--[[
	Informant - An addon for World of Warcraft that shows pertinent information about
	an item in a tooltip when you hover over the item in the game.
	Version: 5.5.4293 (WombatII)
	Revision: $Id: InfData.lua 4187 2009-04-28 04:03:51Z Nechckn $
	URL: http://auctioneeraddon.com/dl/Informant/

	Informant ItemData

	License:
		This program is free software; you can redistribute it and/or
		modify it under the terms of the GNU General Public License
		as published by the Free Software Foundation; either version 2
		of the License, or (at your option) any later version.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program(see GPL.txt); if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is its designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat
		Many thanks to the folks at http://www.wowhead.com for providing this data.
--]]
-- Numeric Codes and the Skills associated with them.
Informant.SetSkills({
	[171]="Alchemy",
	[164]="Blacksmithing",
	[185]="Cooking",
	[333]="Enchanting",
	[202]="Engineering",
	[129]="FirstAid",
	[356]="Fishing",
	[182]="Herbalism",
	[773]="Inscription",
	[755]="Jewelcrafting",
	[165]="Leatherworking",
	[186]="Mining",
	[762]="Riding",
	[197]="Tailoring",
	[-11]="Druid",
	[-8]="Mage",
	[237]="Mage",
	[-2]="Paladin",
	[-5]="Priest",
	[40]="Rogue",
	[-4]="Rogue",
	[-7]="Shaman",
	[354]="Warlock",
	[-9]="Warlock",
})

-- A list of items with skill or other requirements
Informant.SetRequirements({
	[118]="171:1",
	[724]="185:50",
	[733]="185:75",
	[787]="185:1",
	[858]="171:55",
	[929]="171:110",
	[954]="773:15",
	[955]="773:0",
	[1017]="185:100",
	[1082]="185:100",
	[1113]="237:0",
	[1114]="237:0",
	[1180]="773:1",
	[1181]="773:0",
	[1251]="129:1",
	[1477]="773:85",
	[1487]="237:0",
	[1710]="171:155",
	[1711]="773:75",
	[1712]="773:75",
	[2136]="237:0",
	[2288]="237:0",
	[2289]="773:80",
	[2290]="773:75",
	[2300]="165:40",
	[2302]="165:1",
	[2303]="165:15",
	[2304]="165:1",
	[2307]="165:90",
	[2308]="165:85",
	[2309]="165:55",
	[2310]="165:60",
	[2311]="165:60",
	[2312]="165:75",
	[2313]="165:100",
	[2314]="165:120",
	[2315]="165:100",
	[2316]="165:110",
	[2317]="165:100",
	[2318]="165:1",
	[2319]="165:100",
	[2454]="171:1",
	[2455]="171:25",
	[2456]="171:40",
	[2457]="171:50",
	[2458]="171:50",
	[2459]="171:60",
	[2568]="197:10",
	[2569]="197:65",
	[2570]="197:1",
	[2572]="197:40",
	[2575]="197:40",
	[2576]="197:1",
	[2577]="197:40",
	[2578]="197:70",
	[2579]="197:70",
	[2580]="197:60",
	[2581]="129:40",
	[2582]="197:85",
	[2583]="197:95",
	[2584]="197:75",
	[2585]="197:105",
	[2587]="197:100",
	[2679]="185:1",
	[2680]="185:10",
	[2681]="185:1",
	[2682]="185:85",
	[2683]="185:75",
	[2684]="185:50",
	[2685]="185:110",
	[2687]="185:80",
	[2840]="186:1",
	[2841]="186:65",
	[2842]="186:75",
	[2844]="164:15",
	[2845]="164:20",
	[2847]="164:25",
	[2848]="164:110",
	[2849]="164:115",
	[2850]="164:120",
	[2851]="164:35",
	[2852]="164:1",
	[2853]="164:1",
	[2854]="164:90",
	[2857]="164:70",
	[2862]="164:1",
	[2863]="164:65",
	[2864]="164:80",
	[2865]="164:105",
	[2866]="164:105",
	[2868]="164:120",
	[2869]="164:130",
	[2870]="164:145",
	[2871]="164:125",
	[2888]="185:10",
	[2996]="197:1",
	[2997]="197:75",
	[3012]="773:15",
	[3220]="185:60",
	[3239]="164:1",
	[3240]="164:65",
	[3241]="164:125",
	[3382]="171:15",
	[3383]="171:90",
	[3384]="171:110",
	[3385]="171:120",
	[3386]="171:120",
	[3387]="171:250",
	[3388]="171:125",
	[3389]="171:130",
	[3390]="171:140",
	[3391]="171:150",
	[3469]="164:20",
	[3470]="164:25",
	[3471]="164:35",
	[3472]="164:40",
	[3473]="164:45",
	[3474]="164:60",
	[3478]="164:75",
	[3480]="164:110",
	[3481]="164:125",
	[3482]="164:130",
	[3483]="164:135",
	[3484]="164:145",
	[3485]="164:150",
	[3486]="164:125",
	[3487]="164:95",
	[3488]="164:35",
	[3489]="164:70",
	[3490]="164:125",
	[3491]="164:130",
	[3492]="164:145",
	[3530]="129:80",
	[3531]="129:115",
	[3575]="186:125",
	[3576]="186:65",
	[3577]="186:155",
	[3662]="185:80",
	[3663]="185:90",
	[3664]="185:120",
	[3665]="185:130",
	[3666]="185:110",
	[3719]="165:150",
	[3726]="185:110",
	[3727]="185:125",
	[3728]="185:150",
	[3729]="185:175",
	[3772]="237:0",
	[3823]="171:165",
	[3824]="171:165",
	[3825]="171:175",
	[3826]="171:180",
	[3827]="171:160",
	[3828]="171:195",
	[3829]="171:200",
	[3835]="164:165",
	[3836]="164:170",
	[3837]="164:190",
	[3840]="164:160",
	[3841]="164:175",
	[3842]="164:155",
	[3843]="164:170",
	[3844]="164:180",
	[3845]="164:195",
	[3846]="164:185",
	[3847]="164:200",
	[3848]="164:105",
	[3849]="164:160",
	[3850]="164:175",
	[3851]="164:155",
	[3852]="164:170",
	[3853]="164:180",
	[3854]="164:200",
	[3855]="164:185",
	[3856]="164:200",
	[3859]="186:165",
	[3860]="186:175",
	[3928]="171:215",
	[4231]="165:35",
	[4233]="165:100",
	[4234]="165:150",
	[4236]="165:150",
	[4237]="165:25",
	[4238]="197:45",
	[4239]="165:55",
	[4240]="197:80",
	[4241]="197:95",
	[4242]="165:75",
	[4243]="165:85",
	[4244]="165:100",
	[4245]="197:150",
	[4246]="165:80",
	[4247]="165:145",
	[4248]="165:120",
	[4249]="165:125",
	[4250]="165:120",
	[4251]="165:130",
	[4252]="165:140",
	[4253]="165:135",
	[4254]="165:150",
	[4255]="165:155",
	[4256]="165:175",
	[4257]="165:160",
	[4258]="165:170",
	[4259]="165:180",
	[4260]="165:195",
	[4262]="165:185",
	[4264]="165:200",
	[4265]="165:150",
	[4304]="165:200",
	[4305]="197:125",
	[4307]="197:35",
	[4308]="197:60",
	[4309]="197:70",
	[4310]="197:85",
	[4311]="197:100",
	[4312]="197:80",
	[4313]="197:95",
	[4314]="197:110",
	[4315]="197:120",
	[4316]="197:110",
	[4317]="197:125",
	[4318]="197:130",
	[4319]="197:145",
	[4320]="197:125",
	[4321]="197:140",
	[4322]="197:165",
	[4323]="197:170",
	[4324]="197:150",
	[4325]="197:175",
	[4326]="197:185",
	[4327]="197:200",
	[4328]="197:180",
	[4329]="197:200",
	[4330]="197:110",
	[4331]="197:125",
	[4332]="197:135",
	[4333]="197:155",
	[4334]="197:170",
	[4335]="197:185",
	[4336]="197:200",
	[4339]="197:175",
	[4343]="197:30",
	[4344]="197:1",
	[4357]="202:1",
	[4358]="202:1",
	[4359]="202:30",
	[4360]="202:30",
	[4361]="202:50",
	[4362]="202:50",
	[4363]="202:65",
	[4364]="202:75",
	[4365]="202:75",
	[4366]="202:85",
	[4367]="202:100",
	[4368]="202:100",
	[4369]="202:105",
	[4370]="202:105",
	[4371]="202:105",
	[4372]="202:120",
	[4373]="202:120",
	[4374]="202:120",
	[4375]="202:125",
	[4376]="202:125",
	[4377]="202:125",
	[4378]="202:125",
	[4379]="202:130",
	[4380]="202:140",
	[4381]="202:140",
	[4382]="202:145",
	[4383]="202:145",
	[4384]="202:150",
	[4385]="202:150",
	[4386]="202:155",
	[4387]="202:160",
	[4388]="202:160",
	[4389]="202:170",
	[4390]="202:175",
	[4391]="202:175",
	[4392]="202:185",
	[4393]="202:185",
	[4394]="202:190",
	[4395]="202:195",
	[4396]="202:200",
	[4397]="202:200",
	[4398]="202:200",
	[4401]="202:75",
	[4403]="202:165",
	[4404]="202:90",
	[4405]="202:60",
	[4406]="202:110",
	[4407]="202:180",
	[4419]="773:165",
	[4422]="773:155",
	[4424]="773:160",
	[4425]="773:175",
	[4426]="773:170",
	[4455]="165:165",
	[4456]="165:165",
	[4457]="185:175",
	[4592]="185:50",
	[4593]="185:100",
	[4594]="185:175",
	[4596]="171:50",
	[4623]="171:215",
	[4852]="202:185",
	[5081]="165:40",
	[5095]="185:50",
	[5232]="354:0",
	[5349]="237:0",
	[5350]="237:0",
	[5472]="185:10",
	[5473]="185:20",
	[5474]="185:35",
	[5476]="185:50",
	[5477]="185:50",
	[5478]="185:90",
	[5479]="185:100",
	[5480]="185:110",
	[5507]="202:135",
	[5513]="237:0",
	[5514]="237:0",
	[5525]="185:50",
	[5526]="185:90",
	[5527]="185:125",
	[5540]="164:110",
	[5541]="164:140",
	[5542]="197:90",
	[5631]="171:60",
	[5633]="171:175",
	[5634]="171:150",
	[5739]="165:190",
	[5762]="197:70",
	[5763]="197:115",
	[5764]="197:175",
	[5765]="197:185",
	[5766]="197:135",
	[5770]="197:150",
	[5780]="165:90",
	[5781]="165:95",
	[5782]="165:170",
	[5783]="165:190",
	[5957]="165:1",
	[5958]="165:105",
	[5961]="165:115",
	[5962]="165:160",
	[5963]="165:170",
	[5964]="165:175",
	[5965]="165:185",
	[5966]="165:190",
	[5996]="171:90",
	[5997]="171:1",
	[6037]="186:230",
	[6038]="185:175",
	[6040]="164:185",
	[6041]="164:190",
	[6042]="164:150",
	[6043]="164:165",
	[6048]="171:135",
	[6049]="171:165",
	[6050]="171:190",
	[6051]="171:100",
	[6052]="171:190",
	[6149]="171:205",
	[6214]="164:65",
	[6218]="333:1",
	[6219]="202:50",
	[6238]="197:30",
	[6239]="197:55",
	[6240]="197:55",
	[6241]="197:30",
	[6242]="197:70",
	[6263]="197:100",
	[6264]="197:115",
	[6290]="185:1",
	[6316]="185:50",
	[6338]="164:100",
	[6339]="333:100",
	[6350]="164:95",
	[6370]="171:80",
	[6371]="171:130",
	[6372]="171:100",
	[6373]="171:140",
	[6384]="197:120",
	[6385]="197:120",
	[6450]="129:150",
	[6451]="129:180",
	[6452]="129:80",
	[6453]="129:130",
	[6466]="165:90",
	[6467]="165:105",
	[6468]="165:115",
	[6533]="202:150",
	[6657]="185:85",
	[6662]="171:90",
	[6709]="165:90",
	[6712]="202:100",
	[6714]="202:100",
	[6731]="164:100",
	[6786]="197:40",
	[6787]="197:110",
	[6795]="197:160",
	[6796]="197:175",
	[6836]="197:250",
	[6887]="185:225",
	[6888]="185:1",
	[6890]="185:40",
	[7026]="197:15",
	[7046]="197:140",
	[7047]="197:145",
	[7048]="197:145",
	[7049]="197:150",
	[7050]="197:160",
	[7051]="197:170",
	[7052]="197:175",
	[7053]="197:175",
	[7054]="197:190",
	[7055]="197:175",
	[7056]="197:180",
	[7057]="197:180",
	[7058]="197:185",
	[7059]="197:190",
	[7060]="197:190",
	[7061]="197:195",
	[7062]="197:195",
	[7063]="197:205",
	[7064]="197:210",
	[7065]="197:165",
	[7068]="171:300",
	[7071]="164:150",
	[7076]="171:275",
	[7078]="171:275",
	[7080]="171:275",
	[7082]="171:275",
	[7148]="202:165",
	[7166]="164:30",
	[7189]="202:130",
	[7191]="202:275",
	[7276]="165:1",
	[7277]="165:1",
	[7278]="165:30",
	[7279]="165:30",
	[7280]="165:35",
	[7281]="165:70",
	[7282]="165:95",
	[7283]="165:100",
	[7284]="165:120",
	[7285]="165:120",
	[7348]="165:125",
	[7349]="165:135",
	[7352]="165:135",
	[7358]="165:140",
	[7359]="165:145",
	[7371]="165:150",
	[7372]="165:150",
	[7373]="165:165",
	[7374]="165:175",
	[7375]="165:175",
	[7377]="165:180",
	[7378]="165:185",
	[7386]="165:190",
	[7387]="165:195",
	[7390]="165:200",
	[7391]="165:200",
	[7506]="202:125",
	[7676]="185:60",
	[7913]="164:160",
	[7914]="164:160",
	[7915]="164:175",
	[7916]="164:180",
	[7917]="164:185",
	[7918]="164:205",
	[7919]="164:205",
	[7920]="164:210",
	[7921]="164:210",
	[7922]="164:215",
	[7924]="164:215",
	[7926]="164:220",
	[7927]="164:220",
	[7928]="164:225",
	[7929]="164:0",
	[7930]="164:230",
	[7931]="164:230",
	[7932]="164:235",
	[7933]="164:235",
	[7934]="164:245",
	[7935]="164:0",
	[7936]="164:0",
	[7937]="164:0",
	[7938]="164:225",
	[7939]="164:245",
	[7941]="164:210",
	[7942]="164:220",
	[7943]="164:225",
	[7944]="164:240",
	[7945]="164:230",
	[7946]="164:245",
	[7947]="164:255",
	[7954]="164:235",
	[7955]="164:30",
	[7956]="164:125",
	[7957]="164:130",
	[7958]="164:135",
	[7959]="164:250",
	[7960]="164:260",
	[7961]="164:245",
	[7963]="164:200",
	[7964]="164:200",
	[7965]="164:200",
	[7966]="164:200",
	[7967]="164:215",
	[7969]="164:235",
	[8007]="237:0",
	[8008]="237:0",
	[8067]="202:1",
	[8068]="202:75",
	[8069]="202:125",
	[8075]="237:0",
	[8076]="237:0",
	[8077]="237:0",
	[8078]="237:0",
	[8079]="237:0",
	[8170]="165:250",
	[8172]="165:200",
	[8173]="165:200",
	[8174]="165:200",
	[8175]="165:205",
	[8176]="165:205",
	[8185]="165:235",
	[8187]="165:205",
	[8189]="165:210",
	[8191]="165:230",
	[8192]="165:210",
	[8193]="165:230",
	[8197]="165:235",
	[8198]="165:210",
	[8200]="165:215",
	[8201]="165:220",
	[8202]="165:240",
	[8203]="165:220",
	[8204]="165:225",
	[8205]="165:220",
	[8206]="165:245",
	[8207]="165:240",
	[8208]="165:250",
	[8209]="165:235",
	[8210]="165:220",
	[8211]="165:225",
	[8212]="165:250",
	[8213]="165:245",
	[8214]="165:225",
	[8215]="165:250",
	[8216]="165:240",
	[8217]="165:225",
	[8218]="165:225",
	[8345]="165:225",
	[8346]="165:230",
	[8347]="165:225",
	[8348]="165:250",
	[8349]="165:250",
	[8364]="185:175",
	[8367]="165:255",
	[8544]="129:210",
	[8545]="129:240",
	[8827]="171:300",
	[8949]="171:185",
	[8951]="171:195",
	[8956]="171:205",
	[9030]="171:210",
	[9036]="171:210",
	[9060]="164:200",
	[9061]="171:210",
	[9088]="171:240",
	[9144]="171:225",
	[9149]="171:225",
	[9154]="171:230",
	[9155]="171:235",
	[9172]="171:235",
	[9179]="171:235",
	[9187]="171:240",
	[9197]="171:240",
	[9206]="171:245",
	[9210]="171:245",
	[9224]="171:250",
	[9233]="171:250",
	[9264]="171:250",
	[9312]="202:150",
	[9313]="202:150",
	[9318]="202:150",
	[9366]="164:205",
	[9998]="197:205",
	[9999]="197:205",
	[10001]="197:210",
	[10002]="197:210",
	[10003]="197:215",
	[10004]="197:215",
	[10007]="197:215",
	[10008]="197:215",
	[10009]="197:215",
	[10018]="197:225",
	[10019]="197:225",
	[10021]="197:225",
	[10023]="197:225",
	[10024]="197:230",
	[10025]="197:245",
	[10026]="197:230",
	[10027]="197:230",
	[10028]="197:235",
	[10029]="197:235",
	[10030]="197:240",
	[10031]="197:240",
	[10033]="197:240",
	[10034]="197:240",
	[10035]="197:245",
	[10036]="197:250",
	[10040]="197:250",
	[10041]="197:250",
	[10042]="197:225",
	[10044]="197:245",
	[10045]="197:1",
	[10046]="197:20",
	[10047]="197:75",
	[10048]="197:120",
	[10050]="197:225",
	[10051]="197:235",
	[10052]="197:220",
	[10053]="197:235",
	[10054]="197:230",
	[10055]="197:235",
	[10056]="197:215",
	[10306]="773:210",
	[10307]="773:205",
	[10308]="773:215",
	[10309]="773:225",
	[10310]="773:220",
	[10421]="164:1",
	[10423]="164:155",
	[10498]="202:175",
	[10499]="202:175",
	[10500]="202:205",
	[10501]="202:220",
	[10502]="202:225",
	[10503]="202:230",
	[10504]="202:245",
	[10505]="202:175",
	[10506]="202:230",
	[10507]="202:175",
	[10508]="202:205",
	[10510]="202:220",
	[10512]="202:210",
	[10513]="202:245",
	[10514]="202:215",
	[10518]="202:225",
	[10542]="202:205",
	[10543]="202:205",
	[10545]="202:210",
	[10546]="202:210",
	[10548]="202:240",
	[10558]="202:150",
	[10559]="202:195",
	[10560]="202:200",
	[10561]="202:215",
	[10562]="202:235",
	[10576]="202:250",
	[10577]="202:205",
	[10586]="202:235",
	[10587]="202:230",
	[10588]="202:245",
	[10592]="171:200",
	[10644]="202:205",
	[10645]="202:240",
	[10646]="202:205",
	[10713]="202:205",
	[10716]="202:205",
	[10720]="202:210",
	[10721]="202:215",
	[10724]="202:225",
	[10725]="202:230",
	[10726]="202:235",
	[10727]="202:240",
	[10841]="185:175",
	[11128]="164:150",
	[11130]="333:150",
	[11144]="164:200",
	[11145]="333:200",
	[11287]="333:10",
	[11288]="333:70",
	[11289]="333:155",
	[11290]="333:175",
	[11371]="186:230",
	[11590]="202:200",
	[11604]="164:285",
	[11605]="164:280",
	[11606]="164:270",
	[11607]="164:275",
	[11608]="164:265",
	[11811]="333:265",
	[11825]="202:205",
	[11826]="202:205",
	[12190]="171:230",
	[12209]="185:125",
	[12210]="185:175",
	[12212]="185:175",
	[12213]="185:175",
	[12214]="185:175",
	[12215]="185:200",
	[12216]="185:225",
	[12217]="185:200",
	[12218]="185:225",
	[12224]="185:1",
	[12259]="164:180",
	[12260]="164:190",
	[12359]="186:250",
	[12360]="171:275",
	[12404]="164:250",
	[12405]="164:250",
	[12406]="164:250",
	[12408]="164:255",
	[12409]="164:280",
	[12410]="164:280",
	[12414]="164:300",
	[12415]="164:270",
	[12416]="164:260",
	[12417]="164:295",
	[12418]="164:285",
	[12419]="164:290",
	[12420]="164:300",
	[12422]="164:300",
	[12424]="164:265",
	[12425]="164:270",
	[12426]="164:295",
	[12427]="164:295",
	[12428]="164:265",
	[12429]="164:300",
	[12610]="164:300",
	[12611]="164:300",
	[12612]="164:300",
	[12613]="164:300",
	[12614]="164:300",
	[12618]="164:300",
	[12619]="164:300",
	[12620]="164:300",
	[12624]="164:270",
	[12625]="164:290",
	[12628]="164:285",
	[12631]="164:290",
	[12632]="164:295",
	[12633]="164:300",
	[12636]="164:300",
	[12639]="164:300",
	[12640]="164:300",
	[12641]="164:300",
	[12643]="164:250",
	[12644]="164:250",
	[12645]="164:275",
	[12655]="333:250",
	[12773]="164:275",
	[12774]="164:275",
	[12775]="164:280",
	[12776]="164:280",
	[12777]="164:280",
	[12781]="164:285",
	[12782]="164:290",
	[12783]="164:300",
	[12784]="164:300",
	[12790]="164:300",
	[12792]="164:290",
	[12794]="164:300",
	[12796]="164:300",
	[12797]="164:300",
	[12798]="164:300",
	[12803]="171:275",
	[12808]="171:275",
	[12810]="333:250",
	[13423]="171:250",
	[13442]="171:255",
	[13443]="171:260",
	[13444]="171:295",
	[13445]="171:265",
	[13446]="171:275",
	[13447]="171:270",
	[13452]="171:280",
	[13453]="171:275",
	[13454]="171:285",
	[13455]="171:280",
	[13456]="171:290",
	[13457]="171:290",
	[13458]="171:290",
	[13459]="171:290",
	[13461]="171:290",
	[13462]="171:285",
	[13503]="171:350",
	[13506]="171:300",
	[13510]="171:300",
	[13511]="171:300",
	[13512]="171:300",
	[13513]="171:300",
	[13851]="185:175",
	[13856]="197:255",
	[13857]="197:260",
	[13858]="197:260",
	[13860]="197:265",
	[13863]="197:275",
	[13864]="197:280",
	[13865]="197:285",
	[13866]="197:295",
	[13867]="197:300",
	[13868]="197:255",
	[13869]="197:255",
	[13870]="197:265",
	[13871]="197:280",
	[13927]="185:225",
	[13928]="185:240",
	[13929]="185:240",
	[13930]="185:225",
	[13931]="185:250",
	[13932]="185:250",
	[13933]="185:275",
	[13934]="185:275",
	[13935]="185:275",
	[14042]="197:260",
	[14043]="197:270",
	[14044]="197:275",
	[14045]="197:280",
	[14046]="197:260",
	[14048]="197:250",
	[14100]="197:270",
	[14101]="197:270",
	[14103]="197:275",
	[14104]="197:290",
	[14106]="197:300",
	[14107]="197:275",
	[14108]="197:285",
	[14111]="197:290",
	[14112]="197:300",
	[14128]="197:300",
	[14130]="197:300",
	[14132]="197:275",
	[14134]="197:275",
	[14136]="197:285",
	[14137]="197:290",
	[14138]="197:300",
	[14139]="197:300",
	[14140]="197:300",
	[14141]="197:275",
	[14142]="197:270",
	[14143]="197:265",
	[14144]="197:290",
	[14146]="197:300",
	[14152]="197:300",
	[14153]="197:300",
	[14154]="197:300",
	[14155]="197:300",
	[14156]="197:300",
	[14342]="197:250",
	[14529]="129:260",
	[14530]="129:290",
	[15045]="165:260",
	[15046]="165:270",
	[15047]="165:300",
	[15048]="165:285",
	[15049]="165:295",
	[15050]="165:290",
	[15051]="165:300",
	[15052]="165:300",
	[15053]="165:285",
	[15054]="165:270",
	[15055]="165:300",
	[15056]="165:285",
	[15057]="165:275",
	[15058]="165:295",
	[15059]="165:300",
	[15060]="165:285",
	[15061]="165:270",
	[15062]="165:300",
	[15063]="165:290",
	[15064]="165:275",
	[15065]="165:285",
	[15066]="165:290",
	[15067]="165:270",
	[15068]="165:300",
	[15069]="165:285",
	[15070]="165:295",
	[15071]="165:275",
	[15072]="165:280",
	[15073]="165:275",
	[15074]="165:265",
	[15075]="165:290",
	[15076]="165:265",
	[15077]="165:255",
	[15078]="165:275",
	[15079]="165:285",
	[15080]="165:295",
	[15081]="165:300",
	[15082]="165:280",
	[15083]="165:260",
	[15084]="165:265",
	[15085]="165:300",
	[15086]="165:280",
	[15087]="165:290",
	[15088]="165:300",
	[15090]="165:300",
	[15091]="165:270",
	[15092]="165:275",
	[15093]="165:280",
	[15094]="165:290",
	[15095]="165:300",
	[15096]="165:300",
	[15138]="165:300",
	[15407]="165:250",
	[15564]="165:250",
	[15802]="197:290",
	[15846]="202:250",
	[15869]="164:100",
	[15870]="164:150",
	[15871]="164:200",
	[15872]="164:275",
	[15992]="202:250",
	[15993]="202:260",
	[15994]="202:260",
	[15995]="202:260",
	[15996]="202:265",
	[15997]="202:285",
	[15999]="202:270",
	[16000]="202:275",
	[16004]="202:275",
	[16005]="202:285",
	[16006]="202:285",
	[16007]="202:300",
	[16008]="202:290",
	[16009]="202:290",
	[16022]="202:300",
	[16023]="202:275",
	[16040]="202:300",
	[16206]="164:275",
	[16207]="333:290",
	[16766]="185:225",
	[16892]="354:0",
	[16893]="354:0",
	[16895]="354:0",
	[16896]="354:0",
	[16979]="197:300",
	[16980]="197:300",
	[16982]="165:295",
	[16983]="165:300",
	[16984]="165:300",
	[16988]="164:300",
	[16989]="164:295",
	[17013]="164:300",
	[17014]="164:295",
	[17015]="164:300",
	[17016]="164:300",
	[17193]="164:300",
	[17197]="185:1",
	[17198]="185:35",
	[17222]="185:200",
	[17704]="164:190",
	[17708]="171:190",
	[17716]="202:190",
	[17721]="165:190",
	[17723]="197:190",
	[17771]="186:300",
	[18045]="185:225",
	[18168]="202:300",
	[18232]="202:300",
	[18238]="165:200",
	[18251]="165:300",
	[18253]="171:300",
	[18254]="185:275",
	[18258]="197:275",
	[18262]="164:300",
	[18263]="197:300",
	[18282]="202:300",
	[18283]="202:300",
	[18294]="171:215",
	[18405]="197:300",
	[18407]="197:300",
	[18408]="197:300",
	[18409]="197:300",
	[18413]="197:300",
	[18486]="197:300",
	[18504]="165:300",
	[18506]="165:300",
	[18508]="165:300",
	[18509]="165:300",
	[18510]="165:300",
	[18511]="165:300",
	[18587]="202:265",
	[18588]="202:200",
	[18594]="202:275",
	[18631]="202:260",
	[18634]="202:260",
	[18637]="202:275",
	[18638]="202:290",
	[18639]="202:300",
	[18641]="202:250",
	[18645]="202:265",
	[18660]="202:260",
	[18662]="165:150",
	[18948]="165:155",
	[18984]="202:260",
	[18986]="202:260",
	[19026]="202:250",
	[19043]="164:290",
	[19044]="165:290",
	[19047]="197:290",
	[19048]="164:300",
	[19049]="165:300",
	[19050]="197:300",
	[19051]="164:290",
	[19052]="165:290",
	[19056]="197:290",
	[19057]="164:300",
	[19058]="165:300",
	[19059]="197:300",
	[19148]="164:300",
	[19149]="165:300",
	[19156]="197:300",
	[19157]="165:300",
	[19162]="165:300",
	[19163]="165:300",
	[19164]="164:300",
	[19165]="197:300",
	[19166]="164:300",
	[19167]="164:300",
	[19168]="164:300",
	[19169]="164:300",
	[19170]="164:300",
	[19440]="129:300",
	[19682]="197:300",
	[19683]="197:300",
	[19684]="197:300",
	[19685]="165:300",
	[19686]="165:300",
	[19687]="165:300",
	[19688]="165:300",
	[19689]="165:300",
	[19690]="164:300",
	[19691]="164:300",
	[19692]="164:300",
	[19693]="164:300",
	[19694]="164:300",
	[19695]="164:300",
	[19931]="171:300",
	[19998]="202:300",
	[19999]="202:300",
	[20002]="171:275",
	[20004]="171:290",
	[20007]="171:275",
	[20008]="171:285",
	[20039]="164:300",
	[20074]="185:150",
	[20295]="165:300",
	[20296]="165:280",
	[20380]="165:300",
	[20452]="185:285",
	[20475]="202:335",
	[20476]="165:300",
	[20477]="165:300",
	[20478]="165:300",
	[20479]="165:300",
	[20480]="165:300",
	[20481]="165:300",
	[20537]="197:300",
	[20538]="197:300",
	[20539]="197:300",
	[20549]="164:300",
	[20550]="164:300",
	[20551]="164:300",
	[20575]="165:100",
	[20744]="333:45",
	[20745]="333:150",
	[20746]="333:200",
	[20747]="333:250",
	[20748]="333:300",
	[20749]="333:300",
	[20750]="333:275",
	[20816]="755:1",
	[20817]="755:50",
	[20818]="755:50",
	[20820]="755:60",
	[20821]="755:30",
	[20823]="755:70",
	[20826]="755:90",
	[20827]="755:80",
	[20828]="755:100",
	[20830]="755:110",
	[20831]="755:150",
	[20832]="755:120",
	[20833]="755:125",
	[20906]="755:1",
	[20907]="755:50",
	[20909]="755:110",
	[20950]="755:120",
	[20954]="755:125",
	[20955]="755:135",
	[20958]="755:150",
	[20959]="755:170",
	[20960]="755:170",
	[20961]="755:180",
	[20963]="755:150",
	[20964]="755:210",
	[20966]="755:160",
	[20967]="755:190",
	[20969]="755:225",
	[21023]="185:300",
	[21072]="185:80",
	[21154]="197:250",
	[21217]="185:175",
	[21277]="202:250",
	[21278]="165:300",
	[21340]="197:260",
	[21341]="197:280",
	[21342]="197:300",
	[21542]="197:250",
	[21546]="171:250",
	[21557]="202:125",
	[21558]="202:125",
	[21559]="202:125",
	[21569]="202:225",
	[21570]="202:275",
	[21571]="202:225",
	[21574]="202:225",
	[21576]="202:225",
	[21589]="202:175",
	[21590]="202:175",
	[21592]="202:175",
	[21714]="202:275",
	[21716]="202:275",
	[21718]="202:275",
	[21748]="755:200",
	[21752]="755:225",
	[21753]="755:250",
	[21754]="755:245",
	[21755]="755:220",
	[21756]="755:200",
	[21758]="755:215",
	[21760]="755:225",
	[21763]="755:235",
	[21764]="755:235",
	[21765]="755:240",
	[21766]="755:250",
	[21767]="755:260",
	[21768]="755:275",
	[21769]="755:260",
	[21774]="755:275",
	[21775]="755:280",
	[21777]="755:285",
	[21778]="755:285",
	[21779]="755:310",
	[21780]="755:0",
	[21784]="755:300",
	[21789]="755:300",
	[21790]="755:280",
	[21791]="755:290",
	[21792]="755:305",
	[21793]="755:0",
	[21840]="197:300",
	[21841]="197:315",
	[21842]="197:325",
	[21843]="197:340",
	[21844]="197:345",
	[21845]="197:350",
	[21846]="197:355",
	[21847]="197:365",
	[21848]="197:375",
	[21849]="197:310",
	[21850]="197:310",
	[21851]="197:320",
	[21852]="197:325",
	[21853]="197:335",
	[21854]="197:340",
	[21855]="197:345",
	[21858]="197:375",
	[21859]="197:340",
	[21860]="197:350",
	[21861]="197:360",
	[21862]="197:360",
	[21863]="197:355",
	[21864]="197:365",
	[21865]="197:375",
	[21866]="197:350",
	[21867]="197:360",
	[21868]="197:370",
	[21869]="197:355",
	[21870]="197:365",
	[21871]="197:375",
	[21872]="197:375",
	[21873]="197:355",
	[21874]="197:365",
	[21875]="197:375",
	[21876]="197:375",
	[21884]="171:350",
	[21885]="171:350",
	[21886]="171:300",
	[21887]="165:300",
	[21931]="755:1",
	[21932]="755:5",
	[21933]="755:50",
	[21934]="755:30",
	[21990]="129:330",
	[21991]="129:360",
	[22018]="237:0",
	[22019]="237:0",
	[22044]="237:0",
	[22116]="354:0",
	[22191]="164:300",
	[22194]="164:300",
	[22195]="164:300",
	[22196]="164:300",
	[22197]="164:300",
	[22198]="164:300",
	[22246]="197:225",
	[22248]="197:275",
	[22249]="197:300",
	[22251]="197:275",
	[22252]="197:300",
	[22383]="164:300",
	[22384]="164:300",
	[22385]="164:300",
	[22448]="333:300",
	[22449]="333:335",
	[22451]="171:350",
	[22452]="171:350",
	[22456]="171:300",
	[22457]="171:300",
	[22459]="333:350",
	[22460]="333:325",
	[22461]="333:300",
	[22462]="333:350",
	[22463]="333:375",
	[22521]="333:310",
	[22522]="333:340",
	[22573]="186:300",
	[22574]="186:300",
	[22645]="185:60",
	[22652]="197:300",
	[22654]="197:300",
	[22655]="197:300",
	[22658]="197:300",
	[22660]="197:300",
	[22661]="165:300",
	[22662]="165:300",
	[22663]="165:300",
	[22664]="165:300",
	[22665]="165:300",
	[22666]="165:300",
	[22669]="164:300",
	[22670]="164:300",
	[22671]="164:300",
	[22756]="197:300",
	[22757]="197:300",
	[22758]="197:300",
	[22759]="165:300",
	[22760]="165:300",
	[22761]="165:300",
	[22762]="164:300",
	[22763]="164:300",
	[22764]="164:300",
	[22823]="171:305",
	[22824]="171:305",
	[22825]="171:310",
	[22826]="171:315",
	[22827]="171:320",
	[22828]="171:320",
	[22829]="171:325",
	[22830]="171:325",
	[22831]="171:330",
	[22832]="171:340",
	[22833]="171:345",
	[22834]="171:345",
	[22835]="171:350",
	[22836]="171:350",
	[22837]="171:350",
	[22838]="171:350",
	[22839]="171:350",
	[22840]="171:355",
	[22841]="171:360",
	[22842]="171:360",
	[22844]="171:360",
	[22845]="171:360",
	[22846]="171:360",
	[22847]="171:360",
	[22848]="171:365",
	[22849]="171:365",
	[22850]="171:300",
	[22851]="171:300",
	[22853]="171:300",
	[22854]="171:300",
	[22861]="171:300",
	[22866]="171:300",
	[22871]="171:335",
	[22895]="237:0",
	[23094]="755:300",
	[23095]="755:305",
	[23096]="755:315",
	[23097]="755:325",
	[23098]="755:300",
	[23099]="755:305",
	[23100]="755:315",
	[23101]="755:325",
	[23103]="755:300",
	[23104]="755:305",
	[23105]="755:315",
	[23106]="755:325",
	[23108]="755:300",
	[23109]="755:305",
	[23110]="755:315",
	[23111]="755:325",
	[23113]="755:300",
	[23114]="755:305",
	[23115]="755:315",
	[23116]="755:325",
	[23118]="755:300",
	[23119]="755:305",
	[23120]="755:315",
	[23121]="755:325",
	[23445]="186:300",
	[23446]="186:325",
	[23447]="186:350",
	[23448]="186:350",
	[23449]="186:375",
	[23482]="164:300",
	[23484]="164:305",
	[23487]="164:315",
	[23488]="164:315",
	[23489]="164:325",
	[23490]="164:320",
	[23491]="164:310",
	[23493]="164:300",
	[23494]="164:315",
	[23497]="164:310",
	[23498]="164:315",
	[23499]="164:320",
	[23502]="164:325",
	[23503]="164:330",
	[23504]="164:330",
	[23505]="164:335",
	[23506]="164:335",
	[23507]="164:340",
	[23508]="164:335",
	[23509]="164:360",
	[23510]="164:355",
	[23511]="164:355",
	[23512]="164:365",
	[23513]="164:365",
	[23514]="164:360",
	[23515]="164:350",
	[23516]="164:355",
	[23517]="164:360",
	[23518]="164:360",
	[23519]="164:365",
	[23520]="164:365",
	[23521]="164:365",
	[23522]="164:370",
	[23523]="164:360",
	[23524]="164:360",
	[23525]="164:365",
	[23526]="164:370",
	[23527]="164:370",
	[23528]="164:300",
	[23529]="164:350",
	[23530]="164:360",
	[23531]="164:365",
	[23532]="164:365",
	[23533]="164:365",
	[23534]="164:365",
	[23535]="164:365",
	[23536]="164:365",
	[23537]="164:365",
	[23538]="164:365",
	[23539]="164:365",
	[23540]="164:365",
	[23541]="164:365",
	[23542]="164:365",
	[23543]="164:365",
	[23544]="164:365",
	[23546]="164:365",
	[23554]="164:365",
	[23555]="164:365",
	[23556]="164:365",
	[23559]="164:325",
	[23563]="164:350",
	[23564]="164:375",
	[23565]="164:375",
	[23571]="171:350",
	[23573]="186:375",
	[23575]="164:340",
	[23576]="164:375",
	[23736]="202:300",
	[23737]="202:325",
	[23742]="202:320",
	[23746]="202:350",
	[23747]="202:360",
	[23748]="202:375",
	[23758]="202:340",
	[23761]="202:340",
	[23762]="202:350",
	[23763]="202:360",
	[23764]="202:335",
	[23765]="202:360",
	[23766]="202:375",
	[23767]="202:325",
	[23768]="202:335",
	[23769]="202:0",
	[23771]="202:335",
	[23772]="202:310",
	[23774]="202:325",
	[23775]="202:405",
	[23781]="202:300",
	[23782]="202:300",
	[23783]="202:300",
	[23784]="202:325",
	[23785]="202:340",
	[23786]="202:340",
	[23787]="202:340",
	[23793]="165:325",
	[23819]="202:350",
	[23820]="202:0",
	[23821]="202:305",
	[23824]="202:355",
	[23825]="202:350",
	[23826]="202:325",
	[23827]="202:340",
	[23828]="202:375",
	[23829]="202:375",
	[23831]="202:0",
	[23832]="202:0",
	[23835]="202:340",
	[23836]="202:350",
	[23838]="202:375",
	[23839]="202:375",
	[23841]="202:325",
	[24027]="755:350",
	[24028]="755:350",
	[24029]="755:350",
	[24030]="755:350",
	[24031]="755:350",
	[24032]="755:350",
	[24033]="755:350",
	[24035]="755:350",
	[24036]="755:350",
	[24037]="755:350",
	[24039]="755:350",
	[24047]="755:350",
	[24048]="755:350",
	[24050]="755:350",
	[24051]="755:350",
	[24052]="755:350",
	[24053]="755:350",
	[24054]="755:350",
	[24055]="755:350",
	[24056]="755:350",
	[24057]="755:350",
	[24058]="755:350",
	[24059]="755:350",
	[24060]="755:350",
	[24061]="755:350",
	[24062]="755:350",
	[24065]="755:350",
	[24066]="755:350",
	[24067]="755:350",
	[24074]="755:310",
	[24075]="755:310",
	[24076]="755:320",
	[24077]="755:335",
	[24078]="755:335",
	[24079]="755:350",
	[24080]="755:355",
	[24082]="755:355",
	[24085]="755:360",
	[24086]="755:365",
	[24087]="755:345",
	[24088]="755:355",
	[24089]="755:365",
	[24092]="755:360",
	[24093]="755:360",
	[24095]="755:360",
	[24097]="755:360",
	[24098]="755:360",
	[24105]="185:1",
	[24106]="755:355",
	[24110]="755:355",
	[24114]="755:360",
	[24116]="755:360",
	[24117]="755:365",
	[24121]="755:365",
	[24122]="755:370",
	[24123]="755:370",
	[24124]="755:370",
	[24125]="755:370",
	[24126]="755:370",
	[24127]="755:370",
	[24128]="755:370",
	[24249]="197:350",
	[24250]="197:350",
	[24251]="197:350",
	[24252]="197:350",
	[24253]="197:350",
	[24254]="197:350",
	[24255]="197:365",
	[24256]="197:365",
	[24257]="197:365",
	[24258]="197:365",
	[24259]="197:365",
	[24260]="197:365",
	[24261]="197:375",
	[24262]="197:375",
	[24263]="197:375",
	[24264]="197:375",
	[24266]="197:375",
	[24267]="197:375",
	[24268]="197:300",
	[24270]="197:340",
	[24271]="197:350",
	[24272]="197:350",
	[24273]="197:335",
	[24274]="197:375",
	[24275]="197:335",
	[24276]="197:375",
	[25438]="755:20",
	[25439]="755:20",
	[25498]="755:1",
	[25521]="164:350",
	[25650]="165:300",
	[25651]="165:325",
	[25652]="165:325",
	[25653]="165:350",
	[25654]="165:300",
	[25655]="165:310",
	[25656]="165:320",
	[25657]="165:335",
	[25659]="165:335",
	[25660]="165:325",
	[25661]="165:310",
	[25662]="165:300",
	[25668]="165:320",
	[25669]="165:300",
	[25670]="165:315",
	[25671]="165:330",
	[25673]="165:300",
	[25674]="165:310",
	[25675]="165:320",
	[25676]="165:330",
	[25679]="165:300",
	[25680]="165:350",
	[25681]="165:350",
	[25682]="165:350",
	[25683]="165:350",
	[25685]="165:340",
	[25686]="165:350",
	[25687]="165:350",
	[25689]="165:360",
	[25690]="165:355",
	[25691]="165:355",
	[25692]="165:340",
	[25693]="165:350",
	[25694]="165:340",
	[25695]="165:350",
	[25696]="165:360",
	[25697]="165:360",
	[25843]="164:300",
	[25844]="164:350",
	[25845]="164:360",
	[25880]="755:50",
	[25881]="755:110",
	[25882]="755:175",
	[25883]="755:225",
	[25886]="202:335",
	[25890]="755:365",
	[25893]="755:365",
	[25894]="755:365",
	[25895]="755:365",
	[25896]="755:365",
	[25897]="755:365",
	[25898]="755:365",
	[25899]="755:365",
	[25901]="755:365",
	[27498]="773:270",
	[27499]="773:260",
	[27501]="773:255",
	[27502]="773:250",
	[27503]="773:265",
	[27635]="185:1",
	[27636]="185:50",
	[27651]="185:300",
	[27655]="185:300",
	[27656]="185:310",
	[27657]="185:315",
	[27658]="185:325",
	[27659]="185:325",
	[27660]="185:325",
	[27661]="185:300",
	[27662]="185:300",
	[27663]="185:310",
	[27664]="185:320",
	[27665]="185:320",
	[27666]="185:325",
	[27667]="185:350",
	[28100]="171:300",
	[28101]="171:310",
	[28102]="171:300",
	[28103]="171:300",
	[28104]="171:315",
	[28290]="755:325",
	[28420]="164:300",
	[28421]="164:350",
	[28425]="164:350",
	[28426]="164:375",
	[28427]="164:375",
	[28428]="164:350",
	[28429]="164:375",
	[28430]="164:375",
	[28431]="164:350",
	[28432]="164:375",
	[28433]="164:375",
	[28434]="164:350",
	[28435]="164:375",
	[28436]="164:375",
	[28437]="164:350",
	[28438]="164:375",
	[28439]="164:375",
	[28440]="164:350",
	[28441]="164:375",
	[28442]="164:375",
	[28483]="164:350",
	[28484]="164:375",
	[28485]="164:375",
	[28595]="755:305",
	[29157]="755:180",
	[29158]="755:200",
	[29159]="755:280",
	[29160]="755:290",
	[29201]="164:100",
	[29202]="164:200",
	[29203]="164:300",
	[29204]="164:350",
	[29483]="165:340",
	[29485]="165:340",
	[29486]="165:340",
	[29487]="165:340",
	[29488]="165:340",
	[29489]="165:350",
	[29490]="165:350",
	[29491]="165:350",
	[29492]="165:350",
	[29493]="165:350",
	[29494]="165:350",
	[29495]="165:350",
	[29496]="165:350",
	[29497]="165:350",
	[29498]="165:350",
	[29499]="165:350",
	[29500]="165:350",
	[29502]="165:365",
	[29503]="165:365",
	[29504]="165:365",
	[29505]="165:365",
	[29506]="165:365",
	[29507]="165:365",
	[29508]="165:365",
	[29509]="165:365",
	[29510]="165:365",
	[29511]="165:365",
	[29512]="165:365",
	[29514]="165:365",
	[29515]="165:375",
	[29516]="165:375",
	[29517]="165:375",
	[29519]="165:375",
	[29520]="165:375",
	[29521]="165:375",
	[29522]="165:375",
	[29523]="165:375",
	[29524]="165:375",
	[29525]="165:375",
	[29526]="165:375",
	[29527]="165:375",
	[29528]="165:340",
	[29529]="165:365",
	[29530]="165:345",
	[29531]="165:350",
	[29532]="165:370",
	[29533]="165:335",
	[29534]="165:335",
	[29535]="165:365",
	[29536]="165:365",
	[29540]="165:325",
	[29964]="165:260",
	[29970]="165:260",
	[29971]="165:260",
	[29973]="165:330",
	[29974]="165:330",
	[29975]="165:330",
	[30031]="164:375",
	[30032]="164:375",
	[30033]="164:375",
	[30034]="164:375",
	[30035]="197:375",
	[30036]="197:375",
	[30037]="197:375",
	[30038]="197:375",
	[30039]="165:375",
	[30040]="165:375",
	[30041]="165:375",
	[30042]="165:375",
	[30043]="165:375",
	[30044]="165:375",
	[30045]="165:375",
	[30046]="165:375",
	[30069]="164:260",
	[30070]="164:260",
	[30071]="164:260",
	[30072]="164:260",
	[30073]="164:260",
	[30074]="164:330",
	[30076]="164:330",
	[30077]="164:330",
	[30086]="164:330",
	[30087]="164:330",
	[30088]="164:330",
	[30089]="164:330",
	[30093]="164:330",
	[30155]="185:300",
	[30419]="755:75",
	[30420]="755:105",
	[30421]="755:230",
	[30422]="755:265",
	[30459]="197:0",
	[30460]="197:0",
	[30461]="197:0",
	[30542]="202:350",
	[30544]="202:350",
	[30703]="237:0",
	[30804]="755:65",
	[30816]="185:1",
	[30825]="755:360",
	[30831]="197:350",
	[30837]="197:350",
	[30838]="197:360",
	[30839]="197:370",
	[31079]="755:325",
	[31080]="171:325",
	[31154]="755:80",
	[31364]="164:375",
	[31367]="164:375",
	[31368]="164:375",
	[31369]="164:375",
	[31370]="164:375",
	[31371]="164:375",
	[31398]="755:375",
	[31399]="755:375",
	[31672]="185:335",
	[31673]="185:335",
	[31676]="171:345",
	[31677]="171:360",
	[31679]="171:335",
	[31860]="755:325",
	[31861]="755:350",
	[31862]="755:325",
	[31863]="755:350",
	[31864]="755:325",
	[31865]="755:350",
	[31866]="755:325",
	[31867]="755:350",
	[31868]="755:350",
	[31869]="755:325",
	[32062]="171:310",
	[32063]="171:320",
	[32067]="171:320",
	[32068]="171:330",
	[32193]="755:375",
	[32194]="755:375",
	[32195]="755:375",
	[32196]="755:375",
	[32197]="755:375",
	[32198]="755:375",
	[32199]="755:375",
	[32200]="755:375",
	[32201]="755:375",
	[32202]="755:375",
	[32203]="755:375",
	[32204]="755:375",
	[32205]="755:375",
	[32206]="755:375",
	[32207]="755:375",
	[32208]="755:375",
	[32209]="755:375",
	[32210]="755:375",
	[32211]="755:375",
	[32212]="755:375",
	[32213]="755:375",
	[32214]="755:375",
	[32215]="755:375",
	[32216]="755:375",
	[32217]="755:375",
	[32218]="755:375",
	[32219]="755:375",
	[32220]="755:375",
	[32221]="755:375",
	[32222]="755:375",
	[32223]="755:375",
	[32224]="755:375",
	[32225]="755:375",
	[32226]="755:375",
	[32389]="197:375",
	[32390]="197:375",
	[32391]="197:375",
	[32392]="197:375",
	[32393]="165:375",
	[32394]="165:375",
	[32395]="165:375",
	[32396]="165:375",
	[32397]="165:375",
	[32398]="165:375",
	[32399]="165:375",
	[32400]="165:375",
	[32401]="164:375",
	[32402]="164:375",
	[32403]="164:375",
	[32404]="164:375",
	[32409]="755:365",
	[32410]="755:365",
	[32413]="202:335",
	[32420]="197:375",
	[32423]="202:335",
	[32461]="202:350",
	[32472]="202:350",
	[32473]="202:350",
	[32474]="202:350",
	[32475]="202:350",
	[32476]="202:350",
	[32478]="202:350",
	[32479]="202:350",
	[32480]="202:350",
	[32494]="202:350",
	[32495]="202:350",
	[32508]="755:340",
	[32568]="164:375",
	[32570]="164:375",
	[32571]="164:375",
	[32573]="164:375",
	[32574]="165:375",
	[32575]="165:375",
	[32577]="165:375",
	[32579]="165:375",
	[32580]="165:375",
	[32581]="165:375",
	[32582]="165:375",
	[32583]="165:375",
	[32584]="197:375",
	[32585]="197:375",
	[32586]="197:375",
	[32587]="197:375",
	[32756]="202:375",
	[32772]="755:325",
	[32774]="755:330",
	[32776]="755:365",
	[32833]="755:325",
	[32836]="755:350",
	[32839]="171:300",
	[32849]="171:300",
	[32850]="171:300",
	[32851]="171:300",
	[32852]="171:300",
	[32854]="164:365",
	[33004]="185:0",
	[33048]="185:320",
	[33052]="185:350",
	[33053]="185:350",
	[33092]="202:330",
	[33093]="202:345",
	[33122]="165:360",
	[33131]="755:360",
	[33133]="755:360",
	[33134]="755:360",
	[33135]="755:360",
	[33140]="755:360",
	[33143]="755:360",
	[33144]="755:360",
	[33173]="164:365",
	[33185]="164:335",
	[33204]="165:365",
	[33208]="171:375",
	[33312]="237:0",
	[33447]="171:405",
	[33448]="171:410",
	[33457]="773:310",
	[33458]="773:310",
	[33460]="773:295",
	[33461]="773:290",
	[33462]="773:305",
	[33568]="165:350",
	[33782]="755:350",
	[33791]="164:35",
	[33825]="185:325",
	[33866]="185:300",
	[33867]="185:300",
	[33872]="185:325",
	[33874]="185:300",
	[33924]="185:1",
	[34060]="202:350",
	[34061]="202:375",
	[34085]="197:250",
	[34086]="165:285",
	[34087]="197:250",
	[34099]="165:315",
	[34100]="165:315",
	[34105]="165:350",
	[34106]="165:350",
	[34113]="202:360",
	[34207]="165:350",
	[34220]="755:365",
	[34330]="165:350",
	[34353]="202:375",
	[34354]="202:375",
	[34355]="202:375",
	[34356]="202:375",
	[34357]="202:375",
	[34358]="755:365",
	[34359]="755:365",
	[34360]="755:365",
	[34361]="755:365",
	[34362]="755:365",
	[34363]="755:365",
	[34364]="197:365",
	[34365]="197:365",
	[34366]="197:365",
	[34367]="197:365",
	[34369]="165:365",
	[34370]="165:365",
	[34371]="165:365",
	[34372]="165:365",
	[34373]="165:365",
	[34374]="165:365",
	[34375]="165:365",
	[34376]="165:365",
	[34377]="164:365",
	[34378]="164:365",
	[34379]="164:365",
	[34380]="164:365",
	[34411]="185:325",
	[34440]="171:325",
	[34482]="165:300",
	[34490]="165:360",
	[34504]="202:335",
	[34721]="129:350",
	[34722]="129:400",
	[34747]="185:0",
	[34748]="185:350",
	[34749]="185:350",
	[34750]="185:350",
	[34751]="185:350",
	[34752]="185:350",
	[34753]="185:375",
	[34754]="185:400",
	[34755]="185:400",
	[34756]="185:400",
	[34757]="185:400",
	[34758]="185:400",
	[34759]="185:350",
	[34760]="185:350",
	[34761]="185:350",
	[34762]="185:350",
	[34763]="185:350",
	[34764]="185:350",
	[34765]="185:350",
	[34766]="185:400",
	[34767]="185:400",
	[34768]="185:400",
	[34769]="185:400",
	[34832]="185:100",
	[34847]="202:375",
	[35128]="186:375",
	[35181]="202:375",
	[35182]="202:375",
	[35183]="202:375",
	[35184]="202:375",
	[35185]="202:375",
	[35315]="755:350",
	[35316]="755:350",
	[35318]="755:350",
	[35501]="755:370",
	[35503]="755:370",
	[35563]="185:250",
	[35565]="185:250",
	[35581]="202:355",
	[35622]="171:300",
	[35623]="171:300",
	[35624]="171:300",
	[35625]="171:300",
	[35627]="171:300",
	[35693]="755:375",
	[35694]="755:375",
	[35700]="755:375",
	[35702]="755:375",
	[35703]="755:375",
	[35707]="755:350",
	[35748]="171:375",
	[35749]="171:375",
	[35750]="171:375",
	[35751]="171:375",
	[35758]="755:375",
	[35759]="755:375",
	[35760]="755:375",
	[35761]="755:375",
	[35945]="755:350",
	[36766]="755:370",
	[36767]="755:370",
	[36860]="171:300",
	[36895]="354:0",
	[36913]="186:400",
	[36916]="186:350",
	[37091]="773:360",
	[37092]="773:410",
	[37093]="773:350",
	[37094]="773:400",
	[37097]="773:355",
	[37098]="773:405",
	[37101]="773:1",
	[37118]="773:35",
	[37168]="773:110",
	[37503]="755:375",
	[37567]="202:410",
	[37602]="773:200",
	[37663]="186:450",
	[38225]="197:375",
	[38277]="197:250",
	[38278]="197:245",
	[38322]="773:400",
	[38347]="165:415",
	[38371]="165:405",
	[38372]="165:400",
	[38373]="165:425",
	[38374]="165:425",
	[38375]="165:350",
	[38376]="165:395",
	[38399]="165:415",
	[38400]="165:370",
	[38401]="165:375",
	[38402]="165:380",
	[38403]="165:375",
	[38404]="165:370",
	[38405]="165:380",
	[38406]="165:380",
	[38407]="165:375",
	[38408]="165:375",
	[38409]="165:370",
	[38410]="165:370",
	[38411]="165:380",
	[38412]="165:370",
	[38413]="165:380",
	[38414]="165:375",
	[38415]="165:380",
	[38416]="165:370",
	[38417]="165:380",
	[38418]="165:375",
	[38419]="165:380",
	[38420]="165:375",
	[38421]="165:370",
	[38422]="165:370",
	[38424]="165:375",
	[38425]="165:390",
	[38433]="165:385",
	[38434]="165:385",
	[38435]="165:385",
	[38436]="165:385",
	[38437]="165:385",
	[38438]="165:385",
	[38439]="165:385",
	[38440]="165:385",
	[38441]="165:380",
	[38590]="165:400",
	[38591]="165:395",
	[38592]="165:395",
	[38682]="773:35",
	[39083]="164:360",
	[39084]="164:370",
	[39085]="164:375",
	[39086]="164:370",
	[39087]="164:350",
	[39088]="164:350",
	[39349]="773:75",
	[39350]="773:235",
	[39469]="773:35",
	[39520]="185:375",
	[39666]="171:395",
	[39671]="171:350",
	[39681]="202:350",
	[39682]="202:375",
	[39683]="202:390",
	[39688]="202:400",
	[39690]="202:350",
	[39774]="773:75",
	[39900]="755:350",
	[39905]="755:350",
	[39906]="755:350",
	[39907]="755:360",
	[39908]="755:350",
	[39909]="755:350",
	[39910]="755:350",
	[39911]="755:350",
	[39912]="755:350",
	[39914]="755:350",
	[39915]="755:350",
	[39916]="755:350",
	[39917]="755:350",
	[39918]="755:350",
	[39919]="755:350",
	[39920]="755:350",
	[39927]="755:350",
	[39932]="755:350",
	[39933]="755:350",
	[39934]="755:350",
	[39935]="755:350",
	[39936]="755:350",
	[39937]="755:350",
	[39938]="755:360",
	[39939]="755:350",
	[39940]="755:350",
	[39941]="755:350",
	[39942]="755:350",
	[39943]="755:350",
	[39944]="755:350",
	[39945]="755:350",
	[39946]="755:350",
	[39947]="755:350",
	[39948]="755:350",
	[39949]="755:350",
	[39950]="755:350",
	[39951]="755:350",
	[39952]="755:350",
	[39953]="755:350",
	[39954]="755:350",
	[39955]="755:350",
	[39956]="755:350",
	[39957]="755:350",
	[39958]="755:350",
	[39959]="755:350",
	[39960]="755:350",
	[39961]="755:350",
	[39962]="755:350",
	[39963]="755:350",
	[39964]="755:350",
	[39965]="755:360",
	[39966]="755:350",
	[39967]="755:350",
	[39968]="755:350",
	[39974]="755:350",
	[39975]="755:350",
	[39976]="755:350",
	[39977]="755:350",
	[39978]="755:350",
	[39979]="755:350",
	[39980]="755:350",
	[39981]="755:350",
	[39982]="755:350",
	[39983]="755:350",
	[39984]="755:350",
	[39985]="755:350",
	[39986]="755:350",
	[39988]="755:350",
	[39989]="755:350",
	[39990]="755:350",
	[39991]="755:350",
	[39992]="755:350",
	[39996]="755:390",
	[39997]="755:390",
	[39998]="755:390",
	[39999]="755:390",
	[40000]="755:390",
	[40001]="755:390",
	[40002]="755:390",
	[40003]="755:390",
	[40008]="755:390",
	[40009]="755:390",
	[40010]="755:390",
	[40011]="755:390",
	[40012]="755:390",
	[40013]="755:390",
	[40014]="755:390",
	[40015]="755:390",
	[40016]="755:390",
	[40017]="755:390",
	[40022]="755:390",
	[40023]="755:390",
	[40024]="755:390",
	[40025]="755:390",
	[40026]="755:390",
	[40027]="755:390",
	[40028]="755:390",
	[40029]="755:390",
	[40030]="755:390",
	[40031]="755:390",
	[40032]="755:390",
	[40033]="755:390",
	[40034]="755:390",
	[40037]="755:390",
	[40038]="755:390",
	[40039]="755:390",
	[40040]="755:390",
	[40041]="755:390",
	[40043]="755:390",
	[40044]="755:390",
	[40045]="755:390",
	[40046]="755:390",
	[40047]="755:390",
	[40048]="755:390",
	[40049]="755:390",
	[40050]="755:390",
	[40051]="755:390",
	[40052]="755:390",
	[40053]="755:390",
	[40054]="755:390",
	[40055]="755:390",
	[40056]="755:390",
	[40057]="755:390",
	[40058]="755:390",
	[40059]="755:390",
	[40067]="171:360",
	[40068]="171:355",
	[40070]="171:365",
	[40072]="171:385",
	[40073]="171:385",
	[40076]="171:375",
	[40077]="171:400",
	[40078]="171:390",
	[40079]="171:375",
	[40081]="171:380",
	[40085]="755:390",
	[40086]="755:390",
	[40087]="171:400",
	[40088]="755:390",
	[40089]="755:390",
	[40090]="755:390",
	[40091]="755:390",
	[40092]="755:390",
	[40093]="171:395",
	[40094]="755:390",
	[40095]="755:390",
	[40096]="755:390",
	[40097]="171:400",
	[40098]="755:390",
	[40099]="755:390",
	[40100]="755:390",
	[40101]="755:390",
	[40102]="755:390",
	[40103]="755:390",
	[40104]="755:390",
	[40105]="755:390",
	[40106]="755:390",
	[40109]="171:400",
	[40195]="171:375",
	[40211]="171:400",
	[40212]="171:400",
	[40213]="171:400",
	[40214]="171:400",
	[40215]="171:400",
	[40216]="171:400",
	[40217]="171:400",
	[40248]="171:300",
	[40536]="202:375",
	[40668]="164:360",
	[40669]="164:395",
	[40670]="164:390",
	[40671]="164:400",
	[40672]="164:400",
	[40673]="164:405",
	[40674]="164:395",
	[40675]="164:405",
	[40767]="202:420",
	[40768]="202:425",
	[40769]="202:0",
	[40771]="202:350",
	[40772]="202:435",
	[40773]="354:0",
	[40865]="202:420",
	[40892]="202:375",
	[40893]="202:375",
	[40895]="202:425",
	[40896]="773:350",
	[40897]="773:90",
	[40899]="773:385",
	[40900]="773:385",
	[40901]="773:260",
	[40902]="773:200",
	[40903]="773:310",
	[40906]="773:385",
	[40908]="773:385",
	[40909]="773:170",
	[40912]="773:385",
	[40913]="773:80",
	[40914]="773:115",
	[40915]="773:385",
	[40916]="773:220",
	[40919]="773:150",
	[40920]="773:385",
	[40921]="773:385",
	[40922]="773:85",
	[40923]="773:130",
	[40924]="773:100",
	[40942]="164:375",
	[40943]="164:395",
	[40949]="164:380",
	[40950]="164:385",
	[40951]="164:385",
	[40952]="164:390",
	[40953]="164:395",
	[40954]="164:400",
	[40955]="164:400",
	[40956]="164:375",
	[40957]="164:375",
	[40958]="164:375",
	[40959]="164:375",
	[41092]="773:120",
	[41094]="773:335",
	[41095]="773:90",
	[41096]="773:80",
	[41097]="773:385",
	[41098]="773:230",
	[41099]="773:205",
	[41100]="773:155",
	[41101]="773:385",
	[41102]="773:375",
	[41103]="773:265",
	[41104]="773:180",
	[41105]="773:300",
	[41106]="773:105",
	[41107]="773:385",
	[41108]="773:135",
	[41109]="773:385",
	[41110]="773:385",
	[41112]="202:0",
	[41113]="164:410",
	[41114]="164:415",
	[41116]="164:410",
	[41117]="164:390",
	[41121]="202:425",
	[41126]="164:395",
	[41127]="164:400",
	[41128]="164:405",
	[41129]="164:415",
	[41146]="202:425",
	[41163]="186:450",
	[41167]="202:430",
	[41168]="202:450",
	[41169]="354:0",
	[41170]="354:0",
	[41171]="354:0",
	[41172]="354:0",
	[41173]="354:0",
	[41174]="354:0",
	[41181]="164:390",
	[41182]="164:395",
	[41183]="164:400",
	[41184]="164:405",
	[41185]="164:410",
	[41186]="164:415",
	[41187]="164:415",
	[41188]="164:415",
	[41189]="164:415",
	[41190]="164:415",
	[41191]="354:0",
	[41192]="354:0",
	[41193]="354:0",
	[41194]="354:0",
	[41195]="354:0",
	[41196]="354:0",
	[41238]="165:395",
	[41239]="164:380",
	[41240]="164:380",
	[41241]="164:385",
	[41242]="164:385",
	[41243]="164:390",
	[41245]="164:405",
	[41248]="197:400",
	[41249]="197:400",
	[41250]="197:400",
	[41251]="197:400",
	[41252]="197:400",
	[41253]="197:400",
	[41254]="197:400",
	[41255]="197:400",
	[41257]="164:440",
	[41264]="165:0",
	[41266]="171:430",
	[41285]="755:420",
	[41307]="755:420",
	[41333]="755:420",
	[41334]="171:425",
	[41335]="755:420",
	[41339]="755:420",
	[41344]="164:425",
	[41345]="164:425",
	[41346]="164:425",
	[41347]="164:425",
	[41348]="164:420",
	[41349]="164:420",
	[41350]="164:425",
	[41351]="164:420",
	[41352]="164:420",
	[41353]="164:425",
	[41354]="164:420",
	[41355]="164:420",
	[41356]="164:420",
	[41357]="164:420",
	[41367]="755:350",
	[41375]="755:420",
	[41376]="755:420",
	[41377]="755:420",
	[41378]="755:420",
	[41379]="755:420",
	[41380]="755:420",
	[41381]="755:420",
	[41382]="755:420",
	[41383]="164:440",
	[41384]="164:440",
	[41385]="755:420",
	[41386]="164:440",
	[41387]="164:440",
	[41388]="164:440",
	[41389]="755:420",
	[41391]="164:440",
	[41392]="164:440",
	[41394]="164:440",
	[41395]="755:420",
	[41396]="755:420",
	[41397]="755:420",
	[41398]="755:420",
	[41400]="755:420",
	[41401]="755:420",
	[41508]="202:450",
	[41509]="197:360",
	[41510]="197:350",
	[41511]="197:400",
	[41512]="197:350",
	[41513]="197:350",
	[41515]="197:360",
	[41516]="197:420",
	[41517]="773:385",
	[41518]="773:385",
	[41519]="197:380",
	[41520]="197:375",
	[41521]="197:380",
	[41522]="197:370",
	[41523]="197:385",
	[41524]="773:385",
	[41525]="197:390",
	[41526]="773:385",
	[41527]="773:300",
	[41528]="197:385",
	[41529]="773:385",
	[41530]="773:110",
	[41531]="773:85",
	[41532]="773:125",
	[41533]="773:215",
	[41534]="773:385",
	[41535]="773:235",
	[41536]="773:140",
	[41537]="773:95",
	[41538]="773:385",
	[41539]="773:375",
	[41540]="773:165",
	[41541]="773:275",
	[41542]="773:330",
	[41543]="197:395",
	[41544]="197:0",
	[41545]="197:405",
	[41546]="197:395",
	[41547]="773:185",
	[41548]="197:395",
	[41549]="197:405",
	[41550]="197:410",
	[41551]="197:400",
	[41552]="773:385",
	[41553]="197:415",
	[41554]="197:420",
	[41555]="197:415",
	[41593]="197:415",
	[41594]="197:415",
	[41595]="197:415",
	[41597]="197:435",
	[41598]="197:440",
	[41599]="197:410",
	[41600]="197:445",
	[41601]="197:400",
	[41602]="197:430",
	[41603]="197:400",
	[41604]="197:430",
	[41607]="197:390",
	[41608]="197:395",
	[41609]="197:0",
	[41610]="197:0",
	[41611]="164:415",
	[41745]="164:420",
	[41974]="164:360",
	[41975]="164:370",
	[41976]="164:420",
	[41984]="197:425",
	[41985]="197:420",
	[41986]="197:420",
	[42093]="197:425",
	[42095]="197:420",
	[42096]="197:420",
	[42100]="197:440",
	[42101]="197:440",
	[42102]="197:440",
	[42103]="197:435",
	[42111]="197:435",
	[42113]="197:435",
	[42142]="755:370",
	[42143]="755:370",
	[42144]="755:370",
	[42145]="755:370",
	[42146]="755:370",
	[42148]="755:370",
	[42149]="755:370",
	[42150]="755:370",
	[42151]="755:370",
	[42152]="755:370",
	[42153]="755:370",
	[42154]="755:370",
	[42155]="755:370",
	[42156]="755:370",
	[42157]="755:370",
	[42158]="755:370",
	[42336]="755:350",
	[42337]="755:350",
	[42338]="755:380",
	[42339]="755:380",
	[42340]="755:420",
	[42341]="755:400",
	[42395]="755:400",
	[42396]="773:385",
	[42397]="773:230",
	[42398]="773:105",
	[42399]="773:270",
	[42400]="773:120",
	[42401]="773:315",
	[42402]="773:135",
	[42403]="773:385",
	[42404]="773:385",
	[42405]="773:385",
	[42406]="773:350",
	[42407]="773:385",
	[42408]="773:80",
	[42409]="773:385",
	[42410]="773:95",
	[42411]="773:160",
	[42412]="773:375",
	[42413]="755:400",
	[42414]="773:385",
	[42415]="773:180",
	[42416]="773:210",
	[42417]="773:385",
	[42418]="755:400",
	[42420]="755:360",
	[42421]="755:370",
	[42435]="164:440",
	[42443]="164:410",
	[42453]="773:350",
	[42454]="773:385",
	[42455]="773:85",
	[42456]="773:385",
	[42457]="773:385",
	[42458]="773:125",
	[42459]="773:385",
	[42460]="773:385",
	[42461]="773:110",
	[42462]="773:95",
	[42463]="773:385",
	[42464]="773:385",
	[42465]="773:140",
	[42466]="773:215",
	[42467]="773:165",
	[42468]="773:275",
	[42469]="773:385",
	[42470]="773:240",
	[42471]="773:325",
	[42472]="773:385",
	[42473]="773:190",
	[42500]="164:420",
	[42508]="164:440",
	[42546]="202:415",
	[42549]="202:440",
	[42550]="202:440",
	[42551]="202:440",
	[42552]="202:440",
	[42553]="202:440",
	[42554]="202:440",
	[42555]="202:440",
	[42641]="202:425",
	[42642]="755:430",
	[42643]="755:430",
	[42644]="755:430",
	[42645]="755:440",
	[42646]="755:440",
	[42647]="755:440",
	[42701]="755:360",
	[42702]="755:390",
	[42723]="164:420",
	[42724]="164:420",
	[42725]="164:425",
	[42726]="164:425",
	[42727]="164:420",
	[42728]="164:425",
	[42729]="164:420",
	[42730]="164:420",
	[42731]="165:425",
	[42734]="773:100",
	[42735]="773:115",
	[42736]="773:335",
	[42737]="773:130",
	[42738]="773:155",
	[42739]="773:385",
	[42740]="773:385",
	[42741]="773:80",
	[42742]="773:385",
	[42743]="773:90",
	[42744]="773:225",
	[42745]="773:375",
	[42746]="773:175",
	[42747]="773:205",
	[42748]="773:385",
	[42749]="773:325",
	[42750]="773:280",
	[42751]="773:385",
	[42752]="773:400",
	[42753]="773:385",
	[42754]="773:385",
	[42897]="773:175",
	[42898]="773:100",
	[42899]="773:385",
	[42900]="773:115",
	[42901]="773:385",
	[42902]="773:385",
	[42903]="773:200",
	[42904]="773:225",
	[42905]="773:260",
	[42906]="773:350",
	[42907]="773:80",
	[42908]="773:130",
	[42909]="773:375",
	[42910]="773:150",
	[42911]="773:315",
	[42912]="773:90",
	[42913]="773:385",
	[42914]="773:385",
	[42915]="773:385",
	[42916]="773:385",
	[42917]="773:385",
	[42942]="185:350",
	[42954]="773:385",
	[42955]="773:340",
	[42956]="773:80",
	[42957]="773:385",
	[42958]="773:385",
	[42959]="773:385",
	[42960]="773:95",
	[42961]="773:105",
	[42962]="773:120",
	[42963]="773:305",
	[42964]="773:135",
	[42965]="773:385",
	[42966]="773:160",
	[42967]="773:385",
	[42968]="773:385",
	[42969]="773:385",
	[42970]="773:185",
	[42971]="773:385",
	[42972]="773:210",
	[42973]="773:235",
	[42974]="773:285",
	[42993]="185:400",
	[42994]="185:400",
	[42995]="185:400",
	[42996]="185:400",
	[42997]="185:400",
	[42998]="185:400",
	[42999]="185:400",
	[43000]="185:400",
	[43001]="185:400",
	[43004]="185:400",
	[43005]="185:400",
	[43015]="185:450",
	[43115]="773:85",
	[43116]="773:100",
	[43117]="773:125",
	[43118]="773:150",
	[43119]="773:175",
	[43120]="773:200",
	[43121]="773:225",
	[43122]="773:250",
	[43123]="773:275",
	[43124]="773:290",
	[43125]="773:325",
	[43126]="773:350",
	[43127]="773:375",
	[43129]="165:425",
	[43130]="165:420",
	[43131]="165:420",
	[43132]="165:425",
	[43133]="165:420",
	[43145]="773:350",
	[43146]="773:400",
	[43244]="755:350",
	[43245]="755:350",
	[43246]="755:370",
	[43247]="755:370",
	[43248]="755:390",
	[43249]="755:390",
	[43250]="755:420",
	[43251]="755:420",
	[43252]="755:420",
	[43253]="755:420",
	[43255]="165:420",
	[43256]="165:420",
	[43257]="165:425",
	[43258]="165:420",
	[43260]="165:420",
	[43261]="165:420",
	[43262]="165:420",
	[43263]="165:420",
	[43264]="165:420",
	[43265]="165:425",
	[43266]="165:425",
	[43268]="185:350",
	[43271]="165:425",
	[43273]="165:425",
	[43316]="773:75",
	[43331]="773:75",
	[43332]="773:75",
	[43334]="773:75",
	[43335]="773:75",
	[43338]="773:75",
	[43339]="773:75",
	[43340]="773:75",
	[43342]="773:75",
	[43343]="773:75",
	[43344]="773:75",
	[43350]="773:75",
	[43351]="773:75",
	[43354]="773:75",
	[43355]="773:75",
	[43356]="773:75",
	[43357]="773:75",
	[43359]="773:75",
	[43360]="773:75",
	[43361]="773:75",
	[43364]="773:75",
	[43365]="773:75",
	[43366]="773:75",
	[43367]="773:75",
	[43368]="773:75",
	[43369]="773:75",
	[43370]="773:75",
	[43371]="773:75",
	[43372]="773:75",
	[43373]="773:75",
	[43374]="773:75",
	[43376]="773:75",
	[43377]="773:75",
	[43378]="773:75",
	[43379]="773:75",
	[43380]="773:75",
	[43381]="773:75",
	[43385]="773:75",
	[43386]="773:75",
	[43388]="773:75",
	[43389]="773:75",
	[43390]="773:75",
	[43391]="773:75",
	[43392]="773:75",
	[43393]="773:75",
	[43394]="773:75",
	[43395]="773:75",
	[43396]="773:75",
	[43397]="773:75",
	[43398]="773:75",
	[43399]="773:75",
	[43400]="773:75",
	[43412]="773:385",
	[43413]="773:85",
	[43414]="773:240",
	[43415]="773:385",
	[43416]="773:285",
	[43417]="773:125",
	[43418]="773:95",
	[43419]="773:385",
	[43420]="773:220",
	[43421]="773:385",
	[43422]="773:170",
	[43423]="773:110",
	[43424]="773:190",
	[43425]="773:385",
	[43426]="773:385",
	[43427]="773:140",
	[43428]="773:320",
	[43429]="773:385",
	[43430]="773:385",
	[43431]="773:385",
	[43432]="773:345",
	[43433]="165:420",
	[43434]="165:420",
	[43435]="165:420",
	[43436]="165:425",
	[43437]="165:425",
	[43438]="165:425",
	[43439]="165:425",
	[43442]="165:425",
	[43443]="165:425",
	[43444]="165:420",
	[43445]="165:420",
	[43446]="165:425",
	[43447]="165:420",
	[43448]="165:425",
	[43449]="165:420",
	[43450]="165:425",
	[43451]="165:425",
	[43452]="165:420",
	[43453]="165:420",
	[43454]="165:425",
	[43455]="165:420",
	[43456]="165:425",
	[43457]="165:420",
	[43458]="165:440",
	[43459]="165:440",
	[43461]="165:440",
	[43463]="773:370",
	[43464]="773:420",
	[43465]="773:365",
	[43466]="773:415",
	[43469]="165:440",
	[43478]="185:425",
	[43480]="185:425",
	[43481]="165:440",
	[43482]="755:420",
	[43484]="165:440",
	[43488]="185:350",
	[43490]="185:350",
	[43491]="185:350",
	[43492]="185:350",
	[43495]="165:440",
	[43498]="755:420",
	[43502]="165:440",
	[43515]="773:110",
	[43518]="237:0",
	[43523]="237:0",
	[43533]="773:385",
	[43534]="773:385",
	[43535]="773:75",
	[43536]="773:265",
	[43537]="773:385",
	[43538]="773:385",
	[43539]="773:75",
	[43541]="773:285",
	[43542]="773:385",
	[43543]="773:270",
	[43544]="773:75",
	[43545]="773:385",
	[43546]="773:280",
	[43547]="773:385",
	[43548]="773:300",
	[43549]="773:350",
	[43550]="773:385",
	[43551]="773:330",
	[43552]="773:375",
	[43553]="773:305",
	[43554]="773:345",
	[43565]="165:440",
	[43566]="165:440",
	[43569]="171:410",
	[43570]="171:410",
	[43582]="755:420",
	[43583]="197:425",
	[43584]="197:420",
	[43585]="197:420",
	[43586]="164:425",
	[43587]="164:420",
	[43588]="164:420",
	[43590]="165:425",
	[43591]="165:420",
	[43592]="165:420",
	[43593]="165:425",
	[43594]="165:420",
	[43595]="165:420",
	[43654]="773:125",
	[43655]="773:125",
	[43656]="773:175",
	[43657]="773:175",
	[43660]="773:225",
	[43661]="773:225",
	[43663]="773:275",
	[43664]="773:275",
	[43666]="773:325",
	[43667]="773:325",
	[43671]="773:75",
	[43672]="773:75",
	[43673]="773:75",
	[43674]="773:75",
	[43725]="773:75",
	[43825]="773:310",
	[43826]="773:320",
	[43827]="773:340",
	[43850]="773:200",
	[43853]="164:430",
	[43854]="164:350",
	[43860]="164:395",
	[43864]="164:400",
	[43865]="164:405",
	[43867]="773:385",
	[43868]="773:385",
	[43869]="773:385",
	[43870]="164:415",
	[43871]="164:410",
	[43969]="197:415",
	[43970]="197:420",
	[43971]="197:420",
	[43972]="197:420",
	[43973]="197:420",
	[43974]="197:415",
	[43975]="197:420",
	[44063]="755:400",
	[44142]="773:125",
	[44161]="773:175",
	[44163]="773:225",
	[44210]="773:400",
	[44211]="197:360",
	[44314]="773:200",
	[44315]="773:350",
	[44316]="773:275",
	[44317]="773:325",
	[44318]="773:400",
	[44322]="171:400",
	[44323]="171:400",
	[44324]="171:400",
	[44325]="171:400",
	[44327]="171:400",
	[44328]="171:400",
	[44329]="171:400",
	[44330]="171:400",
	[44331]="171:400",
	[44332]="171:395",
	[44413]="202:450",
	[44436]="165:395",
	[44437]="165:395",
	[44438]="165:400",
	[44440]="165:395",
	[44441]="165:395",
	[44442]="165:400",
	[44443]="165:395",
	[44444]="165:395",
	[44445]="165:400",
	[44446]="165:415",
	[44447]="165:415",
	[44448]="165:415",
	[44452]="333:425",
	[44504]="202:450",
	[44506]="202:415",
	[44507]="202:410",
	[44554]="197:410",
	[44558]="197:425",
	[44684]="773:385",
	[44739]="202:390",
	[44740]="202:0",
	[44741]="202:0",
	[44742]="202:420",
	[44836]="185:0",
	[44837]="185:0",
	[44838]="185:0",
	[44839]="185:0",
	[44840]="185:0",
	[44920]="773:75",
	[44922]="773:75",
	[44923]="773:75",
	[44928]="773:75",
	[44930]="165:440",
	[44931]="165:440",
	[44936]="164:450",
	[44939]="171:385",
	[44943]="755:425",
	[44949]="202:440",
	[44951]="202:405",
	[44953]="185:400",
	[44955]="773:75",
	[44958]="171:375",
	[44963]="165:425",
	[45054]="755:300",
	[45085]="164:440",
	[45550]="164:450",
	[45551]="164:450",
	[45552]="164:450",
	[45553]="165:450",
	[45554]="165:450",
	[45555]="165:450",
	[45556]="165:450",
	[45557]="197:450",
	[45558]="197:450",
	[45559]="164:450",
	[45560]="164:450",
	[45561]="164:450",
	[45562]="165:450",
	[45563]="165:450",
	[45564]="165:450",
	[45565]="165:450",
	[45566]="197:450",
	[45567]="197:450",
	[45601]="773:0",
	[45602]="773:0",
	[45603]="773:0",
	[45604]="773:0",
	[45621]="171:135",
	[45622]="773:250",
	[45623]="773:0",
	[45625]="773:0",
	[45626]="197:125",
	[45627]="755:200",
	[45631]="202:250",
	[45731]="773:0",
	[45732]="773:0",
	[45733]="773:0",
	[45734]="773:0",
	[45735]="773:0",
	[45736]="773:0",
	[45737]="773:0",
	[45738]="773:0",
	[45739]="773:0",
	[45740]="773:0",
	[45741]="773:0",
	[45742]="773:0",
	[45743]="773:0",
	[45744]="773:0",
	[45745]="773:0",
	[45746]="773:0",
	[45747]="773:0",
	[45753]="773:0",
	[45755]="773:0",
	[45756]="773:0",
	[45757]="773:0",
	[45758]="773:0",
	[45760]="773:255",
	[45761]="773:0",
	[45762]="773:0",
	[45764]="773:0",
	[45766]="773:0",
	[45767]="773:0",
	[45768]="773:255",
	[45769]="773:0",
	[45770]="773:0",
	[45771]="773:0",
	[45772]="773:0",
	[45773]="197:435",
	[45775]="773:250",
	[45776]="773:255",
	[45777]="773:0",
	[45778]="773:0",
	[45779]="773:0",
	[45780]="773:0",
	[45781]="773:0",
	[45782]="773:0",
	[45783]="773:0",
	[45785]="773:0",
	[45789]="773:0",
	[45790]="773:0",
	[45792]="773:0",
	[45793]="773:0",
	[45794]="773:350",
	[45795]="773:0",
	[45797]="773:0",
	[45799]="773:0",
	[45800]="773:0",
	[45803]="773:0",
	[45804]="773:275",
	[45805]="773:280",
	[45806]="773:0",
	[45808]="755:420",
	[45809]="755:420",
	[45810]="197:405",
	[45811]="197:400",
	[45812]="755:420",
	[45813]="755:420",
	[45849]="773:350",
	[45854]="773:350",
	[45908]="773:0",
	[45932]="185:400",
	[46372]="773:0",
	[46376]="171:435",
	[46377]="171:435",
	[46378]="171:435",
	[46379]="171:435",
})

-- The base item data
Informant.SetDatabase({
	[25]="0:7:2:1:1:OneHandSword::1:0:", -- Worn Shortsword
	[35]="0:9:2:1:1:Stave::1:0:", -- Bent Staff
	[36]="0:7:2:1:1:OneHandMace::1:0:", -- Worn Mace
	[37]="0:7:2:1:1:OneHandAxe::1:0:", -- Worn Axe
	[38]="1:1:4:1:1:Shirt::1:0:18672", -- Recruit's Shirt
	[39]="5:1:4:0:1:Cloth::1:0:18672", -- Recruit's Pants
	[40]="5:1:4:1:1:Miscellaneous::1:0:18672", -- Recruit's Boots
	[43]="5:1:4:1:1:Miscellaneous::1:0:18672", -- Squire's Boots
	[44]="4:1:4:0:1:Cloth::1:0:18672", -- Squire's Pants
	[45]="1:1:4:1:1:Shirt::1:0:18672", -- Squire's Shirt
	[47]="0:1:4:1:1:Miscellaneous::1:0:", -- Footpad's Shoes
	[48]="0:1:4:0:1:Cloth::1:0:", -- Footpad's Pants
	[49]="0:1:4:1:1:Shirt::1:0:", -- Footpad's Shirt
	[51]="5:1:4:1:1:Miscellaneous::1:0:18672", -- Neophyte's Boots
	[52]="5:1:4:0:1:Cloth::1:0:18672", -- Neophyte's Pants
	[53]="1:1:4:1:1:Shirt::1:0:18672", -- Neophyte's Shirt
	[55]="5:1:4:1:1:Miscellaneous::1:0:18672", -- Apprentice's Boots
	[56]="5:1:4:0:1:Cloth::1:0:18672", -- Apprentice's Robe
	[57]="5:1:4:0:1:Cloth::1:0:18672", -- Acolyte's Robe
	[59]="5:1:4:1:1:Miscellaneous::1:0:18672", -- Acolyte's Shoes
	[60]="0:12:4:1:1:Leather::1:0:", -- Layered Tunic
	[61]="0:12:4:1:1:Leather::1:0:", -- Dwarven Leather Pants
	[79]="0:10:4:1:1:Cloth::1:0:", -- Dwarven Cloth Britches
	[80]="0:7:4:1:1:Cloth::1:0:", -- Soft Fur-lined Shoes
	[85]="63:12:4:1:1:Leather::1:0:2113,3074,3160,4558", -- Dirty Leather Vest
	[117]="25:1:0:1:20:FoodDrink::5:0:982,1464,2365,2388,2814,3025,3089,3312,3368,3411,3489,3621,3705,3881,3882,3933,3935,3960,4084,4169,4782,4875,4879,4891,4894,4954,5111,5124,5611,5620,5870,6928,6929,7485,7731,7733,8125,9356,11118,11187,12196,12959,14624,15174,15397,16443,16618,16739,17553,17630,17656,19182,23263,23481,23605,24208,24343", -- Tough Jerky
	[118]="0:5:0:1:5:Potion:171:1:0:", -- Minor Healing Potion
	[120]="0:1:4:0:1:Cloth::1:0:", -- Thug Pants
	[121]="0:1:4:1:1:Miscellaneous::1:0:", -- Thug Boots
	[127]="0:1:4:1:1:Shirt::1:0:", -- Trapper's Shirt
	[129]="0:1:4:1:1:Miscellaneous::1:0:", -- Rugged Trapper's Boots
	[139]="0:1:4:0:1:Cloth::1:0:", -- Brawler's Pants
	[140]="0:1:4:1:1:Miscellaneous::1:0:", -- Brawler's Boots
	[147]="0:1:4:0:1:Cloth::1:0:", -- Rugged Trapper's Pants
	[148]="0:1:4:1:1:Shirt::1:0:", -- Rugged Trapper's Shirt
	[153]="0:1:4:0:1:Leather::1:0:", -- Primitive Kilt
	[154]="0:1:4:1:1:Shirt::1:0:", -- Primitive Mantle
	[159]="25:1:0:1:20:FoodDrink:185,202:5:0:151,152,227,258,274,295,465,491,734,791,829,955,982,1149,1237,1247,1250,1285,1328,1448,1452,1464,1682,1685,1691,1697,2084,2115,2134,2140,2303,2352,2364,2366,2381,2388,2397,2401,2664,2803,2806,2808,2820,2832,2908,3027,3072,3076,3085,3086,3158,3164,3186,3298,3313,3350,3400,3411,3481,3498,3541,3546,3577,3587,3608,3621,3689,3708,3881,3882,3883,3884,3934,3937,3959,3961,3962,4082,4084,4167,4169,4170,4181,4182,4190,4191,4192,4195,4223,4241,4265,4266,4553,4554,4555,4571,4782,4875,4876,4879,4893,4896,4981,5101,5111,5112,5134,5140,5160,5483,5611,5620,5688,5814,5871,6091,6272,6495,6727,6734,6735,6736,6737,6738,6739,6740,6741,6746,6747,6790,6791,6807,6928,6929,6930,7485,7714,7731,7733,7736,7737,7744,7941,7942,7943,8125,8137,8139,8143,8150,8152,8307,8362,8931,9356,9501,11038,11103,11106,11116,11118,11187,11287,11555,12019,12021,12026,12027,12033,12196,12246,12959,12960,14371,14624,14731,14738,15174,15287,15397,15433,16187,16191,16253,16256,16259,16260,16443,16444,16458,16542,16553,16618,16677,16718,16732,16739,16920,17246,17421,17446,17489,17553,17630,17656,18810,18811,18987,18993,19182,19195,19371,19617,20028,20096,20097,21145,23573,23995,24208,24834,24934,24993,25012,25020,25052,25089,26868,28811,29291,31031,31032,33595", -- Refreshing Spring Water
	[182]="0:0:12:1:1:::1:0:", -- Garrick's Head
	[192]="0:210533:2:6:1:Miscellaneous::1:0:", -- Martin Thunder
	[193]="49:9:4:1:1:Cloth::1:0:2113,3160,4558", -- Tattered Cloth Vest
	[194]="49:9:4:1:1:Cloth::1:0:2113,3160,4558", -- Tattered Cloth Pants
	[195]="37:7:4:1:1:Cloth::1:0:2113,3160,4558", -- Tattered Cloth Boots
	[200]="2270:454:4:1:1:Cloth::1:0:1291,2849,3092,3317,3492,3952,4175,4188,5155,5821,8358,16623,16716", -- Thick Cloth Vest
	[201]="2278:455:4:1:1:Cloth::1:0:1291,2849,3092,3317,3492,3952,4175,4188,5155,5821,8358,16623,16716", -- Thick Cloth Pants
	[202]="1715:343:4:1:1:Cloth::1:0:1291,2849,3092,3317,3492,3952,4175,4188,5155,5821,8358,16623,16716", -- Thick Cloth Shoes
	[203]="1147:229:4:1:1:Cloth::1:0:1291,2849,3092,3317,3492,3952,4175,4188,5155,5821,8358,16623,16716", -- Thick Cloth Gloves
	[209]="61:12:4:1:1:Leather::1:0:2113,3074,3160,4558", -- Dirty Leather Pants
	[210]="45:9:4:1:1:Leather::1:0:2113,3074,3160,4558", -- Dirty Leather Boots
	[236]="2795:559:4:1:1:Leather::1:0:1295,1695,3093,3097,3321,3492,3536,3953,4236,5783,5820,8359,16691,16747", -- Cured Leather Armor
	[237]="2806:561:4:1:1:Leather::1:0:1295,1695,3093,3097,3321,3492,3536,3953,4236,5783,5820,8359,16691,16747", -- Cured Leather Pants
	[238]="2112:422:4:1:1:Leather::1:0:1295,1695,3093,3097,3321,3492,3536,3953,4236,5783,5820,8359,16691,16747", -- Cured Leather Boots
	[239]="1413:282:4:1:1:Leather::1:0:1295,1695,3093,3097,3321,3492,3536,3953,4236,5783,5820,8359,16691,16747", -- Cured Leather Gloves
	[285]="3555:711:4:1:1:Mail::1:0:956,1294,1341,3319,3493,3543,3682,4177,5125,5812,5819,8360,16625,16750", -- Scalemail Vest
	[286]="3229:645:4:1:1:Mail::1:0:956,1294,1341,3319,3493,3543,3682,4177,5125,5812,5819,8360,16625,16750", -- Scalemail Pants
	[287]="2442:488:4:1:1:Mail::1:0:956,1294,1341,3319,3493,3543,3682,4177,5125,5812,5819,8360,16625,16750", -- Scalemail Boots
	[414]="125:6:0:1:20:FoodDrink::5:0:295,465,483,1237,2352,2364,3298,3546,4782,4891,4894,4981,5620,6746,6790,6930,9501,11106,11116,16553,17630,18929,23521,23604,24934,29714", -- Dalaran Sharp
	[422]="500:25:0:1:20:FoodDrink::5:0:295,465,483,1237,2352,2364,3298,3546,4782,4891,4894,4981,5620,6746,6790,6930,9501,11106,11116,16553,17630,18929,23521,23604,24934", -- Dwarven Mild
	[537]="0:87:15:0:5:Junk::1:0:", -- Dull Frenzy Scale
	[555]="0:8:15:0:10:Junk::1:0:", -- Rough Vulture Feathers
	[556]="0:106:15:0:5:Junk::1:0:", -- Buzzard Beak
	[647]="0:70024:2:4:1:TwoHandSword::1:0:", -- Destiny
	[710]="0:72:4:1:1:Cloth::1:0:", -- Bracers of the People's Militia
	[711]="26:5:4:1:1:Cloth::1:0:2113,3160,4558", -- Tattered Cloth Gloves
	[714]="32:6:4:1:1:Leather::1:0:2113,3074,3160,4558", -- Dirty Leather Gloves
	[718]="1614:322:4:1:1:Mail::1:0:956,1294,1341,3319,3493,3543,3682,4177,5125,5812,5819,8360,16625,16750", -- Scalemail Gloves
	[719]="0:4:4:1:1:Cloth::1:0:", -- Rabbit Handler Gloves
	[720]="0:1070:4:3:1:Leather::1:0:", -- Brawler Gloves
	[723]="0:15:7:1:10:Meat:185:1:0:", -- Goretusk Liver
	[724]="0:25:0:1:20:FoodDrink::1:0:", -- Goretusk Liver Pie
	[725]="0:0:12:1:20:::1:0:", -- Gnoll Paw
	[727]="0:245:2:2:1:OneHandSword::1:0:", -- Notched Shortsword
	[728]="200:50:9:1:1:Cooking::1:0:340", -- Recipe: Westfall Stew
	[729]="0:17:7:1:10:Meat:185:1:0:", -- Stringy Vulture Meat
	[730]="0:16:7:1:10:Meat:185:1:0:", -- Murloc Eye
	[731]="0:27:7:1:10:Meat:185:1:0:", -- Goretusk Snout
	[732]="0:6:12:1:10:::1:0:", -- Okra
	[733]="0:100:0:1:20:FoodDrink::1:0:", -- Westfall Stew
	[735]="0:0:12:1:1:::1:0:", -- Rolf and Malakai's Medallions
	[737]="0:0:12:1:1:::1:0:", -- Holy Spring Water
	[738]="0:0:12:1:20:::1:0:", -- Sack of Barley
	[739]="0:0:12:1:20:::1:0:", -- Sack of Corn
	[740]="0:0:12:1:20:::1:0:", -- Sack of Rye
	[742]="0:0:12:1:1:::1:0:", -- A Sycamore Branch
	[743]="0:0:12:1:1:::1:0:", -- Bundle of Charred Oak
	[744]="0:10000:4:2:1:Trinket::1:0:", -- Thunderbrew's Boot Flask
	[745]="0:0:12:1:1:::1:0:", -- Marshal McBride's Documents
	[748]="0:0:12:1:1:::1:0:", -- Stormwind Armor Marker
	[750]="0:0:12:1:20:::1:0:", -- Tough Wolf Meat
	[752]="0:0:12:1:20:::1:0:", -- Red Burlap Bandana
	[753]="0:3842:2:2:1:OneHandSword::1:0:", -- Dragonmaw Shortsword
	[754]="0:23556:2:3:1:OneHandSword::1:0:", -- Shortsword of Vengeance
	[755]="0:1:15:0:5:Junk::1:0:", -- Melted Candle
	[756]="0:4963:2:2:1:TwoHandAxe::1:0:", -- Tunnel Pick
	[763]="0:58:4:1:1:Leather::1:0:", -- Ice-covered Bracers
	[765]="40:10:7:1:20:Herb:171:1:1:1313,3490,3548,16224,16641,16705", -- Silverleaf
	[766]="0:57:2:1:1:OneHandMace::1:0:", -- Flanged Mace
	[767]="0:100:2:1:1:Stave::1:0:", -- Long Bo Staff
	[768]="0:113:2:1:1:OneHandAxe::1:0:", -- Lumberjack Axe
	[769]="0:3:7:1:10:Meat:185:1:0:", -- Chunk of Boar Meat
	[770]="0:316:15:0:10:Junk::1:0:", -- Pointy Crocolisk Tooth
	[771]="0:38:15:0:5:Junk::1:0:", -- Chipped Boar Tusk
	[772]="0:0:12:1:20:::1:0:", -- Large Candle
	[773]="0:0:12:1:20:::1:0:", -- Gold Dust
	[774]="0:15:3:2:20:GemSimple:164,202,755:1:0:", -- Malachite
	[776]="0:5765:2:3:1:Dagger::1:0:", -- Vendetta
	[777]="0:21:15:0:10:Junk::1:0:", -- Prowler Teeth
	[778]="0:55:2:1:1:OneHandAxe::1:0:", -- Kobold Excavation Pick
	[779]="0:18:15:0:5:Junk::1:0:", -- Shiny Seashell
	[780]="0:0:12:1:20:::1:0:", -- Torn Murloc Fin
	[781]="0:110:2:1:1:OneHandMace::1:0:", -- Stone Gnoll Hammer
	[782]="0:0:12:1:20:::1:0:", -- Painted Gnoll Armband
	[783]="0:50:7:1:10:Leather:165:1:0:", -- Light Hide
	[785]="80:20:7:1:20:Herb:171,185:1:1:844,1302,1313,3490,3548,4083,8305,14846,16224,16641,16705", -- Mageroyal
	[787]="25:1:0:1:20:FoodDrink::5:0:1678,1684,2842,3086,3178,3497,3540,4200,4221,4305,4307,5814,6727,6738,6791,6807,7943,8137,8931,11187,12962,14731,16618,16739,17553,17656,19045,23896,24834,24993,25012,25020,25052,25089,29291", -- Slitherskin Mackerel
	[789]="0:1969:2:2:1:OneHandMace::1:0:", -- Stout Battlehammer
	[790]="0:2020:2:2:1:OneHandAxe::1:0:", -- Forester's Axe
	[791]="0:7069:2:3:1:Stave::1:0:", -- Gnarled Ash Staff
	[792]="208:41:4:1:1:Cloth::1:0:74,959,1238,1291,2264,3092,3530,3611,3952,4164,4175,5821,16716,17929", -- Knitted Sandals
	[793]="139:27:4:1:1:Cloth::1:0:74,959,1238,1291,2264,3092,3530,3611,3952,4164,4175,5821,16716,17929", -- Knitted Gloves
	[794]="280:56:4:1:1:Cloth::1:0:74,959,1238,1291,2264,3092,3530,3611,3952,4164,4175,5821,16716,17929", -- Knitted Pants
	[795]="281:56:4:1:1:Cloth::1:0:74,959,1238,1291,2264,3092,3530,3611,3952,4164,4175,5821,16716,17929", -- Knitted Tunic
	[796]="264:52:4:1:1:Leather::1:0:74,896,1238,1295,3162,3532,3612,3953,4164,4236,5820,16747,17929", -- Rough Leather Boots
	[797]="177:35:4:1:1:Leather::1:0:74,896,1238,1295,3162,3532,3612,3953,4164,4236,5820,16747,17929", -- Rough Leather Gloves
	[798]="355:71:4:1:1:Leather::1:0:74,896,1238,1295,3162,3532,3612,3953,4164,4236,5820,16747,17929", -- Rough Leather Pants
	[799]="356:71:4:1:1:Leather::1:0:74,896,1238,1295,3162,3532,3612,3953,4164,4236,5820,16747,17929", -- Rough Leather Vest
	[804]="0:2500:1:1:1:Bag::1:0:", -- Large Blue Sack
	[805]="0:250:1:1:1:Bag::1:0:", -- Small Red Pouch
	[809]="0:39125:2:4:1:OneHandSword::1:0:", -- Bloodrazor
	[810]="0:45267:2:4:1:OneHandMace::1:0:", -- Hammer of the Northern Wind
	[811]="0:54123:2:4:1:OneHandAxe::1:0:", -- Axe of the Deep Woods
	[812]="0:57018:2:4:1:Stave::1:0:", -- Glowing Brightwood Staff
	[814]="0:25:7:1:20:Part:202:1:0:", -- Flask of Oil
	[816]="0:305:2:2:1:Dagger::1:0:", -- Small Hand Blade
	[818]="0:100:3:2:20:GemSimple:164,202,755:1:0:", -- Tigerseye
	[820]="0:947:2:2:1:Dagger::1:0:", -- Slicer Blade
	[821]="0:249:4:2:1:Leather::1:0:", -- Riverpaw Leather Vest
	[826]="0:732:2:2:1:OneHandAxe::1:0:", -- Brutish Riverpaw Axe
	[827]="0:971:2:2:1:OneHandMace::1:0:", -- Wicked Blackjack
	[828]="0:250:1:1:1:Bag::1:0:", -- Small Blue Pouch
	[829]="0:0:12:1:20:::1:0:", -- Red Leather Bandana
	[832]="0:203:4:2:1:Mail::1:0:", -- Silver Defias Belt
	[833]="0:28000:4:4:1:Trinket::1:0:", -- Lifestone
	[835]="0:23:0:1:1:Consumable::1:0:", -- Large Rope Net
	[837]="1125:225:4:1:1:Cloth::1:0:1214,1291,3092,3317,3486,3554,3683,3952,4164,4175,4185,4558,5108,5821,8358,16623,16631,16716", -- Heavy Weave Armor
	[838]="1129:225:4:1:1:Cloth::1:0:1214,1291,3092,3317,3486,3554,3683,3952,4164,4175,4185,4558,5108,5821,8358,16623,16631,16716", -- Heavy Weave Pants
	[839]="566:113:4:1:1:Cloth::1:0:1214,1291,3092,3317,3486,3554,3683,3952,4164,4175,4185,4558,5108,5821,8358,16623,16631,16716", -- Heavy Weave Gloves
	[840]="853:170:4:1:1:Cloth::1:0:1214,1291,3092,3317,3486,3554,3683,3952,4164,4175,4185,4558,5108,5821,8358,16623,16631,16716", -- Heavy Weave Shoes
	[841]="0:0:12:1:1:::1:0:", -- Furlbrow's Pocket Watch
	[843]="1077:215:4:1:1:Leather::1:0:896,954,1295,1669,3093,3321,3483,3552,3684,3953,4164,4186,4236,4558,5108,5820,8359,10380,16691,16747", -- Tanned Leather Boots
	[844]="721:144:4:1:1:Leather::1:0:896,954,1295,1669,3093,3321,3483,3552,3684,3953,4164,4186,4236,4558,5108,5820,8359,10380,16691,16747", -- Tanned Leather Gloves
	[845]="1447:289:4:1:1:Leather::1:0:896,954,1295,1669,3093,3321,3483,3552,3684,3953,4164,4186,4236,4558,5108,5820,8359,10380,16691,16747", -- Tanned Leather Pants
	[846]="1452:290:4:1:1:Leather::1:0:896,954,1295,1669,3093,3321,3483,3552,3684,3953,4164,4186,4236,4558,5108,5820,8359,10380,16691,16747", -- Tanned Leather Jerkin
	[847]="1749:349:4:1:1:Mail::1:0:167,1294,1362,3319,3483,3528,3553,4164,4177,4187,4560,5107,5812,5819,8360,11703,16625,16750", -- Chainmail Armor
	[848]="1755:351:4:1:1:Mail::1:0:167,1294,1362,3319,3483,3528,3553,4164,4177,4187,4560,5107,5812,5819,8360,11703,16625,16750", -- Chainmail Pants
	[849]="1327:265:4:1:1:Mail::1:0:167,1294,1362,3319,3483,3528,3553,4164,4177,4187,4560,5107,5812,5819,8360,11703,16625,16750", -- Chainmail Boots
	[850]="883:176:4:1:1:Mail::1:0:167,1294,1362,3319,3483,3528,3553,4164,4177,4187,4560,5107,5812,5819,8360,11703,16625,16750", -- Chainmail Gloves
	[851]="2023:404:2:1:1:OneHandSword::1:0:1287,1289,2997,3021,3314,3331,3361,3479,3534,3658,4171,4183,4203,4231,4557,4569,5103,5120,16714", -- Cutlass
	[852]="1739:347:2:1:1:OneHandMace::1:0:222,1287,1289,1348,2840,2997,3020,3314,3360,3479,3534,3658,4183,4203,4231,4233,4557,4602,5103,5121,16765,17412", -- Mace
	[853]="2409:481:2:1:1:OneHandAxe::1:0:1287,1289,2997,3019,3314,3409,3479,3534,3658,4183,4203,4231,4232,4557,4601,5103,5119,16714", -- Hatchet
	[854]="3023:604:2:1:1:Stave::1:0:1287,1289,1348,2997,3020,3314,3360,3409,3479,3534,3658,4183,4203,4231,4233,4557,4602,5103,5121,16765,17412,19238", -- Quarter Staff
	[856]="0:875:1:1:1:Bag::1:0:", -- Blue Leather Bag
	[857]="0:2500:1:1:1:Bag::1:0:", -- Large Red Sack
	[858]="100:25:0:1:5:Potion::1:1:844,958,1257,2140,3548,3658,14847", -- Lesser Healing Potion
	[859]="0:87:4:1:1:Shirt::1:0:", -- Fine Cloth Shirt
	[860]="0:89:4:1:1:Cloth::1:0:", -- Cavalier's Boots
	[862]="0:38222:4:3:1:Ring::1:0:", -- Runed Ring
	[863]="0:8964:2:2:1:OneHandAxe::1:0:", -- Gloom Reaper
	[864]="0:9716:2:2:1:OneHandSword::1:0:", -- Knightly Longsword
	[865]="0:5096:2:2:1:OneHandMace::1:0:", -- Leaden Mace
	[866]="0:16640:2:2:1:Stave::1:0:", -- Monk's Staff
	[867]="0:5344:4:4:1:Leather::1:0:", -- Gloves of Holy Might
	[868]="0:21533:2:4:1:OneHandMace::1:0:", -- Ardent Custodian
	[869]="0:18529:2:4:1:OneHandSword::1:0:", -- Dazzling Longsword
	[870]="0:21528:2:4:1:TwoHandAxe::1:0:", -- Fiery War Axe
	[871]="0:29628:2:4:1:OneHandAxe::1:0:", -- Flurry Axe
	[872]="0:2414:2:3:1:TwoHandAxe::1:0:", -- Rockslicer
	[873]="0:21770:2:4:1:Stave::1:0:", -- Staff of Jordan
	[878]="0:56:7:0:10:Other::1:0:", -- Fist-sized Spinneret
	[880]="0:2692:2:2:1:Stave::1:0:", -- Staff of Horrors
	[884]="0:0:12:1:20:::1:0:", -- Ghoul Rib
	[885]="0:2301:2:2:1:OneHandAxe::1:0:", -- Black Metal Axe
	[886]="0:2949:2:2:1:OneHandSword::1:0:", -- Black Metal Shortsword
	[887]="0:82:15:0:5:Junk::1:0:", -- Pound of Flesh
	[888]="0:980:4:3:1:Leather::1:0:", -- Naga Battle Gloves
	[889]="0:0:12:1:1:::1:0:", -- A Dusty Unsent Letter
	[890]="0:3517:2:3:1:Stave::1:0:", -- Twisted Chanter's Staff
	[892]="0:370:4:2:1:Cloth::1:0:", -- Gnoll Casting Gloves
	[893]="0:137:15:0:10:Junk::1:0:", -- Dire Wolf Fang
	[895]="0:0:12:1:20:::1:0:", -- Worgen Skull
	[896]="0:0:12:1:20:::1:0:", -- Worgen Fang
	[897]="0:1022:4:2:1:Leather::1:0:", -- Madwolf Bracers
	[899]="0:1248:2:2:1:Dagger::1:0:", -- Venom Web Fang
	[910]="0:0:12:1:1:::1:0:", -- An Undelivered Letter
	[911]="0:3324:2:2:1:TwoHandMace::1:0:", -- Ironwood Treebranch
	[914]="0:2669:4:2:1:Mail::1:0:", -- Large Ogre Chain Armor
	[915]="0:0:12:1:20:::1:0:", -- Red Silk Bandana
	[916]="0:0:12:1:1:::1:0:", -- A Torn Journal Page
	[918]="0:1250:1:1:1:Bag::1:0:", -- Deviate Hide Pack
	[920]="0:2821:2:2:1:OneHandMace::1:0:", -- Wicked Spiked Mace
	[921]="0:0:12:1:1:::1:0:", -- A Faded Journal Page
	[922]="12039:2407:2:1:1:TwoHandSword::1:0:225,1287,1289,1441,3021,3331,3361,3539,4086,4171,4203,4569,5120,11137,16714", -- Dacian Falx
	[923]="8744:1748:2:1:1:OneHandSword::1:0:225,1287,1289,1441,3021,3331,3361,3539,4086,4171,4203,4569,5120,11137,16714", -- Longsword
	[924]="10973:2194:2:1:1:TwoHandMace::1:0:225,1287,1289,1348,1441,3020,3360,3539,4086,4203,4233,4602,5121,11137,16765,17412", -- Maul
	[925]="7797:1559:2:1:1:OneHandMace::1:0:225,1287,1289,1348,1441,3020,3360,3539,4086,4203,4233,4602,5121,11137,16765,17412", -- Flail
	[926]="9785:1957:2:1:1:TwoHandAxe::1:0:225,1287,1289,1441,3019,3409,3539,4086,4203,4232,4601,5119,11137,16714", -- Battle Axe
	[927]="6954:1390:2:1:1:OneHandAxe::1:0:225,1287,1289,1441,3019,3409,3539,4086,4203,4232,4601,5119,11137,16714", -- Double Axe
	[928]="9860:1972:2:1:1:Stave::1:0:225,1287,1289,1348,1441,3020,3360,3409,3539,4086,4203,4233,4602,5121,11137,16765,17412,19238", -- Long Staff
	[929]="300:75:0:1:5:Potion:197:1:1:1307,1453,1457,2481,2805,3134,3534,3956,4083,4878,8305,13476,18810", -- Healing Potion
	[932]="0:637:1:1:1:Bag::1:0:", -- Fel Steed Saddlebags
	[933]="0:2500:1:1:1:Bag::1:0:", -- Large Rucksack
	[934]="0:10682:2:3:1:OneHandAxe::1:0:", -- Stalvan's Reaper
	[935]="0:1742:2:3:1:OneHandSword::1:0:", -- Night Watch Shortsword
	[936]="0:11620:2:3:1:OneHandMace::1:0:", -- Midnight Mace
	[937]="0:14577:2:3:1:Stave::1:0:", -- Black Duskwood Staff
	[938]="0:0:12:1:1:::1:0:", -- Muddy Journal Pages
	[939]="0:0:12:1:1:::1:0:", -- A Bloodstained Journal Page
	[940]="0:12566:4:4:1:Cloth::1:0:", -- Robes of Insight
	[942]="0:4500:4:4:1:Ring::1:0:", -- Freezing Band
	[943]="0:42863:2:4:1:Stave::1:0:", -- Warden Staff
	[944]="0:80153:2:4:1:Stave::1:0:", -- Elemental Mage Staff
	[954]="200:50:0:1:20:Scroll::1:1:958,1316,2805,4581,4878,13476,14847,16224", -- Scroll of Strength
	[955]="150:37:0:1:20:Scroll::1:1:958,1316,4581,14847,16224", -- Scroll of Intellect
	[957]="0:0:12:1:1:::1:0:", -- William's Shipment
	[961]="0:2:0:1:10:FoodDrink::1:0:", -- Healing Herb
	[962]="0:0:12:1:1:::1:0:", -- Pork Belly Pie
	[981]="0:0:12:1:1:::1:0:", -- Bernice's Necklace
	[983]="0:21:4:1:1:Cloth::1:0:", -- Red Linen Sash
	[1006]="0:0:12:1:1:::1:0:", -- Brass Collar
	[1008]="0:144:2:1:1:OneHandSword::1:0:", -- Well-used Sword
	[1009]="0:490:2:2:1:OneHandMace::1:0:", -- Compact Hammer
	[1010]="0:99:2:1:1:Stave::1:0:", -- Gnarled Short Staff
	[1011]="0:80:2:1:1:OneHandAxe::1:0:", -- Sharp Axe
	[1013]="0:0:12:1:20:::1:0:", -- Iron Rivet
	[1015]="0:24:7:1:10:Meat:185:1:0:", -- Lean Wolf Flank
	[1017]="0:100:0:1:20:FoodDrink::1:0:", -- Seasoned Wolf Kabob
	[1019]="0:0:12:1:20:::1:0:", -- Red Linen Bandana
	[1074]="0:491:15:0:5:Junk::1:0:", -- Hard Spider Leg Tip
	[1075]="0:0:12:1:20:::1:0:", -- Shadowhide Pendant
	[1076]="0:650:4:2:1:Ring::1:0:", -- Defias Renegade Ring
	[1077]="0:25:4:2:1:Ring::1:0:", -- Defias Mage Ring
	[1080]="0:78:7:1:10:Meat:185:1:0:", -- Tough Condor Meat
	[1081]="0:50:7:1:10:Meat:185:1:0:", -- Crisp Spider Meat
	[1082]="0:150:0:1:20:FoodDrink::1:0:", -- Redridge Goulash
	[1083]="0:0:12:1:20:::1:0:", -- Glyph of Azora
	[1113]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Bread
	[1114]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Rye
	[1116]="0:1250:4:2:1:Ring::1:0:", -- Ring of Pure Silver
	[1121]="0:1075:4:3:1:Leather::1:0:", -- Feet of the Lynx
	[1127]="0:25:0:1:10:Consumable::1:0:", -- Flash Bundle
	[1129]="0:0:12:1:20:::1:0:", -- Ghoul Fang
	[1130]="0:0:12:1:20:::1:0:", -- Vial of Spider Venom
	[1131]="0:1136:4:2:1:OffHandFrill::1:0:", -- Totem of Infliction
	[1132]="100000:0:15:3:1:Mount::1:0:3362", -- Horn of the Timber Wolf
	[1154]="0:102:4:1:1:Mail::1:0:", -- Belt of the People's Militia
	[1155]="0:5954:2:3:1:Stave::1:0:", -- Rod of the Sleepwalker
	[1156]="0:812:4:3:1:Ring::1:0:", -- Lavishly Jeweled Ring
	[1158]="0:146:2:1:1:OneHandMace::1:0:", -- Solid Metal Club
	[1159]="0:32:2:1:1:Stave::1:0:", -- Militia Quarterstaff
	[1161]="0:25:2:1:1:OneHandSword::1:0:", -- Militia Shortsword
	[1166]="0:16:4:1:1:Shield::1:0:", -- Dented Buckler
	[1167]="0:96:4:1:1:Shield::1:0:", -- Small Targe
	[1168]="0:42296:4:4:1:Shield::1:0:", -- Skullflame Shield
	[1169]="0:18815:4:4:1:Shield::1:0:", -- Blackskull Shield
	[1171]="0:55:4:1:1:Cloth::1:0:", -- Well-stitched Robe
	[1172]="0:968:4:2:1:OffHandFrill::1:0:", -- Grayson's Torch
	[1173]="0:52:4:1:1:Leather::1:0:", -- Weather-worn Boots
	[1175]="0:28:15:0:1:Junk::1:0:", -- A Gold Tooth
	[1177]="0:3:0:1:10:Other::1:0:", -- Oil of Olaf
	[1178]="0:7:0:1:20:Other::1:0:", -- Explosive Rocket
	[1179]="125:6:0:1:20:FoodDrink:185:5:0:227,258,274,295,465,491,734,791,955,982,1237,1247,1285,1328,1448,1452,1464,1682,1685,1697,2140,2303,2352,2364,2366,2388,2401,2803,2806,2832,3086,3298,3313,3411,3481,3498,3541,3546,3577,3621,3689,3708,3881,3882,3883,3884,3934,3937,3959,3961,3962,4082,4084,4167,4169,4181,4182,4190,4191,4192,4195,4266,4554,4555,4571,4782,4875,4876,4879,4893,4981,5111,5112,5140,5611,5620,5688,5814,5871,6091,6272,6495,6727,6734,6735,6736,6737,6738,6739,6740,6741,6746,6747,6790,6791,6807,6928,6929,6930,7485,7714,7731,7733,7736,7737,7744,7941,7942,7943,8125,8137,8139,8143,8150,8152,8362,8931,9356,9501,11038,11103,11106,11116,11118,11187,11287,12019,12021,12026,12027,12196,12959,12960,14371,14624,14731,15174,15397,15433,16187,16191,16256,16443,16444,16458,16542,16553,16618,16732,16739,17421,17489,17553,17630,17656,18810,18811,19182,19617,21145,23573,23995,24208,24834,24934,24993,25012,25020,25052,25089,29291", -- Ice Cold Milk
	[1180]="150:37:0:1:20:Scroll::1:1:958,1316,4581,14847,16224", -- Scroll of Stamina
	[1181]="100:25:0:1:20:Scroll::1:1:958,1316,4581,14847,16224", -- Scroll of Spirit
	[1182]="0:44:4:1:1:Mail::1:0:", -- Brass-studded Bracers
	[1183]="0:29:4:1:1:Cloth::1:0:", -- Elastic Wristguards
	[1187]="0:1081:15:2:1:CombatPet::1:0:", -- Spiked Collar
	[1189]="0:625:4:2:1:Ring::1:0:", -- Overseer's Ring
	[1190]="0:418:4:2:1:Cloak::1:0:", -- Overseer's Cloak
	[1191]="0:82:0:1:1:Consumable::1:0:", -- Bag of Marbles
	[1193]="0:355:4:1:1:Shield::1:0:", -- Banded Buckler
	[1194]="104:20:2:1:1:TwoHandSword::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919", -- Bastard Sword
	[1195]="0:47:2:1:1:TwoHandMace::1:0:", -- Kobold Mining Shovel
	[1196]="2214:442:2:1:1:TwoHandAxe::1:0:1287,1289,2997,3019,3314,3409,3479,3534,3658,4183,4203,4231,4232,4557,4601,5103,5119,16714", -- Tabar
	[1197]="2667:533:2:1:1:TwoHandMace::1:0:222,1287,1289,1348,2840,2997,3020,3314,3360,3479,3534,3658,4183,4203,4231,4233,4557,4602,5103,5121,16765,17412", -- Giant Mace
	[1198]="2677:535:2:1:1:TwoHandSword::1:0:1287,1289,2997,3021,3314,3331,3361,3479,3534,3658,4171,4183,4203,4231,4557,4569,5103,5120,16714", -- Claymore
	[1200]="82:16:4:1:1:Shield::1:0:2116,3075,3161,4559,16693", -- Large Wooden Shield
	[1201]="473:94:4:1:1:Shield::1:0:1249,2046,3613,4240,5106,16762,17930", -- Dull Heater Shield
	[1202]="1839:367:4:1:1:Shield::1:0:3319,3528,4187,4559,4560,5107,8360,16693,16762", -- Wall Shield
	[1203]="0:23505:4:3:1:Shield::1:0:", -- Aegis of Stormwind
	[1204]="0:12577:4:4:1:Shield::1:0:", -- The Green Tower
	[1205]="500:25:0:1:20:FoodDrink::5:0:227,258,274,295,465,734,791,955,982,1149,1237,1247,1285,1328,1448,1452,1464,1697,2084,2303,2352,2364,2366,2388,2401,2803,2806,2808,2820,2832,2908,3086,3298,3313,3350,3411,3498,3541,3546,3577,3621,3689,3708,3881,3882,3883,3884,3934,3937,3959,3961,3962,4082,4084,4167,4169,4170,4181,4190,4191,4192,4195,4241,4266,4554,4555,4571,4782,4875,4876,4879,4893,4896,4981,5101,5111,5112,5134,5140,5611,5620,5688,5814,5871,6091,6272,6495,6727,6734,6735,6736,6737,6738,6739,6740,6741,6746,6747,6790,6791,6807,6928,6929,6930,7485,7714,7731,7733,7736,7737,7744,7941,7942,7943,8125,8137,8139,8143,8150,8152,8362,8931,9356,9501,11038,11103,11106,11116,11118,11187,11287,11555,12019,12021,12026,12027,12196,12246,12959,12960,14371,14624,14731,14963,14964,15124,15125,15174,15397,15433,16191,16256,16443,16458,16542,16553,16618,16732,16739,17489,17553,17630,17656,18811,19182,19617,21145,23573,23995,24208,24834,24934,24993,25012,25020,25052,25089,29291", -- Melon Juice
	[1206]="0:400:3:2:20:GemSimple:164,202,755,165:1:0:", -- Moss Agate
	[1207]="0:9892:2:2:1:OneHandMace::1:0:", -- Murphstar
	[1208]="0:0:12:1:1:::1:0:", -- Maybell's Love Letter
	[1210]="0:250:3:2:20:GemSimple:164,202,755:1:0:", -- Shadowgem
	[1211]="0:347:4:2:1:Leather::1:0:", -- Gnoll War Harness
	[1212]="0:21:15:0:5:Junk::1:0:", -- Gnoll Spittle
	[1213]="0:87:4:1:1:Leather::1:0:", -- Gnoll Kindred Bracers
	[1214]="0:930:2:2:1:OneHandMace::1:0:", -- Gnoll Punisher
	[1215]="0:469:4:2:1:Leather::1:0:", -- Support Girdle
	[1217]="0:0:12:1:1:::1:0:", -- Unknown Reward
	[1218]="0:2064:2:2:1:TwoHandMace::1:0:", -- Heavy Gnoll War Club
	[1219]="0:823:2:2:1:OneHandSword::1:0:", -- Redridge Machete
	[1220]="0:1807:2:2:1:TwoHandAxe::1:0:", -- Lupine Axe
	[1221]="0:0:12:1:20:::1:0:", -- Underbelly Whelp Scale
	[1251]="0:8:0:1:20:Bandage::1:0:", -- Linen Bandage
	[1252]="0:0:12:1:1:::1:0:", -- Gramma Stonefield's Note
	[1254]="0:0:4:1:1:Miscellaneous::1:0:", -- Lesser Firestone (DEPRECATED)
	[1256]="0:0:12:1:20:::1:0:", -- Crystal Kelp Frond
	[1257]="0:0:12:1:1:::1:0:", -- Invisibility Liquor
	[1260]="0:0:12:1:1:::1:0:", -- Tharil'zun's Head
	[1261]="0:0:12:1:20:::1:0:", -- Midnight Orb
	[1262]="0:111:0:1:1:Consumable::1:0:", -- Keg of Thunderbrew Lager
	[1263]="0:79064:2:4:1:TwoHandAxe::1:0:", -- Brain Hacker
	[1264]="0:3671:2:2:1:TwoHandMace::1:0:", -- Headbasher
	[1265]="0:11775:2:3:1:OneHandSword::1:0:", -- Scorpion Sting
	[1270]="0:213:4:2:1:Cloak::1:0:", -- Finely Woven Cloak
	[1273]="0:1656:4:2:1:Mail::1:0:", -- Forest Chain
	[1274]="0:8:12:1:20:::1:0:", -- Hops
	[1275]="0:1668:4:2:1:Mail::1:0:", -- Deputy Chain Coat
	[1276]="0:2220:4:2:1:Shield::1:0:", -- Fire Hardened Buckler
	[1280]="0:3696:4:2:1:Leather::1:0:", -- Cloaked Hood
	[1282]="0:2825:4:2:1:Mail::1:0:", -- Sparkmetal Coif
	[1283]="0:0:12:1:1:::1:0:", -- Verner's Note
	[1284]="0:0:12:1:1:::1:0:", -- Crate of Horseshoes
	[1287]="0:703:2:2:1:Dagger::1:0:", -- Giant Tarantula Fang
	[1288]="0:185:7:1:5:Other:171,129:1:0:", -- Large Venom Sac
	[1292]="0:3300:2:3:1:OneHandAxe::1:0:", -- Butcher's Cleaver
	[1293]="0:0:12:1:1:::1:0:", -- The State of Lakeshire
	[1294]="0:0:12:1:1:::1:0:", -- The General's Response
	[1296]="0:1681:2:2:1:OneHandMace::1:0:", -- Blackrock Mace
	[1297]="0:2038:4:2:1:Cloth::1:0:", -- Robes of the Shadowcaster
	[1299]="0:390:4:2:1:Cloth::1:0:", -- Lesser Belt of the Spire
	[1300]="0:1854:2:2:1:Stave::1:0:", -- Lesser Staff of the Spire
	[1302]="0:262:4:2:1:Leather::1:0:", -- Black Whelp Gloves
	[1303]="0:418:4:2:1:Mail::1:0:", -- Bridgeworker's Gloves
	[1304]="0:279:4:2:1:Cloth::1:0:", -- Riding Gloves
	[1306]="0:352:4:2:1:Leather::1:0:", -- Wolfmane Wristguards
	[1307]="0:0:12:1:1:::1:0:", -- Gold Pickup Schedule
	[1309]="0:0:12:1:1:::1:0:", -- Oslow's Toolbox
	[1310]="0:715:4:2:1:Leather::1:0:", -- Smith's Trousers
	[1314]="0:362:4:2:1:Leather::1:0:", -- Ghoul Fingers
	[1315]="0:13000:4:4:1:Amulet::1:0:", -- Lei of Lilies
	[1317]="0:3500:2:2:1:Stave::1:0:", -- Hardened Root Staff
	[1318]="0:3066:2:3:1:TwoHandAxe::1:0:", -- Night Reaver
	[1319]="0:462:4:2:1:Ring::1:0:", -- Ring of Iron Will
	[1322]="0:68:0:1:10:Consumable::1:0:", -- Fishliver Oil
	[1325]="0:0:12:1:1:::1:0:", -- Daffodil Bouquet
	[1326]="0:10:0:1:20:FoodDrink::1:0:", -- Sauteed Sunfish
	[1327]="0:0:12:1:1:::1:0:", -- Wiley's Note
	[1349]="0:0:12:1:1:::1:0:", -- Abercrombie's Crate
	[1351]="0:768:4:2:1:Cloth::1:0:", -- Fingerbone Bracers
	[1353]="0:0:12:1:1:::1:0:", -- Shaw's Report
	[1355]="0:201:4:2:1:Cloak::1:0:", -- Buckskin Cape
	[1357]="0:0:12:1:1:::1:0:", -- Captain Sanders' Treasure Map
	[1358]="0:0:12:1:1:::1:0:", -- A Clue to Sanders' Treasure
	[1359]="0:19:4:1:1:Leather::1:0:", -- Lion-stamped Gloves
	[1360]="0:42:4:1:1:Mail::1:0:", -- Stormwind Chain Gloves
	[1361]="0:0:12:1:1:::1:0:", -- Another Clue to Sanders' Treasure
	[1362]="0:0:12:1:1:::1:0:", -- Final Clue to Sanders' Treasure
	[1364]="0:8:4:0:1:Leather::1:0:", -- Ragged Leather Vest
	[1366]="0:2:4:0:1:Leather::1:0:", -- Ragged Leather Pants
	[1367]="0:2:4:0:1:Leather::1:0:", -- Ragged Leather Boots
	[1368]="0:2:4:0:1:Leather::1:0:", -- Ragged Leather Gloves
	[1369]="0:4:4:0:1:Leather::1:0:", -- Ragged Leather Belt
	[1370]="0:2:4:0:1:Leather::1:0:", -- Ragged Leather Bracers
	[1372]="0:2:4:0:1:Cloak::1:0:", -- Ragged Cloak
	[1374]="0:3:4:0:1:Cloth::1:0:", -- Frayed Shoes
	[1376]="0:4:4:0:1:Cloak::1:0:", -- Frayed Cloak
	[1377]="0:1:4:0:1:Cloth::1:0:", -- Frayed Gloves
	[1378]="0:1:4:0:1:Cloth::1:0:", -- Frayed Pants
	[1380]="0:4:4:0:1:Cloth::1:0:", -- Frayed Robe
	[1381]="0:0:12:1:1:::1:0:", -- A Mysterious Message
	[1382]="0:24:2:1:1:OneHandMace::1:0:", -- Rock Mace
	[1383]="0:25:2:1:1:OneHandAxe::1:0:", -- Stone Tomahawk
	[1384]="0:11:2:1:1:OneHandSword::1:0:", -- Dull Blade
	[1386]="0:32:2:1:1:TwoHandAxe::1:0:", -- Thistlewood Axe
	[1387]="0:1578:2:2:1:TwoHandSword::1:0:", -- Ghoulfang
	[1388]="0:14:2:1:1:Stave::1:0:", -- Crooked Staff
	[1389]="0:58:2:1:1:OneHandMace::1:0:", -- Kobold Mining Mallet
	[1391]="0:1392:2:2:1:Stave::1:0:", -- Riverpaw Mystic Staff
	[1394]="0:740:2:2:1:OneHandMace::1:0:", -- Driftwood Club
	[1395]="5:1:4:0:1:Cloth::1:0:18672", -- Apprentice's Pants
	[1396]="4:1:4:0:1:Cloth::1:0:18672", -- Acolyte's Pants
	[1399]="0:12:0:1:20:Other::1:0:", -- Magic Candle
	[1401]="0:14:0:1:20:FoodDrink::1:0:", -- Green Tea Leaf
	[1404]="0:10306:4:2:1:Trinket::1:0:", -- Tidal Charm
	[1405]="0:1184:2:2:1:Stave::1:0:", -- Foamspittle Staff
	[1406]="0:2079:2:2:1:Polearm::1:0:", -- Pearl-encrusted Spear
	[1407]="0:0:12:1:1:::1:0:", -- Solomon's Plea to Westfall
	[1408]="0:0:12:1:1:::1:0:", -- Stoutmantle's Response to Solomon
	[1409]="0:0:12:1:1:::1:0:", -- Solomon's Plea to Darkshire
	[1410]="0:0:12:1:1:::1:0:", -- Ebonlocke's Response to Solomon
	[1411]="0:68:2:0:1:Stave::1:0:", -- Withered Staff
	[1412]="0:49:2:0:1:TwoHandSword::1:0:", -- Crude Bastard Sword
	[1413]="0:55:2:0:1:OneHandSword::1:0:", -- Feeble Sword
	[1414]="0:97:2:0:1:TwoHandMace::1:0:", -- Cracked Sledge
	[1415]="0:72:2:0:1:OneHandMace::1:0:", -- Carpenter's Mallet
	[1416]="0:72:2:0:1:OneHandAxe::1:0:", -- Rusty Hatchet
	[1417]="0:65:2:0:1:TwoHandAxe::1:0:", -- Beaten Battle Axe
	[1418]="0:9:4:0:1:Leather::1:0:", -- Worn Leather Belt
	[1419]="0:19:4:0:1:Leather::1:0:", -- Worn Leather Boots
	[1420]="0:18:4:0:1:Leather::1:0:", -- Worn Leather Bracers
	[1421]="0:28:4:0:1:Cloak::1:0:", -- Worn Hide Cloak
	[1422]="0:6:4:0:1:Leather::1:0:", -- Worn Leather Gloves
	[1423]="0:19:4:0:1:Leather::1:0:", -- Worn Leather Pants
	[1425]="0:37:4:0:1:Leather::1:0:", -- Worn Leather Vest
	[1427]="0:29:4:0:1:Cloth::1:0:", -- Patchwork Shoes
	[1429]="0:7:4:0:1:Cloak::1:0:", -- Patchwork Cloak
	[1430]="0:7:4:0:1:Cloth::1:0:", -- Patchwork Gloves
	[1431]="0:20:4:0:1:Cloth::1:0:", -- Patchwork Pants
	[1433]="0:14:4:0:1:Cloth::1:0:", -- Patchwork Armor
	[1434]="0:43:0:1:20:Consumable::1:0:", -- Glowing Wax Stick
	[1436]="0:458:4:2:1:Leather::1:0:", -- Frontier Britches
	[1438]="0:70:4:1:1:Shield::1:0:", -- Warrior's Shield
	[1440]="0:1230:2:2:1:OneHandMace::1:0:", -- Gnoll Skull Basher
	[1443]="0:21125:4:4:1:Amulet::1:0:", -- Jeweled Amulet of Cainwyn
	[1445]="0:584:4:1:1:Mail::1:0:", -- Blackrock Pauldrons
	[1446]="0:568:4:2:1:Mail::1:0:", -- Blackrock Boots
	[1447]="0:22775:4:4:1:Ring::1:0:", -- Ring of Saviors
	[1448]="0:405:4:2:1:Mail::1:0:", -- Blackrock Gauntlets
	[1449]="0:1875:4:2:1:Ring::1:0:", -- Minor Channeling Ring
	[1451]="0:0:12:1:1:::1:0:", -- Bottle of Zombie Juice
	[1453]="0:0:12:1:1:::1:0:", -- Spectral Comb
	[1454]="0:3937:2:3:1:OneHandAxe::1:0:", -- Axe of the Enforcer
	[1455]="0:2931:2:2:1:TwoHandAxe::1:0:", -- Blackrock Champion's Axe
	[1457]="0:1850:2:2:1:OneHandMace::1:0:", -- Shadowhide Mace
	[1458]="0:2623:2:2:1:TwoHandMace::1:0:", -- Shadowhide Maul
	[1459]="0:2380:2:2:1:OneHandAxe::1:0:", -- Shadowhide Scalper
	[1460]="0:1768:2:2:1:TwoHandSword::1:0:", -- Shadowhide Two-handed Sword
	[1461]="0:3387:2:2:1:TwoHandAxe::1:0:", -- Slayer's Battle Axe
	[1462]="0:1306:4:2:1:Ring::1:0:", -- Ring of the Shadow
	[1464]="0:71:15:0:5:Junk::1:0:", -- Buzzard Talon
	[1465]="0:9825:2:2:1:Dagger::1:0:", -- Tigerbane
	[1467]="0:0:12:1:20:::1:0:", -- Spotted Sunfish
	[1468]="0:28:7:1:10:Meat:185:1:0:", -- Murloc Fin
	[1469]="0:1180:2:2:1:OneHandSword::1:0:", -- Scimitar of Atun
	[1470]="0:875:1:1:1:Bag::1:0:", -- Murloc Skin Bag
	[1473]="0:1497:2:2:1:Stave::1:0:", -- Riverside Staff
	[1475]="0:82:7:1:5:Other:129:1:0:", -- Small Venom Sac
	[1476]="0:6:15:0:5:Junk::1:0:", -- Snapped Spider Limb
	[1477]="350:87:0:1:20:Scroll::1:1:12246,14847", -- Scroll of Agility II
	[1478]="250:62:0:1:20:Scroll::1:1:1316,2805,4581,4878,13476", -- Scroll of Protection II
	[1479]="0:47:4:1:1:Cloth::1:0:", -- Salma's Oven Mitts
	[1480]="0:954:2:2:1:OneHandMace::1:0:", -- Fist of the People's Militia
	[1481]="0:3337:2:3:1:OneHandAxe::1:0:", -- Grimclaw
	[1482]="0:2964:2:3:1:OneHandSword::1:0:", -- Shadowfang
	[1483]="0:2025:2:3:1:OneHandMace::1:0:", -- Face Smasher
	[1484]="0:2922:2:3:1:Stave::1:0:", -- Witching Stave
	[1485]="0:1410:2:0:1:Polearm::1:0:", -- Pitchfork
	[1486]="0:1202:4:3:1:Cloth::1:0:", -- Tree Bark Jacket
	[1487]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Pumpernickel
	[1488]="0:3379:4:3:1:Mail::1:0:", -- Avenger's Armor
	[1489]="0:1553:4:3:1:Leather::1:0:", -- Gloomshroud Armor
	[1490]="0:8910:4:2:1:Trinket::1:0:", -- Guardian Talisman
	[1491]="0:2207:4:3:1:Ring::1:0:", -- Ring of Precision
	[1493]="0:3922:2:3:1:OneHandSword::1:0:", -- Heavy Marauder Scimitar
	[1495]="0:59:4:0:1:Cloth::1:0:", -- Calico Shoes
	[1497]="0:71:4:0:1:Cloak::1:0:", -- Calico Cloak
	[1498]="0:57:4:0:1:Cloth::1:0:", -- Calico Gloves
	[1499]="0:51:4:0:1:Cloth::1:0:", -- Calico Pants
	[1501]="0:80:4:0:1:Cloth::1:0:", -- Calico Tunic
	[1502]="0:60:4:0:1:Leather::1:0:", -- Warped Leather Belt
	[1503]="0:109:4:0:1:Leather::1:0:", -- Warped Leather Boots
	[1504]="0:32:4:0:1:Leather::1:0:", -- Warped Leather Bracers
	[1505]="0:48:4:0:1:Cloak::1:0:", -- Warped Cloak
	[1506]="0:51:4:0:1:Leather::1:0:", -- Warped Leather Gloves
	[1507]="0:123:4:0:1:Leather::1:0:", -- Warped Leather Pants
	[1509]="0:59:4:0:1:Leather::1:0:", -- Warped Leather Vest
	[1510]="0:150:2:0:1:OneHandMace::1:0:", -- Heavy Hammer
	[1511]="0:194:2:0:1:OneHandSword::1:0:", -- Commoner's Sword
	[1512]="0:194:2:0:1:TwoHandAxe::1:0:", -- Crude Battle Axe
	[1513]="0:293:2:0:1:TwoHandSword::1:0:", -- Old Greatsword
	[1514]="0:294:2:0:1:TwoHandMace::1:0:", -- Rusty Warhammer
	[1515]="0:196:2:0:1:Stave::1:0:", -- Rough Wooden Staff
	[1516]="0:237:2:0:1:OneHandAxe::1:0:", -- Worn Hatchet
	[1518]="0:0:12:1:1:::1:0:", -- Ghost Hair Comb
	[1519]="0:0:12:1:20:::1:0:", -- Bloodscalp Ear
	[1520]="0:71:15:0:5:Junk::1:0:", -- Troll Sweat
	[1521]="0:19205:2:2:1:TwoHandAxe::1:0:", -- Lumbering Ogre Axe
	[1522]="0:10224:2:2:1:Polearm::1:0:", -- Headhunting Spear
	[1523]="0:10261:2:2:1:TwoHandMace::1:0:", -- Huge Stone Club
	[1524]="0:0:12:1:20:::1:0:", -- Skullsplitter Tusk
	[1528]="0:0:12:1:20:::1:0:", -- Handful of Oats
	[1529]="0:700:3:2:20:GemSimple:164,202,755,165,197:1:0:", -- Jade
	[1532]="0:0:12:1:20:::1:0:", -- Shrunken Head
	[1537]="0:62:1:1:1:Bag::1:0:", -- Old Blanchy's Feed Pouch
	[1539]="0:1572:2:2:1:Stave::1:0:", -- Gnarled Hermit's Staff
	[1547]="0:2795:4:2:1:Shield::1:0:", -- Shield of the Faith
	[1557]="0:919:4:2:1:Shield::1:0:", -- Buckler of the Seas
	[1560]="0:513:4:2:1:Cloth::1:0:", -- Bluegill Sandals
	[1561]="0:268:4:2:1:Cloth::1:0:", -- Harvester's Robe
	[1566]="0:1132:2:2:1:TwoHandSword::1:0:", -- Edge of the People's Militia
	[1596]="0:0:12:1:1:::1:0:", -- Ghost Hair Thread
	[1598]="0:0:12:1:20:::1:0:", -- Rot Blossom
	[1602]="0:11685:2:3:1:OneHandAxe::1:0:", -- Sickle Axe
	[1604]="0:19464:2:2:1:TwoHandSword::1:0:", -- Chromatic Sword
	[1607]="0:43420:2:3:1:Stave::1:0:", -- Soulkeeper
	[1608]="0:18940:2:2:1:OneHandMace::1:0:", -- Skullcrusher Mace
	[1613]="0:19139:2:2:1:Stave::1:0:", -- Spiritchaser Staff
	[1624]="0:6172:4:2:1:Mail::1:0:", -- Skullsplitter Helm
	[1625]="0:14754:2:2:1:TwoHandSword::1:0:", -- Exquisite Flamberge
	[1630]="0:66:15:0:5:Junk::1:0:", -- Broken Electro-lantern
	[1637]="0:0:12:1:1:::1:0:", -- Letter to Ello
	[1639]="0:28460:2:2:1:TwoHandAxe::1:0:", -- Grinning Axe
	[1640]="0:15637:2:2:1:TwoHandAxe::1:0:", -- Monstrous War Axe
	[1645]="2000:100:0:1:20:FoodDrink::5:0:258,274,295,465,734,955,982,1149,1237,1247,1285,1328,1464,1697,2084,2303,2352,2364,2366,2388,2401,2803,2806,2808,2820,2832,2908,3086,3298,3313,3350,3411,3541,3546,3577,3621,3689,3708,3881,3882,3883,3884,3934,3937,3959,3961,4167,4169,4170,4181,4190,4191,4192,4195,4241,4266,4554,4555,4571,4782,4875,4879,4893,4896,4981,5101,5111,5112,5134,5140,5611,5620,5688,5814,5871,6091,6272,6495,6727,6734,6735,6736,6737,6738,6739,6740,6741,6746,6747,6790,6791,6807,6928,6929,6930,7485,7714,7731,7733,7736,7737,7744,7941,7942,7943,8125,8137,8139,8143,8150,8152,8362,8931,9356,9501,11038,11103,11106,11116,11118,11187,11287,11555,12019,12021,12026,12027,12196,12246,12959,12960,14371,14624,14731,14963,14964,15124,15125,15174,15397,15433,16191,16256,16443,16458,16542,16553,16618,16732,16739,17553,17630,17656,19182,19617,21145,23573,23995,24208,24834,24934,24993,25012,25020,25052,25089,29291", -- Moonberry Juice
	[1652]="0:5000:1:1:1:Bag::1:0:", -- Sturdy Lunchbox
	[1656]="0:0:12:1:1:::1:0:", -- Translated Letter
	[1659]="0:2136:4:2:1:Cloth::1:0:", -- Engineering Gloves
	[1664]="0:14695:2:2:1:Stave::1:0:", -- Spellforce Rod
	[1677]="0:10093:4:2:1:Mail::1:0:", -- Drake-scale Vest
	[1678]="0:4581:4:3:1:Mail::1:0:", -- Black Ogre Kickers
	[1679]="0:9635:2:2:1:TwoHandMace::1:0:", -- Korg Bat
	[1680]="0:18234:2:2:1:TwoHandAxe::1:0:", -- Headchopper
	[1685]="0:6250:1:1:1:Bag::1:0:", -- Troll-hide Bag
	[1686]="0:733:15:0:10:Junk::1:0:", -- Bristly Whisker
	[1687]="0:243:15:0:5:Junk::1:0:", -- Retractable Claw
	[1688]="0:806:15:0:5:Junk::1:0:", -- Long Soft Tail
	[1696]="0:606:15:0:5:Junk::1:0:", -- Curved Raptor Talon
	[1697]="0:445:15:0:10:Junk::1:0:", -- Keen Raptor Tooth
	[1701]="0:376:15:0:5:Junk::1:0:", -- Curved Basilisk Claw
	[1702]="0:320:15:0:5:Junk::1:0:", -- Intact Basilisk Spine
	[1703]="0:81:0:1:10:Other::1:0:", -- Crystal Basilisk Spine
	[1705]="0:600:3:2:20:GemSimple:164,202,755:1:0:", -- Lesser Moonstone
	[1706]="0:86:15:0:10:Junk::1:0:", -- Azuredeep Shards
	[1707]="1000:62:0:1:20:FoodDrink::5:0:295,465,483,1237,2352,2364,3298,3546,4782,4891,4894,4981,5620,6746,6790,6930,9501,11106,11116,16553,17630,18929,23521,23604,24934", -- Stormwind Brie
	[1708]="1000:50:0:1:20:FoodDrink::5:0:258,274,295,465,734,955,982,1149,1237,1247,1285,1328,1464,1697,2084,2303,2352,2364,2366,2388,2401,2803,2806,2808,2820,2832,2908,3086,3298,3313,3350,3411,3541,3546,3577,3621,3689,3708,3881,3882,3883,3884,3934,3937,3959,3961,4167,4169,4170,4181,4190,4191,4192,4195,4241,4266,4554,4555,4571,4782,4875,4879,4893,4896,4981,5101,5111,5112,5134,5140,5611,5620,5688,5814,5871,6091,6272,6495,6727,6734,6735,6736,6737,6738,6739,6740,6741,6746,6747,6790,6791,6807,6928,6929,6930,7485,7714,7731,7733,7736,7737,7744,7941,7942,7943,8125,8137,8139,8143,8150,8152,8362,8931,9356,9501,11038,11103,11106,11116,11118,11187,11287,11555,12019,12021,12026,12027,12196,12246,12959,12960,14371,14624,14731,14963,14964,15124,15125,15174,15397,15433,16191,16256,16443,16458,16542,16553,16618,16732,16739,17553,17630,17656,19182,19617,21145,23573,23995,24208,24834,24934,24993,25012,25020,25052,25089,29291", -- Sweet Nectar
	[1710]="500:125:0:1:5:Potion::1:1:2380,2480,2812,2848,12245", -- Greater Healing Potion
	[1711]="300:75:0:1:20:Scroll::1:1:1316,2805,4581,4878,12246,14847", -- Scroll of Stamina II
	[1712]="250:62:0:1:20:Scroll::1:1:1316,2805,4581,4878,13476", -- Scroll of Spirit II
	[1713]="0:5350:4:3:1:Trinket::1:0:", -- Ankh of Life
	[1714]="0:2535:4:3:1:Amulet::1:0:", -- Necklace of Calisea
	[1715]="0:10301:4:3:1:Mail::1:0:", -- Polished Jazeraint Armor
	[1716]="0:5067:4:3:1:Cloth::1:0:", -- Robe of the Magi
	[1717]="0:3108:4:3:1:Mail::1:0:", -- Double Link Tunic
	[1718]="0:8040:4:3:1:Leather::1:0:", -- Basilisk Hide Pants
	[1720]="0:26209:2:3:1:Stave::1:0:", -- Tanglewood Staff
	[1721]="0:35815:2:3:1:OneHandMace::1:0:", -- Viking Warhammer
	[1722]="0:19407:2:3:1:TwoHandMace::1:0:", -- Thornstone Sledgehammer
	[1725]="0:5000:1:1:1:Bag::1:0:", -- Large Knapsack
	[1726]="0:12183:2:3:1:Polearm::1:0:", -- Poison-tipped Bone Spear
	[1727]="0:4562:2:3:1:OneHandSword::1:0:", -- Sword of Decay
	[1728]="0:72936:2:4:1:OneHandSword::1:0:", -- Teebu's Blazing Longsword
	[1729]="0:500:1:1:1:Bag::1:0:", -- Gunnysack of the Night Watch
	[1730]="0:48:4:0:1:Mail::1:0:", -- Worn Mail Belt
	[1731]="0:92:4:0:1:Mail::1:0:", -- Worn Mail Boots
	[1732]="0:73:4:0:1:Mail::1:0:", -- Worn Mail Bracers
	[1733]="0:88:4:0:1:Cloak::1:0:", -- Worn Cloak
	[1734]="0:39:4:0:1:Mail::1:0:", -- Worn Mail Gloves
	[1735]="0:89:4:0:1:Mail::1:0:", -- Worn Mail Pants
	[1737]="0:139:4:0:1:Mail::1:0:", -- Worn Mail Vest
	[1738]="0:147:4:0:1:Mail::1:0:", -- Laced Mail Belt
	[1739]="0:255:4:0:1:Mail::1:0:", -- Laced Mail Boots
	[1740]="0:97:4:0:1:Mail::1:0:", -- Laced Mail Bracers
	[1741]="0:112:4:0:1:Cloak::1:0:", -- Laced Cloak
	[1742]="0:129:4:0:1:Mail::1:0:", -- Laced Mail Gloves
	[1743]="0:299:4:0:1:Mail::1:0:", -- Laced Mail Pants
	[1744]="0:260:4:0:1:Mail::1:0:", -- Laced Mail Shoulderpads
	[1745]="0:198:4:0:1:Mail::1:0:", -- Laced Mail Vest
	[1746]="0:332:4:0:1:Mail::1:0:", -- Linked Chain Belt
	[1747]="0:302:4:0:1:Mail::1:0:", -- Linked Chain Boots
	[1748]="0:232:4:0:1:Mail::1:0:", -- Linked Chain Bracers
	[1749]="0:263:4:0:1:Cloak::1:0:", -- Linked Chain Cloak
	[1750]="0:298:4:0:1:Mail::1:0:", -- Linked Chain Gloves
	[1751]="0:676:4:0:1:Mail::1:0:", -- Linked Chain Pants
	[1752]="0:286:4:0:1:Mail::1:0:", -- Linked Chain Shoulderpads
	[1753]="0:439:4:0:1:Mail::1:0:", -- Linked Chain Vest
	[1754]="0:359:4:0:1:Mail::1:0:", -- Reinforced Chain Belt
	[1755]="0:597:4:0:1:Mail::1:0:", -- Reinforced Chain Boots
	[1756]="0:438:4:0:1:Mail::1:0:", -- Reinforced Chain Bracers
	[1757]="0:483:4:0:1:Cloak::1:0:", -- Reinforced Chain Cloak
	[1758]="0:534:4:0:1:Mail::1:0:", -- Reinforced Chain Gloves
	[1759]="0:732:4:0:1:Mail::1:0:", -- Reinforced Chain Pants
	[1760]="0:609:4:0:1:Mail::1:0:", -- Reinforced Chain Shoulderpads
	[1761]="0:892:4:0:1:Mail::1:0:", -- Reinforced Chain Vest
	[1764]="0:113:4:0:1:Cloth::1:0:", -- Canvas Shoes
	[1766]="0:131:4:0:1:Cloak::1:0:", -- Canvas Cloak
	[1767]="0:101:4:0:1:Cloth::1:0:", -- Canvas Gloves
	[1768]="0:217:4:0:1:Cloth::1:0:", -- Canvas Pants
	[1769]="0:163:4:0:1:Cloth::1:0:", -- Canvas Shoulderpads
	[1770]="0:143:4:0:1:Cloth::1:0:", -- Canvas Vest
	[1772]="0:247:4:0:1:Cloth::1:0:", -- Brocade Shoes
	[1774]="0:281:4:0:1:Cloak::1:0:", -- Brocade Cloak
	[1775]="0:212:4:0:1:Cloth::1:0:", -- Brocade Gloves
	[1776]="0:257:4:0:1:Cloth::1:0:", -- Brocade Pants
	[1777]="0:222:4:0:1:Cloth::1:0:", -- Brocade Shoulderpads
	[1778]="0:337:4:0:1:Cloth::1:0:", -- Brocade Vest
	[1780]="0:489:4:0:1:Cloth::1:0:", -- Cross-stitched Sandals
	[1782]="0:542:4:0:1:Cloak::1:0:", -- Cross-stitched Cloak
	[1783]="0:247:4:0:1:Cloth::1:0:", -- Cross-stitched Gloves
	[1784]="0:546:4:0:1:Cloth::1:0:", -- Cross-stitched Pants
	[1785]="0:464:4:0:1:Cloth::1:0:", -- Cross-stitched Shoulderpads
	[1786]="0:683:4:0:1:Cloth::1:0:", -- Cross-stitched Vest
	[1787]="0:102:4:0:1:Leather::1:0:", -- Patched Leather Belt
	[1788]="0:177:4:0:1:Leather::1:0:", -- Patched Leather Boots
	[1789]="0:136:4:0:1:Leather::1:0:", -- Patched Leather Bracers
	[1790]="0:93:4:0:1:Cloak::1:0:", -- Patched Cloak
	[1791]="0:90:4:0:1:Leather::1:0:", -- Patched Leather Gloves
	[1792]="0:208:4:0:1:Leather::1:0:", -- Patched Leather Pants
	[1793]="0:207:4:0:1:Leather::1:0:", -- Patched Leather Shoulderpads
	[1794]="0:277:4:0:1:Leather::1:0:", -- Patched Leather Jerkin
	[1795]="0:235:4:0:1:Leather::1:0:", -- Rawhide Belt
	[1796]="0:400:4:0:1:Leather::1:0:", -- Rawhide Boots
	[1797]="0:161:4:0:1:Leather::1:0:", -- Rawhide Bracers
	[1798]="0:223:4:0:1:Cloak::1:0:", -- Rawhide Cloak
	[1799]="0:211:4:0:1:Leather::1:0:", -- Rawhide Gloves
	[1800]="0:479:4:0:1:Leather::1:0:", -- Rawhide Pants
	[1801]="0:418:4:0:1:Leather::1:0:", -- Rawhide Shoulderpads
	[1802]="0:337:4:0:1:Leather::1:0:", -- Rawhide Tunic
	[1803]="0:465:4:0:1:Leather::1:0:", -- Tough Leather Belt
	[1804]="0:478:4:0:1:Leather::1:0:", -- Tough Leather Boots
	[1805]="0:351:4:0:1:Leather::1:0:", -- Tough Leather Bracers
	[1806]="0:466:4:0:1:Cloak::1:0:", -- Tough Cloak
	[1807]="0:388:4:0:1:Leather::1:0:", -- Tough Leather Gloves
	[1808]="0:856:4:0:1:Leather::1:0:", -- Tough Leather Pants
	[1809]="0:440:4:0:1:Leather::1:0:", -- Tough Leather Shoulderpads
	[1810]="0:648:4:0:1:Leather::1:0:", -- Tough Leather Armor
	[1811]="0:451:2:0:1:TwoHandSword::1:0:", -- Blunt Claymore
	[1812]="0:453:2:0:1:TwoHandAxe::1:0:", -- Short-handled Battle Axe
	[1813]="0:523:2:0:1:Stave::1:0:", -- Chipped Quarterstaff
	[1814]="0:603:2:0:1:TwoHandMace::1:0:", -- Battered Mallet
	[1815]="0:366:2:0:1:OneHandMace::1:0:", -- Ornamental Mace
	[1816]="0:486:2:0:1:OneHandAxe::1:0:", -- Unbalanced Axe
	[1817]="0:501:2:0:1:OneHandSword::1:0:", -- Stock Shortsword
	[1818]="0:1221:2:0:1:TwoHandSword::1:0:", -- Standard Claymore
	[1819]="0:768:2:0:1:OneHandAxe::1:0:", -- Gouging Pick
	[1820]="0:963:2:0:1:TwoHandMace::1:0:", -- Wooden Maul
	[1821]="0:988:2:0:1:OneHandSword::1:0:", -- Warped Blade
	[1822]="0:1096:2:0:1:Stave::1:0:", -- Cedar Walking Stick
	[1823]="0:779:2:0:1:OneHandMace::1:0:", -- Bludgeoning Cudgel
	[1824]="0:1104:2:0:1:TwoHandAxe::1:0:", -- Shiny War Axe
	[1825]="0:1548:2:0:1:OneHandMace::1:0:", -- Bulky Bludgeon
	[1826]="0:1765:2:0:1:TwoHandMace::1:0:", -- Rock Maul
	[1827]="0:1282:2:0:1:OneHandAxe::1:0:", -- Meat Cleaver
	[1828]="0:1609:2:0:1:TwoHandAxe::1:0:", -- Stone War Axe
	[1829]="0:1563:2:0:1:OneHandSword::1:0:", -- Short Cutlass
	[1830]="0:1783:2:0:1:TwoHandSword::1:0:", -- Long Bastard Sword
	[1831]="0:1790:2:0:1:Stave::1:0:", -- Oaken War Staff
	[1832]="0:362:4:2:1:Cloth::1:0:", -- Lucky Trousers
	[1835]="31:6:4:1:1:Leather::1:0:2113,3074,3160,4558", -- Dirty Leather Belt
	[1836]="31:6:4:1:1:Leather::1:0:2113,3074,3160,4558", -- Dirty Leather Bracers
	[1839]="185:37:4:1:1:Leather::1:0:74,896,1238,1295,3162,3532,3612,3953,4164,4236,5820,16747,17929", -- Rough Leather Belt
	[1840]="185:37:4:1:1:Leather::1:0:74,896,1238,1295,3162,3532,3612,3953,4164,4236,5820,16747,17929", -- Rough Leather Bracers
	[1843]="726:145:4:1:1:Leather::1:0:896,954,1295,1669,3093,3321,3483,3552,3684,3953,4164,4186,4236,4558,5108,5820,8359,10380,16691,16747", -- Tanned Leather Belt
	[1844]="728:145:4:1:1:Leather::1:0:896,954,1295,1669,3093,3321,3483,3552,3684,3953,4164,4186,4236,4558,5108,5820,8359,10380,16691,16747", -- Tanned Leather Bracers
	[1845]="877:175:4:1:1:Mail::1:0:167,1294,1362,3319,3483,3528,3553,4164,4177,4187,4560,5107,5812,5819,8360,11703,16625,16750", -- Chainmail Belt
	[1846]="881:176:4:1:1:Mail::1:0:167,1294,1362,3319,3483,3528,3553,4164,4177,4187,4560,5107,5812,5819,8360,11703,16625,16750", -- Chainmail Bracers
	[1849]="1388:277:4:1:1:Leather::1:0:1295,1695,3093,3097,3321,3492,3536,3953,4236,5783,5820,8359,16691,16747", -- Cured Leather Belt
	[1850]="1393:278:4:1:1:Leather::1:0:1295,1695,3093,3097,3321,3492,3536,3953,4236,5783,5820,8359,16691,16747", -- Cured Leather Bracers
	[1852]="1684:336:4:1:1:Mail::1:0:956,1294,1341,3319,3493,3543,3682,4177,5125,5812,5819,8360,16625,16750", -- Scalemail Bracers
	[1853]="1690:338:4:1:1:Mail::1:0:956,1294,1341,3319,3493,3543,3682,4177,5125,5812,5819,8360,16625,16750", -- Scalemail Belt
	[1875]="0:0:12:1:1:::1:0:", -- Thistlenettle's Badge
	[1893]="0:1775:2:2:1:TwoHandAxe::1:0:", -- Miner's Revenge
	[1894]="0:0:12:1:20:::1:0:", -- Miners' Union Card
	[1913]="0:148:2:1:1:OneHandMace::1:0:", -- Studded Blackjack
	[1917]="0:251:2:2:1:Dagger::1:0:", -- Jeweled Dagger
	[1922]="0:0:12:1:1:::1:0:", -- Supplies for Sven
	[1923]="0:0:12:1:1:::1:0:", -- Ambassador's Satchel
	[1925]="0:787:2:2:1:OneHandSword::1:0:", -- Defias Rapier
	[1926]="0:687:2:2:1:OneHandMace::1:0:", -- Weighted Sap
	[1927]="0:690:2:2:1:OneHandAxe::1:0:", -- Deadmines Cleaver
	[1928]="0:996:2:2:1:Stave::1:0:", -- Defias Mage Staff
	[1929]="0:434:4:2:1:Cloth::1:0:", -- Silk-threaded Trousers
	[1930]="0:327:4:2:1:Cloak::1:0:", -- Stonemason Cloak
	[1931]="0:0:12:1:1:::1:0:", -- Huge Gnoll Claw
	[1933]="0:905:2:2:1:Stave::1:0:", -- Staff of Conjuring
	[1934]="0:731:4:2:1:Leather::1:0:", -- Stonemason Trousers
	[1935]="0:2974:2:3:1:Dagger::1:0:", -- Assassin's Blade
	[1936]="0:1114:2:2:1:Dagger::1:0:", -- Goblin Screwdriver
	[1937]="0:2040:2:3:1:OneHandSword::1:0:", -- Buzz Saw
	[1938]="0:1962:2:2:1:OneHandMace::1:0:", -- Block Mallet
	[1939]="675:168:12:1:1:::1:0:465", -- Skin of Sweet Rum
	[1941]="815:203:12:1:1:::1:0:277", -- Cask of Merlot
	[1942]="1265:316:12:1:1:::1:0:274", -- Bottle of Moonshine
	[1943]="0:713:4:2:1:Mail::1:0:", -- Goblin Mail Leggings
	[1944]="0:259:4:2:1:Leather::1:0:", -- Metalworking Gloves
	[1945]="0:267:4:2:1:Leather::1:0:", -- Woodworking Gloves
	[1946]="0:0:12:1:1:::1:0:", -- Mary's Looking Glass
	[1951]="0:1258:2:2:1:OneHandSword::1:0:", -- Blackwater Cutlass
	[1955]="0:1573:4:2:1:Mail::1:0:", -- Dragonmaw Chain Boots
	[1956]="0:0:12:1:1:::1:0:", -- Faded Shadowhide Pendant
	[1958]="0:975:2:2:1:OneHandMace::1:0:", -- Petrified Shinbone
	[1959]="0:1223:2:2:1:TwoHandAxe::1:0:", -- Cold Iron Pick
	[1962]="0:0:12:1:1:::1:0:", -- Glowing Shadowhide Pendant
	[1965]="0:36:4:1:1:Leather::1:0:", -- White Wolf Gloves
	[1968]="0:0:12:1:1:::1:0:", -- Ogre's Monocle
	[1970]="0:120:0:1:10:Consumable::1:0:", -- Restoring Balm
	[1971]="0:0:12:1:1:::1:0:", -- Furlbrow's Deed
	[1972]="0:0:12:1:1:::1:0:", -- Westfall Deed
	[1973]="0:4618:4:3:1:Trinket::1:0:", -- Orb of Deception
	[1974]="0:464:4:3:1:Cloth::1:0:", -- Mindthrust Bracers
	[1975]="0:5744:2:3:1:TwoHandSword::1:0:", -- Pysan's Old Greatsword
	[1976]="0:6340:2:3:1:TwoHandMace::1:0:", -- Slaghammer
	[1978]="0:981:4:3:1:Leather::1:0:", -- Wolfclaw Gloves
	[1979]="0:23274:4:4:1:Shield::1:0:", -- Wall of the Dead
	[1980]="0:6200:4:4:1:Ring::1:0:", -- Underworld Band
	[1981]="0:14113:4:4:1:Mail::1:0:", -- Icemail Jerkin
	[1982]="0:29513:2:4:1:TwoHandSword::1:0:", -- Nightblade
	[1986]="0:14861:2:2:1:TwoHandSword::1:0:", -- Gutrender
	[1987]="0:0:12:1:1:::1:0:", -- Krazek's Fixed Pot
	[1988]="0:2852:4:2:1:Mail::1:0:", -- Chief Brigadier Gauntlets
	[1990]="0:10077:2:2:1:TwoHandMace::1:0:", -- Ballast Maul
	[1991]="0:8357:2:2:1:TwoHandMace::1:0:", -- Goblin Power Shovel
	[1992]="0:5468:4:3:1:OffHandFrill::1:0:", -- Swampchill Fetish
	[1993]="0:2100:4:2:1:Ring::1:0:", -- Ogremind Ring
	[1994]="0:16696:2:2:1:OneHandAxe::1:0:", -- Ebonclaw Reaver
	[1996]="0:1720:4:2:1:Ring::1:0:", -- Voodoo Band
	[1997]="0:2539:4:2:1:Cloth::1:0:", -- Pressed Felt Robe
	[1998]="0:7239:2:2:1:Stave::1:0:", -- Bloodscalp Channeling Staff
	[2000]="0:8827:2:2:1:TwoHandSword::1:0:", -- Archeus
	[2004]="0:0:12:1:1:::1:0:", -- Grelin Whitebeard's Journal
	[2005]="0:0:12:1:1:::1:0:", -- The First Troll Legend
	[2006]="0:0:12:1:1:::1:0:", -- The Second Troll Legend
	[2007]="0:0:12:1:1:::1:0:", -- The Third Troll Legend
	[2008]="0:0:12:1:1:::1:0:", -- The Fourth Troll Legend
	[2011]="0:3840:2:3:1:OneHandSword::1:0:", -- Twisted Sabre
	[2013]="0:3644:2:2:1:Stave::1:0:", -- Cryptbone Staff
	[2014]="0:4869:2:2:1:TwoHandSword::1:0:", -- Black Metal Greatsword
	[2015]="0:4443:2:2:1:TwoHandAxe::1:0:", -- Black Metal War Axe
	[2017]="0:895:4:2:1:Leather::1:0:", -- Glowing Leather Bracers
	[2018]="0:3269:2:2:1:OneHandSword::1:0:", -- Skeletal Longsword
	[2020]="0:1050:2:2:1:Dagger::1:0:", -- Hollowfang Blade
	[2021]="0:1025:4:2:1:Shield::1:0:", -- Green Carapace Shield
	[2024]="6079:1215:2:1:1:TwoHandSword::1:0:225,1287,1289,2997,3021,3331,3361,3491,4171,4203,4231,4557,4569,5103,5120,16714", -- Espadon
	[2025]="5305:1061:2:1:1:TwoHandAxe::1:0:225,1287,1289,2997,3019,3409,3491,4203,4231,4232,4557,4601,5103,5119,16714", -- Bearded Axe
	[2026]="6286:1257:2:1:1:TwoHandMace::1:0:225,1287,1289,1348,2997,3020,3360,3491,4203,4231,4233,4557,4602,5103,5121,16765,17412", -- Rock Hammer
	[2027]="3816:763:2:1:1:OneHandSword::1:0:225,1287,1289,2997,3021,3331,3361,3491,4171,4203,4231,4557,4569,5103,5120,16714", -- Scimitar
	[2028]="5065:1013:2:1:1:OneHandMace::1:0:225,1287,1289,1348,2997,3020,3360,3491,4203,4231,4233,4557,4602,5103,5121,16765,17412", -- Hammer
	[2029]="4420:884:2:1:1:OneHandAxe::1:0:225,1287,1289,2997,3019,3409,3491,4203,4231,4232,4557,4601,5103,5119,16714", -- Cleaver
	[2030]="5545:1109:2:1:1:Stave::1:0:225,1287,1289,1348,2997,3020,3360,3409,3491,4203,4231,4233,4557,4602,5103,5121,16765,17412,19238", -- Gnarled Staff
	[2032]="0:1665:4:2:1:Cloth::1:0:", -- Gallan Cuffs
	[2033]="0:967:4:2:1:Leather::1:0:", -- Ambassador's Boots
	[2034]="0:1035:4:2:1:Cloth::1:0:", -- Scholarly Robes
	[2035]="0:2300:2:2:1:OneHandSword::1:0:", -- Sword of the Night Sky
	[2036]="0:258:4:2:1:Leather::1:0:", -- Dusty Mining Gloves
	[2037]="0:469:4:2:1:Mail::1:0:", -- Tunneler's Boots
	[2039]="0:750:4:3:1:Ring::1:0:", -- Plains Ring
	[2040]="0:15296:4:3:1:Shield::1:0:", -- Troll Protector
	[2041]="0:1412:4:3:1:Leather::1:0:", -- Tunic of Westfall
	[2042]="0:3639:2:3:1:Stave::1:0:", -- Staff of Westfall
	[2043]="0:1500:4:3:1:Ring::1:0:", -- Ring of Forlorn Spirits
	[2044]="0:8829:2:3:1:OneHandAxe::1:0:", -- Crescent of Forlorn Spirits
	[2046]="0:2461:2:2:1:OneHandSword::1:0:", -- Bluegill Kukri
	[2047]="0:26:2:1:1:OneHandAxe::1:0:", -- Anvilmar Hand Axe
	[2048]="0:26:2:1:1:OneHandMace::1:0:", -- Anvilmar Hammer
	[2054]="0:16:2:1:1:OneHandAxe::1:0:", -- Trogg Hand Axe
	[2055]="0:16:2:1:1:OneHandMace::1:0:", -- Small Wooden Hammer
	[2057]="0:16:2:1:1:OneHandSword::1:0:", -- Pitted Defias Shortsword
	[2058]="0:4197:2:2:1:TwoHandMace::1:0:", -- Kazon's Maul
	[2059]="0:863:4:3:1:Cloak::1:0:", -- Sentry Cloak
	[2064]="0:191:2:1:1:OneHandMace::1:0:", -- Trogg Club
	[2065]="0:113:2:1:1:OneHandSword::1:0:", -- Rockjaw Blade
	[2066]="0:81:2:1:1:OneHandAxe::1:0:", -- Skull Hatchet
	[2067]="0:186:2:1:1:Stave::1:0:", -- Frostbit Staff
	[2069]="0:122:4:1:1:Leather::1:0:", -- Black Bear Hide Vest
	[2070]="25:1:0:1:20:FoodDrink::5:0:295,465,483,1237,2352,2364,3298,3546,4782,4891,4894,4981,5620,6746,6790,6930,9501,11106,11116,16553,17630,18929,23521,23604,24934", -- Darnassian Bleu
	[2072]="0:4414:2:2:1:Stave::1:0:", -- Dwarven Magestaff
	[2073]="0:742:2:2:1:OneHandAxe::1:0:", -- Dwarven Hatchet
	[2074]="0:1054:2:2:1:OneHandSword::1:0:", -- Solid Shortblade
	[2075]="0:386:2:2:1:OneHandMace::1:0:", -- Priest's Mace
	[2077]="0:5059:2:2:1:Stave::1:0:", -- Magician Staff
	[2078]="0:1070:2:2:1:OneHandSword::1:0:", -- Northern Shortsword
	[2079]="0:934:2:2:1:OneHandMace::1:0:", -- Sergeant's Warhammer
	[2080]="0:6590:2:2:1:OneHandAxe::1:0:", -- Hillborne Axe
	[2082]="0:250:1:1:1:Bag::1:0:", -- Wizbang's Gunnysack
	[2084]="0:5709:2:2:1:TwoHandSword::1:0:", -- Darksteel Bastard Sword
	[2085]="0:15:15:0:5:Junk::1:0:", -- Chunk of Flesh
	[2087]="0:252:4:2:1:Leather::1:0:", -- Hard Crawler Carapace
	[2088]="0:729:2:2:1:Dagger::1:0:", -- Long Crawler Limb
	[2089]="0:1113:2:2:1:Dagger::1:0:", -- Scrimshaw Dagger
	[2091]="0:213:0:1:10:Other::1:0:", -- Magic Dust
	[2092]="0:7:2:1:1:Dagger::1:0:", -- Worn Dagger
	[2098]="0:3021:2:3:1:Gun::1:0:", -- Double-barreled Shotgun
	[2099]="0:45040:2:4:1:Gun::1:0:", -- Dwarven Hand Cannon
	[2100]="0:24540:2:4:1:Gun::1:0:", -- Precisely Calibrated Boomstick
	[2101]="4:1:11:1:1:Quiver::1:0:1287,4602,7976,16715,16919,17667", -- Light Quiver
	[2102]="4:1:11:1:1:AmmoPouch::1:0:2685,6028", -- Small Ammo Pouch
	[2105]="0:1:4:1:1:Shirt::1:0:", -- Thug Shirt
	[2108]="0:8:4:1:1:Leather::1:0:", -- Frostmane Leather Vest
	[2109]="0:14:4:1:1:Mail::1:0:", -- Frostmane Chain Vest
	[2110]="0:6:4:1:1:Cloth::1:0:", -- Light Magesmith Robe
	[2112]="0:54:4:1:1:Leather::1:0:", -- Lumberjack Jerkin
	[2113]="0:0:12:1:1:::1:0:", -- Calor's Note
	[2114]="0:31:4:1:1:Cloth::1:0:", -- Snowy Robe
	[2117]="37:7:4:1:1:Cloth::1:0:190,836,1238,3590,4175,16918", -- Thin Cloth Shoes
	[2119]="25:5:4:1:1:Cloth::1:0:190,836,1238,3590,4175,16918", -- Thin Cloth Gloves
	[2120]="50:10:4:1:1:Cloth::1:0:190,836,1238,3590,4175,16918", -- Thin Cloth Pants
	[2121]="50:10:4:1:1:Cloth::1:0:190,836,1238,3590,4175,16918", -- Thin Cloth Armor
	[2122]="32:6:4:1:1:Leather::1:0:190,836,1238,3591,4236,16918", -- Cracked Leather Belt
	[2123]="49:9:4:1:1:Leather::1:0:190,836,1238,3591,4236,16918", -- Cracked Leather Boots
	[2124]="33:6:4:1:1:Leather::1:0:190,836,1238,3591,4236,16918", -- Cracked Leather Bracers
	[2125]="33:6:4:1:1:Leather::1:0:190,836,1238,3591,4236,16918", -- Cracked Leather Gloves
	[2126]="60:12:4:1:1:Leather::1:0:190,836,1238,3591,4236,16918", -- Cracked Leather Pants
	[2127]="60:12:4:1:1:Leather::1:0:190,836,1238,3591,4236,16918", -- Cracked Leather Vest
	[2129]="77:15:4:1:1:Shield::1:0:1104,1213,3592,4240,16762,16917", -- Large Round Shield
	[2130]="54:10:2:1:1:OneHandMace::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919", -- Club
	[2131]="54:10:2:1:1:OneHandSword::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919", -- Shortsword
	[2132]="102:20:2:1:1:Stave::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919", -- Short Staff
	[2133]="0:16:4:1:1:Shield::1:0:", -- Small Shield
	[2134]="82:16:2:1:1:OneHandAxe::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919", -- Hand Axe
	[2136]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Purified Water
	[2137]="0:25:2:1:1:Dagger::1:0:", -- Whittling Knife
	[2138]="0:38:2:0:1:Dagger::1:0:", -- Sharpened Letter Opener
	[2139]="57:11:2:1:1:Dagger::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919", -- Dirk
	[2140]="0:323:2:2:1:Dagger::1:0:", -- Carving Knife
	[2141]="5224:1044:4:1:1:Leather::1:0:1314,1695,3315,3316,3953,4236,5820", -- Cuirboulli Vest
	[2142]="2621:524:4:1:1:Leather::1:0:1314,1695,3315,3316,3953,4236,5820", -- Cuirboulli Belt
	[2143]="3945:789:4:1:1:Leather::1:0:1314,1695,3315,3316,3953,4236,5820", -- Cuirboulli Boots
	[2144]="2639:527:4:1:1:Leather::1:0:1314,1695,3315,3316,3953,4236,5820", -- Cuirboulli Bracers
	[2145]="2649:529:4:1:1:Leather::1:0:1314,1695,3315,3316,3953,4236,5820", -- Cuirboulli Gloves
	[2146]="4809:961:4:1:1:Leather::1:0:1314,1695,3315,3316,3953,4236,5820", -- Cuirboulli Pants
	[2148]="2908:581:4:1:1:Mail::1:0:226,1323,1341,1349,1450,3095,4085,4177,4883,4886,5125,5812,5819,6028", -- Polished Scale Belt
	[2149]="4398:879:4:1:1:Mail::1:0:226,1323,1341,1349,1450,3095,4085,4177,4883,4886,5125,5812,5819,6028", -- Polished Scale Boots
	[2150]="2930:586:4:1:1:Mail::1:0:226,1323,1341,1349,1450,3095,4085,4177,4883,4886,5125,5812,5819,6028", -- Polished Scale Bracers
	[2151]="2941:588:4:1:1:Mail::1:0:226,1323,1341,1349,1450,3095,4085,4177,4883,4886,5125,5812,5819,6028", -- Polished Scale Gloves
	[2152]="5906:1181:4:1:1:Mail::1:0:226,1323,1341,1349,1450,3095,4085,4177,4883,4886,5125,5812,5819,6028", -- Polished Scale Leggings
	[2153]="5928:1185:4:1:1:Mail::1:0:226,1323,1341,1349,1450,3095,4085,4177,4883,4886,5125,5812,5819,6028", -- Polished Scale Vest
	[2154]="0:0:15:0:1:Junk::1:0:", -- The Story of Morgan Ladimore
	[2156]="3078:615:4:1:1:Cloth::1:0:1314,2849,3092,3315,3316,3952,4175,4188,5821", -- Padded Boots
	[2158]="2066:413:4:1:1:Cloth::1:0:1314,2849,3092,3315,3316,3952,4175,4188,5821", -- Padded Gloves
	[2159]="4148:829:4:1:1:Cloth::1:0:1314,2849,3092,3315,3316,3952,4175,4188,5821", -- Padded Pants
	[2160]="4163:832:4:1:1:Cloth::1:0:1314,2849,3092,3315,3316,3952,4175,4188,5821", -- Padded Armor
	[2161]="0:0:12:1:1:::1:0:", -- Book from Sven's Farm
	[2162]="0:0:12:1:1:::1:0:", -- Sarah's Ring
	[2163]="0:46710:2:4:1:Dagger::1:0:", -- Shadowblade
	[2164]="0:27032:2:4:1:Dagger::1:0:", -- Gut Ripper
	[2165]="0:45:4:1:1:Cloak::1:0:", -- Old Blanchy's Blanket
	[2166]="0:811:4:2:1:Mail::1:0:", -- Foreman's Leggings
	[2167]="0:339:4:2:1:Leather::1:0:", -- Foreman's Gloves
	[2168]="0:469:4:2:1:Cloth::1:0:", -- Foreman's Boots
	[2169]="0:1887:2:3:1:Dagger::1:0:", -- Buzzer Blade
	[2172]="0:7:4:1:1:Mail::1:0:", -- Rustic Belt
	[2173]="0:6:4:1:1:Leather::1:0:", -- Old Leather Belt
	[2175]="0:2683:2:2:1:TwoHandAxe::1:0:", -- Shadowhide Battle Axe
	[2186]="0:6:4:1:1:Leather::1:0:", -- Outfitter Belt
	[2187]="0:0:12:1:1:::1:0:", -- A Stack of Letters
	[2188]="0:0:12:1:1:::1:0:", -- A Letter to Grelin Whitebeard
	[2194]="0:3276:2:3:1:OneHandMace::1:0:", -- Diamond Hammer
	[2195]="0:25:2:1:1:Dagger::1:0:", -- Anvilmar Knife
	[2203]="0:1492:2:2:1:TwoHandAxe::1:0:", -- Brashclaw's Chopper
	[2204]="0:1133:2:2:1:TwoHandSword::1:0:", -- Brashclaw's Skewer
	[2205]="0:3961:2:3:1:TwoHandSword::1:0:", -- Duskbringer
	[2207]="2391:478:2:1:1:Dagger::1:0:1287,1289,2997,3021,3314,3331,3361,3479,3534,3658,4171,4183,4203,4231,4557,4569,5103,5120,16714", -- Jambiya
	[2208]="3651:730:2:1:1:Dagger::1:0:225,1287,1289,2997,3021,3331,3361,3491,4171,4203,4231,4557,4569,5103,5120,16714", -- Poniard
	[2209]="7116:1423:2:1:1:Dagger::1:0:225,1287,1289,1441,3021,3331,3361,3539,4086,4171,4203,4569,5120,11137,16714", -- Kris
	[2210]="0:3:4:0:1:Shield::1:0:", -- Battered Buckler
	[2211]="0:7:4:0:1:Shield::1:0:", -- Bent Large Shield
	[2212]="0:16:4:0:1:Shield::1:0:", -- Cracked Buckler
	[2213]="0:24:4:0:1:Shield::1:0:", -- Worn Large Shield
	[2214]="0:182:4:0:1:Shield::1:0:", -- Wooden Buckler
	[2215]="0:81:4:0:1:Shield::1:0:", -- Wooden Shield
	[2216]="0:210:4:0:1:Shield::1:0:", -- Simple Buckler
	[2217]="0:243:4:0:1:Shield::1:0:", -- Rectangular Shield
	[2218]="0:501:2:2:1:Dagger::1:0:", -- Craftsman's Dagger
	[2219]="0:457:4:0:1:Shield::1:0:", -- Small Round Shield
	[2220]="0:519:4:0:1:Shield::1:0:", -- Box Shield
	[2221]="0:910:4:0:1:Shield::1:0:", -- Targe Shield
	[2222]="0:1005:4:0:1:Shield::1:0:", -- Tower Shield
	[2223]="0:0:12:1:1:::1:0:", -- The Collector's Schedule
	[2224]="0:24:2:1:1:Dagger::1:0:", -- Militia Dagger
	[2225]="0:183:2:1:1:Dagger::1:0:", -- Sharp Kitchen Knife
	[2226]="0:4118:2:2:1:Stave::1:0:", -- Ogremage Staff
	[2227]="0:4133:2:2:1:TwoHandAxe::1:0:", -- Heavy Ogre War Axe
	[2230]="0:714:4:2:1:Mail::1:0:", -- Gloves of Brawn
	[2231]="0:4386:4:2:1:Cloth::1:0:", -- Inferno Robe
	[2232]="0:813:4:2:1:Cloth::1:0:", -- Dark Runner Boots
	[2233]="0:1690:4:2:1:Leather::1:0:", -- Shadow Weaver Leggings
	[2234]="0:1806:4:2:1:Cloth::1:0:", -- Nightwalker Armor
	[2235]="0:1281:2:2:1:Dagger::1:0:", -- Brackclaw
	[2236]="0:3386:2:3:1:Dagger::1:0:", -- Blackfang
	[2237]="0:75:4:1:1:Leather::1:0:", -- Patched Pants
	[2238]="0:60:4:1:1:Cloth::1:0:", -- Urchin's Pants
	[2239]="0:0:12:1:1:::1:0:", -- The Collector's Ring
	[2240]="0:121:4:1:1:Cloak::1:0:", -- Rugged Cape
	[2241]="0:408:4:2:1:Cloak::1:0:", -- Desperado Cape
	[2243]="0:65783:2:4:1:OneHandMace::1:0:", -- Hand of Edward the Odd
	[2244]="0:51858:2:4:1:OneHandSword::1:0:", -- Krol Blade
	[2245]="0:27636:4:4:1:Mail::1:0:", -- Helm of Narv
	[2246]="0:30000:4:4:1:Ring::1:0:", -- Myrmidon's Signet
	[2249]="0:91:4:1:1:Shield::1:0:", -- Militia Buckler
	[2250]="0:0:12:1:1:::1:0:", -- Dusky Crab Cakes
	[2251]="0:12:7:1:10:Meat:185:1:0:", -- Gooey Spider Leg
	[2252]="0:0:12:1:1:::1:0:", -- Miscellaneous Goblin Supplies
	[2254]="0:506:2:2:1:TwoHandMace::1:0:", -- Icepane Warhammer
	[2256]="0:2996:2:3:1:OneHandMace::1:0:", -- Skeletal Club
	[2257]="0:189:2:1:1:Stave::1:0:", -- Frostmane Staff
	[2258]="0:83:2:1:1:OneHandSword::1:0:", -- Frostmane Shortsword
	[2259]="0:75:2:1:1:OneHandMace::1:0:", -- Frostmane Club
	[2260]="0:106:2:1:1:OneHandAxe::1:0:", -- Frostmane Hand Axe
	[2262]="0:8746:4:3:1:Ring::1:0:", -- Mark of Kern
	[2263]="0:2619:2:2:1:OneHandSword::1:0:", -- Phytoblade
	[2264]="0:1957:4:3:1:Leather::1:0:", -- Mantle of Thieves
	[2265]="0:477:2:2:1:OneHandAxe::1:0:", -- Stonesplinter Axe
	[2266]="0:479:2:2:1:Dagger::1:0:", -- Stonesplinter Dagger
	[2267]="0:711:2:2:1:OneHandMace::1:0:", -- Stonesplinter Mace
	[2268]="0:146:2:1:1:OneHandSword::1:0:", -- Stonesplinter Blade
	[2271]="0:3255:2:3:1:Stave::1:0:", -- Staff of the Blessed Seer
	[2274]="0:289:4:2:1:Mail::1:0:", -- Sapper's Gloves
	[2276]="0:4093:4:3:1:Leather::1:0:", -- Swampwalker Boots
	[2277]="0:3620:4:3:1:Cloth::1:0:", -- Necromancer Leggings
	[2278]="0:2326:4:3:1:Leather::1:0:", -- Forest Tracker Epaulets
	[2280]="0:4828:2:3:1:Stave::1:0:", -- Kam's Walking Stick
	[2281]="0:300:2:2:1:OneHandAxe::1:0:", -- Rodentia Flint Axe
	[2282]="0:139:2:1:1:OneHandSword::1:0:", -- Rodentia Shortsword
	[2283]="0:140:4:2:1:Cloth::1:0:", -- Rat Cloth Belt
	[2284]="0:211:4:2:1:Cloak::1:0:", -- Rat Cloth Cloak
	[2287]="125:6:0:1:20:FoodDrink::5:0:982,1464,2365,2388,2814,3025,3089,3312,3368,3411,3489,3621,3705,3881,3882,3933,3935,3960,4084,4169,4782,4875,4879,4891,4894,4954,5111,5124,5611,5620,5870,6928,6929,7485,7731,7733,8125,9356,11118,11187,12196,12959,14624,15174,15397,16443,16618,16739,17553,17630,17656,19182,23263,23481,23605,24208,24291,24343", -- Haunch of Meat
	[2288]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Fresh Water
	[2289]="350:87:0:1:20:Scroll::1:1:12246,14847", -- Scroll of Strength II
	[2290]="300:75:0:1:20:Scroll::1:1:1316,2805,4581,12246,13476,14847", -- Scroll of Intellect II
	[2291]="0:44580:2:4:1:TwoHandAxe::1:0:", -- Kang the Decapitator
	[2292]="0:1334:4:3:1:Cloth::1:0:", -- Necrology Robes
	[2295]="0:70:15:0:5:Junk::1:0:", -- Large Boar Tusk
	[2296]="0:50:7:1:10:Meat::1:0:", -- Great Goretusk Snout
	[2299]="0:8757:2:3:1:TwoHandAxe::1:0:", -- Burning War Axe
	[2300]="0:192:4:2:1:Leather::1:0:", -- Embossed Leather Vest
	[2302]="0:29:4:1:1:Leather::1:0:", -- Handstitched Leather Boots
	[2303]="0:71:4:1:1:Leather::1:0:", -- Handstitched Leather Pants
	[2304]="0:15:0:1:10:EnhPerm::1:0:", -- Light Armor Kit
	[2307]="0:405:4:2:1:Leather::1:0:", -- Fine Leather Boots
	[2308]="0:214:4:2:1:Cloak::1:0:", -- Fine Leather Cloak
	[2309]="0:268:4:2:1:Leather::1:0:", -- Embossed Leather Boots
	[2310]="0:149:4:2:1:Cloak::1:0:", -- Embossed Leather Cloak
	[2311]="0:250:4:2:1:Leather::1:0:", -- White Leather Jerkin
	[2312]="0:181:4:2:1:Leather::1:0:", -- Fine Leather Gloves
	[2313]="0:200:0:1:10:EnhPerm::1:0:", -- Medium Armor Kit
	[2314]="0:1487:4:3:1:Leather::1:0:", -- Toughened Leather Armor
	[2315]="0:513:4:2:1:Leather::1:0:", -- Dark Leather Boots
	[2316]="0:544:4:2:1:Cloak::1:0:", -- Dark Leather Cloak
	[2317]="0:689:4:2:1:Leather::1:0:", -- Dark Leather Tunic
	[2318]="0:15:7:1:20:Leather:164,202,165,197:1:0:", -- Light Leather
	[2319]="200:50:7:1:20:Leather:164,202,165,197:1:1:14846", -- Medium Leather
	[2320]="10:2:7:1:20:Cloth:165,197:1:0:66,777,843,960,989,1148,1250,1286,1347,1454,1456,1465,1474,1672,1692,2118,2225,2381,2393,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3081,3091,3096,3168,3187,3364,3366,3367,3482,3485,3499,3556,3614,3779,3954,3955,3958,4168,4189,4194,4225,4229,4561,4577,4589,4775,4877,4897,5100,5128,5135,5154,5163,5565,5783,5817,5944,6301,6567,6568,6574,6576,6731,7852,7854,7940,7947,8145,8160,8363,8681,8934,9636,11189,11557,11874,12022,12028,12043,12245,12941,12942,12943,12956,12957,12958,15165,15179,16224,16261,16262,16366,16613,16638,16689,16748,16767,16768,17486,17490,18009,18277,18426,18427,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,24995,25010,25019,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,33596,33601", -- Coarse Thread
	[2321]="100:25:7:1:20:Cloth:164,165,197:1:0:777,843,960,989,1148,1286,1347,1454,1456,1465,1474,1672,2225,2381,2393,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3091,3096,3364,3366,3367,3482,3485,3499,3556,3779,3954,3955,3958,4168,4189,4194,4225,4229,4561,4577,4589,4775,4877,4897,5100,5128,5135,5154,5163,5565,5783,5817,5944,6301,6567,6568,6574,6576,6731,7852,7854,7940,7947,8145,8160,8363,8681,8934,9636,11189,11557,11874,12022,12028,12043,12245,12941,12942,12943,12956,12957,12958,15165,15179,16224,16366,16613,16638,16689,16748,16767,16768,17486,17490,18009,18277,18426,18427,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,24995,25010,25019,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,33596,33601", -- Fine Thread
	[2324]="25:6:7:1:10:Other:165,197:1:0:66,777,843,960,1250,1347,1454,1456,1465,1474,1672,1692,2118,2225,2381,2393,2394,2668,2669,2670,2672,3005,3081,3091,3096,3168,3187,3364,3482,3485,3499,3556,3614,4168,4189,4194,4577,4877,5100,5135,5154,5817,5944,6301,6567,6568,6574,6576,7940,7947,8145,8681,8934,9636,11557,12022,12028,12043,15165,16224,16261,16262,16366,16638,16767,17490,18426,18427,18749,18772,19213,19521,19722,24843,24935,24995,25010,25019,25051,25082,28726,28810,29288,33596", -- Bleach
	[2325]="1000:250:7:1:10:Other:165,197:1:0:989,1148,1286,1347,1454,1474,1672,2225,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3091,3096,3364,3366,3367,3485,3779,3954,3955,3958,4168,4189,4225,4229,4561,4577,4589,4775,4897,5128,5135,5154,5163,5565,5783,5817,5944,6301,6567,6568,6574,6576,6731,7852,7854,7940,7947,8145,8160,8363,8681,8934,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12957,12958,15165,15179,16366,16613,16638,16689,16748,16767,16768,17486,18009,18277,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,24995,25010,25019,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,33596,33601", -- Black Dye
	[2326]="0:29:4:1:1:Cloth::1:0:", -- Ivy-weave Bracers
	[2327]="0:36:4:1:1:Leather::1:0:", -- Sturdy Leather Bracers
	[2361]="0:9:2:1:1:TwoHandMace::1:0:", -- Battleworn Hammer
	[2362]="0:1:4:0:1:Shield::1:0:", -- Worn Wooden Shield
	[2364]="296:59:4:1:1:Cloth::1:0:3166,3317,3522,4558,16186,16623", -- Woven Vest
	[2366]="298:59:4:1:1:Cloth::1:0:3166,3317,3522,4558,16186,16623", -- Woven Pants
	[2367]="224:44:4:1:1:Cloth::1:0:3166,3317,3522,4558,16186,16623", -- Woven Boots
	[2369]="150:30:4:1:1:Cloth::1:0:3166,3317,3522,4558,16186,16623", -- Woven Gloves
	[2370]="378:75:4:1:1:Leather::1:0:2137,3079,3093,3166,3321,4558,16186,16691", -- Battered Leather Harness
	[2371]="189:37:4:1:1:Leather::1:0:2137,3079,3093,3166,3321,4558,16186,16691", -- Battered Leather Belt
	[2372]="344:68:4:1:1:Leather::1:0:2137,3079,3093,3166,3321,4558,16186,16691", -- Battered Leather Pants
	[2373]="259:51:4:1:1:Leather::1:0:2137,3079,3093,3166,3321,4558,16186,16691", -- Battered Leather Boots
	[2374]="173:34:4:1:1:Leather::1:0:2137,3079,3093,3166,3321,4558,16186,16691", -- Battered Leather Bracers
	[2375]="174:34:4:1:1:Leather::1:0:2137,3079,3093,3166,3321,4558,16186,16691", -- Battered Leather Gloves
	[2376]="448:89:4:1:1:Shield::1:0:2135,3080,3167,3319,4559,16258,16693", -- Worn Heater Shield
	[2377]="0:89:4:1:1:Shield::1:0:", -- Round Buckler
	[2378]="0:0:12:1:20:::1:0:", -- Skeleton Finger
	[2379]="76:15:4:1:1:Mail::1:0:1104,1213,3592,4177,16917", -- Tarnished Chain Vest
	[2380]="38:7:4:1:1:Mail::1:0:1104,1213,3592,4177,16917", -- Tarnished Chain Belt
	[2381]="76:15:4:1:1:Mail::1:0:1104,1213,3592,4177,16917", -- Tarnished Chain Leggings
	[2382]="0:0:12:1:1:::1:0:", -- The Embalmer's Heart
	[2383]="58:11:4:1:1:Mail::1:0:1104,1213,3592,4177,16917", -- Tarnished Chain Boots
	[2384]="38:7:4:1:1:Mail::1:0:1104,1213,3592,4177,16917", -- Tarnished Chain Bracers
	[2385]="38:7:4:1:1:Mail::1:0:1104,1213,3592,4177,16917", -- Tarnished Chain Gloves
	[2386]="78:15:4:1:1:Mail::1:0:2116,3075,3161,4559", -- Rusted Chain Vest
	[2387]="39:7:4:1:1:Mail::1:0:2116,3075,3161,4559", -- Rusted Chain Belt
	[2388]="78:15:4:1:1:Mail::1:0:2116,3075,3161,4559", -- Rusted Chain Leggings
	[2389]="59:11:4:1:1:Mail::1:0:2116,3075,3161,4559", -- Rusted Chain Boots
	[2390]="39:7:4:1:1:Mail::1:0:2116,3075,3161,4559", -- Rusted Chain Bracers
	[2391]="39:7:4:1:1:Mail::1:0:2116,3075,3161,4559", -- Rusted Chain Gloves
	[2392]="413:82:4:1:1:Mail::1:0:1240,1249,1294,2046,3613,4164,4177,5106,5812,5819,16750,17930", -- Light Mail Armor
	[2393]="207:41:4:1:1:Mail::1:0:1240,1249,1294,2046,3613,4164,4177,5106,5812,5819,16750,17930", -- Light Mail Belt
	[2394]="416:83:4:1:1:Mail::1:0:1240,1249,1294,2046,3613,4164,4177,5106,5812,5819,16750,17930", -- Light Mail Leggings
	[2395]="323:64:4:1:1:Mail::1:0:1240,1249,1294,2046,3613,4164,4177,5106,5812,5819,16750,17930", -- Light Mail Boots
	[2396]="215:43:4:1:1:Mail::1:0:1240,1249,1294,2046,3613,4164,4177,5106,5812,5819,16750,17930", -- Light Mail Bracers
	[2397]="216:43:4:1:1:Mail::1:0:1240,1249,1294,2046,3613,4164,4177,5106,5812,5819,16750,17930", -- Light Mail Gloves
	[2398]="434:86:4:1:1:Mail::1:0:2135,3080,3167,3319,4559,16258,16625,16693", -- Light Chain Armor
	[2399]="218:43:4:1:1:Mail::1:0:2135,3080,3167,3319,4559,16258,16625,16693", -- Light Chain Belt
	[2400]="437:87:4:1:1:Mail::1:0:2135,3080,3167,3319,4559,16258,16625,16693", -- Light Chain Leggings
	[2401]="331:66:4:1:1:Mail::1:0:2135,3080,3167,3319,4559,16258,16625,16693", -- Light Chain Boots
	[2402]="220:44:4:1:1:Mail::1:0:2135,3080,3167,3319,4559,16258,16625,16693", -- Light Chain Bracers
	[2403]="221:44:4:1:1:Mail::1:0:2135,3080,3167,3319,4559,16258,16625,16693", -- Light Chain Gloves
	[2406]="0:25:9:2:1:Leatherworking::1:0:", -- Pattern: Fine Leather Boots
	[2407]="0:162:9:2:1:Leatherworking::1:0:", -- Pattern: White Leather Jerkin
	[2408]="0:125:9:2:1:Leatherworking::1:0:", -- Pattern: Fine Leather Gloves
	[2409]="0:350:9:2:1:Leatherworking::1:0:", -- Pattern: Dark Leather Tunic
	[2411]="100000:0:15:3:1:Mount::1:0:1460", -- Black Stallion Bridle
	[2414]="100000:0:15:3:1:Mount::1:0:384,1460,2357,4885", -- Pinto Bridle
	[2417]="15673:3134:4:1:1:Mail::1:0:1322,1323,1349,1381,2845,3095,4177,5125,5812,5819,8129", -- Augmented Chain Vest
	[2418]="15732:3146:4:1:1:Mail::1:0:1322,1323,1349,1381,2845,3095,4177,5125,5812,5819,8129", -- Augmented Chain Leggings
	[2419]="7895:1579:4:1:1:Mail::1:0:1322,1323,1349,1381,2845,3095,4177,5125,5812,5819,8129", -- Augmented Chain Belt
	[2420]="11938:2387:4:1:1:Mail::1:0:1322,1323,1339,1349,1381,2845,3095,4177,4890,5125,5812,5819,8129,23571", -- Augmented Chain Boots
	[2421]="7952:1590:4:1:1:Mail::1:0:1322,1323,1349,1381,2845,3095,4177,5125,5812,5819,8129", -- Augmented Chain Bracers
	[2422]="7981:1596:4:1:1:Mail::1:0:1322,1323,1349,1381,2845,3095,4177,5125,5812,5819,8129", -- Augmented Chain Gloves
	[2423]="42770:8554:4:1:1:Mail::1:0:980,1323,1349,3095,4177,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Brigandine Vest
	[2424]="21461:4292:4:1:1:Mail::1:0:980,1323,1349,3095,4177,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Brigandine Belt
	[2425]="43077:8615:4:1:1:Mail::1:0:980,1323,1349,3095,4177,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Brigandine Leggings
	[2426]="32569:6513:4:1:1:Mail::1:0:980,1323,1339,1349,3095,4177,4890,5126,5508,5812,5819,8129,11182,16626,16753,23571,25274,27067", -- Brigandine Boots
	[2427]="20146:4029:4:1:1:Mail::1:0:980,1323,1349,3095,4177,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Brigandine Bracers
	[2428]="20222:4044:4:1:1:Mail::1:0:980,1323,1349,3095,4177,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Brigandine Gloves
	[2429]="10139:2027:4:1:1:Cloth::1:0:1147,1314,1407,2849,3092,3315,3316,4175,5155,5821,8159,10293", -- Russet Vest
	[2431]="10215:2043:4:1:1:Cloth::1:0:1147,1314,1407,2849,3092,3315,3316,4175,5155,5821,8159,10293", -- Russet Pants
	[2432]="7691:1538:4:1:1:Cloth::1:0:1147,1314,1339,1407,2849,3092,3315,3316,4175,4890,5155,5821,8159,10293,23571", -- Russet Boots
	[2434]="5166:1033:4:1:1:Cloth::1:0:1147,1314,1407,2849,3092,3315,3316,4175,5155,5821,8159,10293", -- Russet Gloves
	[2435]="27683:5536:4:1:1:Cloth::1:0:984,1314,2849,3092,3315,3316,4175,5129,5155,5821,10293,11183,12023,26707", -- Embroidered Armor
	[2437]="27891:5578:4:1:1:Cloth::1:0:984,1314,2849,3092,3315,3316,4175,5129,5155,5821,10293,11183,12023,26707", -- Embroidered Pants
	[2438]="20996:4199:4:1:1:Cloth::1:0:984,1314,1339,2849,3092,3315,3316,4175,4890,5129,5155,5821,10293,11183,12023,23571,26707", -- Embroidered Boots
	[2440]="14099:2819:4:1:1:Cloth::1:0:984,1314,2849,3092,3315,3316,4175,5129,5155,5821,10293,11183,12023,26707", -- Embroidered Gloves
	[2441]="0:729:4:1:1:Shield::1:0:", -- Ringed Buckler
	[2445]="3433:686:4:1:1:Shield::1:0:793,1319,3319,3493,4240,5126,8360,16693,16762", -- Large Metal Shield
	[2446]="6182:1236:4:1:1:Shield::1:0:226,1319,1323,1349,1450,3095,4240,4886,5126,5812,5819,6028,16693,16762,31027", -- Kite Shield
	[2447]="40:10:7:1:20:Herb:171:1:1:1313,3490,3548,16224,16641,16705", -- Peacebloom
	[2448]="16159:3231:4:1:1:Shield::1:0:1319,1322,1323,1349,1381,2845,3095,4177,4240,5125,5126,5812,5819,8129", -- Heavy Pavise
	[2449]="80:20:7:1:20:Herb:171:1:1:844,1302,1313,3490,3548,4083,4878,8305,14846,16224,16641,16705", -- Earthroot
	[2450]="0:25:7:1:20:Herb:171:1:0:", -- Briarthorn
	[2451]="43629:8725:4:1:1:Shield::1:0:980,1319,1323,1349,3095,4177,4240,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Crested Heater Shield
	[2452]="0:15:7:1:20:Herb:171,185:1:0:", -- Swiftthistle
	[2453]="100:25:7:1:20:Herb:171:1:1:844,1302,1313,3490,3548,4083,4878,8305,14846,16224,16641,16705", -- Bruiseweed
	[2454]="0:20:0:1:20:Elixir::1:0:", -- Elixir of Lion's Strength
	[2455]="40:10:0:1:5:Potion::1:1:958,3658,16612,16706", -- Minor Mana Potion
	[2456]="0:15:0:1:5:Potion::1:0:", -- Minor Rejuvenation Potion
	[2457]="0:15:0:1:20:Elixir:165:1:0:", -- Elixir of Minor Agility
	[2458]="0:15:0:1:20:Elixir::1:0:", -- Elixir of Minor Fortitude
	[2459]="0:25:0:1:5:Potion:164,165:1:0:", -- Swiftness Potion
	[2463]="13695:2739:4:1:1:Leather::1:0:1147,1314,1320,1407,3315,3316,4236,5129,5820,8159", -- Studded Doublet
	[2464]="6872:1374:4:1:1:Leather::1:0:1147,1314,1320,1407,3315,3316,4236,5129,5820,8159", -- Studded Belt
	[2465]="12477:2495:4:1:1:Leather::1:0:1147,1314,1320,1407,3315,3316,4236,5129,5820,8159", -- Studded Pants
	[2466]="0:0:12:1:20:::1:0:", -- Skullsplitter Fetish
	[2467]="9430:1886:4:1:1:Leather::1:0:1147,1314,1320,1339,1407,3315,3316,4236,4890,5129,5820,8159,23571", -- Studded Boots
	[2468]="6311:1262:4:1:1:Leather::1:0:1147,1314,1320,1407,3315,3316,4236,5129,5820,8159", -- Studded Bracers
	[2469]="6335:1267:4:1:1:Leather::1:0:1147,1314,1320,1407,3315,3316,4236,5129,5820,8159", -- Studded Gloves
	[2470]="33952:6790:4:1:1:Leather::1:0:984,1314,1320,3315,3316,4236,5129,5820,11183,12023,26707,27037", -- Reinforced Leather Vest
	[2471]="17041:3408:4:1:1:Leather::1:0:984,1314,1320,3315,3316,4236,5129,5820,11183,12023,26707,27037", -- Reinforced Leather Belt
	[2472]="34212:6842:4:1:1:Leather::1:0:984,1314,1320,3315,3316,4236,5129,5820,11183,12023,26707,27037", -- Reinforced Leather Pants
	[2473]="25753:5150:4:1:1:Leather::1:0:984,1314,1320,1339,3315,3316,4236,4890,5129,5820,11183,12023,23571,26707,27037", -- Reinforced Leather Boots
	[2474]="17233:3446:4:1:1:Leather::1:0:984,1314,1320,3315,3316,4236,5129,5820,11183,12023,26707,27037", -- Reinforced Leather Bracers
	[2475]="17298:3459:4:1:1:Leather::1:0:984,1314,1320,3315,3316,4236,5129,5820,11183,12023,26707,27037", -- Reinforced Leather Gloves
	[2476]="0:0:12:1:20:::1:0:", -- Chilled Basilisk Haunch
	[2477]="0:0:12:1:20:::1:0:", -- Ravager's Skull
	[2479]="108:21:2:1:1:TwoHandAxe::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919", -- Broad Axe
	[2480]="72:14:2:1:1:TwoHandMace::1:0:78,945,2117,2997,3073,3159,3314,3588,4231,4556,5102,16919", -- Large Club
	[2488]="536:107:2:1:1:OneHandSword::1:0:54,1273,1698,2136,2265,2997,3077,3163,3314,3609,4231,4556,5102,10369,16257,17930,18926", -- Gladius
	[2489]="343:68:2:1:1:TwoHandSword::1:0:54,1273,1698,2136,2265,2997,3077,3163,3314,3609,4231,4556,5102,10369,16257,17930,18926", -- Two-handed Sword
	[2490]="540:108:2:1:1:OneHandAxe::1:0:54,1273,1698,2136,2265,2997,3077,3163,3177,3314,3609,4231,4556,5102,10369,16257,17930,18926", -- Tomahawk
	[2491]="484:96:2:1:1:TwoHandAxe::1:0:54,1273,1698,2136,2265,2997,3077,3163,3177,3314,3609,4231,4556,5102,10369,16257,17930,18926", -- Large Axe
	[2492]="285:57:2:1:1:OneHandMace::1:0:54,222,1273,1348,1698,2136,2265,2997,3077,3163,3177,3314,3609,4231,4556,5102,10369,16257,17930,18926", -- Cudgel
	[2493]="701:140:2:1:1:TwoHandMace::1:0:54,222,1273,1348,1698,2136,2265,2997,3077,3163,3177,3314,3609,4231,4556,5102,10369,16257,17930,18926", -- Wooden Mallet
	[2494]="402:80:2:1:1:Dagger::1:0:54,1273,1698,2136,2265,2997,3077,3163,3314,3609,4231,4556,5102,10369,16257,17930,18926", -- Stiletto
	[2495]="505:101:2:1:1:Stave::1:0:54,1273,1698,2136,2265,2997,3077,3163,3314,3409,3609,4231,4556,5102,10369,16257,17930,18926,19238", -- Walking Stick
	[2499]="0:143:2:1:1:TwoHandAxe::1:0:", -- Double-bladed Axe
	[2504]="29:5:2:1:1:Bow::1:0:1297,12029,16263,16274,16619,16715,17667", -- Worn Shortbow
	[2505]="60:12:2:1:1:Bow::1:0:1297,12029,16263,16274,16619,16715,17667", -- Polished Shortbow
	[2506]="285:57:2:1:1:Bow::1:0:1198,1297,3165,3589,3610,10369,12029,16263,16274,16619,16715,17667", -- Hornwood Recurve Bow
	[2507]="1752:350:2:1:1:Bow::1:0:1198,1297,1459,1668,1687,3165,3409,3488,3589,3610,3951,4203,9549,9553,10369,12029,16263,16274,16619,16715,17667", -- Laminated Recurve Bow
	[2508]="27:5:2:1:1:Gun::1:0:5510", -- Old Blunderbuss
	[2509]="414:82:2:1:1:Gun::1:0:1243,1297,1469,2997,3018,3078,3322,3488,4603,5123,5510,7976,9551,16274,16620,16735", -- Ornate Blunderbuss
	[2510]="41:8:2:1:1:Gun::1:0:1243,3018,3078,4603,5123,5510", -- Solid Blunderbuss
	[2511]="1324:264:2:1:1:Gun::1:0:1297,1469,1686,2997,3018,3088,3322,3488,7976,9551,16274,16620,16735", -- Hunter's Boomstick
	[2512]="10:0:6:1:1000:Arrow::200:0:151,152,228,491,789,791,829,1198,1250,1285,1287,1297,1298,1459,1462,1668,1682,1685,1687,1691,2115,2134,2140,2839,3015,3072,3076,3158,3164,3165,3186,3313,3409,3410,3481,3488,3498,3587,3589,3608,3610,3951,4082,4084,4170,4173,4182,4203,4241,4555,4602,4604,4892,5122,6028,7942,7976,8362,9548,9549,9551,9552,9553,9555,10369,12027,12029,12960,14301,15287,16187,16191,16259,16260,16263,16274,16444,16619,16715,16732,16919,16920,17421,17446,17489,17598,17667,18810,18811,19020,19561,27055", -- Rough Arrow
	[2515]="50:0:6:1:1000:Arrow::200:0:227,228,491,734,789,791,1149,1198,1285,1287,1297,1298,1448,1452,1459,1462,1668,1682,1685,1687,2084,2140,2401,2803,2806,2808,2820,2839,2908,3015,3165,3313,3350,3409,3410,3481,3488,3498,3541,3589,3610,3951,3962,4082,4084,4170,4173,4182,4203,4241,4555,4602,4604,4876,4892,4896,5101,5122,5134,6028,7942,7976,8139,8362,9548,9549,9551,9552,9553,9555,10369,11038,11555,12021,12027,12029,12246,12959,12960,14301,14624,15174,15397,16187,16191,16263,16274,16444,16619,16715,16732,16919,17421,17489,17598,17667,18810,18811,19020,19561,27055", -- Sharp Arrow
	[2516]="10:0:6:1:1000:Bullet::200:0:151,152,491,791,829,1243,1250,1285,1297,1461,1469,1682,1685,1686,1691,2115,2134,2140,2685,2997,3018,3053,3072,3076,3078,3088,3158,3164,3186,3313,3322,3481,3488,3498,3587,3608,4082,4084,4170,4182,4241,4555,4603,4889,5123,5510,6028,7942,7976,8131,8362,9548,9551,11184,12027,12960,16187,16191,16259,16260,16274,16444,16620,16732,16735,17421,17446,17489,18810,18811", -- Light Shot
	[2519]="50:0:6:1:1000:Bullet::200:0:227,491,734,791,1149,1243,1285,1297,1448,1452,1461,1469,1682,1685,1686,2084,2140,2401,2685,2803,2806,2808,2820,2908,2997,3018,3053,3078,3088,3313,3322,3350,3481,3488,3498,3541,3962,4082,4084,4170,4182,4241,4555,4603,4876,4889,4896,5101,5123,5134,5510,6028,7942,7976,8131,8139,8362,9548,9551,11038,11184,11555,12021,12027,12246,12959,12960,14624,15174,15397,16187,16191,16274,16444,16620,16732,16735,17421,17489,18810,18811", -- Heavy Shot
	[2520]="24629:4925:2:1:1:OneHandSword::1:0:1146,1324,1645,2482,2843,3000,3021,3331,3361,4171,4600,4884,4888,5120,5170,11137,15315,16678,16714,19047,19240,21086,21474,28871", -- Broadsword
	[2521]="30896:6179:2:1:1:TwoHandSword::1:0:1146,1333,1645,2482,2843,3000,4043,4180,4600,4884,4888,5120,5170,8398,11137,15315,16678,19047,19240,21086,21474,28871", -- Flamberge
	[2522]="22548:4509:2:1:1:OneHandAxe::1:0:1146,1645,2482,2483,3000,3019,4232,4884,4888,5119,5509,10379,11137,12045,15315,16666,19479,21086,23571", -- Crescent Axe
	[2523]="28286:5657:2:1:1:TwoHandAxe::1:0:1146,1333,1645,2482,2483,3000,3019,4043,4180,4232,4600,4884,4888,5119,5509,8398,10379,11137,12045,15315,16666,19479,21086,23571", -- Bullova
	[2524]="19192:3838:2:1:1:OneHandMace::1:0:1146,1471,1645,2482,3000,4884,4888,5121,5152,8878,10379,11137,16637,16765,19370,21086,25314,28855,31027", -- Truncheon
	[2525]="26490:5298:2:1:1:TwoHandMace::1:0:1146,1333,1471,1645,2482,3000,4043,4180,4600,4884,4888,5121,5152,8398,8878,10379,11137,16637,16765,19370,21086,25314,28855,31027", -- War Hammer
	[2526]="19336:3867:2:1:1:Dagger::1:0:1146,1324,1645,2482,2843,3000,3021,3331,3361,4171,4600,4884,4888,5120,5170,11137,15315,16678,16714,19047,19239,19240,21086,21474,28871", -- Main Gauche
	[2527]="29356:5871:2:1:1:Stave::1:0:1146,1315,1471,1645,2482,3000,3022,3330,3349,4234,4570,4884,4888,5121,5152,8878,10379,11137,16637,16765,19043,19238,19370,21086,25314,28855,31027", -- Battle Staff
	[2528]="51836:10367:2:1:1:OneHandSword::1:0:981,1296,1324,1407,2843,3000,3021,3331,3361,4171,4600,5120,5170,10361,11184,12024,15315,16388,16678,16714,19047,19240,21474,23897,28871", -- Falchion
	[2529]="65032:13006:2:1:1:TwoHandSword::1:0:981,1296,1333,1407,2843,3000,4043,4180,4600,5120,5170,8398,10361,11184,12024,15315,16388,16678,19047,19240,21474,23897,28871", -- Zweihander
	[2530]="52220:10444:2:1:1:OneHandAxe::1:0:981,1296,1407,2483,3000,3019,4232,5119,5509,10361,10379,11184,12024,12045,15315,16388,16666,19479,23571,23897", -- Francisca
	[2531]="56170:11234:2:1:1:TwoHandAxe::1:0:981,1296,1333,1407,2483,3000,3019,4043,4180,4232,4600,5119,5509,8398,10361,10379,11184,12024,12045,15315,16388,16666,19479,23571,23897", -- Great Axe
	[2532]="52608:10521:2:1:1:OneHandMace::1:0:981,1296,1407,1471,3000,5121,5152,8878,10361,10379,11184,12024,16388,16637,16765,19370,21086,23897,25314,28855,31027", -- Morning Star
	[2533]="61108:12221:2:1:1:TwoHandMace::1:0:981,1296,1333,1407,1471,3000,4043,4180,4600,5121,5152,8398,8878,10361,10379,11184,12024,16388,16637,16765,19370,21086,23897,25314,28855,31027", -- War Maul
	[2534]="45431:9086:2:1:1:Dagger::1:0:981,1296,1324,1407,2843,3000,3021,3331,3361,4171,4600,5120,5170,10361,11184,12024,15315,16388,16678,16714,19047,19239,19240,21474,23897,28871", -- Rondel
	[2535]="61557:12311:2:1:1:Stave::1:0:981,1296,1315,1407,1471,3000,3022,3330,3349,4234,4570,5121,5152,8878,10361,10379,11184,12024,16388,16637,16765,19043,19238,19370,21086,23897,25314,28855,31027", -- War Staff
	[2536]="0:0:12:1:20:::1:0:", -- Trogg Stone Tooth
	[2545]="0:1797:4:2:1:Mail::1:0:", -- Malleable Chain Leggings
	[2546]="0:55:4:1:1:Mail::1:0:", -- Royal Frostmane Girdle
	[2547]="0:7:4:1:1:Mail::1:0:", -- Boar Handler Gloves
	[2548]="0:0:12:1:1:::1:0:", -- Barrel of Barleybrew Scalder
	[2549]="0:5016:2:3:1:Stave::1:0:", -- Staff of the Shade
	[2553]="0:25:9:2:1:Alchemy::1:0:", -- Recipe: Elixir of Minor Agility
	[2555]="0:40:9:2:1:Alchemy::1:0:", -- Recipe: Swiftness Potion
	[2560]="0:0:12:1:1:::1:0:", -- Jitters' Completed Journal
	[2561]="0:0:12:1:1:::1:0:", -- Chok'sul's Head
	[2562]="0:575:4:1:1:OffHandFrill::1:0:", -- Bouquet of Scarlet Begonias
	[2563]="0:0:12:1:1:::1:0:", -- Strange Smelling Powder
	[2564]="0:6817:4:3:1:Leather::1:0:", -- Elven Spirit Claws
	[2565]="0:3113:4:3:1:OffHandFrill::1:0:", -- Rod of Molten Fire
	[2566]="0:1322:4:2:1:Cloth::1:0:", -- Sacrificial Robes
	[2567]="0:2509:2:3:1:Dagger::1:0:", -- Evocator's Blade
	[2568]="0:31:4:1:1:Cloth::1:0:", -- Brown Linen Vest
	[2569]="0:146:4:2:1:Cloth::1:0:", -- Linen Boots
	[2570]="0:11:4:1:1:Cloak::1:0:", -- Linen Cloak
	[2571]="0:17:4:1:1:Cloth::1:0:", -- Viny Wrappings
	[2572]="0:99:4:2:1:Cloth::1:0:", -- Red Linen Robe
	[2575]="0:25:4:1:1:Shirt::1:0:", -- Red Linen Shirt
	[2576]="0:75:4:1:1:Shirt::1:0:", -- White Linen Shirt
	[2577]="0:75:4:1:1:Shirt::1:0:", -- Blue Linen Shirt
	[2578]="0:224:4:2:1:Cloth::1:0:", -- Barbaric Linen Vest
	[2579]="0:37:4:1:1:Shirt::1:0:", -- Green Linen Shirt
	[2580]="0:112:4:2:1:Cloak::1:0:", -- Reinforced Linen Cape
	[2581]="0:20:0:1:20:Bandage::1:0:", -- Heavy Linen Bandage
	[2582]="0:216:4:1:1:Cloth::1:0:", -- Green Woolen Vest
	[2583]="0:359:4:2:1:Cloth::1:0:", -- Woolen Boots
	[2584]="0:142:4:1:1:Cloak::1:0:", -- Woolen Cape
	[2585]="0:638:4:2:1:Cloth::1:0:", -- Gray Woolen Robe
	[2586]="0:1:4:1:1:Cloth::1:0:", -- Gamemaster's Robe
	[2587]="0:200:4:1:1:Shirt::1:0:", -- Gray Woolen Shirt
	[2589]="55:13:7:1:20:Cloth:164,202,129,197:1:1:16631", -- Linen Cloth
	[2590]="0:5:15:0:5:Junk::1:0:", -- Forest Spider Webbing
	[2591]="0:5:15:0:5:Junk::1:0:", -- Dirty Trogg Cloth
	[2592]="135:33:7:1:20:Cloth:164,202,129,197:1:1:16631", -- Wool Cloth
	[2593]="150:37:0:1:20:FoodDrink:185:1:0:258,277,465,955,1301,1305,1311,1328,1697,2832,5111,5112,5140,5570,5611,5848,16442,17553,18542,18954,19186,19245,19617,23525,23606,24333,31017,33026", -- Flask of Port
	[2594]="1500:375:0:1:20:FoodDrink:185:1:0:258,277,465,955,1301,1305,1311,1328,1464,1697,2832,5111,5112,5140,5570,5611,5848,16442,17553,18542,18954,19186,19245,19617,20377,23525,23606,24333,31017,33026", -- Flagon of Mead
	[2595]="2000:500:0:1:20:FoodDrink::1:0:258,277,465,955,1301,1305,1311,1328,1697,2832,5111,5112,5140,5570,5611,5848,16442,17553,18542,18954,19186,19245,19617,23525,23606,24333,31017,33026", -- Jug of Bourbon
	[2596]="120:30:0:1:20:FoodDrink:185:1:0:258,277,465,955,1301,1305,1311,1328,1697,2832,5111,5112,5140,5570,5611,5848,16442,17553,18542,18954,19186,19245,19617,23525,23606,24333,31017,33026", -- Skin of Dwarven Stout
	[2598]="0:30:9:2:1:Tailoring::1:0:", -- Pattern: Red Linen Robe
	[2601]="0:100:9:2:1:Tailoring::1:0:", -- Pattern: Gray Woolen Robe
	[2604]="50:12:7:1:10:Other:202,165,197:1:0:66,843,989,1148,1250,1286,1347,1454,1465,1474,1672,1692,2118,2225,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3081,3091,3096,3168,3187,3364,3366,3367,3482,3485,3614,3779,3954,3955,3958,4168,4189,4194,4225,4229,4561,4577,4589,4775,4897,5128,5135,5154,5163,5565,5783,5817,5944,6301,6567,6568,6574,6576,6731,7852,7854,7940,7947,8145,8160,8363,8681,8934,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12957,12958,15165,15179,16224,16261,16262,16366,16613,16638,16689,16748,16767,16768,17486,17490,18009,18277,18426,18427,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,24995,25010,25019,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,33596,33601", -- Red Dye
	[2605]="100:25:7:1:10:Other:164,202,165,197:1:0:843,1347,1454,1465,1474,1672,2225,2394,2668,2669,2670,2672,2697,2698,2699,2816,2819,2846,3005,3091,3096,3364,3366,3482,3485,3958,4168,4189,4194,4225,4577,4589,5128,5135,5154,5565,5783,5817,5944,6301,6567,6568,6574,6576,6731,7852,7854,7940,8160,8681,8934,11557,11874,12942,12943,12956,15165,16224,16366,16638,16689,16748,16767,17490,18277,18426,18427,18749,18754,18771,18772,19196,19213,19521,19532,19722,21085,28718,28726,28798,28810,33596,33601", -- Green Dye
	[2606]="0:0:12:1:1:::1:0:", -- Lurker Venom
	[2607]="0:0:12:1:1:::1:0:", -- Mo'grosh Crystal
	[2608]="0:63:15:0:5:Junk::1:0:", -- Threshadon Ambergris
	[2609]="0:0:12:1:1:::1:0:", -- Disarming Colloid
	[2610]="0:0:12:1:1:::1:0:", -- Disarming Mixture
	[2611]="0:0:12:1:20:::1:0:", -- Crude Flint
	[2612]="163:32:4:1:1:Cloth::1:0:1309,1350,3092,3315,4172,4580,5156", -- Plain Robe
	[2613]="608:121:4:1:1:Cloth::1:0:1309,1350,3092,3315,4172,4580,5156", -- Double-stitched Robes
	[2614]="1162:232:4:1:1:Cloth::1:0:1309,1350,3092,3315,4172,4580,5156", -- Robe of Apprenticeship
	[2615]="5092:1018:4:1:1:Cloth::1:0:1309,1350,3092,3315,4172,4580,5156", -- Chromatic Robe
	[2616]="2660:532:4:1:1:Cloth::1:0:1309,1350,3092,3315,4172,4580,5156", -- Shimmering Silk Robes
	[2617]="10992:2198:4:1:1:Cloth::1:0:1309,1350,3092,3315,4172,4580,5156", -- Burning Robes
	[2618]="26640:5328:4:1:1:Cloth::1:0:1309,1350,3092,3315,4172,4580,5156", -- Silver Dress Robes
	[2619]="0:0:12:1:1:::1:0:", -- Grelin's Report
	[2620]="0:3013:4:2:1:Cloth::1:0:", -- Augural Shroud
	[2621]="0:2357:4:2:1:Cloth::1:0:", -- Cowl of Necromancy
	[2622]="0:2603:4:2:1:Cloth::1:0:", -- Nimar's Tribal Headdress
	[2623]="0:3554:4:2:1:Cloth::1:0:", -- Holy Diadem
	[2624]="0:3852:4:2:1:Cloth::1:0:", -- Thinking Cap
	[2625]="0:0:12:1:1:::1:0:", -- Menethil Statuette
	[2628]="0:0:12:1:1:::1:0:", -- Senir's Report
	[2629]="0:0:13:1:1:::1:0:", -- Intrepid Strongbox Key
	[2632]="0:605:2:2:1:Dagger::1:0:", -- Curved Dagger
	[2633]="0:25:0:1:10:Potion::1:0:", -- Jungle Remedy
	[2634]="0:0:12:1:1:::1:0:", -- Venom Fern Extract
	[2635]="0:16:4:0:1:Mail::1:0:", -- Loose Chain Belt
	[2636]="0:0:12:1:20:::1:0:", -- Carved Stone Idol
	[2637]="0:0:12:1:1:::1:0:", -- Ironband's Progress Report
	[2639]="0:0:12:1:1:::1:0:", -- Merrin's Letter
	[2640]="0:0:12:1:20:::1:0:", -- Miners' Gear
	[2642]="0:33:4:0:1:Mail::1:0:", -- Loose Chain Boots
	[2643]="0:28:4:0:1:Mail::1:0:", -- Loose Chain Bracers
	[2644]="0:7:4:0:1:Cloak::1:0:", -- Loose Chain Cloak
	[2645]="0:11:4:0:1:Mail::1:0:", -- Loose Chain Gloves
	[2646]="0:32:4:0:1:Mail::1:0:", -- Loose Chain Pants
	[2648]="0:58:4:0:1:Mail::1:0:", -- Loose Chain Vest
	[2649]="0:1:4:0:1:Mail::1:0:", -- Flimsy Chain Belt
	[2650]="0:3:4:0:1:Mail::1:0:", -- Flimsy Chain Boots
	[2651]="0:3:4:0:1:Mail::1:0:", -- Flimsy Chain Bracers
	[2652]="0:4:4:0:1:Cloak::1:0:", -- Flimsy Chain Cloak
	[2653]="0:3:4:0:1:Mail::1:0:", -- Flimsy Chain Gloves
	[2654]="0:2:4:0:1:Mail::1:0:", -- Flimsy Chain Pants
	[2656]="0:9:4:0:1:Mail::1:0:", -- Flimsy Chain Vest
	[2657]="0:875:1:1:1:Bag::1:0:", -- Red Leather Bag
	[2658]="0:0:12:1:1:::1:0:", -- Ados Fragment
	[2659]="0:0:12:1:1:::1:0:", -- Modr Fragment
	[2660]="0:0:12:1:1:::1:0:", -- Golm Fragment
	[2661]="0:0:12:1:1:::1:0:", -- Neru Fragment
	[2662]="0:8750:11:2:1:Quiver::1:0:", -- Ribbly's Quiver
	[2663]="0:8750:11:2:1:AmmoPouch::1:0:", -- Ribbly's Bandolier
	[2665]="20:5:7:1:20:Meat::1:0:1303", -- Stormwind Seasoning Herbs
	[2666]="0:0:12:1:1:::1:0:", -- Barrel of Thunder Ale
	[2667]="0:0:12:1:1:::1:0:", -- MacGrann's Dried Meats
	[2671]="0:0:12:1:20:::1:0:", -- Wendigo Mane
	[2672]="0:4:7:1:10:Meat:185:1:0:", -- Stringy Wolf Meat
	[2673]="0:10:7:1:10:Meat:185:1:0:", -- Coyote Meat
	[2674]="0:12:7:1:10:Meat:185:1:0:", -- Crawler Meat
	[2675]="0:11:7:1:10:Meat:185:1:0:", -- Crawler Claw
	[2676]="0:0:12:1:20:::1:0:", -- Shimmerweed
	[2677]="0:15:7:1:10:Meat:185:1:0:", -- Boar Ribs
	[2678]="10:0:7:1:20:Other:185:5:0:66,777,843,960,989,1148,1250,1286,1456,1465,1692,2118,2225,2381,2393,2397,2664,2810,2821,3027,3081,3085,3168,3187,3367,3400,3482,3499,3556,3614,3779,3954,3955,4194,4223,4229,4265,4553,4561,4775,4877,4897,5100,5135,5160,5163,5483,5817,6301,7947,8145,8307,8363,8934,9636,11189,12022,12028,12033,12043,12245,12941,12957,12958,14738,15179,16224,16253,16261,16262,16613,16677,16718,16768,17246,17486,17490,18009,18426,18427,18987,18993,19195,19244,19371,19372,19450,20028,20096,20097,24834,24843,24935,24993,24995,25010,25012,25019,25020,25051,25052,25082,25089,26868,27021,27026,27043,27057,28692,28811,28831,28872,29288,29291,30311,31031,31032,33595", -- Mild Spices
	[2679]="0:5:0:1:20:FoodDrink::1:0:", -- Charred Wolf Meat
	[2680]="0:10:0:1:20:FoodDrink::1:0:", -- Spiced Wolf Meat
	[2681]="0:6:0:1:20:FoodDrink::1:0:", -- Roasted Boar Meat
	[2682]="0:25:0:1:20:FoodDrink::1:0:", -- Cooked Crab Claw
	[2683]="0:25:0:1:20:FoodDrink::1:0:", -- Crab Cake
	[2684]="0:20:0:1:20:FoodDrink::1:0:", -- Coyote Steak
	[2685]="0:75:0:1:20:FoodDrink::1:0:", -- Succulent Pork Ribs
	[2686]="50:12:0:1:10:FoodDrink::1:0:1247,1682,7744", -- Thunder Ale
	[2687]="0:25:0:1:20:FoodDrink::1:0:", -- Dry Pork Ribs
	[2690]="0:7:4:1:1:Mail::1:0:", -- Latched Belt
	[2691]="0:10:4:1:1:Mail::1:0:", -- Outfitter Boots
	[2692]="40:10:7:0:20:Other::1:0:777,843,960,989,1148,1286,1456,1465,2381,2393,2397,2664,2810,2821,3027,3085,3367,3400,3482,3499,3556,3779,3954,3955,4194,4223,4229,4265,4553,4561,4775,4877,4897,5100,5160,5163,5483,5817,6301,7947,8145,8307,8363,8934,9636,11189,12022,12028,12033,12043,12941,12958,14738,15179,16224,16253,16613,16677,16718,16768,17246,17486,17490,18009,18426,18427,18987,18993,19195,19244,19371,19372,19450,20028,20096,20097,24834,24843,24935,24993,24995,25010,25012,25019,25020,25051,25052,25082,25089,26868,27021,27026,27043,27057,28692,28811,28831,28872,29288,29291,30311,31031,31032", -- Hot Spices
	[2694]="0:539:4:2:1:Mail::1:0:", -- Settler's Leggings
	[2696]="0:0:12:1:1:::1:0:", -- Cask of Evershine
	[2697]="400:100:9:1:1:Cooking::1:0:340", -- Recipe: Goretusk Liver Pie
	[2698]="400:100:9:1:1:Cooking::1:0:340", -- Recipe: Cooked Crab Claw
	[2699]="800:200:9:1:1:Cooking::1:0:340", -- Recipe: Redridge Goulash
	[2700]="400:100:9:1:1:Cooking::1:0:340", -- Recipe: Succulent Pork Ribs
	[2701]="1600:400:9:1:1:Cooking::1:0:340", -- Recipe: Seasoned Wolf Kabob
	[2702]="0:0:12:1:20:::1:0:", -- Lightforge Ingot
	[2712]="0:0:12:1:1:::1:0:", -- Crate of Lightforge Ingots
	[2713]="0:0:12:1:1:::1:0:", -- Ol' Sooty's Head
	[2719]="0:0:13:1:1:::1:0:", -- Small Brass Key
	[2720]="0:0:12:1:1:::1:0:", -- Muddy Note
	[2721]="0:1982:4:3:1:Cloth::1:0:", -- Holy Shroud
	[2722]="0:0:12:1:1:::1:0:", -- Wine Ticket
	[2723]="50:12:0:1:20:FoodDrink::1:0:258,277,465,955,1301,1305,1311,1328,1697,2832,5111,5112,5140,5570,5611,5848,16442,17553,18542,18954,19186,19245,19617,23525,23606,24333,31017,33026", -- Bottle of Pinot Noir
	[2724]="0:0:12:1:1:::1:0:", -- Cloth Request
	[2725]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 1
	[2728]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 4
	[2730]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 6
	[2732]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 8
	[2734]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 10
	[2735]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 11
	[2738]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 14
	[2740]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 16
	[2742]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 18
	[2744]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 20
	[2745]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 21
	[2748]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 24
	[2749]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 25
	[2750]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 26
	[2751]="0:375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 27
	[2754]="0:13:2:1:1:TwoHandSword::1:0:", -- Tarnished Bastard Sword
	[2756]="0:0:12:1:1:::1:0:", -- Green Hills of Stranglethorn - Chapter I
	[2757]="0:0:12:1:1:::1:0:", -- Green Hills of Stranglethorn - Chapter II
	[2758]="0:0:12:1:1:::1:0:", -- Green Hills of Stranglethorn - Chapter III
	[2759]="0:0:12:1:1:::1:0:", -- Green Hills of Stranglethorn - Chapter IV
	[2760]="0:0:12:1:1:::1:0:", -- Thurman's Sewing Kit
	[2763]="0:240:2:0:1:Dagger::1:0:", -- Fisherman Knife
	[2764]="0:440:2:0:1:Dagger::1:0:", -- Small Dagger
	[2765]="0:811:2:0:1:Dagger::1:0:", -- Hunting Knife
	[2766]="0:1564:2:0:1:Dagger::1:0:", -- Deft Stiletto
	[2770]="20:5:7:1:20:MetalStone:186:1:1:16224", -- Copper Ore
	[2771]="100:25:7:1:20:MetalStone:186:1:1:16224", -- Tin Ore
	[2772]="0:150:7:1:20:MetalStone:333,186:1:0:", -- Iron Ore
	[2773]="0:39:2:0:1:Bow::1:0:", -- Cracked Shortbow
	[2774]="0:28:2:0:1:Gun::1:0:", -- Rust-covered Blunderbuss
	[2775]="300:75:7:2:20:MetalStone:186:1:1:16224", -- Silver Ore
	[2776]="0:500:7:2:20:MetalStone:186:1:0:", -- Gold Ore
	[2777]="0:147:2:0:1:Bow::1:0:", -- Feeble Shortbow
	[2778]="0:147:2:0:1:Gun::1:0:", -- Cheap Blunderbuss
	[2779]="0:0:12:1:1:::1:0:", -- Tear of Tilloa
	[2780]="0:374:2:0:1:Bow::1:0:", -- Light Hunting Bow
	[2781]="0:335:2:0:1:Gun::1:0:", -- Dirty Blunderbuss
	[2782]="0:751:2:0:1:Bow::1:0:", -- Mishandled Recurve Bow
	[2783]="0:590:2:0:1:Gun::1:0:", -- Shoddy Blunderbuss
	[2784]="0:0:12:1:1:::1:0:", -- Musquash Root
	[2785]="0:1062:2:0:1:Bow::1:0:", -- Stiff Recurve Bow
	[2786]="0:1173:2:0:1:Gun::1:0:", -- Oiled Blunderbuss
	[2787]="0:10:2:1:1:Dagger::1:0:", -- Trogg Dagger
	[2788]="0:0:12:1:1:::1:0:", -- Black Claw Stout
	[2794]="0:0:12:1:1:::1:0:", -- An Old History Book
	[2795]="0:0:12:1:1:::1:0:", -- Book: Stresses of Iron
	[2797]="0:0:12:1:1:::1:0:", -- Heart of Mokk
	[2798]="0:25:12:1:20:::1:0:", -- Rethban Ore
	[2799]="0:67:12:1:20:::1:0:", -- Gorilla Fang
	[2800]="0:1525:4:3:1:Cloth::1:0:", -- Black Velvet Robes
	[2801]="0:90978:2:4:1:TwoHandSword::1:0:", -- Blade of Hanna
	[2802]="0:1625:4:3:1:Trinket::1:0:", -- Blazing Emblem
	[2805]="0:1882:4:2:1:Cloak::1:0:", -- Yeti Fur Cloak
	[2806]="0:0:12:1:1:::1:0:", -- Package for Stormpike
	[2807]="0:2452:2:3:1:OneHandAxe::1:0:", -- Guillotine Axe
	[2815]="0:19778:2:3:1:OneHandAxe::1:0:", -- Curve-bladed Ripper
	[2816]="0:7324:2:3:1:OneHandMace::1:0:", -- Death Speaker Scepter
	[2817]="0:201:4:2:1:Leather::1:0:", -- Soft Leather Tunic
	[2818]="0:363:4:2:1:Leather::1:0:", -- Stretched Leather Trousers
	[2819]="0:3830:2:2:1:Dagger::1:0:", -- Cross Dagger
	[2820]="0:4662:4:2:1:Trinket::1:0:", -- Nifty Stopwatch
	[2821]="0:1118:2:2:1:OneHandMace::1:0:", -- Mo'grosh Masher
	[2822]="0:1402:2:2:1:TwoHandSword::1:0:", -- Mo'grosh Toothpick
	[2823]="0:1618:2:2:1:TwoHandAxe::1:0:", -- Mo'grosh Can Opener
	[2824]="0:32032:2:4:1:Bow::1:0:", -- Hurricane
	[2825]="0:14722:2:4:1:Bow::1:0:", -- Bow of Searing Arrows
	[2828]="0:0:12:1:1:::1:0:", -- Nissa's Remains
	[2829]="0:0:12:1:1:::1:0:", -- Gregor's Remains
	[2830]="0:0:12:1:1:::1:0:", -- Thurman's Remains
	[2831]="0:0:12:1:1:::1:0:", -- Devlin's Remains
	[2832]="0:0:12:1:1:::1:0:", -- Verna's Westfall Stew Recipe
	[2833]="0:0:12:1:1:::1:0:", -- The Lich's Spellbook
	[2834]="0:0:12:1:20:::1:0:", -- Embalming Ichor
	[2835]="0:2:7:1:20:MetalStone:164,202,755:1:0:", -- Rough Stone
	[2836]="0:15:7:1:20:MetalStone:164,202,755:1:0:", -- Coarse Stone
	[2837]="0:0:12:1:1:::1:0:", -- Thurman's Letter
	[2838]="0:60:7:1:20:MetalStone:164,202,755:1:0:", -- Heavy Stone
	[2839]="0:0:12:1:1:::1:0:", -- A Letter to Yvette
	[2840]="0:10:7:1:20:MetalStone:164,202,755,165,186:1:0:", -- Copper Bar
	[2841]="0:50:7:1:20:MetalStone:164,202,755:1:0:", -- Bronze Bar
	[2842]="0:100:7:2:20:MetalStone:164,202,755:1:0:", -- Silver Bar
	[2843]="0:0:12:1:20:::1:0:", -- Dirty Knucklebones
	[2844]="0:106:2:1:1:OneHandMace::1:0:", -- Copper Mace
	[2845]="0:109:2:1:1:OneHandAxe::1:0:", -- Copper Axe
	[2846]="0:0:12:1:20:::1:0:", -- Tirisfal Pumpkin
	[2847]="0:110:2:1:1:OneHandSword::1:0:", -- Copper Shortsword
	[2848]="0:1865:2:2:1:OneHandMace::1:0:", -- Bronze Mace
	[2849]="0:2115:2:2:1:OneHandAxe::1:0:", -- Bronze Axe
	[2850]="0:2399:2:2:1:OneHandSword::1:0:", -- Bronze Shortsword
	[2851]="0:56:4:1:1:Mail::1:0:", -- Copper Chain Belt
	[2852]="0:67:4:1:1:Mail::1:0:", -- Copper Chain Pants
	[2853]="0:17:4:1:1:Mail::1:0:", -- Copper Bracers
	[2854]="0:376:4:2:1:Mail::1:0:", -- Runed Copper Bracers
	[2855]="0:0:12:1:20:::1:0:", -- Putrid Claw
	[2856]="0:0:12:1:20:::1:0:", -- Iron Pike
	[2857]="0:330:4:2:1:Mail::1:0:", -- Runed Copper Belt
	[2858]="0:0:12:1:20:::1:0:", -- Darkhound Blood
	[2859]="0:0:12:1:20:::1:0:", -- Vile Fin Scale
	[2862]="0:3:0:1:20:EnhTemp::1:0:", -- Rough Sharpening Stone
	[2863]="0:10:0:1:20:EnhTemp::1:0:", -- Coarse Sharpening Stone
	[2864]="0:630:4:2:1:Mail::1:0:", -- Runed Copper Breastplate
	[2865]="0:962:4:2:1:Mail::1:0:", -- Rough Bronze Leggings
	[2866]="0:1255:4:2:1:Mail::1:0:", -- Rough Bronze Cuirass
	[2867]="0:629:4:2:1:Mail::1:0:", -- Rough Bronze Bracers
	[2868]="0:807:4:2:1:Mail::1:0:", -- Patterned Bronze Bracers
	[2869]="0:1831:4:2:1:Mail::1:0:", -- Silvered Bronze Breastplate
	[2870]="0:2935:4:3:1:Mail::1:0:", -- Shining Silver Breastplate
	[2871]="0:40:0:1:20:EnhTemp::1:0:", -- Heavy Sharpening Stone
	[2872]="0:0:12:1:20:::1:0:", -- Vicious Night Web Spider Venom
	[2874]="0:0:12:1:1:::1:0:", -- An Unsent Letter
	[2875]="0:0:12:1:20:::1:0:", -- Scarlet Insignia Ring
	[2876]="0:0:12:1:20:::1:0:", -- Duskbat Pelt
	[2877]="0:8524:2:3:1:TwoHandSword::1:0:", -- Combatant Claymore
	[2878]="0:5143:2:3:1:OneHandAxe::1:0:", -- Bearded Boneaxe
	[2879]="0:3121:4:3:1:OffHandFrill::1:0:", -- Antipodean Rod
	[2880]="100:25:7:1:20:Other:164,202:1:0:66,372,777,790,843,960,989,1148,1250,1286,1448,1456,1465,1690,1692,1694,2118,2225,2381,2393,2682,2683,2684,2685,2687,2688,2810,2821,2844,2847,2999,3002,3081,3133,3167,3168,3187,3343,3356,3358,3367,3392,3413,3477,3482,3495,3499,3556,3578,3614,3779,3954,3955,4194,4229,4256,4257,4259,4453,4561,4587,4597,4599,4775,4877,4897,5100,5135,5163,5175,5411,5512,5514,5519,5817,6298,6300,6301,6730,6777,7947,8145,8161,8176,8363,8678,8679,8934,9179,9544,9636,9676,11185,11186,11189,12022,12028,12043,12245,12941,12957,12958,14337,14624,14637,14737,15176,15179,15400,16224,16261,16262,16376,16583,16613,16657,16664,16670,16713,16751,16768,16782,16823,17222,17245,17421,17486,17490,17655,18009,18278,18426,18427,18484,18752,18775,19011,19012,19056,19244,19342,19372,19383,19450,19520,19530,19662,19879,20082,20463,20890,20981,22264,22476,23144,23724,23908,24052,24843,24935,24995,25010,25019,25051,25082,26081,26599,26600,26898,26934,27019,27021,27026,27043,27045,27057,27062,27134,27267,27711,28344,28692,28716,28722,28728,28796,28797,28831,28872,29252,29253,29288,29907,29923,29964,29969,30241,30253,30311,30336,30345,30434,30436,30825,31024,31776,31781,32594,33594,33599,33669", -- Weak Flux
	[2881]="0:150:9:2:1:Blacksmithing::1:0:", -- Plans: Runed Copper Breastplate
	[2882]="0:300:9:2:1:Blacksmithing::1:0:", -- Plans: Silvered Bronze Shoulders
	[2883]="0:375:9:2:1:Blacksmithing::1:0:", -- Plans: Deadly Bronze Poniard
	[2885]="0:0:12:1:1:::1:0:", -- Scarlet Crusade Documents
	[2886]="0:5:7:1:10:Meat:185:1:0:", -- Crag Boar Rib
	[2888]="0:10:0:1:20:FoodDrink::1:0:", -- Beer Basted Boar Ribs
	[2889]="240:60:9:1:1:Cooking::1:0:340", -- Recipe: Beer Basted Boar Ribs
	[2892]="100:25:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12097,15175,16268,16683,18006,20121,26568,27031,27038,27053,28347,29535,30239,30244,30306,32639,32641", -- Deadly Poison
	[2893]="200:50:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12097,15175,16268,16683,18006,20121,26568,27031,27038,27053,28347,29535,30239,30244,30306,32639,32641", -- Deadly Poison II
	[2894]="50:12:0:1:10:FoodDrink::1:0:1247,1682,7744", -- Rhapsody Malt
	[2898]="0:32:4:1:1:Mail::1:0:", -- Mountaineer Chestpiece
	[2899]="0:169:4:2:1:Leather::1:0:", -- Wendigo Collar
	[2900]="0:89:4:1:1:Shield::1:0:", -- Stone Buckler
	[2901]="81:16:2:1:1:Miscellaneous:202:1:0:66,372,777,790,843,960,989,1148,1250,1286,1448,1456,1465,1690,1692,1694,2118,2225,2381,2393,2682,2683,2684,2685,2687,2688,2810,2821,2844,2847,2999,3002,3081,3133,3167,3168,3187,3343,3356,3358,3367,3392,3413,3477,3482,3495,3499,3556,3578,3614,3779,3954,3955,4194,4229,4256,4257,4259,4453,4561,4587,4597,4599,4775,4877,4897,5100,5135,5163,5175,5411,5512,5514,5519,5817,6298,6300,6301,6730,6777,7947,8145,8161,8176,8363,8678,8679,8934,9179,9544,9636,9676,11185,11186,11189,12022,12028,12043,12245,12941,12957,12958,14337,14624,14637,14737,15176,15179,15400,16224,16261,16262,16376,16583,16613,16657,16664,16670,16713,16751,16768,16782,16823,17222,17245,17421,17486,17490,17655,18009,18278,18426,18427,18484,18752,18775,19011,19012,19056,19244,19342,19372,19383,19450,19520,19530,19575,19661,19662,19879,20082,20463,20890,20981,21112,22264,22476,23144,23724,23908,24052,24843,24935,24995,25010,25019,25051,25082,26081,26599,26600,26898,26934,27019,27021,27026,27043,27045,27057,27062,27134,27267,27711,28344,28692,28716,28722,28728,28796,28797,28831,28872,29252,29253,29288,29907,29923,29964,29969,30241,30253,30311,30336,30345,30434,30436,30825,31024,31776,31781,32594,33594,33599,33669", -- Mining Pick
	[2902]="0:1305:4:2:1:Cloak::1:0:", -- Cloak of the Faith
	[2903]="0:515:2:2:1:Bow::1:0:", -- Daryl's Hunting Bow
	[2904]="0:595:2:2:1:Gun::1:0:", -- Daryl's Hunting Rifle
	[2905]="0:42:4:1:1:Cloak::1:0:", -- Goat Fur Cloak
	[2906]="0:1810:4:2:1:Mail::1:0:", -- Darkshire Mail Leggings
	[2907]="0:1755:2:2:1:TwoHandAxe::1:0:", -- Dwarven Tree Chopper
	[2908]="0:1409:2:2:1:Dagger::1:0:", -- Thornblade
	[2909]="0:0:12:1:20:::1:0:", -- Red Wool Bandana
	[2910]="0:1257:4:2:1:Mail::1:0:", -- Gold Militia Boots
	[2911]="0:524:4:3:1:Cloth::1:0:", -- Keller's Girdle
	[2912]="0:6731:2:3:1:Dagger::1:0:", -- Claw of the Shadowmancer
	[2913]="0:1153:4:2:1:Cloth::1:0:", -- Silk Mantle of Gamn
	[2915]="0:55289:2:4:1:TwoHandMace::1:0:", -- Taran Icebreaker
	[2916]="0:4405:4:2:1:Shield::1:0:", -- Gold Lion Shield
	[2917]="0:665:4:2:1:Ring::1:0:", -- Tranquil Ring
	[2924]="0:16:7:1:10:Meat:185:1:0:", -- Crocolisk Meat
	[2925]="0:0:12:1:20:::1:0:", -- Crocolisk Skin
	[2926]="0:0:12:1:1:::1:0:", -- Head of Bazil Thredd
	[2928]="20:5:15:0:20:Junk::1:0:3556,29288", -- Dust of Decay
	[2930]="0:12:15:0:20:Junk::1:0:", -- Essence of Pain
	[2931]="0:250:15:0:20:Junk::1:0:", -- Maiden's Anguish
	[2933]="0:3750:4:3:1:Ring::1:0:", -- Seal of Wrynn
	[2934]="0:7:7:1:20:Leather:165:1:0:", -- Ruined Leather Scraps
	[2939]="0:0:12:1:1:::1:0:", -- Crocolisk Tear
	[2940]="0:43:15:0:5:Junk::1:0:", -- Bloody Bear Paw
	[2941]="0:3552:2:3:1:Dagger::1:0:", -- Prison Shank
	[2942]="0:3663:2:3:1:FistWeapon::1:0:", -- Iron Knuckles
	[2943]="0:537:4:2:1:OffHandFrill::1:0:", -- Eye of Paleth
	[2944]="0:0:4:2:1:OffHandFrill::1:0:", -- Cursed Eye of Paleth
	[2946]="0:0:15:1:200:Junk::1:0:", -- Broken Balanced Throwing Dagger
	[2947]="0:0:15:1:200:Junk::1:0:", -- Broken Small Throwing Knife
	[2949]="0:1039:4:2:1:Leather::1:0:", -- Mariner Boots
	[2950]="0:3476:2:2:1:Stave::1:0:", -- Icicle Rod
	[2951]="0:656:4:3:1:Ring::1:0:", -- Ring of the Underwood
	[2953]="0:1857:4:2:1:Cloak::1:0:", -- Watch Master's Cloak
	[2954]="0:2485:4:2:1:Cloth::1:0:", -- Night Watch Pantaloons
	[2955]="0:3449:4:2:1:Cloth::1:0:", -- First Mate Hat
	[2956]="0:0:12:1:1:::1:0:", -- Report on the Defias Brotherhood
	[2957]="0:119:4:2:1:Cloth::1:0:", -- Journeyman's Vest
	[2958]="0:94:4:2:1:Cloth::1:0:", -- Journeyman's Pants
	[2959]="0:32:4:1:1:Cloth::1:0:", -- Journeyman's Boots
	[2960]="0:22:4:1:1:Cloth::1:0:", -- Journeyman's Gloves
	[2961]="0:155:4:2:1:Leather::1:0:", -- Burnt Leather Vest
	[2962]="0:120:4:2:1:Leather::1:0:", -- Burnt Leather Breeches
	[2963]="0:41:4:1:1:Leather::1:0:", -- Burnt Leather Boots
	[2964]="0:36:4:1:1:Leather::1:0:", -- Burnt Leather Gloves
	[2965]="0:189:4:2:1:Mail::1:0:", -- Warrior's Tunic
	[2966]="0:146:4:2:1:Mail::1:0:", -- Warrior's Pants
	[2967]="0:66:4:1:1:Mail::1:0:", -- Warrior's Boots
	[2968]="0:34:4:1:1:Mail::1:0:", -- Warrior's Gloves
	[2969]="0:381:4:2:1:Cloth::1:0:", -- Spellbinder Vest
	[2970]="0:333:4:2:1:Cloth::1:0:", -- Spellbinder Pants
	[2971]="0:109:4:1:1:Cloth::1:0:", -- Spellbinder Boots
	[2972]="0:72:4:1:1:Cloth::1:0:", -- Spellbinder Gloves
	[2973]="0:484:4:2:1:Leather::1:0:", -- Hunting Tunic
	[2974]="0:392:4:2:1:Leather::1:0:", -- Hunting Pants
	[2975]="0:128:4:1:1:Leather::1:0:", -- Hunting Boots
	[2976]="0:172:4:2:1:Leather::1:0:", -- Hunting Gloves
	[2977]="0:476:4:2:1:Mail::1:0:", -- Veteran Armor
	[2978]="0:415:4:2:1:Mail::1:0:", -- Veteran Leggings
	[2979]="0:157:4:1:1:Mail::1:0:", -- Veteran Boots
	[2980]="0:209:4:2:1:Mail::1:0:", -- Veteran Gloves
	[2981]="0:648:4:2:1:Cloth::1:0:", -- Seer's Robe
	[2982]="0:566:4:2:1:Cloth::1:0:", -- Seer's Pants
	[2983]="0:280:4:2:1:Cloth::1:0:", -- Seer's Boots
	[2984]="0:215:4:2:1:Cloth::1:0:", -- Seer's Gloves
	[2985]="0:822:4:2:1:Leather::1:0:", -- Inscribed Leather Breastplate
	[2986]="0:718:4:2:1:Leather::1:0:", -- Inscribed Leather Pants
	[2987]="0:408:4:2:1:Leather::1:0:", -- Inscribed Leather Boots
	[2988]="0:314:4:2:1:Leather::1:0:", -- Inscribed Leather Gloves
	[2989]="0:1001:4:2:1:Mail::1:0:", -- Burnished Tunic
	[2990]="0:933:4:2:1:Mail::1:0:", -- Burnished Leggings
	[2991]="0:705:4:2:1:Mail::1:0:", -- Burnished Boots
	[2992]="0:408:4:2:1:Mail::1:0:", -- Burnished Gloves
	[2996]="160:40:7:1:20:Cloth:197:1:1:16631", -- Bolt of Linen Cloth
	[2997]="400:100:7:1:20:Cloth:165,197:1:1:16631", -- Bolt of Woolen Cloth
	[2998]="0:0:12:1:1:::1:0:", -- A Simple Compass
	[2999]="0:0:12:1:1:::1:0:", -- Steelgrill's Tools
	[3000]="0:119:4:2:1:Leather::1:0:", -- Brood Mother Carapace
	[3008]="0:34:4:1:1:Cloak::1:0:", -- Wendigo Fur Cloak
	[3010]="0:101:15:0:5:Junk::1:0:", -- Fine Sand
	[3011]="0:2847:4:2:1:Leather::1:0:", -- Feathered Headdress
	[3012]="200:50:0:1:20:Scroll::1:1:958,1316,2805,4581,4878,13476,14847,16224", -- Scroll of Agility
	[3013]="100:25:0:1:20:Scroll::1:1:958,1316,4581,14847,16224", -- Scroll of Protection
	[3014]="0:0:12:1:20:::1:0:", -- Battleworn Axe
	[3016]="0:0:12:1:1:::1:0:", -- Gunther's Spellbook
	[3017]="0:0:12:1:1:::1:0:", -- Sevren's Orders
	[3018]="0:625:4:2:1:Cloak::1:0:", -- Hide of Lupos
	[3019]="0:423:4:2:1:Cloth::1:0:", -- Noble's Robe
	[3020]="0:2655:4:3:1:Leather::1:0:", -- Enduring Cap
	[3021]="0:2421:2:3:1:Bow::1:0:", -- Ranger Bow
	[3022]="0:1085:4:2:1:Leather::1:0:", -- Bluegill Breeches
	[3023]="3772:754:2:1:1:Gun::1:0:1297,1461,1686,3018,3053,3088,3322,4603,4889,5123,8131,9548,9551,11184,16274,16620,16735", -- Large Bore Blunderbuss
	[3024]="7098:1419:2:1:1:Gun::1:0:1297,1461,3018,3053,3322,4603,4889,5123,8131,9548,9551,11184,16620,16735", -- "BKP 2700 ""Enforcer"""
	[3025]="18479:3695:2:1:1:Gun::1:0:3322,8131,9548,11184,19836,22491,29945", -- "BKP 42 ""Ultra"""
	[3026]="3812:762:2:1:1:Bow::1:0:228,1297,1298,1459,1668,1687,2839,3015,3409,3410,3488,3951,4173,4203,4604,4892,5122,9548,9549,9551,9552,9553,9555,12029,14301,16263,16274,16619,16715,17667,19020,19561,27055", -- Reinforced Bow
	[3027]="6349:1269:2:1:1:Bow::1:0:228,1297,1298,2839,3015,3410,4173,4604,4892,5122,9548,9551,9552,9555,12029,14301,16263,16274,16619,16715,17667,19020,19561,27055", -- Heavy Recurve Bow
	[3030]="300:0:6:1:1000:Arrow::200:0:227,228,734,789,1149,1285,1287,1297,1298,1448,1452,1462,2084,2401,2803,2806,2808,2820,2839,2908,3015,3313,3350,3410,3541,3962,4170,4173,4241,4555,4602,4604,4876,4892,4896,5101,5122,5134,6028,7942,7976,8139,8362,9548,9551,9552,9555,11038,11555,12021,12027,12029,12246,12959,12960,14301,14624,15174,15397,16191,16263,16274,16619,16715,16732,16919,17489,17598,17667,19020,19561,27055", -- Razor Arrow
	[3033]="300:0:6:1:1000:Bullet::200:0:227,734,1149,1285,1297,1448,1452,1461,1686,2084,2401,2685,2803,2806,2808,2820,2908,3018,3053,3088,3313,3322,3350,3541,3962,4170,4241,4555,4603,4876,4889,4896,5101,5123,5134,6028,7942,8131,8139,8362,9548,9551,11038,11184,11555,12021,12027,12246,12959,12960,14624,15174,15397,16191,16274,16620,16732,16735,17489", -- Solid Shot
	[3035]="0:0:12:1:1:::1:0:", -- Laced Pumpkin
	[3036]="0:515:2:2:1:Bow::1:0:", -- Heavy Shortbow
	[3037]="0:4814:2:2:1:Bow::1:0:", -- Whipwood Recurve Bow
	[3039]="0:1610:2:2:1:Bow::1:0:", -- Short Ash Bow
	[3040]="0:940:2:2:1:Gun::1:0:", -- Hunter's Muzzle Loader
	[3041]="0:3769:2:2:1:Gun::1:0:", -- """Mage-Eye"" Blunderbuss"
	[3042]="0:4577:2:2:1:Gun::1:0:", -- "BKP ""Sparrow"" Smallbore"
	[3045]="0:1574:4:2:1:Mail::1:0:", -- Lambent Scale Boots
	[3047]="0:1052:4:2:1:Mail::1:0:", -- Lambent Scale Gloves
	[3048]="0:1919:4:2:1:Mail::1:0:", -- Lambent Scale Legguards
	[3049]="0:2119:4:2:1:Mail::1:0:", -- Lambent Scale Breastplate
	[3053]="0:2140:4:2:1:Mail::1:0:", -- Humbert's Chestpiece
	[3055]="0:1526:4:2:1:Leather::1:0:", -- Forest Leather Chestpiece
	[3056]="0:1532:4:2:1:Leather::1:0:", -- Forest Leather Pants
	[3057]="0:903:4:2:1:Leather::1:0:", -- Forest Leather Boots
	[3058]="0:682:4:2:1:Leather::1:0:", -- Forest Leather Gloves
	[3065]="0:658:4:2:1:Cloth::1:0:", -- Bright Boots
	[3066]="0:497:4:2:1:Cloth::1:0:", -- Bright Gloves
	[3067]="0:1275:4:2:1:Cloth::1:0:", -- Bright Pants
	[3069]="0:1412:4:2:1:Cloth::1:0:", -- Bright Robe
	[3070]="0:7:4:1:1:Cloak::1:0:", -- Ensign Cloak
	[3071]="0:231:2:1:1:OneHandAxe::1:0:", -- Striking Hatchet
	[3072]="0:1207:4:2:1:Cloth::1:0:", -- Smoldering Robe
	[3073]="0:1211:4:2:1:Cloth::1:0:", -- Smoldering Pants
	[3074]="0:476:4:2:1:Cloth::1:0:", -- Smoldering Gloves
	[3075]="0:15073:4:4:1:Cloth::1:0:", -- Eye of Flame
	[3076]="0:636:4:2:1:Cloth::1:0:", -- Smoldering Boots
	[3078]="0:2777:2:3:1:Bow::1:0:", -- Naga Heartpiercer
	[3079]="0:297:2:2:1:Gun::1:0:", -- Skorn's Rifle
	[3080]="0:0:12:1:1:::1:0:", -- Candle of Beckoning
	[3081]="0:0:12:1:1:::1:0:", -- Nether Gem
	[3082]="0:0:12:1:1:::1:0:", -- Dargol's Skull
	[3083]="0:0:12:1:20:::1:0:", -- Restabilization Cog
	[3084]="0:0:12:1:20:::1:0:", -- Gyromechanic Gear
	[3085]="0:0:12:1:1:::1:0:", -- Barrel of Shimmer Stout
	[3086]="0:0:12:1:1:::1:0:", -- Cask of Shimmer Stout
	[3087]="0:11:0:1:10:Potion::1:0:", -- Mug of Shimmer Stout
	[3103]="0:466:2:2:1:TwoHandMace::1:0:", -- Coldridge Hammer
	[3107]="0:0:15:1:200:Junk::1:0:", -- Broken Keen Throwing Knife
	[3108]="0:0:15:1:200:Junk::1:0:", -- Broken Heavy Throwing Dagger
	[3110]="0:0:12:1:20:::1:0:", -- Tunnel Rat Ear
	[3111]="0:0:15:1:200:Junk::1:0:", -- Broken Crude Throwing Axe
	[3117]="0:0:12:1:1:::1:0:", -- Hildelve's Journal
	[3131]="0:0:15:1:200:Junk::1:0:", -- Broken Weighted Throwing Axe
	[3135]="0:0:15:1:200:Junk::1:0:", -- Broken Sharp Throwing Axe
	[3137]="0:0:15:1:200:Junk::1:0:", -- Broken Deadly Throwing Axe
	[3148]="0:1:4:0:1:Shirt::1:0:", -- Work Shirt
	[3151]="0:87:4:1:1:Mail::1:0:", -- Siege Brigade Vest
	[3152]="0:28:4:1:1:Leather::1:0:", -- Driving Gloves
	[3153]="0:33:4:1:1:Cloak::1:0:", -- Oil-stained Cloak
	[3154]="0:1094:2:2:1:OneHandAxe::1:0:", -- Thelsamar Axe
	[3155]="0:0:12:1:1:::1:0:", -- Remedy of Arugal
	[3156]="0:0:12:1:20:::1:0:", -- Glutton Shackle
	[3157]="0:0:12:1:20:::1:0:", -- Darksoul Shackle
	[3158]="0:60:4:1:1:Leather::1:0:", -- Burnt Hide Bracers
	[3160]="0:470:4:2:1:Shield::1:0:", -- Ironplate Buckler
	[3161]="0:295:4:2:1:Cloth::1:0:", -- Robe of the Keeper
	[3162]="0:0:12:1:20:::1:0:", -- Notched Rib
	[3163]="0:0:12:1:20:::1:0:", -- Blackened Skull
	[3164]="0:33:7:1:10:Other:171:1:0:", -- Discolored Worg Heart
	[3165]="0:0:12:1:1:::1:0:", -- Quinn's Potion
	[3166]="0:407:4:2:1:Mail::1:0:", -- Ironheart Chain
	[3167]="0:68:15:0:10:Junk::1:0:", -- Thick Spider Hair
	[3169]="0:18:15:0:10:Junk::1:0:", -- Chipped Bear Tooth
	[3170]="0:47:15:0:10:Junk::1:0:", -- Large Bear Tooth
	[3171]="0:6:15:0:5:Junk::1:0:", -- Broken Boar Tusk
	[3172]="0:18:7:1:10:Meat:185:1:0:", -- Boar Intestines
	[3173]="0:15:7:1:10:Meat:185:1:0:", -- Bear Meat
	[3174]="0:16:7:1:10:Meat:185:1:0:", -- Spider Ichor
	[3175]="0:100:15:0:10:Junk::1:0:", -- Ruined Dragonhide
	[3176]="0:75:15:0:10:Junk::1:0:", -- Small Claw
	[3177]="0:50:15:0:10:Junk::1:0:", -- Tiny Fang
	[3179]="0:125:15:0:10:Junk::1:0:", -- Cracked Dragon Molting
	[3180]="0:168:15:0:5:Junk::1:0:", -- Flecked Raptor Scale
	[3181]="0:23:15:0:5:Junk::1:0:", -- Partially Digested Meat
	[3182]="0:387:7:1:10:Cloth:165,197:1:0:", -- Spider's Silk
	[3183]="0:0:12:1:1:::1:0:", -- Mangy Claw
	[3184]="0:1394:2:2:1:Dagger::1:0:", -- Hook Dagger
	[3185]="0:8088:2:2:1:Stave::1:0:", -- Acrobatic Staff
	[3186]="0:4436:2:2:1:OneHandSword::1:0:", -- Viking Sword
	[3187]="0:14870:2:2:1:Dagger::1:0:", -- Sacrificial Kris
	[3188]="0:879:2:2:1:TwoHandSword::1:0:", -- Coral Claymore
	[3189]="0:99:2:1:1:TwoHandAxe::1:0:", -- Wood Chopper
	[3190]="0:99:2:1:1:TwoHandMace::1:0:", -- Beatstick
	[3191]="0:4629:2:3:1:TwoHandAxe::1:0:", -- Arced War Axe
	[3192]="0:495:2:2:1:TwoHandSword::1:0:", -- Short Bastard Sword
	[3193]="0:2072:2:2:1:TwoHandMace::1:0:", -- Oak Mallet
	[3194]="0:2496:2:3:1:TwoHandMace::1:0:", -- Black Malice
	[3195]="0:1372:2:2:1:TwoHandAxe::1:0:", -- Barbaric Battle Axe
	[3196]="0:1377:2:2:1:TwoHandSword::1:0:", -- Edged Bastard Sword
	[3197]="0:9295:2:2:1:TwoHandSword::1:0:", -- Stonecutter Claymore
	[3198]="0:2742:2:2:1:TwoHandMace::1:0:", -- Battering Hammer
	[3199]="0:2262:2:2:1:TwoHandAxe::1:0:", -- Battle Slayer
	[3200]="0:19:4:1:1:Leather::1:0:", -- Burnt Leather Bracers
	[3201]="0:4496:2:2:1:TwoHandAxe::1:0:", -- Barbarian War Axe
	[3202]="0:584:4:2:1:Leather::1:0:", -- Forest Leather Bracers
	[3203]="0:5436:2:3:1:TwoHandMace::1:0:", -- Dense Triangle Mace
	[3204]="0:751:4:2:1:Leather::1:0:", -- Deepwood Bracers
	[3205]="0:230:4:2:1:Leather::1:0:", -- Inscribed Leather Bracers
	[3206]="0:4582:2:2:1:TwoHandSword::1:0:", -- Cavalier Two-hander
	[3207]="0:87:4:1:1:Leather::1:0:", -- Hunting Bracers
	[3208]="0:25378:2:2:1:TwoHandMace::1:0:", -- Conk Hammer
	[3209]="0:6783:2:2:1:TwoHandSword::1:0:", -- Ancient War Sword
	[3210]="0:5627:2:2:1:TwoHandAxe::1:0:", -- Brutal War Axe
	[3211]="0:373:4:2:1:Mail::1:0:", -- Burnished Bracers
	[3212]="0:929:4:2:1:Mail::1:0:", -- Lambent Scale Bracers
	[3213]="0:89:4:1:1:Mail::1:0:", -- Veteran Bracers
	[3214]="0:34:4:1:1:Mail::1:0:", -- Warrior's Bracers
	[3216]="0:55:4:1:1:Cloth::1:0:", -- Warm Winter Robe
	[3217]="0:135:4:2:1:Cloth::1:0:", -- Foreman Belt
	[3218]="0:0:12:1:20:::1:0:", -- Pyrewood Shackle
	[3220]="0:40:0:1:20:FoodDrink::1:0:", -- Blood Sausage
	[3223]="0:306:2:2:1:OneHandMace::1:0:", -- Frostmane Scepter
	[3224]="0:28:4:1:1:Cloth::1:0:", -- Silver-lined Bracers
	[3225]="0:109:2:1:1:Dagger::1:0:", -- Bloodstained Knife
	[3227]="0:2633:2:2:1:Stave::1:0:", -- Nightbane Staff
	[3228]="0:1098:4:3:1:Mail::1:0:", -- Jimmied Handcuffs
	[3229]="0:424:4:2:1:Cloth::1:0:", -- Tarantula Silk Sash
	[3230]="0:922:4:3:1:Leather::1:0:", -- Black Wolf Bracers
	[3231]="0:1266:4:2:1:Mail::1:0:", -- Cutthroat Pauldrons
	[3233]="0:212:1:1:1:Bag::1:0:", -- Gnoll Hide Sack
	[3234]="0:0:12:1:1:::1:0:", -- Deliah's Ring
	[3235]="0:412:4:2:1:Ring::1:0:", -- Ring of Scorn
	[3236]="0:0:12:1:20:::1:0:", -- Rot Hide Ichor
	[3237]="0:0:12:1:1:::1:0:", -- Sample Ichor
	[3238]="0:0:12:1:1:::1:0:", -- Johaan's Findings
	[3239]="0:3:0:1:20:EnhTemp::1:0:", -- Rough Weightstone
	[3240]="0:10:0:1:20:EnhTemp::1:0:", -- Coarse Weightstone
	[3241]="0:40:0:1:20:EnhTemp::1:0:", -- Heavy Weightstone
	[3248]="0:0:12:1:1:::1:0:", -- Translated Letter from The Embalmer
	[3250]="0:0:12:1:1:::1:0:", -- Bethor's Scroll
	[3251]="0:0:12:1:1:::1:0:", -- Bethor's Potion
	[3252]="0:0:12:1:1:::1:0:", -- Deathstalker Report
	[3253]="0:0:12:1:20:::1:0:", -- Grizzled Bear Heart
	[3254]="0:0:12:1:20:::1:0:", -- Skittering Blood
	[3255]="0:0:12:1:1:::1:0:", -- Berard's Journal
	[3256]="0:0:12:1:20:::1:0:", -- Lake Skulker Moss
	[3257]="0:0:12:1:20:::1:0:", -- Lake Creeper Moss
	[3258]="0:0:12:1:1:::1:0:", -- Hardened Tumor
	[3260]="0:6:4:1:1:Cloth::1:0:", -- Scarlet Initiate Robes
	[3261]="0:7:4:1:1:Cloak::1:0:", -- Webbed Cloak
	[3262]="0:10:2:1:1:OneHandMace::1:0:", -- Putrid Wooden Hammer
	[3263]="0:4:4:1:1:Cloth::1:0:", -- Webbed Pants
	[3264]="0:0:12:1:20:::1:0:", -- Duskbat Wing
	[3265]="0:0:12:1:20:::1:0:", -- Scavenger Paw
	[3266]="0:0:12:1:20:::1:0:", -- Scarlet Armband
	[3267]="0:25:2:1:1:OneHandSword::1:0:", -- Forsaken Shortsword
	[3268]="0:25:2:1:1:Dagger::1:0:", -- Forsaken Dagger
	[3269]="0:25:2:1:1:OneHandMace::1:0:", -- Forsaken Maul
	[3270]="0:10:4:1:1:Cloth::1:0:", -- Flax Vest
	[3272]="0:13:4:1:1:Leather::1:0:", -- Zombie Skin Leggings
	[3273]="0:15:4:1:1:Mail::1:0:", -- Rugged Mail Vest
	[3274]="0:7:4:1:1:Cloth::1:0:", -- Flax Boots
	[3275]="0:5:4:1:1:Cloth::1:0:", -- Flax Gloves
	[3276]="0:15:4:1:1:Shield::1:0:", -- Deathguard Buckler
	[3277]="0:30:2:1:1:Stave::1:0:", -- Executor Staff
	[3279]="0:105:4:1:1:Mail::1:0:", -- Battle Chain Boots
	[3280]="0:33:4:1:1:Mail::1:0:", -- Battle Chain Bracers
	[3281]="0:56:4:1:1:Mail::1:0:", -- Battle Chain Gloves
	[3282]="0:235:4:2:1:Mail::1:0:", -- Battle Chain Pants
	[3283]="0:295:4:2:1:Mail::1:0:", -- Battle Chain Tunic
	[3284]="0:88:4:1:1:Leather::1:0:", -- Tribal Boots
	[3285]="0:36:4:1:1:Leather::1:0:", -- Tribal Bracers
	[3286]="0:59:4:1:1:Leather::1:0:", -- Tribal Gloves
	[3287]="0:199:4:2:1:Leather::1:0:", -- Tribal Pants
	[3288]="0:250:4:2:1:Leather::1:0:", -- Tribal Vest
	[3289]="0:57:4:1:1:Cloth::1:0:", -- Ancestral Boots
	[3290]="0:48:4:1:1:Cloth::1:0:", -- Ancestral Gloves
	[3291]="0:202:4:2:1:Cloth::1:0:", -- Ancestral Woollies
	[3292]="0:203:4:2:1:Cloth::1:0:", -- Ancestral Tunic
	[3293]="0:11:2:1:1:OneHandAxe::1:0:", -- Deadman Cleaver
	[3294]="0:11:2:1:1:OneHandMace::1:0:", -- Deadman Club
	[3295]="0:10:2:1:1:OneHandSword::1:0:", -- Deadman Blade
	[3296]="0:10:2:1:1:Dagger::1:0:", -- Deadman Dagger
	[3297]="0:0:12:1:20:::1:0:", -- Fel Moss
	[3299]="0:48:15:0:10:Junk::1:0:", -- Fractured Canine
	[3300]="0:9:15:0:5:Junk::1:0:", -- Rabbit's Foot
	[3301]="0:102:15:0:10:Junk::1:0:", -- Sharp Canine
	[3302]="0:319:4:2:1:Mail::1:0:", -- Brackwater Boots
	[3303]="0:70:4:1:1:Mail::1:0:", -- Brackwater Bracers
	[3304]="0:106:4:1:1:Mail::1:0:", -- Brackwater Gauntlets
	[3305]="0:492:4:2:1:Mail::1:0:", -- Brackwater Leggings
	[3306]="0:654:4:2:1:Mail::1:0:", -- Brackwater Vest
	[3307]="0:215:4:2:1:Cloth::1:0:", -- Barbaric Cloth Boots
	[3308]="0:144:4:2:1:Cloth::1:0:", -- Barbaric Cloth Gloves
	[3309]="0:333:4:2:1:Cloth::1:0:", -- Barbaric Loincloth
	[3310]="0:442:4:2:1:Cloth::1:0:", -- Barbaric Cloth Vest
	[3311]="0:152:4:1:1:Leather::1:0:", -- Ceremonial Leather Ankleguards
	[3312]="0:70:4:1:1:Leather::1:0:", -- Ceremonial Leather Bracers
	[3313]="0:519:4:2:1:Leather::1:0:", -- Ceremonial Leather Harness
	[3314]="0:171:4:2:1:Leather::1:0:", -- Ceremonial Leather Gloves
	[3315]="0:455:4:2:1:Leather::1:0:", -- Ceremonial Leather Loincloth
	[3317]="0:0:12:1:1:::1:0:", -- A Talking Head
	[3318]="0:0:12:1:1:::1:0:", -- Alaric's Remains
	[3319]="0:110:2:1:1:OneHandSword::1:0:", -- Short Sabre
	[3321]="0:41:4:1:1:Leather::1:0:", -- Gray Fur Booties
	[3322]="0:11:4:1:1:Cloak::1:0:", -- Wispy Cloak
	[3323]="0:15:4:1:1:Cloth::1:0:", -- Ghostly Bracers
	[3324]="0:1120:4:2:1:Cloth::1:0:", -- Ghostly Mantle
	[3325]="0:140:2:1:1:TwoHandAxe::1:0:", -- Vile Fin Battle Axe
	[3327]="0:141:2:1:1:Stave::1:0:", -- Vile Fin Oracle Staff
	[3328]="0:46:4:1:1:Cloth::1:0:", -- Spider Web Robe
	[3329]="0:179:2:1:1:OneHandMace::1:0:", -- Spiked Wooden Plank
	[3330]="0:281:4:2:1:Mail::1:0:", -- Dargol's Hauberk
	[3331]="0:67:4:1:1:Cloak::1:0:", -- Melrache's Cape
	[3332]="0:48:4:1:1:Mail::1:0:", -- Perrine's Boots
	[3334]="0:68:2:1:1:TwoHandMace::1:0:", -- Farmer's Shovel
	[3335]="0:46:2:1:1:Stave::1:0:", -- Farmer's Broom
	[3336]="0:3986:2:2:1:Dagger::1:0:", -- Flesh Piercer
	[3337]="0:0:12:1:20:::1:0:", -- Dragonmaw War Banner
	[3339]="0:0:12:1:1:::1:0:", -- Dwarven Tinder
	[3340]="0:31:12:1:10:::1:0:", -- Incendicite Ore
	[3341]="0:1621:4:2:1:Mail::1:0:", -- Gauntlets of Ogre Strength
	[3342]="0:137:4:1:1:Shirt::1:0:", -- Captain Sanders' Shirt
	[3343]="0:450:1:1:1:Bag::1:0:", -- Captain Sanders' Booty Bag
	[3344]="0:146:4:2:1:Cloth::1:0:", -- Captain Sanders' Sash
	[3345]="0:2720:4:2:1:Cloth::1:0:", -- Silk Wizard Hat
	[3347]="0:0:12:1:1:::1:0:", -- Bundle of Crocolisk Skins
	[3348]="0:0:12:1:20:::1:0:", -- Giant Crocolisk Skin
	[3349]="0:0:12:1:1:::1:0:", -- Sida's Bag
	[3352]="0:1250:1:1:1:Bag::1:0:", -- Ooze-covered Bag
	[3353]="0:0:12:1:1:::1:0:", -- Rune-inscribed Pendant
	[3354]="0:0:12:1:20:::1:0:", -- Dalaran Pendant
	[3355]="200:50:7:1:20:Herb:171:1:1:844,1302,1313,4083,4878,8305,14846,16705", -- Wild Steelbloom
	[3356]="120:30:7:1:20:Herb:171,333,165:1:1:844,1302,1313,4083,4878,8305,14846,16641,16705", -- Kingsblood
	[3357]="300:75:7:1:20:Herb:171:1:1:1302,1313,4083,8305,14846", -- Liferoot
	[3358]="700:175:7:1:20:Herb:171:1:1:14846", -- Khadgar's Whisker
	[3360]="0:625:4:1:1:OffHandFrill::1:0:", -- Stitches' Femur
	[3363]="0:1:4:0:1:Cloth::1:0:", -- Frayed Belt
	[3365]="0:3:4:0:1:Cloth::1:0:", -- Frayed Bracers
	[3369]="0:25:7:1:20:Herb:171:1:0:", -- Grave Moss
	[3370]="0:10:4:0:1:Cloth::1:0:", -- Patchwork Belt
	[3371]="20:1:7:1:20:Other:171,333:5:0:66,777,843,844,958,960,983,989,1148,1250,1257,1286,1313,1453,1456,1465,1692,2118,2225,2380,2381,2393,2480,2481,2810,2812,2821,2848,3010,3014,3081,3168,3187,3348,3367,3405,3482,3499,3548,3556,3614,3779,3954,3955,3956,4194,4216,4226,4229,4561,4610,4615,4775,4877,4897,4899,5100,5135,5138,5163,5178,5503,5594,5817,6301,7947,8145,8157,8158,8177,8178,8305,8363,8934,9636,11188,11189,12022,12028,12043,12245,12941,12957,12958,15179,16224,16261,16262,16367,16612,16613,16641,16705,16706,16768,16829,17486,17490,18005,18009,18426,18427,19074,19244,19372,19450,19837,20989,24843,24935,24975,24995,25010,25019,25051,25082,26568,27021,27026,27031,27038,27043,27053,27057,27140,27141,28692,28725,28727,28828,28829,28831,28866,28868,28872,29288,29535,29909,30311,33600", -- Empty Vial
	[3372]="200:10:7:1:20:Other:171,333:5:0:777,844,958,960,983,989,1148,1257,1286,1313,1453,1456,2225,2380,2381,2393,2480,2481,2810,2812,2821,2848,3010,3014,3348,3367,3405,3499,3548,3556,3779,3954,3955,3956,4216,4226,4229,4561,4610,4615,4775,4877,4897,4899,5100,5135,5138,5163,5178,5503,5594,5817,6301,7947,8145,8157,8158,8177,8178,8305,8363,8934,9636,11188,11189,12022,12028,12043,12245,12941,12957,12958,15179,16367,16612,16613,16641,16705,16706,16768,16829,17486,18005,18009,19074,19244,19372,19450,19837,20989,24843,24935,24975,24995,25010,25019,25051,25082,26568,27021,27026,27031,27038,27043,27053,27057,27140,27141,28692,28725,28727,28828,28829,28831,28866,28868,28872,29288,29535,29909,30311,33600", -- Leaded Vial
	[3373]="0:14:4:0:1:Cloth::1:0:", -- Patchwork Bracers
	[3374]="0:45:4:0:1:Cloth::1:0:", -- Calico Belt
	[3375]="0:30:4:0:1:Cloth::1:0:", -- Calico Bracers
	[3376]="0:86:4:0:1:Cloth::1:0:", -- Canvas Belt
	[3377]="0:99:4:0:1:Cloth::1:0:", -- Canvas Bracers
	[3378]="0:132:4:0:1:Cloth::1:0:", -- Brocade Belt
	[3379]="0:152:4:0:1:Cloth::1:0:", -- Brocade Bracers
	[3380]="0:365:4:0:1:Cloth::1:0:", -- Cross-stitched Belt
	[3381]="0:303:4:0:1:Cloth::1:0:", -- Cross-stitched Bracers
	[3382]="0:10:0:1:20:Elixir::1:0:", -- Weak Troll's Blood Elixir
	[3383]="0:100:0:1:20:Elixir:165,197:1:0:", -- Elixir of Wisdom
	[3384]="0:20:0:1:5:Potion::1:0:", -- Minor Magic Resistance Potion
	[3385]="120:30:0:1:5:Potion::1:1:1307,2481,2805,3134,3956,4083,13476,14847", -- Lesser Mana Potion
	[3386]="0:35:0:1:20:Potion::1:0:", -- Potion of Curing
	[3387]="0:30:0:1:5:Potion::1:0:", -- Limited Invulnerability Potion
	[3388]="0:40:0:1:20:Elixir::1:0:", -- Strong Troll's Blood Elixir
	[3389]="0:40:0:1:20:Elixir:165:1:0:", -- Elixir of Defense
	[3390]="0:35:0:1:20:Elixir:165:1:0:", -- Elixir of Lesser Agility
	[3391]="0:40:0:1:20:Elixir:164,755:1:0:", -- Elixir of Ogre's Strength
	[3392]="0:1663:4:2:1:Leather::1:0:", -- Ringed Helm
	[3393]="0:250:9:1:1:Alchemy::1:0:", -- Recipe: Minor Magic Resistance Potion
	[3394]="0:250:9:1:1:Alchemy::1:0:", -- Recipe: Potion of Curing
	[3395]="0:250:9:2:1:Alchemy::1:0:", -- Recipe: Limited Invulnerability Potion
	[3396]="0:250:9:2:1:Alchemy::1:0:", -- Recipe: Elixir of Lesser Agility
	[3397]="0:0:12:1:20:::1:0:", -- Young Crocolisk Skin
	[3399]="0:81:15:0:5:Junk::1:0:", -- Vulture Talon
	[3400]="0:2761:2:2:1:OneHandSword::1:0:", -- Lucine Longsword
	[3401]="0:81:15:0:5:Junk::1:0:", -- Rough Crocolisk Scale
	[3402]="0:602:15:0:5:Junk::1:0:", -- Soft Patch of Fur
	[3403]="0:321:15:0:5:Junk::1:0:", -- Ivory Boar Tusk
	[3404]="0:181:7:1:10:Meat:185:1:0:", -- Buzzard Wing
	[3405]="0:0:12:1:1:::1:0:", -- Raven Claw Talisman
	[3406]="0:0:12:1:1:::1:0:", -- Black Feather Quill
	[3407]="0:0:12:1:1:::1:0:", -- Sapphire of Sky
	[3408]="0:0:12:1:1:::1:0:", -- Rune of Nesting
	[3409]="0:0:12:1:20:::1:0:", -- Nightsaber Fang
	[3411]="0:0:12:1:20:::1:0:", -- Strigid Owl Feather
	[3412]="0:0:12:1:20:::1:0:", -- Webwood Spider Silk
	[3413]="0:3229:2:3:1:Dagger::1:0:", -- Doomspike
	[3414]="0:4029:2:3:1:OneHandMace::1:0:", -- Crested Scepter
	[3415]="0:3598:2:3:1:Stave::1:0:", -- Staff of the Friar
	[3416]="0:2213:4:3:1:Mail::1:0:", -- Martyr's Chain
	[3417]="0:4629:2:3:1:TwoHandSword::1:0:", -- Onyx Claymore
	[3418]="0:0:12:1:20:::1:0:", -- Fel Cone
	[3419]="500:125:4:1:1:OffHandFrill::1:0:1302,1303,3014,23731,28993,31021", -- Red Rose
	[3420]="5000:1250:4:1:1:OffHandFrill::1:0:1302,1303,3014,23731,28993,31021", -- Black Rose
	[3421]="200:50:4:1:1:OffHandFrill::1:0:1302,1303,3014,23731,28993,31021", -- Simple Wildflowers
	[3422]="2000:500:4:1:1:OffHandFrill::1:0:1302,1303,3014,23731,28993,31021", -- Beautiful Wildflowers
	[3423]="20000:5000:4:1:1:OffHandFrill::1:0:1302,1303,3014,23731,28993,31021", -- Bouquet of White Roses
	[3424]="500000:125000:4:1:1:OffHandFrill::1:0:1302,1303,3014,23731,28993,31021", -- Bouquet of Black Roses
	[3425]="0:0:12:1:1:::1:0:", -- Woven Wand
	[3426]="4000:1000:4:1:1:Shirt::1:0:1299", -- Bold Yellow Shirt
	[3427]="6000:1500:4:1:1:Shirt::1:0:1299", -- Stylish Black Shirt
	[3428]="400:100:4:1:1:Shirt::1:0:1214,1291,1299,3317,3486,3554,3683,4185,4558,5108,8358,16623,16631,16716", -- Common Gray Shirt
	[3429]="0:586:4:2:1:Leather::1:0:", -- Guardsman Belt
	[3430]="0:11027:2:2:1:Gun::1:0:", -- Sniper Rifle
	[3431]="0:1335:4:2:1:Leather::1:0:", -- Bone-studded Leather
	[3434]="0:3:0:1:10:Consumable::1:0:", -- Slumber Sand
	[3435]="0:19:4:1:1:Leather::1:0:", -- Zombie Skin Bracers
	[3437]="0:24:4:1:1:Mail::1:0:", -- Clasped Belt
	[3439]="0:30:4:1:1:Leather::1:0:", -- Zombie Skin Boots
	[3440]="0:640:2:2:1:TwoHandMace::1:0:", -- Bonecracker
	[3442]="0:44:4:1:1:Cloth::1:0:", -- Apprentice Sash
	[3443]="0:138:2:1:1:OneHandAxe::1:0:", -- Ceremonial Tomahawk
	[3444]="0:90:4:1:1:Leather::1:0:", -- Tiller's Vest
	[3445]="0:226:2:1:1:Dagger::1:0:", -- Ceremonial Knife
	[3446]="0:592:2:2:1:Stave::1:0:", -- Darkwood Staff
	[3447]="0:34:4:1:1:Mail::1:0:", -- Cryptwalker Boots
	[3448]="0:6:0:1:20:FoodDrink::1:0:", -- Senggin Root
	[3449]="0:207:4:2:1:Cloak::1:0:", -- Mystic Shawl
	[3450]="0:443:4:2:1:Shield::1:0:", -- Faerleia's Shield
	[3451]="0:607:4:2:1:OffHandFrill::1:0:", -- Nightglow Concoction
	[3452]="0:2322:2:2:1:Stave::1:0:", -- Ceranium Rod
	[3453]="0:46:4:1:1:Cloth::1:0:", -- Quilted Bracers
	[3454]="0:105:4:1:1:Cloth::1:0:", -- Reconnaissance Boots
	[3455]="0:188:2:1:1:OneHandSword::1:0:", -- Deathstalker Shortsword
	[3456]="0:6375:15:3:1:CombatPet::1:0:", -- Dog Whistle
	[3457]="0:444:4:2:1:Cloth::1:0:", -- Stamped Trousers
	[3458]="0:334:4:2:1:Mail::1:0:", -- Rugged Mail Gloves
	[3460]="0:0:12:1:1:::1:0:", -- Johaan's Special Drink
	[3461]="0:1006:4:2:1:Cloth::1:0:", -- High Robe of the Adjudicator
	[3462]="0:2283:2:2:1:OneHandSword::1:0:", -- Talonstrike
	[3463]="0:9:15:2:200:Junk::1:0:", -- Broken Silver Star
	[3464]="0:8:6:2:1000:Arrow::1:0:", -- Feathered Arrow
	[3465]="0:9:6:2:1000:Bullet::1:0:", -- Exploding Shot
	[3466]="2000:500:7:1:20:Other:164:1:0:372,790,960,989,1148,1286,1448,1456,1690,1694,2225,2381,2393,2682,2683,2684,2685,2687,2688,2810,2821,2844,2847,2999,3002,3133,3167,3343,3356,3358,3367,3392,3413,3477,3495,3578,3779,3954,3955,4229,4256,4257,4259,4453,4561,4587,4597,4599,4775,4877,4897,5100,5135,5163,5175,5411,5512,5514,5519,5817,6298,6300,6301,6730,6777,7947,8145,8161,8176,8363,8678,8679,8934,9179,9544,9636,9676,11185,11186,11189,12022,12028,12245,12941,12957,12958,14337,14624,14637,14737,15176,15179,15400,16376,16583,16613,16657,16664,16670,16713,16751,16768,16782,16823,17222,17245,17421,17486,17655,18009,18278,18484,18752,18775,19011,19012,19056,19244,19342,19372,19383,19450,19520,19530,19662,19879,20082,20463,20890,20981,22264,22476,23144,23724,23908,24052,24843,24935,24995,25010,25019,25051,25082,26081,26599,26600,26898,26934,27019,27021,27026,27043,27045,27057,27062,27134,27267,27711,28344,28692,28716,28722,28728,28796,28797,28831,28872,29252,29253,29288,29907,29923,29964,29969,30241,30253,30311,30336,30345,30434,30436,30825,31024,31776,31781,32594,33594,33599,33669", -- Strong Flux
	[3467]="0:0:13:1:1:::1:0:", -- Dull Iron Key
	[3468]="0:0:12:1:1:::1:0:", -- Renferrel's Findings
	[3469]="0:49:4:1:1:Mail::1:0:", -- Copper Chain Boots
	[3470]="0:5:7:1:20:MetalStone:164:1:0:", -- Rough Grinding Stone
	[3471]="0:142:4:2:1:Mail::1:0:", -- Copper Chain Vest
	[3472]="0:119:4:2:1:Mail::1:0:", -- Runed Copper Gauntlets
	[3473]="0:299:4:2:1:Mail::1:0:", -- Runed Copper Pants
	[3474]="0:216:4:2:1:Mail::1:0:", -- Gemmed Copper Gauntlets
	[3475]="0:21810:4:4:1:Cloak::1:0:", -- Cloak of Flames
	[3476]="0:0:12:1:20:::1:0:", -- Gray Bear Tongue
	[3477]="0:0:12:1:1:::1:0:", -- Creeper Ichor
	[3478]="0:10:7:1:20:MetalStone:164:1:0:", -- Coarse Grinding Stone
	[3480]="0:887:4:2:1:Mail::1:0:", -- Rough Bronze Shoulders
	[3481]="0:1284:4:2:1:Mail::1:0:", -- Silvered Bronze Shoulders
	[3482]="0:1317:4:2:1:Mail::1:0:", -- Silvered Bronze Boots
	[3483]="0:965:4:2:1:Mail::1:0:", -- Silvered Bronze Gauntlets
	[3484]="0:1767:4:2:1:Mail::1:0:", -- Green Iron Boots
	[3485]="0:1295:4:2:1:Mail::1:0:", -- Green Iron Gauntlets
	[3486]="0:100:7:1:20:MetalStone:164:1:0:", -- Heavy Grinding Stone
	[3487]="0:1498:2:2:1:TwoHandSword::1:0:", -- Heavy Copper Broadsword
	[3488]="0:613:2:2:1:TwoHandAxe::1:0:", -- Copper Battle Axe
	[3489]="0:937:2:2:1:OneHandAxe::1:0:", -- Thick War Axe
	[3490]="0:2731:2:2:1:Dagger::1:0:", -- Deadly Bronze Poniard
	[3491]="0:2741:2:2:1:OneHandMace::1:0:", -- Heavy Bronze Mace
	[3492]="0:4552:2:2:1:OneHandMace::1:0:", -- Mighty Iron Hammer
	[3493]="0:3426:2:2:1:Bow::1:0:", -- Raptor's End
	[3495]="0:0:12:1:1:::1:0:", -- Elixir of Suffering
	[3496]="0:0:12:1:20:::1:0:", -- Mountain Lion Blood
	[3497]="0:0:12:1:1:::1:0:", -- Elixir of Pain
	[3498]="0:0:12:1:1:::1:0:", -- Taretha's Necklace
	[3499]="0:0:13:1:1:::1:0:", -- Burnished Gold Key
	[3502]="0:0:12:1:20:::1:0:", -- Mudsnout Blossoms
	[3505]="0:0:12:1:20:::1:0:", -- Alterac Signet Ring
	[3506]="0:0:12:1:1:::1:0:", -- Mudsnout Composite
	[3508]="0:0:12:1:1:::1:0:", -- Mudsnout Mixture
	[3509]="0:0:12:1:20:::1:0:", -- Daggerspine Scale
	[3510]="0:0:12:1:20:::1:0:", -- Torn Fin Eye
	[3511]="0:214:4:2:1:Cloak::1:0:", -- Cloak of the People's Militia
	[3514]="0:0:12:1:1:::1:0:", -- Mor'Ladim's Skull
	[3515]="0:0:12:1:1:::1:0:", -- Ataeric's Staff
	[3516]="0:0:12:1:1:::1:0:", -- Lescovar's Head
	[3517]="0:0:12:1:1:::1:0:", -- Keg of Shindigger Stout
	[3518]="0:0:12:1:1:::1:0:", -- Decrypted Letter
	[3520]="0:0:12:1:1:::1:0:", -- Tainted Keg
	[3521]="0:0:12:1:1:::1:0:", -- Cleverly Encrypted Letter
	[3530]="0:25:0:1:20:Bandage::1:0:", -- Wool Bandage
	[3531]="0:57:0:1:20:Bandage::1:0:", -- Heavy Wool Bandage
	[3550]="0:0:12:1:1:::1:0:", -- Targ's Head
	[3551]="0:0:12:1:1:::1:0:", -- Muckrake's Head
	[3552]="0:0:12:1:1:::1:0:", -- Glommus's Head
	[3553]="0:0:12:1:1:::1:0:", -- Mug'thol's Head
	[3554]="0:0:12:1:1:::1:0:", -- Crown of Will
	[3555]="0:1032:4:2:1:Cloth::1:0:", -- Robe of Solomon
	[3556]="0:1285:4:2:1:Cloth::1:0:", -- Dread Mage Hat
	[3558]="0:1044:4:2:1:Cloth::1:0:", -- Fen Keeper Robe
	[3559]="0:473:4:2:1:Mail::1:0:", -- Night Watch Gauntlets
	[3560]="0:2102:4:2:1:Cloth::1:0:", -- Mantle of Honor
	[3561]="0:895:4:2:1:Cloak::1:0:", -- Resilient Poncho
	[3562]="0:823:4:2:1:Leather::1:0:", -- Belt of Vindication
	[3563]="0:557:4:2:1:Cloth::1:0:", -- Seafarer's Pantaloons
	[3564]="0:0:12:1:1:::1:0:", -- Shipment of Iron
	[3565]="0:280:4:2:1:Cloth::1:0:", -- Beerstained Gloves
	[3566]="0:2023:4:2:1:Leather::1:0:", -- Raptorbane Armor
	[3567]="0:922:2:2:1:Gun::1:0:", -- Dwarven Fishing Pole
	[3569]="0:1262:4:2:1:Cloth::1:0:", -- Vicar's Robe
	[3570]="0:839:2:2:1:OneHandMace::1:0:", -- Bonegrinding Pestle
	[3571]="0:2118:2:2:1:TwoHandMace::1:0:", -- Trogg Beater
	[3572]="0:972:2:2:1:OneHandSword::1:0:", -- Daryl's Shortsword
	[3573]="0:212:11:1:1:Quiver::1:0:", -- Hunting Quiver
	[3574]="0:212:11:1:1:AmmoPouch::1:0:", -- Hunting Ammo Sack
	[3575]="0:200:7:1:20:MetalStone:171,164,202,755,186:1:0:", -- Iron Bar
	[3576]="0:35:7:1:20:MetalStone:186:1:0:", -- Tin Bar
	[3577]="0:600:7:2:20:MetalStone:164,202,755,197:1:0:", -- Gold Bar
	[3578]="0:340:4:2:1:Leather::1:0:", -- Harvester's Pants
	[3581]="0:1046:2:2:1:Dagger::1:0:", -- Serrated Knife
	[3582]="0:315:4:2:1:Cloak::1:0:", -- Acidproof Cloak
	[3583]="0:57:4:1:1:Leather::1:0:", -- Weathered Belt
	[3585]="0:953:4:2:1:Leather::1:0:", -- Camouflaged Tunic
	[3586]="0:1034:2:2:1:TwoHandAxe::1:0:", -- Logsplitter
	[3587]="14314:2862:4:1:1:Cloth::1:0:984,1314,2849,3092,3315,3316,4175,5129,5155,5821,10293,11183,12023,26707", -- Embroidered Belt
	[3588]="14366:2873:4:1:1:Cloth::1:0:984,1314,2849,3092,3315,3316,4175,5129,5155,5821,10293,11183,12023,26707", -- Embroidered Bracers
	[3589]="577:115:4:1:1:Cloth::1:0:1214,1291,3092,3317,3486,3554,3683,3952,4164,4175,4185,4558,5108,5821,8358,16623,16631,16716", -- Heavy Weave Belt
	[3590]="579:115:4:1:1:Cloth::1:0:1214,1291,3092,3317,3486,3554,3683,3952,4164,4175,4185,4558,5108,5821,8358,16623,16631,16716", -- Heavy Weave Bracers
	[3591]="2097:419:4:1:1:Cloth::1:0:1314,2849,3092,3315,3316,3952,4175,4188,5821", -- Padded Belt
	[3592]="2104:420:4:1:1:Cloth::1:0:1314,2849,3092,3315,3316,3952,4175,4188,5821", -- Padded Bracers
	[3593]="5478:1095:4:1:1:Cloth::1:0:1147,1314,1407,2849,3092,3315,3316,4175,5155,5821,8159,10293", -- Russet Belt
	[3594]="5497:1099:4:1:1:Cloth::1:0:1147,1314,1407,2849,3092,3315,3316,4175,5155,5821,8159,10293", -- Russet Bracers
	[3595]="24:4:4:1:1:Cloth::1:0:2113,3160,4558", -- Tattered Cloth Belt
	[3596]="24:4:4:1:1:Cloth::1:0:2113,3160,4558", -- Tattered Cloth Bracers
	[3597]="1081:216:4:1:1:Cloth::1:0:1291,2849,3092,3317,3492,3952,4175,4188,5155,5821,8358,16623,16716", -- Thick Cloth Belt
	[3598]="1085:217:4:1:1:Cloth::1:0:1291,2849,3092,3317,3492,3952,4175,4188,5155,5821,8358,16623,16716", -- Thick Cloth Bracers
	[3599]="24:4:4:1:1:Cloth::1:0:190,836,1238,3590,4175,16918", -- Thin Cloth Belt
	[3600]="24:4:4:1:1:Cloth::1:0:190,836,1238,3590,4175,16918", -- Thin Cloth Bracers
	[3601]="0:0:12:1:1:::1:0:", -- Syndicate Missive
	[3602]="145:29:4:1:1:Cloth::1:0:74,959,1238,1291,2264,3092,3530,3611,3952,4164,4175,5821,16716,17929", -- Knitted Belt
	[3603]="146:29:4:1:1:Cloth::1:0:74,959,1238,1291,2264,3092,3530,3611,3952,4164,4175,5821,16716,17929", -- Knitted Bracers
	[3604]="0:500:11:2:1:AmmoPouch::1:0:", -- Bandolier of the Night Watch
	[3605]="0:500:11:2:1:Quiver::1:0:", -- Quiver of the Night Watch
	[3606]="147:29:4:1:1:Cloth::1:0:3166,3317,3522,4558,16186,16623", -- Woven Belt
	[3607]="148:29:4:1:1:Cloth::1:0:3166,3317,3522,4558,16186,16623", -- Woven Bracers
	[3608]="0:500:9:2:1:Blacksmithing::1:0:", -- Plans: Mighty Iron Hammer
	[3609]="0:25:9:2:1:Blacksmithing::1:0:", -- Plans: Copper Chain Vest
	[3610]="0:50:9:2:1:Blacksmithing::1:0:", -- Plans: Gemmed Copper Gauntlets
	[3611]="0:500:9:2:1:Blacksmithing::1:0:", -- Plans: Green Iron Boots
	[3612]="0:500:9:2:1:Blacksmithing::1:0:", -- Plans: Green Iron Gauntlets
	[3613]="0:0:12:1:1:::1:0:", -- Valdred's Hands
	[3614]="0:0:12:1:1:::1:0:", -- Yowler's Paw
	[3615]="0:0:12:1:1:::1:0:", -- Kurzen's Head
	[3616]="0:0:12:1:1:::1:0:", -- Mind's Eye
	[3617]="0:0:12:1:1:::1:0:", -- Pendant of Shadow
	[3618]="0:0:12:1:1:::1:0:", -- Gobbler's Head
	[3619]="0:0:12:1:1:::1:0:", -- Snellig's Snuffbox
	[3621]="0:0:12:1:1:::1:0:", -- Ivar's Head
	[3622]="0:0:12:1:1:::1:0:", -- Essence of Nightlash
	[3623]="0:0:12:1:1:::1:0:", -- Thule's Head
	[3625]="0:0:12:1:1:::1:0:", -- Nek'rosh's Head
	[3626]="0:0:12:1:1:::1:0:", -- Head of Baron Vardus
	[3627]="0:0:12:1:1:::1:0:", -- Fang of Vagash
	[3628]="0:0:12:1:1:::1:0:", -- Hand of Dextren Ward
	[3629]="0:0:12:1:1:::1:0:", -- Mistmantle Family Ring
	[3630]="0:0:12:1:1:::1:0:", -- Head of Targorr
	[3631]="0:0:12:1:1:::1:0:", -- Bellygrub's Tusk
	[3632]="0:0:12:1:1:::1:0:", -- Fangore's Paw
	[3633]="0:0:12:1:1:::1:0:", -- Head of Gath'Ilzogg
	[3634]="0:0:12:1:1:::1:0:", -- Head of Grimson
	[3635]="0:0:12:1:1:::1:0:", -- Maggot Eye's Paw
	[3636]="0:0:12:1:1:::1:0:", -- Scale of Old Murk-Eye
	[3637]="0:0:12:1:1:::1:0:", -- Head of VanCleef
	[3638]="0:0:12:1:1:::1:0:", -- Sarltooth's Talon
	[3639]="0:0:12:1:1:::1:0:", -- Ear of Balgaras
	[3640]="0:0:12:1:1:::1:0:", -- Head of Deepfury
	[3641]="0:15:4:1:1:Cloth::1:0:", -- Journeyman's Bracers
	[3642]="0:22:4:1:1:Cloth::1:0:", -- Ancestral Bracers
	[3643]="0:71:4:1:1:Cloth::1:0:", -- Spellbinder Bracers
	[3644]="0:47:4:1:1:Cloth::1:0:", -- Barbaric Cloth Bracers
	[3645]="0:189:4:2:1:Cloth::1:0:", -- Seer's Cuffs
	[3647]="0:434:4:2:1:Cloth::1:0:", -- Bright Bracers
	[3649]="0:115:4:1:1:Shield::1:0:", -- Tribal Buckler
	[3650]="0:68:4:1:1:Shield::1:0:", -- Battle Shield
	[3651]="0:435:4:2:1:Shield::1:0:", -- Veteran Shield
	[3652]="0:364:4:2:1:Shield::1:0:", -- Hunting Buckler
	[3653]="0:438:4:2:1:Shield::1:0:", -- Ceremonial Buckler
	[3654]="0:367:4:2:1:Shield::1:0:", -- Brackwater Shield
	[3655]="0:1022:4:2:1:Shield::1:0:", -- Burnished Shield
	[3656]="0:2116:4:2:1:Shield::1:0:", -- Lambent Scale Shield
	[3657]="0:0:12:1:1:::1:0:", -- Hillsbrad Town Registry
	[3658]="0:0:12:1:10:::1:0:", -- Recovered Tome
	[3659]="0:0:12:1:1:::1:0:", -- Worn Leather Book
	[3660]="0:0:12:1:1:::1:0:", -- Tomes of Alterac
	[3661]="0:9:2:1:1:Stave::1:0:", -- Handcrafted Staff
	[3662]="0:25:0:1:20:FoodDrink::1:0:", -- Crocolisk Steak
	[3663]="0:125:0:1:20:FoodDrink::1:0:", -- Murloc Fin Soup
	[3664]="0:100:0:1:20:FoodDrink::1:0:", -- Crocolisk Gumbo
	[3665]="0:150:0:1:20:FoodDrink::1:0:", -- Curiously Tasty Omelet
	[3666]="0:100:0:1:20:FoodDrink::1:0:", -- Gooey Spider Cake
	[3667]="0:25:7:1:10:Meat:185:1:0:", -- Tender Crocolisk Meat
	[3668]="0:0:12:1:1:::1:0:", -- Assassin's Contract
	[3669]="0:195:15:0:5:Junk::1:0:", -- Gelatinous Goo
	[3670]="0:70:15:0:5:Junk::1:0:", -- Large Slimy Bone
	[3671]="0:201:15:0:5:Junk::1:0:", -- Lifeless Skull
	[3672]="0:0:12:1:1:::1:0:", -- Head of Nagaz
	[3673]="0:45:15:0:100:Junk::1:0:", -- Broken Arrow
	[3674]="0:95:15:0:5:Junk::1:0:", -- Decomposed Boot
	[3676]="0:106:15:0:10:Junk::1:0:", -- Slimy Ichor
	[3678]="400:100:9:1:1:Cooking::1:0:340", -- Recipe: Crocolisk Steak
	[3679]="400:100:9:1:1:Cooking::1:0:340", -- Recipe: Blood Sausage
	[3680]="1600:400:9:1:1:Cooking::1:0:340", -- Recipe: Murloc Fin Soup
	[3681]="1600:400:9:1:1:Cooking::1:0:340", -- Recipe: Crocolisk Gumbo
	[3682]="1600:400:9:1:1:Cooking::1:0:340,1148,2821", -- Recipe: Curiously Tasty Omelet
	[3683]="1600:400:9:1:1:Cooking::1:0:340", -- Recipe: Gooey Spider Cake
	[3684]="0:0:12:1:1:::1:0:", -- Perenolde Tiara
	[3685]="0:71:7:1:10:Meat:185:1:0:", -- Raptor Egg
	[3688]="0:0:12:1:1:::1:0:", -- Bloodstone Oval
	[3689]="0:0:12:1:1:::1:0:", -- Bloodstone Marble
	[3690]="0:0:12:1:1:::1:0:", -- Bloodstone Shard
	[3691]="0:0:12:1:1:::1:0:", -- Bloodstone Wedge
	[3692]="0:0:12:1:30:::1:0:", -- Hillsbrad Human Skull
	[3693]="0:0:12:1:1:::1:0:", -- Humbert's Sword
	[3701]="0:0:12:1:1:::1:0:", -- Darthalia's Sealed Commendation
	[3702]="0:498:15:0:10:Junk::1:0:", -- Bear Gall Bladder
	[3703]="145:36:0:1:10:FoodDrink::1:0:2388,20377", -- Southshore Stout
	[3704]="0:0:13:1:1:::1:0:", -- Rusted Iron Key
	[3706]="0:0:12:1:1:::1:0:", -- Ensorcelled Parchment
	[3708]="0:0:12:1:1:::1:0:", -- Helcular's Rod
	[3710]="0:0:12:1:1:::1:0:", -- Rod of Helcular
	[3711]="0:0:12:1:1:::1:0:", -- Belamoore's Research Journal
	[3712]="0:87:7:1:10:Meat:185:1:0:", -- Turtle Meat
	[3713]="160:40:7:0:20:Other::1:0:960,989,1148,1286,1456,2381,2393,2397,2664,2810,2821,3027,3085,3367,3400,3779,3954,3955,4223,4229,4265,4553,4561,4775,4877,4897,5100,5160,5163,5483,5817,6301,7947,8145,8307,8363,8934,9636,11189,12022,12028,12033,12941,12958,14738,15179,16253,16602,16613,16677,16718,16768,16826,17246,17486,18009,18015,18907,18960,18987,18993,19017,19042,19194,19195,19197,19244,19371,19372,19450,19497,19533,19562,20028,20081,20092,20096,20097,20194,20250,20891,21083,21113,22099,23802,24054,24147,24188,24341,24356,24834,24843,24935,24993,24995,25010,25012,25019,25020,25034,25051,25052,25082,25089,26374,26474,26720,26868,26939,26941,27012,27021,27026,27043,27057,27063,27070,27132,27146,27184,27195,27938,28692,28794,28806,28811,28831,28872,29208,29270,29277,29288,29291,30311,30345,30438,30825,31031,31032,31115,32477,32639,32641", -- Soothing Spices
	[3714]="0:0:12:1:20:::1:0:", -- Worn Stone Token
	[3715]="0:0:12:1:20:::1:0:", -- Bracers of Earth Binding
	[3716]="0:0:12:1:20:::1:0:", -- Murloc Head
	[3717]="0:0:12:1:1:::1:0:", -- Sack of Murloc Heads
	[3718]="0:0:12:1:1:::1:0:", -- Foreboding Plans
	[3719]="0:1370:4:2:1:Cloak::1:0:", -- Hillman's Cloak
	[3720]="0:0:12:1:20:::1:0:", -- Yeti Fur
	[3721]="0:0:12:1:1:::1:0:", -- Farren's Report
	[3722]="0:213:15:0:5:Junk::1:0:", -- Familiar Hide
	[3723]="0:68:15:0:5:Junk::1:0:", -- Familiar Fang
	[3724]="0:81:15:0:5:Junk::1:0:", -- Familiar Claw
	[3725]="0:166:15:0:5:Junk::1:0:", -- Familiar Horn
	[3726]="0:125:0:1:20:FoodDrink::1:0:", -- Big Bear Steak
	[3727]="0:125:0:1:20:FoodDrink::1:0:", -- Hot Lion Chops
	[3728]="0:300:0:1:20:FoodDrink::1:0:", -- Tasty Lion Steak
	[3729]="0:300:0:1:20:FoodDrink::1:0:", -- Soothing Turtle Bisque
	[3730]="0:45:7:1:10:Meat:185:1:0:", -- Big Bear Meat
	[3731]="0:55:7:1:10:Meat:185:1:0:", -- Lion Meat
	[3732]="0:801:4:1:1:Cloth::1:0:", -- Hooded Cowl
	[3733]="0:1269:4:2:1:Mail::1:0:", -- Orcish War Chain
	[3734]="1600:400:9:1:1:Cooking::1:0:3960,12246", -- Recipe: Big Bear Steak
	[3735]="1800:450:9:1:1:Cooking::1:0:3489,12245", -- Recipe: Hot Lion Chops
	[3736]="0:500:9:1:1:Cooking::1:0:", -- Recipe: Tasty Lion Steak
	[3737]="0:550:9:1:1:Cooking::1:0:", -- Recipe: Soothing Turtle Bisque
	[3739]="0:1250:4:2:1:Ring::1:0:", -- Skull Ring
	[3740]="0:2452:2:2:1:OneHandSword::1:0:", -- Decapitating Sword
	[3741]="0:923:4:2:1:Leather::1:0:", -- Stomping Boots
	[3742]="0:2862:2:2:1:Bow::1:0:", -- Bow of Plunder
	[3743]="0:2451:4:2:1:Shield::1:0:", -- Sentry Buckler
	[3745]="0:0:12:1:20:::1:0:", -- Rune of Opening
	[3747]="0:1092:4:2:1:Leather::1:0:", -- Meditative Sash
	[3748]="0:1078:4:3:1:Cloth::1:0:", -- Feline Mantle
	[3749]="0:1320:4:2:1:Cloak::1:0:", -- High Apothecary Cloak
	[3750]="0:2209:4:2:1:Leather::1:0:", -- Ribbed Breastplate
	[3751]="0:2661:4:2:1:Mail::1:0:", -- Mercenary Leggings
	[3752]="0:746:4:2:1:Cloth::1:0:", -- Grunt Vest
	[3753]="0:1635:4:2:1:Leather::1:0:", -- Shepherd's Girdle
	[3754]="0:1492:4:2:1:Leather::1:0:", -- Shepherd's Gloves
	[3755]="0:5447:2:2:1:OneHandAxe::1:0:", -- Fish Gutter
	[3758]="0:1817:4:2:1:Mail::1:0:", -- Crusader Belt
	[3759]="0:1216:4:2:1:Cloth::1:0:", -- Insulated Sage Gloves
	[3760]="0:1500:4:2:1:Ring::1:0:", -- Band of the Undercity
	[3761]="0:3306:4:2:1:Shield::1:0:", -- Deadskull Shield
	[3763]="0:6761:4:2:1:Shield::1:0:", -- Lunar Buckler
	[3764]="0:3181:4:2:1:Cloth::1:0:", -- Mantis Boots
	[3765]="0:4811:4:2:1:Mail::1:0:", -- Brigand's Pauldrons
	[3766]="0:30:15:0:10:Junk::1:0:", -- Gryphon Feather Quill
	[3767]="0:23:15:0:5:Junk::1:0:", -- Fine Parchment
	[3769]="0:13:15:0:5:Junk::1:0:", -- Broken Wand
	[3770]="500:25:0:1:20:FoodDrink::5:0:982,1464,2365,2388,2814,3025,3089,3312,3368,3411,3489,3621,3705,3881,3882,3933,3935,3960,4084,4169,4782,4875,4879,4891,4894,4954,5111,5124,5611,5620,5870,6928,6929,7485,7731,7733,8125,9356,11118,11187,12196,12959,14624,14963,14964,15124,15125,15174,15397,16443,16618,16739,17553,17630,17656,19182,23263,23481,23605,24208,24343", -- Mutton Chop
	[3771]="1000:50:0:1:20:FoodDrink::5:0:982,1464,2365,2388,2814,3025,3089,3312,3368,3411,3489,3621,3705,3881,3882,3933,3935,3960,4084,4169,4782,4875,4879,4891,4894,4954,5111,5124,5611,5620,5870,6928,6929,7485,7731,7733,8125,9356,11118,11187,12196,12959,14624,14963,14964,15124,15125,15174,15397,16443,16618,16739,17553,17630,17656,19182,23263,23481,23605,24208,24343", -- Wild Hog Shank
	[3772]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Spring Water
	[3775]="70:17:0:1:20:EnhTemp::1:0:1325,1326,2622,3090,3135,3334,3561,3969,4585,5139,5169,12097,15175,16268,16588,16683,18019,19013,19049,19239,20194,23145,23732,24148,24313,24349,24357,24780,26568,26945,26950,27031,27053,27089,27149,28347,28832,28869,29037,29535,29909,29922,29947,29961,30010,30069,30239,30244,30306,30438,31115,32639,32641", -- Crippling Poison
	[3776]="0:175:15:0:20:Junk::1:0:", -- Crippling Poison II
	[3777]="0:10:15:0:20:Junk::1:0:", -- Lethargy Root
	[3778]="0:1541:2:0:1:Bow::1:0:", -- Taut Compound Bow
	[3779]="0:2835:2:0:1:TwoHandAxe::1:0:", -- Hefty War Axe
	[3780]="0:1877:2:0:1:Gun::1:0:", -- Long-barreled Musket
	[3781]="0:3125:2:0:1:TwoHandSword::1:0:", -- Broad Claymore
	[3782]="0:3451:2:0:1:TwoHandMace::1:0:", -- Large War Club
	[3783]="0:3048:2:0:1:OneHandSword::1:0:", -- Light Scimitar
	[3784]="0:4208:2:0:1:Stave::1:0:", -- Metal Stave
	[3785]="0:3650:2:0:1:OneHandAxe::1:0:", -- Keen Axe
	[3786]="0:3957:2:0:1:Dagger::1:0:", -- Shiny Dirk
	[3787]="0:4289:2:0:1:OneHandMace::1:0:", -- Stone Club
	[3792]="0:521:4:0:1:Cloth::1:0:", -- Interlaced Belt
	[3793]="0:648:4:0:1:Cloth::1:0:", -- Interlaced Boots
	[3794]="0:775:4:0:1:Cloth::1:0:", -- Interlaced Bracers
	[3795]="0:982:4:0:1:Cloak::1:0:", -- Interlaced Cloak
	[3796]="0:493:4:0:1:Cloth::1:0:", -- Interlaced Gloves
	[3797]="0:1692:4:0:1:Cloth::1:0:", -- Interlaced Pants
	[3798]="0:902:4:0:1:Cloth::1:0:", -- Interlaced Shoulderpads
	[3799]="0:1461:4:0:1:Cloth::1:0:", -- Interlaced Vest
	[3800]="0:1068:4:0:1:Leather::1:0:", -- Hardened Leather Belt
	[3801]="0:1031:4:0:1:Leather::1:0:", -- Hardened Leather Boots
	[3802]="0:627:4:0:1:Leather::1:0:", -- Hardened Leather Bracers
	[3803]="0:1086:4:0:1:Cloak::1:0:", -- Hardened Cloak
	[3804]="0:765:4:0:1:Leather::1:0:", -- Hardened Leather Gloves
	[3805]="0:1049:4:0:1:Leather::1:0:", -- Hardened Leather Pants
	[3806]="0:1272:4:0:1:Leather::1:0:", -- Hardened Leather Shoulderpads
	[3807]="0:1162:4:0:1:Leather::1:0:", -- Hardened Leather Tunic
	[3808]="0:770:4:0:1:Mail::1:0:", -- Double Mail Belt
	[3809]="0:962:4:0:1:Mail::1:0:", -- Double Mail Boots
	[3810]="0:1145:4:0:1:Mail::1:0:", -- Double Mail Bracers
	[3811]="0:1064:4:0:1:Cloak::1:0:", -- Double-stitched Cloak
	[3812]="0:971:4:0:1:Mail::1:0:", -- Double Mail Gloves
	[3813]="0:1772:4:0:1:Mail::1:0:", -- Double Mail Pants
	[3814]="0:1891:4:0:1:Mail::1:0:", -- Double Mail Shoulderpads
	[3815]="0:1475:4:0:1:Mail::1:0:", -- Double Mail Vest
	[3816]="0:2102:4:0:1:Shield::1:0:", -- Reflective Heater
	[3817]="0:1585:4:0:1:Shield::1:0:", -- Reinforced Buckler
	[3818]="0:125:7:1:20:Herb:171:1:0:", -- Fadeleaf
	[3819]="0:100:7:1:20:Herb:171,333:1:0:", -- Wintersbite
	[3820]="0:100:7:1:20:Herb:171:1:0:", -- Stranglekelp
	[3821]="0:150:7:1:20:Herb:171,185:1:0:", -- Goldthorn
	[3822]="0:6481:2:2:1:TwoHandSword::1:0:", -- Runic Darkblade
	[3823]="0:100:0:1:5:Potion:164:1:0:", -- Lesser Invisibility Potion
	[3824]="0:150:0:1:5:EnhTemp:171,164,755,165,197:1:0:", -- Shadow Oil
	[3825]="0:110:0:1:20:Elixir::1:0:", -- Elixir of Fortitude
	[3826]="0:105:0:1:20:Elixir::1:0:", -- Mighty Troll's Blood Elixir
	[3827]="480:120:0:1:5:Potion:755,197:1:1:2380,2480,2812,2848,12245", -- Mana Potion
	[3828]="0:150:0:1:20:Elixir::1:0:", -- Elixir of Detect Lesser Invisibility
	[3829]="0:150:0:1:5:EnhTemp:164,333,202,197:1:0:", -- Frost Oil
	[3830]="0:500:9:1:1:Alchemy::1:0:", -- Recipe: Elixir of Fortitude
	[3831]="0:550:9:2:1:Alchemy::1:0:", -- Recipe: Mighty Troll's Blood Elixir
	[3832]="0:550:9:2:1:Alchemy::1:0:", -- Recipe: Elixir of Detect Lesser Invisibility
	[3833]="0:24:4:1:1:Cloak::1:0:", -- Adept's Cloak
	[3834]="0:32:4:1:1:Cloth::1:0:", -- Sturdy Cloth Trousers
	[3835]="0:1844:4:2:1:Mail::1:0:", -- Green Iron Bracers
	[3836]="0:3053:4:2:1:Mail::1:0:", -- Green Iron Helm
	[3837]="0:4405:4:2:1:Mail::1:0:", -- Golden Scale Coif
	[3838]="0:0:12:1:20:::1:0:", -- Shadowmaw Claw
	[3839]="0:0:12:1:1:::1:0:", -- Pristine Tigress Fang
	[3840]="0:2571:4:2:1:Mail::1:0:", -- Green Iron Shoulders
	[3841]="0:3106:4:2:1:Mail::1:0:", -- Golden Scale Shoulders
	[3842]="0:2906:4:2:1:Mail::1:0:", -- Green Iron Leggings
	[3843]="0:3882:4:2:1:Mail::1:0:", -- Golden Scale Leggings
	[3844]="0:5658:4:3:1:Mail::1:0:", -- Green Iron Hauberk
	[3845]="0:6558:4:2:1:Mail::1:0:", -- Golden Scale Cuirass
	[3846]="0:3937:4:2:1:Mail::1:0:", -- Polished Steel Boots
	[3847]="0:4977:4:2:1:Mail::1:0:", -- Golden Scale Boots
	[3848]="0:1426:2:2:1:Dagger::1:0:", -- Big Bronze Knife
	[3849]="0:5468:2:2:1:OneHandSword::1:0:", -- Hardened Iron Shortsword
	[3850]="0:7304:2:2:1:OneHandSword::1:0:", -- Jade Serpentblade
	[3851]="0:6258:2:2:1:TwoHandMace::1:0:", -- Solid Iron Maul
	[3852]="0:8361:2:2:1:TwoHandMace::1:0:", -- Golden Iron Destroyer
	[3853]="0:10153:2:2:1:TwoHandSword::1:0:", -- Moonsteel Broadsword
	[3854]="0:14120:2:2:1:TwoHandSword::1:0:", -- Frost Tiger Blade
	[3855]="0:11248:2:2:1:TwoHandAxe::1:0:", -- Massive Iron Axe
	[3856]="0:14221:2:2:1:TwoHandAxe::1:0:", -- Shadow Crescent Axe
	[3857]="500:125:7:1:10:MetalStone:186:1:0:372,790,960,989,1148,1286,1456,1690,2225,2381,2393,2810,2821,2844,2847,2999,3002,3133,3167,3343,3356,3358,3367,3392,3477,3578,3779,3954,3955,4229,4256,4257,4259,4561,4597,4599,4775,4877,4897,5100,5135,5163,5411,5512,5514,5817,6298,6300,6301,7947,8145,8161,8176,8363,8934,9179,9636,11186,11189,12022,12028,12245,12941,12957,12958,14624,14737,15176,15179,15400,16376,16583,16613,16664,16670,16713,16751,16768,16823,17245,17486,17655,18009,19011,19012,19056,19244,19342,19372,19450,19520,19530,19662,19879,20082,20463,20981,22264,22476,23144,23724,23908,24052,24843,24935,24995,25010,25019,25051,25082,26081,26599,26934,27019,27021,27026,27043,27045,27057,27062,27134,27267,28344,28692,28716,28728,28796,28831,28872,29252,29253,29288,29907,29923,29964,29969,30241,30253,30311,30336,30436,31024,32594,33599", -- Coal
	[3858]="0:250:7:1:20:MetalStone:171,186:1:0:", -- Mithril Ore
	[3859]="0:60:7:1:20:MetalStone:164,202:1:0:", -- Steel Bar
	[3860]="0:400:7:1:20:MetalStone:171,164,202,755:1:0:", -- Mithril Bar
	[3862]="0:0:12:1:1:::1:0:", -- Aged Gorilla Sinew
	[3863]="0:0:12:1:20:::1:0:", -- Jungle Stalker Feather
	[3864]="0:800:3:2:20:GemSimple:164,202,755,165,197:1:0:", -- Citrine
	[3866]="0:1000:9:2:1:Blacksmithing::1:0:", -- Plans: Jade Serpentblade
	[3867]="0:950:9:2:1:Blacksmithing::1:0:", -- Plans: Golden Iron Destroyer
	[3868]="0:1250:9:2:1:Blacksmithing::1:0:", -- Plans: Frost Tiger Blade
	[3869]="0:1250:9:2:1:Blacksmithing::1:0:", -- Plans: Shadow Crescent Axe
	[3870]="0:750:9:2:1:Blacksmithing::1:0:", -- Plans: Green Iron Shoulders
	[3871]="0:850:9:3:1:Blacksmithing::1:0:", -- Plans: Golden Scale Shoulders
	[3872]="0:800:9:2:1:Blacksmithing::1:0:", -- Plans: Golden Scale Leggings
	[3873]="0:1100:9:2:1:Blacksmithing::1:0:", -- Plans: Golden Scale Cuirass
	[3874]="0:1100:9:2:1:Blacksmithing::1:0:", -- Plans: Polished Steel Boots
	[3875]="0:1250:9:3:1:Blacksmithing::1:0:", -- Plans: Golden Scale Boots
	[3876]="0:0:12:1:1:::1:0:", -- Fang of Bhag'thera
	[3877]="0:0:12:1:1:::1:0:", -- Talon of Tethis
	[3879]="0:0:12:1:1:::1:0:", -- Paw of Sin'Dall
	[3880]="0:0:12:1:1:::1:0:", -- Head of Bangalash
	[3882]="0:13:15:0:10:Junk::1:0:", -- Buzzard Feather
	[3889]="7923:1584:4:1:1:Cloth::1:0:1147,1310,1314,1407,2849,3092,3315,3316,4175,5155,5821,8159,10293", -- Russet Hat
	[3890]="10201:2040:4:1:1:Leather::1:0:1147,1310,1314,1320,1407,3315,3316,4236,5129,5820,8159", -- Studded Hat
	[3891]="12285:2457:4:1:1:Mail::1:0:1310,1322,1323,1349,1381,2845,3095,4177,5125,5812,5819,8129", -- Augmented Chain Helm
	[3892]="21940:4388:4:1:1:Cloth::1:0:984,1310,1314,2849,3092,3315,3316,4175,5129,5155,5821,10293,11183,12023,26707", -- Embroidered Hat
	[3893]="27523:5504:4:1:1:Leather::1:0:984,1310,1314,1320,3315,3316,4236,5129,5820,11183,12023,26707,27037", -- Reinforced Leather Cap
	[3894]="29986:5997:4:1:1:Mail::1:0:980,1310,1323,1349,3095,4177,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Brigandine Helm
	[3897]="0:0:12:1:1:::1:0:", -- Dizzy's Eye
	[3898]="0:0:12:1:1:::1:0:", -- Library Scrip
	[3899]="0:25:15:0:1:Junk::1:0:", -- "Legends of the Gurubashi, Volume 3"
	[3900]="0:0:12:1:20:::1:0:", -- Pupellyverbos Port
	[3901]="0:0:12:1:20:::1:0:", -- Bloodscalp Tusk
	[3902]="0:1317:2:2:1:Stave::1:0:", -- Staff of Nobles
	[3904]="0:0:12:1:1:::1:0:", -- Gan'zulah's Head
	[3905]="0:0:12:1:1:::1:0:", -- Nezzliok's Head
	[3906]="0:0:12:1:20:::1:0:", -- Balia'mah Trophy
	[3907]="0:0:12:1:20:::1:0:", -- Ziata'jai Trophy
	[3908]="0:0:12:1:20:::1:0:", -- Zul'Mamwe Trophy
	[3909]="0:0:12:1:1:::1:0:", -- Broken Armor of Ana'thek
	[3910]="0:0:12:1:20:::1:0:", -- Snuff
	[3911]="0:0:12:1:20:::1:0:", -- Pulsing Blue Shard
	[3912]="0:0:12:1:1:::1:0:", -- Soul Gem
	[3913]="0:0:12:1:1:::1:0:", -- Filled Soul Gem
	[3914]="0:6250:1:1:1:Bag::1:0:", -- Journeyman's Backpack
	[3915]="0:0:12:1:25:::1:0:", -- Bloody Bone Necklace
	[3916]="0:0:12:1:25:::1:0:", -- Split Bone Necklace
	[3917]="0:0:12:1:20:::1:0:", -- Singing Blue Crystal
	[3918]="0:0:12:1:20:::1:0:", -- Singing Crystal Shard
	[3919]="0:0:12:1:20:::1:0:", -- Mistvale Giblets
	[3920]="0:0:12:1:1:::1:0:", -- Bloodsail Charts
	[3921]="0:0:12:1:1:::1:0:", -- Bloodsail Orders
	[3922]="0:0:12:1:1:::1:0:", -- Shaky's Payment
	[3923]="0:0:12:1:20:::1:0:", -- Water Elemental Bracers
	[3924]="0:0:12:1:1:::1:0:", -- Maury's Clubbed Foot
	[3925]="0:0:12:1:1:::1:0:", -- Jon-Jon's Golden Spyglass
	[3926]="0:0:12:1:1:::1:0:", -- Chucky's Huge Ring
	[3927]="2000:150:0:1:20:FoodDrink::5:0:295,465,483,1237,2352,2364,3298,3546,4782,4891,4894,4981,5620,6746,6790,6930,9501,11106,11116,16553,17630,18929,23521,23604,24934", -- Fine Aged Cheddar
	[3928]="1000:250:0:1:5:Potion::1:1:983,8157,8158,8178,11188,14847,18905", -- Superior Healing Potion
	[3930]="0:0:13:1:1:::1:0:", -- Maury's Key
	[3931]="0:185:15:0:5:Junk::1:0:", -- Poisoned Spider Fang
	[3932]="0:0:12:1:1:::1:0:", -- Smotts' Chest
	[3935]="0:0:2:1:1:OneHandSword::1:0:", -- Smotts' Cutlass
	[3936]="0:985:4:0:1:Cloth::1:0:", -- Crochet Belt
	[3937]="0:2018:4:0:1:Cloth::1:0:", -- Crochet Boots
	[3938]="0:1189:4:0:1:Cloth::1:0:", -- Crochet Bracers
	[3939]="0:2256:4:0:1:Cloak::1:0:", -- Crochet Cloak
	[3940]="0:1630:4:0:1:Cloth::1:0:", -- Crochet Gloves
	[3941]="0:2598:4:0:1:Cloth::1:0:", -- Crochet Pants
	[3942]="0:2636:4:0:1:Cloth::1:0:", -- Crochet Shoulderpads
	[3943]="0:2244:4:0:1:Cloth::1:0:", -- Crochet Vest
	[3944]="0:2277:4:0:1:Cloth::1:0:", -- Twill Belt
	[3945]="0:3852:4:0:1:Cloth::1:0:", -- Twill Boots
	[3946]="0:2432:4:0:1:Cloth::1:0:", -- Twill Bracers
	[3947]="0:3258:4:0:1:Cloak::1:0:", -- Twill Cloak
	[3948]="0:3092:4:0:1:Cloth::1:0:", -- Twill Gloves
	[3949]="0:6517:4:0:1:Cloth::1:0:", -- Twill Pants
	[3950]="0:4157:4:0:1:Cloth::1:0:", -- Twill Shoulderpads
	[3951]="0:5897:4:0:1:Cloth::1:0:", -- Twill Vest
	[3960]="0:0:12:1:1:::1:0:", -- Bag of Water Elemental Bracers
	[3961]="0:1503:4:0:1:Leather::1:0:", -- Thick Leather Belt
	[3962]="0:3080:4:0:1:Leather::1:0:", -- Thick Leather Boots
	[3963]="0:1402:4:0:1:Leather::1:0:", -- Thick Leather Bracers
	[3964]="0:2127:4:0:1:Cloak::1:0:", -- Thick Cloak
	[3965]="0:2221:4:0:1:Leather::1:0:", -- Thick Leather Gloves
	[3966]="0:2625:4:0:1:Leather::1:0:", -- Thick Leather Pants
	[3967]="0:2904:4:0:1:Leather::1:0:", -- Thick Leather Shoulderpads
	[3968]="0:3331:4:0:1:Leather::1:0:", -- Thick Leather Tunic
	[3969]="0:3256:4:0:1:Leather::1:0:", -- Smooth Leather Belt
	[3970]="0:4296:4:0:1:Leather::1:0:", -- Smooth Leather Boots
	[3971]="0:3811:4:0:1:Leather::1:0:", -- Smooth Leather Bracers
	[3972]="0:3891:4:0:1:Cloak::1:0:", -- Smooth Cloak
	[3973]="0:3657:4:0:1:Leather::1:0:", -- Smooth Leather Gloves
	[3974]="0:5487:4:0:1:Leather::1:0:", -- Smooth Leather Pants
	[3975]="0:3896:4:0:1:Leather::1:0:", -- Smooth Leather Shoulderpads
	[3976]="0:6979:4:0:1:Leather::1:0:", -- Smooth Leather Armor
	[3985]="0:0:4:2:1:Cloth::1:0:", -- Monogrammed Sash
	[3986]="0:5332:4:0:1:Shield::1:0:", -- Protective Pavise
	[3987]="0:6837:4:0:1:Shield::1:0:", -- Deflecting Tower
	[3989]="0:3154:4:0:1:Shield::1:0:", -- Blocking Targe
	[3990]="0:8237:4:0:1:Shield::1:0:", -- Crested Buckler
	[3992]="0:3082:4:0:1:Mail::1:0:", -- Laminated Scale Belt
	[3993]="0:4940:4:0:1:Mail::1:0:", -- Laminated Scale Boots
	[3994]="0:4404:4:0:1:Mail::1:0:", -- Laminated Scale Bracers
	[3995]="0:4171:4:0:1:Cloak::1:0:", -- Laminated Scale Cloak
	[3996]="0:4660:4:0:1:Mail::1:0:", -- Laminated Scale Gloves
	[3997]="0:7929:4:0:1:Mail::1:0:", -- Laminated Scale Pants
	[3998]="0:5656:4:0:1:Mail::1:0:", -- Laminated Scale Shoulderpads
	[3999]="0:7109:4:0:1:Mail::1:0:", -- Laminated Scale Armor
	[4000]="0:1797:4:0:1:Mail::1:0:", -- Overlinked Chain Belt
	[4001]="0:3170:4:0:1:Mail::1:0:", -- Overlinked Chain Boots
	[4002]="0:2463:4:0:1:Mail::1:0:", -- Overlinked Chain Bracers
	[4003]="0:2714:4:0:1:Cloak::1:0:", -- Overlinked Chain Cloak
	[4004]="0:2357:4:0:1:Mail::1:0:", -- Overlinked Chain Gloves
	[4005]="0:3478:4:0:1:Mail::1:0:", -- Overlinked Chain Pants
	[4006]="0:2434:4:0:1:Mail::1:0:", -- Overlinked Chain Shoulderpads
	[4007]="0:3696:4:0:1:Mail::1:0:", -- Overlinked Chain Armor
	[4016]="0:0:12:1:20:::1:0:", -- Zanzil's Mixture
	[4017]="0:6910:2:0:1:OneHandSword::1:0:", -- Sharp Shortsword
	[4018]="0:6372:2:0:1:TwoHandSword::1:0:", -- Whetted Claymore
	[4019]="0:8336:2:0:1:OneHandAxe::1:0:", -- Heavy Flint Axe
	[4020]="0:11189:2:0:1:TwoHandAxe::1:0:", -- Splintering Battle Axe
	[4021]="0:7198:2:0:1:OneHandMace::1:0:", -- Blunting Mace
	[4022]="0:12059:2:0:1:TwoHandMace::1:0:", -- Crushing Maul
	[4023]="0:6216:2:0:1:Dagger::1:0:", -- Fine Pointed Dagger
	[4024]="0:9822:2:0:1:Stave::1:0:", -- Heavy War Staff
	[4025]="0:5070:2:0:1:Bow::1:0:", -- Balanced Long Bow
	[4026]="0:4362:2:0:1:Gun::1:0:", -- Sentinel Musket
	[4027]="0:0:12:1:1:::1:0:", -- Catelyn's Blade
	[4028]="0:0:12:1:1:::1:0:", -- Bundle of Akiris Reeds
	[4029]="0:0:12:1:20:::1:0:", -- Akiris Reed
	[4034]="0:0:12:1:1:::1:0:", -- Stone of the Tides
	[4035]="0:1989:4:2:1:Cloth::1:0:", -- Silver-thread Robe
	[4036]="0:681:4:2:1:Cloth::1:0:", -- Silver-thread Cuffs
	[4037]="0:1821:4:2:1:Cloth::1:0:", -- Silver-thread Pants
	[4038]="0:3562:4:2:1:Cloth::1:0:", -- Nightsky Robe
	[4039]="0:2215:4:2:1:Cloth::1:0:", -- Nightsky Cowl
	[4040]="0:1347:4:2:1:Cloth::1:0:", -- Nightsky Gloves
	[4041]="0:3149:4:2:1:Cloth::1:0:", -- Aurora Cowl
	[4042]="0:2107:4:2:1:Cloth::1:0:", -- Aurora Gloves
	[4043]="0:1958:4:2:1:Cloth::1:0:", -- Aurora Bracers
	[4044]="0:4584:4:2:1:Cloth::1:0:", -- Aurora Pants
	[4045]="0:2683:4:2:1:Cloth::1:0:", -- Mistscape Bracers
	[4046]="0:6783:4:2:1:Cloth::1:0:", -- Mistscape Pants
	[4047]="0:3959:4:2:1:Cloth::1:0:", -- Mistscape Boots
	[4048]="0:1767:4:2:1:Leather::1:0:", -- Emblazoned Hat
	[4049]="0:888:4:2:1:Leather::1:0:", -- Emblazoned Bracers
	[4050]="0:2375:4:2:1:Leather::1:0:", -- Emblazoned Leggings
	[4051]="0:1670:4:2:1:Leather::1:0:", -- Emblazoned Boots
	[4052]="0:2699:4:2:1:Leather::1:0:", -- Insignia Cap
	[4053]="0:0:12:1:20:::1:0:", -- Large River Crocolisk Skin
	[4054]="0:3626:4:2:1:Leather::1:0:", -- Insignia Leggings
	[4055]="0:2481:4:2:1:Leather::1:0:", -- Insignia Boots
	[4056]="0:0:12:1:1:::1:0:", -- Cortello's Riddle
	[4057]="0:4032:4:2:1:Leather::1:0:", -- Insignia Chestguard
	[4058]="0:6056:4:2:1:Leather::1:0:", -- Glyphed Breastplate
	[4059]="0:2234:4:2:1:Leather::1:0:", -- Glyphed Bracers
	[4060]="0:5648:4:2:1:Leather::1:0:", -- Glyphed Leggings
	[4061]="0:3306:4:2:1:Leather::1:0:", -- Imperial Leather Bracers
	[4062]="0:8359:4:2:1:Leather::1:0:", -- Imperial Leather Pants
	[4063]="0:3596:4:2:1:Leather::1:0:", -- Imperial Leather Gloves
	[4064]="0:2987:4:2:1:Shield::1:0:", -- Emblazoned Buckler
	[4065]="0:5311:4:2:1:Shield::1:0:", -- Combat Shield
	[4066]="0:4845:4:2:1:Shield::1:0:", -- Insignia Buckler
	[4067]="0:6381:4:2:1:Shield::1:0:", -- Glyphed Buckler
	[4068]="0:6918:4:2:1:Shield::1:0:", -- Chief Brigadier Shield
	[4069]="0:11900:4:2:1:Shield::1:0:", -- Blackforge Buckler
	[4070]="0:7527:4:2:1:Shield::1:0:", -- Jouster's Crest
	[4071]="0:2939:4:2:1:Mail::1:0:", -- Glimmering Mail Breastplate
	[4072]="0:1340:4:2:1:Mail::1:0:", -- Glimmering Mail Gauntlets
	[4073]="0:2230:4:2:1:Mail::1:0:", -- Glimmering Mail Greaves
	[4074]="0:4785:4:2:1:Mail::1:0:", -- Mail Combat Armor
	[4075]="0:1984:4:2:1:Mail::1:0:", -- Mail Combat Gauntlets
	[4076]="0:3301:4:2:1:Mail::1:0:", -- Mail Combat Boots
	[4077]="0:3298:4:2:1:Mail::1:0:", -- Mail Combat Headguard
	[4078]="0:4672:4:2:1:Mail::1:0:", -- Chief Brigadier Coif
	[4079]="0:6753:4:2:1:Mail::1:0:", -- Chief Brigadier Leggings
	[4080]="0:7469:4:2:1:Mail::1:0:", -- Blackforge Cowl
	[4082]="0:11699:4:2:1:Mail::1:0:", -- Blackforge Breastplate
	[4083]="0:4328:4:2:1:Mail::1:0:", -- Blackforge Gauntlets
	[4084]="0:10136:4:2:1:Mail::1:0:", -- Blackforge Leggings
	[4085]="0:0:12:1:1:::1:0:", -- Krazek's Crock Pot
	[4086]="0:6386:2:2:1:Gun::1:0:", -- Flash Rifle
	[4087]="0:8722:2:2:1:Bow::1:0:", -- Trueshot Bow
	[4088]="0:18523:2:2:1:Dagger::1:0:", -- Dreadblade
	[4089]="0:15060:2:2:1:Gun::1:0:", -- Ricochet Blunderbuss
	[4090]="0:20736:2:3:1:OneHandMace::1:0:", -- Mug O' Hurt
	[4091]="0:22479:2:3:1:Dagger::1:0:", -- Widowmaker
	[4092]="0:1296:15:0:5:Junk::1:0:", -- Prismatic Basilisk Scale
	[4093]="0:713:15:0:5:Junk::1:0:", -- Large Basilisk Tail
	[4094]="0:0:12:1:1:::1:0:", -- Tablet Shard
	[4096]="0:608:15:1:10:Junk:165:1:0:", -- Coarse Gorilla Hair
	[4097]="0:305:15:0:10:Junk::1:0:", -- Chipped Gorilla Tooth
	[4098]="0:0:12:1:1:::1:0:", -- Carefully Folded Note
	[4099]="0:1131:15:0:5:Junk::1:0:", -- Tuft of Gorilla Hair
	[4100]="0:23:15:0:10:Junk::1:0:", -- Crumpled Note
	[4101]="0:26:15:0:10:Junk::1:0:", -- Ripped Note
	[4102]="0:33:15:0:10:Junk::1:0:", -- Torn Note
	[4103]="0:0:13:1:1:::1:0:", -- Shackle Key
	[4104]="0:0:12:1:20:::1:0:", -- Snapjaw Crocolisk Skin
	[4105]="0:0:12:1:20:::1:0:", -- Elder Crocolisk Skin
	[4106]="0:0:12:1:20:::1:0:", -- Tumbled Crystal
	[4107]="0:2136:4:2:1:Leather::1:0:", -- Tiger Hunter Gloves
	[4108]="0:5403:4:2:1:Leather::1:0:", -- Panther Hunter Leggings
	[4109]="0:4393:4:2:1:Leather::1:0:", -- Excelsior Boots
	[4110]="0:11999:2:2:1:Bow::1:0:", -- Master Hunter's Bow
	[4111]="0:12043:2:2:1:Gun::1:0:", -- Master Hunter's Rifle
	[4112]="0:4182:4:2:1:Amulet::1:0:", -- Choker of the High Shaman
	[4113]="0:4853:4:2:1:Cloak::1:0:", -- Medicine Blanket
	[4114]="0:3866:4:2:1:Cloak::1:0:", -- Darktide Cape
	[4115]="0:5783:4:2:1:Shield::1:0:", -- Grom'gol Buckler
	[4116]="0:12337:2:2:1:OneHandSword::1:0:", -- Olmann Sewar
	[4117]="0:3119:4:2:1:Cloth::1:0:", -- Scorching Sash
	[4118]="0:7313:4:2:1:Mail::1:0:", -- Poobah's Nose Ring
	[4119]="0:7271:4:2:1:Leather::1:0:", -- Raptor Hunter Tunic
	[4120]="0:5031:4:3:1:Cloth::1:0:", -- Robe of Crystal Waters
	[4121]="0:1380:4:2:1:Cloth::1:0:", -- Gemmed Gloves
	[4122]="0:8384:2:2:1:OneHandMace::1:0:", -- Bookmaker's Scepter
	[4123]="0:3804:4:2:1:Mail::1:0:", -- Frost Metal Pauldrons
	[4124]="0:3991:4:2:1:Leather::1:0:", -- Cap of Harmony
	[4125]="0:3142:4:2:1:OffHandFrill::1:0:", -- Tranquil Orb
	[4126]="0:6396:2:2:1:OneHandAxe::1:0:", -- Guerrilla Cleaver
	[4127]="0:8073:2:2:1:Gun::1:0:", -- Shrapnel Blaster
	[4128]="0:14588:2:2:1:TwoHandMace::1:0:", -- Silver Spade
	[4129]="0:9444:4:2:1:Shield::1:0:", -- Collection Plate
	[4130]="0:2171:4:2:1:Trinket::1:0:", -- Smotts' Compass
	[4131]="0:3815:4:2:1:Leather::1:0:", -- Belt of Corruption
	[4132]="0:2681:4:2:1:Mail::1:0:", -- Darkspear Armsplints
	[4133]="0:1794:4:2:1:Cloth::1:0:", -- Darkspear Cuffs
	[4134]="0:26994:2:3:1:Stave::1:0:", -- Nimboya's Mystical Staff
	[4135]="0:1130:4:2:1:Ring::1:0:", -- Bloodbone Band
	[4136]="0:6022:4:2:1:Mail::1:0:", -- Darkspear Boots
	[4137]="0:4010:4:2:1:Cloth::1:0:", -- Darkspear Shoes
	[4138]="0:10140:4:2:1:Mail::1:0:", -- Blackwater Tunic
	[4139]="0:2749:4:2:1:Cloth::1:0:", -- Junglewalker Sandals
	[4140]="0:1875:4:2:1:Cloth::1:0:", -- Palm Frond Mantle
	[4197]="0:2765:4:3:1:Cloth::1:0:", -- Berylline Pads
	[4213]="0:2500:9:2:1:Book::1:0:", -- Grimoire of Doom
	[4231]="0:110:7:1:20:Leather:165:1:0:", -- Cured Light Hide
	[4232]="0:125:7:1:10:Leather:165:1:0:", -- Medium Hide
	[4233]="0:200:7:1:20:Leather:165:1:0:", -- Cured Medium Hide
	[4234]="600:150:7:1:20:Leather:164,202,165,197:1:1:14846", -- Heavy Leather
	[4235]="0:200:7:1:10:Leather:165:1:0:", -- Heavy Hide
	[4236]="0:225:7:1:20:Leather:165:1:0:", -- Cured Heavy Hide
	[4237]="0:35:4:1:1:Leather::1:0:", -- Handstitched Leather Belt
	[4238]="0:200:1:1:1:Bag::1:0:", -- Linen Bag
	[4239]="0:119:4:2:1:Leather::1:0:", -- Embossed Leather Gloves
	[4240]="0:300:1:1:1:Bag::1:0:", -- Woolen Bag
	[4241]="0:450:1:1:1:Bag::1:0:", -- Green Woolen Bag
	[4242]="0:347:4:2:1:Leather::1:0:", -- Embossed Leather Pants
	[4243]="0:461:4:2:1:Leather:165:1:0:", -- Fine Leather Tunic
	[4244]="0:723:4:2:1:Leather::1:0:", -- Hillman's Leather Vest
	[4245]="0:2000:1:1:1:Bag::1:0:", -- Small Silk Pack
	[4246]="0:208:4:2:1:Leather:165:1:0:", -- Fine Leather Belt
	[4247]="0:1049:4:2:1:Leather::1:0:", -- Hillman's Leather Gloves
	[4248]="0:791:4:2:1:Leather::1:0:", -- Dark Leather Gloves
	[4249]="0:703:4:2:1:Leather::1:0:", -- Dark Leather Belt
	[4250]="0:705:4:2:1:Leather::1:0:", -- Hillman's Belt
	[4251]="0:1200:4:2:1:Leather::1:0:", -- Hillman's Shoulders
	[4252]="0:1457:4:2:1:Leather::1:0:", -- Dark Leather Shoulders
	[4253]="0:962:4:3:1:Leather::1:0:", -- Toughened Leather Gloves
	[4254]="0:1071:4:2:1:Leather::1:0:", -- Barbaric Gloves
	[4255]="0:2366:4:2:1:Leather:164:1:0:", -- Green Leather Armor
	[4256]="0:3477:4:2:1:Leather::1:0:", -- Guardian Armor
	[4257]="0:1311:4:2:1:Leather::1:0:", -- Green Leather Belt
	[4258]="0:1592:4:2:1:Leather::1:0:", -- Guardian Belt
	[4259]="0:1934:4:2:1:Leather::1:0:", -- Green Leather Bracers
	[4260]="0:2559:4:2:1:Leather::1:0:", -- Guardian Leather Bracers
	[4261]="0:32:4:1:1:Cloth::1:0:", -- Solliden's Trousers
	[4262]="0:2652:4:3:1:Leather::1:0:", -- Gem-studded Leather Belt
	[4263]="0:94:4:1:1:Shield::1:0:", -- Standard Issue Shield
	[4264]="0:2804:4:2:1:Leather::1:0:", -- Barbaric Belt
	[4265]="0:650:0:1:10:EnhPerm::1:0:", -- Heavy Armor Kit
	[4278]="0:25:12:1:20:::1:0:", -- Lesser Bloodstone Ore
	[4289]="50:12:7:1:20:Leather:165:1:0:66,777,843,960,989,1148,1250,1286,1456,1465,1692,2118,2225,2381,2393,2697,2698,2699,2810,2816,2819,2821,2846,3005,3081,3168,3187,3366,3367,3482,3499,3556,3614,3779,3954,3955,3958,4194,4225,4229,4561,4589,4775,4877,4897,5100,5128,5135,5163,5565,5783,5817,5944,6301,6731,7852,7854,7947,8145,8160,8363,8934,9636,11189,11874,12022,12028,12043,12245,12941,12942,12943,12956,12957,12958,15179,16224,16261,16262,16613,16689,16748,16768,17486,17490,18009,18277,18426,18427,18754,18771,19196,19244,19372,19450,19532,21085,24843,24935,24995,25010,25019,25051,25082,27021,27026,27037,27043,27057,28692,28718,28798,28831,28872,29288,30311,33601", -- Salt
	[4290]="0:715:4:2:1:Shield::1:0:", -- Dust Bowl
	[4291]="500:125:7:1:20:Cloth:165,197:1:0:960,989,1148,1286,1347,1454,1456,1474,1672,2225,2381,2393,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3091,3096,3364,3366,3367,3485,3779,3954,3955,3958,4168,4189,4225,4229,4561,4577,4589,4775,4877,4897,5100,5128,5135,5154,5163,5565,5783,5817,5944,6301,6567,6568,6574,6576,6731,7852,7854,7940,7947,8145,8160,8363,8681,8934,9636,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12957,12958,15165,15179,16366,16613,16638,16689,16748,16767,16768,17486,18009,18277,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,24995,25010,25019,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,33596,33601", -- Silken Thread
	[4292]="0:200:9:2:1:Tailoring::1:0:", -- Pattern: Green Woolen Bag
	[4293]="0:162:9:2:1:Leatherworking::1:0:", -- Pattern: Hillman's Leather Vest
	[4294]="0:400:9:2:1:Leatherworking::1:0:", -- Pattern: Hillman's Belt
	[4296]="0:525:9:2:1:Leatherworking::1:0:", -- Pattern: Dark Leather Shoulders
	[4297]="0:500:9:2:1:Leatherworking::1:0:", -- Pattern: Barbaric Gloves
	[4298]="0:162:9:3:1:Leatherworking::1:0:", -- Pattern: Guardian Belt
	[4299]="0:500:9:2:1:Leatherworking::1:0:", -- Pattern: Guardian Armor
	[4300]="0:700:9:2:1:Leatherworking::1:0:", -- Pattern: Guardian Leather Bracers
	[4301]="0:875:9:3:1:Leatherworking::1:0:", -- Pattern: Barbaric Belt
	[4302]="0:146:2:1:1:Dagger::1:0:", -- Small Green Dagger
	[4303]="0:398:2:2:1:OneHandMace::1:0:", -- Cranial Thumper
	[4304]="1200:300:7:1:20:Leather:164,202,165,197:1:1:14846", -- Thick Leather
	[4305]="2400:600:7:1:20:Cloth:165,197:1:1:16631", -- Bolt of Silk Cloth
	[4306]="600:150:7:1:20:Cloth:164,202,129,197:1:1:16631", -- Silk Cloth
	[4307]="0:49:4:2:1:Cloth::1:0:", -- Heavy Linen Gloves
	[4308]="0:75:4:2:1:Cloth::1:0:", -- Green Linen Bracers
	[4309]="0:226:4:2:1:Cloth::1:0:", -- Handstitched Linen Britches
	[4310]="0:180:4:2:1:Cloth::1:0:", -- Heavy Woolen Gloves
	[4311]="0:475:4:2:1:Cloak::1:0:", -- Heavy Woolen Cloak
	[4312]="0:237:4:2:1:Cloth::1:0:", -- Soft-soled Linen Boots
	[4313]="0:416:4:2:1:Cloth::1:0:", -- Red Woolen Boots
	[4314]="0:553:4:2:1:Cloth::1:0:", -- Double-stitched Woolen Shoulders
	[4315]="0:709:4:2:1:Cloth::1:0:", -- Reinforced Woolen Shoulders
	[4316]="0:743:4:2:1:Cloth::1:0:", -- Heavy Woolen Pants
	[4317]="0:1076:4:2:1:Cloth::1:0:", -- Phoenix Pants
	[4318]="0:610:4:2:1:Cloth::1:0:", -- Gloves of Meditation
	[4319]="0:815:4:2:1:Cloth::1:0:", -- Azure Silk Gloves
	[4320]="0:866:4:3:1:Cloth::1:0:", -- Spidersilk Boots
	[4321]="0:1120:4:2:1:Cloth::1:0:", -- Spider Silk Slippers
	[4322]="0:1810:4:2:1:Cloth::1:0:", -- Enchanter's Cowl
	[4323]="0:1999:4:2:1:Cloth::1:0:", -- Shadow Hood
	[4324]="0:1874:4:2:1:Cloth::1:0:", -- Azure Silk Vest
	[4325]="0:2272:4:2:1:Cloth::1:0:", -- Boots of the Enchanter
	[4326]="0:2496:4:2:1:Cloak::1:0:", -- Long Silken Cloak
	[4327]="0:3788:4:3:1:Cloak::1:0:", -- Icy Cloak
	[4328]="0:1524:4:2:1:Cloth::1:0:", -- Spider Belt
	[4329]="0:2120:4:2:1:Cloth::1:0:", -- Star Belt
	[4330]="0:250:4:1:1:Shirt::1:0:", -- Stylish Red Shirt
	[4331]="0:526:4:2:1:Cloth::1:0:", -- Phoenix Gloves
	[4332]="0:500:4:1:1:Shirt::1:0:", -- Bright Yellow Shirt
	[4333]="0:1200:4:1:1:Shirt::1:0:", -- Dark Silk Shirt
	[4334]="0:550:4:1:1:Shirt::1:0:", -- Formal White Shirt
	[4335]="0:1500:4:1:1:Shirt::1:0:", -- Rich Purple Silk Shirt
	[4336]="0:1500:4:1:1:Shirt::1:0:", -- Black Swashbuckler's Shirt
	[4337]="0:750:7:1:10:Cloth:202,165,197:1:0:", -- Thick Spider's Silk
	[4338]="1000:250:7:1:20:Cloth:164,202,129,165,197:1:1:16631", -- Mageweave Cloth
	[4339]="0:1250:7:1:20:Cloth:202,197:1:0:", -- Bolt of Mageweave
	[4340]="350:87:7:1:10:Other:165,197:1:0:989,1148,1286,1347,1454,1474,1672,2225,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3091,3096,3364,3366,3367,3485,3779,3954,3955,3958,4168,4189,4225,4229,4561,4577,4589,4775,4897,5128,5135,5154,5163,5565,5783,5817,5944,6301,6567,6568,6574,6576,6731,7852,7854,7940,7947,8145,8160,8363,8681,8934,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12957,12958,15165,15179,16366,16613,16638,16689,16748,16767,16768,17486,18009,18277,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,24995,25010,25019,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,33596,33601", -- Gray Dye
	[4341]="500:125:7:1:10:Other:197:1:0:989,1148,1286,1347,1454,1474,1672,2225,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3091,3096,3364,3366,3367,3485,3779,3954,3955,3958,4168,4189,4225,4229,4561,4577,4589,4775,4897,5128,5135,5154,5163,5565,5783,5817,5944,6301,6567,6568,6574,6576,6731,7852,7854,7940,7947,8145,8160,8363,8681,8934,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12957,12958,15165,15179,16366,16613,16638,16689,16748,16767,16768,17486,18009,18277,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,24995,25010,25019,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,33596,33601", -- Yellow Dye
	[4342]="2500:625:7:1:10:Other:171,202,165,197:1:0:989,1148,1286,1347,1454,1474,1672,2225,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3091,3096,3364,3366,3367,3485,3779,3954,3955,3958,4168,4189,4225,4229,4561,4577,4589,4775,4897,5128,5135,5154,5163,5565,5783,5817,5944,6301,6567,6568,6574,6576,6731,7852,7854,7940,7947,8145,8160,8363,8681,8934,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12957,12958,15165,15179,16366,16613,16638,16689,16748,16767,16768,17486,18009,18277,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,24995,25010,25019,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,33596,33601", -- Purple Dye
	[4343]="0:100:4:2:1:Cloth::1:0:", -- Brown Linen Pants
	[4344]="0:11:4:1:1:Shirt::1:0:", -- Brown Linen Shirt
	[4345]="0:100:9:2:1:Tailoring::1:0:", -- Pattern: Red Woolen Boots
	[4346]="0:100:9:2:1:Tailoring::1:0:", -- Pattern: Heavy Woolen Cloak
	[4347]="0:150:9:2:1:Tailoring::1:0:", -- Pattern: Reinforced Woolen Shoulders
	[4348]="0:175:9:2:1:Tailoring::1:0:", -- Pattern: Phoenix Gloves
	[4349]="0:175:9:2:1:Tailoring::1:0:", -- Pattern: Phoenix Pants
	[4350]="0:200:9:2:1:Tailoring::1:0:", -- Pattern: Spider Silk Slippers
	[4351]="0:225:9:2:1:Tailoring::1:0:", -- Pattern: Shadow Hood
	[4352]="0:275:9:2:1:Tailoring::1:0:", -- Pattern: Boots of the Enchanter
	[4353]="0:300:9:2:1:Tailoring::1:0:", -- Pattern: Spider Belt
	[4354]="0:350:9:3:1:Tailoring::1:0:", -- Pattern: Rich Purple Silk Shirt
	[4355]="1500:375:9:1:1:Tailoring::1:1:2381", -- Pattern: Icy Cloak
	[4356]="0:375:9:2:1:Tailoring::1:0:", -- Pattern: Star Belt
	[4357]="16:4:7:1:20:Part:202:1:1:1448,1694,2682,2683,2684,2685,2687,2688,3133,3413,3495,4453,4587,5175,5519,6730,6777,8678,8679,9544,9676,11185,14337,14637,16657,16782,17222,17421,18278,18484,18752,18775,19383,20890,26600,26898,27711,28722,28797,29907,30345,30434,30825,31776,31781,33594,33669", -- Rough Blasting Powder
	[4358]="0:30:7:1:20:Explosive::1:0:", -- Rough Dynamite
	[4359]="0:12:7:1:20:Part:202:1:0:", -- Handful of Copper Bolts
	[4360]="0:60:7:1:20:Explosive::1:0:", -- Rough Copper Bomb
	[4361]="480:120:7:1:20:Part:202:1:1:1448,1694,2683,2685,2687,2688,3133,3413,3495,4587,5175,5519,6730,6777,8679,9544,11185,14637,17421,18278,18484,18752,18775,19383,20890,26600,26898,27711,28722,28797,29907,30345,30434,30825,31776,31781,33594,33669", -- Copper Tube
	[4362]="0:187:2:2:1:Gun::1:0:", -- Rough Boomstick
	[4363]="200:50:7:1:20:Part:202:1:1:1448,1694,2682,2683,2684,2685,2687,2688,3133,4453,4587,5175,5519,6730,8679,9544,11185,14637,17222,17421,18278,18484,18775,19383,20890,26600,26898,27711,28722,28797,29907,30345,30434,30825,31776,31781,33669", -- Copper Modulator
	[4364]="48:12:7:1:20:Part:202:1:1:1448,1694,2682,2683,2684,2685,2687,2688,3133,3413,3495,4453,4587,5175,5519,6730,6777,8678,8679,9544,9676,11185,14337,14637,16657,16782,17222,17421,18278,18484,18752,18775,19383,20890,26600,26898,27711,28722,28797,29907,30345,30434,30825,31776,31781,33594,33669", -- Coarse Blasting Powder
	[4365]="0:75:7:1:20:Explosive::1:0:", -- Coarse Dynamite
	[4366]="0:75:15:1:10:CombatPet::1:0:", -- Target Dummy
	[4367]="0:150:7:1:10:Explosive::1:0:", -- Small Seaforium Charge
	[4368]="0:408:4:2:1:Cloth:202:1:0:", -- Flying Tiger Goggles
	[4369]="0:1179:2:2:1:Gun::1:0:", -- Deadly Blunderbuss
	[4370]="0:175:7:1:20:Explosive::1:0:", -- Large Copper Bomb
	[4371]="800:200:7:1:20:Part:202:1:1:1448,2682,2683,2685,2687,2688,3133,3413,3495,4587,5175,5519,6730,8679,9544,11185,14637,17222,17421,18278,18484,18775,19383,20890,26600,26898,27711,28722,28797,29907,30345,30434,30825,31776,31781,33669", -- Bronze Tube
	[4372]="0:1800:2:2:1:Gun::1:0:", -- Lovingly Crafted Boomstick
	[4373]="0:722:4:2:1:Cloth::1:0:", -- Shadow Goggles
	[4374]="0:200:7:1:20:Explosive::1:0:", -- Small Bronze Bomb
	[4375]="0:115:7:1:10:Part:202:1:0:", -- Whirring Bronze Gizmo
	[4376]="0:200:7:1:1:Device::1:0:", -- Flame Deflector
	[4377]="0:150:7:1:20:Part:202:1:0:", -- Heavy Blasting Powder
	[4378]="1400:350:7:1:20:Explosive::1:1:3180", -- Heavy Dynamite
	[4379]="0:2357:2:2:1:Gun::1:0:", -- Silver-plated Shotgun
	[4380]="0:500:7:1:20:Explosive::1:0:", -- Big Bronze Bomb
	[4381]="0:600:4:2:1:Trinket::1:0:", -- Minor Recombobulator
	[4382]="2400:600:7:1:10:Part:202:1:1:1448,1694,2682,2683,2684,2685,2687,2688,3133,3413,3495,4453,4587,5175,5519,6730,6777,8679,9544,11185,14637,17421,18278,18484,18752,18775,19383,20890,26600,26898,27711,28722,28797,29907,30345,30434,30825,31776,31781,33594,33669", -- Bronze Framework
	[4383]="0:3183:2:2:1:Gun::1:0:", -- Moonsight Rifle
	[4384]="0:1000:15:1:20:CombatPet::1:0:", -- Explosive Sheep
	[4385]="0:1410:4:2:1:Cloth:202:1:0:", -- Green Tinted Goggles
	[4386]="0:175:7:1:1:Device::1:0:", -- Ice Deflector
	[4387]="0:400:7:1:10:Part:202:1:0:", -- Iron Strut
	[4388]="0:1000:7:1:1:Device::1:0:", -- Discombobulator Ray
	[4389]="3000:750:7:1:10:Part:202:1:1:2682,2685,2687,2688,3133,3413,5175,6777,8679,11185,17421,18484,18752,19383,26600,26898,27711,28722,29907,30345,30434,30825,31776,33669", -- Gyrochronatom
	[4390]="0:500:7:1:20:Explosive::1:0:", -- Iron Grenade
	[4391]="0:4000:15:1:5:CombatPet::1:0:", -- Compact Harvest Reaper Kit
	[4392]="0:2500:15:1:10:CombatPet::1:0:", -- Advanced Target Dummy
	[4393]="0:2632:4:2:1:Cloth::1:0:", -- Craftsman's Monocle
	[4394]="0:750:7:1:20:Explosive:202:1:0:", -- Big Iron Bomb
	[4395]="0:1600:15:1:20:CombatPet::1:0:", -- Goblin Land Mine
	[4396]="0:6000:4:1:1:Trinket::1:0:", -- Mechanical Dragonling
	[4397]="0:5000:4:1:1:Trinket::1:0:", -- Gnomish Cloaking Device
	[4398]="0:900:7:1:20:Explosive::1:0:", -- Large Seaforium Charge
	[4399]="200:50:7:1:10:Part:202:1:0:960,989,1148,1286,1448,1456,1694,2225,2381,2393,2682,2683,2684,2685,2687,2688,2810,2821,3133,3367,3413,3495,3779,3954,3955,4229,4453,4561,4587,4775,4877,4897,5100,5135,5163,5175,5519,5817,6301,6730,6777,7947,8145,8363,8678,8679,8934,9544,9636,9676,11185,11189,12022,12028,12245,12941,12957,12958,14337,14637,15179,16613,16657,16768,16782,17222,17421,17486,18009,18278,18484,18752,18775,19244,19372,19383,19450,20890,24843,24935,24995,25010,25019,25051,25082,26600,26898,27021,27026,27043,27057,27711,28692,28722,28797,28831,28872,29288,29907,30311,30345,30434,30825,31776,31781,33594,33669", -- Wooden Stock
	[4400]="2000:500:7:1:10:Part:202:1:0:960,989,1148,1286,1448,1456,1694,2225,2381,2393,2682,2683,2684,2685,2687,2688,2810,2821,3133,3367,3413,3495,3779,3954,3955,4229,4453,4561,4587,4775,4877,4897,5100,5135,5163,5175,5519,5817,6301,6730,6777,7947,8145,8363,8678,8679,8934,9544,9636,9676,11185,11189,12022,12028,12245,12941,12957,12958,14337,14637,15179,16613,16657,16768,16782,17222,17421,17486,18009,18278,18484,18752,18775,19244,19372,19383,19450,20890,24843,24935,24995,25010,25019,25051,25082,26600,26898,27021,27026,27043,27057,27711,28692,28722,28797,28831,28872,29288,29907,30311,30345,30434,30825,31776,31781,33594,33669", -- Heavy Stock
	[4401]="0:100:15:1:1:Companion::1:0:", -- Mechanical Squirrel Box
	[4402]="0:250:7:1:5:Other:171,185,202:1:0:", -- Small Flame Sac
	[4403]="0:2000:7:1:1:Device::1:0:", -- Portable Bronze Mortar
	[4404]="100:25:7:1:20:Part:202:1:1:1448,1694,2682,2683,2685,2687,2688,3133,3413,3495,4453,4587,5175,5519,6730,6777,8679,9544,11185,14637,17421,18278,18484,18752,18775,19383,20890,26600,26898,27711,28722,28797,29907,30345,30434,30825,31776,31781,33669", -- Silver Contact
	[4405]="0:125:0:1:5:EnhPerm::1:0:", -- Crude Scope
	[4406]="0:600:0:1:5:EnhPerm::1:0:", -- Standard Scope
	[4407]="0:1200:0:2:5:EnhPerm:202:1:0:", -- Accurate Scope
	[4408]="0:162:9:2:1:Engineering::1:0:", -- Schematic: Mechanical Squirrel Box
	[4409]="0:200:9:2:1:Engineering::1:0:", -- Schematic: Small Seaforium Charge
	[4410]="0:250:9:2:1:Engineering::1:0:", -- Schematic: Shadow Goggles
	[4411]="0:275:9:2:1:Engineering::1:0:", -- Schematic: Flame Deflector
	[4412]="0:375:9:2:1:Engineering::1:0:", -- Schematic: Moonsight Rifle
	[4413]="0:450:9:2:1:Engineering::1:0:", -- Schematic: Discombobulator Ray
	[4414]="0:462:9:2:1:Engineering::1:0:", -- Schematic: Portable Bronze Mortar
	[4415]="0:550:9:3:1:Engineering::1:0:", -- Schematic: Craftsman's Monocle
	[4416]="0:600:9:2:1:Engineering::1:0:", -- Schematic: Goblin Land Mine
	[4417]="0:675:9:2:1:Engineering::1:0:", -- Schematic: Large Seaforium Charge
	[4419]="450:112:0:1:20:Scroll::1:1:14847", -- Scroll of Intellect III
	[4421]="400:100:0:1:20:Scroll::1:1:12246,14847", -- Scroll of Protection III
	[4422]="450:112:0:1:20:Scroll::1:1:14847", -- Scroll of Stamina III
	[4424]="400:100:0:1:20:Scroll::1:1:12246,14847", -- Scroll of Spirit III
	[4425]="500:125:0:1:20:Scroll::1:1:14847,20092", -- Scroll of Agility III
	[4426]="500:125:0:1:20:Scroll::1:1:14847,20092", -- Scroll of Strength III
	[4428]="0:331:15:0:5:Junk::1:0:", -- Spider Palp
	[4429]="0:0:12:1:1:::1:0:", -- Deepfury's Orders
	[4430]="0:4307:4:2:1:Amulet::1:0:", -- Ethereal Talisman
	[4432]="0:0:12:1:1:::1:0:", -- Sully Balloo's Letter
	[4433]="0:0:12:1:1:::1:0:", -- Waterlogged Envelope
	[4434]="0:572:4:2:1:Cloth::1:0:", -- Scarecrow Trousers
	[4435]="0:0:12:1:20:::1:0:", -- Mote of Myzrael
	[4436]="0:331:4:2:1:Cloth::1:0:", -- Jewel-encrusted Sash
	[4437]="0:1855:2:2:1:Stave::1:0:", -- Channeler's Staff
	[4438]="0:1693:4:3:1:Mail::1:0:", -- Pugilist Bracers
	[4439]="0:1788:2:2:1:OneHandMace::1:0:", -- Bruiser Club
	[4440]="0:0:12:1:1:::1:0:", -- Sigil of Strom
	[4441]="0:0:12:1:1:::1:0:", -- MacKreel's Moonshine
	[4443]="0:3472:4:2:1:Mail::1:0:", -- Grim Pauldrons
	[4444]="0:1490:4:2:1:Shield::1:0:", -- Black Husk Shield
	[4445]="0:2068:2:2:1:OneHandAxe::1:0:", -- Flesh Carver
	[4446]="0:3594:2:3:1:Dagger::1:0:", -- Blackvenom Blade
	[4447]="0:902:4:2:1:Cloak::1:0:", -- Cloak of Night
	[4448]="0:1992:4:2:1:Mail::1:0:", -- Husk of Naraxis
	[4449]="0:3332:2:2:1:Dagger::1:0:", -- Naraxis' Fang
	[4450]="0:0:12:1:20:::1:0:", -- Sigil Fragment
	[4453]="0:0:12:1:1:::1:0:", -- Sigil of Thoradin
	[4454]="0:3800:2:3:1:Dagger::1:0:", -- Talon of Vultros
	[4455]="0:3096:4:2:1:Leather::1:0:", -- Raptor Hide Harness
	[4456]="0:1553:4:2:1:Leather::1:0:", -- Raptor Hide Belt
	[4457]="0:300:0:1:20:FoodDrink::1:0:", -- Barbecued Buzzard Wing
	[4458]="0:0:12:1:1:::1:0:", -- Sigil of Arathor
	[4459]="0:150:15:0:10:Junk::1:0:", -- Brittle Dragon Bone
	[4460]="0:175:15:0:10:Junk::1:0:", -- Ripped Wing Webbing
	[4461]="0:208:7:1:10:Leather:165:1:0:", -- Raptor Hide
	[4462]="0:1425:4:2:1:Cloak::1:0:", -- Cloak of Rot
	[4463]="0:953:4:2:1:Cloth::1:0:", -- Beaded Raptor Collar
	[4464]="0:2380:4:2:1:Mail::1:0:", -- Trouncing Boots
	[4465]="0:1585:4:2:1:Mail::1:0:", -- Felstrom's Gauntlets
	[4466]="0:0:12:1:1:::1:0:", -- Sigil of Trollbane
	[4467]="0:0:12:1:1:::1:0:", -- Sigil of Ignaeus
	[4468]="0:0:12:1:1:::1:0:", -- Sheathed Trol'kalar
	[4469]="0:0:12:1:1:::1:0:", -- Rod of Order
	[4470]="38:9:7:1:20:Other:333,202:1:0:151,227,491,734,791,1149,1250,1285,1318,1448,1452,1650,1682,1685,1691,2084,2134,2140,2401,2803,2806,2808,2820,2908,3012,3076,3164,3186,3313,3346,3350,3481,3498,3541,3608,3962,4082,4084,4170,4182,4228,4241,4555,4617,4876,4896,5101,5134,5158,5757,5758,7942,8139,8362,11038,11555,12021,12027,12246,12959,12960,14624,15174,15397,15419,16187,16191,16259,16260,16444,16602,16635,16722,16732,16826,17421,17446,17489,18011,18015,18753,18773,18810,18811,18907,18951,18959,18960,19017,19020,19021,19042,19053,19194,19197,19234,19243,19314,19315,19372,19374,19436,19450,19452,19474,19497,19498,19533,19534,19537,19540,19560,19562,19574,19649,19663,19679,20080,20081,20092,20194,20231,20249,20250,20891,20892,21082,21083,21111,21113,21172,21183,22099,22270,23143,23802,24053,24054,24141,24147,24188,24341,24348,24356,25034,25035,26374,26388,26474,26569,26718,26720,26934,26936,26938,26939,26941,27011,27012,27021,27022,27025,27026,27030,27039,27041,27043,27051,27054,27057,27058,27063,27070,27071,27132,27145,27146,27147,27182,27184,27193,27195,27938,27940,28691,28692,28714,28715,28792,28794,28806,28807,28830,28831,28867,28872,29035,29207,29208,29270,29277,29537,29908,29925,29944,29962,29970,30011,30070,30256,30257,30310,30311,30345,30437,30438,30825,31022,31115,32477,32638,32639,32641,32642,33597", -- Simple Wood
	[4471]="135:33:7:0:1:Other::1:0:151,227,491,734,791,1149,1250,1285,1448,1452,1682,1685,1691,2084,2134,2140,2401,2803,2806,2808,2820,2908,3076,3164,3186,3313,3350,3481,3498,3541,3962,4082,4084,4170,4182,4241,4555,4876,4896,5101,5134,7942,8139,8362,11038,11555,12021,12027,12246,12959,12960,14624,15174,15397,16187,16191,16259,16260,16444,16602,16732,16826,17421,17446,17489,18011,18015,18810,18811,18907,18959,18960,19017,19020,19021,19042,19053,19194,19197,19243,19314,19315,19372,19374,19436,19450,19452,19474,19497,19498,19533,19534,19560,19562,19574,19649,19679,20080,20081,20092,20194,20231,20249,20250,20891,20892,21082,21083,21111,21113,21172,21183,22099,22270,23143,23802,24053,24054,24141,24147,24188,24341,24348,24356,25034,25035,26374,26388,26474,26718,26720,26934,26936,26938,26939,26941,27011,27012,27021,27022,27025,27026,27041,27043,27051,27057,27058,27063,27070,27071,27132,27145,27146,27182,27184,27193,27195,27938,27940,28691,28692,28792,28794,28806,28807,28830,28831,28867,28872,29035,29207,29208,29270,29277,29908,29925,29944,29962,29970,30011,30070,30256,30257,30310,30311,30345,30437,30438,30825,31022,31115,32477,32638,32639,32641,32642", -- Flint and Tinder
	[4472]="0:0:12:1:1:::1:0:", -- Scroll of Myzrael
	[4473]="0:0:12:1:1:::1:0:", -- Eldritch Shackles
	[4474]="0:4207:2:2:1:Bow::1:0:", -- Ravenwood Bow
	[4476]="0:2734:4:2:1:Cloth::1:0:", -- Beastwalker Robe
	[4477]="0:4390:4:2:1:Shield::1:0:", -- Nefarious Buckler
	[4478]="0:10176:4:2:1:Mail::1:0:", -- Iridescent Scale Leggings
	[4479]="0:178:0:1:10:Other::1:0:", -- Burning Charm
	[4480]="0:185:0:1:10:Other::1:0:", -- Thundering Charm
	[4481]="0:176:0:1:10:Other::1:0:", -- Cresting Charm
	[4482]="0:0:12:1:1:::1:0:", -- Sealed Folder
	[4483]="0:0:13:1:1:::1:0:", -- Burning Key
	[4484]="0:0:13:1:1:::1:0:", -- Cresting Key
	[4485]="0:0:13:1:1:::1:0:", -- Thundering Key
	[4487]="0:0:12:1:1:::1:0:", -- Maiden's Folly Charts
	[4488]="0:0:12:1:1:::1:0:", -- Spirit of Silverpine Charts
	[4489]="0:0:12:1:1:::1:0:", -- Maiden's Folly Log
	[4490]="0:0:12:1:1:::1:0:", -- Spirit of Silverpine Log
	[4491]="0:0:12:1:1:::1:0:", -- Goggles of Gem Hunting
	[4492]="0:0:12:1:20:::1:0:", -- Elven Gem
	[4493]="0:0:12:1:1:::1:0:", -- Elven Gems
	[4494]="0:0:12:1:1:::1:0:", -- Seahorn's Sealed Letter
	[4495]="0:0:12:1:20:::1:0:", -- Bloodstone Amulet
	[4496]="500:125:1:1:1:Bag::1:0:151,491,791,1250,1285,1321,1682,1685,1691,2134,2140,3016,3076,3164,3186,3313,3369,3481,3487,3498,3608,4082,4084,4170,4182,4230,4241,4555,4590,5132,7942,8362,8364,12027,12960,16187,16191,16259,16260,16444,16690,16709,16732,17421,17446,17489,18810,18811,18947,19197,19560", -- Small Brown Pouch
	[4497]="20000:5000:1:1:1:Bag::1:0:227,734,1149,1285,1321,1448,1452,2084,2401,2803,2806,2808,2820,2908,3016,3313,3350,3369,3487,3541,3962,4170,4230,4241,4555,4590,4876,4896,5101,5132,5134,7942,8139,8362,8364,11038,11555,12021,12027,12246,12959,12960,14624,15174,15397,16191,16690,16709,16732,17489,18947,19197,19560", -- Heavy Brown Bag
	[4498]="2500:625:1:1:1:Bag::1:0:151,227,491,734,791,1149,1250,1285,1321,1448,1452,1682,1685,1691,2084,2134,2140,2401,2803,2806,2808,2820,2908,3016,3076,3164,3186,3313,3350,3369,3481,3487,3498,3541,3608,3962,4082,4084,4170,4182,4230,4241,4555,4590,4876,4896,5101,5132,5134,7942,8139,8362,8364,11038,11555,12021,12027,12246,12959,12960,14624,15174,15397,16187,16191,16259,16260,16444,16690,16709,16732,17421,17446,17489,18810,18811,18947,19197,19560", -- Brown Leather Satchel
	[4499]="100000:25000:1:1:1:Bag::1:0:1321,3369,4230,4590,5132,8364,16690,16709,19197", -- Huge Brown Sack
	[4500]="0:8750:1:2:1:Bag::1:0:", -- Traveler's Backpack
	[4502]="0:0:12:1:1:::1:0:", -- Sample Elven Gem
	[4503]="0:0:12:1:20:::1:0:", -- Witherbark Tusk
	[4504]="0:1475:4:2:1:Cloak::1:0:", -- Dwarven Guard Cloak
	[4505]="0:1974:4:2:1:Cloth::1:0:", -- Swampland Trousers
	[4506]="0:0:12:1:20:::1:0:", -- Stromgarde Badge
	[4507]="0:9938:4:3:1:Shield::1:0:", -- Pit Fighter's Shield
	[4508]="0:9351:4:3:1:Mail::1:0:", -- Blood-tinged Armor
	[4509]="0:2794:4:2:1:Leather::1:0:", -- Seawolf Gloves
	[4510]="0:0:12:1:1:::1:0:", -- Befouled Bloodstone Orb
	[4511]="0:11256:2:2:1:OneHandMace::1:0:", -- Black Water Hammer
	[4512]="0:0:12:1:20:::1:0:", -- Highland Raptor Eye
	[4513]="0:0:12:1:20:::1:0:", -- Raptor Heart
	[4514]="0:0:12:1:1:::1:0:", -- Sara Balloo's Plea
	[4515]="0:0:12:1:1:::1:0:", -- Marez's Head
	[4516]="0:0:12:1:1:::1:0:", -- Otto's Head
	[4517]="0:0:12:1:1:::1:0:", -- Falconcrest's Head
	[4518]="0:0:12:1:1:::1:0:", -- Torn Scroll Fragment
	[4519]="0:0:12:1:1:::1:0:", -- Crumpled Scroll Fragment
	[4520]="0:0:12:1:1:::1:0:", -- Singed Scroll Fragment
	[4521]="0:0:12:1:20:::1:0:", -- Alterac Granite
	[4522]="0:0:12:1:20:::1:0:", -- Witherbark Medicine Pouch
	[4525]="0:0:12:1:1:::1:0:", -- Trelane's Wand of Invocation
	[4526]="0:0:12:1:1:::1:0:", -- Raptor Talon Amulet
	[4527]="0:0:12:1:1:::1:0:", -- Azure Agate
	[4528]="0:0:12:1:1:::1:0:", -- Tor'gan's Orb
	[4529]="0:0:12:1:1:::1:0:", -- Enchanted Agate
	[4530]="0:0:12:1:1:::1:0:", -- Trelane's Phylactery
	[4531]="0:0:12:1:1:::1:0:", -- Trelane's Orb
	[4532]="0:0:12:1:1:::1:0:", -- Trelane's Ember Agate
	[4533]="0:0:12:1:1:::1:0:", -- Sealed Letter to Archmage Malin
	[4534]="0:1173:4:2:1:Mail::1:0:", -- Steel-clasped Bracers
	[4535]="0:882:4:2:1:Ring::1:0:", -- Ironforge Memorial Ring
	[4536]="25:1:0:1:20:FoodDrink::5:0:734,894,1671,3017,3342,3934,3961,4191,4891,5814,6735,6740,7714,7736,7978,16443,16542,17630,19223,21145,23573,24934,29547", -- Shiny Red Apple
	[4537]="125:6:0:1:20:FoodDrink::5:0:734,894,1671,3017,3342,3934,3961,4191,4891,5814,6735,6740,7714,7736,7978,16443,16542,17630,21145,23573,24934,29547", -- Tel'Abim Banana
	[4538]="500:25:0:1:20:FoodDrink::5:0:734,894,1671,3017,3342,3934,3961,4191,4891,5814,6735,6740,7714,7736,7978,14963,14964,15124,15125,16443,16542,17630,21145,23573,24934,29547", -- Snapvine Watermelon
	[4539]="1000:50:0:1:20:FoodDrink::5:0:734,894,1671,3017,3342,3934,3961,4191,4891,5814,6735,6740,7714,7736,7978,14963,14964,15124,15125,16443,16542,17630,19223,21145,23573,24934,29547", -- Goldenbark Apple
	[4540]="25:1:0:1:20:FoodDrink::5:0:152,233,829,1237,1247,1285,1670,2115,2352,2364,2832,3003,3072,3086,3158,3291,3313,3480,3518,3546,3587,3689,3708,3883,3884,3937,3948,3959,4190,4266,4891,4894,5109,5620,6272,6734,6736,6737,6740,6747,7485,7737,7744,7941,8143,8307,8362,11103,11287,15433,16191,16256,16458,16739,17630,23522,23603,24834,24934,24993,25012,25020,25052,25089,29291,33996", -- Tough Hunk of Bread
	[4541]="125:6:0:1:20:FoodDrink::5:0:233,1237,1247,1670,2352,2364,2832,3003,3086,3291,3480,3518,3546,3689,3708,3883,3884,3937,3948,3959,4190,4266,4891,4894,5109,5620,6272,6734,6736,6737,6740,6747,7485,7737,7744,7941,8143,8307,11103,11287,15433,16256,16458,16739,17630,23522,23603,24834,24934,24993,25012,25020,25052,25089,29291,33996", -- Freshly Baked Bread
	[4542]="500:25:0:1:20:FoodDrink::5:0:233,1237,1247,1670,2352,2364,2832,3003,3086,3291,3480,3518,3546,3689,3708,3883,3884,3937,3948,3959,4190,4266,4891,4894,5109,5620,6272,6734,6736,6737,6740,6747,7485,7737,7744,7941,8143,8307,11103,11287,15433,16256,16458,16739,17630,23522,23603,24834,24934,24993,25012,25020,25052,25089,29291,33996", -- Moist Cornbread
	[4543]="0:4098:4:2:1:Leather::1:0:", -- White Drakeskin Cap
	[4544]="1000:50:0:1:20:FoodDrink::5:0:233,1237,1247,1670,2352,2364,2832,3003,3086,3291,3480,3518,3546,3689,3708,3883,3884,3937,3948,3959,4190,4266,4891,4894,5109,5620,6272,6734,6736,6737,6740,6747,7485,7737,7744,7941,8143,8307,11103,11287,15433,16256,16458,16739,17630,23522,23603,24834,24934,24993,25012,25020,25052,25089,29291,33996", -- Mulgore Spice Bread
	[4545]="0:2202:4:2:1:Cloth::1:0:", -- Radiant Silver Bracers
	[4546]="0:533:0:1:1:Consumable::1:0:", -- Call of the Raptor
	[4547]="0:8319:2:2:1:Wand::1:0:", -- Gnomish Zapper
	[4548]="0:15028:2:2:1:TwoHandMace::1:0:", -- Servomechanic Sledgehammer
	[4549]="0:2092:4:2:1:Ring::1:0:", -- Seafire Band
	[4550]="0:2092:4:2:1:Ring::1:0:", -- Coldwater Ring
	[4551]="0:0:12:1:1:::1:0:", -- Or'Kalar's Head
	[4552]="0:530:15:0:10:Junk::1:0:", -- Smooth Stone Chip
	[4553]="0:411:15:0:5:Junk::1:0:", -- Jagged Piece of Stone
	[4554]="0:708:15:0:5:Junk::1:0:", -- Shiny Polished Stone
	[4555]="0:155:15:0:5:Junk::1:0:", -- Thick Scaly Tail
	[4556]="0:903:15:0:5:Junk::1:0:", -- Speckled Shell Fragment
	[4557]="0:225:15:0:10:Junk::1:0:", -- Fiery Gland
	[4558]="0:1565:15:0:1:Junk::1:0:", -- Empty Barrel
	[4560]="0:37:2:1:1:OneHandSword::1:0:", -- Fine Scimitar
	[4561]="0:309:2:2:1:OneHandAxe::1:0:", -- Scalping Tomahawk
	[4562]="0:298:2:2:1:TwoHandAxe::1:0:", -- Severing Axe
	[4563]="0:110:2:1:1:OneHandMace::1:0:", -- Billy Club
	[4564]="0:610:2:2:1:TwoHandMace::1:0:", -- Spiked Club
	[4565]="0:38:2:1:1:Dagger::1:0:", -- Simple Dagger
	[4566]="0:631:2:2:1:Stave::1:0:", -- Sturdy Quarterstaff
	[4567]="0:1049:2:2:1:TwoHandSword::1:0:", -- Merc Sword
	[4568]="0:1695:2:2:1:OneHandAxe::1:0:", -- Grunt Axe
	[4569]="0:612:2:2:1:OneHandMace::1:0:", -- Staunch Hammer
	[4570]="0:922:2:2:1:TwoHandMace::1:0:", -- Birchwood Maul
	[4571]="0:979:2:2:1:Dagger::1:0:", -- War Knife
	[4575]="0:1487:2:2:1:Stave::1:0:", -- Medicine Staff
	[4576]="0:1184:2:2:1:Bow::1:0:", -- Light Bow
	[4577]="0:357:2:2:1:Gun::1:0:", -- Compact Shotgun
	[4580]="0:787:15:0:10:Junk::1:0:", -- Sabertooth Fang
	[4581]="0:862:15:0:5:Junk::1:0:", -- Patch of Fine Fur
	[4582]="0:745:12:1:5:::1:0:", -- Soft Bushy Tail
	[4583]="0:812:15:0:5:Junk::1:0:", -- Thick Furry Mane
	[4584]="0:937:15:0:5:Junk::1:0:", -- Large Trophy Paw
	[4585]="0:583:15:0:5:Junk::1:0:", -- Dripping Spider Mandible
	[4586]="0:713:15:0:5:Junk::1:0:", -- Smooth Raptor Skin
	[4587]="0:807:15:0:10:Junk::1:0:", -- Tribal Raptor Feathers
	[4588]="0:900:15:0:5:Junk::1:0:", -- Pristine Raptor Skull
	[4589]="0:530:7:1:10:Other:197:1:0:", -- Long Elegant Feather
	[4590]="0:655:15:0:5:Junk::1:0:", -- Curved Yellow Bill
	[4591]="0:413:15:0:5:Junk::1:0:", -- Eagle Eye
	[4592]="20:1:0:1:20:FoodDrink::5:0:1678,1684,2842,3086,3178,3497,3540,4200,4221,4305,4307,5814,6727,6738,6791,6807,7943,8137,8931,11187,12962,14731,16618,16739,17553,17656,19045,23896,24834,24993,25012,25020,25052,25089,29291", -- Longjaw Mud Snapper
	[4593]="500:4:0:1:20:FoodDrink::5:0:1678,1684,2842,3086,3178,3497,3540,4200,4221,4305,4307,5814,6727,6738,6791,6807,7943,8137,8931,11187,12962,14731,16618,16739,17553,17656,19045,23896,24834,24993,25012,25020,25052,25089,29291", -- Bristle Whisker Catfish
	[4594]="1000:6:0:1:20:FoodDrink::5:0:1678,1684,2842,3086,3178,3497,3540,4200,4221,4305,4307,5814,6727,6738,6791,6807,7943,8137,8931,11187,12962,14731,16618,16739,17553,17656,19045,23896,24834,24993,25012,25020,25052,25089,29291", -- Rockscale Cod
	[4595]="300:75:0:1:10:FoodDrink::1:0:2832", -- Junglevine Wine
	[4596]="0:25:0:1:5:Potion::1:0:", -- Discolored Healing Potion
	[4597]="0:250:9:2:1:Alchemy::1:0:", -- Recipe: Discolored Healing Potion
	[4598]="0:212:0:1:10:Consumable::1:0:", -- Goblin Fishing Pole
	[4599]="2000:100:0:1:20:FoodDrink::5:0:982,1464,2365,2388,2814,3025,3089,3312,3368,3411,3489,3621,3705,3881,3882,3933,3935,3960,4084,4169,4782,4875,4879,4891,4894,4954,5111,5124,5611,5620,5870,6928,6929,7485,7731,7733,8125,9356,11118,11187,12196,12959,14624,14963,14964,15124,15125,15174,15397,16443,16618,16739,17553,17630,17656,19182,23263,23481,23605,24208,24291,24343", -- Cured Ham Steak
	[4600]="340:85:0:1:20:FoodDrink::1:0:2832,4782,5570,19617,20377,24333,24834,24993,25012,25020,25052,25089,29291", -- Cherry Grog
	[4601]="2000:100:0:1:20:FoodDrink::5:0:233,1237,1247,1670,2352,2364,2832,3003,3086,3291,3480,3518,3546,3689,3708,3883,3884,3937,3948,3959,4190,4266,4891,4894,5109,5620,6272,6734,6736,6737,6740,6747,7485,7737,7744,7941,8143,8307,11103,11287,15433,16256,16458,16739,17630,23522,23603,24834,24934,24993,25012,25020,25052,25089,29291,33996", -- Soft Banana Bread
	[4602]="2000:100:0:1:20:FoodDrink::5:0:734,894,1671,3017,3342,3934,3961,4191,4891,5814,6735,6740,7714,7736,7978,14963,14964,15124,15125,16443,16542,17630,21145,23573,24934,29547", -- Moon Harvest Pumpkin
	[4603]="0:4:7:1:20:Meat:185:1:0:", -- Raw Spotted Yellowtail
	[4604]="25:1:0:1:20:FoodDrink::5:0:2803,2806,3138,3329,3544,3547,4554,4571,5688,5886,6739,6741,8150,8152,11038,12384,17656", -- Forest Mushroom Cap
	[4605]="125:6:0:1:20:FoodDrink::5:0:2803,2806,3138,3329,3544,3547,4554,4571,5688,5886,6739,6741,8150,8152,11038,12384,17656", -- Red-speckled Mushroom
	[4606]="500:25:0:1:20:FoodDrink::5:0:2803,2806,3138,3329,3544,3547,4554,4571,5688,5886,6739,6741,8150,8152,11038,12384,14963,14964,15124,15125,17656", -- Spongy Morel
	[4607]="1000:50:0:1:20:FoodDrink::5:0:2803,2806,3138,3329,3544,3547,4554,4571,5688,5886,6739,6741,8150,8152,11038,12384,14963,14964,15124,15125,17656", -- Delicious Cave Mold
	[4608]="2000:100:0:1:20:FoodDrink::5:0:2803,2806,3138,3329,3544,3547,4554,4571,5688,5886,6739,6741,8150,8152,11038,12384,14963,14964,15124,15125,17656", -- Raw Black Truffle
	[4609]="1000:250:9:1:1:Cooking::1:0:2814,12246", -- Recipe: Barbecued Buzzard Wing
	[4610]="0:0:12:1:20:::1:0:", -- Carved Stone Urn
	[4611]="0:50:7:1:20:Other:202:1:0:", -- Blue Pearl
	[4612]="0:0:12:1:20:::1:0:", -- Black Drake's Heart
	[4613]="0:0:12:1:1:::1:0:", -- Corroded Black Box
	[4614]="0:0:4:2:1:Amulet::1:0:", -- Pendant of Myzrael
	[4615]="0:0:12:1:1:::1:0:", -- Blacklash's Bindings
	[4616]="0:0:2:1:1:Miscellaneous::1:0:", -- Ryedol's Lucky Pick
	[4621]="0:0:12:1:1:::1:0:", -- Ambassador Infernus' Bracer
	[4622]="0:0:12:1:1:::1:0:", -- Sealed Note to Advisor Belgrum
	[4623]="0:375:0:1:5:Potion::1:0:", -- Lesser Stoneshield Potion
	[4624]="0:550:9:1:1:Alchemy::1:0:", -- Recipe: Lesser Stoneshield Potion
	[4625]="0:250:7:1:20:Herb:171,333,197:1:0:", -- Firebloom
	[4626]="0:0:12:1:20:::1:0:", -- Small Stone Shard
	[4627]="0:0:12:1:5:::1:0:", -- Large Stone Slab
	[4628]="0:0:12:1:20:::1:0:", -- Bracers of Rock Binding
	[4629]="0:0:12:1:20:::1:0:", -- Supply Crate
	[4630]="0:0:12:1:20:::1:0:", -- Scrap Metal
	[4631]="0:0:12:1:1:::1:0:", -- Tablet of Ryun'eh
	[4632]="0:50:15:2:1:Junk::1:0:", -- Ornate Bronze Lockbox
	[4633]="0:70:15:2:1:Junk::1:0:", -- Heavy Bronze Lockbox
	[4634]="0:87:15:2:1:Junk::1:0:", -- Iron Lockbox
	[4635]="0:0:12:1:1:::1:0:", -- Hammertoe's Amulet
	[4636]="0:110:15:2:1:Junk::1:0:", -- Strong Iron Lockbox
	[4637]="0:150:15:2:1:Junk::1:0:", -- Steel Lockbox
	[4638]="0:200:15:2:1:Junk::1:0:", -- Reinforced Steel Lockbox
	[4639]="0:162:12:1:1:::1:0:", -- Enchanted Sea Kelp
	[4640]="0:0:12:1:1:::1:0:", -- Sign of the Earth
	[4641]="0:0:12:1:1:::1:0:", -- Hand of Dagun
	[4643]="0:1824:4:2:1:Cloak::1:0:", -- Grimsteel Cape
	[4644]="0:0:12:1:1:::1:0:", -- The Legacy Heart
	[4645]="0:0:12:1:1:::1:0:", -- Chains of Hematus
	[4646]="0:0:12:1:1:::1:0:", -- Star of Xil'yeh
	[4647]="0:0:12:1:1:::1:0:", -- Yagyin's Digest
	[4648]="0:0:12:1:1:::1:0:", -- Sigil of the Hammer
	[4649]="0:0:12:1:1:::1:0:", -- Bonegrip's Note
	[4650]="0:0:12:1:1:::1:0:", -- Bel'dugur's Note
	[4652]="0:10126:4:2:1:Shield::1:0:", -- Salbac Shield
	[4653]="0:7178:4:2:1:Mail::1:0:", -- Ironheel Boots
	[4654]="0:0:12:1:1:::1:0:", -- Mysterious Fossil
	[4655]="0:71:7:1:10:Meat:185:1:0:", -- Giant Clam Meat
	[4656]="0:1:0:1:20:FoodDrink:185:1:0:", -- Small Pumpkin
	[4658]="0:23:4:1:1:Cloak::1:0:", -- Warrior's Cloak
	[4659]="0:23:4:1:1:Mail::1:0:", -- Warrior's Girdle
	[4660]="0:324:4:2:1:Cloth::1:0:", -- Walking Boots
	[4661]="0:929:4:2:1:Cloth::1:0:", -- Bright Mantle
	[4662]="0:24:4:1:1:Cloak::1:0:", -- Journeyman's Cloak
	[4663]="0:23:4:1:1:Cloth::1:0:", -- Journeyman's Belt
	[4665]="0:22:4:1:1:Cloak::1:0:", -- Burnt Cloak
	[4666]="0:26:4:1:1:Leather::1:0:", -- Burnt Leather Belt
	[4668]="0:32:4:1:1:Cloak::1:0:", -- Battle Chain Cloak
	[4669]="0:42:4:1:1:Mail::1:0:", -- Battle Chain Girdle
	[4671]="0:32:4:1:1:Cloak::1:0:", -- Ancestral Cloak
	[4672]="0:28:4:1:1:Cloth::1:0:", -- Ancestral Belt
	[4674]="0:32:4:1:1:Cloak::1:0:", -- Tribal Cloak
	[4675]="0:35:4:1:1:Leather::1:0:", -- Tribal Belt
	[4676]="0:278:4:2:1:Mail::1:0:", -- Skeletal Gauntlets
	[4677]="0:70:4:1:1:Cloak::1:0:", -- Veteran Cloak
	[4678]="0:108:4:1:1:Mail::1:0:", -- Veteran Girdle
	[4680]="0:91:4:1:1:Cloak::1:0:", -- Brackwater Cloak
	[4681]="0:109:4:1:1:Mail::1:0:", -- Brackwater Girdle
	[4683]="0:92:4:1:1:Cloak::1:0:", -- Spellbinder Cloak
	[4684]="0:61:4:1:1:Cloth::1:0:", -- Spellbinder Belt
	[4686]="0:67:4:1:1:Cloak::1:0:", -- Barbaric Cloth Cloak
	[4687]="0:67:4:1:1:Cloth::1:0:", -- Barbaric Cloth Belt
	[4689]="0:85:4:1:1:Cloak::1:0:", -- Hunting Cloak
	[4690]="0:71:4:1:1:Leather::1:0:", -- Hunting Belt
	[4692]="0:69:4:1:1:Cloak::1:0:", -- Ceremonial Cloak
	[4693]="0:86:4:1:1:Leather::1:0:", -- Ceremonial Leather Belt
	[4694]="0:515:4:1:1:Mail::1:0:", -- Burnished Pauldrons
	[4695]="0:327:4:2:1:Cloak::1:0:", -- Burnished Cloak
	[4696]="0:5537:4:3:1:OffHandFrill::1:0:", -- Lapidis Tankard of Tidesippe
	[4697]="0:435:4:2:1:Mail::1:0:", -- Burnished Girdle
	[4698]="0:301:4:1:1:Cloth::1:0:", -- Seer's Mantle
	[4699]="0:221:4:2:1:Cloth::1:0:", -- Seer's Belt
	[4700]="0:379:4:1:1:Leather::1:0:", -- Inscribed Leather Spaulders
	[4701]="0:252:4:2:1:Cloak::1:0:", -- Inscribed Cloak
	[4702]="0:0:12:1:20:::1:0:", -- Prospector's Pick
	[4703]="0:0:12:1:20:::1:0:", -- Broken Tools
	[4705]="0:1449:4:2:1:Mail::1:0:", -- Lambent Scale Pauldrons
	[4706]="0:687:4:2:1:Cloak::1:0:", -- Lambent Scale Cloak
	[4707]="0:881:4:2:1:Mail::1:0:", -- Lambent Scale Girdle
	[4708]="0:462:4:2:1:Cloth::1:0:", -- Bright Belt
	[4709]="0:982:4:2:1:Leather::1:0:", -- Forest Leather Mantle
	[4710]="0:561:4:2:1:Cloak::1:0:", -- Forest Cloak
	[4711]="0:1112:4:2:1:Cloak::1:0:", -- Glimmering Cloak
	[4712]="0:1228:4:2:1:Mail::1:0:", -- Glimmering Mail Girdle
	[4713]="0:926:4:2:1:Cloak::1:0:", -- Silver-thread Cloak
	[4714]="0:681:4:2:1:Cloth::1:0:", -- Silver-thread Sash
	[4715]="0:1026:4:2:1:Cloak::1:0:", -- Emblazoned Cloak
	[4716]="0:1658:4:2:1:Cloak::1:0:", -- Combat Cloak
	[4717]="0:2014:4:2:1:Mail::1:0:", -- Mail Combat Belt
	[4718]="0:2223:4:2:1:Cloth::1:0:", -- Nightsky Mantle
	[4719]="0:1676:4:2:1:Cloak::1:0:", -- Nightsky Cloak
	[4720]="0:1234:4:2:1:Cloth::1:0:", -- Nightsky Sash
	[4721]="0:2809:4:2:1:Leather::1:0:", -- Insignia Mantle
	[4722]="0:1694:4:2:1:Cloak::1:0:", -- Insignia Cloak
	[4723]="0:1703:4:2:1:Cloth::1:0:", -- Humbert's Pants
	[4724]="0:1763:4:2:1:Leather::1:0:", -- Humbert's Helm
	[4725]="0:4736:4:2:1:Mail::1:0:", -- Chief Brigadier Pauldrons
	[4726]="0:2340:4:2:1:Cloak::1:0:", -- Chief Brigadier Cloak
	[4727]="0:2791:4:2:1:Mail::1:0:", -- Chief Brigadier Girdle
	[4729]="0:3036:4:2:1:Cloth::1:0:", -- Aurora Mantle
	[4731]="0:3824:4:2:1:Leather::1:0:", -- Glyphed Epaulets
	[4732]="0:2632:4:2:1:Cloak::1:0:", -- Glyphed Cloak
	[4733]="0:7957:4:2:1:Mail::1:0:", -- Blackforge Pauldrons
	[4734]="0:4208:4:2:1:Cloth::1:0:", -- Mistscape Mantle
	[4735]="0:3621:4:2:1:Cloak::1:0:", -- Mistscape Cloak
	[4736]="0:2616:4:2:1:Cloth::1:0:", -- Mistscape Sash
	[4737]="0:5743:4:2:1:Leather::1:0:", -- Imperial Leather Spaulders
	[4738]="0:3294:4:2:1:Leather::1:0:", -- Imperial Leather Belt
	[4739]="0:0:12:1:20:::1:0:", -- Plainstrider Meat
	[4740]="0:0:12:1:20:::1:0:", -- Plainstrider Feather
	[4741]="0:5438:4:2:1:Mail::1:0:", -- Stromgarde Cavalry Leggings
	[4742]="0:0:12:1:20:::1:0:", -- Mountain Cougar Pelt
	[4743]="0:5430:4:3:1:Amulet::1:0:", -- Pulsating Crystalline Shard
	[4744]="0:1986:4:2:1:Cloth::1:0:", -- Arcane Runed Bracers
	[4745]="0:3230:4:2:1:Mail::1:0:", -- War Rider Bracers
	[4746]="0:4324:4:2:1:Cloth::1:0:", -- Doomsayer's Robe
	[4751]="0:0:12:1:20:::1:0:", -- Windfury Talon
	[4752]="0:0:12:1:20:::1:0:", -- Azure Feather
	[4753]="0:0:12:1:20:::1:0:", -- Bronze Feather
	[4755]="0:0:12:1:1:::1:0:", -- Water Pitcher
	[4757]="0:4:15:0:5:Junk::1:0:", -- Cracked Egg Shells
	[4758]="0:0:12:1:20:::1:0:", -- Prairie Wolf Paw
	[4759]="0:0:12:1:20:::1:0:", -- Plainstrider Talon
	[4765]="2878:575:2:2:1:OneHandSword::1:1:167,3479,3658,3682", -- Enamelled Broadsword
	[4766]="2407:481:2:2:1:OneHandSword::1:1:167,3479,3658,3682", -- Feral Blade
	[4767]="0:139:4:2:1:Cloth::1:0:", -- Coppercloth Gloves
	[4768]="0:139:4:2:1:Cloth::1:0:", -- Adept's Gloves
	[4769]="0:0:12:1:20:::1:0:", -- Trophy Swoop Quill
	[4770]="0:0:12:1:20:::1:0:", -- Bristleback Belt
	[4771]="0:211:4:2:1:Cloak::1:0:", -- Harvest Cloak
	[4772]="0:56:4:1:1:Cloak::1:0:", -- Warm Cloak
	[4775]="0:28:15:0:5:Junk::1:0:", -- Cracked Bill
	[4776]="0:41:15:0:10:Junk::1:0:", -- Ruffled Feather
	[4777]="7040:1408:2:2:1:TwoHandMace::1:1:222,844,2840,3534,3658,3682", -- Ironwood Maul
	[4778]="7351:1470:2:2:1:TwoHandMace::1:1:222,844,2840,3534,3658,3682", -- Heavy Spiked Mace
	[4779]="0:13:15:0:10:Junk::1:0:", -- Dull Kodo Tooth
	[4780]="0:56:15:0:5:Junk::1:0:", -- Kodo Horn Fragment
	[4781]="2736:547:4:2:1:Cloth::1:1:1214,3091,3486,3554", -- Whispering Vest
	[4782]="2077:415:4:2:1:Cloth::1:1:1214,3091,3486,3683", -- Solstice Robe
	[4783]="0:0:12:1:1:::1:0:", -- Totem of Hawkwind
	[4784]="0:360:15:0:5:Junk::1:0:", -- Lifeless Stone
	[4785]="0:469:4:2:1:Cloth::1:0:", -- Brimstone Belt
	[4786]="1394:278:4:2:1:Cloth::1:1:1214,3486,3683", -- Wise Man's Belt
	[4787]="0:577:15:0:5:Junk::1:0:", -- Burning Pitch
	[4788]="2634:526:4:2:1:Leather::1:1:954,1669,3552,3684", -- Agile Boots
	[4789]="1999:399:4:2:1:Leather::1:1:954,1669,3552,3684", -- Stable Boots
	[4790]="4159:831:4:2:1:Cloak::1:1:1454,3096,3486", -- Inferno Cloak
	[4791]="0:133:0:1:20:FoodDrink::1:0:", -- Enchanted Water
	[4792]="3280:656:4:2:1:Cloak::1:1:1454,3096,3486", -- Spirit Cloak
	[4793]="3720:744:4:2:1:Cloak::1:1:1454,3096,3486", -- Sylvan Cloak
	[4794]="3515:703:4:2:1:Leather::1:1:844,3097,3492,3536", -- Wolf Bracers
	[4795]="3528:705:4:2:1:Leather::1:1:844,3097,3492,3536", -- Bear Bracers
	[4796]="3540:708:4:2:1:Leather::1:1:844,3097,3492,3536", -- Owl Bracers
	[4797]="4263:852:4:2:1:Cloak::1:1:226,3493,3543,3682", -- Fiery Cloak
	[4798]="3871:774:4:2:1:Cloak::1:1:226,3493,3543,3682", -- Heavy Runed Cloak
	[4799]="3043:608:4:2:1:Cloak::1:1:226,3493,3543,3682", -- Antiquated Cloak
	[4800]="6110:1222:4:2:1:Mail::1:1:226,3493,3543,3682", -- Mighty Chain Pants
	[4801]="0:0:12:1:20:::1:0:", -- Stalker Claws
	[4802]="0:0:12:1:20:::1:0:", -- Cougar Claws
	[4803]="0:0:12:1:20:::1:0:", -- Prairie Alpha Tooth
	[4804]="0:0:12:1:1:::1:0:", -- Prairie Wolf Heart
	[4805]="0:0:12:1:1:::1:0:", -- Flatland Cougar Femur
	[4806]="0:0:12:1:1:::1:0:", -- Plainstrider Scale
	[4807]="0:0:12:1:1:::1:0:", -- Swoop Gizzard
	[4808]="0:0:12:1:20:::1:0:", -- Well Stone
	[4809]="0:0:12:1:20:::1:0:", -- Ambercorn
	[4810]="0:3352:4:2:1:Leather::1:0:", -- Boulder Pads
	[4813]="0:33:15:0:10:Junk::1:0:", -- Small Leather Collar
	[4814]="0:6:15:0:5:Junk::1:0:", -- Discolored Fang
	[4816]="7519:1503:4:2:1:Mail::1:1:226,3493,3543,3682", -- Legionnaire's Leggings
	[4817]="12311:2462:2:2:1:TwoHandSword::1:1:844,1441,3534,3539,4086,4890", -- Blessed Claymore
	[4818]="14273:2854:2:2:1:TwoHandSword::1:1:844,3534,3539,4086,4890", -- Executioner's Sword
	[4819]="0:0:12:1:1:::1:0:", -- Fizsprocket's Clipboard
	[4820]="8321:1664:4:2:1:Shield::1:1:793,3493", -- Guardian Buckler
	[4821]="6541:1308:4:2:1:Shield::1:1:793,3493", -- Bear Buckler
	[4822]="6746:1349:4:2:1:Shield::1:1:793,3493", -- Owl's Disk
	[4823]="0:0:12:1:1:::1:0:", -- Water of the Seers
	[4824]="16856:3371:2:2:1:OneHandAxe::1:1:1307,3539,4890", -- Blurred Axe
	[4825]="20472:4094:2:2:1:OneHandAxe::1:1:1307,3539,4890", -- Callous Axe
	[4826]="15436:3087:2:2:1:OneHandAxe::1:1:1307,3180,3539,4890", -- Marauder Axe
	[4827]="3749:749:4:2:1:Cloth::1:1:1307,3134,3537", -- Wizard's Belt
	[4828]="3420:684:4:2:1:Cloth::1:1:1307,2679,3134,3537,4085", -- Nightwind Belt
	[4829]="4154:830:4:2:1:Cloth::1:1:1307,3134,3537", -- Dreamer's Belt
	[4830]="9475:1895:4:2:1:Leather::1:1:3180,3536,4085,4890", -- Saber Leggings
	[4831]="7859:1571:4:2:1:Leather::1:1:4890", -- Stalking Pants
	[4832]="10498:2099:4:2:1:Leather::1:1:3536,4085", -- Mystic Sarong
	[4833]="8658:1731:4:2:1:Mail::1:1:3543,4085", -- Glorious Shoulders
	[4834]="0:0:12:1:1:::1:0:", -- Venture Co. Documents
	[4835]="10551:2110:4:2:1:Mail::1:1:2679,3180,3543", -- Elite Shoulders
	[4836]="8002:2000:4:2:1:OffHandFrill::1:1:3134,3537,4086", -- Fireproof Orb
	[4837]="8002:2000:4:2:1:OffHandFrill::1:1:3134,3537,4086", -- Strength of Will
	[4838]="8002:2000:4:2:1:OffHandFrill::1:1:3134,3537,4086", -- Orb of Power
	[4840]="0:142:2:1:1:Dagger::1:0:", -- Long Bayonet
	[4841]="0:0:12:1:1:::1:0:", -- Horn of Arra'chea
	[4843]="0:0:12:1:1:::1:0:", -- Amethyst Runestone
	[4844]="0:0:12:1:1:::1:0:", -- Opal Runestone
	[4845]="0:0:12:1:1:::1:0:", -- Diamond Runestone
	[4846]="0:0:12:1:1:::1:0:", -- Cog #5
	[4847]="0:0:12:1:1:::1:0:", -- Lotwil's Shackles of Elemental Binding
	[4848]="0:0:12:1:20:::1:0:", -- Battleboar Snout
	[4849]="0:0:12:1:20:::1:0:", -- Battleboar Flank
	[4850]="0:0:12:1:1:::1:0:", -- Bristleback Attack Plans
	[4851]="0:0:12:1:1:::1:0:", -- Dirt-stained Map
	[4852]="0:300:7:1:20:Explosive::1:0:", -- Flash Bomb
	[4854]="0:0:4:1:1:Cloak::1:0:", -- Demon Scarred Cloak
	[4859]="0:0:12:1:1:::1:0:", -- Burning Blade Medallion
	[4860]="0:741:15:0:5:Junk::1:0:", -- Glistening Frenzy Scale
	[4861]="0:119:4:2:1:Leather::1:0:", -- Sleek Feathered Tunic
	[4862]="0:0:12:1:20:::1:0:", -- Scorpid Worker Tail
	[4863]="0:0:12:1:20:::1:0:", -- Gnomish Tools
	[4864]="0:0:12:1:10:::1:0:", -- Minshina's Skull
	[4865]="0:5:15:0:5:Junk::1:0:", -- Ruined Pelt
	[4866]="0:0:12:1:1:::1:0:", -- Zalazane's Head
	[4867]="0:8:15:0:5:Junk::1:0:", -- Broken Scorpid Leg
	[4869]="0:0:12:1:1:::1:0:", -- Fizzle's Claw
	[4870]="0:0:12:1:20:::1:0:", -- Canvas Scraps
	[4871]="0:0:12:1:20:::1:0:", -- Searing Collar
	[4872]="0:95:15:0:5:Junk::1:0:", -- Dry Scorpid Eye
	[4873]="0:15:15:0:5:Junk::1:0:", -- Dry Hardened Barnacle
	[4874]="0:46:15:0:5:Junk::1:0:", -- Clean Fishbones
	[4875]="0:13:15:0:5:Junk::1:0:", -- Slimy Bone
	[4876]="0:78:15:0:5:Junk::1:0:", -- Bloody Leather Boot
	[4877]="0:10:15:0:5:Junk::1:0:", -- Stone Arrowhead
	[4878]="0:56:15:0:1:Junk::1:0:", -- Broken Bloodstained Bow
	[4879]="0:7:15:0:5:Junk::1:0:", -- Squashed Rabbit Carcass
	[4880]="0:86:15:0:5:Junk::1:0:", -- Broken Spear
	[4881]="0:0:12:1:1:::1:0:", -- Aged Envelope
	[4882]="0:0:13:1:1:::1:0:", -- Benedict's Key
	[4883]="0:0:12:1:1:::1:0:", -- Admiral Proudmoore's Orders
	[4886]="0:0:12:1:20:::1:0:", -- Venomtail Poison Sac
	[4887]="0:0:12:1:20:::1:0:", -- Intact Makrura Eye
	[4888]="0:0:12:1:20:::1:0:", -- Crawler Mucus
	[4890]="0:0:12:1:20:::1:0:", -- Taillasher Egg
	[4891]="0:0:12:1:1:::1:0:", -- Kron's Amulet
	[4892]="0:0:12:1:20:::1:0:", -- Durotar Tiger Fur
	[4893]="0:0:12:1:20:::1:0:", -- Savannah Lion Tusk
	[4894]="0:0:12:1:20:::1:0:", -- Plainstrider Kidney
	[4895]="0:0:12:1:1:::1:0:", -- Thunder Lizard Horn
	[4896]="0:0:12:1:20:::1:0:", -- Kodo Liver
	[4897]="0:0:12:1:20:::1:0:", -- Thunderhawk Saliva Gland
	[4898]="0:0:12:1:20:::1:0:", -- Lightning Gland
	[4903]="0:0:12:1:1:::1:0:", -- Eye of Burning Shadow
	[4904]="0:0:12:1:20:::1:0:", -- Venomtail Antidote
	[4905]="0:0:12:1:1:::1:0:", -- Sarkoth's Mangled Claw
	[4906]="0:22:4:1:1:Leather::1:0:", -- Rainwalker Boots
	[4907]="0:13:4:1:1:Leather::1:0:", -- Woodland Tunic
	[4908]="0:6:4:1:1:Leather::1:0:", -- Nomadic Bracers
	[4909]="0:369:4:2:1:Leather::1:0:", -- Kodo Hunter's Leggings
	[4910]="0:7:4:1:1:Mail::1:0:", -- Painted Chain Gloves
	[4911]="0:15:4:1:1:Shield::1:0:", -- Thick Bark Buckler
	[4913]="0:7:4:1:1:Mail::1:0:", -- Painted Chain Belt
	[4914]="0:6:4:1:1:Leather::1:0:", -- Battleworn Leather Gloves
	[4915]="0:7:4:1:1:Cloth::1:0:", -- Soft Wool Boots
	[4916]="0:9:4:1:1:Cloth::1:0:", -- Soft Wool Vest
	[4917]="0:14:4:1:1:Mail::1:0:", -- Battleworn Chain Leggings
	[4918]="0:0:12:1:20:::1:0:", -- Sack of Supplies
	[4919]="0:5:4:1:1:Cloth::1:0:", -- Soft Wool Belt
	[4920]="0:7:4:1:1:Cloak::1:0:", -- Battleworn Cape
	[4921]="0:12:4:1:1:Leather::1:0:", -- Dust-covered Leggings
	[4922]="0:15:4:1:1:Mail::1:0:", -- Jagged Chain Vest
	[4923]="0:25:2:1:1:OneHandAxe::1:0:", -- Primitive Hatchet
	[4924]="0:25:2:1:1:OneHandMace::1:0:", -- Primitive Club
	[4925]="0:26:2:1:1:Dagger::1:0:", -- Primitive Hand Blade
	[4926]="0:0:12:1:1:::1:0:", -- Chen's Empty Keg
	[4928]="0:20:4:1:1:Leather::1:0:", -- Sandrunner Wristguards
	[4929]="0:58:4:1:1:Leather::1:0:", -- Light Scorpid Armor
	[4931]="0:134:2:1:1:Bow::1:0:", -- Hickory Shortbow
	[4932]="0:179:2:1:1:OneHandSword::1:0:", -- Harpy Wing Clipper
	[4933]="0:32:4:1:1:Cloak::1:0:", -- Seasoned Fighter's Cloak
	[4935]="0:23:4:1:1:Mail::1:0:", -- Wide Metal Girdle
	[4936]="0:23:4:1:1:Cloth::1:0:", -- Dirt-trodden Boots
	[4937]="0:71:4:1:1:Shield::1:0:", -- Charging Buckler
	[4938]="0:236:2:1:1:Stave::1:0:", -- Blemished Wooden Staff
	[4939]="0:395:2:2:1:TwoHandSword::1:0:", -- Steady Bastard Sword
	[4940]="0:36:4:1:1:Leather::1:0:", -- Veiled Grips
	[4941]="0:11:0:1:20:Consumable::1:0:", -- Really Sticky Glue
	[4942]="0:89:4:1:1:Leather::1:0:", -- Tiger Hide Boots
	[4944]="0:72:4:1:1:Cloak::1:0:", -- Handsewn Cloak
	[4945]="0:37:0:1:1:Consumable::1:0:", -- Faintly Glowing Skull
	[4946]="0:67:4:1:1:Mail::1:0:", -- Lightweight Boots
	[4947]="0:325:2:2:1:Dagger::1:0:", -- Jagged Dagger
	[4948]="0:326:2:2:1:OneHandMace::1:0:", -- Stinging Mace
	[4949]="0:1706:2:2:1:OneHandAxe::1:0:", -- Orcish Cleaver
	[4951]="0:13:4:1:1:Leather::1:0:", -- Squealer's Belt
	[4952]="0:63:0:1:10:Consumable::1:0:", -- Stormstout
	[4953]="0:88:0:1:10:Consumable::1:0:", -- Trogg Ale
	[4954]="0:6:4:1:1:Leather::1:0:", -- Nomadic Belt
	[4957]="0:250:1:1:1:Bag::1:0:", -- Old Moneybag
	[4958]="0:23:4:1:1:Cloak::1:0:", -- Sun-beaten Cloak
	[4960]="0:12:6:1:1000:Bullet::1:0:", -- Flash Pellet
	[4961]="0:183:2:1:1:Stave::1:0:", -- Dreamwatcher Staff
	[4962]="0:20:4:1:1:Leather::1:0:", -- Double-layered Gloves
	[4963]="0:24:4:1:1:Cloak::1:0:", -- Thunderhorn Cloak
	[4964]="0:503:2:2:1:TwoHandMace::1:0:", -- Goblin Smasher
	[4967]="0:116:4:1:1:Shield::1:0:", -- Tribal Warrior's Shield
	[4968]="0:91:4:1:1:Leather::1:0:", -- Bound Harness
	[4969]="0:42:4:1:1:Mail::1:0:", -- Fortified Bindings
	[4970]="0:54:4:1:1:Leather::1:0:", -- Rough-hewn Kodo Leggings
	[4971]="0:383:2:2:1:OneHandMace::1:0:", -- Skorn's Hammer
	[4972]="0:64:4:1:1:Mail::1:0:", -- Cliff Runner Boots
	[4973]="0:35:4:1:1:Leather::1:0:", -- Plains Hunter Wristguards
	[4974]="0:388:2:2:1:Dagger::1:0:", -- Compact Fighting Knife
	[4975]="0:7773:4:3:1:Shield::1:0:", -- Vigilant Buckler
	[4976]="0:5486:4:2:1:Leather::1:0:", -- Mistspray Kilt
	[4977]="0:11893:2:2:1:OneHandSword::1:0:", -- Sword of Hammerfall
	[4978]="0:7976:2:2:1:OneHandMace::1:0:", -- Ryedol's Hammer
	[4979]="0:2587:4:2:1:Cloth::1:0:", -- Enchanted Stonecloth Bracers
	[4980]="0:2209:4:2:1:Leather::1:0:", -- Prospector Gloves
	[4982]="0:961:4:0:1:Leather::1:0:", -- Ripped Prospector Belt
	[4983]="0:16837:2:2:1:TwoHandMace::1:0:", -- Rock Pulverizer
	[4984]="0:5630:4:2:1:OffHandFrill::1:0:", -- Skull of Impending Doom
	[4986]="0:0:12:1:1:::1:0:", -- Flawed Power Stone
	[4987]="0:15584:2:2:1:OneHandSword::1:0:", -- Dwarf Captain's Sword
	[4992]="0:0:12:1:1:::1:0:", -- Recruitment Letter
	[4995]="0:0:12:1:1:::1:0:", -- Signed Recruitment Letter
	[4998]="0:837:4:2:1:Ring::1:0:", -- Blood Ring
	[4999]="0:1052:4:2:1:Ring::1:0:", -- Azora's Will
	[5001]="0:1038:4:2:1:Ring::1:0:", -- Heart Ring
	[5002]="0:1535:4:2:1:Amulet::1:0:", -- Glowing Green Talisman
	[5003]="0:1713:4:2:1:Amulet::1:0:", -- Crystal Starfire Medallion
	[5005]="0:1840:4:2:1:Amulet::1:0:", -- Emberspark Pendant
	[5006]="0:0:12:1:1:::1:0:", -- Khazgorm's Journal
	[5007]="0:1632:4:2:1:Ring::1:0:", -- Band of Thorns
	[5009]="0:1696:4:2:1:Ring::1:0:", -- Mindbender Loop
	[5011]="0:1912:4:2:1:Ring::1:0:", -- Welken Ring
	[5012]="0:0:12:1:20:::1:0:", -- Fungal Spores
	[5016]="0:2955:4:2:1:Cloth::1:0:", -- Artisan's Trousers
	[5017]="0:0:12:1:20:::1:0:", -- Nitroglycerin
	[5018]="0:0:12:1:20:::1:0:", -- Wood Pulp
	[5019]="0:0:12:1:20:::1:0:", -- Sodium Nitrate
	[5020]="0:3:13:1:1:::1:0:", -- Kolkar Booty Key
	[5021]="0:0:12:1:1:::1:0:", -- Explosive Stick of Gann
	[5022]="0:0:12:1:1:::1:0:", -- Barak's Head
	[5023]="0:0:12:1:1:::1:0:", -- Verog's Head
	[5025]="0:0:12:1:1:::1:0:", -- Hezrul's Head
	[5026]="0:0:12:1:1:::1:0:", -- Fire Tar
	[5027]="0:0:12:1:1:::1:0:", -- Rendered Spores
	[5028]="0:5537:4:2:1:OffHandFrill::1:0:", -- Lord Sakrasis' Scepter
	[5029]="0:5282:4:2:1:Amulet::1:0:", -- Talisman of the Naga Lord
	[5030]="0:0:12:1:20:::1:0:", -- Centaur Bracers
	[5038]="0:0:12:1:1:::1:0:", -- Tear of the Moons
	[5040]="0:0:2:1:1:Dagger::1:0:", -- Shadow Hunter Knife
	[5042]="50:12:15:1:10:Junk::1:0:151,491,1250,1285,1682,1685,1691,2134,2140,3076,3164,3186,3313,3481,3608,4170,4182,4241,8362,16187,16191,16259,16260,16444,16732,17421,17446,17489,18810,19197", -- Red Ribboned Wrapping Paper
	[5043]="0:0:15:1:1:Junk::1:0:", -- Red Ribboned Gift
	[5044]="0:0:15:1:1:Junk::1:0:", -- Blue Ribboned Gift
	[5048]="50:12:15:1:10:Junk::1:0:791,1285,3313,3498,4082,4084,4555,7942,8362,12027,12960,16191,16732,17489,18811,19197", -- Blue Ribboned Wrapping Paper
	[5050]="0:0:13:1:1:::1:0:", -- Ignition Key
	[5051]="0:1:12:1:20::185:1:0:", -- Dig Rat
	[5052]="0:0:15:1:1:CombatPet::1:0:", -- Unconscious Dig Rat
	[5054]="0:0:12:1:1:::1:0:", -- Samophlange
	[5055]="0:0:12:1:20:::1:0:", -- Intact Raptor Horn
	[5056]="0:0:12:1:20:::1:0:", -- Root Sample
	[5057]="0:1:0:1:20:FoodDrink::1:0:", -- Ripe Watermelon
	[5058]="0:0:12:1:20:::1:0:", -- Silithid Egg
	[5059]="0:0:15:1:1:CombatPet::1:0:", -- Digging Claw
	[5060]="0:0:15:1:1:Reagent::1:0:", -- Thieves' Tools
	[5061]="0:0:12:1:20:::1:0:", -- Stolen Silver
	[5062]="0:0:12:1:20:::1:0:", -- Raptor Head
	[5063]="0:0:12:1:1:::1:0:", -- Kreenig Snarlsnout's Tusk
	[5064]="0:0:12:1:20:::1:0:", -- Witchwing Talon
	[5065]="0:0:12:1:20:::1:0:", -- Harpy Lieutenant Ring
	[5066]="0:21:0:1:10:FoodDrink::1:0:", -- Fissure Plant
	[5067]="0:0:12:1:1:::1:0:", -- Serena's Head
	[5068]="0:0:12:1:1:::1:0:", -- Dried Seeds
	[5069]="0:293:2:2:1:Wand::1:0:", -- Fire Wand
	[5071]="0:443:2:2:1:Wand::1:0:", -- Shadow Wand
	[5072]="0:0:12:1:1:::1:0:", -- Lok's Skull
	[5073]="0:0:12:1:1:::1:0:", -- Nak's Skull
	[5074]="0:0:12:1:1:::1:0:", -- Kuz's Skull
	[5075]="0:25:12:1:10:::1:0:", -- Blood Shard
	[5076]="0:0:12:1:20:::1:0:", -- Shipment of Boots
	[5077]="0:0:12:1:20:::1:0:", -- Telescopic Lens
	[5078]="0:0:12:1:20:::1:0:", -- Theramore Medal
	[5079]="0:4642:4:2:1:Trinket::1:0:", -- Cold Basilisk Eye
	[5080]="0:0:12:1:10:::1:0:", -- Gazlowe's Ledger
	[5081]="0:250:1:1:1:Bag::1:0:", -- Kodo Hide Bag
	[5082]="0:25:7:1:10:Leather:165:1:0:", -- Thin Kodo Leather
	[5083]="0:50:9:2:1:Leatherworking::1:0:", -- Pattern: Kodo Hide Bag
	[5084]="0:0:12:1:1:::1:0:", -- Baron Longshore's Head
	[5085]="0:0:12:1:60:::1:0:", -- Bristleback Quilboar Tusk
	[5086]="0:0:12:1:20:::1:0:", -- Zhevra Hooves
	[5087]="0:0:12:1:20:::1:0:", -- Plainstrider Beak
	[5088]="0:0:12:1:1:::1:0:", -- Control Console Operating Manual
	[5089]="0:0:13:1:1:::1:0:", -- Console Key
	[5092]="0:240:2:1:1:Wand::1:0:", -- Charred Razormane Wand
	[5093]="0:247:2:1:1:Dagger::1:0:", -- Razormane Backstabber
	[5094]="0:233:4:1:1:Shield::1:0:", -- Razormane War Shield
	[5095]="0:3:0:1:20:FoodDrink::1:0:", -- Rainbow Fin Albacore
	[5096]="0:0:12:1:20:::1:0:", -- Prowler Claws
	[5097]="0:0:12:1:1:::1:0:", -- Cats Eye Emerald
	[5098]="0:0:12:1:20:::1:0:", -- Altered Snapjaw Shell
	[5099]="0:0:12:1:1:::1:0:", -- Hoof of Lakota'mani
	[5100]="0:0:12:1:1:::1:0:", -- Echeyakee's Hide
	[5101]="0:0:12:1:1:::1:0:", -- Ishamuhale's Fang
	[5102]="0:0:12:1:1:::1:0:", -- Owatanka's Tailspike
	[5103]="0:0:12:1:1:::1:0:", -- Washte Pawne's Feather
	[5104]="0:0:12:1:1:::1:0:", -- Heart of Isha Awak
	[5105]="0:25:15:1:20:Junk::1:0:", -- Explosive Shell
	[5107]="0:139:4:1:1:Shirt::1:0:", -- Deckhand's Shirt
	[5109]="0:223:4:1:1:Cloth::1:0:", -- Stonesplinter Rags
	[5110]="0:257:4:1:1:Cloth::1:0:", -- Dalaran Wizard's Robe
	[5111]="0:212:4:2:1:Cloak::1:0:", -- Rathorian's Cape
	[5112]="0:730:2:2:1:Dagger::1:0:", -- Ritual Blade
	[5113]="0:250:15:0:5:Junk::1:0:", -- Mark of the Syndicate
	[5114]="0:96:15:0:5:Junk::1:0:", -- Severed Talon
	[5115]="0:101:15:0:5:Junk::1:0:", -- Broken Wishbone
	[5116]="0:303:7:0:10:Leather::1:0:", -- Long Tail Feather
	[5117]="0:825:12:1:10:::1:0:", -- Vibrant Plume
	[5118]="0:71:15:0:10:Junk::1:0:", -- Large Flat Tooth
	[5119]="0:118:15:0:10:Junk::1:0:", -- Fine Loose Hair
	[5120]="0:193:15:0:5:Junk::1:0:", -- Long Tail Hair
	[5121]="0:162:15:0:5:Junk::1:0:", -- Dirty Kodo Scale
	[5122]="0:287:15:0:10:Junk::1:0:", -- Thick Kodo Hair
	[5123]="0:117:15:0:5:Junk::1:0:", -- Steel Arrowhead
	[5124]="0:117:15:0:10:Junk::1:0:", -- Small Raptor Tooth
	[5125]="0:155:15:0:5:Junk::1:0:", -- Charged Scale
	[5128]="0:202:15:0:5:Junk::1:0:", -- Shed Lizard Skin
	[5133]="0:300:15:0:5:Junk::1:0:", -- Seeping Gizzard
	[5134]="0:92:12:1:5:::1:0:", -- Small Furry Paw
	[5135]="0:142:15:0:5:Junk::1:0:", -- Thin Black Claw
	[5136]="0:177:15:0:5:Junk::1:0:", -- Torn Furry Ear
	[5137]="0:217:15:0:5:Junk::1:0:", -- Bright Eyeball
	[5138]="0:0:12:1:1:::1:0:", -- Harvester's Head
	[5140]="0:6:15:0:20:Reagent:-4:1:0:", -- Flash Powder
	[5143]="0:0:12:1:20:::1:0:", -- Thunder Lizard Blood
	[5164]="0:0:12:1:1:::1:0:", -- Thunderhawk Wings
	[5165]="0:0:12:1:20:::1:0:", -- Sunscale Feather
	[5166]="0:0:12:1:20:::1:0:", -- Webwood Venom Sac
	[5167]="0:0:12:1:20:::1:0:", -- Webwood Egg
	[5168]="0:0:12:1:20:::1:0:", -- Timberling Seed
	[5169]="0:0:12:1:20:::1:0:", -- Timberling Sprout
	[5170]="0:0:12:1:20:::1:0:", -- Mossy Tumor
	[5173]="0:25:15:0:20:Junk::1:0:", -- Deathweed
	[5175]="0:0:15:1:1:Reagent::1:0:", -- Earth Totem
	[5176]="0:0:15:1:1:Reagent::1:0:", -- Fire Totem
	[5177]="0:0:15:1:1:Reagent::1:0:", -- Water Totem
	[5178]="0:0:15:1:1:Reagent::1:0:", -- Air Totem
	[5179]="0:0:12:1:1:::1:0:", -- Moss-twined Heart
	[5180]="0:2777:4:2:1:Amulet::1:0:", -- Necklace of Harmony
	[5181]="0:1778:4:2:1:Cloak::1:0:", -- Vibrant Silk Cape
	[5182]="0:1769:2:2:1:TwoHandSword::1:0:", -- Shiver Blade
	[5183]="0:1575:4:3:1:OffHandFrill::1:0:", -- Pulsating Hydra Heart
	[5184]="0:0:12:1:1:::1:0:", -- Filled Crystal Phial
	[5185]="0:0:12:1:1:::1:0:", -- Crystal Phial
	[5186]="0:0:12:1:1:::1:0:", -- Partially Filled Vessel
	[5187]="0:2163:2:3:1:TwoHandMace::1:0:", -- Rhahk'Zor's Hammer
	[5188]="0:0:12:1:1:::1:0:", -- Filled Vessel
	[5189]="0:0:12:1:1:::1:0:", -- Glowing Fruit
	[5190]="0:0:12:1:1:::1:0:", -- Shimmering Frond
	[5191]="0:2964:2:3:1:OneHandSword::1:0:", -- Cruel Barb
	[5192]="0:2163:2:3:1:OneHandSword::1:0:", -- Thief's Blade
	[5193]="0:940:4:3:1:Cloak::1:0:", -- Cape of the Brotherhood
	[5194]="0:3079:2:3:1:TwoHandAxe::1:0:", -- Taskmaster Axe
	[5195]="0:437:4:3:1:Cloth::1:0:", -- Gold-flecked Gloves
	[5196]="0:2196:2:3:1:OneHandAxe::1:0:", -- Smite's Reaver
	[5197]="0:1917:2:3:1:OneHandMace::1:0:", -- Cookie's Tenderizer
	[5198]="0:1660:2:3:1:Wand::1:0:", -- Cookie's Stirring Rod
	[5199]="0:966:4:3:1:Leather::1:0:", -- Smelting Pants
	[5200]="0:2787:2:3:1:Polearm::1:0:", -- Impaling Harpoon
	[5201]="0:3161:2:3:1:Stave::1:0:", -- Emberstone Staff
	[5202]="0:1147:4:3:1:Cloth::1:0:", -- Corsair's Overshirt
	[5203]="0:0:12:1:20:::1:0:", -- Flatland Prowler Claw
	[5204]="0:0:12:1:20:::1:0:", -- Bloodfeather Belt
	[5205]="0:31:0:1:10:Other::1:0:", -- Sprouted Frond
	[5206]="0:37:0:1:10:Other::1:0:", -- Bogling Root
	[5207]="0:1081:2:2:1:Wand::1:0:", -- Opaque Wand
	[5208]="3340:668:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943", -- Smoldering Wand
	[5209]="3855:771:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943", -- Gloom Wand
	[5210]="5808:1161:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943", -- Burning Wand
	[5211]="5830:1166:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943", -- Dusk Wand
	[5212]="0:672:2:2:1:Wand::1:0:", -- Blazing Wand
	[5213]="0:5218:2:2:1:Wand::1:0:", -- Scorching Wand
	[5214]="0:3935:2:2:1:Wand::1:0:", -- Wand of Eventide
	[5215]="0:8656:2:2:1:Wand::1:0:", -- Ember Wand
	[5216]="0:11821:2:2:1:Wand::1:0:", -- Umbral Wand
	[5217]="0:0:12:1:1:::1:0:", -- Tainted Heart
	[5218]="0:0:12:1:1:::1:0:", -- Cleansed Timberling Heart
	[5219]="0:0:12:1:1:::1:0:", -- Inscribed Bark
	[5220]="0:0:12:1:20:::1:0:", -- Gnarlpine Fang
	[5221]="0:0:12:1:1:::1:0:", -- Melenas' Head
	[5232]="0:0:0:1:1:Consumable::1:0:", -- Minor Soulstone
	[5233]="0:0:12:1:1:::1:0:", -- Stone of Relu
	[5234]="0:0:12:1:1:::1:0:", -- Flagongut's Fossil
	[5236]="14394:2878:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943", -- Combustible Wand
	[5237]="40:10:0:1:20:EnhTemp::1:0:1325,1326,2622,3090,3135,3334,3561,3969,4585,5139,5169,12097,15175,16268,16588,16683,18019,19013,19049,19239,20194,23145,23732,24148,24313,24349,24357,24780,26568,26945,26950,27031,27053,27089,27149,28347,28832,28869,29037,29535,29909,29922,29947,29961,30010,30069,30239,30244,30306,30438,31115,32639,32641", -- Mind-numbing Poison
	[5238]="35727:7145:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943", -- Pitchwood Wand
	[5239]="38731:7746:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943", -- Blackbone Wand
	[5240]="0:1244:2:2:1:Wand::1:0:", -- Torchlight Wand
	[5241]="0:821:2:2:1:Wand::1:0:", -- Dwarven Flamestick
	[5242]="0:623:2:2:1:Wand::1:0:", -- Cinder Wand
	[5243]="0:1312:2:3:1:Wand::1:0:", -- Firebelcher
	[5244]="0:3465:2:2:1:Wand::1:0:", -- Consecrated Wand
	[5245]="0:5091:2:2:1:Wand::1:0:", -- Summoner's Wand
	[5246]="0:3490:2:2:1:Wand::1:0:", -- Excavation Rod
	[5247]="0:7961:2:2:1:Wand::1:0:", -- Rod of Sorrow
	[5248]="0:6849:2:2:1:Wand::1:0:", -- Flash Wand
	[5249]="0:8658:2:2:1:Wand::1:0:", -- Burning Sliver
	[5250]="0:2646:2:2:1:Wand::1:0:", -- Charred Wand
	[5251]="0:0:12:1:1:::1:0:", -- Phial of Scrying
	[5252]="0:1175:2:2:1:Wand::1:0:", -- Wand of Decay
	[5253]="0:7952:2:2:1:Wand::1:0:", -- Goblin Igniter
	[5254]="0:618:4:3:1:Leather::1:0:", -- Rugged Spaulders
	[5256]="0:7227:2:2:1:OneHandMace::1:0:", -- Kovork's Rattle
	[5257]="0:3159:4:3:1:Cloak::1:0:", -- Dark Hooded Cape
	[5263]="0:1:15:0:10:Junk::1:0:", -- Pocket Lint
	[5266]="0:11157:4:3:1:Ring::1:0:", -- Eye of Adaegus
	[5267]="0:53869:2:3:1:Dagger::1:0:", -- Scarlet Kris
	[5268]="0:218:15:0:5:Junk::1:0:", -- Cracked Silithid Shell
	[5269]="0:95:15:0:5:Junk::1:0:", -- Silithid Ichor
	[5270]="0:0:12:1:20:::1:0:", -- Death Cap
	[5271]="0:0:12:1:20:::1:0:", -- Scaber Stalk
	[5272]="0:0:12:1:1:::1:0:", -- Insane Scribbles
	[5273]="0:0:12:1:20:::1:0:", -- Mathystra Relic
	[5274]="0:1003:4:2:1:Cloth::1:0:", -- Rose Mantle
	[5275]="0:176:4:2:1:Leather::1:0:", -- Binding Girdle
	[5279]="0:1437:2:2:1:Dagger::1:0:", -- Harpy Skinner
	[5299]="0:359:4:2:1:Leather::1:0:", -- Gloves of the Moon
	[5302]="0:929:4:2:1:Shield::1:0:", -- Cobalt Buckler
	[5306]="0:1710:2:2:1:Stave::1:0:", -- Wind Rider Staff
	[5309]="0:1038:2:2:1:Gun::1:0:", -- Privateer Musket
	[5310]="0:555:4:2:1:Cloth::1:0:", -- Sea Dog Britches
	[5311]="0:601:4:2:1:Leather::1:0:", -- Buckled Boots
	[5312]="0:420:4:2:1:Mail::1:0:", -- Riveted Gauntlets
	[5313]="0:650:4:2:1:Ring::1:0:", -- Totemic Clan Ring
	[5314]="0:423:4:2:1:Cloak::1:0:", -- Boar Hunter's Cape
	[5315]="0:214:4:2:1:Cloth::1:0:", -- Timberland Armguards
	[5316]="0:1355:4:2:1:Leather::1:0:", -- Barkshell Tunic
	[5317]="0:1360:4:2:1:Leather::1:0:", -- Dry Moss Tunic
	[5318]="0:1789:2:2:1:TwoHandAxe::1:0:", -- Zhovur Axe
	[5319]="0:323:4:1:1:Leather::1:0:", -- Bashing Pauldrons
	[5320]="0:372:4:2:1:Mail::1:0:", -- Padded Lamellar Boots
	[5321]="0:1484:2:2:1:OneHandSword::1:0:", -- Elegant Shortsword
	[5322]="0:4016:2:2:1:TwoHandMace::1:0:", -- Demolition Hammer
	[5323]="0:1632:4:2:1:OffHandFrill::1:0:", -- Everglow Lantern
	[5324]="0:776:2:2:1:OneHandMace::1:0:", -- Engineer's Hammer
	[5325]="0:498:4:2:1:Shield::1:0:", -- Welding Shield
	[5326]="0:776:2:2:1:Wand::1:0:", -- Flaring Baton
	[5327]="0:519:4:2:1:Leather::1:0:", -- Greasy Tinker's Pants
	[5328]="0:205:4:2:1:Mail::1:0:", -- Cinched Belt
	[5329]="0:15:15:0:20:Junk::1:0:", -- Cat Figurine
	[5332]="0:15:15:1:1:CombatPet::1:0:", -- Glowing Cat Figurine
	[5334]="0:0:12:1:1:::1:0:", -- 99-Year-Old Port
	[5335]="0:0:15:1:1:Junk::1:0:", -- A Sack of Coins
	[5336]="0:0:12:1:20:::1:0:", -- Grell Earring
	[5337]="0:167:4:2:1:Cloth::1:0:", -- Wayfaring Gloves
	[5338]="0:0:12:1:1:::1:0:", -- Ancient Moonstone Seal
	[5339]="0:0:12:1:20:::1:0:", -- Serpentbloom
	[5340]="0:919:2:2:1:Stave::1:0:", -- Cauldron Stirrer
	[5341]="0:369:4:2:1:Leather::1:0:", -- Spore-covered Tunic
	[5342]="0:88:0:1:10:FoodDrink::1:0:", -- Raptor Punch
	[5343]="0:306:4:2:1:Cloak::1:0:", -- Barkeeper's Cloak
	[5344]="0:562:2:2:1:OneHandAxe::1:0:", -- Pointed Axe
	[5345]="0:705:2:2:1:TwoHandMace::1:0:", -- Stonewood Hammer
	[5346]="0:425:2:2:1:Bow::1:0:", -- Orcish Battle Bow
	[5347]="15713:3142:2:1:1:Wand::1:0:1312,5133,5754,5816,16632,16636,19236,27943", -- Pestilent Wand
	[5348]="0:0:12:1:20:::1:0:", -- Worn Parchment
	[5349]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Muffin
	[5350]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Water
	[5351]="0:403:4:2:1:Ring::1:0:", -- Bounty Hunter's Ring
	[5352]="0:0:12:1:1:::1:0:", -- Book: The Powers Below
	[5354]="0:0:12:1:1:::1:0:", -- Letter to Delgren
	[5355]="0:947:4:2:1:Leather::1:0:", -- Beastmaster's Girdle
	[5356]="0:2594:2:2:1:Wand::1:0:", -- Branding Rod
	[5357]="0:2221:4:2:1:Shield::1:0:", -- Ward of the Vale
	[5359]="0:0:12:1:1:::1:0:", -- Lorgalis Manuscript
	[5360]="0:0:12:1:20:::1:0:", -- Highborne Relic
	[5361]="0:16:15:0:10:Junk::1:0:", -- Fishbone Toothpick
	[5362]="0:18:15:0:5:Junk::1:0:", -- Chew Toy
	[5363]="0:20:15:0:5:Junk::1:0:", -- Folded Handkerchief
	[5364]="0:27:15:0:5:Junk::1:0:", -- Dry Salt Lick
	[5366]="0:0:12:1:1:::1:0:", -- Glowing Soul Gem
	[5367]="0:22:15:0:5:Junk::1:0:", -- Primitive Rock Tool
	[5368]="0:48:15:0:5:Junk::1:0:", -- Empty Wallet
	[5369]="0:32:15:0:5:Junk::1:0:", -- Gnawed Bone
	[5370]="0:37:15:0:5:Junk::1:0:", -- Bent Spoon
	[5371]="0:48:15:0:5:Junk::1:0:", -- Piece of Coral
	[5373]="0:72:15:1:5:Junk:165:1:0:", -- Lucky Charm
	[5374]="0:87:15:0:5:Junk::1:0:", -- Small Pocket Watch
	[5375]="0:95:15:0:5:Junk::1:0:", -- Scratching Stick
	[5376]="0:66:15:0:5:Junk::1:0:", -- Broken Mirror
	[5377]="0:57:15:0:5:Junk::1:0:", -- Scallop Shell
	[5379]="0:0:15:0:200:Junk::1:0:", -- Broken Boot Knife
	[5382]="0:0:12:1:1:::1:0:", -- Anaya's Pendant
	[5383]="0:0:12:1:1:::1:0:", -- Athrikus Narassin's Head
	[5385]="0:0:12:1:20:::1:0:", -- Crawler Leg
	[5386]="0:0:12:1:20:::1:0:", -- Fine Moonstalker Pelt
	[5387]="0:0:4:2:1:Cloak::1:0:", -- Enchanted Moonstalker Cloak
	[5388]="0:0:12:1:1:::1:0:", -- Ran Bloodtooth's Skull
	[5389]="0:0:12:1:1:::1:0:", -- Corrupted Furbolg Totem
	[5390]="0:0:12:1:1:::1:0:", -- Fandral's Message
	[5391]="0:0:12:1:1:::1:0:", -- Rare Earth
	[5392]="0:25:2:1:1:Dagger::1:0:", -- Thistlewood Dagger
	[5393]="0:32:2:1:1:Stave::1:0:", -- Thistlewood Staff
	[5394]="0:6:4:1:1:Leather::1:0:", -- Archery Training Gloves
	[5395]="0:16:4:1:1:Shield::1:0:", -- Woodland Shield
	[5396]="0:0:13:1:1:::1:0:", -- Key to Searing Gorge
	[5397]="0:0:15:1:1:Junk::1:0:", -- Defias Gunpowder
	[5398]="0:13:4:1:1:Leather::1:0:", -- Canopy Leggings
	[5399]="0:11:4:1:1:Mail::1:0:", -- Tracking Boots
	[5404]="0:938:4:3:1:Leather::1:0:", -- Serpent's Shoulders
	[5405]="0:7:4:1:1:Cloak::1:0:", -- Draped Cloak
	[5411]="0:0:4:1:1:Miscellaneous::1:0:", -- Winterhoof Cleansing Totem
	[5412]="0:0:12:1:20:::1:0:", -- Thresher Eye
	[5413]="0:0:12:1:20:::1:0:", -- Moonstalker Fang
	[5414]="0:0:12:1:20:::1:0:", -- Grizzled Scalp
	[5415]="0:0:12:1:1:::1:0:", -- Thunderhorn Cleansing Totem
	[5416]="0:0:12:1:1:::1:0:", -- Wildmane Cleansing Totem
	[5419]="0:13:4:1:1:Leather::1:0:", -- Feral Bracers
	[5420]="0:227:4:2:1:Cloth::1:0:", -- Banshee Armor
	[5421]="0:650:0:1:1:EnhPerm::1:0:", -- Fiery Blaze Enchantment
	[5422]="0:692:4:2:1:Leather::1:0:", -- Brambleweed Leggings
	[5423]="0:2084:2:3:1:TwoHandAxe::1:0:", -- Boahn's Fang
	[5424]="0:0:12:1:1:::1:0:", -- Ancient Statuette
	[5425]="0:504:4:3:1:Mail::1:0:", -- Runescale Girdle
	[5426]="0:1686:2:3:1:OneHandAxe::1:0:", -- Serpent's Kiss
	[5427]="0:147:15:0:5:Junk::1:0:", -- Crude Pocket Watch
	[5428]="0:322:15:0:5:Junk::1:0:", -- An Exotic Cookbook
	[5429]="0:137:15:0:5:Junk::1:0:", -- A Pretty Rock
	[5430]="0:277:15:0:5:Junk::1:0:", -- Intricate Bauble
	[5431]="0:155:15:0:5:Junk::1:0:", -- Empty Hip Flask
	[5432]="0:330:15:0:5:Junk::1:0:", -- Hickory Pipe
	[5433]="0:138:15:0:5:Junk::1:0:", -- Rag Doll
	[5435]="0:272:15:0:5:Junk::1:0:", -- Shiny Dinglehopper
	[5437]="0:0:12:1:20:::1:0:", -- Bathran's Hair
	[5439]="100:25:11:1:1:Quiver::1:0:228,789,1198,1297,1298,1459,1462,1668,1687,2839,3015,3165,3409,3410,3488,3589,3610,3951,4173,4203,4604,4892,5122,6028,9548,9549,9551,9552,9553,9555,10369,12029,14301,16263,16274,16619,16715,16919,17598,17667,19020,19561,27055", -- Small Quiver
	[5440]="0:0:12:1:1:::1:0:", -- Bottle of Disease
	[5441]="1000:250:11:1:1:AmmoPouch::1:0:1243,1297,1469,1686,2997,3018,3078,3088,3322,3488,4603,5123,5510,7976,9551,16274,16620,16735", -- Small Shot Pouch
	[5442]="0:0:12:1:1:::1:0:", -- Head of Arugal
	[5443]="0:1067:4:3:1:Shield::1:0:", -- Gold-plated Buckler
	[5444]="0:436:4:3:1:Cloak::1:0:", -- Miner's Cape
	[5445]="0:0:12:1:1:::1:0:", -- Ring of Zoram
	[5446]="0:13:15:0:20:Junk::1:0:", -- Broken Elemental Bracer
	[5447]="0:20:15:0:20:Junk::1:0:", -- Damaged Elemental Bracer
	[5448]="0:17:15:0:20:Junk::1:0:", -- Fractured Elemental Bracer
	[5451]="0:22:15:0:20:Junk::1:0:", -- Crushed Elemental Bracer
	[5455]="0:0:12:1:1:::1:0:", -- Divined Scroll
	[5456]="0:0:12:1:1:::1:0:", -- Divining Scroll
	[5457]="0:23:0:1:10:Consumable::1:0:", -- Severed Voodoo Claw
	[5458]="0:27:4:1:1:Cloth::1:0:", -- Dirtwood Belt
	[5459]="0:472:2:2:1:OneHandAxe::1:0:", -- Defender Axe
	[5460]="0:0:12:1:1:::1:0:", -- Orendil's Cure
	[5461]="0:0:12:1:1:::1:0:", -- Branch of Cenarius
	[5462]="0:0:12:1:1:::1:0:", -- Dartol's Rod of Transformation
	[5463]="0:0:12:1:1:::1:0:", -- Glowing Gem
	[5464]="0:0:12:1:1:::1:0:", -- Iron Shaft
	[5465]="0:3:7:1:10:Meat:185:1:0:", -- Small Spider Leg
	[5466]="0:8:7:1:10:Meat:185:1:0:", -- Scorpid Stinger
	[5467]="0:7:7:1:10:Meat:185:1:0:", -- Kodo Meat
	[5468]="0:12:7:1:10:Meat:185:1:0:", -- Soft Frenzy Flesh
	[5469]="0:9:7:1:10:Meat:185:1:0:", -- Strider Meat
	[5470]="0:28:7:1:10:Meat:185:1:0:", -- Thunder Lizard Tail
	[5471]="0:30:7:1:10:Meat:185:1:0:", -- Stag Meat
	[5472]="0:10:0:1:20:FoodDrink::1:0:", -- Kaldorei Spider Kabob
	[5473]="0:10:0:1:20:FoodDrink::1:0:", -- Scorpid Surprise
	[5474]="0:9:0:1:20:FoodDrink::1:0:", -- Roasted Kodo Meat
	[5475]="0:0:13:1:1:::1:0:", -- Wooden Key
	[5476]="0:3:0:1:20:FoodDrink::1:0:", -- Fillet of Frenzy
	[5477]="0:18:0:1:20:FoodDrink::1:0:", -- Strider Stew
	[5478]="0:70:0:1:20:FoodDrink::1:0:", -- Dig Rat Stew
	[5479]="0:125:0:1:20:FoodDrink::1:0:", -- Crispy Lizard Tail
	[5480]="0:95:0:1:20:FoodDrink::1:0:", -- Lean Venison
	[5481]="0:0:12:1:20:::1:0:", -- Satyr Horns
	[5482]="0:10:9:1:1:Cooking::1:0:", -- Recipe: Kaldorei Spider Kabob
	[5483]="140:35:9:1:1:Cooking::1:0:3881", -- Recipe: Scorpid Surprise
	[5484]="240:60:9:1:1:Cooking::1:0:3081", -- Recipe: Roasted Kodo Meat
	[5485]="400:100:9:1:1:Cooking::1:0:4200", -- Recipe: Fillet of Frenzy
	[5486]="440:110:9:1:1:Cooking::1:0:3482", -- Recipe: Strider Stew
	[5487]="0:200:9:1:1:Cooking::1:0:", -- Recipe: Dig Rat Stew
	[5488]="400:100:9:1:1:Cooking::1:0:3482", -- Recipe: Crispy Lizard Tail
	[5489]="1200:300:9:1:1:Cooking::1:0:3960,12245", -- Recipe: Lean Venison
	[5490]="0:0:12:1:20:::1:0:", -- Wrathtail Head
	[5493]="0:0:12:1:1:::1:0:", -- Elune's Tear
	[5494]="0:0:12:1:20:::1:0:", -- Handful of Stardust
	[5498]="0:200:3:2:20:GemSimple:164,755,165,197:1:0:", -- Small Lustrous Pearl
	[5500]="0:750:3:2:20:GemSimple:164,333,165,197:1:0:", -- Iridescent Pearl
	[5503]="0:16:7:1:10:Meat:185:1:0:", -- Clam Meat
	[5504]="0:22:7:1:10:Meat:185:1:0:", -- Tangy Clam Meat
	[5505]="0:0:12:1:1:::1:0:", -- Teronis' Journal
	[5506]="0:71:15:0:5:Junk::1:0:", -- Beady Eye Stalk
	[5507]="0:600:7:1:1:Device::1:0:", -- Ornate Spyglass
	[5508]="0:0:12:1:1:::1:0:", -- Fallen Moonstone
	[5509]="0:0:0:1:1:Other::1:0:", -- Healthstone
	[5510]="0:0:0:1:1:Other::1:0:", -- Greater Healthstone
	[5511]="0:0:0:1:1:Other::1:0:", -- Lesser Healthstone
	[5512]="0:0:0:1:1:Other::1:0:", -- Minor Healthstone
	[5513]="0:0:0:1:1:Consumable::1:0:", -- Mana Jade
	[5514]="0:0:4:1:1:Miscellaneous::1:0:", -- Mana Agate
	[5516]="0:317:2:0:1:Dagger::1:0:", -- Threshadon Fang
	[5517]="0:50:15:1:10:Reagent::1:0:", -- Tiny Bronze Key
	[5518]="0:150:15:1:10:Reagent::1:0:", -- Tiny Iron Key
	[5519]="0:0:12:1:1:::1:0:", -- Iron Pommel
	[5520]="0:0:12:1:1:::1:0:", -- Velinde's Journal
	[5521]="0:0:13:1:1:::1:0:", -- Velinde's Key
	[5523]="0:15:7:1:20:Other::1:0:", -- Small Barnacled Clam
	[5524]="0:21:7:1:20:Other::1:0:", -- Thick-shelled Clam
	[5525]="0:20:0:1:20:FoodDrink::1:0:", -- Boiled Clams
	[5526]="0:75:0:1:20:FoodDrink::1:0:", -- Clam Chowder
	[5527]="0:95:0:1:20:FoodDrink::1:0:", -- Goblin Deviled Clams
	[5528]="800:200:9:1:1:Cooking::1:0:4305,4307", -- Recipe: Clam Chowder
	[5529]="0:125:15:0:20:Junk::1:0:", -- Tomb Dust
	[5533]="0:0:12:1:1:::1:0:", -- Ilkrud Magthrull's Tome
	[5534]="0:0:12:1:1:::1:0:", -- Parker's Lunch
	[5535]="0:0:12:1:1:::1:0:", -- Compendium of the Fallen
	[5536]="0:0:12:1:1:::1:0:", -- Mythology of the Titans
	[5537]="0:0:12:1:1:::1:0:", -- Sarilus Foulborne's Head
	[5538]="0:0:12:1:1:::1:0:", -- Vorrel's Wedding Ring
	[5539]="0:0:12:1:1:::1:0:", -- Letter of Commendation
	[5540]="0:2107:2:2:1:Dagger::1:0:", -- Pearl-handled Dagger
	[5541]="0:3694:2:2:1:OneHandMace::1:0:", -- Iridescent Hammer
	[5542]="0:370:4:2:1:Cloak::1:0:", -- Pearl-clasped Cloak
	[5543]="0:450:9:2:1:Blacksmithing::1:0:", -- Plans: Iridescent Hammer
	[5544]="0:0:12:1:1:::1:0:", -- Dal Bloodclaw's Skull
	[5547]="0:0:12:1:1:::1:0:", -- Reconstructed Rod
	[5565]="5000:1250:15:1:5:Reagent:-9:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Infernal Stone
	[5566]="0:105:15:0:5:Junk::1:0:", -- Broken Antler
	[5567]="0:196:15:0:5:Junk::1:0:", -- Silver Hook
	[5568]="0:4:6:1:1000:Bullet::1:0:", -- Smooth Pebble
	[5569]="0:203:15:0:5:Junk::1:0:", -- Seaweed
	[5570]="0:0:12:1:20:::1:0:", -- Deepmoss Egg
	[5571]="0:250:1:1:1:Bag::1:0:", -- Small Black Pouch
	[5572]="0:250:1:1:1:Bag::1:0:", -- Small Green Pouch
	[5573]="0:875:1:1:1:Bag::1:0:", -- Green Leather Bag
	[5574]="0:875:1:1:1:Bag::1:0:", -- White Leather Bag
	[5575]="0:2500:1:1:1:Bag::1:0:", -- Large Green Sack
	[5576]="0:2500:1:1:1:Bag::1:0:", -- Large Brown Sack
	[5578]="0:300:9:2:1:Blacksmithing::1:0:", -- Plans: Silvered Bronze Breastplate
	[5579]="0:32:2:1:1:TwoHandMace::1:0:", -- Militia Warhammer
	[5580]="0:25:2:1:1:OneHandMace::1:0:", -- Militia Hammer
	[5581]="0:32:2:1:1:Stave::1:0:", -- Smooth Walking Staff
	[5582]="0:0:12:1:20:::1:0:", -- Stonetalon Sap
	[5583]="0:0:12:1:20:::1:0:", -- Fey Dragon Scale
	[5584]="0:0:12:1:20:::1:0:", -- Twilight Whisker
	[5585]="0:0:12:1:20:::1:0:", -- Courser Eye
	[5586]="0:26:2:1:1:OneHandSword::1:0:", -- Thistlewood Blade
	[5587]="0:512:2:2:1:OneHandMace::1:0:", -- Thornroot Club
	[5588]="0:0:12:1:1:::1:0:", -- Lydon's Toxin
	[5589]="0:41:4:1:1:Mail::1:0:", -- Moss-covered Gauntlets
	[5590]="0:36:4:1:1:Cloth::1:0:", -- Cord Bracers
	[5591]="0:54:4:1:1:Cloak::1:0:", -- Rain-spotted Cape
	[5592]="0:54:4:1:1:Mail::1:0:", -- Shackled Girdle
	[5593]="0:116:4:1:1:Shield::1:0:", -- Crag Buckler
	[5594]="0:0:12:1:1:::1:0:", -- Letter to Jin'Zil
	[5595]="0:235:2:1:1:TwoHandMace::1:0:", -- Thicket Hammer
	[5596]="0:141:2:1:1:Bow::1:0:", -- Ashwood Bow
	[5601]="0:22:15:0:10:Junk::1:0:", -- Hatched Egg Sac
	[5602]="0:63:15:0:10:Junk::1:0:", -- Sticky Spider Webbing
	[5604]="0:380:2:2:1:Wand::1:0:", -- Elven Wand
	[5605]="0:150:2:1:1:Dagger::1:0:", -- Pruning Knife
	[5606]="0:23:4:1:1:Cloth::1:0:", -- Gardening Gloves
	[5608]="0:3463:4:2:1:Cloth::1:0:", -- Living Cowl
	[5609]="0:447:4:2:1:Leather::1:0:", -- Steadfast Cinch
	[5610]="0:208:4:2:1:Cloak::1:0:", -- Gustweald Cloak
	[5611]="0:452:4:2:1:OffHandFrill::1:0:", -- Tear of Grief
	[5612]="0:72:4:1:1:Leather::1:0:", -- Ivy Cuffs
	[5613]="0:2635:2:2:1:Stave::1:0:", -- Staff of the Purifier
	[5614]="0:6147:2:2:1:TwoHandSword::1:0:", -- Seraph's Strike
	[5615]="0:1776:2:2:1:TwoHandSword::1:0:", -- Woodsman Sword
	[5616]="0:22738:2:3:1:Dagger::1:0:", -- Gutwrencher
	[5617]="0:247:4:2:1:Leather::1:0:", -- Vagabond Leggings
	[5618]="0:57:4:1:1:Cloak::1:0:", -- Scout's Cloak
	[5619]="0:0:12:1:1:::1:0:", -- Jade Phial
	[5620]="0:0:12:1:20:::1:0:", -- Vial of Innocent Blood
	[5621]="0:0:12:1:1:::1:0:", -- Tourmaline Phial
	[5622]="0:556:4:2:1:Ring::1:0:", -- Clergy Ring
	[5623]="0:0:12:1:1:::1:0:", -- Amethyst Phial
	[5624]="0:2927:4:2:1:Cloth::1:0:", -- Circlet of the Order
	[5626]="0:1717:2:2:1:TwoHandAxe::1:0:", -- Skullchipper
	[5627]="0:1379:2:2:1:Dagger::1:0:", -- Relic Blade
	[5628]="0:0:12:1:1:::1:0:", -- Zamah's Note
	[5629]="0:347:4:2:1:Leather::1:0:", -- Hammerfist Gloves
	[5630]="0:348:4:2:1:Leather::1:0:", -- Windfelt Gloves
	[5631]="0:30:0:1:5:Potion::1:0:", -- Rage Potion
	[5632]="0:85:0:1:5:Potion::1:0:", -- Cowardly Flight Potion
	[5633]="0:150:0:1:5:Potion:165:1:0:", -- Great Rage Potion
	[5634]="0:75:0:1:5:Potion::1:0:", -- Free Action Potion
	[5635]="0:45:7:1:5:Other:171,164:1:0:", -- Sharp Claw
	[5636]="0:75:15:0:10:Junk::1:0:", -- Delicate Feather
	[5637]="0:75:7:1:5:Other:171,164,333,755,165:1:0:", -- Large Fang
	[5638]="0:0:12:1:1:::1:0:", -- Toxic Fogger
	[5639]="0:0:12:1:1:::1:0:", -- Filled Jade Phial
	[5640]="100:25:9:1:1:Alchemy::1:1:1669,1685,3335,3499", -- Recipe: Rage Potion
	[5642]="1800:450:9:1:1:Alchemy::1:1:3348,4226,5178", -- Recipe: Free Action Potion
	[5643]="2000:500:9:1:1:Alchemy::1:1:3335,4226", -- Recipe: Great Rage Potion
	[5645]="0:0:12:1:1:::1:0:", -- Filled Tourmaline Phial
	[5646]="0:0:12:1:1:::1:0:", -- Vial of Blessed Water
	[5655]="100000:0:15:3:1:Mount::1:0:384,1460,2357,4885", -- Chestnut Mare Bridle
	[5656]="100000:0:15:3:1:Mount::1:0:384,1460,2357,4885", -- Brown Horse Bridle
	[5659]="0:0:12:1:20:::1:0:", -- Smoldering Embers
	[5664]="0:0:12:1:20:::1:0:", -- Corroded Shrapnel
	[5665]="100000:0:15:3:1:Mount::1:0:3362", -- Horn of the Dire Wolf
	[5668]="100000:0:15:3:1:Mount::1:0:3362", -- Horn of the Brown Wolf
	[5669]="0:0:12:1:1:::1:0:", -- Dust Devil Debris
	[5675]="0:0:12:1:20:::1:0:", -- Crystalized Scales
	[5681]="0:0:12:1:1:::1:0:", -- Corrosive Sap
	[5686]="0:0:12:1:1:::1:0:", -- Ordanus' Head
	[5687]="0:0:13:1:1:::1:0:", -- Gatekeeper's Key
	[5689]="0:0:13:1:1:::1:0:", -- Sleepers' Key
	[5690]="0:0:13:1:1:::1:0:", -- Claw Key
	[5691]="0:0:13:1:1:::1:0:", -- Barrow Key
	[5692]="0:0:12:1:1:::1:0:", -- Remote Detonator (Red)
	[5693]="0:0:12:1:1:::1:0:", -- Remote Detonator (Blue)
	[5694]="0:0:12:1:1:::1:0:", -- NG-5 Explosives (Red)
	[5695]="0:0:12:1:1:::1:0:", -- NG-5 Explosives (Blue)
	[5717]="0:0:12:1:1:::1:0:", -- Venture Co. Letters
	[5718]="0:0:12:1:1:::1:0:", -- Venture Co. Engineering Plans
	[5731]="0:0:12:1:1:::1:0:", -- Scroll of Messaging
	[5732]="0:0:12:1:1:::1:0:", -- NG-5
	[5733]="0:0:12:1:1:::1:0:", -- Unidentified Ore
	[5734]="0:0:12:1:1:::1:0:", -- Super Reaper 6000 Blueprints
	[5735]="0:0:12:1:1:::1:0:", -- Sealed Envelope
	[5736]="0:0:12:1:1:::1:0:", -- Gerenzo's Mechanical Arm
	[5737]="0:0:12:1:1:::1:0:", -- Covert Ops Plans: Alpha & Beta
	[5738]="0:0:15:1:1:Junk::1:0:", -- Covert Ops Pack
	[5739]="0:4565:4:2:1:Leather::1:0:", -- Barbaric Harness
	[5740]="100:25:0:1:5:Other::1:0:1304,2838,3180,5569,8116,8117,8118,8122,16650,23208", -- Red Fireworks Rocket
	[5741]="0:111:15:0:20:Junk::1:0:", -- Rock Chip
	[5742]="0:10770:2:2:1:Dagger::1:0:", -- Gemstone Dagger
	[5743]="0:1803:4:2:1:Ring::1:0:", -- Prismstone Ring
	[5744]="0:386:2:2:1:OneHandSword::1:0:", -- Pale Skinner
	[5749]="0:2664:2:2:1:TwoHandAxe::1:0:", -- Scythe Axe
	[5750]="0:641:4:2:1:Mail::1:0:", -- Warchief's Girdle
	[5751]="0:822:4:2:1:Cloak::1:0:", -- Webwing Cloak
	[5752]="0:3109:2:2:1:Dagger::1:0:", -- Wyvern Tailspike
	[5753]="0:1884:4:2:1:Leather::1:0:", -- Ruffled Chaplet
	[5754]="0:2538:4:2:1:Amulet::1:0:", -- Wolfpack Medallion
	[5755]="0:4127:4:2:1:Mail::1:0:", -- Onyx Shredder Plate
	[5756]="0:10026:2:3:1:Dagger::1:0:", -- Sliverblade
	[5757]="0:1363:2:2:1:OneHandMace::1:0:", -- Hardwood Cudgel
	[5758]="0:250:15:2:1:Junk::1:0:", -- Mithril Lockbox
	[5759]="0:375:15:2:1:Junk::1:0:", -- Thorium Lockbox
	[5760]="0:500:15:2:1:Junk::1:0:", -- Eternium Lockbox
	[5761]="0:30:2:1:1:TwoHandMace::1:0:", -- Anvilmar Sledge
	[5762]="0:250:1:1:1:Bag::1:0:", -- Red Linen Bag
	[5763]="0:700:1:1:1:Bag::1:0:", -- Red Woolen Bag
	[5764]="0:3000:1:1:1:Bag::1:0:", -- Green Silk Pack
	[5765]="0:4000:1:1:1:Bag::1:0:", -- Black Silk Pack
	[5766]="0:1338:4:2:1:Cloth::1:0:", -- Lesser Wizard's Robe
	[5767]="0:44:4:1:1:Cloth::1:0:", -- Violet Robes
	[5770]="0:1807:4:2:1:Cloth::1:0:", -- Robes of Arcana
	[5771]="200:50:9:1:1:Tailoring::1:1:843,3005,3556,16224", -- Pattern: Red Linen Bag
	[5772]="500:125:9:1:1:Tailoring::1:1:777,1454,1474,3005,3364,3485,3537,3683,4189,4577,5944", -- Pattern: Red Woolen Bag
	[5773]="0:250:9:2:1:Tailoring::1:0:", -- Pattern: Robes of Arcana
	[5774]="0:275:9:2:1:Tailoring::1:0:", -- Pattern: Green Silk Pack
	[5775]="0:350:9:2:1:Tailoring::1:0:", -- Pattern: Black Silk Pack
	[5776]="0:30:2:1:1:Stave::1:0:", -- Elder's Cane
	[5777]="0:30:2:1:1:TwoHandAxe::1:0:", -- Brave's Axe
	[5778]="0:30:2:1:1:Stave::1:0:", -- Primitive Walking Stick
	[5779]="0:30:2:1:1:TwoHandSword::1:0:", -- Forsaken Bastard Sword
	[5780]="0:260:4:2:1:Leather::1:0:", -- Murloc Scale Belt
	[5781]="0:601:4:2:1:Leather::1:0:", -- Murloc Scale Breastplate
	[5782]="0:3211:4:2:1:Leather::1:0:", -- Thick Murloc Armor
	[5783]="0:2316:4:2:1:Leather::1:0:", -- Murloc Scale Bracers
	[5784]="0:75:7:1:10:Leather:165:1:0:", -- Slimy Murloc Scale
	[5785]="0:500:7:1:10:Leather:165:1:0:", -- Thick Murloc Scale
	[5786]="550:137:9:1:1:Leatherworking::1:1:843,3556,4186", -- Pattern: Murloc Scale Belt
	[5787]="600:150:9:1:1:Leatherworking::1:1:843,3556,4186", -- Pattern: Murloc Scale Breastplate
	[5788]="650:162:9:2:1:Leatherworking::1:1:2381,2393,2846", -- Pattern: Thick Murloc Armor
	[5789]="2800:700:9:2:1:Leatherworking::1:1:2846,4897", -- Pattern: Murloc Scale Bracers
	[5790]="0:0:12:1:1:::1:0:", -- Lonebrow's Journal
	[5791]="0:0:12:1:1:::1:0:", -- Henrig Lonebrow's Journal
	[5792]="0:0:12:1:1:::1:0:", -- Razorflank's Medallion
	[5793]="0:0:12:1:1:::1:0:", -- Razorflank's Heart
	[5794]="0:0:12:1:20:::1:0:", -- Salty Scorpid Venom
	[5795]="0:0:12:1:20:::1:0:", -- Hardened Tortoise Shell
	[5796]="0:0:12:1:20:::1:0:", -- Encrusted Tail Fin
	[5797]="0:0:12:1:20:::1:0:", -- Indurium Flake
	[5798]="0:0:12:1:30:::1:0:", -- Rocket Car Parts
	[5799]="0:0:12:1:1:::1:0:", -- Kravel's Parts Order
	[5800]="0:0:12:1:1:::1:0:", -- Kravel's Parts
	[5801]="0:0:12:1:20:::1:0:", -- Kraul Guano
	[5802]="0:0:12:1:1:::1:0:", -- Delicate Car Parts
	[5803]="0:0:12:1:20:::1:0:", -- Speck of Dream Dust
	[5804]="0:0:12:1:1:::1:0:", -- Goblin Rumors
	[5805]="0:0:12:1:20:::1:0:", -- Heart of Zeal
	[5806]="0:0:12:1:1:::1:0:", -- Fool's Stout
	[5807]="0:0:12:1:1:::1:0:", -- Fool's Stout Report
	[5808]="0:0:12:1:20:::1:0:", -- Pridewing Venom Sac
	[5809]="0:0:12:1:20:::1:0:", -- Highperch Venom Sac
	[5810]="0:0:12:1:1:::1:0:", -- Fresh Carcass
	[5811]="0:0:12:1:1:::1:0:", -- Frostmaw's Mane
	[5812]="0:1129:4:2:1:Cloth::1:0:", -- Robes of Antiquity
	[5813]="0:7088:2:2:1:TwoHandSword::1:0:", -- Emil's Brand
	[5814]="0:2351:4:2:1:Leather::1:0:", -- Snapbrook Armor
	[5815]="0:5871:2:2:1:TwoHandMace::1:0:", -- Glacial Stone
	[5816]="0:405:0:1:1:Potion::1:0:", -- Light of Elune
	[5817]="0:3226:2:2:1:Bow::1:0:", -- Lunaris Bow
	[5818]="0:3239:2:2:1:Wand::1:0:", -- Moonbeam Wand
	[5819]="0:3201:4:3:1:Mail::1:0:", -- Sunblaze Coif
	[5820]="0:1623:4:2:1:Cloth::1:0:", -- Faerie Mantle
	[5824]="0:0:12:1:1:::1:0:", -- Tablet of Will
	[5825]="0:0:12:1:1:::1:0:", -- Treshala's Pendant
	[5826]="0:0:12:1:1:::1:0:", -- Kravel's Scheme
	[5827]="0:0:12:1:1:::1:0:", -- Fizzle Brassbolts' Letter
	[5829]="0:804:15:0:5:Junk::1:0:", -- Razor-sharp Beak
	[5830]="0:0:12:1:1:::1:0:", -- Kenata's Head
	[5831]="0:0:12:1:1:::1:0:", -- Fardel's Head
	[5832]="0:0:12:1:1:::1:0:", -- Marcel's Head
	[5833]="0:0:12:1:20:::1:0:", -- Indurium Ore
	[5834]="0:0:12:1:1:::1:0:", -- Mok'Morokk's Snuff
	[5835]="0:0:12:1:1:::1:0:", -- Mok'Morokk's Grog
	[5836]="0:0:12:1:1:::1:0:", -- Mok'Morokk's Strongbox
	[5837]="0:0:12:1:1:::1:0:", -- Steelsnap's Rib
	[5838]="0:0:12:1:1:::1:0:", -- Kodo Skin Scroll
	[5839]="0:1:15:0:1:Junk::1:0:", -- Journal Page
	[5840]="0:0:12:1:20:::1:0:", -- Searing Tongue
	[5841]="0:0:12:1:20:::1:0:", -- Searing Heart
	[5842]="0:0:12:1:1:::1:0:", -- Unrefined Ore Sample
	[5843]="0:0:12:1:1:::1:0:", -- Grenka's Claw
	[5844]="0:0:12:1:1:::1:0:", -- Fragments of Rok'Alim
	[5846]="0:0:12:1:1:::1:0:", -- Korran's Sealed Note
	[5847]="0:0:12:1:20:::1:0:", -- Mirefin Head
	[5848]="0:0:12:1:20:::1:0:", -- Hollow Vulture Bone
	[5849]="0:0:12:1:1:::1:0:", -- Crate of Crash Helmets
	[5850]="0:0:12:1:1:::1:0:", -- Belgrom's Sealed Note
	[5851]="0:0:13:1:1:::1:0:", -- Cozzle's Key
	[5852]="0:0:12:1:1:::1:0:", -- Fuel Regulator Blueprints
	[5853]="0:0:12:1:20:::1:0:", -- Intact Silithid Carapace
	[5854]="0:0:12:1:20:::1:0:", -- Silithid Talon
	[5855]="0:0:12:1:20:::1:0:", -- Silithid Heart
	[5860]="0:0:12:1:1:::1:0:", -- Legacy of the Aspects
	[5861]="0:0:12:1:1:::1:0:", -- Beginnings of the Undead Threat
	[5862]="0:0:12:1:1:::1:0:", -- Seaforium Booster
	[5863]="0:0:15:1:1:Junk::1:0:", -- Guild Charter
	[5864]="100000:0:15:3:1:Mount::1:0:1261", -- Gray Ram
	[5865]="0:0:12:1:1:::1:0:", -- Modified Seaforium Booster
	[5866]="0:0:12:1:1:::1:0:", -- Sample of Indurium Ore
	[5867]="0:0:12:1:1:::1:0:", -- Etched Phial
	[5868]="0:0:12:1:1:::1:0:", -- Filled Etched Phial
	[5869]="0:0:12:1:1:::1:0:", -- Cloven Hoof
	[5871]="0:318:15:0:5:Junk::1:0:", -- Large Hoof
	[5872]="100000:0:15:3:1:Mount::1:0:1261", -- Brown Ram
	[5873]="100000:0:15:3:1:Mount::1:0:1261", -- White Ram
	[5876]="0:0:12:1:20:::1:0:", -- Blueleaf Tuber
	[5877]="0:0:12:1:1:::1:0:", -- Cracked Silithid Carapace
	[5879]="0:0:12:1:20:::1:0:", -- Twilight Pendant
	[5880]="0:0:0:1:1:Consumable::1:0:", -- Crate With Holes
	[5881]="0:0:12:1:1:::1:0:", -- Head of Kelris
	[5882]="0:0:12:1:1:::1:0:", -- Captain's Documents
	[5883]="0:0:12:1:20:::1:0:", -- Forked Mudrock Tongue
	[5884]="0:0:12:1:20:::1:0:", -- Unpopped Darkmist Eye
	[5897]="0:0:12:1:1:::1:0:", -- Snufflenose Owner's Manual
	[5917]="0:0:12:1:1:::1:0:", -- Spy's Report
	[5918]="0:0:12:1:1:::1:0:", -- Defiant Orc Head
	[5919]="0:0:12:1:1:::1:0:", -- Blackened Iron Shield
	[5936]="0:20:4:1:1:Leather::1:0:", -- Animal Skin Belt
	[5938]="0:0:12:1:20:::1:0:", -- Pristine Crawler Leg
	[5939]="0:20:4:1:1:Leather::1:0:", -- Sewing Gloves
	[5940]="0:154:4:1:1:Shield::1:0:", -- Bone Buckler
	[5941]="0:115:4:1:1:Mail::1:0:", -- Brass Scale Pants
	[5942]="0:0:12:1:1:::1:0:", -- Jeweled Pendant
	[5943]="0:1008:4:3:1:Mail::1:0:", -- Rift Bracers
	[5944]="0:331:4:2:1:Mail::1:0:", -- Greaves of the People's Militia
	[5945]="0:0:12:1:1:::1:0:", -- Deadmire's Tooth
	[5946]="0:0:12:1:1:::1:0:", -- Sealed Note to Elling
	[5947]="0:0:12:1:1:::1:0:", -- Defias Docket
	[5948]="0:0:12:1:1:::1:0:", -- Letter to Jorgen
	[5950]="0:0:12:1:1:::1:0:", -- Reethe's Badge
	[5951]="0:41:0:1:10:Consumable::1:0:", -- Moist Towelette
	[5952]="0:0:12:1:20:::1:0:", -- Corrupted Brain Stem
	[5956]="18:3:2:1:1:Miscellaneous:202:1:0:66,777,790,843,960,989,1148,1250,1286,1448,1456,1465,1690,1692,1694,2118,2225,2381,2393,2682,2683,2684,2685,2687,2688,2810,2821,2844,2847,2999,3081,3133,3168,3187,3343,3356,3367,3413,3477,3482,3495,3499,3556,3614,3779,3954,3955,4194,4229,4257,4259,4453,4561,4587,4597,4775,4877,4897,5100,5135,5163,5175,5411,5512,5519,5817,6300,6301,6730,6777,7947,8145,8161,8176,8363,8678,8679,8934,9179,9544,9636,9676,11185,11189,12022,12028,12043,12245,12941,12957,12958,14337,14624,14637,14737,15176,15179,15400,16224,16261,16262,16376,16583,16613,16657,16670,16713,16768,16782,16823,17222,17245,17421,17486,17490,17655,18009,18278,18426,18427,18484,18752,18775,19011,19012,19056,19244,19342,19372,19383,19450,19520,19530,19575,19661,19662,19879,20082,20463,20890,21112,22264,22476,23144,23724,23908,24052,24843,24935,24995,25010,25019,25051,25082,26081,26599,26600,26898,26934,27019,27021,27026,27043,27045,27057,27062,27134,27267,27711,28344,28692,28716,28722,28796,28797,28831,28872,29252,29253,29288,29907,29923,29964,29969,30241,30253,30311,30336,30345,30434,30436,30825,31024,31776,31781,32594,33594,33599,33669", -- Blacksmith Hammer
	[5957]="0:40:4:1:1:Leather::1:0:", -- Handstitched Leather Vest
	[5958]="0:829:4:2:1:Leather::1:0:", -- Fine Leather Pants
	[5959]="0:0:12:1:20:::1:0:", -- Acidic Venom Sac
	[5960]="0:0:12:1:1:::1:0:", -- Sealed Note to Watcher Backus
	[5961]="0:1089:4:2:1:Leather::1:0:", -- Dark Leather Pants
	[5962]="0:2794:4:2:1:Leather::1:0:", -- Guardian Pants
	[5963]="0:3151:4:2:1:Leather::1:0:", -- Barbaric Leggings
	[5964]="0:2609:4:2:1:Leather::1:0:", -- Barbaric Shoulders
	[5965]="0:2536:4:2:1:Cloak::1:0:", -- Guardian Cloak
	[5966]="0:1374:4:1:1:Leather:164:1:0:", -- Guardian Gloves
	[5967]="0:209:4:2:1:Cloth::1:0:", -- Girdle of Nobility
	[5969]="0:625:4:2:1:Cloak::1:0:", -- Regent's Cloak
	[5970]="0:502:4:3:1:Cloth::1:0:", -- Serpent Gloves
	[5971]="0:909:4:2:1:Cloak::1:0:", -- Feathered Cape
	[5972]="0:375:9:2:1:Leatherworking::1:0:", -- Pattern: Fine Leather Pants
	[5973]="650:162:9:1:1:Leatherworking::1:1:2810,2821,3958,4877", -- Pattern: Barbaric Leggings
	[5974]="0:350:9:2:1:Leatherworking::1:0:", -- Pattern: Guardian Cloak
	[5975]="0:532:4:2:1:Leather::1:0:", -- Ruffian Belt
	[5976]="10000:2500:4:1:1:Tabard::1:0:5049,5188,5189,5190,5191,5193,16610,16766,28776", -- Guild Tabard
	[5996]="0:95:0:1:20:Elixir::1:0:", -- Elixir of Water Breathing
	[5997]="0:5:0:1:20:Elixir::1:0:", -- Elixir of Minor Defense
	[5998]="0:0:12:1:1:::1:0:", -- Stormpike's Request
	[6016]="0:0:12:1:1:::1:0:", -- Wolf Heart Sample
	[6037]="0:1250:7:2:20:MetalStone:164,333,202,755,197:1:0:", -- Truesilver Bar
	[6038]="0:312:0:1:20:FoodDrink::1:0:", -- Giant Clam Scorcho
	[6039]="5000:1250:9:1:1:Cooking::1:0:2664", -- Recipe: Giant Clam Scorcho
	[6040]="0:2749:4:2:1:Mail::1:0:", -- Golden Scale Bracers
	[6041]="0:1500:0:1:5:EnhPerm::1:0:", -- Steel Weapon Chain
	[6042]="0:250:0:1:5:EnhPerm::1:0:", -- Iron Shield Spike
	[6043]="0:500:0:1:5:EnhPerm::1:0:", -- Iron Counterweight
	[6044]="0:450:9:2:1:Blacksmithing::1:0:", -- Plans: Iron Shield Spike
	[6045]="0:650:9:2:1:Blacksmithing::1:0:", -- Plans: Iron Counterweight
	[6046]="0:950:9:2:1:Blacksmithing::1:0:", -- Plans: Steel Weapon Chain
	[6047]="4400:1100:9:1:1:Blacksmithing::1:1:5411", -- Plans: Golden Scale Coif
	[6048]="0:100:0:1:5:Potion:333,197:1:0:", -- Shadow Protection Potion
	[6049]="0:170:0:1:5:Potion::1:0:", -- Fire Protection Potion
	[6050]="0:300:0:1:5:Potion::1:0:", -- Frost Protection Potion
	[6051]="0:62:0:1:5:Potion::1:0:", -- Holy Protection Potion
	[6052]="0:300:0:1:5:Potion::1:0:", -- Nature Protection Potion
	[6053]="800:200:9:1:1:Alchemy::1:1:1685,3134,3490", -- Recipe: Holy Protection Potion
	[6054]="900:225:9:1:1:Alchemy::1:1:2393", -- Recipe: Shadow Protection Potion
	[6055]="1500:375:9:1:1:Alchemy::1:1:2380,4083", -- Recipe: Fire Protection Potion
	[6056]="2000:500:9:1:1:Alchemy::1:1:2812,2848", -- Recipe: Frost Protection Potion
	[6057]="2000:500:9:1:1:Alchemy::1:1:2848,5594,8157,8158", -- Recipe: Nature Protection Potion
	[6058]="0:6:4:1:1:Leather::1:0:", -- Blackened Leather Belt
	[6059]="0:13:4:1:1:Leather::1:0:", -- Nomadic Vest
	[6060]="0:4:4:1:1:Cloth::1:0:", -- Flax Bracers
	[6061]="0:23:4:1:1:Mail::1:0:", -- Graystone Bracers
	[6062]="0:28:4:1:1:Cloth::1:0:", -- Heavy Cord Bracers
	[6063]="0:23:4:1:1:Mail::1:0:", -- Cold Steel Gauntlets
	[6064]="0:0:12:1:1:::1:0:", -- Miniature Platinum Discs
	[6065]="0:0:12:1:1:::1:0:", -- Khadgar's Essays on Dimensional Convergence
	[6066]="0:0:12:1:1:::1:0:", -- Khan Dez'hepah's Head
	[6067]="0:0:12:1:20:::1:0:", -- Centaur Ear
	[6068]="1500:375:9:1:1:Alchemy::1:1:2481,4878", -- Recipe: Shadow Oil
	[6069]="0:0:12:1:20:::1:0:", -- Crudely Dried Meat
	[6070]="0:6:4:1:1:Leather::1:0:", -- Wolfskin Bracers
	[6071]="0:0:12:1:20:::1:0:", -- Draenethyst Crystal
	[6072]="0:0:12:1:1:::1:0:", -- Khan Jehn's Head
	[6073]="0:0:12:1:1:::1:0:", -- Khan Shaka's Head
	[6074]="0:0:0:1:1:Consumable::1:0:", -- War Horn Mouthpiece
	[6076]="0:9:4:1:1:Cloth::1:0:", -- Tapered Pants
	[6077]="0:0:12:1:1:::1:0:", -- Maraudine Key Fragment
	[6078]="0:15:4:1:1:Shield::1:0:", -- Pikeman Shield
	[6079]="0:0:12:1:20:::1:0:", -- Crude Charm
	[6080]="0:0:12:1:20:::1:0:", -- Shadow Panther Heart
	[6081]="0:0:12:1:1:::1:0:", -- Mire Lord Fungus
	[6082]="0:0:12:1:1:::1:0:", -- Green Whelp Blood
	[6083]="0:0:12:1:20:::1:0:", -- Broken Tears
	[6084]="0:291:4:2:1:Mail::1:0:", -- Stormwind Guard Leggings
	[6085]="0:243:4:2:1:Leather::1:0:", -- Footman Tunic
	[6086]="0:0:12:1:1:::1:0:", -- Faustin's Truth Serum
	[6087]="0:1728:4:3:1:Mail::1:0:", -- Chausses of Westfall
	[6089]="0:0:12:1:1:::1:0:", -- Zraedus's Brew
	[6091]="0:0:12:1:1:::1:0:", -- Crate of Power Stones
	[6092]="0:421:4:2:1:Leather::1:0:", -- Black Whelp Boots
	[6093]="0:4418:2:2:1:TwoHandMace::1:0:", -- Orc Crusher
	[6094]="0:1278:2:2:1:TwoHandAxe::1:0:", -- Piercing Axe
	[6095]="0:688:4:2:1:Cloth::1:0:", -- Wandering Boots
	[6096]="1:1:4:1:1:Shirt::1:0:18672", -- Apprentice's Shirt
	[6097]="1:1:4:1:1:Shirt::1:0:18672,24539", -- Acolyte's Shirt
	[6098]="4:1:4:0:1:Cloth::1:0:18672", -- Neophyte's Robe
	[6117]="0:1:4:1:1:Shirt::1:0:", -- Squire's Shirt
	[6118]="0:1:4:0:1:Cloth::1:0:", -- Squire's Pants
	[6119]="0:1:4:0:1:Cloth::1:0:", -- Neophyte's Robe
	[6120]="0:1:4:1:1:Shirt::1:0:", -- Recruit's Shirt
	[6121]="0:1:4:0:1:Cloth::1:0:", -- Recruit's Pants
	[6122]="0:1:4:1:1:Miscellaneous::1:0:", -- Recruit's Boots
	[6123]="0:1:4:0:1:Cloth::1:0:", -- Novice's Robe
	[6124]="0:1:4:0:1:Cloth::1:0:", -- Novice's Pants
	[6125]="0:1:4:1:1:Shirt::1:0:", -- Brawler's Harness
	[6126]="0:1:4:0:1:Cloth::1:0:", -- Trapper's Pants
	[6127]="0:1:4:1:1:Miscellaneous::1:0:", -- Trapper's Boots
	[6129]="0:1:4:0:1:Cloth::1:0:", -- Acolyte's Robe
	[6134]="0:1:4:1:1:Shirt::1:0:", -- Primitive Mantle
	[6135]="0:1:4:0:1:Leather::1:0:", -- Primitive Kilt
	[6136]="0:1:4:1:1:Shirt::1:0:", -- Thug Shirt
	[6137]="0:1:4:0:1:Cloth::1:0:", -- Thug Pants
	[6138]="0:1:4:1:1:Miscellaneous::1:0:", -- Thug Boots
	[6139]="0:1:4:0:1:Cloth::1:0:", -- Novice's Robe
	[6140]="0:1:4:0:1:Cloth::1:0:", -- Apprentice's Robe
	[6144]="0:1:4:0:1:Cloth::1:0:", -- Neophyte's Robe
	[6145]="0:0:12:1:1:::1:0:", -- Clarice's Pendant
	[6146]="0:0:12:1:20:::1:0:", -- Sundried Driftwood
	[6147]="0:37:4:1:1:Leather::1:0:", -- Ratty Old Belt
	[6148]="0:44:4:1:1:Cloth::1:0:", -- Web-covered Boots
	[6149]="1200:300:0:1:5:Potion:755:1:1:983,8157,8158,8177,8178,11188,18810,18905,18906", -- Greater Mana Potion
	[6150]="0:22:15:0:20:Junk::1:0:", -- A Frayed Knot
	[6166]="0:0:12:1:20:::1:0:", -- Coyote Jawbone
	[6167]="0:0:12:1:1:::1:0:", -- Neeka's Report
	[6168]="0:0:12:1:20:::1:0:", -- Sawtooth Snapper Claw
	[6169]="0:0:12:1:20:::1:0:", -- Unprepared Sawtooth Flank
	[6170]="0:0:12:1:1:::1:0:", -- Wizards' Reagents
	[6171]="0:6:4:1:1:Leather::1:0:", -- Wolf Handler Gloves
	[6172]="0:0:12:1:1:::1:0:", -- Lost Supplies
	[6173]="0:7:4:1:1:Cloth::1:0:", -- Snow Boots
	[6175]="0:0:12:1:20:::1:0:", -- Atal'ai Artifact
	[6176]="0:15:4:1:1:Shield::1:0:", -- Dwarven Kite Shield
	[6177]="0:69:4:1:1:Mail::1:0:", -- Ironwrought Bracers
	[6178]="0:0:12:1:1:::1:0:", -- Shipment to Nethergarde
	[6179]="0:369:4:2:1:Cloak::1:0:", -- Privateer's Cape
	[6180]="0:423:4:2:1:Mail::1:0:", -- Slarkskin
	[6181]="0:0:12:1:20:::1:0:", -- Fetish of Hakkar
	[6182]="0:0:4:1:1:OffHandFrill::1:0:", -- Dim Torch
	[6184]="0:0:12:1:20:::1:0:", -- Monstrous Crawler Leg
	[6185]="0:7:4:1:1:Cloak::1:0:", -- Bear Shawl
	[6186]="0:1373:2:2:1:TwoHandSword::1:0:", -- Trogg Slicer
	[6187]="0:613:4:2:1:Shield::1:0:", -- Dwarven Defender
	[6188]="0:305:4:2:1:Mail::1:0:", -- Mud Stompers
	[6189]="0:624:4:1:1:Mail::1:0:", -- Durable Chain Shoulders
	[6190]="0:0:12:1:1:::1:0:", -- Draenethyst Shard
	[6191]="0:616:4:2:1:Cloth::1:0:", -- Kimbra Boots
	[6193]="0:0:12:1:1:::1:0:", -- Bundle of Atal'ai Artifacts
	[6194]="0:5308:2:2:1:OneHandAxe::1:0:", -- Barreling Reaper
	[6195]="0:416:4:2:1:Mail::1:0:", -- Wax-polished Armor
	[6196]="0:0:2:0:1:OneHandMace::1:0:", -- Noboru's Cudgel
	[6197]="0:929:4:2:1:Leather::1:0:", -- Loch Croc Hide Vest
	[6198]="0:1113:4:2:1:Leather::1:0:", -- Jurassic Wristguards
	[6199]="0:650:4:2:1:Ring::1:0:", -- Black Widow Band
	[6200]="0:1223:4:2:1:Mail::1:0:", -- Garneg's War Belt
	[6201]="0:54:4:1:1:Leather::1:0:", -- Lithe Boots
	[6202]="0:37:4:1:1:Cloth::1:0:", -- Fingerless Gloves
	[6203]="0:121:4:1:1:Shield::1:0:", -- Thuggish Shield
	[6204]="0:2065:4:2:1:Leather::1:0:", -- Tribal Worg Helm
	[6205]="0:922:2:2:1:TwoHandMace::1:0:", -- Burrowing Shovel
	[6206]="0:555:2:1:1:TwoHandAxe::1:0:", -- Rock Chipper
	[6211]="0:450:9:1:1:Alchemy::1:0:", -- Recipe: Elixir of Ogre's Strength
	[6212]="0:0:12:1:1:::1:0:", -- Head of Jammal'an
	[6214]="0:993:2:2:1:TwoHandMace::1:0:", -- Heavy Copper Maul
	[6215]="0:602:2:2:1:Stave::1:0:", -- Balanced Fighting Stick
	[6217]="124:24:7:1:1:Enchanting:333:1:0:66,777,843,960,989,1148,1250,1286,1318,1456,1465,1692,2118,2225,2381,2393,2810,2821,3012,3081,3168,3187,3346,3367,3482,3499,3556,3614,3779,3954,3955,4194,4228,4229,4561,4617,4775,4877,4897,5100,5135,5158,5163,5757,5758,5817,6301,7947,8145,8363,8934,9636,11189,12022,12028,12043,12245,12941,12957,12958,15179,15419,16224,16261,16262,16613,16635,16722,16768,17486,17490,18009,18426,18427,18753,18773,18951,19234,19244,19372,19450,19537,19540,19663,24843,24935,24995,25010,25019,25051,25082,26569,27021,27026,27030,27039,27043,27054,27057,27147,28692,28714,28715,28831,28872,29288,29537,30311,33597", -- Copper Rod
	[6218]="0:24:7:1:1:Enchanting:333:1:0:", -- Runed Copper Rod
	[6219]="0:144:2:1:1:Miscellaneous::1:0:", -- Arclight Spanner
	[6220]="0:4893:2:3:1:Dagger::1:0:", -- Meteor Shard
	[6223]="0:4797:4:2:1:Shield::1:0:", -- Crest of Darkshire
	[6226]="0:1068:4:3:1:Cloth::1:0:", -- Bloody Apron
	[6238]="0:98:4:2:1:Cloth::1:0:", -- Brown Linen Robe
	[6239]="0:160:4:2:1:Cloth::1:0:", -- Red Linen Vest
	[6240]="0:161:4:2:1:Cloth::1:0:", -- Blue Linen Vest
	[6241]="0:99:4:2:1:Cloth::1:0:", -- White Linen Robe
	[6242]="0:243:4:2:1:Cloth::1:0:", -- Blue Linen Robe
	[6243]="0:445:4:2:1:Cloth::1:0:", -- Green Woolen Robe
	[6245]="0:0:12:1:1:::1:0:", -- Karnitol's Satchel
	[6246]="0:0:12:1:20:::1:0:", -- Hatefury Claw
	[6247]="0:0:12:1:20:::1:0:", -- Hatefury Horn
	[6248]="0:0:12:1:20:::1:0:", -- Scorpashi Venom
	[6249]="0:0:12:1:20:::1:0:", -- Aged Kodo Hide
	[6250]="0:0:12:1:20:::1:0:", -- Felhound Brain
	[6251]="0:0:12:1:20:::1:0:", -- Nether Wing
	[6252]="0:0:12:1:20:::1:0:", -- Doomwarder Blood
	[6253]="0:0:12:1:1:::1:0:", -- Leftwitch's Package
	[6256]="23:4:2:1:1:FishingPole::1:0:66,777,843,989,1148,1250,1286,1465,1678,1684,1692,2118,2225,2383,2626,2810,2821,3029,3081,3168,3178,3187,3333,3367,3482,3497,3499,3550,3556,3572,3614,3779,3954,3955,4194,4222,4229,4561,4574,4775,4897,5135,5162,5163,5494,5817,5940,5942,6301,7945,7947,8145,8363,8508,8934,10118,10216,11189,12022,12028,12031,12043,12245,12941,12957,12958,12962,14740,15179,16224,16261,16262,16613,16708,16768,17101,17486,17490,18009,18018,18347,18426,18427,18911,19244,19372,19450,19472,24843,24935,24995,25010,25019,25051,25082,27021,27026,27043,27057,27144,27181,27190,28692,28707,28742,28812,28831,28872,29288,30311,31804,31805", -- Fishing Pole
	[6257]="0:0:12:1:20:::1:0:", -- Roc Gizzard
	[6258]="0:0:12:1:20:::1:0:", -- Ironfur Liver
	[6259]="0:0:12:1:20:::1:0:", -- Groddoc Liver
	[6260]="50:12:7:1:10:Other:197:1:0:66,843,1250,1347,1454,1465,1474,1672,1692,2118,2225,2394,2668,2669,2670,2672,2697,2698,2699,2816,2819,2846,3005,3081,3091,3096,3168,3187,3364,3366,3482,3485,3614,3958,4168,4189,4194,4225,4577,4589,5128,5135,5154,5565,5783,5817,5944,6301,6567,6568,6574,6576,6731,7852,7854,7940,8160,8681,8934,11557,11874,12942,12943,12956,15165,16224,16261,16262,16366,16638,16689,16748,16767,17490,18277,18426,18427,18749,18754,18771,18772,19196,19213,19521,19532,19722,21085,28718,28726,28798,28810,33596,33601", -- Blue Dye
	[6261]="1000:250:7:1:10:Other:197:1:0:1347,1454,1474,1672,2394,2668,2669,2670,2672,2697,2698,2699,2816,2819,2846,3005,3091,3096,3364,3366,3485,3958,4168,4189,4225,4577,4589,5128,5154,5565,5783,5944,6567,6568,6574,6576,6731,7852,7854,7940,8160,8681,11557,11874,12942,12943,12956,15165,16366,16638,16689,16748,16767,18277,18749,18754,18771,18772,19196,19213,19521,19532,19722,21085,28718,28726,28798,28810,33596,33601", -- Orange Dye
	[6263]="0:589:4:2:1:Cloth::1:0:", -- Blue Overalls
	[6264]="0:884:4:2:1:Cloth::1:0:", -- Greater Adept's Robe
	[6265]="0:0:15:1:1:Reagent:-9:1:0:", -- Soul Shard
	[6266]="0:205:4:2:1:Cloth::1:0:", -- Disciple's Vest
	[6267]="0:149:4:2:1:Cloth::1:0:", -- Disciple's Pants
	[6268]="0:234:4:2:1:Leather::1:0:", -- Pioneer Tunic
	[6269]="0:193:4:2:1:Leather::1:0:", -- Pioneer Trousers
	[6270]="200:50:9:1:1:Tailoring::1:1:66,3364,3485,3522", -- Pattern: Blue Linen Vest
	[6271]="0:50:9:2:1:Tailoring::1:0:", -- Pattern: Red Linen Vest
	[6272]="300:75:9:1:1:Tailoring::1:1:1250,3485,3499,3556,4168", -- Pattern: Blue Linen Robe
	[6274]="400:100:9:1:1:Tailoring::1:1:843,1347,2394,3364,5944", -- Pattern: Blue Overalls
	[6275]="800:200:9:1:1:Tailoring::1:1:1454,1474,2669,3499,4168,4577", -- Pattern: Greater Adept's Robe
	[6281]="0:0:12:1:20:::1:0:", -- Rattlecage Skull
	[6282]="0:2244:4:2:1:Cloth::1:0:", -- Sacred Burial Trousers
	[6283]="0:0:12:1:1:::1:0:", -- The Book of Ur
	[6284]="0:0:12:1:1:::1:0:", -- Runes of Summoning
	[6285]="0:0:12:1:1:::1:0:", -- Egalin's Grimoire
	[6286]="0:0:12:1:1:::1:0:", -- Pure Hearts
	[6287]="0:0:12:1:1:::1:0:", -- Atal'ai Tablet Fragment
	[6288]="0:0:12:1:20:::1:0:", -- Atal'ai Tablet
	[6289]="0:1:7:1:20:Meat:185:1:0:", -- Raw Longjaw Mud Snapper
	[6290]="0:1:0:1:20:FoodDrink::1:0:", -- Brilliant Smallfish
	[6291]="0:1:7:1:20:Meat:185:1:0:", -- Raw Brilliant Smallfish
	[6292]="0:8:4:1:1:OffHandFrill::1:0:", -- 10 Pound Mud Snapper
	[6293]="0:33:15:0:10:Junk::1:0:", -- Dried Bat Blood
	[6294]="0:10:4:1:1:OffHandFrill::1:0:", -- 12 Pound Mud Snapper
	[6295]="0:12:4:1:1:OffHandFrill::1:0:", -- 15 Pound Mud Snapper
	[6296]="0:28:15:0:10:Junk::1:0:", -- Patch of Bat Hair
	[6297]="0:7:15:0:10:Junk::1:0:", -- Old Skull
	[6298]="0:130:15:0:20:Junk::1:0:", -- Bloody Bat Fang
	[6299]="0:1:0:1:20:FoodDrink::1:0:", -- Sickly Looking Fish
	[6300]="0:443:15:0:10:Junk::1:0:", -- Husk Fragment
	[6301]="0:20:15:0:1:Junk::1:0:", -- Old Teamster's Skull
	[6302]="0:628:15:0:5:Junk::1:0:", -- Delicate Insect Wing
	[6303]="0:1:7:1:20:Meat:185:1:0:", -- Raw Slitherskin Mackerel
	[6304]="0:25:15:0:1:Junk::1:0:", -- Damp Diary Page (Day 4)
	[6305]="0:25:15:0:1:Junk::1:0:", -- Damp Diary Page (Day 87)
	[6306]="0:25:15:0:1:Junk::1:0:", -- Damp Diary Page (Day 512)
	[6307]="0:1:15:1:1:Junk::1:0:", -- Message in a Bottle
	[6308]="0:2:7:1:20:Meat:185:1:0:", -- Raw Bristle Whisker Catfish
	[6309]="0:100:4:1:1:OffHandFrill::1:0:", -- 17 Pound Catfish
	[6310]="0:150:4:1:1:OffHandFrill::1:0:", -- 19 Pound Catfish
	[6311]="0:187:4:1:1:OffHandFrill::1:0:", -- 22 Pound Catfish
	[6312]="0:0:12:1:1:::1:0:", -- Dalin's Heart
	[6313]="0:0:12:1:1:::1:0:", -- Comar's Heart
	[6314]="0:1217:4:3:1:Cloak::1:0:", -- Wolfmaster Cape
	[6315]="0:2546:2:2:1:Crossbow::1:0:", -- Steelarrow Crossbow
	[6316]="0:3:0:1:20:FoodDrink::1:0:", -- Loch Frenzy Delight
	[6317]="0:2:7:1:20:Meat:185:1:0:", -- Raw Loch Frenzy
	[6318]="0:4803:2:3:1:Stave::1:0:", -- Odo's Ley Staff
	[6319]="0:964:4:3:1:Leather::1:0:", -- Girdle of the Blindwatcher
	[6320]="0:2711:4:3:1:Shield::1:0:", -- Commander's Crest
	[6321]="0:1650:4:3:1:Ring::1:0:", -- Silverlaine's Family Seal
	[6323]="0:3134:2:3:1:OneHandMace::1:0:", -- Baron's Scepter
	[6324]="0:1892:4:3:1:Cloth::1:0:", -- Robes of Arugal
	[6325]="40:10:9:1:1:Cooking::1:0:66,1684,3029,3550,4265,4574,5494,5940,8508", -- Recipe: Brilliant Smallfish
	[6326]="40:10:9:1:1:Cooking::1:0:3550,4305,5162,5942,10118", -- Recipe: Slitherskin Mackerel
	[6327]="0:12823:2:3:1:TwoHandMace::1:0:", -- The Pacifier
	[6328]="400:100:9:1:1:Cooking::1:0:66,1684,3027,4265,4574,5162,5748,5940", -- Recipe: Longjaw Mud Snapper
	[6329]="400:100:9:1:1:Cooking::1:0:1684", -- Recipe: Loch Frenzy Delight
	[6330]="1200:300:9:1:1:Cooking::1:0:2383,2397,3027,3029,3497,4553,5494", -- Recipe: Bristle Whisker Catfish
	[6331]="0:9466:2:3:1:Dagger::1:0:", -- Howling Blade
	[6332]="0:1153:4:3:1:Ring::1:0:", -- Black Pearl Ring
	[6333]="0:1929:2:2:1:Dagger::1:0:", -- Spikelash Dagger
	[6335]="0:1581:4:2:1:Leather::1:0:", -- Grizzled Boots
	[6336]="0:305:4:2:1:Mail::1:0:", -- Infantry Tunic
	[6337]="0:245:4:2:1:Mail::1:0:", -- Infantry Leggings
	[6338]="0:125:7:1:1:Enchanting:333:1:0:", -- Silver Rod
	[6339]="0:24:7:1:1:Enchanting:333:1:0:", -- Runed Silver Rod
	[6340]="0:1260:4:3:1:Cloak::1:0:", -- Fenrus' Hide
	[6341]="0:666:4:3:1:OffHandFrill::1:0:", -- Eerie Stable Lantern
	[6342]="0:75:9:2:1:Enchanting::1:0:", -- Formula: Enchant Chest - Minor Mana
	[6344]="0:100:9:2:1:Enchanting::1:0:", -- Formula: Enchant Bracer - Minor Spirit
	[6346]="400:100:9:2:1:Enchanting::1:1:3346,5757", -- Formula: Enchant Chest - Lesser Mana
	[6347]="0:100:9:2:1:Enchanting::1:0:", -- Formula: Enchant Bracer - Minor Strength
	[6348]="0:125:9:2:1:Enchanting::1:0:", -- Formula: Enchant Weapon - Minor Beastslayer
	[6349]="500:125:9:1:1:Enchanting::1:1:3012,3346,5158,5758", -- Formula: Enchant 2H Weapon - Lesser Intellect
	[6350]="0:493:4:2:1:Mail::1:0:", -- Rough Bronze Boots
	[6351]="0:1:15:1:1:Other::1:0:", -- Dented Crate
	[6352]="0:1:15:1:1:Other::1:0:", -- Waterlogged Crate
	[6353]="0:1:15:1:1:Junk::1:0:", -- Small Chest
	[6354]="0:1:15:1:1:Junk::1:0:", -- Small Locked Chest
	[6355]="0:1:15:1:1:Junk::1:0:", -- Sturdy Locked Chest
	[6356]="0:1:15:1:1:Junk::1:0:", -- Battered Chest
	[6357]="0:1:15:1:1:Other::1:0:", -- Sealed Crate
	[6358]="0:4:7:1:20:Other:171:1:0:", -- Oily Blackmouth
	[6359]="0:5:7:1:20:Other:171:1:0:", -- Firefin Snapper
	[6360]="0:2581:2:2:1:OneHandMace::1:0:", -- Steelscale Crushfish
	[6361]="0:2:7:1:20:Meat:185:1:0:", -- Raw Rainbow Fin Albacore
	[6362]="0:4:7:1:20:Meat:185:1:0:", -- Raw Rockscale Cod
	[6363]="0:250:4:1:1:OffHandFrill::1:0:", -- 26 Pound Catfish
	[6364]="0:375:4:1:1:OffHandFrill::1:0:", -- 32 Pound Catfish
	[6365]="23:4:2:1:1:FishingPole::1:1:1678,1684,2383,2626,3029,3333,3497,3550,4222,5162,5494,5940,7945,8508,10118,12031,12962,14740,16708,17101,18018,18347,18911,19472,27144,27181,27190,28707,28742,28812,31804,31805", -- Strong Fishing Pole
	[6366]="0:4:2:1:1:FishingPole::1:0:", -- Darkwood Fishing Pole
	[6367]="0:4:2:1:1:FishingPole::1:0:", -- Big Iron Fishing Pole
	[6368]="400:100:9:1:1:Cooking::1:0:3178,3333,3497,4305,4307,4553,5494,5748,5942,10118", -- Recipe: Rainbow Fin Albacore
	[6369]="2200:550:9:1:1:Cooking::1:0:2383,2664,3178,3333,4307,4574,5162,12033,12962", -- Recipe: Rockscale Cod
	[6370]="0:10:7:1:20:Other:171,333:1:0:", -- Blackmouth Oil
	[6371]="0:12:7:1:20:Other:171,333,197:1:0:", -- Fire Oil
	[6372]="0:35:0:1:5:Potion::1:0:", -- Swim Speed Potion
	[6373]="0:35:0:1:20:Elixir::1:0:", -- Elixir of Firepower
	[6375]="0:250:9:2:1:Enchanting::1:0:", -- Formula: Enchant Bracer - Lesser Spirit
	[6377]="1000:250:9:2:1:Enchanting::1:1:3012,3537", -- Formula: Enchant Boots - Minor Agility
	[6378]="0:292:4:2:1:Cloak::1:0:", -- Seer's Cape
	[6379]="0:244:4:2:1:Leather::1:0:", -- Inscribed Leather Belt
	[6380]="0:654:4:2:1:Shield::1:0:", -- Inscribed Buckler
	[6381]="0:625:4:2:1:Cloak::1:0:", -- Bright Cloak
	[6382]="0:523:4:2:1:Leather::1:0:", -- Forest Leather Belt
	[6383]="0:1519:4:2:1:Shield::1:0:", -- Forest Buckler
	[6384]="0:250:4:1:1:Shirt::1:0:", -- Stylish Blue Shirt
	[6385]="0:250:4:1:1:Shirt::1:0:", -- Stylish Green Shirt
	[6386]="0:2692:4:2:1:Mail::1:0:", -- Glimmering Mail Legguards
	[6387]="0:1228:4:2:1:Mail::1:0:", -- Glimmering Mail Bracers
	[6388]="0:2043:4:2:1:Mail::1:0:", -- Glimmering Mail Pauldrons
	[6389]="0:2245:4:2:1:Mail::1:0:", -- Glimmering Mail Coif
	[6390]="0:150:9:2:1:Tailoring::1:0:", -- Pattern: Stylish Blue Shirt
	[6391]="0:150:9:2:1:Tailoring::1:0:", -- Pattern: Stylish Green Shirt
	[6392]="0:1000:4:3:1:Cloth::1:0:", -- Belt of Arugal
	[6393]="0:760:4:2:1:Cloth::1:0:", -- Silver-thread Gloves
	[6394]="0:1041:4:2:1:Cloth::1:0:", -- Silver-thread Boots
	[6395]="0:1264:4:2:1:Cloth::1:0:", -- Silver-thread Amice
	[6396]="0:2814:4:2:1:Leather::1:0:", -- Emblazoned Chestpiece
	[6397]="0:986:4:2:1:Leather::1:0:", -- Emblazoned Gloves
	[6398]="0:989:4:2:1:Leather::1:0:", -- Emblazoned Belt
	[6399]="0:1639:4:2:1:Leather::1:0:", -- Emblazoned Shoulders
	[6400]="0:3089:4:2:1:Shield::1:0:", -- Glimmering Shield
	[6401]="1100:275:9:1:1:Tailoring::1:1:2394,2669", -- Pattern: Dark Silk Shirt
	[6402]="0:4699:4:2:1:Mail::1:0:", -- Mail Combat Leggings
	[6403]="0:1772:4:2:1:Mail::1:0:", -- Mail Combat Armguards
	[6404]="0:3242:4:2:1:Mail::1:0:", -- Mail Combat Spaulders
	[6405]="0:3168:4:2:1:Cloth::1:0:", -- Nightsky Trousers
	[6406]="0:1970:4:2:1:Cloth::1:0:", -- Nightsky Boots
	[6407]="0:1198:4:2:1:Cloth::1:0:", -- Nightsky Wristbands
	[6408]="0:1654:4:2:1:Leather::1:0:", -- Insignia Gloves
	[6409]="0:1660:4:2:1:Leather::1:0:", -- Insignia Belt
	[6410]="0:1515:4:2:1:Leather::1:0:", -- Insignia Bracers
	[6411]="0:7268:4:2:1:Mail::1:0:", -- Chief Brigadier Armor
	[6412]="0:4711:4:2:1:Mail::1:0:", -- Chief Brigadier Boots
	[6413]="0:2497:4:2:1:Mail::1:0:", -- Chief Brigadier Bracers
	[6414]="0:2055:4:3:1:Ring::1:0:", -- Seal of Sylvanas
	[6415]="0:4565:4:2:1:Cloth::1:0:", -- Aurora Robe
	[6416]="0:2728:4:2:1:Cloth::1:0:", -- Aurora Boots
	[6417]="0:2536:4:2:1:Cloak::1:0:", -- Aurora Cloak
	[6418]="0:1697:4:2:1:Cloth::1:0:", -- Aurora Sash
	[6419]="0:2299:4:2:1:Leather::1:0:", -- Glyphed Mitts
	[6420]="0:3739:4:2:1:Leather::1:0:", -- Glyphed Boots
	[6421]="0:2317:4:2:1:Leather::1:0:", -- Glyphed Belt
	[6422]="0:3768:4:2:1:Leather::1:0:", -- Glyphed Helm
	[6423]="0:7233:4:2:1:Mail::1:0:", -- Blackforge Greaves
	[6424]="0:3825:4:2:1:Cloak::1:0:", -- Blackforge Cape
	[6425]="0:4478:4:2:1:Mail::1:0:", -- Blackforge Girdle
	[6426]="0:4162:4:2:1:Mail::1:0:", -- Blackforge Bracers
	[6427]="0:7016:4:2:1:Cloth::1:0:", -- Mistscape Robe
	[6428]="0:2795:4:2:1:Cloth::1:0:", -- Mistscape Gloves
	[6429]="0:4544:4:2:1:Cloth::1:0:", -- Mistscape Wizard Hat
	[6430]="0:9098:4:2:1:Leather::1:0:", -- Imperial Leather Breastplate
	[6431]="0:5436:4:2:1:Leather::1:0:", -- Imperial Leather Boots
	[6432]="0:3741:4:2:1:Cloak::1:0:", -- Imperial Cloak
	[6433]="0:4953:4:2:1:Leather::1:0:", -- Imperial Leather Helm
	[6435]="0:0:12:1:20:::1:0:", -- Infused Burning Gem
	[6436]="0:0:12:1:1:::1:0:", -- Burning Gem
	[6438]="0:362:15:0:5:Junk::1:0:", -- Dull Elemental Bracer
	[6439]="0:237:15:0:5:Junk::1:0:", -- Broken Binding Bracer
	[6440]="0:15812:4:3:1:Ring::1:0:", -- Brainlash
	[6441]="0:0:12:1:1:::1:0:", -- Shadowstalker Scalp
	[6442]="0:0:12:1:1:::1:0:", -- Oracle Crystal
	[6443]="0:0:12:1:20:::1:0:", -- Deviate Hide
	[6444]="0:228:15:0:5:Junk::1:0:", -- Forked Tongue
	[6445]="0:88:15:0:5:Junk::1:0:", -- Brittle Molting
	[6446]="0:532:1:3:1:Bag::1:0:", -- Snakeskin Bag
	[6447]="0:1124:4:3:1:Shield::1:0:", -- Worn Turtle Shell Shield
	[6448]="0:2331:2:3:1:Dagger::1:0:", -- Tail Spike
	[6449]="0:701:4:3:1:Cloak::1:0:", -- Glowing Lizardscale Cloak
	[6450]="0:170:0:1:20:Bandage::1:0:", -- Silk Bandage
	[6451]="0:400:0:1:20:Bandage::1:0:", -- Heavy Silk Bandage
	[6452]="0:28:0:1:20:Other::1:0:", -- Anti-Venom
	[6453]="0:62:0:1:20:Other::1:0:", -- Strong Anti-Venom
	[6454]="0:225:9:2:1:FirstAid::1:0:", -- Manual: Strong Anti-Venom
	[6455]="0:4:15:0:5:Junk::1:0:", -- Old Wagonwheel
	[6456]="0:3:15:0:10:Junk::1:0:", -- Acidic Slime
	[6457]="0:4:15:0:5:Junk::1:0:", -- Rusted Engineering Parts
	[6458]="0:1:0:1:20:Other::1:0:", -- Oil Covered Fish
	[6459]="0:1122:4:3:1:Mail::1:0:", -- Savage Trodders
	[6460]="0:844:4:3:1:Mail::1:0:", -- Cobrahn's Grasp
	[6461]="0:1190:4:3:1:Cloth::1:0:", -- Slime-encrusted Pads
	[6462]="0:0:12:1:1:::1:0:", -- Secure Crate
	[6463]="0:1527:4:3:1:Ring::1:0:", -- Deep Fathom Ring
	[6464]="0:0:12:1:20:::1:0:", -- Wailing Essence
	[6465]="0:922:4:3:1:Cloth::1:0:", -- Robe of the Moccasin
	[6466]="0:330:4:2:1:Cloak::1:0:", -- Deviate Scale Cloak
	[6467]="0:420:4:2:1:Leather::1:0:", -- Deviate Scale Gloves
	[6468]="0:658:4:3:1:Leather::1:0:", -- Deviate Scale Belt
	[6469]="0:2240:2:3:1:Bow::1:0:", -- Venomstrike
	[6470]="0:20:7:1:20:Leather:165:1:0:", -- Deviate Scale
	[6471]="0:500:7:1:20:Leather:165:1:0:", -- Perfect Deviate Scale
	[6472]="0:3018:2:3:1:OneHandMace::1:0:", -- Stinging Viper
	[6473]="0:1212:4:3:1:Leather::1:0:", -- Armor of the Fang
	[6474]="550:137:9:1:1:Leatherworking::1:1:5783", -- Pattern: Deviate Scale Cloak
	[6475]="1500:375:9:1:1:Leatherworking::1:1:5783", -- Pattern: Deviate Scale Gloves
	[6476]="0:500:9:2:1:Leatherworking::1:0:", -- Pattern: Deviate Scale Belt
	[6477]="0:274:4:2:1:Cloth::1:0:", -- Grassland Sash
	[6479]="0:0:12:1:1:::1:0:", -- Malem Pendant
	[6480]="0:713:4:2:1:Leather::1:0:", -- Slick Deviate Leggings
	[6481]="0:642:4:2:1:Mail::1:0:", -- Dagmire Gauntlets
	[6482]="0:728:4:2:1:Cloth::1:0:", -- Firewalker Boots
	[6486]="0:0:12:1:20:::1:0:", -- Singed Scale
	[6487]="0:0:12:1:20:::1:0:", -- Vile Familiar Head
	[6488]="0:0:12:1:1:::1:0:", -- Simple Tablet
	[6502]="0:1140:4:2:1:Mail::1:0:", -- Violet Scale Armor
	[6503]="0:763:4:2:1:Cloth::1:0:", -- Harlequin Robes
	[6504]="0:2933:2:3:1:OneHandSword::1:0:", -- Wingblade
	[6505]="0:3680:2:3:1:Stave::1:0:", -- Crescent Staff
	[6506]="0:87:4:1:1:Mail::1:0:", -- Infantry Boots
	[6507]="0:44:4:1:1:Mail::1:0:", -- Infantry Bracers
	[6508]="0:34:4:1:1:Cloak::1:0:", -- Infantry Cloak
	[6509]="0:45:4:1:1:Mail::1:0:", -- Infantry Belt
	[6510]="0:54:4:1:1:Mail::1:0:", -- Infantry Gauntlets
	[6511]="0:121:4:2:1:Cloth::1:0:", -- Journeyman's Robe
	[6512]="0:191:4:2:1:Cloth::1:0:", -- Disciple's Robe
	[6513]="0:28:4:1:1:Cloth::1:0:", -- Disciple's Sash
	[6514]="0:42:4:1:1:Cloak::1:0:", -- Disciple's Cloak
	[6515]="0:37:4:1:1:Cloth::1:0:", -- Disciple's Gloves
	[6517]="0:35:4:1:1:Leather::1:0:", -- Pioneer Belt
	[6518]="0:70:4:1:1:Leather::1:0:", -- Pioneer Boots
	[6519]="0:36:4:1:1:Leather::1:0:", -- Pioneer Bracers
	[6520]="0:33:4:1:1:Cloak::1:0:", -- Pioneer Cloak
	[6521]="0:47:4:1:1:Leather::1:0:", -- Pioneer Gloves
	[6522]="0:4:0:1:20:FoodDrink:171,185:1:0:", -- Deviate Fish
	[6523]="1422:284:4:1:1:Leather::1:0:3023,3359", -- Buckled Harness
	[6524]="2871:574:4:1:1:Leather::1:0:3023,3359", -- Studded Leather Harness
	[6525]="5168:1033:4:1:1:Leather::1:0:3023,3359", -- Grunt's Harness
	[6526]="12487:2497:4:1:1:Leather::1:0:3023,3359", -- Battle Harness
	[6527]="0:187:4:2:1:Cloth::1:0:", -- Ancestral Robe
	[6528]="0:358:4:2:1:Cloth::1:0:", -- Spellbinder Robe
	[6529]="50:12:0:1:20:EnhTemp::1:0:66,777,843,1250,1465,1678,1684,1692,2118,2225,2383,2626,3029,3081,3168,3178,3187,3333,3482,3497,3499,3550,3556,3572,3614,4194,4222,4574,5135,5162,5494,5817,5940,5942,6301,7945,8508,8934,10118,10216,12028,12031,12043,12962,14740,16224,16261,16262,16708,17101,17490,18018,18347,18426,18427,18911,19472,27144,27181,27190,28707,28742,28812,31804,31805", -- Shiny Bauble
	[6530]="100:25:0:1:20:EnhTemp:202:1:0:777,843,960,989,1148,1286,1456,1465,1678,1684,2225,2381,2383,2393,2626,2810,2821,3029,3178,3333,3367,3482,3497,3499,3550,3556,3572,3779,3954,3955,4194,4222,4229,4561,4574,4775,4877,4897,5100,5135,5162,5163,5494,5817,5940,5942,6301,7945,7947,8145,8363,8508,8934,9636,10118,11189,12022,12028,12031,12043,12245,12941,12957,12958,12962,14740,15179,16224,16613,16708,16768,17101,17486,17490,18009,18018,18347,18426,18427,18911,19244,19372,19450,19472,24843,24935,24995,25010,25019,25051,25082,27021,27026,27043,27057,27144,27181,27190,28692,28707,28742,28812,28831,28872,29288,30311,31804,31805", -- Nightcrawlers
	[6531]="0:417:4:2:1:Cloth::1:0:", -- Barbaric Cloth Robe
	[6532]="250:62:0:1:20:EnhTemp::1:0:960,989,1148,1286,1456,1678,1684,2225,2381,2383,2393,2626,2810,2821,3029,3178,3333,3367,3497,3550,3572,3779,3954,3955,4222,4229,4561,4574,4775,4877,4897,5100,5135,5162,5163,5494,5817,5940,5942,6301,7945,7947,8145,8363,8508,8934,9636,10118,11189,12022,12028,12031,12245,12941,12957,12958,12962,14740,15179,16602,16613,16708,16768,16826,17101,17486,18009,18015,18018,18347,18907,18911,18960,19015,19017,19042,19194,19197,19244,19345,19372,19450,19472,19497,19533,19562,19573,20081,20092,20194,20250,20891,21083,21113,22099,22271,23802,24054,24147,24188,24341,24356,24843,24935,24995,25010,25019,25034,25051,25082,26374,26474,26720,26939,26941,27012,27021,27026,27043,27057,27063,27070,27132,27144,27146,27181,27184,27190,27195,27938,28692,28707,28742,28794,28806,28812,28831,28872,29208,29270,29277,29288,30311,30345,30438,30825,31115,31804,31805,32477,32639,32641,33669", -- Bright Baubles
	[6533]="250:62:0:1:20:EnhTemp::1:1:1678,1684,2383,2626,3029,3178,3333,3497,3550,3572,4222,4574,5162,5494,5940,5942,7945,8508,10118,12031,12962,14740,17101,18018,18347,18911,19472,27144,27181,27190,28707,28742,28812,31804,31805", -- Aquadynamic Fish Attractor
	[6534]="0:0:12:1:1:::1:0:", -- Forged Steel Bars
	[6535]="0:0:12:1:1:::1:0:", -- Tablet of Verga
	[6536]="0:488:4:2:1:Cloth::1:0:", -- Willow Vest
	[6537]="0:210:4:2:1:Cloth::1:0:", -- Willow Boots
	[6538]="0:492:4:2:1:Cloth::1:0:", -- Willow Robe
	[6539]="0:162:4:2:1:Cloth::1:0:", -- Willow Belt
	[6540]="0:431:4:2:1:Cloth::1:0:", -- Willow Pants
	[6541]="0:163:4:2:1:Cloth::1:0:", -- Willow Gloves
	[6542]="0:219:4:2:1:Cloak::1:0:", -- Willow Cape
	[6543]="0:147:4:2:1:Cloth::1:0:", -- Willow Bracers
	[6545]="0:676:4:2:1:Mail::1:0:", -- Soldier's Armor
	[6546]="0:533:4:2:1:Mail::1:0:", -- Soldier's Leggings
	[6547]="0:267:4:2:1:Mail::1:0:", -- Soldier's Gauntlets
	[6548]="0:233:4:2:1:Mail::1:0:", -- Soldier's Girdle
	[6549]="0:102:4:1:1:Cloak::1:0:", -- Soldier's Cloak
	[6550]="0:204:4:2:1:Mail::1:0:", -- Soldier's Wristguards
	[6551]="0:409:4:2:1:Mail::1:0:", -- Soldier's Boots
	[6552]="0:601:4:2:1:Leather::1:0:", -- Bard's Tunic
	[6553]="0:525:4:2:1:Leather::1:0:", -- Bard's Trousers
	[6554]="0:229:4:2:1:Leather::1:0:", -- Bard's Gloves
	[6555]="0:104:4:1:1:Cloak::1:0:", -- Bard's Cloak
	[6556]="0:174:4:2:1:Leather::1:0:", -- Bard's Bracers
	[6557]="0:302:4:2:1:Leather::1:0:", -- Bard's Boots
	[6558]="0:180:4:2:1:Leather::1:0:", -- Bard's Belt
	[6559]="0:533:4:2:1:Shield::1:0:", -- Bard's Buckler
	[6560]="0:616:4:2:1:Shield::1:0:", -- Soldier's Shield
	[6561]="0:675:4:2:1:Cloth::1:0:", -- Seer's Padded Armor
	[6562]="0:508:4:2:1:Cloth::1:0:", -- Shimmering Boots
	[6563]="0:295:4:2:1:Cloth::1:0:", -- Shimmering Bracers
	[6564]="0:512:4:2:1:Cloak::1:0:", -- Shimmering Cloak
	[6565]="0:394:4:2:1:Cloth::1:0:", -- Shimmering Gloves
	[6566]="0:411:4:1:1:Cloth::1:0:", -- Shimmering Amice
	[6567]="0:1036:4:2:1:Cloth::1:0:", -- Shimmering Armor
	[6568]="0:920:4:2:1:Cloth::1:0:", -- Shimmering Trousers
	[6569]="0:1044:4:2:1:Cloth::1:0:", -- Shimmering Robe
	[6570]="0:363:4:2:1:Cloth::1:0:", -- Shimmering Sash
	[6571]="0:1167:4:2:1:Shield::1:0:", -- Scouting Buckler
	[6572]="0:1323:4:2:1:Shield::1:0:", -- Defender Shield
	[6573]="0:938:4:2:1:Mail::1:0:", -- Defender Boots
	[6574]="0:568:4:2:1:Mail::1:0:", -- Defender Bracers
	[6575]="0:431:4:2:1:Cloak::1:0:", -- Defender Cloak
	[6576]="0:572:4:2:1:Mail::1:0:", -- Defender Girdle
	[6577]="0:649:4:2:1:Mail::1:0:", -- Defender Gauntlets
	[6578]="0:1303:4:2:1:Mail::1:0:", -- Defender Leggings
	[6579]="0:667:4:1:1:Mail::1:0:", -- Defender Spaulders
	[6580]="0:1312:4:2:1:Mail::1:0:", -- Defender Tunic
	[6581]="0:422:4:2:1:Leather::1:0:", -- Scouting Belt
	[6582]="0:731:4:2:1:Leather::1:0:", -- Scouting Boots
	[6583]="0:425:4:2:1:Leather::1:0:", -- Scouting Bracers
	[6584]="0:1416:4:2:1:Leather::1:0:", -- Scouting Tunic
	[6585]="0:446:4:2:1:Cloak::1:0:", -- Scouting Cloak
	[6586]="0:505:4:2:1:Leather::1:0:", -- Scouting Gloves
	[6587]="0:1146:4:2:1:Leather::1:0:", -- Scouting Trousers
	[6588]="0:458:4:1:1:Leather::1:0:", -- Scouting Spaulders
	[6590]="0:1830:4:2:1:Mail::1:0:", -- Battleforge Boots
	[6591]="0:1007:4:2:1:Mail::1:0:", -- Battleforge Wristguards
	[6592]="0:2448:4:2:1:Mail::1:0:", -- Battleforge Armor
	[6593]="0:923:4:2:1:Cloak::1:0:", -- Battleforge Cloak
	[6594]="0:1121:4:2:1:Mail::1:0:", -- Battleforge Girdle
	[6595]="0:1125:4:2:1:Mail::1:0:", -- Battleforge Gauntlets
	[6596]="0:2258:4:2:1:Mail::1:0:", -- Battleforge Legguards
	[6597]="0:1707:4:2:1:Mail::1:0:", -- Battleforge Shoulderguards
	[6598]="0:2426:4:2:1:Shield::1:0:", -- Dervish Buckler
	[6599]="0:2678:4:2:1:Shield::1:0:", -- Battleforge Shield
	[6600]="0:867:4:2:1:Leather::1:0:", -- Dervish Belt
	[6601]="0:1437:4:2:1:Leather::1:0:", -- Dervish Boots
	[6602]="0:874:4:2:1:Leather::1:0:", -- Dervish Bracers
	[6603]="0:2335:4:2:1:Leather::1:0:", -- Dervish Tunic
	[6604]="0:960:4:2:1:Cloak::1:0:", -- Dervish Cape
	[6605]="0:971:4:2:1:Leather::1:0:", -- Dervish Gloves
	[6607]="0:2202:4:2:1:Leather::1:0:", -- Dervish Leggings
	[6608]="0:1328:4:2:1:Cloth::1:0:", -- Bright Armor
	[6609]="0:2148:4:2:1:Cloth::1:0:", -- Sage's Cloth
	[6610]="0:2156:4:2:1:Cloth::1:0:", -- Sage's Robe
	[6611]="0:812:4:2:1:Cloth::1:0:", -- Sage's Sash
	[6612]="0:1112:4:2:1:Cloth::1:0:", -- Sage's Boots
	[6613]="0:744:4:2:1:Cloth::1:0:", -- Sage's Bracers
	[6614]="0:1120:4:2:1:Cloak::1:0:", -- Sage's Cloak
	[6615]="0:824:4:2:1:Cloth::1:0:", -- Sage's Gloves
	[6616]="0:2204:4:2:1:Cloth::1:0:", -- Sage's Pants
	[6617]="0:1371:4:2:1:Cloth::1:0:", -- Sage's Mantle
	[6622]="0:49863:2:3:1:OneHandSword::1:0:", -- Sword of Zeal
	[6624]="0:0:12:1:1:::1:0:", -- Ken'zigla's Draught
	[6625]="0:0:12:1:1:::1:0:", -- Dirt-caked Pendant
	[6626]="0:0:12:1:1:::1:0:", -- Dogran's Pendant
	[6627]="0:2620:4:3:1:Mail::1:0:", -- Mutant Scale Breastplate
	[6628]="0:370:4:2:1:Cloth::1:0:", -- Raven's Claws
	[6629]="0:756:4:3:1:Cloak::1:0:", -- Sporid Cape
	[6630]="0:2067:4:3:1:Shield::1:0:", -- Seedcloud Buckler
	[6631]="0:4053:2:3:1:Stave::1:0:", -- Living Root
	[6632]="0:511:4:3:1:Cloak::1:0:", -- Feyscale Cloak
	[6633]="0:2558:2:3:1:OneHandSword::1:0:", -- Butcher's Slicer
	[6634]="0:0:12:1:20:::1:0:", -- Ritual Salve
	[6635]="0:0:0:1:1:Consumable::1:0:", -- Earth Sapta
	[6636]="0:0:0:1:1:Consumable::1:0:", -- Fire Sapta
	[6637]="0:0:0:1:1:Consumable::1:0:", -- Water Sapta
	[6640]="0:0:12:1:20:::1:0:", -- Felstalker Hoof
	[6641]="0:4410:2:3:1:TwoHandSword::1:0:", -- Haunting Blade
	[6642]="0:1880:4:3:1:Mail::1:0:", -- Phantom Armor
	[6643]="0:6:15:1:1:Other::1:0:", -- Bloated Smallfish
	[6645]="0:25:15:1:1:Other::1:0:", -- Bloated Mud Snapper
	[6647]="0:40:15:1:1:Other::1:0:", -- Bloated Catfish
	[6651]="0:234:2:1:1:OneHandMace::1:0:", -- Broken Wine Bottle
	[6652]="0:0:12:1:1:::1:0:", -- Reagent Pouch
	[6653]="0:0:4:1:1:OffHandFrill::1:0:", -- Torch of the Dormant Flame
	[6654]="0:0:4:1:1:OffHandFrill::1:0:", -- Torch of the Eternal Flame
	[6655]="0:0:12:1:1:::1:0:", -- Glowing Ember
	[6656]="0:0:12:1:1:::1:0:", -- Rough Quartz
	[6657]="0:5:0:1:20:FoodDrink::1:0:", -- Savory Deviate Delight
	[6658]="0:0:12:1:1:::1:0:", -- Example Collar
	[6659]="0:541:4:2:1:Cloth::1:0:", -- Scarab Trousers
	[6660]="0:36157:2:3:1:Dagger::1:0:", -- Julie's Dagger
	[6661]="0:115:9:2:1:Cooking::1:0:", -- Recipe: Savory Deviate Delight
	[6662]="0:95:0:1:20:Elixir::1:0:", -- Elixir of Giant Growth
	[6663]="0:150:9:2:1:Alchemy::1:0:", -- Recipe: Elixir of Giant Growth
	[6664]="0:892:4:2:1:Cloth::1:0:", -- Voodoo Mantle
	[6665]="0:895:4:2:1:Mail::1:0:", -- Hexed Bracers
	[6666]="0:830:4:2:1:Mail::1:0:", -- Dredge Boots
	[6667]="0:992:4:2:1:Cloak::1:0:", -- Engineer's Cloak
	[6668]="0:1245:4:2:1:Leather::1:0:", -- Draftsman Boots
	[6669]="0:1378:4:2:1:Ring::1:0:", -- Sacred Band
	[6670]="0:1672:4:2:1:Leather::1:0:", -- Panther Armor
	[6671]="0:2068:4:2:1:Mail::1:0:", -- Juggernaut Leggings
	[6672]="0:500:9:2:1:Engineering::1:0:", -- Schematic: Flash Bomb
	[6675]="0:1049:4:2:1:Mail::1:0:", -- Tempered Bracers
	[6676]="0:2246:4:2:1:Shield::1:0:", -- Constable Buckler
	[6677]="0:2401:2:2:1:Wand::1:0:", -- Spellcrafter Wand
	[6678]="0:677:4:2:1:Ring::1:0:", -- Band of Elven Grace
	[6679]="0:5823:2:3:1:Polearm::1:0:", -- Armor Piercer
	[6681]="0:6249:2:3:1:Dagger::1:0:", -- Thornspike
	[6682]="0:2281:4:3:1:Cloth::1:0:", -- Death Speaker Robes
	[6684]="0:0:12:1:1:::1:0:", -- Snufflenose Command Stick
	[6685]="0:1573:4:3:1:Cloth::1:0:", -- Death Speaker Mantle
	[6686]="0:3152:4:3:1:Mail::1:0:", -- Tusken Helm
	[6687]="0:9930:2:3:1:TwoHandAxe::1:0:", -- Corpsemaker
	[6688]="0:2471:4:3:1:Leather::1:0:", -- Whisperwind Headdress
	[6689]="0:8267:2:3:1:Stave::1:0:", -- Wind Spirit Staff
	[6690]="0:4015:4:3:1:Leather::1:0:", -- Ferine Leggings
	[6691]="0:8866:2:3:1:Dagger::1:0:", -- Swinetusk Shank
	[6692]="0:9788:2:3:1:OneHandAxe::1:0:", -- Pronged Reaver
	[6693]="0:1816:4:3:1:Ring::1:0:", -- Agamaggan's Clutch
	[6694]="0:6309:4:3:1:Shield::1:0:", -- Heart of Agamaggan
	[6695]="0:3002:4:3:1:Amulet::1:0:", -- Stygian Bone Amulet
	[6696]="0:5086:2:3:1:Bow::1:0:", -- Nightstalker Bow
	[6697]="0:2041:4:3:1:Cloth::1:0:", -- Batwing Mantle
	[6709]="0:545:4:2:1:Leather::1:0:", -- Moonglow Vest
	[6710]="0:137:9:2:1:Leatherworking::1:0:", -- Pattern: Moonglow Vest
	[6712]="0:12:15:1:1:Junk::1:0:", -- Practice Lock
	[6713]="0:10:4:1:1:Cloth::1:0:", -- Ripped Pants
	[6714]="0:75:7:1:20:Explosive::1:0:", -- Ez-Thro Dynamite
	[6715]="0:21:7:1:1:Device::1:0:", -- Ruined Jumper Cables
	[6716]="0:200:9:2:1:Engineering::1:0:", -- Schematic: EZ-Thro Dynamite
	[6717]="0:0:12:1:20:::1:0:", -- Gaffer Jack
	[6718]="0:0:12:1:20:::1:0:", -- Electropeller
	[6719]="0:1097:4:2:1:Leather::1:0:", -- Windborne Belt
	[6720]="0:3219:4:2:1:Leather::1:0:", -- Spirit Hunter Headdress
	[6721]="0:1419:4:2:1:Mail::1:0:", -- Chestplate of Kor
	[6722]="0:1331:4:2:1:Mail::1:0:", -- Beastial Manacles
	[6723]="0:8155:4:3:1:Amulet::1:0:", -- Medal of Courage
	[6725]="0:6105:4:3:1:Shield::1:0:", -- Marbled Buckler
	[6726]="0:2388:4:2:1:Cloth::1:0:", -- Razzeric's Customized Seatbelt
	[6727]="0:2996:4:2:1:Leather::1:0:", -- Razzeric's Racing Grips
	[6729]="0:7187:2:2:1:Wand::1:0:", -- Fizzle's Zippy Lighter
	[6730]="0:496:4:2:1:Mail::1:0:", -- Ironforge Chain
	[6731]="0:871:4:2:1:Mail::1:0:", -- Ironforge Breastplate
	[6732]="0:2421:4:2:1:Leather::1:0:", -- Gnomish Mechanic's Gloves
	[6733]="0:1145:4:2:1:Mail::1:0:", -- Ironforge Gauntlets
	[6735]="0:150:9:2:1:Blacksmithing::1:0:", -- Plans: Ironforge Breastplate
	[6737]="0:2805:4:2:1:Cloth::1:0:", -- Dryleaf Pants
	[6738]="0:7040:2:2:1:OneHandAxe::1:0:", -- Bleeding Crescent
	[6739]="0:2991:2:2:1:Bow::1:0:", -- Cliffrunner's Aim
	[6740]="0:1001:4:2:1:Leather::1:0:", -- Azure Sash
	[6741]="0:3014:2:1:1:TwoHandSword::1:0:", -- Orcish War Sword
	[6742]="0:2830:4:3:1:Mail::1:0:", -- Stonefist Girdle
	[6743]="0:1462:4:2:1:Ring::1:0:", -- Sustaining Ring
	[6744]="0:1190:4:2:1:Cloth::1:0:", -- Gloves of Kapelan
	[6745]="0:1791:4:2:1:Cloak::1:0:", -- Swiftrunner Cape
	[6746]="0:7076:4:2:1:Shield::1:0:", -- Basalt Buckler
	[6747]="0:5015:4:2:1:Mail::1:0:", -- Enforcer Pauldrons
	[6748]="0:897:4:2:1:Ring::1:0:", -- Monkey Ring
	[6749]="0:897:4:2:1:Ring::1:0:", -- Tiger Band
	[6750]="0:897:4:2:1:Ring::1:0:", -- Snake Hoop
	[6751]="0:1411:4:2:1:Cloak::1:0:", -- Mourning Shawl
	[6752]="0:1602:4:2:1:Leather::1:0:", -- Lancer Boots
	[6753]="0:0:12:1:20:::1:0:", -- Feather Charm
	[6755]="0:0:15:1:1:Junk::1:0:", -- A Small Container of Gems
	[6756]="0:1375:1:1:1:Bag::1:0:", -- Jewelry Box
	[6757]="0:4630:4:2:1:Ring::1:0:", -- Jaina's Signet Ring
	[6767]="0:0:12:1:1:::1:0:", -- Tyranis' Pendant
	[6773]="0:7366:4:2:1:Mail::1:0:", -- Gelkis Marauder Chain
	[6774]="0:2885:4:2:1:OffHandFrill::1:0:", -- Uthek's Finger
	[6776]="0:0:12:1:1:::1:0:", -- Tome of Valor
	[6780]="0:1560:4:2:1:Cloth::1:0:", -- Lilac Sash
	[6781]="0:0:12:1:1:::1:0:", -- Bartleby's Mug
	[6782]="0:0:12:1:1:::1:0:", -- Marshal Haggard's Badge
	[6783]="0:0:13:1:1:::1:0:", -- Dead-tooth's Key
	[6784]="0:2032:4:2:1:Leather::1:0:", -- Braced Handguards
	[6785]="0:0:12:1:1:::1:0:", -- Powers of the Void
	[6786]="0:59:4:1:1:Miscellaneous::1:0:", -- Simple Dress
	[6787]="0:1:4:1:1:Miscellaneous::1:0:", -- White Woolen Dress
	[6788]="0:3331:4:2:1:Leather::1:0:", -- Magram Hunter's Belt
	[6789]="0:4012:4:2:1:Cloak::1:0:", -- Ceremonial Centaur Blanket
	[6790]="0:1540:4:2:1:Ring::1:0:", -- Ring of Calm
	[6791]="0:3464:4:2:1:Cloth::1:0:", -- Hellion Boots
	[6792]="0:4738:4:2:1:Mail::1:0:", -- Sanguine Pauldrons
	[6793]="0:3157:4:2:1:Mail::1:0:", -- Auric Bracers
	[6794]="0:2641:4:2:1:Leather::1:0:", -- Stormfire Gauntlets
	[6795]="0:500:4:1:1:Shirt::1:0:", -- White Swashbuckler's Shirt
	[6796]="0:750:4:1:1:Shirt::1:0:", -- Red Swashbuckler's Shirt
	[6797]="0:6362:2:2:1:Wand::1:0:", -- Eyepoker
	[6798]="0:6386:2:2:1:Gun::1:0:", -- Blasting Hackbut
	[6799]="0:0:12:1:1:::1:0:", -- Vejrek's Head
	[6800]="0:0:12:1:20:::1:0:", -- Umbral Ore
	[6801]="0:4456:4:2:1:Cloth::1:0:", -- Baroque Apron
	[6802]="0:18255:2:3:1:OneHandSword::1:0:", -- Sword of Omen
	[6803]="0:4885:4:3:1:OffHandFrill::1:0:", -- Prophetic Cane
	[6804]="0:8060:2:3:1:OneHandMace::1:0:", -- Windstorm Hammer
	[6805]="0:0:12:1:1:::1:0:", -- Horn of Vorlus
	[6806]="0:10209:2:3:1:Wand::1:0:", -- Dancing Flame
	[6807]="0:62:0:1:20:FoodDrink::1:0:", -- Frog Leg Stew
	[6808]="0:0:12:1:20:::1:0:", -- Elunite Ore
	[6809]="0:0:12:1:1:::1:0:", -- Elura's Medallion
	[6810]="0:0:12:1:1:::1:0:", -- Surena's Choker
	[6811]="0:25:0:1:20:EnhTemp::1:0:", -- Aquadynamic Fish Lens
	[6812]="0:0:12:1:1:::1:0:", -- Case of Elunite
	[6826]="0:548:15:0:10:Junk::1:0:", -- Brilliant Scale
	[6827]="0:150:15:1:1:Junk::1:0:", -- Box of Supplies
	[6828]="0:6268:4:2:1:Shield::1:0:", -- Visionary Buckler
	[6829]="0:18714:2:3:1:OneHandSword::1:0:", -- Sword of Serenity
	[6830]="0:23476:2:3:1:TwoHandAxe::1:0:", -- Bonebiter
	[6831]="0:17522:2:3:1:Dagger::1:0:", -- Black Menace
	[6832]="0:3770:4:2:1:Cloak::1:0:", -- Cloak of Blight
	[6833]="0:0:4:1:1:Shirt::1:0:", -- White Tuxedo Shirt
	[6834]="0:1:4:1:1:Miscellaneous::1:0:", -- Black Tuxedo
	[6835]="0:0:4:1:1:Cloth::1:0:", -- Black Tuxedo Pants
	[6836]="0:1:4:1:1:Cloth::1:0:", -- Dress Shoes
	[6838]="0:0:12:1:20:::1:0:", -- Scorched Spider Fang
	[6839]="0:0:12:1:20:::1:0:", -- Charred Horn
	[6840]="0:0:12:1:20:::1:0:", -- Galvanized Horn
	[6841]="0:0:12:1:1:::1:0:", -- Vial of Phlogiston
	[6842]="0:0:12:1:1:::1:0:", -- Furen's Instructions
	[6843]="0:0:12:1:1:::1:0:", -- Cask of Scalder
	[6844]="0:0:12:1:20:::1:0:", -- Burning Blood
	[6845]="0:0:12:1:20:::1:0:", -- Burning Rock
	[6846]="0:0:12:1:1:::1:0:", -- Defias Script
	[6847]="0:0:12:1:1:::1:0:", -- Dark Iron Script
	[6848]="0:0:12:1:20:::1:0:", -- Searing Coral
	[6849]="0:0:12:1:20:::1:0:", -- Sunscorched Shell
	[6851]="0:0:12:1:1:::1:0:", -- Essence of the Exile
	[6866]="0:0:12:1:1:::1:0:", -- Symbol of Life
	[6887]="0:5:0:1:20:FoodDrink::1:0:", -- Spotted Yellowtail
	[6888]="0:10:0:1:20:FoodDrink::1:0:", -- Herb Baked Egg
	[6889]="0:4:7:1:10:Meat:185:1:0:", -- Small Egg
	[6890]="0:6:0:1:20:FoodDrink::1:0:", -- Smoked Bear Meat
	[6892]="250:62:9:1:1:Cooking::1:0:1465,3556", -- Recipe: Smoked Bear Meat
	[6893]="0:0:13:1:1:::1:0:", -- Workshop Key
	[6894]="0:0:12:1:1:::1:0:", -- Whirlwind Heart
	[6895]="0:0:12:1:1:::1:0:", -- Jordan's Smithing Hammer
	[6898]="0:4132:4:2:1:OffHandFrill::1:0:", -- Orb of Soran'ruk
	[6900]="0:4685:4:3:1:Cloth::1:0:", -- Enchanted Gold Bloodrobe
	[6901]="0:1523:4:3:1:Cloak::1:0:", -- Glowing Thresher Cape
	[6902]="0:1052:4:3:1:Leather::1:0:", -- Bands of Serra'kis
	[6903]="0:1859:4:3:1:Cloth::1:0:", -- Gaze Dreamer Pants
	[6904]="0:4665:2:3:1:Dagger::1:0:", -- Bite of Serra'kis
	[6905]="0:4813:2:3:1:TwoHandAxe::1:0:", -- Reef Axe
	[6906]="0:1275:4:3:1:Mail::1:0:", -- Algae Fists
	[6907]="0:1873:4:3:1:Mail::1:0:", -- Tortoise Armor
	[6908]="0:626:4:3:1:Cloth::1:0:", -- Ghamoo-ra's Bind
	[6909]="0:7155:2:3:1:TwoHandSword::1:0:", -- Strike of the Hydra
	[6910]="0:2298:4:3:1:Cloth::1:0:", -- Leech Pants
	[6911]="0:1442:4:3:1:Leather::1:0:", -- Moss Cinch
	[6912]="0:0:12:1:1:::1:0:", -- Heartswood
	[6913]="0:0:12:1:1:::1:0:", -- Heartswood Core
	[6914]="0:0:12:1:20:::1:0:", -- Soran'ruk Fragment
	[6915]="0:0:12:1:1:::1:0:", -- Large Soran'ruk Fragment
	[6926]="0:0:12:1:1:::1:0:", -- Furen's Notes
	[6927]="0:0:12:1:1:::1:0:", -- Big Will's Ear
	[6928]="0:0:12:1:1:::1:0:", -- Bloodstone Choker
	[6929]="0:0:12:1:1:::1:0:", -- Bath'rah's Parchment
	[6930]="0:0:12:1:20:::1:0:", -- Rod of Channeling
	[6931]="0:0:12:1:1:::1:0:", -- Moldy Tome
	[6947]="25:6:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12097,15175,16268,16683,18006,20121,26568,27031,27038,27053,28347,29535,30239,30244,30306,32639,32641", -- Instant Poison
	[6948]="0:0:15:1:1:Junk::1:0:", -- Hearthstone
	[6949]="50:12:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12097,15175,16268,16683,18006,20121,26568,27031,27038,27053,28347,29535,30239,30244,30306,32639,32641", -- Instant Poison II
	[6950]="150:37:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12097,15175,16268,16683,18006,20121,26568,27031,27038,27053,28347,29535,30239,30244,30306,32639,32641", -- Instant Poison III
	[6951]="0:75:15:0:20:Junk::1:0:", -- Mind-numbing Poison II
	[6952]="0:0:12:1:20:::1:0:", -- Thick Bear Fur
	[6953]="0:7459:2:3:1:TwoHandMace::1:0:", -- Verigan's Fist
	[6966]="0:693:2:2:1:OneHandAxe::1:0:", -- Elunite Axe
	[6967]="0:696:2:2:1:OneHandSword::1:0:", -- Elunite Sword
	[6968]="0:698:2:2:1:OneHandMace::1:0:", -- Elunite Hammer
	[6969]="0:701:2:2:1:Dagger::1:0:", -- Elunite Dagger
	[6970]="0:906:4:2:1:Shield::1:0:", -- Furen's Favor
	[6971]="0:2221:4:2:1:Mail::1:0:", -- Fire Hardened Coif
	[6972]="0:3242:4:3:1:Mail::1:0:", -- Fire Hardened Hauberk
	[6973]="0:2465:4:2:1:Mail::1:0:", -- Fire Hardened Leggings
	[6974]="0:1497:4:2:1:Mail::1:0:", -- Fire Hardened Gauntlets
	[6975]="0:16766:2:3:1:TwoHandAxe::1:0:", -- Whirlwind Axe
	[6976]="0:17264:2:3:1:TwoHandMace::1:0:", -- Whirlwind Warhammer
	[6977]="0:17325:2:3:1:TwoHandSword::1:0:", -- Whirlwind Sword
	[6978]="0:672:2:2:1:OneHandAxe::1:0:", -- Umbral Axe
	[6979]="0:675:2:2:1:OneHandAxe::1:0:", -- Haggard's Axe
	[6980]="0:677:2:2:1:Dagger::1:0:", -- Haggard's Dagger
	[6981]="0:680:2:2:1:Dagger::1:0:", -- Umbral Dagger
	[6982]="0:683:2:2:1:OneHandMace::1:0:", -- Umbral Mace
	[6983]="0:685:2:2:1:OneHandMace::1:0:", -- Haggard's Hammer
	[6984]="0:688:2:2:1:OneHandSword::1:0:", -- Umbral Sword
	[6985]="0:690:2:2:1:OneHandSword::1:0:", -- Haggard's Sword
	[6986]="0:50:15:0:10:Junk::1:0:", -- Crimson Lotus
	[6989]="0:0:12:1:20:::1:0:", -- Vial of Hatefury Blood
	[6990]="0:0:12:1:1:::1:0:", -- Lesser Infernal Stone
	[6991]="0:0:12:1:20:::1:0:", -- Smoldering Coal
	[6992]="0:0:12:1:1:::1:0:", -- Jordan's Ore Shipment
	[6993]="0:0:12:1:1:::1:0:", -- Jordan's Refined Ore Shipment
	[6994]="0:0:12:1:1:::1:0:", -- Whitestone Oak Lumber
	[6995]="0:0:12:1:1:::1:0:", -- Corrupted Kor Gem
	[6996]="0:0:12:1:1:::1:0:", -- Jordan's Weapon Notes
	[6997]="0:0:12:1:1:::1:0:", -- Tattered Manuscript
	[6998]="0:774:4:2:1:Cloth::1:0:", -- Nimbus Boots
	[6999]="0:0:12:1:1:::1:0:", -- Tome of the Cabal
	[7000]="0:650:4:2:1:Leather::1:0:", -- Heartwood Girdle
	[7001]="0:3535:2:3:1:Wand::1:0:", -- Gravestone Scepter
	[7002]="0:3028:4:3:1:Shield::1:0:", -- Arctic Buckler
	[7003]="0:981:4:2:1:Mail::1:0:", -- Beetle Clasps
	[7004]="0:985:4:2:1:Cloak::1:0:", -- Prelacy Cape
	[7005]="82:16:2:1:1:Miscellaneous:202:1:0:66,777,843,989,1148,1250,1286,1465,1692,2118,2225,2697,2698,2699,2810,2816,2819,2821,2846,3005,3081,3168,3187,3366,3367,3482,3499,3556,3614,3779,3954,3955,3958,4194,4225,4229,4561,4589,4775,4897,5128,5135,5163,5565,5783,5817,5944,6301,6731,7852,7854,7947,8145,8160,8363,8934,11189,11874,12022,12028,12043,12245,12941,12942,12943,12956,12957,12958,15179,16224,16261,16262,16613,16689,16748,16768,17486,17490,18009,18277,18426,18427,18754,18771,19196,19244,19372,19450,19532,21085,24843,24935,24995,25010,25019,25051,25082,27021,27026,27037,27043,27057,28692,28718,28798,28831,28872,29288,30311,33601", -- Skinning Knife
	[7006]="0:0:12:1:1:::1:0:", -- Reconstructed Tome
	[7026]="0:22:4:1:1:Cloth::1:0:", -- Linen Belt
	[7027]="0:1125:4:2:1:Cloth::1:0:", -- Boots of Darkness
	[7046]="0:1494:4:2:1:Cloth::1:0:", -- Azure Silk Pants
	[7047]="0:825:4:2:1:Cloth::1:0:", -- Hands of Darkness
	[7048]="0:1242:4:2:1:Cloth::1:0:", -- Azure Silk Hood
	[7049]="0:914:4:2:1:Cloth::1:0:", -- Truefaith Gloves
	[7050]="0:1665:4:2:1:Cloth::1:0:", -- Silk Headband
	[7051]="0:2696:4:2:1:Cloth::1:0:", -- Earthen Vest
	[7052]="0:1488:4:2:1:Cloth::1:0:", -- Azure Silk Belt
	[7053]="0:2240:4:2:1:Cloak::1:0:", -- Azure Silk Cloak
	[7054]="0:4701:4:3:1:Cloth::1:0:", -- Robe of Power
	[7055]="0:1504:4:2:1:Cloth::1:0:", -- Crimson Silk Belt
	[7056]="0:2314:4:2:1:Cloak::1:0:", -- Crimson Silk Cloak
	[7057]="0:2323:4:2:1:Cloth::1:0:", -- Green Silken Shoulders
	[7058]="0:2827:4:2:1:Cloth::1:0:", -- Crimson Silk Vest
	[7059]="0:2781:4:2:1:Cloth::1:0:", -- Crimson Silk Shoulders
	[7060]="0:2791:4:2:1:Cloth::1:0:", -- Azure Shoulders
	[7061]="0:2017:4:2:1:Cloth::1:0:", -- Earthen Silk Belt
	[7062]="0:4050:4:2:1:Cloth::1:0:", -- Crimson Silk Pantaloons
	[7063]="0:4741:4:2:1:Cloth::1:0:", -- Crimson Silk Robe
	[7064]="0:2569:4:2:1:Cloth::1:0:", -- Crimson Silk Gloves
	[7065]="0:2398:4:2:1:Cloth::1:0:", -- Green Silk Armor
	[7067]="0:400:7:1:10:Elemental:171,164,333,202,755,165,197:1:0:", -- Elemental Earth
	[7068]="0:400:7:1:10:Elemental:171,164,333,202,197:1:0:", -- Elemental Fire
	[7069]="0:400:7:1:10:Elemental:164,202,197:1:0:", -- Elemental Air
	[7070]="0:400:7:1:10:Elemental:171,164,755,165,197:1:0:", -- Elemental Water
	[7071]="0:100:7:1:5:Part:165,197:1:0:", -- Iron Buckle
	[7072]="0:150:7:1:10:Other:197:1:0:", -- Naga Scale
	[7073]="0:6:15:0:5:Junk::1:0:", -- Broken Fang
	[7074]="0:4:15:0:5:Junk::1:0:", -- Chipped Claw
	[7075]="0:400:7:1:10:Elemental:164,333,202,755,165:1:0:", -- Core of Earth
	[7076]="0:400:7:2:10:Elemental:171,164,333,202,755,165,197:1:0:", -- Essence of Earth
	[7077]="0:400:7:1:10:Elemental:171,164,333,202,755,165,197:1:0:", -- Heart of Fire
	[7078]="0:400:7:2:10:Elemental:171,164,333,202,755,165,197:1:0:", -- Essence of Fire
	[7079]="0:400:7:1:10:Elemental:333,202,755,165,197:1:0:", -- Globe of Water
	[7080]="0:400:7:2:10:Elemental:171,164,333,202,165,197:1:0:", -- Essence of Water
	[7081]="0:400:7:1:10:Elemental:164,333,755,165:1:0:", -- Breath of Wind
	[7082]="0:400:7:2:10:Elemental:171,333,202,755,165,197:1:0:", -- Essence of Air
	[7083]="0:0:12:1:1:::1:0:", -- Purified Kor Gem
	[7084]="0:350:9:2:1:Tailoring::1:0:", -- Pattern: Crimson Silk Shoulders
	[7085]="0:350:9:2:1:Tailoring::1:0:", -- Pattern: Azure Shoulders
	[7086]="0:375:9:2:1:Tailoring::1:0:", -- Pattern: Earthen Silk Belt
	[7087]="1200:300:9:1:1:Tailoring::1:1:2670", -- Pattern: Crimson Silk Cloak
	[7088]="5000:1250:9:1:1:Tailoring::1:1:6568", -- Pattern: Crimson Silk Robe
	[7089]="1500:375:9:1:1:Tailoring::1:1:6574,6576", -- Pattern: Azure Silk Cloak
	[7090]="0:250:9:2:1:Tailoring::1:0:", -- Pattern: Green Silk Armor
	[7091]="0:250:9:2:1:Tailoring::1:0:", -- Pattern: Truefaith Gloves
	[7092]="0:250:9:2:1:Tailoring::1:0:", -- Pattern: Hands of Darkness
	[7094]="0:174:2:1:1:Stave::1:0:", -- Driftwood Branch
	[7095]="0:32:4:1:1:Cloth::1:0:", -- Bog Boots
	[7096]="0:5:15:0:5:Junk::1:0:", -- Plucked Feather
	[7097]="0:1:0:1:20:FoodDrink::1:0:", -- Leg Meat
	[7098]="0:6:15:0:5:Junk::1:0:", -- Splintered Tusk
	[7099]="0:6:15:0:5:Junk::1:0:", -- Severed Pincer
	[7100]="0:7:15:0:5:Junk::1:0:", -- Sticky Ichor
	[7101]="0:5:15:0:5:Junk::1:0:", -- Bug Eye
	[7106]="0:1234:4:2:1:Cloth::1:0:", -- Zodiac Gloves
	[7107]="0:1858:4:2:1:Mail::1:0:", -- Belt of the Stars
	[7108]="0:209:4:2:1:Shield::1:0:", -- Infantry Shield
	[7109]="0:74:4:1:1:Shield::1:0:", -- Pioneer Buckler
	[7110]="0:2070:4:2:1:Cloth::1:0:", -- Silver-thread Armor
	[7111]="0:3329:4:2:1:Cloth::1:0:", -- Nightsky Armor
	[7112]="0:4547:4:2:1:Cloth::1:0:", -- Aurora Armor
	[7113]="0:6707:4:2:1:Cloth::1:0:", -- Mistscape Armor
	[7114]="1000:250:9:1:1:Tailoring::1:1:2679,9636", -- Pattern: Azure Silk Gloves
	[7115]="0:683:2:2:1:OneHandAxe::1:0:", -- Heirloom Axe
	[7116]="0:685:2:2:1:Dagger::1:0:", -- Heirloom Dagger
	[7117]="0:688:2:2:1:OneHandMace::1:0:", -- Heirloom Hammer
	[7118]="0:690:2:2:1:OneHandSword::1:0:", -- Heirloom Sword
	[7119]="0:0:12:1:1:::1:0:", -- Twitching Antenna
	[7120]="0:896:4:2:1:Shield::1:0:", -- Ruga's Bulwark
	[7126]="0:0:12:1:20:::1:0:", -- Smoky Iron Ingot
	[7127]="0:0:12:1:20:::1:0:", -- Powdered Azurite
	[7128]="0:0:12:1:20:::1:0:", -- Uncloven Satyr Hoof
	[7129]="0:1546:4:2:1:Mail::1:0:", -- Brutal Gauntlets
	[7130]="0:2328:4:2:1:Mail::1:0:", -- Brutal Helm
	[7131]="0:0:12:1:20:::1:0:", -- Dragonmaw Shinbone
	[7132]="0:2338:4:2:1:Mail::1:0:", -- Brutal Legguards
	[7133]="0:3098:4:3:1:Mail::1:0:", -- Brutal Hauberk
	[7134]="0:0:12:1:20:::1:0:", -- Sturdy Dragonmaw Shinbone
	[7135]="0:0:12:0:20:::1:0:", -- Broken Dragonmaw Shinbone
	[7146]="0:0:13:2:1:::1:0:", -- The Scarlet Key
	[7148]="0:21:7:1:1:Device::1:0:", -- Goblin Jumper Cables
	[7166]="0:194:2:1:1:Dagger::1:0:", -- Copper Dagger
	[7189]="0:4712:4:2:1:Cloth::1:0:", -- Goblin Rocket Boots
	[7190]="0:0:15:0:1:Junk::1:0:", -- Scorched Rocket Boots
	[7191]="0:0:7:1:5:Part:202:1:0:", -- Fused Wiring
	[7192]="0:300:9:2:1:Engineering::1:0:", -- Plans: Goblin Rocket Boots
	[7206]="0:0:12:1:1:::1:0:", -- Mirror Lake Water Sample
	[7207]="0:0:12:1:1:::1:0:", -- Jennea's Flask
	[7208]="0:0:13:1:1:::1:0:", -- Tazan's Key
	[7209]="0:0:15:1:1:Junk::1:0:", -- Tazan's Satchel
	[7226]="0:0:12:1:1:::1:0:", -- Mage-tastic Gizmonitor
	[7227]="0:0:12:1:1:::1:0:", -- Balnir Snapdragons
	[7228]="500:25:0:1:20:FoodDrink::5:0:6496,14480,14481,15353,15354,18913,18914,24934", -- Tigule and Foror's Strawberry Ice Cream
	[7229]="0:285:4:2:1:Mail::1:0:", -- Explorer's Vest
	[7230]="0:3103:2:3:1:TwoHandMace::1:0:", -- Smite's Mighty Hammer
	[7231]="0:0:12:1:1:::1:0:", -- Astor's Letter of Introduction
	[7247]="0:0:15:1:1:Junk::1:0:", -- Chest of Containment Coffers
	[7249]="0:0:12:1:20:::1:0:", -- Charged Rift Gem
	[7266]="0:0:12:1:1:::1:0:", -- Ur's Treatise on Shadow Magic
	[7267]="0:0:12:1:20:::1:0:", -- Pristine Spider Silk
	[7268]="0:0:12:1:1:::1:0:", -- Xavian Water Sample
	[7269]="0:0:12:1:1:::1:0:", -- Deino's Flask
	[7270]="0:0:12:1:20:::1:0:", -- Laughing Sister's Hair
	[7271]="0:0:12:1:20:::1:0:", -- Flawless Ivory Tusk
	[7272]="0:0:12:1:1:::1:0:", -- Bolt Charged Bramble
	[7273]="0:0:12:1:20:::1:0:", -- Witherbark Totem Stick
	[7274]="0:0:12:1:1:::1:0:", -- Rituals of Power
	[7276]="0:34:4:1:1:Cloak::1:0:", -- Handstitched Leather Cloak
	[7277]="0:28:4:1:1:Leather::1:0:", -- Handstitched Leather Bracers
	[7278]="0:25:11:1:1:Quiver::1:0:", -- Light Leather Quiver
	[7279]="0:25:11:1:1:AmmoPouch::1:0:", -- Small Leather Ammo Pouch
	[7280]="0:162:4:2:1:Leather::1:0:", -- Rugged Leather Pants
	[7281]="0:142:4:2:1:Leather::1:0:", -- Light Leather Bracers
	[7282]="0:599:4:2:1:Leather::1:0:", -- Light Leather Pants
	[7283]="0:415:4:2:1:Cloak::1:0:", -- Black Whelp Cloak
	[7284]="0:586:4:2:1:Leather::1:0:", -- Red Whelp Gloves
	[7285]="0:589:4:2:1:Leather::1:0:", -- Nimble Leather Gloves
	[7286]="0:25:7:1:10:Leather:165:1:0:", -- Black Whelp Scale
	[7287]="0:100:15:1:5:Junk:165:1:0:", -- Red Whelp Scale
	[7288]="0:125:9:2:1:Leatherworking::1:0:", -- Pattern: Rugged Leather Pants
	[7289]="650:162:9:1:1:Leatherworking::1:1:2697", -- Pattern: Black Whelp Cloak
	[7290]="1600:400:9:1:1:Leatherworking::1:1:2679", -- Pattern: Red Whelp Gloves
	[7291]="0:0:12:1:1:::1:0:", -- Infernal Orb
	[7292]="0:0:12:1:20:::1:0:", -- Filled Containment Coffer
	[7293]="0:0:12:1:20:::1:0:", -- Dalaran Mana Gem
	[7294]="0:0:12:1:1:::1:0:", -- Andron's Ledger
	[7295]="0:0:12:1:1:::1:0:", -- Tazan's Logbook
	[7296]="0:56:15:0:5:Junk::1:0:", -- Extinguished Torch
	[7297]="0:0:4:1:1:OffHandFrill::1:0:", -- Morbent's Bane
	[7298]="0:469:2:2:1:Dagger::1:0:", -- Blade of Cunning
	[7306]="0:0:12:1:1:::1:0:", -- Fenwick's Head
	[7307]="0:62:0:1:20:EnhTemp::1:0:", -- Flesh Eating Worm
	[7308]="0:0:12:1:1:::1:0:", -- Cantation of Manifestation
	[7309]="0:0:12:1:1:::1:0:", -- Dalaran Status Report
	[7326]="0:696:2:2:1:OneHandAxe::1:0:", -- Thun'grim's Axe
	[7327]="0:698:2:2:1:Dagger::1:0:", -- Thun'grim's Dagger
	[7328]="0:701:2:2:1:OneHandMace::1:0:", -- Thun'grim's Mace
	[7329]="0:703:2:2:1:OneHandSword::1:0:", -- Thun'grim's Sword
	[7330]="0:3923:4:2:1:Shield::1:0:", -- Infiltrator Buckler
	[7331]="0:4330:4:2:1:Shield::1:0:", -- Phalanx Shield
	[7332]="0:6692:4:2:1:Cloth::1:0:", -- Regal Armor
	[7333]="0:0:12:1:1:::1:0:", -- Overseer's Whistle
	[7334]="0:1544:4:2:1:Cloth::1:0:", -- Efflorescent Robe
	[7335]="0:1937:4:2:1:Leather::1:0:", -- Grizzly Tunic
	[7336]="0:1509:4:2:1:Mail::1:0:", -- Wildwood Chain
	[7337]="1000000:250000:4:1:1:Ring::1:0:2849,16624,17512", -- The Rock
	[7338]="10000:2500:4:1:1:Ring::1:0:2849,16624,17512", -- Mood Ring
	[7339]="250000:62500:4:1:1:Ring::1:0:2849,16624,17512", -- Miniscule Diamond Ring
	[7340]="500000:125000:4:1:1:Ring::1:0:2849,16624,17512", -- Flawless Diamond Solitaire
	[7341]="50000:12500:4:1:1:Ring::1:0:2849,16624,17512", -- Cubic Zirconia Ring
	[7342]="100000:25000:4:1:1:Ring::1:0:2849,16624,17512", -- Silver Piffeny Band
	[7343]="0:0:12:1:1:::1:0:", -- Bingles' Wrench
	[7344]="0:5000:4:2:1:OffHandFrill::1:0:", -- Torch of Holy Flame
	[7345]="0:0:12:1:1:::1:0:", -- Bingles' Screwdriver
	[7346]="0:0:12:1:1:::1:0:", -- Bingles' Hammer
	[7348]="0:829:4:3:1:Leather::1:0:", -- Fletcher's Gloves
	[7349]="0:861:4:2:1:Leather::1:0:", -- Herbalist's Gloves
	[7350]="0:29:4:1:1:Cloth::1:0:", -- Disciple's Bracers
	[7351]="0:58:4:1:1:Cloth::1:0:", -- Disciple's Boots
	[7352]="0:1306:4:2:1:Leather::1:0:", -- Earthen Leather Shoulders
	[7353]="0:2998:4:2:1:Cloth::1:0:", -- Elder's Padded Armor
	[7354]="0:1865:4:2:1:Cloth::1:0:", -- Elder's Boots
	[7355]="0:1031:4:2:1:Cloth::1:0:", -- Elder's Bracers
	[7356]="0:1411:4:2:1:Cloak::1:0:", -- Elder's Cloak
	[7357]="0:1875:4:2:1:Cloth::1:0:", -- Elder's Hat
	[7358]="0:885:4:2:1:Leather::1:0:", -- Pilferer's Gloves
	[7359]="0:978:4:2:1:Leather::1:0:", -- Heavy Earthen Gloves
	[7360]="0:400:9:2:1:Leatherworking::1:0:", -- Pattern: Dark Leather Gloves
	[7361]="1800:450:9:2:1:Leatherworking::1:1:6731", -- Pattern: Herbalist's Gloves
	[7362]="2000:500:9:1:1:Leatherworking::1:1:3537", -- Pattern: Earthen Leather Shoulders
	[7363]="0:525:9:2:1:Leatherworking::1:0:", -- Pattern: Pilferer's Gloves
	[7364]="0:550:9:2:1:Leatherworking::1:0:", -- Pattern: Heavy Earthen Gloves
	[7365]="0:0:12:1:1:::1:0:", -- Gnoam Sprecklesprocket
	[7366]="0:1098:4:2:1:Cloth::1:0:", -- Elder's Gloves
	[7367]="0:1818:4:2:1:Cloth::1:0:", -- Elder's Mantle
	[7368]="0:2677:4:2:1:Cloth::1:0:", -- Elder's Pants
	[7369]="0:2955:4:2:1:Cloth::1:0:", -- Elder's Robe
	[7370]="0:1012:4:2:1:Cloth::1:0:", -- Elder's Sash
	[7371]="2000:500:11:2:1:Quiver::1:0:1287,4602,7976,16715,16919,17667", -- Heavy Quiver
	[7372]="0:500:11:2:1:AmmoPouch::1:0:", -- Heavy Leather Ammo Pouch
	[7373]="0:3097:4:2:1:Leather::1:0:", -- Dusky Leather Leggings
	[7374]="0:3760:4:2:1:Leather::1:0:", -- Dusky Leather Armor
	[7375]="0:3774:4:2:1:Leather::1:0:", -- Green Whelp Armor
	[7376]="0:0:12:1:1:::1:0:", -- Bingles' Blastencapper
	[7377]="0:2269:4:2:1:Cloak::1:0:", -- Frost Leather Cloak
	[7378]="0:2146:4:2:1:Leather::1:0:", -- Dusky Bracers
	[7386]="0:2387:4:2:1:Leather::1:0:", -- Green Whelp Bracers
	[7387]="0:2587:4:2:1:Leather:202:1:0:", -- Dusky Belt
	[7389]="0:0:12:1:1:::1:0:", -- Venture Co. Ledger
	[7390]="0:4237:4:2:1:Leather::1:0:", -- Dusky Boots
	[7391]="0:4253:4:2:1:Leather::1:0:", -- Swift Boots
	[7392]="0:200:7:1:5:Leather:333,165:1:0:", -- Green Whelp Scale
	[7406]="0:1372:4:2:1:Leather::1:0:", -- Infiltrator Cord
	[7407]="0:3666:4:2:1:Leather::1:0:", -- Infiltrator Armor
	[7408]="0:2281:4:2:1:Leather::1:0:", -- Infiltrator Shoulders
	[7409]="0:2289:4:2:1:Leather::1:0:", -- Infiltrator Boots
	[7410]="0:1174:4:2:1:Leather::1:0:", -- Infiltrator Bracers
	[7411]="0:1415:4:2:1:Cloak::1:0:", -- Infiltrator Cloak
	[7412]="0:1302:4:2:1:Leather::1:0:", -- Infiltrator Gloves
	[7413]="0:2157:4:2:1:Leather::1:0:", -- Infiltrator Cap
	[7414]="0:3176:4:2:1:Leather::1:0:", -- Infiltrator Pants
	[7415]="0:1484:4:2:1:Leather::1:0:", -- Dervish Spaulders
	[7416]="0:1442:4:2:1:Mail::1:0:", -- Phalanx Bracers
	[7417]="0:2903:4:2:1:Mail::1:0:", -- Phalanx Boots
	[7418]="0:4256:4:2:1:Mail::1:0:", -- Phalanx Breastplate
	[7419]="0:1326:4:2:1:Cloak::1:0:", -- Phalanx Cloak
	[7420]="0:2658:4:2:1:Mail::1:0:", -- Phalanx Headguard
	[7421]="0:1778:4:2:1:Mail::1:0:", -- Phalanx Gauntlets
	[7422]="0:1622:4:2:1:Mail::1:0:", -- Phalanx Girdle
	[7423]="0:3941:4:2:1:Mail::1:0:", -- Phalanx Leggings
	[7424]="0:2709:4:2:1:Mail::1:0:", -- Phalanx Spaulders
	[7428]="0:2500:15:0:10:Junk::1:0:", -- Shadowcat Hide
	[7429]="0:4620:4:2:1:Cloth::1:0:", -- Twilight Armor
	[7430]="0:4194:4:2:1:Cloth::1:0:", -- Twilight Robe
	[7431]="0:3899:4:2:1:Cloth::1:0:", -- Twilight Pants
	[7432]="0:2718:4:2:1:Cloth::1:0:", -- Twilight Cowl
	[7433]="0:1684:4:2:1:Cloth::1:0:", -- Twilight Gloves
	[7434]="0:2536:4:2:1:Cloth::1:0:", -- Twilight Boots
	[7435]="0:2749:4:2:1:Cloth::1:0:", -- Twilight Mantle
	[7436]="0:2111:4:2:1:Cloak::1:0:", -- Twilight Cape
	[7437]="0:1554:4:2:1:Cloth::1:0:", -- Twilight Cuffs
	[7438]="0:1560:4:2:1:Cloth::1:0:", -- Twilight Belt
	[7439]="0:5425:4:2:1:Leather::1:0:", -- Sentinel Breastplate
	[7440]="0:5042:4:2:1:Leather::1:0:", -- Sentinel Trousers
	[7441]="0:3514:4:2:1:Leather::1:0:", -- Sentinel Cap
	[7442]="0:0:12:1:1:::1:0:", -- Gyromast's Key
	[7443]="0:2243:4:2:1:Leather::1:0:", -- Sentinel Gloves
	[7444]="0:3377:4:2:1:Leather::1:0:", -- Sentinel Boots
	[7445]="0:3660:4:2:1:Leather::1:0:", -- Sentinel Shoulders
	[7446]="0:2474:4:2:1:Cloak::1:0:", -- Sentinel Cloak
	[7447]="0:2068:4:2:1:Leather::1:0:", -- Sentinel Bracers
	[7448]="0:2076:4:2:1:Leather::1:0:", -- Sentinel Girdle
	[7449]="0:625:9:2:1:Leatherworking::1:0:", -- Pattern: Dusky Leather Leggings
	[7450]="0:500:9:2:1:Leatherworking::1:0:", -- Pattern: Green Whelp Armor
	[7451]="2800:700:9:2:1:Leatherworking::1:1:4225,4589,7852,7854", -- Pattern: Green Whelp Bracers
	[7452]="0:875:9:3:1:Leatherworking::1:0:", -- Pattern: Dusky Boots
	[7453]="0:875:9:2:1:Leatherworking::1:0:", -- Pattern: Swift Boots
	[7454]="0:5915:4:2:1:Mail::1:0:", -- Knight's Breastplate
	[7455]="0:5937:4:2:1:Mail::1:0:", -- Knight's Legguards
	[7456]="0:4139:4:2:1:Mail::1:0:", -- Knight's Headguard
	[7457]="0:2564:4:2:1:Mail::1:0:", -- Knight's Gauntlets
	[7458]="0:3983:4:2:1:Mail::1:0:", -- Knight's Boots
	[7459]="0:4317:4:2:1:Mail::1:0:", -- Knight's Pauldrons
	[7460]="0:2000:4:2:1:Cloak::1:0:", -- Knight's Cloak
	[7461]="0:2429:4:2:1:Mail::1:0:", -- Knight's Bracers
	[7462]="0:2682:4:2:1:Mail::1:0:", -- Knight's Girdle
	[7463]="0:6202:4:2:1:Shield::1:0:", -- Sentinel Buckler
	[7464]="0:0:12:1:1:::1:0:", -- Glyphs of Summoning
	[7465]="0:6747:4:2:1:Shield::1:0:", -- Knight's Crest
	[7468]="0:6763:4:2:1:Cloth::1:0:", -- Regal Robe
	[7469]="0:6284:4:2:1:Cloth::1:0:", -- Regal Leggings
	[7470]="0:3668:4:2:1:Cloth::1:0:", -- Regal Wizard Hat
	[7471]="0:2455:4:2:1:Cloth::1:0:", -- Regal Gloves
	[7472]="0:3423:4:2:1:Cloth::1:0:", -- Regal Boots
	[7473]="0:3710:4:2:1:Cloth::1:0:", -- Regal Mantle
	[7474]="0:3281:4:2:1:Cloak::1:0:", -- Regal Cloak
	[7475]="0:2371:4:2:1:Cloth::1:0:", -- Regal Cuffs
	[7476]="0:2203:4:2:1:Cloth::1:0:", -- Regal Sash
	[7477]="0:8125:4:2:1:Leather::1:0:", -- Ranger Tunic
	[7478]="0:6991:4:2:1:Leather::1:0:", -- Ranger Leggings
	[7479]="0:4873:4:2:1:Leather::1:0:", -- Ranger Helm
	[7480]="0:3019:4:2:1:Leather::1:0:", -- Ranger Gloves
	[7481]="0:4908:4:2:1:Leather::1:0:", -- Ranger Boots
	[7482]="0:4926:4:2:1:Leather::1:0:", -- Ranger Shoulders
	[7483]="0:3390:4:2:1:Cloak::1:0:", -- Ranger Cloak
	[7484]="0:3062:4:2:1:Leather::1:0:", -- Ranger Wristguards
	[7485]="0:3073:4:2:1:Leather::1:0:", -- Ranger Cord
	[7486]="0:9325:4:2:1:Mail::1:0:", -- Captain's Breastplate
	[7487]="0:8665:4:2:1:Mail::1:0:", -- Captain's Leggings
	[7488]="0:6038:4:2:1:Mail::1:0:", -- Captain's Circlet
	[7489]="0:3740:4:2:1:Mail::1:0:", -- Captain's Gauntlets
	[7490]="0:5680:4:2:1:Mail::1:0:", -- Captain's Boots
	[7491]="0:6158:4:2:1:Mail::1:0:", -- Captain's Shoulderguards
	[7492]="0:3015:4:2:1:Cloak::1:0:", -- Captain's Cloak
	[7493]="0:3268:4:2:1:Mail::1:0:", -- Captain's Bracers
	[7494]="0:3543:4:2:1:Mail::1:0:", -- Captain's Waistguard
	[7495]="0:9558:4:2:1:Shield::1:0:", -- Captain's Buckler
	[7496]="0:8882:4:2:1:Shield::1:0:", -- Field Plate Shield
	[7498]="0:0:12:1:1:::1:0:", -- Top of Gelkak's Key
	[7499]="0:0:12:1:1:::1:0:", -- Middle of Gelkak's Key
	[7500]="0:0:12:1:1:::1:0:", -- Bottom of Gelkak's Key
	[7506]="0:500:4:2:1:Trinket::1:0:", -- Gnomish Universal Remote
	[7507]="0:400:4:2:1:OffHandFrill::1:0:", -- Arcane Orb
	[7508]="0:400:4:2:1:OffHandFrill::1:0:", -- Ley Orb
	[7509]="0:553:4:2:1:Cloth::1:0:", -- Manaweave Robe
	[7510]="0:556:4:2:1:Cloth::1:0:", -- Lesser Spellfire Robes
	[7511]="0:1938:4:2:1:Cloth::1:0:", -- Astral Knot Robe
	[7512]="0:1945:4:2:1:Cloth::1:0:", -- Nether-lace Robe
	[7513]="0:9805:2:3:1:Wand::1:0:", -- Ragefire Wand
	[7514]="0:9842:2:3:1:Wand::1:0:", -- Icefury Wand
	[7515]="0:5382:4:3:1:OffHandFrill::1:0:", -- Celestial Orb
	[7516]="0:0:15:1:1:Junk::1:0:", -- Tabetha's Instructions
	[7517]="0:9372:4:2:1:Cloth::1:0:", -- Gossamer Tunic
	[7518]="0:9406:4:2:1:Cloth::1:0:", -- Gossamer Robe
	[7519]="0:7635:4:2:1:Cloth::1:0:", -- Gossamer Pants
	[7520]="0:5747:4:2:1:Cloth::1:0:", -- Gossamer Headpiece
	[7521]="0:3560:4:2:1:Cloth::1:0:", -- Gossamer Gloves
	[7522]="0:4963:4:2:1:Cloth::1:0:", -- Gossamer Boots
	[7523]="0:4993:4:2:1:Cloth::1:0:", -- Gossamer Shoulderpads
	[7524]="0:4297:4:2:1:Cloak::1:0:", -- Gossamer Cape
	[7525]="0:3106:4:2:1:Cloth::1:0:", -- Gossamer Bracers
	[7526]="0:3367:4:2:1:Cloth::1:0:", -- Gossamer Belt
	[7527]="0:11284:4:2:1:Leather::1:0:", -- Cabalist Chestpiece
	[7528]="0:9894:4:2:1:Leather::1:0:", -- Cabalist Leggings
	[7529]="0:6897:4:2:1:Leather::1:0:", -- Cabalist Helm
	[7530]="0:4273:4:2:1:Leather::1:0:", -- Cabalist Gloves
	[7531]="0:6434:4:2:1:Leather::1:0:", -- Cabalist Boots
	[7532]="0:6975:4:2:1:Leather::1:0:", -- Cabalist Spaulders
	[7533]="0:4446:4:2:1:Cloak::1:0:", -- Cabalist Cloak
	[7534]="0:4016:4:2:1:Leather::1:0:", -- Cabalist Bracers
	[7535]="0:4353:4:2:1:Leather::1:0:", -- Cabalist Belt
	[7536]="0:13048:4:2:1:Shield::1:0:", -- Champion's Wall Shield
	[7537]="0:14012:4:2:1:Shield::1:0:", -- Gothic Shield
	[7538]="0:12322:4:2:1:Mail::1:0:", -- Champion's Armor
	[7539]="0:12692:4:2:1:Mail::1:0:", -- Champion's Leggings
	[7540]="0:8845:4:2:1:Mail::1:0:", -- Champion's Helmet
	[7541]="0:5479:4:2:1:Mail::1:0:", -- Champion's Gauntlets
	[7542]="0:8284:4:2:1:Mail::1:0:", -- Champion's Greaves
	[7543]="0:8123:4:2:1:Mail::1:0:", -- Champion's Pauldrons
	[7544]="0:4296:4:2:1:Cloak::1:0:", -- Champion's Cape
	[7545]="0:4658:4:2:1:Mail::1:0:", -- Champion's Bracers
	[7546]="0:5050:4:2:1:Mail::1:0:", -- Champion's Girdle
	[7549]="0:6420:4:2:1:Amulet::1:0:", -- Fairy's Embrace
	[7551]="0:7145:4:2:1:Amulet::1:0:", -- Entwined Opaline Talisman
	[7552]="0:2542:4:2:1:Ring::1:0:", -- Falcon's Hook
	[7553]="0:2542:4:2:1:Ring::1:0:", -- Band of the Unicorn
	[7554]="0:1039:4:2:1:OffHandFrill::1:0:", -- Willow Branch
	[7555]="0:7123:4:2:1:OffHandFrill::1:0:", -- Regal Star
	[7556]="0:5387:4:2:1:OffHandFrill::1:0:", -- Twilight Orb
	[7557]="0:7596:4:2:1:OffHandFrill::1:0:", -- Gossamer Rod
	[7558]="0:1609:4:2:1:OffHandFrill::1:0:", -- Shimmering Stave
	[7559]="0:666:4:2:1:OffHandFrill::1:0:", -- Runic Cane
	[7560]="1200:300:9:1:1:Engineering::1:1:5175,6730", -- Schematic: Gnomish Universal Remote
	[7561]="2000:500:9:1:1:Engineering::1:1:3134,3537,4086", -- Schematic: Goblin Jumper Cables
	[7566]="0:0:12:1:1:::1:0:", -- Agamand Family Sword
	[7567]="0:0:12:1:1:::1:0:", -- Agamand Family Axe
	[7568]="0:0:12:1:1:::1:0:", -- Agamand Family Dagger
	[7569]="0:0:12:1:1:::1:0:", -- Agamand Family Mace
	[7586]="0:0:12:1:1:::1:0:", -- Tharnariun's Hope
	[7587]="0:0:12:1:1:::1:0:", -- Thun'grim's Instructions
	[7606]="0:557:4:2:1:Mail::1:0:", -- Polar Gauntlets
	[7607]="0:1399:2:2:1:Wand::1:0:", -- Sable Wand
	[7608]="0:1106:4:2:1:OffHandFrill::1:0:", -- Seer's Fine Stein
	[7609]="0:4210:4:2:1:OffHandFrill::1:0:", -- Elder's Amber Stave
	[7610]="0:5811:4:2:1:OffHandFrill::1:0:", -- Aurora Sphere
	[7611]="0:7364:4:2:1:OffHandFrill::1:0:", -- Mistscape Stave
	[7613]="2000:500:9:1:1:Leatherworking::1:1:2679,2698", -- Pattern: Green Leather Armor
	[7626]="0:0:12:1:1:::1:0:", -- Bundle of Furs
	[7627]="0:0:12:1:1:::1:0:", -- Dolanaar Delivery
	[7628]="0:0:12:1:1:::1:0:", -- Nondescript Letter
	[7629]="0:0:12:1:1:::1:0:", -- Ukor's Burden
	[7646]="0:0:12:1:1:::1:0:", -- Crate of Inn Supplies
	[7666]="0:0:12:2:1:::1:0:", -- Shattered Necklace
	[7667]="0:0:12:1:1:::1:0:", -- Talvash's Phial of Scrying
	[7668]="0:0:15:1:1:Junk::1:0:", -- Bloodstained Journal
	[7669]="0:0:12:1:1:::1:0:", -- Shattered Necklace Ruby
	[7670]="0:0:12:1:1:::1:0:", -- Shattered Necklace Sapphire
	[7671]="0:0:12:1:1:::1:0:", -- Shattered Necklace Topaz
	[7672]="0:0:12:1:1:::1:0:", -- Shattered Necklace Power Source
	[7673]="0:8990:4:3:1:Amulet::1:0:", -- Talvash's Enhancing Necklace
	[7674]="0:0:12:1:1:::1:0:", -- Delivery to Mathias
	[7675]="0:0:12:1:1:::1:0:", -- Defias Shipping Schedule
	[7676]="0:30:0:1:10:FoodDrink::1:0:", -- Thistle Tea
	[7678]="0:50:9:1:1:Cooking::1:0:", -- Recipe: Thistle Tea
	[7679]="0:0:12:1:20:::1:0:", -- Shrike Bat Fang
	[7680]="0:0:12:1:20:::1:0:", -- Jadespine Basilisk Scale
	[7682]="0:7678:2:3:1:Dagger::1:0:", -- Torturing Poker
	[7683]="0:7916:2:3:1:FistWeapon::1:0:", -- Bloody Brass Knuckles
	[7684]="0:2621:4:3:1:Cloth::1:0:", -- Bloodmage Mantle
	[7685]="0:5468:4:3:1:OffHandFrill::1:0:", -- Orb of the Forgotten Seer
	[7686]="0:4308:4:3:1:Ring::1:0:", -- Ironspine's Eye
	[7687]="0:8836:2:3:1:OneHandMace::1:0:", -- Ironspine's Fist
	[7688]="0:5320:4:3:1:Mail::1:0:", -- Ironspine's Ribcage
	[7689]="0:11124:2:3:1:TwoHandSword::1:0:", -- Morbid Dawn
	[7690]="0:2232:4:3:1:Leather::1:0:", -- Ebon Vise
	[7691]="0:2689:4:3:1:Cloth::1:0:", -- Embalmed Shroud
	[7708]="0:6649:2:3:1:Wand::1:0:", -- Necrotic Wand
	[7709]="0:3559:4:3:1:Cloth::1:0:", -- Blighted Leggings
	[7710]="0:12279:2:3:1:Stave::1:0:", -- Loksey's Training Stick
	[7711]="0:1405:4:3:1:Cloth::1:0:", -- Robe of Doan
	[7712]="0:1057:4:3:1:Cloth::1:0:", -- Mantle of Doan
	[7713]="0:4777:2:3:1:Stave::1:0:", -- Illusionary Rod
	[7714]="0:3835:2:3:1:Dagger::1:0:", -- Hypnotic Blade
	[7715]="0:0:12:1:1:::1:0:", -- Onin's Report
	[7717]="0:18923:2:3:1:TwoHandAxe::1:0:", -- Ravager
	[7718]="0:6867:4:3:1:Mail::1:0:", -- Herod's Shoulder
	[7719]="0:6863:4:3:1:Mail::1:0:", -- Raging Berserker's Helm
	[7720]="0:5356:4:3:1:Cloth::1:0:", -- Whitemane's Chapeau
	[7721]="0:17922:2:3:1:OneHandMace::1:0:", -- Hand of Righteousness
	[7722]="0:9295:4:3:1:Amulet::1:0:", -- Triune Amulet
	[7723]="0:22567:2:3:1:TwoHandMace::1:0:", -- Mograine's Might
	[7724]="0:5436:4:3:1:Mail::1:0:", -- Gauntlets of Divinity
	[7725]="0:7143:4:1:1:Tabard::1:0:", -- Tabard of the Scarlet Crusade
	[7726]="0:11681:4:3:1:Shield::1:0:", -- Aegis of the Scarlet Commander
	[7727]="0:2488:4:3:1:Leather::1:0:", -- Watchman Pauldrons
	[7728]="0:3223:4:3:1:Cloth::1:0:", -- Beguiler Robes
	[7729]="0:5514:2:3:1:Gun::1:0:", -- Chesterfall Musket
	[7730]="0:10146:2:3:1:TwoHandMace::1:0:", -- Cobalt Crusher
	[7731]="0:3482:4:3:1:Amulet::1:0:", -- Ghostshard Talisman
	[7733]="0:0:12:1:1:::1:0:", -- Staff of Prehistoria
	[7734]="0:15495:4:3:1:Trinket::1:0:", -- Six Demon Bag
	[7735]="0:0:12:1:1:::1:0:", -- Jannok's Rose
	[7736]="0:11971:2:3:1:OneHandMace::1:0:", -- Fight Club
	[7737]="0:0:12:1:1:::1:0:", -- Sethir's Journal
	[7738]="0:211:4:2:1:Cloth::1:0:", -- Evergreen Gloves
	[7739]="0:318:4:2:1:Cloak::1:0:", -- Timberland Cape
	[7740]="0:0:12:1:1:::1:0:", -- Gni'kiv Medallion
	[7741]="0:0:12:1:1:::1:0:", -- The Shaft of Tsol
	[7742]="2400:600:9:1:1:Engineering::1:1:6777", -- Schematic: Gnomish Cloaking Device
	[7746]="0:8430:4:2:1:Amulet::1:0:", -- Explorers' League Commendation
	[7747]="0:7754:4:2:1:Shield::1:0:", -- Vile Protector
	[7749]="0:4885:4:2:1:OffHandFrill::1:0:", -- Omega Orb
	[7750]="0:1712:4:2:1:Cloth::1:0:", -- Mantle of Woe
	[7751]="0:1614:4:2:1:Leather::1:0:", -- Vorrel's Boots
	[7752]="0:6903:2:3:1:OneHandMace::1:0:", -- Dreamslayer
	[7753]="0:7874:2:3:1:TwoHandAxe::1:0:", -- Bloodspiller
	[7754]="0:1959:4:3:1:Leather::1:0:", -- Harbinger Boots
	[7755]="0:4140:4:3:1:Leather::1:0:", -- Flintrock Shoulders
	[7756]="0:1927:4:3:1:Leather::1:0:", -- Dog Training Gloves
	[7757]="0:12875:2:3:1:Stave::1:0:", -- Windweaver Staff
	[7758]="0:15074:2:3:1:Polearm::1:0:", -- Ruthless Shiv
	[7759]="0:6724:4:3:1:Mail::1:0:", -- Archon Chestpiece
	[7760]="0:6074:4:3:1:Leather::1:0:", -- Warchief Kilt
	[7761]="0:11290:2:3:1:OneHandAxe::1:0:", -- Steelclaw Reaver
	[7766]="0:0:12:1:1:::1:0:", -- Empty Brown Waterskin
	[7767]="0:0:12:1:1:::1:0:", -- Empty Blue Waterskin
	[7768]="0:0:12:1:1:::1:0:", -- Empty Red Waterskin
	[7769]="0:0:12:1:1:::1:0:", -- Filled Brown Waterskin
	[7770]="0:0:12:1:1:::1:0:", -- Filled Blue Waterskin
	[7771]="0:0:12:1:1:::1:0:", -- Filled Red Waterskin
	[7786]="0:5605:2:3:1:OneHandAxe::1:0:", -- Headsplitter
	[7787]="0:3960:4:3:1:Shield::1:0:", -- Resplendent Guardian
	[7806]="0:10:0:1:20:FoodDrink::1:0:", -- Lollipop
	[7807]="0:10:0:1:20:FoodDrink::1:0:", -- Candy Bar
	[7808]="0:10:0:1:20:FoodDrink::1:0:", -- Chocolate Square
	[7809]="0:1024:4:1:1:Miscellaneous::1:0:", -- Easter Dress
	[7810]="0:0:12:1:1:::1:0:", -- Vial of Purest Water
	[7811]="0:0:12:1:1:::1:0:", -- Remaining Drops of Purest Water
	[7812]="0:0:12:1:1:::1:0:", -- Corrupt Manifestation's Bracers
	[7813]="0:0:12:1:1:::1:0:", -- Shard of Water
	[7846]="0:0:12:1:20:::1:0:", -- Crag Coyote Fang
	[7847]="0:0:12:1:20:::1:0:", -- Buzzard Gizzard
	[7848]="0:0:12:1:20:::1:0:", -- Rock Elemental Shard
	[7866]="0:0:12:1:1:::1:0:", -- Empty Thaumaturgy Vessel
	[7867]="0:0:12:1:20:::1:0:", -- Vessel of Dragon's Blood
	[7870]="0:0:12:1:1:::1:0:", -- Thaumaturgy Vessel Lockbox
	[7871]="0:0:12:1:1:::1:0:", -- Token of Thievery
	[7886]="0:0:12:1:1:::1:0:", -- Untranslated Journal
	[7887]="0:0:12:1:1:::1:0:", -- Necklace and Gem Salvage
	[7888]="0:8990:4:3:1:Amulet::1:0:", -- Jarkal's Enhancing Necklace
	[7906]="0:0:12:1:1:::1:0:", -- Horns of Nez'ra
	[7907]="0:0:15:1:1:Junk::1:0:", -- Certificate of Thievery
	[7908]="0:0:12:1:1:::1:0:", -- Klaven Mortwake's Journal
	[7909]="0:1000:3:2:20:GemSimple:164,333,202,755:1:0:", -- Aquamarine
	[7910]="0:5000:3:2:20:GemSimple:164,202,755,197:1:0:", -- Star Ruby
	[7911]="0:500:7:2:20:MetalStone:186:1:0:", -- Truesilver Ore
	[7912]="0:100:7:1:20:MetalStone:164,202,755:1:0:", -- Solid Stone
	[7913]="0:2500:4:2:1:Mail::1:0:", -- Barbaric Iron Shoulders
	[7914]="0:3331:4:2:1:Mail::1:0:", -- Barbaric Iron Breastplate
	[7915]="0:3337:4:2:1:Mail::1:0:", -- Barbaric Iron Helm
	[7916]="0:3700:4:2:1:Mail::1:0:", -- Barbaric Iron Boots
	[7917]="0:2711:4:2:1:Mail::1:0:", -- Barbaric Iron Gloves
	[7918]="0:8796:4:2:1:Plate::1:0:", -- Heavy Mithril Shoulder
	[7919]="0:5930:4:2:1:Plate::1:0:", -- Heavy Mithril Gauntlet
	[7920]="0:8053:4:2:1:Mail::1:0:", -- Mithril Scale Pants
	[7921]="0:11876:4:2:1:Plate::1:0:", -- Heavy Mithril Pants
	[7922]="0:8304:4:3:1:Plate::1:0:", -- Steel Plate Helm
	[7923]="0:0:13:1:1:::1:0:", -- Defias Tower Key
	[7924]="0:4103:4:2:1:Mail::1:0:", -- Mithril Scale Bracers
	[7925]="0:4447:4:2:1:Mail::1:0:", -- Mithril Scale Gloves
	[7926]="0:11250:4:2:1:Plate::1:0:", -- Ornate Mithril Pants
	[7927]="0:5678:4:2:1:Plate::1:0:", -- Ornate Mithril Gloves
	[7928]="0:8484:4:2:1:Plate::1:0:", -- Ornate Mithril Shoulder
	[7929]="0:7739:4:2:1:Mail::1:0:", -- Orcish War Leggings
	[7930]="0:12330:4:2:1:Plate::1:0:", -- Heavy Mithril Breastplate
	[7931]="0:7955:4:2:1:Mail::1:0:", -- Mithril Coif
	[7932]="0:8662:4:2:1:Mail::1:0:", -- Mithril Scale Shoulders
	[7933]="0:10077:4:2:1:Plate::1:0:", -- Heavy Mithril Boots
	[7934]="0:10114:4:2:1:Plate::1:0:", -- Heavy Mithril Helm
	[7935]="0:14645:4:2:1:Plate::1:0:", -- Ornate Mithril Breastplate
	[7936]="0:11771:4:2:1:Plate::1:0:", -- Ornate Mithril Boots
	[7937]="0:11813:4:2:1:Plate::1:0:", -- Ornate Mithril Helm
	[7938]="0:7090:4:3:1:Plate::1:0:", -- Truesilver Gauntlets
	[7939]="0:19074:4:3:1:Plate::1:0:", -- Truesilver Breastplate
	[7941]="0:12520:2:2:1:OneHandAxe::1:0:", -- Heavy Mithril Axe
	[7942]="0:14659:2:2:1:OneHandAxe::1:0:", -- Blue Glittering Axe
	[7943]="0:15892:2:2:1:OneHandSword::1:0:", -- Wicked Mithril Blade
	[7944]="0:20092:2:2:1:OneHandSword::1:0:", -- Dazzling Mithril Rapier
	[7945]="0:17291:2:2:1:OneHandMace::1:0:", -- Big Black Mace
	[7946]="0:21661:2:2:1:OneHandMace::1:0:", -- Runed Mithril Hammer
	[7947]="0:24892:2:2:1:Dagger::1:0:", -- Ebon Shiv
	[7954]="0:23160:2:3:1:OneHandMace::1:0:", -- The Shatterer
	[7955]="0:241:2:1:1:TwoHandSword::1:0:", -- Copper Claymore
	[7956]="0:3241:2:2:1:TwoHandMace::1:0:", -- Bronze Warhammer
	[7957]="0:3676:2:2:1:TwoHandSword::1:0:", -- Bronze Greatsword
	[7958]="0:4059:2:2:1:TwoHandAxe::1:0:", -- Bronze Battle Axe
	[7959]="0:33858:2:3:1:Polearm::1:0:", -- Blight
	[7960]="0:38548:2:3:1:TwoHandSword::1:0:", -- Truesilver Champion
	[7961]="0:25508:2:3:1:OneHandSword::1:0:", -- Phantom Blade
	[7963]="0:6488:4:2:1:Mail::1:0:", -- Steel Breastplate
	[7964]="0:40:0:1:20:EnhTemp::1:0:", -- Solid Sharpening Stone
	[7965]="0:40:0:1:20:EnhTemp::1:0:", -- Solid Weightstone
	[7966]="0:200:7:1:20:MetalStone:164:1:0:", -- Solid Grinding Stone
	[7967]="0:250:0:2:5:EnhPerm::1:0:", -- Mithril Shield Spike
	[7968]="0:0:12:1:1:::1:0:", -- Southsea Treasure
	[7969]="0:250:0:2:1:EnhPerm::1:0:", -- Mithril Spurs
	[7970]="0:0:0:1:1:Consumable::1:0:", -- E.C.A.C.
	[7971]="0:1000:3:2:20:GemSimple:164,333,755,165,197:1:0:", -- Black Pearl
	[7972]="0:400:7:1:10:Elemental:171,164,333,202,197:1:0:", -- Ichor of Undeath
	[7973]="0:46:7:1:20:Other::1:0:", -- Big-mouth Clam
	[7974]="0:50:7:1:10:Meat:185:1:0:", -- Zesty Clam Meat
	[7975]="0:1500:9:2:1:Blacksmithing::1:0:", -- Plans: Heavy Mithril Pants
	[7976]="0:2000:9:3:1:Blacksmithing::1:0:", -- Plans: Mithril Shield Spike
	[7978]="0:750:9:2:1:Blacksmithing::1:0:", -- Plans: Barbaric Iron Shoulders
	[7979]="0:750:9:2:1:Blacksmithing::1:0:", -- Plans: Barbaric Iron Breastplate
	[7980]="0:850:9:2:1:Blacksmithing::1:0:", -- Plans: Barbaric Iron Helm
	[7981]="0:1100:9:2:1:Blacksmithing::1:0:", -- Plans: Barbaric Iron Boots
	[7982]="0:1100:9:2:1:Blacksmithing::1:0:", -- Plans: Barbaric Iron Gloves
	[7983]="0:2000:9:2:1:Blacksmithing::1:0:", -- Plans: Ornate Mithril Pants
	[7984]="0:2000:9:2:1:Blacksmithing::1:0:", -- Plans: Ornate Mithril Gloves
	[7985]="0:2000:9:2:1:Blacksmithing::1:0:", -- Plans: Ornate Mithril Shoulder
	[7989]="0:2500:9:2:1:Blacksmithing::1:0:", -- Plans: Mithril Spurs
	[7990]="0:2500:9:2:1:Blacksmithing::1:0:", -- Plans: Heavy Mithril Helm
	[7991]="0:2500:9:3:1:Blacksmithing::1:0:", -- Plans: Mithril Scale Shoulders
	[7992]="0:2000:9:2:1:Blacksmithing::1:0:", -- Plans: Blue Glittering Axe
	[7993]="0:2500:9:2:1:Blacksmithing::1:0:", -- Plans: Dazzling Mithril Rapier
	[7995]="6000:1500:9:1:1:Blacksmithing::1:1:8161,8176", -- Plans: Mithril Scale Bracers
	[7997]="0:81:4:0:1:Miscellaneous::1:0:", -- Red Defias Mask
	[8006]="0:12472:2:3:1:Dagger::1:0:", -- The Ziggler
	[8007]="0:0:0:1:1:Consumable::1:0:", -- Mana Citrine
	[8008]="0:0:0:1:1:Consumable::1:0:", -- Mana Ruby
	[8009]="0:0:12:1:20:::1:0:", -- Dentrium Power Stone
	[8026]="0:0:12:1:1:::1:0:", -- Garrett Family Treasure
	[8027]="0:0:12:1:1:::1:0:", -- Krom Stoutarm's Treasure
	[8028]="0:2500:9:3:1:Blacksmithing::1:0:", -- Plans: Runed Mithril Hammer
	[8029]="0:2000:9:2:1:Blacksmithing::1:0:", -- Plans: Wicked Mithril Blade
	[8030]="10000:2500:9:1:1:Blacksmithing::1:0:11278", -- Plans: Ebon Shiv
	[8046]="0:0:9:1:1:Book::1:0:", -- Kearnen's Journal
	[8047]="0:0:12:1:20:::1:0:", -- Magenta Fungus Cap
	[8048]="0:0:12:1:1:::1:0:", -- Emerald Dreamcatcher
	[8049]="0:0:12:1:1:::1:0:", -- Gnarlpine Necklace
	[8050]="0:0:12:1:1:::1:0:", -- Tallonkai's Jewel
	[8051]="0:0:12:1:1:::1:0:", -- Flare Gun
	[8052]="0:0:12:1:20:::1:0:", -- An'Alleum Power Stone
	[8053]="0:0:12:1:1:::1:0:", -- Obsidian Power Source
	[8066]="0:0:12:1:1:::1:0:", -- Fizzule's Whistle
	[8067]="0:0:6:1:1000:Bullet::1:0:", -- Crafted Light Shot
	[8068]="0:0:6:1:1000:Bullet::1:0:", -- Crafted Heavy Shot
	[8069]="0:0:6:1:1000:Bullet::1:0:", -- Crafted Solid Shot
	[8070]="0:0:12:1:1:::1:0:", -- Reward Voucher
	[8071]="0:1534:2:2:1:Wand::1:0:", -- Sizzle Stick
	[8072]="0:0:13:1:1:::1:0:", -- Silixiz's Tower Key
	[8073]="0:0:12:1:1:::1:0:", -- Cache of Zanzil's Altered Mixture
	[8074]="0:0:12:1:1:::1:0:", -- Gallywix's Head
	[8075]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Sourdough
	[8076]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Sweet Roll
	[8077]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Mineral Water
	[8078]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Sparkling Water
	[8079]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Crystal Water
	[8080]="0:10477:4:0:1:Plate::1:0:", -- Light Plate Chestpiece
	[8081]="0:4989:4:0:1:Plate::1:0:", -- Light Plate Belt
	[8082]="0:5570:4:0:1:Plate::1:0:", -- Light Plate Boots
	[8083]="0:3980:4:0:1:Plate::1:0:", -- Light Plate Bracers
	[8084]="0:4758:4:0:1:Plate::1:0:", -- Light Plate Gloves
	[8085]="0:9194:4:0:1:Plate::1:0:", -- Light Plate Pants
	[8086]="0:6516:4:0:1:Plate::1:0:", -- Light Plate Shoulderpads
	[8087]="0:0:15:1:1:Junk::1:0:", -- Sample of Zanzil's Altered Mixture
	[8088]="23470:4694:4:1:1:Plate::1:0:980,1323,1349,3095,4177,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Platemail Belt
	[8089]="35075:7015:4:1:1:Plate::1:0:980,1323,1349,3095,4177,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Platemail Boots
	[8090]="23653:4730:4:1:1:Plate::1:0:980,1323,1349,3095,4177,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Platemail Bracers
	[8091]="23742:4748:4:1:1:Plate::1:0:980,1323,1349,3095,4177,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Platemail Gloves
	[8092]="35479:7095:4:1:1:Plate::1:0:980,1323,1349,3095,4177,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Platemail Helm
	[8093]="47577:9515:4:1:1:Plate::1:0:980,1323,1349,3095,4177,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Platemail Leggings
	[8094]="47759:9551:4:1:1:Plate::1:0:980,1323,1349,3095,4177,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Platemail Armor
	[8095]="0:0:0:1:1:Consumable::1:0:", -- Hinott's Oil
	[8106]="0:10438:4:2:1:Cloth::1:0:", -- Hibernal Armor
	[8107]="0:5938:4:2:1:Cloth::1:0:", -- Hibernal Boots
	[8108]="0:3594:4:2:1:Cloth::1:0:", -- Hibernal Bracers
	[8109]="0:5012:4:2:1:Cloak::1:0:", -- Hibernal Cloak
	[8110]="0:3622:4:2:1:Cloth::1:0:", -- Hibernal Gloves
	[8111]="0:5890:4:2:1:Cloth::1:0:", -- Hibernal Mantle
	[8112]="0:8436:4:2:1:Cloth::1:0:", -- Hibernal Pants
	[8113]="0:9694:4:2:1:Cloth::1:0:", -- Hibernal Robe
	[8114]="0:3677:4:2:1:Cloth::1:0:", -- Hibernal Sash
	[8115]="0:5980:4:2:1:Cloth::1:0:", -- Hibernal Cowl
	[8116]="0:4632:4:2:1:Leather::1:0:", -- Heraldic Belt
	[8117]="0:7161:4:2:1:Leather::1:0:", -- Heraldic Boots
	[8118]="0:4436:4:2:1:Leather::1:0:", -- Heraldic Bracers
	[8119]="0:12726:4:2:1:Leather::1:0:", -- Heraldic Breastplate
	[8120]="0:4965:4:2:1:Cloak::1:0:", -- Heraldic Cloak
	[8121]="0:4843:4:2:1:Leather::1:0:", -- Heraldic Gloves
	[8122]="0:7875:4:2:1:Leather::1:0:", -- Heraldic Headpiece
	[8123]="0:11276:4:2:1:Leather::1:0:", -- Heraldic Leggings
	[8124]="0:7932:4:2:1:Leather::1:0:", -- Heraldic Spaulders
	[8125]="0:6367:4:2:1:Mail::1:0:", -- Myrmidon's Bracers
	[8126]="0:15656:4:2:1:Mail::1:0:", -- Myrmidon's Breastplate
	[8127]="0:5937:4:2:1:Cloak::1:0:", -- Myrmidon's Cape
	[8128]="0:6229:4:2:1:Mail::1:0:", -- Myrmidon's Gauntlets
	[8129]="0:6253:4:2:1:Mail::1:0:", -- Myrmidon's Girdle
	[8130]="0:9459:4:2:1:Mail::1:0:", -- Myrmidon's Greaves
	[8131]="0:10115:4:2:1:Mail::1:0:", -- Myrmidon's Helm
	[8132]="0:14485:4:2:1:Mail::1:0:", -- Myrmidon's Leggings
	[8133]="0:10517:4:2:1:Mail::1:0:", -- Myrmidon's Pauldrons
	[8134]="0:15993:4:2:1:Shield::1:0:", -- Myrmidon's Defender
	[8135]="0:11234:4:2:1:Shield::1:0:", -- Chromite Shield
	[8136]="0:0:12:1:1:::1:0:", -- Gargantuan Tumor
	[8137]="0:4940:4:2:1:Plate::1:0:", -- Chromite Bracers
	[8138]="0:13416:4:2:1:Plate::1:0:", -- Chromite Chestplate
	[8139]="0:5375:4:2:1:Plate::1:0:", -- Chromite Gauntlets
	[8140]="0:4994:4:2:1:Plate::1:0:", -- Chromite Girdle
	[8141]="0:8058:4:2:1:Plate::1:0:", -- Chromite Greaves
	[8142]="0:8087:4:2:1:Plate::1:0:", -- Chromite Barbute
	[8143]="0:12647:4:2:1:Plate::1:0:", -- Chromite Legplates
	[8144]="0:8796:4:2:1:Plate::1:0:", -- Chromite Pauldrons
	[8146]="0:500:15:0:5:Junk::1:0:", -- Wicked Claw
	[8149]="0:0:12:1:1:::1:0:", -- Voodoo Charm
	[8150]="0:250:7:1:20:Leather:185,202,165:1:0:", -- Deeprock Salt
	[8151]="0:250:7:1:20:Other:202,755,165:1:0:", -- Flask of Mojo
	[8152]="0:500:7:1:20:Other:755,165:1:0:", -- Flask of Big Mojo
	[8153]="0:5:7:1:20:Herb:171,164,333,202,165,197:1:0:", -- Wildvine
	[8154]="0:250:7:1:20:Leather:165:1:0:", -- Scorpid Scale
	[8155]="0:0:12:1:1:::1:0:", -- Sathrah's Sacrifice
	[8156]="0:3907:4:2:1:Plate::1:0:", -- Jouster's Wristguards
	[8157]="0:9096:4:2:1:Plate::1:0:", -- Jouster's Chestplate
	[8158]="0:3936:4:2:1:Plate::1:0:", -- Jouster's Gauntlets
	[8159]="0:3950:4:2:1:Plate::1:0:", -- Jouster's Girdle
	[8160]="0:5901:4:2:1:Plate::1:0:", -- Jouster's Greaves
	[8161]="0:5922:4:2:1:Plate::1:0:", -- Jouster's Visor
	[8162]="0:8575:4:2:1:Plate::1:0:", -- Jouster's Legplates
	[8163]="0:6442:4:2:1:Plate::1:0:", -- Jouster's Pauldrons
	[8165]="0:500:7:1:20:Leather:165:1:0:", -- Worn Dragonscale
	[8167]="0:100:7:1:20:Leather:165:1:0:", -- Turtle Scale
	[8168]="0:100:7:0:20:Leather::1:0:", -- Jet Black Feather
	[8169]="0:500:7:1:10:Leather:165:1:0:", -- Thick Hide
	[8170]="2000:500:7:1:20:Leather:164,333,202,165,197:1:1:14846", -- Rugged Leather
	[8171]="0:500:7:1:10:Leather:165:1:0:", -- Rugged Hide
	[8172]="0:500:7:1:20:Leather:165:1:0:", -- Cured Thick Hide
	[8173]="0:1000:0:1:10:EnhPerm::1:0:", -- Thick Armor Kit
	[8174]="0:4957:4:3:1:Leather::1:0:", -- Comfortable Leather Hat
	[8175]="0:5971:4:2:1:Leather::1:0:", -- Nightscape Tunic
	[8176]="0:4495:4:2:1:Leather::1:0:", -- Nightscape Headband
	[8177]="0:71:2:1:1:TwoHandSword::1:0:", -- Practice Sword
	[8178]="0:306:2:2:1:TwoHandSword::1:0:", -- Training Sword
	[8179]="0:28:2:1:1:Bow::1:0:", -- Cadet's Bow
	[8180]="0:240:2:2:1:Bow::1:0:", -- Hunting Bow
	[8181]="0:79:2:1:1:Gun::1:0:", -- Hunting Rifle
	[8182]="0:40:2:1:1:Gun::1:0:", -- Pellet Rifle
	[8183]="0:2426:2:2:1:Bow::1:0:", -- Precision Bow
	[8184]="0:2947:2:2:1:Wand::1:0:", -- Firestarter
	[8185]="0:10952:4:2:1:Mail::1:0:", -- Turtle Scale Leggings
	[8186]="0:2231:2:2:1:Wand::1:0:", -- Dire Wand
	[8187]="0:3477:4:2:1:Mail::1:0:", -- Turtle Scale Gloves
	[8188]="0:6414:2:2:1:Gun::1:0:", -- Explosive Shotgun
	[8189]="0:7567:4:2:1:Mail::1:0:", -- Turtle Scale Breastplate
	[8190]="0:37286:2:3:1:OneHandSword::1:0:", -- Hanzo Sword
	[8191]="0:7780:4:2:1:Mail::1:0:", -- Turtle Scale Helm
	[8192]="0:4782:4:2:1:Leather::1:0:", -- Nightscape Shoulders
	[8193]="0:8708:4:2:1:Leather::1:0:", -- Nightscape Pants
	[8194]="0:13877:2:2:1:OneHandMace::1:0:", -- Goblin Nutcracker
	[8195]="0:5263:4:2:1:Cloak::1:0:", -- Nightscape Cloak
	[8196]="0:13979:2:2:1:OneHandSword::1:0:", -- Ebon Scimitar
	[8197]="0:7158:4:2:1:Leather::1:0:", -- Nightscape Boots
	[8198]="0:4013:4:2:1:Mail::1:0:", -- Turtle Scale Bracers
	[8199]="0:24661:2:2:1:TwoHandSword::1:0:", -- Battlefield Destroyer
	[8200]="0:7275:4:2:1:Leather::1:0:", -- Big Voodoo Robe
	[8201]="0:5350:4:2:1:Leather::1:0:", -- Big Voodoo Mask
	[8202]="0:9022:4:2:1:Leather::1:0:", -- Big Voodoo Pants
	[8203]="0:8628:4:2:1:Mail::1:0:", -- Tough Scorpid Breastplate
	[8204]="0:4676:4:2:1:Mail::1:0:", -- Tough Scorpid Gloves
	[8205]="0:4346:4:2:1:Mail::1:0:", -- Tough Scorpid Bracers
	[8206]="0:12704:4:2:1:Mail::1:0:", -- Tough Scorpid Leggings
	[8207]="0:8978:4:2:1:Mail::1:0:", -- Tough Scorpid Shoulders
	[8208]="0:10272:4:2:1:Mail::1:0:", -- Tough Scorpid Helm
	[8209]="0:8375:4:2:1:Mail::1:0:", -- Tough Scorpid Boots
	[8210]="0:5537:4:2:1:Leather::1:0:", -- Wild Leather Shoulders
	[8211]="0:8002:4:2:1:Leather::1:0:", -- Wild Leather Vest
	[8212]="0:11585:4:2:1:Leather::1:0:", -- Wild Leather Leggings
	[8213]="0:8150:4:2:1:Leather::1:0:", -- Wild Leather Boots
	[8214]="0:6230:4:2:1:Leather::1:0:", -- Wild Leather Helmet
	[8215]="0:7213:4:2:1:Cloak::1:0:", -- Wild Leather Cloak
	[8216]="0:6323:4:2:1:Cloak::1:0:", -- Big Voodoo Cloak
	[8217]="0:1000:11:2:1:Quiver::1:0:", -- Quickdraw Quiver
	[8218]="0:1000:11:2:1:AmmoPouch::1:0:", -- Thick Leather Ammo Pouch
	[8223]="0:10066:2:3:1:OneHandSword::1:0:", -- Blade of the Basilisk
	[8224]="0:7655:2:2:1:OneHandSword::1:0:", -- Silithid Ripper
	[8225]="0:9222:2:3:1:OneHandSword::1:0:", -- Tainted Pierce
	[8226]="0:5747:2:3:1:OneHandSword::1:0:", -- The Butcher
	[8244]="0:10000:12:3:20:::1:0:", -- Flawless Draenethyst Sphere
	[8245]="0:12923:4:2:1:Cloth::1:0:", -- Imperial Red Tunic
	[8246]="0:7917:4:2:1:Cloth::1:0:", -- Imperial Red Boots
	[8247]="0:4997:4:2:1:Cloth::1:0:", -- Imperial Red Bracers
	[8248]="0:7032:4:2:1:Cloak::1:0:", -- Imperial Red Cloak
	[8249]="0:5336:4:2:1:Cloth::1:0:", -- Imperial Red Gloves
	[8250]="0:8034:4:2:1:Cloth::1:0:", -- Imperial Red Mantle
	[8251]="0:12080:4:2:1:Cloth::1:0:", -- Imperial Red Pants
	[8252]="0:13623:4:2:1:Cloth::1:0:", -- Imperial Red Robe
	[8253]="0:5107:4:2:1:Cloth::1:0:", -- Imperial Red Sash
	[8254]="0:8640:4:2:1:Cloth::1:0:", -- Imperial Red Circlet
	[8255]="0:6010:4:2:1:Leather::1:0:", -- Serpentskin Girdle
	[8256]="0:10261:4:2:1:Leather::1:0:", -- Serpentskin Boots
	[8257]="0:6053:4:2:1:Leather::1:0:", -- Serpentskin Bracers
	[8258]="0:17396:4:2:1:Leather::1:0:", -- Serpentskin Armor
	[8259]="0:7315:4:2:1:Cloak::1:0:", -- Serpentskin Cloak
	[8260]="0:6938:4:2:1:Leather::1:0:", -- Serpentskin Gloves
	[8261]="0:10617:4:2:1:Leather::1:0:", -- Serpentskin Helm
	[8262]="0:14606:4:2:1:Leather::1:0:", -- Serpentskin Leggings
	[8263]="0:10373:4:2:1:Leather::1:0:", -- Serpentskin Spaulders
	[8264]="0:7857:4:2:1:Mail::1:0:", -- Ebonhold Wristguards
	[8265]="0:19914:4:2:1:Mail::1:0:", -- Ebonhold Armor
	[8266]="0:7468:4:2:1:Cloak::1:0:", -- Ebonhold Cloak
	[8267]="0:8928:4:2:1:Mail::1:0:", -- Ebonhold Gauntlets
	[8268]="0:8960:4:2:1:Mail::1:0:", -- Ebonhold Girdle
	[8269]="0:14362:4:2:1:Mail::1:0:", -- Ebonhold Boots
	[8270]="0:14351:4:2:1:Mail::1:0:", -- Ebonhold Helmet
	[8271]="0:20358:4:2:1:Mail::1:0:", -- Ebonhold Leggings
	[8272]="0:13697:4:2:1:Mail::1:0:", -- Ebonhold Shoulderpads
	[8273]="0:6290:4:2:1:Plate::1:0:", -- Valorous Wristguards
	[8274]="0:17940:4:2:1:Plate::1:0:", -- Valorous Chestguard
	[8275]="0:22028:4:2:1:Shield::1:0:", -- Ebonhold Buckler
	[8276]="0:6867:4:2:1:Plate::1:0:", -- Valorous Gauntlets
	[8277]="0:6381:4:2:1:Plate::1:0:", -- Valorous Girdle
	[8278]="0:9567:4:2:1:Plate::1:0:", -- Valorous Greaves
	[8279]="0:10371:4:2:1:Plate::1:0:", -- Valorous Helm
	[8280]="0:14881:4:2:1:Plate::1:0:", -- Valorous Legguards
	[8281]="0:10450:4:2:1:Plate::1:0:", -- Valorous Pauldrons
	[8282]="0:15695:4:2:1:Shield::1:0:", -- Valorous Shield
	[8283]="0:16550:4:2:1:Cloth::1:0:", -- Arcane Armor
	[8284]="0:10514:4:2:1:Cloth::1:0:", -- Arcane Boots
	[8285]="0:6637:4:2:1:Cloth::1:0:", -- Arcane Bands
	[8286]="0:9427:4:2:1:Cloak::1:0:", -- Arcane Cloak
	[8287]="0:7087:4:2:1:Cloth::1:0:", -- Arcane Gloves
	[8288]="0:11876:4:2:1:Cloth::1:0:", -- Arcane Pads
	[8289]="0:16688:4:2:1:Cloth::1:0:", -- Arcane Leggings
	[8290]="0:16982:4:2:1:Cloth::1:0:", -- Arcane Robe
	[8291]="0:6784:4:2:1:Cloth::1:0:", -- Arcane Sash
	[8292]="0:11476:4:2:1:Cloth::1:0:", -- Arcane Cover
	[8293]="0:8542:4:2:1:Leather::1:0:", -- Traveler's Belt
	[8294]="0:12652:4:2:1:Leather::1:0:", -- Traveler's Boots
	[8295]="0:7988:4:2:1:Leather::1:0:", -- Traveler's Bracers
	[8296]="0:20145:4:2:1:Leather::1:0:", -- Traveler's Jerkin
	[8297]="0:9113:4:2:1:Cloak::1:0:", -- Traveler's Cloak
	[8298]="0:8565:4:2:1:Leather::1:0:", -- Traveler's Gloves
	[8299]="0:14354:4:2:1:Leather::1:0:", -- Traveler's Helm
	[8300]="0:20172:4:2:1:Leather::1:0:", -- Traveler's Leggings
	[8301]="0:14463:4:2:1:Leather::1:0:", -- Traveler's Spaulders
	[8302]="0:11060:4:2:1:Mail::1:0:", -- Hero's Bracers
	[8303]="0:25164:4:2:1:Mail::1:0:", -- Hero's Breastplate
	[8304]="0:10513:4:2:1:Cloak::1:0:", -- Hero's Cape
	[8305]="0:11743:4:2:1:Mail::1:0:", -- Hero's Gauntlets
	[8306]="0:11787:4:2:1:Mail::1:0:", -- Hero's Belt
	[8307]="0:18717:4:2:1:Mail::1:0:", -- Hero's Boots
	[8308]="0:18703:4:2:1:Mail::1:0:", -- Hero's Band
	[8309]="0:25377:4:2:1:Mail::1:0:", -- Hero's Leggings
	[8310]="0:19420:4:2:1:Mail::1:0:", -- Hero's Pauldrons
	[8311]="0:10287:4:2:1:Plate::1:0:", -- Alabaster Plate Vambraces
	[8312]="0:25918:4:2:1:Plate::1:0:", -- Alabaster Breastplate
	[8313]="0:28565:4:2:1:Shield::1:0:", -- Hero's Buckler
	[8314]="0:9405:4:2:1:Plate::1:0:", -- Alabaster Plate Gauntlets
	[8315]="0:8908:4:2:1:Plate::1:0:", -- Alabaster Plate Girdle
	[8316]="0:14110:4:2:1:Plate::1:0:", -- Alabaster Plate Greaves
	[8317]="0:15013:4:2:1:Plate::1:0:", -- Alabaster Plate Helmet
	[8318]="0:22622:4:2:1:Plate::1:0:", -- Alabaster Plate Leggings
	[8319]="0:16037:4:2:1:Plate::1:0:", -- Alabaster Plate Pauldrons
	[8320]="0:22092:4:2:1:Shield::1:0:", -- Alabaster Shield
	[8343]="2000:500:7:1:20:Cloth:165,197:1:0:989,1148,1286,1347,1454,1474,1672,2225,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3091,3096,3364,3366,3367,3485,3779,3954,3955,3958,4168,4189,4225,4229,4561,4577,4589,4775,4897,5128,5135,5154,5163,5565,5783,5817,5944,6301,6567,6568,6574,6576,6731,7852,7854,7940,7947,8145,8160,8363,8681,8934,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12957,12958,15165,15179,16366,16613,16638,16689,16748,16767,16768,17486,18009,18277,18749,18754,18771,18772,19196,19213,19244,19372,19450,19521,19532,19722,21085,24843,24935,24995,25010,25019,25051,25082,27021,27026,27043,27057,28692,28718,28726,28798,28810,28831,28872,29288,30311,33596,33601", -- Heavy Silken Thread
	[8344]="0:0:12:1:1:::1:0:", -- Silvery Spinnerets
	[8345]="0:7421:4:3:1:Leather::1:0:", -- Wolfshead Helm
	[8346]="0:5363:4:3:1:Leather::1:0:", -- Gauntlets of the Sea
	[8347]="0:5980:4:3:1:Mail::1:0:", -- Dragonscale Gauntlets
	[8348]="0:10819:4:3:1:Leather::1:0:", -- Helm of Fire
	[8349]="0:14478:4:3:1:Leather::1:0:", -- Feathered Breastplate
	[8350]="0:1130:4:2:1:Ring::1:0:", -- The 1 Ring
	[8363]="0:0:12:1:1:::1:0:", -- Shaman Voodoo Charm
	[8364]="0:6:0:1:20:FoodDrink::1:0:", -- Mithril Head Trout
	[8365]="0:4:7:1:20:Meat:185:1:0:", -- Raw Mithril Head Trout
	[8366]="0:100:15:1:1:Other::1:0:", -- Bloated Trout
	[8367]="0:18455:4:3:1:Mail::1:0:", -- Dragonscale Breastplate
	[8368]="0:1000:15:0:10:Junk::1:0:", -- Thick Wolfhide
	[8383]="0:0:15:1:1:Junk::1:0:", -- Plain Letter
	[8384]="0:875:9:3:1:Leatherworking::1:0:", -- Pattern: Comfortable Leather Hat
	[8385]="3500:875:9:1:1:Leatherworking::1:1:7852,7854", -- Pattern: Turtle Scale Gloves
	[8386]="0:1000:9:2:1:Leatherworking::1:0:", -- Pattern: Big Voodoo Robe
	[8387]="0:1000:9:2:1:Leatherworking::1:0:", -- Pattern: Big Voodoo Mask
	[8389]="0:1250:9:2:1:Leatherworking::1:0:", -- Pattern: Big Voodoo Pants
	[8390]="0:1250:9:2:1:Leatherworking::1:0:", -- Pattern: Big Voodoo Cloak
	[8391]="0:0:12:1:20:::1:0:", -- Snickerfang Jowl
	[8392]="0:0:12:1:20:::1:0:", -- Blasted Boar Lung
	[8393]="0:0:12:1:20:::1:0:", -- Scorpok Pincer
	[8394]="0:0:12:1:20:::1:0:", -- Basilisk Brain
	[8395]="0:1000:9:2:1:Leatherworking::1:0:", -- Pattern: Tough Scorpid Breastplate
	[8396]="0:0:12:1:20:::1:0:", -- Vulture Gizzard
	[8397]="0:1000:9:2:1:Leatherworking::1:0:", -- Pattern: Tough Scorpid Bracers
	[8398]="0:1125:9:2:1:Leatherworking::1:0:", -- Pattern: Tough Scorpid Gloves
	[8399]="0:1250:9:2:1:Leatherworking::1:0:", -- Pattern: Tough Scorpid Boots
	[8400]="0:1250:9:2:1:Leatherworking::1:0:", -- Pattern: Tough Scorpid Shoulders
	[8401]="0:1375:9:2:1:Leatherworking::1:0:", -- Pattern: Tough Scorpid Leggings
	[8402]="0:1375:9:2:1:Leatherworking::1:0:", -- Pattern: Tough Scorpid Helm
	[8403]="0:0:9:2:1:Leatherworking::1:0:", -- Pattern: Wild Leather Shoulders
	[8404]="0:0:9:2:1:Leatherworking::1:0:", -- Pattern: Wild Leather Vest
	[8405]="0:0:9:2:1:Leatherworking::1:0:", -- Pattern: Wild Leather Helmet
	[8406]="0:0:9:2:1:Leatherworking::1:0:", -- Pattern: Wild Leather Boots
	[8407]="0:0:9:2:1:Leatherworking::1:0:", -- Pattern: Wild Leather Leggings
	[8408]="0:0:9:2:1:Leatherworking::1:0:", -- Pattern: Wild Leather Cloak
	[8409]="4000:1000:9:2:1:Leatherworking::1:1:7854,8160", -- Pattern: Nightscape Shoulders
	[8410]="0:0:0:1:1:Elixir::1:0:", -- R.O.I.D.S.
	[8411]="0:0:0:1:1:Elixir::1:0:", -- Lung Juice Cocktail
	[8412]="0:0:0:1:1:Elixir::1:0:", -- Ground Scorpok Assay
	[8423]="0:0:0:1:1:Elixir::1:0:", -- Cerebral Cortex Compound
	[8424]="0:0:0:1:1:Elixir::1:0:", -- Gizzard Gum
	[8425]="0:0:15:0:20:Junk::1:0:", -- Parrot Droppings
	[8426]="0:0:15:0:20:Junk::1:0:", -- Large Ruffled Feather
	[8427]="0:0:15:0:20:Junk::1:0:", -- Mutilated Rat Carcass
	[8428]="0:0:12:1:1:::1:0:", -- Laden Dew Gland
	[8429]="0:31:15:0:10:Junk::1:0:", -- Punctured Dew Gland
	[8430]="0:46:15:0:10:Junk::1:0:", -- Empty Dew Gland
	[8431]="0:0:12:1:1:::1:0:", -- Spool of Light Chartreuse Silk Thread
	[8432]="0:0:0:1:1:Consumable::1:0:", -- Eau de Mixilpixil
	[8443]="0:0:12:1:20:::1:0:", -- Gahz'ridian Ornament
	[8444]="0:0:13:1:1:::1:0:", -- Executioner's Key
	[8463]="0:0:12:1:1:::1:0:", -- Warchief's Orders
	[8483]="0:171:12:1:20:::1:0:", -- Wastewander Water Pouch
	[8484]="0:68:15:1:1:Junk::1:0:", -- Gadgetzan Water Co. Care Package
	[8485]="4000:1000:15:1:1:Companion::1:0:6367", -- Cat Carrier (Bombay)
	[8486]="4000:1000:15:1:1:Companion::1:0:6367", -- Cat Carrier (Cornish Rex)
	[8487]="4000:1000:15:1:1:Companion::1:0:6367", -- Cat Carrier (Orange Tabby)
	[8488]="4000:1000:15:1:1:Companion::1:0:6367", -- Cat Carrier (Silver Tabby)
	[8489]="6000:1500:15:1:1:Companion::1:1:8666", -- Cat Carrier (White Kitten)
	[8490]="6000:1500:15:1:1:Companion::1:0:20980", -- Cat Carrier (Siamese)
	[8491]="0:1500:15:1:1:Companion::1:0:", -- Cat Carrier (Black Tabby)
	[8492]="0:1000:15:1:1:Companion::1:0:", -- Parrot Cage (Green Wing Macaw)
	[8494]="0:1000:15:1:1:Companion::1:0:", -- Parrot Cage (Hyacinth Macaw)
	[8495]="4000:1000:15:1:1:Companion::1:0:2663,20980", -- Parrot Cage (Senegal)
	[8496]="4000:1000:15:1:1:Companion::1:0:2663", -- Parrot Cage (Cockatiel)
	[8497]="2000:500:15:1:1:Companion::1:0:1263", -- Rabbit Crate (Snowshoe)
	[8498]="0:2500:15:1:1:Companion::1:0:", -- Tiny Emerald Whelpling
	[8499]="0:2500:15:1:1:Companion::1:0:", -- Tiny Crimson Whelpling
	[8500]="5000:1250:15:1:1:Companion::1:0:8665", -- Great Horned Owl
	[8501]="5000:1250:15:1:1:Companion::1:0:8665", -- Hawk Owl
	[8508]="0:178:15:0:5:Junk::1:0:", -- Large Fin
	[8523]="1000:0:12:1:1:::1:0:7683", -- Field Testing Kit
	[8524]="0:0:12:2:1:::1:0:", -- Model 4711-FTZ Power Source
	[8525]="0:0:12:1:1:::1:0:", -- Zinge's Purchase Order
	[8526]="0:0:12:1:1:::1:0:", -- Violet Tragan
	[8527]="0:0:12:1:1:::1:0:", -- Sealed Field Testing Kit
	[8528]="0:0:12:1:1:::1:0:", -- Violet Powder
	[8529]="3500:175:0:1:20:Elixir::5:0:7564", -- Noggenfogger Elixir
	[8544]="0:340:0:1:20:Bandage::1:0:", -- Mageweave Bandage
	[8545]="0:800:0:1:20:Bandage::1:0:", -- Heavy Mageweave Bandage
	[8546]="0:50:0:1:1:Other::1:0:", -- Powerful Smelling Salts
	[8548]="0:0:12:1:1:::1:0:", -- Divino-matic Rod
	[8563]="100000:0:15:3:1:Mount::1:0:7955", -- Red Mechanostrider
	[8564]="0:200:12:1:1:::1:0:", -- Hippogryph Egg
	[8584]="0:0:12:1:1:::1:0:", -- Untapped Dowsing Widget
	[8585]="0:0:12:1:1:::1:0:", -- Tapped Dowsing Widget
	[8586]="0:0:15:4:1:Mount::1:0:", -- Whistle of the Mottled Red Raptor
	[8587]="0:0:12:1:20:::1:0:", -- Centipaar Insect Parts
	[8588]="100000:0:15:3:1:Mount::1:0:7952", -- Whistle of the Emerald Raptor
	[8591]="100000:0:15:3:1:Mount::1:0:7952", -- Whistle of the Turquoise Raptor
	[8592]="100000:0:15:3:1:Mount::1:0:7952", -- Whistle of the Violet Raptor
	[8593]="0:0:12:1:1:::1:0:", -- Scrimshank's Surveying Gear
	[8594]="0:0:12:1:1:::1:0:", -- Insect Analysis Report
	[8595]="100000:0:15:3:1:Mount::1:0:7955", -- Blue Mechanostrider
	[8603]="0:0:12:1:1:::1:0:", -- Thistleshrub Dew
	[8623]="0:0:12:2:1:::1:0:", -- OOX-17/TN Distress Beacon
	[8624]="1000:250:4:1:1:OffHandFrill::1:0:8116,8117,8118,8122", -- Red Sparkler
	[8625]="1000:250:4:1:1:OffHandFrill::1:0:8116,8117,8118,8122", -- White Sparkler
	[8626]="1000:250:4:1:1:OffHandFrill::1:0:8116,8117,8118,8122", -- Blue Sparkler
	[8628]="0:0:15:1:1:Mount::1:0:", -- Reins of the Spotted Nightsaber
	[8629]="100000:0:15:3:1:Mount::1:0:4730", -- Reins of the Striped Nightsaber
	[8631]="100000:0:15:3:1:Mount::1:0:4730", -- Reins of the Striped Frostsaber
	[8632]="100000:0:15:3:1:Mount::1:0:4730", -- Reins of the Spotted Frostsaber
	[8643]="0:2500:12:1:1:::1:0:", -- Extraordinary Egg
	[8644]="0:1500:12:1:1:::1:0:", -- Fine Egg
	[8645]="0:750:12:1:1:::1:0:", -- Ordinary Egg
	[8646]="0:250:12:1:1:::1:0:", -- Bad Egg
	[8647]="0:0:12:1:1:::1:0:", -- Egg Crate
	[8663]="0:0:4:2:1:Trinket::1:0:", -- Mithril Insignia
	[8683]="0:1:12:1:20:::1:0:", -- Clara's Fresh Apple
	[8684]="0:0:12:1:20:::1:0:", -- Hinterlands Honey Ripple
	[8685]="0:0:12:1:1:::1:0:", -- Dran's Ripple Delivery
	[8686]="0:0:12:1:1:::1:0:", -- Mithril Pendant
	[8687]="0:0:12:1:1:::1:0:", -- Sealed Description of Thredd's Visitor
	[8703]="0:6492:4:2:1:Trinket::1:0:", -- Signet of Expertise
	[8704]="0:0:12:2:1:::1:0:", -- OOX-09/HL Distress Beacon
	[8705]="0:0:12:2:1:::1:0:", -- OOX-22/FE Distress Beacon
	[8707]="0:0:12:1:1:::1:0:", -- Gahz'rilla's Electrified Scale
	[8708]="0:0:2:4:1:OneHandMace::1:0:", -- Hammer of Expertise
	[8723]="0:0:12:1:1:::1:0:", -- Caliph Scorpidsting's Head
	[8724]="0:0:12:1:1:::1:0:", -- Rin'ji's Secret
	[8746]="0:682:4:0:1:Cloth::1:0:", -- Interlaced Cowl
	[8747]="0:1036:4:0:1:Leather::1:0:", -- Hardened Leather Helm
	[8748]="0:775:4:0:1:Mail::1:0:", -- Double Mail Coif
	[8749]="0:1604:4:0:1:Cloth::1:0:", -- Crochet Hat
	[8750]="0:1863:4:0:1:Leather::1:0:", -- Thick Leather Hat
	[8751]="0:2618:4:0:1:Mail::1:0:", -- Overlinked Coif
	[8752]="0:5217:4:0:1:Mail::1:0:", -- Laminated Scale Circlet
	[8753]="0:5198:4:0:1:Leather::1:0:", -- Smooth Leather Helmet
	[8754]="0:3937:4:0:1:Cloth::1:0:", -- Twill Cover
	[8755]="0:6512:4:0:1:Plate::1:0:", -- Light Plate Helmet
	[8766]="4000:200:0:1:20:FoodDrink::5:0:258,274,295,465,734,955,982,1237,1247,1328,1464,1697,2303,2352,2364,2366,2388,2803,2806,2832,3086,3298,3411,3546,3577,3621,3689,3708,3881,3882,3883,3884,3934,3937,3959,3961,4167,4169,4181,4190,4191,4192,4195,4255,4266,4554,4555,4571,4782,4875,4879,4893,4981,5111,5112,5140,5611,5620,5688,5814,5871,6091,6272,6495,6727,6734,6735,6736,6737,6738,6739,6740,6741,6746,6747,6790,6791,6807,6928,6929,6930,7485,7714,7731,7733,7736,7737,7744,7941,7943,8125,8137,8143,8150,8152,8931,9356,9501,10367,11038,11103,11106,11116,11118,11187,11287,12019,12026,12096,12097,12196,12959,14371,14624,14731,14961,14962,14963,14964,15124,15125,15174,15397,15433,16256,16443,16458,16542,16553,16585,16602,16618,16739,16798,16826,17277,17553,17630,17656,18245,18251,18905,18906,18907,18908,18913,18914,18957,19050,19182,19232,19245,19296,19314,19315,19348,19352,19435,19451,19470,19495,19518,19528,19559,19572,19617,19679,19718,20080,20231,20893,20916,21084,21110,21145,21183,21484,21487,21744,21746,23110,23143,23573,23748,23995,24033,24057,24149,24208,24333,24342,24834,24934,24993,25012,25020,25036,25052,25089,26375,26680,29205,29291,33018", -- Morning Glory Dew
	[8827]="0:125:0:1:20:Elixir::1:0:", -- Elixir of Water Walking
	[8831]="0:300:7:1:20:Herb:171,333,197:1:0:", -- Purple Lotus
	[8836]="0:95:7:1:20:Herb:171:1:0:", -- Arthas' Tears
	[8838]="0:60:7:1:20:Herb:171,333:1:0:", -- Sungrass
	[8839]="0:375:7:1:20:Herb:171:1:0:", -- Blindweed
	[8845]="1500:375:7:1:20:Herb:171:1:1:14846", -- Ghost Mushroom
	[8846]="0:250:7:1:20:Herb:171:1:0:", -- Gromsblood
	[8923]="0:50:15:0:20:Junk::1:0:", -- Essence of Agony
	[8924]="0:25:15:0:20:Junk::1:0:", -- Dust of Deterioration
	[8925]="2500:125:7:1:20:Other:171,333:5:0:844,958,983,989,1148,1257,1286,1313,1453,2225,2380,2480,2481,2810,2812,2821,2848,3010,3014,3348,3367,3405,3548,3779,3954,3955,3956,4216,4226,4229,4561,4610,4615,4775,4897,4899,5135,5138,5163,5178,5503,5594,5817,6301,7947,8145,8157,8158,8177,8178,8305,8363,8934,11188,11189,12022,12028,12245,12941,12957,12958,15179,16367,16612,16613,16641,16705,16706,16768,16829,17486,18005,18009,19074,19244,19372,19450,19837,20989,24843,24935,24975,24995,25010,25019,25051,25082,26568,27021,27026,27031,27038,27043,27053,27057,27140,27141,28692,28725,28727,28828,28829,28831,28866,28868,28872,29288,29535,29909,30311,33600", -- Crystal Vial
	[8926]="500:125:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12097,15175,16268,16683,18006,20121,26568,27031,27038,27053,28347,29535,30239,30244,30306,32639,32641", -- Instant Poison IV
	[8927]="700:175:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12096,12097,15175,16268,16588,16683,16829,18006,18019,18802,19013,19014,19049,19239,19679,20081,20121,20194,20915,20986,22479,23145,23373,24148,24313,24780,25043,26382,26568,27031,27038,27053,27089,28347,29535,30239,30244,30306,30438,31115,32639,32641", -- Instant Poison V
	[8928]="800:200:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12096,12097,15175,16268,16588,16683,16829,18006,18019,18802,19013,19014,19049,19239,19679,20081,20121,20194,20915,20986,22479,23145,23373,23732,24148,24313,24349,24357,24780,25043,25736,26382,26568,26598,26900,26945,26950,27031,27038,27053,27089,27133,27149,27176,27186,28347,28832,28869,29015,29037,29535,29909,29922,29947,29961,29968,30010,30069,30239,30244,30306,30438,31115,32639,32641", -- Instant Poison VI
	[8932]="4000:200:0:1:20:FoodDrink::5:0:295,465,483,1237,2352,2364,3298,3546,4255,4782,4891,4894,4981,5620,6746,6790,6930,9501,10367,11106,11116,16553,17630,18929,19232,19296,19718,20080,20916,21110,21744,21746,22266,23521,23604,24342,24934", -- Alterac Swiss
	[8948]="4000:200:0:1:20:FoodDrink::5:0:2803,2806,3138,3329,3544,3547,4554,4571,5688,5886,6739,6741,8150,8152,10367,11038,12096,12097,12384,14961,14962,14963,14964,15124,15125,17656,19471,22266,23748,24149,24342,24396,24408,27032,29205,33018", -- Dried King Bolete
	[8949]="0:200:0:1:20:Elixir:165:1:0:", -- Elixir of Agility
	[8950]="4000:200:0:1:20:FoodDrink::5:0:233,1237,1247,1670,2352,2364,2832,3003,3086,3291,3480,3518,3546,3689,3708,3883,3884,3937,3948,3959,4190,4255,4266,4891,4894,5109,5620,6272,6734,6736,6737,6740,6747,7485,7737,7744,7941,8143,8307,9099,10367,11103,11287,15433,16256,16458,16739,17630,18245,18251,18907,19038,19232,19348,19352,19451,19495,19518,19664,20893,21744,21746,23522,23603,23937,24033,24057,24834,24934,24993,25012,25020,25052,25089,29291,33996", -- Homemade Cherry Pie
	[8951]="0:200:0:1:20:Elixir:165:1:0:", -- Elixir of Greater Defense
	[8952]="4000:200:0:1:20:FoodDrink::5:0:982,1464,2365,2388,2814,3025,3089,3312,3368,3411,3489,3621,3705,3881,3882,3933,3935,3960,4084,4169,4255,4782,4875,4879,4891,4894,4954,5111,5124,5611,5620,5870,6928,6929,7485,7731,7733,8125,9356,10367,11118,11187,12096,12097,12196,12959,14624,14961,14962,14963,14964,15124,15125,15174,15397,16443,16585,16602,16618,16739,16798,16826,17277,17553,17630,17656,18905,18906,18908,18913,18914,18957,19038,19182,19314,19315,19348,19352,19435,19470,19528,19559,19572,19679,19718,20097,20231,20378,20893,21084,22266,23143,23263,23481,23605,23748,24208,24343,25036,26375,28760,28943,29205", -- Roasted Quail
	[8953]="4000:200:0:1:20:FoodDrink::5:0:734,894,1671,3017,3342,3934,3961,4191,4255,4891,5814,6735,6740,7714,7736,7978,12096,12097,14961,14962,14963,14964,15124,15125,16443,16542,16798,17277,17630,18957,19050,19223,19232,19471,19572,19718,21145,21484,21487,21744,21746,22266,23573,24934,25036,26375,26680,29547", -- Deep Fried Plantains
	[8956]="0:200:0:1:5:Other::1:0:", -- Oil of Immolation
	[8957]="4000:200:0:1:20:FoodDrink::5:0:1678,1684,2842,3086,3178,3497,3540,4200,4221,4255,4305,4307,5814,6727,6738,6791,6807,7943,8137,8931,10367,11187,12962,14731,16618,16739,17553,17656,19045,19296,19472,22266,23748,23896,24033,24057,24834,24993,25012,25020,25036,25052,25089,29291", -- Spinefin Halibut
	[8959]="0:160:7:1:20:Meat::1:0:", -- Raw Spinefin Halibut
	[8973]="0:0:12:1:20:::1:0:", -- Thick Yeti Hide
	[8984]="150:37:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12097,15175,16268,16683,18006,20121,26568,27031,27038,27053,28347,29535,30239,30244,30306,32639,32641", -- Deadly Poison III
	[8985]="250:62:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12096,12097,15175,16268,16588,16683,16829,18006,18019,18802,19013,19014,19049,19239,19679,20081,20121,20194,20915,20986,22479,23145,23373,24148,24313,24780,25043,26382,26568,27031,27038,27053,27089,28347,29535,30239,30244,30306,30438,31115,32639,32641", -- Deadly Poison IV
	[9030]="0:200:0:1:5:Potion::1:0:", -- Restorative Potion
	[9036]="0:150:0:1:5:Potion::1:0:", -- Magic Resistance Potion
	[9060]="0:1000:7:1:20:Part:202:1:0:", -- Inlaid Mithril Cylinder
	[9061]="0:250:7:1:20:Part:185,202:1:0:", -- Goblin Rocket Fuel
	[9088]="0:250:0:1:20:Elixir::1:0:", -- Gift of Arthas
	[9144]="0:250:0:1:5:Potion::1:0:", -- Wildvine Potion
	[9149]="0:250:4:2:1:Trinket:171:1:0:", -- Philosopher's Stone
	[9153]="0:0:12:1:1:::1:0:", -- Rig Blueprints
	[9154]="0:300:0:1:20:Elixir::1:0:", -- Elixir of Detect Undead
	[9155]="0:400:0:1:20:Elixir::1:0:", -- Arcane Elixir
	[9172]="0:500:0:1:5:Potion::1:0:", -- Invisibility Potion
	[9173]="0:0:12:1:1:::1:0:", -- Goblin Transponder
	[9179]="0:1000:0:1:20:Elixir::1:0:", -- Elixir of Greater Intellect
	[9186]="0:175:15:0:20:Junk::1:0:", -- Mind-numbing Poison III
	[9187]="0:600:0:1:20:Elixir::1:0:", -- Elixir of Greater Agility
	[9189]="0:0:12:1:1:::1:0:", -- Shay's Bell
	[9197]="0:600:0:1:20:Elixir::1:0:", -- Elixir of Dream Vision
	[9206]="0:700:0:1:20:Elixir::1:0:", -- Elixir of Giants
	[9210]="0:750:7:1:10:Other:197:1:0:", -- Ghost Dye
	[9214]="0:2500:15:2:1:CombatPet::1:0:", -- Grimoire of Inferno
	[9224]="0:700:0:1:20:Elixir:333:1:0:", -- Elixir of Demonslaying
	[9233]="0:500:0:1:20:Elixir::1:0:", -- Elixir of Detect Demon
	[9234]="0:0:12:1:1:::1:0:", -- Tiara of the Deep
	[9235]="0:0:12:1:1:::1:0:", -- Pratt's Letter
	[9236]="0:0:12:1:1:::1:0:", -- Jangdor's Letter
	[9237]="0:0:12:1:20:::1:0:", -- Woodpaw Gnoll Mane
	[9238]="0:0:12:1:20:::1:0:", -- Uncracked Scarab Shell
	[9240]="0:0:2:3:1:OneHandMace::1:0:", -- Mallet of Zul'Farrak
	[9241]="0:0:12:1:1:::1:0:", -- Sacred Mallet
	[9242]="0:2421:15:0:1:Junk::1:0:", -- Ancient Tablet
	[9243]="0:8155:4:2:1:Amulet::1:0:", -- Shriveled Heart
	[9244]="0:0:12:1:1:::1:0:", -- Stoley's Shipment
	[9245]="0:0:12:1:1:::1:0:", -- Stoley's Bottle
	[9246]="0:0:12:1:1:::1:0:", -- Firebeard's Head
	[9247]="0:0:12:1:20:::1:0:", -- Hatecrest Naga Scale
	[9248]="0:0:12:1:1:::1:0:", -- Mysterious Relic
	[9249]="0:1553:13:2:1:::1:0:", -- Captain's Key
	[9250]="0:0:12:1:1:::1:0:", -- Ship Schedule
	[9251]="0:62:12:1:1:::1:0:", -- Upper Map Fragment
	[9252]="0:62:12:1:1:::1:0:", -- Lower Map Fragment
	[9253]="0:62:12:1:1:::1:0:", -- Middle Map Fragment
	[9254]="0:0:12:1:1:::1:0:", -- Cuergo's Treasure Map
	[9255]="0:0:12:1:1:::1:0:", -- Lahassa Essence
	[9256]="0:0:12:1:1:::1:0:", -- Imbel Essence
	[9257]="0:0:12:1:1:::1:0:", -- Samha Essence
	[9258]="0:0:12:1:1:::1:0:", -- Byltan Essence
	[9259]="0:64:15:1:20:Junk::1:0:", -- Troll Tribal Necklace
	[9260]="1600:400:0:1:10:FoodDrink:171:1:1:14322", -- Volatile Rum
	[9261]="0:250:15:0:10:Junk::1:0:", -- Lead Ore
	[9262]="0:1000:7:1:20:Other:171:1:0:", -- Black Vitriol
	[9263]="0:0:12:1:1:::1:0:", -- Troyas' Stave
	[9264]="0:35:0:1:20:Elixir::1:0:", -- Elixir of Shadow Power
	[9265]="0:15:12:2:1:::1:0:", -- Cuergo's Hidden Treasure
	[9266]="0:0:12:1:1:::1:0:", -- Woodpaw Battle Plans
	[9275]="0:0:13:1:1:::1:0:", -- Cuergo's Key
	[9276]="0:100:15:1:1:Junk::1:0:", -- Pirate's Footlocker
	[9277]="0:0:12:1:1:::1:0:", -- Techbot's Memory Core
	[9278]="0:0:12:1:20:::1:0:", -- Essential Artificial
	[9279]="0:45:12:1:1:::1:0:", -- White Punch Card
	[9280]="0:0:12:1:1:::1:0:", -- Yellow Punch Card
	[9281]="0:0:12:1:1:::1:0:", -- Red Punch Card
	[9282]="0:0:12:1:1:::1:0:", -- Blue Punch Card
	[9283]="0:0:12:1:1:::1:0:", -- Empty Leaden Collection Phial
	[9284]="0:0:12:1:1:::1:0:", -- Full Leaden Collection Phial
	[9285]="0:4204:4:2:1:Plate::1:0:", -- Field Plate Vambraces
	[9286]="0:10571:4:2:1:Plate::1:0:", -- Field Plate Armor
	[9287]="0:4235:4:2:1:Plate::1:0:", -- Field Plate Gauntlets
	[9288]="0:4250:4:2:1:Plate::1:0:", -- Field Plate Girdle
	[9289]="0:6350:4:2:1:Plate::1:0:", -- Field Plate Boots
	[9290]="0:6883:4:2:1:Plate::1:0:", -- Field Plate Helmet
	[9291]="0:9251:4:2:1:Plate::1:0:", -- Field Plate Leggings
	[9292]="0:6436:4:2:1:Plate::1:0:", -- Field Plate Pauldrons
	[9293]="0:1250:9:2:1:Alchemy::1:0:", -- Recipe: Magic Resistance Potion
	[9294]="0:2000:9:2:1:Alchemy::1:0:", -- Recipe: Wildvine Potion
	[9295]="0:2000:9:2:1:Alchemy::1:0:", -- Recipe: Invisibility Potion
	[9296]="0:2000:9:2:1:Alchemy::1:0:", -- Recipe: Gift of Arthas
	[9297]="0:2500:9:2:1:Alchemy::1:0:", -- Recipe: Elixir of Dream Vision
	[9298]="0:2250:9:2:1:Alchemy::1:0:", -- Recipe: Elixir of Giants
	[9299]="0:0:15:1:1:Junk::1:0:", -- Thermaplugg's Safe Combination
	[9300]="10000:2500:9:1:1:Alchemy::1:1:8177,8178", -- Recipe: Elixir of Demonslaying
	[9301]="10000:2500:9:2:1:Alchemy::1:1:1313,4610", -- Recipe: Elixir of Shadow Power
	[9302]="9000:2250:9:1:1:Alchemy::1:1:8157,8158", -- Recipe: Ghost Dye
	[9303]="8000:2000:9:1:1:Alchemy::1:0:5594", -- Recipe: Philosopher's Stone
	[9304]="8000:2000:9:1:1:Alchemy::1:0:5594", -- Recipe: Transmute Iron to Gold
	[9305]="8000:2000:9:1:1:Alchemy::1:1:5594", -- Recipe: Transmute Mithril to Truesilver
	[9306]="0:0:12:1:1:::1:0:", -- Stave of Equinex
	[9307]="0:0:12:1:1:::1:0:", -- A Sparkling Stone
	[9308]="0:38:12:1:20:::1:0:", -- Grime-Encrusted Object
	[9309]="0:0:12:1:20:::1:0:", -- Robo-mechanical Guts
	[9311]="0:0:15:1:1:Junk::1:0:", -- Default Stationery
	[9312]="20:5:0:1:5:Other::1:0:8116,8117,8118,8122,15011,15012", -- Blue Firework
	[9313]="20:5:0:1:5:Other::1:0:8116,8117,8118,8122,15011,15012", -- Green Firework
	[9314]="50:12:0:1:5:Other::1:0:8116,8117,8118,8122,15011,15012,23208", -- Red Streaks Firework
	[9315]="40:10:0:1:5:Other::1:0:8116,8117,8118,8122,15011,15012", -- Yellow Rose Firework
	[9316]="0:0:12:1:1:::1:0:", -- Prismatic Punch Card
	[9317]="100:25:0:1:5:Other::1:0:8116,8117,8118,8122", -- "Red, White and Blue Firework"
	[9318]="20:5:0:1:5:Other::1:0:8116,8117,8118,8122,15011,15012", -- Red Firework
	[9319]="0:0:0:1:1:Consumable::1:0:", -- Nimboya's Laden Pike
	[9320]="0:0:12:1:20:::1:0:", -- Witherbark Skull
	[9321]="0:0:12:1:1:::1:0:", -- Venom Bottle
	[9322]="0:0:12:1:20:::1:0:", -- Undamaged Venom Sac
	[9323]="0:0:12:1:1:::1:0:", -- Gadrin's Parchment
	[9324]="0:0:12:1:1:::1:0:", -- Shadra's Venom
	[9326]="0:0:12:1:1:::1:0:", -- Grime-Encrusted Ring
	[9327]="0:625:12:2:1:::1:0:", -- Security DELTA Data Access Card
	[9328]="0:0:12:1:1:::1:0:", -- Super Snapper FX
	[9329]="0:0:12:1:1:::1:0:", -- A Short Note
	[9330]="0:0:12:1:1:::1:0:", -- Snapshot of Gammerita
	[9331]="0:0:12:1:1:::1:0:", -- Feralas: A History
	[9332]="0:38:15:0:20:Junk::1:0:", -- Crusted Bandages
	[9333]="0:73:4:0:20:Amulet::1:0:", -- Tarnished Silver Necklace
	[9334]="0:47:15:0:10:Junk::1:0:", -- Cracked Pottery
	[9335]="0:52:15:0:5:Junk::1:0:", -- Broken Obsidian Club
	[9336]="0:1288:15:0:5:Junk::1:0:", -- Gold-capped Troll Tusk
	[9355]="0:376:15:0:20:Junk::1:0:", -- Hoop Earring
	[9356]="0:217:15:0:5:Junk::1:0:", -- A Wooden Leg
	[9357]="0:227:15:0:10:Junk::1:0:", -- A Parrot Skeleton
	[9358]="0:228:15:0:20:Junk::1:0:", -- A Head Rag
	[9359]="0:19577:2:3:1:OneHandMace::1:0:", -- Wirt's Third Leg
	[9360]="0:400:0:1:1:FoodDrink::1:0:", -- Cuergo's Gold
	[9361]="0:400:0:1:1:FoodDrink::1:0:", -- Cuergo's Gold with Worm
	[9362]="0:0:4:2:1:Ring::1:0:", -- Brilliant Gold Ring
	[9363]="0:12:15:1:1:Junk::1:0:", -- Sparklematic-Wrapped Box
	[9364]="0:0:12:1:1:::1:0:", -- Heavy Leaden Collection Phial
	[9365]="0:0:12:1:1:::1:0:", -- High Potency Radioactive Fallout
	[9366]="0:3689:4:2:1:Mail::1:0:", -- Golden Scale Gauntlets
	[9367]="0:1250:9:2:1:Blacksmithing::1:0:", -- Plans: Golden Scale Gauntlets
	[9368]="0:0:12:1:1:::1:0:", -- Jer'kai's Signet Ring
	[9369]="0:0:12:1:20:::1:0:", -- Iridescent Sprite Darter Wing
	[9370]="0:0:12:1:1:::1:0:", -- Gordunni Scroll
	[9371]="0:0:12:1:1:::1:0:", -- Gordunni Orb
	[9372]="0:61936:2:4:1:TwoHandSword::1:0:", -- Sul'thraze the Lasher
	[9375]="0:4220:4:3:1:Leather::1:0:", -- Expert Goldminer's Helmet
	[9378]="0:11380:2:3:1:OneHandAxe::1:0:", -- Shovelphlange's Mining Axe
	[9379]="0:26383:2:3:1:OneHandSword::1:0:", -- Sang'thraze the Deflector
	[9381]="0:8628:2:3:1:Wand::1:0:", -- Earthen Rod
	[9382]="0:3608:4:2:1:Leather::1:0:", -- Tromping Miner's Boots
	[9383]="0:16895:2:3:1:TwoHandAxe::1:0:", -- Obsidian Cleaver
	[9384]="0:9789:2:3:1:Dagger::1:0:", -- Stonevault Shiv
	[9385]="0:12281:2:3:1:TwoHandSword::1:0:", -- Archaic Defender
	[9386]="0:9859:2:3:1:OneHandMace::1:0:", -- Excavator's Brand
	[9387]="0:7208:4:3:1:Plate::1:0:", -- Revelosh's Boots
	[9388]="0:3835:4:3:1:Mail::1:0:", -- Revelosh's Armguards
	[9389]="0:5198:4:3:1:Leather::1:0:", -- Revelosh's Spaulders
	[9390]="0:2576:4:3:1:Cloth::1:0:", -- Revelosh's Gloves
	[9391]="0:12831:2:3:1:TwoHandMace::1:0:", -- The Shoveler
	[9392]="0:12980:2:3:1:OneHandSword::1:0:", -- Annealed Blade
	[9393]="0:7882:4:3:1:OffHandFrill::1:0:", -- Beacon of Hope
	[9394]="0:2397:4:3:1:Plate::1:0:", -- Horned Viking Helmet
	[9395]="0:1565:4:3:1:Cloth::1:0:", -- Gloves of Old
	[9396]="0:7319:4:3:1:Mail::1:0:", -- Legguards of the Vault
	[9397]="0:3672:4:3:1:Cloak::1:0:", -- Energy Cloak
	[9398]="0:1493:4:3:1:Leather::1:0:", -- Worn Running Boots
	[9399]="0:3:6:2:1000:Arrow::1:0:", -- Precision Arrow
	[9400]="0:3248:2:3:1:Bow::1:0:", -- Baelog's Shortbow
	[9401]="0:5070:2:3:1:OneHandSword::1:0:", -- Nordic Longshank
	[9402]="0:25308:4:3:1:Leather::1:0:", -- Earthborn Kilt
	[9403]="0:2662:4:3:1:Shield::1:0:", -- Battered Viking Shield
	[9404]="0:2819:4:3:1:Shield::1:0:", -- Olaf's All Purpose Shield
	[9405]="0:2055:4:3:1:Mail::1:0:", -- Girdle of Golem Strength
	[9406]="0:4161:4:3:1:Leather::1:0:", -- Spirewind Fetter
	[9407]="0:5094:4:3:1:Cloth::1:0:", -- Stoneweaver Leggings
	[9408]="0:18639:2:3:1:Stave::1:0:", -- Ironshod Bludgeon
	[9409]="0:4490:4:3:1:Mail::1:0:", -- Ironaya's Bracers
	[9410]="0:6662:4:3:1:Plate::1:0:", -- Cragfists
	[9411]="0:8587:4:3:1:Mail::1:0:", -- Rockshard Pauldrons
	[9412]="0:16681:2:3:1:Gun::1:0:", -- Galgann's Fireblaster
	[9413]="0:32249:2:3:1:TwoHandMace::1:0:", -- The Rockpounder
	[9414]="0:10374:4:3:1:Leather::1:0:", -- Oilskin Leggings
	[9415]="0:8997:4:3:1:Cloth::1:0:", -- Grimlok's Tribal Vestments
	[9416]="0:28218:2:3:1:Polearm::1:0:", -- Grimlok's Charge
	[9418]="0:32851:2:3:1:TwoHandSword::1:0:", -- Stoneslayer
	[9419]="0:21692:2:3:1:OneHandMace::1:0:", -- Galgann's Firehammer
	[9420]="0:4083:4:3:1:Leather::1:0:", -- Adventurer's Pith Helmet
	[9421]="0:0:0:1:1:Other::1:0:", -- Major Healthstone
	[9422]="0:13052:2:3:1:Gun::1:0:", -- Shadowforge Bushmaster
	[9423]="0:25464:2:3:1:TwoHandMace::1:0:", -- The Jackhammer
	[9424]="0:13594:2:3:1:OneHandSword::1:0:", -- Ginn-su Sword
	[9425]="0:21489:2:3:1:TwoHandAxe::1:0:", -- Pendulum of Doom
	[9426]="0:10275:2:3:1:Bow::1:0:", -- Monolithic Bow
	[9427]="0:14853:2:3:1:OneHandMace::1:0:", -- Stonevault Bonebreaker
	[9428]="0:2096:4:3:1:Leather::1:0:", -- Unearthed Bands
	[9429]="0:5236:4:3:1:Cloth::1:0:", -- Miner's Hat of the Deep
	[9430]="0:8553:4:3:1:Mail::1:0:", -- Spaulders of a Lost Age
	[9431]="0:4885:4:3:1:Cloth::1:0:", -- Papal Fez
	[9432]="0:5327:4:3:1:Plate::1:0:", -- Skullplate Bracers
	[9433]="0:4133:4:3:1:Cloth::1:0:", -- Forgotten Wraps
	[9434]="0:5648:4:3:1:Cloth::1:0:", -- Elemental Raiment
	[9435]="0:2916:4:3:1:Mail::1:0:", -- Reticulated Bone Gauntlets
	[9436]="0:0:12:1:1:::1:0:", -- Faranell's Parcel
	[9437]="0:0:12:1:20:::1:0:", -- Untested Basilisk Sample
	[9438]="0:0:12:1:20:::1:0:", -- Acceptable Scorpid Sample
	[9439]="0:0:12:1:20:::1:0:", -- Untested Hyena Sample
	[9440]="0:0:12:1:20:::1:0:", -- Acceptable Basilisk Sample
	[9441]="0:0:12:1:20:::1:0:", -- Acceptable Hyena Sample
	[9442]="0:0:12:1:20:::1:0:", -- Untested Scorpid Sample
	[9444]="0:1120:4:1:1:Shield::1:0:", -- Techbot CPU Shell
	[9445]="0:2260:4:3:1:Mail::1:0:", -- Grubbis Paws
	[9446]="0:7564:2:3:1:OneHandSword::1:0:", -- Electrocutioner Leg
	[9447]="0:3237:4:3:1:Ring::1:0:", -- Electrocutioner Lagnut
	[9448]="0:1385:4:3:1:Cloth::1:0:", -- Spidertank Oilrag
	[9449]="0:9564:2:3:1:TwoHandMace::1:0:", -- Manual Crowd Pummeler
	[9450]="0:2618:4:3:1:Leather::1:0:", -- Gnomebot Operating Boots
	[9451]="0:25:0:1:20:FoodDrink::1:0:", -- Bubbling Water
	[9452]="0:8210:2:3:1:Stave::1:0:", -- Hydrocane
	[9453]="0:6592:2:3:1:Dagger::1:0:", -- Toxic Revenger
	[9454]="0:1984:4:3:1:Cloth::1:0:", -- Acidic Walkers
	[9455]="0:1826:4:3:1:Leather::1:0:", -- Emissary Cuffs
	[9456]="0:6652:2:3:1:Gun::1:0:", -- Glass Shooter
	[9457]="0:8902:2:3:1:OneHandMace::1:0:", -- Royal Diplomatic Scepter
	[9458]="0:6918:4:3:1:Shield::1:0:", -- Thermaplugg's Central Core
	[9459]="0:13560:2:3:1:TwoHandAxe::1:0:", -- Thermaplugg's Left Arm
	[9460]="0:0:12:1:20:::1:0:", -- Grimtotem Horn
	[9461]="0:4586:4:3:1:Ring::1:0:", -- Charged Gear
	[9462]="0:0:12:1:1:::1:0:", -- Crate of Grimtotem Horns
	[9463]="0:0:12:1:20:::1:0:", -- Gordunni Cobalt
	[9465]="0:18561:2:3:1:OneHandAxe::1:0:", -- Digmaster 5000
	[9466]="0:0:12:1:1:::1:0:", -- Orwin's Shovel
	[9467]="0:22418:2:3:1:Dagger::1:0:", -- Gahz'rilla Fang
	[9468]="0:0:12:1:1:::1:0:", -- Sharpbeak's Feather
	[9469]="0:14634:4:3:1:Mail::1:0:", -- Gahz'rilla Scale Armor
	[9470]="0:7858:4:3:1:Cloth::1:0:", -- Bad Mojo Mask
	[9471]="0:0:12:1:1:::1:0:", -- Nekrum's Medallion
	[9472]="0:0:13:1:1:::1:0:", -- Hexx's Key
	[9473]="0:13241:4:3:1:Leather::1:0:", -- Jinxed Hoodoo Skin
	[9474]="0:13290:4:3:1:Leather::1:0:", -- Jinxed Hoodoo Kilt
	[9475]="0:33346:2:3:1:Polearm::1:0:", -- Diabolic Skiver
	[9476]="0:15010:4:3:1:Plate::1:0:", -- Big Bad Pauldrons
	[9477]="0:35936:2:3:1:Stave::1:0:", -- The Chief's Enforcer
	[9478]="0:28853:2:3:1:OneHandAxe::1:0:", -- Ripsaw
	[9479]="0:10858:4:3:1:Leather::1:0:", -- Embrace of the Lycan
	[9480]="0:31725:2:3:1:Polearm::1:0:", -- Eyegouger
	[9481]="0:34067:2:3:1:TwoHandAxe::1:0:", -- The Minotaur
	[9482]="0:29585:2:3:1:Stave::1:0:", -- Witch Doctor's Cane
	[9483]="0:19139:2:3:1:Wand::1:0:", -- Flaming Incinerator
	[9484]="0:10962:4:3:1:Cloth::1:0:", -- Spellshock Leggings
	[9485]="0:5288:2:3:1:OneHandAxe::1:0:", -- Vibroblade
	[9486]="0:5483:2:3:1:TwoHandAxe::1:0:", -- Supercharger Battle Axe
	[9487]="0:3632:2:3:1:Gun::1:0:", -- Hi-tech Supergun
	[9488]="0:4419:2:3:1:OneHandMace::1:0:", -- Oscillating Power Hammer
	[9489]="0:3690:2:2:1:Wand::1:0:", -- Gyromatic Icemaker
	[9490]="0:6122:2:3:1:TwoHandSword::1:0:", -- Gizmotron Megachopper
	[9491]="0:1308:4:3:1:Cloth::1:0:", -- Hotshot Pilot's Gloves
	[9492]="0:3172:4:3:1:Cloth::1:0:", -- Electromagnetic Gigaflux Reactivator
	[9507]="0:0:12:1:1:::1:0:", -- A Carefully-packed Crate
	[9508]="0:2352:4:3:1:Cloth::1:0:", -- Mechbuilder's Overalls
	[9509]="0:2683:4:3:1:Leather::1:0:", -- Petrolspill Leggings
	[9510]="0:2945:4:3:1:Mail::1:0:", -- Caverndeep Trudgers
	[9511]="0:21060:2:3:1:OneHandSword::1:0:", -- Bloodletter Scalpel
	[9512]="0:6341:4:3:1:Cloak::1:0:", -- Blackmetal Cape
	[9513]="0:620:2:2:1:Stave::1:0:", -- Ley Staff
	[9514]="0:306:2:2:1:Stave::1:0:", -- Arcane Staff
	[9515]="0:2011:4:2:1:Cloth::1:0:", -- Nether-lace Tunic
	[9516]="0:2071:4:2:1:Cloth::1:0:", -- Astral Knot Blouse
	[9517]="0:15737:2:3:1:Stave::1:0:", -- Celestial Stave
	[9518]="0:1900:4:2:1:Leather::1:0:", -- Mud's Crushers
	[9519]="0:2288:4:2:1:Cloth::1:0:", -- Durtfeet Stompers
	[9520]="0:11461:2:2:1:Dagger::1:0:", -- Silent Hunter
	[9521]="0:14382:2:2:1:TwoHandAxe::1:0:", -- Skullsplitter
	[9522]="0:4938:4:2:1:Shield::1:0:", -- Energized Stone Circle
	[9523]="0:0:12:1:20:::1:0:", -- Troll Temper
	[9527]="0:21613:2:2:1:Stave::1:0:", -- Spellshifter Rod
	[9528]="0:0:12:1:1:::1:0:", -- Edana's Dark Heart
	[9530]="0:0:12:1:1:::1:0:", -- Horn of Hatetalon
	[9531]="0:9195:4:2:1:Plate::1:0:", -- Gemshale Pauldrons
	[9533]="0:7092:4:3:1:Ring::1:0:", -- Masons Fraternity Ring
	[9534]="0:8847:4:3:1:Leather::1:0:", -- Engineer's Guild Headpiece
	[9535]="0:1406:4:2:1:Mail::1:0:", -- Fire-welded Bracers
	[9536]="0:1411:4:2:1:Cloth::1:0:", -- Fairywing Mantle
	[9538]="0:6463:4:3:1:Ring::1:0:", -- Talvash's Gold Ring
	[9539]="0:50:15:1:1:Junk::1:0:", -- Box of Rations
	[9540]="0:150:15:1:1:Junk::1:0:", -- Box of Spells
	[9541]="0:200:15:1:1:Junk::1:0:", -- Box of Goodies
	[9542]="0:0:12:1:1:::1:0:", -- Simple Letter
	[9543]="0:0:12:1:1:::1:0:", -- Simple Rune
	[9544]="0:0:12:1:1:::1:0:", -- Simple Memorandum
	[9545]="0:0:12:1:1:::1:0:", -- Simple Sigil
	[9546]="0:0:12:1:1:::1:0:", -- Simple Scroll
	[9547]="0:0:12:1:1:::1:0:", -- Simple Note
	[9548]="0:0:12:1:1:::1:0:", -- Hallowed Letter
	[9550]="0:0:12:1:1:::1:0:", -- Encrypted Rune
	[9551]="0:0:12:1:1:::1:0:", -- Encrypted Sigil
	[9552]="0:0:12:1:1:::1:0:", -- Rune-Inscribed Note
	[9553]="0:0:12:1:1:::1:0:", -- Etched Parchment
	[9554]="0:0:12:1:1:::1:0:", -- Encrypted Tablet
	[9555]="0:0:12:1:1:::1:0:", -- Encrypted Letter
	[9556]="0:0:12:1:1:::1:0:", -- Hallowed Rune
	[9557]="0:0:12:1:1:::1:0:", -- Hallowed Sigil
	[9558]="0:0:12:1:1:::1:0:", -- Encrypted Memorandum
	[9559]="0:0:12:1:1:::1:0:", -- Encrypted Scroll
	[9560]="0:0:12:1:1:::1:0:", -- Encrypted Parchment
	[9561]="0:0:12:1:1:::1:0:", -- Hallowed Tablet
	[9562]="0:0:12:1:1:::1:0:", -- Rune-Inscribed Tablet
	[9563]="0:0:12:1:1:::1:0:", -- Consecrated Rune
	[9564]="0:0:12:1:1:::1:0:", -- Etched Tablet
	[9565]="0:0:12:1:1:::1:0:", -- Etched Note
	[9566]="0:0:12:1:1:::1:0:", -- Etched Rune
	[9567]="0:0:12:1:1:::1:0:", -- Etched Sigil
	[9568]="0:0:12:1:1:::1:0:", -- Rune-Inscribed Parchment
	[9569]="0:0:12:1:1:::1:0:", -- Hallowed Scroll
	[9570]="0:0:12:1:1:::1:0:", -- Consecrated Letter
	[9571]="0:0:12:1:1:::1:0:", -- Glyphic Letter
	[9573]="0:0:12:1:1:::1:0:", -- Glyphic Memorandum
	[9574]="0:0:12:1:1:::1:0:", -- Glyphic Scroll
	[9575]="0:0:12:1:1:::1:0:", -- Glyphic Tablet
	[9576]="0:0:12:1:1:::1:0:", -- Tainted Letter
	[9577]="0:0:12:1:1:::1:0:", -- Tainted Memorandum
	[9578]="0:0:12:1:1:::1:0:", -- Tainted Scroll
	[9579]="0:0:12:1:1:::1:0:", -- Tainted Parchment
	[9580]="0:0:12:1:1:::1:0:", -- Verdant Sigil
	[9581]="0:0:12:1:1:::1:0:", -- Verdant Note
	[9587]="0:6250:1:1:1:Bag::1:0:", -- Thawpelt Sack
	[9588]="0:6463:4:3:1:Ring::1:0:", -- Nogg's Gold Ring
	[9589]="0:0:12:1:20:::1:0:", -- Encrusted Minerals
	[9590]="0:0:12:1:2:::1:0:", -- Splintered Log
	[9591]="0:0:12:1:20:::1:0:", -- Resilient Sinew
	[9592]="0:0:12:1:40:::1:0:", -- Metallic Fragments
	[9593]="0:0:12:1:20:::1:0:", -- Treant Muisek
	[9594]="0:0:12:1:20:::1:0:", -- Wildkin Muisek
	[9595]="0:0:12:1:20:::1:0:", -- Hippogryph Muisek
	[9596]="0:0:12:1:20:::1:0:", -- Faerie Dragon Muisek
	[9597]="0:0:12:1:20:::1:0:", -- Mountain Giant Muisek
	[9598]="0:94:4:2:1:Cloth::1:0:", -- Sleeping Robes
	[9599]="0:142:4:2:1:Mail::1:0:", -- Barkmail Leggings
	[9600]="0:93:4:1:1:Cloth::1:0:", -- Lace Pants
	[9601]="0:87:4:1:1:Leather::1:0:", -- Cushioned Boots
	[9602]="0:301:2:2:1:TwoHandSword::1:0:", -- Brushwood Blade
	[9603]="0:302:2:2:1:Stave::1:0:", -- Gritroot Staff
	[9604]="0:5632:2:2:1:TwoHandMace::1:0:", -- Mechanic's Pipehammer
	[9605]="0:1356:4:2:1:Cloak::1:0:", -- Repairman's Cape
	[9606]="0:0:12:1:1:::1:0:", -- Treant Muisek Vessel
	[9607]="0:1762:4:2:1:Shield::1:0:", -- Bastion of Stormwind
	[9608]="0:5028:2:2:1:OneHandAxe::1:0:", -- Shoni's Disarming Tool
	[9609]="0:1009:4:2:1:Cloth::1:0:", -- Shilly Mitts
	[9618]="0:0:12:1:1:::1:0:", -- Wildkin Muisek Vessel
	[9619]="0:0:12:1:1:::1:0:", -- Hippogryph Muisek Vessel
	[9620]="0:0:12:1:1:::1:0:", -- Faerie Dragon Muisek Vessel
	[9621]="0:0:12:1:1:::1:0:", -- Mountain Giant Muisek Vessel
	[9622]="0:5665:4:2:1:Ring::1:0:", -- Reedknot Ring
	[9623]="0:4198:4:3:1:Cloth::1:0:", -- Civinad Robes
	[9624]="0:5267:4:3:1:Leather::1:0:", -- Triprunner Dungarees
	[9625]="0:6344:4:3:1:Mail::1:0:", -- Dual Reinforced Leggings
	[9626]="0:16243:2:2:1:TwoHandAxe::1:0:", -- Dwarven Charge
	[9627]="0:2542:4:2:1:OffHandFrill::1:0:", -- Explorers' League Lodestar
	[9628]="0:0:12:1:1:::1:0:", -- Neeru's Herb Pouch
	[9629]="0:0:12:1:1:::1:0:", -- A Shrunken Head
	[9630]="0:5780:4:2:1:Leather::1:0:", -- Pratt's Handcrafted Boots
	[9631]="0:3868:4:2:1:Leather::1:0:", -- Pratt's Handcrafted Gloves
	[9632]="0:3883:4:2:1:Leather::1:0:", -- Jangdor's Handcrafted Gloves
	[9633]="0:5847:4:2:1:Leather::1:0:", -- Jangdor's Handcrafted Boots
	[9634]="0:3381:4:2:1:Cloth::1:0:", -- Skilled Handling Gloves
	[9635]="0:4713:4:2:1:Cloak::1:0:", -- Master Apothecary Cape
	[9636]="0:3154:4:2:1:Cloth::1:0:", -- Swashbuckler Sash
	[9637]="0:8296:4:2:1:Plate::1:0:", -- Shinkicker Boots
	[9638]="0:6875:4:2:1:Mail::1:0:", -- Chelonian Cuffs
	[9639]="0:24111:2:3:1:OneHandMace::1:0:", -- The Hand of Antu'sul
	[9640]="0:8519:4:3:1:Plate::1:0:", -- Vice Grips
	[9641]="0:13041:4:3:1:Amulet::1:0:", -- Lifeblood Amulet
	[9642]="0:2092:4:2:1:Ring::1:0:", -- Band of the Great Tortoise
	[9643]="0:15988:4:2:1:Shield::1:0:", -- Optomatic Deflector
	[9644]="0:9885:4:2:1:OffHandFrill::1:0:", -- Thermotastic Egg Timer
	[9645]="0:6768:4:2:1:Cloth::1:0:", -- Gnomish Inventor Boots
	[9646]="0:11863:4:2:1:Plate::1:0:", -- Gnomish Water Sinking Device
	[9647]="0:7962:4:2:1:Leather::1:0:", -- Failed Flying Experiment
	[9648]="0:6392:4:2:1:Cloak::1:0:", -- Chainlink Towel
	[9649]="0:15875:4:3:1:Cloth::1:0:", -- Royal Highmark Vestments
	[9650]="0:21619:4:3:1:Mail::1:0:", -- Honorguard Chestpiece
	[9651]="0:32193:2:3:1:OneHandMace::1:0:", -- Gryphon Rider's Stormhammer
	[9652]="0:16159:4:3:1:Leather::1:0:", -- Gryphon Rider's Leggings
	[9653]="0:6745:4:2:1:Cloth::1:0:", -- Speedy Racer Goggles
	[9654]="0:16929:2:2:1:Wand::1:0:", -- Cairnstone Sliver
	[9655]="0:7092:4:2:1:Ring::1:0:", -- Seedtime Hoop
	[9656]="0:7482:4:2:1:Plate::1:0:", -- Granite Grips
	[9657]="0:5333:4:2:1:Leather::1:0:", -- Vinehedge Cinch
	[9658]="0:4086:4:2:1:Cloth::1:0:", -- Boots of the Maharishi
	[9660]="0:4227:4:2:1:Cloak::1:0:", -- Stargazer Cloak
	[9661]="0:9051:4:2:1:Shield::1:0:", -- Earthclasp Barrier
	[9662]="0:7437:4:2:1:Plate::1:0:", -- Rushridge Boots
	[9663]="0:9969:4:2:1:Mail::1:0:", -- Dawnrider's Chestpiece
	[9664]="0:8738:4:2:1:Plate::1:0:", -- Sentinel's Guard
	[9665]="0:4827:4:2:1:Cloth::1:0:", -- Wingcrest Gloves
	[9666]="0:7266:4:2:1:Mail::1:0:", -- Stronghorn Girdle
	[9678]="0:17486:2:2:1:TwoHandMace::1:0:", -- Tok'kar's Murloc Basher
	[9679]="0:17550:2:2:1:TwoHandAxe::1:0:", -- Tok'kar's Murloc Chopper
	[9680]="0:14090:2:2:1:Dagger::1:0:", -- Tok'kar's Murloc Shanker
	[9681]="0:50:0:1:20:FoodDrink::1:0:", -- Grilled King Crawler Legs
	[9682]="0:3832:4:2:1:Leather::1:0:", -- Leather Chef's Belt
	[9683]="0:38459:2:3:1:Stave::1:0:", -- Strength of the Treant
	[9684]="0:30875:2:3:1:OneHandAxe::1:0:", -- Force of the Hippogryph
	[9686]="0:31097:2:3:1:OneHandMace::1:0:", -- Spirit of the Faerie Dragon
	[9687]="0:1554:4:2:1:Leather::1:0:", -- Grappler's Belt
	[9698]="0:1505:4:2:1:Leather::1:0:", -- Gloves of Insight
	[9699]="0:1812:4:2:1:Cloak::1:0:", -- Garrison Cloak
	[9703]="0:4272:4:2:1:Cloak::1:0:", -- Scorched Cape
	[9704]="0:3573:4:2:1:Leather::1:0:", -- Rustler Gloves
	[9705]="0:3586:4:2:1:Leather::1:0:", -- Tharg's Shoelace
	[9706]="0:9212:4:2:1:Shield::1:0:", -- Tharg's Disk
	[9718]="0:11421:2:3:1:OneHandSword::1:0:", -- Reforged Blade of Heroes
	[9719]="0:6250:7:3:1:Other::1:0:", -- Broken Blade of Heroes
	[9738]="0:0:12:1:20:::1:0:", -- Gem of Cobrahn
	[9739]="0:0:12:1:20:::1:0:", -- Gem of Anacondra
	[9740]="0:0:12:1:20:::1:0:", -- Gem of Pythas
	[9741]="0:0:12:1:20:::1:0:", -- Gem of Serpentis
	[9742]="0:49:4:1:1:Cloth::1:0:", -- Simple Cord
	[9743]="0:67:4:1:1:Cloth::1:0:", -- Simple Shoes
	[9744]="0:45:4:1:1:Cloth::1:0:", -- Simple Bands
	[9745]="0:54:4:1:1:Cloak::1:0:", -- Simple Cape
	[9746]="0:56:4:1:1:Cloth::1:0:", -- Simple Gloves
	[9747]="0:227:4:2:1:Cloth::1:0:", -- Simple Britches
	[9748]="0:274:4:2:1:Cloth::1:0:", -- Simple Robe
	[9749]="0:275:4:2:1:Cloth::1:0:", -- Simple Blouse
	[9750]="0:57:4:1:1:Leather::1:0:", -- Gypsy Sash
	[9751]="0:86:4:1:1:Leather::1:0:", -- Gypsy Sandals
	[9752]="0:58:4:1:1:Leather::1:0:", -- Gypsy Bands
	[9753]="0:248:4:2:1:Shield::1:0:", -- Gypsy Buckler
	[9754]="0:56:4:1:1:Cloak::1:0:", -- Gypsy Cloak
	[9755]="0:73:4:1:1:Leather::1:0:", -- Gypsy Gloves
	[9756]="0:294:4:2:1:Leather::1:0:", -- Gypsy Trousers
	[9757]="0:364:4:2:1:Leather::1:0:", -- Gypsy Tunic
	[9758]="0:73:4:1:1:Mail::1:0:", -- Cadet Belt
	[9759]="0:138:4:1:1:Mail::1:0:", -- Cadet Boots
	[9760]="0:73:4:1:1:Mail::1:0:", -- Cadet Bracers
	[9761]="0:59:4:1:1:Cloak::1:0:", -- Cadet Cloak
	[9762]="0:92:4:1:1:Mail::1:0:", -- Cadet Gauntlets
	[9763]="0:336:4:2:1:Mail::1:0:", -- Cadet Leggings
	[9764]="0:300:4:2:1:Shield::1:0:", -- Cadet Shield
	[9765]="0:406:4:2:1:Mail::1:0:", -- Cadet Vest
	[9766]="0:362:4:2:1:Cloth::1:0:", -- Greenweave Sash
	[9767]="0:616:4:2:1:Cloth::1:0:", -- Greenweave Sandals
	[9768]="0:317:4:2:1:Cloth::1:0:", -- Greenweave Bracers
	[9769]="0:1637:4:2:1:OffHandFrill::1:0:", -- Greenweave Branch
	[9770]="0:417:4:2:1:Cloak::1:0:", -- Greenweave Cloak
	[9771]="0:532:4:2:1:Cloth::1:0:", -- Greenweave Gloves
	[9772]="0:1328:4:2:1:Cloth::1:0:", -- Greenweave Leggings
	[9773]="0:1369:4:2:1:Cloth::1:0:", -- Greenweave Robe
	[9774]="0:1374:4:2:1:Cloth::1:0:", -- Greenweave Vest
	[9775]="0:316:4:2:1:Leather::1:0:", -- Bandit Cinch
	[9776]="0:547:4:2:1:Leather::1:0:", -- Bandit Boots
	[9777]="0:318:4:2:1:Leather::1:0:", -- Bandit Bracers
	[9778]="0:940:4:2:1:Shield::1:0:", -- Bandit Buckler
	[9779]="0:334:4:2:1:Cloak::1:0:", -- Bandit Cloak
	[9780]="0:370:4:2:1:Leather::1:0:", -- Bandit Gloves
	[9781]="0:982:4:2:1:Leather::1:0:", -- Bandit Pants
	[9782]="0:1113:4:2:1:Leather::1:0:", -- Bandit Jerkin
	[9783]="0:812:4:2:1:Mail::1:0:", -- Raider's Chestpiece
	[9784]="0:533:4:2:1:Mail::1:0:", -- Raider's Boots
	[9785]="0:269:4:2:1:Mail::1:0:", -- Raider's Bracers
	[9786]="0:234:4:2:1:Cloak::1:0:", -- Raider's Cloak
	[9787]="0:358:4:2:1:Mail::1:0:", -- Raider's Gauntlets
	[9788]="0:312:4:2:1:Mail::1:0:", -- Raider's Belt
	[9789]="0:742:4:2:1:Mail::1:0:", -- Raider's Legguards
	[9790]="0:794:4:2:1:Shield::1:0:", -- Raider's Shield
	[9791]="0:1644:4:2:1:Cloth::1:0:", -- Ivycloth Tunic
	[9792]="0:823:4:2:1:Cloth::1:0:", -- Ivycloth Boots
	[9793]="0:550:4:2:1:Cloth::1:0:", -- Ivycloth Bracelets
	[9794]="0:829:4:2:1:Cloak::1:0:", -- Ivycloth Cloak
	[9795]="0:626:4:2:1:Cloth::1:0:", -- Ivycloth Gloves
	[9796]="0:1038:4:2:1:Cloth::1:0:", -- Ivycloth Mantle
	[9797]="0:1528:4:2:1:Cloth::1:0:", -- Ivycloth Pants
	[9798]="0:1686:4:2:1:Cloth::1:0:", -- Ivycloth Robe
	[9799]="0:635:4:2:1:Cloth::1:0:", -- Ivycloth Sash
	[9800]="0:2027:4:2:1:OffHandFrill::1:0:", -- Ivy Orb
	[9801]="0:708:4:2:1:Leather::1:0:", -- Superior Belt
	[9802]="0:1205:4:2:1:Leather::1:0:", -- Superior Boots
	[9803]="0:729:4:2:1:Leather::1:0:", -- Superior Bracers
	[9804]="0:1874:4:2:1:Shield::1:0:", -- Superior Buckler
	[9805]="0:709:4:2:1:Cloak::1:0:", -- Superior Cloak
	[9806]="0:834:4:2:1:Leather::1:0:", -- Superior Gloves
	[9807]="0:1255:4:2:1:Leather::1:0:", -- Superior Shoulders
	[9808]="0:1848:4:2:1:Leather::1:0:", -- Superior Leggings
	[9809]="0:1855:4:2:1:Leather::1:0:", -- Superior Tunic
	[9810]="0:1231:4:2:1:Mail::1:0:", -- Fortified Boots
	[9811]="0:725:4:2:1:Mail::1:0:", -- Fortified Bracers
	[9812]="0:570:4:2:1:Cloak::1:0:", -- Fortified Cloak
	[9813]="0:826:4:2:1:Mail::1:0:", -- Fortified Gauntlets
	[9814]="0:733:4:2:1:Mail::1:0:", -- Fortified Belt
	[9815]="0:1664:4:2:1:Mail::1:0:", -- Fortified Leggings
	[9816]="0:1781:4:2:1:Shield::1:0:", -- Fortified Shield
	[9817]="0:1426:4:2:1:Mail::1:0:", -- Fortified Spaulders
	[9818]="0:1682:4:2:1:Mail::1:0:", -- Fortified Chain
	[9819]="0:2726:4:2:1:Cloth::1:0:", -- Durable Tunic
	[9820]="0:1541:4:2:1:Cloth::1:0:", -- Durable Boots
	[9821]="0:871:4:2:1:Cloth::1:0:", -- Durable Bracers
	[9822]="0:1192:4:2:1:Cloak::1:0:", -- Durable Cape
	[9823]="0:965:4:2:1:Cloth::1:0:", -- Durable Gloves
	[9824]="0:1599:4:2:1:Cloth::1:0:", -- Durable Shoulders
	[9825]="0:2355:4:2:1:Cloth::1:0:", -- Durable Pants
	[9826]="0:2600:4:2:1:Cloth::1:0:", -- Durable Robe
	[9827]="0:1114:4:2:1:Leather::1:0:", -- Scaled Leather Belt
	[9828]="0:1845:4:2:1:Leather::1:0:", -- Scaled Leather Boots
	[9829]="0:1020:4:2:1:Leather::1:0:", -- Scaled Leather Bracers
	[9830]="0:3489:4:2:1:Shield::1:0:", -- Scaled Shield
	[9831]="0:1233:4:2:1:Cloak::1:0:", -- Scaled Cloak
	[9832]="0:1248:4:2:1:Leather::1:0:", -- Scaled Leather Gloves
	[9833]="0:3031:4:2:1:Leather::1:0:", -- Scaled Leather Leggings
	[9834]="0:2074:4:2:1:Leather::1:0:", -- Scaled Leather Shoulders
	[9835]="0:3053:4:2:1:Leather::1:0:", -- Scaled Leather Tunic
	[9836]="0:3677:4:2:1:Mail::1:0:", -- Banded Armor
	[9837]="0:1287:4:2:1:Mail::1:0:", -- Banded Bracers
	[9838]="0:1174:4:2:1:Cloak::1:0:", -- Banded Cloak
	[9839]="0:1426:4:2:1:Mail::1:0:", -- Banded Gauntlets
	[9840]="0:1432:4:2:1:Mail::1:0:", -- Banded Girdle
	[9841]="0:3163:4:2:1:Mail::1:0:", -- Banded Leggings
	[9842]="0:2391:4:2:1:Mail::1:0:", -- Banded Pauldrons
	[9843]="0:3739:4:2:1:Shield::1:0:", -- Banded Shield
	[9844]="0:3709:4:2:1:Cloth::1:0:", -- Conjurer's Vest
	[9845]="0:2136:4:2:1:Cloth::1:0:", -- Conjurer's Shoes
	[9846]="0:1429:4:2:1:Cloth::1:0:", -- Conjurer's Bracers
	[9847]="0:1779:4:2:1:Cloak::1:0:", -- Conjurer's Cloak
	[9848]="0:1584:4:2:1:Cloth::1:0:", -- Conjurer's Gloves
	[9849]="0:2385:4:2:1:Cloth::1:0:", -- Conjurer's Hood
	[9850]="0:2394:4:2:1:Cloth::1:0:", -- Conjurer's Mantle
	[9851]="0:3524:4:2:1:Cloth::1:0:", -- Conjurer's Breeches
	[9852]="0:3820:4:2:1:Cloth::1:0:", -- Conjurer's Robe
	[9853]="0:1368:4:2:1:Cloth::1:0:", -- Conjurer's Cinch
	[9854]="0:4935:4:2:1:Leather::1:0:", -- Archer's Jerkin
	[9855]="0:1895:4:2:1:Leather::1:0:", -- Archer's Belt
	[9856]="0:2839:4:2:1:Leather::1:0:", -- Archer's Boots
	[9857]="0:1570:4:2:1:Leather::1:0:", -- Archer's Bracers
	[9858]="0:4882:4:2:1:Shield::1:0:", -- Archer's Buckler
	[9859]="0:2872:4:2:1:Leather::1:0:", -- Archer's Cap
	[9860]="0:1906:4:2:1:Cloak::1:0:", -- Archer's Cloak
	[9861]="0:1753:4:2:1:Leather::1:0:", -- Archer's Gloves
	[9862]="0:4260:4:2:1:Leather::1:0:", -- Archer's Trousers
	[9863]="0:3207:4:2:1:Leather::1:0:", -- Archer's Shoulderpads
	[9864]="0:3527:4:2:1:Mail::1:0:", -- Renegade Boots
	[9865]="0:1942:4:2:1:Mail::1:0:", -- Renegade Bracers
	[9866]="0:5605:4:2:1:Mail::1:0:", -- Renegade Chestguard
	[9867]="0:1779:4:2:1:Cloak::1:0:", -- Renegade Cloak
	[9868]="0:2160:4:2:1:Mail::1:0:", -- Renegade Gauntlets
	[9869]="0:2225:4:2:1:Mail::1:0:", -- Renegade Belt
	[9870]="0:3686:4:2:1:Mail::1:0:", -- Renegade Circlet
	[9871]="0:5425:4:2:1:Mail::1:0:", -- Renegade Leggings
	[9872]="0:4101:4:2:1:Mail::1:0:", -- Renegade Pauldrons
	[9873]="0:5828:4:2:1:Shield::1:0:", -- Renegade Shield
	[9874]="0:5801:4:2:1:Cloth::1:0:", -- Sorcerer Drape
	[9875]="0:2139:4:2:1:Cloth::1:0:", -- Sorcerer Sash
	[9876]="0:3146:4:2:1:Cloth::1:0:", -- Sorcerer Slippers
	[9877]="0:2708:4:2:1:Cloak::1:0:", -- Sorcerer Cloak
	[9878]="0:3425:4:2:1:Cloth::1:0:", -- Sorcerer Hat
	[9879]="0:1964:4:2:1:Cloth::1:0:", -- Sorcerer Bracelets
	[9880]="0:2130:4:2:1:Cloth::1:0:", -- Sorcerer Gloves
	[9881]="0:3464:4:2:1:Cloth::1:0:", -- Sorcerer Mantle
	[9882]="0:6209:4:2:1:OffHandFrill::1:0:", -- Sorcerer Sphere
	[9883]="0:5026:4:2:1:Cloth::1:0:", -- Sorcerer Pants
	[9884]="0:5448:4:2:1:Cloth::1:0:", -- Sorcerer Robe
	[9885]="0:4180:4:2:1:Leather::1:0:", -- Huntsman's Boots
	[9886]="0:2589:4:2:1:Leather::1:0:", -- Huntsman's Bands
	[9887]="0:7071:4:2:1:Leather::1:0:", -- Huntsman's Armor
	[9889]="0:4240:4:2:1:Leather::1:0:", -- Huntsman's Cap
	[9890]="0:2919:4:2:1:Cloak::1:0:", -- Huntsman's Cape
	[9891]="0:2636:4:2:1:Leather::1:0:", -- Huntsman's Belt
	[9892]="0:2857:4:2:1:Leather::1:0:", -- Huntsman's Gloves
	[9893]="0:6689:4:2:1:Leather::1:0:", -- Huntsman's Leggings
	[9894]="0:4661:4:2:1:Leather::1:0:", -- Huntsman's Shoulders
	[9895]="0:5221:4:2:1:Mail::1:0:", -- Jazeraint Boots
	[9896]="0:2913:4:2:1:Mail::1:0:", -- Jazeraint Bracers
	[9897]="0:7368:4:2:1:Mail::1:0:", -- Jazeraint Chestguard
	[9898]="0:2718:4:2:1:Cloak::1:0:", -- Jazeraint Cloak
	[9899]="0:7920:4:2:1:Shield::1:0:", -- Jazeraint Shield
	[9900]="0:3195:4:2:1:Mail::1:0:", -- Jazeraint Gauntlets
	[9901]="0:3295:4:2:1:Mail::1:0:", -- Jazeraint Belt
	[9902]="0:5357:4:2:1:Mail::1:0:", -- Jazeraint Helm
	[9903]="0:7743:4:2:1:Mail::1:0:", -- Jazeraint Leggings
	[9904]="0:5420:4:2:1:Mail::1:0:", -- Jazeraint Pauldrons
	[9905]="0:8251:4:2:1:Cloth::1:0:", -- Royal Blouse
	[9906]="0:3043:4:2:1:Cloth::1:0:", -- Royal Sash
	[9907]="0:4581:4:2:1:Cloth::1:0:", -- Royal Boots
	[9908]="0:4257:4:2:1:Cloak::1:0:", -- Royal Cape
	[9909]="0:2848:4:2:1:Cloth::1:0:", -- Royal Bands
	[9910]="0:3087:4:2:1:Cloth::1:0:", -- Royal Gloves
	[9911]="0:7228:4:2:1:Cloth::1:0:", -- Royal Trousers
	[9912]="0:5037:4:2:1:Cloth::1:0:", -- Royal Amice
	[9913]="0:8491:4:2:1:Cloth::1:0:", -- Royal Gown
	[9914]="0:7557:4:2:1:OffHandFrill::1:0:", -- Royal Scepter
	[9915]="0:5091:4:2:1:Cloth::1:0:", -- Royal Headband
	[9916]="0:3566:4:2:1:Leather::1:0:", -- Tracker's Belt
	[9917]="0:5519:4:2:1:Leather::1:0:", -- Tracker's Boots
	[9918]="0:10212:4:2:1:Shield::1:0:", -- Brigade Defender
	[9919]="0:4119:4:2:1:Cloak::1:0:", -- Tracker's Cloak
	[9920]="0:3721:4:2:1:Leather::1:0:", -- Tracker's Gloves
	[9921]="0:6050:4:2:1:Leather::1:0:", -- Tracker's Headband
	[9922]="0:8745:4:2:1:Leather::1:0:", -- Tracker's Leggings
	[9923]="0:6095:4:2:1:Leather::1:0:", -- Tracker's Shoulderpads
	[9924]="0:10276:4:2:1:Leather::1:0:", -- Tracker's Tunic
	[9925]="0:3790:4:2:1:Leather::1:0:", -- Tracker's Wristguards
	[9926]="0:6368:4:2:1:Mail::1:0:", -- Brigade Boots
	[9927]="0:3927:4:2:1:Mail::1:0:", -- Brigade Bracers
	[9928]="0:9930:4:2:1:Mail::1:0:", -- Brigade Breastplate
	[9929]="0:3662:4:2:1:Cloak::1:0:", -- Brigade Cloak
	[9930]="0:4287:4:2:1:Mail::1:0:", -- Brigade Gauntlets
	[9931]="0:4303:4:2:1:Mail::1:0:", -- Brigade Girdle
	[9932]="0:6995:4:2:1:Mail::1:0:", -- Brigade Circlet
	[9933]="0:9394:4:2:1:Mail::1:0:", -- Brigade Leggings
	[9934]="0:6577:4:2:1:Mail::1:0:", -- Brigade Pauldrons
	[9935]="0:10097:4:2:1:Shield::1:0:", -- Embossed Plate Shield
	[9936]="0:6403:4:2:1:Cloth::1:0:", -- Abjurer's Boots
	[9937]="0:4004:4:2:1:Cloth::1:0:", -- Abjurer's Bands
	[9938]="0:6029:4:2:1:Cloak::1:0:", -- Abjurer's Cloak
	[9939]="0:4317:4:2:1:Cloth::1:0:", -- Abjurer's Gloves
	[9940]="0:6954:4:2:1:Cloth::1:0:", -- Abjurer's Hood
	[9941]="0:6523:4:2:1:Cloth::1:0:", -- Abjurer's Mantle
	[9942]="0:9341:4:2:1:Cloth::1:0:", -- Abjurer's Pants
	[9943]="0:11271:4:2:1:Cloth::1:0:", -- Abjurer's Robe
	[9944]="0:8570:4:2:1:OffHandFrill::1:0:", -- Abjurer's Crystal
	[9945]="0:4124:4:2:1:Cloth::1:0:", -- Abjurer's Sash
	[9946]="0:11396:4:2:1:Cloth::1:0:", -- Abjurer's Tunic
	[9947]="0:5193:4:2:1:Leather::1:0:", -- Chieftain's Belt
	[9948]="0:8365:4:2:1:Leather::1:0:", -- Chieftain's Boots
	[9949]="0:4855:4:2:1:Leather::1:0:", -- Chieftain's Bracers
	[9950]="0:13418:4:2:1:Leather::1:0:", -- Chieftain's Breastplate
	[9951]="0:5436:4:2:1:Cloak::1:0:", -- Chieftain's Cloak
	[9952]="0:5255:4:2:1:Leather::1:0:", -- Chieftain's Gloves
	[9953]="0:8467:4:2:1:Leather::1:0:", -- Chieftain's Headdress
	[9954]="0:12126:4:2:1:Leather::1:0:", -- Chieftain's Leggings
	[9955]="0:8531:4:2:1:Leather::1:0:", -- Chieftain's Shoulders
	[9956]="0:5130:4:2:1:Mail::1:0:", -- Warmonger's Bracers
	[9957]="0:13753:4:2:1:Mail::1:0:", -- Warmonger's Chestpiece
	[9958]="0:14724:4:2:1:Shield::1:0:", -- Warmonger's Buckler
	[9959]="0:4803:4:2:1:Cloak::1:0:", -- Warmonger's Cloak
	[9960]="0:5623:4:2:1:Mail::1:0:", -- Warmonger's Gauntlets
	[9961]="0:5644:4:2:1:Mail::1:0:", -- Warmonger's Belt
	[9962]="0:9218:4:2:1:Mail::1:0:", -- Warmonger's Greaves
	[9963]="0:9211:4:2:1:Mail::1:0:", -- Warmonger's Circlet
	[9964]="0:13190:4:2:1:Mail::1:0:", -- Warmonger's Leggings
	[9965]="0:9973:4:2:1:Mail::1:0:", -- Warmonger's Pauldrons
	[9966]="0:11800:4:2:1:Plate::1:0:", -- Embossed Plate Armor
	[9967]="0:5105:4:2:1:Plate::1:0:", -- Embossed Plate Gauntlets
	[9968]="0:4744:4:2:1:Plate::1:0:", -- Embossed Plate Girdle
	[9969]="0:6925:4:2:1:Plate::1:0:", -- Embossed Plate Helmet
	[9970]="0:10029:4:2:1:Plate::1:0:", -- Embossed Plate Leggings
	[9971]="0:6978:4:2:1:Plate::1:0:", -- Embossed Plate Pauldrons
	[9972]="0:4357:4:2:1:Plate::1:0:", -- Embossed Plate Bracers
	[9973]="0:6510:4:2:1:Plate::1:0:", -- Embossed Plate Boots
	[9974]="0:16449:4:2:1:Shield::1:0:", -- Overlord's Shield
	[9978]="0:0:12:1:1:::1:0:", -- Gahz'ridian Detector
	[9998]="0:4815:4:2:1:Cloth::1:0:", -- Black Mageweave Vest
	[9999]="0:4833:4:2:1:Cloth::1:0:", -- Black Mageweave Leggings
	[10000]="0:0:12:1:1:::1:0:", -- Margol's Horn
	[10001]="0:5257:4:2:1:Cloth::1:0:", -- Black Mageweave Robe
	[10002]="0:5276:4:2:1:Cloth::1:0:", -- Shadoweave Pants
	[10003]="0:2859:4:2:1:Cloth::1:0:", -- Black Mageweave Gloves
	[10004]="0:5738:4:2:1:Cloth::1:0:", -- Shadoweave Robe
	[10005]="0:0:12:1:1:::1:0:", -- Margol's Gigantic Horn
	[10007]="0:5800:4:2:1:Cloth::1:0:", -- Red Mageweave Vest
	[10008]="0:4365:4:2:1:Cloth::1:0:", -- White Bandit Mask
	[10009]="0:5284:4:2:1:Cloth::1:0:", -- Red Mageweave Pants
	[10010]="0:5729:4:2:1:Cloth::1:0:", -- Stormcloth Pants
	[10011]="0:2875:4:2:1:Cloth::1:0:", -- Stormcloth Gloves
	[10018]="0:3275:4:2:1:Cloth::1:0:", -- Red Mageweave Gloves
	[10019]="0:3944:4:3:1:Cloth::1:0:", -- Dreamweave Gloves
	[10020]="0:6597:4:2:1:Cloth::1:0:", -- Stormcloth Vest
	[10021]="0:7946:4:3:1:Cloth::1:0:", -- Dreamweave Vest
	[10022]="0:0:12:1:1:::1:0:", -- Proof of Deed
	[10023]="0:3334:4:2:1:Cloth::1:0:", -- Shadoweave Gloves
	[10024]="0:5421:4:2:1:Cloth::1:0:", -- Black Mageweave Headband
	[10025]="0:6790:4:2:1:Cloth::1:0:", -- Shadoweave Mask
	[10026]="0:5459:4:2:1:Cloth:202:1:0:", -- Black Mageweave Boots
	[10027]="0:5479:4:2:1:Cloth::1:0:", -- Black Mageweave Shoulders
	[10028]="0:5938:4:2:1:Cloth::1:0:", -- Shadoweave Shoulders
	[10029]="0:5391:4:2:1:Cloth::1:0:", -- Red Mageweave Shoulders
	[10030]="0:6007:4:2:1:Cloth::1:0:", -- Admiral's Hat
	[10031]="0:6030:4:2:1:Cloth::1:0:", -- Shadoweave Boots
	[10032]="0:6052:4:2:1:Cloth::1:0:", -- Stormcloth Headband
	[10033]="0:6075:4:2:1:Cloth::1:0:", -- Red Mageweave Headband
	[10034]="0:2000:4:1:1:Shirt::1:0:", -- Tuxedo Shirt
	[10035]="0:1735:4:1:1:Cloth::1:0:", -- Tuxedo Pants
	[10036]="0:1741:4:1:1:Cloth::1:0:", -- Tuxedo Jacket
	[10038]="0:6620:4:2:1:Cloth::1:0:", -- Stormcloth Shoulders
	[10039]="0:7110:4:2:1:Cloth::1:0:", -- Stormcloth Boots
	[10040]="0:1767:4:1:1:Cloth::1:0:", -- White Wedding Dress
	[10041]="0:8593:4:3:1:Cloth::1:0:", -- Dreamweave Circlet
	[10042]="0:6644:4:2:1:Cloth::1:0:", -- Cindercloth Robe
	[10043]="0:2033:4:2:1:Cloth::1:0:", -- Pious Legwraps
	[10044]="0:6765:4:2:1:Cloth::1:0:", -- Cindercloth Boots
	[10045]="0:23:4:1:1:Cloth::1:0:", -- Simple Linen Pants
	[10046]="0:32:4:1:1:Cloth::1:0:", -- Simple Linen Boots
	[10047]="0:274:4:2:1:Cloth::1:0:", -- Simple Kilt
	[10048]="0:935:4:2:1:Cloth::1:0:", -- Colorful Kilt
	[10050]="0:2500:1:1:1:Bag::1:0:", -- Mageweave Bag
	[10051]="0:2500:1:1:1:Bag::1:0:", -- Red Mageweave Bag
	[10052]="0:1500:4:1:1:Shirt::1:0:", -- Orange Martial Shirt
	[10053]="0:4499:4:1:1:Miscellaneous::1:0:", -- Simple Black Dress
	[10054]="0:3000:4:1:1:Shirt::1:0:", -- Lavender Mageweave Shirt
	[10055]="0:3000:4:1:1:Shirt::1:0:", -- Pink Mageweave Shirt
	[10056]="0:1500:4:1:1:Shirt::1:0:", -- Orange Mageweave Shirt
	[10057]="0:12711:4:2:1:Cloth::1:0:", -- Duskwoven Tunic
	[10058]="0:7083:4:2:1:Cloth::1:0:", -- Duskwoven Sandals
	[10059]="0:4739:4:2:1:Cloth::1:0:", -- Duskwoven Bracers
	[10060]="0:6668:4:2:1:Cloak::1:0:", -- Duskwoven Cape
	[10061]="0:7661:4:2:1:Cloth::1:0:", -- Duskwoven Turban
	[10062]="0:4758:4:2:1:Cloth::1:0:", -- Duskwoven Gloves
	[10063]="0:7165:4:2:1:Cloth::1:0:", -- Duskwoven Amice
	[10064]="0:10775:4:2:1:Cloth::1:0:", -- Duskwoven Pants
	[10065]="0:12153:4:2:1:Cloth::1:0:", -- Duskwoven Robe
	[10066]="0:4220:4:2:1:Cloth::1:0:", -- Duskwoven Sash
	[10067]="0:5295:4:2:1:Leather::1:0:", -- Righteous Waistguard
	[10068]="0:9128:4:2:1:Leather::1:0:", -- Righteous Boots
	[10069]="0:5335:4:2:1:Leather::1:0:", -- Righteous Bracers
	[10070]="0:15482:4:2:1:Leather::1:0:", -- Righteous Armor
	[10071]="0:6450:4:2:1:Cloak::1:0:", -- Righteous Cloak
	[10072]="0:6177:4:2:1:Leather::1:0:", -- Righteous Gloves
	[10073]="0:9858:4:2:1:Leather::1:0:", -- Righteous Helmet
	[10074]="0:13985:4:2:1:Leather::1:0:", -- Righteous Leggings
	[10075]="0:9369:4:2:1:Leather::1:0:", -- Righteous Spaulders
	[10076]="0:6571:4:2:1:Mail::1:0:", -- Lord's Armguards
	[10077]="0:16968:4:2:1:Mail::1:0:", -- Lord's Breastplate
	[10078]="0:18642:4:2:1:Shield::1:0:", -- Lord's Crest
	[10079]="0:6370:4:2:1:Cloak::1:0:", -- Lord's Cape
	[10080]="0:7319:4:2:1:Mail::1:0:", -- Lord's Gauntlets
	[10081]="0:7345:4:2:1:Mail::1:0:", -- Lord's Girdle
	[10082]="0:10752:4:2:1:Mail::1:0:", -- Lord's Boots
	[10083]="0:10745:4:2:1:Mail::1:0:", -- Lord's Crown
	[10084]="0:15246:4:2:1:Mail::1:0:", -- Lord's Legguards
	[10085]="0:11529:4:2:1:Mail::1:0:", -- Lord's Pauldrons
	[10086]="0:14768:4:2:1:Plate::1:0:", -- Gothic Plate Armor
	[10087]="0:5973:4:2:1:Plate::1:0:", -- Gothic Plate Gauntlets
	[10088]="0:5551:4:2:1:Plate::1:0:", -- Gothic Plate Girdle
	[10089]="0:8296:4:2:1:Plate::1:0:", -- Gothic Sabatons
	[10090]="0:8992:4:2:1:Plate::1:0:", -- Gothic Plate Helmet
	[10091]="0:13023:4:2:1:Plate::1:0:", -- Gothic Plate Leggings
	[10092]="0:9785:4:2:1:Plate::1:0:", -- Gothic Plate Spaulders
	[10093]="0:18903:4:2:1:Shield::1:0:", -- Revenant Deflector
	[10094]="0:5828:4:2:1:Plate::1:0:", -- Gothic Plate Vambraces
	[10095]="0:10295:4:2:1:Cloth::1:0:", -- Councillor's Boots
	[10096]="0:6130:4:2:1:Cloth::1:0:", -- Councillor's Cuffs
	[10097]="0:10992:4:2:1:Cloth::1:0:", -- Councillor's Circlet
	[10098]="0:8737:4:2:1:Cloak::1:0:", -- Councillor's Cloak
	[10099]="0:6568:4:2:1:Cloth::1:0:", -- Councillor's Gloves
	[10100]="0:11109:4:2:1:Cloth::1:0:", -- Councillor's Shoulders
	[10101]="0:15756:4:2:1:Cloth::1:0:", -- Councillor's Pants
	[10102]="0:15020:4:2:1:Cloth::1:0:", -- Councillor's Robes
	[10103]="0:5687:4:2:1:Cloth::1:0:", -- Councillor's Sash
	[10104]="0:15137:4:2:1:Cloth::1:0:", -- Councillor's Tunic
	[10105]="0:19942:4:2:1:Leather::1:0:", -- Wanderer's Armor
	[10106]="0:12120:4:2:1:Leather::1:0:", -- Wanderer's Boots
	[10107]="0:7218:4:2:1:Leather::1:0:", -- Wanderer's Bracers
	[10108]="0:8203:4:2:1:Cloak::1:0:", -- Wanderer's Cloak
	[10109]="0:7273:4:2:1:Leather::1:0:", -- Wanderer's Belt
	[10110]="0:7948:4:2:1:Leather::1:0:", -- Wanderer's Gloves
	[10111]="0:13444:4:2:1:Leather::1:0:", -- Wanderer's Hat
	[10112]="0:19071:4:2:1:Leather::1:0:", -- Wanderer's Leggings
	[10113]="0:13541:4:2:1:Leather::1:0:", -- Wanderer's Shoulders
	[10118]="0:23382:4:2:1:Mail::1:0:", -- Ornate Breastplate
	[10119]="0:16676:4:2:1:Mail::1:0:", -- Ornate Greaves
	[10120]="0:8797:4:2:1:Cloak::1:0:", -- Ornate Cloak
	[10121]="0:10515:4:2:1:Mail::1:0:", -- Ornate Gauntlets
	[10122]="0:9007:4:2:1:Mail::1:0:", -- Ornate Girdle
	[10123]="0:15239:4:2:1:Mail::1:0:", -- Ornate Circlet
	[10124]="0:20396:4:2:1:Mail::1:0:", -- Ornate Legguards
	[10125]="0:14551:4:2:1:Mail::1:0:", -- Ornate Pauldrons
	[10126]="0:8865:4:2:1:Mail::1:0:", -- Ornate Bracers
	[10127]="0:7656:4:2:1:Plate::1:0:", -- Revenant Bracers
	[10128]="0:20838:4:2:1:Plate::1:0:", -- Revenant Chestplate
	[10129]="0:8253:4:2:1:Plate::1:0:", -- Revenant Gauntlets
	[10130]="0:8283:4:2:1:Plate::1:0:", -- Revenant Girdle
	[10131]="0:12376:4:2:1:Plate::1:0:", -- Revenant Boots
	[10132]="0:13289:4:2:1:Plate::1:0:", -- Revenant Helmet
	[10133]="0:18887:4:2:1:Plate::1:0:", -- Revenant Leggings
	[10134]="0:13386:4:2:1:Plate::1:0:", -- Revenant Shoulders
	[10135]="0:17950:4:2:1:Cloth::1:0:", -- High Councillor's Tunic
	[10136]="0:8530:4:2:1:Cloth::1:0:", -- High Councillor's Bracers
	[10137]="0:13021:4:2:1:Cloth::1:0:", -- High Councillor's Boots
	[10138]="0:12274:4:2:1:Cloak::1:0:", -- High Councillor's Cloak
	[10139]="0:13294:4:2:1:Cloth::1:0:", -- High Councillor's Circlet
	[10140]="0:8773:4:2:1:Cloth::1:0:", -- High Councillor's Gloves
	[10141]="0:18094:4:2:1:Cloth::1:0:", -- High Councillor's Pants
	[10142]="0:12495:4:2:1:Cloth::1:0:", -- High Councillor's Mantle
	[10143]="0:17176:4:2:1:Cloth::1:0:", -- High Councillor's Robe
	[10144]="0:8164:4:2:1:Cloth::1:0:", -- High Councillor's Sash
	[10145]="0:9755:4:2:1:Leather::1:0:", -- Mighty Girdle
	[10146]="0:15638:4:2:1:Leather::1:0:", -- Mighty Boots
	[10147]="0:10319:4:2:1:Leather::1:0:", -- Mighty Armsplints
	[10148]="0:11273:4:2:1:Cloak::1:0:", -- Mighty Cloak
	[10149]="0:10541:4:2:1:Leather::1:0:", -- Mighty Gauntlets
	[10150]="0:16087:4:2:1:Leather::1:0:", -- Mighty Helmet
	[10151]="0:22114:4:2:1:Leather::1:0:", -- Mighty Tunic
	[10152]="0:21901:4:2:1:Leather::1:0:", -- Mighty Leggings
	[10153]="0:16264:4:2:1:Leather::1:0:", -- Mighty Spaulders
	[10154]="0:12880:4:2:1:Mail::1:0:", -- Mercurial Girdle
	[10155]="0:19476:4:2:1:Mail::1:0:", -- Mercurial Greaves
	[10156]="0:12794:4:2:1:Mail::1:0:", -- Mercurial Bracers
	[10157]="0:27117:4:2:1:Mail::1:0:", -- Mercurial Breastplate
	[10158]="0:26964:4:2:1:Shield::1:0:", -- Mercurial Guard
	[10159]="0:11444:4:2:1:Cloak::1:0:", -- Mercurial Cloak
	[10160]="0:18599:4:2:1:Mail::1:0:", -- Mercurial Circlet
	[10161]="0:12277:4:2:1:Mail::1:0:", -- Mercurial Gauntlets
	[10162]="0:25325:4:2:1:Mail::1:0:", -- Mercurial Legguards
	[10163]="0:18893:4:2:1:Mail::1:0:", -- Mercurial Pauldrons
	[10164]="0:25915:4:2:1:Plate::1:0:", -- Templar Chestplate
	[10165]="0:10983:4:2:1:Plate::1:0:", -- Templar Gauntlets
	[10166]="0:10399:4:2:1:Plate::1:0:", -- Templar Girdle
	[10167]="0:16470:4:2:1:Plate::1:0:", -- Templar Boots
	[10168]="0:17523:4:2:1:Plate::1:0:", -- Templar Crown
	[10169]="0:24903:4:2:1:Plate::1:0:", -- Templar Legplates
	[10170]="0:17651:4:2:1:Plate::1:0:", -- Templar Pauldrons
	[10171]="0:10591:4:2:1:Plate::1:0:", -- Templar Bracers
	[10172]="0:9603:4:2:1:Cloth::1:0:", -- Mystical Mantle
	[10173]="0:5718:4:2:1:Cloth::1:0:", -- Mystical Bracers
	[10174]="0:8121:4:2:1:Cloak::1:0:", -- Mystical Cape
	[10175]="0:9011:4:2:1:Cloth::1:0:", -- Mystical Headwrap
	[10176]="0:5689:4:2:1:Cloth::1:0:", -- Mystical Gloves
	[10177]="0:12833:4:2:1:Cloth::1:0:", -- Mystical Leggings
	[10178]="0:14475:4:2:1:Cloth::1:0:", -- Mystical Robe
	[10179]="0:8632:4:2:1:Cloth::1:0:", -- Mystical Boots
	[10180]="0:5141:4:2:1:Cloth::1:0:", -- Mystical Belt
	[10181]="0:14640:4:2:1:Cloth::1:0:", -- Mystical Armor
	[10182]="0:18370:4:2:1:Leather::1:0:", -- Swashbuckler's Breastplate
	[10183]="0:10954:4:2:1:Leather::1:0:", -- Swashbuckler's Boots
	[10184]="0:6523:4:2:1:Leather::1:0:", -- Swashbuckler's Bracers
	[10185]="0:7412:4:2:1:Cloak::1:0:", -- Swashbuckler's Cape
	[10186]="0:6966:4:2:1:Leather::1:0:", -- Swashbuckler's Gloves
	[10187]="0:11785:4:2:1:Leather::1:0:", -- Swashbuckler's Eyepatch
	[10188]="0:16717:4:2:1:Leather::1:0:", -- Swashbuckler's Leggings
	[10189]="0:11872:4:2:1:Leather::1:0:", -- Swashbuckler's Shoulderpads
	[10190]="0:6669:4:2:1:Leather::1:0:", -- Swashbuckler's Belt
	[10191]="0:7777:4:2:1:Mail::1:0:", -- Crusader's Armguards
	[10192]="0:13212:4:2:1:Mail::1:0:", -- Crusader's Boots
	[10193]="0:19776:4:2:1:Mail::1:0:", -- Crusader's Armor
	[10194]="0:7345:4:2:1:Cloak::1:0:", -- Crusader's Cloak
	[10195]="0:19221:4:2:1:Shield::1:0:", -- Crusader's Shield
	[10196]="0:7593:4:2:1:Mail::1:0:", -- Crusader's Gauntlets
	[10197]="0:7623:4:2:1:Mail::1:0:", -- Crusader's Belt
	[10198]="0:12167:4:2:1:Mail::1:0:", -- Crusader's Helm
	[10199]="0:17261:4:2:1:Mail::1:0:", -- Crusader's Leggings
	[10200]="0:12314:4:2:1:Mail::1:0:", -- Crusader's Pauldrons
	[10201]="0:10411:4:2:1:Plate::1:0:", -- Overlord's Greaves
	[10202]="0:7020:4:2:1:Plate::1:0:", -- Overlord's Vambraces
	[10203]="0:18195:4:2:1:Plate::1:0:", -- Overlord's Chestplate
	[10204]="0:19888:4:2:1:Shield::1:0:", -- Heavy Lamellar Shield
	[10205]="0:7596:4:2:1:Plate::1:0:", -- Overlord's Gauntlets
	[10206]="0:7125:4:2:1:Plate::1:0:", -- Overlord's Girdle
	[10207]="0:11694:4:2:1:Plate::1:0:", -- Overlord's Crown
	[10208]="0:16777:4:2:1:Plate::1:0:", -- Overlord's Legplates
	[10209]="0:12604:4:2:1:Plate::1:0:", -- Overlord's Spaulders
	[10210]="0:12845:4:2:1:Cloth::1:0:", -- Elegant Mantle
	[10211]="0:12276:4:2:1:Cloth::1:0:", -- Elegant Boots
	[10212]="0:11069:4:2:1:Cloak::1:0:", -- Elegant Cloak
	[10213]="0:7850:4:2:1:Cloth::1:0:", -- Elegant Bracers
	[10214]="0:8271:4:2:1:Cloth::1:0:", -- Elegant Gloves
	[10215]="0:16212:4:2:1:Cloth::1:0:", -- Elegant Robes
	[10216]="0:7180:4:2:1:Cloth::1:0:", -- Elegant Belt
	[10217]="0:16116:4:2:1:Cloth::1:0:", -- Elegant Leggings
	[10218]="0:16399:4:2:1:Cloth::1:0:", -- Elegant Tunic
	[10219]="0:12011:4:2:1:Cloth::1:0:", -- Elegant Circlet
	[10220]="0:20938:4:2:1:Leather::1:0:", -- Nightshade Tunic
	[10221]="0:9148:4:2:1:Leather::1:0:", -- Nightshade Girdle
	[10222]="0:14462:4:2:1:Leather::1:0:", -- Nightshade Boots
	[10223]="0:9466:4:2:1:Leather::1:0:", -- Nightshade Armguards
	[10224]="0:10755:4:2:1:Cloak::1:0:", -- Nightshade Cloak
	[10225]="0:10012:4:2:1:Leather::1:0:", -- Nightshade Gloves
	[10226]="0:16046:4:2:1:Leather::1:0:", -- Nightshade Helmet
	[10227]="0:21769:4:2:1:Leather::1:0:", -- Nightshade Leggings
	[10228]="0:15940:4:2:1:Leather::1:0:", -- Nightshade Spaulders
	[10229]="0:10331:4:2:1:Mail::1:0:", -- Engraved Bracers
	[10230]="0:25686:4:2:1:Mail::1:0:", -- Engraved Breastplate
	[10231]="0:9816:4:2:1:Cloak::1:0:", -- Engraved Cape
	[10232]="0:11732:4:2:1:Mail::1:0:", -- Engraved Gauntlets
	[10233]="0:11106:4:2:1:Mail::1:0:", -- Engraved Girdle
	[10234]="0:17801:4:2:1:Mail::1:0:", -- Engraved Boots
	[10235]="0:16896:4:2:1:Mail::1:0:", -- Engraved Helm
	[10236]="0:22616:4:2:1:Mail::1:0:", -- Engraved Leggings
	[10237]="0:16287:4:2:1:Mail::1:0:", -- Engraved Pauldrons
	[10238]="0:13362:4:2:1:Plate::1:0:", -- Heavy Lamellar Boots
	[10239]="0:8733:4:2:1:Plate::1:0:", -- Heavy Lamellar Vambraces
	[10240]="0:22009:4:2:1:Plate::1:0:", -- Heavy Lamellar Chestpiece
	[10241]="0:14716:4:2:1:Plate::1:0:", -- Heavy Lamellar Helm
	[10242]="0:9360:4:2:1:Plate::1:0:", -- Heavy Lamellar Gauntlets
	[10243]="0:8863:4:2:1:Plate::1:0:", -- Heavy Lamellar Girdle
	[10244]="0:21069:4:2:1:Plate::1:0:", -- Heavy Lamellar Leggings
	[10245]="0:14932:4:2:1:Plate::1:0:", -- Heavy Lamellar Pauldrons
	[10246]="0:18058:4:2:1:Cloth::1:0:", -- Master's Vest
	[10247]="0:13238:4:2:1:Cloth::1:0:", -- Master's Boots
	[10248]="0:8737:4:2:1:Cloth::1:0:", -- Master's Bracers
	[10249]="0:12974:4:2:1:Cloak::1:0:", -- Master's Cloak
	[10250]="0:13380:4:2:1:Cloth::1:0:", -- Master's Hat
	[10251]="0:8952:4:2:1:Cloth::1:0:", -- Master's Gloves
	[10252]="0:18207:4:2:1:Cloth::1:0:", -- Master's Leggings
	[10253]="0:13523:4:2:1:Cloth::1:0:", -- Master's Mantle
	[10254]="0:18580:4:2:1:Cloth::1:0:", -- Master's Robe
	[10255]="0:8330:4:2:1:Cloth::1:0:", -- Master's Belt
	[10256]="0:10309:4:2:1:Leather::1:0:", -- Adventurer's Bracers
	[10257]="0:15735:4:2:1:Leather::1:0:", -- Adventurer's Boots
	[10258]="0:12292:4:2:1:Cloak::1:0:", -- Adventurer's Cape
	[10259]="0:10569:4:2:1:Leather::1:0:", -- Adventurer's Belt
	[10260]="0:10752:4:2:1:Leather::1:0:", -- Adventurer's Gloves
	[10261]="0:16187:4:2:1:Leather::1:0:", -- Adventurer's Bandana
	[10262]="0:21954:4:2:1:Leather::1:0:", -- Adventurer's Legguards
	[10263]="0:16306:4:2:1:Leather::1:0:", -- Adventurer's Shoulders
	[10264]="0:22406:4:2:1:Leather::1:0:", -- Adventurer's Tunic
	[10265]="0:12964:4:2:1:Mail::1:0:", -- Masterwork Bracers
	[10266]="0:27085:4:2:1:Mail::1:0:", -- Masterwork Breastplate
	[10267]="0:12880:4:2:1:Cloak::1:0:", -- Masterwork Cape
	[10268]="0:13283:4:2:1:Mail::1:0:", -- Masterwork Gauntlets
	[10269]="0:13152:4:2:1:Mail::1:0:", -- Masterwork Girdle
	[10270]="0:20158:4:2:1:Mail::1:0:", -- Masterwork Boots
	[10271]="0:27321:4:2:1:Shield::1:0:", -- Masterwork Shield
	[10272]="0:18780:4:2:1:Mail::1:0:", -- Masterwork Circlet
	[10273]="0:25473:4:2:1:Mail::1:0:", -- Masterwork Legplates
	[10274]="0:19008:4:2:1:Mail::1:0:", -- Masterwork Pauldrons
	[10275]="0:28357:4:2:1:Plate::1:0:", -- Emerald Breastplate
	[10276]="0:17200:4:2:1:Plate::1:0:", -- Emerald Sabatons
	[10277]="0:12294:4:2:1:Plate::1:0:", -- Emerald Gauntlets
	[10278]="0:10981:4:2:1:Plate::1:0:", -- Emerald Girdle
	[10279]="0:19543:4:2:1:Plate::1:0:", -- Emerald Helm
	[10280]="0:27515:4:2:1:Plate::1:0:", -- Emerald Legplates
	[10281]="0:19689:4:2:1:Plate::1:0:", -- Emerald Pauldrons
	[10282]="0:11813:4:2:1:Plate::1:0:", -- Emerald Vambraces
	[10283]="0:0:12:1:1:::1:0:", -- Wolf Heart Samples
	[10285]="0:1000:7:1:10:Cloth:202,165,197:1:0:", -- Shadow Silk
	[10286]="0:400:7:1:10:Elemental:171,202,755,197:1:0:", -- Heart of the Wild
	[10287]="0:964:4:2:1:Cloth::1:0:", -- Greenweave Mantle
	[10288]="0:1410:4:2:1:Cloth::1:0:", -- Sage's Circlet
	[10289]="0:1557:4:2:1:Cloth::1:0:", -- Durable Hat
	[10290]="2500:625:7:1:10:Other:197:1:0:1347,1454,1474,1672,2394,2668,2669,2670,2672,2697,2698,2699,2816,2819,2846,3005,3091,3096,3364,3366,3485,3958,4168,4189,4225,4577,4589,5128,5154,5565,5783,5944,6567,6568,6574,6576,6731,7852,7854,7940,8160,8681,11557,11874,12942,12943,12956,15165,16366,16638,16689,16748,16767,18277,18749,18754,18771,18772,19196,19213,19521,19532,19722,21085,28718,28726,28798,28810,33596,33601", -- Pink Dye
	[10298]="0:1243:4:2:1:Ring::1:0:", -- Gnomeregan Band
	[10299]="0:3778:4:2:1:Amulet::1:0:", -- Gnomeregan Amulet
	[10300]="0:1250:9:2:1:Tailoring::1:0:", -- Pattern: Red Mageweave Vest
	[10301]="0:1250:9:2:1:Tailoring::1:0:", -- Pattern: White Bandit Mask
	[10302]="0:1250:9:2:1:Tailoring::1:0:", -- Pattern: Red Mageweave Pants
	[10305]="550:100:0:1:20:Scroll::1:1:14847", -- Scroll of Protection IV
	[10306]="550:100:0:1:20:Scroll::1:1:14847,20092", -- Scroll of Spirit IV
	[10307]="600:112:0:1:20:Scroll::1:1:14847,20092", -- Scroll of Stamina IV
	[10308]="600:112:0:1:20:Scroll::1:1:14847,20092", -- Scroll of Intellect IV
	[10309]="650:125:0:1:20:Scroll::1:1:14847", -- Scroll of Agility IV
	[10310]="650:125:0:1:20:Scroll::1:1:14847", -- Scroll of Strength IV
	[10311]="3000:750:9:1:1:Tailoring::1:1:3005,4168", -- Pattern: Orange Martial Shirt
	[10312]="0:1500:9:2:1:Tailoring::1:0:", -- Pattern: Red Mageweave Gloves
	[10314]="4000:1000:9:1:1:Tailoring::1:1:3364,8681", -- Pattern: Lavender Mageweave Shirt
	[10315]="0:1750:9:2:1:Tailoring::1:0:", -- Pattern: Red Mageweave Shoulders
	[10316]="0:200:9:2:1:Tailoring::1:0:", -- Pattern: Colorful Kilt
	[10317]="4000:1000:9:1:1:Tailoring::1:1:3364,8681", -- Pattern: Pink Mageweave Shirt
	[10318]="7000:1750:9:1:1:Tailoring::1:1:2672", -- Pattern: Admiral's Hat
	[10320]="0:1750:9:2:1:Tailoring::1:0:", -- Pattern: Red Mageweave Headband
	[10321]="4500:1125:9:1:1:Tailoring::1:1:4577,8681", -- Pattern: Tuxedo Shirt
	[10323]="4500:1125:9:1:1:Tailoring::1:1:4577,8681", -- Pattern: Tuxedo Pants
	[10325]="10000:2500:9:1:1:Tailoring::1:1:1347,3005", -- Pattern: White Wedding Dress
	[10326]="5000:1250:9:1:1:Tailoring::1:1:4577,8681", -- Pattern: Tuxedo Jacket
	[10327]="0:0:12:1:1:::1:0:", -- Horn of Echeyakee
	[10328]="0:6992:4:3:1:Mail::1:0:", -- Scarlet Chestpiece
	[10329]="0:2507:4:2:1:Mail::1:0:", -- Scarlet Belt
	[10330]="0:9587:4:3:1:Mail::1:0:", -- Scarlet Leggings
	[10331]="0:2729:4:2:1:Mail::1:0:", -- Scarlet Gauntlets
	[10332]="0:3790:4:3:1:Mail::1:0:", -- Scarlet Boots
	[10333]="0:2314:4:2:1:Mail::1:0:", -- Scarlet Wristguards
	[10338]="0:0:12:1:1:::1:0:", -- Fresh Zhevra Carcass
	[10358]="0:2421:4:2:1:Mail::1:0:", -- Duracin Bracers
	[10359]="0:2430:4:2:1:Cloth::1:0:", -- Everlast Boots
	[10360]="5000:1250:15:1:1:Companion::1:0:8404", -- Black Kingsnake
	[10361]="5000:1250:15:1:1:Companion::1:0:8404", -- Brown Snake
	[10362]="0:24760:4:2:1:Shield::1:0:", -- Ornate Shield
	[10363]="0:27396:4:2:1:Shield::1:0:", -- Engraved Wall
	[10364]="0:24938:4:2:1:Shield::1:0:", -- Templar Shield
	[10365]="0:26276:4:2:1:Shield::1:0:", -- Emerald Shield
	[10366]="0:28849:4:2:1:Shield::1:0:", -- Demon Guard
	[10367]="0:27639:4:2:1:Shield::1:0:", -- Hyperion Shield
	[10368]="0:29156:4:2:1:Plate::1:0:", -- Imbued Plate Armor
	[10369]="0:12984:4:2:1:Plate::1:0:", -- Imbued Plate Gauntlets
	[10370]="0:12295:4:2:1:Plate::1:0:", -- Imbued Plate Girdle
	[10371]="0:19474:4:2:1:Plate::1:0:", -- Imbued Plate Greaves
	[10372]="0:20525:4:2:1:Plate::1:0:", -- Imbued Plate Helmet
	[10373]="0:29298:4:2:1:Plate::1:0:", -- Imbued Plate Leggings
	[10374]="0:20676:4:2:1:Plate::1:0:", -- Imbued Plate Pauldrons
	[10375]="0:12525:4:2:1:Plate::1:0:", -- Imbued Plate Vambraces
	[10376]="0:21868:4:2:1:Plate::1:0:", -- Commander's Boots
	[10377]="0:14042:4:2:1:Plate::1:0:", -- Commander's Vambraces
	[10378]="0:30662:4:2:1:Plate::1:0:", -- Commander's Armor
	[10379]="0:22418:4:2:1:Plate::1:0:", -- Commander's Helm
	[10380]="0:14904:4:2:1:Plate::1:0:", -- Commander's Gauntlets
	[10381]="0:14246:4:2:1:Plate::1:0:", -- Commander's Girdle
	[10382]="0:30689:4:2:1:Plate::1:0:", -- Commander's Leggings
	[10383]="0:21121:4:2:1:Plate::1:0:", -- Commander's Pauldrons
	[10384]="0:29882:4:2:1:Plate::1:0:", -- Hyperion Armor
	[10385]="0:21575:4:2:1:Plate::1:0:", -- Hyperion Greaves
	[10386]="0:14548:4:2:1:Plate::1:0:", -- Hyperion Gauntlets
	[10387]="0:14405:4:2:1:Plate::1:0:", -- Hyperion Girdle
	[10388]="0:22117:4:2:1:Plate::1:0:", -- Hyperion Helm
	[10389]="0:30056:4:2:1:Plate::1:0:", -- Hyperion Legplates
	[10390]="0:22285:4:2:1:Plate::1:0:", -- Hyperion Pauldrons
	[10391]="0:14420:4:2:1:Plate::1:0:", -- Hyperion Vambraces
	[10392]="5000:1250:15:1:1:Companion::1:0:8404,20980", -- Crimson Snake
	[10393]="5000:1250:15:1:1:Companion::1:0:8403,20980", -- Cockroach
	[10394]="5000:1250:15:1:1:Companion::1:0:8401", -- Prairie Dog Whistle
	[10398]="0:1000:15:1:1:Companion::1:0:", -- Mechanical Chicken
	[10399]="0:1467:4:3:1:Leather::1:0:", -- Blackened Defias Armor
	[10400]="0:563:4:2:1:Leather::1:0:", -- Blackened Defias Leggings
	[10401]="0:255:4:2:1:Leather::1:0:", -- Blackened Defias Gloves
	[10402]="0:385:4:2:1:Leather::1:0:", -- Blackened Defias Boots
	[10403]="0:541:4:3:1:Leather::1:0:", -- Blackened Defias Belt
	[10404]="0:864:4:2:1:Cloth::1:0:", -- Durable Belt
	[10405]="0:409:4:1:1:Leather::1:0:", -- Bandit Shoulders
	[10406]="0:1976:4:2:1:Leather::1:0:", -- Scaled Leather Headband
	[10407]="0:432:4:1:1:Mail::1:0:", -- Raider's Shoulderpads
	[10408]="0:2390:4:2:1:Mail::1:0:", -- Banded Helm
	[10409]="0:2409:4:2:1:Mail::1:0:", -- Banded Boots
	[10410]="0:1256:4:3:1:Leather::1:0:", -- Leggings of the Fang
	[10411]="0:945:4:3:1:Leather::1:0:", -- Footpads of the Fang
	[10412]="0:486:4:3:1:Leather::1:0:", -- Belt of the Fang
	[10413]="0:369:4:3:1:Leather::1:0:", -- Gloves of the Fang
	[10414]="0:0:12:1:1:::1:0:", -- Sample Snapjaw Shell
	[10418]="0:16464:4:2:1:Trinket::1:0:", -- Glimmering Mithril Insignia
	[10420]="0:0:12:1:1:::1:0:", -- Skull of the Coldbringer
	[10421]="0:32:4:1:1:Mail::1:0:", -- Rough Copper Vest
	[10423]="0:2842:4:2:1:Mail::1:0:", -- Silvered Bronze Leggings
	[10424]="0:750:9:2:1:Blacksmithing::1:0:", -- Plans: Silvered Bronze Leggings
	[10438]="0:0:12:1:1:::1:0:", -- Felix's Box
	[10439]="0:0:12:1:1:::1:0:", -- Durnan's Scalding Mornbrew
	[10440]="0:0:12:1:1:::1:0:", -- Nori's Mug
	[10441]="0:0:12:1:1:::1:0:", -- Glowing Shard
	[10442]="0:0:12:1:1:::1:0:", -- Mysterious Artifact
	[10443]="0:0:12:1:1:::1:0:", -- Singed Letter
	[10444]="0:0:12:1:1:::1:0:", -- Standard Issue Flare Gun
	[10445]="0:0:12:1:1:::1:0:", -- Drawing Kit
	[10446]="0:0:12:1:1:::1:0:", -- Heart of Obsidion
	[10447]="0:0:12:1:1:::1:0:", -- Head of Lathoric the Black
	[10450]="0:396:12:0:20:::1:0:", -- Undamaged Hippogryph Feather
	[10454]="0:0:12:2:1:::1:0:", -- Essence of Eranikus
	[10455]="0:6464:4:2:1:Trinket::1:0:", -- Chained Essence of Eranikus
	[10456]="0:0:15:1:1:Junk::1:0:", -- A Bulging Coin Purse
	[10457]="0:142:15:0:5:Junk::1:0:", -- Empty Sea Snail Shell
	[10458]="0:0:12:1:1:::1:0:", -- Prayer to Elune
	[10459]="0:0:12:1:1:::1:0:", -- Chief Sharptusk Thornmantle's Head
	[10460]="0:629:15:1:1:Junk::1:0:", -- Hakkari Blood
	[10461]="0:3082:4:2:1:Cloth::1:0:", -- Shadowy Bracers
	[10462]="0:3609:4:2:1:Cloth::1:0:", -- Shadowy Belt
	[10463]="0:1750:9:2:1:Tailoring::1:0:", -- Pattern: Shadoweave Mask
	[10464]="0:0:12:1:1:::1:0:", -- Staff of Command
	[10465]="0:0:12:1:1:::1:0:", -- Egg of Hakkar
	[10466]="0:0:12:1:1:::1:0:", -- Atal'ai Stone Circle
	[10467]="0:0:15:1:1:Junk::1:0:", -- Trader's Satchel
	[10479]="0:24:15:2:1:Junk::1:0:", -- Kovic's Trading Satchel
	[10498]="0:16:7:1:1:Part::1:0:", -- Gyromatic Micro-Adjustor
	[10499]="0:2105:4:2:1:Cloth::1:0:", -- Bright-Eye Goggles
	[10500]="0:3478:4:2:1:Cloth:202:1:0:", -- Fire Goggles
	[10501]="0:4398:4:2:1:Cloth::1:0:", -- Catseye Ultra Goggles
	[10502]="0:4088:4:2:1:Cloth:202:1:0:", -- Spellpower Goggles Xtreme
	[10503]="0:5169:4:2:1:Cloth::1:0:", -- Rose Colored Goggles
	[10504]="0:7770:4:3:1:Cloth::1:0:", -- Green Lens
	[10505]="0:250:7:1:20:Part:202:1:0:", -- Solid Blasting Powder
	[10506]="0:5227:4:2:1:Cloth::1:0:", -- Deepdive Helmet
	[10507]="0:350:7:1:20:Explosive:202:1:0:", -- Solid Dynamite
	[10508]="0:8959:2:2:1:Gun::1:0:", -- Mithril Blunderbuss
	[10509]="0:0:12:1:4:::1:0:", -- Heart of Flame
	[10510]="0:11369:2:2:1:Gun::1:0:", -- Mithril Heavy-bore Rifle
	[10511]="0:0:12:1:4:::1:0:", -- Golem Oil
	[10512]="0:2:6:2:1000:Bullet::1:0:", -- Hi-Impact Mithril Slugs
	[10513]="0:5:6:2:1000:Bullet::1:0:", -- Mithril Gyro-Shot
	[10514]="0:750:7:1:20:Explosive::1:0:", -- Mithril Frag Bomb
	[10515]="0:0:4:1:1:Miscellaneous::1:0:", -- Torch of Retribution
	[10518]="0:4696:4:2:1:Cloak::1:0:", -- Parachute Cloak
	[10538]="0:0:12:1:1:::1:0:", -- Tablet of Beth'Amara
	[10539]="0:0:12:1:1:::1:0:", -- Tablet of Jin'yael
	[10540]="0:0:12:1:1:::1:0:", -- Tablet of Markri
	[10541]="0:0:12:1:1:::1:0:", -- Tablet of Sael'hai
	[10542]="0:5255:4:2:1:Mail::1:0:", -- Goblin Mining Helmet
	[10543]="0:3517:4:2:1:Cloth:202:1:0:", -- Goblin Construction Helmet
	[10544]="0:25:2:1:1:OneHandMace::1:0:", -- Thistlewood Maul
	[10545]="0:3929:4:2:1:Cloth::1:0:", -- Gnomish Goggles
	[10546]="0:1500:0:1:5:EnhPerm:202:1:0:", -- Deadly Scope
	[10547]="0:81:2:1:1:Dagger::1:0:", -- Camping Knife
	[10548]="0:2500:0:1:5:EnhPerm::1:0:", -- Sniper Scope
	[10549]="0:162:4:2:1:Cloth::1:0:", -- Rancher's Trousers
	[10550]="0:48:4:1:1:Cloth::1:0:", -- Wooly Mittens
	[10551]="0:0:12:1:10:::1:0:", -- Thorium Plated Dagger
	[10552]="0:0:12:1:1:::1:0:", -- Symbol of Ragnaros
	[10553]="0:131:4:2:1:Cloth::1:0:", -- Foreman Vest
	[10554]="0:119:4:2:1:Cloth::1:0:", -- Foreman Pants
	[10556]="0:0:12:1:1:::1:0:", -- Stone Circle
	[10558]="0:250:7:1:20:Part:202:1:0:", -- Gold Power Core
	[10559]="0:750:7:1:20:Part:202:1:0:", -- Mithril Tube
	[10560]="0:1000:7:1:10:Part:202:1:0:", -- Unstable Trigger
	[10561]="0:1000:7:1:10:Part:202:1:0:", -- Mithril Casing
	[10562]="0:750:7:1:20:Explosive::1:0:", -- Hi-Explosive Bomb
	[10563]="0:0:12:1:1:::1:0:", -- Rubbing: Rune of Beth'Amara
	[10564]="0:0:12:1:1:::1:0:", -- Rubbing: Rune of Jin'yael
	[10565]="0:0:12:1:1:::1:0:", -- Rubbing: Rune of Markri
	[10566]="0:0:12:1:1:::1:0:", -- Rubbing: Rune of Sael'hai
	[10567]="0:8725:2:3:1:Bow::1:0:", -- Quillshooter
	[10569]="0:0:15:1:1:Junk::1:0:", -- Hoard of the Black Dragonflight
	[10570]="0:15875:2:3:1:TwoHandAxe::1:0:", -- Manslayer
	[10571]="0:10927:2:3:1:OneHandMace::1:0:", -- Ebony Boneclub
	[10572]="0:9592:2:3:1:Wand::1:0:", -- Freezing Shard
	[10573]="0:13754:2:3:1:TwoHandSword::1:0:", -- Boneslasher
	[10574]="0:3775:4:3:1:Cloth::1:0:", -- Corpseshroud
	[10575]="0:0:15:1:10:Junk::1:0:", -- Black Dragonflight Molt
	[10576]="0:6000:4:2:1:Trinket:202:1:0:", -- Mithril Mechanical Dragonling
	[10577]="0:2000:4:1:1:Trinket:202:1:0:", -- Goblin Mortar
	[10578]="0:3377:4:3:1:Cloth::1:0:", -- Thoughtcast Boots
	[10579]="0:0:6:3:200:Arrow::1:0:", -- Explosive Arrow
	[10580]="0:750:7:1:10:Explosive::1:0:", -- "Goblin ""Boom"" Box"
	[10581]="0:5310:4:3:1:Cloth::1:0:", -- Death's Head Vestment
	[10582]="0:3606:4:3:1:Leather::1:0:", -- Briar Tredders
	[10583]="0:6191:4:3:1:Leather::1:0:", -- Quillward Harness
	[10584]="0:2905:4:3:1:Mail::1:0:", -- Stormgale Fists
	[10585]="0:750:4:1:10:Trinket::1:0:", -- Goblin Radio
	[10586]="0:750:7:1:20:Explosive:202:1:0:", -- The Big One
	[10587]="0:1500:4:1:1:Trinket::1:0:", -- Goblin Bomb Dispenser
	[10588]="0:5834:4:2:1:Cloth::1:0:", -- Goblin Rocket Helmet
	[10589]="0:0:12:1:1:::1:0:", -- Oathstone of Ysera's Dragonflight
	[10590]="0:0:12:1:1:::1:0:", -- Pocked Black Box
	[10592]="0:150:0:1:20:Elixir:202:1:0:", -- Catseye Elixir
	[10593]="0:0:12:2:20:::1:0:", -- Imperfect Draenethyst Fragment
	[10597]="0:0:12:1:1:::1:0:", -- Head of Magus Rimtori
	[10598]="0:0:12:1:1:::1:0:", -- Hetaera's Bloodied Head
	[10599]="0:0:12:1:1:::1:0:", -- Hetaera's Beaten Head
	[10600]="0:0:12:1:1:::1:0:", -- Hetaera's Bruised Head
	[10601]="0:500:9:2:1:Engineering::1:0:", -- Schematic: Bright-Eye Goggles
	[10602]="3000:750:9:1:1:Engineering::1:1:8679,9544", -- Schematic: Deadly Scope
	[10603]="0:825:9:2:1:Engineering::1:0:", -- Schematic: Catseye Ultra Goggles
	[10604]="0:825:9:2:1:Engineering::1:0:", -- Schematic: Mithril Heavy-bore Rifle
	[10605]="0:875:9:3:1:Engineering::1:0:", -- Schematic: Spellpower Goggles Xtreme
	[10606]="0:875:9:2:1:Engineering::1:0:", -- Schematic: Parachute Cloak
	[10607]="3600:900:9:1:1:Engineering::1:1:8678", -- Schematic: Deepdive Helmet
	[10608]="0:950:9:3:1:Engineering::1:0:", -- Schematic: Sniper Scope
	[10609]="4000:1000:9:1:1:Engineering::1:1:2688", -- Schematic: Mithril Mechanical Dragonling
	[10610]="0:0:12:1:1:::1:0:", -- Hetaera's Blood
	[10620]="0:250:7:1:20:MetalStone:171,186:1:0:", -- Thorium Ore
	[10621]="0:0:15:1:1:Junk::1:0:", -- Runed Scroll
	[10622]="0:0:12:1:1:::1:0:", -- Kadrak's Flag
	[10623]="0:24748:2:3:1:OneHandAxe::1:0:", -- Winter's Bite
	[10624]="0:17249:2:3:1:Bow::1:0:", -- Stinging Bow
	[10625]="0:27366:2:3:1:Dagger::1:0:", -- Stealthblade
	[10626]="0:36732:2:3:1:TwoHandMace::1:0:", -- Ragehammer
	[10627]="0:26974:2:3:1:Stave::1:0:", -- Bludgeon of the Grinning Dog
	[10628]="0:29245:2:3:1:TwoHandSword::1:0:", -- Deathblow
	[10629]="0:8066:4:3:1:Cloth::1:0:", -- Mistwalker Boots
	[10630]="0:8664:4:3:1:Cloth::1:0:", -- Soulcatcher Halo
	[10631]="0:6086:4:3:1:Mail::1:0:", -- Murkwater Gauntlets
	[10632]="0:7624:4:3:1:Mail::1:0:", -- Slimescale Bracers
	[10633]="0:20447:4:3:1:Plate::1:0:", -- Silvershell Leggings
	[10634]="0:10812:4:3:1:Ring::1:0:", -- Mindseye Circle
	[10635]="0:14:4:1:1:Mail::1:0:", -- Painted Chain Leggings
	[10636]="0:6:4:1:1:Leather::1:0:", -- Nomadic Gloves
	[10637]="0:139:4:2:1:Cloth::1:0:", -- Brewer's Gloves
	[10638]="0:210:4:2:1:Cloak::1:0:", -- Long Draping Cape
	[10639]="0:0:12:1:20:::1:0:", -- Hyacinth Mushroom
	[10640]="0:0:12:1:20:::1:0:", -- Webwood Ichor
	[10641]="0:0:12:1:20:::1:0:", -- Moonpetal Lily
	[10642]="0:0:12:1:1:::1:0:", -- Iverron's Antidote
	[10643]="0:0:12:1:1:::1:0:", -- Sealed Letter to Ag'tor
	[10644]="0:500:9:1:1:Alchemy::1:0:", -- Recipe: Goblin Rocket Fuel
	[10645]="0:750:4:1:1:Trinket::1:0:", -- Gnomish Death Ray
	[10646]="0:500:7:1:20:Explosive::1:0:", -- Goblin Sapper Charge
	[10647]="2000:500:7:1:10:Part:202:1:0:1316,1448,1694,2682,2683,2684,2685,2687,2688,3133,3413,3495,4453,4581,4587,5175,5519,6730,6777,8678,8679,9544,9676,11185,14337,14637,16657,16782,17222,17421,18278,18484,18752,18775,19383,19575,19661,20890,21112,26600,26898,27711,28722,28797,29907,30345,30434,30825,31776,31781,33594,33669", -- Engineer's Ink
	[10648]="125:31:7:1:20:Other:202,773:1:0:66,1250,1316,1448,1692,1694,2118,2682,2683,2684,2685,2687,2688,3081,3133,3168,3187,3413,3495,3614,4453,4581,4587,5175,5519,5817,6730,6777,8678,8679,8934,9544,9676,11185,14337,14637,16261,16262,16602,16657,16782,16826,17222,17421,17490,18015,18278,18484,18752,18775,18907,18960,19015,19017,19042,19194,19197,19345,19372,19383,19450,19497,19533,19562,19573,19575,19661,20081,20092,20194,20250,20890,20891,21083,21112,21113,22099,22271,23363,23802,24054,24147,24188,24341,24356,25034,26374,26474,26600,26720,26898,26916,26939,26941,26959,26977,26995,27012,27021,27026,27043,27057,27063,27070,27132,27143,27146,27184,27195,27711,27938,28692,28722,28723,28794,28797,28806,28831,28872,29208,29270,29277,29907,30311,30345,30434,30438,30723,30724,30727,30729,30730,30731,30732,30733,30734,30735,30825,31115,31776,31781,32477,32639,32641,33594,33598,33669", -- Common Parchment
	[10649]="0:0:12:1:1:::1:0:", -- Nightmare Shard
	[10652]="0:36370:2:3:1:TwoHandAxe::1:0:", -- Will of the Mountain Giant
	[10653]="0:1639:4:2:1:Leather::1:0:", -- Trailblazer Boots
	[10654]="0:965:4:2:1:Cloth::1:0:", -- Jutebraid Gloves
	[10655]="0:9:4:1:1:Cloth::1:0:", -- Sedgeweed Britches
	[10656]="0:14:4:1:1:Mail::1:0:", -- Barkmail Vest
	[10657]="0:933:4:2:1:Cloth::1:0:", -- Talbar Mantle
	[10658]="0:1249:4:2:1:Mail::1:0:", -- Quagmire Galoshes
	[10659]="0:4662:4:2:1:Trinket::1:0:", -- Shard of Afrasa
	[10660]="0:0:12:1:1:::1:0:", -- First Mosh'aru Tablet
	[10661]="0:0:12:1:1:::1:0:", -- Second Mosh'aru Tablet
	[10662]="0:0:12:1:1:::1:0:", -- Filled Egg of Hakkar
	[10663]="0:0:0:1:1:Consumable::1:0:", -- Essence of Hakkar
	[10664]="0:0:12:1:1:::1:0:", -- A Note to Magus Rimtori
	[10678]="0:0:12:1:1:::1:0:", -- Magatha's Note
	[10679]="0:0:12:1:1:::1:0:", -- Andron's Note
	[10680]="0:0:12:1:1:::1:0:", -- Jes'rimon's Note
	[10681]="0:0:12:1:1:::1:0:", -- Xylem's Note
	[10682]="0:0:12:1:1:::1:0:", -- Belnistrasz's Oathstone
	[10684]="2000:500:0:1:1:Consumable::1:0:7772", -- Colossal Parachute
	[10686]="0:25395:4:3:1:Shield::1:0:", -- Aegis of Battle
	[10687]="0:0:0:1:1:Consumable::1:0:", -- Empty Vial Labeled #1
	[10688]="0:0:0:1:1:Consumable::1:0:", -- Empty Vial Labeled #2
	[10689]="0:0:0:1:1:Consumable::1:0:", -- Empty Vial Labeled #3
	[10690]="0:0:0:1:1:Consumable::1:0:", -- Empty Vial Labeled #4
	[10691]="0:0:12:1:1:::1:0:", -- Filled Vial Labeled #1
	[10692]="0:0:12:1:1:::1:0:", -- Filled Vial Labeled #2
	[10693]="0:0:12:1:1:::1:0:", -- Filled Vial Labeled #3
	[10694]="0:0:12:1:1:::1:0:", -- Filled Vial Labeled #4
	[10695]="0:0:15:1:1:Junk::1:0:", -- Box of Empty Vials
	[10696]="0:41891:2:2:1:OneHandSword::1:0:", -- Enchanted Azsharite Felbane Sword
	[10697]="0:42044:2:2:1:Dagger::1:0:", -- Enchanted Azsharite Felbane Dagger
	[10698]="0:52747:2:2:1:Stave::1:0:", -- Enchanted Azsharite Felbane Staff
	[10699]="0:0:12:1:1:::1:0:", -- Yeh'kinya's Bramble
	[10700]="0:4983:4:2:1:Cloth::1:0:", -- Encarmine Boots
	[10701]="0:7536:4:2:1:Mail::1:0:", -- Boots of Zua'tec
	[10702]="0:5379:4:2:1:Leather::1:0:", -- Enormous Ogre Boots
	[10703]="0:16792:2:2:1:Dagger::1:0:", -- Fiendish Skiv
	[10704]="0:13649:2:2:1:Wand::1:0:", -- Chillnail Splinter
	[10705]="0:3666:4:2:1:Cloth::1:0:", -- Firwillow Wristbands
	[10706]="0:5521:4:2:1:Mail::1:0:", -- Nightscale Girdle
	[10707]="0:13576:4:2:1:Plate::1:0:", -- Steelsmith Greaves
	[10708]="0:8982:4:2:1:OffHandFrill::1:0:", -- Skullspell Orb
	[10709]="0:10953:4:2:1:OffHandFrill::1:0:", -- Pyrestone Orb
	[10710]="0:6130:4:3:1:Ring::1:0:", -- Dragonclaw Ring
	[10711]="0:8377:4:3:1:Amulet::1:0:", -- Dragon's Blood Necklace
	[10712]="0:0:12:1:1:::1:0:", -- Cuely's Elixir
	[10713]="0:500:9:1:1:Blacksmithing::1:0:", -- Plans: Inlaid Mithril Cylinder
	[10714]="0:0:12:1:20:::1:0:", -- Crystallized Azsharite
	[10715]="0:0:12:1:1:::1:0:", -- Kim'Jael's Scope
	[10716]="0:750:4:1:1:Trinket::1:0:", -- Gnomish Shrink Ray
	[10717]="0:0:12:1:1:::1:0:", -- Kim'Jael's Compass
	[10718]="0:0:12:1:1:::1:0:", -- Kim'Jael's Wizzlegoober
	[10719]="0:1500:15:1:1:CombatPet::1:0:", -- Mobile Alarm
	[10720]="0:750:4:1:1:Trinket::1:0:", -- Gnomish Net-o-Matic Projector
	[10721]="0:3317:4:2:1:Leather::1:0:", -- Gnomish Harm Prevention Belt
	[10722]="0:0:12:1:1:::1:0:", -- Kim'Jael's Stuffed Chicken
	[10723]="0:750:4:1:10:Trinket::1:0:", -- Gnomish Ham Radio
	[10724]="0:4697:4:2:1:Cloth::1:0:", -- Gnomish Rocket Boots
	[10725]="0:1500:4:1:1:Trinket::1:0:", -- Gnomish Battle Chicken
	[10726]="0:5520:4:2:1:Cloth::1:0:", -- Gnomish Mind Control Cap
	[10727]="0:2000:4:1:1:Trinket::1:0:", -- Goblin Dragon Gun
	[10728]="1500:375:9:1:1:Tailoring::1:1:2663", -- Pattern: Black Swashbuckler's Shirt
	[10738]="0:0:12:1:1:::1:0:", -- Shipment to Galvan
	[10739]="0:5292:4:2:1:Ring::1:0:", -- Ring of Fortitude
	[10740]="0:18712:4:2:1:Plate::1:0:", -- Centurion Legplates
	[10741]="0:10063:4:2:1:Leather::1:0:", -- Lordrec Helmet
	[10742]="0:9589:4:2:1:Cloth::1:0:", -- Dragonflight Leggings
	[10743]="0:10830:4:2:1:Mail::1:0:", -- Drakefire Headguard
	[10744]="0:24159:2:2:1:OneHandAxe::1:0:", -- Axe of the Ebon Drake
	[10745]="0:8498:4:2:1:Leather::1:0:", -- Kaylari Shoulders
	[10746]="0:8007:4:2:1:Plate::1:0:", -- Runesteel Vambraces
	[10747]="0:2327:4:2:1:Cloth::1:0:", -- Teacher's Sash
	[10748]="0:4380:4:2:1:Leather::1:0:", -- Wanderlust Boots
	[10749]="0:18436:4:3:1:Plate::1:0:", -- Avenguard Helm
	[10750]="0:35315:2:3:1:Dagger::1:0:", -- Lifeforce Dirk
	[10751]="0:10634:4:3:1:Cloth::1:0:", -- Gemburst Circlet
	[10752]="0:0:15:2:1:Junk::1:0:", -- Emerald Encrusted Chest
	[10753]="0:0:12:1:1:::1:0:", -- Amulet of Grol
	[10754]="0:0:12:1:1:::1:0:", -- Amulet of Sevine
	[10755]="0:0:12:1:1:::1:0:", -- Amulet of Allistarj
	[10757]="0:0:15:1:1:Junk::1:0:", -- Ward of the Defiler
	[10758]="0:20144:2:3:1:TwoHandSword::1:0:", -- X'caliboar
	[10759]="0:0:12:1:1:::1:0:", -- Severed Horn of the Defiler
	[10760]="0:2914:4:3:1:Leather::1:0:", -- Swine Fists
	[10761]="0:17193:2:3:1:Dagger::1:0:", -- Coldrage Dagger
	[10762]="0:6903:4:3:1:Cloth::1:0:", -- Robes of the Lich
	[10763]="0:9079:4:3:1:Plate::1:0:", -- Icemetal Barbute
	[10764]="0:10434:4:3:1:Mail::1:0:", -- Deathchill Armor
	[10765]="0:4041:4:3:1:Leather::1:0:", -- Bonefingers
	[10766]="0:9660:2:3:1:Wand::1:0:", -- Plaguerot Sprig
	[10767]="0:9652:4:3:1:Shield::1:0:", -- Savage Boar's Guard
	[10768]="0:4541:4:3:1:Mail::1:0:", -- Boar Champion's Belt
	[10769]="0:5277:4:3:1:Amulet::1:0:", -- Glowing Eye of Mordresh
	[10770]="0:7835:4:3:1:OffHandFrill::1:0:", -- Mordresh's Lifeless Skull
	[10771]="0:2910:4:3:1:Cloth::1:0:", -- Deathmage Sash
	[10772]="0:14604:2:3:1:OneHandAxe::1:0:", -- Glutton's Cleaver
	[10773]="0:0:15:2:1:Junk::1:0:", -- Hakkari Urn
	[10774]="0:5957:4:3:1:Leather::1:0:", -- Fleshhide Shoulders
	[10775]="0:11161:4:3:1:Plate::1:0:", -- Carapace of Tuten'kash
	[10776]="0:4800:4:3:1:Cloak::1:0:", -- Silky Spider Cape
	[10777]="0:4014:4:3:1:Leather::1:0:", -- Arachnid Gloves
	[10778]="0:16930:4:2:1:Amulet::1:0:", -- Necklace of Sanctuary
	[10779]="0:8807:4:2:1:Trinket::1:0:", -- Demon's Blood
	[10780]="0:5542:4:2:1:Ring::1:0:", -- Mark of Hakkar
	[10781]="0:15072:4:2:1:Leather::1:0:", -- Hakkari Breastplate
	[10782]="0:4539:4:2:1:Cloth::1:0:", -- Hakkari Shroud
	[10783]="0:11476:4:3:1:Leather::1:0:", -- Atal'ai Spaulders
	[10784]="0:18432:4:3:1:Mail::1:0:", -- Atal'ai Breastplate
	[10785]="0:15840:4:3:1:Leather::1:0:", -- Atal'ai Leggings
	[10786]="0:14373:4:3:1:Mail::1:0:", -- Atal'ai Boots
	[10787]="0:6382:4:3:1:Cloth::1:0:", -- Atal'ai Gloves
	[10788]="0:11275:4:3:1:Plate::1:0:", -- Atal'ai Girdle
	[10789]="0:0:12:1:1:::1:0:", -- Manual of Engineering Disciplines
	[10790]="0:0:12:1:1:::1:0:", -- Gnome Engineer Membership Card
	[10791]="0:0:12:1:1:::1:0:", -- Goblin Engineer Membership Card
	[10792]="0:0:12:1:1:::1:0:", -- Nixx's Pledge of Secrecy
	[10793]="0:0:12:1:1:::1:0:", -- Overspark's Pledge of Secrecy
	[10794]="0:0:12:1:1:::1:0:", -- Oglethorpe's Pledge of Secrecy
	[10795]="0:5542:4:3:1:Ring::1:0:", -- Drakeclaw Band
	[10796]="0:8982:4:3:1:OffHandFrill::1:0:", -- Drakestone
	[10797]="0:35069:2:3:1:OneHandSword::1:0:", -- Firebreather
	[10798]="0:11024:4:3:1:Plate::1:0:", -- Atal'alarion's Tusk Ring
	[10799]="0:39288:2:3:1:Polearm::1:0:", -- Headspike
	[10800]="0:7562:4:3:1:Leather::1:0:", -- Darkwater Bracers
	[10801]="0:11704:4:3:1:Leather::1:0:", -- Slitherscale Boots
	[10802]="0:9397:4:3:1:Cloak::1:0:", -- Wingveil Cloak
	[10803]="0:35329:2:3:1:OneHandSword::1:0:", -- Blade of the Wretched
	[10804]="0:35462:2:3:1:OneHandMace::1:0:", -- Fist of the Damned
	[10805]="0:35594:2:3:1:OneHandAxe::1:0:", -- Eater of the Dead
	[10806]="0:15146:4:3:1:Cloth::1:0:", -- Vestments of the Atal'ai Prophet
	[10807]="0:15202:4:3:1:Cloth::1:0:", -- Kilt of the Atal'ai Prophet
	[10808]="0:7629:4:3:1:Cloth::1:0:", -- Gloves of the Atal'ai Prophet
	[10818]="0:0:12:1:1:::1:0:", -- Yeh'kinya's Scroll
	[10819]="0:0:12:1:20:::1:0:", -- Wildkin Feather
	[10820]="0:138:4:2:1:Cloth::1:0:", -- Jackseed Belt
	[10821]="0:208:4:2:1:Cloak::1:0:", -- Sower's Cloak
	[10822]="0:2500:15:1:1:Companion::1:0:", -- Dark Whelpling
	[10823]="0:17796:2:3:1:OneHandSword::1:0:", -- Vanquisher's Sword
	[10824]="0:5930:4:3:1:Amulet::1:0:", -- Amberglow Talisman
	[10826]="0:25501:2:2:1:Stave::1:0:", -- Staff of Lore
	[10827]="0:10238:4:2:1:Leather::1:0:", -- Surveyor's Tunic
	[10828]="0:40427:2:3:1:Dagger::1:0:", -- Dire Nail
	[10829]="0:10680:4:3:1:Amulet::1:0:", -- The Dragon's Eye
	[10830]="0:750:0:1:10:Consumable::1:0:", -- M73 Frag Grenade
	[10831]="0:0:15:1:1:CombatPet::1:0:", -- Fel Orb
	[10832]="0:0:12:1:1:::1:0:", -- Fel Tracker Owner's Manual
	[10833]="0:8597:4:3:1:Mail::1:0:", -- Horns of Eranikus
	[10834]="0:0:15:1:1:Junk::1:0:", -- Felhound Tracker Kit
	[10835]="0:24645:4:3:1:Shield::1:0:", -- Crest of Supremacy
	[10836]="0:28989:2:3:1:Wand::1:0:", -- Rod of Corrosion
	[10837]="0:38801:2:3:1:OneHandAxe::1:0:", -- Tooth of Eranikus
	[10838]="0:34665:2:3:1:OneHandMace::1:0:", -- Might of Hakkar
	[10839]="0:0:15:0:1:Junk::1:0:", -- Crystallized Note
	[10840]="0:0:15:0:1:Junk::1:0:", -- Crystallized Note
	[10841]="0:85:0:1:20:FoodDrink::1:0:", -- Goldthorn Tea
	[10842]="0:17595:4:3:1:Leather::1:0:", -- Windscale Sarong
	[10843]="0:10595:4:3:1:Cloak::1:0:", -- Featherskin Cape
	[10844]="0:44314:2:3:1:Stave::1:0:", -- Spire of Hakkar
	[10845]="0:24908:4:3:1:Plate::1:0:", -- Warrior's Embrace
	[10846]="0:16143:4:3:1:Mail::1:0:", -- Bloodshot Greaves
	[10847]="0:56921:2:4:1:OneHandSword::1:0:", -- Dragon's Call
	[10858]="3000:750:9:1:1:Blacksmithing::1:1:1471,8878,9179", -- Plans: Solid Iron Maul
	[10918]="50:12:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12097,15175,16268,16683,18006,20121,26568,27031,27038,27053,28347,29535,30239,30244,30306,32639,32641", -- Wound Poison
	[10919]="0:215:4:2:1:Cloth::1:0:", -- Apothecary Gloves
	[10920]="150:37:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12097,15175,16268,16683,18006,20121,26568,27031,27038,27053,28347,29535,30239,30244,30306,32639,32641", -- Wound Poison II
	[10921]="250:62:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12097,15175,16268,16683,18006,20121,26568,27031,27038,27053,28347,29535,30239,30244,30306,32639,32641", -- Wound Poison III
	[10922]="800:200:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12096,12097,15175,16268,16588,16683,16829,18006,18019,18802,19013,19014,19049,19239,19679,20081,20121,20194,20915,20986,22479,23145,23373,24148,24313,24780,25043,26382,26568,27031,27038,27053,27089,28347,29535,30239,30244,30306,30438,31115,32639,32641", -- Wound Poison IV
	[10938]="800:0:7:2:10:Enchanting:333:1:1:1318,3012,3346,4228,4617,5158,5757,5758,15419,16635,16722,18753,18773,18951,19234,19537,19540,19663,26569,27030,27039,27054,27147,28714,28715,29537,33597", -- Lesser Magic Essence
	[10939]="0:0:7:2:10:Enchanting:333:1:0:", -- Greater Magic Essence
	[10940]="800:0:7:1:20:Enchanting:333:1:1:1318,3012,3346,4228,4617,5158,5757,5758,15419,16635,16722,18753,18773,18951,19234,19537,19540,19663,26569,27030,27039,27054,27147,28714,28715,29537,33597", -- Strange Dust
	[10958]="0:0:12:1:1:::1:0:", -- Hilary's Necklace
	[10959]="0:8750:1:2:1:Bag::1:0:", -- Demon Hide Sack
	[10978]="0:0:7:3:20:Enchanting:333:1:0:", -- Small Glimmering Shard
	[10998]="0:0:7:2:10:Enchanting:333:1:0:", -- Lesser Astral Essence
	[10999]="0:0:12:1:1:::1:0:", -- Ironfel
	[11000]="0:0:13:1:1:::1:0:", -- Shadowforge Key
	[11018]="0:146:12:1:100:::1:0:", -- Un'Goro Soil
	[11020]="10000:0:12:1:1:::1:0:4217,7879,9087", -- Evergreen Pouch
	[11022]="1000:250:12:1:20:::1:0:4217,7879,9087", -- Packet of Tharlendris Seeds
	[11023]="10000:2500:15:1:1:Companion::1:0:6548", -- Ancona Chicken
	[11024]="0:0:12:1:1:::1:0:", -- Evergreen Herb Casing
	[11026]="10000:2500:15:1:1:Companion::1:0:14860", -- Tree Frog Box
	[11027]="10000:2500:15:1:1:Companion::1:1:14860", -- Wood Frog Box
	[11038]="0:200:9:2:1:Enchanting::1:0:", -- Formula: Enchant 2H Weapon - Lesser Spirit
	[11039]="800:200:9:2:1:Enchanting::1:1:3954,12043", -- Formula: Enchant Cloak - Minor Agility
	[11040]="0:1:12:1:20::197:1:0:", -- Morrowgrain
	[11058]="0:0:12:1:1:::1:0:", -- Sha'ni's Nose-Ring
	[11078]="0:0:13:1:20:::1:0:", -- Relic Coffer Key
	[11079]="0:0:15:1:1:Junk::1:0:", -- Gor'tesh's Lopped Off Head
	[11080]="0:0:12:1:1:::1:0:", -- Gor'tesh's Lopped Off Head
	[11081]="0:200:9:2:1:Enchanting::1:0:", -- Formula: Enchant Shield - Lesser Protection
	[11082]="0:0:7:2:10:Enchanting:333:1:0:", -- Greater Astral Essence
	[11083]="0:0:7:1:20:Enchanting:333,755:1:0:", -- Soul Dust
	[11084]="0:0:7:3:20:Enchanting:333:1:0:", -- Large Glimmering Shard
	[11086]="0:27403:2:3:1:OneHandSword::1:0:", -- Jang'thraze the Protector
	[11098]="0:500:9:2:1:Enchanting::1:0:", -- Formula: Enchant Cloak - Lesser Shadow Resistance
	[11101]="2500:625:9:2:1:Enchanting::1:1:3954,12043", -- Formula: Enchant Bracer - Lesser Strength
	[11102]="0:0:12:1:1:::1:0:", -- Unhatched Sprite Darter Egg
	[11103]="0:0:12:1:1:::1:0:", -- Seed Voucher
	[11104]="0:0:12:1:1:::1:0:", -- Large Compass
	[11105]="0:0:12:1:1:::1:0:", -- Curled Map Parchment
	[11106]="0:0:13:1:1:::1:0:", -- Lion-headed Key
	[11107]="0:0:12:1:1:::1:0:", -- A Small Pack
	[11108]="0:0:12:1:1:::1:0:", -- Faded Photograph
	[11109]="25:6:0:1:1:FoodDrink::1:0:233,33996", -- Special Chicken Feed
	[11110]="0:2:15:1:1:Companion::1:0:", -- Chicken Egg
	[11112]="0:0:12:1:1:::1:0:", -- Research Equipment
	[11113]="0:0:12:1:1:::1:0:", -- Crate of Foodstuffs
	[11114]="0:0:12:1:20:::1:0:", -- Dinosaur Bone
	[11116]="0:0:15:2:1:Junk::1:0:", -- A Mangled Journal
	[11118]="0:10795:4:3:1:Ring::1:0:", -- Archaedic Stone
	[11119]="0:0:12:1:20:::1:0:", -- Milly's Harvest
	[11120]="0:30144:2:2:1:OneHandMace::1:0:", -- Belgrom's Hammer
	[11121]="0:3529:2:3:1:OneHandSword::1:0:", -- Darkwater Talwar
	[11122]="0:7162:4:2:1:Trinket::1:0:", -- Carrot on a Stick
	[11123]="0:15037:4:3:1:Cloth::1:0:", -- Rainstrider Leggings
	[11124]="0:16980:4:3:1:Mail::1:0:", -- Helm of Exile
	[11125]="0:0:12:1:1:::1:0:", -- Grape Manifest
	[11126]="0:0:12:1:1:::1:0:", -- Tablet of Kurniya
	[11127]="0:0:12:1:20:::1:0:", -- Scavenged Goods
	[11128]="0:500:7:1:1:Enchanting:333:1:0:", -- Golden Rod
	[11129]="0:0:12:1:20:::1:0:", -- Essence of the Elements
	[11130]="0:500:7:1:1:Enchanting:333:1:0:", -- Runed Golden Rod
	[11131]="0:0:12:1:1:::1:0:", -- Hive Wall Sample
	[11132]="0:0:12:1:1:::1:0:", -- Unused Scraping Vial
	[11133]="0:0:12:1:1:::1:0:", -- Linken's Training Sword
	[11134]="0:0:7:2:10:Enchanting:333:1:0:", -- Lesser Mystic Essence
	[11135]="0:0:7:2:10:Enchanting:333:1:0:", -- Greater Mystic Essence
	[11136]="0:0:12:1:1:::1:0:", -- Linken's Tempered Sword
	[11137]="0:0:7:1:20:Enchanting:333,755,197:1:0:", -- Vision Dust
	[11138]="0:0:7:3:20:Enchanting:333:1:0:", -- Small Glowing Shard
	[11139]="0:0:7:3:20:Enchanting:333:1:0:", -- Large Glowing Shard
	[11140]="0:0:13:1:1:::1:0:", -- Prison Cell Key
	[11141]="2000:0:12:1:1:::1:0:7775", -- Bait
	[11142]="0:0:12:1:1:::1:0:", -- Broken Samophlange
	[11143]="0:0:12:1:20:::1:0:", -- Nugget Slug
	[11144]="0:1000:7:1:1:Enchanting:333:1:0:", -- Truesilver Rod
	[11145]="0:1250:7:1:1:Enchanting:333:1:0:", -- Runed Truesilver Rod
	[11146]="0:0:12:1:1:::1:0:", -- Broken and Battered Samophlange
	[11147]="0:0:12:1:1:::1:0:", -- Samophlange Manual Cover
	[11148]="0:0:0:1:20:Consumable::1:0:", -- Samophlange Manual Page
	[11149]="0:0:12:1:1:::1:0:", -- Samophlange Manual
	[11150]="0:750:9:2:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Mining
	[11151]="0:750:9:2:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Herbalism
	[11152]="0:750:9:2:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Fishing
	[11162]="0:0:12:1:1:::1:0:", -- Linken's Superior Sword
	[11163]="3000:750:9:2:1:Enchanting::1:1:2381,2821", -- Formula: Enchant Bracer - Lesser Deflection
	[11164]="0:750:9:2:1:Enchanting::1:0:", -- Formula: Enchant Weapon - Lesser Beastslayer
	[11165]="0:750:9:2:1:Enchanting::1:0:", -- Formula: Enchant Weapon - Lesser Elemental Slayer
	[11166]="0:1000:9:2:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Skinning
	[11167]="0:1000:9:2:1:Enchanting::1:0:", -- Formula: Enchant Boots - Lesser Spirit
	[11168]="0:1000:9:2:1:Enchanting::1:0:", -- Formula: Enchant Shield - Lesser Block
	[11169]="0:0:12:1:1:::1:0:", -- Book of Aquor
	[11172]="0:0:12:1:20:::1:0:", -- Silvery Claws
	[11173]="0:0:12:1:1:::1:0:", -- Irontree Heart
	[11174]="0:0:7:2:10:Enchanting:333:1:0:", -- Lesser Nether Essence
	[11175]="0:0:7:2:10:Enchanting:333:1:0:", -- Greater Nether Essence
	[11176]="0:0:7:1:20:Enchanting:171,333,197:1:0:", -- Dream Dust
	[11177]="0:0:7:3:20:Enchanting:333:1:0:", -- Small Radiant Shard
	[11178]="0:0:7:3:20:Enchanting:333,755:1:0:", -- Large Radiant Shard
	[11179]="0:0:12:1:1:::1:0:", -- Golden Flame
	[11184]="0:0:12:1:100:::1:0:", -- Blue Power Crystal
	[11185]="0:0:12:1:100:::1:0:", -- Green Power Crystal
	[11186]="0:0:12:1:100:::1:0:", -- Red Power Crystal
	[11187]="0:5:4:1:1:Cloth::1:0:", -- Stemleaf Bracers
	[11188]="0:0:12:1:100:::1:0:", -- Yellow Power Crystal
	[11189]="0:10:4:1:1:Cloth::1:0:", -- Woodland Robes
	[11190]="0:5:4:1:1:Cloth::1:0:", -- Viny Gloves
	[11191]="0:45:4:1:1:Cloth::1:0:", -- Farmer's Boots
	[11192]="0:4:4:1:1:Cloth::1:0:", -- Outfitter Gloves
	[11193]="0:16938:4:2:1:Leather::1:0:", -- Blazewind Breastplate
	[11194]="0:20405:4:2:1:Mail::1:0:", -- Prismscale Hauberk
	[11195]="0:23897:4:2:1:Plate::1:0:", -- Warforged Chestplate
	[11196]="0:16875:4:2:1:Amulet::1:0:", -- Mindburst Medallion
	[11197]="0:0:13:1:1:::1:0:", -- Dark Keeper Key
	[11202]="0:1100:9:2:1:Enchanting::1:0:", -- Formula: Enchant Shield - Stamina
	[11203]="0:1100:9:2:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Advanced Mining
	[11204]="0:1100:9:2:1:Enchanting::1:0:", -- Formula: Enchant Bracer - Greater Spirit
	[11205]="0:1250:9:2:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Advanced Herbalism
	[11206]="0:1250:9:2:1:Enchanting::1:0:", -- Formula: Enchant Cloak - Lesser Agility
	[11207]="0:3000:9:2:1:Enchanting::1:0:", -- Formula: Enchant Weapon - Fiery Weapon
	[11208]="0:1350:9:2:1:Enchanting::1:0:", -- Formula: Enchant Weapon - Demonslaying
	[11222]="0:0:12:1:1:::1:0:", -- Head of Krom'zar
	[11223]="5800:1450:9:2:1:Enchanting::1:1:989,4229", -- Formula: Enchant Bracer - Deflection
	[11224]="0:1450:9:2:1:Enchanting::1:0:", -- Formula: Enchant Shield - Frost Resistance
	[11225]="0:1550:9:2:1:Enchanting::1:0:", -- Formula: Enchant Bracer - Greater Stamina
	[11226]="0:1550:9:2:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Riding Skill
	[11227]="0:0:12:1:1:::1:0:", -- Piece of Krom'zar's Banner
	[11229]="0:1696:4:2:1:Mail::1:0:", -- Brightscale Girdle
	[11230]="0:0:12:1:1:::1:0:", -- Encased Fiery Essence
	[11231]="0:0:12:1:10:::1:0:", -- Altered Black Dragonflight Molt
	[11242]="0:0:12:1:1:::1:0:", -- Evoroot
	[11243]="0:0:12:1:20:::1:0:", -- Videre Elixir
	[11262]="0:8142:4:3:1:OffHandFrill::1:0:", -- Orb of Lorica
	[11263]="0:10103:2:3:1:Wand::1:0:", -- Nether Force Wand
	[11265]="0:16485:2:2:1:TwoHandMace::1:0:", -- Cragwood Maul
	[11266]="0:0:12:1:20:::1:0:", -- Fractured Elemental Shard
	[11267]="0:0:12:1:1:::1:0:", -- Elemental Shard Sample
	[11268]="0:0:12:1:1:::1:0:", -- Head of Argelmach
	[11269]="0:0:12:1:10:::1:0:", -- Intact Elemental Core
	[11270]="0:0:12:1:1:::1:0:", -- Nixx's Signed Pledge
	[11282]="0:0:12:1:1:::1:0:", -- Oglethorpe's Signed Pledge
	[11283]="0:0:12:1:1:::1:0:", -- Overspark's Signed Pledge
	[11284]="1000:1:6:1:1000:Bullet::200:0:734,1149,1285,1297,1461,2084,2401,2685,2803,2806,2808,2820,2908,3018,3053,3313,3322,3350,3541,4170,4241,4555,4603,4889,4896,5101,5123,5134,6028,7942,8131,8139,8362,9548,9551,11038,11184,11555,12021,12027,12246,12959,12960,14624,15174,15397,16191,16602,16620,16732,16735,16826,18011,18907,18959,19020,19021,19053,19197,19243,19314,19315,19339,19343,19351,19374,19436,19452,19473,19474,19498,19534,19560,19574,19625,19649,19679,19694,19718,20080,20092,20194,20231,20249,20892,21082,21111,21172,21183,21483,21488,22099,22270,23143,23373,24053,24141,24348,25035,26718,27071,28792,28807,29207", -- Accurate Slugs
	[11285]="1000:2:6:1:1000:Arrow::200:0:228,734,789,1149,1285,1298,1462,2084,2401,2803,2806,2808,2820,2839,2908,3015,3313,3350,3410,3541,4170,4173,4241,4555,4604,4892,4896,5101,5122,5134,6028,7942,8139,8362,9548,9551,9552,9555,11038,11555,12021,12027,12246,12959,12960,14301,14624,15174,15397,16191,16602,16732,16826,16919,17598,18011,18907,18959,19020,19021,19053,19197,19243,19314,19315,19339,19343,19351,19374,19436,19452,19473,19474,19498,19534,19560,19561,19574,19625,19649,19679,19694,19718,20080,20092,20194,20231,20249,20892,21082,21111,21172,21183,21483,21488,22099,22270,23143,23373,24053,24141,24348,25035,26718,27055,27071,28792,28807,29207", -- Jagged Arrow
	[11286]="0:0:12:1:1:::1:0:", -- Thorium Shackles
	[11287]="0:508:2:2:1:Wand::1:0:", -- Lesser Magic Wand
	[11288]="0:1535:2:2:1:Wand::1:0:", -- Greater Magic Wand
	[11289]="0:3581:2:2:1:Wand::1:0:", -- Lesser Mystic Wand
	[11290]="0:5263:2:2:1:Wand::1:0:", -- Greater Mystic Wand
	[11291]="4500:1125:7:1:20:Other:333,202:1:0:1318,3012,3346,4228,4617,5158,5757,5758,15419,16635,16722,18753,18773,18951,19234,19537,19540,19663,26569,27030,27039,27054,27147,28714,28715,29537,33597", -- Star Wood
	[11302]="0:7130:4:3:1:Trinket::1:0:", -- Uther's Strength
	[11303]="3185:637:2:2:1:Bow::1:1:1198,1298,3015,3410,4173,4604,5122", -- Fine Shortbow
	[11304]="4862:972:2:2:1:Bow::1:1:228,1459,1668,1687,3488,3534,9549,9551,9553", -- Fine Longbow
	[11305]="25814:5162:2:2:1:Bow::1:1:3951,9551,9555,14301", -- Dense Shortbow
	[11306]="19468:3893:2:2:1:Bow::1:1:1298,3410,4604,5122", -- Sturdy Recurve
	[11307]="67952:13590:2:2:1:Bow::1:1:1298,3015,3410,4604,24028", -- Massive Longbow
	[11308]="78829:15765:2:2:1:Bow::1:1:9548,19499,24028", -- Sylvan Shortbow
	[11309]="0:0:12:1:1:::1:0:", -- The Heart of the Mountain
	[11310]="0:6598:4:3:1:Cloth::1:0:", -- Flameseer Mantle
	[11311]="0:6132:4:3:1:Cloak::1:0:", -- Emberscale Cape
	[11312]="0:0:12:1:1:::1:0:", -- Lost Thunderbrew Recipe
	[11313]="0:0:12:1:1:::1:0:", -- Ribbly's Head
	[11315]="0:0:12:1:100:::1:0:", -- Bloodpetal Sprout
	[11316]="0:0:12:1:20:::1:0:", -- Bloodpetal
	[11318]="0:0:12:1:20:::1:0:", -- Atal'ai Haze
	[11319]="0:0:12:1:1:::1:0:", -- Unloaded Zapper
	[11320]="0:0:12:1:1:::1:0:", -- Bloodpetal Zapper
	[11324]="0:6250:1:1:1:Bag::1:0:", -- Explorer's Knapsack
	[11325]="600:150:0:1:20:Other::1:1:9499", -- Dark Iron Ale Mug
	[11362]="1000:250:11:1:1:Quiver::1:0:228,789,1198,1287,1297,1298,1459,1462,1668,1687,2839,3015,3165,3409,3410,3488,3589,3610,3951,4173,4203,4602,4604,4892,5122,6028,7976,9548,9549,9551,9552,9553,9555,10369,12029,14301,16263,16274,16619,16715,16919,17598,17667,19020,19561,27055", -- Medium Quiver
	[11363]="1000:250:11:1:1:AmmoPouch::1:0:2685,6028", -- Medium Shot Pouch
	[11364]="0:0:4:1:1:Tabard::1:0:", -- Tabard of Stormwind
	[11366]="0:0:12:1:1:::1:0:", -- Helendis Riverhorn's Letter
	[11367]="0:0:12:1:1:::1:0:", -- Solomon's Plea to Bolvar
	[11368]="0:0:12:1:1:::1:0:", -- Wrynn's Decree
	[11370]="0:500:7:1:20:MetalStone:186:1:0:", -- Dark Iron Ore
	[11371]="0:600:7:1:20:MetalStone:164,202,755:1:0:", -- Dark Iron Bar
	[11382]="0:750:3:2:20:GemSimple:164,755:1:0:", -- Blood of the Mountain
	[11384]="0:70:15:0:20:Junk::1:0:", -- Broken Basilisk Teeth
	[11385]="0:145:15:0:20:Junk::1:0:", -- Basilisk Scale
	[11386]="0:676:15:0:10:Junk::1:0:", -- Squishy Basilisk Eye
	[11387]="0:1013:15:0:5:Junk::1:0:", -- Basilisk Heart
	[11388]="0:1563:15:0:5:Junk::1:0:", -- Basilisk Venom
	[11389]="0:2163:15:0:5:Junk::1:0:", -- Shimmering Basilisk Skin
	[11390]="0:80:15:0:20:Junk::1:0:", -- Broken Bat Fang
	[11391]="0:205:15:0:10:Junk::1:0:", -- Spined Bat Wing
	[11392]="0:403:15:0:5:Junk::1:0:", -- Severed Bat Claw
	[11393]="0:780:15:0:10:Junk::1:0:", -- Small Bat Skull
	[11394]="0:580:15:0:10:Junk::1:0:", -- Bat Heart
	[11395]="0:830:15:0:10:Junk::1:0:", -- Bat Ear
	[11402]="0:1205:15:0:10:Junk::1:0:", -- Sleek Bat Pelt
	[11403]="0:1592:15:0:10:Junk::1:0:", -- Large Bat Fang
	[11404]="0:2080:12:1:10:::1:0:", -- Evil Bat Eye
	[11405]="0:0:12:1:20:::1:0:", -- Giant Silver Vein
	[11406]="0:168:15:0:5:Junk::1:0:", -- Rotting Bear Carcass
	[11407]="0:108:12:1:10:::1:0:", -- Torn Bear Pelt
	[11408]="0:898:15:0:10:Junk::1:0:", -- Bear Jaw
	[11409]="0:503:15:0:10:Junk::1:0:", -- Bear Organ
	[11410]="0:578:15:0:10:Junk::1:0:", -- Savage Bear Claw
	[11411]="0:1484:2:0:1:OneHandMace::1:0:", -- Large Bear Bone
	[11412]="0:0:12:1:1:::1:0:", -- Nagmara's Vial
	[11413]="0:0:12:1:1:::1:0:", -- Nagmara's Filled Vial
	[11414]="0:1828:15:0:10:Junk::1:0:", -- Grizzled Mane
	[11415]="0:200:0:1:20:FoodDrink::1:0:", -- Mixed Berries
	[11416]="0:328:15:0:10:Junk::1:0:", -- Delicate Ribcage
	[11417]="0:1204:15:0:5:Junk::1:0:", -- Feathery Wing
	[11418]="0:604:15:0:5:Junk::1:0:", -- Hollow Wing Bone
	[11419]="0:1900:15:0:10:Junk::1:0:", -- Mysterious Unhatched Egg
	[11420]="0:1712:15:0:10:Junk::1:0:", -- Elegant Writing Tool
	[11422]="0:0:15:1:1:Junk::1:0:", -- Goblin Engineer's Renewal Gift
	[11423]="0:0:15:1:1:Junk::1:0:", -- Gnome Engineer's Renewal Gift
	[11444]="4000:200:0:1:20:FoodDrink::5:0:9499", -- Grim Guzzler Boar
	[11445]="0:0:12:1:1:::1:0:", -- Flute of the Ancients
	[11446]="0:0:12:1:1:::1:0:", -- A Crumpled Up Note
	[11462]="0:0:12:1:1:::1:0:", -- Discarded Knife
	[11463]="0:0:12:2:1:::1:0:", -- Undelivered Parcel
	[11464]="0:0:12:1:1:::1:0:", -- Marshal Windsor's Lost Information
	[11465]="0:0:12:1:1:::1:0:", -- Marshal Windsor's Lost Information
	[11466]="0:0:12:1:1:::1:0:", -- Raschal's Report
	[11467]="0:0:12:1:50:::1:0:", -- Blackrock Medallion
	[11468]="0:0:12:1:20:::1:0:", -- Dark Iron Fanny Pack
	[11469]="0:3563:4:2:1:Cloth::1:0:", -- Bloodband Bracers
	[11470]="0:0:12:1:1:::1:0:", -- Tablet Transcript
	[11471]="0:0:12:1:1:::1:0:", -- Fragile Sprite Darter Egg
	[11472]="0:0:12:1:10:::1:0:", -- Silvermane Stalker Flank
	[11474]="0:0:15:1:1:Companion::1:0:", -- Sprite Darter Egg
	[11475]="0:7:4:1:1:Cloak::1:0:", -- Wine-stained Cloak
	[11476]="0:0:12:1:1:::1:0:", -- U'cha's Pelt
	[11477]="0:0:12:1:10:::1:0:", -- White Ravasaur Claw
	[11478]="0:0:12:1:10:::1:0:", -- Un'Goro Gorilla Pelt
	[11479]="0:0:12:1:10:::1:0:", -- Un'Goro Stomper Pelt
	[11480]="0:0:12:1:10:::1:0:", -- Un'Goro Thunderer Pelt
	[11482]="0:0:15:0:1:Junk::1:0:", -- Crystal Pylon User's Manual
	[11502]="0:6510:4:2:1:Leather::1:0:", -- Loreskin Shoulders
	[11503]="0:0:12:1:20:::1:0:", -- Blood Amber
	[11504]="0:0:12:1:1:::1:0:", -- Piece of Threshadon Carcass
	[11507]="0:0:12:1:20:::1:0:", -- Spotted Hyena Pelt
	[11508]="0:1:4:1:1:Cloth::1:0:", -- Gamemaster's Slippers
	[11509]="0:0:12:1:5:::1:0:", -- Ravasaur Pheromone Gland
	[11510]="0:0:12:1:1:::1:0:", -- Lar'korwi's Head
	[11511]="0:0:12:1:1:::1:0:", -- Cenarion Beacon
	[11512]="0:0:12:1:20:::1:0:", -- Patch of Tainted Skin
	[11513]="0:1:12:1:20:::1:0:", -- Tainted Vitriol
	[11514]="0:1:12:1:20:::1:0:", -- Fel Creep
	[11515]="0:1:12:1:20:::1:0:", -- Corrupted Soul Shard
	[11516]="0:0:12:1:100:::1:0:", -- Cenarion Plant Salve
	[11522]="0:0:4:1:1:OffHandFrill::1:0:", -- Silver Totem of Aquementas
	[11562]="0:1000:12:1:20:::1:0:", -- Crystal Restore
	[11563]="0:1000:12:1:20:::1:0:", -- Crystal Force
	[11564]="0:1000:12:1:20:::1:0:", -- Crystal Ward
	[11565]="0:1000:12:1:20:::1:0:", -- Crystal Yield
	[11566]="0:1000:12:1:20:::1:0:", -- Crystal Charge
	[11567]="0:1000:12:1:20:::1:0:", -- Crystal Spire
	[11568]="0:0:15:1:1:Junk::1:0:", -- Torwa's Pouch
	[11569]="0:0:12:1:1:::1:0:", -- Preserved Threshadon Meat
	[11570]="0:0:12:1:1:::1:0:", -- Preserved Pheromone Mixture
	[11582]="0:0:15:1:1:Junk::1:0:", -- Fel Salve
	[11583]="0:0:12:1:10:::1:0:", -- Cactus Apple
	[11584]="0:1:0:1:20:FoodDrink::1:0:", -- Cactus Apple Surprise
	[11590]="0:250:7:1:5:Device::1:0:", -- Mechanical Repair Kit
	[11602]="0:0:13:1:1:::1:0:", -- Grim Guzzler Key
	[11603]="0:30656:2:3:1:FistWeapon::1:0:", -- Vilerend Slicer
	[11604]="0:34000:4:3:1:Plate::1:0:", -- Dark Iron Plate
	[11605]="0:18822:4:2:1:Plate::1:0:", -- Dark Iron Shoulders
	[11606]="0:19256:4:2:1:Mail::1:0:", -- Dark Iron Mail
	[11607]="0:51225:2:3:1:TwoHandAxe::1:0:", -- Dark Iron Sunderer
	[11608]="0:45760:2:3:1:TwoHandMace::1:0:", -- Dark Iron Pulverizer
	[11610]="0:3000:9:3:1:Blacksmithing::1:0:", -- Plans: Dark Iron Pulverizer
	[11611]="0:3000:9:3:1:Blacksmithing::1:0:", -- Plans: Dark Iron Sunderer
	[11612]="0:3000:9:3:1:Blacksmithing::1:0:", -- Plans: Dark Iron Plate
	[11614]="0:3000:9:2:1:Blacksmithing::1:0:", -- Plans: Dark Iron Mail
	[11615]="0:3000:9:2:1:Blacksmithing::1:0:", -- Plans: Dark Iron Shoulders
	[11617]="0:0:12:1:1:::1:0:", -- Eridan's Supplies
	[11622]="0:0:0:2:1:EnhPerm::1:0:", -- Lesser Arcanum of Rumination
	[11623]="0:9999:4:3:1:Cloak::1:0:", -- Spritecaster Cape
	[11624]="0:9079:4:3:1:Cloth::1:0:", -- Kentic Amice
	[11625]="0:10452:4:3:1:OffHandFrill::1:0:", -- Enthralled Sphere
	[11626]="0:9698:4:3:1:Cloak::1:0:", -- Blackveil Cape
	[11627]="0:14668:4:3:1:Mail::1:0:", -- Fleetfoot Greaves
	[11628]="0:24433:2:3:1:Bow::1:0:", -- Houndmaster's Bow
	[11629]="0:24527:2:3:1:Gun::1:0:", -- Houndmaster's Rifle
	[11630]="0:5:6:3:1000:Bullet::1:0:", -- Rockshard Pellets
	[11631]="0:19893:4:3:1:Shield::1:0:", -- Stoneshell Guard
	[11632]="0:16349:4:3:1:Plate::1:0:", -- Earthslag Shoulders
	[11633]="0:24633:4:3:1:Plate::1:0:", -- Spiderfang Carapace
	[11634]="0:7063:4:3:1:Cloth::1:0:", -- Silkweb Gloves
	[11635]="0:35451:2:3:1:Dagger::1:0:", -- Hookfang Shanker
	[11642]="0:0:0:2:1:EnhPerm::1:0:", -- Lesser Arcanum of Constitution
	[11643]="0:0:0:2:1:EnhPerm::1:0:", -- Lesser Arcanum of Tenacity
	[11644]="0:0:0:2:1:EnhPerm::1:0:", -- Lesser Arcanum of Resilience
	[11645]="0:0:0:2:1:EnhPerm::1:0:", -- Lesser Arcanum of Voracity
	[11646]="0:0:0:2:1:EnhPerm::1:0:", -- Lesser Arcanum of Voracity
	[11647]="0:0:0:2:1:EnhPerm::1:0:", -- Lesser Arcanum of Voracity
	[11648]="0:0:0:2:1:EnhPerm::1:0:", -- Lesser Arcanum of Voracity
	[11649]="0:0:0:2:1:EnhPerm::1:0:", -- Lesser Arcanum of Voracity
	[11662]="0:7462:4:3:1:Cloth::1:0:", -- Ban'thok Sash
	[11665]="0:8532:4:3:1:Leather::1:0:", -- Ogreseer Fists
	[11668]="0:0:12:1:1:::1:0:", -- Flute of Xavaric
	[11669]="0:17157:4:3:1:Ring::1:0:", -- Naglering
	[11674]="0:0:12:1:20:::1:0:", -- Jadefire Felbind
	[11675]="0:14464:4:3:1:Leather::1:0:", -- Shadefiend Boots
	[11677]="0:11655:4:3:1:Cloak::1:0:", -- Graverot Cape
	[11678]="0:27293:4:3:1:Plate::1:0:", -- Carapace of Anub'shiah
	[11679]="0:11738:4:3:1:Mail::1:0:", -- Rubicund Armguards
	[11682]="0:0:12:1:1:::1:0:", -- Eridan's Vial
	[11684]="0:63086:2:4:1:OneHandMace::1:0:", -- Ironfoe
	[11685]="0:13941:4:3:1:Leather::1:0:", -- Splinthide Shoulders
	[11686]="0:9329:4:3:1:Leather::1:0:", -- Girdle of Beastial Fury
	[11702]="0:36752:2:3:1:OneHandAxe::1:0:", -- Grizzle's Skinner
	[11703]="0:12986:4:3:1:Plate::1:0:", -- Stonewall Girdle
	[11722]="0:16610:4:3:1:Mail::1:0:", -- Dregmetal Spaulders
	[11723]="0:0:12:1:1:::1:0:", -- Goodsteel's Balanced Flameberge
	[11724]="0:0:12:1:1:::1:0:", -- Overdue Package
	[11725]="0:0:12:1:20:::1:0:", -- Solid Crystal Leg Shaft
	[11726]="0:33533:4:4:1:Mail::1:0:", -- Savage Gladiator Chain
	[11727]="0:0:12:1:1:::1:0:", -- Goodsteel Ledger
	[11728]="0:25336:4:3:1:Mail::1:0:", -- Savage Gladiator Leggings
	[11729]="0:19073:4:3:1:Mail::1:0:", -- Savage Gladiator Helm
	[11730]="0:12762:4:3:1:Mail::1:0:", -- Savage Gladiator Grips
	[11731]="0:19300:4:3:1:Mail::1:0:", -- Savage Gladiator Greaves
	[11732]="0:0:9:2:1:Book::1:0:", -- Libram of Rumination
	[11733]="0:0:9:2:1:Book::1:0:", -- Libram of Constitution
	[11734]="0:0:9:2:1:Book::1:0:", -- Libram of Tenacity
	[11735]="0:16670:4:3:1:Leather::1:0:", -- Ragefury Eyepatch
	[11736]="0:0:9:2:1:Book::1:0:", -- Libram of Resilience
	[11737]="0:0:9:2:1:Book::1:0:", -- Libram of Voracity
	[11742]="0:8750:1:2:1:Bag::1:0:", -- Wayfarer's Knapsack
	[11743]="0:36881:2:3:1:FistWeapon::1:0:", -- Rockfist
	[11744]="0:39242:2:3:1:FistWeapon::1:0:", -- Bloodfist
	[11745]="0:13865:4:3:1:Plate::1:0:", -- Fists of Phalanx
	[11746]="0:20718:4:3:1:Plate::1:0:", -- Golem Skull Helm
	[11747]="0:16659:4:3:1:Leather::1:0:", -- Flamestrider Robes
	[11748]="0:25083:2:3:1:Wand::1:0:", -- Pyric Caduceus
	[11749]="0:20141:4:3:1:Mail::1:0:", -- Searingscale Leggings
	[11750]="0:43234:2:3:1:Stave::1:0:", -- Kindling Stave
	[11751]="0:0:12:1:5:::1:0:", -- Burning Essence
	[11752]="0:0:12:1:5:::1:0:", -- Black Blood of the Tormented
	[11753]="0:0:12:1:1:::1:0:", -- Eye of Kajal
	[11754]="0:0:12:2:20::164,755,165:1:0:", -- Black Diamond
	[11755]="0:14627:4:3:1:Amulet::1:0:", -- Verek's Collar
	[11764]="0:10398:4:3:1:Leather::1:0:", -- Cinderhide Armsplints
	[11765]="0:12525:4:3:1:Mail::1:0:", -- Pyremail Wristguards
	[11766]="0:8606:4:3:1:Cloth::1:0:", -- Flameweave Cuffs
	[11767]="0:15202:4:3:1:Plate::1:0:", -- Emberplate Armguards
	[11768]="0:8669:4:3:1:Cloth::1:0:", -- Incendic Bracers
	[11782]="0:12720:4:3:1:Cloth::1:0:", -- Boreal Mantle
	[11783]="0:12767:4:3:1:Mail::1:0:", -- Chillsteel Girdle
	[11784]="0:33835:2:3:1:OneHandSword::1:0:", -- Arbiter's Blade
	[11785]="0:29083:4:3:1:Shield::1:0:", -- Rock Golem Bulwark
	[11786]="0:50740:2:3:1:TwoHandSword::1:0:", -- Stone of the Earth
	[11787]="0:23986:4:3:1:Plate::1:0:", -- Shalehusk Boots
	[11802]="0:31459:4:3:1:Plate::1:0:", -- Lavacrest Leggings
	[11803]="0:50177:2:3:1:TwoHandMace::1:0:", -- Force of Magma
	[11804]="0:0:12:1:1:::1:0:", -- Spraggle's Canteen
	[11805]="0:40439:2:3:1:OneHandMace::1:0:", -- Rubidium Hammer
	[11807]="0:9153:4:3:1:Cloth::1:0:", -- Sash of the Burning Heart
	[11808]="0:19292:4:4:1:Cloth::1:0:", -- Circle of Flame
	[11809]="0:51287:2:3:1:Polearm::1:0:", -- Flame Wrath
	[11810]="0:10000:4:3:1:Trinket::1:0:", -- Force of Will
	[11811]="0:1500:4:3:1:Trinket::1:0:", -- Smoking Heart of the Mountain
	[11812]="0:13979:4:3:1:Cloak::1:0:", -- Cape of the Fire Salamander
	[11813]="0:3000:9:2:1:Enchanting::1:0:", -- Formula: Smoking Heart of the Mountain
	[11814]="0:13083:4:3:1:Mail::1:0:", -- Molten Fists
	[11815]="0:10000:4:3:1:Trinket::1:0:", -- Hand of Justice
	[11816]="0:48882:2:3:1:TwoHandAxe::1:0:", -- Angerforge's Battle Axe
	[11817]="0:39254:2:3:1:OneHandSword::1:0:", -- Lord General's Sword
	[11818]="0:0:12:1:1:::1:0:", -- Grimesilt Outhouse Key
	[11819]="0:10000:4:3:1:Trinket::1:0:", -- Second Wind
	[11820]="0:26761:4:3:1:Mail::1:0:", -- Royal Decorated Armor
	[11821]="0:22385:4:3:1:Leather::1:0:", -- Warstrife Leggings
	[11822]="0:14153:4:3:1:Cloth::1:0:", -- Omnicast Boots
	[11823]="0:23677:4:3:1:Leather::1:0:", -- Luminary Kilt
	[11824]="0:13657:4:3:1:Ring::1:0:", -- Cyclopean Band
	[11825]="0:2500:15:1:1:Companion::1:0:", -- Pet Bombling
	[11826]="0:2500:15:1:1:Companion::1:0:", -- Lil' Smoky
	[11827]="0:675:9:2:1:Engineering::1:0:", -- Schematic: Lil' Smoky
	[11828]="0:675:9:2:1:Engineering::1:0:", -- Schematic: Pet Bombling
	[11829]="0:0:12:1:20:::1:0:", -- Un'Goro Ash
	[11830]="0:0:12:1:20:::1:0:", -- Webbed Diemetradon Scale
	[11831]="0:0:12:1:20:::1:0:", -- Webbed Pterrordax Scale
	[11832]="0:10000:4:3:1:Trinket::1:0:", -- Burst of Knowledge
	[11833]="0:0:12:1:1:::1:0:", -- Gorishi Queen Lure
	[11834]="0:0:12:1:20:::1:0:", -- Super Sticky Tar
	[11835]="0:0:12:1:1:::1:0:", -- Gorishi Queen Brain
	[11837]="0:0:12:1:1:::1:0:", -- Gorishi Scent Gland
	[11839]="0:11191:4:3:1:Cloth::1:0:", -- Chief Architect's Monocle
	[11840]="0:7137:4:1:1:Shirt::1:0:", -- Master Builder's Shirt
	[11841]="0:15032:4:3:1:Cloth::1:0:", -- Senior Designer's Pantaloons
	[11842]="0:17050:4:3:1:Mail::1:0:", -- Lead Surveyor's Mantle
	[11843]="0:0:12:1:1:::1:0:", -- Bank Voucher
	[11844]="0:0:12:1:1:::1:0:", -- Pestlezugg's Un'Goro Report
	[11845]="0:62:1:1:1:Bag::1:0:", -- Handmade Leather Bag
	[11846]="0:30:0:1:20:FoodDrink::1:0:", -- Wizbang's Special Brew
	[11847]="0:7:4:1:1:Cloak::1:0:", -- Battered Cloak
	[11848]="0:5:4:1:1:Cloth::1:0:", -- Flax Belt
	[11849]="0:7:4:1:1:Mail::1:0:", -- Rustmetal Bracers
	[11850]="0:7:4:1:1:Cloak::1:0:", -- Short Duskbat Cape
	[11851]="0:12:4:1:1:Leather::1:0:", -- Scavenger Tunic
	[11852]="0:14:4:1:1:Mail::1:0:", -- Roamer's Leggings
	[11853]="0:388:4:2:1:Leather::1:0:", -- Rambling Boots
	[11854]="0:1494:2:2:1:TwoHandSword::1:0:", -- Samophlange Screwdriver
	[11855]="0:782:4:2:1:OffHandFrill::1:0:", -- Tork Wrench
	[11856]="0:15775:2:2:1:Dagger::1:0:", -- Ceremonial Elven Blade
	[11857]="0:21377:2:2:1:Stave::1:0:", -- Sanctimonial Rod
	[11858]="0:4768:4:2:1:Cloak::1:0:", -- Battlehard Cape
	[11859]="0:7135:4:2:1:OffHandFrill::1:0:", -- Jademoon Orb
	[11860]="0:12971:2:2:1:Wand::1:0:", -- Charged Lightning Rod
	[11861]="0:5207:4:2:1:Mail::1:0:", -- Girdle of Reprisal
	[11862]="0:7042:4:2:1:Ring::1:0:", -- White Bone Band
	[11863]="0:27191:2:2:1:FistWeapon::1:0:", -- White Bone Shredder
	[11864]="0:34108:2:2:1:Polearm::1:0:", -- White Bone Spear
	[11865]="0:8708:4:2:1:Cloth::1:0:", -- Rancor Boots
	[11866]="0:9819:4:3:1:Leather::1:0:", -- Nagmara's Whipping Belt
	[11867]="0:8769:4:2:1:Mail::1:0:", -- Maddening Gauntlets
	[11868]="0:6542:4:2:1:Ring::1:0:", -- Choking Band
	[11869]="0:6542:4:2:1:Ring::1:0:", -- Sha'ni's Ring
	[11870]="0:10287:4:2:1:OffHandFrill::1:0:", -- Oblivion Orb
	[11871]="0:10666:4:2:1:Leather::1:0:", -- Snarkshaw Spaulders
	[11872]="0:14962:4:2:1:Plate::1:0:", -- Eschewal Greaves
	[11873]="0:9662:4:2:1:Cloak::1:0:", -- Ethereal Mist Cape
	[11874]="0:12124:4:2:1:Leather::1:0:", -- Clouddrift Mantle
	[11875]="0:5776:4:2:1:Cloth::1:0:", -- Breezecloud Bracers
	[11876]="0:16287:4:2:1:Leather::1:0:", -- Plainstalker Tunic
	[11882]="0:20520:4:2:1:Mail::1:0:", -- Outrider Leggings
	[11883]="0:0:15:1:1:Junk::1:0:", -- A Dingy Fanny Pack
	[11884]="0:1846:4:2:1:Cloth::1:0:", -- Moonlit Amice
	[11885]="0:711:12:1:1:::1:0:", -- Shadowforge Torch
	[11886]="0:0:12:1:1:::1:0:", -- Urgent Message
	[11887]="0:12:15:1:1:Junk::1:0:", -- Cenarion Circle Cache
	[11888]="0:4879:4:2:1:Cloth::1:0:", -- Quintis' Research Gloves
	[11889]="0:12830:4:2:1:Plate::1:0:", -- Bark Iron Pauldrons
	[11902]="0:34194:2:2:1:OneHandSword::1:0:", -- Linken's Sword of Mastery
	[11904]="0:13815:4:2:1:OffHandFrill::1:0:", -- Spirit of Aquementas
	[11905]="0:6203:4:2:1:Trinket::1:0:", -- Linken's Boomerang
	[11906]="0:32723:2:2:1:OneHandMace::1:0:", -- Beastsmasher
	[11907]="0:41050:2:2:1:TwoHandAxe::1:0:", -- Beastslayer
	[11908]="0:9887:4:2:1:Cloth::1:0:", -- Archaeologist's Quarry Boots
	[11909]="0:8267:4:2:1:Leather::1:0:", -- Excavator's Utility Belt
	[11910]="0:21604:4:2:1:Plate::1:0:", -- Bejeweled Legguards
	[11911]="0:12392:4:2:1:Cloth::1:0:", -- Treetop Leggings
	[11912]="0:0:15:1:1:Junk::1:0:", -- Package of Empty Ooze Containers
	[11913]="0:14045:4:2:1:Mail::1:0:", -- Clayridge Helm
	[11914]="0:0:0:1:20:Consumable::1:0:", -- Empty Cursed Ooze Jar
	[11915]="0:20124:4:2:1:Shield::1:0:", -- Shizzle's Drizzle Blocker
	[11916]="0:11834:4:2:1:Leather::1:0:", -- Shizzle's Muzzle
	[11917]="0:6335:4:2:1:Cloth::1:0:", -- Shizzle's Nozzle Wiper
	[11918]="0:9537:4:2:1:Mail::1:0:", -- Grotslab Gloves
	[11919]="0:16720:4:2:1:Plate::1:0:", -- Cragplate Greaves
	[11920]="0:40732:2:3:1:OneHandAxe::1:0:", -- Wraith Scythe
	[11921]="0:54167:2:3:1:TwoHandMace::1:0:", -- Impervious Giant
	[11922]="0:43491:2:3:1:Dagger::1:0:", -- Blood-etched Blade
	[11923]="0:43649:2:3:1:OneHandMace::1:0:", -- The Hammer of Grace
	[11924]="0:20475:4:3:1:Cloth::1:0:", -- Robes of the Royal Crown
	[11925]="0:16484:4:3:1:Leather::1:0:", -- Ghostshroud
	[11926]="0:24590:4:3:1:Mail::1:0:", -- Deathdealer Breastplate
	[11927]="0:28799:4:3:1:Plate::1:0:", -- Legplates of the Eternal Guardian
	[11928]="0:22045:4:3:1:OffHandFrill::1:0:", -- Thaurissan's Royal Scepter
	[11929]="0:16581:4:3:1:Cloth::1:0:", -- Haunting Specter Leggings
	[11930]="0:14588:4:3:1:Cloak::1:0:", -- The Emperor's New Cape
	[11931]="0:58103:2:3:1:TwoHandAxe::1:0:", -- Dreadforge Retaliator
	[11932]="0:58322:2:3:1:Stave::1:0:", -- Guiding Stave of Wisdom
	[11933]="0:19646:4:3:1:Amulet::1:0:", -- Imperial Jewel
	[11934]="0:19921:4:3:1:Ring::1:0:", -- Emperor's Seal
	[11935]="0:13162:4:3:1:OffHandFrill::1:0:", -- Magmus Stone
	[11936]="0:284:4:2:1:Cloth::1:0:", -- Relic Hunter Belt
	[11937]="0:187:15:1:1:Junk::1:0:", -- Fat Sack of Coins
	[11938]="0:213:15:1:1:Junk::1:0:", -- Sack of Gems
	[11939]="0:671:15:0:20:Junk::1:0:", -- Shiny Bracelet
	[11940]="0:389:15:0:20:Junk::1:0:", -- Sparkly Necklace
	[11941]="0:5896:15:0:10:Junk::1:0:", -- False Documents
	[11942]="0:5303:15:0:10:Junk::1:0:", -- Legal Documents
	[11943]="0:21485:15:0:1:Junk::1:0:", -- Deed to Thandol Span
	[11944]="0:8821:15:0:1:Junk::1:0:", -- Dark Iron Baby Booties
	[11945]="0:6592:4:3:1:Ring::1:0:", -- Dark Iron Ring
	[11946]="0:7912:4:3:1:Amulet::1:0:", -- Fire Opal Necklace
	[11947]="0:0:12:1:20:::1:0:", -- Filled Cursed Ooze Jar
	[11948]="0:0:0:1:20:Consumable::1:0:", -- Empty Tainted Ooze Jar
	[11949]="0:0:12:1:20:::1:0:", -- Filled Tainted Ooze Jar
	[11950]="0:0:0:1:20:Other::1:0:", -- Windblossom Berries
	[11951]="0:0:0:1:20:FoodDrink::1:0:", -- Whipper Root Tuber
	[11952]="0:0:0:1:20:Other::1:0:", -- Night Dragon's Breath
	[11953]="0:0:0:1:20:Consumable::1:0:", -- Empty Pure Sample Jar
	[11954]="0:0:12:1:20:::1:0:", -- Filled Pure Sample Jar
	[11955]="0:0:15:1:1:Junk::1:0:", -- Bag of Empty Ooze Containers
	[11962]="0:7939:4:3:1:Cloth::1:0:", -- Manacle Cuffs
	[11963]="0:10025:4:2:1:Leather::1:0:", -- Penance Spaulders
	[11964]="0:30156:2:2:1:OneHandMace::1:0:", -- Swiftstrike Cudgel
	[11965]="0:464:4:2:1:Ring::1:0:", -- Quartz Ring
	[11966]="0:164:15:1:1:Junk::1:0:", -- Small Sack of Coins
	[11967]="0:1087:4:2:1:Ring::1:0:", -- Zircon Band
	[11968]="0:997:4:2:1:Ring::1:0:", -- Amber Hoop
	[11969]="0:1721:4:2:1:Ring::1:0:", -- Jacinth Circle
	[11970]="0:1710:4:2:1:Ring::1:0:", -- Spinel Ring
	[11971]="0:3969:4:2:1:Ring::1:0:", -- Amethyst Band
	[11972]="0:4649:4:2:1:Ring::1:0:", -- Carnelian Loop
	[11973]="0:3971:4:2:1:Ring::1:0:", -- Hematite Link
	[11974]="0:4971:4:2:1:Ring::1:0:", -- Aquamarine Ring
	[11975]="0:4739:4:2:1:Ring::1:0:", -- Topaz Ring
	[11976]="0:7778:4:2:1:Ring::1:0:", -- Sardonyx Knuckle
	[11977]="0:7896:4:2:1:Ring::1:0:", -- Serpentine Loop
	[11978]="0:7414:4:2:1:Ring::1:0:", -- Jasper Link
	[11979]="0:7471:4:2:1:Ring::1:0:", -- Peridot Circle
	[11980]="0:10539:4:2:1:Ring::1:0:", -- Opal Ring
	[11981]="0:496:4:2:1:Ring::1:0:", -- Lead Band
	[11982]="0:1062:4:2:1:Ring::1:0:", -- Viridian Band
	[11983]="0:1130:4:2:1:Ring::1:0:", -- Chrome Ring
	[11984]="0:2189:4:2:1:Ring::1:0:", -- Cobalt Ring
	[11985]="0:2144:4:2:1:Ring::1:0:", -- Cerulean Ring
	[11986]="0:1745:4:2:1:Ring::1:0:", -- Thallium Hoop
	[11987]="0:2885:4:2:1:Ring::1:0:", -- Iridium Circle
	[11988]="0:7113:4:2:1:Ring::1:0:", -- Tellurium Band
	[11989]="0:7471:4:2:1:Ring::1:0:", -- Vanadium Loop
	[11990]="0:8306:4:2:1:Ring::1:0:", -- Selenium Loop
	[11991]="0:6317:4:2:1:Ring::1:0:", -- Quicksilver Ring
	[11992]="0:7396:4:2:1:Ring::1:0:", -- Vermilion Band
	[11993]="0:874:4:2:1:Ring::1:0:", -- Clay Ring
	[11994]="0:1312:4:2:1:Ring::1:0:", -- Coral Band
	[11995]="0:914:4:2:1:Ring::1:0:", -- Ivory Band
	[11996]="0:1713:4:2:1:Ring::1:0:", -- Basalt Ring
	[11997]="0:6469:4:2:1:Ring::1:0:", -- Greenstone Circle
	[11998]="0:2896:4:2:1:Ring::1:0:", -- Jet Loop
	[11999]="0:5538:4:2:1:Ring::1:0:", -- Lodestone Hoop
	[12000]="0:41054:2:2:1:TwoHandAxe::1:0:", -- Limb Cleaver
	[12001]="0:4971:4:2:1:Ring::1:0:", -- Onyx Ring
	[12002]="0:6322:4:2:1:Ring::1:0:", -- Marble Circle
	[12003]="0:250:0:1:20:FoodDrink::1:0:", -- Dark Dwarven Lager
	[12004]="0:9163:4:2:1:Ring::1:0:", -- Obsidian Band
	[12005]="0:8813:4:2:1:Ring::1:0:", -- Granite Ring
	[12006]="0:1064:4:2:1:Ring::1:0:", -- Meadow Ring
	[12007]="0:1064:4:2:1:Ring::1:0:", -- Prairie Ring
	[12008]="0:895:4:2:1:Ring::1:0:", -- Savannah Ring
	[12009]="0:2174:4:2:1:Ring::1:0:", -- Tundra Ring
	[12010]="0:2469:4:2:1:Ring::1:0:", -- Fen Ring
	[12011]="0:4649:4:2:1:Ring::1:0:", -- Forest Hoop
	[12012]="0:2463:4:2:1:Ring::1:0:", -- Marsh Ring
	[12013]="0:4649:4:2:1:Ring::1:0:", -- Desert Ring
	[12014]="0:6289:4:2:1:Ring::1:0:", -- Arctic Ring
	[12015]="0:8811:4:2:1:Ring::1:0:", -- Swamp Ring
	[12016]="0:7781:4:2:1:Ring::1:0:", -- Jungle Ring
	[12017]="0:8963:4:2:1:Ring::1:0:", -- Prismatic Band
	[12018]="0:13842:4:2:1:Mail::1:0:", -- Conservator Helm
	[12019]="0:4220:4:2:1:Amulet::1:0:", -- Cerulean Talisman
	[12020]="0:3969:4:2:1:Amulet::1:0:", -- Thallium Choker
	[12021]="0:16291:4:2:1:Plate::1:0:", -- Shieldplate Sabatons
	[12022]="0:4718:4:2:1:Amulet::1:0:", -- Iridium Chain
	[12023]="0:4971:4:2:1:Amulet::1:0:", -- Tellurium Necklace
	[12024]="0:5396:4:2:1:Amulet::1:0:", -- Vanadium Talisman
	[12025]="0:5282:4:2:1:Amulet::1:0:", -- Selenium Chain
	[12026]="0:7757:4:2:1:Amulet::1:0:", -- Quicksilver Pendant
	[12027]="0:6257:4:2:1:Amulet::1:0:", -- Vermilion Necklace
	[12028]="0:4007:4:2:1:Amulet::1:0:", -- Basalt Necklace
	[12029]="0:5395:4:2:1:Amulet::1:0:", -- Greenstone Talisman
	[12030]="0:7143:4:2:1:Amulet::1:0:", -- Jet Chain
	[12031]="0:7894:4:2:1:Amulet::1:0:", -- Lodestone Necklace
	[12032]="0:5396:4:2:1:Amulet::1:0:", -- Onyx Choker
	[12033]="0:0:15:1:1:Junk::1:0:", -- Thaurissan Family Jewels
	[12034]="0:5012:4:2:1:Amulet::1:0:", -- Marble Necklace
	[12035]="0:5513:4:2:1:Amulet::1:0:", -- Obsidian Pendant
	[12036]="0:5982:4:2:1:Amulet::1:0:", -- Granite Necklace
	[12037]="350:87:7:1:10:Meat:185:1:0:24291", -- Mystery Meat
	[12038]="0:9092:4:2:1:Ring::1:0:", -- Lagrave's Seal
	[12039]="0:4224:4:2:1:Amulet::1:0:", -- Tundra Necklace
	[12040]="0:4164:4:2:1:Amulet::1:0:", -- Forest Pendant
	[12041]="0:14446:4:2:1:Leather::1:0:", -- Windshear Leggings
	[12042]="0:4749:4:2:1:Amulet::1:0:", -- Marsh Chain
	[12043]="0:5396:4:2:1:Amulet::1:0:", -- Desert Choker
	[12044]="0:5145:4:2:1:Amulet::1:0:", -- Arctic Pendant
	[12045]="0:7767:4:2:1:Amulet::1:0:", -- Swamp Pendant
	[12046]="0:5757:4:2:1:Amulet::1:0:", -- Jungle Necklace
	[12047]="0:4996:4:2:1:Amulet::1:0:", -- Spectral Necklace
	[12048]="0:6507:4:2:1:Amulet::1:0:", -- Prismatic Pendant
	[12049]="0:16850:4:2:1:Mail::1:0:", -- Splintsteel Armor
	[12050]="0:8963:4:2:1:Cloth::1:0:", -- Hazecover Boots
	[12051]="0:8996:4:2:1:Mail::1:0:", -- Brazen Gauntlets
	[12052]="0:837:4:2:1:Ring::1:0:", -- Ring of the Moon
	[12053]="0:837:4:2:1:Ring::1:0:", -- Volcanic Rock Ring
	[12054]="0:837:4:2:1:Ring::1:0:", -- Demon Band
	[12055]="0:8375:4:2:1:Ring::1:0:", -- Stardust Band
	[12056]="0:8375:4:2:1:Ring::1:0:", -- Ring of the Heavens
	[12057]="0:8375:4:2:1:Ring::1:0:", -- Dragonscale Band
	[12058]="0:8376:4:2:1:Ring::1:0:", -- Demonic Bone Ring
	[12059]="0:12377:4:3:1:Amulet::1:0:", -- Conqueror's Medallion
	[12060]="0:0:12:1:1:::1:0:", -- Shindrell's Note
	[12061]="0:40212:2:2:1:OneHandSword::1:0:", -- Blade of Reckoning
	[12062]="0:40365:2:2:1:Dagger::1:0:", -- Skilled Fighting Blade
	[12064]="0:1:4:1:1:Cloth::1:0:", -- Gamemaster Hood
	[12065]="0:7953:4:2:1:Trinket::1:0:", -- Ward of the Elements
	[12066]="0:11149:4:2:1:Cloak::1:0:", -- Shaleskin Cape
	[12082]="0:13726:4:2:1:Leather::1:0:", -- Wyrmhide Spaulders
	[12083]="0:7348:4:2:1:Cloth::1:0:", -- Valconian Sash
	[12102]="0:9042:4:2:1:Ring::1:0:", -- Ring of the Aristocrat
	[12103]="0:12157:4:3:1:Amulet::1:0:", -- Star of Mystaria
	[12108]="0:23055:4:2:1:Mail::1:0:", -- Basaltscale Armor
	[12109]="0:11569:4:2:1:Cloth::1:0:", -- Azure Moon Amice
	[12110]="0:11610:4:2:1:Cloak::1:0:", -- Raincaster Drape
	[12111]="0:13672:4:2:1:Plate::1:0:", -- Lavaplate Gauntlets
	[12112]="0:10407:4:2:1:Mail::1:0:", -- Crypt Demon Bracers
	[12113]="0:10444:4:2:1:Cloak::1:0:", -- Sunborne Cape
	[12114]="0:8734:4:2:1:Leather::1:0:", -- Nightfall Gloves
	[12115]="0:12341:4:2:1:Plate::1:0:", -- Stalwart Clutch
	[12122]="0:0:15:2:1:Junk::1:0:", -- Kum'isha's Junk
	[12144]="0:0:15:1:1:Junk::1:0:", -- Eggscilloscope
	[12162]="3000:750:9:1:1:Blacksmithing::1:1:2843,3356,5512", -- Plans: Hardened Iron Shortsword
	[12163]="4400:1100:9:1:1:Blacksmithing::1:1:2482", -- Plans: Moonsteel Broadsword
	[12164]="4400:1100:9:1:1:Blacksmithing::1:1:1146,2483", -- Plans: Massive Iron Axe
	[12184]="0:87:7:1:10:Meat:185:1:0:", -- Raptor Flesh
	[12185]="0:12895:4:2:1:Cloth::1:0:", -- Bloodsail Admiral's Hat
	[12190]="0:250:0:1:5:Potion::1:0:", -- Dreamless Sleep Potion
	[12191]="0:0:12:1:1:::1:0:", -- Silver Dawning's Lockbox
	[12192]="0:0:12:1:1:::1:0:", -- Mist Veil's Lockbox
	[12202]="0:87:7:1:10:Meat:185:1:0:", -- Tiger Meat
	[12203]="0:87:7:1:10:Meat:185:1:0:", -- Red Wolf Meat
	[12204]="0:112:7:1:10:Meat:185:1:0:", -- Heavy Kodo Meat
	[12205]="0:112:7:1:10:Meat:185:1:0:", -- White Spider Meat
	[12206]="0:112:7:1:10:Meat:185:1:0:", -- Tender Crab Meat
	[12207]="0:150:7:1:10:Meat:185:1:0:", -- Giant Egg
	[12208]="0:150:7:1:10:Meat:185:1:0:", -- Tender Wolf Meat
	[12209]="0:95:0:1:20:FoodDrink::1:0:", -- Lean Wolf Steak
	[12210]="0:300:0:1:20:FoodDrink::1:0:", -- Roast Raptor
	[12212]="0:300:0:1:20:FoodDrink::1:0:", -- Jungle Stew
	[12213]="0:300:0:1:20:FoodDrink::1:0:", -- Carrion Surprise
	[12214]="0:300:0:1:20:FoodDrink::1:0:", -- Mystery Stew
	[12215]="0:300:0:1:20:FoodDrink::1:0:", -- Heavy Kodo Stew
	[12216]="0:300:0:1:20:FoodDrink::1:0:", -- Spiced Chili Crab
	[12217]="0:300:0:1:20:FoodDrink::1:0:", -- Dragonbreath Chili
	[12218]="0:300:0:1:20:FoodDrink::1:0:", -- Monster Omelet
	[12219]="0:0:12:1:1:::1:0:", -- Unadorned Seal of Ascension
	[12220]="0:0:12:1:20:::1:0:", -- Intact Elemental Bracer
	[12223]="0:4:7:1:10:Meat:185:1:0:", -- Meaty Bat Wing
	[12224]="0:10:0:1:20:FoodDrink::1:0:", -- Crispy Bat Wing
	[12225]="0:4:2:1:1:FishingPole::1:0:", -- Blump Family Fishing Pole
	[12226]="25:6:9:1:1:Cooking::1:0:2118", -- Recipe: Crispy Bat Wing
	[12227]="1600:400:9:1:1:Cooking::1:1:12246", -- Recipe: Lean Wolf Steak
	[12228]="5000:1250:9:1:1:Cooking::1:0:734,1148,2810,2821,4879,4897,12245", -- Recipe: Roast Raptor
	[12229]="5000:1250:9:1:1:Cooking::1:0:7947,8145,12246", -- Recipe: Hot Wolf Ribs
	[12230]="0:0:12:1:20:::1:0:", -- Felwood Slime Sample
	[12231]="3000:750:9:1:1:Cooking::1:0:734,1148,12245", -- Recipe: Jungle Stew
	[12232]="5000:1250:9:1:1:Cooking::1:0:989,4879,9636,12245", -- Recipe: Carrion Surprise
	[12233]="3000:750:9:1:1:Cooking::1:0:4897,8150,12246", -- Recipe: Mystery Stew
	[12234]="0:0:12:1:20:::1:0:", -- Corrupted Felwood Sample
	[12235]="0:0:12:1:20:::1:0:", -- Un'Goro Slime Sample
	[12236]="0:0:12:1:20:::1:0:", -- Pure Un'Goro Sample
	[12237]="0:0:12:1:20:::1:0:", -- Fine Crab Chunks
	[12238]="0:2:0:1:20:FoodDrink::1:0:", -- Darkshore Grouper
	[12239]="7000:1750:9:1:1:Cooking::1:0:4879,4897,12246", -- Recipe: Dragonbreath Chili
	[12240]="7000:1750:9:1:1:Cooking::1:0:8150,9636,12245", -- Recipe: Heavy Kodo Stew
	[12241]="0:0:12:1:20:::1:0:", -- Collected Dragon Egg
	[12242]="0:0:12:1:1:::1:0:", -- Sea Creature Bones
	[12243]="0:45980:2:3:1:Polearm::1:0:", -- Smoldering Claw
	[12247]="28373:5674:2:2:1:Dagger::1:1:3539,4235", -- Broad Bladed Knife
	[12248]="32030:6406:2:2:1:Dagger::1:1:1146,2843", -- Daring Dirk
	[12249]="30195:6039:2:2:1:TwoHandAxe::1:1:225,3539,4232,12045", -- Merciless Axe
	[12250]="40342:8068:2:2:1:TwoHandAxe::1:1:1146,2483,12045", -- Midnight Axe
	[12251]="53897:10779:2:2:1:Stave::1:1:2482,4884,19043", -- Big Stick
	[12252]="63095:12619:2:2:1:Stave::1:1:2482", -- Staff of Protection
	[12253]="17728:3545:4:2:1:Cloak::1:1:8159", -- Brilliant Red Cloak
	[12254]="22416:4483:4:2:1:Cloak::1:1:8159", -- Well Oiled Cloak
	[12255]="34988:6997:4:2:1:Cloth::1:1:984,3315", -- Pale Leggings
	[12256]="43828:8765:4:2:1:Cloth::1:1:984,3316,4175", -- Cindercloth Leggings
	[12257]="19430:3886:4:2:1:Mail::1:1:2845", -- Heavy Notched Belt
	[12259]="0:8072:2:2:1:Dagger::1:0:", -- Glinting Steel Dagger
	[12260]="0:10395:2:2:1:Dagger::1:0:", -- Searing Golden Blade
	[12261]="0:950:9:2:1:Blacksmithing::1:0:", -- Plans: Searing Golden Blade
	[12262]="0:0:12:1:1:::1:0:", -- Empty Worg Pup Cage
	[12263]="0:0:12:1:1:::1:0:", -- Caged Worg Pup
	[12264]="0:0:15:1:1:Companion::1:0:", -- Worg Carrier
	[12282]="0:8:2:1:1:TwoHandAxe::1:0:", -- Worn Battleaxe
	[12283]="0:0:12:1:20:::1:0:", -- Broodling Essence
	[12284]="0:0:12:1:1:::1:0:", -- Draco-Incarcinatrix 900
	[12286]="0:0:12:1:1:::1:0:", -- Eggscilloscope Prototype
	[12287]="0:0:12:1:1:::1:0:", -- Collectronic Module
	[12288]="0:0:12:1:1:::1:0:", -- Encased Corrupt Ooze
	[12289]="0:0:12:1:1:::1:0:", -- Sea Turtle Remains
	[12291]="0:0:12:1:1:::1:0:", -- Merged Ooze Sample
	[12292]="0:0:12:1:1:::1:0:", -- Strangely Marked Box
	[12293]="0:0:12:1:1:::1:0:", -- Fine Gold Thread
	[12295]="0:282:4:2:1:Cloth::1:0:", -- Leggings of the People's Militia
	[12296]="0:722:2:2:1:Wand::1:0:", -- Spark of the People's Militia
	[12299]="0:16:4:1:1:Cloth::1:0:", -- Netted Gloves
	[12300]="0:0:12:1:1:::1:0:", -- Orb of Draconic Energy
	[12301]="0:0:13:1:1:::1:0:", -- Bamboo Cage Key
	[12302]="0:0:15:4:1:Mount::1:0:", -- Reins of the Ancient Frostsaber
	[12303]="0:0:15:4:1:Mount::1:0:", -- Reins of the Nightsaber
	[12323]="0:0:12:1:1:::1:0:", -- Unforged Seal of Ascension
	[12324]="0:0:12:1:1:::1:0:", -- Forged Seal of Ascension
	[12330]="0:0:15:4:1:Mount::1:0:", -- Horn of the Red Wolf
	[12334]="0:0:12:1:20:::1:0:", -- Frostmaul Shards
	[12335]="0:0:12:2:1:::1:0:", -- Gemstone of Smolderthorn
	[12336]="0:0:12:2:1:::1:0:", -- Gemstone of Spirestone
	[12337]="0:0:12:2:1:::1:0:", -- Gemstone of Bloodaxe
	[12339]="0:0:12:1:1:::1:0:", -- Vaelan's Gift
	[12341]="0:0:12:1:1:::1:0:", -- Blackwood Fruit Sample
	[12342]="0:0:12:1:1:::1:0:", -- Blackwood Grain Sample
	[12343]="0:0:12:1:1:::1:0:", -- Blackwood Nut Sample
	[12344]="0:0:4:3:1:Ring::1:0:", -- Seal of Ascension
	[12345]="0:0:12:1:1:::1:0:", -- Bijou's Belongings
	[12346]="0:0:12:1:1:::1:0:", -- Empty Cleansing Bowl
	[12347]="0:0:12:1:1:::1:0:", -- Filled Cleansing Bowl
	[12349]="0:0:12:1:1:::1:0:", -- Cliffspring River Sample
	[12350]="0:0:12:1:1:::1:0:", -- Empty Sampling Tube
	[12351]="0:0:15:4:1:Mount::1:0:", -- Horn of the Arctic Wolf
	[12352]="0:0:12:1:1:::1:0:", -- Doomrigger's Clasp
	[12353]="0:0:15:4:1:Mount::1:0:", -- White Stallion Bridle
	[12354]="0:0:15:4:1:Mount::1:0:", -- Palomino Bridle
	[12355]="0:0:12:1:1:::1:0:", -- Talisman of Corruption
	[12356]="0:0:12:1:20:::1:0:", -- Highperch Wyvern Egg
	[12358]="0:0:12:1:1:::1:0:", -- Darkstone Tablet
	[12359]="0:600:7:1:20:MetalStone:171,164,333,202,755:1:0:", -- Thorium Bar
	[12360]="0:5000:7:2:20:MetalStone:164,202,755,186,197:1:0:", -- Arcanite Bar
	[12361]="0:7000:3:2:20:GemSimple:164,202,755:1:0:", -- Blue Sapphire
	[12363]="0:2000:3:2:20:GemSimple:171,755:1:0:", -- Arcane Crystal
	[12364]="0:10000:3:2:20:GemSimple:164,202,755,197:1:0:", -- Huge Emerald
	[12365]="0:250:7:1:20:MetalStone:164,202,755:1:0:", -- Dense Stone
	[12366]="0:0:12:1:20:::1:0:", -- Thick Yeti Fur
	[12367]="0:0:12:1:20:::1:0:", -- Pristine Yeti Horn
	[12368]="0:0:12:1:1:::1:0:", -- Dawn's Gambit
	[12382]="0:0:13:2:1:::1:0:", -- Key to the City
	[12383]="0:0:12:1:20:::1:0:", -- Moontouched Feather
	[12384]="0:0:12:1:1:::1:0:", -- Cache of Mau'ari
	[12402]="0:0:12:1:1:::1:0:", -- Ancient Egg
	[12404]="0:75:0:1:20:EnhTemp::1:0:", -- Dense Sharpening Stone
	[12405]="0:16170:4:2:1:Plate::1:0:", -- Thorium Armor
	[12406]="0:8160:4:2:1:Plate::1:0:", -- Thorium Belt
	[12408]="0:8797:4:2:1:Plate::1:0:", -- Thorium Bracers
	[12409]="0:18054:4:2:1:Plate::1:0:", -- Thorium Boots
	[12410]="0:18117:4:2:1:Plate::1:0:", -- Thorium Helm
	[12411]="0:0:12:1:1:::1:0:", -- Third Mosh'aru Tablet
	[12412]="0:0:12:1:1:::1:0:", -- Fourth Mosh'aru Tablet
	[12414]="0:30408:4:2:1:Plate::1:0:", -- Thorium Leggings
	[12415]="0:17003:4:2:1:Mail::1:0:", -- Radiant Breastplate
	[12416]="0:7596:4:2:1:Mail::1:0:", -- Radiant Belt
	[12417]="0:17034:4:2:1:Mail::1:0:", -- Radiant Circlet
	[12418]="0:10242:4:2:1:Mail::1:0:", -- Radiant Gloves
	[12419]="0:16421:4:2:1:Mail::1:0:", -- Radiant Boots
	[12420]="0:24462:4:2:1:Mail::1:0:", -- Radiant Leggings
	[12422]="0:28357:4:2:1:Plate::1:0:", -- Imperial Plate Chest
	[12424]="0:9738:4:2:1:Plate::1:0:", -- Imperial Plate Belt
	[12425]="0:10638:4:2:1:Plate::1:0:", -- Imperial Plate Bracers
	[12426]="0:21069:4:2:1:Plate::1:0:", -- Imperial Plate Boots
	[12427]="0:21145:4:2:1:Plate::1:0:", -- Imperial Plate Helm
	[12428]="0:15103:4:2:1:Plate::1:0:", -- Imperial Plate Shoulders
	[12429]="0:30289:4:2:1:Plate::1:0:", -- Imperial Plate Leggings
	[12430]="0:0:12:1:20:::1:0:", -- Frostsaber E'ko
	[12431]="0:0:12:1:20:::1:0:", -- Winterfall E'ko
	[12432]="0:0:12:1:20:::1:0:", -- Shardtooth E'ko
	[12433]="0:0:12:1:20:::1:0:", -- Wildkin E'ko
	[12434]="0:0:12:1:20:::1:0:", -- Chillwind E'ko
	[12435]="0:0:12:1:20:::1:0:", -- Ice Thistle E'ko
	[12436]="0:0:12:1:20:::1:0:", -- Frostmaul E'ko
	[12437]="0:0:12:1:1:::1:0:", -- Ridgewell's Crate
	[12438]="0:0:12:1:1:::1:0:", -- Tinkee's Letter
	[12444]="0:0:12:1:20:::1:0:", -- Uncracked Chillwind Horn
	[12445]="0:0:12:1:1:::1:0:", -- Felnok's Package
	[12446]="0:19:2:1:1:Gun::1:0:", -- Anvilmar Musket
	[12447]="0:19:2:1:1:Bow::1:0:", -- Thistlewood Bow
	[12448]="0:19:2:1:1:Gun::1:0:", -- Light Hunting Rifle
	[12449]="0:19:2:1:1:Bow::1:0:", -- Primitive Bow
	[12450]="0:1500:12:1:20:::1:0:", -- Juju Flurry
	[12451]="0:1500:12:1:20:::1:0:", -- Juju Power
	[12455]="0:1500:12:1:20:::1:0:", -- Juju Ember
	[12457]="0:1500:12:1:20:::1:0:", -- Juju Chill
	[12458]="0:1500:12:1:20:::1:0:", -- Juju Guile
	[12459]="0:1500:12:1:20:::1:0:", -- Juju Escape
	[12460]="0:1500:12:1:20:::1:0:", -- Juju Might
	[12462]="0:20274:4:4:1:Cloth::1:0:", -- Embrace of the Wind Serpent
	[12463]="0:42446:2:3:1:TwoHandSword::1:0:", -- Drakefang Butcher
	[12464]="0:8520:4:3:1:Leather::1:0:", -- Bloodfire Talons
	[12465]="0:10261:4:3:1:Cloak::1:0:", -- Nightfall Drape
	[12466]="0:6865:4:3:1:Cloth::1:0:", -- Dawnspire Cord
	[12467]="0:0:12:1:1:::1:0:", -- Alien Egg
	[12470]="0:8784:4:3:1:Leather::1:0:", -- Sandstalker Ankleguards
	[12471]="0:8409:4:3:1:OffHandFrill::1:0:", -- Desertwalker Cane
	[12472]="0:0:12:1:1:::1:0:", -- Krakle's Thermometer
	[12522]="0:182:4:2:1:Leather::1:0:", -- Bingles' Flying Gloves
	[12524]="0:0:12:1:1:::1:0:", -- Blue-feathered Amulet
	[12525]="0:0:12:1:1:::1:0:", -- Jaron's Supplies
	[12527]="0:35332:2:3:1:OneHandAxe::1:0:", -- Ribsplitter
	[12528]="0:37833:2:3:1:TwoHandMace::1:0:", -- The Judge's Gavel
	[12529]="0:0:15:1:1:Companion::1:0:", -- Smolderweb Carrier
	[12530]="0:0:12:1:20:::1:0:", -- Spire Spider Egg
	[12531]="0:28883:2:3:1:Dagger::1:0:", -- Searing Needle
	[12532]="0:48501:2:3:1:Stave::1:0:", -- Spire of the Stoneshaper
	[12533]="0:0:15:1:1:Junk::1:0:", -- Roughshod Pike
	[12534]="0:0:12:1:1:::1:0:", -- Omokk's Head
	[12535]="0:34926:2:3:1:OneHandSword::1:0:", -- Doomforged Straightedge
	[12542]="0:12356:4:3:1:Cloth::1:0:", -- Funeral Pyre Vestment
	[12543]="0:7156:4:3:1:Ring::1:0:", -- Songstone of Ironforge
	[12544]="0:7407:4:3:1:Ring::1:0:", -- Thrall's Resolve
	[12545]="0:7082:4:3:1:Ring::1:0:", -- Eye of Orgrimmar
	[12546]="0:7463:4:3:1:Cloth::1:0:", -- Aristocratic Cuffs
	[12547]="0:10519:4:3:1:Leather::1:0:", -- Mar Alom's Grip
	[12548]="0:7102:4:3:1:Ring::1:0:", -- Magni's Will
	[12549]="0:13670:4:3:1:Mail::1:0:", -- Braincage
	[12550]="0:11378:4:3:1:Plate::1:0:", -- Runed Golem Shackles
	[12551]="0:11594:4:3:1:Cloak::1:0:", -- Stoneshield Cloak
	[12552]="0:10980:4:3:1:Cloak::1:0:", -- Blisterbane Wrap
	[12553]="0:17699:4:3:1:Leather::1:0:", -- Swiftwalker Boots
	[12554]="0:9474:4:3:1:Cloth::1:0:", -- Hands of the Exalted Herald
	[12555]="0:19923:4:3:1:Plate::1:0:", -- Battlechaser's Greaves
	[12556]="0:14317:4:3:1:Cloth::1:0:", -- High Priestess Boots
	[12557]="0:25096:4:3:1:Plate::1:0:", -- Ebonsteel Spaulders
	[12558]="0:0:12:1:1:::1:0:", -- Blue-feathered Necklace
	[12562]="0:0:12:1:1:::1:0:", -- Important Blackrock Documents
	[12563]="0:0:12:1:1:::1:0:", -- Warlord Goretooth's Command
	[12564]="0:0:12:1:1:::1:0:", -- Assassination Note
	[12565]="0:0:15:1:1:Junk::1:0:", -- Winna's Kitten Carrier
	[12566]="0:0:12:1:1:::1:0:", -- Hardened Flasket
	[12567]="0:0:12:1:1:::1:0:", -- Filled Flasket
	[12582]="0:51199:2:3:1:Dagger::1:0:", -- Keris of Zul'Serak
	[12583]="0:66915:2:3:1:Polearm::1:0:", -- Blackhand Doomsaw
	[12584]="0:0:2:4:1:OneHandSword::1:0:12784", -- Grand Marshal's Longsword
	[12586]="0:0:0:1:50:Other::1:0:", -- Immature Venom Sac
	[12587]="0:18929:4:3:1:Leather::1:0:", -- Eye of Rend
	[12588]="0:22903:4:3:1:Mail::1:0:", -- Bonespike Shoulder
	[12589]="0:9899:4:3:1:Cloth::1:0:", -- Dustfeather Sash
	[12590]="0:68066:2:4:1:Dagger::1:0:", -- Felstriker
	[12592]="0:85722:2:4:1:TwoHandSword::1:0:", -- Blackblade of Shahram
	[12602]="0:31693:4:3:1:Shield::1:0:", -- Draconian Deflector
	[12603]="0:24189:4:3:1:Leather::1:0:", -- Nightbrace Tunic
	[12604]="0:14368:4:3:1:Cloth::1:0:", -- Starfire Tiara
	[12605]="0:29106:2:3:1:Wand::1:0:", -- Serpentine Skuller
	[12606]="0:12233:4:3:1:Leather::1:0:", -- Crystallized Girdle
	[12607]="0:8048:12:3:20::165:1:0:", -- Brilliant Chromatic Scale
	[12608]="0:13232:4:3:1:Cloak::1:0:", -- Butcher's Apron
	[12609]="0:19795:4:3:1:Cloth::1:0:", -- Polychromatic Visionwrap
	[12610]="0:21392:4:2:1:Plate::1:0:", -- Runic Plate Shoulders
	[12611]="0:21473:4:2:1:Plate::1:0:", -- Runic Plate Boots
	[12612]="0:21854:4:2:1:Plate::1:0:", -- Runic Plate Helm
	[12613]="0:29704:4:2:1:Plate::1:0:", -- Runic Breastplate
	[12614]="0:29815:4:2:1:Plate::1:0:", -- Runic Plate Leggings
	[12618]="0:37759:4:3:1:Plate::1:0:", -- Enchanted Thorium Breastplate
	[12619]="0:37893:4:3:1:Plate::1:0:", -- Enchanted Thorium Leggings
	[12620]="0:28084:4:3:1:Plate::1:0:", -- Enchanted Thorium Helm
	[12621]="0:45085:2:3:1:OneHandAxe::1:0:", -- Demonfork
	[12622]="0:0:12:1:10:::1:0:", -- Shardtooth Meat
	[12623]="0:0:12:1:10:::1:0:", -- Chillwind Meat
	[12624]="0:20642:4:3:1:Mail::1:0:", -- Wildthorn Mail
	[12625]="0:22847:4:3:1:Plate::1:0:", -- Dawnbringer Shoulders
	[12626]="0:9191:4:3:1:Cloth::1:0:", -- Funeral Cuffs
	[12627]="0:0:12:1:1:::1:0:", -- Temporal Displacer
	[12628]="0:29121:4:3:1:Plate::1:0:", -- Demon Forged Breastplate
	[12630]="0:0:12:1:1:::1:0:", -- Head of Rend Blackhand
	[12631]="0:15698:4:3:1:Plate::1:0:", -- Fiery Plate Gauntlets
	[12632]="0:14099:4:3:1:Mail::1:0:", -- Storm Gauntlets
	[12633]="0:25955:4:3:1:Plate::1:0:", -- Whitesoul Helm
	[12634]="0:15310:4:3:1:Mail::1:0:", -- Chiselbrand Girdle
	[12635]="0:0:12:1:1:::1:0:", -- Simple Parchment
	[12636]="0:23452:4:3:1:Mail::1:0:", -- Helm of the Great Chief
	[12637]="0:18157:4:3:1:Plate::1:0:", -- Backusarian Gauntlets
	[12638]="0:0:12:1:20:::1:0:", -- Andorhal Watch
	[12639]="0:25061:4:4:1:Plate::1:0:", -- Stronghold Gauntlets
	[12640]="0:36930:4:4:1:Plate::1:0:", -- Lionheart Helm
	[12641]="0:39455:4:4:1:Mail::1:0:", -- Invulnerable Mail
	[12642]="0:0:12:1:1:::1:0:", -- Cleansed Infernal Orb
	[12643]="0:75:0:1:20:EnhTemp::1:0:", -- Dense Weightstone
	[12644]="0:200:7:1:20:MetalStone:164:1:0:", -- Dense Grinding Stone
	[12645]="0:500:0:2:5:EnhPerm::1:0:", -- Thorium Shield Spike
	[12646]="0:0:12:1:1:::1:0:", -- Infus Emerald
	[12647]="0:0:12:1:1:::1:0:", -- Felhas Ruby
	[12648]="0:0:12:1:1:::1:0:", -- Imprisoned Felhound Spirit
	[12649]="0:0:12:1:1:::1:0:", -- Imprisoned Infernal Spirit
	[12650]="0:0:0:1:1:Consumable::1:0:", -- Attuned Dampener
	[12651]="0:36055:2:3:1:Crossbow::1:0:", -- Blackcrow
	[12652]="0:0:12:1:1:::1:0:", -- Bijou's Reconnaissance Report
	[12653]="0:36318:2:3:1:Bow::1:0:", -- Riphook
	[12654]="0:62:6:3:200:Arrow::1:0:", -- Doomshot
	[12655]="0:500:7:1:20:MetalStone:164,202:1:0:", -- Enchanted Thorium Bar
	[12662]="0:600:7:2:20:Other:164,755,197:1:0:", -- Demonic Rune
	[12663]="0:0:12:1:1:::1:0:", -- Glyphed Oaken Branch
	[12682]="0:3000:9:2:1:Blacksmithing::1:0:", -- Plans: Thorium Armor
	[12683]="0:3000:9:2:1:Blacksmithing::1:0:", -- Plans: Thorium Belt
	[12684]="0:3000:9:2:1:Blacksmithing::1:0:", -- Plans: Thorium Bracers
	[12685]="0:3000:9:2:1:Blacksmithing::1:0:", -- Plans: Radiant Belt
	[12687]="0:3000:9:2:1:Blacksmithing::1:0:", -- Plans: Imperial Plate Shoulders
	[12688]="0:3000:9:2:1:Blacksmithing::1:0:", -- Plans: Imperial Plate Belt
	[12689]="0:3500:9:2:1:Blacksmithing::1:0:", -- Plans: Radiant Breastplate
	[12690]="0:3000:9:2:1:Blacksmithing::1:0:", -- Plans: Imperial Plate Bracers
	[12691]="0:4000:9:2:1:Blacksmithing::1:0:", -- Plans: Wildthorn Mail
	[12692]="0:4000:9:2:1:Blacksmithing::1:0:", -- Plans: Thorium Shield Spike
	[12693]="0:5000:9:2:1:Blacksmithing::1:0:", -- Plans: Thorium Boots
	[12694]="0:5000:9:2:1:Blacksmithing::1:0:", -- Plans: Thorium Helm
	[12695]="0:5000:9:2:1:Blacksmithing::1:0:", -- Plans: Radiant Gloves
	[12696]="0:5000:9:3:1:Blacksmithing::1:0:", -- Plans: Demon Forged Breastplate
	[12697]="0:5500:9:2:1:Blacksmithing::1:0:", -- Plans: Radiant Boots
	[12698]="0:5500:9:3:1:Blacksmithing::1:0:", -- Plans: Dawnbringer Shoulders
	[12699]="0:5000:9:3:1:Blacksmithing::1:0:", -- Plans: Fiery Plate Gauntlets
	[12700]="0:6250:9:2:1:Blacksmithing::1:0:", -- Plans: Imperial Plate Boots
	[12701]="0:6250:9:2:1:Blacksmithing::1:0:", -- Plans: Imperial Plate Helm
	[12702]="0:6250:9:2:1:Blacksmithing::1:0:", -- Plans: Radiant Circlet
	[12703]="40000:10000:9:3:1:Blacksmithing::1:0:11278", -- Plans: Storm Gauntlets
	[12704]="0:7500:9:2:1:Blacksmithing::1:0:", -- Plans: Thorium Leggings
	[12705]="0:7500:9:2:1:Blacksmithing::1:0:", -- Plans: Imperial Plate Chest
	[12706]="0:7500:9:2:1:Blacksmithing::1:0:", -- Plans: Runic Plate Shoulders
	[12707]="0:7500:9:2:1:Blacksmithing::1:0:", -- Plans: Runic Plate Boots
	[12708]="0:0:12:1:1:::1:0:", -- Crossroads' Supply Crates
	[12709]="0:52195:2:3:1:Dagger::1:0:", -- Finkle's Skinner
	[12710]="0:0:12:1:1:::1:0:", -- Glowing Hunk of the Beast's Flesh
	[12711]="0:10000:9:3:1:Blacksmithing::1:0:", -- Plans: Whitesoul Helm
	[12712]="0:0:12:1:1:::1:0:", -- Warosh's Mojo
	[12713]="0:10000:9:2:1:Blacksmithing::1:0:", -- Plans: Radiant Leggings
	[12714]="0:10000:9:2:1:Blacksmithing::1:0:", -- Plans: Runic Plate Helm
	[12715]="0:10000:9:2:1:Blacksmithing::1:0:", -- Plans: Imperial Plate Leggings
	[12716]="0:15000:9:3:1:Blacksmithing::1:0:", -- Plans: Helm of the Great Chief
	[12717]="0:15000:9:4:1:Blacksmithing::1:0:", -- Plans: Lionheart Helm
	[12718]="0:15000:9:2:1:Blacksmithing::1:0:", -- Plans: Runic Breastplate
	[12719]="0:15000:9:2:1:Blacksmithing::1:0:", -- Plans: Runic Plate Leggings
	[12720]="0:20000:9:4:1:Blacksmithing::1:0:", -- Plans: Stronghold Gauntlets
	[12721]="0:0:12:1:1:::1:0:", -- Good Luck Half-Charm
	[12722]="0:0:12:1:1:::1:0:", -- Good Luck Other-Half-Charm
	[12723]="0:0:12:1:1:::1:0:", -- Good Luck Charm
	[12724]="0:0:12:1:1:::1:0:", -- Janice's Parcel
	[12725]="0:15000:9:3:1:Blacksmithing::1:0:", -- Plans: Enchanted Thorium Helm
	[12726]="0:15000:9:3:1:Blacksmithing::1:0:", -- Plans: Enchanted Thorium Leggings
	[12727]="0:15000:9:3:1:Blacksmithing::1:0:", -- Plans: Enchanted Thorium Breastplate
	[12728]="0:20000:9:4:1:Blacksmithing::1:0:", -- Plans: Invulnerable Mail
	[12730]="0:0:12:1:1:::1:0:", -- Warosh's Scroll
	[12731]="0:0:12:4:1:::1:0:", -- Pristine Hide of the Beast
	[12732]="0:0:12:1:20:::1:0:", -- Incendia Agave
	[12733]="0:0:12:1:1:::1:0:", -- Sacred Frostsaber Meat
	[12734]="0:0:12:1:10:::1:0:", -- Enchanted Scarlet Thread
	[12735]="0:0:12:2:20:::1:0:", -- Frayed Abomination Stitching
	[12736]="0:0:12:1:10:::1:0:", -- Frostwhisper's Embalming Fluid
	[12737]="0:0:12:1:20:::1:0:", -- Gloom Weed
	[12738]="0:0:13:1:1:::1:0:", -- Dalson Outhouse Key
	[12739]="0:0:13:1:1:::1:0:", -- Dalson Cabinet Key
	[12740]="0:0:12:1:1:::1:0:", -- Fifth Mosh'aru Tablet
	[12741]="0:0:12:1:1:::1:0:", -- Sixth Mosh'aru Tablet
	[12752]="0:21359:4:4:1:Cloth::1:0:", -- Cap of the Scarlet Savant
	[12753]="0:0:12:2:10::164,165:1:0:", -- Skin of Shadow
	[12756]="0:32687:4:4:1:Leather::1:0:", -- Leggings of Arcana
	[12757]="0:32813:4:4:1:Leather::1:0:", -- Breastplate of Bloodthirst
	[12764]="0:33621:2:2:1:TwoHandSword::1:0:", -- Thorium Greatsword
	[12765]="0:0:12:1:1:::1:0:", -- Secret Note #1
	[12766]="0:0:12:1:1:::1:0:", -- Secret Note #2
	[12768]="0:0:12:1:1:::1:0:", -- Secret Note #3
	[12769]="0:46154:2:3:1:TwoHandAxe::1:0:", -- Bleakwood Hew
	[12770]="0:0:12:1:1:::1:0:", -- Bijou's Information
	[12771]="0:0:12:1:1:::1:0:", -- Empty Firewater Flask
	[12772]="0:38871:2:2:1:TwoHandMace::1:0:", -- Inlaid Thorium Hammer
	[12773]="0:33080:2:2:1:OneHandAxe::1:0:", -- Ornate Thorium Handaxe
	[12774]="0:36044:2:3:1:OneHandAxe::1:0:", -- Dawn's Edge
	[12775]="0:39949:2:2:1:TwoHandAxe::1:0:", -- Huge Thorium Battleaxe
	[12776]="0:48125:2:3:1:TwoHandMace::1:0:", -- Enchanted Battlehammer
	[12777]="0:38648:2:3:1:OneHandSword::1:0:", -- Blazing Rapier
	[12779]="0:35338:2:2:1:OneHandAxe::1:0:", -- Rune Edge
	[12780]="0:0:12:1:1:::1:0:", -- General Drakkisath's Command
	[12781]="0:42721:2:3:1:OneHandMace::1:0:", -- Serenity
	[12782]="0:56808:2:3:1:TwoHandSword::1:0:", -- Corruption
	[12783]="0:52397:2:3:1:Dagger::1:0:", -- Heartseeker
	[12784]="0:65736:2:3:1:TwoHandAxe::1:0:", -- Arcanite Reaper
	[12785]="0:0:12:1:1:::1:0:", -- Incendia Powder
	[12790]="0:67161:2:3:1:TwoHandSword::1:0:", -- Arcanite Champion
	[12791]="0:39411:2:3:1:Dagger::1:0:", -- Barman Shanker
	[12792]="0:39255:2:2:1:OneHandMace::1:0:", -- Volcanic Hammer
	[12793]="0:19846:4:3:1:Leather::1:0:", -- Mixologist's Tunic
	[12794]="0:50676:2:3:1:OneHandMace::1:0:", -- Masterwork Stormhammer
	[12795]="0:48821:2:3:1:FistWeapon::1:0:", -- Blood Talon
	[12796]="0:63825:2:3:1:TwoHandMace::1:0:", -- Hammer of the Titans
	[12797]="0:51252:2:3:1:OneHandSword::1:0:", -- Frostguard
	[12798]="0:51438:2:3:1:OneHandAxe::1:0:", -- Annihilator
	[12799]="0:7000:3:2:20:GemSimple:164,202,755:1:0:", -- Large Opal
	[12800]="0:10000:3:2:20:GemSimple:164,202,755,197:1:0:", -- Azerothian Diamond
	[12802]="0:62625:2:3:1:Polearm::1:0:", -- Darkspear
	[12803]="0:500:7:2:10:Elemental:171,164,333,202,755,165,197:1:0:", -- Living Essence
	[12804]="0:2000:7:1:20:Other:171,164,202,755,165,197:1:0:", -- Powerful Mojo
	[12806]="0:0:12:3:1:::1:0:", -- Unforged Rune Covered Breastplate
	[12807]="0:0:12:1:1:::1:0:", -- Scourge Banner
	[12808]="0:1000:7:2:10:Elemental:171,164,185,333,202,755,197:1:0:", -- Essence of Undeath
	[12809]="0:10000:7:2:20:MetalStone:164,165,197:1:0:", -- Guardian Stone
	[12810]="2000:500:7:1:20:Leather:164,202,165,197:1:1:14846", -- Enchanted Leather
	[12811]="0:20000:7:2:20:Other:164,333,197:1:0:", -- Righteous Orb
	[12812]="0:0:12:3:1:::1:0:", -- Unfired Plate Gauntlets
	[12813]="0:0:12:1:1:::1:0:", -- Flask of Mystery Goo
	[12814]="0:0:12:1:1:::1:0:", -- Flame in a Bottle
	[12815]="0:0:12:1:1:::1:0:", -- Beacon Torch
	[12819]="16000:4000:9:2:1:Blacksmithing::1:0:11278", -- Plans: Ornate Thorium Handaxe
	[12820]="0:0:0:1:10:Elixir::1:0:", -- Winterfall Firewater
	[12821]="0:4000:9:3:1:Blacksmithing::1:0:", -- Plans: Dawn's Edge
	[12822]="0:0:12:1:20:::1:0:", -- Toxic Horror Droplet
	[12823]="20000:5000:9:1:1:Blacksmithing::1:0:11278", -- Plans: Huge Thorium Battleaxe
	[12824]="0:5000:9:2:1:Blacksmithing::1:0:", -- Plans: Enchanted Battlehammer
	[12825]="0:5000:9:2:1:Blacksmithing::1:0:", -- Plans: Blazing Rapier
	[12827]="0:5000:9:2:1:Blacksmithing::1:0:", -- Plans: Serenity
	[12828]="0:5500:9:2:1:Blacksmithing::1:0:", -- Plans: Volcanic Hammer
	[12829]="0:0:12:1:1:::1:0:", -- Winterfall Crate
	[12830]="0:5500:9:1:1:Blacksmithing::1:0:", -- Plans: Corruption
	[12833]="0:20000:9:3:1:Blacksmithing::1:0:", -- Plans: Hammer of the Titans
	[12834]="0:20000:9:3:1:Blacksmithing::1:0:", -- Plans: Arcanite Champion
	[12835]="0:20000:9:3:1:Blacksmithing::1:0:", -- Plans: Annihilator
	[12836]="0:20000:9:3:1:Blacksmithing::1:0:", -- Plans: Frostguard
	[12837]="0:20000:9:3:1:Blacksmithing::1:0:", -- Plans: Masterwork Stormhammer
	[12838]="0:20000:9:3:1:Blacksmithing::1:0:", -- Plans: Arcanite Reaper
	[12839]="0:20000:9:3:1:Blacksmithing::1:0:", -- Plans: Heartseeker
	[12840]="0:0:12:1:250:::1:0:", -- Minion's Scourgestone
	[12841]="0:0:12:1:250:::1:0:", -- Invader's Scourgestone
	[12842]="0:0:12:1:1:::1:0:", -- Crudely-written Log
	[12843]="0:0:12:2:250:::1:0:", -- Corruptor's Scourgestone
	[12844]="0:0:12:2:250:::1:0:", -- Argent Dawn Valor Token
	[12845]="0:0:12:1:1:::1:0:", -- Medallion of Faith
	[12846]="0:0:4:1:1:Trinket::1:0:", -- Argent Dawn Commission
	[12847]="0:0:12:1:1:::1:0:", -- Soul Stained Pike
	[12848]="0:0:12:1:1:::1:0:", -- Blood Stained Pike
	[12849]="0:0:12:2:1:::1:0:", -- Demon Kissed Sack
	[12871]="0:8048:15:4:1:Junk::1:0:", -- Chromatic Carapace
	[12884]="0:0:12:1:1:::1:0:", -- Arnak's Hoof
	[12885]="0:0:12:1:1:::1:0:", -- Pamela's Doll
	[12886]="0:0:0:1:1:Consumable::1:0:", -- Pamela's Doll's Head
	[12887]="0:0:12:1:1:::1:0:", -- Pamela's Doll's Left Side
	[12888]="0:0:12:1:1:::1:0:", -- Pamela's Doll's Right Side
	[12891]="0:0:12:1:1:::1:0:", -- Jaron's Pick
	[12894]="0:0:12:1:1:::1:0:", -- Joseph's Wedding Ring
	[12895]="0:48071:4:4:1:Plate::1:0:", -- Breastplate of the Chromatic Flight
	[12896]="0:0:12:1:1:::1:0:", -- First Relic Fragment
	[12897]="0:0:12:1:1:::1:0:", -- Second Relic Fragment
	[12898]="0:0:12:1:1:::1:0:", -- Third Relic Fragment
	[12899]="0:0:12:1:1:::1:0:", -- Fourth Relic Fragment
	[12900]="0:0:12:1:1:::1:0:", -- Annals of Darrowshire
	[12903]="0:42407:4:4:1:Mail::1:0:", -- Legguards of the Chromatic Defier
	[12905]="0:15798:4:3:1:Cloak::1:0:", -- Wildfire Cape
	[12906]="0:0:12:1:1:::1:0:", -- Purified Moonwell Water
	[12907]="0:0:12:1:1:::1:0:", -- Corrupt Moonwell Water
	[12922]="0:0:0:1:1:Consumable::1:0:", -- Empty Canteen
	[12923]="0:0:12:1:1:::1:0:", -- Awbee's Scale
	[12924]="0:0:15:1:5:Junk::1:0:", -- Ritual Candle
	[12925]="0:0:12:1:1:::1:0:", -- Arikara Serpent Skin
	[12926]="0:14907:4:3:1:Ring::1:0:", -- Flaming Band
	[12927]="0:18492:4:3:1:Leather::1:0:", -- Truestrike Shoulders
	[12928]="0:0:12:1:1:::1:0:", -- Umi's Mechanical Yeti
	[12929]="0:19646:4:3:1:Amulet::1:0:", -- Emberfury Talisman
	[12930]="0:10000:4:3:1:Trinket::1:0:", -- Briarwood Reed
	[12935]="0:36536:4:3:1:Plate::1:0:", -- Warmaster Legguards
	[12936]="0:18440:4:3:1:Plate::1:0:", -- Battleborn Armbraces
	[12938]="0:0:12:1:20::171,755:1:0:", -- Blood of Heroes
	[12939]="0:54330:2:3:1:OneHandSword::1:0:", -- Dal'Rend's Tribal Guardian
	[12940]="0:49334:2:3:1:OneHandSword::1:0:", -- Dal'Rend's Sacred Charge
	[12942]="0:0:13:1:1:::1:0:", -- Panther Cage Key
	[12945]="0:39686:4:4:1:Mail::1:0:", -- Legplates of the Chromatic Defier
	[12946]="0:0:12:1:1:::1:0:", -- Hypercapacitor Gizmo
	[12947]="0:0:4:6:1:Ring::1:0:", -- Alex's Ring of Audacity
	[12952]="0:25957:4:3:1:Plate::1:0:", -- Gyth's Skull
	[12953]="0:22374:4:3:1:Mail::1:0:", -- Dragoneye Coif
	[12954]="0:0:12:1:1:::1:0:", -- Davil's Libram
	[12955]="0:0:12:1:1:::1:0:", -- Redpath's Shield
	[12956]="0:0:12:1:1:::1:0:", -- Skull of Horgus
	[12957]="0:0:12:1:1:::1:0:", -- Shattered Sword of Marduk
	[12958]="50000:12500:9:1:1:Alchemy::1:0:5594", -- Recipe: Transmute Arcanite
	[12960]="0:17752:4:3:1:Leather::1:0:", -- Tribal War Feathers
	[12963]="0:24947:4:3:1:Leather::1:0:", -- Blademaster Leggings
	[12964]="0:30051:4:3:1:Mail::1:0:", -- Tristam Legguards
	[12965]="0:20111:4:3:1:Cloth::1:0:", -- Spiritshroud Leggings
	[12966]="0:12617:4:3:1:Leather::1:0:", -- Blackmist Armguards
	[12967]="0:15196:4:3:1:Cloak::1:0:", -- Bloodmoon Cloak
	[12968]="0:15254:4:3:1:Cloak::1:0:", -- Frostweaver Cape
	[12969]="0:63799:2:3:1:TwoHandMace::1:0:", -- Seeping Willow
	[12973]="0:0:15:1:1:Junk::1:0:", -- Scarlet Cannonball
	[12974]="0:6105:2:3:1:OneHandSword::1:0:", -- The Black Knight
	[12975]="0:2205:2:3:1:TwoHandAxe::1:0:", -- Prospector Axe
	[12976]="0:1770:2:3:1:OneHandSword::1:0:", -- Ironpatch Blade
	[12977]="0:355:4:3:1:Cloth::1:0:", -- Magefist Gloves
	[12978]="0:534:4:3:1:Mail::1:0:", -- Stormbringer Belt
	[12979]="0:617:4:3:1:Cloak::1:0:", -- Firebane Cloak
	[12982]="0:851:4:3:1:Mail::1:0:", -- Silver-linked Footguards
	[12983]="0:2362:2:3:1:TwoHandMace::1:0:", -- Rakzur Club
	[12984]="0:1423:2:3:1:Wand::1:0:", -- Skycaller
	[12985]="0:1153:4:3:1:Ring::1:0:", -- Ring of Defense
	[12987]="0:906:4:3:1:Cloth::1:0:", -- Darkweave Breeches
	[12988]="0:1137:4:3:1:Leather::1:0:", -- Starsight Tunic
	[12989]="0:2854:2:3:1:Polearm::1:0:", -- Gargoyle's Bite
	[12990]="0:2589:2:3:1:OneHandAxe::1:0:", -- Razor's Edge
	[12992]="0:3260:2:3:1:TwoHandSword::1:0:", -- Searing Blade
	[12994]="0:788:4:3:1:Mail::1:0:", -- Thorbia's Gauntlets
	[12996]="0:1527:4:3:1:Ring::1:0:", -- Band of Purification
	[12997]="0:1920:4:3:1:Shield::1:0:", -- Redbeard Crest
	[12998]="0:1020:4:3:1:Cloth::1:0:", -- Magician's Mantle
	[12999]="0:853:4:3:1:Leather::1:0:", -- Drakewing Bands
	[13000]="0:60815:2:3:1:Stave::1:0:", -- Staff of Hale Magefire
	[13001]="0:10648:4:3:1:Ring::1:0:", -- Maiden's Circle
	[13002]="0:14617:4:3:1:Amulet::1:0:", -- Lady Alizabeth's Pendant
	[13003]="0:49640:2:3:1:TwoHandAxe::1:0:", -- Lord Alexander's Battle Axe
	[13004]="0:33591:2:3:1:Wand::1:0:", -- Torch of Austen
	[13005]="0:1331:4:3:1:Cloak::1:0:", -- Amy's Blanket
	[13006]="0:51132:2:3:1:OneHandMace::1:0:", -- Mass of McGowan
	[13007]="0:13585:4:3:1:Cloak::1:0:", -- Mageflame Cloak
	[13008]="0:12815:4:3:1:Cloth::1:0:", -- Dalewind Trousers
	[13009]="0:15167:4:3:1:Leather::1:0:", -- Cow King's Hide
	[13010]="0:2241:4:3:1:Mail::1:0:", -- Dreamsinger Legguards
	[13011]="0:1031:4:3:1:Leather::1:0:", -- Silver-lined Belt
	[13012]="0:1241:4:3:1:Mail::1:0:", -- Yorgen Bracers
	[13013]="0:12355:4:3:1:Cloth::1:0:", -- Elder Wizard's Mantle
	[13014]="0:34705:2:3:1:OneHandAxe::1:0:", -- Axe of Rin'ji
	[13015]="0:52106:2:3:1:OneHandAxe::1:0:", -- Serathil
	[13016]="0:4771:2:3:1:TwoHandAxe::1:0:", -- Killmaim
	[13017]="0:17209:2:3:1:TwoHandAxe::1:0:", -- Hellslayer Battle Axe
	[13018]="0:31967:2:3:1:TwoHandAxe::1:0:", -- Executioner's Cleaver
	[13019]="0:4765:2:3:1:Bow::1:0:", -- Harpyclaw Short Bow
	[13020]="0:8985:2:3:1:Bow::1:0:", -- Skystriker Bow
	[13021]="0:16694:2:3:1:Bow::1:0:", -- Needle Threader
	[13022]="0:27990:2:3:1:Bow::1:0:", -- Gryphonwing Long Bow
	[13023]="0:38435:2:3:1:Bow::1:0:", -- Eaglehorn Long Bow
	[13024]="0:4863:2:3:1:OneHandMace::1:0:", -- Beazel's Basher
	[13025]="0:10464:2:3:1:OneHandMace::1:0:", -- Deadwood Sledge
	[13026]="0:19441:2:3:1:OneHandMace::1:0:", -- Heaven's Light
	[13027]="0:33832:2:3:1:OneHandMace::1:0:", -- Bonesnapper
	[13028]="0:50800:2:3:1:OneHandMace::1:0:", -- Bludstone Hammer
	[13029]="0:5613:4:3:1:OffHandFrill::1:0:", -- Umbral Crystal
	[13030]="0:13113:4:3:1:OffHandFrill::1:0:", -- Basilisk Bone
	[13031]="0:1401:4:3:1:OffHandFrill::1:0:", -- Orb of Mistmantle
	[13032]="0:4138:2:3:1:OneHandSword::1:0:", -- Sword of Corruption
	[13033]="0:8094:2:3:1:OneHandSword::1:0:", -- Zealot Blade
	[13034]="0:14710:2:3:1:OneHandSword::1:0:", -- Speedsteel Rapier
	[13035]="0:25141:2:3:1:OneHandSword::1:0:", -- Serpent Slicer
	[13036]="0:40988:2:3:1:OneHandSword::1:0:", -- Assassination Blade
	[13037]="0:4729:2:3:1:Crossbow::1:0:", -- Crystalpine Stinger
	[13038]="0:9630:2:3:1:Crossbow::1:0:", -- Swiftwind
	[13039]="0:17892:2:3:1:Crossbow::1:0:", -- Skull Splitting Crossbow
	[13040]="0:29444:2:3:1:Crossbow::1:0:", -- Heartseeking Crossbow
	[13041]="0:4516:2:3:1:TwoHandSword::1:0:", -- Guardian Blade
	[13042]="0:17596:2:3:1:TwoHandSword::1:0:", -- Sword of the Magistrate
	[13043]="0:32389:2:3:1:TwoHandSword::1:0:", -- Blade of the Titans
	[13044]="0:52800:2:3:1:TwoHandSword::1:0:", -- Demonslayer
	[13045]="0:10809:2:3:1:TwoHandMace::1:0:", -- Viscous Hammer
	[13046]="0:35042:2:3:1:TwoHandMace::1:0:", -- Blanchard's Stout
	[13047]="0:56588:2:3:1:TwoHandMace::1:0:", -- Twig of the World Tree
	[13048]="0:5971:2:3:1:OneHandMace::1:0:", -- Looming Gavel
	[13049]="0:6191:2:3:1:TwoHandSword::1:0:", -- Deanship Claymore
	[13051]="0:22911:2:3:1:TwoHandSword::1:0:", -- Witchfury
	[13052]="0:41677:2:3:1:TwoHandSword::1:0:", -- Warmonger
	[13053]="0:59186:2:3:1:TwoHandSword::1:0:", -- Doombringer
	[13054]="0:15805:2:3:1:Polearm::1:0:", -- Grim Reaper
	[13055]="0:29367:2:3:1:Polearm::1:0:", -- Bonechewer
	[13056]="0:48330:2:3:1:Polearm::1:0:", -- Frenzied Striker
	[13057]="0:5382:2:3:1:Polearm::1:0:", -- Bloodpike
	[13058]="0:21833:2:3:1:Polearm::1:0:", -- Khoo's Point
	[13059]="0:38719:2:3:1:Polearm::1:0:", -- Stoneraven
	[13060]="0:60784:2:3:1:Polearm::1:0:", -- The Needler
	[13062]="0:2991:2:3:1:Wand::1:0:", -- Thunderwood
	[13063]="0:5851:2:3:1:Wand::1:0:", -- Starfaller
	[13064]="0:11487:2:3:1:Wand::1:0:", -- Jaina's Firestarter
	[13065]="0:20945:2:3:1:Wand::1:0:", -- Wand of Allistarj
	[13066]="0:15716:4:3:1:Plate::1:0:", -- Wyrmslayer Spaulders
	[13067]="0:25098:4:3:1:Plate::1:0:", -- Hydralick Armor
	[13068]="0:8358:4:3:1:Plate::1:0:", -- Obsidian Greaves
	[13070]="0:24606:4:3:1:Plate::1:0:", -- Sapphiron's Scale Boots
	[13071]="0:7148:4:3:1:Plate::1:0:", -- Plated Fist of Hakoo
	[13072]="0:18351:4:3:1:Plate::1:0:", -- Stonegrip Gauntlets
	[13073]="0:15861:4:3:1:Plate::1:0:", -- Mugthol's Helm
	[13074]="0:14043:4:3:1:Plate::1:0:", -- Golem Shard Leggings
	[13075]="0:34795:4:3:1:Plate::1:0:", -- Direwing Legguards
	[13076]="0:8300:4:3:1:Plate::1:0:", -- Giantslayer Bracers
	[13077]="0:14478:4:3:1:Plate::1:0:", -- Girdle of Uther
	[13079]="0:3359:4:3:1:Shield::1:0:", -- Shield of Thorsen
	[13081]="0:7123:4:3:1:Shield::1:0:", -- Skullance Shield
	[13082]="0:13235:4:3:1:Shield::1:0:", -- Mountainside Buckler
	[13083]="0:32348:4:3:1:Shield::1:0:", -- Garrett Family Crest
	[13084]="0:6614:4:3:1:Amulet::1:0:", -- Kaleidoscope Chain
	[13085]="0:9137:4:3:1:Amulet::1:0:", -- Horizon Choker
	[13086]="1000000:0:15:4:1:Mount::1:0:10618", -- Reins of the Winterspring Frostsaber
	[13087]="0:5896:4:3:1:Amulet::1:0:", -- River Pride Choker
	[13088]="0:7413:4:3:1:Amulet::1:0:", -- Gazlowe's Charm
	[13089]="0:8039:4:3:1:Amulet::1:0:", -- Skibi's Pendant
	[13091]="0:10637:4:3:1:Amulet::1:0:", -- Medallion of Grand Marshal Morris
	[13093]="0:3381:4:3:1:Ring::1:0:", -- Blush Ember Ring
	[13094]="0:2646:4:3:1:Ring::1:0:", -- The Queen's Jewel
	[13095]="0:6646:4:3:1:Ring::1:0:", -- Assault Band
	[13096]="0:7913:4:3:1:Ring::1:0:", -- Band of the Hierophant
	[13097]="0:2164:4:3:1:Ring::1:0:", -- Thunderbrow Ring
	[13098]="0:15282:4:3:1:Ring::1:0:", -- Painweaver Band
	[13099]="0:1431:4:3:1:Cloth::1:0:", -- Moccasins of the White Hare
	[13100]="0:5421:4:3:1:Cloth::1:0:", -- Furen's Boots
	[13101]="0:14318:4:3:1:Cloth::1:0:", -- Wolfrunner Shoes
	[13102]="0:6879:4:3:1:Cloth::1:0:", -- Cassandra's Grace
	[13103]="0:3453:4:3:1:Cloth::1:0:", -- Pads of the Venom Spider
	[13105]="0:2147:4:3:1:Cloth::1:0:", -- Sutarn's Ring
	[13106]="0:1216:4:3:1:Cloth::1:0:", -- Glowing Magical Bracelets
	[13107]="0:10528:4:3:1:Cloth::1:0:", -- Magiskull Cuffs
	[13108]="0:2446:4:3:1:Cloak::1:0:", -- Tigerstrike Mantle
	[13109]="0:8152:4:3:1:Cloak::1:0:", -- Blackflame Cape
	[13110]="0:4968:4:3:1:Leather::1:0:", -- Wolffear Harness
	[13111]="0:13993:4:3:1:Leather::1:0:", -- Sandals of the Insurgent
	[13112]="0:9625:4:3:1:Leather::1:0:", -- Winged Helm
	[13113]="0:18492:4:3:1:Leather::1:0:", -- Feathermoon Headdress
	[13114]="0:2574:4:3:1:Leather::1:0:", -- Troll's Bane Leggings
	[13115]="0:6991:4:3:1:Leather::1:0:", -- Sheepshear Mantle
	[13116]="0:18705:4:3:1:Leather::1:0:", -- Spaulders of the Unseen
	[13117]="0:3830:4:3:1:Leather::1:0:", -- Ogron's Sash
	[13118]="0:10601:4:3:1:Leather::1:0:", -- Serpentine Sash
	[13119]="0:3063:4:3:1:Leather::1:0:", -- Enchanted Kodo Bracers
	[13120]="0:9505:4:3:1:Leather::1:0:", -- Deepfury Bracers
	[13121]="0:3428:4:3:1:Cloak::1:0:", -- Wing of the Whelpling
	[13122]="0:11489:4:3:1:Cloak::1:0:", -- Dark Phantom Cape
	[13123]="0:31130:4:3:1:Mail::1:0:", -- Dreamwalker Armor
	[13124]="0:3996:4:3:1:Mail::1:0:", -- Ravasaur Scale Boots
	[13125]="0:12954:4:3:1:Mail::1:0:", -- Elven Chain Boots
	[13126]="0:10374:4:3:1:Mail::1:0:", -- Battlecaller Gauntlets
	[13127]="0:3021:4:3:1:Mail::1:0:", -- Frostreaver Crown
	[13128]="0:10543:4:3:1:Mail::1:0:", -- High Bergg Helm
	[13129]="0:7621:4:3:1:Mail::1:0:", -- Firemane Leggings
	[13130]="0:25065:4:3:1:Mail::1:0:", -- Windrunner Legguards
	[13131]="0:2312:4:3:1:Mail::1:0:", -- Sparkleshell Mantle
	[13132]="0:7340:4:3:1:Mail::1:0:", -- Skeletal Shoulders
	[13133]="0:22291:4:3:1:Mail::1:0:", -- Drakesfire Epaulets
	[13134]="0:7716:4:3:1:Mail::1:0:", -- Belt of the Gladiator
	[13135]="0:14001:4:3:1:Mail::1:0:", -- Lordly Armguards
	[13136]="0:1456:2:3:1:Gun::1:0:", -- Lil Timmy's Peashooter
	[13137]="0:5874:2:3:1:Gun::1:0:", -- Ironweaver
	[13138]="0:11532:2:3:1:Gun::1:0:", -- The Silencer
	[13139]="0:21029:2:3:1:Gun::1:0:", -- Guttbuster
	[13140]="0:0:13:1:1:::1:0:", -- Blood Red Key
	[13141]="0:12093:4:3:1:Amulet::1:0:", -- Tooth of Gnarr
	[13142]="0:18442:4:3:1:Plate::1:0:", -- Brigam Girdle
	[13143]="0:21372:4:4:1:Ring::1:0:", -- Mark of the Dragon Lord
	[13144]="0:6865:4:3:1:Cloth::1:0:", -- Serenity Belt
	[13145]="0:4760:4:3:1:Plate::1:0:", -- Enormous Ogre Belt
	[13146]="0:34704:2:3:1:Gun::1:0:", -- Shell Launcher Shotgun
	[13148]="0:60480:2:3:1:Polearm::1:0:", -- Chillpike
	[13155]="0:0:12:1:20:::1:0:", -- Resonating Skull
	[13156]="0:0:0:1:1:Consumable::1:0:", -- Mystic Crystal
	[13157]="0:0:12:1:20:::1:0:", -- Fetid Skull
	[13158]="0:0:12:1:1:::1:0:", -- Words of the High Chief
	[13159]="0:0:12:1:20:::1:0:", -- Bone Dust
	[13161]="0:63494:2:3:1:Stave::1:0:", -- Trindlehaven Staff
	[13162]="0:17945:4:3:1:Plate::1:0:", -- Reiver Claws
	[13163]="0:64835:2:3:1:TwoHandSword::1:0:", -- Relentless Scythe
	[13164]="0:10539:4:3:1:Trinket::1:0:", -- Heart of the Scale
	[13166]="0:24811:4:3:1:Plate::1:0:", -- Slamshot Shoulders
	[13167]="0:59410:2:3:1:TwoHandMace::1:0:", -- Fist of Omokk
	[13168]="0:33398:4:3:1:Plate::1:0:", -- Plate of the Shaman King
	[13169]="0:23948:4:3:1:Leather::1:0:", -- Tressermane Leggings
	[13170]="0:19230:4:3:1:Cloth::1:0:", -- Skyshroud Leggings
	[13171]="0:7000:4:2:1:Trinket::1:0:", -- Smokey's Lighter
	[13172]="0:0:12:1:1:::1:0:", -- Siabi's Premium Tobacco
	[13173]="0:11:15:3:200:Junk::1:0:", -- Broken Flightblade Throwing Axe
	[13174]="0:0:12:1:30:::1:0:", -- Plagued Flesh Sample
	[13175]="0:30619:2:2:1:Bow::1:0:", -- Voone's Twitchbow
	[13176]="0:0:12:1:1:::1:0:", -- Scourge Data
	[13177]="0:16396:4:3:1:Amulet::1:0:", -- Talisman of Evasion
	[13178]="0:13782:4:3:1:Ring::1:0:", -- Rosewine Circle
	[13179]="0:14916:4:3:1:Mail::1:0:", -- Brazecore Armguards
	[13180]="0:0:12:1:50:::1:0:", -- Stratholme Holy Water
	[13181]="0:8797:4:3:1:Cloth::1:0:", -- Demonskin Gloves
	[13182]="0:44142:2:3:1:OneHandSword::1:0:", -- Phase Blade
	[13183]="0:51771:2:3:1:OneHandMace::1:0:", -- Venomspitter
	[13184]="0:13170:4:3:1:Leather::1:0:", -- Fallbrush Handgrips
	[13185]="0:15858:4:3:1:Cloth::1:0:", -- Sunderseer Mantle
	[13186]="0:0:12:1:1:::1:0:", -- Empty Felstone Field Bottle
	[13187]="0:0:12:1:1:::1:0:", -- Empty Dalson's Tears Bottle
	[13188]="0:0:12:1:1:::1:0:", -- Empty Writhing Haunt Bottle
	[13189]="0:0:12:1:1:::1:0:", -- Empty Gahrron's Withering Bottle
	[13190]="0:0:12:1:1:::1:0:", -- Filled Felstone Field Bottle
	[13191]="0:0:12:1:1:::1:0:", -- Filled Dalson's Tears Bottle
	[13192]="0:0:12:1:1:::1:0:", -- Filled Writhing Haunt Bottle
	[13193]="0:0:12:1:1:::1:0:", -- Filled Gahrron's Withering Bottle
	[13194]="0:0:13:1:1:::1:0:", -- Felstone Field Cauldron Key
	[13195]="0:0:13:1:1:::1:0:", -- Dalson's Tears Cauldron Key
	[13196]="0:0:13:1:1:::1:0:", -- Gahrron's Withering Cauldron Key
	[13197]="0:0:13:1:1:::1:0:", -- Writhing Haunt Cauldron Key
	[13198]="0:50851:2:3:1:FistWeapon::1:0:", -- Hurd Smasher
	[13199]="0:4399:4:3:1:Mail::1:0:", -- Crushridge Bindings
	[13202]="0:0:12:1:1:::1:0:", -- Extended Annals of Darrowshire
	[13203]="0:15529:4:3:1:Cloak::1:0:", -- Armswake Cloak
	[13204]="0:51945:2:3:1:OneHandMace::1:0:", -- Bashguuder
	[13205]="0:33829:4:3:1:Shield::1:0:", -- Rhombeard Protector
	[13206]="0:19198:4:3:1:Cloth::1:0:", -- Wolfshear Leggings
	[13207]="0:0:12:1:1:::1:0:", -- Shadow Lord Fel'dan's Head
	[13208]="0:12091:4:3:1:Leather::1:0:", -- Bleak Howler Armguards
	[13209]="0:0:4:3:1:Trinket::1:0:", -- Seal of the Dawn
	[13210]="0:18024:4:3:1:Leather::1:0:", -- Pads of the Dread Wolf
	[13211]="0:14474:4:3:1:Mail::1:0:", -- Slashclaw Bracers
	[13212]="0:10670:4:3:1:Amulet::1:0:", -- Halycon's Spiked Collar
	[13213]="0:9633:4:3:1:Trinket::1:0:", -- Smolderweb's Eye
	[13216]="0:12795:4:2:1:Cloth::1:0:", -- Crown of the Penitent
	[13217]="0:8814:4:2:1:Ring::1:0:", -- Band of the Penitent
	[13218]="0:51556:2:3:1:Dagger::1:0:", -- Fang of the Crystal Spider
	[13243]="0:34046:4:3:1:Shield::1:0:", -- Argent Defender
	[13244]="0:14482:4:3:1:Mail::1:0:", -- Gilded Gauntlets
	[13245]="0:1064:4:3:1:Shield::1:0:", -- Kresh's Back
	[13246]="0:49997:2:3:1:OneHandSword::1:0:", -- Argent Avenger
	[13248]="0:29670:2:3:1:Gun::1:0:", -- Burstshot Harquebus
	[13249]="0:63199:2:3:1:Stave::1:0:", -- Argent Crusader
	[13250]="0:0:12:1:1:::1:0:", -- Head of Balnazzar
	[13251]="0:0:12:1:1:::1:0:", -- Head of Baron Rivendare
	[13252]="0:12434:4:3:1:Leather::1:0:", -- Cloudrunner Girdle
	[13253]="0:9983:4:3:1:Cloth::1:0:", -- Hands of Power
	[13254]="0:25883:4:3:1:Shield::1:0:", -- Astral Guard
	[13255]="0:14366:4:3:1:Mail::1:0:", -- Trueaim Gauntlets
	[13257]="0:18088:4:3:1:Leather::1:0:", -- Demonic Runed Spaulders
	[13258]="0:12885:4:3:1:Leather::1:0:", -- Slaghide Gauntlets
	[13259]="0:27105:4:3:1:Plate::1:0:", -- Ribsteel Footguards
	[13260]="0:21787:4:3:1:Mail::1:0:", -- Wind Dancer Boots
	[13261]="0:10452:4:3:1:OffHandFrill::1:0:", -- Globe of D'sak
	[13262]="0:261407:2:5:1:TwoHandSword::1:0:", -- Ashbringer
	[13282]="0:13684:4:3:1:Cloth::1:0:", -- Ogreseer Tower Boots
	[13283]="0:14907:4:3:1:Ring::1:0:", -- Magus Ring
	[13284]="0:19785:4:3:1:Mail::1:0:", -- Swiftdart Battleboots
	[13285]="0:54924:2:3:1:TwoHandAxe::1:0:", -- The Blackrock Slicer
	[13286]="0:44106:2:3:1:OneHandAxe::1:0:", -- Rivenspike
	[13287]="2500:625:9:2:1:Leatherworking::1:1:2819", -- Pattern: Raptor Hide Harness
	[13288]="2500:625:9:2:1:Leatherworking::1:1:2816", -- Pattern: Raptor Hide Belt
	[13289]="0:0:12:1:1:::1:0:", -- Egan's Blaster
	[13302]="0:0:13:1:20:::1:0:", -- Market Row Postbox Key
	[13303]="0:0:13:1:20:::1:0:", -- Crusaders' Square Postbox Key
	[13304]="0:0:13:1:20:::1:0:", -- Festival Lane Postbox Key
	[13305]="0:0:13:1:20:::1:0:", -- Elders' Square Postbox Key
	[13306]="0:0:13:1:20:::1:0:", -- King's Square Postbox Key
	[13307]="0:0:13:1:20:::1:0:", -- Fras Siabi's Postbox Key
	[13308]="1800:450:9:1:1:Engineering::1:1:2684", -- Schematic: Ice Deflector
	[13309]="1000:250:9:1:1:Engineering::1:1:2682,6730", -- Schematic: Lovingly Crafted Boomstick
	[13310]="2000:500:9:1:1:Engineering::1:1:2685", -- Schematic: Accurate Scope
	[13311]="10000:2500:9:1:1:Engineering::1:1:2687", -- Schematic: Mechanical Dragonling
	[13313]="0:0:12:1:1:::1:0:", -- Sacred Highborne Writings
	[13314]="0:28178:4:4:1:Cloth::1:0:", -- Alanna's Embrace
	[13315]="0:11396:4:2:1:OffHandFrill::1:0:", -- Testament of Hope
	[13317]="0:0:15:4:1:Mount::1:0:", -- Whistle of the Ivory Raptor
	[13320]="5000:0:12:1:1:::1:0:11056,11057", -- Arcane Quickener
	[13321]="100000:0:15:3:1:Mount::1:0:7955", -- Green Mechanostrider
	[13322]="100000:0:15:3:1:Mount::1:0:7955", -- Unpainted Mechanostrider
	[13326]="0:0:15:4:1:Mount::1:0:", -- White Mechanostrider Mod B
	[13327]="0:0:15:4:1:Mount::1:0:", -- Icy Blue Mechanostrider Mod A
	[13328]="0:0:15:4:1:Mount::1:0:", -- Black Ram
	[13329]="0:0:15:4:1:Mount::1:0:", -- Frost Ram
	[13331]="100000:0:15:3:1:Mount::1:0:4731", -- Red Skeletal Horse
	[13332]="100000:0:15:3:1:Mount::1:0:4731", -- Blue Skeletal Horse
	[13333]="100000:0:15:3:1:Mount::1:0:4731", -- Brown Skeletal Horse
	[13334]="1000000:0:15:4:1:Mount::1:0:4731", -- Green Skeletal Warhorse
	[13335]="0:0:15:4:1:Mount::1:0:", -- Deathcharger's Reins
	[13340]="0:14850:4:3:1:Cloak::1:0:", -- Cape of the Black Baron
	[13344]="0:15490:4:3:1:Mail::1:0:", -- Dracorian Gauntlets
	[13345]="0:15457:4:3:1:Ring::1:0:", -- Seal of Rivendare
	[13346]="0:20807:4:3:1:Cloth::1:0:", -- Robes of the Exalted
	[13347]="0:0:4:1:1:Trinket::1:0:", -- Crystal of Zin-Malor
	[13348]="0:65497:2:3:1:TwoHandSword::1:0:", -- Demonshear
	[13349]="0:52589:2:3:1:OneHandMace::1:0:", -- Scepter of the Unholy
	[13350]="0:0:12:1:1:::1:0:", -- Insignia of the Black Guard
	[13351]="0:0:12:1:1:::1:0:", -- Crimson Hammersmith's Apron
	[13352]="0:0:12:1:1:::1:0:", -- Vosh'gajin's Snakestone
	[13353]="0:10452:4:4:1:OffHandFrill::1:0:", -- Book of the Dead
	[13354]="0:0:12:1:200:::1:0:", -- Ectoplasmic Resonator
	[13356]="0:0:12:1:200:::1:0:", -- Somatic Intensifier
	[13357]="0:0:12:1:200:::1:0:", -- Osseous Agitator
	[13358]="0:18933:4:3:1:Leather::1:0:", -- Wyrmtongue Shoulders
	[13359]="0:22804:4:3:1:Mail::1:0:", -- Crown of Tyranny
	[13360]="0:50868:2:3:1:Dagger::1:0:", -- Gift of the Elven Magi
	[13361]="0:51060:2:3:1:OneHandSword::1:0:", -- Skullforge Reaver
	[13362]="0:2000:15:0:20:Junk::1:0:", -- Letter from the Front
	[13363]="0:2000:15:0:20:Junk::1:0:", -- Municipal Proclamation
	[13364]="0:2000:15:0:20:Junk::1:0:", -- Fras Siabi's Advertisement
	[13365]="0:2000:15:0:20:Junk::1:0:", -- Town Meeting Notice
	[13366]="0:3000:15:0:20:Junk::1:0:", -- Ingenious Toy
	[13367]="0:0:15:0:1:Junk::1:0:", -- Wrapped Gift
	[13368]="0:51689:2:3:1:Dagger::1:0:", -- Bonescraper
	[13369]="0:15775:4:3:1:Cloth::1:0:", -- Fire Striders
	[13370]="0:0:12:1:1:::1:0:", -- Vitreous Focuser
	[13371]="0:6657:4:2:1:OffHandFrill::1:0:", -- Father Flame
	[13372]="0:63769:2:3:1:Stave::1:0:", -- Slavedriver's Cane
	[13373]="0:14846:4:3:1:Ring::1:0:", -- Band of Flesh
	[13374]="0:14315:4:3:1:Cloth::1:0:", -- Soulstealer Mantle
	[13375]="0:30656:4:3:1:Shield::1:0:", -- Crest of Retribution
	[13376]="0:13738:4:3:1:Cloak::1:0:", -- Royal Tribunal Cloak
	[13377]="0:7:6:3:1000:Bullet::1:0:", -- Miniature Cannon Balls
	[13378]="0:21972:4:3:1:Leather::1:0:", -- Songbird Blouse
	[13379]="0:10734:4:3:1:Trinket::1:0:", -- Piccolo of the Flaming Fire
	[13380]="0:37124:2:3:1:Gun::1:0:", -- Willey's Portable Howitzer
	[13381]="0:26032:4:3:1:Plate::1:0:", -- Master Cannoneer Boots
	[13382]="0:10850:4:3:1:Trinket::1:0:", -- Cannonball Runner
	[13383]="0:26864:4:3:1:Mail::1:0:", -- Woollies of the Prancing Minstrel
	[13384]="0:15819:4:3:1:Plate::1:0:", -- Rainbow Girdle
	[13385]="0:13237:4:3:1:OffHandFrill::1:0:", -- Tome of Knowledge
	[13386]="0:15182:4:3:1:Cloak::1:0:", -- Archivist Cape
	[13387]="0:15238:4:3:1:Mail::1:0:", -- Foresight Girdle
	[13388]="0:20392:4:3:1:Cloth::1:0:", -- The Postmaster's Tunic
	[13389]="0:21000:4:3:1:Cloth::1:0:", -- The Postmaster's Trousers
	[13390]="0:15806:4:3:1:Cloth::1:0:", -- The Postmaster's Band
	[13391]="0:15861:4:3:1:Cloth::1:0:", -- The Postmaster's Treads
	[13392]="0:12211:4:3:1:Ring::1:0:", -- The Postmaster's Seal
	[13393]="0:60240:2:3:1:TwoHandMace::1:0:", -- Malown's Slam
	[13394]="0:31808:4:3:1:Plate::1:0:", -- Skul's Cold Embrace
	[13395]="0:11403:4:3:1:Leather::1:0:", -- Skul's Fingerbone Claws
	[13396]="0:30853:2:3:1:Wand::1:0:", -- Skul's Ghastly Touch
	[13397]="0:14680:4:3:1:Cloak::1:0:", -- Stoneskin Gargoyle Cape
	[13398]="0:18674:4:3:1:Leather::1:0:", -- Boots of the Shrieker
	[13399]="0:46312:2:3:1:FistWeapon::1:0:", -- Gargoyle Shredder Talons
	[13400]="0:16361:4:3:1:Plate::1:0:", -- Vambraces of the Sadist
	[13401]="0:49675:2:3:1:OneHandMace::1:0:", -- The Cruel Hand of Timmy
	[13402]="0:21168:4:3:1:Mail::1:0:", -- Timmy's Galoshes
	[13403]="0:9401:4:3:1:Cloth::1:0:", -- Grimgore Noose
	[13404]="0:15895:4:3:1:Leather::1:0:", -- Mask of the Unforgiven
	[13405]="0:22885:4:3:1:Plate::1:0:", -- Wailing Nightbane Pauldrons
	[13408]="0:44142:2:3:1:OneHandAxe::1:0:", -- Soul Breaker
	[13409]="0:8860:4:3:1:Cloth::1:0:", -- Tearfall Bracers
	[13422]="0:10:7:1:20:Other:171:1:0:", -- Stonescale Eel
	[13423]="0:125:7:1:20:Other:171:1:0:", -- Stonescale Oil
	[13442]="0:500:0:1:5:Potion::1:0:", -- Mighty Rage Potion
	[13443]="1600:400:0:1:5:Potion::1:1:14847,28715,29537", -- Superior Mana Potion
	[13444]="6000:1500:0:1:5:Potion:333:1:1:15471,19837,20092,20989", -- Major Mana Potion
	[13445]="0:500:0:1:20:Elixir::1:0:", -- Elixir of Superior Defense
	[13446]="4000:1000:0:1:5:Potion:333:1:1:15471,19837,20092,20989,29628", -- Major Healing Potion
	[13447]="0:1250:0:1:20:Elixir::1:0:", -- Elixir of the Sages
	[13448]="0:0:12:1:1:::1:0:", -- The Deed to Caer Darrow
	[13450]="0:0:12:1:1:::1:0:", -- The Deed to Southshore
	[13451]="0:0:12:1:1:::1:0:", -- The Deed to Tarren Mill
	[13452]="0:1250:0:1:20:Elixir::1:0:", -- Elixir of the Mongoose
	[13453]="0:1250:0:1:20:Elixir::1:0:", -- Elixir of Brute Force
	[13454]="0:750:0:1:20:Elixir::1:0:", -- Greater Arcane Elixir
	[13455]="0:750:0:1:5:Potion::1:0:", -- Greater Stoneshield Potion
	[13456]="0:750:0:1:5:Potion::1:0:", -- Greater Frost Protection Potion
	[13457]="0:750:0:1:5:Potion::1:0:", -- Greater Fire Protection Potion
	[13458]="0:750:0:1:5:Potion::1:0:", -- Greater Nature Protection Potion
	[13459]="0:100:0:1:5:Potion::1:0:", -- Greater Shadow Protection Potion
	[13460]="0:750:0:1:5:Potion::1:0:", -- Greater Holy Protection Potion
	[13461]="0:750:0:1:5:Potion::1:0:", -- Greater Arcane Protection Potion
	[13462]="0:750:0:1:5:Potion::1:0:", -- Purification Potion
	[13463]="400:100:7:1:20:Herb:171:1:1:14846", -- Dreamfoil
	[13464]="400:100:7:1:20:Herb:171:1:1:14846", -- Golden Sansam
	[13465]="600:150:7:1:20:Herb:171:1:1:14846", -- Mountain Silversage
	[13466]="0:250:7:1:20:Herb:171:1:0:", -- Plaguebloom
	[13467]="1000:250:7:1:20:Herb:171,333,202:1:1:20989,24975", -- Icecap
	[13468]="4000:1000:7:2:20:Herb:171,197:1:1:14846", -- Black Lotus
	[13469]="0:0:12:1:1:::1:0:", -- Head of Weldon Barov
	[13470]="0:0:12:1:1:::1:0:", -- Head of Alexi Barov
	[13471]="0:0:12:1:1:::1:0:", -- The Deed to Brill
	[13473]="0:7164:4:2:1:Amulet::1:0:", -- Felstone Good Luck Charm
	[13474]="0:24725:2:2:1:Gun::1:0:", -- Farmer Dalson's Shotgun
	[13475]="0:8109:4:2:1:Ring::1:0:", -- Dalson Family Wedding Ring
	[13476]="0:3000:9:2:1:Alchemy::1:0:", -- Recipe: Mighty Rage Potion
	[13477]="0:3000:9:1:1:Alchemy::1:0:", -- Recipe: Superior Mana Potion
	[13478]="13000:3250:9:1:1:Alchemy::1:1:3348,5178", -- Recipe: Elixir of Superior Defense
	[13479]="0:3500:9:2:1:Alchemy::1:0:", -- Recipe: Elixir of the Sages
	[13480]="0:3750:9:1:1:Alchemy::1:0:", -- Recipe: Major Healing Potion
	[13481]="0:3750:9:2:1:Alchemy::1:0:", -- Recipe: Elixir of Brute Force
	[13482]="15000:0:9:2:1:Alchemy::1:0:10856,10857,11536", -- Recipe: Transmute Air to Fire
	[13483]="15000:0:9:2:1:Alchemy::1:0:9499", -- Recipe: Transmute Fire to Earth
	[13484]="15000:0:9:2:1:Alchemy::1:0:11557", -- Recipe: Transmute Earth to Water
	[13485]="15000:0:9:2:1:Alchemy::1:0:11278", -- Recipe: Transmute Water to Air
	[13486]="0:3750:9:2:1:Alchemy::1:0:", -- Recipe: Transmute Undeath to Water
	[13487]="0:3750:9:2:1:Alchemy::1:0:", -- Recipe: Transmute Water to Undeath
	[13488]="0:3750:9:2:1:Alchemy::1:0:", -- Recipe: Transmute Life to Earth
	[13489]="0:3750:9:2:1:Alchemy::1:0:", -- Recipe: Transmute Earth to Life
	[13490]="0:4000:9:2:1:Alchemy::1:0:", -- Recipe: Greater Stoneshield Potion
	[13491]="0:4000:9:2:1:Alchemy::1:0:", -- Recipe: Elixir of the Mongoose
	[13492]="0:5000:9:2:1:Alchemy::1:0:", -- Recipe: Purification Potion
	[13493]="0:5000:9:2:1:Alchemy::1:0:", -- Recipe: Greater Arcane Elixir
	[13494]="0:6000:9:2:1:Alchemy::1:0:", -- Recipe: Greater Fire Protection Potion
	[13495]="0:6000:9:2:1:Alchemy::1:0:", -- Recipe: Greater Frost Protection Potion
	[13496]="0:6000:9:2:1:Alchemy::1:0:", -- Recipe: Greater Nature Protection Potion
	[13497]="0:6000:9:2:1:Alchemy::1:0:", -- Recipe: Greater Arcane Protection Potion
	[13498]="0:34808:4:3:1:Plate::1:0:", -- Handcrafted Mastersmith Leggings
	[13499]="0:6000:9:2:1:Alchemy::1:0:", -- Recipe: Greater Shadow Protection Potion
	[13501]="30000:7500:9:2:1:Alchemy::1:0:11278", -- Recipe: Major Mana Potion
	[13502]="0:18989:4:3:1:Plate::1:0:", -- Handcrafted Mastersmith Girdle
	[13503]="0:25000:4:4:1:Trinket:171:1:0:", -- Alchemist's Stone
	[13505]="0:82215:2:4:1:TwoHandSword::1:0:", -- Runeblade of Baron Rivendare
	[13506]="0:1250:0:1:20:Flask::1:0:", -- Flask of Petrification
	[13507]="0:0:12:1:1:::1:0:", -- Cliffwatcher Longhorn Report
	[13508]="0:4778:15:2:1:CombatPet::1:0:", -- Eye of Arachnida
	[13509]="0:5393:0:2:1:Consumable::1:0:", -- Clutch of Foresight
	[13510]="0:1250:0:1:20:Flask:164:1:0:", -- Flask of the Titans
	[13511]="0:1250:0:1:20:Flask::1:0:", -- Flask of Distilled Wisdom
	[13512]="0:1250:0:1:20:Flask:164:1:0:", -- Flask of Supreme Power
	[13513]="0:1250:0:1:20:Flask::1:0:", -- Flask of Chromatic Resistance
	[13514]="0:5820:0:2:1:Consumable::1:0:", -- Wail of the Banshee
	[13515]="0:9600:4:3:1:Trinket::1:0:", -- Ramstein's Lightning Bolts
	[13517]="80000:20000:9:1:1:Alchemy::1:0:21432", -- Recipe: Alchemist's Stone
	[13518]="0:10000:9:2:1:Alchemy::1:0:", -- Recipe: Flask of Petrification
	[13519]="0:10000:9:2:1:Alchemy::1:0:", -- Recipe: Flask of the Titans
	[13520]="0:10000:9:2:1:Alchemy::1:0:", -- Recipe: Flask of Distilled Wisdom
	[13521]="0:10000:9:2:1:Alchemy::1:0:", -- Recipe: Flask of Supreme Power
	[13522]="0:10000:9:2:1:Alchemy::1:0:", -- Recipe: Flask of Chromatic Resistance
	[13523]="0:0:12:1:1:::1:0:", -- Blood of Innocents
	[13524]="0:12458:4:3:1:OffHandFrill::1:0:", -- Skull of Burning Shadows
	[13525]="0:8110:4:2:1:Cloth::1:0:", -- Darkbind Fingers
	[13526]="0:10177:4:2:1:Leather::1:0:", -- Flamescarred Girdle
	[13527]="0:21414:4:2:1:Plate::1:0:", -- Lavawalker Greaves
	[13528]="0:12306:4:2:1:Mail::1:0:", -- Twilight Void Bracers
	[13529]="0:31195:4:3:1:Shield::1:0:", -- Husk of Nerub'enkan
	[13530]="0:12232:4:2:1:Cloth::1:0:", -- Fangdrip Runners
	[13531]="0:20464:4:2:1:Leather::1:0:", -- Crypt Stalker Leggings
	[13532]="0:12324:4:2:1:Mail::1:0:", -- Darkspinner Claws
	[13533]="0:21607:4:2:1:Plate::1:0:", -- Acid-etched Pauldrons
	[13534]="0:37728:2:3:1:Wand::1:0:", -- Banshee Finger
	[13535]="0:16829:4:2:1:Cloth::1:0:", -- Coldtouch Phantom Wraps
	[13536]="0:0:12:1:1:::1:0:", -- Horn of Awakening
	[13537]="0:10594:4:2:1:Leather::1:0:", -- Chillhide Bracers
	[13538]="0:19223:4:2:1:Mail::1:0:", -- Windshrieker Pauldrons
	[13539]="0:15022:4:2:1:Plate::1:0:", -- Banshee's Touch
	[13542]="0:0:12:1:1:::1:0:", -- Demon Box
	[13544]="0:0:4:2:1:Trinket::1:0:", -- Spectral Essence
	[13545]="0:0:12:1:20:::1:0:", -- Shellfish
	[13546]="0:62:0:1:20:FoodDrink::1:0:", -- Bloodbelly Fish
	[13562]="0:0:12:1:1:::1:0:", -- Remains of Trey Lightforge
	[13582]="0:0:15:3:1:Companion::1:0:", -- Zergling Leash
	[13583]="0:0:15:3:1:Companion::1:0:", -- Panda Collar
	[13584]="0:0:15:3:1:Companion::1:0:", -- Diablo Stone
	[13585]="0:0:12:1:1:::1:0:", -- Keepsake of Remembrance
	[13624]="0:0:12:1:1:::1:0:", -- Soulbound Keepsake
	[13626]="0:0:12:1:1:::1:0:", -- Human Head of Ras Frostwhisper
	[13700]="0:0:4:1:1:Miscellaneous::1:0:", -- Greater Firestone (DEPRECATED)
	[13702]="0:0:12:1:20:::1:0:", -- Doom Weed
	[13703]="0:0:12:1:20:::1:0:", -- Kodo Bone
	[13704]="0:0:13:1:1:::1:0:", -- Skeleton Key
	[13724]="6000:300:0:1:20:FoodDrink::5:0:10856,10857,11536", -- Enriched Manna Biscuit
	[13725]="0:0:12:1:1:::1:0:", -- Krastinov's Bag of Horrors
	[13752]="0:0:12:1:1:::1:0:", -- Soulbound Keepsake
	[13754]="0:6:7:1:20:Meat:185:1:0:", -- Raw Glossy Mightfish
	[13755]="0:7:0:1:20:FoodDrink:185:1:0:", -- Winter Squid
	[13756]="0:9:7:1:20:Meat:185:1:0:", -- Raw Summer Bass
	[13757]="0:10:7:1:20:Other:185:1:0:", -- Lightning Eel
	[13758]="0:4:7:1:20:Meat:185:1:0:", -- Raw Redgill
	[13759]="0:10:7:1:20:Meat:185:1:0:", -- Raw Nightfin Snapper
	[13760]="0:10:7:1:20:Meat:185:1:0:", -- Raw Sunscale Salmon
	[13761]="0:0:12:1:1:::1:0:", -- Frozen Eggs
	[13810]="6000:300:0:1:20:FoodDrink::5:0:10856,10857,11536", -- Blessed Sunfruit
	[13813]="6000:300:0:1:20:Consumable::5:0:10856,10857,11536", -- Blessed Sunfruit Juice
	[13815]="0:0:12:1:1:::1:0:", -- Some Rune
	[13816]="0:10561:2:0:1:OneHandSword::1:0:", -- Fine Longsword
	[13817]="0:18797:2:0:1:TwoHandSword::1:0:", -- Tapered Greatsword
	[13818]="0:13431:2:0:1:OneHandAxe::1:0:", -- Jagged Axe
	[13819]="0:19881:2:0:1:TwoHandAxe::1:0:", -- Balanced War Axe
	[13820]="0:12042:2:0:1:OneHandMace::1:0:", -- Clout Mace
	[13821]="0:17993:2:0:1:TwoHandMace::1:0:", -- Bulky Maul
	[13822]="0:11442:2:0:1:Dagger::1:0:", -- Spiked Dagger
	[13823]="0:13107:2:0:1:Stave::1:0:", -- Stout War Staff
	[13824]="0:9015:2:0:1:Bow::1:0:", -- Recurve Long Bow
	[13825]="0:10168:2:0:1:Gun::1:0:", -- Primed Musket
	[13850]="0:0:12:1:1:::1:0:", -- Rumbleshot's Ammo
	[13851]="0:312:0:1:20:FoodDrink::1:0:", -- Hot Wolf Ribs
	[13852]="0:0:12:1:1:::1:0:", -- The Grand Crusader's Command
	[13853]="0:0:12:1:10:::1:0:", -- Slab of Carrion Worm Meat
	[13856]="0:5112:4:2:1:Cloth::1:0:", -- Runecloth Belt
	[13857]="0:10878:4:2:1:Cloth::1:0:", -- Runecloth Tunic
	[13858]="0:10917:4:2:1:Cloth::1:0:", -- Runecloth Robe
	[13860]="0:8741:4:2:1:Cloak::1:0:", -- Runecloth Cloak
	[13863]="0:6617:4:2:1:Cloth::1:0:", -- Runecloth Gloves
	[13864]="0:9553:4:2:1:Cloth::1:0:", -- Runecloth Boots
	[13865]="0:13555:4:2:1:Cloth::1:0:", -- Runecloth Pants
	[13866]="0:11358:4:2:1:Cloth::1:0:", -- Runecloth Headband
	[13867]="0:12138:4:2:1:Cloth::1:0:", -- Runecloth Shoulders
	[13868]="0:9665:4:2:1:Cloth::1:0:", -- Frostweave Robe
	[13869]="0:9702:4:2:1:Cloth::1:0:", -- Frostweave Tunic
	[13870]="0:5471:4:2:1:Cloth::1:0:", -- Frostweave Gloves
	[13871]="0:13436:4:2:1:Cloth::1:0:", -- Frostweave Pants
	[13872]="0:0:12:1:20:::1:0:", -- Bundle of Wood
	[13873]="0:0:13:1:1:::1:0:", -- Viewing Room Key
	[13874]="0:1:15:1:1:Other::1:0:", -- Heavy Crate
	[13875]="0:1:15:1:1:Junk::1:0:", -- Ironbound Locked Chest
	[13876]="0:25:15:1:1:Junk::1:0:", -- 40 Pound Grouper
	[13877]="0:30:15:1:1:Junk::1:0:", -- 47 Pound Grouper
	[13878]="0:32:15:1:1:Junk::1:0:", -- 53 Pound Grouper
	[13879]="0:35:15:1:1:Junk::1:0:", -- 59 Pound Grouper
	[13880]="0:37:15:1:1:Junk::1:0:", -- 68 Pound Grouper
	[13881]="0:100:15:1:1:Other::1:0:", -- Bloated Redgill
	[13882]="0:60:4:1:1:OffHandFrill::1:0:", -- 42 Pound Redgill
	[13883]="0:60:4:1:1:OffHandFrill::1:0:", -- 45 Pound Redgill
	[13884]="0:75:4:1:1:OffHandFrill::1:0:", -- 49 Pound Redgill
	[13885]="0:50:4:1:1:OffHandFrill::1:0:", -- 34 Pound Redgill
	[13886]="0:50:4:1:1:OffHandFrill::1:0:", -- 37 Pound Redgill
	[13887]="0:75:4:1:1:OffHandFrill::1:0:", -- 52 Pound Redgill
	[13888]="0:12:7:1:20:Meat:185:1:0:", -- Darkclaw Lobster
	[13889]="0:5:7:1:20:Meat:185:1:0:", -- Raw Whitescale Salmon
	[13890]="0:70:7:1:20:Meat::1:0:", -- Plated Armorfish
	[13891]="0:100:15:1:1:Other::1:0:", -- Bloated Salmon
	[13892]="0:0:12:1:1:::1:0:", -- Kodo Kombobulator
	[13893]="0:15:0:1:20:FoodDrink:185:1:0:", -- Large Raw Mightfish
	[13895]="0:101324:4:1:1:Miscellaneous::1:0:", -- Formal Dangui
	[13896]="55103:11020:4:1:1:Miscellaneous::1:0:1299,4184,5821", -- Dark Green Wedding Hanbok
	[13897]="2977:595:4:1:1:Miscellaneous::1:0:1299,4184,5821", -- White Traditional Hanbok
	[13898]="288699:57739:4:1:1:Miscellaneous::1:0:1299,4184,5821", -- Royal Dangui
	[13899]="17641:3528:4:1:1:Miscellaneous::1:1:4184", -- Red Traditional Hanbok
	[13900]="0:27442:4:1:1:Miscellaneous::1:0:", -- Green Wedding Hanbok
	[13901]="0:25:4:1:1:OffHandFrill::1:0:", -- 15 Pound Salmon
	[13902]="0:25:4:1:1:OffHandFrill::1:0:", -- 18 Pound Salmon
	[13903]="0:25:4:1:1:OffHandFrill::1:0:", -- 22 Pound Salmon
	[13904]="0:25:4:1:1:OffHandFrill::1:0:", -- 25 Pound Salmon
	[13905]="0:25:4:1:1:OffHandFrill::1:0:", -- 29 Pound Salmon
	[13907]="0:50:15:1:1:Junk::1:0:", -- 7 Pound Lobster
	[13908]="0:55:15:1:1:Junk::1:0:", -- 9 Pound Lobster
	[13909]="0:55:15:1:1:Junk::1:0:", -- 12 Pound Lobster
	[13910]="0:62:15:1:1:Junk::1:0:", -- 15 Pound Lobster
	[13911]="0:80:15:1:1:Junk::1:0:", -- 19 Pound Lobster
	[13912]="0:90:15:1:1:Junk::1:0:", -- 21 Pound Lobster
	[13913]="0:100:15:1:1:Junk::1:0:", -- 22 Pound Lobster
	[13914]="0:125:4:1:1:OffHandFrill::1:0:", -- 70 Pound Mightfish
	[13915]="0:125:4:1:1:OffHandFrill::1:0:", -- 85 Pound Mightfish
	[13916]="0:150:4:1:1:OffHandFrill::1:0:", -- 92 Pound Mightfish
	[13917]="0:200:4:1:1:OffHandFrill::1:0:", -- 103 Pound Mightfish
	[13918]="0:1:15:1:1:Junk::1:0:", -- Reinforced Locked Chest
	[13920]="0:0:12:1:1:::1:0:", -- Healthy Dragon Scale
	[13926]="0:10000:3:2:20:GemSimple:333,197:1:0:", -- Golden Pearl
	[13927]="0:8:0:1:20:FoodDrink::1:0:", -- Cooked Glossy Mightfish
	[13928]="0:8:0:1:20:FoodDrink::1:0:", -- Grilled Squid
	[13929]="0:10:0:1:20:FoodDrink::1:0:", -- Hot Smoked Bass
	[13930]="0:5:0:1:20:FoodDrink::1:0:", -- Filet of Redgill
	[13931]="0:12:0:1:20:FoodDrink::1:0:", -- Nightfin Soup
	[13932]="0:12:0:1:20:FoodDrink::1:0:", -- Poached Sunscale Salmon
	[13933]="0:14:0:1:20:FoodDrink::1:0:", -- Lobster Stew
	[13934]="0:18:0:1:20:FoodDrink::1:0:", -- Mightfish Steak
	[13935]="0:10:0:1:20:FoodDrink::1:0:", -- Baked Salmon
	[13937]="0:81129:2:4:1:Stave::1:0:", -- Headmaster's Charge
	[13938]="0:36646:2:3:1:Wand::1:0:", -- Bonecreeper Stylus
	[13939]="16000:4000:9:1:1:Cooking::1:0:8137", -- Recipe: Spotted Yellowtail
	[13940]="16000:4000:9:1:1:Cooking::1:0:2664", -- Recipe: Cooked Glossy Mightfish
	[13941]="16000:4000:9:1:1:Cooking::1:0:2664", -- Recipe: Filet of Redgill
	[13942]="16000:4000:9:1:1:Cooking::1:0:8137", -- Recipe: Grilled Squid
	[13943]="16000:4000:9:1:1:Cooking::1:0:2664", -- Recipe: Hot Smoked Bass
	[13944]="0:24996:4:3:1:Leather::1:0:", -- Tombstone Breastplate
	[13945]="20000:5000:9:1:1:Cooking::1:0:8137", -- Recipe: Nightfin Soup
	[13946]="20000:5000:9:1:1:Cooking::1:0:8137", -- Recipe: Poached Sunscale Salmon
	[13947]="20000:5000:9:1:1:Cooking::1:0:7947,8145", -- Recipe: Lobster Stew
	[13948]="20000:5000:9:1:1:Cooking::1:0:7947,8145", -- Recipe: Mightfish Steak
	[13949]="20000:5000:9:1:1:Cooking::1:0:7947,8145", -- Recipe: Baked Salmon
	[13950]="0:15335:4:3:1:Mail::1:0:", -- Detention Strap
	[13951]="0:18059:4:3:1:Plate::1:0:", -- Vigorsteel Vambraces
	[13952]="0:52850:2:3:1:OneHandAxe::1:0:", -- Iceblade Hacker
	[13953]="0:53034:2:3:1:OneHandSword::1:0:", -- Silent Fang
	[13954]="0:19687:4:3:1:Leather::1:0:", -- Verdant Footpads
	[13955]="0:27607:4:3:1:Plate::1:0:", -- Stoneform Shoulders
	[13956]="0:10574:4:3:1:Cloth::1:0:", -- Clutch of Andros
	[13957]="0:12001:4:3:1:Leather::1:0:", -- Gargoyle Slashers
	[13958]="0:9505:4:3:1:Cloth::1:0:", -- Wyrmthalak's Shackles
	[13959]="0:16794:4:3:1:Plate::1:0:", -- Omokk's Girth Restrainer
	[13960]="0:12828:4:3:1:Amulet::1:0:", -- Heart of the Fiend
	[13961]="0:18028:4:3:1:Leather::1:0:", -- Halycon's Muzzle
	[13962]="0:12064:4:3:1:Leather::1:0:", -- Vosh'gajin's Strand
	[13963]="0:14533:4:3:1:Mail::1:0:", -- Voone's Vice Grips
	[13964]="0:49986:2:3:1:Dagger::1:0:", -- Witchblade
	[13965]="0:16250:4:3:1:Trinket::1:0:", -- Blackhand's Breadth
	[13966]="0:16250:4:3:1:Trinket::1:0:", -- Mark of Tyranny
	[13967]="0:22537:4:3:1:Mail::1:0:", -- Windreaver Greaves
	[13968]="0:16250:4:3:1:Trinket::1:0:", -- Eye of the Beast
	[13969]="0:15470:4:3:1:Mail::1:0:", -- Loomguard Armbraces
	[13982]="0:62847:2:3:1:TwoHandSword::1:0:", -- Warblade of Caer Darrow
	[13983]="0:62240:2:3:1:TwoHandAxe::1:0:", -- Gravestone War Axe
	[13984]="0:52029:2:3:1:Dagger::1:0:", -- Darrowspike
	[13986]="0:15723:4:3:1:Cloth::1:0:", -- Crown of Caer Darrow
	[14002]="0:33050:4:3:1:Shield::1:0:", -- Darrowshire Strongguard
	[14022]="0:8991:4:3:1:Trinket::1:0:", -- Barov Peasant Caller
	[14023]="0:8991:4:3:1:Trinket::1:0:", -- Barov Peasant Caller
	[14024]="0:50623:2:3:1:Dagger::1:0:", -- Frightalon
	[14025]="0:188:4:2:1:Cloth::1:0:", -- Mystic's Belt
	[14042]="0:10561:4:2:1:Cloth::1:0:", -- Cindercloth Vest
	[14043]="0:5955:4:2:1:Cloth::1:0:", -- Cindercloth Gloves
	[14044]="0:9503:4:2:1:Cloak:165:1:0:", -- Cindercloth Cloak
	[14045]="0:13481:4:2:1:Cloth::1:0:", -- Cindercloth Pants
	[14046]="0:5000:1:1:1:Bag::1:0:", -- Runecloth Bag
	[14047]="0:400:7:1:20:Cloth:164,202,129,165,197:1:0:", -- Runecloth
	[14048]="0:2000:7:1:20:Cloth:165,197:1:0:", -- Bolt of Runecloth
	[14086]="0:45:4:1:1:Cloth::1:0:", -- Beaded Sandals
	[14087]="0:16:4:1:1:Cloth::1:0:", -- Beaded Cuffs
	[14088]="0:24:4:1:1:Cloak::1:0:", -- Beaded Cloak
	[14089]="0:30:4:1:1:Cloth::1:0:", -- Beaded Gloves
	[14090]="0:119:4:2:1:Cloth::1:0:", -- Beaded Britches
	[14091]="0:120:4:2:1:Cloth::1:0:", -- Beaded Robe
	[14093]="0:21:4:1:1:Cloth::1:0:", -- Beaded Cord
	[14094]="0:121:4:2:1:Cloth::1:0:", -- Beaded Wraps
	[14095]="0:36:4:1:1:Cloth::1:0:", -- Native Bands
	[14096]="0:325:4:2:1:Cloth::1:0:", -- Native Vest
	[14097]="0:236:4:2:1:Cloth::1:0:", -- Native Pants
	[14098]="0:43:4:1:1:Cloak::1:0:", -- Native Cloak
	[14099]="0:47:4:1:1:Cloth::1:0:", -- Native Sash
	[14100]="0:12089:4:2:1:Cloth::1:0:", -- Brightcloth Robe
	[14101]="0:6066:4:2:1:Cloth::1:0:", -- Brightcloth Gloves
	[14102]="0:60:4:1:1:Cloth::1:0:", -- Native Handwraps
	[14103]="0:9716:4:2:1:Cloak::1:0:", -- Brightcloth Cloak
	[14104]="0:15484:4:2:1:Cloth::1:0:", -- Brightcloth Pants
	[14106]="0:17434:4:2:1:Cloth::1:0:", -- Felcloth Robe
	[14107]="0:13141:4:2:1:Cloth::1:0:", -- Felcloth Pants
	[14108]="0:11112:4:2:1:Cloth::1:0:", -- Felcloth Boots
	[14109]="0:341:4:2:1:Cloth::1:0:", -- Native Robe
	[14110]="0:84:4:1:1:Cloth::1:0:", -- Native Sandals
	[14111]="0:10775:4:2:1:Cloth::1:0:", -- Felcloth Hood
	[14112]="0:12596:4:2:1:Cloth::1:0:", -- Felcloth Shoulders
	[14113]="0:139:4:2:1:Cloth::1:0:", -- Aboriginal Sash
	[14114]="0:242:4:2:1:Cloth::1:0:", -- Aboriginal Footwraps
	[14115]="0:70:4:1:1:Cloth::1:0:", -- Aboriginal Bands
	[14116]="0:106:4:1:1:Cloak::1:0:", -- Aboriginal Cape
	[14117]="0:163:4:2:1:Cloth::1:0:", -- Aboriginal Gloves
	[14119]="0:378:4:2:1:Cloth::1:0:", -- Aboriginal Loincloth
	[14120]="0:577:4:2:1:Cloth::1:0:", -- Aboriginal Robe
	[14121]="0:579:4:2:1:Cloth::1:0:", -- Aboriginal Vest
	[14122]="0:219:4:2:1:Cloth::1:0:", -- Ritual Bands
	[14123]="0:287:4:2:1:Cloak::1:0:", -- Ritual Cape
	[14124]="0:292:4:2:1:Cloth::1:0:", -- Ritual Gloves
	[14125]="0:676:4:2:1:Cloth::1:0:", -- Ritual Leggings
	[14126]="0:396:4:1:1:Cloth::1:0:", -- Ritual Amice
	[14127]="0:1000:4:2:1:Cloth::1:0:", -- Ritual Shroud
	[14128]="0:16093:4:2:1:Cloth::1:0:", -- Wizardweave Robe
	[14129]="0:415:4:2:1:Cloth::1:0:", -- Ritual Sandals
	[14130]="0:12330:4:2:1:Cloth::1:0:", -- Wizardweave Turban
	[14131]="0:242:4:2:1:Cloth::1:0:", -- Ritual Belt
	[14132]="0:12441:4:2:1:Cloth::1:0:", -- Wizardweave Leggings
	[14133]="0:950:4:2:1:Cloth::1:0:", -- Ritual Tunic
	[14134]="0:11280:4:3:1:Cloak::1:0:", -- Cloak of Fire
	[14136]="0:17025:4:3:1:Cloth::1:0:", -- Robe of Winter Night
	[14137]="0:18113:4:3:1:Cloth::1:0:", -- Mooncloth Leggings
	[14138]="0:20042:4:3:1:Cloth::1:0:", -- Mooncloth Vest
	[14139]="0:15297:4:3:1:Cloth::1:0:", -- Mooncloth Shoulders
	[14140]="0:15565:4:3:1:Cloth::1:0:", -- Mooncloth Circlet
	[14141]="0:12859:4:2:1:Cloth::1:0:", -- Ghostweave Vest
	[14142]="0:6087:4:2:1:Cloth::1:0:", -- Ghostweave Gloves
	[14143]="0:5763:4:2:1:Cloth::1:0:", -- Ghostweave Belt
	[14144]="0:14374:4:2:1:Cloth::1:0:", -- Ghostweave Pants
	[14145]="0:1238:2:3:1:OneHandSword::1:0:", -- Cursed Felblade
	[14146]="0:13132:4:4:1:Cloth::1:0:", -- Gloves of Spell Mastery
	[14147]="0:374:4:3:1:Mail::1:0:", -- Cavedweller Bracers
	[14148]="0:250:4:3:1:Cloth::1:0:", -- Crystalline Cuffs
	[14149]="0:377:4:3:1:Cloak::1:0:", -- Subterranean Cape
	[14150]="0:504:4:3:1:Cloth::1:0:", -- Robe of Evocation
	[14151]="0:1267:2:3:1:Dagger::1:0:", -- Chanting Blade
	[14152]="0:26866:4:4:1:Cloth::1:0:", -- Robe of the Archmage
	[14153]="0:26965:4:4:1:Cloth::1:0:", -- Robe of the Void
	[14154]="0:27066:4:4:1:Cloth::1:0:", -- Truefaith Vestments
	[14155]="0:20000:1:2:1:Bag::1:0:", -- Mooncloth Bag
	[14156]="0:40000:1:3:1:Bag::1:0:", -- Bottomless Bag
	[14157]="0:434:4:1:1:Cloth::1:0:", -- Pagan Mantle
	[14158]="0:1236:4:2:1:Cloth::1:0:", -- Pagan Vest
	[14159]="0:570:4:2:1:Cloth::1:0:", -- Pagan Shoes
	[14160]="0:251:4:2:1:Cloth::1:0:", -- Pagan Bands
	[14161]="0:337:4:2:1:Cloak::1:0:", -- Pagan Cape
	[14162]="0:445:4:2:1:Cloth::1:0:", -- Pagan Mitts
	[14163]="0:1168:4:2:1:Cloth::1:0:", -- Pagan Wraps
	[14164]="0:312:4:2:1:Cloth::1:0:", -- Pagan Belt
	[14165]="0:1041:4:2:1:Cloth::1:0:", -- Pagan Britches
	[14166]="0:238:4:2:1:Cloth::1:0:", -- Buccaneer's Bracers
	[14167]="0:358:4:2:1:Cloak::1:0:", -- Buccaneer's Cape
	[14168]="0:276:4:2:1:Cloth::1:0:", -- Buccaneer's Gloves
	[14169]="0:286:4:1:1:Cloth::1:0:", -- Aboriginal Shoulder Pads
	[14170]="0:331:4:1:1:Cloth::1:0:", -- Buccaneer's Mantle
	[14171]="0:738:4:2:1:Cloth::1:0:", -- Buccaneer's Pants
	[14172]="0:837:4:2:1:Cloth::1:0:", -- Buccaneer's Robes
	[14173]="0:281:4:2:1:Cloth::1:0:", -- Buccaneer's Cord
	[14174]="0:368:4:2:1:Cloth::1:0:", -- Buccaneer's Boots
	[14175]="0:847:4:2:1:Cloth::1:0:", -- Buccaneer's Vest
	[14176]="0:920:4:2:1:Cloth::1:0:", -- Watcher's Boots
	[14177]="0:631:4:2:1:Cloth::1:0:", -- Watcher's Cuffs
	[14178]="0:1532:4:2:1:Cloth::1:0:", -- Watcher's Cap
	[14179]="0:747:4:2:1:Cloak::1:0:", -- Watcher's Cape
	[14180]="0:1870:4:2:1:Cloth::1:0:", -- Watcher's Jerkin
	[14181]="0:775:4:2:1:Cloth::1:0:", -- Watcher's Handwraps
	[14182]="0:1167:4:2:1:Cloth::1:0:", -- Watcher's Mantle
	[14183]="0:1710:4:2:1:Cloth::1:0:", -- Watcher's Leggings
	[14184]="0:1716:4:2:1:Cloth::1:0:", -- Watcher's Robes
	[14185]="0:647:4:2:1:Cloth::1:0:", -- Watcher's Cinch
	[14186]="0:1179:4:2:1:Cloth::1:0:", -- Raincaller Mantle
	[14187]="0:717:4:2:1:Cloth::1:0:", -- Raincaller Cuffs
	[14188]="0:982:4:2:1:Cloak::1:0:", -- Raincaller Cloak
	[14189]="0:1588:4:2:1:Cloth::1:0:", -- Raincaller Cap
	[14190]="0:1932:4:2:1:Cloth::1:0:", -- Raincaller Vest
	[14191]="0:881:4:2:1:Cloth::1:0:", -- Raincaller Mitts
	[14192]="0:1946:4:2:1:Cloth::1:0:", -- Raincaller Robes
	[14193]="0:2006:4:2:1:Cloth::1:0:", -- Raincaller Pants
	[14194]="0:756:4:2:1:Cloth::1:0:", -- Raincaller Cord
	[14195]="0:1252:4:2:1:Cloth::1:0:", -- Raincaller Boots
	[14196]="0:1673:4:2:1:Cloth::1:0:", -- Thistlefur Sandals
	[14197]="0:925:4:2:1:Cloth::1:0:", -- Thistlefur Bands
	[14198]="0:1531:4:2:1:Cloak::1:0:", -- Thistlefur Cloak
	[14199]="0:1240:4:2:1:Cloth::1:0:", -- Thistlefur Gloves
	[14200]="0:2258:4:2:1:Cloth::1:0:", -- Thistlefur Cap
	[14201]="0:2060:4:2:1:Cloth::1:0:", -- Thistlefur Mantle
	[14202]="0:3336:4:2:1:Cloth::1:0:", -- Thistlefur Jerkin
	[14203]="0:2754:4:2:1:Cloth::1:0:", -- Thistlefur Pants
	[14204]="0:3041:4:2:1:Cloth::1:0:", -- Thistlefur Robe
	[14205]="0:1042:4:2:1:Cloth::1:0:", -- Thistlefur Belt
	[14206]="0:1046:4:2:1:Cloth::1:0:", -- Vital Bracelets
	[14207]="0:3076:4:2:1:Cloth::1:0:", -- Vital Leggings
	[14208]="0:2316:4:2:1:Cloth::1:0:", -- Vital Headband
	[14209]="0:1196:4:2:1:Cloth::1:0:", -- Vital Sash
	[14210]="0:1637:4:2:1:Cloak::1:0:", -- Vital Cape
	[14211]="0:1325:4:2:1:Cloth::1:0:", -- Vital Handwraps
	[14212]="0:2194:4:2:1:Cloth::1:0:", -- Vital Shoulders
	[14213]="0:3553:4:2:1:Cloth::1:0:", -- Vital Raiment
	[14214]="0:2009:4:2:1:Cloth::1:0:", -- Vital Boots
	[14215]="0:3579:4:2:1:Cloth::1:0:", -- Vital Tunic
	[14216]="0:4887:4:2:1:Cloth::1:0:", -- Geomancer's Jerkin
	[14217]="0:1638:4:2:1:Cloth::1:0:", -- Geomancer's Cord
	[14218]="0:2713:4:2:1:Cloth::1:0:", -- Geomancer's Boots
	[14219]="0:2046:4:2:1:Cloak::1:0:", -- Geomancer's Cloak
	[14220]="0:3442:4:2:1:Cloth::1:0:", -- Geomancer's Cap
	[14221]="0:1511:4:2:1:Cloth::1:0:", -- Geomancer's Bracers
	[14222]="0:1834:4:2:1:Cloth::1:0:", -- Geomancer's Gloves
	[14223]="0:2699:4:2:1:Cloth::1:0:", -- Geomancer's Spaulders
	[14224]="0:3901:4:2:1:Cloth::1:0:", -- Geomancer's Trousers
	[14225]="0:4694:4:2:1:Cloth::1:0:", -- Geomancer's Wraps
	[14226]="0:1731:4:2:1:Cloth::1:0:", -- Embersilk Bracelets
	[14227]="0:2500:7:1:10:Cloth:202,165,197:1:0:", -- Ironweb Spider Silk
	[14228]="0:3560:4:2:1:Cloth::1:0:", -- Embersilk Coronet
	[14229]="0:2387:4:2:1:Cloak::1:0:", -- Embersilk Cloak
	[14230]="0:5164:4:2:1:Cloth::1:0:", -- Embersilk Tunic
	[14231]="0:1905:4:2:1:Cloth::1:0:", -- Embersilk Mitts
	[14232]="0:3097:4:2:1:Cloth::1:0:", -- Embersilk Mantle
	[14233]="0:4476:4:2:1:Cloth::1:0:", -- Embersilk Leggings
	[14234]="0:5240:4:2:1:Cloth::1:0:", -- Embersilk Robes
	[14235]="0:1789:4:2:1:Cloth::1:0:", -- Embersilk Cord
	[14236]="0:2909:4:2:1:Cloth::1:0:", -- Embersilk Boots
	[14237]="0:7206:4:2:1:Cloth::1:0:", -- Darkmist Armor
	[14238]="0:3691:4:2:1:Cloth::1:0:", -- Darkmist Boots
	[14239]="0:3176:4:2:1:Cloak::1:0:", -- Darkmist Cape
	[14240]="0:2294:4:2:1:Cloth::1:0:", -- Darkmist Bands
	[14241]="0:2311:4:2:1:Cloth::1:0:", -- Darkmist Handguards
	[14242]="0:5413:4:2:1:Cloth::1:0:", -- Darkmist Pants
	[14243]="0:4075:4:2:1:Cloth::1:0:", -- Darkmist Mantle
	[14244]="0:6870:4:2:1:Cloth::1:0:", -- Darkmist Wraps
	[14245]="0:2346:4:2:1:Cloth::1:0:", -- Darkmist Girdle
	[14246]="0:4451:4:2:1:Cloth::1:0:", -- Darkmist Wizard Hat
	[14247]="0:4467:4:2:1:Cloth::1:0:", -- Lunar Mantle
	[14248]="0:2373:4:2:1:Cloth::1:0:", -- Lunar Bindings
	[14249]="0:7559:4:2:1:Cloth::1:0:", -- Lunar Vest
	[14250]="0:3873:4:2:1:Cloth::1:0:", -- Lunar Slippers
	[14251]="0:3332:4:2:1:Cloak::1:0:", -- Lunar Cloak
	[14252]="0:4914:4:2:1:Cloth::1:0:", -- Lunar Coronet
	[14253]="0:2819:4:2:1:Cloth::1:0:", -- Lunar Handwraps
	[14254]="0:7698:4:2:1:Cloth::1:0:", -- Lunar Raiment
	[14255]="0:2629:4:2:1:Cloth::1:0:", -- Lunar Belt
	[14256]="8000:2000:7:1:20:Cloth:165,197:1:1:16015", -- Felcloth
	[14257]="0:6194:4:2:1:Cloth::1:0:", -- Lunar Leggings
	[14258]="0:3109:4:2:1:Cloth::1:0:", -- Bloodwoven Cord
	[14259]="0:5056:4:2:1:Cloth::1:0:", -- Bloodwoven Boots
	[14260]="0:2900:4:2:1:Cloth::1:0:", -- Bloodwoven Bracers
	[14261]="0:4044:4:2:1:Cloak::1:0:", -- Bloodwoven Cloak
	[14262]="0:3156:4:2:1:Cloth::1:0:", -- Bloodwoven Mitts
	[14263]="0:5987:4:2:1:Cloth::1:0:", -- Bloodwoven Mask
	[14264]="0:8013:4:2:1:Cloth::1:0:", -- Bloodwoven Pants
	[14265]="0:9853:4:2:1:Cloth::1:0:", -- Bloodwoven Wraps
	[14266]="0:5606:4:2:1:Cloth::1:0:", -- Bloodwoven Pads
	[14267]="0:9926:4:2:1:Cloth::1:0:", -- Bloodwoven Jerkin
	[14268]="0:3486:4:2:1:Cloth::1:0:", -- Gaea's Cuffs
	[14269]="0:5669:4:2:1:Cloth::1:0:", -- Gaea's Slippers
	[14270]="0:4877:4:2:1:Cloak::1:0:", -- Gaea's Cloak
	[14271]="0:6599:4:2:1:Cloth::1:0:", -- Gaea's Circlet
	[14272]="0:3821:4:2:1:Cloth::1:0:", -- Gaea's Handwraps
	[14273]="0:6375:4:2:1:Cloth::1:0:", -- Gaea's Amice
	[14274]="0:10448:4:2:1:Cloth::1:0:", -- Gaea's Leggings
	[14275]="0:11115:4:2:1:Cloth::1:0:", -- Gaea's Raiment
	[14276]="0:3598:4:2:1:Cloth::1:0:", -- Gaea's Belt
	[14277]="0:10131:4:2:1:Cloth::1:0:", -- Gaea's Tunic
	[14278]="0:6725:4:2:1:Cloth::1:0:", -- Opulent Mantle
	[14279]="0:4206:4:2:1:Cloth::1:0:", -- Opulent Bracers
	[14280]="0:5919:4:2:1:Cloak::1:0:", -- Opulent Cape
	[14281]="0:8178:4:2:1:Cloth::1:0:", -- Opulent Crown
	[14282]="0:4552:4:2:1:Cloth::1:0:", -- Opulent Gloves
	[14283]="0:11646:4:2:1:Cloth::1:0:", -- Opulent Leggings
	[14284]="0:13135:4:2:1:Cloth::1:0:", -- Opulent Robes
	[14285]="0:6905:4:2:1:Cloth::1:0:", -- Opulent Boots
	[14286]="0:4620:4:2:1:Cloth::1:0:", -- Opulent Belt
	[14287]="0:13283:4:2:1:Cloth::1:0:", -- Opulent Tunic
	[14288]="0:14132:4:2:1:Cloth::1:0:", -- Arachnidian Armor
	[14289]="0:5131:4:2:1:Cloth::1:0:", -- Arachnidian Girdle
	[14290]="0:7725:4:2:1:Cloth::1:0:", -- Arachnidian Footpads
	[14291]="0:4830:4:2:1:Cloth::1:0:", -- Arachnidian Bracelets
	[14292]="0:6795:4:2:1:Cloak::1:0:", -- Arachnidian Cape
	[14293]="0:9857:4:2:1:Cloth::1:0:", -- Arachnidian Circlet
	[14294]="0:5223:4:2:1:Cloth::1:0:", -- Arachnidian Gloves
	[14295]="0:13237:4:2:1:Cloth::1:0:", -- Arachnidian Legguards
	[14296]="0:7568:4:2:1:Cloth::1:0:", -- Arachnidian Pauldrons
	[14297]="0:13556:4:2:1:Cloth::1:0:", -- Arachnidian Robes
	[14298]="0:9629:4:2:1:Cloth::1:0:", -- Bonecaster's Spaulders
	[14299]="0:8602:4:2:1:Cloth::1:0:", -- Bonecaster's Boots
	[14300]="0:7685:4:2:1:Cloak::1:0:", -- Bonecaster's Cape
	[14301]="0:5451:4:2:1:Cloth::1:0:", -- Bonecaster's Bindings
	[14302]="0:6517:4:2:1:Cloth::1:0:", -- Bonecaster's Gloves
	[14303]="0:16209:4:2:1:Cloth::1:0:", -- Bonecaster's Shroud
	[14304]="0:6194:4:2:1:Cloth::1:0:", -- Bonecaster's Belt
	[14305]="0:14349:4:2:1:Cloth::1:0:", -- Bonecaster's Sarong
	[14306]="0:16831:4:2:1:Cloth::1:0:", -- Bonecaster's Vest
	[14307]="0:12064:4:2:1:Cloth::1:0:", -- Bonecaster's Crown
	[14308]="0:17188:4:2:1:Cloth::1:0:", -- Celestial Tunic
	[14309]="0:6867:4:2:1:Cloth::1:0:", -- Celestial Belt
	[14310]="0:11615:4:2:1:Cloth::1:0:", -- Celestial Slippers
	[14311]="0:6524:4:2:1:Cloth::1:0:", -- Celestial Bindings
	[14312]="0:13077:4:2:1:Cloth::1:0:", -- Celestial Crown
	[14313]="0:9298:4:2:1:Cloak::1:0:", -- Celestial Cape
	[14314]="0:7854:4:2:1:Cloth::1:0:", -- Celestial Handwraps
	[14315]="0:16550:4:2:1:Cloth::1:0:", -- Celestial Kilt
	[14316]="0:11271:4:2:1:Cloth::1:0:", -- Celestial Pauldrons
	[14317]="0:16062:4:2:1:Cloth::1:0:", -- Celestial Silk Robes
	[14318]="0:16569:4:2:1:Cloth::1:0:", -- Resplendent Tunic
	[14319]="0:11401:4:2:1:Cloth::1:0:", -- Resplendent Boots
	[14320]="0:6855:4:2:1:Cloth::1:0:", -- Resplendent Bracelets
	[14321]="0:9438:4:2:1:Cloak::1:0:", -- Resplendent Cloak
	[14322]="0:12785:4:2:1:Cloth::1:0:", -- Resplendent Circlet
	[14323]="0:8322:4:2:1:Cloth::1:0:", -- Resplendent Gauntlets
	[14324]="0:16706:4:2:1:Cloth::1:0:", -- Resplendent Sarong
	[14325]="0:12751:4:2:1:Cloth::1:0:", -- Resplendent Epaulets
	[14326]="0:17533:4:2:1:Cloth::1:0:", -- Resplendent Robes
	[14327]="0:7659:4:2:1:Cloth::1:0:", -- Resplendent Belt
	[14328]="0:18134:4:2:1:Cloth::1:0:", -- Eternal Chestguard
	[14329]="0:13115:4:2:1:Cloth::1:0:", -- Eternal Boots
	[14330]="0:8655:4:2:1:Cloth::1:0:", -- Eternal Bindings
	[14331]="0:11654:4:2:1:Cloak::1:0:", -- Eternal Cloak
	[14332]="0:13616:4:2:1:Cloth::1:0:", -- Eternal Crown
	[14333]="0:8989:4:2:1:Cloth::1:0:", -- Eternal Gloves
	[14334]="0:18041:4:2:1:Cloth::1:0:", -- Eternal Sarong
	[14335]="0:13578:4:2:1:Cloth::1:0:", -- Eternal Spaulders
	[14336]="0:16880:4:2:1:Cloth::1:0:", -- Eternal Wraps
	[14337]="0:8253:4:2:1:Cloth::1:0:", -- Eternal Cord
	[14338]="0:0:12:1:1:::1:0:", -- Empty Water Tube
	[14339]="0:0:12:1:1:::1:0:", -- Moonwell Water Tube
	[14340]="0:20305:4:3:1:Cloth::1:0:", -- Freezing Lich Robes
	[14341]="5000:1250:7:1:20:Cloth:165,197:1:0:989,1148,1286,1347,1454,1474,1672,2225,2394,2668,2669,2670,2672,2697,2698,2699,2810,2816,2819,2821,2846,3005,3091,3096,3364,3366,3367,3485,3779,3954,3955,3958,4168,4189,4225,4229,4561,4577,4589,4775,4897,5128,5135,5154,5163,5565,5783,5817,5944,6301,6567,6568,6574,6576,6731,7852,7854,7940,7947,8145,8160,8363,8681,8934,11189,11557,11874,12022,12028,12245,12941,12942,12943,12956,12957,12958,15165,15179,16366,16602,16613,16638,16689,16748,16767,16768,16826,17486,18009,18015,18277,18749,18754,18771,18772,18907,18960,19015,19017,19042,19194,19196,19197,19213,19244,19345,19372,19450,19497,19521,19532,19533,19562,19573,19722,20081,20092,20194,20250,20891,21083,21085,21113,22099,22271,23802,24054,24147,24188,24341,24356,24843,24935,24995,25010,25019,25034,25051,25082,26374,26474,26720,26939,26941,27012,27021,27026,27043,27057,27063,27070,27132,27146,27184,27195,27938,28692,28718,28726,28794,28798,28806,28810,28831,28872,29208,29270,29277,29288,30311,30345,30438,30825,31115,32477,32639,32641,33596,33601,33669", -- Rune Thread
	[14342]="0:4000:7:1:20:Cloth:165,197:1:0:", -- Mooncloth
	[14343]="0:0:7:3:20:Enchanting:333:1:0:", -- Small Brilliant Shard
	[14344]="0:0:7:3:20:Enchanting:333,197:1:0:", -- Large Brilliant Shard
	[14364]="0:325:4:2:1:Cloth::1:0:", -- Mystic's Slippers
	[14365]="0:214:4:2:1:Cloak::1:0:", -- Mystic's Cape
	[14366]="0:189:4:2:1:Cloth::1:0:", -- Mystic's Bracelets
	[14367]="0:252:4:2:1:Cloth::1:0:", -- Mystic's Gloves
	[14368]="0:346:4:1:1:Cloth::1:0:", -- Mystic's Shoulder Pads
	[14369]="0:809:4:2:1:Cloth::1:0:", -- Mystic's Wrap
	[14370]="0:473:4:2:1:Cloth::1:0:", -- Mystic's Woolies
	[14371]="0:816:4:2:1:Cloth::1:0:", -- Mystic's Robe
	[14372]="0:1430:4:2:1:Cloth::1:0:", -- Sanguine Armor
	[14373]="0:525:4:2:1:Cloth::1:0:", -- Sanguine Belt
	[14374]="0:699:4:2:1:Cloth::1:0:", -- Sanguine Sandals
	[14375]="0:528:4:2:1:Cloth::1:0:", -- Sanguine Cuffs
	[14376]="0:552:4:2:1:Cloak::1:0:", -- Sanguine Cape
	[14377]="0:602:4:2:1:Cloth::1:0:", -- Sanguine Handwraps
	[14378]="0:997:4:2:1:Cloth::1:0:", -- Sanguine Mantle
	[14379]="0:1615:4:2:1:Cloth::1:0:", -- Sanguine Trousers
	[14380]="0:1473:4:2:1:Cloth::1:0:", -- Sanguine Robe
	[14381]="0:0:12:1:1:::1:0:", -- Grimtotem Satchel
	[14395]="0:0:12:1:1:::1:0:", -- Spells of Shadow
	[14396]="0:0:12:1:1:::1:0:", -- Incantations from the Nether
	[14397]="0:1600:4:2:1:Cloth::1:0:", -- Resilient Mantle
	[14398]="0:2355:4:2:1:Cloth::1:0:", -- Resilient Tunic
	[14399]="0:1465:4:2:1:Cloth::1:0:", -- Resilient Boots
	[14400]="0:1215:4:2:1:Cloak::1:0:", -- Resilient Cape
	[14401]="0:1786:4:2:1:Cloth::1:0:", -- Resilient Cap
	[14402]="0:838:4:2:1:Cloth::1:0:", -- Resilient Bands
	[14403]="0:1017:4:2:1:Cloth::1:0:", -- Resilient Handgrips
	[14404]="0:2472:4:2:1:Cloth::1:0:", -- Resilient Leggings
	[14405]="0:2480:4:2:1:Cloth::1:0:", -- Resilient Robe
	[14406]="0:935:4:2:1:Cloth::1:0:", -- Resilient Cord
	[14407]="0:4266:4:2:1:Cloth::1:0:", -- Stonecloth Vest
	[14408]="0:2275:4:2:1:Cloth::1:0:", -- Stonecloth Boots
	[14409]="0:1707:4:2:1:Cloak::1:0:", -- Stonecloth Cape
	[14410]="0:2710:4:2:1:Cloth::1:0:", -- Stonecloth Circlet
	[14411]="0:1387:4:2:1:Cloth::1:0:", -- Stonecloth Gloves
	[14412]="0:2298:4:2:1:Cloth::1:0:", -- Stonecloth Epaulets
	[14413]="0:3947:4:2:1:Cloth::1:0:", -- Stonecloth Robe
	[14414]="0:1276:4:2:1:Cloth::1:0:", -- Stonecloth Belt
	[14415]="0:3410:4:2:1:Cloth::1:0:", -- Stonecloth Britches
	[14416]="0:1285:4:2:1:Cloth::1:0:", -- Stonecloth Bindings
	[14417]="0:5888:4:2:1:Cloth::1:0:", -- Silksand Tunic
	[14418]="0:3098:4:2:1:Cloth::1:0:", -- Silksand Boots
	[14419]="0:1919:4:2:1:Cloth::1:0:", -- Silksand Bracers
	[14420]="0:2889:4:2:1:Cloak::1:0:", -- Silksand Cape
	[14421]="0:3945:4:2:1:Cloth::1:0:", -- Silksand Circlet
	[14422]="0:2263:4:2:1:Cloth::1:0:", -- Silksand Gloves
	[14423]="0:3406:4:2:1:Cloth::1:0:", -- Silksand Shoulder Pads
	[14424]="0:5316:4:2:1:Cloth::1:0:", -- Silksand Legwraps
	[14425]="0:6223:4:2:1:Cloth::1:0:", -- Silksand Wraps
	[14426]="0:2125:4:2:1:Cloth::1:0:", -- Silksand Girdle
	[14427]="0:9124:4:2:1:Cloth::1:0:", -- Windchaser Wraps
	[14428]="0:4717:4:2:1:Cloth::1:0:", -- Windchaser Footpads
	[14429]="0:2644:4:2:1:Cloth::1:0:", -- Windchaser Cuffs
	[14430]="0:3686:4:2:1:Cloak::1:0:", -- Windchaser Cloak
	[14431]="0:2877:4:2:1:Cloth::1:0:", -- Windchaser Handguards
	[14432]="0:4679:4:2:1:Cloth::1:0:", -- Windchaser Amice
	[14433]="0:6764:4:2:1:Cloth::1:0:", -- Windchaser Woolies
	[14434]="0:8706:4:2:1:Cloth::1:0:", -- Windchaser Robes
	[14435]="0:2778:4:2:1:Cloth::1:0:", -- Windchaser Cinch
	[14436]="0:5270:4:2:1:Cloth::1:0:", -- Windchaser Coronet
	[14437]="0:12002:4:2:1:Cloth::1:0:", -- Venomshroud Vest
	[14438]="0:6192:4:2:1:Cloth::1:0:", -- Venomshroud Boots
	[14439]="0:3836:4:2:1:Cloth::1:0:", -- Venomshroud Armguards
	[14440]="0:5347:4:2:1:Cloak::1:0:", -- Venomshroud Cape
	[14441]="0:7167:4:2:1:Cloth::1:0:", -- Venomshroud Mask
	[14442]="0:4481:4:2:1:Cloth::1:0:", -- Venomshroud Mitts
	[14443]="0:6745:4:2:1:Cloth::1:0:", -- Venomshroud Mantle
	[14444]="0:10955:4:2:1:Cloth::1:0:", -- Venomshroud Leggings
	[14445]="0:12353:4:2:1:Cloth::1:0:", -- Venomshroud Silk Robes
	[14446]="0:4248:4:2:1:Cloth::1:0:", -- Venomshroud Belt
	[14447]="0:8801:4:2:1:Cloth::1:0:", -- Highborne Footpads
	[14448]="0:5555:4:2:1:Cloth::1:0:", -- Highborne Bracelets
	[14449]="0:10125:4:2:1:Cloth::1:0:", -- Highborne Crown
	[14450]="0:7364:4:2:1:Cloak::1:0:", -- Highborne Cloak
	[14451]="0:5537:4:2:1:Cloth::1:0:", -- Highborne Gloves
	[14452]="0:8836:4:2:1:Cloth::1:0:", -- Highborne Pauldrons
	[14453]="0:15677:4:2:1:Cloth::1:0:", -- Highborne Robes
	[14454]="0:5598:4:2:1:Cloth::1:0:", -- Highborne Cord
	[14455]="0:15792:4:2:1:Cloth::1:0:", -- Highborne Padded Armor
	[14456]="0:17574:4:2:1:Cloth::1:0:", -- Elunarian Vest
	[14457]="0:7575:4:2:1:Cloth::1:0:", -- Elunarian Cuffs
	[14458]="0:12573:4:2:1:Cloth::1:0:", -- Elunarian Boots
	[14459]="0:10798:4:2:1:Cloak::1:0:", -- Elunarian Cloak
	[14460]="0:13196:4:2:1:Cloth::1:0:", -- Elunarian Diadem
	[14461]="0:8711:4:2:1:Cloth::1:0:", -- Elunarian Handgrips
	[14462]="0:17483:4:2:1:Cloth::1:0:", -- Elunarian Sarong
	[14463]="0:13160:4:2:1:Cloth::1:0:", -- Elunarian Spaulders
	[14464]="0:18088:4:2:1:Cloth::1:0:", -- Elunarian Silk Robes
	[14465]="0:8596:4:2:1:Cloth::1:0:", -- Elunarian Belt
	[14466]="0:3000:9:2:1:Tailoring::1:0:", -- Pattern: Frostweave Tunic
	[14467]="0:3000:9:2:1:Tailoring::1:0:", -- Pattern: Frostweave Robe
	[14468]="12000:3000:9:1:1:Tailoring::1:1:11189", -- Pattern: Runecloth Bag
	[14469]="12000:3000:9:1:1:Tailoring::1:1:7940", -- Pattern: Runecloth Robe
	[14470]="0:3000:9:2:1:Tailoring::1:0:", -- Pattern: Runecloth Tunic
	[14471]="0:3000:9:2:1:Tailoring::1:0:", -- Pattern: Cindercloth Vest
	[14472]="12000:3000:9:1:1:Tailoring::1:1:7940", -- Pattern: Runecloth Cloak
	[14473]="0:3000:9:2:1:Tailoring::1:0:", -- Pattern: Ghostweave Belt
	[14474]="0:3000:9:2:1:Tailoring::1:0:", -- Pattern: Frostweave Gloves
	[14476]="0:3500:9:2:1:Tailoring::1:0:", -- Pattern: Cindercloth Gloves
	[14477]="0:3500:9:2:1:Tailoring::1:0:", -- Pattern: Ghostweave Gloves
	[14478]="0:3500:9:2:1:Tailoring::1:0:", -- Pattern: Brightcloth Robe
	[14479]="0:3500:9:2:1:Tailoring::1:0:", -- Pattern: Brightcloth Gloves
	[14480]="0:4000:9:2:1:Tailoring::1:0:", -- Pattern: Ghostweave Vest
	[14481]="0:4000:9:1:1:Tailoring::1:0:", -- Pattern: Runecloth Gloves
	[14482]="0:4000:9:2:1:Tailoring::1:0:", -- Pattern: Cindercloth Cloak
	[14483]="16000:4000:9:1:1:Tailoring::1:1:12022", -- Pattern: Felcloth Pants
	[14484]="0:4000:9:2:1:Tailoring::1:0:", -- Pattern: Brightcloth Cloak
	[14485]="0:4000:9:2:1:Tailoring::1:0:", -- Pattern: Wizardweave Leggings
	[14486]="0:10000:9:3:1:Tailoring::1:0:", -- Pattern: Cloak of Fire
	[14487]="0:49623:2:3:1:OneHandMace::1:0:", -- Bonechill Hammer
	[14488]="0:5000:9:1:1:Tailoring::1:0:", -- Pattern: Runecloth Boots
	[14489]="0:5000:9:2:1:Tailoring::1:0:", -- Pattern: Frostweave Pants
	[14490]="0:5000:9:2:1:Tailoring::1:0:", -- Pattern: Cindercloth Pants
	[14491]="0:5000:9:2:1:Tailoring::1:0:", -- Pattern: Runecloth Pants
	[14492]="0:5000:9:2:1:Tailoring::1:0:", -- Pattern: Felcloth Boots
	[14493]="0:5000:9:3:1:Tailoring::1:0:", -- Pattern: Robe of Winter Night
	[14494]="0:5500:9:2:1:Tailoring::1:0:", -- Pattern: Brightcloth Pants
	[14495]="0:5500:9:2:1:Tailoring::1:0:", -- Pattern: Ghostweave Pants
	[14496]="0:5500:9:2:1:Tailoring::1:0:", -- Pattern: Felcloth Hood
	[14497]="0:5500:9:3:1:Tailoring::1:0:", -- Pattern: Mooncloth Leggings
	[14498]="0:6250:9:2:1:Tailoring::1:0:", -- Pattern: Runecloth Headband
	[14499]="0:7500:9:2:1:Tailoring::1:0:", -- Pattern: Mooncloth Bag
	[14500]="0:7500:9:2:1:Tailoring::1:0:", -- Pattern: Wizardweave Robe
	[14501]="0:7500:9:3:1:Tailoring::1:0:", -- Pattern: Mooncloth Vest
	[14502]="0:12169:4:3:1:Leather::1:0:", -- Frostbite Girdle
	[14503]="0:18323:4:3:1:Leather::1:0:", -- Death's Clutch
	[14504]="0:10000:9:2:1:Tailoring::1:0:", -- Pattern: Runecloth Shoulders
	[14505]="0:10000:9:2:1:Tailoring::1:0:", -- Pattern: Wizardweave Turban
	[14506]="0:10000:9:2:1:Tailoring::1:0:", -- Pattern: Felcloth Robe
	[14507]="0:10000:9:3:1:Tailoring::1:0:", -- Pattern: Mooncloth Shoulders
	[14508]="0:15000:9:2:1:Tailoring::1:0:", -- Pattern: Felcloth Shoulders
	[14509]="0:15000:9:3:1:Tailoring::1:0:", -- Pattern: Mooncloth Circlet
	[14510]="0:15000:9:3:1:Tailoring::1:0:", -- Pattern: Bottomless Bag
	[14511]="0:15000:9:4:1:Tailoring::1:0:", -- Pattern: Gloves of Spell Mastery
	[14512]="0:15000:9:4:1:Tailoring::1:0:", -- Pattern: Truefaith Vestments
	[14513]="0:15000:9:4:1:Tailoring::1:0:", -- Pattern: Robe of the Archmage
	[14514]="0:15000:9:4:1:Tailoring::1:0:", -- Pattern: Robe of the Void
	[14522]="0:29200:4:3:1:Mail::1:0:", -- Maelstrom Leggings
	[14523]="0:0:12:1:1:::1:0:", -- Demon Pick
	[14525]="0:17330:4:3:1:Plate::1:0:", -- Boneclenched Gauntlets
	[14526]="20000:5000:9:1:1:Tailoring::1:0:11189", -- Pattern: Mooncloth
	[14528]="0:31870:4:3:1:Shield::1:0:", -- Rattlecage Buckler
	[14529]="0:425:0:1:20:Bandage::1:0:", -- Runecloth Bandage
	[14530]="4000:1000:0:1:20:Bandage::1:1:15471", -- Heavy Runecloth Bandage
	[14531]="0:59891:2:3:1:TwoHandMace::1:0:", -- Frightskull Shaft
	[14536]="0:31164:4:3:1:Mail::1:0:", -- Bonebrace Hauberk
	[14537]="0:27688:4:3:1:Plate::1:0:", -- Corpselight Greaves
	[14538]="0:15908:4:3:1:Cloth::1:0:", -- Deadwalker Mantle
	[14539]="0:19956:4:3:1:Leather::1:0:", -- Bone Ring Helm
	[14540]="0:0:12:1:1:::1:0:", -- Taragaman the Hungerer's Heart
	[14541]="0:66079:2:3:1:TwoHandSword::1:0:", -- Barovian Family Sword
	[14542]="0:0:12:1:1:::1:0:", -- Kravel's Crate
	[14543]="0:9770:4:3:1:Cloth::1:0:", -- Darkshade Gloves
	[14544]="0:0:12:1:1:::1:0:", -- Lieutenant's Insignia
	[14545]="0:24612:4:3:1:Leather::1:0:", -- Ghostloom Leggings
	[14546]="0:0:12:1:1:::1:0:", -- Roon's Kodo Horn
	[14547]="0:0:12:1:1:::1:0:", -- Hand of Iruxos
	[14548]="0:23116:4:3:1:Mail::1:0:", -- Royal Cap Spaulders
	[14549]="0:13637:4:4:1:Plate::1:0:", -- Boots of Avoidance
	[14551]="0:10601:4:4:1:Mail::1:0:", -- Edgemaster's Handguards
	[14552]="0:26860:4:4:1:Plate::1:0:", -- Stockade Pauldrons
	[14553]="0:17125:4:4:1:Leather::1:0:", -- Sash of Mercy
	[14554]="0:48787:4:4:1:Plate::1:0:", -- Cloudkeeper Legplates
	[14555]="0:70900:2:4:1:Dagger::1:0:", -- Alcor's Sunrazor
	[14557]="0:17880:4:4:1:Trinket::1:0:", -- The Lion Horn of Stormwind
	[14558]="0:10500:4:4:1:Amulet::1:0:", -- Lady Maye's Pendant
	[14559]="0:279:4:2:1:Leather::1:0:", -- Prospector's Sash
	[14560]="0:484:4:2:1:Leather::1:0:", -- Prospector's Boots
	[14561]="0:245:4:2:1:Leather::1:0:", -- Prospector's Cuffs
	[14562]="0:1039:4:2:1:Leather::1:0:", -- Prospector's Chestpiece
	[14563]="0:275:4:2:1:Cloak::1:0:", -- Prospector's Cloak
	[14564]="0:304:4:2:1:Leather::1:0:", -- Prospector's Mitts
	[14565]="0:809:4:2:1:Leather::1:0:", -- Prospector's Woolies
	[14566]="0:1010:4:2:1:Leather::1:0:", -- Prospector's Pads
	[14567]="0:529:4:2:1:Leather::1:0:", -- Bristlebark Belt
	[14568]="0:797:4:2:1:Leather::1:0:", -- Bristlebark Boots
	[14569]="0:472:4:2:1:Leather::1:0:", -- Bristlebark Bindings
	[14570]="0:1870:4:2:1:Leather::1:0:", -- Bristlebark Blouse
	[14571]="0:496:4:2:1:Cloak::1:0:", -- Bristlebark Cape
	[14572]="0:609:4:2:1:Leather::1:0:", -- Bristlebark Gloves
	[14573]="0:1289:4:2:1:Leather::1:0:", -- Bristlebark Amice
	[14574]="0:1568:4:2:1:Leather::1:0:", -- Bristlebark Britches
	[14576]="0:48770:2:3:1:OneHandSword::1:0:", -- Ebon Hilt of Marduk
	[14577]="0:20844:4:3:1:Cloth::1:0:", -- Skullsmoke Pants
	[14578]="0:983:4:2:1:Leather::1:0:", -- Dokebi Cord
	[14579]="0:1791:4:2:1:Leather::1:0:", -- Dokebi Boots
	[14580]="0:818:4:2:1:Leather::1:0:", -- Dokebi Bracers
	[14581]="0:2912:4:2:1:Leather::1:0:", -- Dokebi Chestguard
	[14582]="0:1089:4:2:1:Cloak::1:0:", -- Dokebi Cape
	[14583]="0:1333:4:2:1:Leather::1:0:", -- Dokebi Gloves
	[14584]="0:2673:4:2:1:Leather::1:0:", -- Dokebi Hat
	[14585]="0:2687:4:2:1:Leather::1:0:", -- Dokebi Leggings
	[14587]="0:2030:4:2:1:Leather::1:0:", -- Dokebi Mantle
	[14588]="0:1989:4:2:1:Leather::1:0:", -- Hawkeye's Cord
	[14589]="0:3294:4:2:1:Leather::1:0:", -- Hawkeye's Shoes
	[14590]="0:1821:4:2:1:Leather::1:0:", -- Hawkeye's Bracers
	[14591]="0:4180:4:2:1:Leather::1:0:", -- Hawkeye's Helm
	[14592]="0:5594:4:2:1:Leather::1:0:", -- Hawkeye's Tunic
	[14593]="0:2210:4:2:1:Cloak::1:0:", -- Hawkeye's Cloak
	[14594]="0:2236:4:2:1:Leather::1:0:", -- Hawkeye's Gloves
	[14595]="0:4500:4:2:1:Leather::1:0:", -- Hawkeye's Breeches
	[14596]="0:3388:4:2:1:Leather::1:0:", -- Hawkeye's Epaulets
	[14598]="0:2655:4:2:1:Leather::1:0:", -- Warden's Waistband
	[14599]="0:4663:4:2:1:Leather::1:0:", -- Warden's Footpads
	[14600]="0:2675:4:2:1:Leather::1:0:", -- Warden's Wristbands
	[14601]="0:7307:4:2:1:Leather::1:0:", -- Warden's Wraps
	[14602]="0:2995:4:2:1:Cloak::1:0:", -- Warden's Cloak
	[14603]="0:4383:4:2:1:Leather::1:0:", -- Warden's Mantle
	[14604]="0:5986:4:2:1:Leather::1:0:", -- Warden's Wizard Hat
	[14605]="0:6868:4:2:1:Leather::1:0:", -- Warden's Woolies
	[14606]="0:2955:4:2:1:Leather::1:0:", -- Warden's Gloves
	[14607]="0:5581:4:2:1:Shield::1:0:", -- Hawkeye's Buckler
	[14608]="0:3162:4:2:1:Shield::1:0:", -- Dokebi Buckler
	[14610]="0:0:12:1:1:::1:0:", -- Araj's Scarab
	[14611]="0:31394:4:3:1:Mail::1:0:", -- Bloodmail Hauberk
	[14612]="0:31503:4:3:1:Mail::1:0:", -- Bloodmail Legguards
	[14613]="0:0:12:1:1:::1:0:", -- Taelan's Hammer
	[14614]="0:15863:4:3:1:Mail::1:0:", -- Bloodmail Belt
	[14615]="0:14404:4:3:1:Mail::1:0:", -- Bloodmail Gauntlets
	[14616]="0:21785:4:3:1:Mail::1:0:", -- Bloodmail Boots
	[14617]="0:6250:4:1:1:Shirt::1:0:", -- Sawbones Shirt
	[14619]="0:0:12:1:20:::1:0:", -- Skeletal Fragments
	[14620]="0:17226:4:3:1:Plate::1:0:", -- Deathbone Girdle
	[14621]="0:25741:4:3:1:Plate::1:0:", -- Deathbone Sabatons
	[14622]="0:17357:4:3:1:Plate::1:0:", -- Deathbone Gauntlets
	[14623]="0:34649:4:3:1:Plate::1:0:", -- Deathbone Legguards
	[14624]="0:34776:4:3:1:Plate::1:0:", -- Deathbone Chestplate
	[14625]="0:0:12:1:1:::1:0:", -- Symbol of Lost Honor
	[14626]="0:20021:4:3:1:Cloth::1:0:", -- Necropile Robe
	[14627]="800:200:9:1:1:Tailoring::1:1:2668", -- Pattern: Bright Yellow Shirt
	[14628]="0:0:12:1:1:::1:0:", -- Imbued Skeletal Fragments
	[14629]="0:10389:4:3:1:Cloth::1:0:", -- Necropile Cuffs
	[14630]="1000:250:9:1:1:Tailoring::1:1:2670", -- Pattern: Enchanter's Cowl
	[14631]="0:15694:4:3:1:Cloth::1:0:", -- Necropile Boots
	[14632]="0:21000:4:3:1:Cloth::1:0:", -- Necropile Leggings
	[14633]="0:15806:4:3:1:Cloth::1:0:", -- Necropile Mantle
	[14634]="2500:625:9:2:1:Alchemy::1:1:2480", -- Recipe: Frost Oil
	[14635]="0:750:9:1:1:Leatherworking::1:0:", -- Pattern: Gem-studded Leather Belt
	[14636]="0:12048:4:3:1:Leather::1:0:", -- Cadaverous Belt
	[14637]="0:24189:4:3:1:Leather::1:0:", -- Cadaverous Armor
	[14638]="0:24282:4:3:1:Leather::1:0:", -- Cadaverous Leggings
	[14639]="1500:375:9:1:1:Engineering::1:1:2682,3495", -- Schematic: Minor Recombobulator
	[14640]="0:12233:4:3:1:Leather::1:0:", -- Cadaverous Gloves
	[14641]="0:18420:4:3:1:Leather::1:0:", -- Cadaverous Walkers
	[14644]="0:0:12:1:1:::1:0:", -- Skeleton Key Mold
	[14645]="0:0:12:1:1:::1:0:", -- Unfinished Skeleton Key
	[14646]="0:0:12:1:1:::1:0:", -- Goldshire Gift Voucher
	[14647]="0:0:12:1:1:::1:0:", -- Kharanos Gift Voucher
	[14648]="0:0:12:1:1:::1:0:", -- Dolanaar Gift Voucher
	[14649]="0:0:12:1:1:::1:0:", -- Razor Hill Gift Voucher
	[14650]="0:0:12:1:1:::1:0:", -- Bloodhoof Village Gift Voucher
	[14651]="0:0:12:1:1:::1:0:", -- Brill Gift Voucher
	[14652]="0:4216:4:2:1:Leather::1:0:", -- Scorpashi Sash
	[14653]="0:6854:4:2:1:Leather::1:0:", -- Scorpashi Slippers
	[14654]="0:3931:4:2:1:Leather::1:0:", -- Scorpashi Wristbands
	[14655]="0:10392:4:2:1:Leather::1:0:", -- Scorpashi Breastplate
	[14656]="0:4300:4:2:1:Cloak::1:0:", -- Scorpashi Cape
	[14657]="0:4195:4:2:1:Leather::1:0:", -- Scorpashi Gloves
	[14658]="0:7884:4:2:1:Leather::1:0:", -- Scorpashi Skullcap
	[14659]="0:9382:4:2:1:Leather::1:0:", -- Scorpashi Leggings
	[14660]="0:7063:4:2:1:Leather::1:0:", -- Scorpashi Shoulder Pads
	[14661]="0:5461:4:2:1:Leather::1:0:", -- Keeper's Cord
	[14662]="0:9413:4:2:1:Leather::1:0:", -- Keeper's Hooves
	[14663]="0:5141:4:2:1:Leather::1:0:", -- Keeper's Bindings
	[14664]="0:15058:4:2:1:Leather::1:0:", -- Keeper's Armor
	[14665]="0:6214:4:2:1:Cloak::1:0:", -- Keeper's Cloak
	[14666]="0:6367:4:2:1:Leather::1:0:", -- Keeper's Gloves
	[14667]="0:10770:4:2:1:Leather::1:0:", -- Keeper's Wreath
	[14668]="0:13597:4:2:1:Leather::1:0:", -- Keeper's Woolies
	[14669]="0:9654:4:2:1:Leather::1:0:", -- Keeper's Mantle
	[14670]="0:20396:4:2:1:Leather::1:0:", -- Pridelord Armor
	[14671]="0:13012:4:2:1:Leather::1:0:", -- Pridelord Boots
	[14672]="0:7309:4:2:1:Leather::1:0:", -- Pridelord Bands
	[14673]="0:8303:4:2:1:Cloak::1:0:", -- Pridelord Cape
	[14674]="0:8270:4:2:1:Leather::1:0:", -- Pridelord Girdle
	[14675]="0:8182:4:2:1:Leather::1:0:", -- Pridelord Gloves
	[14676]="0:13841:4:2:1:Leather::1:0:", -- Pridelord Halo
	[14677]="0:18524:4:2:1:Leather::1:0:", -- Pridelord Pants
	[14678]="0:13156:4:2:1:Leather::1:0:", -- Pridelord Pauldrons
	[14679]="0:0:12:1:1:::1:0:", -- Of Love and Family
	[14680]="0:21805:4:2:1:Leather::1:0:", -- Indomitable Vest
	[14681]="0:15980:4:2:1:Leather::1:0:", -- Indomitable Boots
	[14682]="0:9906:4:2:1:Leather::1:0:", -- Indomitable Armguards
	[14683]="0:11932:4:2:1:Cloak::1:0:", -- Indomitable Cloak
	[14684]="0:10477:4:2:1:Leather::1:0:", -- Indomitable Belt
	[14685]="0:10810:4:2:1:Leather::1:0:", -- Indomitable Gauntlets
	[14686]="0:16495:4:2:1:Leather::1:0:", -- Indomitable Headdress
	[14687]="0:21778:4:2:1:Leather::1:0:", -- Indomitable Leggings
	[14688]="0:16168:4:2:1:Leather::1:0:", -- Indomitable Epaulets
	[14722]="0:424:4:2:1:Mail::1:0:", -- War Paint Anklewraps
	[14723]="0:290:4:2:1:Mail::1:0:", -- War Paint Bindings
	[14724]="0:253:4:2:1:Cloak::1:0:", -- War Paint Cloak
	[14725]="0:292:4:2:1:Mail::1:0:", -- War Paint Waistband
	[14726]="0:337:4:2:1:Mail::1:0:", -- War Paint Gloves
	[14727]="0:778:4:2:1:Mail::1:0:", -- War Paint Legguards
	[14728]="0:485:4:1:1:Mail::1:0:", -- War Paint Shoulder Pads
	[14729]="0:870:4:2:1:Shield::1:0:", -- War Paint Shield
	[14730]="0:1223:4:2:1:Mail::1:0:", -- War Paint Chestpiece
	[14742]="0:1118:4:2:1:Mail::1:0:", -- Hulking Boots
	[14743]="0:583:4:2:1:Mail::1:0:", -- Hulking Bands
	[14744]="0:2310:4:2:1:Mail::1:0:", -- Hulking Chestguard
	[14745]="0:444:4:2:1:Cloak::1:0:", -- Hulking Cloak
	[14746]="0:589:4:2:1:Mail::1:0:", -- Hulking Belt
	[14747]="0:668:4:2:1:Mail::1:0:", -- Hulking Gauntlets
	[14748]="0:1550:4:2:1:Mail::1:0:", -- Hulking Leggings
	[14749]="0:1325:4:2:1:Mail::1:0:", -- Hulking Spaulders
	[14750]="0:1068:4:2:1:Mail::1:0:", -- Slayer's Cuffs
	[14751]="0:3454:4:2:1:Mail::1:0:", -- Slayer's Surcoat
	[14752]="0:978:4:2:1:Cloak::1:0:", -- Slayer's Cape
	[14753]="0:2610:4:2:1:Mail::1:0:", -- Slayer's Skullcap
	[14754]="0:1193:4:2:1:Mail::1:0:", -- Slayer's Gloves
	[14755]="0:1118:4:2:1:Mail::1:0:", -- Slayer's Sash
	[14756]="0:1860:4:2:1:Mail::1:0:", -- Slayer's Slippers
	[14757]="0:3298:4:2:1:Mail::1:0:", -- Slayer's Pants
	[14758]="0:2267:4:2:1:Mail::1:0:", -- Slayer's Shoulderguards
	[14759]="0:2010:4:2:1:Mail::1:0:", -- Enduring Bracers
	[14760]="0:6263:4:2:1:Mail::1:0:", -- Enduring Breastplate
	[14761]="0:2024:4:2:1:Mail::1:0:", -- Enduring Belt
	[14762]="0:4074:4:2:1:Mail::1:0:", -- Enduring Boots
	[14763]="0:1685:4:2:1:Cloak::1:0:", -- Enduring Cape
	[14764]="0:2250:4:2:1:Mail::1:0:", -- Enduring Gauntlets
	[14765]="0:4428:4:2:1:Mail::1:0:", -- Enduring Circlet
	[14766]="0:5486:4:2:1:Mail::1:0:", -- Enduring Breeches
	[14767]="0:4478:4:2:1:Mail::1:0:", -- Enduring Pauldrons
	[14768]="0:8566:4:2:1:Mail::1:0:", -- Ravager's Armor
	[14769]="0:5554:4:2:1:Mail::1:0:", -- Ravager's Sandals
	[14770]="0:3172:4:2:1:Mail::1:0:", -- Ravager's Armguards
	[14771]="0:3030:4:2:1:Cloak::1:0:", -- Ravager's Cloak
	[14772]="0:3284:4:2:1:Mail::1:0:", -- Ravager's Handwraps
	[14773]="0:3052:4:2:1:Mail::1:0:", -- Ravager's Cord
	[14774]="0:6252:4:2:1:Mail::1:0:", -- Ravager's Crown
	[14775]="0:8367:4:2:1:Mail::1:0:", -- Ravager's Woolies
	[14776]="0:6326:4:2:1:Mail::1:0:", -- Ravager's Mantle
	[14777]="0:9710:4:2:1:Shield::1:0:", -- Ravager's Shield
	[14778]="0:4933:4:2:1:Mail::1:0:", -- Khan's Bindings
	[14779]="0:13347:4:2:1:Mail::1:0:", -- Khan's Chestpiece
	[14780]="0:14289:4:2:1:Shield::1:0:", -- Khan's Buckler
	[14781]="0:4617:4:2:1:Cloak::1:0:", -- Khan's Cloak
	[14782]="0:5004:4:2:1:Mail::1:0:", -- Khan's Gloves
	[14783]="0:5424:4:2:1:Mail::1:0:", -- Khan's Belt
	[14784]="0:8202:4:2:1:Mail::1:0:", -- Khan's Greaves
	[14785]="0:9558:4:2:1:Mail::1:0:", -- Khan's Helmet
	[14786]="0:11841:4:2:1:Mail::1:0:", -- Khan's Legguards
	[14787]="0:8323:4:2:1:Mail::1:0:", -- Khan's Mantle
	[14788]="0:6408:4:2:1:Mail::1:0:", -- Protector Armguards
	[14789]="0:17541:4:2:1:Mail::1:0:", -- Protector Breastplate
	[14790]="0:18781:4:2:1:Shield::1:0:", -- Protector Buckler
	[14791]="0:6056:4:2:1:Cloak::1:0:", -- Protector Cape
	[14792]="0:6960:4:2:1:Mail::1:0:", -- Protector Gauntlets
	[14793]="0:6985:4:2:1:Mail::1:0:", -- Protector Waistband
	[14794]="0:10563:4:2:1:Mail::1:0:", -- Protector Ankleguards
	[14795]="0:12690:4:2:1:Mail::1:0:", -- Protector Helm
	[14796]="0:16983:4:2:1:Mail::1:0:", -- Protector Legguards
	[14797]="0:11427:4:2:1:Mail::1:0:", -- Protector Pads
	[14798]="0:24037:4:2:1:Mail::1:0:", -- Bloodlust Breastplate
	[14799]="0:17308:4:2:1:Mail::1:0:", -- Bloodlust Boots
	[14800]="0:25826:4:2:1:Shield::1:0:", -- Bloodlust Buckler
	[14801]="0:8156:4:2:1:Cloak::1:0:", -- Bloodlust Cape
	[14802]="0:9749:4:2:1:Mail::1:0:", -- Bloodlust Gauntlets
	[14803]="0:9087:4:2:1:Mail::1:0:", -- Bloodlust Belt
	[14804]="0:16296:4:2:1:Mail::1:0:", -- Bloodlust Helm
	[14805]="0:20577:4:2:1:Mail::1:0:", -- Bloodlust Britches
	[14806]="0:15560:4:2:1:Mail::1:0:", -- Bloodlust Epaulets
	[14807]="0:8211:4:2:1:Mail::1:0:", -- Bloodlust Bracelets
	[14808]="0:11581:4:2:1:Mail::1:0:", -- Warstrike Belt
	[14809]="0:18905:4:2:1:Mail::1:0:", -- Warstrike Sabatons
	[14810]="0:11669:4:2:1:Mail::1:0:", -- Warstrike Armsplints
	[14811]="0:25972:4:2:1:Mail::1:0:", -- Warstrike Chestguard
	[14812]="0:27804:4:2:1:Shield::1:0:", -- Warstrike Buckler
	[14813]="0:10601:4:2:1:Cloak::1:0:", -- Warstrike Cape
	[14814]="0:19435:4:2:1:Mail::1:0:", -- Warstrike Helmet
	[14815]="0:12830:4:2:1:Mail::1:0:", -- Warstrike Gauntlets
	[14816]="0:25752:4:2:1:Mail::1:0:", -- Warstrike Legguards
	[14817]="0:19471:4:2:1:Mail::1:0:", -- Warstrike Shoulder Pads
	[14821]="0:9258:4:2:1:Plate::1:0:", -- Symbolic Breastplate
	[14825]="0:8595:4:2:1:Shield::1:0:", -- Symbolic Crest
	[14826]="0:4068:4:2:1:Plate::1:0:", -- Symbolic Gauntlets
	[14827]="0:4083:4:2:1:Plate::1:0:", -- Symbolic Belt
	[14828]="0:6590:4:2:1:Plate::1:0:", -- Symbolic Greaves
	[14829]="0:8837:4:2:1:Plate::1:0:", -- Symbolic Legplates
	[14830]="0:6640:4:2:1:Plate::1:0:", -- Symbolic Pauldrons
	[14831]="0:7197:4:2:1:Plate::1:0:", -- Symbolic Crown
	[14832]="0:4160:4:2:1:Plate::1:0:", -- Symbolic Vambraces
	[14833]="0:5260:4:2:1:Plate::1:0:", -- Tyrant's Gauntlets
	[14834]="0:4889:4:2:1:Plate::1:0:", -- Tyrant's Armguards
	[14835]="0:14337:4:2:1:Plate::1:0:", -- Tyrant's Chestpiece
	[14838]="0:5090:4:2:1:Plate::1:0:", -- Tyrant's Belt
	[14839]="0:8212:4:2:1:Plate::1:0:", -- Tyrant's Greaves
	[14840]="0:13869:4:2:1:Plate::1:0:", -- Tyrant's Legplates
	[14841]="0:7484:4:2:1:Plate::1:0:", -- Tyrant's Epaulets
	[14842]="0:12483:4:2:1:Shield::1:0:", -- Tyrant's Shield
	[14843]="0:8796:4:2:1:Plate::1:0:", -- Tyrant's Helm
	[14844]="0:20075:4:2:1:Plate::1:0:", -- Sunscale Chestguard
	[14846]="0:7981:4:2:1:Plate::1:0:", -- Sunscale Gauntlets
	[14847]="0:7487:4:2:1:Plate::1:0:", -- Sunscale Belt
	[14848]="0:11972:4:2:1:Plate::1:0:", -- Sunscale Sabatons
	[14849]="0:14448:4:2:1:Plate::1:0:", -- Sunscale Helmet
	[14850]="0:18275:4:2:1:Plate::1:0:", -- Sunscale Legplates
	[14851]="0:12954:4:2:1:Plate::1:0:", -- Sunscale Spaulders
	[14852]="0:19420:4:2:1:Shield::1:0:", -- Sunscale Shield
	[14853]="0:7346:4:2:1:Plate::1:0:", -- Sunscale Wristguards
	[14854]="0:28358:4:2:1:Plate::1:0:", -- Vanguard Breastplate
	[14855]="0:11444:4:2:1:Plate::1:0:", -- Vanguard Gauntlets
	[14856]="0:10835:4:2:1:Plate::1:0:", -- Vanguard Girdle
	[14857]="0:16185:4:2:1:Plate::1:0:", -- Vanguard Sabatons
	[14858]="0:20507:4:2:1:Plate::1:0:", -- Vanguard Headdress
	[14859]="0:25936:4:2:1:Plate::1:0:", -- Vanguard Legplates
	[14860]="0:18380:4:2:1:Plate::1:0:", -- Vanguard Pauldrons
	[14861]="0:8880:4:2:1:Plate::1:0:", -- Vanguard Vambraces
	[14862]="0:28887:4:2:1:Plate::1:0:", -- Warleader's Breastplate
	[14863]="0:13995:4:2:1:Plate::1:0:", -- Warleader's Gauntlets
	[14864]="0:13380:4:2:1:Plate::1:0:", -- Warleader's Belt
	[14865]="0:20993:4:2:1:Plate::1:0:", -- Warleader's Greaves
	[14866]="0:21662:4:2:1:Plate::1:0:", -- Warleader's Crown
	[14867]="0:29048:4:2:1:Plate::1:0:", -- Warleader's Leggings
	[14868]="0:22112:4:2:1:Plate::1:0:", -- Warleader's Shoulders
	[14869]="0:13336:4:2:1:Plate::1:0:", -- Warleader's Bracers
	[14872]="0:0:12:1:1:::1:0:", -- Tirion's Gift
	[14894]="0:0:0:1:1:Consumable::1:0:", -- Lily Root
	[14895]="0:8583:4:2:1:Plate::1:0:", -- Saltstone Surcoat
	[14896]="0:5970:4:2:1:Plate::1:0:", -- Saltstone Sabatons
	[14897]="0:4025:4:2:1:Plate::1:0:", -- Saltstone Gauntlets
	[14898]="0:4039:4:2:1:Plate::1:0:", -- Saltstone Girdle
	[14899]="0:6517:4:2:1:Plate::1:0:", -- Saltstone Helm
	[14900]="0:7521:4:2:1:Plate::1:0:", -- Saltstone Legplates
	[14901]="0:6104:4:2:1:Plate::1:0:", -- Saltstone Shoulder Pads
	[14902]="0:7482:4:2:1:Shield::1:0:", -- Saltstone Shield
	[14903]="0:3825:4:2:1:Plate::1:0:", -- Saltstone Armsplints
	[14904]="0:16179:4:2:1:Plate::1:0:", -- Brutish Breastplate
	[14905]="0:5662:4:2:1:Plate::1:0:", -- Brutish Gauntlets
	[14906]="0:5262:4:2:1:Plate::1:0:", -- Brutish Belt
	[14907]="0:10696:4:2:1:Plate::1:0:", -- Brutish Helmet
	[14908]="0:14342:4:2:1:Plate::1:0:", -- Brutish Legguards
	[14909]="0:8554:4:2:1:Plate::1:0:", -- Brutish Shoulders
	[14910]="0:5339:4:2:1:Plate::1:0:", -- Brutish Armguards
	[14911]="0:9305:4:2:1:Plate::1:0:", -- Brutish Boots
	[14912]="0:15232:4:2:1:Shield::1:0:", -- Brutish Shield
	[14913]="0:11698:4:2:1:Plate::1:0:", -- Jade Greaves
	[14914]="0:6318:4:2:1:Plate::1:0:", -- Jade Bracers
	[14915]="0:20246:4:2:1:Plate::1:0:", -- Jade Breastplate
	[14916]="0:17254:4:2:1:Shield::1:0:", -- Jade Deflector
	[14917]="0:6920:4:2:1:Plate::1:0:", -- Jade Gauntlets
	[14918]="0:6432:4:2:1:Plate::1:0:", -- Jade Belt
	[14919]="0:13480:4:2:1:Plate::1:0:", -- Jade Circlet
	[14920]="0:17053:4:2:1:Plate::1:0:", -- Jade Legplates
	[14921]="0:11191:4:2:1:Plate::1:0:", -- Jade Epaulets
	[14922]="0:14451:4:2:1:Plate::1:0:", -- Lofty Sabatons
	[14923]="0:8104:4:2:1:Plate::1:0:", -- Lofty Armguards
	[14924]="0:24555:4:2:1:Plate::1:0:", -- Lofty Breastplate
	[14925]="0:18448:4:2:1:Plate::1:0:", -- Lofty Helm
	[14926]="0:9852:4:2:1:Plate::1:0:", -- Lofty Gauntlets
	[14927]="0:9329:4:2:1:Plate::1:0:", -- Lofty Belt
	[14928]="0:22179:4:2:1:Plate::1:0:", -- Lofty Legguards
	[14929]="0:15719:4:2:1:Plate::1:0:", -- Lofty Shoulder Pads
	[14930]="0:22950:4:2:1:Shield::1:0:", -- Lofty Shield
	[14931]="0:30265:4:2:1:Plate::1:0:", -- Heroic Armor
	[14932]="0:20583:4:2:1:Plate::1:0:", -- Heroic Greaves
	[14933]="0:13876:4:2:1:Plate::1:0:", -- Heroic Gauntlets
	[14934]="0:11887:4:2:1:Plate::1:0:", -- Heroic Girdle
	[14935]="0:20760:4:2:1:Plate::1:0:", -- Heroic Skullcap
	[14936]="0:28227:4:2:1:Plate::1:0:", -- Heroic Legplates
	[14937]="0:19923:4:2:1:Plate::1:0:", -- Heroic Pauldrons
	[14938]="0:11387:4:2:1:Plate::1:0:", -- Heroic Bracers
	[14939]="0:11888:4:2:1:Plate::1:0:", -- Warbringer's Chestguard
	[14940]="0:7090:4:2:1:Plate::1:0:", -- Warbringer's Sabatons 
	[14941]="0:4427:4:2:1:Plate::1:0:", -- Warbringer's Armsplints
	[14942]="0:4443:4:2:1:Plate::1:0:", -- Warbringer's Gauntlets
	[14943]="0:4460:4:2:1:Plate::1:0:", -- Warbringer's Belt
	[14944]="0:8395:4:2:1:Plate::1:0:", -- Warbringer's Crown
	[14945]="0:11257:4:2:1:Plate::1:0:", -- Warbringer's Legguards
	[14946]="0:7251:4:2:1:Plate::1:0:", -- Warbringer's Spaulders
	[14947]="0:11198:4:2:1:Shield::1:0:", -- Warbringer's Shield
	[14948]="0:18028:4:2:1:Plate::1:0:", -- Bloodforged Chestpiece
	[14949]="0:6876:4:2:1:Plate::1:0:", -- Bloodforged Gauntlets
	[14950]="0:6390:4:2:1:Plate::1:0:", -- Bloodforged Belt
	[14951]="0:10309:4:2:1:Plate::1:0:", -- Bloodforged Sabatons
	[14952]="0:12792:4:2:1:Plate::1:0:", -- Bloodforged Helmet
	[14953]="0:16028:4:2:1:Plate::1:0:", -- Bloodforged Legplates
	[14954]="0:15234:4:2:1:Shield::1:0:", -- Bloodforged Shield
	[14955]="0:9463:4:2:1:Plate::1:0:", -- Bloodforged Shoulder Pads
	[14956]="0:5471:4:2:1:Plate::1:0:", -- Bloodforged Bindings
	[14957]="0:12617:4:2:1:Plate::1:0:", -- High Chief's Sabatons
	[14958]="0:22643:4:2:1:Plate::1:0:", -- High Chief's Armor
	[14959]="0:9052:4:2:1:Plate::1:0:", -- High Chief's Gauntlets
	[14960]="0:8572:4:2:1:Plate::1:0:", -- High Chief's Belt
	[14961]="0:16172:4:2:1:Plate::1:0:", -- High Chief's Crown
	[14962]="0:20458:4:2:1:Plate::1:0:", -- High Chief's Legguards
	[14963]="0:14501:4:2:1:Plate::1:0:", -- High Chief's Pauldrons
	[14964]="0:21741:4:2:1:Shield::1:0:", -- High Chief's Shield
	[14965]="0:7833:4:2:1:Plate::1:0:", -- High Chief's Bindings
	[14966]="0:30083:4:2:1:Plate::1:0:", -- Glorious Breastplate
	[14967]="0:12087:4:2:1:Plate::1:0:", -- Glorious Gauntlets
	[14968]="0:11444:4:2:1:Plate::1:0:", -- Glorious Belt
	[14969]="0:21381:4:2:1:Plate::1:0:", -- Glorious Headdress
	[14970]="0:27297:4:2:1:Plate::1:0:", -- Glorious Legplates
	[14971]="0:19346:4:2:1:Plate::1:0:", -- Glorious Shoulder Pads
	[14972]="0:18316:4:2:1:Plate::1:0:", -- Glorious Sabatons
	[14973]="0:27810:4:2:1:Shield::1:0:", -- Glorious Shield
	[14974]="0:10576:4:2:1:Plate::1:0:", -- Glorious Bindings
	[14975]="0:29662:4:2:1:Plate::1:0:", -- Exalted Harness
	[14976]="0:14191:4:2:1:Plate::1:0:", -- Exalted Gauntlets
	[14977]="0:14049:4:2:1:Plate::1:0:", -- Exalted Girdle
	[14978]="0:21873:4:2:1:Plate::1:0:", -- Exalted Sabatons
	[14979]="0:22251:4:2:1:Plate::1:0:", -- Exalted Helmet
	[14980]="0:30244:4:2:1:Plate::1:0:", -- Exalted Legplates
	[14981]="0:22417:4:2:1:Plate::1:0:", -- Exalted Epaulets
	[14982]="0:28601:4:2:1:Shield::1:0:", -- Exalted Shield
	[14983]="0:14054:4:2:1:Plate::1:0:", -- Exalted Armsplints
	[15002]="0:0:12:1:1:::1:0:", -- Nimboya's Pike
	[15003]="0:20:4:1:1:Leather::1:0:", -- Primal Belt
	[15004]="0:42:4:1:1:Leather::1:0:", -- Primal Boots
	[15005]="0:28:4:1:1:Leather::1:0:", -- Primal Bands
	[15006]="0:73:4:1:1:Shield::1:0:", -- Primal Buckler
	[15007]="0:24:4:1:1:Cloak::1:0:", -- Primal Cape
	[15008]="0:37:4:1:1:Leather::1:0:", -- Primal Mitts
	[15009]="0:162:4:2:1:Leather::1:0:", -- Primal Leggings
	[15010]="0:163:4:2:1:Leather::1:0:", -- Primal Wraps
	[15011]="0:184:4:2:1:Leather::1:0:", -- Lupine Cord
	[15012]="0:296:4:2:1:Leather::1:0:", -- Lupine Slippers
	[15013]="0:86:4:1:1:Leather::1:0:", -- Lupine Cuffs
	[15014]="0:585:4:2:1:Shield::1:0:", -- Lupine Buckler
	[15015]="0:86:4:1:1:Cloak::1:0:", -- Lupine Cloak
	[15016]="0:200:4:2:1:Leather::1:0:", -- Lupine Handwraps
	[15017]="0:611:4:2:1:Leather::1:0:", -- Lupine Leggings
	[15018]="0:706:4:2:1:Leather::1:0:", -- Lupine Vest
	[15019]="0:366:4:1:1:Leather::1:0:", -- Lupine Mantle
	[15042]="0:0:12:1:1:::1:0:", -- Empty Termite Jar
	[15043]="0:0:12:1:100:::1:0:", -- Plagueland Termites
	[15044]="0:0:12:1:1:::1:0:", -- Barrel of Plagueland Termites
	[15045]="0:19938:4:3:1:Mail::1:0:", -- Green Dragonscale Breastplate
	[15046]="0:22482:4:3:1:Mail::1:0:", -- Green Dragonscale Leggings
	[15047]="0:28812:4:3:1:Mail::1:0:", -- Red Dragonscale Breastplate
	[15048]="0:24409:4:3:1:Mail::1:0:", -- Blue Dragonscale Breastplate
	[15049]="0:20543:4:3:1:Mail::1:0:", -- Blue Dragonscale Shoulders
	[15050]="0:26071:4:3:1:Mail::1:0:", -- Black Dragonscale Breastplate
	[15051]="0:21736:4:3:1:Mail::1:0:", -- Black Dragonscale Shoulders
	[15052]="0:28964:4:3:1:Mail::1:0:", -- Black Dragonscale Leggings
	[15053]="0:17275:4:2:1:Leather::1:0:", -- Volcanic Breastplate
	[15054]="0:14559:4:2:1:Leather::1:0:", -- Volcanic Leggings
	[15055]="0:15470:4:2:1:Leather::1:0:", -- Volcanic Shoulders
	[15056]="0:20966:4:3:1:Leather::1:0:", -- Stormshroud Armor
	[15057]="0:18728:4:3:1:Leather::1:0:", -- Stormshroud Pants
	[15058]="0:17631:4:3:1:Leather::1:0:", -- Stormshroud Shoulders
	[15059]="0:24776:4:3:1:Leather::1:0:", -- Living Breastplate
	[15060]="0:21277:4:3:1:Leather::1:0:", -- Living Leggings
	[15061]="0:13803:4:3:1:Leather::1:0:", -- Living Shoulders
	[15062]="0:25709:4:3:1:Leather::1:0:", -- Devilsaur Leggings
	[15063]="0:11701:4:3:1:Leather::1:0:", -- Devilsaur Gauntlets
	[15064]="0:19717:4:3:1:Leather::1:0:", -- Warbear Harness
	[15065]="0:22233:4:3:1:Leather::1:0:", -- Warbear Woolies
	[15066]="0:23650:4:3:1:Leather::1:0:", -- Ironfeather Breastplate
	[15067]="0:12758:4:3:1:Leather::1:0:", -- Ironfeather Shoulders
	[15068]="0:20359:4:2:1:Leather::1:0:", -- Frostsaber Tunic
	[15069]="0:17013:4:2:1:Leather::1:0:", -- Frostsaber Leggings
	[15070]="0:9504:4:2:1:Leather::1:0:", -- Frostsaber Gloves
	[15071]="0:11443:4:2:1:Leather::1:0:", -- Frostsaber Boots
	[15072]="0:16234:4:2:1:Leather::1:0:", -- Chimeric Leggings
	[15073]="0:11530:4:2:1:Leather::1:0:", -- Chimeric Boots
	[15074]="0:6867:4:2:1:Leather::1:0:", -- Chimeric Gloves
	[15075]="0:18449:4:2:1:Leather::1:0:", -- Chimeric Vest
	[15076]="0:16604:4:2:1:Mail::1:0:", -- Heavy Scorpid Vest
	[15077]="0:7615:4:2:1:Mail::1:0:", -- Heavy Scorpid Bracers
	[15078]="0:9649:4:2:1:Mail::1:0:", -- Heavy Scorpid Gauntlets
	[15079]="0:21760:4:2:1:Mail::1:0:", -- Heavy Scorpid Leggings
	[15080]="0:18230:4:2:1:Mail::1:0:", -- Heavy Scorpid Helm
	[15081]="0:19566:4:2:1:Mail::1:0:", -- Heavy Scorpid Shoulders
	[15082]="0:10375:4:2:1:Mail::1:0:", -- Heavy Scorpid Belt
	[15083]="0:6872:4:2:1:Leather::1:0:", -- Wicked Leather Gauntlets
	[15084]="0:7311:4:2:1:Leather::1:0:", -- Wicked Leather Bracers
	[15085]="0:21952:4:2:1:Leather::1:0:", -- Wicked Leather Armor
	[15086]="0:13154:4:2:1:Leather::1:0:", -- Wicked Leather Headband
	[15087]="0:17892:4:2:1:Leather::1:0:", -- Wicked Leather Pants
	[15088]="0:9901:4:2:1:Leather::1:0:", -- Wicked Leather Belt
	[15090]="0:20514:4:2:1:Leather::1:0:", -- Runic Leather Armor
	[15091]="0:7195:4:2:1:Leather::1:0:", -- Runic Leather Gauntlets
	[15092]="0:7656:4:2:1:Leather::1:0:", -- Runic Leather Bracers
	[15093]="0:8368:4:2:1:Leather::1:0:", -- Runic Leather Belt
	[15094]="0:14155:4:2:1:Leather::1:0:", -- Runic Leather Headband
	[15095]="0:20885:4:2:1:Leather::1:0:", -- Runic Leather Pants
	[15096]="0:16161:4:2:1:Leather::1:0:", -- Runic Leather Shoulders
	[15102]="0:0:15:1:1:Junk::1:0:", -- Un'Goro Tested Sample
	[15103]="0:0:15:1:1:Junk::1:0:", -- Corrupt Tested Sample
	[15104]="0:3825:4:3:1:Cloth::1:0:", -- Wingborne Boots
	[15105]="0:14397:2:2:1:Stave::1:0:", -- Staff of Noh'Orahil
	[15106]="0:14447:2:2:1:Stave::1:0:", -- Staff of Dar'Orahil
	[15107]="0:5000:4:3:1:OffHandFrill::1:0:", -- Orb of Noh'Orahil
	[15108]="0:5000:4:3:1:OffHandFrill::1:0:", -- Orb of Dar'Orahil
	[15109]="0:3344:2:2:1:Stave::1:0:", -- Staff of Soran'ruk
	[15110]="0:351:4:2:1:Leather::1:0:", -- Rigid Belt
	[15111]="0:609:4:2:1:Leather::1:0:", -- Rigid Moccasins
	[15112]="0:354:4:2:1:Leather::1:0:", -- Rigid Bracelets
	[15113]="0:1361:4:2:1:Shield::1:0:", -- Rigid Buckler
	[15114]="0:372:4:2:1:Cloak::1:0:", -- Rigid Cape
	[15115]="0:474:4:2:1:Leather::1:0:", -- Rigid Gloves
	[15116]="0:1163:4:2:1:Leather::1:0:", -- Rigid Shoulders
	[15117]="0:1219:4:2:1:Leather::1:0:", -- Rigid Leggings
	[15118]="0:1562:4:2:1:Leather::1:0:", -- Rigid Tunic
	[15119]="0:13683:4:2:1:Cloth::1:0:", -- Highborne Pants
	[15120]="0:787:4:2:1:Leather::1:0:", -- Robust Girdle
	[15121]="0:1433:4:2:1:Leather::1:0:", -- Robust Boots
	[15122]="0:701:4:2:1:Leather::1:0:", -- Robust Bracers
	[15123]="0:2463:4:2:1:Shield::1:0:", -- Robust Buckler
	[15124]="0:847:4:2:1:Cloak::1:0:", -- Robust Cloak
	[15125]="0:991:4:2:1:Leather::1:0:", -- Robust Gloves
	[15126]="0:1989:4:2:1:Leather::1:0:", -- Robust Leggings
	[15127]="0:1647:4:2:1:Leather::1:0:", -- Robust Shoulders
	[15128]="0:2425:4:2:1:Leather::1:0:", -- Robust Tunic
	[15129]="0:1825:4:2:1:Leather::1:0:", -- Robust Helm
	[15130]="0:3252:4:2:1:Leather::1:0:", -- Cutthroat's Vest
	[15131]="0:2023:4:2:1:Leather::1:0:", -- Cutthroat's Boots
	[15132]="0:1017:4:2:1:Leather::1:0:", -- Cutthroat's Armguards
	[15133]="0:3827:4:2:1:Shield::1:0:", -- Cutthroat's Buckler
	[15134]="0:3295:4:2:1:Leather::1:0:", -- Cutthroat's Hat
	[15135]="0:1357:4:2:1:Cloak::1:0:", -- Cutthroat's Cape
	[15136]="0:1249:4:2:1:Leather::1:0:", -- Cutthroat's Belt
	[15137]="0:1516:4:2:1:Leather::1:0:", -- Cutthroat's Mitts
	[15138]="0:15198:4:3:1:Cloak::1:0:", -- Onyxia Scale Cloak
	[15139]="0:3055:4:2:1:Leather::1:0:", -- Cutthroat's Pants
	[15140]="0:2530:4:2:1:Leather::1:0:", -- Cutthroat's Mantle
	[15141]="0:39101:4:4:1:Mail::1:0:", -- Onyxia Scale Breastplate
	[15142]="0:2603:4:2:1:Leather::1:0:", -- Ghostwalker Boots
	[15143]="0:1439:4:2:1:Leather::1:0:", -- Ghostwalker Bindings
	[15144]="0:4232:4:2:1:Leather::1:0:", -- Ghostwalker Rags
	[15145]="0:4943:4:2:1:Shield::1:0:", -- Ghostwalker Buckler
	[15146]="0:3730:4:2:1:Leather::1:0:", -- Ghostwalker Crown
	[15147]="0:1754:4:2:1:Cloak::1:0:", -- Ghostwalker Cloak
	[15148]="0:1614:4:2:1:Leather::1:0:", -- Ghostwalker Belt
	[15149]="0:1960:4:2:1:Leather::1:0:", -- Ghostwalker Gloves
	[15150]="0:2951:4:2:1:Leather::1:0:", -- Ghostwalker Pads
	[15151]="0:3949:4:2:1:Leather::1:0:", -- Ghostwalker Legguards
	[15152]="0:4449:4:2:1:Leather::1:0:", -- Nocturnal Shoes
	[15153]="0:2626:4:2:1:Cloak::1:0:", -- Nocturnal Cloak
	[15154]="0:2372:4:2:1:Leather::1:0:", -- Nocturnal Sash
	[15155]="0:2571:4:2:1:Leather::1:0:", -- Nocturnal Gloves
	[15156]="0:5266:4:2:1:Leather::1:0:", -- Nocturnal Cap
	[15157]="0:6200:4:2:1:Leather::1:0:", -- Nocturnal Leggings
	[15158]="0:4320:4:2:1:Leather::1:0:", -- Nocturnal Shoulder Pads
	[15159]="0:6743:4:2:1:Leather::1:0:", -- Nocturnal Tunic
	[15160]="0:2430:4:2:1:Leather::1:0:", -- Nocturnal Wristbands
	[15161]="0:3319:4:2:1:Leather::1:0:", -- Imposing Belt
	[15162]="0:5829:4:2:1:Leather::1:0:", -- Imposing Boots
	[15163]="0:3344:4:2:1:Leather::1:0:", -- Imposing Bracers
	[15164]="0:9135:4:2:1:Leather::1:0:", -- Imposing Vest
	[15165]="0:3744:4:2:1:Cloak::1:0:", -- Imposing Cape
	[15166]="0:3945:4:2:1:Leather::1:0:", -- Imposing Gloves
	[15167]="0:7484:4:2:1:Leather::1:0:", -- Imposing Bandana
	[15168]="0:7951:4:2:1:Leather::1:0:", -- Imposing Pants
	[15169]="0:5542:4:2:1:Leather::1:0:", -- Imposing Shoulders
	[15170]="0:13104:4:2:1:Leather::1:0:", -- Potent Armor
	[15171]="0:8697:4:2:1:Leather::1:0:", -- Potent Boots
	[15172]="0:4706:4:2:1:Leather::1:0:", -- Potent Bands
	[15173]="0:5387:4:2:1:Cloak::1:0:", -- Potent Cape
	[15174]="0:6017:4:2:1:Leather::1:0:", -- Potent Gloves
	[15175]="0:9692:4:2:1:Leather::1:0:", -- Potent Helmet
	[15176]="0:12121:4:2:1:Leather::1:0:", -- Potent Pants
	[15177]="0:8525:4:2:1:Leather::1:0:", -- Potent Shoulders
	[15178]="0:4936:4:2:1:Leather::1:0:", -- Potent Belt
	[15179]="0:18593:4:2:1:Leather::1:0:", -- Praetorian Padded Armor
	[15180]="0:6686:4:2:1:Leather::1:0:", -- Praetorian Girdle
	[15181]="0:11312:4:2:1:Leather::1:0:", -- Praetorian Boots
	[15182]="0:5996:4:2:1:Leather::1:0:", -- Praetorian Wristbands
	[15183]="0:6751:4:2:1:Cloak::1:0:", -- Praetorian Cloak
	[15184]="0:7197:4:2:1:Leather::1:0:", -- Praetorian Gloves
	[15185]="0:12906:4:2:1:Leather::1:0:", -- Praetorian Coif
	[15186]="0:15373:4:2:1:Leather::1:0:", -- Praetorian Leggings
	[15187]="0:10918:4:2:1:Leather::1:0:", -- Praetorian Pauldrons
	[15188]="0:8702:4:2:1:Leather::1:0:", -- Grand Armguards
	[15189]="0:15723:4:2:1:Leather::1:0:", -- Grand Boots
	[15190]="0:9614:4:2:1:Cloak::1:0:", -- Grand Cloak
	[15191]="0:9035:4:2:1:Leather::1:0:", -- Grand Belt
	[15192]="0:10596:4:2:1:Leather::1:0:", -- Grand Gauntlets
	[15193]="0:16397:4:2:1:Leather::1:0:", -- Grand Crown
	[15194]="0:21643:4:2:1:Leather::1:0:", -- Grand Legguards
	[15195]="0:22020:4:2:1:Leather::1:0:", -- Grand Breastplate
	[15196]="0:0:4:1:1:Tabard::1:0:5049,5191,5193,12781,12805,16766", -- Private's Tabard
	[15197]="0:0:4:1:1:Tabard::1:0:5188,5189,5190,12793,12799,16610", -- Scout's Tabard
	[15198]="0:0:4:1:1:Tabard::1:0:5049,5191,5193,12781,16766", -- Knight's Colors
	[15199]="0:0:4:1:1:Tabard::1:0:5188,5189,5190,12793,16610", -- Stone Guard's Herald
	[15200]="0:0:4:3:1:Amulet::1:0:12793,12799", -- Senior Sergeant's Insignia
	[15202]="0:516:4:2:1:Leather::1:0:", -- Wildkeeper Leggings
	[15203]="0:621:4:2:1:Mail::1:0:", -- Guststorm Legguards
	[15204]="0:779:2:2:1:Wand::1:0:", -- Moonstone Wand
	[15205]="0:1063:2:2:1:Gun::1:0:", -- Owlsight Rifle
	[15206]="0:857:4:2:1:OffHandFrill::1:0:", -- Jadefinger Baton
	[15207]="0:914:4:2:1:Shield::1:0:", -- Steelcap Shield
	[15208]="0:0:12:1:1:::1:0:", -- Cenarion Moondust
	[15209]="0:0:12:1:1:::1:0:", -- Relic Bundle
	[15210]="0:825:2:2:1:OneHandSword::1:0:", -- Raider Shortsword
	[15211]="0:1917:2:2:1:OneHandSword::1:0:", -- Militant Shortsword
	[15212]="0:3450:2:2:1:OneHandSword::1:0:", -- Fighter Broadsword
	[15213]="0:8165:2:2:1:OneHandSword::1:0:", -- Mercenary Blade
	[15214]="0:11356:2:2:1:OneHandSword::1:0:", -- Nobles Brand
	[15215]="0:16744:2:2:1:OneHandSword::1:0:", -- Furious Falchion
	[15216]="0:25932:2:2:1:OneHandSword::1:0:", -- Rune Sword
	[15217]="0:30996:2:2:1:OneHandSword::1:0:", -- Widow Blade
	[15218]="0:37048:2:2:1:OneHandSword::1:0:", -- Crystal Sword
	[15219]="0:41376:2:2:1:OneHandSword::1:0:", -- Dimensional Blade
	[15220]="0:40552:2:2:1:OneHandSword::1:0:", -- Battlefell Sabre
	[15221]="0:43545:2:2:1:OneHandSword::1:0:", -- Holy War Sword
	[15222]="0:1219:2:2:1:OneHandMace::1:0:", -- Barbed Club
	[15223]="0:2376:2:2:1:OneHandMace::1:0:", -- Jagged Star
	[15224]="0:2695:2:2:1:OneHandMace::1:0:", -- Battlesmasher
	[15225]="0:5958:2:2:1:OneHandMace::1:0:", -- Sequoia Hammer
	[15226]="0:8755:2:2:1:OneHandMace::1:0:", -- Giant Club
	[15227]="0:21925:2:2:1:OneHandMace::1:0:", -- Diamond-Tip Bludgeon
	[15228]="0:28308:2:2:1:OneHandMace::1:0:", -- Smashing Star
	[15229]="0:31924:2:2:1:OneHandMace::1:0:", -- Blesswind Hammer
	[15230]="0:2755:2:2:1:OneHandAxe::1:0:", -- Ridge Cleaver
	[15231]="0:5033:2:2:1:OneHandAxe::1:0:", -- Splitting Hatchet
	[15232]="0:6112:2:2:1:OneHandAxe::1:0:", -- Hacking Cleaver
	[15233]="0:10476:2:2:1:OneHandAxe::1:0:", -- Savage Axe
	[15234]="0:11354:2:2:1:OneHandAxe::1:0:", -- Greater Scythe
	[15235]="0:21091:2:2:1:OneHandAxe::1:0:", -- Crescent Edge
	[15236]="0:27485:2:2:1:OneHandAxe::1:0:", -- Moon Cleaver
	[15237]="0:30526:2:2:1:OneHandAxe::1:0:", -- Corpse Harvester
	[15238]="0:36496:2:2:1:OneHandAxe::1:0:", -- Warlord's Axe
	[15239]="0:40954:2:2:1:OneHandAxe::1:0:", -- Felstone Reaver
	[15240]="0:42810:2:2:1:OneHandAxe::1:0:", -- Demon's Claw
	[15241]="0:3012:2:2:1:Dagger::1:0:", -- Battle Knife
	[15242]="0:4426:2:2:1:Dagger::1:0:", -- Honed Stiletto
	[15243]="0:7871:2:2:1:Dagger::1:0:", -- Deadly Kris
	[15244]="0:12769:2:2:1:Dagger::1:0:", -- Razor Blade
	[15245]="0:23284:2:2:1:Dagger::1:0:", -- Vorpal Dagger
	[15246]="0:42614:2:2:1:Dagger::1:0:", -- Demon Blade
	[15247]="0:43935:2:2:1:Dagger::1:0:", -- Bloodstrike Dagger
	[15248]="0:1791:2:2:1:TwoHandSword::1:0:", -- Gleaming Claymore
	[15249]="0:3877:2:2:1:TwoHandSword::1:0:", -- Polished Zweihander
	[15250]="0:6895:2:2:1:TwoHandSword::1:0:", -- Glimmering Flamberge
	[15251]="0:17685:2:2:1:TwoHandSword::1:0:", -- Headstriker Sword
	[15252]="0:27906:2:2:1:TwoHandSword::1:0:", -- Tusker Sword
	[15253]="0:31547:2:2:1:TwoHandSword::1:0:", -- Beheading Blade
	[15254]="0:35584:2:2:1:TwoHandSword::1:0:", -- Dark Espadon
	[15255]="0:42545:2:2:1:TwoHandSword::1:0:", -- Gallant Flamberge
	[15256]="0:47531:2:2:1:TwoHandSword::1:0:", -- Massacre Sword
	[15257]="0:51499:2:2:1:TwoHandSword::1:0:", -- Shin Blade
	[15258]="0:53805:2:2:1:TwoHandSword::1:0:", -- Divine Warblade
	[15259]="0:3306:2:2:1:TwoHandMace::1:0:", -- Hefty Battlehammer
	[15260]="0:11556:2:2:1:TwoHandMace::1:0:", -- Stone Hammer
	[15261]="0:13530:2:2:1:TwoHandMace::1:0:", -- Sequoia Branch
	[15262]="0:21552:2:2:1:TwoHandMace::1:0:", -- Greater Maul
	[15263]="0:28889:2:2:1:TwoHandMace::1:0:", -- Royal Mallet
	[15264]="0:41517:2:2:1:TwoHandMace::1:0:", -- Backbreaker
	[15265]="0:46823:2:2:1:TwoHandMace::1:0:", -- Painbringer
	[15266]="0:52538:2:2:1:TwoHandMace::1:0:", -- Fierce Mauler
	[15267]="0:54186:2:2:1:TwoHandMace::1:0:", -- Brutehammer
	[15268]="0:1024:2:2:1:TwoHandAxe::1:0:", -- Twin-bladed Axe
	[15269]="0:3036:2:2:1:TwoHandAxe::1:0:", -- Massive Battle Axe
	[15270]="0:22775:2:2:1:TwoHandAxe::1:0:", -- Gigantic War Axe
	[15271]="0:43701:2:2:1:TwoHandAxe::1:0:", -- Colossal Great Axe
	[15272]="0:51740:2:2:1:TwoHandAxe::1:0:", -- Razor Axe
	[15273]="0:51401:2:2:1:TwoHandAxe::1:0:", -- Death Striker
	[15274]="0:31666:2:2:1:Stave::1:0:", -- Diviner Long Staff
	[15275]="0:35714:2:2:1:Stave::1:0:", -- Thaumaturgist Staff
	[15276]="0:45263:2:2:1:Stave::1:0:", -- Magus Long Staff
	[15277]="100000:0:15:3:1:Mount::1:0:3685", -- Gray Kodo
	[15278]="0:50286:2:2:1:Stave::1:0:", -- Solstice Staff
	[15279]="0:18267:2:2:1:Wand::1:0:", -- Ivory Wand
	[15280]="0:20603:2:2:1:Wand::1:0:", -- Wizard's Hand
	[15281]="0:26110:2:2:1:Wand::1:0:", -- Glowstar Rod
	[15282]="0:30628:2:2:1:Wand::1:0:", -- Dragon Finger
	[15283]="0:32459:2:2:1:Wand::1:0:", -- Lunar Wand
	[15284]="0:3039:2:2:1:Bow::1:0:", -- Long Battle Bow
	[15285]="0:4061:2:2:1:Bow::1:0:", -- Archer's Longbow
	[15286]="0:5568:2:2:1:Bow::1:0:", -- Long Redwood Bow
	[15287]="0:12516:2:2:1:Bow::1:0:", -- Crusader Bow
	[15288]="0:32585:2:2:1:Bow::1:0:", -- Blasthorn Bow
	[15289]="0:34505:2:2:1:Bow::1:0:", -- Archstrike Bow
	[15290]="100000:0:15:3:1:Mount::1:0:3685", -- Brown Kodo
	[15291]="0:19591:2:2:1:Bow::1:0:", -- Harpy Needler
	[15292]="0:0:15:4:1:Mount::1:0:", -- Green Kodo
	[15293]="0:0:15:4:1:Mount::1:0:", -- Teal Kodo
	[15294]="0:20135:2:2:1:Bow::1:0:", -- Siege Bow
	[15295]="0:22712:2:2:1:Bow::1:0:", -- Quillfire Bow
	[15296]="0:31193:2:2:1:Bow::1:0:", -- Hawkeye Bow
	[15297]="0:45:4:1:1:Leather::1:0:", -- Grizzly Bracers
	[15298]="0:305:4:2:1:Shield::1:0:", -- Grizzly Buckler
	[15299]="0:42:4:1:1:Cloak::1:0:", -- Grizzly Cape
	[15300]="0:86:4:1:1:Leather::1:0:", -- Grizzly Gloves
	[15301]="0:108:4:1:1:Leather::1:0:", -- Grizzly Slippers
	[15302]="0:47:4:1:1:Leather::1:0:", -- Grizzly Belt
	[15303]="0:299:4:2:1:Leather::1:0:", -- Grizzly Pants
	[15304]="0:414:4:2:1:Leather::1:0:", -- Grizzly Jerkin
	[15305]="0:412:4:2:1:Leather::1:0:", -- Feral Shoes
	[15306]="0:208:4:2:1:Leather::1:0:", -- Feral Bindings
	[15307]="0:815:4:2:1:Shield::1:0:", -- Feral Buckler
	[15308]="0:241:4:2:1:Leather::1:0:", -- Feral Cord
	[15309]="0:220:4:2:1:Cloak::1:0:", -- Feral Cloak
	[15310]="0:279:4:2:1:Leather::1:0:", -- Feral Gloves
	[15311]="0:982:4:2:1:Leather::1:0:", -- Feral Harness
	[15312]="0:745:4:2:1:Leather::1:0:", -- Feral Leggings
	[15313]="0:514:4:1:1:Leather::1:0:", -- Feral Shoulder Pads
	[15314]="0:0:12:1:1:::1:0:", -- Bundle of Relics
	[15322]="0:7745:2:2:1:Gun::1:0:", -- Smoothbore Gun
	[15323]="0:17791:2:2:1:Gun::1:0:", -- Percussion Shotgun
	[15324]="0:25565:2:2:1:Gun::1:0:", -- Burnside Rifle
	[15325]="0:31785:2:2:1:Gun::1:0:", -- Sharpshooter Harquebus
	[15326]="0:1:15:1:200:Junk::1:0:", -- Broken Gleaming Throwing Axe
	[15327]="0:1:15:1:200:Junk::1:0:", -- Broken Wicked Throwing Dagger
	[15328]="0:0:13:1:1:::1:0:", -- Joseph's Key
	[15329]="0:623:4:2:1:Leather::1:0:", -- Wrangler's Belt
	[15330]="0:1059:4:2:1:Leather::1:0:", -- Wrangler's Boots
	[15331]="0:555:4:2:1:Leather::1:0:", -- Wrangler's Wristbands
	[15332]="0:2263:4:2:1:Shield::1:0:", -- Wrangler's Buckler
	[15333]="0:537:4:2:1:Cloak::1:0:", -- Wrangler's Cloak
	[15334]="0:828:4:2:1:Leather::1:0:", -- Wrangler's Gloves
	[15335]="0:580:2:2:1:OneHandSword::1:0:", -- Briarsteel Shortsword
	[15336]="0:1669:4:2:1:Leather::1:0:", -- Wrangler's Leggings
	[15337]="0:2027:4:2:1:Leather::1:0:", -- Wrangler's Wraps
	[15338]="0:1387:4:2:1:Leather::1:0:", -- Wrangler's Mantle
	[15339]="0:2466:4:2:1:Leather::1:0:", -- Pathfinder Hat
	[15340]="0:1016:4:2:1:Cloak::1:0:", -- Pathfinder Cloak
	[15341]="0:1697:4:2:1:Leather::1:0:", -- Pathfinder Footpads
	[15342]="0:2907:4:2:1:Shield::1:0:", -- Pathfinder Guard
	[15343]="0:1139:4:2:1:Leather::1:0:", -- Pathfinder Gloves
	[15344]="0:2516:4:2:1:Leather::1:0:", -- Pathfinder Pants
	[15345]="0:1894:4:2:1:Leather::1:0:", -- Pathfinder Shoulder Pads
	[15346]="0:2788:4:2:1:Leather::1:0:", -- Pathfinder Vest
	[15347]="0:955:4:2:1:Leather::1:0:", -- Pathfinder Belt
	[15348]="0:792:4:2:1:Leather::1:0:", -- Pathfinder Bracers
	[15349]="0:1550:4:2:1:Leather::1:0:", -- Headhunter's Belt
	[15350]="0:2385:4:2:1:Leather::1:0:", -- Headhunter's Slippers
	[15351]="0:1090:4:2:1:Leather::1:0:", -- Headhunter's Bands
	[15352]="0:4101:4:2:1:Shield::1:0:", -- Headhunter's Buckler
	[15353]="0:3467:4:2:1:Leather::1:0:", -- Headhunter's Headdress
	[15354]="0:1600:4:2:1:Cloak::1:0:", -- Headhunter's Cloak
	[15355]="0:1620:4:2:1:Leather::1:0:", -- Headhunter's Mitts
	[15356]="0:3935:4:2:1:Leather::1:0:", -- Headhunter's Armor
	[15357]="0:2693:4:2:1:Leather::1:0:", -- Headhunter's Spaulders
	[15358]="0:3604:4:2:1:Leather::1:0:", -- Headhunter's Woolies
	[15359]="0:5955:4:2:1:Leather::1:0:", -- Trickster's Vest
	[15360]="0:2372:4:2:1:Leather::1:0:", -- Trickster's Bindings
	[15361]="0:2204:4:2:1:Leather::1:0:", -- Trickster's Sash
	[15362]="0:3871:4:2:1:Leather::1:0:", -- Trickster's Boots
	[15363]="0:4894:4:2:1:Leather::1:0:", -- Trickster's Headdress
	[15364]="0:2431:4:2:1:Cloak::1:0:", -- Trickster's Cloak
	[15365]="0:2415:4:2:1:Leather::1:0:", -- Trickster's Handwraps
	[15366]="0:5250:4:2:1:Leather::1:0:", -- Trickster's Leggings
	[15367]="0:6246:4:2:1:Shield::1:0:", -- Trickster's Protector
	[15368]="0:3674:4:2:1:Leather::1:0:", -- Trickster's Pauldrons
	[15369]="0:3097:4:2:1:Leather::1:0:", -- Wolf Rider's Belt
	[15370]="0:5439:4:2:1:Leather::1:0:", -- Wolf Rider's Boots
	[15371]="0:3467:4:2:1:Cloak::1:0:", -- Wolf Rider's Cloak
	[15372]="0:3383:4:2:1:Leather::1:0:", -- Wolf Rider's Gloves
	[15373]="0:6930:4:2:1:Leather::1:0:", -- Wolf Rider's Headgear
	[15374]="0:7363:4:2:1:Leather::1:0:", -- Wolf Rider's Leggings
	[15375]="0:5132:4:2:1:Leather::1:0:", -- Wolf Rider's Shoulder Pads
	[15376]="0:8653:4:2:1:Leather::1:0:", -- Wolf Rider's Padded Armor
	[15377]="0:3191:4:2:1:Leather::1:0:", -- Wolf Rider's Wristbands
	[15378]="0:4358:4:2:1:Leather::1:0:", -- Rageclaw Belt
	[15379]="0:7654:4:2:1:Leather::1:0:", -- Rageclaw Boots
	[15380]="0:4391:4:2:1:Leather::1:0:", -- Rageclaw Bracers
	[15381]="0:12593:4:2:1:Leather::1:0:", -- Rageclaw Chestguard
	[15382]="0:5043:4:2:1:Cloak::1:0:", -- Rageclaw Cloak
	[15383]="0:5313:4:2:1:Leather::1:0:", -- Rageclaw Gloves
	[15384]="0:9155:4:2:1:Leather::1:0:", -- Rageclaw Helm
	[15385]="0:11449:4:2:1:Leather::1:0:", -- Rageclaw Leggings
	[15386]="0:7287:4:2:1:Leather::1:0:", -- Rageclaw Shoulder Pads
	[15387]="0:5584:4:2:1:Leather::1:0:", -- Jadefire Bracelets
	[15388]="0:6357:4:2:1:Leather::1:0:", -- Jadefire Belt
	[15389]="0:10146:4:2:1:Leather::1:0:", -- Jadefire Sabatons
	[15390]="0:16175:4:2:1:Leather::1:0:", -- Jadefire Chestguard
	[15391]="0:12178:4:2:1:Leather::1:0:", -- Jadefire Cap
	[15392]="0:6382:4:2:1:Cloak::1:0:", -- Jadefire Cloak
	[15393]="0:6479:4:2:1:Leather::1:0:", -- Jadefire Gloves
	[15394]="0:14615:4:2:1:Leather::1:0:", -- Jadefire Pants
	[15395]="0:10379:4:2:1:Leather::1:0:", -- Jadefire Epaulets
	[15396]="0:582:2:2:1:Dagger::1:0:", -- Curvewood Dagger
	[15397]="0:731:2:2:1:Stave::1:0:", -- Oakthrush Staff
	[15398]="0:108:4:1:1:Cloth::1:0:", -- Sandcomber Boots
	[15399]="0:151:4:2:1:Leather::1:0:", -- Dryweed Belt
	[15400]="0:109:4:1:1:Mail::1:0:", -- Clamshell Bracers
	[15401]="0:73:4:1:1:Cloth::1:0:", -- Welldrip Gloves
	[15402]="0:110:4:1:1:Mail::1:0:", -- Noosegrip Gauntlets
	[15403]="0:280:4:2:1:Leather::1:0:", -- Ridgeback Bracers
	[15404]="0:337:4:2:1:Mail::1:0:", -- Breakwater Girdle
	[15405]="0:245:4:2:1:Leather::1:0:", -- Shucking Gloves
	[15406]="0:402:4:2:1:Mail::1:0:", -- Crustacean Boots
	[15407]="0:500:7:1:20:Leather:202,165:1:0:", -- Cured Rugged Hide
	[15408]="0:500:7:1:20:Leather:165:1:0:", -- Heavy Scorpid Scale
	[15409]="0:1000:7:1:20:Leather:165:1:0:", -- Refined Deeprock Salt
	[15410]="0:5000:7:3:20:Leather:165:1:0:", -- Scale of Onyxia
	[15411]="0:10283:4:3:1:Amulet::1:0:", -- Mark of Fordring
	[15412]="0:500:7:1:20:Leather:165:1:0:", -- Green Dragonscale
	[15413]="0:35470:4:3:1:Plate::1:0:", -- Ornate Adamantium Breastplate
	[15414]="0:1500:7:1:20:Leather:165:1:0:", -- Red Dragonscale
	[15415]="0:500:7:1:20:Leather:165:1:0:", -- Blue Dragonscale
	[15416]="0:1000:7:1:20:Leather:165:1:0:", -- Black Dragonscale
	[15417]="0:500:7:1:20:Leather:164,165:1:0:", -- Devilsaur Leather
	[15418]="0:66242:2:3:1:TwoHandMace::1:0:", -- Shimmering Platinum Warhammer
	[15419]="0:600:7:1:20:Leather:165:1:0:", -- Warbear Leather
	[15420]="0:100:15:0:50:Junk::1:0:", -- Ironfeather
	[15421]="0:16070:4:3:1:Cloak::1:0:", -- Shroud of the Exile
	[15422]="0:500:15:0:20:Junk::1:0:", -- Frostsaber Leather
	[15423]="0:500:15:0:20:Junk::1:0:", -- Chimera Leather
	[15424]="0:1404:2:2:1:TwoHandAxe::1:0:", -- Axe of Orgrimmar
	[15425]="0:8273:4:2:1:Leather::1:0:", -- Peerless Bracers
	[15426]="0:13419:4:2:1:Leather::1:0:", -- Peerless Boots
	[15427]="0:8536:4:2:1:Cloak::1:0:", -- Peerless Cloak
	[15428]="0:8024:4:2:1:Leather::1:0:", -- Peerless Belt
	[15429]="0:9049:4:2:1:Leather::1:0:", -- Peerless Gloves
	[15430]="0:15435:4:2:1:Leather::1:0:", -- Peerless Headband
	[15431]="0:19673:4:2:1:Leather::1:0:", -- Peerless Leggings
	[15432]="0:14104:4:2:1:Leather::1:0:", -- Peerless Shoulders
	[15433]="0:21099:4:2:1:Leather::1:0:", -- Peerless Armor
	[15434]="0:10588:4:2:1:Leather::1:0:", -- Supreme Sash
	[15435]="0:16380:4:2:1:Leather::1:0:", -- Supreme Shoes
	[15436]="0:10519:4:2:1:Leather::1:0:", -- Supreme Bracers
	[15437]="0:12845:4:2:1:Cloak::1:0:", -- Supreme Cape
	[15438]="0:11039:4:2:1:Leather::1:0:", -- Supreme Gloves
	[15439]="0:16841:4:2:1:Leather::1:0:", -- Supreme Crown
	[15440]="0:22238:4:2:1:Leather::1:0:", -- Supreme Leggings
	[15441]="0:16737:4:2:1:Leather::1:0:", -- Supreme Shoulders
	[15442]="0:22996:4:2:1:Leather::1:0:", -- Supreme Breastplate
	[15443]="0:1119:2:2:1:Dagger::1:0:", -- Kris of Orgrimmar
	[15444]="0:1404:2:2:1:Stave::1:0:", -- Staff of Orgrimmar
	[15445]="0:1127:2:2:1:OneHandMace::1:0:", -- Hammer of Orgrimmar
	[15447]="0:0:12:1:1:::1:0:", -- Living Rot
	[15448]="0:0:12:1:1:::1:0:", -- Coagulated Rot
	[15449]="0:425:4:2:1:Cloth::1:0:", -- Ghastly Trousers
	[15450]="0:534:4:2:1:Leather::1:0:", -- Dredgemire Leggings
	[15451]="0:643:4:2:1:Mail::1:0:", -- Gargoyle Leggings
	[15452]="0:215:4:2:1:Cloth::1:0:", -- Featherbead Bracers
	[15453]="0:270:4:2:1:Leather::1:0:", -- Savannah Bracers
	[15454]="0:0:12:1:1:::1:0:", -- Mortar and Pestle
	[15455]="0:3541:4:2:1:Cloth::1:0:", -- Dustfall Robes
	[15456]="0:4442:4:2:1:Leather::1:0:", -- Lightstep Leggings
	[15457]="0:1134:4:2:1:Cloth::1:0:", -- Desert Shoulders
	[15458]="0:1423:4:2:1:Leather::1:0:", -- Tundra Boots
	[15459]="0:1142:4:2:1:Mail::1:0:", -- Grimtoll Wristguards
	[15461]="0:841:4:2:1:Cloth::1:0:", -- Lightheel Boots
	[15462]="0:653:4:2:1:Leather::1:0:", -- Loamflake Bracers
	[15463]="0:787:4:2:1:Mail::1:0:", -- Palestrider Gloves
	[15464]="0:4504:2:2:1:TwoHandMace::1:0:", -- Brute Hammer
	[15465]="0:2713:2:2:1:Wand::1:0:", -- Stingshot Wand
	[15466]="0:2324:4:2:1:Shield::1:0:", -- Clink Shield
	[15467]="0:8630:4:2:1:Ring::1:0:", -- Inventor's League Ring
	[15468]="0:1207:4:2:1:Cloak::1:0:", -- Windsong Drape
	[15469]="0:1009:4:2:1:Leather::1:0:", -- Windsong Cinch
	[15470]="0:2432:4:2:1:Mail::1:0:", -- Plainsguard Leggings
	[15471]="0:2034:4:2:1:Leather::1:0:", -- Brawnhide Armor
	[15472]="0:33:4:1:1:Mail::1:0:", -- Charger's Belt
	[15473]="0:65:4:1:1:Mail::1:0:", -- Charger's Boots
	[15474]="0:24:4:1:1:Mail::1:0:", -- Charger's Bindings
	[15475]="0:24:4:1:1:Cloak::1:0:", -- Charger's Cloak
	[15476]="0:44:4:1:1:Mail::1:0:", -- Charger's Handwraps
	[15477]="0:192:4:2:1:Mail::1:0:", -- Charger's Pants
	[15478]="0:52:4:1:1:Shield::1:0:", -- Charger's Shield
	[15479]="0:179:4:2:1:Mail::1:0:", -- Charger's Armor
	[15480]="0:84:4:1:1:Mail::1:0:", -- War Torn Girdle
	[15481]="0:127:4:1:1:Mail::1:0:", -- War Torn Greaves
	[15482]="0:54:4:1:1:Mail::1:0:", -- War Torn Bands
	[15483]="0:42:4:1:1:Cloak::1:0:", -- War Torn Cape
	[15484]="0:68:4:1:1:Mail::1:0:", -- War Torn Handgrips
	[15485]="0:344:4:2:1:Mail::1:0:", -- War Torn Pants
	[15486]="0:245:4:2:1:Shield::1:0:", -- War Torn Shield
	[15487]="0:479:4:2:1:Mail::1:0:", -- War Torn Tunic
	[15488]="0:967:4:2:1:Mail::1:0:", -- Bloodspattered Surcoat
	[15489]="0:363:4:2:1:Mail::1:0:", -- Bloodspattered Sabatons
	[15490]="0:105:4:1:1:Cloak::1:0:", -- Bloodspattered Cloak
	[15491]="0:211:4:2:1:Mail::1:0:", -- Bloodspattered Gloves
	[15492]="0:212:4:2:1:Mail::1:0:", -- Bloodspattered Sash
	[15493]="0:647:4:2:1:Mail::1:0:", -- Bloodspattered Loincloth
	[15494]="0:693:4:2:1:Shield::1:0:", -- Bloodspattered Shield
	[15495]="0:220:4:2:1:Mail::1:0:", -- Bloodspattered Wristbands
	[15496]="0:462:4:1:1:Mail::1:0:", -- Bloodspattered Shoulder Pads
	[15497]="0:387:4:2:1:Mail::1:0:", -- Outrunner's Cord
	[15498]="0:674:4:2:1:Mail::1:0:", -- Outrunner's Slippers
	[15499]="0:307:4:2:1:Mail::1:0:", -- Outrunner's Cuffs
	[15500]="0:1378:4:2:1:Mail::1:0:", -- Outrunner's Chestguard
	[15501]="0:269:4:2:1:Cloak::1:0:", -- Outrunner's Cloak
	[15502]="0:411:4:2:1:Mail::1:0:", -- Outrunner's Gloves
	[15503]="0:1091:4:2:1:Mail::1:0:", -- Outrunner's Legguards
	[15504]="0:1168:4:2:1:Shield::1:0:", -- Outrunner's Shield
	[15505]="0:561:4:1:1:Mail::1:0:", -- Outrunner's Pauldrons
	[15506]="0:723:4:2:1:Mail::1:0:", -- Grunt's AnkleWraps
	[15507]="0:364:4:2:1:Mail::1:0:", -- Grunt's Bracers
	[15508]="0:365:4:2:1:Cloak::1:0:", -- Grunt's Cape
	[15509]="0:485:4:2:1:Mail::1:0:", -- Grunt's Handwraps
	[15510]="0:423:4:2:1:Mail::1:0:", -- Grunt's Belt
	[15511]="0:1474:4:2:1:Mail::1:0:", -- Grunt's Legguards
	[15512]="0:1578:4:2:1:Shield::1:0:", -- Grunt's Shield
	[15513]="0:1264:4:2:1:Mail::1:0:", -- Grunt's Pauldrons
	[15514]="0:1902:4:2:1:Mail::1:0:", -- Grunt's Chestpiece
	[15515]="0:845:4:2:1:Mail::1:0:", -- Spiked Chain Belt
	[15516]="0:1588:4:2:1:Mail::1:0:", -- Spiked Chain Slippers
	[15517]="0:850:4:2:1:Mail::1:0:", -- Spiked Chain Wristbands
	[15518]="0:2825:4:2:1:Mail::1:0:", -- Spiked Chain Breastplate
	[15519]="0:607:4:2:1:Cloak::1:0:", -- Spiked Chain Cloak
	[15520]="0:879:4:2:1:Mail::1:0:", -- Spiked Chain Gauntlets
	[15521]="0:1942:4:2:1:Mail::1:0:", -- Spiked Chain Leggings
	[15522]="0:2516:4:2:1:Shield::1:0:", -- Spiked Chain Shield
	[15523]="0:1474:4:2:1:Mail::1:0:", -- Spiked Chain Shoulder Pads
	[15524]="0:2876:4:2:1:Mail::1:0:", -- Sentry's Surcoat
	[15525]="0:1634:4:2:1:Mail::1:0:", -- Sentry's Slippers
	[15526]="0:704:4:2:1:Cloak::1:0:", -- Sentry's Cape
	[15527]="0:1020:4:2:1:Mail::1:0:", -- Sentry's Gloves
	[15528]="0:931:4:2:1:Mail::1:0:", -- Sentry's Sash
	[15529]="0:2487:4:2:1:Mail::1:0:", -- Sentry's Leggings
	[15530]="0:3222:4:2:1:Shield::1:0:", -- Sentry's Shield
	[15531]="0:2076:4:2:1:Mail::1:0:", -- Sentry's Shoulderguards
	[15532]="0:944:4:2:1:Mail::1:0:", -- Sentry's Armsplints
	[15533]="0:2290:4:2:1:Mail::1:0:", -- Sentry's Headdress
	[15534]="0:2308:4:2:1:Mail::1:0:", -- Wicked Chain Boots
	[15535]="0:1270:4:2:1:Mail::1:0:", -- Wicked Chain Bracers
	[15536]="0:4107:4:2:1:Mail::1:0:", -- Wicked Chain Chestpiece
	[15537]="0:1163:4:2:1:Cloak::1:0:", -- Wicked Chain Cloak
	[15538]="0:1412:4:2:1:Mail::1:0:", -- Wicked Chain Gauntlets
	[15539]="0:1282:4:2:1:Mail::1:0:", -- Wicked Chain Waistband
	[15540]="0:2827:4:2:1:Mail::1:0:", -- Wicked Chain Helmet
	[15541]="0:3441:4:2:1:Mail::1:0:", -- Wicked Chain Legguards
	[15542]="0:2365:4:2:1:Mail::1:0:", -- Wicked Chain Shoulder Pads
	[15543]="0:4179:4:2:1:Shield::1:0:", -- Wicked Chain Shield
	[15544]="0:2448:4:2:1:Mail::1:0:", -- Thick Scale Sabatons
	[15545]="0:1348:4:2:1:Mail::1:0:", -- Thick Scale Bracelets
	[15546]="0:4794:4:2:1:Mail::1:0:", -- Thick Scale Breastplate
	[15547]="0:1234:4:2:1:Cloak::1:0:", -- Thick Scale Cloak
	[15548]="0:1649:4:2:1:Mail::1:0:", -- Thick Scale Gauntlets
	[15549]="0:1504:4:2:1:Mail::1:0:", -- Thick Scale Belt
	[15550]="0:3316:4:2:1:Mail::1:0:", -- Thick Scale Crown
	[15551]="0:4438:4:2:1:Mail::1:0:", -- Thick Scale Legguards
	[15552]="0:5226:4:2:1:Shield::1:0:", -- Thick Scale Shield
	[15553]="0:3061:4:2:1:Mail::1:0:", -- Thick Scale Shoulder Pads
	[15554]="0:1853:4:2:1:Mail::1:0:", -- Pillager's Girdle
	[15555]="0:2802:4:2:1:Mail::1:0:", -- Pillager's Boots
	[15556]="0:1697:4:2:1:Mail::1:0:", -- Pillager's Bracers
	[15557]="0:5486:4:2:1:Mail::1:0:", -- Pillager's Chestguard
	[15558]="0:4128:4:2:1:Mail::1:0:", -- Pillager's Crown
	[15559]="0:1450:4:2:1:Cloak::1:0:", -- Pillager's Cloak
	[15560]="0:1937:4:2:1:Mail::1:0:", -- Pillager's Gloves
	[15561]="0:4705:4:2:1:Mail::1:0:", -- Pillager's Leggings
	[15562]="0:3558:4:2:1:Mail::1:0:", -- Pillager's Pauldrons
	[15563]="0:5562:4:2:1:Shield::1:0:", -- Pillager's Shield
	[15564]="0:1000:0:1:10:EnhPerm::1:0:", -- Rugged Armor Kit
	[15565]="0:4274:4:2:1:Mail::1:0:", -- Marauder's Boots
	[15566]="0:2178:4:2:1:Mail::1:0:", -- Marauder's Bracers
	[15567]="0:6666:4:2:1:Mail::1:0:", -- Marauder's Tunic
	[15568]="0:1814:4:2:1:Cloak::1:0:", -- Marauder's Cloak
	[15569]="0:7162:4:2:1:Shield::1:0:", -- Marauder's Crest
	[15570]="0:2431:4:2:1:Mail::1:0:", -- Marauder's Gauntlets
	[15571]="0:2218:4:2:1:Mail::1:0:", -- Marauder's Belt
	[15572]="0:4714:4:2:1:Mail::1:0:", -- Marauder's Circlet
	[15573]="0:5840:4:2:1:Mail::1:0:", -- Marauder's Leggings
	[15574]="0:5150:4:2:1:Mail::1:0:", -- Marauder's Shoulder Pads
	[15575]="0:2300:4:2:1:Mail::1:0:", -- Sparkleshell Belt
	[15576]="0:4462:4:2:1:Mail::1:0:", -- Sparkleshell Sabatons
	[15577]="0:2317:4:2:1:Mail::1:0:", -- Sparkleshell Bracers
	[15578]="0:6962:4:2:1:Mail::1:0:", -- Sparkleshell Breastplate
	[15579]="0:2122:4:2:1:Cloak::1:0:", -- Sparkleshell Cloak
	[15580]="0:4871:4:2:1:Mail::1:0:", -- Sparkleshell Headwrap
	[15581]="0:2794:4:2:1:Mail::1:0:", -- Sparkleshell Gauntlets
	[15582]="0:6544:4:2:1:Mail::1:0:", -- Sparkleshell Legguards
	[15583]="0:5344:4:2:1:Mail::1:0:", -- Sparkleshell Shoulder Pads
	[15584]="0:7594:4:2:1:Shield::1:0:", -- Sparkleshell Shield
	[15585]="0:1447:4:2:1:Cloth::1:0:", -- Pardoc Grips
	[15587]="0:1822:4:2:1:Leather::1:0:", -- Ringtail Girdle
	[15588]="0:2194:4:2:1:Mail::1:0:", -- Bracesteel Belt
	[15589]="0:5462:4:2:1:Mail::1:0:", -- Steadfast Stompers
	[15590]="0:2674:4:2:1:Mail::1:0:", -- Steadfast Bracelets
	[15591]="0:8740:4:2:1:Mail::1:0:", -- Steadfast Breastplate
	[15592]="0:8465:4:2:1:Shield::1:0:", -- Steadfast Buckler
	[15593]="0:5532:4:2:1:Mail::1:0:", -- Steadfast Coronet
	[15594]="0:2520:4:2:1:Cloak::1:0:", -- Steadfast Cloak
	[15595]="0:2950:4:2:1:Mail::1:0:", -- Steadfast Gloves
	[15596]="0:6909:4:2:1:Mail::1:0:", -- Steadfast Legplates
	[15597]="0:5642:4:2:1:Mail::1:0:", -- Steadfast Shoulders
	[15598]="0:2763:4:2:1:Mail::1:0:", -- Steadfast Girdle
	[15599]="0:6631:4:2:1:Mail::1:0:", -- Ancient Greaves
	[15600]="0:3787:4:2:1:Mail::1:0:", -- Ancient Vambraces
	[15601]="0:10345:4:2:1:Mail::1:0:", -- Ancient Chestpiece
	[15602]="0:7211:4:2:1:Mail::1:0:", -- Ancient Crown
	[15603]="0:3546:4:2:1:Cloak::1:0:", -- Ancient Cloak
	[15604]="0:11158:4:2:1:Shield::1:0:", -- Ancient Defender
	[15605]="0:3858:4:2:1:Mail::1:0:", -- Ancient Gauntlets
	[15606]="0:3585:4:2:1:Mail::1:0:", -- Ancient Belt
	[15607]="0:9306:4:2:1:Mail::1:0:", -- Ancient Legguards
	[15608]="0:7035:4:2:1:Mail::1:0:", -- Ancient Pauldrons
	[15609]="0:11806:4:2:1:Mail::1:0:", -- Bonelink Armor
	[15610]="0:4354:4:2:1:Mail::1:0:", -- Bonelink Bracers
	[15611]="0:4369:4:2:1:Cloak::1:0:", -- Bonelink Cape
	[15612]="0:4285:4:2:1:Mail::1:0:", -- Bonelink Gauntlets
	[15613]="0:3688:4:2:1:Mail::1:0:", -- Bonelink Belt
	[15614]="0:7026:4:2:1:Mail::1:0:", -- Bonelink Sabatons
	[15615]="0:7584:4:2:1:Mail::1:0:", -- Bonelink Helmet
	[15616]="0:10151:4:2:1:Mail::1:0:", -- Bonelink Legplates
	[15617]="0:7107:4:2:1:Mail::1:0:", -- Bonelink Epaulets
	[15618]="0:11782:4:2:1:Shield::1:0:", -- Bonelink Wall Shield
	[15619]="0:5987:4:2:1:Mail::1:0:", -- Gryphon Mail Belt
	[15620]="0:5564:4:2:1:Mail::1:0:", -- Gryphon Mail Bracelets
	[15621]="0:15766:4:2:1:Shield::1:0:", -- Gryphon Mail Buckler
	[15622]="0:14834:4:2:1:Mail::1:0:", -- Gryphon Mail Breastplate
	[15623]="0:10715:4:2:1:Mail::1:0:", -- Gryphon Mail Crown
	[15624]="0:4971:4:2:1:Cloak::1:0:", -- Gryphon Cloak
	[15625]="0:5818:4:2:1:Mail::1:0:", -- Gryphon Mail Gauntlets
	[15626]="0:8798:4:2:1:Mail::1:0:", -- Gryphon Mail Greaves
	[15627]="0:14493:4:2:1:Mail::1:0:", -- Gryphon Mail Legguards
	[15628]="0:9570:4:2:1:Mail::1:0:", -- Gryphon Mail Pauldrons
	[15629]="0:6374:4:2:1:Mail::1:0:", -- Formidable Bracers
	[15630]="0:10312:4:2:1:Mail::1:0:", -- Formidable Sabatons
	[15631]="0:16672:4:2:1:Mail::1:0:", -- Formidable Chestpiece
	[15632]="0:4997:4:2:1:Cloak::1:0:", -- Formidable Cape
	[15633]="0:16210:4:2:1:Shield::1:0:", -- Formidable Crest
	[15634]="0:11441:4:2:1:Mail::1:0:", -- Formidable Circlet
	[15635]="0:5896:4:2:1:Mail::1:0:", -- Formidable Gauntlets
	[15636]="0:6333:4:2:1:Mail::1:0:", -- Formidable Belt
	[15637]="0:14557:4:2:1:Mail::1:0:", -- Formidable Legguards
	[15638]="0:9615:4:2:1:Mail::1:0:", -- Formidable Shoulder Pads
	[15639]="0:7040:4:2:1:Mail::1:0:", -- Ironhide Bracers
	[15640]="0:20233:4:2:1:Mail::1:0:", -- Ironhide Breastplate
	[15641]="0:7587:4:2:1:Mail::1:0:", -- Ironhide Belt
	[15642]="0:12162:4:2:1:Mail::1:0:", -- Ironhide Greaves
	[15643]="0:6675:4:2:1:Cloak::1:0:", -- Ironhide Cloak
	[15644]="0:8130:4:2:1:Mail::1:0:", -- Ironhide Gauntlets
	[15645]="0:14577:4:2:1:Mail::1:0:", -- Ironhide Helmet
	[15646]="0:19507:4:2:1:Mail::1:0:", -- Ironhide Legguards
	[15647]="0:13125:4:2:1:Mail::1:0:", -- Ironhide Pauldrons
	[15648]="0:22212:4:2:1:Shield::1:0:", -- Ironhide Shield
	[15649]="0:7808:4:2:1:Mail::1:0:", -- Merciless Bracers
	[15650]="0:22230:4:2:1:Mail::1:0:", -- Merciless Surcoat
	[15651]="0:15785:4:2:1:Mail::1:0:", -- Merciless Crown
	[15652]="0:7139:4:2:1:Cloak::1:0:", -- Merciless Cloak
	[15653]="0:8053:4:2:1:Mail::1:0:", -- Merciless Gauntlets
	[15654]="0:8569:4:2:1:Mail::1:0:", -- Merciless Belt
	[15655]="0:19862:4:2:1:Mail::1:0:", -- Merciless Legguards
	[15656]="0:13366:4:2:1:Mail::1:0:", -- Merciless Epaulets
	[15657]="0:22625:4:2:1:Shield::1:0:", -- Merciless Shield
	[15658]="0:17851:4:2:1:Mail::1:0:", -- Impenetrable Sabatons
	[15659]="0:9508:4:2:1:Mail::1:0:", -- Impenetrable Bindings
	[15660]="0:25412:4:2:1:Mail::1:0:", -- Impenetrable Breastplate
	[15661]="0:9036:4:2:1:Cloak::1:0:", -- Impenetrable Cloak
	[15662]="0:10801:4:2:1:Mail::1:0:", -- Impenetrable Gauntlets
	[15663]="0:10226:4:2:1:Mail::1:0:", -- Impenetrable Belt
	[15664]="0:19071:4:2:1:Mail::1:0:", -- Impenetrable Helmet
	[15665]="0:25520:4:2:1:Mail::1:0:", -- Impenetrable Legguards
	[15666]="0:18375:4:2:1:Mail::1:0:", -- Impenetrable Pauldrons
	[15667]="0:27798:4:2:1:Shield::1:0:", -- Impenetrable Wall
	[15668]="0:11697:4:2:1:Mail::1:0:", -- Magnificent Bracers
	[15669]="0:26609:4:2:1:Mail::1:0:", -- Magnificent Breastplate
	[15670]="0:19753:4:2:1:Mail::1:0:", -- Magnificent Helmet
	[15671]="0:9782:4:2:1:Cloak::1:0:", -- Magnificent Cloak
	[15672]="0:12164:4:2:1:Mail::1:0:", -- Magnificent Gauntlets
	[15673]="0:11075:4:2:1:Mail::1:0:", -- Magnificent Belt
	[15674]="0:18464:4:2:1:Mail::1:0:", -- Magnificent Greaves
	[15675]="0:26976:4:2:1:Shield::1:0:", -- Magnificent Guard
	[15676]="0:25039:4:2:1:Mail::1:0:", -- Magnificent Leggings
	[15677]="0:18933:4:2:1:Mail::1:0:", -- Magnificent Shoulders
	[15678]="0:19525:4:2:1:Mail::1:0:", -- Triumphant Sabatons
	[15679]="0:12658:4:2:1:Mail::1:0:", -- Triumphant Bracers
	[15680]="0:26811:4:2:1:Mail::1:0:", -- Triumphant Chestpiece
	[15681]="0:11406:4:2:1:Cloak::1:0:", -- Triumphant Cloak
	[15682]="0:13149:4:2:1:Mail::1:0:", -- Triumphant Gauntlets
	[15683]="0:12666:4:2:1:Mail::1:0:", -- Triumphant Girdle
	[15684]="0:20135:4:2:1:Mail::1:0:", -- Triumphant Skullcap
	[15685]="0:26587:4:2:1:Mail::1:0:", -- Triumphant Legplates
	[15686]="0:20099:4:2:1:Mail::1:0:", -- Triumphant Shoulder Pads
	[15687]="0:27239:4:2:1:Shield::1:0:", -- Triumphant Shield
	[15689]="0:4040:4:2:1:Ring::1:0:", -- Trader's Ring
	[15690]="0:4912:4:2:1:Amulet::1:0:", -- Kodobone Necklace
	[15691]="0:6909:2:2:1:Gun::1:0:", -- Sidegunner Shottie
	[15692]="0:6935:2:2:1:Wand::1:0:", -- Kodo Brander
	[15693]="0:14533:4:2:1:Leather::1:0:", -- Grand Shoulders
	[15694]="0:13264:4:2:1:Mail::1:0:", -- Merciless Greaves
	[15695]="0:5984:4:2:1:Shield::1:0:", -- Studded Ring Shield
	[15696]="0:0:12:1:1:::1:0:", -- Ruined Tome
	[15697]="0:2826:4:2:1:Cloth::1:0:", -- Kodo Rustler Boots
	[15698]="0:4273:4:2:1:Mail::1:0:", -- Wrangling Spaulders
	[15699]="0:25:15:1:1:Junk::1:0:", -- Small Brown-wrapped Package
	[15702]="0:7396:4:2:1:Ring::1:0:", -- Chemist's Ring
	[15703]="0:9645:4:2:1:Cloak::1:0:", -- Chemist's Smock
	[15704]="0:6145:4:2:1:Amulet::1:0:", -- Hunter's Insignia Medal
	[15705]="0:33774:2:2:1:OneHandSword::1:0:", -- Tidecrest Blade
	[15706]="0:33905:2:2:1:Dagger::1:0:", -- Hunt Tracker Blade
	[15707]="0:7215:4:2:1:Cloth::1:0:", -- Brantwood Sash
	[15708]="0:9053:4:2:1:Leather::1:0:", -- Blight Leather Gloves
	[15709]="0:12796:4:2:1:Plate::1:0:", -- Gearforge Girdle
	[15710]="0:0:12:1:1:::1:0:", -- Cenarion Lunardust
	[15722]="0:0:12:1:1:::1:0:", -- Spraggle's Canteen
	[15723]="0:2825:0:2:1:Consumable::1:0:", -- Tea with Sugar
	[15724]="12000:3000:9:1:1:Leatherworking::1:1:12956", -- Pattern: Heavy Scorpid Bracers
	[15725]="12000:3000:9:1:1:Leatherworking::1:1:12942,12943", -- Pattern: Wicked Leather Gauntlets
	[15726]="0:3000:9:1:1:Leatherworking::1:0:", -- Pattern: Green Dragonscale Breastplate
	[15727]="0:3000:9:2:1:Leatherworking::1:0:", -- Pattern: Heavy Scorpid Vest
	[15728]="0:3000:9:2:1:Leatherworking::1:0:", -- Pattern: Wicked Leather Bracers
	[15729]="0:3000:9:1:1:Leatherworking::1:0:", -- Pattern: Chimeric Gloves
	[15730]="0:3000:9:3:1:Leatherworking::1:0:", -- Pattern: Red Dragonscale Breastplate
	[15731]="0:3500:9:2:1:Leatherworking::1:0:", -- Pattern: Runic Leather Gauntlets
	[15732]="0:3500:9:2:1:Leatherworking::1:0:", -- Pattern: Volcanic Leggings
	[15733]="0:3500:9:3:1:Leatherworking::1:0:", -- Pattern: Green Dragonscale Leggings
	[15734]="14000:3500:9:1:1:Leatherworking::1:1:7852,7854", -- Pattern: Living Shoulders
	[15735]="14000:3500:9:1:1:Leatherworking::1:1:12958", -- Pattern: Ironfeather Shoulders
	[15736]="0:0:12:1:1:::1:0:", -- Smokey's Special Compound
	[15737]="0:4000:9:2:1:Leatherworking::1:0:", -- Pattern: Chimeric Boots
	[15738]="0:4000:9:2:1:Leatherworking::1:0:", -- Pattern: Heavy Scorpid Gauntlets
	[15739]="0:4000:9:2:1:Leatherworking::1:0:", -- Pattern: Runic Leather Bracers
	[15740]="16000:4000:9:1:1:Leatherworking::1:1:11189", -- Pattern: Frostsaber Boots
	[15741]="16000:4000:9:1:1:Leatherworking::1:1:12942,12943", -- Pattern: Stormshroud Pants
	[15742]="0:4000:9:1:1:Leatherworking::1:0:", -- Pattern: Warbear Harness
	[15743]="0:5000:9:2:1:Leatherworking::1:0:", -- Pattern: Heavy Scorpid Belt
	[15744]="0:5000:9:2:1:Leatherworking::1:0:", -- Pattern: Wicked Leather Headband
	[15745]="0:5000:9:2:1:Leatherworking::1:0:", -- Pattern: Runic Leather Belt
	[15746]="0:5000:9:2:1:Leatherworking::1:0:", -- Pattern: Chimeric Leggings
	[15747]="0:5000:9:2:1:Leatherworking::1:0:", -- Pattern: Frostsaber Leggings
	[15748]="0:5000:9:2:1:Leatherworking::1:0:", -- Pattern: Heavy Scorpid Leggings
	[15749]="0:5000:9:2:1:Leatherworking::1:0:", -- Pattern: Volcanic Breastplate
	[15750]="0:0:12:1:1:::1:0:", -- Sceptre of Light
	[15751]="0:5000:9:1:1:Leatherworking::1:0:", -- Pattern: Blue Dragonscale Breastplate
	[15752]="0:5000:9:3:1:Leatherworking::1:0:", -- Pattern: Living Leggings
	[15753]="0:5000:9:3:1:Leatherworking::1:0:", -- Pattern: Stormshroud Armor
	[15754]="0:5000:9:1:1:Leatherworking::1:0:", -- Pattern: Warbear Woolies
	[15755]="0:5500:9:2:1:Leatherworking::1:0:", -- Pattern: Chimeric Vest
	[15756]="0:5500:9:1:1:Leatherworking::1:0:", -- Pattern: Runic Leather Headband
	[15757]="0:5500:9:2:1:Leatherworking::1:0:", -- Pattern: Wicked Leather Pants
	[15758]="22000:5500:9:1:1:Leatherworking::1:1:12959", -- Pattern: Devilsaur Gauntlets
	[15759]="22000:5500:9:1:1:Leatherworking::1:1:9499", -- Pattern: Black Dragonscale Breastplate
	[15760]="0:5500:9:3:1:Leatherworking::1:0:", -- Pattern: Ironfeather Breastplate
	[15761]="0:6250:9:2:1:Leatherworking::1:0:", -- Pattern: Frostsaber Gloves
	[15762]="25000:6250:9:1:1:Leatherworking::1:1:12956", -- Pattern: Heavy Scorpid Helm
	[15763]="0:6250:9:3:1:Leatherworking::1:0:", -- Pattern: Blue Dragonscale Shoulders
	[15764]="0:6250:9:3:1:Leatherworking::1:0:", -- Pattern: Stormshroud Shoulders
	[15765]="0:7500:9:2:1:Leatherworking::1:0:", -- Pattern: Runic Leather Pants
	[15766]="0:0:12:1:1:::1:0:", -- Gem of the Serpent
	[15767]="0:0:13:1:1:::1:0:", -- Hameya's Key
	[15768]="0:7500:9:2:1:Leatherworking::1:0:", -- Pattern: Wicked Leather Belt
	[15770]="0:7500:9:3:1:Leatherworking::1:0:", -- Pattern: Black Dragonscale Shoulders
	[15771]="0:7500:9:3:1:Leatherworking::1:0:", -- Pattern: Living Breastplate
	[15772]="0:7500:9:3:1:Leatherworking::1:0:", -- Pattern: Devilsaur Leggings
	[15773]="0:10000:9:2:1:Leatherworking::1:0:", -- Pattern: Wicked Leather Armor
	[15774]="0:10000:9:2:1:Leatherworking::1:0:", -- Pattern: Heavy Scorpid Shoulders
	[15775]="0:10000:9:2:1:Leatherworking::1:0:", -- Pattern: Volcanic Shoulders
	[15776]="0:10000:9:2:1:Leatherworking::1:0:", -- Pattern: Runic Leather Armor
	[15777]="0:15000:9:2:1:Leatherworking::1:0:", -- Pattern: Runic Leather Shoulders
	[15778]="0:1250:15:2:1:CombatPet::1:0:", -- Mechanical Yeti
	[15779]="0:15000:9:2:1:Leatherworking::1:0:", -- Pattern: Frostsaber Tunic
	[15781]="0:15000:9:3:1:Leatherworking::1:0:", -- Pattern: Black Dragonscale Leggings
	[15782]="0:43142:2:2:1:OneHandSword::1:0:", -- Beaststalker Blade
	[15783]="0:43292:2:2:1:Dagger::1:0:", -- Beasthunter Dagger
	[15784]="0:11541:4:2:1:Cloth::1:0:", -- Crystal Breeze Mantle
	[15785]="0:0:12:1:1:::1:0:", -- Zaeldarr's Head
	[15786]="0:19381:4:2:1:Leather::1:0:", -- Fernpulse Jerkin
	[15787]="0:23343:4:2:1:Mail::1:0:", -- Willow Band Hauberk
	[15788]="0:0:12:1:1:::1:0:", -- Everlook Report
	[15789]="0:9967:4:2:1:Cloak::1:0:", -- Deep River Cloak
	[15790]="0:0:12:1:1:::1:0:", -- Studies in Spirit Speaking
	[15791]="0:7521:4:2:1:Cloth::1:0:", -- Turquoise Sash
	[15792]="0:14154:4:2:1:Leather::1:0:", -- Plow Wood Spaulders
	[15793]="0:50:15:0:20:Junk::1:0:", -- A Chewed Bone
	[15794]="0:39:4:0:1:Cloth::1:0:", -- Ripped Ogre Loincloth
	[15795]="0:13431:4:2:1:Plate::1:0:", -- Emerald Mist Gauntlets
	[15796]="0:12063:4:2:1:Mail::1:0:", -- Seaspray Bracers
	[15797]="0:14206:4:2:1:Plate::1:0:", -- Shining Armplates
	[15798]="0:50:15:0:20:Junk::1:0:", -- Chipped Ogre Teeth
	[15799]="0:7108:4:3:1:Amulet::1:0:", -- Heroic Commendation Medal
	[15800]="0:43299:2:3:1:OneHandSword::1:0:", -- Intrepid Shortsword
	[15801]="0:43466:2:3:1:OneHandSword::1:0:", -- Valiant Shortsword
	[15802]="0:11648:4:3:1:Cloth::1:0:", -- Mooncloth Boots
	[15803]="0:0:12:1:1:::1:0:", -- Book of the Ancients
	[15804]="0:9781:4:2:1:Cloak::1:0:", -- Cerise Drape
	[15805]="0:14662:4:3:1:OffHandFrill::1:0:", -- Penelope's Rose
	[15806]="0:49514:2:3:1:OneHandSword::1:0:", -- Mirah's Song
	[15807]="294:58:2:1:1:Crossbow::1:0:1287,4602,7976,16715,16919,17667", -- Light Crossbow
	[15808]="3641:728:2:1:1:Crossbow::1:0:1287,4602,7976,16715,16919,17667", -- Fine Light Crossbow
	[15809]="14691:2938:2:1:1:Crossbow::1:0:1287,4602,7976,16715,16919,17667", -- Heavy Crossbow
	[15810]="10145:2029:2:1:1:Polearm::1:0:1289,4601", -- Short Spear
	[15811]="27133:5426:2:1:1:Polearm::1:0:1289,4601", -- Heavy Spear
	[15812]="0:10076:4:2:1:Cloth::1:0:", -- Orchid Amice
	[15813]="0:10113:4:2:1:Mail::1:0:", -- Gold Link Belt
	[15814]="0:41911:2:2:1:OneHandSword::1:0:", -- Hameya's Slayer
	[15815]="0:12619:4:2:1:Cloak::1:0:", -- Hameya's Cloak
	[15822]="0:11446:4:2:1:Leather::1:0:", -- Shadowskin Spaulders
	[15823]="0:9191:4:2:1:Mail::1:0:", -- Bricksteel Gauntlets
	[15824]="0:15385:4:2:1:Cloth::1:0:", -- Astoria Robes
	[15825]="0:19302:4:2:1:Leather::1:0:", -- Traphook Jerkin
	[15826]="0:0:12:1:1:::1:0:", -- Curative Animal Salve
	[15827]="0:23338:4:2:1:Mail::1:0:", -- Jadescale Breastplate
	[15842]="0:0:12:1:1:::1:0:", -- Empty Dreadmist Peak Sampler
	[15843]="0:0:12:1:1:::1:0:", -- Filled Dreadmist Peak Sampler
	[15844]="0:0:12:1:1:::1:0:", -- Empty Cliffspring Falls Sampler
	[15845]="0:0:12:1:1:::1:0:", -- Filled Cliffspring Falls Sampler
	[15846]="0:7500:7:1:1:Device::1:0:", -- Salt Shaker
	[15847]="0:0:12:1:1:::1:0:", -- Quel'Thalas Registry
	[15848]="0:0:12:1:1:::1:0:", -- Crate of Ghost Magnets
	[15849]="0:0:12:1:20:::1:0:", -- Ghost-o-plasm
	[15850]="0:0:12:1:1:::1:0:", -- Patch of Duskwing's Fur
	[15851]="0:0:12:1:20:::1:0:", -- Lunar Fungus
	[15852]="0:0:12:1:20:::1:0:", -- Kodo Horn
	[15853]="0:51418:2:3:1:OneHandAxe::1:0:", -- Windreaper
	[15854]="0:64502:2:3:1:Stave::1:0:", -- Dancing Sliver
	[15855]="0:7888:4:3:1:Ring::1:0:", -- Ring of Protection
	[15856]="0:8788:4:3:1:Amulet::1:0:", -- Archlight Talisman
	[15857]="0:15335:4:3:1:OffHandFrill::1:0:", -- Magebane Scion
	[15858]="0:7516:4:2:1:Cloth::1:0:", -- Freewind Gloves
	[15859]="0:11317:4:2:1:Mail::1:0:", -- Seapost Girdle
	[15860]="0:13997:4:2:1:Plate::1:0:", -- Blinkstrike Armguards
	[15861]="0:14969:4:2:1:Leather::1:0:", -- Swiftfoot Treads
	[15862]="0:28789:2:2:1:OneHandAxe::1:0:", -- Blitzcleaver
	[15863]="0:28896:2:2:1:OneHandMace::1:0:", -- Grave Scepter
	[15864]="0:2043:4:2:1:Cloth::1:0:", -- Condor Bracers
	[15865]="0:6562:4:2:1:Shield::1:0:", -- Anchorhold Buckler
	[15866]="0:562:4:2:1:OffHandFrill::1:0:", -- Veildust Medicine Bag
	[15867]="0:7464:4:2:1:Trinket::1:0:", -- Prismcharm
	[15868]="0:0:12:1:1:::1:0:", -- The Grand Crusader's Command
	[15869]="0:50:13:2:20:::1:0:", -- Silver Skeleton Key
	[15870]="0:300:13:2:20:::1:0:", -- Golden Skeleton Key
	[15871]="0:625:13:2:20:::1:0:", -- Truesilver Skeleton Key
	[15872]="0:625:13:2:20:::1:0:", -- Arcanite Skeleton Key
	[15873]="0:8144:4:3:1:Trinket::1:0:", -- Ragged John's Neverending Cup
	[15874]="0:0:7:1:20:Other::1:0:", -- Soft-shelled Clam
	[15875]="0:0:12:1:1:::1:0:", -- Rotten Apple
	[15876]="0:0:12:1:1:::1:0:", -- Nathanos' Chest
	[15877]="0:0:12:1:1:::1:0:", -- Shrine Bauble
	[15878]="0:0:13:1:1:::1:0:", -- Rackmore's Silver Key
	[15879]="0:0:12:1:1:::1:0:", -- Overlord Ror's Claw
	[15880]="0:0:12:1:1:::1:0:", -- Head of Ramstein the Gorger
	[15881]="0:0:13:1:1:::1:0:", -- Rackmore's Golden Key
	[15882]="0:0:12:1:1:::1:0:", -- Half Pendant of Aquatic Endurance
	[15883]="0:0:12:1:1:::1:0:", -- Half Pendant of Aquatic Agility
	[15884]="0:0:12:1:1:::1:0:", -- Augustus' Receipt Book
	[15885]="0:0:12:1:1:::1:0:", -- Pendant of the Sea Lion
	[15886]="0:0:12:1:1:::1:0:", -- Timolain's Phylactery
	[15887]="0:27581:4:2:1:Shield::1:0:", -- Heroic Guard
	[15890]="0:25831:4:2:1:Shield::1:0:", -- Vanguard Shield
	[15891]="0:2014:4:2:1:Shield::1:0:", -- Hulking Shield
	[15892]="0:3582:4:2:1:Shield::1:0:", -- Slayer's Shield
	[15893]="0:1082:4:2:1:Shield::1:0:", -- Prospector's Buckler
	[15894]="0:1802:4:2:1:Shield::1:0:", -- Bristlebark Buckler
	[15895]="0:53:4:1:1:Shield::1:0:", -- Burnt Buckler
	[15902]="80000:20000:15:1:1:Junk::1:1:12384", -- A Crazy Grab Bag
	[15903]="8118:1623:2:1:1:FistWeapon::1:0:3361,4203,7976,19047", -- Right-Handed Claw
	[15904]="21708:4341:2:1:1:FistWeapon::1:0:3361,4203,7976,19047", -- Right-Handed Blades
	[15905]="2130:426:2:1:1:FistWeapon::1:0:3361,4203,7976,19047", -- Right-Handed Brass Knuckles
	[15906]="2138:427:2:1:1:FistWeapon::1:0:3361,4203,7976,19047", -- Left-Handed Brass Knuckles
	[15907]="8237:1647:2:1:1:FistWeapon::1:0:3361,4203,7976,19047", -- Left-Handed Claw
	[15908]="0:0:12:1:1:::1:0:", -- Taming Rod
	[15909]="22107:4421:2:1:1:FistWeapon::1:0:3361,4203,7976,19047", -- Left-Handed Blades
	[15911]="0:0:12:1:1:::1:0:", -- Taming Rod
	[15912]="0:1148:4:2:1:OffHandFrill::1:0:", -- Buccaneer's Orb
	[15913]="0:0:12:1:1:::1:0:", -- Taming Rod
	[15914]="0:0:12:1:1:::1:0:", -- Taming Rod
	[15915]="0:0:12:1:1:::1:0:", -- Taming Rod
	[15916]="0:0:12:1:1:::1:0:", -- Taming Rod
	[15917]="0:0:12:1:1:::1:0:", -- Taming Rod
	[15918]="0:4848:4:2:1:OffHandFrill::1:0:", -- Conjurer's Sphere
	[15919]="0:0:12:1:1:::1:0:", -- Taming Rod
	[15920]="0:0:12:1:1:::1:0:", -- Taming Rod
	[15921]="0:0:12:1:1:::1:0:", -- Taming Rod
	[15922]="0:0:12:1:1:::1:0:", -- Taming Rod
	[15923]="0:0:12:1:1:::1:0:", -- Taming Rod
	[15924]="0:0:12:1:10:::1:0:", -- Soft-shelled Clam Meat
	[15925]="0:439:4:2:1:OffHandFrill::1:0:", -- Journeyman's Stave
	[15926]="0:802:4:2:1:OffHandFrill::1:0:", -- Spellbinder Orb
	[15927]="0:1864:4:2:1:OffHandFrill::1:0:", -- Bright Sphere
	[15928]="0:2387:4:2:1:OffHandFrill::1:0:", -- Silver-thread Rod
	[15929]="0:4396:4:2:1:OffHandFrill::1:0:", -- Nightsky Orb
	[15930]="0:9146:4:2:1:OffHandFrill::1:0:", -- Imperial Red Scepter
	[15931]="0:10646:4:2:1:OffHandFrill::1:0:", -- Arcane Star
	[15932]="0:527:4:2:1:OffHandFrill::1:0:", -- Disciple's Stein
	[15933]="0:620:4:2:1:OffHandFrill::1:0:", -- Simple Branch
	[15934]="0:2596:4:2:1:OffHandFrill::1:0:", -- Sage's Stave
	[15935]="0:3323:4:2:1:OffHandFrill::1:0:", -- Durable Rod
	[15936]="0:8950:4:2:1:OffHandFrill::1:0:", -- Duskwoven Branch
	[15937]="0:7922:4:2:1:OffHandFrill::1:0:", -- Hibernal Sphere
	[15938]="0:9550:4:2:1:OffHandFrill::1:0:", -- Mystical Orb
	[15939]="0:10455:4:2:1:OffHandFrill::1:0:", -- Councillor's Scepter
	[15940]="0:10957:4:2:1:OffHandFrill::1:0:", -- Elegant Scepter
	[15941]="0:12345:4:2:1:OffHandFrill::1:0:", -- High Councillor's Scepter
	[15942]="0:12757:4:2:1:OffHandFrill::1:0:", -- Master's Rod
	[15943]="0:26800:4:2:1:Shield::1:0:", -- Imbued Shield
	[15944]="0:512:4:2:1:OffHandFrill::1:0:", -- Ancestral Orb
	[15945]="0:837:4:2:1:OffHandFrill::1:0:", -- Runic Stave
	[15946]="0:802:4:2:1:OffHandFrill::1:0:", -- Mystic's Sphere
	[15947]="0:1887:4:2:1:OffHandFrill::1:0:", -- Sanguine Star
	[15962]="0:2716:4:2:1:OffHandFrill::1:0:", -- Satyr's Rod
	[15963]="0:4887:4:2:1:OffHandFrill::1:0:", -- Stonecloth Branch
	[15964]="0:6364:4:2:1:OffHandFrill::1:0:", -- Silksand Star
	[15965]="0:7996:4:2:1:OffHandFrill::1:0:", -- Windchaser Orb
	[15966]="0:9137:4:2:1:OffHandFrill::1:0:", -- Venomshroud Orb
	[15967]="0:10304:4:2:1:OffHandFrill::1:0:", -- Highborne Star
	[15968]="0:802:4:2:1:OffHandFrill::1:0:", -- Elunarian Sphere
	[15969]="0:425:4:2:1:OffHandFrill::1:0:", -- Beaded Orb
	[15970]="0:587:4:2:1:OffHandFrill::1:0:", -- Native Branch
	[15971]="0:1064:4:2:1:OffHandFrill::1:0:", -- Aboriginal Rod
	[15972]="0:1171:4:2:1:OffHandFrill::1:0:", -- Ritual Stein
	[15973]="0:2313:4:2:1:OffHandFrill::1:0:", -- Watcher's Star
	[15974]="0:1461:4:2:1:OffHandFrill::1:0:", -- Pagan Rod
	[15975]="0:2421:4:2:1:OffHandFrill::1:0:", -- Raincaller Scepter
	[15976]="0:4146:4:2:1:OffHandFrill::1:0:", -- Thistlefur Branch
	[15977]="0:4614:4:2:1:OffHandFrill::1:0:", -- Vital Orb
	[15978]="0:5385:4:2:1:OffHandFrill::1:0:", -- Geomancer's Rod
	[15979]="0:7215:4:2:1:OffHandFrill::1:0:", -- Embersilk Stave
	[15980]="0:7469:4:2:1:OffHandFrill::1:0:", -- Darkmist Orb
	[15981]="0:7215:4:2:1:OffHandFrill::1:0:", -- Lunar Sphere
	[15982]="0:8142:4:2:1:OffHandFrill::1:0:", -- Bloodwoven Rod
	[15983]="0:8387:4:2:1:OffHandFrill::1:0:", -- Gaea's Scepter
	[15984]="0:9614:4:2:1:OffHandFrill::1:0:", -- Opulent Scepter
	[15985]="0:9887:4:2:1:OffHandFrill::1:0:", -- Arachnidian Branch
	[15986]="0:10813:4:2:1:OffHandFrill::1:0:", -- Bonecaster's Star
	[15987]="0:10996:4:2:1:OffHandFrill::1:0:", -- Astral Orb
	[15988]="0:12471:4:2:1:OffHandFrill::1:0:", -- Resplendent Orb
	[15989]="0:12498:4:2:1:OffHandFrill::1:0:", -- Eternal Rod
	[15990]="0:6850:4:2:1:Shield::1:0:", -- Enduring Shield
	[15991]="0:26309:4:2:1:Shield::1:0:", -- Warleader's Shield
	[15992]="0:250:7:1:20:Part:202:1:0:", -- Dense Blasting Powder
	[15993]="0:1500:7:1:20:Explosive::1:0:", -- Thorium Grenade
	[15994]="0:2500:7:1:10:Part:202:1:0:", -- Thorium Widget
	[15995]="0:19739:2:2:1:Gun::1:0:", -- Thorium Rifle
	[15996]="0:2500:15:1:1:Companion::1:0:", -- Lifelike Mechanical Toad
	[15997]="0:10:6:2:1000:Bullet::1:0:", -- Thorium Shells
	[15998]="0:0:12:1:1:::1:0:", -- Lewis' Note
	[15999]="0:9003:4:2:1:Cloth::1:0:", -- Spellpower Goggles Xtreme Plus
	[16000]="0:3750:7:1:20:Part:202:1:0:", -- Thorium Tube
	[16001]="0:0:12:1:1:::1:0:", -- SI:7 Insignia (Fredo)
	[16002]="0:0:12:1:1:::1:0:", -- SI:7 Insignia (Turyen)
	[16003]="0:0:12:1:1:::1:0:", -- SI:7 Insignia (Rutger)
	[16004]="0:29152:2:3:1:Gun::1:0:", -- Dark Iron Rifle
	[16005]="0:1250:7:1:20:Explosive::1:0:", -- Dark Iron Bomb
	[16006]="0:10000:7:1:10:Part:202:1:0:", -- Delicate Arcanite Converter
	[16007]="0:39231:2:3:1:Gun::1:0:", -- Flawless Arcanite Rifle
	[16008]="0:11739:4:2:1:Cloth::1:0:", -- Master Engineer's Goggles
	[16009]="0:5930:4:2:1:Amulet::1:0:", -- Voice Amplification Modulator
	[16022]="0:40000:4:3:1:Trinket::1:0:", -- Arcanite Dragonling
	[16023]="0:10000:15:1:10:CombatPet::1:0:", -- Masterwork Target Dummy
	[16039]="0:53598:2:3:1:TwoHandSword::1:0:", -- Ta'Kierthan Songblade
	[16040]="0:4000:7:1:20:Explosive::1:0:", -- Arcane Bomb
	[16041]="0:3000:9:1:1:Engineering::1:0:", -- Schematic: Thorium Grenade
	[16042]="0:3000:9:1:1:Engineering::1:0:", -- Schematic: Thorium Widget
	[16043]="0:3000:9:2:1:Engineering::1:0:", -- Schematic: Thorium Rifle
	[16044]="0:4000:9:2:1:Engineering::1:0:", -- Schematic: Lifelike Mechanical Toad
	[16045]="0:4000:9:2:1:Engineering::1:0:", -- Schematic: Spellpower Goggles Xtreme Plus
	[16046]="16000:4000:9:1:1:Engineering::1:1:11185", -- Schematic: Masterwork Target Dummy
	[16047]="0:4000:9:1:1:Engineering::1:0:", -- Schematic: Thorium Tube
	[16048]="0:4000:9:2:1:Engineering::1:0:", -- Schematic: Dark Iron Rifle
	[16049]="0:5000:9:2:1:Engineering::1:0:", -- Schematic: Dark Iron Bomb
	[16050]="20000:5000:9:1:1:Engineering::1:1:11185", -- Schematic: Delicate Arcanite Converter
	[16051]="0:5000:9:2:1:Engineering::1:0:", -- Schematic: Thorium Shells
	[16052]="0:5000:9:2:1:Engineering::1:0:", -- Schematic: Voice Amplification Modulator
	[16053]="0:5000:9:2:1:Engineering::1:0:", -- Schematic: Master Engineer's Goggles
	[16054]="0:6000:9:2:1:Engineering::1:0:", -- Schematic: Arcanite Dragonling
	[16055]="0:6000:9:2:1:Engineering::1:0:", -- Schematic: Arcane Bomb
	[16056]="0:6000:9:2:1:Engineering::1:0:", -- Schematic: Flawless Arcanite Rifle
	[16058]="0:10156:4:3:1:Ring::1:0:", -- Fordring's Seal
	[16059]="400:100:4:1:1:Shirt::1:0:1214,1291,3317,3486,3554,3683,4185,4558,5108,8358,16623,16631,16716", -- Common Brown Shirt
	[16060]="400:100:4:1:1:Shirt::1:0:1214,1291,3317,3486,3554,3683,4185,4558,5108,8358,16623,16631,16716", -- Common White Shirt
	[16072]="10000:2500:9:1:1:Cooking::1:0:3955,12033", -- Expert Cookbook
	[16083]="10000:2500:9:1:1:Fishing::1:0:2626", -- Expert Fishing - The Bass and You
	[16084]="10000:2500:9:1:1:FirstAid::1:0:2805,13476", -- Expert First Aid - Under Wraps
	[16085]="0:5000:9:1:1:FirstAid::1:0:", -- Artisan First Aid - Heal Thyself
	[16110]="12000:3000:9:1:1:Cooking::1:0:2803,2806,11187", -- Recipe: Monster Omelet
	[16111]="12000:3000:9:1:1:Cooking::1:0:989,1149,4305", -- Recipe: Spiced Chili Crab
	[16112]="2200:550:9:1:1:FirstAid::1:0:2805,13476", -- Manual: Heavy Silk Bandage
	[16113]="5000:1250:9:1:1:FirstAid::1:0:2805,13476", -- Manual: Mageweave Bandage
	[16114]="0:0:12:1:1:::1:0:", -- Foreman's Blackjack
	[16115]="0:0:12:1:1:::1:0:", -- Osric's Crate
	[16166]="25:1:0:1:20:FoodDrink::5:0:2303,3961,4167,4181,4191,4195,4266,6091,7941,12019,12026", -- Bean Soup
	[16167]="125:6:0:1:20:FoodDrink::5:0:2303,3961,4167,4181,4191,4195,4266,6091,7941,12019,12026", -- Versicolor Treat
	[16168]="2000:100:0:1:20:FoodDrink::5:0:2303,3961,4167,4181,4191,4195,4266,6091,7941,12019,12026", -- Heaven Peach
	[16169]="1000:62:0:1:20:FoodDrink::5:0:2303,3961,4167,4181,4191,4195,4266,6091,7941,12019,12026", -- Wild Ricecake
	[16170]="500:25:0:1:20:FoodDrink::5:0:2303,3961,4167,4181,4191,4195,4266,6091,7941,12019,12026", -- Steamed Mandu
	[16171]="0:200:0:1:20:FoodDrink::1:0:", -- Shinsollo
	[16189]="0:0:12:1:1:::1:0:", -- Maggran's Reserve Letter
	[16190]="0:0:12:1:1:::1:0:", -- Bloodfury Ripper's Remains
	[16192]="0:0:12:1:1:::1:0:", -- Besseleth's Fang
	[16202]="0:0:7:2:10:Enchanting:333:1:0:", -- Lesser Eternal Essence
	[16203]="0:0:7:2:10:Enchanting:333,197:1:0:", -- Greater Eternal Essence
	[16204]="0:0:7:1:20:Enchanting:333:1:0:", -- Illusion Dust
	[16205]="0:0:12:1:10:::1:0:", -- Gaea Seed
	[16206]="0:1000:7:1:1:Enchanting:333:1:0:", -- Arcanite Rod
	[16207]="0:1250:7:1:1:Enchanting:333:1:0:", -- Runed Arcanite Rod
	[16208]="0:0:12:1:1:::1:0:", -- Enchanted Gaea Seeds
	[16209]="0:0:12:1:1:::1:0:", -- Podrig's Order
	[16210]="0:0:12:1:1:::1:0:", -- Gordon's Crate
	[16214]="0:3000:9:2:1:Enchanting::1:0:", -- Formula: Enchant Bracer - Greater Intellect
	[16215]="0:3000:9:2:1:Enchanting::1:0:", -- Formula: Enchant Boots - Greater Stamina
	[16216]="0:3000:9:2:1:Enchanting::1:0:", -- Formula: Enchant Cloak - Greater Resistance
	[16217]="12000:3000:9:1:1:Enchanting::1:1:4229,4561", -- Formula: Enchant Shield - Greater Stamina
	[16218]="0:3500:9:2:1:Enchanting::1:0:", -- Formula: Enchant Bracer - Superior Spirit
	[16219]="0:3500:9:2:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Greater Agility
	[16220]="0:4000:9:2:1:Enchanting::1:0:", -- Formula: Enchant Boots - Spirit
	[16221]="16000:4000:9:1:1:Enchanting::1:1:11189", -- Formula: Enchant Chest - Major Health
	[16222]="0:5000:9:2:1:Enchanting::1:0:", -- Formula: Enchant Shield - Superior Spirit
	[16223]="0:5000:9:2:1:Enchanting::1:0:", -- Formula: Enchant Weapon - Icy Chill
	[16224]="20000:5000:9:1:1:Enchanting::1:1:12022", -- Formula: Enchant Cloak - Superior Defense
	[16242]="0:5500:9:2:1:Enchanting::1:0:", -- Formula: Enchant Chest - Major Mana
	[16243]="22000:5500:9:1:1:Enchanting::1:1:12022", -- Formula: Runed Arcanite Rod
	[16244]="0:6000:9:2:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Greater Strength
	[16245]="0:6000:9:2:1:Enchanting::1:0:", -- Formula: Enchant Boots - Greater Agility
	[16246]="0:6000:9:2:1:Enchanting::1:0:", -- Formula: Enchant Bracer - Superior Strength
	[16247]="0:6000:9:2:1:Enchanting::1:0:", -- Formula: Enchant 2H Weapon - Superior Impact
	[16248]="0:6000:9:2:1:Enchanting::1:0:", -- Formula: Enchant Weapon - Unholy
	[16249]="0:7500:9:2:1:Enchanting::1:0:", -- Formula: Enchant 2H Weapon - Major Intellect
	[16250]="0:7500:9:2:1:Enchanting::1:0:", -- Formula: Enchant Weapon - Superior Striking
	[16251]="0:7500:9:2:1:Enchanting::1:0:", -- Formula: Enchant Bracer - Superior Stamina
	[16252]="0:7500:9:2:1:Enchanting::1:0:", -- Formula: Enchant Weapon - Crusader
	[16253]="0:7500:9:2:1:Enchanting::1:0:", -- Formula: Enchant Chest - Greater Stats
	[16254]="0:7500:9:3:1:Enchanting::1:0:", -- Formula: Enchant Weapon - Lifestealing
	[16255]="0:7500:9:2:1:Enchanting::1:0:", -- Formula: Enchant 2H Weapon - Major Spirit
	[16262]="0:0:12:1:1:::1:0:", -- Nessa's Collection
	[16263]="0:0:12:1:1:::1:0:", -- Laird's Response
	[16282]="0:0:12:1:1:::1:0:", -- Bundle of Hides
	[16283]="0:0:12:1:1:::1:0:", -- Ahanu's Leather Goods
	[16302]="100:25:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Firebolt (Rank 2)
	[16303]="0:0:12:2:1:::1:0:", -- Ursangous's Paw
	[16304]="0:0:12:2:1:::1:0:", -- Shadumbra's Head
	[16305]="0:0:12:2:1:::1:0:", -- Sharptalon's Claw
	[16306]="0:0:12:1:1:::1:0:", -- Zargh's Meats
	[16307]="0:0:12:1:1:::1:0:", -- Gryshka's Letter
	[16309]="0:0:4:3:1:Amulet::1:0:", -- Drakefire Amulet
	[16310]="0:0:12:1:1:::1:0:", -- Brock's List
	[16311]="0:0:12:1:1:::1:0:", -- Honorary Picks
	[16312]="0:0:12:1:10:::1:0:", -- Incendrites
	[16313]="0:0:12:1:1:::1:0:", -- Felix's Chest
	[16314]="0:0:12:1:1:::1:0:", -- Felix's Bucket of Bolts
	[16316]="1500:375:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Firebolt (Rank 3)
	[16317]="5000:1250:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Firebolt (Rank 4)
	[16318]="10000:2500:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Firebolt (Rank 5)
	[16319]="14000:3500:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Firebolt (Rank 6)
	[16320]="24000:6000:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Firebolt (Rank 7)
	[16321]="100:25:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Blood Pact (Rank 1)
	[16322]="900:225:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Blood Pact (Rank 2)
	[16323]="4000:1000:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Blood Pact (Rank 3)
	[16324]="10000:2500:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Blood Pact (Rank 4)
	[16325]="15000:3750:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Blood Pact (Rank 5)
	[16326]="900:225:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Fire Shield (Rank 1)
	[16327]="3000:750:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Fire Shield (Rank 2)
	[16328]="8000:2000:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Fire Shield (Rank 3)
	[16329]="12000:3000:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Fire Shield (Rank 4)
	[16330]="20000:5000:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Fire Shield (Rank 5)
	[16331]="600:150:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Phase Shift
	[16332]="0:0:12:1:1:::1:0:", -- Thazz'ril's Pick
	[16333]="0:0:12:1:1:::1:0:", -- Samuel's Remains
	[16335]="0:0:4:3:1:Amulet::1:0:12793,12799", -- Senior Sergeant's Insignia
	[16339]="0:0:15:1:1:Mount::1:0:", -- Commander's Steed
	[16341]="0:0:4:3:1:Cloak::1:0:12793,12799", -- Sergeant's Cloak
	[16342]="0:0:4:3:1:Cloak::1:0:12781,12805", -- Sergeant's Cape
	[16345]="0:0:2:4:1:OneHandSword::1:0:12794", -- High Warlord's Blade
	[16346]="2000:500:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Torment (Rank 2)
	[16347]="6000:1500:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Torment (Rank 3)
	[16348]="11000:2750:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Torment (Rank 4)
	[16349]="15000:3750:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Torment (Rank 5)
	[16350]="26000:6500:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Torment (Rank 6)
	[16351]="1200:300:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Sacrifice (Rank 1)
	[16352]="3000:750:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Sacrifice (Rank 2)
	[16353]="7000:1750:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Sacrifice (Rank 3)
	[16354]="11000:2750:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Sacrifice (Rank 4)
	[16355]="14000:3500:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Sacrifice (Rank 5)
	[16356]="22000:5500:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Sacrifice (Rank 6)
	[16357]="1500:375:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Consume Shadows (Rank 1)
	[16358]="4000:1000:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Consume Shadows (Rank 2)
	[16359]="8000:2000:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Consume Shadows (Rank 3)
	[16360]="11000:2750:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Consume Shadows (Rank 4)
	[16361]="15000:3750:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Consume Shadows (Rank 5)
	[16362]="24000:6000:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Consume Shadows (Rank 6)
	[16363]="3000:750:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Suffering (Rank 1)
	[16364]="9000:2250:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Suffering (Rank 2)
	[16365]="14000:3500:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Suffering (Rank 3)
	[16366]="26000:6500:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Suffering (Rank 4)
	[16368]="5000:1250:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Lash of Pain (Rank 2)
	[16369]="0:7575:4:3:1:Cloth::1:0:", -- Knight-Lieutenant's Silk Boots
	[16371]="9000:2250:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Lash of Pain (Rank 3)
	[16372]="12000:3000:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Lash of Pain (Rank 4)
	[16373]="18000:4500:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Lash of Pain (Rank 5)
	[16374]="26000:6500:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Lash of Pain (Rank 6)
	[16375]="2500:625:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Soothing Kiss (Rank 1)
	[16376]="8000:2000:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Soothing Kiss (Rank 2)
	[16377]="13000:3250:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Soothing Kiss (Rank 3)
	[16378]="24000:6000:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Soothing Kiss (Rank 4)
	[16379]="4000:1000:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Seduction
	[16380]="7000:1750:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Lesser Invisibility
	[16381]="10000:2500:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Devour Magic (Rank 2)
	[16382]="13000:3250:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Devour Magic (Rank 3)
	[16383]="20000:5000:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Devour Magic (Rank 4)
	[16384]="7000:1750:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Tainted Blood (Rank 1)
	[16385]="11000:2750:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Tainted Blood (Rank 2)
	[16386]="14000:3500:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Tainted Blood (Rank 3)
	[16387]="22000:5500:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Tainted Blood (Rank 4)
	[16388]="9000:2250:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Spell Lock (Rank 1)
	[16389]="18000:4500:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Spell Lock (Rank 2)
	[16390]="11000:2750:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Paranoia
	[16391]="0:5087:4:3:1:Cloth::1:0:", -- Knight-Lieutenant's Silk Gloves
	[16392]="0:9574:4:3:1:Leather::1:0:", -- Knight-Lieutenant's Leather Boots
	[16393]="0:9609:4:3:1:Leather::1:0:", -- Knight-Lieutenant's Dragonhide Footwraps
	[16396]="0:6650:4:3:1:Leather::1:0:", -- Knight-Lieutenant's Leather Gauntlets
	[16397]="0:6673:4:3:1:Leather::1:0:", -- Knight-Lieutenant's Dragonhide Gloves
	[16401]="0:12237:4:3:1:Mail::1:0:", -- Knight-Lieutenant's Chain Boots
	[16403]="0:7401:4:3:1:Mail::1:0:", -- Knight-Lieutenant's Chain Gauntlets
	[16405]="0:13027:4:3:1:Plate::1:0:", -- Knight-Lieutenant's Plate Boots
	[16406]="0:8785:4:3:1:Plate::1:0:", -- Knight-Lieutenant's Plate Gauntlets
	[16408]="0:0:12:2:1:::1:0:", -- Befouled Water Globe
	[16409]="0:13227:4:3:1:Plate::1:0:", -- Knight-Lieutenant's Lamellar Sabatons
	[16410]="0:8919:4:3:1:Plate::1:0:", -- Knight-Lieutenant's Lamellar Gauntlets
	[16413]="0:10524:4:3:1:Cloth::1:0:", -- Knight-Captain's Silk Raiment
	[16414]="0:10562:4:3:1:Cloth::1:0:", -- Knight-Captain's Silk Leggings
	[16415]="0:7950:4:3:1:Cloth::1:0:", -- Lieutenant Commander's Silk Spaulders
	[16416]="0:7978:4:3:1:Cloth::1:0:", -- Lieutenant Commander's Crown
	[16417]="0:13345:4:3:1:Leather::1:0:", -- Knight-Captain's Leather Armor
	[16418]="0:10045:4:3:1:Leather::1:0:", -- Lieutenant Commander's Leather Veil
	[16419]="0:13441:4:3:1:Leather::1:0:", -- Knight-Captain's Leather Legguards
	[16420]="0:10116:4:3:1:Leather::1:0:", -- Lieutenant Commander's Leather Spaulders
	[16421]="0:13536:4:3:1:Leather::1:0:", -- Knight-Captain's Dragonhide Tunic
	[16422]="0:13583:4:3:1:Leather::1:0:", -- Knight-Captain's Dragonhide Leggings
	[16423]="0:9251:4:3:1:Leather::1:0:", -- Lieutenant Commander's Dragonhide Epaulets
	[16424]="0:9286:4:3:1:Leather::1:0:", -- Lieutenant Commander's Dragonhide Shroud
	[16425]="0:14915:4:3:1:Mail::1:0:", -- Knight-Captain's Chain Hauberk
	[16426]="0:14972:4:3:1:Mail::1:0:", -- Knight-Captain's Chain Leggings
	[16427]="0:11632:4:3:1:Mail::1:0:", -- Lieutenant Commander's Chain Pauldrons
	[16428]="0:11623:4:3:1:Mail::1:0:", -- Lieutenant Commander's Chain Helmet
	[16429]="0:13585:4:3:1:Plate::1:0:", -- Lieutenant Commander's Plate Helm
	[16430]="0:18215:4:3:1:Plate::1:0:", -- Knight-Captain's Plate Chestguard
	[16431]="0:18281:4:3:1:Plate::1:0:", -- Knight-Captain's Plate Leggings
	[16432]="0:13734:4:3:1:Plate::1:0:", -- Lieutenant Commander's Plate Pauldrons
	[16433]="0:18415:4:3:1:Plate::1:0:", -- Knight-Captain's Lamellar Breastplate
	[16434]="0:13835:4:3:1:Plate::1:0:", -- Lieutenant Commander's Lamellar Headguard
	[16435]="0:18547:4:3:1:Plate::1:0:", -- Knight-Captain's Lamellar Leggings
	[16436]="0:13934:4:3:1:Plate::1:0:", -- Lieutenant Commander's Lamellar Shoulders
	[16437]="0:0:4:4:1:Cloth::1:0:12785", -- Marshal's Silk Footwraps
	[16440]="0:0:4:4:1:Cloth::1:0:12785", -- Marshal's Silk Gloves
	[16441]="0:0:4:4:1:Cloth::1:0:12785", -- Field Marshal's Coronet
	[16442]="0:0:4:4:1:Cloth::1:0:12785", -- Marshal's Silk Leggings
	[16443]="0:0:4:4:1:Cloth::1:0:12785", -- Field Marshal's Silk Vestments
	[16444]="0:0:4:4:1:Cloth::1:0:12785", -- Field Marshal's Silk Spaulders
	[16446]="0:0:4:4:1:Leather::1:0:12785", -- Marshal's Leather Footguards
	[16448]="0:0:4:4:1:Leather::1:0:", -- Marshal's Dragonhide Gauntlets
	[16449]="0:0:4:4:1:Leather::1:0:", -- Field Marshal's Dragonhide Spaulders
	[16450]="0:0:4:4:1:Leather::1:0:", -- Marshal's Dragonhide Legguards
	[16451]="0:0:4:4:1:Leather::1:0:", -- Field Marshal's Dragonhide Helmet
	[16452]="0:0:4:4:1:Leather::1:0:", -- Field Marshal's Dragonhide Breastplate
	[16453]="0:0:4:4:1:Leather::1:0:12785", -- Field Marshal's Leather Chestpiece
	[16454]="0:0:4:4:1:Leather::1:0:12785", -- Marshal's Leather Handgrips
	[16455]="0:0:4:4:1:Leather::1:0:12785", -- Field Marshal's Leather Mask
	[16456]="0:0:4:4:1:Leather::1:0:12785", -- Marshal's Leather Leggings
	[16457]="0:0:4:4:1:Leather::1:0:12785", -- Field Marshal's Leather Epaulets
	[16459]="0:0:4:4:1:Leather::1:0:", -- Marshal's Dragonhide Boots
	[16462]="0:0:4:4:1:Mail::1:0:12785", -- Marshal's Chain Boots
	[16463]="0:0:4:4:1:Mail::1:0:12785", -- Marshal's Chain Grips
	[16465]="0:0:4:4:1:Mail::1:0:12785", -- Field Marshal's Chain Helm
	[16466]="0:0:4:4:1:Mail::1:0:12785", -- Field Marshal's Chain Breastplate
	[16467]="0:0:4:4:1:Mail::1:0:12785", -- Marshal's Chain Legguards
	[16468]="0:0:4:4:1:Mail::1:0:12785", -- Field Marshal's Chain Spaulders
	[16471]="0:0:4:4:1:Plate::1:0:12785", -- Marshal's Lamellar Gloves
	[16472]="0:0:4:4:1:Plate::1:0:12785", -- Marshal's Lamellar Boots
	[16473]="0:0:4:4:1:Plate::1:0:12785", -- Field Marshal's Lamellar Chestplate
	[16474]="0:0:4:4:1:Plate::1:0:12785", -- Field Marshal's Lamellar Faceguard
	[16475]="0:0:4:4:1:Plate::1:0:12785", -- Marshal's Lamellar Legplates
	[16476]="0:0:4:4:1:Plate::1:0:12785", -- Field Marshal's Lamellar Pauldrons
	[16477]="0:0:4:4:1:Plate::1:0:12785", -- Field Marshal's Plate Armor
	[16478]="0:0:4:4:1:Plate::1:0:12785", -- Field Marshal's Plate Helm
	[16479]="0:0:4:4:1:Plate::1:0:12785", -- Marshal's Plate Legguards
	[16480]="0:0:4:4:1:Plate::1:0:12785", -- Field Marshal's Plate Shoulderguards
	[16483]="0:0:4:4:1:Plate::1:0:12785", -- Marshal's Plate Boots
	[16484]="0:0:4:4:1:Plate::1:0:12785", -- Marshal's Plate Gauntlets
	[16485]="0:7660:4:3:1:Cloth::1:0:", -- Blood Guard's Silk Footwraps
	[16486]="0:0:4:3:1:Cloth::1:0:12793,12799", -- First Sergeant's Silk Cuffs
	[16487]="0:5145:4:3:1:Cloth::1:0:", -- Blood Guard's Silk Gloves
	[16489]="0:7774:4:3:1:Cloth::1:0:", -- Champion's Silk Hood
	[16490]="0:10404:4:3:1:Cloth::1:0:", -- Legionnaire's Silk Pants
	[16491]="0:10716:4:3:1:Cloth::1:0:", -- Legionnaire's Silk Robes
	[16492]="0:8066:4:3:1:Cloth::1:0:", -- Champion's Silk Shoulderpads
	[16494]="0:10154:4:3:1:Leather::1:0:", -- Blood Guard's Dragonhide Boots
	[16496]="0:6168:4:3:1:Leather::1:0:", -- Blood Guard's Dragonhide Gauntlets
	[16497]="0:0:4:3:1:Leather::1:0:12793,12799", -- First Sergeant's Leather Armguards
	[16498]="0:9325:4:3:1:Leather::1:0:", -- Blood Guard's Leather Treads
	[16499]="0:6240:4:3:1:Leather::1:0:", -- Blood Guard's Leather Vices
	[16501]="0:9431:4:3:1:Leather::1:0:", -- Champion's Dragonhide Spaulders
	[16502]="0:12623:4:3:1:Leather::1:0:", -- Legionnaire's Dragonhide Trousers
	[16503]="0:9502:4:3:1:Leather::1:0:", -- Champion's Dragonhide Helm
	[16504]="0:12718:4:3:1:Leather::1:0:", -- Legionnaire's Dragonhide Breastplate
	[16505]="0:12766:4:3:1:Leather::1:0:", -- Legionnaire's Leather Hauberk
	[16506]="0:9609:4:3:1:Leather::1:0:", -- Champion's Leather Headguard
	[16507]="0:9903:4:3:1:Leather::1:0:", -- Champion's Leather Mantle
	[16508]="0:13252:4:3:1:Leather::1:0:", -- Legionnaire's Leather Leggings
	[16509]="0:13938:4:3:1:Plate::1:0:", -- Blood Guard's Plate Boots
	[16510]="0:0:4:3:1:Plate::1:0:", -- Blood Guard's Plate Gloves
	[16513]="0:18886:4:3:1:Plate::1:0:", -- Legionnaire's Plate Armor
	[16514]="0:14187:4:3:1:Plate::1:0:", -- Champion's Plate Headguard
	[16515]="0:19019:4:3:1:Plate::1:0:", -- Legionnaire's Plate Legguards
	[16516]="0:12928:4:3:1:Plate::1:0:", -- Champion's Plate Pauldrons
	[16518]="0:11237:4:3:1:Mail::1:0:", -- Blood Guard's Mail Walkers
	[16519]="0:7487:4:3:1:Mail::1:0:", -- Blood Guard's Mail Grips
	[16521]="0:11316:4:3:1:Mail::1:0:", -- Champion's Mail Helm
	[16522]="0:15145:4:3:1:Mail::1:0:", -- Legionnaire's Mail Chestpiece
	[16523]="0:15615:4:3:1:Mail::1:0:", -- Legionnaire's Mail Leggings
	[16524]="0:11806:4:3:1:Mail::1:0:", -- Champion's Mail Shoulders
	[16525]="0:15728:4:3:1:Mail::1:0:", -- Legionnaire's Chain Breastplate
	[16526]="0:11839:4:3:1:Mail::1:0:", -- Champion's Chain Headguard
	[16527]="0:15843:4:3:1:Mail::1:0:", -- Legionnaire's Chain Leggings
	[16528]="0:11978:4:3:1:Mail::1:0:", -- Champion's Chain Pauldrons
	[16530]="0:8007:4:3:1:Mail::1:0:", -- Blood Guard's Chain Gauntlets
	[16531]="0:12107:4:3:1:Mail::1:0:", -- Blood Guard's Chain Boots
	[16532]="0:0:4:3:1:Mail::1:0:12793,12799", -- First Sergeant's Mail Wristguards
	[16533]="0:0:4:4:1:Cloth::1:0:12795", -- Warlord's Silk Cowl
	[16534]="0:0:4:4:1:Cloth::1:0:12795", -- General's Silk Trousers
	[16535]="0:0:4:4:1:Cloth::1:0:12795", -- Warlord's Silk Raiment
	[16536]="0:0:4:4:1:Cloth::1:0:12795", -- Warlord's Silk Amice
	[16539]="0:0:4:4:1:Cloth::1:0:12795", -- General's Silk Boots
	[16540]="0:0:4:4:1:Cloth::1:0:12795", -- General's Silk Handguards
	[16541]="0:0:4:4:1:Plate::1:0:12795", -- Warlord's Plate Armor
	[16542]="0:0:4:4:1:Plate::1:0:12795", -- Warlord's Plate Headpiece
	[16543]="0:0:4:4:1:Plate::1:0:12795", -- General's Plate Leggings
	[16544]="0:0:4:4:1:Plate::1:0:12795", -- Warlord's Plate Shoulders
	[16545]="0:0:4:4:1:Plate::1:0:12795", -- General's Plate Boots
	[16548]="0:0:4:4:1:Plate::1:0:12795", -- General's Plate Gauntlets
	[16549]="0:0:4:4:1:Leather::1:0:12795", -- Warlord's Dragonhide Hauberk
	[16550]="0:0:4:4:1:Leather::1:0:12795", -- Warlord's Dragonhide Helmet
	[16551]="0:0:4:4:1:Leather::1:0:12795", -- Warlord's Dragonhide Epaulets
	[16552]="0:0:4:4:1:Leather::1:0:12795", -- General's Dragonhide Leggings
	[16554]="0:0:4:4:1:Leather::1:0:12795", -- General's Dragonhide Boots
	[16555]="0:0:4:4:1:Leather::1:0:12795", -- General's Dragonhide Gloves
	[16558]="0:0:4:4:1:Leather::1:0:12795", -- General's Leather Treads
	[16560]="0:0:4:4:1:Leather::1:0:12795", -- General's Leather Mitts
	[16561]="0:0:4:4:1:Leather::1:0:12795", -- Warlord's Leather Helm
	[16562]="0:0:4:4:1:Leather::1:0:12795", -- Warlord's Leather Spaulders
	[16563]="0:0:4:4:1:Leather::1:0:12795", -- Warlord's Leather Breastplate
	[16564]="0:0:4:4:1:Leather::1:0:12795", -- General's Leather Legguards
	[16565]="0:0:4:4:1:Mail::1:0:12795", -- Warlord's Chain Chestpiece
	[16566]="0:0:4:4:1:Mail::1:0:12795", -- Warlord's Chain Helmet
	[16567]="0:0:4:4:1:Mail::1:0:12795", -- General's Chain Legguards
	[16568]="0:0:4:4:1:Mail::1:0:12795", -- Warlord's Chain Shoulders
	[16569]="0:0:4:4:1:Mail::1:0:12795", -- General's Chain Boots
	[16571]="0:0:4:4:1:Mail::1:0:12795", -- General's Chain Gloves
	[16573]="0:0:4:4:1:Mail::1:0:12795", -- General's Mail Boots
	[16574]="0:0:4:4:1:Mail::1:0:12795", -- General's Mail Gauntlets
	[16577]="0:0:4:4:1:Mail::1:0:12795", -- Warlord's Mail Armor
	[16578]="0:0:4:4:1:Mail::1:0:12795", -- Warlord's Mail Helm
	[16579]="0:0:4:4:1:Mail::1:0:12795", -- General's Mail Leggings
	[16580]="0:0:4:4:1:Mail::1:0:12795", -- Warlord's Mail Spaulders
	[16581]="0:0:12:1:20:::1:0:", -- Resonite Crystal
	[16583]="10000:2500:15:1:5:Reagent::1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24409,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Demonic Figurine
	[16602]="0:0:12:1:20:::1:0:", -- Troll Charm
	[16603]="0:0:12:1:1:::1:0:", -- Enchanted Resonite Crystal
	[16604]="0:17:4:2:1:Cloth::1:0:", -- Moon Robes of Elune
	[16605]="0:17:4:2:1:Cloth::1:0:", -- Friar's Robes of the Light
	[16606]="0:17:4:2:1:Cloth::1:0:", -- Juju Hex Robes
	[16607]="0:17:4:2:1:Cloth::1:0:", -- Acolyte's Sacrificial Robes
	[16608]="0:514:4:3:1:Leather::1:0:", -- Aquarius Belt
	[16622]="0:27307:2:2:1:Bow::1:0:", -- Thornflinger
	[16623]="0:7783:4:2:1:Amulet::1:0:", -- Opaline Medallion
	[16642]="0:0:12:1:1:::1:0:", -- Shredder Operating Manual - Chapter 1
	[16643]="0:0:12:1:1:::1:0:", -- Shredder Operating Manual - Chapter 2
	[16644]="0:0:12:1:1:::1:0:", -- Shredder Operating Manual - Chapter 3
	[16645]="0:62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 1
	[16646]="0:62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 2
	[16647]="0:62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 3
	[16648]="0:62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 4
	[16649]="0:62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 5
	[16650]="0:62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 6
	[16651]="0:62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 7
	[16652]="0:62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 8
	[16653]="0:62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 9
	[16654]="0:62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 10
	[16655]="0:62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 11
	[16656]="0:62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 12
	[16658]="0:1649:4:2:1:Cloak::1:0:", -- Wildhunter Cloak
	[16659]="0:856:4:2:1:Leather::1:0:", -- Deftkin Belt
	[16660]="0:2200:4:2:1:Shield::1:0:", -- Driftmire Shield
	[16661]="0:1035:4:2:1:Cloak::1:0:", -- Soft Willow Cape
	[16662]="0:0:12:1:1:::1:0:", -- Fragment of the Dragon's Eye
	[16663]="0:0:12:1:1:::1:0:", -- Blood of the Black Dragon Champion
	[16665]="0:0:9:2:1:Book::1:0:", -- Tome of Tranquilizing Shot
	[16666]="0:32368:4:3:1:Mail::1:0:", -- Vest of Elements
	[16667]="0:24035:4:3:1:Mail::1:0:", -- Coif of Elements
	[16668]="0:29493:4:3:1:Mail::1:0:", -- Kilt of Elements
	[16669]="0:21995:4:3:1:Mail::1:0:", -- Pauldrons of Elements
	[16670]="0:21027:4:3:1:Mail::1:0:", -- Boots of Elements
	[16671]="0:12586:4:3:1:Mail::1:0:", -- Bindings of Elements
	[16672]="0:14059:4:3:1:Mail::1:0:", -- Gauntlets of Elements
	[16673]="0:13440:4:3:1:Mail::1:0:", -- Cord of Elements
	[16674]="0:30993:4:3:1:Mail::1:0:", -- Beaststalker's Tunic
	[16675]="0:21421:4:3:1:Mail::1:0:", -- Beaststalker's Boots
	[16676]="0:14268:4:3:1:Mail::1:0:", -- Beaststalker's Gloves
	[16677]="0:23186:4:3:1:Mail::1:0:", -- Beaststalker's Cap
	[16678]="0:30607:4:3:1:Mail::1:0:", -- Beaststalker's Pants
	[16679]="0:22822:4:3:1:Mail::1:0:", -- Beaststalker's Mantle
	[16680]="0:13788:4:3:1:Mail::1:0:", -- Beaststalker's Belt
	[16681]="0:13055:4:3:1:Mail::1:0:", -- Beaststalker's Bindings
	[16682]="0:14582:4:3:1:Cloth::1:0:", -- Magister's Boots
	[16683]="0:8765:4:3:1:Cloth::1:0:", -- Magister's Bindings
	[16684]="0:9093:4:3:1:Cloth::1:0:", -- Magister's Gloves
	[16685]="0:8694:4:3:1:Cloth::1:0:", -- Magister's Belt
	[16686]="0:14836:4:3:1:Cloth::1:0:", -- Magister's Crown
	[16687]="0:19585:4:3:1:Cloth::1:0:", -- Magister's Leggings
	[16688]="0:20202:4:3:1:Cloth::1:0:", -- Magister's Robes
	[16689]="0:14597:4:3:1:Cloth::1:0:", -- Magister's Mantle
	[16690]="0:20355:4:3:1:Cloth::1:0:", -- Devout Robe
	[16691]="0:14005:4:3:1:Cloth::1:0:", -- Devout Sandals
	[16692]="0:9372:4:3:1:Cloth::1:0:", -- Devout Gloves
	[16693]="0:15230:4:3:1:Cloth::1:0:", -- Devout Crown
	[16694]="0:20106:4:3:1:Cloth::1:0:", -- Devout Skirt
	[16695]="0:14925:4:3:1:Cloth::1:0:", -- Devout Mantle
	[16696]="0:9058:4:3:1:Cloth::1:0:", -- Devout Belt
	[16697]="0:8577:4:3:1:Cloth::1:0:", -- Devout Bracers
	[16698]="0:15511:4:3:1:Cloth::1:0:", -- Dreadmist Mask
	[16699]="0:20475:4:3:1:Cloth::1:0:", -- Dreadmist Leggings
	[16700]="0:21665:4:3:1:Cloth::1:0:", -- Dreadmist Robe
	[16701]="0:15650:4:3:1:Cloth::1:0:", -- Dreadmist Mantle
	[16702]="0:8593:4:3:1:Cloth::1:0:", -- Dreadmist Belt
	[16703]="0:8138:4:3:1:Cloth::1:0:", -- Dreadmist Bracers
	[16704]="0:13639:4:3:1:Cloth::1:0:", -- Dreadmist Sandals
	[16705]="0:9127:4:3:1:Cloth::1:0:", -- Dreadmist Wraps
	[16706]="0:25058:4:3:1:Leather::1:0:", -- Wildheart Vest
	[16707]="0:18612:4:3:1:Leather::1:0:", -- Shadowcraft Cap
	[16708]="0:18175:4:3:1:Leather::1:0:", -- Shadowcraft Spaulders
	[16709]="0:24666:4:3:1:Leather::1:0:", -- Shadowcraft Pants
	[16710]="0:10446:4:3:1:Leather::1:0:", -- Shadowcraft Bracers
	[16711]="0:17505:4:3:1:Leather::1:0:", -- Shadowcraft Boots
	[16712]="0:11714:4:3:1:Leather::1:0:", -- Shadowcraft Gloves
	[16713]="0:11197:4:3:1:Leather::1:0:", -- Shadowcraft Belt
	[16714]="0:10602:4:3:1:Leather::1:0:", -- Wildheart Bracers
	[16715]="0:17766:4:3:1:Leather::1:0:", -- Wildheart Boots
	[16716]="0:11621:4:3:1:Leather::1:0:", -- Wildheart Belt
	[16717]="0:12244:4:3:1:Leather::1:0:", -- Wildheart Gloves
	[16718]="0:19354:4:3:1:Leather::1:0:", -- Wildheart Spaulders
	[16719]="0:26260:4:3:1:Leather::1:0:", -- Wildheart Kilt
	[16720]="0:20037:4:3:1:Leather::1:0:", -- Wildheart Cowl
	[16721]="0:27173:4:3:1:Leather::1:0:", -- Shadowcraft Tunic
	[16722]="0:14266:4:3:1:Plate::1:0:", -- Lightforge Bracers
	[16723]="0:15180:4:3:1:Plate::1:0:", -- Lightforge Belt
	[16724]="0:16001:4:3:1:Plate::1:0:", -- Lightforge Gauntlets
	[16725]="0:23910:4:3:1:Plate::1:0:", -- Lightforge Boots
	[16726]="0:35078:4:3:1:Plate::1:0:", -- Lightforge Breastplate
	[16727]="0:26005:4:3:1:Plate::1:0:", -- Lightforge Helm
	[16728]="0:34398:4:3:1:Plate::1:0:", -- Lightforge Legplates
	[16729]="0:25488:4:3:1:Plate::1:0:", -- Lightforge Spaulders
	[16730]="0:35611:4:3:1:Plate::1:0:", -- Breastplate of Valor
	[16731]="0:26399:4:3:1:Plate::1:0:", -- Helm of Valor
	[16732]="0:35849:4:3:1:Plate::1:0:", -- Legplates of Valor
	[16733]="0:26562:4:3:1:Plate::1:0:", -- Spaulders of Valor
	[16734]="0:25389:4:3:1:Plate::1:0:", -- Boots of Valor
	[16735]="0:15379:4:3:1:Plate::1:0:", -- Bracers of Valor
	[16736]="0:16359:4:3:1:Plate::1:0:", -- Belt of Valor
	[16737]="0:17239:4:3:1:Plate::1:0:", -- Gauntlets of Valor
	[16738]="0:4235:4:2:1:Cloth::1:0:", -- Witherseed Gloves
	[16739]="0:7969:4:2:1:Leather::1:0:", -- Rugwood Mantle
	[16740]="0:1032:4:2:1:Cloth::1:0:", -- Shredder Operating Gloves
	[16741]="0:1295:4:2:1:Leather::1:0:", -- Oilrag Handwraps
	[16742]="0:0:12:1:1:::1:0:", -- Warsong Saw Blades
	[16743]="0:0:12:1:20:::1:0:", -- Logging Rope
	[16744]="0:0:12:1:20:::1:0:", -- Warsong Oil
	[16745]="0:0:12:1:1:::1:0:", -- Warsong Axe Shipment
	[16746]="0:0:12:1:20:::1:0:", -- Warsong Report
	[16747]="0:27:15:0:20:Junk::1:0:", -- Broken Lock
	[16748]="0:15:15:0:20:Junk::1:0:", -- Padded Lining
	[16762]="0:0:12:1:1:::1:0:", -- Fathom Core
	[16763]="0:0:12:1:1:::1:0:", -- Warsong Runner Update
	[16764]="0:0:12:1:1:::1:0:", -- Warsong Scout Update
	[16765]="0:0:12:1:1:::1:0:", -- Warsong Outrider Update
	[16766]="0:100:0:1:20:FoodDrink::1:0:", -- Undermine Clam Chowder
	[16767]="3000:750:9:1:1:Cooking::1:1:8139", -- Recipe: Undermine Clam Chowder
	[16768]="150000:37500:4:2:1:OffHandFrill::1:0:11555", -- Furbolg Medicine Pouch
	[16769]="133081:26616:2:2:1:OneHandMace::1:0:11555", -- Furbolg Medicine Totem
	[16782]="0:0:12:2:1:::1:0:", -- Strange Water Globe
	[16783]="0:0:12:1:20:::1:0:", -- Bundle of Reports
	[16784]="0:0:12:1:20:::1:0:", -- Sapphire of Aku'Mai
	[16785]="0:0:12:1:1:::1:0:", -- Rokaro's Letter
	[16786]="0:0:12:1:20:::1:0:", -- Black Dragonspawn Eye
	[16787]="0:0:4:1:1:Amulet::1:0:", -- Amulet of Draconic Subversion
	[16788]="0:5095:4:2:1:Shield::1:0:", -- Captain Rackmore's Wheel
	[16789]="0:5992:2:2:1:Wand::1:0:", -- Captain Rackmore's Tiller
	[16790]="0:0:15:1:1:Junk::1:0:", -- Damp Note
	[16791]="0:1912:4:2:1:Cloth::1:0:", -- Silkstream Cuffs
	[16793]="0:4353:4:2:1:Mail::1:0:", -- Arcmetal Shoulders
	[16794]="0:2899:4:2:1:Mail::1:0:", -- Gripsteel Wristguards
	[16795]="0:22128:4:4:1:Cloth::1:0:", -- Arcanist Crown
	[16796]="0:27491:4:4:1:Cloth::1:0:", -- Arcanist Leggings
	[16797]="0:20698:4:4:1:Cloth::1:0:", -- Arcanist Mantle
	[16798]="0:27704:4:4:1:Cloth::1:0:", -- Arcanist Robes
	[16799]="0:13905:4:4:1:Cloth::1:0:", -- Arcanist Bindings
	[16800]="0:20935:4:4:1:Cloth::1:0:", -- Arcanist Boots
	[16801]="0:14010:4:4:1:Cloth::1:0:", -- Arcanist Gloves
	[16802]="0:14063:4:4:1:Cloth::1:0:", -- Arcanist Belt
	[16803]="0:21174:4:4:1:Cloth::1:0:", -- Felheart Slippers
	[16804]="0:14168:4:4:1:Cloth::1:0:", -- Felheart Bracers
	[16805]="0:14221:4:4:1:Cloth::1:0:", -- Felheart Gloves
	[16806]="0:14274:4:4:1:Cloth::1:0:", -- Felheart Belt
	[16807]="0:21491:4:4:1:Cloth::1:0:", -- Felheart Shoulder Pads
	[16808]="0:21569:4:4:1:Cloth::1:0:", -- Felheart Horns
	[16809]="0:28865:4:4:1:Cloth::1:0:", -- Felheart Robes
	[16810]="0:28972:4:4:1:Cloth::1:0:", -- Felheart Pants
	[16811]="0:21806:4:4:1:Cloth::1:0:", -- Boots of Prophecy
	[16812]="0:14591:4:4:1:Cloth::1:0:", -- Gloves of Prophecy
	[16813]="0:22537:4:4:1:Cloth::1:0:", -- Circlet of Prophecy
	[16814]="0:30156:4:4:1:Cloth::1:0:", -- Pants of Prophecy
	[16815]="0:27382:4:4:1:Cloth::1:0:", -- Robes of Prophecy
	[16816]="0:20616:4:4:1:Cloth::1:0:", -- Mantle of Prophecy
	[16817]="0:13797:4:4:1:Cloth::1:0:", -- Girdle of Prophecy
	[16818]="0:15636:4:4:1:Cloth::1:0:", -- Netherwind Belt
	[16819]="0:13902:4:4:1:Cloth::1:0:", -- Vambraces of Prophecy
	[16820]="0:34888:4:4:1:Leather::1:0:", -- Nightslayer Chestpiece
	[16821]="0:26266:4:4:1:Leather::1:0:", -- Nightslayer Cover
	[16822]="0:35154:4:4:1:Leather::1:0:", -- Nightslayer Pants
	[16823]="0:26463:4:4:1:Leather::1:0:", -- Nightslayer Shoulder Pads
	[16824]="0:26562:4:4:1:Leather::1:0:", -- Nightslayer Boots
	[16825]="0:17775:4:4:1:Leather::1:0:", -- Nightslayer Bracelets
	[16826]="0:17839:4:4:1:Leather::1:0:", -- Nightslayer Gloves
	[16827]="0:17906:4:4:1:Leather::1:0:", -- Nightslayer Belt
	[16828]="0:17972:4:4:1:Leather::1:0:", -- Cenarion Belt
	[16829]="0:27773:4:4:1:Leather::1:0:", -- Cenarion Boots
	[16830]="0:18580:4:4:1:Leather::1:0:", -- Cenarion Bracers
	[16831]="0:18646:4:4:1:Leather::1:0:", -- Cenarion Gloves
	[16832]="0:31689:4:4:1:Leather::1:0:", -- Bloodfang Spaulders
	[16833]="0:37559:4:4:1:Leather::1:0:", -- Cenarion Vestments
	[16834]="0:28266:4:4:1:Leather::1:0:", -- Cenarion Helm
	[16835]="0:34223:4:4:1:Leather::1:0:", -- Cenarion Leggings
	[16836]="0:25767:4:4:1:Leather::1:0:", -- Cenarion Spaulders
	[16837]="0:31178:4:4:1:Mail::1:0:", -- Earthfury Boots
	[16838]="0:20771:4:4:1:Mail::1:0:", -- Earthfury Belt
	[16839]="0:20851:4:4:1:Mail::1:0:", -- Earthfury Gauntlets
	[16840]="0:20931:4:4:1:Mail::1:0:", -- Earthfury Bracers
	[16841]="0:42021:4:4:1:Mail::1:0:", -- Earthfury Vestments
	[16842]="0:31632:4:4:1:Mail::1:0:", -- Earthfury Helmet
	[16843]="0:42336:4:4:1:Mail::1:0:", -- Earthfury Legguards
	[16844]="0:32013:4:4:1:Mail::1:0:", -- Earthfury Epaulets
	[16845]="0:43794:4:4:1:Mail::1:0:", -- Giantstalker's Breastplate
	[16846]="0:32965:4:4:1:Mail::1:0:", -- Giantstalker's Helmet
	[16847]="0:44113:4:4:1:Mail::1:0:", -- Giantstalker's Leggings
	[16848]="0:33352:4:4:1:Mail::1:0:", -- Giantstalker's Epaulets
	[16849]="0:33469:4:4:1:Mail::1:0:", -- Giantstalker's Boots
	[16850]="0:22294:4:4:1:Mail::1:0:", -- Giantstalker's Bracers
	[16851]="0:22373:4:4:1:Mail::1:0:", -- Giantstalker's Belt
	[16852]="0:22453:4:4:1:Mail::1:0:", -- Giantstalker's Gloves
	[16853]="0:52573:4:4:1:Plate::1:0:", -- Lawbringer Chestguard
	[16854]="0:39494:4:4:1:Plate::1:0:", -- Lawbringer Helm
	[16855]="0:47908:4:4:1:Plate::1:0:", -- Lawbringer Legplates
	[16856]="0:36002:4:4:1:Plate::1:0:", -- Lawbringer Spaulders
	[16857]="0:24275:4:4:1:Plate::1:0:", -- Lawbringer Bracers
	[16858]="0:24369:4:4:1:Plate::1:0:", -- Lawbringer Belt
	[16859]="0:36416:4:4:1:Plate::1:0:", -- Lawbringer Boots
	[16860]="0:24554:4:4:1:Plate::1:0:", -- Lawbringer Gauntlets
	[16861]="0:25318:4:4:1:Plate::1:0:", -- Bracers of Might
	[16862]="0:37829:4:4:1:Plate::1:0:", -- Sabatons of Might
	[16863]="0:25505:4:4:1:Plate::1:0:", -- Gauntlets of Might
	[16864]="0:25596:4:4:1:Plate::1:0:", -- Belt of Might
	[16865]="0:51088:4:4:1:Plate::1:0:", -- Breastplate of Might
	[16866]="0:38382:4:4:1:Plate::1:0:", -- Helm of Might
	[16867]="0:51461:4:4:1:Plate::1:0:", -- Legplates of Might
	[16868]="0:38657:4:4:1:Plate::1:0:", -- Pauldrons of Might
	[16869]="0:0:12:1:1:::1:0:", -- The Skull of Scryer
	[16870]="0:0:12:1:1:::1:0:", -- The Skull of Somnus
	[16871]="0:0:12:1:1:::1:0:", -- The Skull of Chronalis
	[16872]="0:0:12:1:1:::1:0:", -- The Skull of Axtroz
	[16873]="0:2469:4:2:1:Leather::1:0:", -- Braidfur Gloves
	[16882]="0:0:15:1:1:Junk::1:0:", -- Battered Junkbox
	[16883]="0:0:15:1:1:Junk::1:0:", -- Worn Junkbox
	[16884]="0:0:15:1:1:Junk::1:0:", -- Sturdy Junkbox
	[16885]="0:0:15:1:1:Junk::1:0:", -- Heavy Junkbox
	[16886]="0:5492:2:3:1:OneHandSword::1:0:", -- Outlaw Sabre
	[16887]="0:1988:4:3:1:OffHandFrill::1:0:", -- Witch's Finger
	[16888]="0:0:12:1:1:::1:0:", -- Dull Drakefire Amulet
	[16889]="0:3093:2:2:1:Stave::1:0:", -- Polished Walking Staff
	[16890]="0:2483:2:2:1:OneHandSword::1:0:", -- Slatemetal Cutlass
	[16891]="0:1697:2:2:1:OneHandSword::1:0:", -- Claystone Shortsword
	[16892]="0:0:0:1:1:Consumable::1:0:", -- Lesser Soulstone
	[16893]="0:0:0:1:1:Consumable::1:0:", -- Soulstone
	[16894]="0:1993:2:2:1:Stave::1:0:", -- Clear Crystal Rod
	[16895]="0:0:0:1:1:Consumable::1:0:", -- Greater Soulstone
	[16896]="0:0:0:1:1:Consumable::1:0:", -- Major Soulstone
	[16897]="0:39996:4:4:1:Leather::1:0:", -- Stormrage Chestguard
	[16898]="0:30106:4:4:1:Leather::1:0:", -- Stormrage Boots
	[16899]="0:20146:4:4:1:Leather::1:0:", -- Stormrage Handguards
	[16900]="0:30331:4:4:1:Leather::1:0:", -- Stormrage Cover
	[16901]="0:40592:4:4:1:Leather::1:0:", -- Stormrage Legguards
	[16902]="0:30554:4:4:1:Leather::1:0:", -- Stormrage Pauldrons
	[16903]="0:20444:4:4:1:Leather::1:0:", -- Stormrage Belt
	[16904]="0:20519:4:4:1:Leather::1:0:", -- Stormrage Bracers
	[16905]="0:41189:4:4:1:Leather::1:0:", -- Bloodfang Chestpiece
	[16906]="0:31001:4:4:1:Leather::1:0:", -- Bloodfang Boots
	[16907]="0:20742:4:4:1:Leather::1:0:", -- Bloodfang Gloves
	[16908]="0:31226:4:4:1:Leather::1:0:", -- Bloodfang Hood
	[16909]="0:38795:4:4:1:Leather::1:0:", -- Bloodfang Pants
	[16910]="0:19472:4:4:1:Leather::1:0:", -- Bloodfang Belt
	[16911]="0:19547:4:4:1:Leather::1:0:", -- Bloodfang Bracers
	[16912]="0:23547:4:4:1:Cloth::1:0:", -- Netherwind Boots
	[16913]="0:15756:4:4:1:Cloth::1:0:", -- Netherwind Gloves
	[16914]="0:23725:4:4:1:Cloth::1:0:", -- Netherwind Crown
	[16915]="0:31753:4:4:1:Cloth::1:0:", -- Netherwind Pants
	[16916]="0:31873:4:4:1:Cloth::1:0:", -- Netherwind Robes
	[16917]="0:23992:4:4:1:Cloth::1:0:", -- Netherwind Mantle
	[16918]="0:16055:4:4:1:Cloth::1:0:", -- Netherwind Bindings
	[16919]="0:24173:4:4:1:Cloth::1:0:", -- Boots of Transcendence
	[16920]="0:16175:4:4:1:Cloth::1:0:", -- Handguards of Transcendence
	[16921]="0:24350:4:4:1:Cloth::1:0:", -- Halo of Transcendence
	[16922]="0:32587:4:4:1:Cloth::1:0:", -- Leggings of Transcendence
	[16923]="0:32707:4:4:1:Cloth::1:0:", -- Robes of Transcendence
	[16924]="0:24618:4:4:1:Cloth::1:0:", -- Pauldrons of Transcendence
	[16925]="0:16902:4:4:1:Cloth::1:0:", -- Belt of Transcendence
	[16926]="0:16962:4:4:1:Cloth::1:0:", -- Bindings of Transcendence
	[16927]="0:25533:4:4:1:Cloth::1:0:", -- Nemesis Boots
	[16928]="0:15456:4:4:1:Cloth::1:0:", -- Nemesis Gloves
	[16929]="0:23274:4:4:1:Cloth::1:0:", -- Nemesis Skullcap
	[16930]="0:31152:4:4:1:Cloth::1:0:", -- Nemesis Leggings
	[16931]="0:31273:4:4:1:Cloth::1:0:", -- Nemesis Robes
	[16932]="0:23542:4:4:1:Cloth::1:0:", -- Nemesis Spaulders
	[16933]="0:15755:4:4:1:Cloth::1:0:", -- Nemesis Belt
	[16934]="0:15815:4:4:1:Cloth::1:0:", -- Nemesis Bracers
	[16935]="0:23812:4:4:1:Mail::1:0:", -- Dragonstalker's Bracers
	[16936]="0:23900:4:4:1:Mail::1:0:", -- Dragonstalker's Belt
	[16937]="0:36145:4:4:1:Mail::1:0:", -- Dragonstalker's Spaulders
	[16938]="0:48160:4:4:1:Mail::1:0:", -- Dragonstalker's Legguards
	[16939]="0:36252:4:4:1:Mail::1:0:", -- Dragonstalker's Helm
	[16940]="0:24258:4:4:1:Mail::1:0:", -- Dragonstalker's Gauntlets
	[16941]="0:37656:4:4:1:Mail::1:0:", -- Dragonstalker's Greaves
	[16942]="0:50167:4:4:1:Mail::1:0:", -- Dragonstalker's Breastplate
	[16943]="0:25171:4:4:1:Mail::1:0:", -- Bracers of Ten Storms
	[16944]="0:25261:4:4:1:Mail::1:0:", -- Belt of Ten Storms
	[16945]="0:38196:4:4:1:Mail::1:0:", -- Epaulets of Ten Storms
	[16946]="0:50882:4:4:1:Mail::1:0:", -- Legplates of Ten Storms
	[16947]="0:38293:4:4:1:Mail::1:0:", -- Helmet of Ten Storms
	[16948]="0:23182:4:4:1:Mail::1:0:", -- Gauntlets of Ten Storms
	[16949]="0:35063:4:4:1:Mail::1:0:", -- Greaves of Ten Storms
	[16950]="0:46724:4:4:1:Mail::1:0:", -- Breastplate of Ten Storms
	[16951]="0:27514:4:4:1:Plate::1:0:", -- Judgement Bindings
	[16952]="0:27620:4:4:1:Plate::1:0:", -- Judgement Belt
	[16953]="0:41273:4:4:1:Plate::1:0:", -- Judgement Spaulders
	[16954]="0:55341:4:4:1:Plate::1:0:", -- Judgement Legplates
	[16955]="0:41584:4:4:1:Plate::1:0:", -- Judgement Crown
	[16956]="0:28040:4:4:1:Plate::1:0:", -- Judgement Gauntlets
	[16957]="0:43025:4:4:1:Plate::1:0:", -- Judgement Sabatons
	[16958]="0:57681:4:4:1:Plate::1:0:", -- Judgement Breastplate
	[16959]="0:29111:4:4:1:Plate::1:0:", -- Bracelets of Wrath
	[16960]="0:29217:4:4:1:Plate::1:0:", -- Waistband of Wrath
	[16961]="0:43651:4:4:1:Plate::1:0:", -- Pauldrons of Wrath
	[16962]="0:58516:4:4:1:Plate::1:0:", -- Legplates of Wrath
	[16963]="0:43961:4:4:1:Plate::1:0:", -- Helm of Wrath
	[16964]="0:29637:4:4:1:Plate::1:0:", -- Gauntlets of Wrath
	[16965]="0:44276:4:4:1:Plate::1:0:", -- Sabatons of Wrath
	[16966]="0:59351:4:4:1:Plate::1:0:", -- Breastplate of Wrath
	[16967]="0:0:4:1:1:OffHandFrill::1:0:", -- Feralas Ahi
	[16968]="0:0:12:1:1:::1:0:", -- Sar'theris Striker
	[16969]="0:0:12:1:1:::1:0:", -- Savage Coast Blue Sailfin
	[16970]="0:0:12:1:1:::1:0:", -- Misty Reed Mahi Mahi
	[16971]="0:300:0:1:20:FoodDrink::1:0:", -- Clamlette Surprise
	[16972]="0:0:12:1:1:::1:0:", -- Karang's Banner
	[16973]="0:0:12:1:1:::1:0:", -- Vial of Dire Water
	[16974]="0:0:12:1:1:::1:0:", -- Empty Water Vial
	[16975]="0:813:4:3:1:Cloth::1:0:", -- Warsong Sash
	[16976]="0:0:12:1:1:::1:0:", -- Murgut's Totem
	[16977]="0:1536:4:3:1:Leather::1:0:", -- Warsong Boots
	[16978]="0:1233:4:3:1:Mail::1:0:", -- Warsong Gauntlets
	[16979]="0:13894:4:4:1:Cloth::1:0:", -- Flarecore Gloves
	[16980]="0:20632:4:4:1:Cloth::1:0:", -- Flarecore Mantle
	[16981]="0:292:4:2:1:Cloth::1:0:", -- Owlbeard Bracers
	[16982]="0:24397:4:4:1:Leather::1:0:", -- Corehound Boots
	[16983]="0:25709:4:4:1:Leather::1:0:", -- Molten Helm
	[16984]="0:31533:4:4:1:Mail::1:0:", -- Black Dragonscale Boots
	[16985]="0:847:4:2:1:Cloth::1:0:", -- Windseeker Boots
	[16986]="0:850:4:2:1:Mail::1:0:", -- Sandspire Gloves
	[16987]="0:884:4:2:1:Leather::1:0:", -- Screecher Belt
	[16988]="0:29333:4:4:1:Mail::1:0:", -- Fiery Chain Shoulders
	[16989]="0:18610:4:4:1:Mail::1:0:", -- Fiery Chain Girdle
	[16990]="0:998:4:2:1:Cloak::1:0:", -- Spritekin Cloak
	[16991]="0:0:12:1:1:::1:0:", -- Triage Bandage
	[16992]="0:30874:2:2:1:Gun::1:0:", -- Smokey's Explosive Launcher
	[16993]="0:30989:2:2:1:Wand::1:0:", -- Smokey's Fireshooter
	[16994]="0:10368:4:2:1:Leather::1:0:", -- Duskwing Gloves
	[16995]="0:15609:4:2:1:Leather::1:0:", -- Duskwing Mantle
	[16996]="0:38648:2:3:1:Bow::1:0:", -- Gorewood Bow
	[16997]="0:38790:2:3:1:Wand::1:0:", -- Stormrager
	[16998]="0:33222:4:3:1:Shield::1:0:", -- Sacred Protector
	[16999]="0:10709:4:3:1:Ring::1:0:", -- Royal Seal of Alexis
	[17001]="0:10314:4:2:1:Ring::1:0:", -- Elemental Circle
	[17002]="0:43287:2:2:1:OneHandAxe::1:0:", -- Ichor Spitter
	[17003]="0:43439:2:2:1:OneHandMace::1:0:", -- Skullstone Hammer
	[17004]="0:54493:2:2:1:Stave::1:0:", -- Sarah's Guide
	[17005]="0:1632:4:2:1:Leather::1:0:", -- Boorguard Tunic
	[17006]="0:1966:4:2:1:Mail::1:0:", -- Cobalt Legguards
	[17007]="0:11697:4:4:1:Mail::1:0:", -- Stonerender Gauntlets
	[17008]="0:0:15:1:1:Junk::1:0:", -- Small Scroll
	[17009]="0:0:12:1:1:::1:0:", -- Ambassador Malcin's Head
	[17010]="0:2000:7:3:10:Other:164,202,165,186,197:1:0:", -- Fiery Core
	[17011]="0:2000:7:3:10:Other:164,202,165,197:1:0:", -- Lava Core
	[17012]="0:1000:7:1:20:Leather:164,165,197:1:0:", -- Core Leather
	[17013]="0:46272:4:4:1:Plate::1:0:", -- Dark Iron Leggings
	[17014]="0:22242:4:4:1:Plate::1:0:", -- Dark Iron Bracers
	[17015]="0:53430:2:3:1:OneHandSword::1:0:", -- Dark Iron Reaver
	[17016]="0:53627:2:3:1:OneHandAxe::1:0:", -- Dark Iron Destroyer
	[17017]="180000:45000:9:1:1:Tailoring::1:1:12944", -- Pattern: Flarecore Mantle
	[17018]="80000:20000:9:1:1:Tailoring::1:1:12944", -- Pattern: Flarecore Gloves
	[17019]="0:140:15:1:1:Reagent::1:0:", -- Arcane Dust
	[17020]="1000:250:15:1:100:Reagent:202,-8:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Arcane Powder
	[17021]="700:175:15:1:20:Reagent:-11:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Wild Berries
	[17022]="150000:37500:9:1:1:Leatherworking::1:1:12944", -- Pattern: Corehound Boots
	[17023]="160000:40000:9:1:1:Leatherworking::1:1:12944", -- Pattern: Molten Helm
	[17025]="160000:40000:9:1:1:Leatherworking::1:1:12944", -- Pattern: Black Dragonscale Boots
	[17026]="1000:250:15:1:20:Reagent:-11:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Wild Thornroot
	[17028]="700:175:15:1:20:Reagent:-5:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Holy Candle
	[17029]="1000:250:15:1:20:Reagent:-5:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24409,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Sacred Candle
	[17030]="2000:500:15:1:10:Reagent:-7:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24409,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Ankh
	[17031]="1000:250:15:1:20:Reagent:-8:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Rune of Teleportation
	[17032]="2000:500:15:1:20:Reagent:-8:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Rune of Portals
	[17033]="2000:500:15:1:5:Reagent:-2:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24409,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Symbol of Divinity
	[17034]="200:50:15:1:20:Reagent:333,-11:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16611,16612,16706,16757,16829,18006,18019,18243,19004,19678,19718,20081,22479,23112,23560,24843,24935,24995,25010,25019,25051,25082,26474,26569,26598,26900,26908,26984,27030,27039,27054,27088,29288,29537,29636,30239,30244,30307,30438,31115,32639,32641,33871", -- Maple Seed
	[17035]="400:100:15:1:20:Reagent:333,-11:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16611,16612,16706,16757,16829,18006,18019,18243,19004,19678,19718,20081,22479,23112,23560,24843,24935,24995,25010,25019,25051,25082,26474,26569,26598,26900,26908,26984,27030,27039,27054,27088,29288,29537,29636,30239,30244,30307,30438,31115,32639,32641,33871", -- Stranglethorn Seed
	[17036]="800:200:15:1:20:Reagent:-11:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16611,16612,16706,16757,16829,18006,18019,18243,19004,19678,19718,20081,22479,23112,23560,24843,24935,24995,25010,25019,25051,25082,26474,26569,26598,26900,26908,26984,27030,27039,27054,27088,29288,29537,29636,30239,30244,30307,30438,31115,32639,32641,33871", -- Ashwood Seed
	[17037]="1400:350:15:1:20:Reagent:-11:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Hornbeam Seed
	[17038]="2000:500:15:1:20:Reagent:-11:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Ironwood Seed
	[17039]="0:8317:2:2:1:OneHandMace::1:0:", -- Skullbreaker
	[17042]="0:5706:2:2:1:Gun::1:0:", -- Nail Spitter
	[17043]="0:3055:4:2:1:Cloth::1:0:", -- Zealot's Robe
	[17044]="0:15038:4:3:1:Amulet::1:0:", -- Will of the Martyr
	[17045]="0:14846:4:3:1:Ring::1:0:", -- Blood of the Martyr
	[17046]="0:4796:2:2:1:OneHandAxe::1:0:", -- Gutterblade
	[17047]="0:1313:4:2:1:Cloth::1:0:", -- Luminescent Amice
	[17048]="0:400:0:1:10:Consumable::1:0:", -- Rumsey Rum
	[17049]="90000:22500:9:3:1:Blacksmithing::1:1:12944", -- Plans: Fiery Chain Girdle
	[17050]="0:12536:4:3:1:Cloth::1:0:", -- Chan's Imperial Robes
	[17051]="70000:17500:9:3:1:Blacksmithing::1:1:12944", -- Plans: Dark Iron Bracers
	[17052]="180000:45000:9:3:1:Blacksmithing::1:0:12944", -- Plans: Dark Iron Leggings
	[17053]="200000:50000:9:3:1:Blacksmithing::1:0:12944", -- Plans: Fiery Chain Shoulders
	[17054]="0:28788:2:3:1:OneHandSword::1:0:", -- Joonho's Mercy
	[17055]="0:28892:2:3:1:OneHandMace::1:0:", -- Changuk Smasher
	[17056]="0:7:15:1:20:Reagent:165,-8,-5:1:0:", -- Light Feather
	[17057]="0:7:15:1:20:Reagent:-7:1:0:", -- Shiny Fish Scales
	[17058]="0:7:15:1:20:Reagent:-7:1:0:", -- Fish Oil
	[17059]="220000:55000:9:3:1:Blacksmithing::1:1:12944", -- Plans: Dark Iron Reaver
	[17060]="220000:55000:9:3:1:Blacksmithing::1:1:12944", -- Plans: Dark Iron Destroyer
	[17061]="0:12888:4:3:1:Cloak::1:0:", -- Juno's Shadow
	[17062]="2200:550:9:1:1:Cooking::1:0:2383,2664,3178,3333,4307,4574,5162,12033,12962", -- Recipe: Mithril Head Trout
	[17063]="0:23961:4:4:1:Ring::1:0:", -- Band of Accuria
	[17064]="0:45914:4:4:1:Trinket::1:0:", -- Shard of the Scale
	[17065]="0:33381:4:4:1:Amulet::1:0:", -- Medallion of Steadfast Might
	[17066]="0:45228:4:4:1:Shield::1:0:", -- Drillborer Disk
	[17067]="0:75452:4:4:1:OffHandFrill::1:0:", -- Ancient Cornerstone Grimoire
	[17068]="0:78453:2:4:1:OneHandAxe::1:0:", -- Deathbringer
	[17069]="0:54968:2:4:1:Bow::1:0:", -- Striker's Mark
	[17070]="0:76483:2:4:1:Dagger::1:0:", -- Fang of the Mystics
	[17071]="0:75814:2:4:1:Dagger::1:0:", -- Gutgore Ripper
	[17072]="0:57776:2:4:1:Gun::1:0:", -- Blastershot Launcher
	[17073]="0:91903:2:4:1:TwoHandMace::1:0:", -- Earthshaker
	[17074]="0:88668:2:4:1:Polearm::1:0:", -- Shadowstrike
	[17075]="0:81686:2:4:1:OneHandSword::1:0:", -- Vis'kag the Bloodletter
	[17076]="0:106067:2:4:1:TwoHandSword::1:0:", -- Bonereaver's Edge
	[17077]="0:53771:2:4:1:Wand::1:0:", -- Crimson Shocker
	[17078]="0:24190:4:4:1:Cloak::1:0:", -- Sapphiron Drape
	[17082]="0:46146:4:4:1:Trinket::1:0:", -- Shard of the Flame
	[17102]="0:23363:4:4:1:Cloak::1:0:", -- Cloak of the Shrouded Mists
	[17103]="0:75431:2:4:1:OneHandSword::1:0:", -- Azuresong Mageblade
	[17104]="0:100375:2:4:1:TwoHandAxe::1:0:", -- Spinal Reaper
	[17105]="0:74149:2:4:1:OneHandMace::1:0:", -- Aurastone Hammer
	[17106]="0:51180:4:4:1:Shield::1:0:", -- Malistar's Defender
	[17107]="0:23523:4:4:1:Cloak::1:0:", -- Dragon's Blood Cape
	[17109]="0:33625:4:4:1:Amulet::1:0:", -- Choker of Enlightenment
	[17110]="0:24648:4:4:1:Ring::1:0:", -- Seal of the Archmagus
	[17111]="0:34648:4:4:1:Amulet::1:0:", -- Blazefury Medallion
	[17112]="0:73242:2:4:1:OneHandMace::1:0:", -- Empyrean Demolisher
	[17113]="0:93061:2:4:1:Stave::1:0:", -- Amberseal Keeper
	[17114]="0:0:12:1:1:::1:0:", -- Araj's Phylactery Shard
	[17117]="0:0:12:1:1:::1:0:", -- Rat Catcher's Flute
	[17118]="0:0:12:1:1:::1:0:", -- Carton of Mystery Meat
	[17119]="125:6:0:1:20:FoodDrink::5:0:13018", -- Deeprun Rat Kabob
	[17124]="0:0:12:1:100:::1:0:", -- Syndicate Emblem
	[17125]="0:0:12:1:1:::1:0:", -- Seal of Ravenholdt
	[17126]="0:0:12:1:1:::1:0:", -- Elegant Letter
	[17182]="0:160402:2:5:1:TwoHandMace::1:0:", -- "Sulfuras, Hand of Ragnaros"
	[17183]="36:7:4:1:1:Shield::1:0:2116,3075,3161,4559,16693", -- Dented Buckler
	[17184]="36:7:4:1:1:Shield::1:0:1104,1213,3592,4240,16762,16917", -- Small Shield
	[17185]="260:52:4:1:1:Shield::1:0:2135,3080,3167,3319,4559,16258,16693", -- Round Buckler
	[17186]="260:52:4:1:1:Shield::1:0:1249,2046,3613,4240,5106,16762,17930", -- Small Targe
	[17187]="1161:232:4:1:1:Shield::1:0:3319,3528,4187,4559,4560,5107,8360,16693,16762", -- Banded Buckler
	[17188]="2447:489:4:1:1:Shield::1:0:793,1319,3319,3493,4240,5126,8360,16693,16762", -- Ringed Buckler
	[17189]="13054:2610:4:1:1:Shield::1:0:1319,1322,1323,1349,1381,2845,3095,4177,4240,5125,5126,5812,5819,8129", -- Metal Buckler
	[17190]="37647:7529:4:1:1:Shield::1:0:980,1319,1323,1349,3095,4177,4240,5126,5508,5812,5819,8129,11182,16626,16753,25274,27067", -- Ornate Buckler
	[17191]="0:0:2:3:1:Stave::1:0:", -- Scepter of Celebras
	[17192]="4820:964:4:1:1:Shield::1:0:226,1319,1323,1349,1450,3095,4240,4886,5126,5812,5819,6028,16693,16762,31027", -- Reinforced Targe
	[17193]="0:95427:2:4:1:TwoHandMace::1:0:", -- Sulfuron Hammer
	[17194]="10:0:15:1:20:Holiday:185:5:0:13420,13429,13432,13433,13435,23010,23012,23064", -- Holiday Spices
	[17195]="0:0:15:1:20:Junk::1:0:", -- Fake Mistletoe
	[17196]="50:12:0:1:20:FoodDrink:185:1:0:13420,13429,13432,13433,13435,23010,23012,23064", -- Holiday Spirits
	[17197]="0:10:0:1:20:FoodDrink::1:0:", -- Gingerbread Cookie
	[17198]="0:9:0:1:20:FoodDrink::1:0:", -- Egg Nog
	[17200]="25:6:9:1:1:Cooking::1:0:13420,13429,13432,13433,13435,23010,23012,23064", -- Recipe: Gingerbread Cookie
	[17201]="240:60:9:1:1:Cooking::1:0:13420,13429,13432,13433,13435,23010,23012,23064", -- Recipe: Egg Nog
	[17202]="10:0:15:1:20:Holiday:202:5:0:13420,13429,13432,13433,13435,23010,23012,23064", -- Snowball
	[17203]="0:100000:7:4:20:MetalStone:164:1:0:", -- Sulfuron Ingot
	[17204]="0:200000:7:5:1:Other::1:0:", -- Eye of Sulfuras
	[17222]="0:300:0:1:20:FoodDrink::1:0:", -- Spider Sausage
	[17223]="0:87372:2:4:1:Polearm::1:0:", -- Thunderstrike
	[17224]="0:0:12:2:1:::1:0:", -- Scrying Scope
	[17242]="0:0:13:1:1:::1:0:", -- Key to Salem's Chest
	[17262]="0:0:13:1:1:::1:0:", -- James' Key
	[17302]="0:0:15:1:1:Junk::1:0:", -- Blue Ribboned Holiday Gift
	[17303]="10:2:15:1:10:Junk::1:0:13420,13429,13432,13433,13435,23010,23012,23064", -- Blue Ribboned Wrapping Paper
	[17304]="10:2:15:1:10:Junk::1:0:13420,13429,13432,13433,13435,23010,23012,23064", -- Green Ribboned Wrapping Paper
	[17305]="0:0:15:1:1:Junk::1:0:", -- Green Ribboned Holiday Gift
	[17306]="0:0:12:1:100:::1:0:", -- Stormpike Soldier's Blood
	[17307]="10:2:15:1:10:Junk::1:0:13420,13429,13432,13433,13435,23010,23012,23064", -- Purple Ribboned Wrapping Paper
	[17308]="0:0:15:1:1:Junk::1:0:", -- Purple Ribboned Holiday Gift
	[17309]="0:0:12:1:20:::1:0:", -- Discordant Bracers
	[17310]="0:0:12:1:1:::1:0:", -- Aspect of Neptulon
	[17322]="0:0:12:1:1:::1:0:", -- Eye of the Emberseer
	[17326]="0:0:12:1:100:::1:0:", -- Stormpike Soldier's Flesh
	[17327]="0:0:12:1:100:::1:0:", -- Stormpike Lieutenant's Flesh
	[17328]="0:0:12:1:100:::1:0:", -- Stormpike Commander's Flesh
	[17329]="0:0:12:1:1:::1:0:", -- Hand of Lucifron
	[17330]="0:0:12:1:1:::1:0:", -- Hand of Sulfuron
	[17331]="0:0:12:1:1:::1:0:", -- Hand of Gehennas
	[17332]="0:0:12:1:1:::1:0:", -- Hand of Shazzrah
	[17333]="0:0:12:1:1:::1:0:", -- Aqual Quintessence
	[17344]="25:1:0:1:20:FoodDrink::5:0:13420,13429,13432,13433,13435,23010,23012,23064", -- Candy Cane
	[17345]="0:0:12:1:20:::1:0:", -- Silithid Goo
	[17346]="0:0:12:1:1:::1:0:", -- Encrusted Silithid Object
	[17348]="1000:250:0:1:10:Potion::1:0:13216,13217,13218,13219,14753,14754", -- Major Healing Draught
	[17349]="500:125:0:1:10:Potion::1:0:13216,13217,13218,13219,14753,14754,15126,15127", -- Superior Healing Draught
	[17351]="1000:250:0:1:10:Potion::1:0:13216,13217,13218,13219,14753,14754", -- Major Mana Draught
	[17352]="500:125:0:1:10:Potion::1:0:13216,13217,13218,13219,14753,14754,15126,15127", -- Superior Mana Draught
	[17353]="0:0:12:1:1:::1:0:", -- Stormpike Assault Orders
	[17355]="0:0:12:1:1:::1:0:", -- Rabine's Letter
	[17364]="0:0:12:2:1:::1:0:", -- Scrying Scope
	[17384]="0:0:15:3:1:CombatPet::1:0:", -- Zinfizzlex's Portable Shredder Unit
	[17402]="2000:500:0:1:20:FoodDrink::1:0:13418,13430,13431,13434,13436,23009,23011,23065", -- Greatfather's Winter Ale
	[17403]="150:37:0:1:20:FoodDrink::1:0:13418,13430,13431,13434,13436,23009,23011,23065", -- Steamwheedle Fizzy Spirits
	[17404]="125:6:0:1:20:FoodDrink::5:0:13418,13430,13431,13434,13436,23009,23011,23065", -- Blended Bean Brew
	[17405]="1000:50:15:1:20:Holiday::5:0:13418,13430,13431,13434,13436,23009,23011,23065", -- Green Garden Tea
	[17406]="125:6:0:1:20:FoodDrink::5:0:13418,13430,13431,13434,13436,23009,23011,23065", -- Holiday Cheesewheel
	[17407]="1000:50:0:1:20:FoodDrink::5:0:13418,13430,13431,13434,13436,23009,23011,23065", -- Graccu's Homemade Meat Pie
	[17408]="2000:100:0:1:20:FoodDrink::5:0:13418,13430,13431,13434,13436,23009,23011,23065", -- Spicy Beefstick
	[17410]="0:0:15:3:1:CombatPet::1:0:", -- Zinfizzlex's Portable Shredder Unit
	[17411]="0:0:12:1:1:::1:0:", -- Steamsaw
	[17413]="0:7750:9:3:1:Book::1:0:", -- Codex: Prayer of Fortitude
	[17414]="0:14750:9:3:1:Book::1:0:", -- Codex: Prayer of Fortitude II
	[17422]="0:2:12:1:100:::1:0:", -- Armor Scraps
	[17423]="0:0:12:1:100:::1:0:", -- Storm Crystal
	[17442]="0:0:12:1:1:::1:0:", -- Frostwolf Assault Orders
	[17502]="0:0:12:1:100:::1:0:", -- Frostwolf Soldier's Medal
	[17503]="0:0:12:1:100:::1:0:", -- Frostwolf Lieutenant's Medal
	[17504]="0:0:12:1:100:::1:0:", -- Frostwolf Commander's Medal
	[17508]="0:7880:4:2:1:Shield::1:0:", -- Forcestone Buckler
	[17522]="0:2:12:1:20:::1:0:", -- Irondeep Supplies
	[17523]="0:11453:4:2:1:Cloak::1:0:", -- Smokey's Drape
	[17542]="0:2:12:1:20:::1:0:", -- Coldtooth Supplies
	[17562]="0:7863:4:3:1:Cloth::1:0:", -- Knight-Lieutenant's Dreadweave Boots
	[17564]="0:5280:4:3:1:Cloth::1:0:", -- Knight-Lieutenant's Dreadweave Gloves
	[17566]="0:7977:4:3:1:Cloth::1:0:", -- Lieutenant Commander's Headguard
	[17567]="0:10675:4:3:1:Cloth::1:0:", -- Knight-Captain's Dreadweave Leggings
	[17568]="0:9949:4:3:1:Cloth::1:0:", -- Knight-Captain's Dreadweave Robe
	[17569]="0:7491:4:3:1:Cloth::1:0:", -- Lieutenant Commander's Dreadweave Mantle
	[17570]="0:7519:4:3:1:Cloth::1:0:", -- Champion's Dreadweave Hood
	[17571]="0:10064:4:3:1:Cloth::1:0:", -- Legionnaire's Dreadweave Leggings
	[17572]="0:10102:4:3:1:Cloth::1:0:", -- Legionnaire's Dreadweave Robe
	[17573]="0:7605:4:3:1:Cloth::1:0:", -- Champion's Dreadweave Shoulders
	[17576]="0:7690:4:3:1:Cloth::1:0:", -- Blood Guard's Dreadweave Boots
	[17577]="0:5146:4:3:1:Cloth::1:0:", -- Blood Guard's Dreadweave Gloves
	[17578]="0:0:4:4:1:Cloth::1:0:", -- Field Marshal's Coronal
	[17579]="0:0:4:4:1:Cloth::1:0:", -- Marshal's Dreadweave Leggings
	[17580]="0:0:4:4:1:Cloth::1:0:", -- Field Marshal's Dreadweave Shoulders
	[17581]="0:0:4:4:1:Cloth::1:0:", -- Field Marshal's Dreadweave Robe
	[17583]="0:0:4:4:1:Cloth::1:0:", -- Marshal's Dreadweave Boots
	[17584]="0:0:4:4:1:Cloth::1:0:", -- Marshal's Dreadweave Gloves
	[17586]="0:0:4:4:1:Cloth::1:0:12795", -- General's Dreadweave Boots
	[17588]="0:0:4:4:1:Cloth::1:0:12795", -- General's Dreadweave Gloves
	[17590]="0:0:4:4:1:Cloth::1:0:12795", -- Warlord's Dreadweave Mantle
	[17591]="0:0:4:4:1:Cloth::1:0:12795", -- Warlord's Dreadweave Hood
	[17592]="0:0:4:4:1:Cloth::1:0:12795", -- Warlord's Dreadweave Robe
	[17593]="0:0:4:4:1:Cloth::1:0:12795", -- General's Dreadweave Pants
	[17594]="0:7633:4:3:1:Cloth::1:0:", -- Knight-Lieutenant's Satin Boots
	[17596]="0:5126:4:3:1:Cloth::1:0:", -- Knight-Lieutenant's Satin Gloves
	[17598]="0:7746:4:3:1:Cloth::1:0:", -- Lieutenant Commander's Diadem
	[17599]="0:10367:4:3:1:Cloth::1:0:", -- Knight-Captain's Satin Leggings
	[17600]="0:10680:4:3:1:Cloth::1:0:", -- Knight-Captain's Satin Robes
	[17601]="0:8039:4:3:1:Cloth::1:0:", -- Lieutenant Commander's Satin Amice
	[17602]="0:0:4:4:1:Cloth::1:0:12785", -- Field Marshal's Headdress
	[17603]="0:0:4:4:1:Cloth::1:0:12785", -- Marshal's Satin Pants
	[17604]="0:0:4:4:1:Cloth::1:0:12785", -- Field Marshal's Satin Mantle
	[17605]="0:0:4:4:1:Cloth::1:0:12785", -- Field Marshal's Satin Vestments
	[17607]="0:0:4:4:1:Cloth::1:0:12785", -- Marshal's Satin Sandals
	[17608]="0:0:4:4:1:Cloth::1:0:12785", -- Marshal's Satin Gloves
	[17610]="0:7517:4:3:1:Cloth::1:0:", -- Champion's Satin Cowl
	[17611]="0:10061:4:3:1:Cloth::1:0:", -- Legionnaire's Satin Trousers
	[17612]="0:10100:4:3:1:Cloth::1:0:", -- Legionnaire's Satin Vestments
	[17613]="0:7603:4:3:1:Cloth::1:0:", -- Champion's Satin Shoulderpads
	[17616]="0:7895:4:3:1:Cloth::1:0:", -- Blood Guard's Satin Boots
	[17617]="0:5282:4:3:1:Cloth::1:0:", -- Blood Guard's Satin Gloves
	[17618]="0:0:4:4:1:Cloth::1:0:12795", -- General's Satin Boots
	[17620]="0:0:4:4:1:Cloth::1:0:12795", -- General's Satin Gloves
	[17622]="0:0:4:4:1:Cloth::1:0:12795", -- Warlord's Satin Mantle
	[17623]="0:0:4:4:1:Cloth::1:0:12795", -- Warlord's Satin Cowl
	[17624]="0:0:4:4:1:Cloth::1:0:12795", -- Warlord's Satin Robes
	[17625]="0:0:4:4:1:Cloth::1:0:12795", -- General's Satin Leggings
	[17626]="0:0:12:1:1:::1:0:", -- Frostwolf Muzzle
	[17642]="0:0:12:1:100:::1:0:", -- Alterac Ram Hide
	[17643]="0:0:12:1:100:::1:0:", -- Frostwolf Hide
	[17662]="0:0:12:1:1:::1:0:", -- Stolen Treats
	[17682]="0:8750:9:3:1:Book::1:0:", -- Book: Gift of the Wild
	[17683]="0:14750:9:3:1:Book::1:0:", -- Book: Gift of the Wild II
	[17684]="0:0:12:1:30:::1:0:", -- Theradric Crystal Carving
	[17685]="0:0:15:1:1:Junk::1:0:", -- Smokywood Pastures Sampler
	[17686]="0:10192:2:2:1:Bow::1:0:", -- Master Hunter's Bow
	[17687]="0:10231:2:2:1:Gun::1:0:", -- Master Hunter's Rifle
	[17688]="0:5695:4:2:1:Plate::1:0:", -- Jungle Boots
	[17689]="0:0:12:1:1:::1:0:", -- Stormpike Training Collar
	[17690]="0:0:4:2:1:Trinket::1:0:", -- Frostwolf Insignia Rank 1
	[17691]="0:0:4:2:1:Trinket::1:0:", -- Stormpike Insignia Rank 1
	[17692]="0:881:4:2:1:Ring::1:0:", -- Horn Ring
	[17693]="0:0:12:1:1:::1:0:", -- Coated Cerulean Vial
	[17694]="0:881:4:2:1:Ring::1:0:", -- Band of the Fist
	[17695]="0:930:4:2:1:Cloth::1:0:", -- Chestnut Mantle
	[17696]="0:0:12:1:1:::1:0:", -- Filled Cerulean Vial
	[17702]="0:0:12:1:1:::1:0:", -- Celebrian Rod
	[17703]="0:0:12:1:1:::1:0:", -- Celebrian Diamond
	[17704]="0:9178:2:2:1:OneHandAxe::1:0:", -- Edge of Winter
	[17705]="0:32854:2:3:1:OneHandSword::1:0:", -- Thrash Blade
	[17706]="0:950:9:2:1:Blacksmithing::1:0:", -- Plans: Edge of Winter
	[17707]="0:11631:4:3:1:Amulet::1:0:", -- Gemshard Heart
	[17708]="0:35:0:1:20:Elixir::1:0:", -- Elixir of Frost Power
	[17709]="0:500:9:1:1:Alchemy::1:0:", -- Recipe: Elixir of Frost Power
	[17710]="0:35483:2:3:1:Dagger::1:0:", -- Charstone Dirk
	[17711]="0:24928:4:3:1:Plate::1:0:", -- Elemental Rockridge Leggings
	[17712]="0:0:15:1:1:Junk::1:0:", -- Winter Veil Disguise Kit
	[17713]="0:14641:4:3:1:Ring::1:0:", -- Blackstone Ring
	[17714]="0:11086:4:3:1:Mail::1:0:", -- Bracers of the Stone Princess
	[17715]="0:11125:4:3:1:Cloth::1:0:", -- Eye of Theradras
	[17716]="0:7500:7:1:1:Device::1:0:", -- Snowmaster 9000
	[17717]="0:26426:2:3:1:Gun::1:0:", -- Megashot Rifle
	[17718]="0:22630:4:3:1:Shield::1:0:", -- Gizlock's Hypertech Buckler
	[17719]="0:32106:2:3:1:OneHandSword::1:0:", -- Inventor's Focal Sword
	[17720]="0:600:9:2:1:Engineering::1:0:", -- Schematic: Snowmaster 9000
	[17721]="0:2268:4:2:1:Leather::1:0:", -- Gloves of the Greatfather
	[17722]="0:700:9:2:1:Leatherworking::1:0:", -- Pattern: Gloves of the Greatfather
	[17723]="0:750:4:1:1:Shirt::1:0:", -- Green Holiday Shirt
	[17724]="0:375:9:1:1:Tailoring::1:0:", -- Pattern: Green Holiday Shirt
	[17725]="0:750:9:2:1:Enchanting::1:0:", -- Formula: Enchant Weapon - Winter's Might
	[17726]="0:0:15:1:1:Junk::1:0:", -- Smokywood Pastures Special Gift
	[17727]="0:0:15:1:1:Junk::1:0:", -- Smokywood Pastures Gift Pack
	[17728]="0:12458:4:3:1:Leather::1:0:", -- Albino Crocscale Boots
	[17730]="0:42952:2:3:1:TwoHandAxe::1:0:", -- Gatorbite Axe
	[17732]="0:10383:4:3:1:Cloth::1:0:", -- Rotgrip Mantle
	[17733]="0:34735:2:3:1:OneHandMace::1:0:", -- Fist of Stone
	[17734]="0:18265:4:3:1:Plate::1:0:", -- Helm of the Mountain
	[17735]="0:0:15:1:1:Junk::1:0:", -- The Feast of Winter Veil
	[17736]="0:10532:4:3:1:Mail::1:0:", -- Rockgrip Gauntlets
	[17737]="0:10163:4:3:1:OffHandFrill::1:0:", -- Cloud Stone
	[17738]="0:33351:2:3:1:FistWeapon::1:0:", -- Claw of Celebras
	[17739]="0:9085:4:3:1:Cloak::1:0:", -- Grovekeeper's Drape
	[17740]="0:11401:4:3:1:Leather::1:0:", -- Soothsayer's Headdress
	[17741]="0:11516:4:3:1:Cloth::1:0:", -- Nature's Embrace
	[17742]="0:14450:4:3:1:Leather::1:0:", -- Fungus Shroud Armor
	[17743]="0:40748:2:3:1:Stave::1:0:", -- Resurgence Rod
	[17744]="0:9031:4:3:1:Trinket::1:0:", -- Heart of Noxxion
	[17745]="0:22520:2:3:1:Wand::1:0:", -- Noxious Shooter
	[17746]="0:10608:4:3:1:Plate::1:0:", -- Noxxion's Shackles
	[17747]="0:500:0:1:5:Other::1:0:", -- Razorlash Root
	[17748]="0:9107:4:3:1:Cloth::1:0:", -- Vinerot Sandals
	[17749]="0:11425:4:3:1:Leather::1:0:", -- Phytoskin Spaulders
	[17750]="0:6115:4:3:1:Cloth::1:0:", -- Chloromesh Girdle
	[17751]="0:15344:4:3:1:Leather::1:0:", -- Brusslehide Leggings
	[17752]="0:28785:2:3:1:Dagger::1:0:", -- Satyr's Lash
	[17753]="0:26046:2:3:1:Bow::1:0:", -- Verdant Keeper's Aim
	[17754]="0:17394:4:3:1:Mail::1:0:", -- Infernal Trickster Leggings
	[17755]="0:5818:4:3:1:Cloth::1:0:", -- Satyrmane Sash
	[17756]="0:0:12:1:20:::1:0:", -- Shadowshard Fragment
	[17757]="0:0:12:1:1:::1:0:", -- Amulet of Spirits
	[17758]="0:0:12:1:1:::1:0:", -- Amulet of Union
	[17759]="0:10307:4:2:1:Trinket::1:0:", -- Mark of Resolution
	[17760]="0:0:12:1:1:::1:0:", -- Seed of Life
	[17761]="0:0:12:1:1:::1:0:", -- Gem of the First Khan
	[17762]="0:0:12:1:1:::1:0:", -- Gem of the Second Khan
	[17763]="0:0:12:1:1:::1:0:", -- Gem of the Third Khan
	[17764]="0:0:12:1:1:::1:0:", -- Gem of the Fourth Khan
	[17765]="0:0:12:1:1:::1:0:", -- Gem of the Fifth Khan
	[17766]="0:44863:2:3:1:TwoHandMace::1:0:", -- Princess Theradras' Scepter
	[17767]="0:13610:4:3:1:Mail::1:0:", -- Bloomsprout Headpiece
	[17768]="0:7891:4:2:1:Ring::1:0:", -- Woodseed Hoop
	[17770]="0:6778:4:2:1:Plate::1:0:", -- Branchclaw Gauntlets
	[17771]="0:100000:7:5:20:MetalStone::1:0:", -- Elementium Bar
	[17772]="0:7132:4:2:1:Amulet::1:0:", -- Zealous Shadowshard Pendant
	[17773]="0:7132:4:2:1:Amulet::1:0:", -- Prodigious Shadowshard Pendant
	[17774]="0:6133:4:2:1:Trinket::1:0:", -- Mark of the Chosen
	[17775]="0:7841:4:2:1:Cloth::1:0:", -- Acumen Robes
	[17776]="0:7377:4:2:1:Leather::1:0:", -- Sprightring Helm
	[17777]="0:11011:4:2:1:Mail::1:0:", -- Relentless Chain
	[17778]="0:4605:4:2:1:Leather::1:0:", -- Sagebrush Girdle
	[17779]="0:9689:4:2:1:Plate::1:0:", -- Hulkstone Pauldrons
	[17780]="0:46796:2:4:1:Dagger::1:0:", -- Blade of Eternal Darkness
	[17781]="0:0:12:1:1:::1:0:", -- The Pariah's Instructions
	[17782]="0:33625:4:5:1:Amulet::1:0:", -- Talisman of Binding Shard
	[17822]="0:0:12:1:1:::1:0:", -- Frostwolf Maps
	[17823]="0:0:12:1:1:::1:0:", -- Stormpike Battle Plans
	[17849]="0:0:12:1:1:::1:0:", -- Stormpike Banner
	[17850]="0:0:12:1:1:::1:0:", -- Frostwolf Banner
	[17900]="0:0:4:2:1:Trinket::1:0:", -- Stormpike Insignia Rank 2
	[17901]="0:0:4:2:1:Trinket::1:0:", -- Stormpike Insignia Rank 3
	[17902]="0:0:4:3:1:Trinket::1:0:", -- Stormpike Insignia Rank 4
	[17903]="0:0:4:3:1:Trinket::1:0:", -- Stormpike Insignia Rank 5
	[17904]="0:0:4:4:1:Trinket::1:0:", -- Stormpike Insignia Rank 6
	[17905]="0:0:4:2:1:Trinket::1:0:", -- Frostwolf Insignia Rank 2
	[17906]="0:0:4:2:1:Trinket::1:0:", -- Frostwolf Insignia Rank 3
	[17907]="0:0:4:3:1:Trinket::1:0:", -- Frostwolf Insignia Rank 4
	[17908]="0:0:4:3:1:Trinket::1:0:", -- Frostwolf Insignia Rank 5
	[17909]="0:0:4:4:1:Trinket::1:0:", -- Frostwolf Insignia Rank 6
	[17922]="0:125:4:2:1:Leather::1:0:", -- Lionfur Armor
	[17943]="0:35234:2:3:1:OneHandMace::1:0:", -- Fist of Stone
	[17962]="0:4762:15:2:1:Junk::1:0:", -- Blue Sack of Gems
	[17963]="0:213:15:2:1:Junk::1:0:", -- Green Sack of Gems
	[17964]="0:5512:15:2:1:Junk::1:0:", -- Gray Sack of Gems
	[17965]="0:213:15:2:1:Junk::1:0:", -- Yellow Sack of Gems
	[17966]="0:8750:1:2:1:Bag::1:0:", -- Onyxia Hide Backpack
	[17967]="0:5000:7:3:20:Leather::1:0:", -- Refined Scale of Onyxia
	[17968]="0:5000:7:3:20:Other::1:0:", -- Charged Scale of Onyxia
	[17969]="0:4773:15:2:1:Junk::1:0:", -- Red Sack of Gems
	[17982]="0:23961:4:3:1:Ring::1:0:", -- Ragnaros Core
	[18022]="0:10709:4:3:1:Ring::1:0:", -- Royal Seal of Alexis
	[18042]="0:10:6:2:1000:Arrow::1:0:", -- Thorium Headed Arrow
	[18043]="0:15495:4:3:1:Leather::1:0:", -- Coal Miner Boots
	[18044]="0:41478:2:3:1:OneHandMace::1:0:", -- Hurley's Tankard
	[18045]="0:300:0:1:20:FoodDrink::1:0:", -- Tender Wolf Steak
	[18046]="12000:3000:9:1:1:Cooking::1:0:4782,7733,8125", -- Recipe: Tender Wolf Steak
	[18047]="0:22776:4:3:1:Mail::1:0:", -- Flame Walkers
	[18048]="0:49204:2:3:1:OneHandMace::1:0:", -- Mastersmith's Hammer
	[18082]="0:28161:2:3:1:Stave::1:0:", -- Zum'rah's Vexing Cane
	[18083]="0:4522:4:3:1:Cloth::1:0:", -- Jumanza Grips
	[18102]="0:15444:4:3:1:Cloth::1:0:", -- Dragonrider Boots
	[18103]="0:15252:4:3:1:Ring::1:0:", -- Band of Rumination
	[18104]="0:15557:4:3:1:Mail::1:0:", -- Feralsurge Girdle
	[18142]="0:0:12:1:100:::1:0:", -- Severed Night Elf Head
	[18143]="0:0:12:1:100:::1:0:", -- Tuft of Gnome Hair
	[18144]="0:0:12:1:100:::1:0:", -- Human Bone Chip
	[18145]="0:0:12:1:100:::1:0:", -- Tauren Hoof
	[18146]="0:0:12:1:100:::1:0:", -- Darkspear Troll Mojo
	[18147]="0:0:12:1:100:::1:0:", -- Forsaken Heart
	[18148]="0:0:12:1:1:::1:0:", -- Skull of Korrak
	[18149]="0:0:12:2:1:::1:0:", -- Rune of Recall
	[18150]="0:0:12:2:1:::1:0:", -- Rune of Recall
	[18151]="0:0:12:1:1:::1:0:", -- Filled Amethyst Phial
	[18152]="0:0:12:1:1:::1:0:", -- Amethyst Phial
	[18154]="0:0:15:1:1:Junk::1:0:", -- Blizzard Stationery
	[18160]="0:50:9:2:1:Cooking::1:0:", -- Recipe: Thistle Tea
	[18168]="0:47292:4:4:1:Shield::1:0:", -- Force Reactive Disk
	[18169]="100000:25000:0:2:1:EnhPerm::1:0:10856", -- Flame Mantle of the Dawn
	[18170]="100000:25000:0:2:1:EnhPerm::1:0:10856", -- Frost Mantle of the Dawn
	[18171]="100000:25000:0:2:1:EnhPerm::1:0:10856", -- Arcane Mantle of the Dawn
	[18172]="100000:25000:0:2:1:EnhPerm::1:0:10856", -- Nature Mantle of the Dawn
	[18173]="100000:25000:0:2:1:EnhPerm::1:0:10856", -- Shadow Mantle of the Dawn
	[18182]="400000:100000:0:2:1:EnhPerm::1:0:10856", -- Chromatic Mantle of the Dawn
	[18202]="0:73256:2:4:1:FistWeapon::1:0:", -- Eskhandar's Left Claw
	[18203]="0:73522:2:4:1:FistWeapon::1:0:", -- Eskhandar's Right Claw
	[18204]="0:22136:4:4:1:Cloak::1:0:", -- Eskhandar's Pelt
	[18205]="0:33287:4:4:1:Amulet::1:0:", -- Eskhandar's Collar
	[18206]="0:0:12:1:100:::1:0:", -- Dwarf Spine
	[18207]="0:0:12:1:100:::1:0:", -- Orc Tooth
	[18208]="0:22741:4:4:1:Cloak::1:0:", -- Drape of Benediction
	[18222]="0:3070:15:0:20:Junk::1:0:", -- Thorny Vine
	[18223]="0:6142:15:0:20:Junk::1:0:", -- Serrated Petal
	[18224]="0:1728:15:0:40:Junk::1:0:", -- Lasher Root
	[18225]="0:140:15:0:5:Junk::1:0:", -- Worn Running Shoes
	[18226]="0:408:15:0:5:Junk::1:0:", -- A Sealed Pact
	[18227]="0:248:15:0:5:Junk::1:0:", -- Nubless Pacifier
	[18228]="0:2500:15:0:1:Junk::1:0:", -- Autographed Picture of Foror & Tigule
	[18229]="0:790:15:0:1:Junk::1:0:", -- Nat Pagle's Guide to Extreme Anglin'
	[18230]="0:509:15:0:5:Junk::1:0:", -- Broken I.W.I.N. Button
	[18231]="0:361:4:0:1:Shirt::1:0:", -- Sleeveless T-Shirt
	[18232]="0:10000:15:1:5:CombatPet::1:0:", -- Field Repair Bot 74A
	[18233]="0:130:15:0:5:Junk::1:0:", -- Tear Stained Handkerchief
	[18234]="0:225:15:0:5:Junk::1:0:", -- Document from Boomstick Imports
	[18236]="0:2716:15:0:20:Junk::1:0:", -- Gordok Chew Toy
	[18237]="0:1622:15:0:20:Junk::1:0:", -- Mastiff Jawbone
	[18238]="0:3321:4:3:1:Leather::1:0:", -- Shadowskin Gloves
	[18239]="3500:875:9:1:1:Leatherworking::1:1:2699", -- Pattern: Shadowskin Gloves
	[18240]="0:0:7:2:20:Other:165,197:1:0:", -- Ogre Tannin
	[18241]="0:0:15:4:1:Mount::1:0:", -- Black War Steed Bridle
	[18242]="0:0:15:4:1:Mount::1:0:", -- Reins of the Black War Tiger
	[18243]="0:0:15:4:1:Mount::1:0:", -- Black Battlestrider
	[18244]="0:0:15:4:1:Mount::1:0:", -- Black War Ram
	[18245]="0:0:15:4:1:Mount::1:0:", -- Horn of the Black War Wolf
	[18246]="0:0:15:4:1:Mount::1:0:", -- Whistle of the Black War Raptor
	[18247]="0:0:15:4:1:Mount::1:0:", -- Black War Kodo
	[18248]="0:0:15:4:1:Mount::1:0:", -- Red Skeletal Warhorse
	[18249]="0:0:13:1:1:::1:0:", -- Crescent Key
	[18250]="0:0:13:2:1:::1:0:", -- Gordok Shackle Key
	[18251]="0:5000:0:3:10:EnhPerm::1:0:", -- Core Armor Kit
	[18252]="0:50000:9:3:1:Leatherworking::1:0:", -- Pattern: Core Armor Kit
	[18253]="0:1000:0:1:5:Potion::1:0:", -- Major Rejuvenation Potion
	[18254]="0:18:0:1:20:FoodDrink::1:0:", -- Runn Tum Tuber Surprise
	[18255]="0:15:0:1:20:FoodDrink:185:1:0:", -- Runn Tum Tuber
	[18256]="20000:1000:7:1:20:Other:171,333:5:0:844,958,983,989,1148,1257,1286,1313,1453,2225,2380,2480,2481,2810,2812,2821,2848,3010,3014,3348,3367,3548,3779,3954,3955,3956,4226,4229,4561,4610,4775,4897,4899,5135,5163,5178,5594,5817,6301,7947,8145,8157,8158,8177,8178,8305,8363,8934,11188,11189,12022,12028,12245,12941,12957,12958,15179,16588,16602,16612,16613,16641,16705,16706,16768,16826,16829,17486,18005,18009,18015,18802,18907,18960,19015,19017,19042,19074,19194,19197,19244,19345,19372,19450,19497,19533,19562,19573,19837,20081,20092,20194,20250,20891,20989,21083,21113,22099,22271,23802,24054,24147,24188,24341,24356,24780,24975,25034,26374,26474,26720,26939,26941,27012,27021,27026,27031,27038,27043,27057,27063,27070,27132,27140,27146,27184,27195,27938,28692,28725,28794,28806,28829,28831,28866,28872,29208,29270,29277,29535,29909,30311,30345,30438,30825,31115,32477,32639,32641,33600,33669", -- Imbued Vial
	[18257]="0:50000:9:3:1:Alchemy::1:0:", -- Recipe: Major Rejuvenation Potion
	[18258]="0:0:12:2:1:::1:0:", -- Gordok Ogre Suit
	[18259]="0:7500:9:3:1:Enchanting::1:0:", -- Formula: Enchant Weapon - Spell Power
	[18260]="0:7500:9:3:1:Enchanting::1:0:", -- Formula: Enchant Weapon - Healing Power
	[18261]="0:0:12:1:1:::1:0:", -- Book of Incantations
	[18262]="0:1250:0:2:20:EnhTemp::1:0:", -- Elemental Sharpening Stone
	[18263]="0:14690:4:4:1:Cloth::1:0:", -- Flarecore Wraps
	[18264]="0:25000:9:3:1:Blacksmithing::1:0:", -- Plans: Elemental Sharpening Stone
	[18265]="0:30000:9:3:1:Tailoring::1:0:", -- Pattern: Flarecore Wraps
	[18266]="0:0:13:1:1:::1:0:", -- Gordok Courtyard Key
	[18267]="0:5000:9:2:1:Cooking::1:0:", -- Recipe: Runn Tum Tuber Surprise
	[18268]="0:0:13:1:1:::1:0:", -- Gordok Inner Door Key
	[18269]="1500:375:0:2:10:Consumable::1:0:14322", -- Gordok Green Grog
	[18282]="0:55617:2:4:1:Gun::1:0:", -- Core Marksman Rifle
	[18283]="0:25000:0:3:5:EnhPerm::1:0:", -- Biznicks 247x128 Accurascope
	[18284]="1500:375:0:2:10:Consumable::1:0:14322", -- Kreeg's Stout Beatdown
	[18285]="0:4558:15:0:20:Junk::1:0:", -- Crystallized Mana Shard
	[18286]="0:2953:15:0:20:Junk::1:0:", -- Condensed Mana Fragment
	[18287]="200:50:0:1:20:FoodDrink::1:0:14322", -- Evermurky
	[18288]="1000:250:0:1:20:FoodDrink::1:0:14322", -- Molasses Firewater
	[18289]="0:9701:4:3:1:Amulet::1:0:", -- Barbed Thorn Necklace
	[18290]="0:30000:9:3:1:Engineering::1:0:", -- Schematic: Biznicks 247x128 Accurascope
	[18291]="0:30000:9:3:1:Engineering::1:0:", -- Schematic: Force Reactive Disk
	[18292]="0:30000:9:3:1:Engineering::1:0:", -- Schematic: Core Marksman Rifle
	[18294]="0:250:0:1:20:Elixir::1:0:", -- Elixir of Greater Water Breathing
	[18295]="0:11582:4:3:1:Cloth::1:0:", -- Phasing Boots
	[18296]="0:12322:4:3:1:Mail::1:0:", -- Marksman Bands
	[18297]="0:0:15:1:5:CombatPet::1:0:", -- Thornling Seed
	[18298]="0:20685:4:3:1:Leather::1:0:", -- Unbridled Leggings
	[18299]="0:0:12:1:1:::1:0:", -- Hydrospawn Essence
	[18300]="0:200:0:1:20:FoodDrink::1:0:", -- Hyjal Nectar
	[18301]="0:29363:2:2:1:Wand::1:0:", -- Lethtendris's Wand
	[18302]="0:7530:4:2:1:Ring::1:0:", -- Band of Vigor
	[18305]="0:25157:4:2:1:Plate::1:0:", -- Breakwater Legguards
	[18306]="0:7215:4:2:1:Cloth::1:0:", -- Gloves of Shadowy Mist
	[18307]="0:11163:4:2:1:Cloth::1:0:", -- Riptide Shoes
	[18308]="0:14006:4:2:1:Leather::1:0:", -- Clever Hat
	[18309]="0:11808:4:3:1:Leather::1:0:", -- Gloves of Restoration
	[18310]="0:47406:2:3:1:OneHandSword::1:0:", -- Fiendish Machete
	[18311]="0:56644:2:3:1:Stave::1:0:", -- Quel'dorai Channeling Rod
	[18312]="0:33429:4:3:1:Plate::1:0:", -- Energized Chestplate
	[18313]="0:23920:4:3:1:Plate::1:0:", -- Helm of Awareness
	[18314]="0:12100:4:3:1:Ring::1:0:", -- Ring of Demonic Guile
	[18315]="0:12100:4:3:1:Ring::1:0:", -- Ring of Demonic Potency
	[18317]="0:12503:4:3:1:Amulet::1:0:", -- Tempest Talisman
	[18318]="0:22057:4:3:1:Mail::1:0:", -- Merciful Greaves
	[18319]="0:20989:4:3:1:Mail::1:0:", -- Fervent Helm
	[18321]="0:49320:2:3:1:OneHandMace::1:0:", -- Energetic Rod
	[18322]="0:17677:4:3:1:Leather::1:0:", -- Waterspout Boots
	[18323]="0:32988:2:3:1:Bow::1:0:", -- Satyr's Bow
	[18324]="0:55189:2:3:1:TwoHandAxe::1:0:", -- Waveslicer
	[18325]="0:16617:4:3:1:Leather::1:0:", -- Felhide Cap
	[18326]="0:16440:4:3:1:Plate::1:0:", -- Razor Gauntlets
	[18327]="0:9376:4:3:1:Cloth::1:0:", -- Whipvine Cord
	[18328]="0:14116:4:3:1:Cloak::1:0:", -- Shadewood Cloak
	[18329]="0:0:0:2:1:EnhPerm::1:0:", -- Arcanum of Rapidity
	[18330]="0:0:0:2:1:EnhPerm::1:0:", -- Arcanum of Focus
	[18331]="0:0:0:2:1:EnhPerm::1:0:", -- Arcanum of Protection
	[18332]="0:0:9:2:1:Book::1:0:", -- Libram of Rapidity
	[18333]="0:0:9:2:1:Book::1:0:", -- Libram of Focus
	[18334]="0:0:9:2:1:Book::1:0:", -- Libram of Protection
	[18335]="0:0:12:3:20::755:1:0:", -- Pristine Black Diamond
	[18336]="0:0:12:1:1:::1:0:", -- Gauntlet of Gordok Might
	[18337]="0:8103:4:2:1:Cloth::1:0:", -- Orphic Bracers
	[18338]="0:36595:2:3:1:Wand::1:0:", -- Wand of Arcane Potency
	[18339]="0:11370:4:2:1:Cloak::1:0:", -- Eidolon Cloak
	[18340]="0:28853:4:3:1:Amulet::1:0:", -- Eidolon Talisman
	[18343]="0:14615:4:2:1:Ring::1:0:", -- Petrified Band
	[18344]="0:11587:4:3:1:Leather::1:0:", -- Stonebark Gauntlets
	[18345]="0:14727:4:2:1:Ring::1:0:", -- Murmuring Ring
	[18346]="0:16345:4:2:1:Cloth::1:0:", -- Threadbare Trousers
	[18347]="0:41589:2:2:1:OneHandAxe::1:0:", -- Well Balanced Axe
	[18348]="0:75990:2:4:1:OneHandSword::1:0:", -- Quel'Serrar
	[18349]="0:12568:4:2:1:Mail::1:0:", -- Gauntlets of Accuracy
	[18350]="0:12615:4:2:1:Cloak::1:0:", -- Amplifying Cloak
	[18351]="0:14855:4:2:1:Plate::1:0:", -- Magically Sealed Bracers
	[18352]="0:27109:4:2:1:Shield::1:0:", -- Petrified Bark Shield
	[18353]="0:53142:2:2:1:Stave::1:0:", -- Stoneflower Staff
	[18354]="0:17466:4:3:1:Trinket::1:0:", -- Pimgib's Collar
	[18356]="0:0:12:3:1:::1:0:", -- Garona: A Study on Stealth and Treachery
	[18357]="0:0:12:3:1:::1:0:", -- Codex of Defense
	[18358]="0:0:12:3:1:::1:0:", -- The Arcanist's Cookbook
	[18359]="0:0:12:3:1:::1:0:", -- The Light and How to Swing It
	[18360]="0:0:12:3:1:::1:0:", -- Harnessing Shadows
	[18361]="0:0:12:3:1:::1:0:", -- The Greatest Race of Hunters
	[18362]="0:0:12:3:1:::1:0:", -- Holy Bologna: What the Light Won't Tell You
	[18363]="0:0:12:3:1:::1:0:", -- Frost Shock and You
	[18364]="0:0:12:3:1:::1:0:", -- The Emerald Dream
	[18365]="0:0:15:0:1:Junk::1:0:", -- "A Thoroughly Read Copy of ""Nat Pagle's Extreme' Anglin."""
	[18366]="0:17257:4:3:1:Plate::1:0:", -- Gordok's Handguards
	[18367]="0:14762:4:3:1:Mail::1:0:", -- Gordok's Gauntlets
	[18368]="0:12348:4:3:1:Leather::1:0:", -- Gordok's Gloves
	[18369]="0:9915:4:3:1:Cloth::1:0:", -- Gordok's Handwraps
	[18370]="0:21612:4:3:1:Trinket::1:0:", -- Vigilance Charm
	[18371]="0:20737:4:3:1:Trinket::1:0:", -- Mindtap Talisman
	[18372]="0:52881:2:3:1:Dagger::1:0:", -- Blade of the New Moon
	[18373]="0:26535:4:3:1:Leather::1:0:", -- Chestplate of Tranquility
	[18374]="0:19970:4:3:1:Leather::1:0:", -- Flamescarred Shoulders
	[18375]="0:13360:4:3:1:Leather::1:0:", -- Bracers of the Eclipse
	[18376]="0:53632:2:3:1:OneHandMace::1:0:", -- Timeworn Mace
	[18377]="0:12175:4:3:1:Leather::1:0:", -- Quickdraw Gloves
	[18378]="0:29332:4:3:1:Mail::1:0:", -- Silvermoon Leggings
	[18379]="0:22182:4:3:1:Mail::1:0:", -- Odious Greaves
	[18380]="0:34486:4:3:1:Plate::1:0:", -- Eldritch Reinforced Legplates
	[18381]="0:21635:4:3:1:Amulet::1:0:", -- Evil Eye Pendant
	[18382]="0:14891:4:3:1:Cloak::1:0:", -- Fluctuating Cloak
	[18383]="0:17301:4:3:1:Plate::1:0:", -- Force Imbued Gauntlets
	[18384]="0:26209:4:3:1:Plate::1:0:", -- Bile-etched Spaulders
	[18385]="0:20080:4:3:1:Cloth::1:0:", -- Robe of Everlasting Night
	[18386]="0:19882:4:3:1:Cloth::1:0:", -- Padre's Trousers
	[18387]="0:9840:4:3:1:Cloth::1:0:", -- Brightspark Gloves
	[18388]="0:39093:2:3:1:Crossbow::1:0:", -- Stoneshatter
	[18389]="0:15692:4:3:1:Cloak::1:0:", -- Cloak of the Cosmos
	[18390]="0:25891:4:3:1:Leather::1:0:", -- Tanglemoss Leggings
	[18391]="0:13171:4:3:1:Leather::1:0:", -- Eyestalk Cord
	[18392]="0:52875:2:3:1:Dagger::1:0:", -- Distracting Dagger
	[18393]="0:15701:4:3:1:Mail::1:0:", -- Warpwood Binding
	[18394]="0:15974:4:3:1:Mail::1:0:", -- Demon Howl Wristguards
	[18395]="0:36645:4:3:1:Ring::1:0:", -- Emerald Flame Ring
	[18396]="0:53627:2:3:1:OneHandSword::1:0:", -- Mind Carver
	[18397]="0:22464:4:3:1:Amulet::1:0:", -- Elder Magus Pendant
	[18398]="0:27103:4:3:1:Ring::1:0:", -- Tidal Loop
	[18399]="0:27103:4:3:1:Ring::1:0:", -- Ocean's Breeze
	[18400]="0:14853:4:2:1:Ring::1:0:", -- Ring of Living Stone
	[18401]="0:0:12:4:1:::1:0:", -- Foror's Compendium of Dragon Slaying
	[18402]="0:18662:4:2:1:Ring::1:0:", -- Glowing Crystal Ring
	[18403]="0:49060:4:4:1:Ring::1:0:", -- Dragonslayer's Signet
	[18404]="0:6714:4:4:1:Amulet::1:0:", -- Onyxia Tooth Pendant
	[18405]="0:13747:4:4:1:Cloth::1:0:", -- Belt of the Archmage
	[18406]="0:46030:4:4:1:Trinket::1:0:", -- Onyxia Blood Talisman
	[18407]="0:10386:4:3:1:Cloth::1:0:", -- Felcloth Gloves
	[18408]="0:10422:4:3:1:Cloth::1:0:", -- Inferno Gloves
	[18409]="0:10460:4:3:1:Cloth::1:0:", -- Mooncloth Gloves
	[18410]="0:45516:2:2:1:TwoHandSword::1:0:", -- Sprinter's Sword
	[18411]="0:13704:4:2:1:Leather::1:0:", -- Spry Boots
	[18412]="0:0:12:1:1:::1:0:", -- Core Fragment
	[18413]="0:15916:4:3:1:Cloak::1:0:", -- Cloak of Warding
	[18414]="0:30000:9:4:1:Tailoring::1:0:", -- Pattern: Belt of the Archmage
	[18415]="0:10000:9:3:1:Tailoring::1:0:", -- Pattern: Felcloth Gloves
	[18416]="0:10000:9:3:1:Tailoring::1:0:", -- Pattern: Inferno Gloves
	[18417]="0:10000:9:3:1:Tailoring::1:0:", -- Pattern: Mooncloth Gloves
	[18418]="0:10000:9:3:1:Tailoring::1:0:", -- Pattern: Cloak of Warding
	[18420]="0:64117:2:3:1:TwoHandMace::1:0:", -- Bonecrusher
	[18421]="0:23168:4:3:1:Mail::1:0:", -- Backwood Helm
	[18422]="0:0:12:4:1:::1:0:", -- Head of Onyxia
	[18423]="0:0:12:4:1:::1:0:", -- Head of Onyxia
	[18424]="0:19520:4:3:1:Leather::1:0:", -- Sedge Boots
	[18425]="0:5537:4:2:1:OffHandFrill::1:0:", -- Kreeg's Mug
	[18426]="0:0:12:1:1:::1:0:", -- Lethtendris's Web
	[18427]="0:0:4:3:1:Cloak::1:0:12793,12799", -- Sergeant's Cloak
	[18428]="0:0:4:3:1:Amulet::1:0:12793,12799", -- Senior Sergeant's Insignia
	[18429]="0:0:4:3:1:Plate::1:0:12793,12799", -- First Sergeant's Plate Bracers
	[18430]="0:0:4:3:1:Plate::1:0:12793,12799", -- First Sergeant's Plate Bracers
	[18432]="0:0:4:3:1:Mail::1:0:12793,12799", -- First Sergeant's Mail Wristguards
	[18434]="0:0:4:3:1:Leather::1:0:12793,12799", -- First Sergeant's Dragonhide Armguards
	[18435]="0:0:4:3:1:Leather::1:0:12793,12799", -- First Sergeant's Leather Armguards
	[18436]="0:0:4:3:1:Leather::1:0:12793,12799", -- First Sergeant's Dragonhide Armguards
	[18437]="0:0:4:3:1:Cloth::1:0:12793,12799", -- First Sergeant's Silk Cuffs
	[18440]="0:0:4:3:1:Cloak::1:0:12781,12805", -- Sergeant's Cape
	[18441]="0:0:4:3:1:Cloak::1:0:12781,12805", -- Sergeant's Cape
	[18442]="0:0:4:3:1:Amulet::1:0:12781,12805", -- Master Sergeant's Insignia
	[18443]="0:0:4:3:1:Amulet::1:0:12781,12805", -- Master Sergeant's Insignia
	[18444]="0:0:4:3:1:Amulet::1:0:12781,12805", -- Master Sergeant's Insignia
	[18445]="0:0:4:3:1:Plate::1:0:12781", -- Sergeant Major's Plate Wristguards
	[18447]="0:0:4:3:1:Plate::1:0:12781", -- Sergeant Major's Plate Wristguards
	[18448]="0:0:4:3:1:Mail::1:0:12781", -- Sergeant Major's Chain Armguards
	[18449]="0:0:4:3:1:Mail::1:0:12781", -- Sergeant Major's Chain Armguards
	[18450]="0:17016:4:2:1:Cloth::1:0:", -- Robe of Combustion
	[18451]="0:10673:4:2:1:Leather::1:0:", -- Hyena Hide Belt
	[18452]="0:0:4:3:1:Leather::1:0:12781,12805", -- Sergeant Major's Leather Armsplints
	[18453]="0:0:4:3:1:Leather::1:0:12781,12805", -- Sergeant Major's Leather Armsplints
	[18454]="0:0:4:3:1:Leather::1:0:12781", -- Sergeant Major's Dragonhide Armsplints
	[18455]="0:0:4:3:1:Leather::1:0:12781", -- Sergeant Major's Dragonhide Armsplints
	[18456]="0:0:4:3:1:Cloth::1:0:12781", -- Sergeant Major's Silk Cuffs
	[18457]="0:0:4:3:1:Cloth::1:0:12781", -- Sergeant Major's Silk Cuffs
	[18458]="0:12212:4:2:1:Mail::1:0:", -- Modest Armguards
	[18459]="0:14383:4:2:1:Plate::1:0:", -- Gallant's Wristguards
	[18460]="0:30762:2:2:1:Gun::1:0:", -- Unsophisticated Hand Cannon
	[18461]="0:0:4:3:1:Cloak::1:0:12793,12799", -- Sergeant's Cloak
	[18462]="0:41319:2:2:1:FistWeapon::1:0:", -- Jagged Bone Fist
	[18463]="0:41472:2:2:1:OneHandSword::1:0:", -- Ogre Pocket Knife
	[18464]="0:29135:4:2:1:Ring::1:0:", -- Gordok Nose Ring
	[18465]="0:0:4:3:1:Trinket::1:0:", -- Royal Seal of Eldre'Thalas
	[18466]="0:0:4:3:1:Trinket::1:0:", -- Royal Seal of Eldre'Thalas
	[18467]="0:0:4:3:1:Trinket::1:0:", -- Royal Seal of Eldre'Thalas
	[18468]="0:0:4:3:1:Trinket::1:0:", -- Royal Seal of Eldre'Thalas
	[18469]="0:0:4:3:1:Trinket::1:0:", -- Royal Seal of Eldre'Thalas
	[18470]="0:0:4:3:1:Trinket::1:0:", -- Royal Seal of Eldre'Thalas
	[18471]="0:0:4:3:1:Trinket::1:0:", -- Royal Seal of Eldre'Thalas
	[18472]="0:0:4:3:1:Trinket::1:0:", -- Royal Seal of Eldre'Thalas
	[18473]="0:0:4:3:1:Trinket::1:0:", -- Royal Seal of Eldre'Thalas
	[18475]="0:804:4:2:1:Cloth::1:0:", -- Oddly Magical Belt
	[18476]="0:1514:4:2:1:Leather::1:0:", -- Mud Stained Boots
	[18477]="0:2027:4:2:1:Leather::1:0:", -- Shaggy Leggings
	[18478]="0:2035:4:2:1:Leather::1:0:", -- Hyena Hide Jerkin
	[18479]="0:1838:4:2:1:Mail::1:0:", -- Carrion Scorpid Helm
	[18480]="0:2148:4:2:1:Plate::1:0:", -- Scarab Plate Helm
	[18481]="0:5145:2:2:1:TwoHandMace::1:0:", -- Skullcracking Mace
	[18482]="0:3098:2:2:1:Bow::1:0:", -- Ogre Toothpick Shooter
	[18483]="0:37839:2:3:1:Wand::1:0:", -- Mana Channeling Wand
	[18484]="0:51975:2:3:1:OneHandSword::1:0:", -- Cho'Rush's Blade
	[18485]="0:33383:4:3:1:Shield::1:0:", -- Observer's Shield
	[18486]="0:20939:4:3:1:Cloth::1:0:", -- Mooncloth Robe
	[18487]="40000:10000:9:1:1:Tailoring::1:1:14371", -- Pattern: Mooncloth Robe
	[18488]="0:0:12:1:1:::1:0:", -- Heated Ancient Blade
	[18489]="0:0:12:4:1:::1:0:", -- Unfired Ancient Blade
	[18490]="0:18015:4:3:1:Leather::1:0:", -- Insightful Hood
	[18491]="0:40695:2:3:1:Dagger::1:0:", -- Lorespinner
	[18492]="0:0:12:1:1:::1:0:", -- Treated Ancient Blade
	[18493]="0:25113:4:3:1:Plate::1:0:", -- Bulky Iron Spaulders
	[18494]="0:21743:4:3:1:Mail::1:0:", -- Denwatcher's Shoulders
	[18495]="0:1509:4:3:1:Cloak::1:0:", -- Redoubt Cloak
	[18496]="0:14542:4:3:1:Cloak::1:0:", -- Heliotrope Cloak
	[18497]="0:9731:4:3:1:Cloth::1:0:", -- Sublime Wristguards
	[18498]="0:48836:2:3:1:OneHandAxe::1:0:", -- Hedgecutter
	[18499]="0:3225:4:3:1:Shield::1:0:", -- Barrier Shield
	[18500]="0:3134:4:3:1:Ring::1:0:", -- Tarnished Elven Ring
	[18501]="0:0:12:1:1:::1:0:", -- Felvine Shard
	[18502]="0:65385:2:3:1:Polearm::1:0:", -- Monstrous Glaive
	[18503]="0:36748:4:3:1:Plate::1:0:", -- Kromcrush's Chestplate
	[18504]="0:13171:4:3:1:Leather::1:0:", -- Girdle of Insight
	[18505]="0:13218:4:3:1:Leather::1:0:", -- Mugger's Belt
	[18506]="0:19897:4:3:1:Leather::1:0:", -- Mongoose Boots
	[18507]="0:15974:4:3:1:Cloth::1:0:", -- Boots of the Full Moon
	[18508]="0:16031:4:3:1:Mail::1:0:", -- Swift Flight Bracers
	[18509]="0:21451:4:4:1:Cloak::1:0:", -- Chromatic Cloak
	[18510]="0:19477:4:4:1:Cloak::1:0:", -- Hide of the Wild
	[18511]="0:19553:4:4:1:Cloak::1:0:", -- Shifting Cloak
	[18512]="0:4000:7:1:5:Other:165:1:0:", -- Larval Acid
	[18513]="0:0:12:4:1:::1:0:", -- A Dull and Flat Elven Blade
	[18514]="0:15000:9:3:1:Leatherworking::1:0:", -- Pattern: Girdle of Insight
	[18515]="0:15000:9:3:1:Leatherworking::1:0:", -- Pattern: Mongoose Boots
	[18516]="0:15000:9:3:1:Leatherworking::1:0:", -- Pattern: Swift Flight Bracers
	[18517]="0:40000:9:4:1:Leatherworking::1:0:", -- Pattern: Chromatic Cloak
	[18518]="0:40000:9:4:1:Leatherworking::1:0:", -- Pattern: Hide of the Wild
	[18519]="0:40000:9:4:1:Leatherworking::1:0:", -- Pattern: Shifting Cloak
	[18520]="0:6579:2:3:1:TwoHandSword::1:0:", -- Barbarous Blade
	[18521]="0:2767:4:3:1:Plate::1:0:", -- Grimy Metal Boots
	[18522]="0:3625:4:3:1:Ring::1:0:", -- Band of the Ogre King
	[18523]="0:3481:4:3:1:OffHandFrill::1:0:", -- Brightly Glowing Stone
	[18524]="0:3203:4:3:1:Mail::1:0:", -- Leggings of Destruction
	[18525]="0:1339:4:3:1:Leather::1:0:", -- Bracers of Prosperity
	[18526]="0:1613:4:3:1:Cloth::1:0:", -- Crown of the Ogre King
	[18527]="0:1619:4:3:1:Mail::1:0:", -- Harmonious Gauntlets
	[18528]="0:1976:4:3:1:Leather::1:0:", -- Cyclone Spaulders
	[18529]="0:1861:4:3:1:Plate::1:0:", -- Elemental Plate Girdle
	[18530]="0:2921:4:3:1:Mail::1:0:", -- Ogre Forged Hauberk
	[18531]="0:6109:2:3:1:TwoHandMace::1:0:", -- Unyielding Maul
	[18532]="0:2016:4:3:1:Cloth::1:0:", -- Mindsurge Robe
	[18533]="0:1805:4:3:1:Plate::1:0:", -- Gordok Bracers of Power
	[18534]="0:6435:2:3:1:Stave::1:0:", -- Rod of the Ogre Magi
	[18535]="0:30231:4:3:1:Shield::1:0:", -- Milli's Shield
	[18536]="0:38664:4:3:1:OffHandFrill::1:0:", -- Milli's Lexicon
	[18537]="0:6613:4:3:1:Trinket::1:0:", -- Counterattack Lodestone
	[18538]="0:8707:2:4:1:TwoHandAxe::1:0:", -- Treant's Bane
	[18539]="0:0:12:1:1:::1:0:", -- Reliquary of Purity
	[18540]="0:0:12:1:1:::1:0:", -- Sealed Reliquary of Purity
	[18541]="0:23110:4:4:1:Cloak::1:0:", -- Puissant Cape
	[18542]="0:94273:2:4:1:TwoHandSword::1:0:", -- Typhoon
	[18543]="0:63728:4:4:1:Ring::1:0:", -- Ring of Entropy
	[18544]="0:19705:4:4:1:Leather::1:0:", -- Doomhide Gauntlets
	[18545]="0:30875:4:4:1:Cloth::1:0:", -- Leggings of Arcane Supremacy
	[18546]="0:34859:4:4:1:Mail::1:0:", -- Infernal Headcage
	[18547]="0:28041:4:4:1:Plate::1:0:", -- Unmelting Ice Girdle
	[18562]="0:100000:7:4:20:MetalStone:186:1:0:", -- Elementium Ore
	[18563]="0:0:15:5:1:Junk::1:0:", -- Bindings of the Windseeker
	[18564]="0:0:15:5:1:Junk::1:0:", -- Bindings of the Windseeker
	[18567]="150000:37500:7:1:20:MetalStone:186:1:0:790,1690,2844,2847,2999,3343,3356,3477,4257,4259,4597,5411,5512,6300,8161,8176,9179,14624,14737,15176,15400,16376,16583,16670,16713,16823,17245,17655,19011,19012,19056,19342,19520,19530,19662,19879,20082,20463,22264,22476,23144,23724,23908,24052,26081,26599,26934,27019,27045,27062,27134,27267,28344,28716,28796,29252,29253,29907,29923,29964,29969,30241,30253,30336,30436,31024,32594,33599", -- Elemental Flux
	[18582]="0:271161:2:6:1:OneHandSword::1:0:", -- The Twin Blades of Azzinoth
	[18583]="0:246242:2:6:1:OneHandSword::1:0:", -- Warglaive of Azzinoth (Right)
	[18584]="0:247199:2:6:1:OneHandSword::1:0:", -- Warglaive of Azzinoth (Left)
	[18585]="0:14853:4:3:1:Ring::1:0:", -- Band of Allegiance
	[18586]="0:14853:4:3:1:Ring::1:0:", -- Lonetree's Circle
	[18587]="0:2000:7:1:1:Device::1:0:", -- Goblin Jumper Cables XL
	[18588]="0:200:7:1:20:Explosive::1:0:", -- Ez-Thro Dynamite II
	[18590]="0:0:12:1:30:::1:0:", -- Raging Beast's Blood
	[18591]="0:0:12:1:1:::1:0:", -- Case of Blood
	[18592]="0:20000:9:4:1:Blacksmithing::1:0:", -- Plans: Sulfuron Hammer
	[18594]="0:3000:7:1:20:Explosive::1:0:", -- Powerful Seaforium Charge
	[18597]="0:0:15:1:1:CombatPet::1:0:", -- Orcish Orphan Whistle
	[18598]="0:0:15:1:1:CombatPet::1:0:", -- Human Orphan Whistle
	[18600]="0:12000:9:3:1:Book::1:0:", -- Tome of Arcane Brilliance
	[18601]="0:0:12:1:1:::1:0:", -- Glowing Crystal Prison
	[18602]="0:25000:4:3:1:OffHandFrill::1:0:", -- Tome of Sacrifice
	[18603]="0:0:12:1:15:::1:0:", -- Satyr Blood
	[18604]="0:0:12:1:5:::1:0:", -- Tears of the Hederine
	[18605]="0:0:12:1:1:::1:0:", -- Imprisoned Doomguard
	[18606]="0:0:0:1:1:Consumable::1:0:12781", -- Alliance Battle Standard
	[18607]="0:0:0:1:1:Consumable::1:0:12793", -- Horde Battle Standard
	[18608]="0:0:2:4:1:Stave::1:0:", -- Benediction
	[18609]="0:0:2:4:1:Stave::1:0:", -- Anathema
	[18610]="0:37:2:1:1:OneHandSword::1:0:", -- Keen Machete
	[18611]="0:27:4:1:1:Leather::1:0:", -- Gnarlpine Leggings
	[18612]="0:35:4:1:1:Mail::1:0:", -- Bloody Chain Boots
	[18622]="0:0:12:1:1:::1:0:", -- Flawless Fel Essence (Jaedenar)
	[18623]="0:0:12:1:1:::1:0:", -- Flawless Fel Essence (Dark Portal)
	[18624]="0:0:12:1:1:::1:0:", -- Flawless Fel Essence (Azshara)
	[18625]="0:0:12:1:1:::1:0:", -- Kroshius' Infernal Core
	[18626]="0:0:12:1:1:::1:0:", -- Fel Fire
	[18628]="0:0:12:4:1:::1:0:", -- Thorium Brotherhood Contract
	[18629]="500000:0:12:1:1:::1:0:14437", -- Black Lodestone
	[18631]="0:3000:7:1:10:Part:202:1:0:", -- Truesilver Transformer
	[18632]="1000:50:0:1:20:FoodDrink::5:0:14480,14481,15353,15354", -- Moonbrook Riot Taffy
	[18633]="125:6:0:1:20:FoodDrink::5:0:14480,14481,15353,15354", -- Styleen's Sour Suckerpop
	[18634]="0:12500:4:3:1:Trinket::1:0:", -- Gyrofreeze Ice Reflector
	[18635]="2000:100:0:1:20:FoodDrink::5:0:14480,14481,15353,15354", -- Bellara's Nutterbar
	[18636]="0:100:7:1:1:Device::1:0:", -- Ruined Jumper Cables XL
	[18637]="0:600:4:2:1:Trinket::1:0:", -- Major Recombobulator
	[18638]="0:12500:4:3:1:Trinket::1:0:", -- Hyper-Radiant Flame Reflector
	[18639]="0:12500:4:3:1:Trinket::1:0:", -- Ultra-Flash Shadow Reflector
	[18640]="0:0:0:1:4:Other::1:0:", -- Happy Fun Rock
	[18641]="0:500:7:1:20:Explosive::1:0:", -- Dense Dynamite
	[18642]="0:0:12:1:1:::1:0:", -- Jaina's Autograph
	[18643]="0:0:12:1:1:::1:0:", -- Cairne's Hoofprint
	[18645]="0:1500:7:1:1:Device::1:0:", -- Gnomish Alarm-O-Bot
	[18646]="0:0:4:4:1:Trinket::1:0:", -- The Eye of Divinity
	[18647]="1800:450:9:1:1:Engineering::1:1:3413", -- Schematic: Red Firework
	[18648]="1800:450:9:1:1:Engineering::1:1:2838,3495", -- Schematic: Green Firework
	[18649]="1800:450:9:1:1:Engineering::1:1:1304,5175", -- Schematic: Blue Firework
	[18650]="5000:1250:9:1:1:Engineering::1:1:8131", -- Schematic: EZ-Thro Dynamite II
	[18651]="0:3000:9:1:1:Engineering::1:0:", -- Schematic: Truesilver Transformer
	[18652]="12000:3000:9:1:1:Engineering::1:1:11185", -- Schematic: Gyrofreeze Ice Reflector
	[18653]="0:4000:9:2:1:Engineering::1:0:", -- Schematic: Goblin Jumper Cables XL
	[18654]="0:4000:9:2:1:Engineering::1:0:", -- Schematic: Gnomish Alarm-O-Bot
	[18655]="0:4000:9:2:1:Engineering::1:0:", -- Schematic: Major Recombobulator
	[18656]="16000:4000:9:1:1:Engineering::1:1:11185", -- Schematic: Powerful Seaforium Charge
	[18657]="0:5000:9:2:1:Engineering::1:0:", -- Schematic: Hyper-Radiant Flame Reflector
	[18658]="0:6000:9:2:1:Engineering::1:0:", -- Schematic: Ultra-Flash Shadow Reflector
	[18659]="0:0:12:4:1:::1:0:", -- Splinter of Nordrassil
	[18660]="0:7500:7:2:1:Device::1:0:", -- World Enlarger
	[18661]="0:3000:9:2:1:Engineering::1:0:", -- Schematic: World Enlarger
	[18662]="20:5:0:1:5:Other::1:0:14860", -- Heavy Leather Ball
	[18663]="1500000:0:12:1:1:::1:0:14437", -- J'eevee's Jar
	[18664]="100:25:15:1:1:Junk::1:0:12805", -- A Treatise on Military Ranks
	[18665]="0:0:4:4:1:Trinket::1:0:", -- The Eye of Shadow
	[18670]="500000:0:12:1:1:::1:0:14437", -- Xorothian Glyphs
	[18671]="0:47747:2:3:1:OneHandMace::1:0:", -- Baron Charr's Sceptre
	[18672]="0:17855:4:2:1:OffHandFrill::1:0:", -- Elemental Ember
	[18673]="0:30782:4:3:1:Shield::1:0:", -- Avalanchion's Stony Hide
	[18674]="0:22003:4:2:1:Ring::1:0:", -- Hardened Stone Band
	[18675]="100:25:15:1:1:Junk::1:0:12799", -- Military Ranks of the Horde & Alliance
	[18676]="0:15529:4:3:1:Mail::1:0:", -- Sash of the Windreaver
	[18677]="0:12059:4:2:1:Cloak::1:0:", -- Zephyr Cloak
	[18678]="0:26635:4:3:1:Amulet::1:0:", -- Tempestria's Frozen Necklace
	[18679]="0:25136:4:2:1:Ring::1:0:", -- Frigid Ring
	[18680]="0:36594:2:3:1:Bow::1:0:", -- Ancient Bone Bow
	[18681]="0:14693:4:3:1:Cloth::1:0:", -- Burial Shawl
	[18682]="0:24583:4:3:1:Leather::1:0:", -- Ghoul Skin Leggings
	[18683]="0:49347:2:3:1:OneHandMace::1:0:", -- Hammer of the Vesper
	[18684]="0:36141:4:3:1:Ring::1:0:", -- Dimly Opalescent Ring
	[18686]="0:22869:4:3:1:Mail::1:0:", -- Bone Golem Shoulders
	[18687]="1500000:0:12:1:1:::1:0:14522", -- Xorothian Stardust
	[18688]="0:0:12:1:1:::1:0:", -- Imp in a Jar
	[18689]="0:15347:4:3:1:Cloak::1:0:", -- Phantasmal Cloak
	[18690]="0:35939:4:3:1:Plate::1:0:", -- Wraithplate Leggings
	[18691]="0:31400:4:3:1:Amulet::1:0:", -- Dark Advisor's Pendant
	[18692]="0:25109:4:3:1:Plate::1:0:", -- Death Knight Sabatons
	[18693]="0:10652:4:3:1:Cloth::1:0:", -- Shivery Handwraps
	[18694]="0:24158:4:3:1:Mail::1:0:", -- Shadowy Mail Greaves
	[18695]="0:34450:4:3:1:OffHandFrill::1:0:", -- Spellbound Tome
	[18696]="0:31173:4:3:1:Shield::1:0:", -- Intricately Runed Shield
	[18697]="0:10867:4:3:1:Cloth::1:0:", -- Coldstone Slippers
	[18698]="0:14454:4:3:1:Leather::1:0:", -- Tattered Leather Hood
	[18699]="0:15380:4:3:1:Leather::1:0:", -- Icy Tomb Spaulders
	[18700]="0:10910:4:3:1:Leather::1:0:", -- Malefic Bracers
	[18701]="0:36410:4:3:1:Ring::1:0:", -- Innervating Band
	[18702]="0:17064:4:3:1:Plate::1:0:", -- Belt of the Ordained
	[18703]="0:0:12:4:1:::1:0:", -- Ancient Petrified Leaf
	[18704]="0:0:12:4:1:::1:0:", -- Mature Blue Dragon Sinew
	[18705]="0:0:12:4:1:::1:0:", -- Mature Black Dragon Sinew
	[18706]="0:10031:4:2:1:Trinket::1:0:", -- Arena Master
	[18707]="0:0:12:4:1:::1:0:", -- Ancient Rune Etched Stave
	[18708]="0:0:12:1:1:::1:0:", -- Petrified Bark
	[18709]="0:5758:4:3:1:Cloth::1:0:", -- Arena Wristguards
	[18710]="0:7224:4:3:1:Leather::1:0:", -- Arena Bracers
	[18711]="0:8700:4:3:1:Mail::1:0:", -- Arena Bands
	[18712]="0:10245:4:3:1:Plate::1:0:", -- Arena Vambraces
	[18713]="0:0:2:4:1:Bow::1:0:", -- "Rhok'delar, Longbow of the Ancient Keepers"
	[18714]="0:0:11:4:1:Quiver::1:0:", -- Ancient Sinew Wrapped Lamina
	[18715]="0:0:2:4:1:Stave::1:0:", -- "Lok'delar, Stave of the Ancient Keepers"
	[18716]="0:18015:4:3:1:Leather::1:0:", -- Ash Covered Boots
	[18717]="0:61940:2:3:1:TwoHandMace::1:0:", -- Hammer of the Grand Crusader
	[18718]="0:26065:4:3:1:Plate::1:0:", -- Grand Crusader's Helm
	[18719]="0:0:12:1:1:::1:0:", -- The Traitor's Heart
	[18720]="0:15036:4:3:1:Cloth::1:0:", -- Shroud of the Nathrezim
	[18721]="0:14689:4:3:1:Mail::1:0:", -- Barrage Girdle
	[18722]="0:17539:4:3:1:Plate::1:0:", -- Death Grips
	[18723]="0:41953:4:3:1:Amulet::1:0:", -- Animated Chain Necklace
	[18724]="0:0:12:4:1:::1:0:", -- Enchanted Black Dragon Sinew
	[18725]="0:59927:2:3:1:Polearm::1:0:", -- Peacemaker
	[18726]="0:12029:4:3:1:Leather::1:0:", -- Magistrate's Cuffs
	[18727]="0:14487:4:3:1:Cloth::1:0:", -- Crimson Felt Hat
	[18728]="0:32466:4:3:1:Amulet::1:0:", -- Anastari Heirloom
	[18729]="0:38302:2:3:1:Bow::1:0:", -- Screeching Bow
	[18730]="0:10250:4:3:1:Cloth::1:0:", -- Shadowy Laced Handwraps
	[18731]="2000:500:9:1:1:Leatherworking::1:1:3366,5128", -- Pattern: Heavy Leather Ball
	[18734]="0:16031:4:3:1:Cloak::1:0:", -- Pale Moon Cloak
	[18735]="0:16086:4:3:1:Cloth::1:0:", -- Maleki's Footwraps
	[18736]="0:24346:4:3:1:Leather::1:0:", -- Plaguehound Leggings
	[18737]="0:48882:2:3:1:OneHandAxe::1:0:", -- Bone Slicing Hatchet
	[18738]="0:36303:2:3:1:Crossbow::1:0:", -- Carapace Spine Crossbow
	[18739]="0:34010:4:3:1:Plate::1:0:", -- Chitinous Plate Legguards
	[18740]="0:9754:4:3:1:Cloth::1:0:", -- Thuzadin Sash
	[18741]="0:17704:4:3:1:Plate::1:0:", -- Morlune's Bracer
	[18742]="0:22503:4:3:1:Mail::1:0:", -- Stratholme Militia Shoulderguard
	[18743]="0:14275:4:3:1:Cloak::1:0:", -- Gracious Cape
	[18744]="0:11371:4:3:1:Leather::1:0:", -- Plaguebat Fur Gloves
	[18745]="0:17228:4:3:1:Cloth::1:0:", -- Sacred Cloth Leggings
	[18746]="0:0:12:1:1:::1:0:", -- Divination Scryer
	[18749]="0:0:12:1:1:::1:0:", -- Charger's Lost Soul
	[18752]="0:0:12:1:1:::1:0:", -- Exorcism Censer
	[18753]="0:0:12:1:1:::1:0:", -- Arcanite Barding
	[18754]="0:18806:4:3:1:Plate::1:0:", -- Fel Hardened Bracers
	[18755]="0:40213:2:3:1:Gun::1:0:", -- Xorothian Firestick
	[18756]="0:31160:4:3:1:Shield::1:0:", -- Dreadguard's Protector
	[18757]="0:15069:4:3:1:Cloth::1:0:", -- Diabolic Mantle
	[18758]="0:50416:2:3:1:Dagger::1:0:", -- Specter's Blade
	[18759]="0:63257:2:3:1:TwoHandAxe::1:0:", -- Malicious Axe
	[18760]="0:30866:4:3:1:Ring::1:0:", -- Necromantic Band
	[18761]="0:38238:2:3:1:Wand::1:0:", -- Oblivion's Touch
	[18762]="0:27631:4:3:1:OffHandFrill::1:0:", -- Shard of the Green Flame
	[18766]="1000000:0:15:4:1:Mount::1:0:4730", -- Reins of the Swift Frostsaber
	[18767]="1000000:0:15:4:1:Mount::1:0:4730", -- Reins of the Swift Mistsaber
	[18769]="0:0:12:3:1:::1:0:", -- Enchanted Thorium Platemail
	[18770]="0:0:12:3:1:::1:0:", -- Enchanted Thorium Platemail
	[18771]="0:0:12:3:1:::1:0:", -- Enchanted Thorium Platemail
	[18772]="1000000:0:15:4:1:Mount::1:0:7955", -- Swift Green Mechanostrider
	[18773]="1000000:0:15:4:1:Mount::1:0:7955", -- Swift White Mechanostrider
	[18774]="1000000:0:15:4:1:Mount::1:0:7955", -- Swift Yellow Mechanostrider
	[18775]="0:0:12:1:1:::1:0:", -- Manna-Enriched Horse Feed
	[18776]="1000000:0:15:4:1:Mount::1:0:384,2357,4885", -- Swift Palomino
	[18777]="1000000:0:15:4:1:Mount::1:0:384,2357,4885", -- Swift Brown Steed
	[18778]="1000000:0:15:4:1:Mount::1:0:384,2357,4885", -- Swift White Steed
	[18779]="0:0:12:3:1:::1:0:", -- Bottom Half of Advanced Armorsmithing: Volume I
	[18780]="0:0:12:3:1:::1:0:", -- Top Half of Advanced Armorsmithing: Volume I
	[18781]="0:0:12:3:1:::1:0:", -- Bottom Half of Advanced Armorsmithing: Volume II
	[18782]="0:0:12:3:1:::1:0:", -- Top Half of Advanced Armorsmithing: Volume II
	[18783]="0:0:12:3:1:::1:0:", -- Bottom Half of Advanced Armorsmithing: Volume III
	[18784]="0:0:12:3:1:::1:0:", -- Top Half of Advanced Armorsmithing: Volume III
	[18785]="1000000:0:15:4:1:Mount::1:0:1261", -- Swift White Ram
	[18786]="1000000:0:15:4:1:Mount::1:0:1261", -- Swift Brown Ram
	[18787]="1000000:0:15:4:1:Mount::1:0:1261", -- Swift Gray Ram
	[18788]="1000000:0:15:4:1:Mount::1:0:7952", -- Swift Blue Raptor
	[18789]="1000000:0:15:4:1:Mount::1:0:7952", -- Swift Olive Raptor
	[18790]="1000000:0:15:4:1:Mount::1:0:7952", -- Swift Orange Raptor
	[18791]="1000000:0:15:4:1:Mount::1:0:4731", -- Purple Skeletal Warhorse
	[18792]="0:0:12:1:1:::1:0:", -- Blessed Arcanite Barding
	[18793]="1000000:0:15:4:1:Mount::1:0:3685", -- Great White Kodo
	[18794]="1000000:0:15:4:1:Mount::1:0:3685", -- Great Brown Kodo
	[18795]="1000000:0:15:4:1:Mount::1:0:3685", -- Great Gray Kodo
	[18796]="1000000:0:15:4:1:Mount::1:0:3362", -- Horn of the Swift Brown Wolf
	[18797]="1000000:0:15:4:1:Mount::1:0:3362", -- Horn of the Swift Timber Wolf
	[18798]="1000000:0:15:4:1:Mount::1:0:3362", -- Horn of the Swift Gray Wolf
	[18799]="0:0:12:1:1:::1:0:", -- Charger's Redeemed Soul
	[18802]="60000:5000:12:1:5:::3:0:14437", -- Shadowy Potion
	[18803]="0:94876:2:4:1:TwoHandMace::1:0:", -- Finkle's Lava Dredger
	[18804]="0:0:12:1:1:::1:0:", -- Lord Grayson's Satchel
	[18805]="0:76460:2:4:1:Dagger::1:0:", -- Core Hound Tooth
	[18806]="0:41261:4:4:1:Plate::1:0:", -- Core Forged Greaves
	[18807]="0:25796:4:3:1:Mail::1:0:", -- Helm of Latent Power
	[18808]="0:15859:4:4:1:Cloth::1:0:", -- Gloves of the Hypnotic Flame
	[18809]="0:14578:4:4:1:Cloth::1:0:", -- Sash of Whispered Secrets
	[18810]="0:27440:4:4:1:Leather::1:0:", -- Wild Growth Spaulders
	[18811]="0:22035:4:4:1:Cloak::1:0:", -- Fireproof Cloak
	[18812]="0:22119:4:4:1:Mail::1:0:", -- Wristguards of True Flight
	[18813]="0:89103:4:4:1:Ring::1:0:", -- Ring of Binding
	[18814]="0:89135:4:4:1:Amulet::1:0:", -- Choker of the Fire Lord
	[18815]="0:64095:4:4:1:Trinket::1:0:", -- Essence of the Pure Flame
	[18816]="0:80298:2:4:1:Dagger::1:0:", -- Perdition's Blade
	[18817]="0:35861:4:4:1:Mail::1:0:", -- Crown of Destruction
	[18818]="0:0:12:1:1:::1:0:", -- Mor'zul's Instructions
	[18819]="0:0:12:1:1:::1:0:", -- Rohan's Exorcism Censer
	[18820]="0:66290:4:4:1:Trinket::1:0:", -- Talisman of Ephemeral Power
	[18821]="0:64030:4:4:1:Ring::1:0:", -- Quick Strike Ring
	[18822]="0:94642:2:4:1:TwoHandSword::1:0:", -- Obsidian Edged Blade
	[18823]="0:19235:4:4:1:Leather::1:0:", -- Aged Core Leather Gloves
	[18824]="0:40964:4:4:1:Plate::1:0:", -- Magma Tempered Boots
	[18825]="0:0:4:4:1:Shield::1:0:12784", -- Grand Marshal's Aegis
	[18826]="0:0:4:4:1:Shield::1:0:12794", -- High Warlord's Shield Wall
	[18827]="0:0:2:4:1:OneHandAxe::1:0:12784", -- Grand Marshal's Handaxe
	[18828]="0:0:2:4:1:OneHandAxe::1:0:12794", -- High Warlord's Cleaver
	[18829]="0:32943:4:4:1:Mail::1:0:", -- Deep Earth Spaulders
	[18830]="0:0:2:4:1:TwoHandAxe::1:0:12784", -- Grand Marshal's Sunderer
	[18831]="0:0:2:4:1:TwoHandAxe::1:0:12794", -- High Warlord's Battle Axe
	[18832]="0:72832:2:4:1:OneHandSword::1:0:", -- Brutality Blade
	[18833]="0:0:2:4:1:Bow::1:0:12784", -- Grand Marshal's Bullseye
	[18834]="0:0:4:3:1:Trinket::1:0:12793,12799", -- Insignia of the Horde
	[18835]="0:0:2:4:1:Bow::1:0:12794", -- High Warlord's Recurve
	[18836]="0:0:2:4:1:Crossbow::1:0:12784", -- Grand Marshal's Repeater
	[18837]="0:0:2:4:1:Crossbow::1:0:12794", -- High Warlord's Crossbow
	[18838]="0:0:2:4:1:Dagger::1:0:12784", -- Grand Marshal's Dirk
	[18839]="1000:250:0:1:10:Potion::1:0:12781,12793", -- Combat Healing Potion
	[18840]="0:0:2:4:1:Dagger::1:0:12794", -- High Warlord's Razor
	[18841]="1000:250:0:1:10:Potion::1:0:12781,12793", -- Combat Mana Potion
	[18842]="0:97012:2:4:1:Stave::1:0:", -- Staff of Dominance
	[18843]="0:0:2:4:1:FistWeapon::1:0:12784", -- Grand Marshal's Right Hand Blade
	[18844]="0:0:2:4:1:FistWeapon::1:0:12794", -- High Warlord's Right Claw
	[18845]="0:0:4:3:1:Trinket::1:0:12793,12799", -- Insignia of the Horde
	[18846]="0:0:4:3:1:Trinket::1:0:12793,12799", -- Insignia of the Horde
	[18847]="0:0:2:4:1:FistWeapon::1:0:12784", -- Grand Marshal's Left Hand Blade
	[18848]="0:0:2:4:1:FistWeapon::1:0:12794", -- High Warlord's Left Claw
	[18849]="0:0:4:3:1:Trinket::1:0:12793,12799", -- Insignia of the Horde
	[18850]="0:0:4:3:1:Trinket::1:0:12793,12799", -- Insignia of the Horde
	[18851]="0:0:4:3:1:Trinket::1:0:12793,12799", -- Insignia of the Horde
	[18852]="0:0:4:3:1:Trinket::1:0:12793,12799", -- Insignia of the Horde
	[18853]="0:0:4:3:1:Trinket::1:0:12793,12799", -- Insignia of the Horde
	[18854]="0:0:4:3:1:Trinket::1:0:12781", -- Insignia of the Alliance
	[18855]="0:0:2:4:1:Gun::1:0:12784", -- Grand Marshal's Hand Cannon
	[18856]="0:0:4:3:1:Trinket::1:0:12781", -- Insignia of the Alliance
	[18857]="0:0:4:3:1:Trinket::1:0:12781,12805", -- Insignia of the Alliance
	[18858]="0:0:4:3:1:Trinket::1:0:12781", -- Insignia of the Alliance
	[18859]="0:0:4:3:1:Trinket::1:0:12781", -- Insignia of the Alliance
	[18860]="0:0:2:4:1:Gun::1:0:12794", -- High Warlord's Street Sweeper
	[18861]="0:48152:4:4:1:Plate::1:0:", -- Flamewaker Legplates
	[18862]="0:0:4:3:1:Trinket::1:0:12781", -- Insignia of the Alliance
	[18863]="0:0:4:3:1:Trinket::1:0:12781", -- Insignia of the Alliance
	[18864]="0:0:4:3:1:Trinket::1:0:12781", -- Insignia of the Alliance
	[18865]="0:0:2:4:1:OneHandMace::1:0:12784", -- Grand Marshal's Punisher
	[18866]="0:0:2:4:1:OneHandMace::1:0:12794", -- High Warlord's Bludgeon
	[18867]="0:0:2:4:1:TwoHandMace::1:0:12784", -- Grand Marshal's Battle Hammer
	[18868]="0:0:2:4:1:TwoHandMace::1:0:12794", -- High Warlord's Pulverizer
	[18869]="0:0:2:4:1:Polearm::1:0:12784", -- Grand Marshal's Glaive
	[18870]="0:30139:4:4:1:Mail::1:0:", -- Helm of the Lifegiver
	[18871]="0:0:2:4:1:Polearm::1:0:12794", -- High Warlord's Pig Sticker
	[18872]="0:27356:4:4:1:Cloth::1:0:", -- Manastorm Leggings
	[18873]="0:0:2:4:1:Stave::1:0:12784", -- Grand Marshal's Stave
	[18874]="0:0:2:4:1:Stave::1:0:12794", -- High Warlord's War Staff
	[18875]="0:35039:4:4:1:Leather::1:0:", -- Salamander Scale Pants
	[18876]="0:0:2:4:1:TwoHandSword::1:0:12784", -- Grand Marshal's Claymore
	[18877]="0:0:2:4:1:TwoHandSword::1:0:12794", -- High Warlord's Greatsword
	[18878]="0:71794:2:4:1:Dagger::1:0:", -- Sorcerous Dagger
	[18879]="0:53364:4:4:1:Ring::1:0:", -- Heavy Dark Iron Ring
	[18880]="0:0:12:1:1:::1:0:", -- Darkreaver's Head
	[18902]="1000000:0:15:4:1:Mount::1:0:4730", -- Reins of the Swift Stormsaber
	[18904]="0:0:12:1:1:::1:0:", -- Zorbin's Ultra-Shrinker
	[18922]="0:0:12:1:1:::1:0:", -- Secret Plans: Fiery Flux
	[18943]="0:0:12:1:20:::1:0:", -- Dark Iron Pillow
	[18944]="0:123:12:1:100:::1:0:", -- Incendosaur Scale
	[18945]="0:100:12:1:100:::1:0:", -- Dark Iron Residue
	[18946]="0:0:12:1:1:::1:0:", -- Head of Overseer Maltorius
	[18947]="0:0:12:1:20:::1:0:", -- Rage Scar Yeti Hide
	[18948]="0:1589:4:3:1:Leather::1:0:", -- Barbaric Bracers
	[18949]="2000:500:9:1:1:Leatherworking::1:1:4225,4589", -- Pattern: Barbaric Bracers
	[18952]="0:0:12:1:1:::1:0:", -- Simone's Head
	[18953]="0:0:12:1:1:::1:0:", -- Klinfran's Head
	[18954]="0:0:12:1:1:::1:0:", -- Solenor's Head
	[18955]="0:0:12:1:1:::1:0:", -- Artorius's Head
	[18956]="0:0:12:1:20:::1:0:", -- Miniaturization Residue
	[18957]="0:250:2:2:1:OneHandSword::1:0:", -- Brushwood Blade
	[18958]="0:0:12:1:20:::1:0:", -- Water Elemental Core
	[18959]="0:0:12:1:1:::1:0:", -- Smithing Tuyere
	[18960]="0:0:12:1:1:::1:0:", -- Lookout's Spyglass
	[18961]="0:0:12:1:20:::1:0:", -- Zukk'ash Carapace
	[18962]="0:0:12:1:1:::1:0:", -- Stinglasher's Glands
	[18964]="0:1000:15:1:1:Companion::1:0:", -- Turtle Egg (Loggerhead)
	[18969]="0:0:12:1:1:::1:0:", -- Pristine Yeti Hide
	[18972]="0:0:12:1:1:::1:0:", -- Perfect Yeti Hide
	[18984]="0:5000:4:2:1:Trinket::1:0:", -- Dimensional Ripper - Everlook
	[18986]="0:5000:4:2:1:Trinket::1:0:", -- Ultrasafe Transporter: Gadgetzan
	[18987]="0:0:12:1:1:::1:0:", -- Blackhand's Command
	[19002]="0:0:12:4:1:::1:0:", -- Head of Nefarian
	[19003]="0:0:12:4:1:::1:0:", -- Head of Nefarian
	[19004]="0:0:0:1:1:Other::1:0:", -- Minor Healthstone
	[19005]="0:0:0:1:1:Other::1:0:", -- Minor Healthstone
	[19006]="0:0:0:1:1:Other::1:0:", -- Lesser Healthstone
	[19007]="0:0:0:1:1:Other::1:0:", -- Lesser Healthstone
	[19008]="0:0:0:1:1:Other::1:0:", -- Healthstone
	[19009]="0:0:0:1:1:Other::1:0:", -- Healthstone
	[19010]="0:0:0:1:1:Other::1:0:", -- Greater Healthstone
	[19011]="0:0:0:1:1:Other::1:0:", -- Greater Healthstone
	[19012]="0:0:0:1:1:Other::1:0:", -- Major Healthstone
	[19013]="0:0:0:1:1:Other::1:0:", -- Major Healthstone
	[19016]="0:0:12:5:1:::1:0:", -- Vessel of Rebirth
	[19017]="0:0:12:1:1:::1:0:", -- Essence of the Firelord
	[19018]="0:0:12:5:1:::1:0:", -- Dormant Wind Kissed Blade
	[19019]="0:123140:2:5:1:OneHandSword::1:0:", -- "Thunderfury, Blessed Blade of the Windseeker"
	[19020]="0:0:12:1:1:::1:0:", -- Camp Mojache Zukk'ash Report
	[19022]="0:7:2:2:1:FishingPole::1:0:", -- Nat Pagle's Extreme Angler FC-5000
	[19023]="0:0:12:1:1:::1:0:", -- Katoom's Best Lure
	[19024]="0:10031:4:3:1:Trinket::1:0:", -- Arena Grand Master
	[19025]="0:0:12:1:1:::1:0:", -- Skylord Plume
	[19026]="0:250:0:1:10:Other::1:0:", -- Snake Burst Firework
	[19027]="5000:1250:9:1:1:Engineering::1:0:14637", -- Schematic: Snake Burst Firework
	[19028]="0:0:4:1:1:Miscellaneous::1:0:", -- Elegant Dress
	[19029]="0:0:15:4:1:Mount::1:0:13218,13219", -- Horn of the Frostwolf Howler
	[19030]="0:0:15:4:1:Mount::1:0:13216,13217", -- Stormpike Battle Charger
	[19031]="0:0:4:1:1:Tabard::1:0:5188,5189,5190,13218,13219,16610", -- Frostwolf Battle Tabard
	[19032]="0:0:4:1:1:Tabard::1:0:5049,5191,5193,13216,13217,16766", -- Stormpike Battle Tabard
	[19033]="0:0:12:1:1:::1:0:", -- Slagtree's Lost Tools
	[19034]="0:0:12:1:1:::1:0:", -- Lard's Lunch
	[19035]="0:250:15:2:1:Junk::1:0:", -- Lard's Special Picnic Basket
	[19036]="0:0:12:1:1:::1:0:", -- Final Message to the Wildhammer
	[19037]="0:10266:4:2:1:Plate::1:0:", -- Emerald Peak Spaulders
	[19038]="0:11145:4:2:1:Ring::1:0:", -- Ring of Subtlety
	[19039]="0:7403:4:2:1:Leather::1:0:", -- Zorbin's Water Resistant Hat
	[19040]="0:19817:2:2:1:OneHandSword::1:0:", -- Zorbin's Mega-Slicer
	[19041]="0:9946:4:2:1:Leather::1:0:", -- Pratt's Handcrafted Tunic
	[19042]="0:9984:4:2:1:Leather::1:0:", -- Jangdor's Handcrafted Tunic
	[19043]="0:13291:4:3:1:Mail::1:0:", -- Heavy Timbermaw Belt
	[19044]="0:11116:4:3:1:Leather::1:0:", -- Might of the Timbermaw
	[19045]="0:0:0:3:1:Consumable::1:0:13216,13217", -- Stormpike Battle Standard
	[19046]="0:0:0:3:1:Consumable::1:0:13218,13219", -- Frostwolf Battle Standard
	[19047]="0:9232:4:3:1:Cloth::1:0:", -- Wisdom of the Timbermaw
	[19048]="0:24376:4:3:1:Mail::1:0:", -- Heavy Timbermaw Boots
	[19049]="0:13531:4:3:1:Leather::1:0:", -- Timbermaw Brawlers
	[19050]="0:16295:4:3:1:Cloth::1:0:", -- Mantle of the Timbermaw
	[19051]="0:16483:4:3:1:Plate::1:0:", -- Girdle of the Dawn
	[19052]="0:17621:4:3:1:Leather::1:0:", -- Dawn Treaders
	[19056]="0:12941:4:3:1:Cloth::1:0:", -- Argent Boots
	[19057]="0:17744:4:3:1:Plate::1:0:", -- Gloves of the Dawn
	[19058]="0:18977:4:3:1:Leather::1:0:", -- Golden Mantle of the Dawn
	[19059]="0:15238:4:3:1:Cloth::1:0:", -- Argent Shoulders
	[19060]="2000:100:0:1:20:Consumable::5:0:14753,14754", -- Warsong Gulch Enriched Ration
	[19061]="1500:75:0:1:20:Consumable::5:0:14753,14754", -- Warsong Gulch Iron Ration
	[19062]="1000:50:0:1:20:Consumable::5:0:14753,14754", -- Warsong Gulch Field Ration
	[19064]="0:0:13:1:1:::1:0:", -- Shackle Key
	[19066]="2000:100:0:1:20:Bandage::5:0:14753,14754", -- Warsong Gulch Runecloth Bandage
	[19067]="1500:75:0:1:20:Bandage::5:0:14753,14754", -- Warsong Gulch Mageweave Bandage
	[19068]="1000:50:0:1:20:Bandage::5:0:14753,14754", -- Warsong Gulch Silk Bandage
	[19069]="0:0:12:1:1:::1:0:", -- Huntsman Malkhor's Skull
	[19070]="0:0:12:1:1:::1:0:", -- Huntsman Malkhor's Bones
	[19071]="0:0:12:1:10:::1:0:", -- Vessel of Tainted Blood
	[19083]="0:0:4:3:1:Cloak::1:0:13218,13219", -- Frostwolf Legionnaire's Cloak
	[19084]="0:0:4:3:1:Cloak::1:0:13216,13217", -- Stormpike Soldier's Cloak
	[19085]="0:0:4:3:1:Cloak::1:0:13218,13219", -- Frostwolf Advisor's Cloak
	[19086]="0:0:4:3:1:Cloak::1:0:13216,13217", -- Stormpike Sage's Cloak
	[19087]="0:0:4:3:1:Plate::1:0:13218,13219", -- Frostwolf Plate Belt
	[19088]="0:0:4:3:1:Mail::1:0:13218,13219", -- Frostwolf Mail Belt
	[19089]="0:0:4:3:1:Leather::1:0:13218,13219", -- Frostwolf Leather Belt
	[19090]="0:0:4:3:1:Cloth::1:0:13218,13219", -- Frostwolf Cloth Belt
	[19091]="0:0:4:3:1:Plate::1:0:13216,13217", -- Stormpike Plate Girdle
	[19092]="0:0:4:3:1:Mail::1:0:13216,13217", -- Stormpike Mail Girdle
	[19093]="0:0:4:3:1:Leather::1:0:13216,13217", -- Stormpike Leather Girdle
	[19094]="0:0:4:3:1:Cloth::1:0:13216,13217", -- Stormpike Cloth Girdle
	[19095]="0:0:4:3:1:Amulet::1:0:13218,13219", -- Frostwolf Legionnaire's Pendant
	[19096]="0:0:4:3:1:Amulet::1:0:13218,13219", -- Frostwolf Advisor's Pendant
	[19097]="0:0:4:3:1:Amulet::1:0:13216,13217", -- Stormpike Soldier's Pendant
	[19098]="0:0:4:3:1:Amulet::1:0:13216,13217", -- Stormpike Sage's Pendant
	[19099]="0:0:2:3:1:Dagger::1:0:13218,13219", -- Glacial Blade
	[19100]="0:0:2:3:1:Dagger::1:0:13216,13217", -- Electrified Dagger
	[19101]="0:0:2:3:1:Stave::1:0:13218,13219", -- Whiteout Staff
	[19102]="0:0:2:3:1:Stave::1:0:13216,13217", -- Crackling Staff
	[19103]="0:0:2:3:1:OneHandAxe::1:0:13218,13219", -- Frostbite
	[19104]="0:0:2:3:1:OneHandMace::1:0:13216,13217", -- Stormstrike Hammer
	[19105]="0:0:4:3:1:Cloth::1:0:", -- Frost Runed Headdress
	[19106]="0:66021:2:3:1:Polearm::1:0:", -- Ice Barbed Spear
	[19107]="0:39756:2:3:1:Crossbow::1:0:", -- Bloodseeker
	[19108]="0:39896:2:3:1:Wand::1:0:", -- Wand of Biting Cold
	[19109]="0:33920:4:3:1:Ring::1:0:", -- Deep Rooted Ring
	[19110]="0:0:2:3:1:OneHandSword::1:0:", -- Cold Forged Blade
	[19111]="0:22580:4:3:1:Mail::1:0:", -- Winteraxe Epaulets
	[19112]="0:17650:4:3:1:Plate::1:0:", -- Frozen Steel Vambraces
	[19113]="0:12583:4:3:1:Leather::1:0:", -- Yeti Hide Bracers
	[19114]="0:18282:2:2:1:Bow::1:0:", -- Highland Bow
	[19115]="0:11003:4:2:1:OffHandFrill::1:0:", -- Flask of Forest Mojo
	[19116]="0:4590:4:2:1:Cloth::1:0:", -- Greenleaf Handwraps
	[19117]="0:16127:4:2:1:Plate::1:0:", -- Laquered Wooden Plate Legplates
	[19118]="0:17344:2:2:1:Wand::1:0:", -- Nature's Breath
	[19119]="0:5803:4:2:1:Leather::1:0:", -- Owlbeast Hide Gloves
	[19120]="0:16283:4:2:1:Trinket::1:0:", -- Rune of the Guard Captain
	[19121]="0:9007:4:3:1:Cloak::1:0:", -- Deep Woodlands Cloak
	[19123]="0:4114:4:2:1:Cloth::1:0:", -- Everwarm Handwraps
	[19124]="0:14453:4:2:1:Plate::1:0:", -- Slagplate Leggings
	[19125]="0:6652:4:2:1:Mail::1:0:", -- Seared Mail Girdle
	[19126]="0:7833:4:2:1:Plate::1:0:", -- Slagplate Gauntlets
	[19127]="0:12258:4:2:1:Leather::1:0:", -- Charred Leather Tunic
	[19128]="0:13358:4:2:1:Mail::1:0:", -- Seared Mail Vest
	[19130]="0:54431:2:4:1:Wand::1:0:", -- Cold Snap
	[19131]="0:21586:4:4:1:Cloth::1:0:", -- Snowblind Shoes
	[19132]="0:21400:4:4:1:Cloth::1:0:", -- Crystal Adorned Crown
	[19133]="0:29722:4:4:1:Cloth::1:0:", -- Fel Infused Leggings
	[19134]="0:17969:4:4:1:Leather::1:0:", -- Flayed Doomguard Belt
	[19135]="0:14066:4:4:1:Cloth::1:0:", -- Blacklight Bracer
	[19136]="0:15029:4:4:1:Cloth::1:0:", -- Mana Igniting Cord
	[19137]="0:28803:4:4:1:Plate::1:0:", -- Onslaught Girdle
	[19138]="0:79853:4:4:1:Ring::1:0:", -- Band of Sulfuras
	[19139]="0:28496:4:4:1:Leather::1:0:", -- Fireguard Shoulders
	[19140]="0:60256:4:4:1:Ring::1:0:", -- Cauterizing Band
	[19141]="0:16612:4:2:1:Trinket::1:0:", -- Luffa
	[19142]="0:18903:4:4:1:OffHandFrill::1:0:", -- Fire Runed Grimoire
	[19143]="0:27183:4:4:1:Plate::1:0:", -- Flameguard Gauntlets
	[19144]="0:34596:4:4:1:Mail::1:0:", -- Sabatons of the Flamewalker
	[19145]="0:29952:4:4:1:Cloth::1:0:", -- Robe of Volatile Power
	[19146]="0:18542:4:4:1:Leather::1:0:", -- Wristguards of Stability
	[19147]="0:91453:4:4:1:Ring::1:0:", -- Ring of Spell Power
	[19148]="0:35881:4:4:1:Plate::1:0:", -- Dark Iron Helm
	[19149]="0:17185:4:4:1:Leather::1:0:", -- Lava Belt
	[19150]="0:0:15:1:1:Junk::1:0:", -- Sentinel Basic Care Package
	[19151]="0:0:15:1:1:Junk::1:0:", -- Sentinel Standard Care Package
	[19152]="0:0:15:1:1:Junk::1:0:", -- Sentinel Advanced Care Package
	[19153]="0:0:15:1:1:Junk::1:0:", -- Outrider Advanced Care Package
	[19154]="0:0:15:1:1:Junk::1:0:", -- Outrider Basic Care Package
	[19155]="0:0:15:1:1:Junk::1:0:", -- Outrider Standard Care Package
	[19156]="0:28236:4:4:1:Cloth::1:0:", -- Flarecore Robe
	[19157]="0:22350:4:4:1:Mail::1:0:", -- Chromatic Gauntlets
	[19159]="0:21141:4:3:1:Amulet::1:0:", -- Woven Ivy Necklace
	[19160]="0:0:4:1:1:Tabard::1:0:", -- Contest Winner's Tabard
	[19162]="0:19474:4:4:1:Leather::1:0:", -- Corehound Belt
	[19163]="0:19544:4:4:1:Leather::1:0:", -- Molten Belt
	[19164]="0:27616:4:4:1:Plate::1:0:", -- Dark Iron Gauntlets
	[19165]="0:31491:4:4:1:Cloth::1:0:", -- Flarecore Leggings
	[19166]="0:75133:2:4:1:Dagger::1:0:", -- Black Amnesty
	[19167]="0:94248:2:4:1:Polearm::1:0:", -- Blackfury
	[19168]="0:71993:2:4:1:OneHandSword::1:0:", -- Blackguard
	[19169]="0:90341:2:4:1:TwoHandAxe::1:0:", -- Nightfall
	[19170]="0:72552:2:4:1:OneHandMace::1:0:", -- Ebon Hand
	[19182]="0:25:15:1:200:Junk::1:0:", -- Darkmoon Faire Prize Ticket
	[19183]="0:0:0:1:200:Other::1:0:", -- Hourglass Sand
	[19202]="22000:5500:9:1:1:Blacksmithing::1:0:11557", -- Plans: Heavy Timbermaw Belt
	[19203]="22000:5500:9:1:1:Blacksmithing::1:0:10856,10857,11536", -- Plans: Girdle of the Dawn
	[19204]="40000:10000:9:1:1:Blacksmithing::1:0:11557", -- Plans: Heavy Timbermaw Boots
	[19205]="40000:10000:9:1:1:Blacksmithing::1:0:10856,10857,11536", -- Plans: Gloves of the Dawn
	[19206]="60000:15000:9:1:1:Blacksmithing::1:1:12944", -- Plans: Dark Iron Helm
	[19207]="80000:20000:9:1:1:Blacksmithing::1:0:12944", -- Plans: Dark Iron Gauntlets
	[19208]="70000:17500:9:1:1:Blacksmithing::1:0:12944", -- Plans: Black Amnesty
	[19209]="70000:17500:9:1:1:Blacksmithing::1:0:12944", -- Plans: Blackfury
	[19210]="0:30000:9:1:1:Blacksmithing::1:0:", -- Plans: Ebon Hand
	[19211]="0:30000:9:1:1:Blacksmithing::1:0:", -- Plans: Blackguard
	[19212]="0:30000:9:1:1:Blacksmithing::1:0:", -- Plans: Nightfall
	[19213]="0:0:12:2:250:::1:0:", -- Silverwing Talisman of Merit
	[19215]="22000:5500:9:1:1:Tailoring::1:0:11557", -- Pattern: Wisdom of the Timbermaw
	[19216]="22000:5500:9:1:1:Tailoring::1:0:10856,10857,11536", -- Pattern: Argent Boots
	[19217]="40000:10000:9:1:1:Tailoring::1:0:10856,10857,11536", -- Pattern: Argent Shoulders
	[19218]="40000:10000:9:1:1:Tailoring::1:0:11557", -- Pattern: Mantle of the Timbermaw
	[19219]="60000:15000:9:1:1:Tailoring::1:1:12944", -- Pattern: Flarecore Robe
	[19220]="90000:22500:9:1:1:Tailoring::1:0:12944", -- Pattern: Flarecore Leggings
	[19221]="50:12:0:1:10:FoodDrink::1:0:14844", -- Darkmoon Special Reserve
	[19222]="10:2:0:1:10:FoodDrink::1:0:14844,20377", -- Cheap Beer
	[19223]="25:1:0:1:20:FoodDrink::5:0:14845", -- Darkmoon Dog
	[19224]="1000:50:0:1:20:FoodDrink::5:0:14845", -- Red Hot Wings
	[19225]="4000:200:0:1:20:FoodDrink::5:0:14845", -- Deep Fried Candybar
	[19227]="0:12500:12:3:20:::1:0:", -- Ace of Beasts
	[19228]="0:50000:12:4:1:::1:0:", -- Beasts Deck
	[19229]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #1
	[19230]="0:12500:12:3:20:::1:0:", -- Two of Beasts
	[19231]="0:12500:12:3:20:::1:0:", -- Three of Beasts
	[19232]="0:12500:12:3:20:::1:0:", -- Four of Beasts
	[19233]="0:12500:12:3:20:::1:0:", -- Five of Beasts
	[19234]="0:12500:12:3:20:::1:0:", -- Six of Beasts
	[19235]="0:12500:12:3:20:::1:0:", -- Seven of Beasts
	[19236]="0:12500:12:3:20:::1:0:", -- Eight of Beasts
	[19237]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #19
	[19238]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #3
	[19239]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #4
	[19240]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #5
	[19241]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #6
	[19242]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #7
	[19243]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #8
	[19244]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #9
	[19245]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #10
	[19246]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #11
	[19247]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #12
	[19248]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #13
	[19249]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #14
	[19250]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #15
	[19251]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #16
	[19252]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #18
	[19253]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #17
	[19254]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #21
	[19255]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #22
	[19256]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #2
	[19257]="0:50000:12:4:1:::1:0:", -- Warlords Deck
	[19258]="0:12500:12:3:20:::1:0:", -- Ace of Warlords
	[19259]="0:12500:12:3:20:::1:0:", -- Two of Warlords
	[19260]="0:12500:12:3:20:::1:0:", -- Three of Warlords
	[19261]="0:12500:12:3:20:::1:0:", -- Four of Warlords
	[19262]="0:12500:12:3:20:::1:0:", -- Five of Warlords
	[19263]="0:12500:12:3:20:::1:0:", -- Six of Warlords
	[19264]="0:12500:12:3:20:::1:0:", -- Seven of Warlords
	[19265]="0:12500:12:3:20:::1:0:", -- Eight of Warlords
	[19266]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #20
	[19267]="0:50000:12:4:1:::1:0:", -- Elementals Deck
	[19268]="0:12500:12:3:20:::1:0:", -- Ace of Elementals
	[19269]="0:12500:12:3:20:::1:0:", -- Two of Elementals
	[19270]="0:12500:12:3:20:::1:0:", -- Three of Elementals
	[19271]="0:12500:12:3:20:::1:0:", -- Four of Elementals
	[19272]="0:12500:12:3:20:::1:0:", -- Five of Elementals
	[19273]="0:12500:12:3:20:::1:0:", -- Six of Elementals
	[19274]="0:12500:12:3:20:::1:0:", -- Seven of Elementals
	[19275]="0:12500:12:3:20:::1:0:", -- Eight of Elementals
	[19276]="0:12500:12:3:20:::1:0:", -- Ace of Portals
	[19277]="0:50000:12:4:1:::1:0:", -- Portals Deck
	[19278]="0:12500:12:3:20:::1:0:", -- Two of Portals
	[19279]="0:12500:12:3:20:::1:0:", -- Three of Portals
	[19280]="0:12500:12:3:20:::1:0:", -- Four of Portals
	[19281]="0:12500:12:3:20:::1:0:", -- Five of Portals
	[19282]="0:12500:12:3:20:::1:0:", -- Six of Portals
	[19283]="0:12500:12:3:20:::1:0:", -- Seven of Portals
	[19284]="0:12500:12:3:20:::1:0:", -- Eight of Portals
	[19287]="0:100000:4:4:1:Trinket::1:0:", -- Darkmoon Card: Heroism
	[19288]="0:100000:4:4:1:Trinket::1:0:", -- Darkmoon Card: Blue Dragon
	[19289]="0:100000:4:4:1:Trinket::1:0:", -- Darkmoon Card: Maelstrom
	[19290]="0:100000:4:4:1:Trinket::1:0:", -- Darkmoon Card: Twisting Nether
	[19291]="0:25000:1:1:1:Bag::1:0:", -- Darkmoon Storage Box
	[19292]="0:4022:2:1:1:OneHandMace::1:0:", -- Last Month's Mutton
	[19293]="0:19376:2:1:1:OneHandMace::1:0:", -- Last Year's Mutton
	[19295]="0:750:4:1:1:OffHandFrill::1:0:", -- Darkmoon Flower
	[19296]="0:250:15:2:1:Junk::1:0:", -- Greater Darkmoon Prize
	[19297]="0:110:15:2:1:Junk::1:0:", -- Lesser Darkmoon Prize
	[19298]="0:50:15:2:1:Junk::1:0:", -- Minor Darkmoon Prize
	[19299]="500:25:0:1:20:FoodDrink::5:0:14844", -- Fizzy Faire Drink
	[19300]="2000:100:0:1:20:FoodDrink::5:0:14844", -- Bottled Winterspring Water
	[19301]="7000:350:0:1:20:FoodDrink::5:0:13216,13217,13218,13219", -- Alterac Manna Biscuit
	[19302]="0:12500:4:3:1:Ring::1:0:", -- Darkmoon Ring
	[19303]="50000:12500:4:2:1:Amulet::1:1:14846", -- Darkmoon Necklace
	[19304]="125:6:0:1:20:FoodDrink::5:0:14845", -- Spiced Beef Jerky
	[19305]="500:25:0:1:20:FoodDrink::5:0:14845", -- Pickled Kodo Foot
	[19306]="2000:100:0:1:20:FoodDrink::5:0:14845", -- Crunchy Frog
	[19307]="8000:100:0:1:100:Bandage::20:0:13216,13217,13218,13219", -- Alterac Heavy Runecloth Bandage
	[19308]="0:0:4:4:1:OffHandFrill::1:0:13216,13217,13218,13219", -- Tome of Arcane Domination
	[19309]="0:0:4:4:1:OffHandFrill::1:0:13216,13217,13218,13219", -- Tome of Shadow Force
	[19310]="0:0:4:4:1:OffHandFrill::1:0:13216,13217,13218,13219", -- Tome of the Ice Lord
	[19311]="0:0:4:4:1:OffHandFrill::1:0:13216,13217,13218,13219", -- Tome of Fiery Arcana
	[19312]="0:0:4:4:1:OffHandFrill::1:0:13216,13217,13218,13219", -- Lei of the Lifegiver
	[19315]="0:0:4:4:1:OffHandFrill::1:0:13216,13217,13218,13219", -- Therazane's Touch
	[19316]="6000:7:6:2:1000:Arrow::200:0:13216,13217,13218,13219", -- Ice Threaded Arrow
	[19317]="6000:7:6:2:200:Bullet::200:0:13216,13217,13218,13219", -- Ice Threaded Bullet
	[19318]="5000:250:0:1:20:Consumable::5:0:13216,13217,13218,13219", -- Bottled Alterac Spring Water
	[19319]="0:0:11:3:1:Quiver::1:0:13216,13217,13218,13219", -- Harpy Hide Quiver
	[19320]="0:0:11:3:1:AmmoPouch::1:0:13216,13217,13218,13219", -- Gnoll Skin Bandolier
	[19321]="0:0:4:4:1:Shield::1:0:13216,13217,13218,13219", -- The Immovable Object
	[19323]="0:0:2:4:1:TwoHandMace::1:0:13216,13217,13218,13219", -- The Unstoppable Force
	[19324]="0:0:2:4:1:Dagger::1:0:13216,13217,13218,13219", -- The Lobotomizer
	[19325]="0:0:4:4:1:Ring::1:0:13216,13217,13218,13219", -- Don Julio's Band
	[19326]="22000:5500:9:1:1:Leatherworking::1:0:11557", -- Pattern: Might of the Timbermaw
	[19327]="40000:10000:9:1:1:Leatherworking::1:0:11557", -- Pattern: Timbermaw Brawlers
	[19328]="22000:5500:9:1:1:Leatherworking::1:0:10856,10857,11536", -- Pattern: Dawn Treaders
	[19329]="40000:10000:9:1:1:Leatherworking::1:0:10856,10857,11536", -- Pattern: Golden Mantle of the Dawn
	[19330]="60000:15000:9:1:1:Leatherworking::1:1:12944", -- Pattern: Lava Belt
	[19331]="90000:22500:9:1:1:Leatherworking::1:0:12944", -- Pattern: Chromatic Gauntlets
	[19332]="90000:22500:9:1:1:Leatherworking::1:0:12944", -- Pattern: Corehound Belt
	[19333]="90000:22500:9:1:1:Leatherworking::1:0:12944", -- Pattern: Molten Belt
	[19334]="0:100551:2:4:1:TwoHandSword::1:0:", -- The Untamed Blade
	[19335]="0:80731:2:4:1:OneHandMace::1:0:", -- Spineshatter
	[19336]="0:72039:4:4:1:Trinket::1:0:", -- Arcane Infused Gem
	[19337]="0:72039:4:4:1:Trinket::1:0:", -- The Black Book
	[19338]="0:0:12:1:1:::1:0:", -- Free Ticket Voucher
	[19339]="0:72039:4:4:1:Trinket::1:0:", -- Mind Quickening Gem
	[19340]="0:72039:4:4:1:Trinket::1:0:", -- Rune of Metamorphosis
	[19341]="0:72039:4:4:1:Trinket::1:0:", -- Lifegiving Gem
	[19342]="0:72039:4:4:1:Trinket::1:0:", -- Venomous Totem
	[19343]="0:72039:4:4:1:Trinket::1:0:", -- Scrolls of Blinding Light
	[19344]="0:72039:4:4:1:Trinket::1:0:", -- Natural Alignment Crystal
	[19345]="0:72039:4:4:1:Trinket::1:0:", -- Aegis of Preservation
	[19346]="0:79053:2:4:1:Dagger::1:0:", -- Dragonfang Blade
	[19347]="0:82129:2:4:1:Dagger::1:0:", -- Claw of Chromaggus
	[19348]="0:50969:4:4:1:Shield::1:0:", -- Red Dragonscale Protector
	[19349]="0:52946:4:4:1:Shield::1:0:", -- Elementium Reinforced Bulwark
	[19350]="0:60867:2:4:1:Bow::1:0:", -- Heartstriker
	[19351]="0:81453:2:4:1:OneHandSword::1:0:", -- "Maladath, Runed Blade of the Black Flight"
	[19352]="0:85814:2:4:1:OneHandSword::1:0:", -- Chromatically Tempered Sword
	[19353]="0:105206:2:4:1:TwoHandAxe::1:0:", -- Drake Talon Cleaver
	[19354]="0:91123:2:4:1:TwoHandAxe::1:0:", -- Draconic Avenger
	[19355]="0:95910:2:4:1:Stave::1:0:", -- Shadow Wing Focus Staff
	[19356]="0:102955:2:4:1:Stave::1:0:", -- Staff of the Shadow Flame
	[19357]="0:96642:2:4:1:TwoHandMace::1:0:", -- Herald of Woe
	[19358]="0:91409:2:4:1:TwoHandMace::1:0:", -- Draconic Maul
	[19360]="0:83625:2:4:1:OneHandMace::1:0:", -- Lok'amir il Romathis
	[19361]="0:60230:2:4:1:Crossbow::1:0:", -- "Ashjre'thul, Crossbow of Smiting"
	[19362]="0:74238:2:4:1:OneHandAxe::1:0:", -- Doom's Edge
	[19363]="0:84569:2:4:1:OneHandAxe::1:0:", -- "Crul'shorukh, Edge of Chaos"
	[19364]="0:106097:2:4:1:TwoHandSword::1:0:", -- "Ashkandi, Greatsword of the Brotherhood"
	[19365]="0:79672:2:4:1:FistWeapon::1:0:", -- Claw of the Black Drake
	[19366]="0:203059:4:4:1:OffHandFrill::1:0:", -- Master Dragonslayer's Orb
	[19367]="0:60199:2:4:1:Wand::1:0:", -- Dragon's Touch
	[19368]="0:62010:2:4:1:Gun::1:0:", -- Dragonbreath Hand Cannon
	[19369]="0:16212:4:4:1:Cloth::1:0:", -- Gloves of Rapid Evolution
	[19370]="0:24405:4:4:1:Cloth::1:0:", -- Mantle of the Blackwing Cabal
	[19371]="0:88355:4:4:1:Amulet::1:0:", -- Pendant of the Fallen Dragon
	[19372]="0:43435:4:4:1:Plate::1:0:", -- Helm of Endless Rage
	[19373]="0:38038:4:4:1:Mail::1:0:", -- Black Brood Pauldrons
	[19374]="0:15284:4:4:1:Cloth::1:0:", -- Bracers of Arcane Accuracy
	[19375]="0:25143:4:4:1:Cloth::1:0:", -- "Mish'undare, Circlet of the Mind Flayer"
	[19376]="0:111528:4:4:1:Ring::1:0:", -- Archimtiros' Ring of Reckoning
	[19377]="0:105328:4:4:1:Amulet::1:0:", -- Prestor's Talisman of Connivery
	[19378]="0:25432:4:4:1:Cloak::1:0:", -- Cloak of the Brood Lord
	[19379]="0:205863:4:4:1:Trinket::1:0:", -- Neltharion's Tear
	[19380]="0:25624:4:4:1:Mail::1:0:", -- Therazane's Link
	[19381]="0:32152:4:4:1:Leather::1:0:", -- Boots of the Shadow Flame
	[19382]="0:128280:4:4:1:Ring::1:0:", -- Pure Elementium Band
	[19383]="0:128862:4:4:1:Amulet::1:0:", -- Master Dragonslayer's Medallion
	[19384]="0:130616:4:4:1:Ring::1:0:", -- Master Dragonslayer's Ring
	[19385]="0:33472:4:4:1:Cloth::1:0:", -- Empowered Leggings
	[19386]="0:25195:4:4:1:Cloak::1:0:", -- Elementium Threaded Cloak
	[19387]="0:44162:4:4:1:Plate::1:0:", -- Chromatic Boots
	[19388]="0:16916:4:4:1:Cloth::1:0:", -- Angelista's Grasp
	[19389]="0:31832:4:4:1:Leather::1:0:", -- Taut Dragonhide Shoulderpads
	[19390]="0:21297:4:4:1:Leather::1:0:", -- Taut Dragonhide Gloves
	[19391]="0:25645:4:4:1:Cloth::1:0:", -- Shimmering Geta
	[19392]="0:30198:4:4:1:Plate::1:0:", -- Girdle of the Fallen Crusader
	[19393]="0:25828:4:4:1:Mail::1:0:", -- Primalist's Linked Waistguard
	[19394]="0:40037:4:4:1:Plate::1:0:", -- Drake Talon Pauldrons
	[19395]="0:103103:4:4:1:Trinket::1:0:", -- Rejuvenating Gem
	[19396]="0:19250:4:4:1:Leather::1:0:", -- Taut Dragonhide Belt
	[19397]="0:107438:4:4:1:Ring::1:0:", -- Ring of Blackrock
	[19398]="0:23275:4:4:1:Cloak::1:0:", -- Cloak of Firemaw
	[19399]="0:31153:4:4:1:Cloth::1:0:", -- Black Ash Robe
	[19400]="0:16061:4:4:1:Cloth::1:0:", -- Firemaw's Clutch
	[19401]="0:48361:4:4:1:Mail::1:0:", -- Primalist's Linked Legguards
	[19402]="0:56624:4:4:1:Plate::1:0:", -- Legguards of the Fallen Crusader
	[19403]="0:105328:4:4:1:Ring::1:0:", -- Band of Forced Concentration
	[19405]="0:40891:4:4:1:Leather::1:0:", -- Malfurion's Blessed Bulwark
	[19406]="0:91160:4:4:1:Trinket::1:0:", -- Drake Fang Talisman
	[19407]="0:16473:4:4:1:Cloth::1:0:", -- Ebony Flame Gloves
	[19422]="0:0:12:1:1:::1:0:", -- Darkmoon Faire Fortune
	[19423]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #23
	[19424]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #24
	[19425]="0:0:15:2:1:Junk::1:0:", -- Mysterious Lockbox
	[19426]="0:25000:4:4:1:Amulet::1:0:", -- Orb of the Darkmoon
	[19430]="0:24972:4:4:1:Cloak::1:0:", -- Shroud of Pure Thought
	[19431]="0:103117:4:4:1:Trinket::1:0:", -- Styleen's Impeding Scarab
	[19432]="0:147286:4:4:1:Ring::1:0:", -- Circle of Applied Force
	[19433]="0:46932:4:4:1:Mail::1:0:", -- Emberweave Leggings
	[19434]="0:80863:4:4:1:Ring::1:0:", -- Band of Dark Dominion
	[19435]="0:55695:2:4:1:Wand::1:0:", -- Essence Gatherer
	[19436]="0:22359:4:4:1:Cloak::1:0:", -- Cloak of Draconic Might
	[19437]="0:22443:4:4:1:Cloth::1:0:", -- Boots of Pure Thought
	[19438]="0:22804:4:4:1:Cloth::1:0:", -- Ringo's Blizzard Boots
	[19439]="0:38148:4:4:1:Leather::1:0:", -- Interlaced Shadow Jerkin
	[19440]="0:500:0:1:10:Other::1:0:", -- Powerful Anti-Venom
	[19441]="0:1500:7:1:5:Other:129:1:0:", -- Huge Venom Sac
	[19442]="100000:25000:9:1:1:FirstAid::1:0:10856,10857,11536", -- Formula: Powerful Anti-Venom
	[19443]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #25
	[19444]="30000:7500:9:1:1:Enchanting::1:1:12944", -- Formula: Enchant Weapon - Strength
	[19445]="30000:7500:9:1:1:Enchanting::1:0:11557", -- Formula: Enchant Weapon - Agility
	[19446]="30000:7500:9:1:1:Enchanting::1:0:10856,10857,11536", -- Formula: Enchant Bracer - Mana Regeneration
	[19447]="60000:15000:9:1:1:Enchanting::1:0:10856,10857,11536", -- Formula: Enchant Bracer - Healing Power
	[19448]="80000:20000:9:1:1:Enchanting::1:1:12944", -- Formula: Enchant Weapon - Mighty Spirit
	[19449]="100000:25000:9:1:1:Enchanting::1:1:12944", -- Formula: Enchant Weapon - Mighty Intellect
	[19450]="0:0:15:1:1:Companion::1:0:", -- A Jubling's Tiny Home
	[19451]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #26
	[19452]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #27
	[19453]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #28
	[19454]="0:0:15:1:1:Junk::1:0:", -- Sayge's Fortune #29
	[19462]="0:0:15:1:1:Companion::1:0:", -- Unhatched Jubling Egg
	[19483]="0:0:15:1:1:Junk::1:0:", -- Peeling the Onion
	[19484]="0:0:15:1:1:Junk::1:0:", -- The Frostwolf Artichoke
	[19491]="0:25000:4:4:1:Amulet::1:0:", -- Amulet of the Darkmoon
	[19505]="0:0:4:1:1:Tabard::1:0:5188,5189,5190,14754,16610", -- Warsong Battle Tabard
	[19506]="0:0:4:1:1:Tabard::1:0:5049,5191,5193,14753,16766", -- Silverwing Battle Tabard
	[19507]="0:1701:4:2:1:Cloth::1:0:", -- Inquisitor's Shawl
	[19508]="0:1423:4:2:1:Leather::1:0:", -- Branded Leather Bracers
	[19509]="0:2583:4:2:1:Mail::1:0:", -- Dusty Mail Boots
	[19510]="0:0:4:3:1:Ring::1:0:14754", -- Legionnaire's Band
	[19511]="0:0:4:3:1:Ring::1:0:14754", -- Legionnaire's Band
	[19512]="0:0:4:3:1:Ring::1:0:14754", -- Legionnaire's Band
	[19513]="0:0:4:3:1:Ring::1:0:14754", -- Legionnaire's Band
	[19514]="0:0:4:3:1:Ring::1:0:14753", -- Protector's Band
	[19515]="0:0:4:3:1:Ring::1:0:14753", -- Protector's Band
	[19516]="0:0:4:3:1:Ring::1:0:14753", -- Protector's Band
	[19517]="0:0:4:3:1:Ring::1:0:14753", -- Protector's Band
	[19518]="0:0:4:3:1:Ring::1:0:14754", -- Advisor's Ring
	[19519]="0:0:4:3:1:Ring::1:0:14754", -- Advisor's Ring
	[19520]="0:0:4:3:1:Ring::1:0:14754", -- Advisor's Ring
	[19521]="0:0:4:3:1:Ring::1:0:14754", -- Advisor's Ring
	[19522]="0:0:4:3:1:Ring::1:0:14753", -- Lorekeeper's Ring
	[19523]="0:0:4:3:1:Ring::1:0:14753", -- Lorekeeper's Ring
	[19524]="0:0:4:3:1:Ring::1:0:14753", -- Lorekeeper's Ring
	[19525]="0:0:4:3:1:Ring::1:0:14753", -- Lorekeeper's Ring
	[19526]="0:0:4:3:1:Cloak::1:0:14754", -- Battle Healer's Cloak
	[19527]="0:0:4:3:1:Cloak::1:0:14754", -- Battle Healer's Cloak
	[19528]="0:0:4:3:1:Cloak::1:0:14754", -- Battle Healer's Cloak
	[19529]="0:0:4:3:1:Cloak::1:0:14754", -- Battle Healer's Cloak
	[19530]="0:0:4:3:1:Cloak::1:0:14753", -- Caretaker's Cape
	[19531]="0:0:4:3:1:Cloak::1:0:14753", -- Caretaker's Cape
	[19532]="0:0:4:3:1:Cloak::1:0:14753", -- Caretaker's Cape
	[19533]="0:0:4:3:1:Cloak::1:0:14753", -- Caretaker's Cape
	[19534]="0:0:4:3:1:Amulet::1:0:14754", -- Scout's Medallion
	[19535]="0:0:4:3:1:Amulet::1:0:14754", -- Scout's Medallion
	[19536]="0:0:4:3:1:Amulet::1:0:14754", -- Scout's Medallion
	[19537]="0:0:4:3:1:Amulet::1:0:14754", -- Scout's Medallion
	[19538]="0:0:4:3:1:Amulet::1:0:14753", -- Sentinel's Medallion
	[19539]="0:0:4:3:1:Amulet::1:0:14753", -- Sentinel's Medallion
	[19540]="0:0:4:3:1:Amulet::1:0:14753", -- Sentinel's Medallion
	[19541]="0:0:4:3:1:Amulet::1:0:14753", -- Sentinel's Medallion
	[19542]="0:0:2:3:1:Dagger::1:0:14754", -- Scout's Blade
	[19543]="0:0:2:3:1:Dagger::1:0:14754", -- Scout's Blade
	[19544]="0:0:2:3:1:Dagger::1:0:14754", -- Scout's Blade
	[19545]="0:0:2:3:1:Dagger::1:0:14754", -- Scout's Blade
	[19546]="0:0:2:3:1:Dagger::1:0:14753", -- Sentinel's Blade
	[19547]="0:0:2:3:1:Dagger::1:0:14753", -- Sentinel's Blade
	[19548]="0:0:2:3:1:Dagger::1:0:14753", -- Sentinel's Blade
	[19549]="0:0:2:3:1:Dagger::1:0:14753", -- Sentinel's Blade
	[19550]="0:0:2:3:1:OneHandSword::1:0:14754", -- Legionnaire's Sword
	[19551]="0:0:2:3:1:OneHandSword::1:0:14754", -- Legionnaire's Sword
	[19552]="0:0:2:3:1:OneHandSword::1:0:14754", -- Legionnaire's Sword
	[19553]="0:0:2:3:1:OneHandSword::1:0:14754", -- Legionnaire's Sword
	[19554]="0:0:2:3:1:OneHandSword::1:0:14753", -- Protector's Sword
	[19555]="0:0:2:3:1:OneHandSword::1:0:14753", -- Protector's Sword
	[19556]="0:0:2:3:1:OneHandSword::1:0:14753", -- Protector's Sword
	[19557]="0:0:2:3:1:OneHandSword::1:0:14753", -- Protector's Sword
	[19558]="0:0:2:3:1:Bow::1:0:14754", -- Outrider's Bow
	[19559]="0:0:2:3:1:Bow::1:0:14754", -- Outrider's Bow
	[19560]="0:0:2:3:1:Bow::1:0:14754", -- Outrider's Bow
	[19561]="0:0:2:3:1:Bow::1:0:14754", -- Outrider's Bow
	[19562]="0:0:2:3:1:Bow::1:0:14753", -- Outrunner's Bow
	[19563]="0:0:2:3:1:Bow::1:0:14753", -- Outrunner's Bow
	[19564]="0:0:2:3:1:Bow::1:0:14753", -- Outrunner's Bow
	[19565]="0:0:2:3:1:Bow::1:0:14753", -- Outrunner's Bow
	[19566]="0:0:2:3:1:Stave::1:0:14754", -- Advisor's Gnarled Staff
	[19567]="0:0:2:3:1:Stave::1:0:14754", -- Advisor's Gnarled Staff
	[19568]="0:0:2:3:1:Stave::1:0:14754", -- Advisor's Gnarled Staff
	[19569]="0:0:2:3:1:Stave::1:0:14754", -- Advisor's Gnarled Staff
	[19570]="0:0:2:3:1:Stave::1:0:14753", -- Lorekeeper's Staff
	[19571]="0:0:2:3:1:Stave::1:0:14753", -- Lorekeeper's Staff
	[19572]="0:0:2:3:1:Stave::1:0:14753", -- Lorekeeper's Staff
	[19573]="0:0:2:3:1:Stave::1:0:14753", -- Lorekeeper's Staff
	[19574]="0:0:4:2:1:Amulet::1:0:", -- Strength of Mugamba
	[19575]="0:0:4:3:1:Amulet::1:0:", -- Strength of Mugamba
	[19576]="0:0:4:3:1:Amulet::1:0:", -- Strength of Mugamba
	[19577]="0:0:4:4:1:Amulet::1:0:", -- Rage of Mugamba
	[19578]="0:0:4:4:1:Plate::1:0:14753,14754", -- Berserker Bracers
	[19579]="0:0:4:2:1:Amulet::1:0:", -- Heathen's Brand
	[19580]="0:0:4:4:1:Plate::1:0:14753,14754", -- Berserker Bracers
	[19581]="0:0:4:4:1:Plate::1:0:14753,14754", -- Berserker Bracers
	[19582]="0:0:4:4:1:Mail::1:0:14753,14754", -- Windtalker's Wristguards
	[19583]="0:0:4:4:1:Mail::1:0:14753,14754", -- Windtalker's Wristguards
	[19584]="0:0:4:4:1:Mail::1:0:14753,14754", -- Windtalker's Wristguards
	[19585]="0:0:4:3:1:Amulet::1:0:", -- Heathen's Brand
	[19586]="0:0:4:3:1:Amulet::1:0:", -- Heathen's Brand
	[19587]="0:0:4:4:1:Leather::1:0:14753,14754", -- Forest Stalker's Bracers
	[19588]="0:0:4:4:1:Amulet::1:0:", -- Hero's Brand
	[19589]="0:0:4:4:1:Leather::1:0:14753,14754", -- Forest Stalker's Bracers
	[19590]="0:0:4:4:1:Leather::1:0:14753,14754", -- Forest Stalker's Bracers
	[19591]="0:0:4:2:1:Amulet::1:0:", -- The Eye of Zuldazar
	[19592]="0:0:4:3:1:Amulet::1:0:", -- The Eye of Zuldazar
	[19593]="0:0:4:3:1:Amulet::1:0:", -- The Eye of Zuldazar
	[19594]="0:0:4:4:1:Amulet::1:0:", -- The All-Seeing Eye of Zuldazar
	[19595]="0:0:4:4:1:Cloth::1:0:14753,14754", -- Dryad's Wrist Bindings
	[19596]="0:0:4:4:1:Cloth::1:0:14753,14754", -- Dryad's Wrist Bindings
	[19597]="0:0:4:4:1:Cloth::1:0:14753,14754", -- Dryad's Wrist Bindings
	[19598]="0:0:4:2:1:Amulet::1:0:", -- Pebble of Kajaro
	[19599]="0:0:4:3:1:Amulet::1:0:", -- Pebble of Kajaro
	[19600]="0:0:4:3:1:Amulet::1:0:", -- Pebble of Kajaro
	[19601]="0:0:4:4:1:Amulet::1:0:", -- Jewel of Kajaro
	[19602]="0:0:4:2:1:Amulet::1:0:", -- Kezan's Taint
	[19603]="0:0:4:3:1:Amulet::1:0:", -- Kezan's Taint
	[19604]="0:0:4:3:1:Amulet::1:0:", -- Kezan's Taint
	[19605]="0:0:4:4:1:Amulet::1:0:", -- Kezan's Unstoppable Taint
	[19606]="0:0:4:2:1:Amulet::1:0:", -- Vision of Voodress
	[19607]="0:0:4:3:1:Amulet::1:0:", -- Vision of Voodress
	[19608]="0:0:4:3:1:Amulet::1:0:", -- Vision of Voodress
	[19609]="0:0:4:4:1:Amulet::1:0:", -- Unmarred Vision of Voodress
	[19610]="0:0:4:2:1:Amulet::1:0:", -- Enchanted South Seas Kelp
	[19611]="0:0:4:3:1:Amulet::1:0:", -- Enchanted South Seas Kelp
	[19612]="0:0:4:3:1:Amulet::1:0:", -- Enchanted South Seas Kelp
	[19613]="0:0:4:4:1:Amulet::1:0:", -- Pristine Enchanted South Seas Kelp
	[19614]="0:0:4:2:1:Amulet::1:0:", -- Zandalarian Shadow Talisman
	[19615]="0:0:4:3:1:Amulet::1:0:", -- Zandalarian Shadow Talisman
	[19616]="0:0:4:3:1:Amulet::1:0:", -- Zandalarian Shadow Talisman
	[19617]="0:0:4:4:1:Amulet::1:0:", -- Zandalarian Shadow Mastery Talisman
	[19618]="0:0:4:2:1:Amulet::1:0:", -- Maelstrom's Tendril
	[19619]="0:0:4:3:1:Amulet::1:0:", -- Maelstrom's Tendril
	[19620]="0:0:4:3:1:Amulet::1:0:", -- Maelstrom's Tendril
	[19621]="0:0:4:4:1:Amulet::1:0:", -- Maelstrom's Wrath
	[19682]="0:20986:4:3:1:Cloth::1:0:", -- Bloodvine Vest
	[19683]="0:21065:4:3:1:Cloth::1:0:", -- Bloodvine Leggings
	[19684]="0:15856:4:3:1:Cloth::1:0:", -- Bloodvine Boots
	[19685]="0:26526:4:3:1:Leather::1:0:", -- Primal Batskin Jerkin
	[19686]="0:13312:4:3:1:Leather::1:0:", -- Primal Batskin Gloves
	[19687]="0:13361:4:3:1:Leather::1:0:", -- Primal Batskin Bracers
	[19688]="0:26819:4:3:1:Leather::1:0:", -- Blood Tiger Breastplate
	[19689]="0:20188:4:3:1:Leather::1:0:", -- Blood Tiger Shoulders
	[19690]="0:33265:4:3:1:Mail::1:0:", -- Bloodsoul Breastplate
	[19691]="0:25148:4:3:1:Mail::1:0:", -- Bloodsoul Shoulders
	[19692]="0:16749:4:3:1:Mail::1:0:", -- Bloodsoul Gauntlets
	[19693]="0:35490:4:3:1:Plate::1:0:", -- Darksoul Breastplate
	[19694]="0:35628:4:3:1:Plate::1:0:", -- Darksoul Leggings
	[19695]="0:26773:4:3:1:Plate::1:0:", -- Darksoul Shoulders
	[19696]="0:0:0:1:20:FoodDrink::1:0:", -- Harvest Bread
	[19697]="0:0:4:1:1:Miscellaneous::1:0:", -- Bounty of the Harvest
	[19698]="0:0:12:2:250:::1:0:", -- Zulian Coin
	[19699]="0:0:12:2:250:::1:0:", -- Razzashi Coin
	[19700]="0:0:12:2:250:::1:0:", -- Hakkari Coin
	[19701]="0:0:12:2:250:::1:0:", -- Gurubashi Coin
	[19702]="0:0:12:2:250:::1:0:", -- Vilebranch Coin
	[19703]="0:0:12:2:250:::1:0:", -- Witherbark Coin
	[19704]="0:0:12:2:250:::1:0:", -- Sandfury Coin
	[19705]="0:0:12:2:250:::1:0:", -- Skullsplitter Coin
	[19706]="0:0:12:2:250:::1:0:", -- Bloodscalp Coin
	[19707]="0:0:12:3:250:::1:0:", -- Red Hakkari Bijou
	[19708]="0:0:12:3:250:::1:0:", -- Blue Hakkari Bijou
	[19709]="0:0:12:3:250:::1:0:", -- Yellow Hakkari Bijou
	[19710]="0:0:12:3:250:::1:0:", -- Orange Hakkari Bijou
	[19711]="0:0:12:3:250:::1:0:", -- Green Hakkari Bijou
	[19712]="0:0:12:3:250:::1:0:", -- Purple Hakkari Bijou
	[19713]="0:0:12:3:250:::1:0:", -- Bronze Hakkari Bijou
	[19714]="0:0:12:3:250:::1:0:", -- Silver Hakkari Bijou
	[19715]="0:0:12:3:250:::1:0:", -- Gold Hakkari Bijou
	[19716]="0:0:12:4:250:::1:0:", -- Primal Hakkari Bindings
	[19717]="0:0:12:4:250:::1:0:", -- Primal Hakkari Armsplint
	[19718]="0:0:12:4:250:::1:0:", -- Primal Hakkari Stanchion
	[19719]="0:0:12:4:250:::1:0:", -- Primal Hakkari Girdle
	[19720]="0:0:12:4:250:::1:0:", -- Primal Hakkari Sash
	[19721]="0:0:12:4:250:::1:0:", -- Primal Hakkari Shawl
	[19722]="0:0:12:4:250:::1:0:", -- Primal Hakkari Tabard
	[19723]="0:0:12:4:250:::1:0:", -- Primal Hakkari Kossack
	[19724]="0:0:12:4:250:::1:0:", -- Primal Hakkari Aegis
	[19725]="0:0:12:1:20:::1:0:", -- Arathi Resource Crate
	[19726]="0:500:7:2:20:Herb:164,202,165,197:1:0:", -- Bloodvine
	[19727]="0:15000:7:3:1:Herb::1:0:", -- Blood Scythe
	[19764]="50000:12500:9:1:1:Tailoring::1:0:14921", -- Pattern: Bloodvine Vest
	[19765]="50000:12500:9:1:1:Tailoring::1:0:14921", -- Pattern: Bloodvine Leggings
	[19766]="50000:12500:9:1:1:Tailoring::1:0:14921", -- Pattern: Bloodvine Boots
	[19767]="0:2000:7:1:20:Leather:165:1:0:", -- Primal Bat Leather
	[19768]="0:2000:7:1:20:Leather:165:1:0:", -- Primal Tiger Leather
	[19769]="50000:12500:9:1:1:Leatherworking::1:0:14921", -- Pattern: Primal Batskin Jerkin
	[19770]="50000:12500:9:1:1:Leatherworking::1:0:14921", -- Pattern: Primal Batskin Gloves
	[19771]="50000:12500:9:1:1:Leatherworking::1:0:14921", -- Pattern: Primal Batskin Bracers
	[19772]="50000:12500:9:1:1:Leatherworking::1:0:14921", -- Pattern: Blood Tiger Breastplate
	[19773]="50000:12500:9:1:1:Leatherworking::1:0:14921", -- Pattern: Blood Tiger Shoulders
	[19774]="0:5000:3:2:20:GemSimple:164:1:0:", -- Souldarite
	[19775]="0:0:15:1:1:Junk::1:0:", -- Sealed Azure Bag
	[19776]="50000:12500:9:1:1:Blacksmithing::1:0:14921", -- Plans: Bloodsoul Breastplate
	[19777]="50000:12500:9:1:1:Blacksmithing::1:0:14921", -- Plans: Bloodsoul Shoulders
	[19778]="50000:12500:9:1:1:Blacksmithing::1:0:14921", -- Plans: Bloodsoul Gauntlets
	[19779]="50000:12500:9:1:1:Blacksmithing::1:0:14921", -- Plans: Darksoul Breastplate
	[19780]="50000:12500:9:1:1:Blacksmithing::1:0:14921", -- Plans: Darksoul Leggings
	[19781]="50000:12500:9:1:1:Blacksmithing::1:0:14921", -- Plans: Darksoul Shoulders
	[19782]="0:0:0:3:1:EnhPerm::1:0:", -- Presence of Might
	[19783]="0:0:0:3:1:EnhPerm::1:0:", -- Syncretist's Sigil
	[19784]="0:0:0:3:1:EnhPerm::1:0:", -- Death's Embrace
	[19785]="0:0:0:3:1:EnhPerm::1:0:", -- Falcon's Call
	[19786]="0:0:0:3:1:EnhPerm::1:0:", -- Vodouisant's Vigilant Embrace
	[19787]="0:0:0:3:1:EnhPerm::1:0:", -- Presence of Sight
	[19788]="0:0:0:3:1:EnhPerm::1:0:", -- Hoodoo Hex
	[19789]="0:0:0:3:1:EnhPerm::1:0:", -- Prophetic Aura
	[19790]="0:0:0:3:1:EnhPerm::1:0:", -- Animist's Caress
	[19802]="0:0:12:4:1:::1:0:", -- Heart of Hakkar
	[19803]="0:0:15:2:20:Junk::1:0:", -- Brownell's Blue Striped Racer
	[19805]="0:0:15:2:20:Junk::1:0:", -- Keefer's Angelfish
	[19806]="0:0:15:2:20:Junk::1:0:", -- Dezian Queenfish
	[19807]="0:0:12:1:20:::1:0:", -- Speckled Tastyfish
	[19808]="0:15556:2:2:1:OneHandMace::1:0:", -- Rockhide Strongfish
	[19812]="0:0:4:3:1:Trinket::1:0:", -- Rune of the Dawn
	[19813]="0:0:12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19814]="0:0:12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19815]="0:0:12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19816]="0:0:12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19817]="0:0:12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19818]="0:0:12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19819]="0:0:12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19820]="0:0:12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19821]="0:0:12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19822]="0:0:4:4:1:Plate::1:0:", -- Zandalar Vindicator's Breastplate
	[19823]="0:0:4:4:1:Plate::1:0:", -- Zandalar Vindicator's Belt
	[19824]="0:0:4:4:1:Plate::1:0:", -- Zandalar Vindicator's Armguards
	[19825]="0:0:4:4:1:Plate::1:0:", -- Zandalar Freethinker's Breastplate
	[19826]="0:0:4:4:1:Plate::1:0:", -- Zandalar Freethinker's Belt
	[19827]="0:0:4:4:1:Plate::1:0:", -- Zandalar Freethinker's Armguards
	[19828]="0:0:4:4:1:Mail::1:0:", -- Zandalar Augur's Hauberk
	[19829]="0:0:4:4:1:Mail::1:0:", -- Zandalar Augur's Belt
	[19830]="0:0:4:4:1:Mail::1:0:", -- Zandalar Augur's Bracers
	[19831]="0:0:4:4:1:Mail::1:0:", -- Zandalar Predator's Mantle
	[19832]="0:0:4:4:1:Mail::1:0:", -- Zandalar Predator's Belt
	[19833]="0:0:4:4:1:Mail::1:0:", -- Zandalar Predator's Bracers
	[19834]="0:0:4:4:1:Leather::1:0:", -- Zandalar Madcap's Tunic
	[19835]="0:0:4:4:1:Leather::1:0:", -- Zandalar Madcap's Mantle
	[19836]="0:0:4:4:1:Leather::1:0:", -- Zandalar Madcap's Bracers
	[19838]="0:0:4:4:1:Leather::1:0:", -- Zandalar Haruspex's Tunic
	[19839]="0:0:4:4:1:Leather::1:0:", -- Zandalar Haruspex's Belt
	[19840]="0:0:4:4:1:Leather::1:0:", -- Zandalar Haruspex's Bracers
	[19841]="0:0:4:4:1:Cloth::1:0:", -- Zandalar Confessor's Mantle
	[19842]="0:0:4:4:1:Cloth::1:0:", -- Zandalar Confessor's Bindings
	[19843]="0:0:4:4:1:Cloth::1:0:", -- Zandalar Confessor's Wraps
	[19845]="0:0:4:4:1:Cloth::1:0:", -- Zandalar Illusionist's Mantle
	[19846]="0:0:4:4:1:Cloth::1:0:", -- Zandalar Illusionist's Wraps
	[19848]="0:0:4:4:1:Cloth::1:0:", -- Zandalar Demoniac's Wraps
	[19849]="0:0:4:4:1:Cloth::1:0:", -- Zandalar Demoniac's Mantle
	[19850]="0:0:12:1:1:::1:0:", -- Uther's Tribute
	[19851]="0:0:12:1:1:::1:0:", -- Grom's Tribute
	[19852]="0:73811:2:4:1:OneHandAxe::1:0:", -- Ancient Hakkari Manslayer
	[19853]="0:55563:2:4:1:Gun::1:0:", -- Gurubashi Dwarf Destroyer
	[19854]="0:92937:2:4:1:TwoHandSword::1:0:", -- "Zin'rokh, Destroyer of Worlds"
	[19855]="0:52235:4:4:1:Plate::1:0:", -- Bloodsoaked Legplates
	[19856]="0:48628:4:4:1:Amulet::1:0:", -- The Eye of Hakkar
	[19857]="0:22550:4:4:1:Cloak::1:0:", -- Cloak of Consumption
	[19858]="0:0:12:2:250:::1:0:", -- Zandalar Honor Token
	[19859]="0:75706:2:4:1:Dagger::1:0:", -- Fang of the Faceless
	[19861]="0:57183:2:4:1:Wand::1:0:", -- Touch of Chaos
	[19862]="0:48971:4:4:1:Shield::1:0:", -- Aegis of the Blood God
	[19863]="0:61286:4:3:1:Ring::1:0:", -- Primalist's Seal
	[19864]="0:77063:2:4:1:OneHandSword::1:0:", -- Bloodcaller
	[19865]="0:77328:2:4:1:OneHandSword::1:0:", -- Warblade of the Hakkari
	[19866]="0:70360:2:4:1:OneHandSword::1:0:", -- Warblade of the Hakkari
	[19867]="0:70626:2:4:1:OneHandSword::1:0:", -- Bloodlord's Defender
	[19869]="0:14200:4:3:1:Leather::1:0:", -- Blooddrenched Grips
	[19870]="0:17104:4:3:1:Cloak::1:0:", -- Hakkari Loa Cloak
	[19871]="0:50287:4:3:1:Amulet::1:0:", -- Talisman of Protection
	[19872]="0:0:15:4:1:Mount::1:0:", -- Swift Razzashi Raptor
	[19873]="0:48660:4:3:1:Ring::1:0:", -- Overlord's Crimson Band
	[19874]="0:90591:2:4:1:Polearm::1:0:", -- Halberd of Smiting
	[19875]="0:26132:4:3:1:Mail::1:0:", -- Bloodstained Coif
	[19876]="0:85311:4:4:1:Amulet::1:0:", -- Soul Corrupter's Necklace
	[19877]="0:29245:4:3:1:Leather::1:0:", -- Animist's Leggings
	[19878]="0:30760:4:3:1:Plate::1:0:", -- Bloodsoaked Pauldrons
	[19880]="0:0:12:1:1:::1:0:", -- Gurubashi Head Collection
	[19881]="0:0:12:1:20:::1:0:", -- Channeler's Head
	[19882]="0:0:12:1:20:::1:0:", -- The Hexxer's Head
	[19883]="0:0:12:1:1:::1:0:", -- Sacred Cord
	[19884]="0:87276:2:4:1:Stave::1:0:", -- Jin'do's Judgement
	[19885]="0:44203:4:4:1:Amulet::1:0:", -- Jin'do's Evil Eye
	[19886]="0:16849:4:3:1:Cloth::1:0:", -- The Hexxer's Cover
	[19887]="0:33827:4:3:1:Mail::1:0:", -- Bloodstained Legplates
	[19888]="0:16975:4:3:1:Cloak::1:0:", -- Overlord's Embrace
	[19889]="0:28398:4:3:1:Leather::1:0:", -- Blooddrenched Leggings
	[19890]="0:71409:2:4:1:OneHandMace::1:0:", -- Jin'do's Hexxer
	[19891]="0:63628:4:4:1:OffHandFrill::1:0:", -- Jin'do's Bag of Whammies
	[19892]="0:21535:4:3:1:Leather::1:0:", -- Animist's Boots
	[19893]="0:55355:4:3:1:Ring::1:0:", -- Zanzil's Seal
	[19894]="0:20364:4:3:1:Plate::1:0:", -- Bloodsoaked Gauntlets
	[19895]="0:23224:4:3:1:Cloth::1:0:", -- Bloodtinged Kilt
	[19896]="0:72049:2:4:1:FistWeapon::1:0:", -- Thekal's Grasp
	[19897]="0:21693:4:4:1:Cloth::1:0:", -- Betrayer's Boots
	[19898]="0:55035:4:3:1:Ring::1:0:", -- Seal of Jin
	[19899]="0:21077:4:3:1:Cloth::1:0:", -- Ritualistic Legguards
	[19900]="0:66122:2:3:1:TwoHandAxe::1:0:", -- Zulian Stone Axe
	[19901]="0:53102:2:3:1:OneHandSword::1:0:", -- Zulian Slicer
	[19902]="0:0:15:4:1:Mount::1:0:", -- Swift Zulian Tiger
	[19903]="0:68651:2:4:1:Dagger::1:0:", -- Fang of Venoxis
	[19904]="0:41348:4:4:1:Mail::1:0:", -- Runed Bloodstained Hauberk
	[19905]="0:45253:4:3:1:Ring::1:0:", -- Zanzil's Band
	[19906]="0:20294:4:3:1:Leather::1:0:", -- Blooddrenched Footpads
	[19907]="0:16295:4:3:1:Cloak::1:0:", -- Zulian Tigerhide Cloak
	[19908]="0:52467:2:3:1:OneHandMace::1:0:", -- Sceptre of Smiting
	[19909]="0:87773:2:4:1:Stave::1:0:", -- Will of Arlokk
	[19910]="0:70474:2:4:1:FistWeapon::1:0:", -- Arlokk's Grasp
	[19911]="0:0:15:1:5:Junk::1:0:", -- Whipweed Heart
	[19912]="0:43548:4:3:1:Ring::1:0:", -- Overlord's Onyx Band
	[19913]="0:29103:4:3:1:Plate::1:0:", -- Bloodsoaked Greaves
	[19914]="0:8750:1:3:1:Bag::1:0:", -- Panther Hide Sack
	[19915]="0:36742:4:3:1:Shield::1:0:", -- Zulian Defender
	[19918]="0:93051:2:4:1:TwoHandMace::1:0:", -- Jeklik's Crusher
	[19919]="0:23814:4:3:1:Mail::1:0:", -- Bloodstained Greaves
	[19920]="0:56037:4:3:1:Ring::1:0:", -- Primalist's Band
	[19921]="0:51094:2:3:1:OneHandAxe::1:0:", -- Zulian Hacker
	[19922]="0:63655:4:3:1:OffHandFrill::1:0:", -- Arlokk's Hoodoo Stick
	[19923]="0:44030:4:3:1:Amulet::1:0:", -- Jeklik's Opaline Talisman
	[19925]="0:43635:4:3:1:Ring::1:0:", -- Band of Jin
	[19927]="0:52265:2:4:1:Wand::1:0:", -- Mar'li's Touch
	[19928]="0:20444:4:3:1:Leather::1:0:", -- Animist's Spaulders
	[19929]="0:11356:4:3:1:Cloth::1:0:", -- Bloodtinged Gloves
	[19930]="0:73852:4:3:1:Trinket::1:0:", -- Mar'li's Eye
	[19931]="0:0:12:3:20:::1:0:", -- Gurubashi Mojo Madness
	[19933]="0:2080:15:1:10:Junk::1:0:", -- Glowing Scorpid Blood
	[19934]="0:1400:15:0:10:Junk::1:0:", -- Large Scorpid Claw
	[19935]="0:830:15:0:10:Junk::1:0:", -- Empty Venom Sac
	[19936]="0:830:15:0:10:Junk::1:0:", -- Dried Scorpid Carapace
	[19937]="0:780:15:0:10:Junk::1:0:", -- Small Scorpid Claw
	[19938]="0:580:15:0:10:Junk::1:0:", -- Heavy Scorpid Leg
	[19939]="0:0:12:2:1:::1:0:", -- Gri'lek's Blood
	[19940]="0:0:12:2:1:::1:0:", -- Renataki's Tooth
	[19941]="0:0:12:2:1:::1:0:", -- Wushoolay's Mane
	[19942]="0:0:12:2:1:::1:0:", -- Hazza'rah's Dream Thread
	[19943]="0:2000:7:1:20:Other:171:1:0:", -- Massive Mojo
	[19944]="0:86115:2:4:1:Stave::1:0:", -- Nat Pagle's Fish Terminator
	[19945]="0:25933:4:4:1:Leather::1:0:", -- Foror's Eyepatch
	[19946]="0:67629:2:3:1:Polearm::1:0:", -- Tigule's Harpoon
	[19947]="0:86528:4:3:1:Trinket::1:0:", -- Nat Pagle's Broken Reel
	[19948]="0:111303:4:4:1:Trinket::1:0:", -- Zandalarian Hero Badge
	[19949]="0:111303:4:4:1:Trinket::1:0:", -- Zandalarian Hero Medallion
	[19950]="0:111303:4:4:1:Trinket::1:0:", -- Zandalarian Hero Charm
	[19951]="0:0:4:4:1:Trinket::1:0:", -- Gri'lek's Charm of Might
	[19952]="0:0:4:4:1:Trinket::1:0:", -- Gri'lek's Charm of Valor
	[19953]="0:0:4:4:1:Trinket::1:0:", -- Renataki's Charm of Beasts
	[19954]="0:0:4:4:1:Trinket::1:0:", -- Renataki's Charm of Trickery
	[19955]="0:0:4:4:1:Trinket::1:0:", -- Wushoolay's Charm of Nature
	[19956]="0:0:4:4:1:Trinket::1:0:", -- Wushoolay's Charm of Spirits
	[19957]="0:0:4:4:1:Trinket::1:0:", -- Hazza'rah's Charm of Destruction
	[19958]="0:0:4:4:1:Trinket::1:0:", -- Hazza'rah's Charm of Healing
	[19959]="0:0:4:4:1:Trinket::1:0:", -- Hazza'rah's Charm of Magic
	[19960]="0:0:12:1:1:::1:0:", -- Crystalized Honey
	[19961]="0:53080:2:3:1:OneHandMace::1:0:", -- Gri'lek's Grinder
	[19962]="0:66605:2:3:1:TwoHandAxe::1:0:", -- Gri'lek's Carver
	[19963]="0:68686:2:3:1:Polearm::1:0:", -- Pitchfork of Madness
	[19964]="0:55154:2:3:1:OneHandSword::1:0:", -- Renataki's Soul Conduit
	[19965]="0:55358:2:3:1:Dagger::1:0:", -- Wushoolay's Poker
	[19967]="0:41821:2:3:1:Wand::1:0:", -- Thoughtblighter
	[19968]="0:55966:2:3:1:OneHandSword::1:0:", -- Fiery Retributer
	[19969]="0:3360:4:2:1:Cloth::1:0:", -- Nat Pagle's Extreme Anglin' Boots
	[19970]="0:9:2:3:1:FishingPole::1:0:", -- Arcanite Fishing Pole
	[19971]="0:2000:0:2:5:EnhPerm::1:0:", -- High Test Eternium Fishing Line
	[19972]="0:3396:4:2:1:Cloth::1:0:", -- Lucky Fishing Hat
	[19973]="0:0:12:1:1:::1:0:", -- Nat's Measuring Tape
	[19974]="10000:2500:12:1:20:::1:0:12919", -- Mudskunk Lure
	[19975]="0:0:12:1:20:::1:0:", -- Zulian Mudskunk
	[19978]="0:0:15:1:1:Junk::1:0:", -- Fishing Tournament!
	[19979]="0:25000:4:3:1:Trinket::1:0:", -- Hook of the Master Angler
	[19982]="0:9444:4:3:1:Cloak::1:0:", -- Duskbat Drape
	[19984]="0:11893:4:3:1:Leather::1:0:", -- Ebon Mask
	[19990]="0:25000:4:3:1:Trinket::1:0:", -- Blessed Prayer Beads
	[19991]="0:10000:4:3:1:Trinket::1:0:", -- Devilsaur Eye
	[19992]="0:10000:4:3:1:Trinket::1:0:", -- Devilsaur Tooth
	[19993]="0:42730:2:3:1:Bow::1:0:", -- Hoodoo Hunting Bow
	[19994]="0:0:0:1:20:FoodDrink::1:0:", -- Harvest Fruit
	[19995]="0:0:0:1:20:FoodDrink::1:0:", -- Harvest Boar
	[19996]="0:0:0:1:20:FoodDrink::1:0:", -- Harvest Fish
	[19997]="0:0:0:1:20:Consumable::1:0:", -- Harvest Nectar
	[19998]="0:19457:4:3:1:Leather::1:0:", -- Bloodvine Lens
	[19999]="0:15625:4:3:1:Cloth::1:0:", -- Bloodvine Goggles
	[20000]="120000:30000:9:1:1:Engineering::1:0:14921", -- Schematic: Bloodvine Goggles
	[20001]="50000:12500:9:1:1:Engineering::1:0:14921", -- Schematic: Bloodvine Lens
	[20002]="0:1000:0:1:5:Potion::1:0:", -- Greater Dreamless Sleep Potion
	[20004]="0:1000:0:1:20:Elixir::1:0:", -- Major Troll's Blood Elixir
	[20006]="0:8375:4:3:1:Ring::1:0:", -- Circle of Hope
	[20007]="0:1000:0:1:20:Elixir::1:0:", -- Mageblood Elixir
	[20008]="0:600:0:1:5:Potion::1:0:", -- Living Action Potion
	[20009]="0:0:12:1:1:::1:0:", -- For the Light!
	[20010]="0:0:12:1:1:::1:0:", -- The Horde's Hellscream
	[20011]="50000:12500:9:1:1:Alchemy::1:0:14921", -- Recipe: Mageblood Elixir
	[20012]="50000:12500:9:1:1:Alchemy::1:0:14921", -- Recipe: Greater Dreamless Sleep Potion
	[20013]="50000:12500:9:1:1:Alchemy::1:0:14921", -- Recipe: Living Action Potion
	[20014]="50000:12500:9:1:1:Alchemy::1:0:14921", -- Recipe: Major Troll's Blood Elixir
	[20015]="0:1658:15:0:10:Junk::1:0:", -- Elder Raptor Feathers
	[20016]="0:3635:15:0:1:Junk::1:0:", -- Trophy Raptor Skull
	[20017]="0:0:15:1:5:Junk::1:0:", -- Perfect Courser Antler
	[20018]="0:0:12:1:20:::1:0:", -- Angerclaw Grizzly Hide
	[20019]="0:0:15:1:1:Junk::1:0:", -- Tooth of Morphaz
	[20021]="0:0:12:1:40:::1:0:", -- Gold Pirate Earring
	[20022]="0:0:13:1:1:::1:0:", -- Azure Key
	[20023]="0:0:12:1:20:::1:0:", -- Encoded Fragment
	[20025]="0:0:12:1:1:::1:0:", -- Blood of Morphaz
	[20027]="0:0:12:1:10:::1:0:", -- Healthy Courser Gland
	[20028]="0:0:12:1:20:::1:0:", -- Glittering Dust
	[20029]="0:0:12:1:20:::1:0:", -- Enchanted Coral
	[20030]="0:1580:15:0:1:Junk::1:0:", -- Pet Rock
	[20031]="0:0:0:1:20:FoodDrink::1:0:", -- Essence Mango
	[20032]="0:27040:4:4:1:Cloth::1:0:", -- Flowing Ritual Robes
	[20033]="0:0:4:4:1:Cloth::1:0:", -- Zandalar Demoniac's Robe
	[20034]="0:0:4:4:1:Cloth::1:0:", -- Zandalar Illusionist's Robe
	[20035]="0:30651:2:3:1:Dagger::1:0:", -- Glacial Spike
	[20036]="0:2750:4:3:1:Trinket::1:0:", -- Fire Ruby
	[20037]="0:15003:4:3:1:Amulet::1:0:", -- Arcane Crystal Pendant
	[20038]="0:52549:2:4:1:Bow::1:0:", -- Mandokir's Sting
	[20039]="0:38754:4:4:1:Plate::1:0:", -- Dark Iron Boots
	[20040]="0:20000:9:1:1:Blacksmithing::1:0:", -- Plans: Dark Iron Boots
	[20041]="0:0:4:3:1:Plate::1:0:15127", -- Highlander's Plate Girdle
	[20042]="0:0:4:3:1:Plate::1:0:15127", -- Highlander's Lamellar Girdle
	[20043]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Chain Girdle
	[20044]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Mail Girdle
	[20045]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Leather Girdle
	[20046]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Lizardhide Girdle
	[20047]="0:0:4:3:1:Cloth::1:0:", -- Highlander's Cloth Girdle
	[20048]="0:0:4:3:1:Plate::1:0:15127", -- Highlander's Plate Greaves
	[20049]="0:0:4:3:1:Plate::1:0:15127", -- Highlander's Lamellar Greaves
	[20050]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Chain Greaves
	[20051]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Mail Greaves
	[20052]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Leather Boots
	[20053]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Lizardhide Boots
	[20054]="0:0:4:3:1:Cloth::1:0:", -- Highlander's Cloth Boots
	[20055]="0:0:4:4:1:Mail::1:0:15127", -- Highlander's Chain Pauldrons
	[20056]="0:0:4:4:1:Mail::1:0:15127", -- Highlander's Mail Pauldrons
	[20057]="0:0:4:4:1:Plate::1:0:15127", -- Highlander's Plate Spaulders
	[20058]="0:0:4:4:1:Plate::1:0:15127", -- Highlander's Lamellar Spaulders
	[20059]="0:0:4:4:1:Leather::1:0:15127", -- Highlander's Leather Shoulders
	[20060]="0:0:4:4:1:Leather::1:0:15127", -- Highlander's Lizardhide Shoulders
	[20061]="0:0:4:4:1:Cloth::1:0:", -- Highlander's Epaulets
	[20062]="0:100:0:1:20:Consumable::1:0:", -- Arathi Basin Enriched Ration
	[20063]="0:50:0:1:20:Consumable::1:0:", -- Arathi Basin Field Ration
	[20064]="0:75:0:1:20:Consumable::1:0:", -- Arathi Basin Iron Ration
	[20065]="0:75:0:1:20:Bandage::1:0:", -- Arathi Basin Mageweave Bandage
	[20066]="0:100:0:1:20:Bandage::1:0:", -- Arathi Basin Runecloth Bandage
	[20067]="0:50:0:1:20:Bandage::1:0:", -- Arathi Basin Silk Bandage
	[20068]="0:0:4:4:1:Cloak::1:0:15126", -- Deathguard's Cloak
	[20069]="0:0:2:4:1:Stave::1:0:15127", -- Ironbark Staff
	[20070]="0:0:2:4:1:Dagger::1:0:15127", -- Sageclaw
	[20071]="0:0:4:3:1:Trinket::1:0:15127", -- Talisman of Arathor
	[20072]="0:0:4:3:1:Trinket::1:0:15126", -- Defiler's Talisman
	[20073]="0:0:4:4:1:Cloak::1:0:15127", -- Cloak of the Honor Guard
	[20074]="0:300:0:1:20:FoodDrink::1:0:", -- Heavy Crocolisk Stew
	[20075]="2000:500:9:1:1:Cooking::1:0:4879", -- Recipe: Heavy Crocolisk Stew
	[20076]="0:0:0:3:1:EnhPerm::1:0:", -- Zandalar Signet of Mojo
	[20077]="0:0:0:3:1:EnhPerm::1:0:", -- Zandalar Signet of Might
	[20078]="0:0:0:3:1:EnhPerm::1:0:", -- Zandalar Signet of Serenity
	[20079]="0:0:0:2:1:Elixir::1:0:", -- Spirit of Zanza
	[20080]="0:0:0:2:1:Elixir::1:0:", -- Sheen of Zanza
	[20081]="0:0:0:2:1:Elixir::1:0:", -- Swiftness of Zanza
	[20082]="0:24229:2:3:1:Wand::1:0:", -- Woestave
	[20083]="0:40524:2:3:1:Polearm::1:0:", -- Hunting Spear
	[20085]="0:0:15:1:1:Junk::1:0:", -- Arcane Shard
	[20086]="0:1:15:2:200:Junk::1:0:", -- Broken Dusksteel Throwing Knife
	[20087]="0:0:15:1:20:Junk::1:0:", -- Wavethrasher Scales
	[20088]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Chain Girdle
	[20089]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Chain Girdle
	[20090]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Padded Girdle
	[20091]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Chain Greaves
	[20092]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Chain Greaves
	[20093]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Padded Greaves
	[20094]="0:0:4:3:1:Cloth::1:0:", -- Highlander's Cloth Boots
	[20095]="0:0:4:3:1:Cloth::1:0:", -- Highlander's Cloth Boots
	[20096]="0:0:4:3:1:Cloth::1:0:", -- Highlander's Cloth Boots
	[20097]="0:0:4:3:1:Cloth::1:0:", -- Highlander's Cloth Girdle
	[20098]="0:0:4:3:1:Cloth::1:0:", -- Highlander's Cloth Girdle
	[20099]="0:0:4:3:1:Cloth::1:0:", -- Highlander's Cloth Girdle
	[20100]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Lizardhide Boots
	[20101]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Lizardhide Boots
	[20102]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Lizardhide Boots
	[20103]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Lizardhide Girdle
	[20104]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Lizardhide Girdle
	[20105]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Lizardhide Girdle
	[20106]="0:0:4:3:1:Plate::1:0:15127", -- Highlander's Lamellar Girdle
	[20107]="0:0:4:3:1:Plate::1:0:15127", -- Highlander's Lamellar Girdle
	[20108]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Lamellar Girdle
	[20109]="0:0:4:3:1:Plate::1:0:15127", -- Highlander's Lamellar Greaves
	[20110]="0:0:4:3:1:Plate::1:0:15127", -- Highlander's Lamellar Greaves
	[20111]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Lamellar Greaves
	[20112]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Leather Boots
	[20113]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Leather Boots
	[20114]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Leather Boots
	[20115]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Leather Girdle
	[20116]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Leather Girdle
	[20117]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Leather Girdle
	[20118]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Mail Girdle
	[20119]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Mail Girdle
	[20120]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Mail Girdle
	[20121]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Mail Greaves
	[20122]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Mail Greaves
	[20123]="0:0:4:3:1:Leather::1:0:15127", -- Highlander's Mail Greaves
	[20124]="0:0:4:3:1:Plate::1:0:15127", -- Highlander's Plate Girdle
	[20125]="0:0:4:3:1:Plate::1:0:15127", -- Highlander's Plate Girdle
	[20126]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Mail Girdle
	[20127]="0:0:4:3:1:Plate::1:0:15127", -- Highlander's Plate Greaves
	[20128]="0:0:4:3:1:Plate::1:0:15127", -- Highlander's Plate Greaves
	[20129]="0:0:4:3:1:Mail::1:0:15127", -- Highlander's Mail Greaves
	[20130]="0:10000:4:3:1:Trinket::1:0:", -- Diamond Flask
	[20131]="0:0:4:1:1:Tabard::1:0:", -- Battle Tabard of the Defilers
	[20132]="0:0:4:1:1:Tabard::1:0:", -- Arathor Battle Tabard
	[20134]="0:30246:4:4:1:Mail::1:0:", -- Skyfury Helm
	[20150]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Chain Girdle
	[20151]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Chain Girdle
	[20152]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Chain Girdle
	[20153]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Chain Girdle
	[20154]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Chain Greaves
	[20155]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Chain Greaves
	[20156]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Chain Greaves
	[20157]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Chain Greaves
	[20158]="0:0:4:4:1:Mail::1:0:15126", -- Defiler's Chain Pauldrons
	[20159]="0:0:4:3:1:Cloth::1:0:15126", -- Defiler's Cloth Boots
	[20160]="0:0:4:3:1:Cloth::1:0:15126", -- Defiler's Cloth Boots
	[20161]="0:0:4:3:1:Cloth::1:0:15126", -- Defiler's Cloth Boots
	[20162]="0:0:4:3:1:Cloth::1:0:15126", -- Defiler's Cloth Boots
	[20163]="0:0:4:3:1:Cloth::1:0:15126", -- Defiler's Cloth Girdle
	[20164]="0:0:4:3:1:Cloth::1:0:15126", -- Defiler's Cloth Girdle
	[20165]="0:0:4:3:1:Cloth::1:0:15126", -- Defiler's Cloth Girdle
	[20166]="0:0:4:3:1:Cloth::1:0:15126", -- Defiler's Cloth Girdle
	[20167]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Lizardhide Boots
	[20168]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Lizardhide Boots
	[20169]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Lizardhide Boots
	[20170]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Lizardhide Boots
	[20171]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Lizardhide Girdle
	[20172]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Lizardhide Girdle
	[20173]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Lizardhide Girdle
	[20174]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Lizardhide Girdle
	[20175]="0:0:4:4:1:Leather::1:0:15126", -- Defiler's Lizardhide Shoulders
	[20176]="0:0:4:4:1:Cloth::1:0:15126", -- Defiler's Epaulets
	[20177]="0:0:4:3:1:Plate::1:0:15126", -- Defiler's Lamellar Girdle
	[20178]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Lamellar Girdle
	[20179]="0:0:4:3:1:Plate::1:0:15126", -- Defiler's Lamellar Girdle
	[20180]="0:0:4:3:1:Plate::1:0:15126", -- Defiler's Lamellar Girdle
	[20181]="0:0:4:3:1:Plate::1:0:15126", -- Defiler's Lamellar Greaves
	[20182]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Lamellar Greaves
	[20183]="0:0:4:3:1:Plate::1:0:15126", -- Defiler's Lamellar Greaves
	[20184]="0:0:4:4:1:Plate::1:0:15126", -- Defiler's Lamellar Spaulders
	[20185]="0:0:4:3:1:Plate::1:0:15126", -- Defiler's Lamellar Greaves
	[20186]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Leather Boots
	[20187]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Leather Boots
	[20188]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Leather Boots
	[20189]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Leather Boots
	[20190]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Leather Girdle
	[20191]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Leather Girdle
	[20192]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Leather Girdle
	[20193]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Leather Girdle
	[20194]="0:0:4:4:1:Leather::1:0:15126", -- Defiler's Leather Shoulders
	[20195]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Mail Girdle
	[20196]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Mail Girdle
	[20197]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Padded Girdle
	[20198]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Mail Girdle
	[20199]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Mail Greaves
	[20200]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Mail Greaves
	[20201]="0:0:4:3:1:Leather::1:0:15126", -- Defiler's Mail Greaves
	[20202]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Mail Greaves
	[20203]="0:0:4:4:1:Mail::1:0:15126", -- Defiler's Mail Pauldrons
	[20204]="0:0:4:3:1:Plate::1:0:15126", -- Defiler's Plate Girdle
	[20205]="0:0:4:3:1:Plate::1:0:15126", -- Defiler's Plate Girdle
	[20206]="0:0:4:3:1:Plate::1:0:15126", -- Defiler's Plate Girdle
	[20207]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Mail Girdle
	[20208]="0:0:4:3:1:Plate::1:0:15126", -- Defiler's Plate Greaves
	[20209]="0:0:4:3:1:Plate::1:0:15126", -- Defiler's Plate Greaves
	[20210]="0:0:4:3:1:Mail::1:0:15126", -- Defiler's Mail Greaves
	[20211]="0:0:4:3:1:Plate::1:0:15126", -- Defiler's Plate Greaves
	[20212]="0:0:4:4:1:Plate::1:0:15126", -- Defiler's Plate Spaulders
	[20213]="0:20119:4:3:1:Plate::1:0:", -- Belt of Shrunken Heads
	[20214]="0:0:2:4:1:Dagger::1:0:15126", -- Mindfang
	[20215]="0:17271:4:3:1:Mail::1:0:", -- Belt of Shriveled Heads
	[20216]="0:14445:4:3:1:Leather::1:0:", -- Belt of Preserved Heads
	[20217]="0:11598:4:3:1:Cloth::1:0:", -- Belt of Tiny Heads
	[20218]="0:14590:4:3:1:Cloak::1:0:", -- Faded Hakkari Cloak
	[20219]="0:14641:4:3:1:Cloak::1:0:", -- Tattered Hakkari Cape
	[20220]="0:0:2:4:1:Stave::1:0:15126", -- Ironbark Staff
	[20222]="2000:100:0:1:20:Consumable::5:0:15126", -- Defiler's Enriched Ration
	[20223]="1000:50:0:1:20:Consumable::5:0:15126", -- Defiler's Field Ration
	[20224]="1500:75:0:1:20:Consumable::5:0:15126", -- Defiler's Iron Ration
	[20225]="2000:100:0:1:20:Consumable::5:0:15127", -- Highlander's Enriched Ration
	[20226]="1000:50:0:1:20:Consumable::5:0:15127", -- Highlander's Field Ration
	[20227]="1500:75:0:1:20:Consumable::5:0:15127", -- Highlander's Iron Ration
	[20228]="0:0:15:1:1:Junk::1:0:", -- Defiler's Advanced Care Package
	[20229]="0:0:15:1:1:Junk::1:0:", -- Defiler's Basic Care Package
	[20230]="0:0:15:1:1:Junk::1:0:", -- Defiler's Standard Care Package
	[20231]="0:0:15:1:1:Junk::1:0:", -- Arathor Advanced Care Package
	[20232]="1500:75:0:1:20:Bandage::5:0:15126", -- Defiler's Mageweave Bandage
	[20233]="0:0:15:1:1:Junk::1:0:", -- Arathor Basic Care Package
	[20234]="2000:100:0:1:20:Bandage::5:0:15126", -- Defiler's Runecloth Bandage
	[20235]="1000:50:0:1:20:Bandage::5:0:15126", -- Defiler's Silk Bandage
	[20236]="0:0:15:1:1:Junk::1:0:", -- Arathor Standard Care Package
	[20237]="1500:75:0:1:20:Bandage::5:0:15127", -- Highlander's Mageweave Bandage
	[20243]="2000:100:0:1:20:Bandage::5:0:15127", -- Highlander's Runecloth Bandage
	[20244]="1000:50:0:1:20:Bandage::5:0:15127", -- Highlander's Silk Bandage
	[20253]="16000:4000:9:1:1:Leatherworking::1:0:11557", -- Pattern: Warbear Harness
	[20254]="20000:5000:9:1:1:Leatherworking::1:0:11557", -- Pattern: Warbear Woolies
	[20255]="0:12425:4:3:1:Leather::1:0:", -- Whisperwalk Boots
	[20256]="0:0:12:2:250:::1:0:", -- Warsong Gulch Ribbon of Sacrifice
	[20257]="0:23207:4:4:1:Mail::1:0:", -- Seafury Gauntlets
	[20258]="0:63375:2:3:1:Stave::1:0:", -- Zulian Ceremonial Staff
	[20259]="0:12724:4:3:1:Leather::1:0:", -- Shadow Panther Hide Gloves
	[20260]="0:31854:4:3:1:Mail::1:0:", -- Seafury Leggings
	[20261]="0:12821:4:3:1:Leather::1:0:", -- Shadow Panther Hide Belt
	[20262]="0:24182:4:3:1:Mail::1:0:", -- Seafury Boots
	[20263]="0:27080:4:3:1:Plate::1:0:", -- Gurubashi Helm
	[20264]="0:25299:4:4:1:Plate::1:0:", -- Peacekeeper Gauntlets
	[20265]="0:28353:4:3:1:Plate::1:0:", -- Peacekeeper Boots
	[20266]="0:38019:4:3:1:Plate::1:0:", -- Peacekeeper Leggings
	[20295]="0:31083:4:3:1:Mail::1:0:", -- Blue Dragonscale Leggings
	[20296]="0:11205:4:3:1:Mail::1:0:", -- Green Dragonscale Gauntlets
	[20310]="0:0:12:1:1:::1:0:", -- Flayed Demon Skin
	[20369]="0:9975:4:3:1:Mail::1:0:", -- Azurite Fists
	[20371]="0:0:15:3:1:Companion::1:0:", -- Blue Murloc Egg
	[20373]="0:0:12:1:20:::1:0:", -- Stonelash Scorpid Stinger
	[20374]="0:0:12:1:20:::1:0:", -- Stonelash Pincer Stinger
	[20375]="0:0:12:1:20:::1:0:", -- Stonelash Flayer Stinger
	[20376]="0:0:12:1:20:::1:0:", -- Sand Skitterer Fang
	[20377]="0:0:12:1:20:::1:0:", -- Rock Stalker Fang
	[20378]="0:0:12:1:20:::1:0:", -- Twilight Tablet Fragment
	[20379]="0:0:12:1:1:::1:0:", -- Noggle's Satchel
	[20380]="0:43614:4:4:1:Mail::1:0:", -- Dreamscale Breastplate
	[20381]="0:5000:7:2:20:Leather:165:1:0:", -- Dreamscale
	[20382]="60000:15000:9:1:1:Leatherworking::1:0:15293", -- Pattern: Dreamscale Breastplate
	[20383]="0:0:12:1:1:::1:0:", -- Head of the Broodlord Lashlayer
	[20384]="0:0:12:1:200:::1:0:", -- Silithid Carapace Fragment
	[20385]="0:0:12:1:1:::1:0:", -- Deathclasp's Pincer
	[20387]="1000:0:12:1:1:::1:0:15197", -- Forsaken Stink Bomb Cluster
	[20388]="0:0:0:1:20:Consumable::1:0:", -- Lollipop
	[20389]="0:0:0:1:20:Consumable::1:0:", -- Candy Corn
	[20390]="0:0:0:1:20:Consumable::1:0:", -- Candy Bar
	[20391]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Male Gnome Mask
	[20392]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Female Gnome Mask
	[20393]="0:0:15:1:1:Junk::1:0:", -- Treat Bag
	[20394]="0:0:12:1:1:::1:0:", -- Twilight Lexicon - Chapter 1
	[20395]="0:0:12:1:1:::1:0:", -- Twilight Lexicon - Chapter 2
	[20396]="0:0:12:1:1:::1:0:", -- Twilight Lexicon - Chapter 3
	[20397]="0:0:0:1:1:Consumable::1:0:", -- Hallowed Wand - Pirate
	[20398]="0:0:0:1:1:Consumable::1:0:", -- Hallowed Wand - Ninja
	[20399]="0:0:0:1:1:Consumable::1:0:", -- Hallowed Wand - Leper Gnome
	[20400]="0:20000:1:2:1:Bag::1:0:", -- Pumpkin Bag
	[20401]="0:0:12:1:1:::1:0:", -- Restored Twilight Tablet
	[20402]="0:0:15:2:1:Junk::1:0:", -- Agent of Nozdormu
	[20403]="0:0:15:2:1:Junk::1:0:", -- Proxy of Nozdormu
	[20404]="0:0:12:1:250:::1:0:", -- Encrypted Twilight Text
	[20405]="0:0:12:1:1:::1:0:", -- Decoded Tablet Transcription
	[20406]="0:1929:4:2:1:Cloth::1:0:", -- Twilight Cultist Mantle
	[20407]="0:2581:4:2:1:Cloth::1:0:", -- Twilight Cultist Robe
	[20408]="0:1942:4:2:1:Cloth::1:0:", -- Twilight Cultist Cowl
	[20409]="0:0:0:1:1:Consumable::1:0:", -- Hallowed Wand - Ghost
	[20410]="0:0:0:1:1:Consumable::1:0:", -- Hallowed Wand - Bat
	[20411]="0:0:0:1:1:Consumable::1:0:", -- Hallowed Wand - Skeleton
	[20413]="0:0:0:1:1:Consumable::1:0:", -- Hallowed Wand - Random
	[20414]="0:0:0:1:1:Consumable::1:0:", -- Hallowed Wand - Wisp
	[20415]="0:0:15:1:1:Junk::1:0:", -- The War of the Shifting Sands
	[20416]="0:0:12:1:20:::1:0:", -- Crest of Beckoning: Fire
	[20418]="0:0:12:1:20:::1:0:", -- Crest of Beckoning: Thunder
	[20419]="0:0:12:1:20:::1:0:", -- Crest of Beckoning: Earth
	[20420]="0:0:12:1:20:::1:0:", -- Crest of Beckoning: Water
	[20422]="0:0:4:1:1:Amulet::1:0:", -- Twilight Cultist Medallion of Station
	[20424]="0:175:7:1:20:Meat:185:1:0:", -- Sandworm Meat
	[20425]="0:0:2:3:1:Stave::1:0:14754", -- Advisor's Gnarled Staff
	[20426]="0:0:4:3:1:Ring::1:0:14754", -- Advisor's Ring
	[20427]="0:0:4:3:1:Cloak::1:0:14754", -- Battle Healer's Cloak
	[20428]="0:0:4:3:1:Cloak::1:0:14753", -- Caretaker's Cape
	[20429]="0:0:4:3:1:Ring::1:0:14754", -- Legionnaire's Band
	[20430]="0:0:2:3:1:OneHandSword::1:0:14754", -- Legionnaire's Sword
	[20431]="0:0:4:3:1:Ring::1:0:14753", -- Lorekeeper's Ring
	[20432]="0:0:12:1:20:::1:0:", -- Signet of Beckoning: Fire
	[20433]="0:0:12:1:20:::1:0:", -- Signet of Beckoning: Thunder
	[20434]="0:0:2:3:1:Stave::1:0:14753", -- Lorekeeper's Staff
	[20435]="0:0:12:1:20:::1:0:", -- Signet of Beckoning: Stone
	[20436]="0:0:12:1:20:::1:0:", -- Signet of Beckoning: Water
	[20437]="0:0:2:3:1:Bow::1:0:14754", -- Outrider's Bow
	[20438]="0:0:2:3:1:Bow::1:0:14753", -- Outrunner's Bow
	[20439]="0:0:4:3:1:Ring::1:0:14753", -- Protector's Band
	[20440]="0:0:2:3:1:OneHandSword::1:0:14753", -- Protector's Sword
	[20441]="0:0:2:3:1:Dagger::1:0:14754", -- Scout's Blade
	[20442]="0:0:4:3:1:Amulet::1:0:14754", -- Scout's Medallion
	[20443]="0:0:2:3:1:Dagger::1:0:14753", -- Sentinel's Blade
	[20444]="0:0:4:3:1:Amulet::1:0:14753", -- Sentinel's Medallion
	[20447]="0:0:12:1:20:::1:0:", -- Scepter of Beckoning: Fire
	[20448]="0:0:12:1:20:::1:0:", -- Scepter of Beckoning: Thunder
	[20449]="0:0:12:1:20:::1:0:", -- Scepter of Beckoning: Stone
	[20450]="0:0:12:1:20:::1:0:", -- Scepter of Beckoning: Water
	[20451]="0:0:4:1:1:Ring::1:0:", -- Twilight Cultist Ring of Lordship
	[20452]="0:250:0:1:20:FoodDrink::1:0:", -- Smoked Desert Dumplings
	[20453]="0:0:12:1:1:::1:0:", -- Geologist's Transcription Kit
	[20454]="0:0:12:1:1:::1:0:", -- Hive'Zora Rubbing
	[20455]="0:0:12:1:1:::1:0:", -- Hive'Ashi Rubbing
	[20456]="0:0:12:1:1:::1:0:", -- Hive'Regal Rubbing
	[20457]="0:0:12:1:1:::1:0:", -- Hive'Ashi Silithid Brain
	[20458]="0:0:12:1:1:::1:0:", -- Hive'Zora Silithid Brain
	[20459]="0:0:12:1:1:::1:0:", -- Hive'Regal Silithid Brain
	[20461]="0:0:15:1:1:Junk::1:0:", -- Brann Bronzebeard's Lost Letter
	[20463]="0:0:12:1:1:::1:0:", -- Glyphed Crystal Prism
	[20464]="0:0:15:1:1:Junk::1:0:", -- Glyphs of Calling
	[20465]="0:0:12:1:1:::1:0:", -- Crystal Unlocking Mechanism
	[20466]="0:0:12:1:1:::1:0:", -- Vyral's Signet Ring
	[20467]="0:0:12:1:1:::1:0:", -- Torn Recipe Page
	[20469]="0:12:15:1:1:Junk::1:0:", -- Decoded True Believer Clippings
	[20470]="0:0:12:1:1:::1:0:", -- Solanian's Scrying Orb
	[20471]="0:0:12:1:1:::1:0:", -- Scroll of Scourge Magic
	[20472]="0:0:12:1:1:::1:0:", -- Solanian's Journal
	[20474]="0:0:1:1:1:Bag::1:0:", -- Sunstrider Book Satchel
	[20475]="0:6250:0:1:1:Other::1:0:", -- Adamantite Arrow Maker
	[20476]="0:15292:4:3:1:Mail::1:0:", -- Sandstalker Bracers
	[20477]="0:15755:4:3:1:Mail::1:0:", -- Sandstalker Gauntlets
	[20478]="0:31624:4:3:1:Mail::1:0:", -- Sandstalker Breastplate
	[20479]="0:31734:4:3:1:Mail::1:0:", -- Spitfire Breastplate
	[20480]="0:15924:4:3:1:Mail::1:0:", -- Spitfire Gauntlets
	[20481]="0:15980:4:3:1:Mail::1:0:", -- Spitfire Bracers
	[20482]="0:0:12:1:20:::1:0:", -- Arcane Sliver
	[20483]="0:0:15:1:1:Junk::1:0:", -- Tainted Arcane Sliver
	[20490]="0:0:12:1:1:::1:0:", -- Ironforge Mint
	[20491]="0:0:12:1:1:::1:0:", -- Undercity Mint
	[20492]="0:0:12:1:1:::1:0:", -- Stormwind Nougat
	[20493]="0:0:12:1:1:::1:0:", -- Orgrimmar Nougat
	[20494]="0:0:12:1:1:::1:0:", -- Gnomeregan Gumdrop
	[20495]="0:0:12:1:1:::1:0:", -- Darkspear Gumdrop
	[20496]="0:0:12:1:1:::1:0:", -- Darnassus Marzipan
	[20497]="0:0:12:1:1:::1:0:", -- Thunder Bluff Marzipan
	[20498]="0:1000:7:1:20:Leather:165:1:0:", -- Silithid Chitin
	[20499]="0:500:15:0:20:Junk::1:0:", -- Broken Silithid Chitin
	[20500]="0:2000:7:1:20:Leather:165:1:0:", -- Light Silithid Carapace
	[20501]="0:2000:7:1:20:Leather:165:1:0:", -- Heavy Silithid Carapace
	[20503]="0:10000:4:3:1:Trinket::1:0:", -- Enamored Water Spirit
	[20504]="0:37873:2:3:1:TwoHandSword::1:0:", -- Lightforged Blade
	[20505]="0:15457:4:3:1:Ring::1:0:", -- Chivalrous Signet
	[20506]="40000:10000:9:1:1:Leatherworking::1:0:15293", -- Pattern: Spitfire Bracers
	[20507]="40000:10000:9:1:1:Leatherworking::1:0:15293", -- Pattern: Spitfire Gauntlets
	[20508]="40000:10000:9:1:1:Leatherworking::1:0:15293", -- Pattern: Spitfire Breastplate
	[20509]="40000:10000:9:1:1:Leatherworking::1:0:15293", -- Pattern: Sandstalker Bracers
	[20510]="40000:10000:9:1:1:Leatherworking::1:0:15293", -- Pattern: Sandstalker Gauntlets
	[20511]="40000:10000:9:1:1:Leatherworking::1:0:15293", -- Pattern: Sandstalker Breastplate
	[20512]="0:10000:4:3:1:Trinket::1:0:", -- Sanctified Orb
	[20513]="0:0:12:2:20:::1:0:", -- Abyssal Crest
	[20514]="0:0:12:3:20:::1:0:", -- Abyssal Signet
	[20515]="0:0:12:4:20:::1:0:", -- Abyssal Scepter
	[20516]="0:0:0:1:5:FoodDrink::1:0:", -- Bobbing Apple
	[20517]="0:17113:4:3:1:Plate::1:0:", -- Razorsteel Shoulders
	[20518]="0:500:12:1:20:::1:0:", -- Scroll: Create Crest of Beckoning
	[20519]="0:0:12:1:20:::1:0:", -- Southsea Pirate Hat
	[20520]="0:2000:7:2:20:Other:164,197:1:0:", -- Dark Rune
	[20521]="0:17358:4:3:1:Plate::1:0:", -- Fury Visor
	[20526]="0:500:12:1:20:::1:0:", -- Scroll: Create Crest of Beckoning
	[20527]="0:500:12:1:20:::1:0:", -- Scroll: Create Crest of Beckoning
	[20528]="0:500:12:1:20:::1:0:", -- Scroll: Create Crest of Beckoning
	[20530]="0:12735:4:3:1:Cloth::1:0:", -- Robes of Servitude
	[20531]="0:750:12:1:20:::1:0:", -- Scroll: Create Signet of Beckoning
	[20532]="0:750:12:1:20:::1:0:", -- Scroll: Create Signet of Beckoning
	[20533]="0:750:12:1:20:::1:0:", -- Scroll: Create Signet of Beckoning
	[20534]="0:3975:4:3:1:Trinket::1:0:", -- Abyss Shard
	[20535]="0:750:12:1:20:::1:0:", -- Scroll: Create Signet of Beckoning
	[20536]="0:40671:2:3:1:Stave::1:0:", -- Soul Harvester
	[20537]="0:15963:4:3:1:Cloth::1:0:", -- Runed Stygian Boots
	[20538]="0:21361:4:3:1:Cloth::1:0:", -- Runed Stygian Leggings
	[20539]="0:10717:4:3:1:Cloth::1:0:", -- Runed Stygian Belt
	[20540]="0:1250:12:1:20:::1:0:", -- Scroll: Create Scepter of Beckoning
	[20541]="0:500:12:1:20:::1:0:", -- Decoded Twilight Text
	[20542]="0:1250:12:1:20:::1:0:", -- Scroll: Create Scepter of Beckoning
	[20543]="0:1250:12:1:20:::1:0:", -- Scroll: Create Scepter of Beckoning
	[20544]="0:1250:12:1:20:::1:0:", -- Scroll: Create Scepter of Beckoning
	[20545]="0:500:12:1:20:::1:0:", -- Decoded Twilight Text
	[20546]="0:10000:9:3:1:Tailoring::1:0:", -- Pattern: Runed Stygian Leggings
	[20547]="0:10000:9:3:1:Tailoring::1:0:", -- Pattern: Runed Stygian Boots
	[20548]="0:10000:9:3:1:Tailoring::1:0:", -- Pattern: Runed Stygian Belt
	[20549]="0:18192:4:3:1:Plate::1:0:", -- Darkrune Gauntlets
	[20550]="0:36308:4:3:1:Plate::1:0:", -- Darkrune Breastplate
	[20551]="0:27279:4:3:1:Plate::1:0:", -- Darkrune Helm
	[20552]="0:500:12:1:20:::1:0:", -- Decoded Twilight Text
	[20553]="0:15000:9:3:1:Blacksmithing::1:0:", -- Plans: Darkrune Gauntlets
	[20554]="0:15000:9:3:1:Blacksmithing::1:0:", -- Plans: Darkrune Breastplate
	[20555]="0:15000:9:3:1:Blacksmithing::1:0:", -- Plans: Darkrune Helm
	[20556]="0:40667:2:3:1:Stave::1:0:", -- Wildstaff
	[20557]="3500:175:0:1:100:Consumable::5:0:15353,15354", -- Hallow's End Pumpkin Treat
	[20558]="0:0:10:2::Currency::1:0:", -- Warsong Gulch Mark of Honor
	[20559]="0:0:10:2::Currency::1:0:", -- Arathi Basin Mark of Honor
	[20560]="0:0:10:2::Currency::1:0:", -- Alterac Valley Mark of Honor
	[20561]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Male Dwarf Mask
	[20562]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Female Dwarf Mask
	[20563]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Female Nightelf Mask
	[20564]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Male Nightelf Mask
	[20565]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Female Human Mask
	[20566]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Male Human Mask
	[20567]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Female Troll Mask
	[20568]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Male Troll Mask
	[20569]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Female Orc Mask
	[20570]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Male Orc Mask
	[20571]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Female Tauren Mask
	[20572]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Male Tauren Mask
	[20573]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Male Undead Mask
	[20574]="0:1:4:1:1:Miscellaneous::1:0:", -- Flimsy Female Undead Mask
	[20575]="0:743:4:2:1:Leather::1:0:", -- Black Whelp Tunic
	[20576]="1400:350:9:1:1:Leatherworking::1:1:777", -- Pattern: Black Whelp Tunic
	[20577]="0:72906:2:4:1:OneHandSword::1:0:", -- Nightmare Blade
	[20578]="0:73189:2:4:1:Dagger::1:0:", -- Emerald Dragonfang
	[20579]="0:22041:4:4:1:Cloak::1:0:", -- Green Dragonskin Cloak
	[20580]="0:73748:2:4:1:OneHandMace::1:0:", -- Hammer of Bestial Fury
	[20581]="0:92539:2:4:1:Stave::1:0:", -- Staff of Rampant Growth
	[20582]="0:62802:4:4:1:OffHandFrill::1:0:", -- Trance Stone
	[20599]="0:55093:2:4:1:Crossbow::1:0:", -- Polished Ironwood Crossbow
	[20600]="0:98660:4:4:1:Ring::1:0:", -- Malfurion's Signet Ring
	[20601]="0:12:15:1:1:Junk::1:0:", -- Sack of Spoils
	[20602]="0:12:15:1:1:Junk::1:0:", -- Chest of Spoils
	[20603]="0:12:15:1:1:Junk::1:0:", -- Bag of Spoils
	[20604]="500:0:12:1:1:::1:0:15199", -- Stink Bomb Cleaner
	[20605]="0:0:12:1:1:::1:0:", -- Rotten Eggs
	[20606]="0:0:15:1:10:Junk::1:0:", -- Amber Voodoo Feather
	[20607]="0:0:15:1:10:Junk::1:0:", -- Blue Voodoo Feather
	[20608]="0:0:15:1:10:Junk::1:0:", -- Green Voodoo Feather
	[20610]="0:0:15:1:20:Junk::1:0:", -- Bloodshot Spider Eye
	[20611]="0:0:15:1:20:Junk::1:0:", -- Thick Black Claw
	[20612]="0:0:15:1:10:Junk::1:0:", -- Inert Scourgestone
	[20613]="0:0:15:1:20:Junk::1:0:", -- Rotting Wood
	[20614]="0:0:15:1:20:Junk::1:0:", -- Bloodvenom Essence
	[20615]="0:19996:4:4:1:Leather::1:0:", -- Dragonspur Wraps
	[20616]="0:28254:4:4:1:Plate::1:0:", -- Dragonbone Wristguards
	[20617]="0:44264:4:4:1:Mail::1:0:", -- Ancient Corroded Leggings
	[20618]="0:14810:4:4:1:Cloth::1:0:", -- Gloves of Delusional Power
	[20619]="0:38954:4:4:1:Plate::1:0:", -- Acid Inscribed Greaves
	[20620]="0:0:15:1:5:Junk::1:0:", -- Holy Mightstone
	[20621]="0:33455:4:4:1:Mail::1:0:", -- Boots of the Endless Moor
	[20622]="0:114103:4:4:1:Amulet::1:0:", -- Dragonheart Necklace
	[20623]="0:29073:4:4:1:Leather::1:0:", -- Circlet of Restless Dreams
	[20624]="0:143303:4:4:1:Ring::1:0:", -- Ring of the Unliving
	[20625]="0:15433:4:4:1:Cloth::1:0:", -- Belt of the Dark Bog
	[20626]="0:15488:4:4:1:Cloth::1:0:", -- Black Bark Wristbands
	[20627]="0:38863:4:4:1:Leather::1:0:", -- Dark Heart Pants
	[20628]="0:29608:4:4:1:Leather::1:0:", -- Deviate Growth Cap
	[20629]="0:35813:4:4:1:Mail::1:0:", -- Malignant Footguards
	[20630]="0:27991:4:4:1:Plate::1:0:", -- Gauntlets of the Shining Light
	[20631]="0:23655:4:4:1:Cloth::1:0:", -- Mendicant's Slippers
	[20632]="0:101281:4:4:1:Ring::1:0:", -- Mindtear Band
	[20633]="0:30139:4:4:1:Leather::1:0:", -- Unnatural Leather Spaulders
	[20634]="0:30247:4:4:1:Leather::1:0:", -- Boots of Fright
	[20635]="0:31990:4:4:1:Cloth::1:0:", -- Jade Inlaid Vestments
	[20636]="0:89103:4:4:1:Trinket::1:0:", -- Hibernation Crystal
	[20637]="0:38649:4:4:1:Plate::1:0:", -- Acid Inscribed Pauldrons
	[20638]="0:45658:4:4:1:Mail::1:0:", -- Leggings of the Demented Mind
	[20639]="0:53469:4:4:1:Plate::1:0:", -- Strangely Glyphed Legplates
	[20640]="0:8405:4:2:1:Plate::1:0:", -- Southsea Head Bucket
	[20641]="0:4829:4:2:1:Cloth::1:0:", -- Southsea Mojo Boots
	[20642]="0:7539:4:2:1:Cloth::1:0:", -- Antiquated Nobleman's Tunic
	[20643]="0:7094:4:2:1:Leather::1:0:", -- Undercity Reservist's Cap
	[20644]="0:0:12:4:1:::1:0:", -- Nightmare Engulfed Object
	[20645]="0:21785:4:2:1:Amulet::1:0:", -- Nature's Whisper
	[20646]="0:35956:2:3:1:Bow::1:0:", -- Sandstrider's Mark
	[20647]="0:48117:2:3:1:Dagger::1:0:", -- Black Crystal Dagger
	[20648]="0:52827:2:3:1:OneHandMace::1:0:", -- Cold Forged Hammer
	[20649]="0:22425:4:2:1:Amulet::1:0:", -- Sunprism Pendant
	[20650]="0:14980:4:2:1:Plate::1:0:", -- Desert Wind Gauntlets
	[20652]="0:12858:4:2:1:Cloth::1:0:", -- Abyssal Cloth Slippers
	[20653]="0:15141:4:2:1:Plate::1:0:", -- Abyssal Plate Gauntlets
	[20654]="0:60175:2:3:1:Stave::1:0:", -- Amethyst War Staff
	[20655]="0:8054:4:2:1:Cloth::1:0:", -- Abyssal Cloth Handwraps
	[20656]="0:18269:4:2:1:Mail::1:0:", -- Abyssal Mail Sabatons
	[20657]="0:48687:2:3:1:Dagger::1:0:", -- Crystal Tipped Stiletto
	[20658]="0:15272:4:2:1:Leather::1:0:", -- Abyssal Leather Boots
	[20659]="0:12263:4:2:1:Mail::1:0:", -- Abyssal Mail Handguards
	[20660]="0:61543:2:3:1:Polearm::1:0:", -- Stonecutting Glaive
	[20661]="0:10295:4:2:1:Leather::1:0:", -- Abyssal Leather Gloves
	[20662]="0:21659:4:2:1:Plate::1:0:", -- Abyssal Plate Greaves
	[20663]="0:37336:2:3:1:Bow::1:0:", -- Deep Strike Bow
	[20664]="0:8909:4:2:1:Cloth::1:0:", -- Abyssal Cloth Sash
	[20665]="0:25775:4:3:1:Leather::1:0:", -- Abyssal Leather Leggings
	[20666]="0:51740:2:3:1:OneHandMace::1:0:", -- Hardened Steel Warhammer
	[20667]="0:11258:4:2:1:Leather::1:0:", -- Abyssal Leather Belt
	[20668]="0:31268:4:3:1:Mail::1:0:", -- Abyssal Mail Legguards
	[20669]="0:65379:2:3:1:TwoHandSword::1:0:", -- Darkstone Claymore
	[20670]="0:12679:4:2:1:Mail::1:0:", -- Abyssal Mail Clutch
	[20671]="0:34239:4:3:1:Plate::1:0:", -- Abyssal Plate Legplates
	[20672]="0:36826:2:3:1:Wand::1:0:", -- Sparkling Crystal Wand
	[20673]="0:15048:4:2:1:Plate::1:0:", -- Abyssal Plate Girdle
	[20674]="0:19792:4:3:1:Cloth::1:0:", -- Abyssal Cloth Pants
	[20675]="0:49664:2:3:1:OneHandAxe::1:0:", -- Soulrender
	[20676]="0:500:12:1:20:::1:0:", -- Decoded Twilight Text
	[20677]="0:500:12:1:20:::1:0:", -- Decoded Twilight Text
	[20678]="0:500:12:1:20:::1:0:", -- Decoded Twilight Text
	[20679]="0:500:12:1:20:::1:0:", -- Decoded Twilight Text
	[20680]="0:24739:4:3:1:Mail::1:0:", -- Abyssal Mail Pauldrons
	[20681]="0:13734:4:3:1:Leather::1:0:", -- Abyssal Leather Bracers
	[20682]="0:73553:4:4:1:Ring::1:0:", -- Elemental Focus Band
	[20683]="0:28999:4:3:1:Plate::1:0:", -- Abyssal Plate Epaulets
	[20684]="0:16664:4:3:1:Mail::1:0:", -- Abyssal Mail Armguards
	[20685]="0:61617:4:4:1:Amulet::1:0:", -- Wavefront Necklace
	[20686]="0:17224:4:3:1:Cloth::1:0:", -- Abyssal Cloth Amice
	[20687]="0:20282:4:3:1:Plate::1:0:", -- Abyssal Plate Vambraces
	[20688]="0:47483:4:4:1:Shield::1:0:", -- Earthen Guard
	[20689]="0:21761:4:3:1:Leather::1:0:", -- Abyssal Leather Shoulders
	[20690]="0:10538:4:3:1:Cloth::1:0:", -- Abyssal Cloth Wristbands
	[20691]="0:20361:4:4:1:Cloak::1:0:", -- Windshear Cape
	[20692]="0:13362:4:2:1:Ring::1:0:", -- Multicolored Band
	[20693]="0:11985:4:2:1:Cloak::1:0:", -- Weighted Cloak
	[20694]="0:17828:4:2:1:OffHandFrill::1:0:", -- Glowing Black Orb
	[20695]="0:36253:4:3:1:Amulet::1:0:", -- Abyssal War Beads
	[20696]="0:63158:2:3:1:TwoHandMace::1:0:", -- Crystal Spiked Maul
	[20697]="0:15213:4:3:1:Cloak::1:0:", -- Crystalline Threaded Cape
	[20698]="0:67873:2:4:1:OneHandSword::1:0:", -- Elemental Attuned Blade
	[20699]="0:35767:4:3:1:Plate::1:0:", -- Cenarion Reservist's Legplates
	[20700]="0:35901:4:3:1:Plate::1:0:", -- Cenarion Reservist's Legplates
	[20701]="0:30885:4:3:1:Mail::1:0:", -- Cenarion Reservist's Legguards
	[20702]="0:31824:4:3:1:Mail::1:0:", -- Cenarion Reservist's Legguards
	[20703]="0:26616:4:3:1:Leather::1:0:", -- Cenarion Reservist's Leggings
	[20704]="0:26711:4:3:1:Leather::1:0:", -- Cenarion Reservist's Leggings
	[20705]="0:21444:4:3:1:Cloth::1:0:", -- Cenarion Reservist's Pants
	[20706]="0:21520:4:3:1:Cloth::1:0:", -- Cenarion Reservist's Pants
	[20707]="0:21597:4:3:1:Cloth::1:0:", -- Cenarion Reservist's Pants
	[20708]="0:2:15:1:1:Junk::1:0:", -- Tightly Sealed Trunk
	[20709]="0:50:0:1:10:FoodDrink::1:0:", -- Rumsey Rum Light
	[20710]="0:25873:4:3:1:Plate::1:0:", -- Crystal Encrusted Greaves
	[20711]="0:25973:4:3:1:Plate::1:0:", -- Crystal Lined Greaves
	[20712]="0:14926:4:3:1:Mail::1:0:", -- Wastewalker's Gauntlets
	[20713]="0:14983:4:3:1:Mail::1:0:", -- Desertstalkers's Gauntlets
	[20714]="0:18801:4:3:1:Leather::1:0:", -- Sandstorm Boots
	[20715]="0:18873:4:3:1:Leather::1:0:", -- Dunestalker's Boots
	[20716]="0:10103:4:3:1:Cloth::1:0:", -- Sandworm Skin Gloves
	[20717]="0:10141:4:3:1:Cloth::1:0:", -- Desert Bloom Gloves
	[20720]="0:54064:2:3:1:Dagger::1:0:", -- Dark Whisper Blade
	[20721]="0:38790:4:3:1:Ring::1:0:", -- Band of the Cultist
	[20722]="0:40843:2:3:1:Gun::1:0:", -- Crystal Slugthrower
	[20723]="0:43760:2:2:1:OneHandAxe::1:0:", -- Brann's Trusty Pick
	[20724]="0:54892:2:2:1:Stave::1:0:", -- Corrupted Blackwood Staff
	[20725]="0:0:7:4:20:Enchanting:164,333:1:0:", -- Nexus Crystal
	[20726]="0:25000:9:3:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Threat
	[20727]="0:25000:9:3:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Shadow Power
	[20728]="0:25000:9:3:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Frost Power
	[20729]="0:25000:9:3:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Fire Power
	[20730]="0:25000:9:3:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Healing Power
	[20731]="0:25000:9:3:1:Enchanting::1:0:", -- Formula: Enchant Gloves - Superior Agility
	[20732]="100000:25000:9:1:1:Enchanting::1:0:15419", -- Formula: Enchant Cloak - Greater Fire Resistance
	[20733]="100000:25000:9:1:1:Enchanting::1:0:15419", -- Formula: Enchant Cloak - Greater Nature Resistance
	[20734]="0:25000:9:3:1:Enchanting::1:0:", -- Formula: Enchant Cloak - Stealth
	[20735]="0:25000:9:3:1:Enchanting::1:0:", -- Formula: Enchant Cloak - Subtlety
	[20736]="0:25000:9:3:1:Enchanting::1:0:", -- Formula: Enchant Cloak - Dodge
	[20741]="0:0:15:1:1:Junk::1:0:", -- Deadwood Ritual Totem
	[20742]="0:0:15:1:1:Junk::1:0:", -- Winterfall Ritual Totem
	[20743]="0:0:12:1:10:::1:0:", -- Unstable Mana Crystal
	[20744]="0:500:0:1:1:EnhTemp::1:0:", -- Minor Wizard Oil
	[20745]="0:1000:0:1:1:EnhTemp::1:0:", -- Minor Mana Oil
	[20746]="0:1000:0:1:1:EnhTemp::1:0:", -- Lesser Wizard Oil
	[20747]="0:1000:0:1:1:EnhTemp::1:0:", -- Lesser Mana Oil
	[20748]="0:1000:0:1:1:EnhTemp::1:0:", -- Brilliant Mana Oil
	[20749]="0:1000:0:1:1:EnhTemp::1:0:", -- Brilliant Wizard Oil
	[20750]="0:1000:0:1:1:EnhTemp::1:0:", -- Wizard Oil
	[20752]="3000:750:9:1:1:Enchanting::1:0:1318,3012,3346,4228,4617,5158,5757,5758,15419,16635,16722,18753,18773,18951,19234,19537,19540,19663,26569,27030,27054,27147,28714", -- Formula: Minor Mana Oil
	[20753]="4000:1000:9:1:1:Enchanting::1:0:1318,3012,3346,4228,4617,5158,5757,5758,15419,16635,16722,18753,18773,18951,19234,19537,19540,19663,26569,27030,27054,27147,28714", -- Formula: Lesser Wizard Oil
	[20754]="10000:2500:9:1:1:Enchanting::1:0:15419", -- Formula: Lesser Mana Oil
	[20755]="20000:5000:9:1:1:Enchanting::1:0:15419", -- Formula: Wizard Oil
	[20756]="40000:10000:9:1:1:Enchanting::1:0:14921", -- Formula: Brilliant Wizard Oil
	[20757]="40000:10000:9:1:1:Enchanting::1:0:14921", -- Formula: Brilliant Mana Oil
	[20758]="500:125:9:1:1:Enchanting::1:0:1318,3012,3346,4228,4617,5158,5757,5758,15419,16635,16722,18753,18773,18951,19234,19537,19540,19663,26569,27030,27054,27147,28714", -- Formula: Minor Wizard Oil
	[20759]="0:0:12:1:1:::1:0:", -- Otembe's Hammer
	[20760]="0:0:12:1:1:::1:0:", -- Chieftain Zul'Marosh's Head
	[20761]="120000:30000:9:1:1:Alchemy::1:1:12944", -- Recipe: Transmute Elemental Fire
	[20763]="0:312:15:0:5:Junk::1:0:", -- Broken Weapon
	[20764]="0:0:12:1:1:::1:0:", -- Prospector Anvilward's Head
	[20765]="0:0:12:1:1:::1:0:", -- Incriminating Documents
	[20766]="0:0:15:1:1:Junk::1:0:", -- Slimy Bag
	[20767]="0:0:15:1:1:Junk::1:0:", -- Scum Covered Bag
	[20768]="0:0:15:1:1:Junk::1:0:", -- Oozing Bag
	[20769]="0:2500:15:1:1:Companion::1:0:", -- Disgusting Oozeling
	[20770]="0:450:15:0:10:Junk::1:0:", -- Bubbling Green Ichor
	[20771]="0:0:12:1:20:::1:0:", -- Tainted Soil Sample
	[20772]="0:0:12:1:20:::1:0:", -- Springpaw Pelt
	[20797]="0:0:12:1:20:::1:0:", -- Lynx Collar
	[20799]="0:0:12:1:1:::1:0:", -- Felendren's Head
	[20800]="0:0:12:2:20:::1:0:", -- Cenarion Logistics Badge
	[20801]="0:0:12:2:20:::1:0:", -- Cenarion Tactical Badge
	[20802]="0:0:12:2:20:::1:0:", -- Cenarion Combat Badge
	[20803]="0:0:12:1:1:::1:0:", -- Twilight Battle Orders
	[20804]="0:0:12:1:1:::1:0:", -- Erona's Package
	[20805]="0:12:15:1:1:Junk::1:0:", -- Followup Logistics Assignment
	[20806]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing X
	[20807]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing I
	[20808]="0:12:15:1:1:Junk::1:0:", -- Combat Assignment
	[20809]="0:12:15:1:1:Junk::1:0:", -- Tactical Assignment
	[20810]="0:0:12:1:1:::1:0:", -- Signed Field Duty Papers
	[20812]="0:5:15:0:10:Junk::1:0:", -- Tattered Pelt
	[20813]="0:4:15:0:10:Junk::1:0:", -- Lynx Tooth
	[20815]="800:200:7:1:1:Other::1:0:372,790,3002,3133,3167,3358,3392,3578,4256,4599,5514,6298,11186,16224,16262,16613,16624,16664,16751,16768,17486,17512,18427,18751,18774,19065,19538,19539,20981,27142,28721,28728,28799,33602", -- Jeweler's Kit
	[20816]="0:20:7:1:20:Jewelcrafting:202,755:1:0:", -- Delicate Copper Wire
	[20817]="0:100:7:1:20:Jewelcrafting:755:1:0:", -- Bronze Setting
	[20818]="0:625:4:2:1:Ring::1:0:", -- Elegant Silver Ring
	[20820]="0:1064:4:2:1:Ring::1:0:", -- Simple Pearl Ring
	[20821]="0:1064:4:2:1:Ring::1:0:", -- Inlaid Malachite Ring
	[20823]="0:837:4:2:1:Ring::1:0:", -- Gloom Band
	[20824]="25000:6250:7:1:1:Jewelcrafting::1:0:372,790,3002,3133,3167,3358,3392,3578,4256,4599,5514,6298,11186,16224,16262,16613,16624,16664,16751,16768,17486,17512,18427,18751,18774,19065,19538,19539,20981,27142,28721,28728,28799,33602", -- Simple Grinder
	[20826]="0:2207:4:3:1:Ring::1:0:", -- Heavy Silver Ring
	[20827]="0:875:4:2:1:Ring::1:0:", -- Ring of Silver Might
	[20828]="0:677:4:2:1:Ring::1:0:", -- Ring of Twilight Shadows
	[20830]="0:1535:4:2:1:Amulet::1:0:", -- Amulet of the Moon
	[20831]="0:1535:4:2:1:Amulet::1:0:", -- Heavy Golden Necklace of Battle
	[20832]="0:1800:4:3:1:Cloth::1:0:", -- Moonsoul Crown
	[20833]="0:1540:4:2:1:Ring::1:0:", -- Wicked Moonstone Ring
	[20835]="0:25:2:1:1:OneHandSword::1:0:", -- Sunstrider Sword
	[20836]="0:25:2:1:1:Dagger::1:0:", -- Sunstrider Dagger
	[20837]="0:26:2:1:1:OneHandAxe::1:0:", -- Sunstrider Axe
	[20838]="0:19:2:1:1:Bow::1:0:", -- Sunstrider Bow
	[20839]="0:32:2:1:1:Stave::1:0:", -- Sunstrider Staff
	[20840]="0:26:2:1:1:OneHandMace::1:0:", -- Sunstrider Mace
	[20841]="0:16:4:1:1:Shield::1:0:", -- Sunstrider Shield
	[20842]="0:5:15:0:10:Junk::1:0:", -- Frayed Tender Vine
	[20843]="0:6:15:0:10:Junk::1:0:", -- Smashed Petal
	[20844]="300:75:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,10364,12096,12097,15175,16268,16588,16683,16829,18006,18019,18802,19013,19014,19049,19239,19679,20081,20121,20194,20915,20986,22479,23145,23373,24148,24313,24780,25043,26382,26568,27031,27038,27053,27089,28347,29535,30239,30244,30306,30438,31115,32639,32641", -- Deadly Poison V
	[20845]="0:4:15:0:10:Junk::1:0:", -- Torn Wyrm Scale
	[20846]="0:5:15:0:10:Junk::1:0:", -- Faintly Glowing Eye
	[20847]="0:6:15:0:10:Junk::1:0:", -- Wraith Fragment
	[20848]="0:5:15:0:10:Junk::1:0:", -- Sparkling Dust
	[20849]="84:16:2:1:1:OneHandSword::1:0:15289", -- Arcane Forged Shortsword
	[20850]="84:16:2:1:1:OneHandAxe::1:0:15289", -- Arcane Forged Axe
	[20851]="85:17:2:1:1:OneHandMace::1:0:15289", -- Arcane Forged Mace
	[20852]="85:17:2:1:1:Dagger::1:0:15289", -- Arcane Forged Dirk
	[20853]="107:21:2:1:1:Stave::1:0:15289", -- Mana Gathering Staff
	[20854]="1800:450:9:1:1:Jewelcrafting::1:1:4229,4561,16624,17512", -- Design: Amulet of the Moon
	[20855]="1500:375:9:1:1:Jewelcrafting::1:1:3499,3954", -- Design: Wicked Moonstone Ring
	[20856]="1500:375:9:1:1:Jewelcrafting::1:1:1286,3367,16624,17512", -- Design: Heavy Golden Necklace of Battle
	[20857]="25:1:0:1:20:FoodDrink::5:0:15287,16920", -- Honey Bread
	[20858]="0:0:12:2:250:::1:0:", -- Stone Scarab
	[20859]="0:0:12:2:250:::1:0:", -- Gold Scarab
	[20860]="0:0:12:2:250:::1:0:", -- Silver Scarab
	[20861]="0:0:12:2:250:::1:0:", -- Bronze Scarab
	[20862]="0:0:12:2:250:::1:0:", -- Crystal Scarab
	[20863]="0:0:12:2:250:::1:0:", -- Clay Scarab
	[20864]="0:0:12:2:250:::1:0:", -- Bone Scarab
	[20865]="0:0:12:2:250:::1:0:", -- Ivory Scarab
	[20866]="0:0:12:3:250:::1:0:", -- Azure Idol
	[20867]="0:0:12:3:250:::1:0:", -- Onyx Idol
	[20868]="0:0:12:3:250:::1:0:", -- Lambent Idol
	[20869]="0:0:12:3:250:::1:0:", -- Amber Idol
	[20870]="0:0:12:3:250:::1:0:", -- Jasper Idol
	[20871]="0:0:12:3:250:::1:0:", -- Obsidian Idol
	[20872]="0:0:12:3:250:::1:0:", -- Vermillion Idol
	[20873]="0:0:12:3:250:::1:0:", -- Alabaster Idol
	[20874]="0:0:12:3:250:::1:0:", -- Idol of the Sun
	[20875]="0:0:12:3:250:::1:0:", -- Idol of Night
	[20876]="0:0:12:3:250:::1:0:", -- Idol of Death
	[20877]="0:0:12:3:250:::1:0:", -- Idol of the Sage
	[20878]="0:0:12:3:250:::1:0:", -- Idol of Rebirth
	[20879]="0:0:12:3:250:::1:0:", -- Idol of Life
	[20881]="0:0:12:3:250:::1:0:", -- Idol of Strife
	[20882]="0:0:12:3:250:::1:0:", -- Idol of War
	[20884]="0:0:12:3:250:::1:0:", -- Qiraji Magisterial Ring
	[20885]="0:0:12:3:250:::1:0:", -- Qiraji Martial Drape
	[20886]="0:0:12:4:250:::1:0:", -- Qiraji Spiked Hilt
	[20888]="0:0:12:3:250:::1:0:", -- Qiraji Ceremonial Ring
	[20889]="0:0:12:3:250:::1:0:", -- Qiraji Regal Drape
	[20890]="0:0:12:4:250:::1:0:", -- Qiraji Ornate Hilt
	[20891]="0:1:4:0:1:Cloth::1:0:", -- Neophyte's Robe
	[20892]="0:1:4:0:1:Cloth::1:0:", -- Acolyte's Robe
	[20893]="0:1:4:0:1:Cloth::1:0:", -- Apprentice's Robe
	[20894]="0:1:4:0:1:Cloth::1:0:", -- Apprentice's Pants
	[20895]="0:1:4:1:1:Miscellaneous::1:0:", -- Apprentice's Boots
	[20896]="0:1:4:0:1:Cloth::1:0:", -- Lookout's Pants
	[20897]="0:1:4:0:1:Shirt::1:0:", -- Lookout's Tunic
	[20898]="0:1:4:0:1:Cloth::1:0:", -- Lookout's Shoes
	[20899]="0:1:4:0:1:Cloth::1:0:", -- Warder's Pants
	[20900]="0:1:4:0:1:Cloth::1:0:", -- Warder's Boots
	[20901]="0:1:4:0:1:Shirt::1:0:", -- Warder's Shirt
	[20906]="0:250:4:2:1:Ring::1:0:", -- Braided Copper Ring
	[20907]="0:300:4:2:1:Ring::1:0:", -- Solid Bronze Ring
	[20909]="0:1010:4:2:1:Amulet::1:0:", -- Barbaric Iron Collar
	[20910]="63:12:2:1:1:Bow::1:0:15289", -- Stiff Shortbow
	[20911]="37:7:4:1:1:Shield::1:0:15292", -- Light Guard
	[20912]="84:16:4:1:1:Shield::1:0:15292", -- Large Shield
	[20914]="39:7:4:1:1:Mail::1:0:15292", -- Unadorned Chain Belt
	[20915]="60:12:4:1:1:Mail::1:0:15292", -- Unadorned Chain Boots
	[20916]="36:7:4:1:1:Mail::1:0:15292", -- Unadorned Chain Bracers
	[20917]="36:7:4:1:1:Mail::1:0:15292", -- Unadorned Chain Gloves
	[20918]="72:14:4:1:1:Mail::1:0:15292,24539", -- Unadorned Chain Leggings
	[20919]="73:14:4:1:1:Mail::1:0:15292", -- Unadorned Chain Vest
	[20920]="30:6:4:1:1:Leather::1:0:15291", -- Sun Cured Belt
	[20921]="46:9:4:1:1:Leather::1:0:15291", -- Sun Cured Boots
	[20922]="30:6:4:1:1:Leather::1:0:15291", -- Sun Cured Bracers
	[20923]="30:6:4:1:1:Leather::1:0:15291", -- Sun Cured Gloves
	[20924]="62:12:4:1:1:Leather::1:0:15291", -- Sun Cured Pants
	[20925]="62:12:4:1:1:Leather::1:0:15291", -- Sun Cured Vest
	[20926]="0:0:12:4:250:::1:0:", -- Vek'nilash's Circlet
	[20927]="0:0:12:4:250:::1:0:", -- Ouro's Intact Hide
	[20928]="0:0:12:4:250:::1:0:", -- Qiraji Bindings of Command
	[20929]="0:0:12:4:250:::1:0:", -- Carapace of the Old God
	[20930]="0:0:12:4:250:::1:0:", -- Vek'lor's Diadem
	[20931]="0:0:12:4:250:::1:0:", -- Skin of the Great Sandworm
	[20932]="0:0:12:4:250:::1:0:", -- Qiraji Bindings of Dominance
	[20933]="0:0:12:4:250:::1:0:", -- Husk of the Old God
	[20934]="0:0:12:1:20:::1:0:", -- Wraith Essence
	[20935]="0:0:12:1:1:::1:0:", -- Tainted Wraith Essence
	[20938]="0:0:12:1:1:::1:0:", -- Falconwing Square Gift Voucher
	[20939]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing II
	[20940]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing III
	[20941]="0:0:12:2:1:::1:0:", -- Combat Task Briefing XII
	[20942]="0:0:12:2:1:::1:0:", -- Combat Task Briefing III
	[20943]="0:0:12:2:1:::1:0:", -- Tactical Task Briefing X
	[20944]="0:0:12:2:1:::1:0:", -- Tactical Task Briefing IX
	[20945]="0:0:12:2:1:::1:0:", -- Tactical Task Briefing II
	[20947]="0:0:12:2:1:::1:0:", -- Tactical Task Briefing IV
	[20948]="0:0:12:2:1:::1:0:", -- Tactical Task Briefing V
	[20949]="0:0:12:1:1:::1:0:", -- Magical Ledger
	[20950]="0:1535:4:2:1:Amulet::1:0:", -- Pendant of the Agate Shield
	[20951]="0:0:12:1:1:::1:0:", -- Narain's Scrying Goggles
	[20954]="0:5681:2:2:1:FistWeapon::1:0:", -- Heavy Iron Knuckles
	[20955]="0:665:4:2:1:Ring::1:0:", -- Golden Dragon Ring
	[20956]="0:2777:4:2:1:Amulet::1:0:", -- Silver Rose Pendant
	[20958]="0:1130:4:2:1:Ring::1:0:", -- Blazing Citrine Ring
	[20959]="0:1720:4:2:1:Ring::1:0:", -- The Jade Eye
	[20960]="0:1720:4:2:1:Ring::1:0:", -- Engraved Truesilver Ring
	[20961]="0:1720:4:2:1:Ring::1:0:", -- Citrine Ring of Rapid Healing
	[20963]="0:900:7:1:20:Jewelcrafting:755:1:0:", -- Mithril Filigree
	[20964]="0:6646:4:3:1:Ring::1:0:", -- Aquamarine Signet
	[20966]="0:3482:4:2:1:Amulet::1:0:", -- Jade Pendant of Blasting
	[20967]="0:3482:4:2:1:Amulet::1:0:", -- Citrine Pendant of Golden Healing
	[20969]="0:5989:4:3:1:Cloth::1:0:", -- Ruby Crown of Restoration
	[20970]="1500:375:9:1:1:Jewelcrafting::1:1:1448,4877", -- Design: Pendant of the Agate Shield
	[20971]="1500:375:9:1:1:Jewelcrafting::1:1:2381,2393", -- Design: Heavy Iron Knuckles
	[20973]="2000:500:9:1:1:Jewelcrafting::1:1:2381,9636", -- Design: Blazing Citrine Ring
	[20974]="0:625:9:2:1:Jewelcrafting::1:0:", -- Design: Jade Pendant of Blasting
	[20975]="2500:625:9:1:1:Jewelcrafting::1:1:4775,5163,16624,17512", -- Design: The Jade Eye
	[20976]="0:0:9:2:1:Jewelcrafting::1:0:", -- Design: Citrine Pendant of Golden Healing
	[20978]="46:9:2:1:1:Stave::1:0:24539", -- Apprentice's Staff
	[20980]="0:5:2:1:1:Bow::1:0:", -- Warder's Shortbow
	[20981]="0:7:2:1:1:OneHandMace::1:0:", -- Neophyte's Mace
	[20982]="0:7:2:1:1:Dagger::1:0:", -- Sharp Dagger
	[20983]="37:7:2:1:1:Dagger::1:0:24539", -- Acolyte's Dagger
	[20985]="38:7:4:1:1:Cloth::1:0:15291", -- Light Cloth Shoes
	[20986]="51:10:4:1:1:Cloth::1:0:15291,24539", -- Light Cloth Pants
	[20987]="25:5:4:1:1:Cloth::1:0:15291", -- Light Cloth Gloves
	[20988]="25:5:4:1:1:Cloth::1:0:15291", -- Light Cloth Bracers
	[20989]="25:5:4:1:1:Cloth::1:0:15291", -- Light Cloth Belt
	[20990]="52:10:4:1:1:Cloth::1:0:15291", -- Light Cloth Armor
	[20991]="0:7:4:1:1:Cloak::1:0:", -- Daylight Cloak
	[20992]="0:4:4:1:1:Cloth::1:0:", -- Sunrise Bracers
	[20993]="0:6:4:1:1:Leather::1:0:", -- Lynxskin Gloves
	[20994]="0:14:4:1:1:Mail::1:0:", -- Green Chain Vest
	[20995]="0:4:4:1:1:Cloth::1:0:", -- Well Watcher Gloves
	[20996]="0:6:4:1:1:Leather::1:0:", -- Sunspire Cord
	[20997]="0:11:4:1:1:Mail::1:0:", -- Green Chain Boots
	[20998]="0:4:4:1:1:Cloth::1:0:", -- Wyrm Sash
	[20999]="0:7:4:1:1:Mail::1:0:", -- Green Chain Gauntlets
	[21000]="0:6:4:1:1:Leather::1:0:", -- Vigorous Bracers
	[21001]="0:10:4:1:1:Cloth::1:0:", -- Striding Pants
	[21002]="0:1:4:0:1:Cloth::1:0:", -- Unkempt Belt
	[21003]="0:3:4:0:1:Cloth::1:0:", -- Unkempt Bracers
	[21004]="0:5:4:0:1:Cloak::1:0:", -- Unkempt Cloak
	[21005]="0:1:4:0:1:Cloth::1:0:", -- Unkempt Gloves
	[21006]="0:2:4:0:1:Cloth::1:0:", -- Unkempt Pants
	[21007]="0:4:4:0:1:Cloth::1:0:", -- Unkempt Robe
	[21008]="0:3:4:0:1:Cloth::1:0:", -- Unkempt Shoes
	[21009]="0:4:4:0:1:Leather::1:0:", -- Scraggy Leather Belt
	[21010]="0:2:4:0:1:Leather::1:0:", -- Scraggy Leather Boots
	[21011]="0:2:4:0:1:Leather::1:0:", -- Scraggy Leather Bracers
	[21012]="0:2:4:0:1:Leather::1:0:", -- Scraggy Leather Gloves
	[21013]="0:2:4:0:1:Leather::1:0:", -- Scraggy Leather Pants
	[21014]="0:8:4:0:1:Leather::1:0:", -- Scraggy Leather Vest
	[21015]="0:1:4:0:1:Mail::1:0:", -- Shoddy Chain Belt
	[21016]="0:9:4:0:1:Mail::1:0:", -- Shoddy Chain Vest
	[21017]="0:2:4:0:1:Mail::1:0:", -- Shoddy Chain Pants
	[21018]="0:3:4:0:1:Mail::1:0:", -- Shoddy Chain Gloves
	[21019]="0:3:4:0:1:Mail::1:0:", -- Shoddy Chain Bracers
	[21020]="0:3:4:0:1:Mail::1:0:", -- Shoddy Chain Boots
	[21021]="0:7:4:0:1:Shield::1:0:", -- Battered Shield
	[21022]="0:3:4:0:1:Shield::1:0:", -- Weather Beaten Buckler
	[21023]="0:250:0:1:20:FoodDrink::1:0:", -- Dirge's Kickin' Chimaerok Chops
	[21024]="0:0:7:1:20:Meat:185:1:0:", -- Chimaerok Tenderloin
	[21025]="0:1250:9:4:1:Cooking::1:0:", -- Recipe: Dirge's Kickin' Chimaerok Chops
	[21027]="0:0:12:1:1:::1:0:", -- Lakmaeran's Carcass
	[21028]="0:0:12:1:1:::1:0:", -- 500 Pound Chicken
	[21029]="0:0:12:1:1:::1:0:", -- Ransom Letter
	[21030]="2000:100:0:1:20:FoodDrink::5:0:2303,3961,4167,4181,4191,4195,4266,6091,7941,12019,12026", -- Darnassus Kimchi Pie
	[21031]="4000:200:0:1:20:FoodDrink::5:0:2303,3961,4167,4181,4191,4195,4266,6091,7941,12019,12026", -- Cabbage Kimchi
	[21032]="0:0:12:1:1:::1:0:", -- Meridith's Love Letter
	[21033]="4000:200:0:1:20:FoodDrink::5:0:2303,3961,4167,4181,4191,4195,4266,6091,7941,12019,12026", -- Radish Kimchi
	[21037]="0:0:15:1:1:Junk::1:0:", -- Crude Map
	[21038]="0:0:0:1:20:Other::1:0:", -- Hardpacked Snowball
	[21039]="0:1:4:1:1:Miscellaneous::1:0:", -- Narain's Turban
	[21040]="0:1:4:1:1:Miscellaneous::1:0:", -- Narain's Robe
	[21041]="0:0:12:1:1:::1:0:", -- Bag of Gold
	[21042]="0:0:15:1:1:Junk::1:0:", -- Narain's Special Kit
	[21071]="0:25:7:1:20:Meat:185:1:0:", -- Raw Sagefish
	[21072]="0:40:0:1:20:FoodDrink::1:0:", -- Smoked Sagefish
	[21099]="500:125:9:1:1:Cooking::1:0:2381,2397,2664,3027,3085,3400,4223,4265,4553,5160,5483,8307,12033,14738,16253,16677,16718,17246,19195,26868", -- Recipe: Smoked Sagefish
	[21100]="0:0:12:1:100:::1:0:", -- Coin of Ancestry
	[21103]="0:0:15:1:1:Junk::1:0:", -- Draconic for Dummies
	[21104]="0:0:15:1:1:Junk::1:0:", -- Draconic for Dummies
	[21105]="0:0:15:1:1:Junk::1:0:", -- Draconic for Dummies
	[21106]="0:0:15:1:1:Junk::1:0:", -- Draconic for Dummies
	[21107]="0:0:15:1:1:Junk::1:0:", -- Draconic for Dummies
	[21108]="0:0:15:1:1:Junk::1:0:", -- Draconic for Dummies
	[21109]="0:0:15:1:1:Junk::1:0:", -- Draconic for Dummies
	[21110]="0:0:15:1:1:Junk::1:0:", -- Draconic for Dummies
	[21111]="0:0:12:1:1:::1:0:", -- Draconic For Dummies: Volume II
	[21112]="0:0:12:1:1:::1:0:", -- Magical Book Binding
	[21113]="0:2:15:1:1:Junk::1:0:", -- Watertight Trunk
	[21114]="0:50:0:1:10:FoodDrink::1:0:", -- Rumsey Rum Dark
	[21115]="0:0:4:3:1:Trinket::1:0:15126", -- Defiler's Talisman
	[21116]="0:0:4:3:1:Trinket::1:0:15126", -- Defiler's Talisman
	[21117]="0:0:4:3:1:Trinket::1:0:15127", -- Talisman of Arathor
	[21118]="0:0:4:3:1:Trinket::1:0:15127", -- Talisman of Arathor
	[21119]="0:0:4:3:1:Trinket::1:0:15127", -- Talisman of Arathor
	[21120]="0:0:4:3:1:Trinket::1:0:15126", -- Defiler's Talisman
	[21126]="0:85698:2:4:1:Dagger::1:0:", -- Death's Sting
	[21128]="0:97775:2:4:1:Stave::1:0:", -- Staff of the Qiraji Prophets
	[21130]="0:0:15:1:1:Junk::1:0:", -- Diary of Weavil
	[21131]="0:12:15:1:1:Junk::1:0:", -- Followup Combat Assignment
	[21132]="0:12:15:1:1:Junk::1:0:", -- Logistics Assignment
	[21133]="0:12:15:1:1:Junk::1:0:", -- Followup Tactical Assignment
	[21134]="0:110377:2:4:1:TwoHandAxe::1:0:", -- Dark Edge of Insanity
	[21136]="0:0:12:1:1:::1:0:", -- Arcanite Buoy
	[21137]="0:0:12:1:1:::1:0:", -- Blue Scepter Shard
	[21138]="0:0:12:1:1:::1:0:", -- Red Scepter Shard
	[21139]="0:0:12:1:1:::1:0:", -- Green Scepter Shard
	[21140]="0:0:15:1:1:Junk::1:0:", -- Auction Stationery
	[21142]="0:0:15:1:1:Junk::1:0:", -- From the Desk of Lord Victor Nefarius
	[21143]="0:0:12:1:1:::1:0:", -- Unsigned Field Duty Papers
	[21144]="0:0:12:1:1:::1:0:", -- Demon Summoning Torch
	[21145]="0:0:12:1:1:::1:0:", -- Essence of Xandivious
	[21146]="0:0:12:1:1:::1:0:", -- Fragment of the Nightmare's Corruption
	[21147]="0:0:12:1:1:::1:0:", -- Fragment of the Nightmare's Corruption
	[21148]="0:0:12:1:1:::1:0:", -- Fragment of the Nightmare's Corruption
	[21149]="0:0:12:1:1:::1:0:", -- Fragment of the Nightmare's Corruption
	[21150]="0:2:15:1:1:Junk::1:0:", -- Iron Bound Trunk
	[21151]="200:50:0:1:10:FoodDrink::1:0:20377", -- Rumsey Rum Black Label
	[21153]="0:125:7:1:20:Meat:185:1:0:", -- Raw Greater Sagefish
	[21154]="0:1:4:1:1:Cloth::1:0:", -- Festival Dress
	[21155]="0:0:12:1:1:::1:0:", -- Timbermaw Offering of Peace
	[21156]="0:12:15:1:1:Junk::1:0:", -- Scarab Bag
	[21157]="0:0:4:1:1:Miscellaneous::1:0:15864", -- Festive Green Dress
	[21158]="0:0:12:1:1:::1:0:", -- Hive'Zora Scout Report
	[21160]="0:0:12:1:1:::1:0:", -- Hive'Regal Scout Report
	[21161]="0:0:12:1:1:::1:0:", -- Hive'Ashi Scout Report
	[21162]="0:25:15:1:1:Junk::1:0:", -- Bloated Oily Blackmouth
	[21164]="0:100:15:1:1:Other::1:0:", -- Bloated Rockscale Cod
	[21165]="0:0:12:2:1:::1:0:", -- Tactical Task Briefing VI
	[21166]="0:0:12:2:1:::1:0:", -- Tactical Task Briefing VII
	[21167]="0:0:12:2:1:::1:0:", -- Tactical Task Briefing VIII
	[21168]="0:1500:15:1:1:Companion::1:0:", -- Baby Shark
	[21171]="0:0:15:1:1:Junk::1:0:", -- Filled Festive Mug
	[21174]="0:0:15:1:1:Junk::1:0:", -- Empty Festive Mug
	[21175]="0:0:15:1:1:Junk::1:0:", -- The Scepter of the Shifting Sands
	[21176]="0:0:15:5:1:Mount::1:0:", -- Black Qiraji Resonating Crystal
	[21177]="3000:37:15:1:100:Reagent:-2:20:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24409,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Symbol of Kings
	[21178]="0:13268:4:3:1:Leather::1:0:", -- Gloves of Earthen Power
	[21179]="0:10709:4:3:1:Ring::1:0:", -- Band of Earthen Wrath
	[21180]="0:21612:4:4:1:Trinket::1:0:", -- Earthstrike
	[21181]="0:21612:4:3:1:Trinket::1:0:", -- Grace of Earth
	[21182]="0:10709:4:3:1:Ring::1:0:", -- Band of Earthen Might
	[21183]="0:20620:4:3:1:Cloth::1:0:", -- Earthpower Vest
	[21184]="0:23671:4:4:1:Plate::1:0:", -- Deeprock Bracers
	[21185]="0:10452:4:4:1:OffHandFrill::1:0:", -- Earthcalm Orb
	[21186]="0:13550:4:4:1:Cloth::1:0:", -- Rockfury Bracers
	[21187]="0:15299:4:3:1:Cloak::1:0:", -- Earthweave Cloak
	[21188]="0:89953:2:4:1:TwoHandMace::1:0:", -- Fist of Cenarius
	[21189]="0:188888:4:4:1:Ring::1:0:", -- Might of Cenarius
	[21190]="0:188888:4:4:1:Ring::1:0:", -- Wrath of Cenarius
	[21191]="0:0:15:1:1:Junk::1:0:", -- Carefully Wrapped Present
	[21196]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21197]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21198]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21199]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21200]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21201]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21202]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21203]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21204]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21205]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21206]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21207]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21208]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21209]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21210]="0:0:4:4:1:Ring::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21211]="0:0:12:1:1:::1:0:", -- Pouch of Reindeer Dust
	[21212]="0:0:0:1:20:Consumable::1:0:", -- Fresh Holly
	[21213]="0:0:15:2:20:Holiday::1:0:", -- Preserved Holly
	[21214]="0:100000:9:3:1:Book::1:0:", -- Tome of Frostbolt XI
	[21215]="0:0:0:1:20:FoodDrink::1:0:", -- Graccu's Mince Meat Fruitcake
	[21216]="0:0:15:1:1:Junk::1:0:", -- Smokywood Pastures Extra-Special Gift
	[21217]="0:125:0:1:20:FoodDrink::1:0:", -- Sagefish Delight
	[21218]="0:0:15:3:1:Mount::1:0:", -- Blue Qiraji Resonating Crystal
	[21219]="5000:1250:9:1:1:Cooking::1:0:2381,2397,2664,3027,3085,3400,4223,4265,4553,5160,5483,8307,12033,14738,16253,16677,16718,17246,19195,26868", -- Recipe: Sagefish Delight
	[21220]="0:0:12:4:1:::1:0:", -- Head of Ossirian the Unscarred
	[21221]="0:0:12:4:1:::1:0:", -- Eye of C'Thun
	[21222]="0:1750:15:0:10:Junk::1:0:", -- Armored Chitin
	[21223]="0:1500:15:0:10:Junk::1:0:", -- Black Stone
	[21224]="0:3000:15:0:10:Junk::1:0:", -- Ancient Armor Fragment
	[21225]="0:2500:15:0:10:Junk::1:0:", -- Heavy Silithid Husk
	[21226]="0:4000:15:0:10:Junk::1:0:", -- Runic Stone
	[21227]="0:7500:15:0:10:Junk::1:0:", -- Ancient Hero's Skull
	[21228]="0:2:15:1:1:Junk::1:0:", -- Mithril Bound Trunk
	[21229]="0:0:15:1:50:Junk::1:0:", -- Qiraji Lord's Insignia
	[21230]="0:0:15:1:1:Junk::1:0:", -- Ancient Qiraji Artifact
	[21232]="0:0:15:4:1:Junk::1:0:", -- Imperial Qiraji Armaments
	[21235]="0:0:0:1:20:FoodDrink::1:0:", -- Winter Veil Roast
	[21237]="0:0:15:4:1:Junk::1:0:", -- Imperial Qiraji Regalia
	[21241]="0:0:0:1:20:Consumable::1:0:", -- Winter Veil Eggnog
	[21242]="0:82145:2:4:1:OneHandAxe::1:0:", -- Blessed Qiraji War Axe
	[21243]="0:100:15:1:1:Junk::1:0:", -- Bloated Mightfish
	[21244]="0:82758:2:4:1:Dagger::1:0:", -- Blessed Qiraji Pugio
	[21245]="0:0:12:2:1:::1:0:", -- Tactical Task Briefing I
	[21248]="0:0:12:2:1:::1:0:", -- Combat Task Briefing IV
	[21249]="0:0:12:2:1:::1:0:", -- Combat Task Briefing V
	[21250]="0:0:12:2:1:::1:0:", -- Combat Task Briefing VI
	[21251]="0:0:12:2:1:::1:0:", -- Combat Task Briefing VII
	[21252]="0:0:12:2:1:::1:0:", -- Combat Task Briefing VIII
	[21253]="0:0:12:2:1:::1:0:", -- Combat Task Briefing IX
	[21254]="0:0:0:1:5:FoodDrink::1:0:", -- Winter Veil Cookie
	[21255]="0:0:12:2:1:::1:0:", -- Combat Task Briefing X
	[21256]="0:0:12:2:1:::1:0:", -- Combat Task Briefing XI
	[21257]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing IV
	[21258]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing IV
	[21259]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing V
	[21260]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing VI
	[21261]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing VI
	[21262]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing VIII
	[21263]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing VII
	[21264]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing VII
	[21265]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing IX
	[21266]="0:12:15:1:1:Junk::1:0:", -- Logistics Assignment
	[21267]="0:0:15:1:1:Holiday::1:0:", -- Toasting Goblet
	[21268]="0:86208:2:4:1:OneHandMace::1:0:", -- Blessed Qiraji War Hammer
	[21269]="0:55371:4:4:1:Shield::1:0:", -- Blessed Qiraji Bulwark
	[21270]="0:0:15:1:1:Junk::1:0:", -- Gently Shaken Gift
	[21271]="0:0:15:1:1:Junk::1:0:", -- Gently Shaken Gift
	[21272]="0:65581:2:4:1:Gun::1:0:", -- Blessed Qiraji Musket
	[21273]="0:109680:2:4:1:Stave::1:0:", -- Blessed Qiraji Acolyte Staff
	[21275]="0:99954:2:4:1:Stave::1:0:", -- Blessed Qiraji Augur Staff
	[21277]="0:1250:15:1:1:Companion::1:0:", -- Tranquil Mechanical Yeti
	[21278]="0:9126:4:3:1:Leather::1:0:", -- Stormshroud Gloves
	[21279]="0:100000:9:3:1:Book::1:0:", -- Tome of Fireball XII
	[21280]="0:100000:9:3:1:Book::1:0:", -- Tome of Arcane Missiles VIII
	[21281]="0:100000:9:3:1:Book::1:0:", -- Grimoire of Shadow Bolt X
	[21282]="0:100000:9:3:1:Book::1:0:", -- Grimoire of Immolate VIII
	[21283]="0:100000:9:3:1:Book::1:0:", -- Grimoire of Corruption VII
	[21284]="0:100000:9:3:1:Book::1:0:", -- Codex of Greater Heal V
	[21285]="0:100000:9:3:1:Book::1:0:", -- Codex of Renew X
	[21287]="0:100000:9:3:1:Book::1:0:", -- Codex of Prayer of Healing V
	[21288]="0:100000:9:3:1:Book::1:0:", -- Libram: Blessing of Wisdom VI
	[21289]="0:100000:9:3:1:Book::1:0:", -- Libram: Blessing of Might VII
	[21290]="0:100000:9:3:1:Book::1:0:", -- Libram: Holy Light IX
	[21291]="0:100000:9:3:1:Book::1:0:", -- Tablet of Healing Wave X
	[21292]="0:100000:15:3:1:CombatPet::1:0:", -- Tablet of Strength of Earth Totem V
	[21293]="0:100000:9:3:1:Book::1:0:", -- Tablet of Grace of Air Totem III
	[21294]="0:100000:9:3:1:Book::1:0:", -- Book of Healing Touch XI
	[21295]="0:100000:9:3:1:Book::1:0:", -- Book of Starfire VII
	[21296]="0:100000:9:3:1:Book::1:0:", -- Book of Rejuvenation XI
	[21297]="0:100000:9:3:1:Book::1:0:", -- Manual of Heroic Strike IX
	[21298]="0:100000:9:3:1:Book::1:0:", -- Manual of Battle Shout VII
	[21299]="0:100000:9:3:1:Book::1:0:", -- Manual of Revenge VI
	[21300]="0:100000:9:3:1:Book::1:0:", -- Handbook of Backstab IX
	[21301]="0:0:15:1:1:Companion::1:0:", -- Green Helper Box
	[21302]="0:100000:9:3:1:Book::1:0:", -- Handbook of Deadly Poison V
	[21303]="0:100000:9:3:1:Book::1:0:", -- Handbook of Feint V
	[21304]="0:100000:9:3:1:Book::1:0:", -- Guide: Multi-Shot V
	[21305]="0:0:15:1:1:Companion::1:0:", -- Red Helper Box
	[21306]="0:100000:9:3:1:Book::1:0:", -- Guide: Serpent Sting IX
	[21307]="0:100000:9:3:1:Book::1:0:", -- Guide: Aspect of the Hawk VII
	[21308]="0:0:15:1:1:Companion::1:0:", -- Jingling Bell
	[21309]="0:0:15:1:1:Companion::1:0:", -- Snowman Kit
	[21310]="0:0:15:1:1:Junk::1:0:", -- Gaily Wrapped Present
	[21311]="0:8473:4:2:1:Cloth::1:0:", -- Earth Warder's Vest
	[21312]="0:6377:4:2:1:Mail::1:0:", -- Belt of the Den Watcher
	[21314]="0:0:15:1:1:Junk::1:0:", -- Metzen's Letters and Notes
	[21315]="0:0:15:1:1:Junk::1:0:", -- Smokywood Satchel
	[21316]="0:21713:4:2:1:Plate::1:0:", -- Leggings of the Ursa
	[21317]="0:11675:4:2:1:Leather::1:0:", -- Helm of the Pathfinder
	[21318]="0:7444:4:2:1:Cloth::1:0:", -- Earth Warder's Gloves
	[21319]="0:9339:4:2:1:Leather::1:0:", -- Gloves of the Pathfinder
	[21320]="0:22497:4:2:1:Mail::1:0:", -- Vest of the Den Watcher
	[21321]="0:0:15:3:1:Mount::1:0:", -- Red Qiraji Resonating Crystal
	[21322]="0:26439:4:2:1:Plate::1:0:", -- Ursa's Embrace
	[21323]="0:0:15:3:1:Mount::1:0:", -- Green Qiraji Resonating Crystal
	[21324]="0:0:15:3:1:Mount::1:0:", -- Yellow Qiraji Resonating Crystal
	[21325]="0:0:15:2:1:CombatPet::1:0:", -- Mechanical Greench
	[21326]="0:8991:4:4:1:Trinket::1:0:", -- Defender of the Timbermaw
	[21327]="0:0:15:1:1:Junk::1:0:", -- Ticking Present
	[21328]="0:0:15:1:1:Junk::1:0:", -- Wand of Holiday Cheer
	[21329]="0:43010:4:4:1:Plate::1:0:", -- Conqueror's Crown
	[21330]="0:41773:4:4:1:Plate::1:0:", -- Conqueror's Spaulders
	[21331]="0:62274:4:4:1:Plate::1:0:", -- Conqueror's Breastplate
	[21332]="0:58117:4:4:1:Plate::1:0:", -- Conqueror's Legguards
	[21333]="0:42255:4:4:1:Plate::1:0:", -- Conqueror's Greaves
	[21334]="0:35991:4:4:1:Cloth::1:0:", -- Doomcaller's Robes
	[21335]="0:24374:4:4:1:Cloth::1:0:", -- Doomcaller's Mantle
	[21336]="0:33714:4:4:1:Cloth::1:0:", -- Doomcaller's Trousers
	[21337]="0:25378:4:4:1:Cloth::1:0:", -- Doomcaller's Circlet
	[21338]="0:24648:4:4:1:Cloth::1:0:", -- Doomcaller's Footwraps
	[21340]="0:5000:1:2:1:SoulBag::1:0:", -- Soul Pouch
	[21341]="0:20000:1:3:1:SoulBag::1:0:", -- Felcloth Bag
	[21342]="0:80000:1:4:1:SoulBag::1:0:", -- Core Felcloth Bag
	[21343]="0:37212:4:4:1:Cloth::1:0:", -- Enigma Robes
	[21344]="0:25198:4:4:1:Cloth::1:0:", -- Enigma Boots
	[21345]="0:25947:4:4:1:Cloth::1:0:", -- Enigma Shoulderpads
	[21346]="0:35883:4:4:1:Cloth::1:0:", -- Enigma Leggings
	[21347]="0:27007:4:4:1:Cloth::1:0:", -- Enigma Circlet
	[21348]="0:24526:4:4:1:Cloth::1:0:", -- Tiara of the Oracle
	[21349]="0:23821:4:4:1:Cloth::1:0:", -- Footwraps of the Oracle
	[21350]="0:23913:4:4:1:Cloth::1:0:", -- Mantle of the Oracle
	[21351]="0:35581:4:4:1:Cloth::1:0:", -- Vestments of the Oracle
	[21352]="0:33203:4:4:1:Cloth::1:0:", -- Trousers of the Oracle
	[21353]="0:31246:4:4:1:Leather::1:0:", -- Genesis Helm
	[21354]="0:30349:4:4:1:Leather::1:0:", -- Genesis Shoulderpads
	[21355]="0:30464:4:4:1:Leather::1:0:", -- Genesis Boots
	[21356]="0:42134:4:4:1:Leather::1:0:", -- Genesis Trousers
	[21357]="0:45491:4:4:1:Leather::1:0:", -- Genesis Vest
	[21358]="12000:3000:9:1:1:Tailoring::1:0:6568", -- Pattern: Soul Pouch
	[21359]="0:30922:4:4:1:Leather::1:0:", -- Deathdealer's Boots
	[21360]="0:32073:4:4:1:Leather::1:0:", -- Deathdealer's Helm
	[21361]="0:31974:4:4:1:Leather::1:0:", -- Deathdealer's Spaulders
	[21362]="0:44219:4:4:1:Leather::1:0:", -- Deathdealer's Leggings
	[21363]="0:0:15:1:1:Junk::1:0:", -- Festive Gift
	[21364]="0:47900:4:4:1:Leather::1:0:", -- Deathdealer's Vest
	[21365]="0:39091:4:4:1:Mail::1:0:", -- Striker's Footguards
	[21366]="0:40364:4:4:1:Mail::1:0:", -- Striker's Diadem
	[21367]="0:40683:4:4:1:Mail::1:0:", -- Striker's Pauldrons
	[21368]="0:49042:4:4:1:Mail::1:0:", -- Striker's Leggings
	[21370]="0:53161:4:4:1:Mail::1:0:", -- Striker's Hauberk
	[21371]="0:20000:9:3:1:Tailoring::1:0:", -- Pattern: Core Felcloth Bag
	[21372]="0:37349:4:4:1:Mail::1:0:", -- Stormcaller's Diadem
	[21373]="0:36438:4:4:1:Mail::1:0:", -- Stormcaller's Footguards
	[21374]="0:53975:4:4:1:Mail::1:0:", -- Stormcaller's Hauberk
	[21375]="0:50365:4:4:1:Mail::1:0:", -- Stormcaller's Leggings
	[21376]="0:36851:4:4:1:Mail::1:0:", -- Stormcaller's Pauldrons
	[21377]="0:200:12:1:250:::1:0:", -- Deadwood Headdress Feather
	[21378]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing I
	[21379]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing II
	[21380]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing III
	[21381]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing IX
	[21382]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing V
	[21383]="0:200:12:1:250:::1:0:", -- Winterfall Spirit Beads
	[21384]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing VIII
	[21385]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing X
	[21386]="0:12:15:1:1:Junk::1:0:", -- Followup Logistics Assignment
	[21387]="0:47159:4:4:1:Plate::1:0:", -- Avenger's Crown
	[21388]="0:41438:4:4:1:Plate::1:0:", -- Avenger's Greaves
	[21389]="0:61776:4:4:1:Plate::1:0:", -- Avenger's Breastplate
	[21390]="0:57649:4:4:1:Plate::1:0:", -- Avenger's Legguards
	[21391]="0:41916:4:4:1:Plate::1:0:", -- Avenger's Pauldrons
	[21392]="0:0:2:4:1:OneHandAxe::1:0:", -- Sickle of Unyielding Strength
	[21393]="0:0:4:4:1:Ring::1:0:", -- Signet of Unyielding Strength
	[21394]="0:0:4:4:1:Cloak::1:0:", -- Drape of Unyielding Strength
	[21395]="0:0:2:4:1:OneHandSword::1:0:", -- Blade of Eternal Justice
	[21396]="0:0:4:4:1:Ring::1:0:", -- Ring of Eternal Justice
	[21397]="0:0:4:4:1:Cloak::1:0:", -- Cape of Eternal Justice
	[21398]="0:0:2:4:1:OneHandMace::1:0:", -- Hammer of the Gathering Storm
	[21399]="0:0:4:4:1:Ring::1:0:", -- Ring of the Gathering Storm
	[21400]="0:0:4:4:1:Cloak::1:0:", -- Cloak of the Gathering Storm
	[21401]="0:0:2:4:1:OneHandAxe::1:0:", -- Scythe of the Unseen Path
	[21402]="0:0:4:4:1:Ring::1:0:", -- Signet of the Unseen Path
	[21403]="0:0:4:4:1:Cloak::1:0:", -- Cloak of the Unseen Path
	[21404]="0:0:2:4:1:Dagger::1:0:", -- Dagger of Veiled Shadows
	[21405]="0:0:4:4:1:Ring::1:0:", -- Band of Veiled Shadows
	[21406]="0:0:4:4:1:Cloak::1:0:", -- Cloak of Veiled Shadows
	[21407]="0:0:2:4:1:TwoHandMace::1:0:", -- Mace of Unending Life
	[21408]="0:0:4:4:1:Ring::1:0:", -- Band of Unending Life
	[21409]="0:0:4:4:1:Cloak::1:0:", -- Cloak of Unending Life
	[21410]="0:0:2:4:1:OneHandMace::1:0:", -- Gavel of Infinite Wisdom
	[21411]="0:0:4:4:1:Ring::1:0:", -- Ring of Infinite Wisdom
	[21412]="0:0:4:4:1:Cloak::1:0:", -- Shroud of Infinite Wisdom
	[21413]="0:0:2:4:1:OneHandSword::1:0:", -- Blade of Vaulted Secrets
	[21414]="0:0:4:4:1:Ring::1:0:", -- Band of Vaulted Secrets
	[21415]="0:0:4:4:1:Cloak::1:0:", -- Drape of Vaulted Secrets
	[21416]="0:0:2:4:1:Dagger::1:0:", -- Kris of Unspoken Names
	[21417]="0:0:4:4:1:Ring::1:0:", -- Ring of Unspoken Names
	[21418]="0:0:4:4:1:Cloak::1:0:", -- Shroud of Unspoken Names
	[21436]="0:0:15:1:100:Junk::1:0:", -- Alliance Commendation Signet
	[21438]="0:0:15:1:100:Junk::1:0:", -- Horde Commendation Signet
	[21452]="0:96177:2:4:1:Stave::1:0:", -- Staff of the Ruins
	[21453]="0:40467:4:4:1:Plate::1:0:", -- Mantle of the Horusath
	[21454]="0:35033:4:4:1:Mail::1:0:", -- Runic Stone Shoulders
	[21455]="0:22403:4:3:1:Leather::1:0:", -- Southwind Helm
	[21456]="0:23424:4:4:1:Cloak::1:0:", -- Sandstorm Cloak
	[21457]="0:27585:4:4:1:Plate::1:0:", -- Bracers of Brutality
	[21458]="0:20174:4:4:1:Leather::1:0:", -- Gauntlets of New Life
	[21459]="0:60738:2:4:1:Crossbow::1:0:", -- Crossbow of Imminent Doom
	[21460]="0:42586:4:4:1:Plate::1:0:", -- Helm of Domination
	[21461]="0:29522:4:4:1:Cloth::1:0:", -- Leggings of the Black Blizzard
	[21462]="0:14816:4:4:1:Cloth::1:0:", -- Gloves of Dark Wisdom
	[21463]="0:22311:4:4:1:Mail::1:0:", -- Ossirian's Binding
	[21464]="0:14931:4:4:1:Cloth::1:0:", -- Shackles of the Unscarred
	[21466]="0:72521:2:4:1:OneHandMace::1:0:", -- Stinger of Ayamiss
	[21467]="0:36399:4:4:1:Leather::1:0:", -- Thick Silithid Chestguard
	[21468]="0:17462:4:3:1:Cloth::1:0:", -- Mantle of Maz'Nadir
	[21469]="0:14605:4:3:1:Leather::1:0:", -- Gauntlets of Southwind
	[21470]="0:17592:4:3:1:Cloak::1:0:", -- Cloak of the Savior
	[21471]="0:88787:4:4:1:OffHandFrill::1:0:", -- Talon of Furious Concentration
	[21472]="0:22251:4:4:1:Cloth::1:0:", -- Dustwind Turban
	[21473]="0:82878:4:3:1:Trinket::1:0:", -- Eye of Moam
	[21474]="0:22909:4:3:1:Leather::1:0:", -- Chitinous Shoulderguards
	[21475]="0:42918:4:3:1:Plate::1:0:", -- Legplates of the Destroyer
	[21476]="0:36919:4:3:1:Mail::1:0:", -- Obsidian Scaled Leggings
	[21477]="0:88503:4:3:1:Ring::1:0:", -- Ring of Fury
	[21478]="0:57620:2:4:1:Bow::1:0:", -- Bow of Taut Sinew
	[21479]="0:27139:4:4:1:Plate::1:0:", -- Gauntlets of the Immovable
	[21480]="0:18501:4:3:1:Mail::1:0:", -- Scaled Silithid Gauntlets
	[21481]="0:29346:4:3:1:Plate::1:0:", -- Boots of the Desert Protector
	[21482]="0:25412:4:3:1:Mail::1:0:", -- Boots of the Fiery Sands
	[21483]="0:75303:4:3:1:Ring::1:0:", -- Ring of the Desert Winds
	[21484]="0:21244:4:3:1:Leather::1:0:", -- Helm of Regrowth
	[21485]="0:45658:4:4:1:Shield::1:0:", -- Buru's Skull Fragment
	[21486]="0:25208:4:4:1:Plate::1:0:", -- Gloves of the Swarm
	[21487]="0:21566:4:4:1:Mail::1:0:", -- Slimy Scaled Gauntlets
	[21488]="0:67812:4:3:1:Trinket::1:0:", -- Fetish of Chitinous Spikes
	[21489]="0:17319:4:3:1:Cloth::1:0:", -- Quicksand Waders
	[21490]="0:31182:4:3:1:Plate::1:0:", -- Slime Kickers
	[21491]="0:14931:4:3:1:Leather::1:0:", -- Scaled Bracers of the Gorger
	[21492]="0:91625:2:4:1:TwoHandSword::1:0:", -- Manslayer of the Qiraji
	[21493]="0:27587:4:4:1:Leather::1:0:", -- Boots of the Vanguard
	[21494]="0:14736:4:3:1:Leather::1:0:", -- Southwind's Grasp
	[21495]="0:41405:4:3:1:Plate::1:0:", -- Legplates of the Qiraji Command
	[21496]="0:11872:4:3:1:Cloth::1:0:", -- Bracers of Qiraji Command
	[21497]="0:26928:4:3:1:Mail::1:0:", -- Boots of the Qiraji General
	[21498]="0:74888:2:4:1:Dagger::1:0:", -- Qiraji Sacrificial Dagger
	[21499]="0:30059:4:4:1:Cloth::1:0:", -- Vestments of the Shifting Sands
	[21500]="0:12041:4:3:1:Cloth::1:0:", -- Belt of the Inquisition
	[21501]="0:13668:4:3:1:Leather::1:0:", -- Toughened Silithid Hide Gloves
	[21502]="0:16466:4:3:1:Mail::1:0:", -- Sand Reaver Wristguards
	[21503]="0:19392:4:3:1:Plate::1:0:", -- Belt of the Sand Reaver
	[21504]="0:111628:4:4:1:Amulet::1:0:", -- Charm of the Shifting Sands
	[21505]="0:111628:4:4:1:Amulet::1:0:", -- Choker of the Shifting Sands
	[21506]="0:111628:4:4:1:Amulet::1:0:", -- Pendant of the Shifting Sands
	[21507]="0:111628:4:4:1:Amulet::1:0:", -- Amulet of the Shifting Sands
	[21508]="0:0:12:2:20:::1:0:", -- Mark of Cenarius
	[21509]="0:0:15:1:1:Junk::1:0:", -- Ahn'Qiraj War Effort Supplies
	[21510]="0:0:15:1:1:Junk::1:0:", -- Ahn'Qiraj War Effort Supplies
	[21511]="0:0:15:1:1:Junk::1:0:", -- Ahn'Qiraj War Effort Supplies
	[21512]="0:0:15:1:1:Junk::1:0:", -- Ahn'Qiraj War Effort Supplies
	[21513]="0:0:15:1:1:Junk::1:0:", -- Ahn'Qiraj War Effort Supplies
	[21514]="0:0:12:2:1:::1:0:", -- Logistics Task Briefing XI
	[21515]="0:0:12:2:20:::1:0:", -- Mark of Remulos
	[21517]="0:24982:4:4:1:Cloth::1:0:", -- Gnomish Turban of Psychic Might
	[21519]="0:0:15:1:20:Junk::1:0:", -- Mistletoe
	[21520]="0:85129:2:4:1:OneHandSword::1:0:", -- Ravencrest's Legacy
	[21521]="0:77306:2:4:1:OneHandSword::1:0:", -- Runesword of the Red
	[21522]="0:79748:2:4:1:Dagger::1:0:", -- Shadowsong's Sorrow
	[21523]="0:80049:2:4:1:Dagger::1:0:", -- Fang of Korialstrasz
	[21524]="0:1:4:2:1:Cloth::1:0:", -- Red Winter Hat
	[21525]="0:1:4:2:1:Cloth::1:0:", -- Green Winter Hat
	[21526]="0:828085:4:4:1:Ring::1:0:", -- Band of Icy Depths
	[21527]="0:32868:4:4:1:Cloth::1:0:", -- Darkwater Robes
	[21528]="0:0:15:2:1:Junk::1:0:", -- Colossal Bag of Loot
	[21529]="0:90788:4:4:1:Amulet::1:0:", -- Amulet of Shadow Shielding
	[21530]="0:49843:4:4:1:Mail::1:0:", -- Onyx Embedded Leggings
	[21531]="0:103030:4:4:1:Amulet::1:0:", -- Drake Tooth Necklace
	[21532]="0:31380:4:4:1:Leather::1:0:", -- Drudge Boots
	[21533]="0:0:12:1:1:::1:0:", -- Colossus of Zora's Husk
	[21534]="0:0:12:1:1:::1:0:", -- Colossus of Ashi's Husk
	[21535]="0:0:12:1:1:::1:0:", -- Colossus of Regal's Husk
	[21536]="0:0:15:1:20:Holiday::1:0:", -- Elune Stone
	[21537]="0:0:0:1:20:Consumable::8:0:15864", -- Festival Dumplings
	[21538]="0:0:4:1:1:Miscellaneous::1:0:15864", -- Festive Pink Dress
	[21539]="0:0:4:1:1:Miscellaneous::1:0:15864", -- Festive Purple Dress
	[21540]="0:0:15:2:1:Junk::1:0:", -- Elune's Lantern
	[21541]="0:0:4:1:1:Miscellaneous::1:0:15864", -- Festive Black Pant Suit
	[21542]="0:1:4:1:1:Miscellaneous::1:0:", -- Festival Suit
	[21543]="0:0:4:1:1:Miscellaneous::1:0:15864", -- Festive Teal Pant Suit
	[21544]="0:0:4:1:1:Miscellaneous::1:0:15864", -- Festive Blue Pant Suit
	[21545]="0:0:12:1:1:::1:0:", -- Smokywood Supplies
	[21546]="0:35:0:1:20:Elixir::1:0:", -- Elixir of Greater Firepower
	[21547]="0:2500:9:2:1:Alchemy::1:0:", -- Recipe: Elixir of Greater Firepower
	[21548]="0:15000:9:3:1:Leatherworking::1:0:", -- Pattern: Stormshroud Gloves
	[21552]="2000:5:0:1:20:FoodDrink::5:0:1678,1684,2842,3086,3178,3497,3540,4200,4221,4305,4307,5814,6727,6738,6791,6807,7943,8137,8931,11187,12962,14731,16618,16739,17553,17656,19045,23896,24834,24993,25012,25020,25052,25089,29291", -- Striped Yellowtail
	[21557]="25:6:15:1:20:Holiday::1:0:15898", -- Small Red Rocket
	[21558]="25:6:15:1:20:Holiday::1:0:15898", -- Small Blue Rocket
	[21559]="25:6:15:1:20:Holiday::1:0:15898", -- Small Green Rocket
	[21561]="0:6:15:1:20:Holiday::1:0:", -- Small White Rocket
	[21562]="0:6:15:1:20:Holiday::1:0:", -- Small Yellow Rocket
	[21563]="0:0:4:4:1:Ring::1:0:13216,13217,13218,13219", -- Don Rodrigo's Band
	[21565]="0:0:4:3:1:Trinket::1:0:14753,14754", -- Rune of Perfection
	[21566]="0:0:4:3:1:Trinket::1:0:14753,14754", -- Rune of Perfection
	[21567]="0:0:4:3:1:Trinket::1:0:14753,14754", -- Rune of Duty
	[21568]="0:0:4:3:1:Trinket::1:0:14753,14754", -- Rune of Duty
	[21569]="0:0:15:1:1:Holiday::1:0:", -- Firework Launcher
	[21570]="0:0:15:1:20:Holiday::1:0:", -- Cluster Launcher
	[21571]="100:25:15:1:20:Holiday::1:0:15898", -- Blue Rocket Cluster
	[21574]="100:25:15:1:20:Holiday::1:0:15898", -- Green Rocket Cluster
	[21576]="100:25:15:1:20:Holiday::1:0:15898", -- Red Rocket Cluster
	[21579]="0:108030:4:4:1:Trinket::1:0:", -- Vanquished Tentacle of C'Thun
	[21581]="0:31789:4:4:1:Plate::1:0:", -- Gauntlets of Annihilation
	[21582]="0:18128:4:4:1:Cloth::1:0:", -- Grasp of the Old God
	[21583]="0:27295:4:4:1:Cloak::1:0:", -- Cloak of Clarity
	[21585]="0:18333:4:4:1:Cloth::1:0:", -- Dark Storm Gauntlets
	[21586]="0:23611:4:4:1:Leather::1:0:", -- Belt of Never-ending Agony
	[21587]="0:53413:4:4:1:Plate::1:0:", -- Wristguards of Castigation
	[21588]="0:80408:4:4:1:Mail::1:0:", -- Wristguards of Elemental Fury
	[21589]="0:12:15:1:20:Holiday::1:0:", -- Large Blue Rocket
	[21590]="0:12:15:1:20:Holiday::1:0:", -- Large Green Rocket
	[21592]="0:12:15:1:20:Holiday::1:0:", -- Large Red Rocket
	[21593]="0:12:15:1:20:Holiday::1:0:", -- Large White Rocket
	[21595]="0:12:15:1:20:Holiday::1:0:", -- Large Yellow Rocket
	[21596]="0:89033:4:4:1:Ring::1:0:", -- Ring of the Godslayer
	[21597]="0:72651:4:4:1:OffHandFrill::1:0:", -- Royal Scepter of Vek'lor
	[21598]="0:29215:4:4:1:Plate::1:0:", -- Royal Qiraji Belt
	[21599]="0:24994:4:4:1:Mail::1:0:", -- Vek'lor's Gloves of Devastation
	[21600]="0:25090:4:4:1:Cloth::1:0:", -- Boots of Epiphany
	[21601]="0:79025:4:4:1:Ring::1:0:", -- Ring of Emperor Vek'lor
	[21602]="0:21633:4:4:1:Leather::1:0:", -- Qiraji Execution Bracers
	[21603]="0:63026:2:4:1:Wand::1:0:", -- Wand of Qiraji Nobility
	[21604]="0:17433:4:4:1:Cloth::1:0:", -- Bracelets of Royal Redemption
	[21605]="0:21869:4:4:1:Leather::1:0:", -- Gloves of the Hidden Temple
	[21606]="0:30903:4:4:1:Plate::1:0:", -- Belt of the Fallen Emperor
	[21607]="0:26433:4:4:1:Mail::1:0:", -- Grasp of the Fallen Emperor
	[21608]="0:102777:4:4:1:Amulet::1:0:", -- Amulet of Vek'nilash
	[21609]="0:22184:4:4:1:Leather::1:0:", -- Regenerating Belt of Vek'nilash
	[21610]="0:56995:4:4:1:Shield::1:0:", -- Wormscale Blocker
	[21611]="0:17874:4:4:1:Cloth::1:0:", -- Burrower Bracers
	[21615]="0:24614:4:4:1:Cloth::1:0:", -- Don Rigoberto's Lost Hat
	[21616]="0:59764:2:4:1:Bow::1:0:", -- Huhuran's Stinger
	[21617]="0:19998:4:4:1:Leather::1:0:", -- Wasphide Gauntlets
	[21618]="0:29040:4:4:1:Plate::1:0:", -- Hive Defiler Wristguards
	[21619]="0:16561:4:4:1:Cloth::1:0:", -- Gloves of the Messiah
	[21620]="0:88661:4:4:1:Ring::1:0:", -- Ring of the Martyr
	[21621]="0:25024:4:4:1:Cloak::1:0:", -- Cloak of the Golden Hive
	[21622]="0:83720:2:4:1:OneHandSword::1:0:", -- Sharpened Silithid Femur
	[21623]="0:29577:4:4:1:Plate::1:0:", -- Gauntlets of the Righteous Champion
	[21624]="0:25297:4:4:1:Mail::1:0:", -- Gauntlets of Kalimdor
	[21625]="0:83030:4:4:1:Trinket::1:0:", -- Scarab Brooch
	[21626]="0:50964:4:4:1:Mail::1:0:", -- Slime-coated Leggings
	[21627]="0:25286:4:4:1:Cloak::1:0:", -- Cloak of Untold Secrets
	[21635]="0:100824:2:4:1:Polearm::1:0:", -- Barb of the Sand Reaver
	[21639]="0:42897:4:4:1:Plate::1:0:", -- Pauldrons of the Unrelenting
	[21640]="0:0:15:1:1:Junk::1:0:15864", -- Lunar Festival Fireworks Pack
	[21645]="0:31380:4:4:1:Leather::1:0:", -- Hive Tunneler's Boots
	[21647]="0:86370:4:4:1:Trinket::1:0:", -- Fetish of the Sand Reaver
	[21648]="0:25088:4:4:1:Cloth::1:0:", -- Recomposed Boots
	[21650]="0:79141:2:4:1:OneHandSword::1:0:", -- Ancient Qiraji Ripper
	[21651]="0:47667:4:4:1:Mail::1:0:", -- Scaled Sand Reaver Leggings
	[21652]="0:55824:4:4:1:Plate::1:0:", -- Silithid Carapace Chestguard
	[21663]="0:33225:4:4:1:Cloth::1:0:", -- Robes of the Guardian Saint
	[21664]="0:86443:4:4:1:Amulet::1:0:", -- Barbed Choker
	[21665]="0:31373:4:4:1:Leather::1:0:", -- Mantle of Wicked Revenge
	[21666]="0:91352:4:4:1:OffHandFrill::1:0:", -- Sartura's Might
	[21667]="0:54142:4:4:1:Plate::1:0:", -- Legplates of Blazing Light
	[21668]="0:46588:4:4:1:Mail::1:0:", -- Scaled Leggings of Qiraji Fury
	[21669]="0:29227:4:4:1:Leather::1:0:", -- Creeping Vine Helm
	[21670]="0:80303:4:4:1:Trinket::1:0:", -- Badge of the Swarmguard
	[21671]="0:31415:4:4:1:Cloth::1:0:", -- Robes of the Battleguard
	[21672]="0:19707:4:4:1:Leather::1:0:", -- Gloves of Enforcement
	[21673]="0:79132:2:4:1:FistWeapon::1:0:", -- Silithid Claw
	[21674]="0:27960:4:4:1:Plate::1:0:", -- Gauntlets of Steadfast Determination
	[21675]="0:19933:4:4:1:Leather::1:0:", -- Thick Qirajihide Belt
	[21676]="0:32009:4:4:1:Cloth::1:0:", -- Leggings of the Festering Swarm
	[21677]="0:96853:4:4:1:Ring::1:0:", -- Ring of the Qiraji Fury
	[21678]="0:99641:4:4:1:Amulet::1:0:", -- Necklace of Purity
	[21679]="0:106933:2:4:1:TwoHandSword::1:0:", -- Kalimdor's Revenge
	[21680]="0:41536:4:4:1:Leather::1:0:", -- Vest of Swift Execution
	[21681]="0:91369:4:4:1:Ring::1:0:", -- Ring of the Devoured
	[21682]="0:20921:4:4:1:Leather::1:0:", -- Bile-Covered Gauntlets
	[21683]="0:44157:4:4:1:Plate::1:0:", -- Mantle of the Desert Crusade
	[21684]="0:38221:4:4:1:Mail::1:0:", -- Mantle of the Desert's Fury
	[21685]="0:87120:4:4:1:Trinket::1:0:", -- Petrified Scarab
	[21686]="0:25548:4:4:1:Cloth::1:0:", -- Mantle of Phrenic Power
	[21687]="0:102995:4:4:1:Ring::1:0:", -- Ukko's Ring of Darkness
	[21688]="0:40213:4:4:1:Plate::1:0:", -- Boots of the Fallen Hero
	[21689]="0:19260:4:4:1:Leather::1:0:", -- Gloves of Ebru
	[21690]="0:73749:4:4:1:Amulet::1:0:", -- Angelista's Charm
	[21691]="0:27324:4:4:1:Plate::1:0:", -- Ooze-ridden Gauntlets
	[21692]="0:27429:4:4:1:Plate::1:0:", -- Triad Girdle
	[21693]="0:29332:4:4:1:Leather::1:0:", -- Guise of the Devourer
	[21694]="0:23555:4:4:1:Cloth::1:0:", -- Ternary Mantle
	[21695]="0:90277:4:4:1:Ring::1:0:", -- Angelista's Touch
	[21696]="0:31641:4:4:1:Cloth::1:0:", -- Robes of the Triumvirate
	[21697]="0:23819:4:4:1:Cloak::1:0:", -- Cape of the Trinity
	[21698]="0:38927:4:4:1:Leather::1:0:", -- Leggings of Immersion
	[21699]="0:36256:4:4:1:Mail::1:0:", -- Barrage Shoulders
	[21700]="0:90535:4:4:1:Amulet::1:0:", -- Pendant of the Qiraji Guardian
	[21701]="0:24238:4:4:1:Cloak::1:0:", -- Cloak of Concentrated Hatred
	[21702]="0:78630:4:4:1:Amulet::1:0:", -- Amulet of Foul Warding
	[21703]="0:101707:2:4:1:TwoHandMace::1:0:", -- Hammer of Ji'zhi
	[21704]="0:42787:4:4:1:Plate::1:0:", -- Boots of the Redeemed Prophecy
	[21705]="0:37039:4:4:1:Mail::1:0:", -- Boots of the Fallen Prophet
	[21706]="0:43087:4:4:1:Plate::1:0:", -- Boots of the Unwavering Will
	[21707]="0:85399:4:4:1:Ring::1:0:", -- Ring of Swarming Thought
	[21708]="0:18740:4:4:1:Leather::1:0:", -- Beetle Scaled Wristguards
	[21709]="0:113642:4:4:1:Ring::1:0:", -- Ring of the Fallen God
	[21710]="0:26680:4:4:1:Cloak::1:0:", -- Cloak of the Fallen God
	[21711]="0:0:0:1:1:Consumable::1:0:", -- Lunar Festival Invitation
	[21712]="0:115200:4:4:1:Amulet::1:0:", -- Amulet of the Fallen God
	[21713]="1000:250:2:1:1:Miscellaneous::1:0:15864", -- Elune's Candle
	[21714]="0:50:15:1:20:Holiday::1:0:", -- Large Blue Rocket Cluster
	[21715]="0:78119:2:4:1:OneHandMace::1:0:", -- Sand Polished Hammer
	[21716]="0:50:15:1:20:Holiday::1:0:", -- Large Green Rocket Cluster
	[21718]="0:50:15:1:20:Holiday::1:0:", -- Large Red Rocket Cluster
	[21721]="15:3:0:1:10:FoodDrink::1:0:15898", -- Moonglow
	[21722]="0:1250:9:2:1:Tailoring::1:0:", -- Pattern: Festival Dress
	[21723]="0:1250:9:2:1:Tailoring::1:0:", -- Pattern: Festival Suit
	[21724]="0:175:9:2:1:Engineering::1:0:", -- Schematic: Small Blue Rocket
	[21725]="0:175:9:2:1:Engineering::1:0:", -- Schematic: Small Green Rocket
	[21726]="0:175:9:2:1:Engineering::1:0:", -- Schematic: Small Red Rocket
	[21727]="0:275:9:2:1:Engineering::1:0:", -- Schematic: Large Blue Rocket
	[21728]="0:275:9:2:1:Engineering::1:0:", -- Schematic: Large Green Rocket
	[21729]="0:275:9:2:1:Engineering::1:0:", -- Schematic: Large Red Rocket
	[21730]="0:875:9:2:1:Engineering::1:0:", -- Schematic: Blue Rocket Cluster
	[21731]="0:875:9:2:1:Engineering::1:0:", -- Schematic: Green Rocket Cluster
	[21732]="0:875:9:2:1:Engineering::1:0:", -- Schematic: Red Rocket Cluster
	[21733]="0:4000:9:2:1:Engineering::1:0:", -- Schematic: Large Blue Rocket Cluster
	[21734]="0:4000:9:2:1:Engineering::1:0:", -- Schematic: Large Green Rocket Cluster
	[21735]="0:4000:9:2:1:Engineering::1:0:", -- Schematic: Large Red Rocket Cluster
	[21737]="0:4000:9:2:1:Engineering::1:0:", -- Schematic: Cluster Launcher
	[21738]="0:875:9:2:1:Engineering::1:0:", -- Schematic: Firework Launcher
	[21740]="0:0:15:1:1:Junk::1:0:15909", -- Small Rocket Recipes
	[21741]="0:0:15:1:1:Junk::1:0:15909", -- Cluster Rocket Recipes
	[21742]="0:0:15:1:1:Junk::1:0:15909", -- Large Rocket Recipes
	[21743]="0:0:15:1:1:Junk::1:0:15909", -- Large Cluster Rocket Recipes
	[21744]="0:0:0:1:20:Consumable::1:0:", -- Lucky Rocket Cluster
	[21745]="0:0:0:1:20:Consumable::1:0:", -- Elder's Moonstone
	[21746]="0:0:15:1:1:Junk::1:0:", -- Lucky Red Envelope
	[21747]="300:75:15:1:20:Holiday::1:0:15898", -- Festival Firecracker
	[21748]="0:1500:4:2:1:Trinket::1:0:", -- Figurine - Jade Owl
	[21749]="0:0:12:2:1:::1:0:", -- Combat Task Briefing I
	[21750]="0:0:12:2:1:::1:0:", -- Combat Task Briefing II
	[21751]="0:0:12:2:1:::1:0:", -- Tactical Task Briefing III
	[21752]="0:1250:7:1:20:Jewelcrafting:755:1:0:", -- Thorium Setting
	[21753]="0:5000:4:3:1:Ring::1:0:", -- Gem Studded Band
	[21754]="0:4307:4:2:1:Ring::1:0:", -- The Aquamarine Ward
	[21755]="0:4307:4:2:1:Amulet::1:0:", -- Aquamarine Pendant of the Warrior
	[21756]="0:1500:4:2:1:Trinket::1:0:", -- Figurine - Golden Hare
	[21757]="0:0:12:1:10:::1:0:", -- Grimscale Murloc Head
	[21758]="0:1500:4:2:1:Trinket::1:0:", -- Figurine - Black Pearl Panther
	[21760]="0:1500:4:2:1:Trinket::1:0:", -- Figurine - Truesilver Crab
	[21761]="0:0:13:1:20:::1:0:", -- Scarab Coffer Key
	[21762]="0:0:13:1:20:::1:0:", -- Greater Scarab Coffer Key
	[21763]="0:1500:4:2:1:Trinket::1:0:", -- Figurine - Truesilver Boar
	[21764]="0:6420:4:2:1:Amulet::1:0:", -- Ruby Pendant of Fire
	[21765]="0:2542:4:2:1:Ring::1:0:", -- Truesilver Healing Ring
	[21766]="0:7500:4:3:1:Amulet::1:0:", -- Opal Necklace of Impact
	[21767]="0:8375:4:2:1:Ring::1:0:", -- Simple Opal Ring
	[21768]="0:12500:4:3:1:Ring::1:0:", -- Sapphire Signet
	[21769]="0:1500:4:2:1:Trinket::1:0:", -- Figurine - Ruby Serpent
	[21770]="0:0:12:1:1:::1:0:", -- Ring of Mmmrrrggglll
	[21771]="0:0:12:1:10:::1:0:", -- Captain Kelisendra's Cargo
	[21774]="0:11416:4:3:1:Cloth::1:0:", -- Emerald Crown of Destruction
	[21775]="0:8375:4:2:1:Ring::1:0:", -- Onslaught Ring
	[21776]="0:0:12:1:1:::1:0:", -- Captain Kelisendra's Lost Rutters
	[21777]="0:3750:4:2:1:Trinket::1:0:", -- Figurine - Emerald Owl
	[21778]="0:18662:4:2:1:Ring::1:0:", -- Ring of Bitter Shadows
	[21779]="0:21305:4:3:1:Ring::1:0:", -- Band of Natural Fire
	[21780]="0:15216:4:3:1:Cloth::1:0:", -- Blood Crown
	[21781]="0:0:12:1:1:::1:0:", -- Thaelis's Head
	[21783]="0:0:12:1:1:::1:0:", -- Magister Duskwither's Journal
	[21784]="0:15000:4:3:1:Trinket::1:0:", -- Figurine - Black Diamond Crab
	[21789]="0:15000:4:3:1:Trinket::1:0:", -- Figurine - Dark Iron Scorpid
	[21790]="0:7767:4:2:1:Amulet::1:0:", -- Sapphire Pendant of Winter Night
	[21791]="0:12503:4:3:1:Amulet::1:0:", -- Living Emerald Pendant
	[21792]="0:25218:4:3:1:Amulet::1:0:", -- Necklace of the Diamond Tower
	[21793]="0:25914:4:3:1:Amulet::1:0:", -- Arcanite Sword Pendant
	[21800]="0:39523:2:3:1:Gun::1:0:", -- Silithid Husked Launcher
	[21801]="0:39677:2:3:1:Wand::1:0:", -- Antenna of Invigoration
	[21802]="0:53107:2:3:1:Dagger::1:0:", -- The Lost Kris of Zedd
	[21803]="0:27935:4:3:1:Plate::1:0:", -- Helm of the Holy Avenger
	[21804]="0:24080:4:3:1:Mail::1:0:", -- Coif of Elemental Fury
	[21805]="0:28147:4:3:1:Plate::1:0:", -- Polished Obsidian Pauldrons
	[21806]="0:69942:2:3:1:TwoHandMace::1:0:", -- Gavel of Qiraji Authority
	[21807]="0:0:12:1:1:::1:0:", -- Unmarked Letter
	[21808]="0:0:12:1:10:::1:0:", -- Arcane Core
	[21809]="0:48655:4:3:1:Amulet::1:0:", -- Fury of the Forgotten Swarm
	[21810]="0:17039:4:3:1:Cloth::1:0:", -- Treads of the Wandering Nomad
	[21812]="0:0:15:1:1:Junk::1:0:", -- Box of Chocolates
	[21813]="0:0:15:1:1:Junk::1:0:", -- Bag of Candies
	[21814]="0:56555:4:4:1:Plate::1:0:", -- Breastplate of Annihilation
	[21815]="10:0:15:1:10:Junk::10:0:5111,6735,6737,6740,6741,6746,7733", -- Love Token
	[21816]="0:0:15:1:1:Holiday::1:0:", -- Heart Candy
	[21817]="0:0:15:1:1:Holiday::1:0:", -- Heart Candy
	[21818]="0:0:15:1:1:Holiday::1:0:", -- Heart Candy
	[21819]="0:0:15:1:1:Holiday::1:0:", -- Heart Candy
	[21820]="0:0:15:1:1:Holiday::1:0:", -- Heart Candy
	[21821]="0:0:15:1:1:Holiday::1:0:", -- Heart Candy
	[21822]="0:0:15:1:1:Holiday::1:0:", -- Heart Candy
	[21823]="0:0:15:1:1:Holiday::1:0:", -- Heart Candy
	[21829]="100:25:15:1:1:Holiday::1:0:5111,6735,6737,6740,6741,6746,7733", -- Perfume Bottle
	[21830]="0:0:15:1:10:Holiday::1:0:", -- Empty Wrapper
	[21831]="0:0:15:1:1:Holiday::1:0:", -- Wrappered Gift
	[21833]="100:25:15:1:1:Holiday::1:0:5111,6735,6737,6740,6741,6746,7733", -- Cologne Bottle
	[21835]="1500:375:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,12096,12097,15175,16268,16588,16683,16829,18006,18019,18802,19013,19014,19049,19239,19679,20081,20121,20194,20915,20986,22479,23145,23373,23732,24148,24313,24349,24357,24780,25043,25736,26382,26568,26598,26900,26945,26950,27031,27038,27053,27089,27133,27149,27176,27186,28347,28832,28869,29015,29037,29535,29909,29922,29947,29961,29968,30010,30069,30239,30244,30306,30438,31115,32639,32641", -- Anesthetic Poison
	[21836]="0:96853:4:4:1:Ring::1:0:", -- Ritssyn's Ring of Chaos
	[21837]="0:79716:2:4:1:OneHandMace::1:0:", -- Anubisath Warhammer
	[21838]="0:31996:4:4:1:Cloth::1:0:", -- Garb of Royal Ascension
	[21839]="0:92916:2:4:1:OneHandMace::1:0:", -- Scepter of the False Prophet
	[21840]="0:4000:7:1:20:Cloth:202,197:1:0:", -- Bolt of Netherweave
	[21841]="0:10000:1:2:1:Bag::1:0:", -- Netherweave Bag
	[21842]="0:8000:7:2:20:Cloth:197:1:0:", -- Bolt of Imbued Netherweave
	[21843]="0:10000:1:2:1:Bag::1:0:", -- Imbued Netherweave Bag
	[21844]="0:8000:7:1:20:Cloth:165,197:1:0:", -- Bolt of Soulcloth
	[21845]="0:4000:7:3:20:Cloth:197:1:0:", -- Primal Mooncloth
	[21846]="0:21632:4:4:1:Cloth::1:0:", -- Spellfire Belt
	[21847]="0:21712:4:4:1:Cloth::1:0:", -- Spellfire Gloves
	[21848]="0:43584:4:4:1:Cloth::1:0:", -- Spellfire Robe
	[21849]="0:12261:4:2:1:Cloth::1:0:", -- Netherweave Bracers
	[21850]="0:12306:4:2:1:Cloth::1:0:", -- Netherweave Belt
	[21851]="0:13059:4:2:1:Cloth::1:0:", -- Netherweave Gloves
	[21852]="0:26926:4:2:1:Cloth::1:0:", -- Netherweave Pants
	[21853]="0:21336:4:2:1:Cloth::1:0:", -- Netherweave Boots
	[21854]="0:29267:4:2:1:Cloth::1:0:", -- Netherweave Robe
	[21855]="0:30091:4:2:1:Cloth::1:0:", -- Netherweave Tunic
	[21856]="0:99282:2:4:1:TwoHandAxe::1:0:", -- "Neretzek, The Blood Drinker"
	[21858]="0:20000:1:3:1:EnchantingBag::1:0:", -- Spellfire Bag
	[21859]="0:31883:4:3:1:Cloth::1:0:", -- Imbued Netherweave Pants
	[21860]="0:24616:4:3:1:Cloth::1:0:", -- Imbued Netherweave Boots
	[21861]="0:34308:4:3:1:Cloth::1:0:", -- Imbued Netherweave Robe
	[21862]="0:34437:4:3:1:Cloth::1:0:", -- Imbued Netherweave Tunic
	[21863]="0:20474:4:4:1:Cloth::1:0:", -- Soulcloth Gloves
	[21864]="0:30824:4:4:1:Cloth::1:0:", -- Soulcloth Shoulders
	[21865]="0:41251:4:4:1:Cloth::1:0:", -- Soulcloth Vest
	[21866]="0:17197:4:3:1:Cloth::1:0:", -- Arcanoweave Bracers
	[21867]="0:26309:4:3:1:Cloth::1:0:", -- Arcanoweave Boots
	[21868]="0:35486:4:3:1:Cloth::1:0:", -- Arcanoweave Robe
	[21869]="0:32801:4:4:1:Cloth::1:0:", -- Frozen Shadoweave Shoulders
	[21870]="0:32921:4:4:1:Cloth::1:0:", -- Frozen Shadoweave Boots
	[21871]="0:44055:4:4:1:Cloth::1:0:", -- Frozen Shadoweave Robe
	[21872]="0:40000:1:3:1:SoulBag::1:0:", -- Ebon Shadowbag
	[21873]="0:24089:4:4:1:Cloth::1:0:", -- Primal Mooncloth Belt
	[21874]="0:33398:4:4:1:Cloth::1:0:", -- Primal Mooncloth Shoulders
	[21875]="0:46852:4:4:1:Cloth::1:0:", -- Primal Mooncloth Robe
	[21876]="0:50000:1:3:1:Bag::1:0:", -- Primal Mooncloth Bag
	[21877]="0:800:7:1:20:Cloth:164,202,129,197:1:0:", -- Netherweave Cloth
	[21881]="0:5000:7:1:10:Cloth:197:1:0:", -- Netherweb Spider Silk
	[21882]="0:2500:7:1:20:Other:197:1:0:", -- Soul Essence
	[21884]="0:4000:7:2:20:Elemental:171,164,333,202,755,165,186,197:1:0:", -- Primal Fire
	[21885]="0:4000:7:2:20:Elemental:171,164,333,202,755,165,197:1:0:", -- Primal Water
	[21886]="0:4000:7:2:20:Elemental:171,164,333,202,755,165,197,773:1:0:", -- Primal Life
	[21887]="5000:1250:7:1:20:Leather:164,202,165,197:1:1:14846", -- Knothide Leather
	[21888]="0:15430:4:4:1:Cloth::1:0:", -- Gloves of the Immortal
	[21889]="0:28578:4:4:1:Plate::1:0:", -- Gloves of the Redeemed Prophecy
	[21890]="0:24445:4:4:1:Mail::1:0:", -- Gloves of the Fallen Prophet
	[21891]="0:99378:4:4:1:Trinket::1:0:", -- Shard of the Fallen Star
	[21892]="40000:10000:9:1:1:Tailoring::1:0:16638,16767,19213", -- Pattern: Bolt of Imbued Netherweave
	[21893]="40000:10000:9:1:1:Tailoring::1:0:19015,19213", -- Pattern: Imbued Netherweave Bag
	[21894]="40000:10000:9:1:1:Tailoring::1:1:16638,16767,19015,19017", -- Pattern: Bolt of Soulcloth
	[21895]="40000:10000:9:1:1:Tailoring::1:0:22208,29512", -- Pattern: Primal Mooncloth
	[21896]="40000:10000:9:1:1:Tailoring::1:0:16638,16767,19213", -- Pattern: Netherweave Robe
	[21897]="40000:10000:9:1:1:Tailoring::1:0:16638,16767,19213", -- Pattern: Netherweave Tunic
	[21898]="60000:15000:9:1:1:Tailoring::1:1:18011,19722", -- Pattern: Imbued Netherweave Pants
	[21899]="60000:15000:9:1:1:Tailoring::1:1:18011,19722", -- Pattern: Imbued Netherweave Boots
	[21900]="60000:15000:9:1:1:Tailoring::1:1:19521", -- Pattern: Imbued Netherweave Robe
	[21901]="60000:15000:9:1:1:Tailoring::1:1:19521", -- Pattern: Imbued Netherweave Tunic
	[21902]="80000:20000:9:1:1:Tailoring::1:1:19015,19017", -- Pattern: Soulcloth Gloves
	[21903]="0:15000:9:4:1:Tailoring::1:0:", -- Pattern: Soulcloth Shoulders
	[21904]="0:15000:9:4:1:Tailoring::1:0:", -- Pattern: Soulcloth Vest
	[21905]="0:15000:9:2:1:Tailoring::1:0:", -- Pattern: Arcanoweave Bracers
	[21906]="0:15000:9:2:1:Tailoring::1:0:", -- Pattern: Arcanoweave Boots
	[21907]="0:20000:9:2:1:Tailoring::1:0:", -- Pattern: Arcanoweave Robe
	[21908]="60000:15000:9:1:1:Tailoring::1:0:22213,29511", -- Pattern: Spellfire Belt
	[21909]="60000:15000:9:1:1:Tailoring::1:0:22213,29511", -- Pattern: Spellfire Gloves
	[21910]="60000:15000:9:1:1:Tailoring::1:0:22213,29511", -- Pattern: Spellfire Robe
	[21911]="60000:15000:9:3:1:Tailoring::1:0:22213,29511", -- Pattern: Spellfire Bag
	[21912]="60000:15000:9:1:1:Tailoring::1:0:22212,29510", -- Pattern: Frozen Shadoweave Shoulders
	[21913]="60000:15000:9:1:1:Tailoring::1:0:22212,29510", -- Pattern: Frozen Shadoweave Robe
	[21914]="60000:15000:9:1:1:Tailoring::1:0:22212,29510", -- Pattern: Frozen Shadoweave Boots
	[21915]="60000:0:9:3:1:Tailoring::1:0:22212,29510", -- Pattern: Ebon Shadowbag
	[21916]="60000:15000:9:1:1:Tailoring::1:0:22208,29512", -- Pattern: Primal Mooncloth Belt
	[21917]="60000:15000:9:1:1:Tailoring::1:0:22208,29512", -- Pattern: Primal Mooncloth Robe
	[21918]="60000:15000:9:1:1:Tailoring::1:0:22208,29512", -- Pattern: Primal Mooncloth Shoulders
	[21919]="60000:15000:9:3:1:Tailoring::1:0:22208,29512", -- Pattern: Primal Mooncloth Bag
	[21920]="0:0:15:1:1:Junk::1:0:", -- Creased Letter
	[21921]="0:0:15:1:1:Junk::1:0:", -- Carefully Penned Note
	[21925]="0:0:15:1:1:Junk::1:0:", -- Immaculate Letter
	[21926]="0:0:15:1:1:Junk::1:0:", -- Slightly Creased Note
	[21927]="1500:375:0:1:20:EnhTemp::1:0:1325,1326,2622,3090,3334,3561,3969,4585,5169,15175,16268,16588,16683,18019,19013,19049,19239,20194,23145,23732,24148,24313,24349,24357,24780,26568,26945,26950,27031,27053,27089,27149,28347,28832,28869,29037,29535,29909,29922,29947,29961,30010,30069,30239,30244,30306,30438,31115,32639,32641", -- Instant Poison VII
	[21928]="0:0:12:1:20:::1:0:", -- Winterspring Blood Sample
	[21929]="0:2500:3:2:20:GemOrange:202,755:1:0:", -- Flame Spessarite
	[21931]="0:250:4:2:1:Ring::1:0:", -- Woven Copper Ring
	[21932]="0:250:4:2:1:Ring::1:0:", -- Heavy Copper Ring
	[21933]="0:750:4:2:1:Amulet::1:0:", -- Thick Bronze Necklace
	[21934]="0:1500:4:2:1:Amulet::1:0:", -- Ornate Tigerseye Necklace
	[21935]="0:0:12:1:20:::1:0:", -- Stable Ectoplasm
	[21936]="0:0:12:1:20:::1:0:", -- Frozen Ectoplasm
	[21937]="0:0:12:1:20:::1:0:", -- Scorched Ectoplasm
	[21938]="0:0:12:1:1:::1:0:", -- Magma Core
	[21939]="400000:100000:12:1:1:::1:0:16015", -- Fel Elemental Rod
	[21940]="0:1250:9:2:1:Jewelcrafting::1:0:", -- Design: Golden Hare
	[21941]="5000:1250:9:1:1:Jewelcrafting::1:1:989,4897", -- Design: Black Pearl Panther
	[21942]="6000:1500:9:1:1:Jewelcrafting::1:1:2810,2821", -- Design: Ruby Crown of Restoration
	[21943]="6000:1500:9:1:1:Jewelcrafting::1:1:1148,4897", -- Design: Truesilver Crab
	[21944]="0:1875:9:2:1:Jewelcrafting::1:0:", -- Design: Truesilver Boar
	[21945]="0:1875:9:2:1:Jewelcrafting::1:0:", -- Design: The Aquamarine Ward
	[21946]="0:0:12:1:1:::1:0:", -- Ectoplasmic Distiller
	[21947]="0:1875:9:2:1:Jewelcrafting::1:0:", -- Design: Gem Studded Band
	[21948]="7500:1875:9:1:1:Jewelcrafting::1:1:5163,8363,16624,17512", -- Design: Opal Necklace of Impact
	[21949]="0:2500:9:2:1:Jewelcrafting::1:0:", -- Design: Ruby Serpent
	[21952]="10000:2500:9:1:1:Jewelcrafting::1:1:15179", -- Design: Emerald Crown of Destruction
	[21953]="0:3125:9:2:1:Jewelcrafting::1:0:", -- Design: Emerald Owl
	[21954]="10000:2500:9:1:1:Jewelcrafting::1:1:12941", -- Design: Ring of Bitter Shadows
	[21955]="0:0:9:2:1:Jewelcrafting::1:0:", -- Design: Black Diamond Crab
	[21956]="0:0:9:2:1:Jewelcrafting::1:0:", -- Design: Dark Iron Scorpid
	[21957]="13500:3375:9:1:1:Jewelcrafting::1:1:11189", -- Design: Necklace of the Diamond Tower
	[21960]="0:0:15:1:20:Holiday::1:0:", -- Handmade Woodcraft
	[21975]="0:0:15:1:1:Holiday::1:0:", -- Pledge of Adoration: Stormwind
	[21979]="0:0:15:1:1:Holiday::1:0:", -- Gift of Adoration: Darnassus
	[21980]="0:0:15:1:1:Holiday::1:0:", -- Gift of Adoration: Ironforge
	[21981]="0:0:15:1:1:Holiday::1:0:", -- Gift of Adoration: Stormwind
	[21982]="0:0:12:1:25:::1:0:", -- Ogre Warbeads
	[21983]="0:0:12:1:1:::1:0:", -- Incomplete Banner of Provocation
	[21984]="0:0:12:1:1:::1:0:", -- Left Piece of Lord Valthalak's Amulet
	[21985]="0:0:12:1:1:::1:0:", -- Sealed Blood Container
	[21986]="0:0:12:1:1:::1:0:", -- Banner of Provocation
	[21987]="0:0:12:1:1:::1:0:", -- Incendicite of Incendius
	[21988]="0:0:12:1:1:::1:0:", -- Ember of Emberseer
	[21989]="0:0:12:1:1:::1:0:", -- Cinder of Cynders
	[21990]="0:1275:0:1:20:Bandage::1:0:", -- Netherweave Bandage
	[21991]="0:3000:0:1:20:Bandage::1:0:", -- Heavy Netherweave Bandage
	[21992]="20000:5000:9:1:1:FirstAid::1:0:18990,18991,26947", -- Manual: Netherweave Bandage
	[21993]="40000:10000:9:1:1:FirstAid::1:0:18990,18991,26947", -- Manual: Heavy Netherweave Bandage
	[21994]="0:18406:4:3:1:Plate::1:0:", -- Belt of Heroism
	[21995]="0:34276:4:4:1:Plate::1:0:", -- Boots of Heroism
	[21996]="0:18543:4:3:1:Plate::1:0:", -- Bracers of Heroism
	[21997]="0:46128:4:4:1:Plate::1:0:", -- Breastplate of Heroism
	[21998]="0:17731:4:4:1:Plate::1:0:", -- Gauntlets of Heroism
	[21999]="0:34787:4:4:1:Plate::1:0:", -- Helm of Heroism
	[22000]="0:37912:4:3:1:Plate::1:0:", -- Legplates of Heroism
	[22001]="0:28117:4:3:1:Plate::1:0:", -- Spaulders of Heroism
	[22002]="0:13464:4:3:1:Leather::1:0:", -- Darkmantle Belt
	[22003]="0:25261:4:4:1:Leather::1:0:", -- Darkmantle Boots
	[22004]="0:13913:4:3:1:Leather::1:0:", -- Darkmantle Bracers
	[22005]="0:26102:4:4:1:Leather::1:0:", -- Darkmantle Cap
	[22006]="0:12034:4:4:1:Leather::1:0:", -- Darkmantle Gloves
	[22007]="0:25791:4:3:1:Leather::1:0:", -- Darkmantle Pants
	[22008]="0:19166:4:3:1:Leather::1:0:", -- Darkmantle Spaulders
	[22009]="0:31970:4:4:1:Leather::1:0:", -- Darkmantle Tunic
	[22010]="0:15451:4:3:1:Mail::1:0:", -- Beastmaster's Belt
	[22011]="0:15508:4:3:1:Mail::1:0:", -- Beastmaster's Bindings
	[22012]="50000:12500:9:1:1:FirstAid::1:0:18990,18991,26947", -- Master First Aid - Doctor in the House
	[22013]="0:29212:4:4:1:Mail::1:0:", -- Beastmaster's Cap
	[22014]="1333333:333333:12:1:1:::1:0:10856,10857,11536", -- Hallowed Brazier
	[22015]="0:14941:4:4:1:Mail::1:0:", -- Beastmaster's Gloves
	[22016]="0:23809:4:3:1:Mail::1:0:", -- Beastmaster's Mantle
	[22017]="0:32137:4:3:1:Mail::1:0:", -- Beastmaster's Pants
	[22018]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Glacier Water
	[22019]="0:0:0:1:20:FoodDrink::1:0:", -- Conjured Croissant
	[22044]="0:0:0:1:1:Consumable::1:0:", -- Mana Emerald
	[22046]="0:0:12:1:1:::1:0:", -- Right Piece of Lord Valthalak's Amulet
	[22047]="0:0:12:1:1:::1:0:", -- Top Piece of Lord Valthalak's Amulet
	[22048]="0:0:12:1:1:::1:0:", -- Lord Valthalak's Amulet
	[22049]="0:0:12:1:1:::1:0:", -- Brazier of Beckoning
	[22050]="0:0:12:1:1:::1:0:", -- Brazier of Beckoning
	[22051]="0:0:12:1:1:::1:0:", -- Brazier of Beckoning
	[22052]="0:0:12:1:1:::1:0:", -- Brazier of Beckoning
	[22053]="1000:250:0:1:20:EnhTemp::1:0:1325,1326,1457,2622,3090,3135,3334,3490,3542,3551,3561,3969,4585,5139,5169,6779,12096,12097,15175,16268,16588,16683,16829,18006,18019,18802,19013,19014,19049,19239,19679,20081,20121,20194,20915,20986,22479,23145,23373,23732,24148,24313,24349,24357,24780,25043,25736,26382,26568,26598,26900,26945,26950,27031,27038,27053,27089,27133,27149,27176,27186,28347,28832,28869,29015,29037,29535,29909,29922,29947,29961,29968,30010,30069,30239,30244,30306,30438,31115,32639,32641", -- Deadly Poison VI
	[22054]="1500:375:0:1:20:EnhTemp::1:0:1325,1326,2622,3090,3334,3561,3969,4585,5169,15175,16268,16588,16683,18019,19013,19049,19239,20194,23145,23732,24148,24313,24349,24357,24780,26568,26945,26950,27031,27053,27089,27149,28347,28832,28869,29037,29535,29909,29922,29947,29961,30010,30069,30239,30244,30306,30438,31115,32639,32641", -- Deadly Poison VII
	[22055]="900:225:0:1:20:EnhTemp::1:0:1325,1326,2622,3090,3334,3561,3969,4585,5169,15175,16268,16588,16683,18019,19013,19049,19239,20194,23145,23732,24148,24313,24349,24357,24780,26568,26945,26950,27031,27053,27089,27149,28347,28832,28869,29037,29535,29909,29922,29947,29961,30010,30069,30239,30244,30306,30438,31115,32639,32641", -- Wound Poison V
	[22056]="0:0:12:1:1:::1:0:", -- Brazier of Beckoning
	[22057]="0:0:12:1:1:::1:0:", -- Brazier of Invocation
	[22058]="0:0:15:1:1:Holiday::1:0:", -- Valentine's Day Stationery
	[22059]="0:0:15:1:1:Junk::1:0:", -- Valentine's Day Card
	[22060]="0:41015:4:4:1:Mail::1:0:", -- Beastmaster's Tunic
	[22061]="0:31009:4:4:1:Mail::1:0:", -- Beastmaster's Boots
	[22062]="0:11049:4:3:1:Cloth::1:0:", -- Sorcerer's Belt
	[22063]="0:11088:4:3:1:Cloth::1:0:", -- Sorcerer's Bindings
	[22064]="0:20800:4:4:1:Cloth::1:0:", -- Sorcerer's Boots
	[22065]="0:20873:4:4:1:Cloth::1:0:", -- Sorcerer's Crown
	[22066]="0:9623:4:4:1:Cloth::1:0:", -- Sorcerer's Gloves
	[22067]="0:20624:4:3:1:Cloth::1:0:", -- Sorcerer's Leggings
	[22068]="0:15749:4:3:1:Cloth::1:0:", -- Sorcerer's Mantle
	[22069]="0:26269:4:4:1:Cloth::1:0:", -- Sorcerer's Robes
	[22070]="0:10578:4:3:1:Cloth::1:0:", -- Deathmist Belt
	[22071]="0:10618:4:3:1:Cloth::1:0:", -- Deathmist Bracers
	[22072]="0:21591:4:3:1:Cloth::1:0:", -- Deathmist Leggings
	[22073]="0:16043:4:3:1:Cloth::1:0:", -- Deathmist Mantle
	[22074]="0:20067:4:4:1:Cloth::1:0:", -- Deathmist Mask
	[22075]="0:26852:4:4:1:Cloth::1:0:", -- Deathmist Robe
	[22076]="0:20213:4:4:1:Cloth::1:0:", -- Deathmist Sandals
	[22077]="0:10299:4:4:1:Cloth::1:0:", -- Deathmist Wraps
	[22078]="0:10891:4:3:1:Cloth::1:0:", -- Virtuous Belt
	[22079]="0:10929:4:3:1:Cloth::1:0:", -- Virtuous Bracers
	[22080]="0:20505:4:4:1:Cloth::1:0:", -- Virtuous Crown
	[22081]="0:10448:4:4:1:Cloth::1:0:", -- Virtuous Gloves
	[22082]="0:16572:4:3:1:Cloth::1:0:", -- Virtuous Mantle
	[22083]="0:27632:4:4:1:Cloth::1:0:", -- Virtuous Robe
	[22084]="0:19333:4:4:1:Cloth::1:0:", -- Virtuous Sandals
	[22085]="0:21034:4:3:1:Cloth::1:0:", -- Virtuous Skirt
	[22086]="0:18341:4:3:1:Plate::1:0:", -- Soulforge Belt
	[22087]="0:34151:4:4:1:Plate::1:0:", -- Soulforge Boots
	[22088]="0:18477:4:3:1:Plate::1:0:", -- Soulforge Bracers
	[22089]="0:45966:4:4:1:Plate::1:0:", -- Soulforge Breastplate
	[22090]="0:17667:4:4:1:Plate::1:0:", -- Soulforge Gauntlets
	[22091]="0:34662:4:4:1:Plate::1:0:", -- Soulforge Helm
	[22092]="0:37780:4:3:1:Plate::1:0:", -- Soulforge Legplates
	[22093]="0:28020:4:3:1:Plate::1:0:", -- Soulforge Spaulders
	[22094]="0:0:12:1:25:::1:0:", -- Bloodkelp
	[22095]="0:16158:4:3:1:Mail::1:0:", -- Bindings of The Five Thunders
	[22096]="0:30451:4:4:1:Mail::1:0:", -- Boots of The Five Thunders
	[22097]="0:30427:4:4:1:Mail::1:0:", -- Coif of The Five Thunders
	[22098]="0:16334:4:3:1:Mail::1:0:", -- Cord of The Five Thunders
	[22099]="0:15558:4:4:1:Mail::1:0:", -- Gauntlets of The Five Thunders
	[22100]="0:30953:4:3:1:Mail::1:0:", -- Kilt of The Five Thunders
	[22101]="0:23106:4:3:1:Mail::1:0:", -- Pauldrons of The Five Thunders
	[22102]="0:38368:4:4:1:Mail::1:0:", -- Vest of The Five Thunders
	[22103]="0:0:0:1:1:Other::1:0:", -- Master Healthstone
	[22104]="0:0:0:1:1:Other::1:0:", -- Master Healthstone
	[22105]="0:0:0:1:1:Other::1:0:", -- Master Healthstone
	[22106]="0:13023:4:3:1:Leather::1:0:", -- Feralheart Belt
	[22107]="0:24438:4:4:1:Leather::1:0:", -- Feralheart Boots
	[22108]="0:13122:4:3:1:Leather::1:0:", -- Feralheart Bracers
	[22109]="0:24619:4:4:1:Leather::1:0:", -- Feralheart Cowl
	[22110]="0:12546:4:4:1:Leather::1:0:", -- Feralheart Gloves
	[22111]="0:26883:4:3:1:Leather::1:0:", -- Feralheart Kilt
	[22112]="0:19976:4:3:1:Leather::1:0:", -- Feralheart Spaulders
	[22113]="0:33313:4:4:1:Leather::1:0:", -- Feralheart Vest
	[22114]="0:0:15:3:1:Companion::1:0:", -- Pink Murloc Egg
	[22115]="0:0:12:1:1:::1:0:", -- Extra-Dimensional Ghost Revealer
	[22116]="0:0:0:1:1:Consumable::1:0:", -- Master Soulstone
	[22117]="0:0:15:1:20:Holiday::1:0:", -- Pledge of Loyalty: Stormwind
	[22119]="0:0:15:1:20:Holiday::1:0:", -- Pledge of Loyalty: Ironforge
	[22120]="0:0:15:1:20:Holiday::1:0:", -- Pledge of Loyalty: Darnassus
	[22121]="0:0:15:1:20:Holiday::1:0:", -- Pledge of Loyalty: Undercity
	[22122]="0:0:15:1:20:Holiday::1:0:", -- Pledge of Loyalty: Thunder Bluff
	[22123]="0:0:15:1:20:Holiday::1:0:", -- Pledge of Loyalty: Orgrimmar
	[22128]="0:0:4:1:1:Miscellaneous::1:0:", -- Master Firestone (DEPRECATED)
	[22131]="0:0:15:1:1:Holiday::1:0:", -- Stormwind Gift Collection
	[22132]="0:0:15:1:1:Holiday::1:0:", -- Ironforge Gift Collection
	[22133]="0:0:15:1:1:Holiday::1:0:", -- Darnassus Gift Collection
	[22134]="0:0:15:1:1:Holiday::1:0:", -- Undercity Gift Collection
	[22135]="0:0:15:1:1:Holiday::1:0:", -- Thunder Bluff Gift Collection
	[22136]="0:0:15:1:1:Holiday::1:0:", -- Orgrimmar Gift Collection
	[22137]="0:12:15:1:1:Junk::1:0:", -- Ysida's Satchel
	[22138]="0:0:12:1:50:::1:0:", -- Blackrock Bracer
	[22139]="0:0:12:1:1:::1:0:", -- Ysida's Locket
	[22140]="0:0:15:1:20:Holiday::1:0:", -- Sentinel's Card
	[22141]="0:0:15:1:20:Holiday::1:0:", -- Ironforge Guard's Card
	[22142]="0:0:15:1:20:Holiday::1:0:", -- Grunt's Card
	[22143]="0:0:15:1:20:Holiday::1:0:", -- Stormwind Guard's Card
	[22144]="0:0:15:1:20:Holiday::1:0:", -- Bluffwatcher's Card
	[22145]="0:0:15:1:20:Holiday::1:0:", -- Guardian's Moldy Card
	[22146]="0:100000:9:3:1:Book::1:0:", -- Book: Gift of the Wild III
	[22147]="5000:1250:15:1:20:Reagent:-11:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24409,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Flintweed Seed
	[22148]="1500:375:15:1:20:Reagent:-11:1:0:958,983,1257,1275,1307,1308,1351,1463,1673,2805,3323,3335,3351,3490,3500,3542,3562,3700,3970,4083,4220,4562,4575,4878,5110,5139,5151,8361,10364,12096,12097,13476,14739,15175,16015,16588,16611,16612,16706,16757,16829,17518,18006,18017,18019,18243,18802,18998,19004,19013,19014,19235,19535,19678,19679,19718,20081,20092,20915,22479,23112,23145,23157,23373,23560,23734,24313,24349,24357,24409,24780,24843,24935,24995,25010,25019,25039,25051,25082,25736,26382,26474,26569,26598,26900,26908,26950,26968,26984,27030,27039,27054,27088,27133,27138,27149,27176,27186,27935,28714,28809,28827,28870,29015,29037,29203,29288,29537,29636,29909,29922,29947,29961,29968,30010,30069,30239,30244,30307,30345,30438,30825,31115,32639,32641,33669,33871", -- Wild Quillvine
	[22149]="0:10283:4:3:1:Amulet::1:0:", -- Beads of Ogre Mojo
	[22150]="0:10283:4:3:1:Amulet::1:0:", -- Beads of Ogre Might
	[22153]="0:100000:9:3:1:Book::1:0:", -- Tome of Arcane Brilliance 2
	[22154]="0:0:15:1:1:Holiday::1:0:", -- Pledge of Adoration: Ironforge
	[22155]="0:0:15:1:1:Holiday::1:0:", -- Pledge of Adoration: Darnassus
	[22156]="0:0:15:1:1:Holiday::1:0:", -- Pledge of Adoration: Orgrimmar
	[22157]="0:0:15:1:1:Holiday::1:0:", -- Pledge of Adoration: Undercity
	[22158]="0:0:15:1:1:Holiday::1:0:", -- Pledge of Adoration: Thunder Bluff
	[22159]="0:0:15:1:1:Holiday::1:0:", -- Pledge of Friendship: Darnassus
	[22160]="0:0:15:1:1:Holiday::1:0:", -- Pledge of Friendship: Ironforge
	[22161]="0:0:15:1:1:Holiday::1:0:", -- Pledge of Friendship: Orgrimmar
	[22162]="0:0:15:1:1:Holiday::1:0:", -- Pledge of Friendship: Thunder Bluff
	[22163]="0:0:15:1:1:Holiday::1:0:", -- Pledge of Friendship: Undercity
	[22164]="0:0:15:1:1:Holiday::1:0:", -- Gift of Adoration: Orgrimmar
	[22165]="0:0:15:1:1:Holiday::1:0:", -- Gift of Adoration: Thunder Bluff
	[22166]="0:0:15:1:1:Holiday::1:0:", -- Gift of Adoration: Undercity
	[22167]="0:0:15:1:1:Holiday::1:0:", -- Gift of Friendship: Darnassus
	[22168]="0:0:15:1:1:Holiday::1:0:", -- Gift of Friendship: Ironforge
	[22169]="0:0:15:1:1:Holiday::1:0:", -- Gift of Friendship: Orgrimmar
	[22170]="0:0:15:1:1:Holiday::1:0:", -- Gift of Friendship: Stormwind
	[22171]="0:0:15:1:1:Holiday::1:0:", -- Gift of Friendship: Thunder Bluff
	[22172]="0:0:15:1:1:Holiday::1:0:", -- Gift of Friendship: Undercity
	[22173]="0:0:15:1:20:Holiday::1:0:", -- Dwarven Homebrew
	[22174]="0:0:15:1:20:Holiday::1:0:", -- Romantic Poem
	[22175]="0:0:15:1:20:Holiday::1:0:", -- Freshly Baked Pie
	[22176]="0:0:15:1:20:Holiday::1:0:", -- Homemade Bread
	[22177]="0:0:15:1:20:Holiday::1:0:", -- Freshly Picked Flowers
	[22178]="0:0:15:1:1:Holiday::1:0:", -- Pledge of Friendship: Stormwind
	[22179]="54000:13500:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Firebolt (Rank 8)
	[22180]="26000:6500:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Blood Pact (Rank 6)
	[22181]="36000:9000:9:1:1:Book::1:0:5520,5749,5750,5753,5815,6027,6328,6373,6374,6376,6382,12776,12807,15494,16267,16649,23535", -- Grimoire of Fire Shield (Rank 6)
	[22182]="67000:16750:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Torment (Rank 7)
	[22183]="32000:8000:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Suffering (Rank 5)
	[22184]="44000:11000:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Consume Shadows (Rank 7)
	[22185]="36000:9000:9:1:1:Book::1:0:5520,5750,5753,5815,6027,6328,6374,6382,12807,16267,16649,23535", -- Grimoire of Sacrifice (Rank 7)
	[22186]="54000:13500:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Lash of Pain (Rank 7)
	[22187]="67000:16750:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Soothing Kiss (Rank 5)
	[22188]="29000:7250:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Devour Magic (Rank 5)
	[22189]="67000:16750:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Devour Magic (Rank 6)
	[22190]="36000:9000:9:1:1:Book::1:0:5520,5753,5815,6382,12807,16267,16649,23535", -- Grimoire of Tainted Blood (Rank 5)
	[22191]="0:47549:4:4:1:Mail::1:0:", -- Obsidian Mail Tunic
	[22192]="0:0:0:1:20:Consumable::1:0:", -- Bloodkelp Elixir of Dodging
	[22193]="0:0:0:1:20:Consumable::1:0:", -- Bloodkelp Elixir of Resistance
	[22194]="0:23455:4:4:1:Mail::1:0:", -- Black Grasp of the Destroyer
	[22195]="0:17221:4:3:1:Mail::1:0:", -- Light Obsidian Belt
	[22196]="0:56466:4:4:1:Plate::1:0:", -- Thick Obsidian Breastplate
	[22197]="0:18915:4:3:1:Plate::1:0:", -- Heavy Obsidian Belt
	[22198]="0:47188:4:4:1:Shield::1:0:", -- Jagged Obsidian Shield
	[22200]="0:0:15:1:20:Junk::1:0:", -- Silver Shafted Arrow
	[22201]="0:0:12:1:1:::1:0:", -- Reliquary of Purity
	[22202]="0:2500:7:1:10:MetalStone:164:1:0:", -- Small Obsidian Shard
	[22203]="0:5000:7:1:10:MetalStone:164:1:0:", -- Large Obsidian Shard
	[22204]="0:12403:4:3:1:Leather::1:0:", -- Wristguards of Renown
	[22205]="0:14998:4:3:1:Plate::1:0:", -- Black Steel Bindings
	[22206]="0:0:4:2:1:OffHandFrill::1:0:", -- Bouquet of Red Roses
	[22207]="0:15047:4:3:1:Mail::1:0:", -- Sash of the Grand Hunt
	[22208]="0:57079:2:3:1:TwoHandMace::1:0:", -- Lavastone Hammer
	[22209]="50000:12500:9:1:1:Blacksmithing::1:0:15176", -- Plans: Heavy Obsidian Belt
	[22212]="0:18636:4:3:1:Mail::1:0:", -- Golem Fitted Pauldrons
	[22214]="50000:12500:9:1:1:Blacksmithing::1:0:15176", -- Plans: Light Obsidian Belt
	[22216]="0:0:12:1:1:::1:0:", -- Venoxis's Venom Sac
	[22217]="0:0:12:1:1:::1:0:", -- Kurinnaxx's Venom Sac
	[22218]="0:0:15:1:20:Holiday::1:0:", -- Handful of Rose Petals
	[22219]="50000:12500:9:1:1:Blacksmithing::1:1:15471", -- Plans: Jagged Obsidian Shield
	[22220]="0:12500:9:3:1:Blacksmithing::1:0:", -- Plans: Black Grasp of the Destroyer
	[22221]="80000:20000:9:1:1:Blacksmithing::1:1:15471", -- Plans: Obsidian Mail Tunic
	[22222]="0:20000:9:3:1:Blacksmithing::1:0:", -- Plans: Thick Obsidian Breastplate
	[22223]="0:19722:4:3:1:Plate::1:0:", -- Foreman's Head Protector
	[22224]="0:0:12:1:1:::1:0:", -- Jeering Spectre's Essence
	[22225]="0:14937:4:3:1:Cloth::1:0:", -- Dragonskin Cowl
	[22226]="0:0:12:1:1:::1:0:", -- Druidical Remains
	[22227]="0:0:12:1:1:::1:0:", -- Starbreeze Village Relic
	[22228]="0:0:12:1:1:::1:0:", -- Brilliant Sword of Zealotry
	[22229]="0:0:12:1:1:::1:0:", -- Soul Ashes of the Banished
	[22231]="0:15880:4:3:1:Cloth::1:0:", -- Kayser's Boots of Precision
	[22232]="0:14421:4:3:1:Mail::1:0:", -- Marksman's Girdle
	[22234]="0:9713:4:3:1:Cloth::1:0:", -- Mantle of Lost Hope
	[22235]="0:0:15:1:1:Companion::1:0:", -- Truesilver Shafted Arrow
	[22236]="0:0:0:1:20:Consumable::1:0:", -- Buttermilk Delight
	[22237]="0:0:0:1:20:Consumable::1:0:", -- Dark Desire
	[22238]="0:0:0:1:20:Consumable::1:0:", -- Very Berry Cream
	[22239]="0:0:0:1:20:Consumable::1:0:", -- Sweet Surprise
	[22240]="0:14972:4:3:1:Mail::1:0:", -- Greaves of Withering Despair
	[22241]="0:15739:4:3:1:Leather::1:0:", -- Dark Warder's Pauldrons
	[22242]="0:11923:4:3:1:Mail::1:0:", -- Verek's Leash
	[22243]="0:250:1:2:1:SoulBag::1:0:", -- Small Soul Pouch
	[22244]="0:1000:1:2:1:SoulBag::1:0:", -- Box of Souls
	[22245]="0:12375:4:3:1:Cloth::1:0:", -- Soot Encrusted Footwear
	[22246]="0:2500:1:2:1:EnchantingBag::1:0:", -- Enchanted Mageweave Pouch
	[22247]="0:16087:4:3:1:Cloth::1:0:", -- Faith Healer's Boots
	[22248]="0:10000:1:2:1:EnchantingBag::1:0:", -- Enchanted Runecloth Bag
	[22249]="0:30000:1:2:1:EnchantingBag::1:0:", -- Big Bag of Enchantment
	[22250]="1000:250:1:2:1:HerbBag::1:0:3405,3548,4216,4615,4899,5138,5503,16367,26568,27053,27141,28727,28828,28868", -- Herb Pouch
	[22251]="0:10000:1:2:1:HerbBag::1:0:", -- Cenarion Herb Bag
	[22252]="0:30000:1:2:1:HerbBag::1:0:", -- Satchel of Cenarius
	[22253