QuestHelper_File["collect_achievement.lua"] = "1.1.18"
QuestHelper_Loadtime["collect_achievement.lua"] = GetTime()

local QHCA

local GetLoc
local Merger

local AchievementDB

--X 0 is a monster kill, asset is the monster ID
--X 1 is winning PvP objectives in a thorough manner (holding all bases, controlling all flags)
--X 7 is weapon skill, asset is probably a skill ID of some sort
--X 8 is another achievement, asset is achievement ID
--X 9 is completing quests globally
--X 10 is completing a daily quest every day
--X 11 is completing quests in specific areas
--X 14 is completing daily quests
--X 27 is a quest, asset is quest ID
--X 28 is getting a spell cast on you, asset is a spell ID
--X 29 is casting a spell (often crafting), asset is a spell ID
--X 30 is PvP objectives (flags, assaulting, defending)
--X 31 is PvP kills in battleground PvP locations
--X 32 is winning ranked arena matches in specific locations (asset is probably a location ID)
--X 34 is the Squashling (owning a specific pet?), asset is the spell ID
--X 35 is PvP kills while under the influence of something
--X 36 is acquiring items (soulbound), asset is an item ID
--X 37 is winning arenas
--X 41 is eating or drinking a specific item, asset is item ID
--X 42 is fishing things up, asset is item ID
--X 43 is exploration, asset is a location ID?
--X 45 is purchasing 7 bank slots
--X 46 is exalted rep, asset is presumably some kind of faction ID
--X 47 is 5 reputations to exalted
--X 49 is equipping items, asset is a slot ID (quality is presumably encoded into flags)
--X 52 is killing specific classes of player
--X 53 is kill-a-given-race, asset is race ID?
-- 54 is using emotes on targets, asset ID is likely the emote ID
--X 56 is being a wrecking ball in Alterac Valley
--X 62 is getting gold from quest rewards
--X 67 is looting gold
-- 68 is reading books
-- 70 is killing players in world PvP locations
-- 72 is fishing things from schools or wreckage
--X 73 is killing Mal'Ganis on Heroic. Why? Who can say.
--X 75 is obtaining mounts
-- 109 is fishing, either in general or in specific locations
-- 110 is casting spells on specific targets, asset ID is the spell ID
--X 112 is learning cooking recipes
--X 113 is honorable kills
local achievement_type_blacklist = {}
for _, v in pairs({0, 1, 7, 8, 9, 10, 11, 14, 27, 28, 29, 30, 31, 32, 34, 35, 36, 37, 41, 42, 46, 47, 49, 52, 53, 56, 62, 67, 73, 75, 112, 113}) do
  achievement_type_blacklist[v] = true
end

local achievement_list = {}

--local crittypes = {}
--QuestHelper_ZorbaForgotToRemoveThis = {}

local qhdinfo = false
local qhdinfodump = {}
local function qhadumpy()
  for k, v in pairs(qhdinfodump) do
    local ct = 0
    local some
    for tk, tv in pairs(v) do
      ct = ct + 1
      some = tk
    end
    QuestHelper:TextOut(string.format("%d: %d, %s", k, ct, some))
  end
end

local function registerAchievement(id)
  --if db.achievements[id] then return end
  
  local _, title, _, complete = GetAchievementInfo(id)
  --QuestHelper:TextOut(string.format("Registering %d (%s)", id, title))
  local prev = GetPreviousAchievement(id)
  local record = false
  
  --[[
  db.achievements[id] = {
    previous = prev,
    compete = complete,
    name = title,
    criterialist = {}
  }
  local dbi = db.achievements[id]
  ]]
  
  if prev then
    registerAchievement(prev)
  end
    
  local critcount = GetAchievementNumCriteria(id)
  if critcount == 0 then record = true end
  
  for i = 1, critcount do
    local crit_name, crit_type, crit_complete, crit_quantity, crit_reqquantity, _, _, crit_asset, _, crit_id = GetAchievementCriteriaInfo(id, i)
    
    if qhdinfo and not achievement_type_blacklist[crit_type] then
      if not qhdinfodump[crit_type] then qhdinfodump[crit_type] = {} end
      qhdinfodump[crit_type][title .. " --- " .. crit_name] = true
    end
    
    --[[
    table.insert(dbi.criterialist, crit_id)
    ass ert (not db.criteria[crit_id])
    crittypes[crit_type] = (crittypes[crit_type] or 0) + 1]]
    
    if not achievement_type_blacklist[crit_type] then record = true end
    
    --[[
    db.criteria[crit_id] = {
      name = crit_name,
      type = crit_type,
      complete = crit_complete,
      progress = crit_quantity,
      progress_total = crit_reqquantity,
      asset = crit_asset,
    }]]
  end
  
  if record then achievement_list[id] = true end
end

function createAchievementList()
  for _, catid in pairs(GetCategoryList()) do
    for d = 1, GetCategoryNumAchievements(catid) do
      registerAchievement(GetAchievementInfo(catid, d), db)
    end
  end
end

local achievement_stop_time = 0

local GetAchievementInfo = GetAchievementInfo
local GetAchievementNumCriteria = GetAchievementNumCriteria
local GetAchievementCriteriaInfo = GetAchievementCriteriaInfo

local function retrieveAchievement(id, db)
  QH_Timeslice_Yield()

  local _, _, _, complete = GetAchievementInfo(id)
  --QuestHelper:TextOut(string.format("Registering %d (%s)", id, title))
  
  db.achievements[id] = QuestHelper:CreateTable("collect_achievement achievement")
  db.achievements[id].complete = complete
  
  local dbi = db.achievements[id]
  
  local critcount = GetAchievementNumCriteria(id)
  
  --QuestHelper:TextOut(string.format("%d criteria", crit))
  for i = 1, critcount do
    QuestHelper: Assert(not db.criteria[crit_id])
    local _, _, crit_complete, crit_quantity, crit_reqquantity, _, _, _, _, crit_id = GetAchievementCriteriaInfo(id, i)

    db.criteria[crit_id] = QuestHelper:CreateTable("collect_achievement criteria")
    db.criteria[crit_id].complete = crit_complete
    db.criteria[crit_id].progress = crit_quantity
    db.criteria[crit_id].parent = id
  end
end

local function getAchievementDB()
  local db = {}
  db.achievements = {}
  db.criteria = {}
  
  local ct = 0
  for k in pairs(achievement_list) do
    retrieveAchievement(k, db)
    ct = ct + 1
  end
  --QuestHelper: TextOut(tostring(ct))
  
  return db
end

local updating = false

local function ScanAchievements()
  local cloc = GetLoc() -- yoink
  
  --QuestHelper:TextOut("Scanning")
  local newADB = getAchievementDB()
  --QuestHelper:TextOut("GADB done")
  local oldADB = AchievementDB
  
  for k, v in pairs(newADB.achievements) do
    if v.complete ~= oldADB.achievements[k].complete then
      QuestHelper: Assert(v.complete and not oldADB.achievements[k].complete)
      if not QHCA[k] then QHCA[k] = {} end
      QHCA[k].achieved = (QHCA[k].achieved or "") .. cloc
      
      --QuestHelper:TextOut(string.format("Achievement complete, %s", select(2, GetAchievementInfo(k))))
    end
  end
  
  for k, v in pairs(newADB.criteria) do
    if v.complete and not oldADB.criteria[k].complete then  -- Note that it's possible for objectives to be "uncompleted" when it's things like "do a bunch of shit in one run of this battleground" (see: isle of conquest)
      --QuestHelper:TextOut(string.format("Criteria complete, %d", k))
      --QuestHelper:TextOut(string.format("Criteria complete, %s", select(1, GetAchievementCriteriaInfo(k))))
      if not QHCA[v.parent] then QHCA[v.parent] = {} end
      QHCA[v.parent][k] = (QHCA[v.parent][k] or "") .. cloc
    elseif v.progress > oldADB.criteria[k].progress then
      --QuestHelper:TextOut(string.format("Criteria progress, %d", k))
      --QuestHelper:TextOut(string.format("Criteria progress, %s", select(1, GetAchievementCriteriaInfo(k))))
    end
  end
  
  AchievementDB = newADB
  
  for k, v in pairs(oldADB.achievements) do QuestHelper:ReleaseTable(v) end
  for k, v in pairs(oldADB.criteria) do QuestHelper:ReleaseTable(v) end
  
  updating = false -- This prevents error spam.
  --QuestHelper:TextOut("Done scan")
end

local function OnEvent()
  if not updating and AchievementDB then
    QH_Timeslice_Add(ScanAchievements, "criteria")
    updating = true
  end
end
--qhaach = OnEvent

function QH_Collect_Achievement_Init(QHCData, API)
  if not QHCData.achievement then QHCData.achievement = {} end
  QHCA = QHCData.achievement
  
  createAchievementList()
  AchievementDB = getAchievementDB() -- 'coz we're lazy
  
  GetLoc = API.Callback_LocationBolusCurrent
  QuestHelper: Assert(GetLoc)
  
  Merger = API.Utility_Merger
  QuestHelper: Assert(Merger)
  
  QH_Event("CRITERIA_UPDATE", OnEvent)
  QH_Event("ACHIEVEMENT_EARNED", OnEvent)
  
  OnEvent() -- kick it into its first update cycle
end
