Cartographer_InstanceMaps_Rotations = {
	-- currently only 90*k degree rotations are supported since in-between cases causes texture bleeding.
	["Ahn'kahet: The Old Kingdom"] = 90,
	["Dire Maul"] = 180,
	["Halls of Lightning"] = 270,
	["Shadowfang Keep"] = 90,
	["The Deadmines"] = 270,
	["Razorfen Kraul"] = 270,
	["Old Hillsbrad Foothills"] = 90,
	["The Black Morass"] = 90,
	["Utgarde Pinnacle"] = 90,
	["Hellfire Ramparts"] = 90,
	["Zul'Gurub"] = 90,
	["Zul'Farrak"] = 90,
	["Hyjal Summit"] = 90,
	["Black Temple"] = 270,
	["Zul'Aman"] = 90,
}

Cartographer_InstanceMaps_Floors = {
	["Karazhan"] = {5, 140, 260},
	["Azjol-Nerub"] = {0},
	["Upper Blackrock Spire"] = {0},
}

Cartographer_InstanceMaps_MapData = {
	["Ahn'Qiraj"] = "\038\228\211\125\055\060\144\173\020\046\160\009\125\191\150\004\150\118\126\068\081\012\054\068\176\066\004\196\084\190\106\145\249\103\037\243\153\036\254\211\138\243\214\013\075\059\191\068\081\012\118\068\176\066\004\196\029\072\112\125\002\052\238\134\192\179\144\077\186\194\036\046\075\059\191\068\040\006\155\068\176\066\004\196\010\015\142\154\016\239\113\225\012\208\067\111\129\155\069\153\075\059\159\068\081\012\118\068\176\066\004\196\055\168\063\194\083\074\159\044\094\253\215\250\080\164\009\244\075\059\159\068\040\006\155\068\176\066\004\196\147\036\092\177\223\254\012\194\054\206\173\106\193\125\076\139\150\118\126\068\040\006\155\068\176\066\004\196\160\218\052\169\218\127\232\127\078\115\041\019\249\138\203\084\075\059\159\068\081\012\054\068\176\066\004\196\117\168\053\037\245\009\057\233\071\187\195\183\109\075\045\144\150\118\126\068\081\012\118\068\176\066\004\196\150\037\112\065\127\041\105\164\090\159\066\084\185\095\131\084\203\081\166\068\189\144\167\065\152\013\002\196\086\215\013\125\049\080\079\064\155\065\234\096\011\134\245\161\203\081\166\068\011\121\138\067\152\013\002\196\076\028\245\236\192\241\007\150\158\157\172\043\194\008\055\020\203\081\198\068\011\121\138\067\152\013\002\196\220\056\053\031\065\148\073\075\181\091\026\047\028\109\216\086\203\081\166\068\133\060\005\068\152\013\002\196\051\170\159\129\048\089\254\136\132\202\104\236\117\056\038\125\203\081\198\068\133\060\005\068\152\013\002\196\201\252\051\112\088\053\014\154\127\125\208\082\007\111\075\016\203\081\198\068\189\144\167\065\152\013\002\196\035\033\056\005\255\090\035\022\249\008\146\153\227\121\138\069\203\081\166\068\133\060\069\068\152\013\002\196\063\205\034\021\251\121\131\163\083\243\119\055\159\160\066\042\188\135\147\194\052\145\007\195\120\112\001\196\010\097\037\187\124\238\206\171\165\087\249\236\145\052\121\181\109\036\129\068\095\108\062\068\057\021\000\196\162\186\164\126\035\232\228\050\231\193\067\107\043\083\175\212\109\036\129\068\190\216\252\067\057\021\000\196\001\234\079\068\215\234\075\023\235\174\033\029\254\056\112\253\218\072\066\068\190\216\252\067\057\021\000\196\112\202\088\031\013\232\130\071\238\118\228\180\131\114\177\218\218\072\066\068\095\108\062\068\057\021\000\196\232\137\251\000\217\080\203\014\067\073\199\011\035\125\181\239\223\142\008\068\200\031\048\068\194\121\247\195\002\066\039\064\238\233\025\076\126\210\066\035\044\029\016\162\223\142\072\068\144\063\224\067\194\121\247\195\216\050\068\233\008\242\248\112\155\130\230\173\239\210\018\097\223\142\008\068\144\063\224\067\194\121\247\195\003\133\126\081\238\011\085\086\138\102\051\067\253\073\240\136\022\165\055\195\205\162\161\068\018\030\245\195\081\063\098\008\155\135\229\216\041\112\066\095\115\054\178\105\022\165\055\195\205\162\193\068\018\030\245\195\000\126\119\199\180\251\186\250\032\136\233\130\188\134\149\117\014\028\001\196\115\074\205\068\018\030\245\195\079\117\071\151\194\216\228\077\109\057\010\022\153\181\198\042\029\056\130\195\115\074\205\068\018\030\245\195\122\182\233\120\220\060\241\122\090\137\224\017\011\149\000\114\029\056\130\195\115\074\237\068\018\030\245\195\207\221\176\038\232\223\033\002\131\160\143\018\051\057\052\227\014\028\001\196\115\074\237\068\018\030\245\195\208\098\140\223\110\231\135\074\100\027\205\185\048\156\055\159\010\000\088\196\038\050\191\068\148\021\245\195\034\090\000\049\228\071\156\229\207\183\192\028\101\007\209\200\010\000\088\196\038\050\223\068\148\021\245\195\186\132\115\225\119\118\161\212\234\138\057\050\172\051\015\150\010\000\024\196\038\050\223\068\148\021\245\195\091\051\047\209\101\213\249\000\072\142\251\024\045\137\051\208\010\000\088\196\038\050\159\068\148\021\245\195\091\138\176\158\067\002\253\039\062\060\129\238\217\197\148\169\010\000\024\196\038\050\191\068\148\021\245\195\049\225\170\104\109\197\129\137\211\089\006\034\234\064\196\114\055\189\144\067\157\181\003\068\107\248\243\195\059\188\085\138\095\079\237\111\073\101\003\234\225\165\136\111\055\189\144\067\059\107\135\067\107\248\243\195\046\025\145\105\223\118\198\005\209\050\007\157\201\166\199\202\155\094\008\068\157\181\003\068\107\248\243\195\231\104\065\169\146\119\130\020\062\015\027\114\232\242\209\147\155\094\008\068\059\107\135\067\107\248\243\195\120\067\066\160\225\037\105\105\060\144\173\229\142\043\152\013\191\233\005\066\157\181\003\068\107\248\243\195\204\152\150\096\161\116\085\175\011\075\032\095\003\073\116\184\191\233\005\066\059\107\135\067\107\248\243\195\040\090\167\254\108\145\201\102\084\081\076\066\243\042\113\113\099\141\166\067\244\234\136\068\063\030\240\195\190\159\180\026\007\061\118\114\038\238\050\143\213\157\119\130\177\070\019\068\233\213\017\068\063\030\240\195\239\121\161\129\248\055\151\168\115\193\066\007\012\217\067\145\177\070\019\068\244\234\136\068\063\030\240\195\075\175\022\229\230\173\132\039\097\030\113\189\114\041\043\100\177\070\019\068\233\213\081\068\063\030\240\195\196\026\177\196\066\135\199\230\140\136\160\196\077\117\092\234\099\141\166\067\233\213\081\068\063\030\240\195\061\097\188\187\223\111\159\222\145\241\203\189\154\196\024\254\099\141\166\067\233\213\017\068\063\030\240\195\065\090\207\007\213\156\012\245\063\018\157\140\219\125\146\215\113\204\134\195\195\153\250\068\016\084\234\195\003\051\160\174\168\090\180\170\020\254\158\005\237\243\173\136\252\233\135\067\036\224\137\068\148\061\228\195\123\186\211\130\076\018\115\168\068\062\178\164\009\204\149\178\252\233\135\067\036\224\169\068\148\061\228\195\130\100\082\014\227\235\131\116\114\099\076\047\038\047\052\139\149\063\125\065\036\224\169\068\148\061\228\195\089\041\129\214\178\255\057\053\161\176\152\051\160\073\068\167\149\063\125\065\036\224\137\068\148\061\228\195\050\052\234\090\226\102\111\083\211\043\132\100\130\199\231\236\177\065\121\195\136\144\243\068\111\250\227\195\254\040\155\146\015\088\009\236\225\170\047\068\063\246\023\012\216\160\252\195\136\144\243\068\111\250\227\195\149\107\208\242\067\036\056\224\246\025\171\122\250\221\052\202\216\160\252\195\068\200\009\069\111\250\227\195\172\019\153\060\173\102\191\107\245\079\253\057\188\246\244\193\194\174\044\068\241\214\201\195\008\189\221\195\191\063\096\063\004\231\040\221\150\118\220\103\103\236\066\203\097\087\150\068\241\214\201\195\008\189\221\195\156\205\164\056\209\066\024\168\136\152\047\195\192\068\081\168\097\087\182\068\120\235\036\196\008\189\221\195\055\027\030\021\138\238\192\042\035\087\151\137\077\022\176\131\194\174\044\068\120\235\036\196\008\189\221\195\120\203\222\058\235\138\233\084\086\209\179\167\228\082\138\177\194\174\044\068\120\235\100\196\008\189\221\195\234\133\004\239\081\037\046\224\162\064\064\138\025\115\106\144\194\174\108\068\241\214\201\195\008\189\221\195\231\130\211\209\106\059\128\057\194\022\220\219\050\253\075\081\097\087\150\068\120\235\036\196\008\189\221\195\223\172\224\043\140\080\142\246\163\227\129\112\065\122\000\082\097\087\182\068\120\235\100\196\008\189\221\195\126\191\251\196\247\158\237\171\004\133\217\202\222\052\218\209\097\087\150\068\120\235\100\196\008\189\221\195\009\174\115\130\057\004\122\099\223\113\110\076\210\010\149\055\194\174\108\068\120\235\036\196\008\189\221\195\168\141\114\181\019\238\031\083\190\186\168\068\254\176\233\001\194\174\108\068\120\235\100\196\008\189\221\195\079\171\185\229\118\205\170\035\243\111\189\146\170\117\088\073\053\197\010\196\246\131\137\068\208\180\220\195\115\215\152\075\031\030\253\026\162\129\239\247\048\142\056\231\053\197\010\196\237\007\083\068\208\180\220\195\242\017\236\166\038\064\193\156\025\099\148\255\060\143\006\064\053\197\074\196\246\131\137\068\208\180\220\195\135\175\022\209\100\244\145\196\067\032\234\148\216\242\197\051\053\197\074\196\237\007\083\068\208\180\220\195\050\193\168\246\154\102\158\002\051\082\107\131\232\139\240\054\174\198\111\068\184\196\178\195\137\067\205\195\075\179\077\108\205\233\052\243\252\098\227\202\242\100\102\148\023\082\137\068\095\101\143\193\137\067\205\195\064\053\118\067\092\135\237\177\102\044\008\158\090\157\238\030\047\164\082\068\085\246\136\195\137\067\205\195\061\095\245\188\210\238\206\187\013\068\185\006\076\005\205\109\023\082\137\068\085\246\136\195\137\067\205\195\234\211\194\013\142\135\046\224\042\115\089\044\243\091\108\200\047\164\082\068\095\101\143\193\137\067\205\195\051\165\192\058\174\174\123\047\254\196\227\032\218\231\024\219\004\038\211\195\154\249\009\069\117\231\204\195\198\098\143\247\170\177\164\158\067\023\010\094\255\088\236\195\004\038\211\195\154\249\025\069\117\231\204\195\038\088\161\253\252\044\142\193\103\226\187\172\100\161\096\189\009\076\038\195\154\249\009\069\117\231\204\195\056\243\181\127\074\124\175\126\007\068\194\239\157\004\050\210\009\076\038\195\154\249\025\069\117\231\204\195\235\071\245\061\218\092\044\033\062\041\000\128\203\137\159\229\117\096\137\068\214\020\226\194\148\161\196\195\183\121\244\096\121\017\210\116\129\016\100\087\231\105\232\197\117\096\169\068\214\020\226\194\148\161\196\195\146\183\148\218\121\045\184\055\002\189\026\114\163\167\039\161\225\015\094\195\090\108\014\068\079\042\193\195\141\047\092\202\182\113\253\072\021\238\168\141\105\114\067\005\225\015\094\195\090\108\078\068\079\042\193\195\082\030\019\065\171\082\053\111\131\019\206\104\011\104\076\013\240\007\239\195\090\108\078\068\079\042\193\195\184\094\035\086\044\223\050\032\220\096\063\017\204\076\074\203\240\007\239\195\090\108\014\068\079\042\193\195\017\071\062\223\089\148\172\020\015\081\142\078\039\095\226\151\230\003\035\068\034\124\211\194\057\244\183\195\193\119\055\140\246\137\105\068\192\124\042\171\251\204\003\085\149\195\207\067\179\003\109\195\255\086\182\195\042\224\015\134\055\004\103\069\237\055\058\047\021\070\002\025\202\225\039\068\179\003\109\195\255\086\182\195\106\103\024\154\199\032\242\005\253\162\050\107\228\236\088\028\043\135\031\067\179\003\109\195\255\086\182\195\234\028\218\095\006\137\078\083\181\183\077\242\142\211\051\085\170\236\188\195\026\067\243\066\024\234\160\195\241\097\145\253\114\017\030\140\008\190\054\142\097\156\197\110\170\236\188\195\198\208\188\067\024\234\160\195\155\254\011\168\133\103\099\112\185\015\148\029\104\223\164\143\083\154\144\066\117\174\022\195\132\078\160\195\002\130\238\140\073\014\106\068\244\016\183\108\195\080\012\006\083\154\144\066\058\087\203\195\132\078\160\195\206\167\079\086\096\250\165\255\255\105\232\170\192\024\107\159\213\178\055\195\117\174\022\195\132\078\160\195\221\173\192\141\060\128\186\216\108\165\164\048\099\139\108\048\213\178\055\195\058\087\203\195\132\078\160\195\011\035\034\195\230\091\121\226\245\108\056\067\029\021\133\237\219\144\005\195\101\172\231\066\207\021\155\195\195\094\202\248\191\228\227\041\246\232\185\058\164\169\006\247\219\144\005\195\204\041\012\195\207\021\155\195\068\118\145\251\028\247\226\013\155\042\215\055\245\183\089\101\071\222\244\066\204\041\012\195\207\021\155\195\249\205\025\013\106\230\193\141\218\164\198\177\083\009\003\194\071\222\244\066\101\172\231\066\207\021\155\195\107\005\015\017\247\189\226\208\060\161\044\213\213\248\248\091\191\034\216\195\225\093\209\194\209\134\149\195\205\141\230\235\079\023\026\193\192\034\055\040\153\007\151\071\191\034\216\195\014\081\023\067\209\134\149\195\067\200\137\117\088\014\195\023\125\095\105\118\007\176\129\126\127\069\048\195\225\093\209\194\209\134\149\195\092\220\222\246\010\067\095\164\005\115\230\174\030\209\014\179\158\076\239\064\002\012\004\195\017\153\050\195\222\003\027\143\194\255\217\122\015\047\156\109\197\080\014\235\168\211\006\194\138\053\251\066\043\081\041\195\022\150\076\164\208\251\051\098\066\017\249\002\148\071\098\001\009\099\062\195\248\120\001\195\195\199\027\195\025\067\143\184\192\184\008\216\143\032\152\061\191\116\240\224\080\069\122\066\050\135\132\066\180\196\003\195\127\054\210\061\238\029\044\026\049\014\232\161\249\066\213\004\169\007\210\192\095\227\050\066\230\110\208\194\049\007\226\063\134\080\107\180\180\080\193\016\075\173\160\149\194\111\121\067\039\071\083\195\230\110\208\194\072\099\010\217\066\223\056\075\101\223\153\227\122\208\175\245\169\007\210\192\039\071\083\195\230\110\208\194\201\214\067\210\125\044\054\001\020\004\148\252\113\141\065\255\147\218\201\194\039\174\243\066\215\155\205\194\149\208\032\073\060\135\204\124\049\116\141\096\021\087\116\153\147\218\201\194\235\040\006\195\215\155\205\194\116\191\129\072\245\253\038\108\121\165\236\117\013\204\000\106\178\061\174\195\240\085\201\194\146\025\185\194\013\253\203\165\019\156\130\021\134\148\146\219\158\234\152\054\113\153\243\064\195\140\077\195\198\123\173\194\128\220\003\122\013\017\092\207\116\007\050\170\022\223\208\134\203\106\011\067\190\047\045\195\157\074\173\194\159\040\053\121\174\123\092\170\155\126\034\010\035\208\110\248\110\142\130\067\236\248\141\194\102\000\172\194\058\030\098\088\036\048\022\027\200\098\133\044\138\113\042\036\110\142\130\067\040\131\110\065\102\000\172\194\076\146\005\022\140\152\027\236\134\144\015\078\038\151\138\123\173\214\069\195\049\008\021\195\220\034\143\194\062\244\245\043\038\140\255\053\013\023\191\030\087\186\177\240\173\214\069\195\155\239\213\066\220\034\143\194\004\192\046\128\025\171\151\183\113\214\128\038\064\090\090\085\045\150\119\195\210\182\186\194\161\138\005\194",
	["Armory"] = "\047\182\003\035\111\089\193\217\209\044\140\195\222\079\018\223\019\059\133\196\219\034\089\067\039\201\068\065\065\156\223\208\240\126\209\104\248\197\077\058\153\106\156\161\239\061\050\196\038\025\239\066\109\129\092\065\092\013\188\176\208\129\146\087\007\233\029\106\034\185\099\031\221\203\011\196\230\157\251\066\014\035\122\065\088\198\173\049\218\108\041\125\000\209\157\120\044\192\092\031\017\191\099\196\234\019\239\066\170\036\122\065\210\225\245\168\119\116\029\018\196\172\157\139\150\082\248\210\165\095\157\195\209\115\156\065\161\180\202\065\169\236\016\021\210\167\191\222\137\123\007\196\027\033\251\023\224\188\000\196\092\076\146\066\169\179\229\065\197\090\113\220\219\185\046\221\153\055\033\241\237\039\144\008\187\170\111\196\155\088\126\067\246\131\008\066\064\238\083\038\255\063\056\078\180\075\107\063\175\219\236\084\225\009\191\195\030\042\142\066\148\160\013\066\140\054\205\108\096\129\134\178\040\141\002\130\162\027\115\060\019\159\174\195\177\129\140\194\119\133\015\066\096\191\177\139\232\206\019\030\056\040\138\122\061\007\048\209\088\113\173\195\204\128\210\065\099\136\015\066\213\058\204\007\079\107\090\134\118\066\002\036\159\065\033\145\081\090\109\196\024\223\213\066\095\215\015\066\008\153\095\127\174\208\109\023\119\079\124\125\160\053\082\214\081\090\109\196\105\001\018\067\096\215\015\066\025\013\100\141\121\091\140\032\129\128\096\253\174\019\149\200\081\090\109\196\006\177\065\067\098\215\015\066\048\067\132\093\097\015\071\102\064\076\031\136\224\004\030\007\082\090\109\196\002\083\040\067\099\215\015\066\141\142\245\033\147\238\217\062\074\151\129\068\121\116\198\109\019\218\146\195\007\163\167\194\142\173\019\066\206\096\032\039\171\091\180\024\226\020\075\222\190\009\010\208\018\004\147\195\096\243\090\066\015\111\020\066\195\224\165\096\149\237\141\154\142\172\147\238\097\010\006\109\165\095\157\195\167\229\102\194\205\037\021\066\189\219\120\223\215\108\069\212\178\244\058\121\253\112\018\199\054\137\140\195\097\228\077\194\029\049\021\066\203\139\040\169\179\070\250\031\001\223\175\042\070\134\045\065\170\233\010\195\114\225\010\194\017\050\021\066\161\194\133\007\121\145\208\225\242\096\001\209\186\202\054\108\175\233\010\195\201\122\072\065\017\050\021\066",
	["Auchenai Crypts"] = "\139\171\159\031\040\164\021\076\131\171\247\006\165\114\169\243\152\242\203\195\139\054\070\067\160\068\185\195\091\082\090\174\089\093\157\186\093\069\208\074\137\058\138\239\155\053\208\066\139\054\070\067\160\068\185\195\030\046\089\230\004\168\048\100\168\122\009\053\213\021\018\238\049\229\023\195\139\054\070\067\160\068\185\195\072\064\016\052\096\158\229\007\040\072\175\021\225\129\108\172\156\041\013\196\126\242\173\194\098\043\222\192\091\111\221\006\186\136\062\219\115\229\063\095\156\247\110\159\223\211\024\195\188\139\204\194\118\001\163\192\196\165\047\190\020\173\157\198\216\014\218\148\113\151\199\106\239\105\204\195\188\139\204\194\118\001\163\192\109\240\146\193\117\208\035\162\132\132\022\092\201\242\173\040\244\097\087\194\018\206\186\193\181\125\005\192\028\143\172\105\154\148\080\038\082\249\166\157\005\102\118\201\130\039\074\067\018\206\186\193\181\125\005\192\118\197\155\137\043\079\210\116\243\024\089\117\059\113\046\115\023\142\055\066\039\086\040\068\092\012\027\066\086\137\018\214\171\092\197\033\006\099\206\172\010\190\140\114\121\028\082\195\039\086\040\068\092\012\027\066\248\066\165\135\143\083\014\216\159\151\168\086\179\196\148\051\173\121\019\196\008\042\127\067\013\255\045\066\179\114\108\026\053\096\240\063\203\135\109\122\194\148\169\249\082\226\210\066\053\221\013\068\185\064\055\066\239\181\208\052\209\064\196\010\118\238\186\160\015\050\014\120\082\226\210\066\107\186\155\067\185\064\055\066\090\010\237\178\035\013\142\025\153\066\101\000\115\073\036\101\148\184\180\067\053\221\013\068\185\064\055\066\100\017\152\032\155\122\179\166\132\163\230\071\136\229\122\027\148\184\180\067\107\186\155\067\185\064\055\066\141\051\235\207\040\096\026\113\209\200\014\100\067\232\222\011\034\126\057\067\030\132\151\067\072\122\084\066\196\097\129\078\076\031\059\165\213\138\135\249\040\254\224\191\251\225\059\067\043\201\034\068\086\122\084\066\223\012\005\162\242\208\051\013\156\032\130\177\037\136\156\113\089\182\250\195\165\087\175\066\240\129\084\066",
	["Black Temple"] = "\216\055\249\074\191\061\180\025\002\168\229\149\090\066\004\237\163\098\105\194\255\214\155\063\154\057\064\193\069\096\041\156\143\124\019\105\161\077\176\205\170\019\191\003\163\098\105\194\081\200\126\195\154\057\064\193\055\125\193\082\156\128\138\001\095\036\039\171\243\078\092\167\037\021\038\195\243\067\013\196\161\163\057\066\027\219\169\197\084\235\098\151\196\151\161\059\044\011\002\208\037\021\038\195\243\067\077\196\161\163\057\066\181\193\009\088\098\146\251\071\022\096\062\219\203\236\087\214\037\021\038\195\231\135\154\195\161\163\057\066\243\217\233\169\162\193\059\099\179\129\208\141\114\093\099\188\113\110\054\195\153\044\147\196\078\110\082\067\115\233\148\054\030\068\123\234\081\074\218\192\088\127\163\171\027\035\147\066\051\089\102\196\078\110\082\067\171\106\120\117\102\187\117\085\025\207\040\037\223\199\091\016\113\110\054\195\051\089\102\196\078\110\082\067\223\081\189\048\132\012\025\235\149\198\025\108\131\173\069\084\027\035\147\066\153\044\147\196\078\110\082\067\159\182\056\195\240\248\164\227\209\109\067\210\097\190\132\165\231\016\155\195\252\023\132\196\244\140\103\067\249\218\237\093\012\156\111\134\071\177\040\026\228\189\029\092\115\136\077\196\252\023\132\196\244\140\103\067\101\099\037\006\206\013\077\220\102\043\230\006\000\137\117\240\115\136\013\196\252\023\132\196\244\140\103\067\242\076\096\246\129\246\198\066\026\150\213\141\194\032\204\240\072\043\009\196\195\197\155\196\060\013\152\067\164\229\038\242\028\105\145\082\074\157\165\145\037\160\125\062\205\248\135\195\160\040\156\196\103\194\189\067\166\088\063\020\002\143\129\052\009\197\158\134\073\024\203\239\205\248\135\195\160\040\188\196\103\194\189\067\114\174\214\175\229\043\044\184\166\216\105\150\056\194\000\078\102\252\003\196\160\040\156\196\103\194\189\067\214\003\199\184\243\253\037\202\073\048\118\122\240\085\231\125\102\252\067\196\160\040\188\196\103\194\189\067\043\124\122\218\106\034\040\070\193\109\211\165\100\225\107\006\102\252\067\196\160\040\156\196\103\194\189\067\247\156\036\024\231\146\012\106\145\095\187\178\153\008\096\187\102\252\003\196\160\040\188\196\103\194\189\067\094\088\186\237\002\047\245\125\080\130\038\087\215\233\152\201\177\201\226\196\210\051\217\196\013\126\200\067\184\022\184\110\089\131\076\147\076\002\155\218\047\238\226\252\177\201\226\196\210\051\185\196\013\126\200\067\115\009\083\043\080\105\198\212\206\225\018\026\237\059\220\189\216\100\001\197\210\051\217\196\013\126\200\067\105\220\087\196\152\064\050\107\105\197\151\152\052\233\086\056\216\100\001\197\210\051\185\196\013\126\200\067\130\116\108\144\086\061\209\175\127\204\021\003\051\238\145\191\232\229\130\195\109\161\195\196\045\171\225\067\056\253\041\213\078\083\097\179\043\009\001\202\104\180\230\218\122\154\189\196\131\077\003\197\140\062\240\067\159\193\075\081\247\037\066\116\208\119\251\137\143\117\244\182\122\154\221\196\131\077\003\197\140\062\240\067\089\168\070\103\112\012\090\088\143\163\066\161\026\188\191\238\009\209\223\196\196\150\025\197\117\152\241\067\166\128\207\115\047\139\015\243\238\035\113\163\212\006\130\030\009\209\191\196\196\150\009\197\117\152\241\067\167\218\137\080\182\105\238\011\142\216\138\206\025\032\238\026\009\209\191\196\196\150\025\197\117\152\241\067\017\047\022\061\044\232\058\080\111\146\133\150\049\198\070\010\009\209\223\196\196\150\009\197\117\152\241\067\222\068\073\107\080\098\208\165\063\228\009\118\189\068\087\077\150\089\235\196\193\076\020\197\181\108\003\068\040\228\134\079\050\185\053\163\064\170\088\222\155\180\039\160\115\011\227\196\221\124\238\196\094\122\016\068\219\098\224\073\016\102\149\139\189\081\093\143\116\209\215\230\185\133\001\197\110\062\023\197\094\122\016\068\108\200\115\129\111\073\159\055\062\184\229\068\025\175\177\104\115\011\227\196\110\062\007\197\094\122\016\068\132\139\056\126\112\134\200\191\236\162\179\021\125\168\238\091\185\133\001\197\110\062\007\197\094\122\016\068\142\116\175\071\066\037\049\107\025\053\114\129\041\068\148\202\115\011\227\196\110\062\023\197\094\122\016\068\078\246\177\115\190\250\125\198\212\182\031\101\016\147\096\130\185\133\001\197\221\124\238\196\094\122\016\068\009\080\011\197\129\244\149\014\239\119\176\130\142\134\200\217\161\207\225\196\012\160\212\196\044\186\016\068\137\229\001\152\151\214\098\250\209\133\156\003\141\079\134\058\250\235\143\196\128\041\018\197\188\211\016\068\146\209\248\140\184\115\122\061\141\065\215\075\013\091\144\174\113\054\148\196\000\202\022\197\164\029\017\068\179\041\179\227\149\050\011\024\057\060\182\050\121\186\004\051\113\054\180\196\000\202\022\197\164\029\017\068\248\133\238\165\106\111\141\241\058\209\199\205\179\011\208\176\204\076\216\196\167\089\209\196\157\049\017\068\038\220\041\208\052\010\159\212\205\244\208\014\244\017\072\229\204\076\184\196\211\172\008\197\157\049\017\068\233\066\208\254\088\058\110\206\124\023\186\212\027\247\055\040\204\076\184\196\167\089\209\196\157\049\017\068\067\050\144\028\104\011\031\223\183\219\176\069\113\060\072\127\204\076\152\196\167\089\241\196\157\049\017\068\205\175\230\091\174\202\231\074\188\239\230\227\051\240\119\140\204\076\152\196\167\089\209\196\157\049\017\068\011\215\116\238\071\131\189\219\135\248\123\042\102\044\052\053\204\076\152\196\211\172\008\197\157\049\017\068\119\145\027\122\133\065\208\126\126\079\141\029\023\148\066\052\204\076\216\196\167\089\241\196\157\049\017\068\150\162\248\064\113\109\229\037\129\010\250\216\019\078\122\245\204\076\216\196\211\172\008\197\157\049\017\068\017\217\221\209\152\133\218\193\175\087\100\130\181\058\239\038\204\076\184\196\167\089\241\196\157\049\017\068\013\009\030\069\182\138\115\052\013\203\059\081\158\184\023\045\067\095\142\196\120\059\228\196\094\132\017\068\161\103\192\045\228\205\072\117\150\046\005\084\215\132\080\060\066\169\139\196\253\235\249\196\094\132\017\068\174\218\017\071\077\169\249\066\072\160\132\168\066\041\196\144\116\060\143\196\141\120\242\196\087\134\017\068\025\182\253\175\072\251\005\034\002\099\210\070\007\032\102\099\227\099\142\196\013\138\248\196\224\142\017\068\176\149\188\160\203\000\189\212\113\077\041\184\078\082\248\015\194\196\151\196\003\100\200\196\164\143\017\068\052\240\213\153\126\140\005\156\209\018\135\129\102\065\137\176\194\196\183\196\003\100\168\196\164\143\017\068\221\165\073\076\154\113\122\016\116\187\121\076\114\217\113\154\194\196\151\196\003\100\168\196\164\143\017\068\238\197\070\060\226\216\023\090\191\037\056\073\128\176\222\254\194\196\183\196\003\100\200\196\164\143\017\068\006\006\200\145\058\081\214\079\185\038\229\217\189\112\063\155\146\008\146\196\189\124\012\197\126\252\029\068\160\169\240\035\146\254\006\123\251\250\098\199\125\226\227\149\146\008\146\196\123\249\248\196\126\252\029\068\085\035\122\172\056\163\235\018\058\158\088\021\072\161\053\005\253\030\237\196\227\051\204\196\127\000\030\068\000\064\196\029\047\139\057\000\095\159\139\040\178\223\121\096\067\156\133\196\092\088\019\197\028\215\030\068\117\082\196\085\124\155\073\171\110\155\236\219\173\089\046\042\011\175\239\196\155\127\214\196\238\218\030\068\212\119\015\135\187\245\112\188\103\061\200\036\033\054\135\073\179\197\239\196\116\234\181\196\181\130\040\068\111\002\135\184\214\210\143\034\195\149\252\161\023\104\002\109\171\111\240\196\088\230\194\196\090\232\041\068\253\172\010\080\216\230\202\072\072\153\125\212\081\143\097\065\081\200\223\196\113\167\194\196\156\049\043\068\075\130\160\063\039\220\138\243\162\253\190\133\001\039\017\171\037\223\164\196\017\218\155\196\177\148\043\068\112\238\043\129\051\240\105\177\210\007\206\125\115\119\180\239\037\223\228\196\017\218\187\196\177\148\043\068\106\063\212\018\134\033\116\108\086\144\001\011\060\135\054\166\037\223\132\196\017\218\187\196\177\148\043\068\101\234\179\069\255\112\053\213\178\087\188\187\003\158\033\077\037\223\164\196\017\218\187\196\177\148\043\068\040\047\129\051\033\249\015\015\138\053\000\023\224\143\118\027\037\223\196\196\017\218\155\196\177\148\043\068\091\169\102\044\215\203\134\119\067\037\080\125\165\229\210\229\146\111\002\197\017\218\187\196\177\148\043\068\078\066\201\033\137\247\187\144\150\097\119\102\219\084\108\096\037\223\196\196\017\218\187\196\177\148\043\068\031\197\082\086\215\246\118\191\118\230\134\131\225\010\170\088\091\196\168\196\014\104\204\196\011\134\056\068\094\188\197\155\052\150\126\128\048\198\118\006\207\215\201\099\149\122\002\197\048\234\025\197\159\206\056\068\106\028\195\219\122\124\189\032\144\154\098\200\130\067\131\234\043\245\132\196\048\234\025\197\159\206\056\068\136\079\186\107\203\189\243\248\242\091\117\040\174\185\092\046\043\245\164\196\048\234\025\197\159\206\056\068\131\249\122\018\243\135\047\125\215\018\026\087\214\139\049\202\043\245\228\196\048\234\025\197\159\206\056\068\100\028\187\153\043\174\255\126\136\212\148\146\207\169\104\095\043\245\196\196\048\234\025\197\159\206\056\068\031\231\089\205\170\245\056\026\022\154\066\141\196\109\015\103\043\245\196\196\048\234\009\197\159\206\056\068\005\056\025\155\129\131\254\215\060\200\154\087\247\109\052\037\043\245\228\196\048\234\009\197\159\206\056\068\142\200\139\089\188\058\082\106\070\150\251\206\045\161\232\157\118\197\164\196\225\088\187\196\155\153\057\068\069\172\243\137\077\228\129\098\178\047\184\123\150\248\170\038\044\090\168\196\248\100\011\197\169\154\057\068\198\232\148\008\190\233\056\128\142\080\122\042\110\085\026\032\080\184\159\196\031\204\014\197\018\156\057\068\071\021\214\051\226\135\140\208\243\186\136\191\201\164\160\059\145\161\227\196\012\214\014\197\175\156\057\068\200\198\179\198\034\074\024\197\252\224\238\063\143\174\170\101\113\164\236\196\151\041\214\196\008\183\059\068\218\075\193\059\110\062\114\236\057\099\210\165\201\246\236\133\113\164\172\196\151\041\214\196\008\183\059\068\061\245\206\124\149\110\032\117\183\009\012\032\207\129\021\003\113\164\172\196\151\041\246\196\008\183\059\068\218\003\014\079\192\057\001\082\140\175\021\137\140\097\165\072\113\164\204\196\151\041\214\196\008\183\059\068\117\089\145\181\226\230\238\252\061\200\042\200\041\023\145\206\113\164\204\196\203\020\011\197\008\183\059\068\037\208\070\175\091\116\167\085\077\224\192\017\132\199\127\048\113\164\236\196\203\020\011\197\008\183\059\068\236\144\005\082\086\199\117\000\186\129\030\239\078\028\008\083\113\164\236\196\151\041\246\196\008\183\059\068\011\029\006\193\183\181\186\251\202\152\134\202\048\213\033\142\062\102\176\196\109\022\220\196\086\133\096\068\002\163\193\249\169\238\032\123\183\154\188\081\134\113\005\244\062\102\176\196\109\022\252\196\086\133\096\068\088\081\151\174\190\159\240\222\165\163\113\203\048\210\215\138\062\102\208\196\109\022\252\196\086\133\096\068\079\140\218\104\059\206\126\250\208\161\233\037\068\245\126\246\062\102\208\196\109\022\220\196\086\133\096\068\168\042\204\247\100\161\119\091\080\064\044\087\168\205\182\125\113\239\188\196\118\063\216\196\011\007\097\068\211\120\198\040\118\184\232\153\191\102\096\046\125\030\106\213\101\046\189\196\198\117\254\196\252\088\117\068\206\205\208\233\149\088\095\230\040\162\233\017\224\251\179\169\025\034\206\196\062\161\003\197\147\012\121\068\022\112\100\044\030\213\179\123\146\052\248\156\237\041\090\204\025\034\206\196\125\066\231\196\147\012\121\068\161\127\098\026\085\089\089\247\015\229\190\225\061\079\180\036\025\034\174\196\125\066\231\196\147\012\121\068\019\175\133\088\235\248\003\194\079\097\047\168\235\089\176\141\025\034\174\196\062\161\003\197\147\012\121\068\229\144\241\177\066\228\171\077\082\095\186\215\167\204\212\035\176\154\188\196\099\222\231\196\144\106\128\068",
	["Blackfathom Deeps"] = "\195\008\013\096\020\104\085\052\102\106\138\213\049\220\102\080\182\235\141\068\101\118\225\195\243\012\033\195\011\087\170\019\081\244\043\076\007\183\081\070\005\171\222\230\109\215\091\068\203\236\066\195\243\012\033\195\231\142\230\136\127\157\065\144\048\112\228\170\201\139\074\167\182\235\141\068\050\187\048\196\243\012\033\195\175\035\117\116\125\136\142\036\158\150\047\061\078\081\207\199\109\215\091\068\050\187\048\196\243\012\033\195\066\215\054\198\165\139\192\043\113\138\034\100\141\176\248\105\109\215\091\068\101\118\225\195\243\012\033\195\251\241\161\220\151\229\179\086\006\134\049\243\037\001\250\086\205\229\022\068\204\135\050\196\197\032\031\195\082\133\110\213\015\237\117\182\055\164\024\191\104\217\028\160\205\229\022\068\051\031\074\195\197\032\031\195\054\180\113\232\239\054\154\060\234\123\086\199\222\056\229\251\205\229\086\068\204\135\050\196\197\032\031\195\210\029\097\070\204\044\251\098\221\067\098\104\129\001\180\144\205\229\086\068\051\031\074\195\197\032\031\195\095\214\234\044\105\119\204\228\207\084\250\200\051\194\056\152\205\229\086\068\153\015\229\195\197\032\031\195\240\179\127\007\029\007\210\107\247\075\178\186\033\161\145\126\205\229\022\068\153\015\229\195\197\032\031\195\173\127\240\205\215\070\059\212\121\046\095\220\050\054\227\198\068\235\014\068\039\225\055\196\001\239\028\195\101\069\015\041\180\063\190\054\113\184\137\215\166\035\176\185\181\016\056\068\245\234\037\195\157\131\023\195\176\214\181\152\230\212\047\146\019\157\120\033\239\071\066\073\106\033\240\067\245\234\037\195\157\131\023\195\124\055\207\121\032\219\060\127\148\055\000\193\101\103\085\118\133\217\179\068\139\161\113\067\081\120\238\194\108\167\038\109\115\234\044\192\199\033\038\053\242\112\245\120\053\045\012\068\085\253\149\195\047\119\238\194\232\159\127\020\219\178\197\163\200\254\187\120\222\246\018\085\176\183\151\068\247\159\147\195\106\068\238\194\089\173\015\239\086\227\137\023\221\005\126\234\071\247\121\179\033\225\146\068\055\158\000\196\238\019\233\194\113\006\101\005\224\157\123\191\087\186\134\086\128\198\082\065\133\056\015\068\026\003\084\196\202\118\231\194\196\175\165\203\224\254\034\217\223\201\001\249\063\134\232\009\205\157\143\068\152\186\251\194\250\053\226\194\249\211\194\147\104\049\100\245\227\165\071\009\238\211\209\230\200\015\190\067\149\162\219\194\186\048\221\194\116\045\220\081\068\177\109\125\213\112\236\232\133\043\122\226\048\117\161\067\252\209\028\195\062\243\213\194\237\091\182\183\121\086\078\171\199\043\130\122\034\085\166\068\103\219\067\068\056\021\238\194\136\096\205\194\219\231\060\173\138\231\024\205\253\191\095\086\049\106\083\046\179\237\129\068\056\021\238\194\136\096\205\194\113\232\168\227\189\156\156\202\192\238\169\219\158\245\171\178\150\250\131\068\188\208\079\194\102\122\204\194\066\237\158\150\126\152\110\131\011\024\023\048\244\091\119\072\211\190\136\067\232\163\208\195\246\180\195\194\199\075\009\195\105\005\247\176\056\004\147\212\101\149\142\252\184\162\025\067\017\010\172\195\099\104\190\194\148\039\076\176\003\229\151\225\135\055\106\234\046\225\117\235\117\195\194\068\241\051\097\068\169\203\187\194\211\240\204\077\133\084\203\103\222\144\111\035\148\033\208\027\117\195\194\068\227\103\194\067\169\203\187\194\204\205\025\156\154\085\044\253\163\078\030\157\219\017\124\041\117\195\194\068\241\051\033\068\169\203\187\194\158\064\174\048\232\076\247\161\029\095\083\107\083\012\004\183\160\045\095\068\120\211\054\066\158\021\187\194\205\019\021\031\091\173\243\253\205\182\229\173\180\181\027\191\173\106\141\067\026\124\096\195\034\245\184\194\185\137\009\075\140\001\099\200\190\129\231\150\228\138\012\014\069\199\194\068\088\112\004\066\133\233\183\194\182\233\202\046\022\066\255\137\047\114\185\081\199\050\047\028\237\115\168\068\006\013\083\067\133\233\183\194\065\168\217\211\137\212\226\138\128\224\166\157\028\076\149\133\237\115\168\068\229\203\051\194\133\233\183\194\211\162\083\052\059\157\151\252\239\088\232\126\121\025\218\060\078\075\132\068\042\234\067\066\163\023\159\194\182\057\046\189\093\083\106\030\180\237\121\102\082\020\213\223\171\139\161\068\149\145\199\194\226\135\129\194\051\251\214\105\031\222\041\079\249\168\054\179\187\030\055\098\080\247\147\068\158\029\029\064\087\023\108\194\056\203\216\252\020\245\182\101\076\154\153\098\241\051\243\249\016\035\191\068\140\039\079\067\171\148\079\194",
	["Blackrock Depths"] = "\085\019\124\128\243\167\092\167\190\202\031\037\176\169\097\058\246\076\026\197\197\108\153\068\121\228\208\195\025\034\176\103\179\184\007\066\108\026\133\106\186\097\208\255\246\076\026\197\138\217\114\068\121\228\208\195\156\122\242\230\029\126\136\154\155\236\240\102\040\154\106\017\246\076\010\197\197\108\153\068\121\228\208\195\112\090\022\246\187\168\214\046\050\076\133\135\254\194\255\194\246\076\010\197\138\217\114\068\121\228\208\195\128\015\107\130\116\252\211\244\015\195\070\095\121\130\058\004\237\153\244\196\138\217\114\068\121\228\208\195\173\086\241\129\138\234\210\215\038\106\031\030\221\109\226\160\101\047\208\196\205\139\238\193\036\230\199\195\180\098\148\253\038\176\053\235\061\184\171\085\254\052\164\199\101\047\208\196\134\046\098\067\036\230\199\195\127\135\028\005\229\017\089\239\122\189\033\114\008\080\124\097\101\047\176\196\161\139\056\068\036\230\199\195\064\220\095\204\221\125\189\002\000\196\058\236\044\034\195\092\101\047\240\196\161\139\120\068\036\230\199\195\178\118\153\057\244\241\246\061\123\236\127\000\027\202\195\071\101\047\240\196\161\139\056\068\036\230\199\195\047\021\136\095\120\031\139\203\199\235\232\131\061\229\086\076\101\047\240\196\134\046\098\067\036\230\199\195\024\154\222\247\240\105\183\149\140\255\194\211\067\034\157\213\101\047\208\196\067\023\241\067\036\230\199\195\048\231\184\092\185\125\206\208\092\128\123\225\022\052\210\167\101\047\176\196\067\023\241\067\036\230\199\195\065\049\163\213\083\093\134\247\015\002\074\076\178\130\033\041\101\047\240\196\205\139\238\193\036\230\199\195\155\099\183\192\079\190\042\005\246\169\074\101\188\253\114\064\101\047\208\196\161\139\056\068\036\230\199\195\091\203\084\133\014\090\149\219\242\084\245\086\014\025\080\144\101\047\176\196\205\139\238\193\036\230\199\195\077\100\121\181\245\136\076\250\143\193\142\033\155\109\102\026\178\023\008\197\134\046\098\067\036\230\199\195\008\013\043\106\234\254\098\049\184\052\216\076\253\033\245\133\101\047\176\196\134\046\098\067\036\230\199\195\187\015\048\032\135\053\055\223\096\234\162\131\125\188\047\222\101\047\208\196\161\139\120\068\036\230\199\195\121\219\208\252\177\059\201\155\154\151\225\000\084\201\074\158\178\023\008\197\205\139\238\193\036\230\199\195\108\106\033\207\213\066\009\239\243\162\075\035\133\052\245\233\195\161\038\197\117\080\074\068\017\198\122\195\057\217\191\244\017\055\146\008\014\031\010\106\197\210\153\117\195\161\038\197\058\040\133\068\017\198\122\195\025\119\181\253\225\081\119\235\011\000\009\151\087\069\195\025\195\161\038\197\117\080\010\068\017\198\122\195\092\145\246\023\027\142\082\075\222\074\078\114\134\126\211\018\195\161\022\197\117\080\074\068\017\198\122\195\144\101\228\247\056\200\239\040\055\069\221\143\231\083\161\070\195\161\022\197\117\080\010\068\017\198\122\195\001\193\184\045\041\182\126\247\244\074\147\024\132\205\231\192\207\105\021\197\104\068\020\068\232\147\121\195\225\150\210\043\168\220\245\208\051\009\152\117\195\212\194\130\159\211\234\196\208\136\168\067\232\147\121\195\027\150\136\078\185\082\039\153\119\217\106\225\018\002\108\149\207\105\005\197\104\068\020\068\232\147\121\195\072\168\046\075\127\183\220\093\197\192\050\104\138\176\248\082\207\105\005\197\208\136\168\067\232\147\121\195\096\042\026\213\039\201\188\008\199\085\134\016\192\000\200\129\207\105\021\197\208\136\168\067\232\147\121\195\248\011\229\092\251\153\027\147\083\211\208\130\009\109\036\118\122\060\157\196\079\127\156\067\229\223\112\195\236\177\038\034\102\140\209\123\190\146\170\075\117\007\079\235\148\241\249\196\215\071\226\067\090\231\104\195\035\090\046\005\138\215\034\131\091\208\045\003\070\151\161\214\148\241\217\196\215\071\226\067\090\231\104\195\231\048\039\081\252\204\118\022\040\001\182\129\098\154\123\085\148\241\249\196\235\035\049\068\090\231\104\195\159\239\105\131\084\005\124\151\197\136\069\098\076\139\239\124\148\241\217\196\235\035\049\068\090\231\104\195\129\135\013\089\169\010\017\024\091\010\192\079\159\191\065\134\245\006\012\197\238\015\096\068\255\015\100\195\184\022\224\247\125\252\071\206\008\253\018\238\107\057\234\255\212\129\043\196\134\216\117\195\101\205\076\195\013\118\136\040\143\202\131\189\204\093\100\024\157\233\041\163\212\129\107\196\143\119\034\065\101\205\076\195\087\121\046\219\246\120\102\223\153\160\183\219\169\090\159\005\212\129\107\196\134\216\117\195\101\205\076\195\147\078\200\004\161\016\237\075\015\037\144\092\115\010\037\099\165\213\041\197\133\151\088\068\159\103\061\195\211\090\053\201\093\021\243\132\075\081\105\017\048\157\079\065\165\213\041\197\133\151\024\068\159\103\061\195\212\236\177\234\192\022\064\132\223\077\075\159\044\052\252\252\165\213\057\197\133\151\088\068\159\103\061\195\246\170\181\192\238\188\058\200\047\009\195\095\118\065\050\009\165\213\057\197\133\151\024\068\159\103\061\195\085\048\161\222\052\105\194\234\215\246\253\141\126\113\001\128\194\180\050\197\084\000\177\068\069\130\057\195\128\220\220\211\030\128\188\132\043\117\020\016\243\231\186\221\194\180\050\197\084\000\209\068\069\130\057\195\057\223\030\086\146\183\146\048\027\034\102\240\010\226\214\035\242\221\048\197\156\089\139\068\165\089\056\195\014\125\060\012\085\065\174\069\096\189\221\239\083\158\066\043\242\221\048\197\156\089\171\068\165\089\056\195\191\199\184\243\120\208\171\034\055\239\064\194\237\064\085\000\104\087\036\197\066\005\025\068\017\042\056\195\243\229\255\163\041\077\248\013\026\162\081\009\080\094\240\144\159\224\037\197\040\121\011\068\038\140\044\195\133\221\091\072\192\204\212\230\079\089\018\234\054\223\003\239\159\224\021\197\081\242\150\067\038\140\044\195\018\194\049\099\251\021\185\232\252\118\185\013\136\128\142\181\159\224\037\197\081\242\150\067\038\140\044\195\019\080\102\255\031\004\054\237\076\193\178\134\245\208\221\053\081\203\166\196\216\152\216\067\013\143\043\195\252\086\043\153\109\151\086\093\107\040\109\150\088\110\028\128\081\203\134\196\216\152\216\067\013\143\043\195\154\061\186\044\118\166\114\149\137\153\150\108\021\123\110\140\104\031\010\197\133\058\093\067\201\109\043\195\223\125\237\123\104\000\034\109\132\060\201\208\112\101\117\079\104\031\026\197\133\058\093\067\201\109\043\195\180\132\148\218\042\095\091\069\136\082\155\199\127\086\014\245\104\031\026\197\066\157\238\067\201\109\043\195\047\045\070\118\097\092\082\221\110\093\085\219\079\029\244\125\132\243\254\196\154\131\029\068\117\136\040\195\132\116\163\201\228\029\245\068\116\165\049\241\031\160\072\179\132\243\254\196\154\131\093\068\117\136\040\195\091\135\006\080\092\143\168\034\232\079\199\101\238\150\017\255\132\243\222\196\154\131\029\068\117\136\040\195\185\053\112\136\007\015\074\072\020\254\047\041\182\010\182\130\098\067\034\196\246\001\140\067\074\158\039\195\244\144\024\195\090\175\082\177\079\104\009\193\067\255\085\182\098\067\098\196\246\001\140\067\074\158\039\195\014\119\132\115\207\056\101\207\096\177\190\080\022\186\139\023\074\206\168\196\083\053\091\067\012\028\033\195\170\062\233\131\236\102\208\208\055\169\172\093\026\231\095\121\184\226\022\196\044\058\156\066\001\117\030\195\104\068\191\101\030\097\051\163\193\228\004\084\107\157\185\076\184\226\022\196\139\014\167\067\001\117\030\195\051\051\160\022\055\098\200\042\255\064\152\136\189\052\165\247\184\226\086\196\044\058\156\066\001\117\030\195\038\038\139\124\165\024\014\088\088\252\104\149\042\147\217\069\023\167\032\197\103\153\017\068\126\126\028\195\067\119\188\141\094\059\136\015\240\157\170\060\212\089\138\200\132\197\207\196\250\033\205\067\113\138\021\195\141\115\099\220\154\101\190\235\102\126\160\215\004\164\145\068\132\197\239\196\250\033\205\067\113\138\021\195\031\171\024\134\119\117\200\070\123\190\137\031\202\234\017\002\132\197\239\196\253\144\038\068\113\138\021\195\190\157\164\184\210\024\064\253\085\248\034\231\094\062\204\088\185\116\146\196\019\250\156\194\015\096\021\195\219\026\066\184\234\229\116\114\158\095\085\091\038\240\067\252\185\116\146\196\245\130\049\067\015\096\021\195\053\073\164\002\026\019\007\158\246\164\057\254\121\110\152\251\115\233\100\196\019\250\156\194\015\096\021\195\090\217\151\249\254\058\088\216\123\034\203\006\108\014\000\054\115\233\100\196\245\130\049\067\015\096\021\195\079\093\028\104\199\107\036\031\208\077\132\125\182\002\246\249\029\121\158\196\255\147\148\193\127\078\021\195\200\055\182\181\109\114\138\090\015\077\009\250\081\231\192\004\029\121\158\196\063\073\137\195\127\078\021\195\242\090\174\084\249\068\089\090\045\111\038\222\021\028\178\125\029\121\190\196\063\073\137\195\127\078\021\195\182\227\089\202\038\037\101\013\196\015\025\127\041\140\211\170\029\121\190\196\255\147\148\193\127\078\021\195\125\235\044\125\074\111\074\082\180\197\135\006\118\242\240\122\029\121\190\196\159\164\004\196\127\078\021\195\114\139\199\157\028\160\057\243\181\014\117\218\105\085\105\209\235\068\213\196\192\137\152\067\242\206\019\195\123\043\051\164\178\132\035\051\233\155\138\186\255\022\172\021\240\132\031\196\088\143\054\067\009\123\014\195\072\058\041\100\156\200\093\179\158\003\131\160\182\189\096\013\240\132\095\196\088\143\054\067\009\123\014\195\203\028\226\007\027\210\130\115\163\228\036\097\220\021\232\154\036\133\206\196\025\243\001\195\117\230\011\195\195\097\186\244\061\156\126\019\113\191\103\144\214\114\026\186\124\163\138\196\178\096\164\067\200\007\000\195\168\244\144\071\100\232\026\218\023\119\072\155\172\208\222\190\077\132\242\196\061\234\199\067\006\067\247\194\039\191\012\072\088\155\242\117\164\239\219\254\190\167\101\009\252\189\159\196\000\092\132\066\163\089\240\194\201\185\212\103\105\250\022\196\126\131\025\015\085\074\233\210\216\074\185\196\245\181\254\194\163\089\240\194\015\011\087\018\015\135\196\058\193\062\151\098\209\121\168\181\172\095\160\196\211\068\231\067\115\074\237\194\051\016\137\123\240\062\185\124\126\170\140\094\032\199\027\029\027\176\172\196\223\126\234\067\213\178\235\194\007\031\033\015\021\135\098\231\214\009\058\110\089\174\159\119\027\176\172\196\190\253\084\067\213\178\235\194\240\119\154\227\135\054\127\210\017\243\146\153\107\116\023\014\027\176\140\196\190\253\084\067\213\178\235\194\176\152\140\087\044\144\028\112\115\178\149\148\070\188\131\189\027\176\140\196\223\126\234\067\213\178\235\194\029\007\097\192\030\064\004\229\243\206\173\010\236\054\197\060\003\015\214\196\191\091\113\067\085\154\216\194\046\166\110\065\070\163\051\007\152\096\217\108\025\232\208\165\171\115\217\196\057\050\181\194\070\018\215\194\225\018\214\060\209\215\204\124\192\237\251\066\238\013\014\170\197\211\205\196\162\175\160\066\070\018\215\194\216\140\194\085\042\247\234\106\016\220\107\223\165\090\058\125\061\152\147\196\179\237\080\067\252\052\214\194\219\133\065\002\076\027\186\127\063\112\069\182\046\249\227\175\025\137\215\196\147\133\022\068\052\196\202\194\064\218\067\034\187\008\200\251\111\158\039\034\212\058\233\183\122\098\208\196\222\014\036\068\100\108\202\194\205\094\160\030\012\209\149\064\092\135\038\165\205\136\179\043\125\129\225\196\088\069\036\068\217\241\199\194\044\133\042\114\097\019\192\213\138\151\090\134\071\019\197\193\203\138\233\196\242\127\096\067\031\054\199\194\220\184\055\240\121\043\217\173\143\110\185\135\240\223\205\044\081\142\232\196\162\095\128\067\182\039\199\194\226\123\225\093\017\146\013\062\075\185\184\001\176\085\012\171\155\055\212\196\244\033\223\067\014\216\197\194\033\081\157\103\191\181\036\255\216\214\166\021\121\025\078\130\227\094\207\196\240\099\240\067\127\164\197\194\174\162\191\059\045\065\238\155\005\145\082\254\123\102\099\069\044\085\173\196\225\219\105\067\207\011\185\194\244\211\188\040\155\006\141\003\156\008\017\092\189\133\118\151\034\180\192\196\238\188\014\064\206\011\185\194\250\003\231\125\201\201\050\062\068\201\063\032\153\009\088\090\160\117\129\196\240\158\231\067\138\070\176\194\125\031\032\162\106\012\002\060\033\237\068\116\149\114\186\057\160\117\161\196\240\158\231\067\138\070\176\194\103\087\236\089\253\235\251\122\238\245\134\211\236\209\035\114\115\131\218\196\004\106\222\067\175\048\175\194\196\009\031\102\019\043\223\112\252\220\249\111\099\061\222\068\137\009\205\196\224\086\206\067\121\096\173\194",
	["Blackrock Spire"] = "\029\179\202\140\245\076\021\180\097\141\066\035\158\121\177\147\253\002\061\067\095\022\133\064\027\151\065\195\214\096\058\046\132\098\254\146\184\161\030\238\068\049\111\172\003\250\133\194\076\215\123\195\027\151\065\195\098\095\198\097\162\009\085\239\000\085\127\212\069\095\144\033\128\126\161\195\076\215\123\195\027\151\065\195\099\070\236\152\147\036\247\197\252\162\070\170\060\135\150\220\128\126\161\195\095\022\133\064\027\151\065\195\252\010\236\069\199\195\190\006\236\186\245\014\145\004\181\102\003\250\133\194\095\022\133\064\027\151\065\195\192\152\093\019\001\150\081\241\062\164\204\198\203\042\235\111\243\204\166\195\091\057\018\067\239\051\065\195\074\137\155\087\063\170\017\149\196\149\150\189\119\060\190\137\023\102\050\067\091\057\018\067\239\051\065\195\075\175\119\064\226\102\171\192\014\252\057\223\198\037\100\165\243\204\166\195\173\028\201\067\239\051\065\195\028\143\217\217\129\100\065\025\007\036\155\250\059\142\117\020\207\051\155\194\091\057\018\067\239\051\065\195\002\220\158\081\116\234\023\103\022\222\112\067\107\155\137\184\207\051\155\194\173\028\201\067\239\051\065\195\168\027\192\254\094\048\137\139\092\024\103\013\077\033\200\062\191\078\108\195\137\133\029\068\015\230\148\194\095\025\220\068\179\040\242\159\199\124\176\219\089\251\100\022\255\137\157\065\137\133\029\068\015\230\148\194\006\010\126\246\041\003\134\117\254\082\139\053\019\229\250\235\191\078\108\195\137\133\093\068\015\230\148\194\217\103\001\024\065\023\114\211\090\044\038\131\124\022\232\006\255\137\157\065\137\133\093\068\015\230\148\194\113\174\105\140\143\247\080\191\018\019\009\040\094\077\128\118\159\216\137\067\137\133\029\068\015\230\148\194\047\140\227\116\031\058\170\188\153\160\029\013\223\094\195\230\025\096\067\067\213\083\110\068\063\054\031\194\240\033\181\027\201\054\100\009\028\231\028\037\214\191\179\092\120\035\099\193\086\249\105\068\035\064\028\194\045\153\117\181\058\196\037\207\066\141\080\170\250\061\207\081\018\248\075\195\031\214\117\068\091\007\026\194\180\216\060\021\229\150\082\031\149\019\149\118\125\040\239\196\179\031\080\066\031\214\117\068\091\007\026\194\160\218\251\140\230\253\084\148\222\023\051\206\113\184\006\245\227\121\087\065\219\123\093\068\135\006\024\194\248\210\123\031\033\136\131\236\224\247\223\080\201\037\207\176\077\246\048\193\163\020\141\068\115\028\023\194\018\098\018\178\124\229\210\228\057\018\069\200\083\012\030\206\228\085\213\066\102\154\093\068\092\096\021\194\235\052\252\009\021\123\160\102\069\094\212\074\052\118\193\198\016\058\115\066\012\129\093\068\090\096\021\194\076\142\197\228\164\040\150\001\184\200\138\126\003\046\179\093\202\032\123\067\244\058\090\068\204\134\132\065\022\237\020\209\069\199\245\234\187\072\223\184\199\027\120\083\182\024\219\194\110\088\009\068\059\016\153\065\002\131\245\158\211\253\099\118\156\161\051\098\135\198\083\126\012\035\129\065\229\203\093\068\211\036\255\065\099\086\062\095\095\086\246\139\032\018\165\149\156\195\105\136\013\113\245\066\163\153\109\068\057\204\001\066\047\049\028\213\123\019\182\113\100\200\172\110\171\078\035\108\163\109\192\194\138\078\015\068\143\023\046\066\108\143\195\059\107\009\046\060\096\246\193\071\113\083\143\114\222\234\040\067\019\122\105\068\101\200\064\066\222\141\114\070\243\174\012\076\200\101\246\219\056\037\153\032\114\003\113\066\127\152\093\068\073\133\105\066\038\026\068\071\100\046\031\079\216\014\116\025\160\148\166\134\118\232\143\065\184\141\018\068\143\042\116\066\068\103\007\099\168\216\158\172\228\046\016\024\016\022\093\202\094\179\038\066\054\048\052\068\070\022\124\066\049\013\242\050\102\128\186\211\213\058\052\094\006\130\015\162\159\219\228\194\021\195\248\067\104\213\157\066\152\129\047\142\044\253\220\138\135\185\029\082\108\016\125\011\056\150\095\194\099\045\000\068\122\178\168\066\182\235\137\152\009\060\221\140\048\248\124\255\208\025\135\024\077\006\078\194\195\146\236\067\071\252\168\066\071\196\007\104\177\220\249\125\057\169\005\147\164\093\033\135\086\031\039\195\096\218\203\067\088\121\176\066\245\249\209\179\150\128\213\243\142\204\210\152\056\057\215\026\011\111\095\194\105\244\041\068\052\174\192\066\074\223\203\001\008\089\217\217\015\100\012\177\013\009\231\197\203\236\177\194\110\218\042\068\230\127\194\066\155\018\241\035\127\226\105\005\170\090\204\143\162\003\026\081\007\106\046\195\197\230\222\067\089\104\198\066\211\002\219\032\154\039\048\119\008\233\114\066\254\138\165\002\056\202\255\194\221\200\022\068\250\224\214\066\217\252\247\181\096\103\004\194\083\007\100\008\166\080\175\179\095\120\095\195\037\164\022\068\250\224\214\066\088\094\117\077\017\206\087\055\209\041\075\143\236\093\226\056\095\120\095\195\100\217\031\068\215\116\215\066\228\103\158\058\199\016\036\239\228\023\008\205\132\049\187\038\056\202\255\194\198\217\031\068\186\138\215\066\046\136\186\165\006\133\155\083\045\032\030\157\090\218\090\186\197\028\090\195\072\064\254\067\244\145\215\066\255\088\186\114\208\151\131\086\095\189\057\161\031\135\073\089\217\081\068\067\068\199\027\068\179\218\225\066\048\036\003\196\239\090\051\240\214\117\115\091\099\134\049\078\135\079\134\067\072\241\053\068\077\183\231\066\214\087\054\226\103\163\138\253\023\079\018\017\023\255\090\221\039\182\073\195\069\059\042\068\251\244\240\066\061\126\168\205\206\187\079\172\226\148\067\052\156\108\154\238\096\204\176\067\065\165\018\068\059\013\255\066\062\147\153\041\000\089\014\167\240\001\142\183\014\133\036\119\105\063\158\067\193\167\028\068\090\122\000\067\172\061\092\115\154\183\220\207\238\065\076\119\250\016\251\202\105\063\158\067\193\167\092\068\090\122\000\067\090\150\092\185\225\075\114\135\021\162\049\037\086\131\125\137\114\057\135\067\208\049\041\068\080\195\000\067\239\103\240\098\056\211\039\120\048\186\100\073\235\181\255\247\010\009\119\195\056\227\027\068\043\222\002\067\018\105\177\234\002\173\198\046\164\246\089\228\016\112\235\072\111\140\167\066\249\169\013\068\016\022\005\067\190\018\026\199\237\187\083\242\187\113\042\235\246\103\032\194\247\233\093\195\151\064\248\067\089\159\013\067\109\007\215\128\147\140\134\089\173\105\014\143\222\018\253\040\251\244\238\195\151\064\248\067\089\159\013\067\151\172\240\196\028\085\208\140\015\068\070\184\075\219\008\045\007\144\189\066\152\165\045\068\240\165\013\067\090\149\247\173\057\064\201\026\019\218\007\008\209\140\124\191\246\134\233\195\018\204\004\068\209\184\025\067\100\118\239\152\226\248\114\246\149\134\100\228\213\232\052\159\077\168\031\193\000\067\091\068\244\018\027\067\244\038\059\170\176\047\171\247\169\166\109\155\202\224\226\057\043\083\215\195\231\105\251\067\086\031\036\067\017\205\143\049\144\073\143\091\083\090\230\087\154\149\061\198\212\166\230\195\090\205\253\067\086\031\036\067\184\104\215\186\112\172\224\046\225\149\109\157\151\103\053\078\233\015\180\067\206\067\094\068\146\185\046\067\014\190\061\100\236\109\029\134\238\237\058\120\184\121\254\056\122\015\097\195\238\162\231\067\212\055\049\067\088\203\029\225\195\195\228\169\078\104\045\070\041\037\229\101\076\021\176\194\040\164\024\068\149\123\053\067\099\141\033\248\001\219\119\241\217\140\245\226\190\001\093\168\194\116\176\195\078\079\228\067\059\082\054\067\235\242\109\098\224\034\240\102\188\034\147\201\221\157\082\070\077\196\130\195\046\115\252\067\199\208\084\067\025\225\221\237\233\077\218\251\022\191\177\092\045\180\100\177\000\180\130\195\111\141\024\068\199\208\084\067\169\137\107\003\250\210\030\046\038\160\149\213\047\037\204\023\028\199\172\195\222\002\239\067\248\079\085\067\016\167\073\014\207\204\209\010\167\119\081\096\180\216\078\171\015\058\149\195\088\040\122\068\158\163\085\067\205\167\202\010\157\096\088\190\209\087\190\019\078\096\252\049\127\208\041\194\088\040\122\068\158\163\085\067\125\153\109\028\218\085\022\197\150\144\136\131\180\219\103\081\191\128\089\195\170\091\074\068\255\186\091\067\234\001\167\088\053\053\140\234\021\231\151\024\223\177\078\126\157\085\225\195\050\209\051\068\148\227\092\067\163\226\249\033\074\062\140\145\029\243\247\097\092\181\152\097\006\203\169\194\104\234\049\068\028\051\093\067\048\045\028\244\005\066\234\255\105\226\239\236\106\013\005\150\234\163\026\195\197\163\106\068\019\185\093\067\049\098\039\239\036\193\130\197\014\160\130\099\055\192\068\005\093\111\068\195\249\246\089\068\019\185\093\067\176\205\083\212\244\228\004\207\102\223\212\060\082\134\060\194\064\108\068\195\055\207\062\068\019\185\093\067\146\163\113\146\037\044\001\247\121\030\123\126\013\178\226\088\063\228\216\194\175\183\091\068\080\199\093\067\096\171\143\061\120\199\109\141\057\060\062\029\203\255\198\018\233\156\177\194\133\223\022\068\058\205\093\067\239\009\180\017\244\107\172\094\079\053\065\106\088\235\205\031\035\186\177\194\000\117\247\067\182\212\093\067\076\050\018\239\045\182\218\170\004\140\163\050\052\061\083\104\178\194\219\195\079\091\105\068\061\006\104\067\077\180\152\148\015\015\189\207\127\082\244\225\184\085\254\097\160\192\194\195\177\007\052\068\227\112\104\067\033\162\026\121\028\053\006\143\023\025\094\017\169\010\059\248\093\165\026\195\178\249\051\068\227\112\104\067\218\213\052\034\172\068\087\181\170\010\053\113\093\106\224\244\021\017\089\195\110\131\101\068\230\112\104\067\225\252\024\186\054\171\055\098\156\116\150\247\050\223\250\217\149\018\089\195\099\152\047\068\234\109\105\067\060\094\144\205\032\004\149\110\220\163\191\106\127\130\187\077\013\077\123\195\230\093\052\068\127\141\105\067\228\100\083\247\023\102\018\008\186\175\248\074\097\221\242\169\141\075\123\195\067\169\106\068\022\161\105\067\060\178\164\142\073\056\232\018\100\181\213\069\138\055\197\195\234\050\039\196\070\245\080\068\198\183\120\067",
	["Blackwing Lair"] = "\175\255\022\229\085\060\096\133\044\180\249\137\214\242\110\225\208\171\193\195\050\209\051\068\148\227\092\067\083\203\115\014\071\162\086\165\069\031\209\222\130\224\218\075\234\163\026\195\197\163\106\068\019\185\093\067\244\165\000\125\012\126\020\146\157\061\045\221\106\016\255\228\063\228\216\194\175\183\091\068\080\199\093\067\085\127\141\027\117\081\252\088\087\143\224\161\004\135\149\154\099\205\040\196\230\120\149\068\079\104\104\067\232\029\092\050\242\251\184\240\243\120\096\217\248\037\253\053\199\154\209\195\230\120\149\068\079\104\104\067\190\190\138\148\181\097\219\174\247\159\131\230\061\128\103\035\021\017\089\195\110\131\101\068\230\112\104\067\049\177\144\155\060\150\253\070\207\008\106\022\120\191\143\092\178\194\219\195\165\215\105\068\244\143\105\067\018\045\001\194\169\074\210\049\233\158\240\001\169\253\088\253\141\075\123\195\067\169\106\068\022\161\105\067\092\032\141\051\036\184\014\169\236\231\185\089\212\185\242\184\234\050\039\196\070\245\080\068\139\171\126\067\252\012\076\037\204\140\022\227\116\197\129\174\017\041\247\142\101\041\044\196\005\255\106\068\106\167\128\067\224\249\226\132\195\048\136\100\017\056\094\032\189\226\010\010\218\114\087\196\242\157\098\068\217\177\128\067\199\017\090\130\022\184\169\012\091\046\099\197\058\117\040\100\190\165\090\196\255\179\045\068\208\171\139\067\228\245\185\151\093\112\180\117\095\130\189\137\054\012\125\165\213\156\056\196\190\027\034\068\065\139\148\067\004\019\244\209\064\030\055\199\208\099\164\029\069\124\147\158\086\074\038\196\182\110\089\068\208\173\159\067\120\131\087\184\134\154\072\169\085\205\079\054\091\063\112\091\105\178\038\196\067\228\044\068\040\037\160\067\231\133\119\156\101\018\023\144\108\013\176\214\151\167\121\024\211\100\205\195\067\228\108\068\040\037\160\067\088\165\150\194\252\048\121\244\002\200\171\229\105\003\110\238\211\100\205\195\067\228\044\068\040\037\160\067\116\226\073\118\082\205\082\114\123\011\188\011\196\158\162\237\105\178\038\196\067\228\108\068\040\037\160\067\027\196\099\220\168\069\077\100\189\161\007\140\159\125\245\174\224\227\091\196\094\171\091\068\092\237\163\067\090\061\038\037\136\145\150\093\191\119\125\011\213\068\098\015\143\042\098\196\082\163\072\068\205\103\169\067\016\136\094\202\250\172\099\043\104\082\176\169\159\255\042\070\152\017\130\196\152\229\063\068\187\010\185\067\023\043\238\170\194\155\051\017\076\236\157\079\147\068\077\026\152\017\130\196\152\229\127\068\187\010\185\067\163\087\118\125\066\148\230\156\022\235\109\146\120\234\042\073\095\221\135\196\085\181\129\068\100\031\185\067\225\243\181\055\192\200\082\000\119\071\196\158\006\118\251\053\191\186\079\196\085\181\129\068\100\031\185\067\240\120\151\007\055\081\180\164\027\160\149\214\074\001\127\243\097\035\018\196\114\100\141\068\130\236\188\067\025\010\171\067\241\138\108\211\075\085\228\173\036\078\192\001\012\136\199\195\114\100\141\068\130\236\188\067\028\054\077\085\032\040\124\198\141\241\033\177\137\020\032\205\050\170\077\196\022\134\112\068\200\169\196\067\109\079\100\169\196\033\117\213\225\026\143\171\092\186\058\225\063\191\057\196\133\137\149\068\158\178\196\067\252\115\179\062\161\046\114\141\006\142\081\021\241\137\161\097\197\051\039\196\143\076\152\068\159\178\196\067",
	["Cathedral"] = "\105\062\059\131\146\174\254\099\238\135\049\080\064\053\033\109\137\193\131\196\255\170\235\195\203\015\141\191\063\069\151\089\020\218\215\051\083\220\096\217\215\075\186\195\137\193\131\196\255\085\087\195\203\015\141\191\248\246\049\075\104\002\211\228\074\173\141\217\240\162\238\046\019\131\071\196\255\170\235\195\203\015\141\191\044\043\159\081\155\087\043\123\063\214\024\207\188\250\040\084\019\131\071\196\255\085\087\195\203\015\141\191\022\072\168\185\161\033\200\219\189\215\230\129\218\102\232\036\019\131\007\196\255\170\235\195\203\015\141\191\231\223\017\157\047\117\041\101\075\212\172\084\060\108\006\122\019\131\007\196\255\085\087\195\203\015\141\191\138\052\080\085\056\222\230\179\050\161\138\206\012\056\195\230\155\246\154\195\195\097\060\195\033\220\026\065\082\130\209\107\251\185\202\227\073\243\033\249\150\024\005\157\077\123\013\196\225\048\222\195\033\220\026\065\180\137\149\023\109\091\000\024\097\214\185\195\250\159\210\129\077\123\013\196\195\097\060\195\033\220\026\065\237\082\053\117\108\248\006\106\017\094\113\014\210\195\069\069\155\246\154\195\225\048\222\195\033\220\026\065\195\224\165\096\149\237\141\154\142\172\147\238\097\010\006\109\164\095\157\195\167\229\102\194\167\110\207\065\202\219\046\031\036\026\123\140\196\035\094\067\225\171\084\061\019\159\174\195\177\129\140\194\119\133\015\066\231\075\129\053\021\199\156\213\001\024\066\016\092\206\019\241\159\179\174\195\153\055\034\195\119\133\015\066\057\088\015\099\093\155\217\117\072\106\044\205\233\048\255\193\099\159\174\195\126\073\003\195\119\133\015\066\169\151\219\217\134\073\077\065\079\083\074\118\057\014\190\106\099\159\174\195\061\230\201\194\119\133\015\066\174\143\092\149\155\092\204\157\003\162\051\029\145\239\083\153\088\113\173\195\204\128\210\065\099\136\015\066\235\021\204\077\047\239\204\105\137\093\125\171\124\231\161\174\137\238\179\195\045\152\109\195\158\172\015\066\051\037\196\144\004\048\240\138\083\163\126\127\202\129\054\168\159\179\174\195\155\213\062\195\098\211\015\066\073\221\229\113\085\047\093\251\124\239\165\057\033\105\036\082\019\218\146\195\007\163\167\194\142\173\019\066\174\075\010\184\183\039\087\125\117\229\190\133\124\094\174\038\018\004\147\195\096\243\090\066\015\111\020\066\210\225\245\168\119\116\029\018\196\172\157\139\150\082\248\210\166\095\157\195\209\115\156\065\203\037\021\066\130\252\015\012\234\079\192\111\062\093\146\224\194\196\102\017\059\137\140\195\097\228\077\194\029\049\021\066\203\139\040\169\179\070\250\031\001\223\175\042\070\134\045\065\150\233\010\195\114\225\010\194\017\050\021\066\161\194\133\007\121\145\208\225\242\096\001\209\186\202\054\108\163\233\010\195\201\122\072\065\017\050\021\066\095\183\019\141\035\029\135\226\105\110\055\099\014\142\210\054\000\112\128\196\177\164\109\195\222\130\101\066\221\162\135\037\207\124\006\064\042\010\180\099\174\177\089\044\130\033\106\196\219\140\168\194\089\248\113\066\205\238\083\240\239\139\000\019\043\239\208\107\236\214\155\196\130\033\106\196\054\035\170\195\089\248\113\066\043\238\076\237\224\123\141\169\068\002\168\014\058\239\227\082\193\199\104\196\019\032\166\195\102\055\114\066\229\240\090\067\194\188\083\020\104\227\039\107\005\066\025\184\047\200\104\196\126\225\147\195\102\055\114\066\215\116\077\118\177\186\116\016\116\195\069\229\102\227\197\136\193\199\104\196\006\157\255\194\006\057\114\066\157\095\222\202\209\075\067\158\116\166\112\074\118\087\050\044\193\199\104\196\172\244\202\194\013\057\114\066\069\112\127\170\105\205\017\114\003\133\074\128\212\177\169\141\114\113\108\196\109\048\088\195\095\142\127\066\007\053\059\072\252\125\078\171\129\230\035\176\239\112\181\060\180\228\129\196\225\189\121\195\013\206\173\066",
	["Dire Maul"] = "\176\038\053\046\091\120\108\084\255\152\163\082\015\099\225\060\093\149\130\067\099\203\153\196\170\250\111\195\026\071\017\141\240\199\217\080\120\144\111\142\046\186\124\198\174\074\001\068\199\150\051\196\170\250\111\195\255\195\128\244\116\007\074\187\038\046\002\228\223\012\203\122\174\074\065\068\199\150\115\196\170\250\111\195\033\029\209\060\183\168\087\017\223\095\250\211\150\059\001\157\174\074\001\068\199\150\115\196\170\250\111\195\036\015\020\180\206\229\178\086\120\057\032\068\253\108\162\113\093\149\130\067\199\150\115\196\170\250\111\195\115\232\076\081\081\138\167\038\044\038\148\002\043\206\043\177\093\149\130\067\199\150\051\196\170\250\111\195\015\152\234\127\174\026\240\205\044\200\084\129\014\014\128\182\174\074\001\068\099\203\153\196\170\250\111\195\184\052\150\232\071\018\182\088\103\124\194\161\189\054\053\005\236\017\245\067\235\058\066\196\124\113\106\195\081\026\239\102\151\138\186\216\181\096\143\109\134\215\180\076\141\236\004\068\081\028\049\196\093\128\078\195\144\095\206\142\040\003\079\098\038\221\053\094\187\211\022\150\056\215\239\067\105\212\026\196\191\187\042\195\195\178\213\104\216\027\200\095\031\021\206\162\003\168\099\110\012\020\120\195\015\095\109\196\165\146\244\194\110\158\214\047\147\126\209\010\153\255\246\234\139\171\155\204\095\126\253\064\015\095\109\196\165\146\244\194\028\047\254\228\051\068\064\221\198\167\130\198\242\230\248\157\187\006\130\194\205\195\058\196\001\161\237\194\014\039\079\141\169\147\150\036\224\000\220\215\032\132\242\045\187\006\130\194\155\135\245\195\001\161\237\194\089\081\088\204\113\132\250\191\063\117\199\046\192\240\187\255\161\252\062\067\205\195\058\196\001\161\237\194\241\109\030\092\063\110\067\150\130\202\188\022\101\117\094\020\161\252\062\067\155\135\245\195\001\161\237\194\091\145\126\037\087\031\038\096\072\116\064\224\153\090\168\161\174\129\160\195\205\195\058\196\001\161\237\194\044\163\216\199\024\142\093\052\029\028\027\057\124\125\186\056\174\129\160\195\155\135\245\195\001\161\237\194\078\149\120\114\099\234\106\172\066\221\244\040\111\143\169\253\050\134\160\195\151\108\129\196\209\071\234\194\214\029\235\246\238\154\041\223\121\168\151\029\234\093\125\009\104\130\151\195\130\239\077\196\197\105\230\194\118\003\162\251\230\050\164\222\023\110\144\129\145\184\161\154\080\161\083\066\058\161\120\196\234\139\228\194\244\193\247\076\254\001\079\183\053\097\054\009\079\149\153\058\167\142\132\195\000\141\075\196\076\056\228\194\044\066\171\089\028\162\035\103\121\208\180\080\034\105\242\076\062\242\147\195\213\004\062\196\047\045\228\194\168\216\040\144\146\016\180\062\061\032\201\044\160\132\126\182\097\022\234\067\036\133\025\196\083\128\226\194\041\147\250\034\007\006\068\216\043\035\240\153\207\004\091\224\080\061\183\067\106\026\014\196\083\128\226\194\074\012\104\091\107\177\214\051\170\118\061\240\249\131\041\046\040\241\130\067\219\025\014\196\254\099\226\194\084\106\022\001\072\208\204\181\221\173\077\086\041\063\233\230\167\111\000\068\252\072\036\196\245\086\226\194\025\129\109\104\087\127\233\220\180\148\232\010\007\232\002\009\091\025\194\067\019\011\007\196\070\245\201\194\008\049\222\039\139\033\249\105\227\247\028\116\190\068\133\055\041\107\082\067\227\084\140\068\024\000\194\194\156\176\070\086\236\099\246\082\247\111\126\255\022\124\039\057\041\107\082\067\198\169\088\068\024\000\194\194\144\170\134\189\127\037\159\151\046\019\149\044\004\204\054\009\004\035\163\067\211\131\078\068\211\012\191\194\000\055\188\154\220\135\161\013\149\101\047\060\167\167\147\190\224\153\252\067\014\034\055\068\207\012\191\194\021\048\248\121\042\249\001\145\208\111\067\125\173\130\097\223\220\082\173\067\019\228\083\068\080\241\187\194\089\222\198\040\142\191\115\218\046\068\116\241\219\174\159\085\211\053\013\068\139\002\224\195\166\135\186\194\205\202\189\166\115\186\205\020\146\130\020\054\236\066\127\149\166\107\154\067\069\001\048\196\166\135\186\194\093\203\196\110\255\017\212\105\055\047\107\001\061\045\221\247\211\053\013\068\069\001\048\196\166\135\186\194\071\166\158\199\095\212\004\057\236\226\148\232\035\225\145\196\211\053\013\068\069\001\112\196\166\135\186\194\193\002\137\107\128\193\024\185\211\011\111\235\100\030\161\030\211\053\077\068\069\001\112\196\166\135\186\194\065\218\186\088\138\111\128\147\081\192\096\117\000\168\226\027\166\107\154\067\162\000\184\196\166\135\186\194\211\250\012\129\060\129\199\011\109\093\002\098\051\225\161\124\088\148\229\195\139\002\224\195\166\135\186\194\087\209\081\066\212\115\242\009\126\205\234\210\220\100\034\253\088\148\229\195\069\001\112\196\166\135\186\194\248\142\078\214\142\229\114\172\238\225\231\111\219\075\223\028\177\040\075\195\069\001\112\196\166\135\186\194\048\105\134\208\203\059\048\139\141\212\075\224\049\036\118\078\041\175\022\068\029\032\017\068\037\125\171\194\238\074\061\033\047\010\246\062\157\026\136\133\223\063\147\238\035\227\239\194\201\253\066\196\232\221\164\194\224\007\022\246\066\047\101\105\154\023\171\043\116\156\066\246\200\248\187\195\201\253\066\196\232\221\164\194\100\082\221\120\154\207\024\006\181\142\019\217\161\210\088\038\200\248\187\195\201\253\002\196\232\221\164\194\134\218\093\138\074\056\012\049\183\121\206\145\001\068\035\015\109\014\008\067\201\253\002\196\232\221\164\194\046\165\134\070\099\162\172\216\177\105\158\209\228\133\099\042\109\014\008\067\201\253\066\196\232\221\164\194\212\101\054\136\104\036\054\043\142\141\245\182\183\021\046\081\035\227\239\194\201\253\002\196\232\221\164\194\074\180\217\217\216\047\248\193\010\053\069\056\119\250\074\248\207\115\022\068\180\007\217\067\002\213\151\194\221\018\066\184\164\232\114\120\147\217\109\230\098\175\251\074\009\198\214\193\149\174\070\067\048\099\146\194\099\185\205\013\030\185\179\073\018\253\051\072\117\060\011\009\165\198\214\193\107\023\005\067\168\098\146\194\255\200\166\249\039\061\220\209\135\108\035\177\199\071\151\048\207\246\114\066\081\030\038\067\167\098\146\194\169\001\072\184\119\042\223\087\132\171\253\051\064\061\189\122\066\196\031\068\121\119\152\067\030\242\145\194\192\042\159\228\182\132\118\235\110\050\005\048\026\080\037\171\162\148\060\193\150\149\120\196\102\193\145\194\032\195\022\042\138\109\101\004\075\228\255\198\101\149\103\107\085\144\158\192\083\184\010\067\100\077\145\194\188\182\058\169\125\040\183\108\235\205\201\010\028\017\235\142\222\228\112\194\077\116\117\067\247\072\145\194\099\083\129\228\240\254\000\240\076\060\082\030\006\088\222\091\001\057\119\194\069\148\133\067\247\072\145\194\173\057\098\143\015\122\067\194\138\071\081\041\046\057\001\245\245\145\168\065\124\001\221\066\055\070\145\194\249\227\031\252\230\011\022\116\096\235\255\131\078\119\009\027\164\053\167\065\143\070\088\066\055\070\145\194\242\225\153\091\145\165\158\221\230\163\009\178\153\204\161\238\058\222\070\068\073\090\110\067\243\082\143\194\155\206\043\172\178\141\148\249\205\242\233\004\140\211\048\222\058\222\006\068\073\090\110\067\243\082\143\194\008\219\210\133\211\224\177\057\249\232\208\108\230\118\047\018\058\222\070\068\175\045\141\193\243\082\143\194\101\013\223\124\107\061\227\181\039\028\080\095\126\069\229\078\058\222\070\068\218\210\136\195\243\082\143\194\000\068\074\108\232\063\147\230\014\051\176\231\163\136\141\240\058\222\006\068\175\045\141\193\243\082\143\194\216\248\235\224\157\239\157\005\226\055\003\251\025\253\127\167\102\020\045\068\102\127\044\067\243\082\143\194\028\223\180\043\002\131\027\181\190\156\089\051\190\198\246\009\058\222\006\068\218\210\136\195\243\082\143\194\032\180\207\089\193\010\245\136\118\037\176\123\150\032\053\207\104\230\203\194\100\168\150\067\086\040\138\194\247\149\202\175\013\175\113\096\104\136\255\090\189\208\089\000\123\029\191\066\038\218\213\068\184\091\132\194\012\163\054\158\112\007\109\237\021\099\182\216\243\011\227\014\160\056\208\195\038\218\213\068\184\091\132\194\128\058\024\212\079\154\129\003\166\149\146\205\175\168\073\242\065\113\032\195\038\218\149\068\184\091\132\194\065\071\016\209\046\170\170\155\160\123\012\075\148\014\007\233\160\056\208\195\038\218\181\068\184\091\132\194\009\236\110\084\191\047\047\071\124\092\255\015\249\054\192\254\123\029\191\066\038\218\181\068\184\091\132\194\007\243\089\200\007\061\190\106\190\181\057\080\240\126\162\188\160\056\208\195\038\218\149\068\184\091\132\194\086\200\066\063\090\251\245\224\202\074\009\179\164\209\223\123\065\113\032\195\038\218\213\068\184\091\132\194\125\087\092\191\107\046\139\225\133\170\241\092\114\199\167\035\123\029\191\066\038\218\149\068\184\091\132\194\226\182\254\112\238\072\229\114\000\241\207\160\179\183\190\053\065\113\032\195\038\218\181\068\184\091\132\194\043\190\008\193\032\178\245\244\111\144\220\171\168\223\126\185\136\090\084\194\009\203\216\196\095\077\132\194\064\182\062\005\092\252\089\221\036\221\156\097\117\081\073\191\206\126\057\194\017\214\217\196\080\077\132\194\252\248\178\141\015\149\231\240\198\103\170\067\087\091\189\020\012\060\105\065\141\009\210\196\125\072\132\194\249\122\096\041\227\028\138\058\164\058\194\109\098\025\050\232\240\188\138\194\076\077\027\194\103\151\126\194\192\196\134\197\083\052\189\079\126\087\179\239\071\184\081\193\202\078\042\066\180\147\210\196\074\209\119\194\133\242\237\226\143\162\057\038\065\039\177\206\041\220\082\073\230\024\156\067\221\051\250\195\141\077\094\194\073\042\156\111\249\253\032\194\239\064\063\136\189\077\221\096\001\128\038\195\180\253\163\067\184\080\088\194\100\242\171\168\188\085\154\120\126\098\175\200\127\191\234\198\212\029\188\066\212\003\204\196\004\124\086\194\192\066\222\025\087\054\181\183\077\177\116\110\250\184\168\174\198\110\245\066\020\138\154\068\067\094\082\194\229\239\214\138\084\117\067\174\079\247\229\087\223\117\087\240\112\108\021\067\021\196\213\195\232\127\079\194\214\038\104\206\002\151\140\133\015\114\140\011\141\124\144\235\106\253\147\068\141\181\129\068\184\127\075\194\090\213\113\020\211\074\179\045\090\130\097\252\192\033\125\193\213\250\103\068\141\181\129\068\184\127\075\194\106\228\148\041\155\105\066\014\144\220\028\074\214\053\148\070\155\209\232\192\244\022\199\196\069\141\074\194\084\159\087\009\081\107\105\187\164\222\207\145\254\074\045\150\155\209\232\192\244\022\167\196\069\141\074\194\005\191\088\198\245\099\232\244\211\141\144\196\097\123\032\101\016\050\057\068\065\125\113\068\025\109\063\194\139\217\090\173\065\120\011\188\097\254\087\192\114\084\140\066\158\067\099\068\126\193\134\068\025\109\063\194\037\119\251\177\231\199\253\217\227\060\088\008\250\122\153\156\100\150\188\066\101\125\146\196\210\208\060\194\201\209\121\143\229\162\216\061\168\008\099\144\112\141\254\045\055\074\157\065\169\216\120\068\031\219\058\194\084\007\091\170\133\230\015\148\190\088\204\175\005\207\250\052\055\074\157\065\169\216\056\068\031\219\058\194\045\128\098\122\075\019\005\090\217\182\101\200\052\078\098\016\184\086\108\195\169\216\120\068\031\219\058\194\097\092\160\211\189\221\142\041\164\013\161\102\010\052\062\157\163\212\137\067\169\216\056\068\031\219\058\194\012\248\201\199\136\151\115\084\199\172\217\141\224\075\048\102\163\212\137\067\169\216\120\068\031\219\058\194\062\055\223\232\231\128\023\089\151\069\099\118\198\091\158\122\184\086\108\195\169\216\056\068\031\219\058\194\154\069\186\045\225\180\146\253\177\126\192\029\243\127\010\083\220\248\046\066\211\038\131\068\021\171\058\194\177\183\140\157\142\181\022\086\021\247\003\085\059\172\034\068\012\165\199\194\031\029\136\068\024\170\058\194\226\064\125\076\000\206\023\045\176\107\045\089\010\165\208\081\046\136\174\066\222\004\121\068\023\170\058\194\125\190\139\096\008\105\164\180\143\150\060\162\072\100\032\170\037\165\199\194\165\199\146\068\000\170\058\194\198\184\137\135\186\074\154\197\157\037\220\183\126\090\009\165\190\094\058\195\118\068\138\067\193\080\028\194\129\249\129\081\217\109\003\137\207\086\104\210\000\120\001\231\234\243\179\066\155\144\141\196\130\137\027\194\109\142\091\217\000\052\132\042\084\131\040\212\191\081\081\252\072\109\029\067\242\001\137\196\138\104\244\193\141\060\209\219\143\153\065\157\017\095\206\171\068\005\135\197\157\166\057\067\024\140\137\196\179\189\177\193\103\220\144\076\230\082\224\052\153\138\024\056\192\065\226\071\213\152\085\067\058\161\132\196\179\189\177\193\253\081\181\236\120\157\037\150\249\216\128\240\156\018\215\187\064\067\134\067\119\149\174\067\146\193\147\193\151\239\087\201\193\129\059\016\247\132\043\099\201\009\205\032\125\121\115\195\119\149\174\067\146\193\147\193\193\200\010\015\019\094\016\178\217\173\066\072\253\055\032\098\064\067\134\067\187\074\023\068\146\193\147\193\101\074\067\087\101\234\185\208\249\198\186\103\051\243\076\232\031\104\072\065\119\149\174\067\146\193\147\193\225\206\210\250\171\111\029\004\141\149\071\228\119\214\223\100\031\104\072\065\187\074\023\068\146\193\147\193\208\034\044\148\176\089\221\023\158\245\167\028\082\159\215\081\125\121\115\195\187\074\023\068\146\193\147\193\225\098\199\255\004\186\080\077\043\070\022\207\224\223\074\022\138\230\054\068\127\020\060\068\093\082\104\193\190\190\036\217\017\117\067\135\114\039\184\036\104\143\141\100\165\179\075\067\255\181\110\196\242\147\026\193\061\015\022\091\236\060\088\107\072\014\150\088\000\150\021\026\029\236\107\067\224\009\079\068\076\206\013\193\012\032\145\091\051\060\185\168\005\001\146\219\060\125\188\013\029\236\107\067\240\132\135\068\076\206\013\193\116\236\008\145\159\131\118\200\126\080\125\124\142\087\005\160\017\159\160\193\224\009\079\068\076\206\013\193\086\000\173\137\136\083\050\121\162\117\043\199\004\187\142\220\017\159\160\193\240\132\135\068\076\206\013\193\036\063\161\102\067\084\195\109\072\231\200\201\248\007\200\165\090\063\109\195\019\230\144\068\074\206\013\193\226\100\072\051\013\127\138\234\225\169\059\099\070\255\152\024\090\063\109\195\038\204\097\068\074\206\013\193\185\008\095\028\022\112\208\135\177\111\197\159\109\131\234\079\179\075\112\195\061\025\111\196\186\146\009\193\067\184\183\229\046\185\149\082\099\082\016\184\245\090\023\010\191\068\123\065\061\025\111\196\186\146\009\193\166\251\071\051\064\161\028\097\042\190\046\229\123\036\090\044\180\078\177\194\212\001\149\067\169\079\224\192\215\065\076\120\125\105\251\039\172\140\119\137\019\150\047\193\119\216\038\195\111\088\151\067\096\055\224\192\107\045\032\138\006\086\199\153\018\016\251\158\180\143\104\166\138\185\098\066\193\242\150\067\096\055\224\192\163\081\067\097\088\120\176\028\250\217\216\082\162\184\056\235\204\110\210\065\142\139\155\067\072\240\223\192\098\079\229\072\055\133\159\028\024\066\216\167\004\072\168\077\207\015\238\194\168\241\155\067\184\132\223\192\082\078\237\107\125\109\081\128\101\157\100\052\095\028\031\137\113\007\024\195\115\126\165\195\032\239\214\192\175\251\248\035\122\032\242\153\146\131\154\032\026\052\032\088\254\198\217\195\212\086\132\065\092\049\177\192\020\253\149\168\145\194\130\128\251\225\015\076\220\186\226\131\106\022\208\195\053\118\044\196\158\066\176\192\235\023\005\122\052\227\215\075\191\015\000\233\189\035\051\212\255\035\221\195\113\089\032\196\155\066\176\192\019\190\192\136\058\138\068\140\217\144\120\076\175\176\222\034\071\247\048\067\255\040\099\196\015\025\176\192\069\178\228\004\127\117\112\178\050\020\053\193\064\084\091\086\215\047\167\066\060\166\175\195\215\127\175\192\206\254\255\252\239\171\145\176\229\249\043\154\131\133\108\070\191\151\208\065\152\028\159\195\164\127\175\192\207\116\128\182\183\029\021\121\075\068\148\113\193\100\054\017\049\127\244\067\014\148\124\065\115\128\174\192\248\025\190\052\046\106\163\206\119\029\199\176\060\228\242\234\065\109\251\067\191\009\213\193\101\128\174\192\181\102\076\145\217\113\008\237\153\108\026\021\154\018\058\101\133\011\251\067\212\186\002\067\083\128\174\192\030\158\227\237\071\204\037\008\138\084\109\024\135\088\152\073\160\024\211\195\143\004\003\067\034\128\174\192\152\189\030\049\255\022\109\229\204\148\134\055\046\110\019\231\247\132\211\195\014\088\221\193\220\127\174\192\075\227\108\040\022\233\212\062\195\245\239\146\251\090\003\090\078\188\026\068\078\077\137\067\226\058\167\192\043\229\249\122\116\071\037\024\214\238\121\179\108\004\020\014\250\066\086\068\039\077\137\067\203\058\167\192\075\227\108\040\022\233\212\062\195\245\239\146\251\090\003\090\136\190\056\068\088\077\137\067\198\058\167\192\246\145\047\123\128\132\078\082\179\236\204\052\190\081\019\255\158\172\246\067\181\217\143\194\159\151\165\192\170\133\004\134\187\023\157\184\010\162\021\223\131\077\161\170\156\172\246\067\023\139\038\067\135\151\165\192\192\010\187\147\124\019\040\183\026\132\209\213\088\192\172\156\191\199\004\068\092\066\152\067\069\045\090\192\109\031\033\116\157\025\158\057\014\003\116\221\141\032\053\121\191\199\068\068\092\066\152\067\069\045\090\192\213\180\152\000\092\181\035\036\200\001\201\118\235\102\093\006\191\199\068\068\046\033\012\068\069\045\090\192\055\162\065\181\187\153\112\118\188\014\083\178\031\211\129\213\191\199\004\068\046\033\012\068\069\045\090\192\225\002\125\093\096\035\042\186\109\211\071\004\062\167\063\049\101\136\187\068\020\048\126\068\196\066\089\066\048\118\222\065\123\039\138\220\169\083\072\152\193\042\015\157\101\136\155\068\020\048\126\068\196\066\089\066\237\134\146\072\055\006\221\081\240\063\006\069\067\089\248\063\101\136\155\068\020\048\062\068\196\066\089\066\112\039\085\188\180\106\117\176\016\065\215\002\147\014\107\031\101\136\219\068\020\048\062\068\196\066\089\066\079\046\136\057\165\240\079\220\100\023\188\253\061\216\246\028\101\136\187\068\020\048\062\068\196\066\089\066\056\072\163\229\181\012\198\006\222\194\093\069\101\168\194\254\101\136\219\068\020\048\126\068\196\066\089\066\132\097\198\243\247\035\074\159\013\106\221\063\038\084\114\211\250\025\063\067\112\117\057\068\164\153\100\066\138\192\182\125\185\221\205\138\238\135\139\054\049\065\044\114\004\058\077\195\173\116\057\068\018\155\100\066\177\057\197\010\186\248\033\112\131\202\225\084\196\119\049\158\122\175\114\068\161\011\110\068\091\122\107\066\201\159\121\250\087\040\207\188\044\241\137\239\130\118\164\078\202\004\131\068\081\054\103\068\096\122\107\066\110\004\118\032\103\227\000\081\176\017\022\096\250\069\200\028\187\221\065\196\200\088\030\068\153\212\162\066\097\080\057\082\059\215\149\231\028\067\125\196\234\194\169\158\187\221\065\196\200\088\094\068\153\212\162\066\087\201\144\250\205\229\194\126\196\244\161\013\091\120\010\164\187\221\065\196\100\044\143\068\153\212\162\066\138\045\248\213\066\191\146\177\197\026\181\056\137\110\030\180\187\221\065\196\144\177\188\067\153\212\162\066\059\087\182\092\206\209\030\056\220\103\105\158\069\208\220\023\187\221\001\196\200\088\030\068\153\212\162\066\221\176\085\206\223\249\234\205\109\093\232\033\139\217\000\183\187\221\001\196\200\088\094\068\153\212\162\066\002\097\036\130\233\173\160\000\037\230\106\189\213\164\142\047\015\137\120\067\144\177\188\067\153\212\162\066\011\095\190\216\140\189\172\121\008\167\200\211\172\093\166\179\135\068\252\067\200\088\094\068\153\212\162\066\031\099\158\199\173\252\238\107\209\124\159\134\219\137\095\229\015\137\120\067\100\044\143\068\153\212\162\066\113\049\016\109\197\099\033\027\064\151\174\096\151\176\184\128\135\068\252\067\200\088\030\068\153\212\162\066\087\244\058\023\158\093\203\115\253\106\097\229\237\163\004\232\015\137\120\067\200\088\094\068\153\212\162\066\166\079\064\139\003\231\097\118\172\234\167\171\226\031\120\070\015\137\120\067\200\088\030\068\153\212\162\066\127\121\076\136\070\186\088\026\240\066\157\199\177\135\106\134\076\086\187\068\046\003\209\067\127\113\182\066\003\171\050\158\222\176\106\138\069\101\088\138\177\170\067\114\076\086\187\068\151\129\040\068\127\113\182\066\166\027\227\146\246\178\024\026\010\088\192\213\092\140\053\150\152\172\118\068\093\006\034\067\127\113\182\066\042\106\101\220\191\102\098\210\051\116\197\164\142\158\068\151\076\086\187\068\203\064\148\068\127\113\182\066\005\024\194\226\240\044\040\244\160\171\132\070\198\131\131\167\152\172\054\068\208\252\174\195\127\113\182\066\233\012\132\249\180\009\176\192\116\225\149\163\110\092\149\208\152\172\054\068\151\129\040\068\127\113\182\066\053\236\152\073\128\033\112\219\084\218\045\253\094\245\220\223\048\089\237\067\093\006\034\067\127\113\182\066\054\115\149\188\099\020\239\086\217\046\128\048\150\003\002\196\076\086\219\068\151\129\104\068\127\113\182\066",
	["Gnomeregan"] = "\158\188\019\239\164\198\061\053\251\159\074\032\217\069\171\003\211\000\154\068\089\101\181\196\083\234\037\196\157\236\222\104\026\214\177\078\022\178\070\118\152\223\093\173\144\117\179\068\115\107\170\196\191\103\037\196\235\167\201\224\103\138\081\196\202\056\086\086\079\178\070\043\182\118\170\068\206\124\182\196\191\103\037\196\073\019\206\086\211\190\188\000\213\090\173\051\008\054\167\102\064\157\142\068\075\010\157\196\114\175\035\196\014\186\028\014\171\073\044\037\005\187\212\141\168\016\124\202\064\157\142\068\075\010\189\196\114\175\035\196\137\020\173\235\254\024\204\043\115\150\118\083\181\192\146\058\128\058\093\068\075\010\157\196\114\175\035\196\024\091\131\052\173\115\048\253\203\101\100\022\216\113\057\241\128\058\093\068\075\010\189\196\114\175\035\196\166\151\219\028\061\050\055\198\233\247\172\139\162\006\023\237\100\061\181\068\089\098\163\196\192\231\032\196\003\115\048\232\232\175\010\229\028\045\147\169\180\111\232\250\158\188\180\068\242\094\165\196\192\231\032\196\113\176\201\021\215\089\233\197\105\215\134\167\082\131\005\152\181\166\192\068\034\121\081\196\242\170\032\196\007\178\002\079\111\095\208\229\036\228\059\132\099\147\045\056\053\005\215\068\242\164\083\196\105\061\030\196\212\137\249\153\131\221\116\038\041\197\062\085\231\185\160\253\043\177\204\068\215\045\099\196\103\061\030\196\149\155\220\132\089\167\193\014\062\104\070\212\222\153\242\240\143\132\182\068\157\085\158\196\191\103\028\196\149\144\014\093\156\094\169\081\090\235\036\227\180\017\154\065\086\005\183\068\037\089\156\196\191\103\028\196\030\012\154\228\226\211\150\195\086\148\069\059\157\081\158\208\189\017\202\068\117\082\130\196\221\016\026\196\125\140\000\093\086\146\249\123\203\079\105\245\008\124\116\215\176\244\191\068\181\174\140\196\133\251\023\196\029\129\085\241\158\043\015\163\137\066\222\186\046\050\073\196\030\083\180\068\134\076\151\196\193\231\023\196\083\217\017\156\219\155\030\137\038\045\126\197\186\231\073\163\073\070\175\068\231\067\142\196\193\231\023\196\067\078\003\077\026\245\062\181\017\141\130\089\001\149\117\093\192\073\173\068\198\252\140\196\190\103\019\196\048\196\130\022\067\169\245\162\045\010\210\091\050\162\239\253\096\061\168\068\072\124\140\196\190\103\019\196\181\191\120\067\003\178\186\125\076\187\188\003\182\117\226\119\118\074\166\068\138\052\139\196\191\231\014\196\178\069\019\041\135\126\179\247\201\133\157\252\157\010\198\122\014\045\107\068\112\002\146\196\189\231\014\196\135\243\156\215\121\028\219\105\159\211\124\152\239\019\014\205\135\150\149\068\112\002\146\196\189\231\014\196\133\117\163\148\084\115\171\080\210\012\235\123\011\222\239\182\014\045\107\068\225\004\100\196\189\231\014\196\092\188\062\193\105\023\004\170\095\223\088\114\154\252\212\025\135\150\149\068\225\004\100\196\189\231\014\196\184\131\177\002\011\234\238\147\148\201\157\166\199\066\061\102\214\059\200\068\232\160\193\195\137\113\009\196\123\203\014\158\060\131\131\050\139\242\203\189\245\046\155\053\117\061\180\068\172\159\000\196\125\088\009\196\061\006\053\193\106\146\155\155\023\231\038\063\150\240\080\199\186\248\181\068\154\041\110\196\050\086\009\196\224\251\119\159\108\044\245\192\001\020\011\214\010\100\209\051\186\248\149\068\154\041\110\196\050\086\009\196\142\181\077\254\030\097\102\173\118\009\041\254\034\019\089\191\241\193\180\068\098\165\093\196\167\167\008\196\220\098\195\073\150\054\118\123\010\206\040\147\151\054\069\048\158\242\210\068\224\123\090\196\178\160\008\196\233\091\130\009\022\137\004\055\013\226\249\002\186\029\176\050\169\066\188\068\061\217\068\196\167\147\008\196\030\021\062\028\225\001\083\146\020\100\077\016\100\003\044\189\173\113\190\068\088\205\035\196\053\147\008\196\255\082\110\168\102\199\113\046\100\102\046\082\091\150\163\134\166\141\186\068\161\214\012\196\209\141\008\196\162\071\213\229\112\163\027\116\154\042\013\099\093\108\091\250\197\081\157\068\035\070\066\196\107\139\008\196\100\120\045\235\127\207\017\039\092\171\128\023\141\226\195\221\036\170\187\068\113\143\091\196\076\125\008\196\121\237\112\092\247\060\131\005\106\102\066\232\098\156\055\226\036\170\187\068\113\143\027\196\076\125\008\196\078\111\119\224\192\114\133\235\227\190\249\018\199\052\192\193\036\170\219\068\113\143\091\196\076\125\008\196\144\187\016\130\081\025\233\142\174\020\229\172\085\051\136\021\032\105\187\068\033\230\085\196\055\118\008\196\030\237\058\019\155\190\131\043\019\235\246\119\063\242\150\053\062\042\224\068\195\228\044\196\054\118\008\196\158\123\014\207\251\008\117\125\250\068\005\031\228\143\066\120\186\127\217\068\226\220\090\196\225\079\008\196\214\077\041\020\245\047\055\109\145\038\150\167\104\144\005\000\014\140\215\068\195\202\031\196\224\079\008\196\101\001\068\067\067\232\053\169\184\178\172\022\194\020\009\184\192\241\198\068\101\076\018\196\223\079\008\196\176\033\177\130\037\241\220\157\027\120\071\058\030\244\186\150\213\176\195\068\227\022\102\195\022\100\004\196\157\032\035\176\063\027\207\037\232\152\228\078\121\217\121\029\025\127\188\068\012\062\079\195\230\181\002\196\199\167\202\189\119\136\088\056\079\179\206\055\228\054\068\209\010\025\187\068\090\035\021\195\002\076\002\196\216\170\242\063\135\253\255\223\248\142\173\110\218\050\123\203\062\175\154\068\221\053\058\196\130\157\255\195\130\103\041\134\024\142\212\234\219\204\166\234\193\239\174\097\234\252\181\068\215\180\038\194\004\067\252\195\114\085\026\255\127\154\236\005\001\187\247\249\248\039\104\118\141\143\164\068\045\166\211\193\226\018\248\195\236\042\151\032\053\206\169\044\235\116\252\173\216\044\130\199\104\170\151\068\105\181\078\196\109\081\247\195\140\057\165\035\104\118\135\234\195\060\237\208\160\134\182\027\168\216\091\068\215\235\115\196\088\017\233\195\246\235\182\152\211\062\102\227\082\137\025\237\223\054\113\171\168\216\091\068\235\245\153\196\088\017\233\195\005\218\100\144\157\248\186\067\197\131\119\095\094\134\011\054\084\236\141\068\235\245\153\196\088\017\233\195\174\092\211\220\024\225\181\020\199\232\210\242\087\051\045\053\084\236\141\068\215\235\115\196\088\017\233\195\077\148\154\193\001\080\227\084\069\248\213\243\217\137\144\044\185\236\128\068\082\081\069\196\102\187\231\195\137\077\016\057\040\183\003\225\149\193\186\139\249\136\153\148\197\018\132\068\028\069\048\196\107\070\231\195\080\233\002\221\250\172\222\111\167\206\052\023\226\203\237\100\074\152\158\068\071\247\090\196\047\168\230\195\195\015\112\213\037\157\073\242\004\179\066\127\125\088\060\234\118\206\048\068\087\130\196\195\196\109\217\195\030\086\068\160\182\192\149\018\019\222\209\113\128\217\065\056\118\206\112\068\175\004\009\195\196\109\217\195\217\069\131\139\006\227\018\031\144\155\048\228\074\002\103\113\118\206\112\068\087\130\196\195\196\109\217\195\199\215\121\043\192\238\180\201\243\220\047\245\047\094\021\233\118\206\048\068\175\004\009\195\196\109\217\195\086\228\067\245\016\220\022\203\057\254\117\145\065\139\178\132\196\205\130\068\151\018\026\196\052\007\217\195\072\135\042\042\122\046\124\154\090\049\063\143\078\091\098\113\049\061\106\068\203\201\019\196\096\181\211\195\225\170\156\116\233\227\157\124\119\114\079\008\090\166\142\153\062\111\086\068\135\201\019\196\180\149\211\195\255\127\031\222\183\219\096\213\228\060\002\063\067\131\086\132\008\033\128\068\060\066\021\196\177\149\211\195\089\199\104\219\125\164\066\182\199\200\078\184\052\094\239\026\223\179\078\068\066\210\010\196\176\149\211\195\232\022\143\217\047\053\146\010\046\165\093\138\172\012\054\046\223\179\078\068\134\208\236\195\176\149\211\195\082\255\222\179\166\203\189\188\171\226\233\208\078\132\223\215\205\007\131\068\235\250\163\195\029\233\204\195\116\080\145\102\161\155\069\165\147\027\167\012\153\132\175\178\205\007\131\068\175\235\143\194\029\233\204\195\228\186\163\076\100\188\245\242\176\159\178\208\252\073\070\066\038\145\135\068\168\219\166\195\073\200\203\195\197\229\252\167\123\142\051\203\202\107\007\221\210\094\103\128\212\007\140\068\206\211\245\194\188\189\200\195\033\154\034\148\118\024\218\226\124\092\161\001\011\069\123\086\076\194\132\068\204\211\245\194\063\132\200\195\054\181\235\144\182\030\005\127\008\011\026\162\141\036\224\204\209\186\148\068\135\229\167\195\199\176\199\195\154\060\100\047\081\142\241\095\179\119\221\015\248\006\176\214\209\186\148\068\200\172\122\195\251\174\199\195\243\240\219\139\071\172\183\112\237\194\009\057\039\014\187\088\209\186\148\068\120\188\040\195\250\174\199\195\136\150\021\051\221\181\237\026\040\241\036\092\129\071\009\242\099\001\112\068\153\195\240\195\096\228\194\195\221\003\103\058\218\225\107\232\236\218\001\006\166\006\153\064\247\202\141\068\064\025\233\195\060\184\184\195\049\189\007\104\122\232\069\116\250\185\226\159\092\117\208\195\123\030\153\068\177\050\156\195\024\243\183\195\239\033\219\061\014\254\034\244\204\030\158\095\165\116\144\025\124\030\153\068\111\232\071\195\244\077\183\195\210\061\220\109\209\144\242\240\252\146\013\246\156\224\157\067\250\155\134\068\143\138\159\194\071\197\179\195\128\156\188\111\090\114\074\244\055\131\010\138\042\235\077\009\142\240\143\068\142\138\159\194\202\182\179\195\138\057\055\071\018\066\019\109\197\017\194\227\237\024\155\141\214\085\050\068\019\026\250\194\141\157\175\195\106\062\172\250\122\204\141\154\068\060\216\172\111\086\197\212\214\085\114\068\132\134\190\195\141\157\175\195\217\012\039\250\156\224\203\254\166\235\093\246\001\042\115\029\214\085\050\068\132\134\190\195\141\157\175\195\167\233\203\182\174\056\056\237\041\087\080\210\158\228\005\210\214\085\114\068\019\026\250\194\141\157\175\195\131\029\125\148\058\244\119\144\040\118\060\117\188\111\003\225\078\139\033\068\031\128\248\194\050\134\162\195\017\188\122\200\211\028\085\030\045\185\238\201\253\166\091\090\119\152\133\068\171\174\243\195\203\116\159\195\049\216\253\194\202\127\222\187\125\157\219\171\027\119\034\019\108\092\106\068\154\194\190\066\112\016\159\195\179\039\085\213\255\106\037\021\146\019\200\134\117\065\103\116\105\227\200\067\191\080\246\193\145\199\158\195\081\035\043\065\144\091\046\052\189\179\206\064\188\057\244\088\105\227\200\067\011\101\143\195\145\199\158\195\140\191\169\181\155\240\126\235\239\105\178\110\183\244\050\107\141\183\128\068\019\064\143\194\022\140\157\195\006\208\123\229\221\235\119\192\052\132\210\088\110\207\199\185\152\242\113\068\085\191\005\195\070\085\157\195\214\128\228\154\019\061\245\164\142\059\230\071\045\097\077\097\108\023\117\068\081\165\199\195\157\067\155\195",
	["Graveyard"] = "\021\069\026\074\086\199\138\064\031\102\212\158\032\190\172\139\142\197\005\196\221\000\080\196\033\237\164\193\032\101\073\109\152\221\020\010\234\007\137\131\148\151\041\231\212\055\241\195\119\006\072\196\002\101\135\193\026\141\013\015\022\037\053\111\190\096\169\020\091\107\153\208\032\058\232\195\244\253\067\196\056\162\096\192\252\249\049\197\145\109\162\167\088\078\220\185\182\251\017\064\230\011\244\195\218\160\083\196\013\162\096\192\210\073\022\220\030\115\116\040\127\081\110\123\181\132\051\096\201\120\215\195\035\112\134\195\002\241\085\192\176\202\031\238\228\192\077\005\202\045\014\070\054\108\086\124\100\188\107\196\017\056\067\196\002\241\085\192\211\208\155\158\144\097\178\001\050\091\030\092\095\109\116\080\100\188\107\196\008\156\129\196\002\241\085\192\163\225\145\218\165\096\051\151\114\154\111\138\181\185\183\034\100\188\107\196\017\056\003\196\002\241\085\192\151\121\189\218\071\226\236\018\065\107\187\032\245\000\040\020\201\120\215\195\017\056\003\196\002\241\085\192\179\134\063\046\030\152\143\020\223\056\064\252\109\237\002\059\100\188\043\196\008\156\129\196\002\241\085\192\076\050\235\240\252\207\019\043\070\165\097\013\157\247\240\019\100\188\043\196\017\056\003\196\002\241\085\192\233\170\127\073\130\119\112\137\114\161\124\253\072\172\102\084\100\188\043\196\017\056\067\196\002\241\085\192\059\014\008\190\015\119\199\209\112\119\231\147\190\026\188\184\201\120\215\195\008\156\129\196\002\241\085\192\219\241\131\204\139\155\184\013\096\015\175\255\159\077\248\110\100\188\043\196\035\112\134\195\002\241\085\192\032\195\198\106\033\239\235\054\073\244\208\007\172\109\043\061\201\120\215\195\017\056\067\196\002\241\085\192\139\022\021\146\196\018\211\036\003\140\037\223\203\182\190\021\127\037\230\195\041\177\073\196\141\033\096\191\241\143\028\143\132\057\067\215\128\101\017\167\176\213\143\225\039\171\003\196\135\093\082\196\210\064\045\191\089\223\208\091\177\008\225\161\122\177\251\213\133\045\139\208\181\152\214\195\131\127\050\195\008\034\088\065\159\072\254\114\051\127\240\191\140\212\036\128\056\134\067\163\018\166\183\195\144\037\044\195\008\034\088\065\137\086\136\193\132\002\135\181\022\123\033\133\066\093\106\218\173\073\153\195\243\037\044\195\008\034\088\065\076\088\117\119\172\037\239\008\087\099\122\076\013\009\102\122\190\055\195\195\143\037\044\195\008\034\088\065\118\177\125\207\130\030\164\040\018\213\145\017\181\141\122\020\164\222\231\195\223\213\155\195\088\037\088\065\012\024\157\000\036\096\103\235\129\043\236\152\146\209\100\073\216\113\253\195\038\222\155\195\088\037\088\065\242\055\137\208\176\033\195\168\067\015\168\103\112\102\039\130\184\178\148\195\141\002\012\195\024\120\105\065\037\227\181\211\180\192\025\250\070\212\196\011\159\175\216\126\207\082\243\195\199\166\191\195\102\123\105\065\187\019\161\193\239\238\099\118\020\141\013\137\025\223\054\145\118\015\239\195\072\163\136\195\009\125\109\065\107\027\006\212\246\226\167\233\059\122\009\052\102\131\049\251\221\084\250\195\192\100\072\196\218\111\135\065\146\123\052\045\052\154\115\196\031\011\204\139\238\011\031\012\054\137\140\195\145\095\127\194\200\058\218\065\142\012\214\210\218\145\044\217\005\071\239\137\212\000\001\115\019\218\146\195\008\163\167\194\200\058\218\065\070\046\006\216\070\123\104\189\191\134\085\212\078\146\156\167\013\175\164\195\004\136\033\194\118\133\015\066\174\075\010\184\183\039\087\125\117\229\190\133\124\094\174\038\018\004\147\195\096\243\090\066\015\111\020\066\087\139\185\008\047\241\198\214\192\145\220\252\098\205\014\209\047\097\157\195\209\115\156\065\203\037\021\066\161\194\133\007\121\145\208\225\242\096\001\209\186\202\054\108\150\233\010\195\201\122\072\065\017\050\021\066\203\139\040\169\179\070\250\031\001\223\175\042\070\134\045\065\150\233\010\195\114\225\010\194\017\050\021\066",
	["Gruul's Lair"] = "\233\123\238\095\100\060\032\001\161\027\036\064\191\048\254\019\230\133\191\195\186\140\002\196\205\020\246\193\236\074\164\110\098\223\135\014\005\153\113\061\225\157\039\183\155\023\254\194\117\025\133\195\205\020\246\193\128\142\074\221\105\061\057\204\052\042\026\136\227\004\050\093\155\023\254\194\186\140\002\196\205\020\246\193\178\127\243\217\028\059\238\033\070\036\166\100\139\086\112\112\230\133\191\195\117\025\133\195\205\020\246\193\223\027\207\066\114\063\043\189\153\234\039\053\151\246\083\112\248\066\021\196\034\217\091\196\199\082\181\193\031\226\226\201\103\008\007\061\037\030\111\108\064\125\165\162\248\066\021\196\034\217\027\196\199\082\181\193\082\202\103\110\145\128\020\057\113\111\179\187\100\080\046\093\241\133\170\195\034\217\091\196\199\082\181\193\059\093\018\008\017\207\127\152\019\227\200\252\175\224\016\149\086\068\068\195\183\004\135\065\139\029\155\193\224\185\111\204\203\164\131\190\024\102\219\007\227\069\217\030\086\068\068\195\104\031\111\195\139\029\155\193\191\105\165\166\004\000\132\041\238\070\157\250\221\234\061\245\177\132\156\195\043\218\066\196\136\031\211\192\029\210\006\221\114\148\132\096\025\241\124\162\081\154\206\168\177\132\156\195\043\218\002\196\136\031\211\192",
	["Hellfire Ramparts"] = "\052\244\063\080\147\139\071\129\221\201\011\142\118\253\035\038\255\255\223\069\255\255\007\198\000\000\000\000\145\105\174\077\244\244\055\055\114\050\066\163\152\024\116\254\255\255\231\069\255\255\007\198\000\000\000\000",
	["Hyjal Summit"] = "\156\207\117\224\245\048\078\004\105\058\078\063\241\103\224\096\255\255\007\070\255\255\159\197\000\000\000\000\173\027\075\003\235\146\183\058\096\208\055\136\042\121\254\143\255\255\007\070\255\255\167\197\000\000\000\000\074\011\091\098\119\142\144\076\149\053\100\097\139\204\063\167\255\255\007\070\255\255\175\197\000\000\000\000\003\130\220\190\061\140\252\146\171\007\021\046\045\220\161\197\255\255\007\070\255\255\183\197\000\000\000\000\037\125\070\169\094\247\082\089\117\135\002\154\146\186\061\161\255\255\007\070\255\255\191\197\000\000\000\000\242\179\010\053\079\033\167\009\148\139\060\120\236\217\183\049\255\255\011\070\255\255\159\197\000\000\000\000\057\199\021\045\251\127\208\210\229\081\122\227\179\111\072\121\255\255\011\070\255\255\167\197\000\000\000\000\000\001\058\073\133\137\013\218\097\102\120\038\190\032\239\054\255\255\011\070\255\255\175\197\000\000\000\000\126\126\226\152\116\219\253\103\078\127\023\143\040\060\041\090\255\255\011\070\255\255\183\197\000\000\000\000\118\032\167\246\248\118\070\145\109\014\054\221\006\206\217\178\255\255\011\070\255\255\191\197\000\000\000\000\003\046\026\025\155\129\202\205\133\017\249\167\176\114\174\012\255\255\015\070\255\255\159\197\000\000\000\000\216\043\070\001\141\106\191\018\223\023\118\049\173\029\165\055\255\255\015\070\255\255\167\197\000\000\000\000\167\021\152\178\129\190\067\066\218\084\085\115\089\172\068\009\255\255\015\070\255\255\175\197\000\000\000\000\029\219\152\044\080\001\073\151\027\081\042\231\191\014\123\221\255\255\015\070\255\255\183\197\000\000\000\000\003\123\194\037\056\106\210\195\107\187\238\139\198\031\048\138\255\255\015\070\255\255\191\197\000\000\000\000\192\072\001\081\091\149\083\161\074\146\123\174\231\230\101\110\255\255\019\070\255\255\159\197\000\000\000\000\156\152\173\252\014\244\180\191\148\006\116\050\205\167\081\229\255\255\019\070\255\255\167\197\000\000\000\000\135\099\073\088\143\222\061\193\226\253\255\225\090\058\146\141\255\255\019\070\255\255\175\197\000\000\000\000\019\201\034\127\087\042\072\215\094\251\040\010\035\117\075\157\255\255\019\070\255\255\183\197\000\000\000\000\144\089\058\036\255\186\179\121\153\061\068\136\110\056\033\208\255\255\019\070\255\255\191\197\000\000\000\000\222\030\178\149\204\084\049\016\069\183\247\180\048\192\121\088\255\255\023\070\255\255\159\197\000\000\000\000\095\251\093\046\156\074\007\244\130\143\086\162\049\073\124\021\255\255\023\070\255\255\167\197\000\000\000\000\192\207\014\126\014\187\087\049\015\055\064\047\055\224\239\214\255\255\023\070\255\255\175\197\000\000\000\000\003\092\081\094\224\185\077\001\071\250\167\247\233\045\158\039\255\255\023\070\255\255\183\197\000\000\000\000\219\122\100\142\190\149\127\228\036\035\033\146\028\229\037\206\255\255\023\070\255\255\191\197\000\000\000\000\174\034\212\130\208\001\142\163\251\058\169\224\120\193\220\151\255\255\027\070\255\255\159\197\000\000\000\000\131\080\166\238\187\024\120\078\126\231\086\248\142\184\173\092\255\255\027\070\255\255\167\197\000\000\000\000\221\216\003\020\062\058\209\199\038\013\136\059\054\209\215\068\255\255\027\070\255\255\175\197\000\000\000\000\194\091\058\148\126\245\106\007\178\108\121\207\229\189\096\135\255\255\027\070\255\255\183\197\000\000\000\000\056\009\006\189\072\191\164\168\226\239\205\066\035\093\022\013\255\255\027\070\255\255\191\197\000\000\000\000",
	["Karazhan"] = "\212\191\204\054\151\004\238\193\058\200\171\197\068\142\123\096\149\137\212\195\122\233\144\195\008\166\214\192\148\009\221\236\080\187\102\127\023\146\220\129\202\177\199\041\043\019\041\195\122\233\144\195\008\166\214\192\101\135\014\022\013\125\149\044\145\103\015\194\097\246\071\149\043\019\041\195\215\075\007\194\008\166\214\192\080\186\156\064\108\157\224\245\142\040\146\048\150\244\080\108\017\190\084\066\136\060\099\194\250\201\247\191\128\145\215\118\044\028\219\005\085\062\058\032\056\173\240\095\250\103\006\195\200\054\220\195\218\124\189\063\161\068\219\093\131\203\194\081\045\189\025\204\157\162\222\147\114\181\030\194\005\033\050\194\198\249\235\063\240\168\000\030\203\164\092\144\157\096\047\220\106\005\101\091\074\219\163\193\185\227\153\066\205\133\022\064\188\043\253\181\047\185\157\024\027\079\118\065\143\047\101\251\048\021\192\194\145\015\205\194\072\108\032\065\132\255\187\001\046\236\190\144\197\120\195\069\248\130\190\067\045\109\156\195\157\144\138\195\224\076\017\066\166\137\215\041\006\202\104\164\001\132\010\172\098\212\001\004\045\109\156\195\223\009\169\193\224\076\017\066\069\014\253\235\203\021\056\079\028\031\232\227\156\085\141\033\111\105\099\194\157\144\138\195\224\076\017\066\218\056\186\242\175\175\158\068\251\078\063\243\181\132\247\006\168\098\227\193\046\107\000\065\234\153\080\066\234\166\247\220\198\138\135\098\176\144\062\086\233\001\070\047\138\208\247\194\136\062\230\194\205\248\092\066\182\066\229\205\024\158\197\153\093\048\219\145\093\223\208\253\235\129\120\066\034\115\167\195\027\190\100\066\155\230\082\113\099\063\244\184\013\117\070\052\229\138\044\205\132\223\065\195\034\115\167\195\027\190\100\066\073\236\186\024\203\169\182\077\181\193\231\226\167\238\192\237\016\112\012\067\082\045\019\196\020\190\109\066\179\140\167\176\141\178\091\165\044\036\150\205\074\204\131\022\222\031\231\194\165\090\166\195\020\190\109\066\136\091\153\141\177\030\146\112\105\094\080\010\102\133\239\180\222\031\231\194\082\045\019\196\020\190\109\066\155\211\050\183\044\141\068\180\076\132\203\097\104\130\202\175\228\228\235\066\003\153\010\196\022\190\109\066\036\118\192\149\170\069\088\110\251\045\149\131\034\137\050\177\005\253\081\195\227\199\202\195\036\197\110\066\133\052\088\211\034\107\244\210\132\050\178\220\210\246\051\203\087\203\054\065\047\011\041\196\011\032\163\066\035\177\075\184\170\039\122\226\137\091\212\203\158\185\165\114\170\138\207\066\034\110\028\196\098\042\167\066\178\073\098\170\006\230\065\122\194\071\242\203\095\006\230\076\088\137\219\066\015\039\240\195\120\052\167\066\185\223\047\005\210\139\091\251\230\100\064\019\054\005\011\146\125\209\247\195\054\122\069\195\034\072\167\066\172\204\185\195\210\077\116\224\186\166\250\106\225\094\196\036\085\197\205\195\008\099\153\195\154\255\168\066\206\243\137\070\065\052\109\241\169\246\133\220\003\212\215\103\192\245\062\192\191\037\166\192\009\012\171\066\102\128\118\159\221\161\109\187\004\063\182\058\188\037\015\136\225\236\161\066\079\138\030\194\166\016\171\066\064\117\240\131\179\026\218\070\012\199\111\182\106\061\182\076\027\193\070\066\056\220\054\194\206\044\171\066\017\046\059\214\050\234\063\067\082\191\049\063\241\047\070\177\113\187\238\194\185\097\179\195\156\224\173\066\229\138\060\173\025\113\116\217\212\245\155\248\024\022\093\051\222\038\185\195\194\010\203\195\255\239\173\066\091\196\183\108\010\151\115\204\005\004\106\070\010\177\244\176\097\141\182\195\050\249\165\195\190\244\173\066\255\166\064\219\214\002\208\128\211\223\098\214\194\005\101\092\102\065\223\195\155\095\210\194\162\249\173\066\119\002\038\044\242\060\137\125\181\085\006\068\037\075\213\240\178\010\089\195\213\046\143\195\116\252\173\066\252\205\178\239\209\137\235\053\216\119\065\125\228\032\221\168\240\018\087\194\198\070\144\194\239\126\178\066\006\183\216\200\072\103\041\116\108\083\215\235\157\098\019\176\117\025\244\194\056\040\014\194\248\134\178\066\097\122\175\171\245\156\209\071\247\154\165\059\245\111\156\247\046\156\210\194\174\087\246\194\081\096\232\066\197\173\175\142\239\152\186\046\181\128\251\085\050\098\020\247\252\059\159\194\046\200\091\195\065\039\002\067\169\241\027\145\086\075\242\113\071\148\254\145\057\144\227\041\119\075\213\193\156\152\150\195\163\196\023\067\230\253\230\222\128\245\152\151\161\067\215\140\216\206\136\075\222\051\140\194\072\106\145\194\209\199\023\067\134\037\216\089\060\165\253\173\141\144\187\026\071\221\123\196\034\046\148\067\151\161\022\067\099\205\045\067\135\233\169\247\068\187\054\233\179\142\206\100\062\050\243\230\034\046\148\067\203\080\203\067\099\205\045\067\154\102\094\028\212\109\181\089\234\008\151\099\109\186\117\013\017\023\074\068\203\080\203\067\099\205\045\067\240\090\114\184\040\075\066\166\008\116\154\015\072\150\239\004\023\113\033\066\203\080\203\067\099\205\045\067\005\135\170\234\123\102\113\061\212\108\000\020\025\101\028\118\034\046\148\067\207\188\210\194\099\205\045\067\100\170\189\205\108\119\137\014\125\154\053\185\120\249\019\115\023\113\033\066\151\161\022\067\099\205\045\067\213\025\150\186\239\036\136\130\234\034\173\126\211\160\006\071\017\023\010\068\051\175\180\195\099\205\045\067\106\110\114\231\001\237\237\149\165\182\030\071\202\201\220\114\017\023\010\068\207\188\210\194\099\205\045\067\146\233\105\211\166\186\248\016\143\108\065\059\034\230\057\032\023\113\033\066\207\188\210\194\099\205\045\067\080\160\021\238\104\004\156\131\018\025\027\129\112\127\156\114\017\023\074\068\151\161\022\067\099\205\045\067\188\003\140\185\166\201\249\041\157\187\068\111\162\063\040\179\017\023\010\068\151\161\022\067\099\205\045\067\023\133\116\158\078\198\043\192\169\122\152\242\215\029\091\169\017\023\074\068\207\188\210\194\099\205\045\067\109\156\073\178\081\071\028\184\138\210\144\103\034\197\245\054\017\023\010\068\203\080\203\067\099\205\045\067\149\104\012\001\177\033\169\059\235\085\021\173\165\038\166\232\017\023\074\068\051\175\180\195\099\205\045\067\073\221\184\038\061\145\191\072\186\085\116\171\226\086\098\164\023\113\033\066\051\175\180\195\099\205\045\067\105\043\255\023\178\204\203\116\080\045\091\010\201\207\217\197\034\046\148\067\051\175\180\195\099\205\045\067\039\138\213\047\023\227\218\228\027\195\255\213\184\075\137\204\086\242\034\067\150\109\184\193\172\200\086\067\154\141\125\194\029\198\159\191\245\079\232\059\081\012\011\149\246\111\009\194\034\171\000\195\246\081\096\067\032\050\173\000\051\191\080\034\117\197\005\147\226\055\144\046\210\063\186\193\017\175\134\195\099\089\097\067\187\108\017\042\146\149\171\169\205\029\017\167\221\086\196\200\111\173\003\067\204\098\114\195\043\034\103\067\133\249\176\195\007\104\150\164\120\220\188\056\008\072\094\132\170\130\017\068\175\037\009\195\194\143\130\067\171\227\138\113\132\232\242\201\040\028\252\098\165\232\190\177\225\037\226\067\007\204\052\195\016\152\130\067\040\072\199\231\049\192\179\189\027\121\156\186\213\243\228\181\243\051\199\067\064\150\047\195\128\121\152\067\216\202\129\163\169\223\049\122\205\238\102\181\095\126\163\127\099\220\016\068\122\121\244\194\059\052\162\067\043\214\223\079\076\071\173\166\053\061\143\207\004\025\241\100\232\077\096\066\175\243\042\195\233\253\171\067\114\175\087\197\171\210\249\031\154\179\172\185\144\072\002\170\193\037\189\067\054\054\057\066\011\062\175\067\158\069\186\170\161\059\123\126\087\224\000\113\111\053\000\173\062\117\032\194\008\102\065\194\235\182\181\067\174\035\189\022\119\102\048\234\239\202\250\123\180\255\183\042\064\204\016\067\247\189\138\065\110\070\183\067\163\076\194\237\101\166\056\004\181\252\252\208\186\034\231\202\241\038\008\193\154\096\083\195\236\148\183\067\115\097\125\040\006\174\237\191\127\071\097\235\203\082\211\244\052\211\019\194\045\132\009\195\236\148\183\067\109\238\120\188\218\167\191\207\040\207\022\009\117\005\152\162\056\213\015\068\021\234\017\195\015\067\192\067\252\066\037\081\098\066\159\136\255\116\093\224\247\085\238\249\187\147\152\066\067\063\105\195\071\053\196\067\164\052\024\025\235\120\112\072\185\093\186\183\121\182\182\041\091\040\142\066\042\122\030\195\072\053\196\067\141\109\043\227\138\099\083\238\006\164\192\143\154\170\230\123\110\090\105\194\146\002\053\195\203\119\198\067\121\032\254\150\060\148\042\085\171\065\121\080\161\128\237\130\104\087\076\194\234\134\129\194\011\132\199\067\117\034\024\073\222\071\022\114\242\025\078\063\012\186\189\146\166\158\124\193\088\158\126\194\198\005\216\067\205\052\221\206\157\122\113\247\159\182\036\202\166\067\219\028\033\212\237\193\025\196\150\194\129\009\224\067\074\029\158\180\163\117\201\032\114\143\126\214\156\238\207\225\012\142\075\194\169\213\191\194\167\059\226\067\090\128\055\206\236\243\162\174\156\200\099\061\193\241\134\005\204\158\104\194\235\038\187\194\167\059\226\067\090\241\140\109\071\061\250\192\011\240\050\078\044\152\126\105\058\145\125\193\214\237\158\194\167\059\226\067\007\038\254\089\224\232\252\195\126\177\085\099\161\132\221\104\088\070\024\194\070\094\197\194\168\059\226\067\038\027\037\036\093\183\015\146\094\192\193\041\085\253\212\236\055\126\138\194\108\090\176\194\168\059\226\067\015\115\131\173\238\037\080\114\007\013\171\038\238\185\075\010\168\020\190\193\088\201\187\194\168\059\226\067\247\098\236\159\053\131\071\011\156\172\210\083\029\129\061\089\105\237\146\193\201\058\173\194\168\059\226\067\008\177\146\230\079\083\158\237\081\100\240\065\138\009\144\130\232\222\057\068\233\130\001\196\160\176\227\067\018\106\062\185\057\019\116\131\229\030\182\052\236\219\186\122\209\189\243\067\211\005\131\195\160\176\227\067\144\083\045\159\090\037\147\096\108\011\235\019\247\138\094\243\209\189\243\067\233\130\001\196\160\176\227\067\203\200\253\047\067\175\220\214\052\048\183\228\233\215\235\059\232\222\057\068\211\005\131\195\160\176\227\067\185\043\216\020\082\126\022\097\213\187\217\071\092\091\066\238\101\082\026\068\053\220\064\195\035\144\229\067",
	["Library"] = "\137\069\154\048\081\011\089\027\212\153\110\136\147\133\177\185\093\175\164\195\221\026\139\194\096\211\015\066\184\041\100\215\148\009\219\109\210\178\249\205\085\158\104\219\013\175\164\195\023\085\028\194\096\211\015\066\131\027\188\072\201\055\087\214\115\010\093\215\202\140\046\023\208\031\188\194\122\145\231\067\076\169\019\066\023\016\017\130\055\249\006\021\179\044\224\044\114\178\213\150\019\218\146\195\007\163\167\194\142\173\019\066\062\013\231\132\146\083\185\006\012\024\029\216\101\017\148\212\157\231\154\195\114\080\140\067\192\235\019\066\180\192\244\150\217\145\204\110\142\136\155\051\087\063\198\080\157\231\154\195\112\098\240\067\192\235\019\066\133\200\150\141\197\173\233\224\179\243\255\081\108\114\170\045\236\255\229\194\083\151\110\067\013\003\020\066\116\125\113\203\091\040\086\119\140\009\083\119\150\042\177\090\029\120\017\195\187\052\121\067\013\003\020\066\014\053\139\136\160\074\129\227\058\013\136\071\213\214\044\085\063\214\093\195\118\217\114\067\016\003\020\066\209\033\085\133\013\110\149\092\108\085\227\219\089\034\183\109\179\240\047\195\187\052\121\067\017\003\020\066\142\203\201\153\247\015\207\113\212\252\246\230\076\162\254\084\092\031\036\195\154\199\236\067\064\005\020\066\142\231\054\055\214\131\203\193\160\139\033\172\135\025\151\236\196\033\158\195\038\195\170\066\255\005\020\066\040\179\019\196\236\233\086\155\040\248\073\203\013\166\088\078\046\237\137\195\001\119\183\066\000\006\020\066\240\154\143\108\103\091\222\147\150\109\198\143\138\027\226\026\117\113\100\195\058\118\183\066\002\006\020\066\167\100\234\097\088\084\183\060\081\079\159\129\152\052\218\146\211\061\125\195\175\140\187\066\004\006\020\066\249\150\137\159\127\093\137\070\010\191\184\061\189\082\106\180\197\245\033\195\017\189\247\066\099\038\020\066\224\048\090\062\201\233\055\071\237\146\162\013\247\220\146\080\042\136\061\194\062\236\021\067\102\038\020\066\231\085\209\226\151\040\014\039\087\015\194\121\116\041\032\169\200\066\018\194\107\211\006\067\102\038\020\066\087\139\185\008\047\241\198\214\192\145\220\252\098\205\014\209\047\097\157\195\209\115\156\065\203\037\021\066\010\071\220\240\067\138\076\202\138\222\178\228\030\085\176\170\054\137\140\195\097\228\077\194\029\049\021\066\042\046\238\009\233\047\149\036\245\230\054\013\092\143\188\179\019\004\147\195\096\243\090\066\072\050\021\066\239\095\021\238\199\171\019\051\093\173\142\214\246\103\214\015\205\176\075\195\127\126\092\067\160\095\025\066\107\112\194\244\084\089\208\055\139\102\052\081\060\169\236\031\095\251\157\195\074\009\205\067\176\096\032\066\035\246\041\119\206\129\223\068\158\165\190\153\132\172\070\214\095\251\157\195\074\059\169\067\176\096\032\066\076\085\128\073\094\191\140\252\062\039\012\231\078\041\207\060\096\050\146\195\104\250\124\067\074\102\032\066\099\204\120\178\255\005\254\207\023\014\047\082\006\162\183\040\086\060\120\195\104\250\124\067\074\102\032\066",
	["Magisters' Terrace"] = "\162\147\234\166\184\194\185\210\227\130\011\128\059\053\234\253\011\132\044\195\066\250\006\195\183\124\051\194\216\223\120\070\210\194\029\181\039\143\024\082\171\224\038\052\005\066\214\195\066\250\006\195\183\124\051\194\050\117\146\023\187\100\211\116\208\100\238\076\153\059\008\000\005\066\214\195\121\011\242\066\183\124\051\194\098\183\138\177\155\188\021\003\115\219\151\067\198\200\053\170\011\132\044\195\121\011\242\066\183\124\051\194\138\226\078\230\093\001\238\025\189\252\036\077\206\186\087\230\145\087\139\195\085\231\041\195\214\167\050\194\150\212\078\248\198\110\201\233\149\067\105\070\096\000\142\072\051\055\156\195\211\095\120\195\210\167\050\194\072\230\013\203\069\201\198\135\180\213\213\174\101\019\124\003\037\085\178\195\169\197\023\067\168\068\046\194\122\164\128\006\078\255\149\210\081\253\126\130\029\112\032\206\238\073\212\195\168\027\195\067\053\136\044\194\236\191\114\106\226\090\210\034\130\145\097\033\124\251\206\191\231\253\140\195\028\210\169\067\221\204\043\194\005\255\164\094\022\079\018\234\146\013\108\142\028\161\179\231\222\006\141\195\015\194\233\066\000\193\043\194\135\122\061\156\068\023\196\131\046\047\190\109\201\251\156\126\018\039\167\195\246\134\045\067\136\044\017\194\186\236\172\088\131\101\001\065\146\046\142\173\230\004\220\072\057\250\178\195\253\225\212\195\184\108\006\194\146\142\165\122\111\110\255\192\153\014\245\179\189\034\219\099\032\037\211\195\096\143\232\067\205\130\155\193\012\015\111\241\158\003\139\253\168\226\230\230\202\235\145\211\233\160\253\195\212\058\054\067\240\052\155\193\073\185\074\218\001\129\228\151\141\083\194\037\179\125\176\074\233\160\253\195\106\029\219\067\240\052\155\193\030\044\106\035\110\008\072\078\105\161\241\170\041\205\235\246\066\036\244\195\252\092\236\067\121\166\081\193\177\245\108\235\246\134\198\230\044\219\147\173\200\131\241\083\127\098\002\196\127\057\110\066\226\045\068\193\205\008\056\240\143\231\181\040\183\051\070\039\036\250\221\164\054\126\255\194\215\108\048\194\068\007\238\192\065\192\161\158\211\183\116\089\076\083\176\011\181\166\243\149\000\175\012\196\003\232\114\194\212\087\201\192\049\093\234\088\244\113\070\219\087\146\073\093\138\163\245\245\251\062\215\195\067\232\050\194\083\017\194\192\243\011\235\174\117\109\001\119\254\048\133\083\065\095\254\028\007\219\204\195\056\232\050\194\235\016\194\192",
	["Magtheridon's Lair"] = "\216\235\035\037\181\191\004\236\140\224\123\160\021\140\054\043\108\018\012\067\131\192\055\195\022\147\145\191\084\190\234\226\079\061\174\172\141\103\090\199\181\114\141\127\038\219\231\194\247\126\144\066\022\147\145\191\057\074\180\065\110\026\094\167\227\145\125\134\146\112\115\035\038\219\231\194\131\192\055\195\022\147\145\191\184\122\233\236\110\151\191\149\239\228\053\217\206\245\164\221\111\048\011\066\200\001\030\195\218\171\097\191\205\188\061\010\037\088\143\202\074\098\026\018\171\076\077\255\171\158\004\067\095\042\097\194\142\171\097\191\107\071\249\004\105\130\105\001\086\160\123\159\193\130\146\024\109\048\011\066\044\118\029\066\232\163\097\191\005\089\169\155\001\244\183\120\172\039\104\005\163\057\013\025\064\111\133\195\252\252\049\194\082\028\180\066\222\213\056\206\209\248\002\122\072\035\066\076\115\124\230\244\079\208\236\195\170\067\106\195\194\229\006\067\093\236\235\193\105\000\012\230\193\202\213\183\017\002\089\099\079\208\236\195\167\226\173\065\194\229\006\067\158\131\045\101\158\163\035\005\011\123\111\228\134\206\069\209\146\152\006\195\145\122\154\066\166\144\015\067\243\102\212\068\017\089\037\196\146\006\219\214\154\088\076\066\146\152\006\195\182\194\050\195\166\144\015\067\042\230\218\233\019\044\154\251\184\136\027\027\247\164\034\003\217\206\242\066\182\194\050\195\166\144\015\067",
	["Mana-Tombs"] = "\079\215\023\224\012\071\168\006\132\079\030\189\034\028\219\144\140\173\038\068\202\085\199\067\096\251\152\193\062\090\088\215\215\060\106\165\017\030\012\252\233\127\066\002\124\226\169\194\103\111\170\067\095\251\152\193\175\108\187\139\173\035\140\150\135\160\043\064\136\034\234\050\068\181\030\068\080\014\152\066\095\251\152\193\202\114\105\011\171\245\243\042\144\192\233\188\151\028\060\084\062\181\030\068\134\164\128\067\095\251\152\193\113\128\014\081\028\138\044\237\109\176\084\225\222\214\125\226\193\014\043\067\103\111\170\067\095\251\152\193\119\123\115\140\152\151\238\249\011\200\134\228\140\073\167\096\088\140\178\067\160\202\143\067\105\052\029\193\252\203\135\153\219\079\022\097\144\209\208\146\180\241\076\254\088\140\178\067\080\229\007\068\105\052\029\193\160\210\194\230\080\089\171\012\055\175\207\175\095\083\149\201\044\070\025\068\160\202\143\067\105\052\029\193\161\052\195\173\048\114\177\059\078\133\230\079\248\000\083\205\044\070\025\068\080\229\007\068\105\052\029\193\021\120\244\098\184\099\129\070\080\253\178\096\085\138\014\197\236\050\120\065\157\068\081\066\014\092\171\192\177\214\021\242\104\005\017\055\161\184\152\233\174\156\124\051\067\036\032\195\022\078\207\194\081\054\112\192\071\179\239\002\023\097\223\052\097\138\143\124\027\226\147\078\119\183\191\066\022\078\207\194\081\054\112\192\085\255\152\013\033\184\091\029\219\024\241\112\101\083\116\146\043\241\224\066\135\123\146\067\246\179\255\191\201\040\221\192\212\200\140\163\207\146\006\245\252\115\146\034\035\244\039\068\066\016\036\194\147\182\252\191\120\208\196\047\152\153\224\124\045\130\010\024\240\215\030\160\209\211\052\068\180\105\089\067\063\146\252\191\111\110\254\055\069\162\078\074\054\098\056\079\137\221\118\249\116\069\156\067\208\245\211\067\042\165\251\191\107\001\039\056\192\239\181\052\047\030\002\126\015\051\207\087\076\053\015\068\246\005\240\194\253\224\229\065\051\118\097\007\218\142\076\230\009\029\191\050\071\063\011\182\152\106\158\067\246\005\240\194\253\224\229\065\168\021\002\140\097\028\215\199\112\152\069\205\244\244\030\126\061\163\047\067\066\031\036\194\232\018\006\066",
	["Maraudon"] = "\058\027\077\198\020\020\132\052\202\046\153\040\124\118\136\207\226\185\150\195\141\193\159\195\171\244\208\195\254\161\237\211\188\047\235\223\246\169\109\202\097\015\198\174\226\185\150\195\111\012\126\194\171\244\208\195\024\094\040\090\095\001\058\088\115\139\019\170\029\189\174\095\023\207\053\194\227\124\064\067\171\244\208\195\240\093\237\156\086\203\220\012\006\040\058\022\244\189\012\231\023\207\053\194\113\062\224\067\171\244\208\195\076\037\243\236\109\077\014\253\107\057\110\114\055\176\006\109\023\207\053\194\141\193\159\195\171\244\208\195\065\104\043\012\185\073\069\021\242\216\018\074\142\041\215\143\226\185\150\195\227\124\064\067\171\244\208\195\128\047\032\166\089\000\047\217\245\100\048\175\180\232\027\148\226\185\150\195\113\062\224\067\171\244\208\195\187\156\040\108\101\204\114\125\255\080\073\199\016\041\037\218\023\207\053\194\056\031\048\068\171\244\208\195\016\087\014\098\218\033\106\042\182\162\004\244\000\147\077\048\023\207\053\194\111\012\126\194\171\244\208\195\133\017\240\187\046\181\225\008\237\205\136\026\106\037\016\181\215\128\007\194\154\203\093\068\246\040\208\195\149\002\119\112\043\149\227\038\210\195\039\097\082\040\120\243\201\031\094\067\154\203\029\068\246\040\208\195\160\151\201\000\058\191\012\242\130\115\172\075\127\040\002\158\215\128\007\194\154\203\029\068\246\040\208\195\033\147\086\254\088\066\151\044\184\089\191\003\119\049\135\114\173\067\225\195\094\163\021\068\102\132\175\195\042\000\069\080\044\195\079\070\139\079\109\052\041\207\150\108\214\161\048\196\094\163\021\068\102\132\175\195\037\123\200\096\243\072\194\089\066\145\221\053\036\059\067\133\144\079\197\195\243\247\016\068\049\161\174\195\190\071\217\088\089\244\045\033\252\076\143\250\034\160\074\209\205\203\179\195\156\255\168\067\136\063\172\195\213\227\142\128\030\038\086\146\019\043\217\239\074\073\010\222\144\079\197\195\025\161\216\067\176\228\171\195\003\008\046\222\002\110\163\216\229\129\190\206\041\029\008\254\043\055\005\067\248\025\233\067\078\115\170\195\156\200\106\126\083\169\170\193\023\115\078\214\176\226\185\023\224\153\137\195\248\055\151\067\147\224\169\195\070\100\025\194\175\028\237\075\236\021\071\140\042\194\071\068\121\050\072\196\031\199\121\195\114\024\150\195\236\225\010\013\037\071\229\010\026\008\120\070\211\184\083\169\060\025\132\196\255\027\199\064\114\024\150\195\215\127\023\107\233\162\103\052\085\053\207\224\024\180\109\220\060\025\132\196\031\199\121\195\114\024\150\195\052\147\252\227\215\202\251\026\121\249\075\059\131\030\050\249\121\050\008\196\031\199\121\195\114\024\150\195\111\114\252\019\136\102\152\135\037\047\135\223\038\005\064\214\121\050\008\196\255\027\199\064\114\024\150\195\250\176\119\184\015\033\142\138\212\222\120\013\128\009\235\232\121\050\072\196\255\027\199\064\114\024\150\195\043\009\051\172\246\020\114\047\089\149\079\229\116\029\072\217\073\155\079\196\012\174\018\196\067\202\131\195\187\196\250\033\003\252\097\128\011\044\003\144\178\079\071\059\073\155\079\196\025\092\165\195\067\202\131\195\140\049\214\106\030\070\122\165\051\100\010\207\201\132\096\000\004\063\050\196\192\230\175\195\067\202\131\195\006\111\133\206\124\038\104\073\077\034\139\040\145\223\184\231\164\205\135\196\025\092\165\195\067\202\131\195\225\030\053\115\200\053\087\246\196\132\110\148\203\102\111\185\164\205\135\196\012\174\018\196\067\202\131\195\247\129\009\158\016\156\123\119\002\022\091\211\092\186\149\032\189\104\037\196\118\182\121\195\067\202\131\195\009\148\008\227\001\119\213\089\098\255\240\047\001\114\070\171\051\136\244\195\067\097\218\067\231\194\131\195\028\001\039\075\074\024\028\217\209\027\218\006\234\091\049\165\025\068\058\196\067\097\218\067\231\194\131\195\076\127\012\153\202\126\224\193\189\116\237\226\124\164\013\088\025\068\058\196\134\194\052\067\231\194\131\195\069\070\024\224\038\092\163\110\016\148\233\181\035\124\066\078\051\136\244\195\134\194\052\067\231\194\131\195\227\117\073\005\142\036\162\105\222\141\042\012\230\059\097\182\141\048\240\195\199\162\001\067\055\166\129\195\139\058\125\197\001\064\125\104\113\166\195\146\104\186\215\064\022\044\008\196\075\127\031\067\054\166\129\195\008\073\169\167\185\186\156\056\121\113\244\128\143\004\174\255\079\136\051\196\049\221\246\067\005\046\112\195\019\129\186\219\003\135\136\065\022\210\017\164\020\236\147\234\002\044\175\195\176\171\203\067\209\194\089\195\086\245\144\140\085\100\116\187\095\145\050\149\070\178\021\147\195\036\133\196\222\093\147\195\102\174\064\195\216\020\238\153\028\137\109\152\230\148\221\129\251\137\140\028\195\036\165\196\247\238\026\194\102\174\064\195\199\234\169\248\167\046\147\161\232\220\173\209\030\071\149\014\195\036\165\196\222\093\147\195\102\174\064\195\167\159\136\176\255\141\200\212\141\204\077\037\058\069\157\025\195\036\133\196\247\238\026\194\102\174\064\195\200\215\186\173\156\167\002\193\128\064\019\081\216\176\081\087\111\066\133\196\152\166\156\195\235\128\060\195\020\020\120\143\010\021\099\187\085\094\251\184\243\175\228\118\111\066\133\196\060\196\205\195\118\039\060\195\187\007\171\041\069\174\181\077\159\019\051\225\134\010\207\155\205\146\214\196\223\148\018\193\024\093\050\195\225\014\227\231\087\175\092\252\215\165\176\061\204\190\130\184\205\146\214\196\166\148\132\195\024\093\050\195\228\081\155\067\041\074\054\238\056\086\191\049\054\185\043\088\205\146\182\196\166\148\132\195\024\093\050\195\134\017\091\078\215\076\085\057\206\019\197\050\189\036\233\106\100\168\234\196\099\188\004\064\166\207\049\195\138\231\109\126\057\191\014\006\139\064\086\199\159\070\240\153\100\168\234\196\120\009\129\067\166\207\049\195\172\092\163\211\041\172\229\120\015\162\095\143\198\049\051\236\100\168\234\196\188\132\000\068\166\207\049\195\229\197\079\149\000\163\142\081\191\152\000\241\173\010\097\124\100\168\202\196\099\188\004\064\166\207\049\195\209\080\047\020\175\166\048\094\229\235\225\252\043\199\122\114\100\168\202\196\188\132\000\068\166\207\049\195\004\201\166\135\209\189\118\169\247\181\233\027\001\112\124\014\100\168\202\196\120\009\129\067\166\207\049\195\144\250\019\162\038\064\010\066\013\211\121\090\087\091\055\186\220\027\018\197\177\076\169\067\140\227\032\195\226\074\118\233\242\101\204\130\066\220\183\031\229\197\108\105\220\027\002\197\177\076\169\067\140\227\032\195\193\071\070\253\030\231\022\145\248\042\191\232\122\048\126\107\220\027\018\197\088\166\020\068\140\227\032\195\093\143\044\167\102\114\220\034\133\235\149\055\187\029\046\124\066\200\006\197\033\174\012\068\082\133\018\195\062\098\222\240\138\224\139\114\137\214\195\042\195\103\110\202\043\003\255\196\250\254\021\068\116\136\016\195\162\167\187\012\028\202\211\002\241\211\222\203\206\194\231\048\038\061\245\196\192\212\037\067\158\085\008\195\008\224\088\227\020\041\023\144\193\247\192\069\209\048\155\255\240\116\156\196\080\249\133\067\009\034\002\195\164\035\201\114\253\078\081\084\177\197\139\138\138\078\137\137\240\116\188\196\080\249\133\067\009\034\002\195\067\178\100\215\082\155\031\051\183\137\075\009\244\248\102\179\240\116\188\196\168\252\002\068\009\034\002\195\120\203\141\039\204\158\019\207\233\047\026\145\028\035\233\093\240\116\156\196\168\252\002\068\009\034\002\195\013\041\056\206\069\068\196\146\084\129\115\141\088\203\012\102\036\014\225\196\155\165\092\068\177\231\000\195\102\199\068\081\095\116\082\166\187\211\248\208\122\237\164\085\036\014\225\196\155\165\028\068\177\231\000\195\068\042\046\046\083\124\156\118\221\166\213\010\037\169\193\120\036\014\193\196\155\165\028\068\177\231\000\195\148\138\084\050\172\040\211\049\120\176\183\096\225\232\049\178\234\115\219\196\186\065\152\193\254\140\253\194\032\095\187\155\120\218\250\145\061\156\221\180\082\072\087\188\234\115\251\196\186\065\152\193\254\140\253\194\249\222\204\115\211\092\251\223\079\009\207\022\029\073\093\208\123\118\175\196\120\232\019\067\156\229\230\194\147\015\254\035\201\175\152\171\039\255\146\082\067\008\251\095\145\036\217\196\149\143\081\068\186\025\226\194\005\110\191\232\164\162\218\168\059\252\055\097\199\064\125\040\076\235\219\196\016\216\188\068\096\141\225\194\012\090\002\028\031\083\203\160\207\088\061\035\026\009\107\208\076\235\219\196\016\216\156\068\096\141\225\194\219\084\248\120\114\050\104\097\166\205\180\255\189\113\205\181\076\235\187\196\016\216\188\068\096\141\225\194\057\175\142\086\163\028\226\241\212\013\106\058\049\196\068\248\076\235\187\196\016\216\156\068\096\141\225\194\055\096\224\181\220\062\238\084\228\152\089\104\036\254\119\090\020\187\206\196\086\016\078\068\186\126\222\194\133\121\114\223\100\062\190\063\249\239\139\007\170\091\030\178\020\187\206\196\043\008\135\068\186\126\222\194\238\058\021\029\144\119\215\246\134\137\231\099\007\223\144\159\020\187\174\196\086\016\078\068\186\126\222\194\109\247\073\072\080\026\062\230\207\179\225\163\163\143\023\047\196\194\221\196\097\192\203\067\183\057\218\194\173\011\111\166\240\148\081\233\069\236\215\208\217\049\115\194\196\194\253\196\097\192\203\067\183\057\218\194\026\176\037\124\030\202\004\022\182\186\153\130\156\086\155\181\196\194\253\196\048\224\037\068\183\057\218\194\067\161\085\253\114\101\116\050\066\015\051\002\160\097\217\137\189\168\226\196\231\018\069\068\062\143\213\194\148\137\000\206\040\167\127\160\048\141\058\159\129\100\043\038\212\153\152\196\067\221\018\068\112\252\211\194\083\215\213\089\203\180\139\120\213\024\145\093\180\176\229\045\212\153\184\196\067\221\018\068\112\252\211\194\183\153\114\010\203\150\031\110\111\087\058\023\097\123\178\157\054\024\252\196\192\047\085\068\174\068\205\194\247\128\237\033\081\223\096\250\212\239\036\225\180\166\082\025\096\004\009\197\175\031\080\068\252\184\175\194\241\252\005\166\247\017\139\025\126\049\230\236\124\150\183\100\183\096\000\197\127\126\039\068\195\246\173\194\124\220\220\140\014\251\012\150\158\165\040\116\104\040\214\245\176\191\004\197\048\071\027\068\158\192\164\194\085\115\204\171\114\028\134\227\202\036\048\101\138\253\213\191\200\209\008\197\014\204\050\068\111\087\150\194\186\247\113\218\008\031\116\225\111\076\133\084\004\203\005\087\163\198\205\196\034\227\145\068\049\032\133\194\216\176\103\172\147\162\052\224\131\176\083\224\069\102\090\250\163\198\205\196\173\030\137\068\056\252\132\194",
	["Molten Core"] = "\132\123\253\063\204\078\156\146\149\143\200\190\007\214\084\175\212\169\204\196\166\014\200\068\176\133\233\195\019\221\251\107\182\016\076\071\096\111\063\172\220\076\190\005\212\169\236\196\166\014\232\068\176\133\233\195\025\101\236\176\002\037\189\181\019\002\140\188\058\106\091\038\212\169\236\196\166\014\168\068\176\133\233\195\012\081\132\107\084\247\190\246\246\137\223\082\118\223\195\107\212\169\204\196\166\014\168\068\176\133\233\195\069\103\046\230\253\081\080\238\103\149\158\152\082\189\015\158\212\169\236\196\166\014\200\068\176\133\233\195\046\148\108\148\244\131\130\136\163\091\088\149\175\187\119\127\212\169\204\196\166\014\232\068\176\133\233\195\121\217\164\094\090\080\186\004\056\067\246\195\068\010\052\067\127\069\245\196\002\151\153\068\000\228\230\195\076\223\234\208\230\015\041\220\099\224\145\207\142\244\236\061\127\069\245\196\005\046\115\068\000\228\230\195\115\170\176\022\220\013\051\193\218\143\212\141\222\222\008\035\127\069\213\196\002\151\153\068\000\228\230\195\135\000\217\133\155\116\085\014\229\108\191\004\040\038\209\083\127\069\245\196\002\151\185\068\000\228\230\195\162\229\219\124\042\097\129\006\176\203\198\210\000\253\022\128\127\069\213\196\005\046\115\068\000\228\230\195\161\189\250\056\071\250\048\041\191\100\139\096\096\080\090\016\191\162\010\197\002\151\185\068\000\228\230\195\058\162\051\111\207\178\061\099\142\217\226\114\248\022\038\083\191\162\026\197\002\151\185\068\000\228\230\195\082\047\201\074\065\100\176\166\189\178\183\188\192\052\218\033\191\162\010\197\005\046\115\068\000\228\230\195\124\187\166\025\254\172\078\041\124\254\032\222\012\164\003\042\191\162\010\197\002\151\153\068\000\228\230\195\060\121\002\249\200\080\097\156\040\223\175\225\034\188\025\179\191\162\026\197\002\151\153\068\000\228\230\195\088\014\161\185\110\011\197\211\066\081\057\038\097\046\060\031\191\162\026\197\005\046\115\068\000\228\230\195\161\088\085\241\084\073\038\004\023\165\083\139\029\171\215\126\003\045\230\196\071\005\016\069\109\088\225\195\137\242\231\053\024\058\241\032\101\108\130\009\073\012\138\226\003\045\198\196\142\010\224\068\109\088\225\195\025\060\254\106\086\119\238\202\065\103\094\013\241\001\147\254\003\045\230\196\142\010\224\068\109\088\225\195\232\083\132\004\243\234\070\111\112\073\255\163\199\137\040\057\003\045\198\196\071\005\000\069\109\088\225\195\210\089\088\135\175\150\060\091\247\227\070\100\176\164\046\149\003\045\166\196\142\010\224\068\109\088\225\195\141\101\189\082\036\241\001\196\050\227\213\128\159\231\122\139\003\045\198\196\071\005\016\069\109\088\225\195\106\134\094\222\105\060\126\224\127\193\049\052\052\039\209\190\003\045\134\196\071\005\000\069\109\088\225\195\188\131\017\226\012\022\059\182\087\147\236\020\027\027\111\108\003\045\230\196\071\005\000\069\109\088\225\195\142\215\165\125\102\095\030\189\216\153\150\059\048\054\075\100\003\045\166\196\071\005\016\069\109\088\225\195\198\052\240\031\062\163\179\110\100\083\115\228\179\133\184\206\003\045\166\196\071\005\000\069\109\088\225\195\006\218\152\175\247\154\092\085\066\056\083\193\105\084\176\215\224\019\185\196\006\191\214\068\244\044\219\195\234\134\217\015\207\102\246\025\210\217\197\079\070\098\179\227\224\019\185\196\006\191\150\068\244\044\219\195\142\156\009\197\180\098\147\144\026\198\023\142\065\015\228\235\224\019\153\196\006\191\150\068\244\044\219\195\001\029\065\152\130\253\133\151\104\178\217\156\075\109\029\129\224\019\153\196\006\191\214\068\244\044\219\195\039\116\006\105\081\182\227\056\239\182\044\067\248\084\110\127\224\019\153\196\006\191\182\068\244\044\219\195\239\200\023\148\125\127\137\226\207\003\027\130\202\151\076\135\224\019\185\196\006\191\182\068\244\044\219\195\146\150\169\086\102\245\229\162\184\164\208\235\024\068\049\108\079\009\170\196\120\026\100\068\090\041\218\195\013\134\008\160\145\225\088\184\178\170\062\050\048\236\239\047\079\009\202\196\060\013\146\068\090\041\218\195\037\182\220\102\015\140\205\210\203\017\145\125\047\016\055\250\079\009\202\196\120\026\100\068\090\041\218\195\178\190\113\121\202\003\007\199\046\170\020\187\235\194\091\230\098\040\181\196\033\114\149\068\123\028\210\195\053\216\126\149\031\251\207\019\235\202\213\212\140\199\131\212\000\149\017\197\044\204\000\069\059\121\192\195\055\201\100\007\228\209\137\183\117\102\174\209\049\037\006\249\000\149\017\197\088\152\225\068\059\121\192\195\214\176\052\164\230\117\228\023\081\150\023\215\123\086\041\137\001\042\227\196\088\152\225\068\059\121\192\195\212\018\242\098\065\103\191\021\075\197\151\018\081\209\020\138\000\149\001\197\088\152\225\068\059\121\192\195\228\126\158\182\039\174\008\222\005\055\008\162\093\142\209\141\176\253\006\197\245\198\217\068\163\043\179\195\109\065\179\100\110\200\217\218\035\126\255\223\137\085\089\076\097\251\237\196\245\198\217\068\163\043\179\195\198\162\076\017\227\009\219\126\150\082\135\235\211\053\105\056\090\167\005\197\157\246\208\068\009\045\167\195\120\155\078\096\178\149\138\115\061\132\205\123\149\105\076\162\195\161\038\197\068\213\131\068\017\198\122\195\202\116\190\086\113\179\186\056\195\126\120\226\031\013\080\000\195\161\038\197\136\170\071\068\017\198\122\195\086\101\119\251\118\200\092\200\000\236\053\032\153\134\233\232\195\161\022\197\136\170\007\068\017\198\122\195\230\129\053\118\236\192\225\093\184\102\134\077\137\189\114\202\195\161\022\197\136\170\071\068\017\198\122\195\048\177\237\118\092\104\215\206\024\061\063\153\130\237\065\232\195\161\038\197\136\170\007\068\017\198\122\195\040\079\225\104\048\003\007\198\100\097\218\082\129\100\046\203\245\006\012\197\066\059\098\068\190\149\089\195\241\214\048\251\217\205\243\027\148\236\232\027\228\248\163\173\024\167\032\197\188\003\017\068\126\126\028\195",
	["Naxxramas"] = "\044\191\245\055\235\215\143\040\130\005\036\022\141\143\118\053\000\074\139\196\207\085\131\068\241\112\125\195\215\172\112\099\064\050\251\057\120\139\068\085\009\108\046\028\001\148\086\196\207\085\131\068\241\112\125\195\132\250\018\200\093\198\062\037\114\027\250\247\250\177\148\153\000\074\139\196\159\171\070\068\241\112\125\195\211\194\025\066\153\071\154\039\227\072\108\243\082\136\180\248\001\148\086\196\159\171\070\068\241\112\125\195\013\169\105\098\247\144\211\084\071\070\092\061\189\004\028\170\164\162\060\068\097\071\249\195\015\041\255\194\204\078\135\073\218\123\163\159\109\165\030\132\011\117\130\005\164\162\060\068\176\163\060\196\015\041\255\194\133\016\057\043\160\072\152\120\043\243\126\180\176\230\116\019\164\162\124\068\176\163\060\196\015\041\255\194\227\027\101\063\007\171\241\160\043\212\166\045\236\037\204\036\056\204\244\067\120\245\127\196\014\041\255\194\171\089\118\139\173\022\002\251\094\249\041\073\074\109\034\181\006\039\032\068\160\025\089\196\014\041\255\194\188\037\029\108\193\172\025\227\121\116\149\015\064\224\170\160\028\102\058\068\120\245\127\196\014\041\255\194\113\204\099\188\216\128\049\053\189\011\094\157\245\094\059\018\056\204\244\067\120\245\063\196\014\041\255\194\033\066\017\185\161\146\125\032\074\117\204\158\033\172\126\063\199\062\074\068\070\041\244\195\010\041\255\194\105\043\141\134\160\087\192\141\092\138\071\186\194\084\096\128\064\053\157\067\033\179\118\196\010\041\255\194\139\139\021\135\053\071\129\104\206\055\117\181\155\122\054\251\160\045\042\068\196\174\035\067\209\250\250\194\156\142\233\194\238\235\255\109\035\056\135\151\039\240\072\254\129\182\040\067\196\174\035\067\209\250\250\194\108\001\138\182\100\127\214\054\237\095\150\020\038\101\038\212\129\182\040\067\098\215\209\067\209\250\250\194\210\149\129\243\184\098\005\117\024\129\072\251\041\175\202\040\064\091\212\067\196\174\035\067\209\250\250\194\157\203\232\040\092\228\000\010\118\242\090\124\030\243\157\039\154\161\125\068\147\166\141\196\006\061\241\194\052\047\012\197\203\023\251\155\246\049\108\026\168\030\133\147\154\161\125\068\039\077\091\196\006\061\241\194\150\056\033\156\012\024\217\229\234\010\153\171\023\254\130\127\154\161\061\068\039\077\091\196\006\061\241\194\172\149\096\117\113\168\200\099\179\161\065\242\060\161\087\113\154\161\061\068\147\166\141\196\006\061\241\194\048\111\126\221\015\248\117\111\118\223\093\029\223\020\019\082\070\236\213\194\226\190\102\196\188\179\221\194\041\216\129\085\142\012\233\195\172\058\018\133\002\053\107\135\164\135\184\063\226\190\102\196\188\179\221\194\056\127\245\157\048\160\203\039\183\031\061\009\126\028\009\124\163\050\090\068\218\061\226\189\186\179\221\194\149\036\127\063\191\204\254\082\214\193\075\222\248\011\154\162\163\050\090\068\249\006\217\194\186\179\221\194\193\088\005\142\169\129\108\026\219\240\179\147\064\117\154\148\136\091\102\196\095\124\099\189\185\179\221\194\208\240\065\033\090\069\178\219\204\186\008\066\051\233\208\067\218\178\213\194\078\207\089\068\184\179\221\194\255\010\135\220\242\130\015\156\231\040\159\128\112\241\239\145\034\138\191\063\078\207\089\068\184\179\221\194\214\146\185\011\128\192\182\059\098\129\200\000\150\142\242\247\136\091\102\196\120\205\216\194\182\179\221\194\062\042\046\020\239\046\167\070\008\150\139\241\162\223\026\016\203\242\004\196\035\095\155\067\094\191\169\194\188\059\125\096\117\207\253\196\008\053\176\123\218\073\213\046\203\242\068\196\145\175\013\068\094\191\169\194\099\115\244\023\067\003\028\110\210\208\088\115\075\028\051\241\203\242\068\196\035\095\155\067\094\191\169\194\062\150\206\051\034\062\148\134\148\218\192\128\091\064\124\097\203\242\004\196\145\175\013\068\094\191\169\194\132\236\005\012\127\187\103\160\108\059\054\123\068\114\034\097\151\229\137\195\145\175\013\068\094\191\169\194\049\166\037\129\064\191\018\152\201\199\135\075\058\242\035\100\103\250\001\068\108\151\152\065\222\070\159\194\170\112\076\116\141\099\176\217\021\196\089\143\131\111\080\195\090\193\165\067\251\210\151\066\176\125\155\194\150\208\140\141\042\075\087\125\104\254\213\113\100\003\143\219\219\214\155\195\233\001\128\196\070\089\147\194\247\141\106\010\243\150\086\089\091\003\078\157\245\015\229\229\134\149\127\196\135\142\156\195\057\089\147\194\247\182\176\064\218\053\195\137\081\152\004\211\008\024\106\127\229\119\139\066\218\242\127\196\051\089\147\194\199\055\061\193\197\100\011\067\197\212\094\136\218\103\048\129\159\088\065\068\072\146\156\195\051\089\147\194\061\096\222\176\218\105\078\037\104\235\204\240\179\182\203\093\086\177\139\066\179\197\127\068\049\089\147\194\087\067\056\058\095\025\009\075\234\227\227\110\100\113\085\159\086\177\139\066\179\197\063\068\049\089\147\194\191\022\116\097\043\073\201\183\107\112\249\193\233\242\041\147\012\041\064\068\058\093\136\066\049\089\147\194\111\247\091\086\086\025\132\116\207\102\153\027\186\231\119\119\134\020\128\068\058\093\136\066\049\089\147\194\186\051\087\180\123\253\251\207\215\249\224\120\018\153\225\237\064\189\155\195\179\197\063\068\047\089\147\194\157\021\090\221\179\102\070\074\012\126\185\190\095\077\076\253\064\189\155\195\179\197\127\068\047\089\147\194\064\086\240\235\085\104\092\078\181\163\113\106\079\185\169\144\100\146\127\196\188\150\136\066\047\089\147\194\120\041\092\159\076\128\209\185\214\040\248\103\175\120\075\128\041\099\243\195\116\199\118\196\194\227\146\194\167\062\124\022\153\140\022\017\138\230\107\072\059\192\006\157\172\067\157\067\118\219\073\068\185\227\146\194\126\118\191\060\002\171\195\012\187\230\116\081\134\039\190\071\148\062\074\068\148\110\156\067\185\227\146\194\102\228\062\092\207\255\153\144\186\074\246\226\120\182\074\228\004\080\118\196\001\125\156\067\183\227\146\194\102\131\041\196\198\101\044\219\134\219\229\156\157\065\238\075\064\084\243\195\064\219\073\068\183\227\146\194\217\004\170\142\116\018\070\194\062\132\112\126\226\096\169\102\207\079\118\196\214\026\244\195\182\227\146\194\018\026\176\110\103\224\065\108\218\221\100\060\193\134\098\165\154\048\046\196\113\246\181\195\109\005\135\194\024\018\187\099\071\090\199\232\174\062\037\203\105\099\121\104\154\048\046\196\199\217\215\194\109\005\135\194\209\160\163\243\060\139\037\039\092\121\078\077\253\043\194\087\053\097\220\195\199\217\215\194\109\005\135\194\018\232\145\242\063\210\252\113\222\037\108\123\045\184\072\071\053\097\220\195\113\246\181\195\109\005\135\194\119\075\113\144\160\211\195\196\123\041\056\139\185\141\174\216\129\143\199\067\072\137\052\196\145\233\133\194\217\236\167\037\254\101\002\142\162\023\130\158\216\069\252\014\192\199\035\068\072\137\052\196\145\233\133\194\238\045\012\163\251\105\048\071\204\127\236\010\165\108\180\190\192\199\035\068\145\018\233\195\145\233\133\194\069\103\065\100\044\197\022\064\139\056\131\028\222\070\200\173\129\143\199\067\145\018\233\195\145\233\133\194\076\240\021\208\177\159\074\205\184\180\060\150\159\147\082\219\077\105\056\068\242\228\147\195\164\094\133\194\036\034\012\224\143\193\049\061\148\104\075\056\198\010\088\221\154\210\240\067\242\228\147\195\164\094\133\194\003\226\042\167\122\133\131\198\061\115\163\239\138\217\166\076\077\105\056\068\151\039\031\194\164\094\133\194\159\103\121\119\108\096\169\092\143\116\208\152\068\006\137\132\154\210\240\067\151\039\031\194\164\094\133\194\126\030\139\072\196\015\208\174\137\126\073\131\019\104\140\215\213\164\200\067\232\022\141\195\052\067\133\194\000\203\223\237\129\084\010\115\069\243\003\242\045\009\105\035\165\040\174\067\094\020\062\196\051\067\133\194\255\206\082\188\224\141\050\249\162\200\069\137\024\165\092\151\150\162\184\066\189\040\252\195\051\067\133\194\191\128\150\196\157\252\094\015\198\101\004\002\253\204\143\009\150\162\184\066\094\020\062\196\051\067\133\194\049\029\002\088\093\230\152\037\238\137\013\183\179\013\204\054\165\040\174\067\189\040\252\195\051\067\133\194\218\245\218\255\215\222\081\212\117\076\218\077\120\232\083\038\073\134\025\067\197\005\025\068\176\024\129\194\241\065\003\247\138\103\042\120\152\122\200\163\249\137\246\089\036\195\204\067\197\005\025\068\176\024\129\194\109\064\029\056\200\068\225\020\243\083\157\112\209\210\185\168\207\202\104\195\091\176\035\068\193\189\115\194\046\157\173\068\000\226\019\106\009\080\189\076\024\085\237\084\090\049\154\067\031\095\128\068\248\191\113\194\059\152\075\140\202\102\183\135\107\150\230\019\018\217\231\095\215\138\081\066\031\095\128\068\248\191\113\194\210\136\016\115\018\002\100\129\104\245\032\004\009\114\087\115\252\209\179\067\168\192\202\067\181\012\095\194\192\130\080\210\092\065\144\233\166\117\211\226\225\078\027\239\084\246\201\195\136\175\198\195\123\228\063\194\091\065\060\231\087\203\141\014\095\250\017\097\111\205\244\247\169\236\019\195\136\175\198\195\123\228\063\194\160\205\012\081\203\004\071\143\045\167\038\029\112\108\124\135\084\246\201\195\017\095\013\195\123\228\063\194\073\230\128\013\156\210\069\147\071\092\048\189\165\179\193\074\200\152\226\195\031\226\114\067\247\120\042\194\001\170\155\005\073\056\244\008\124\053\017\082\138\115\149\180\044\168\033\195\025\254\189\066\169\040\041\194\234\054\033\206\005\246\049\254\112\150\234\022\000\111\050\106\165\175\188\066\242\000\033\195\169\040\041\194\210\055\224\051\188\098\045\172\180\067\178\052\095\070\251\075\044\168\033\195\242\000\033\195\169\040\041\194\015\048\117\102\226\232\032\167\005\063\132\002\195\150\169\010\086\208\045\196\145\140\045\196\072\132\030\194\005\174\044\103\204\154\079\053\237\159\096\231\044\225\096\063\094\168\163\195\207\162\169\066\091\075\015\194\232\222\162\052\001\011\163\078\009\042\162\012\157\176\161\121\111\252\040\196\017\088\080\067\135\104\006\194\122\184\057\022\051\066\169\181\063\106\165\086\036\003\205\039\111\252\040\196\184\159\062\194\135\104\006\194\149\007\142\012\235\221\001\226\082\130\169\196\194\013\199\020\223\248\209\195\184\159\062\194\135\104\006\194\178\081\211\069\214\160\174\224\214\041\108\045\068\194\092\237\179\109\067\195\181\133\065\195\249\090\005\194\197\137\070\071\003\223\000\011\085\068\146\189\204\095\012\195\057\082\198\195\016\210\030\066\248\136\234\193\249\197\122\211\044\154\018\146\154\080\003\069\161\096\089\161\252\151\139\196\059\175\139\196\127\126\229\193\003\001\137\192\115\028\211\143\118\170\213\211\167\138\117\002\252\151\139\196\119\094\087\196\127\126\229\193\152\145\125\020\089\021\186\155\144\209\218\049\065\191\169\203\249\047\087\196\119\094\087\196\127\126\229\193\227\095\169\004\094\187\207\116\169\040\023\076\062\101\061\069\249\047\087\196\059\175\139\196\127\126\229\193\083\176\143\194\003\215\047\110\093\222\001\013\096\158\157\014\107\156\026\195\045\103\111\066\131\184\222\193\021\071\226\238\048\030\206\095\183\232\223\072\116\227\204\089\134\050\173\195\131\137\006\196\187\158\165\193\029\197\182\215\217\171\013\021\045\243\000\034\066\095\200\041\107\009\089\196\082\202\031\068\123\124\154\193\255\173\109\123\028\041\189\193\030\242\032\011\050\131\023\138\074\027\059\196\148\197\125\196\221\121\154\193\171\188\007\151\067\130\161\007\021\045\077\005\127\100\040\169\074\027\059\196\148\197\061\196\221\121\154\193\212\068\122\057\048\203\224\030\209\187\117\181\045\110\141\109\149\054\246\195\148\197\125\196\221\121\154\193\106\246\046\211\085\040\160\223\015\201\198\066\065\112\077\180\161\145\127\196\219\028\090\196\200\121\154\193\249\048\171\182\178\223\119\236\198\061\255\007\174\039\226\245\161\145\063\196\219\028\090\196\200\121\154\193\185\219\113\095\171\146\078\157\117\115\033\049\015\076\100\117\161\145\127\196\219\028\026\196\200\121\154\193\203\187\240\194\200\135\085\045\208\128\129\000\101\217\014\054\161\145\063\196\219\028\026\196\200\121\154\193\111\154\198\033\187\188\101\037\064\058\034\033\022\051\000\015\151\163\060\068\156\005\244\067\182\121\154\193\117\251\035\179\028\172\110\002\198\177\153\008\105\090\122\053\087\109\058\068\086\063\060\068\182\121\154\193\233\065\198\215\142\002\253\117\039\040\205\000\054\125\004\059\151\163\060\068\206\002\058\068\182\121\154\193\243\252\243\187\254\205\175\154\179\014\240\067\099\043\146\120\151\163\124\068\156\005\244\067\182\121\154\193\068\085\180\141\006\129\081\160\020\171\114\045\022\143\182\157\174\218\244\067\086\063\124\068\182\121\154\193\249\255\001\017\019\158\125\199\076\055\023\106\086\222\082\139\174\218\244\067\086\063\060\068\182\121\154\193\243\081\077\235\015\017\086\013\055\212\150\056\244\218\090\050\166\045\032\068\183\195\031\068\177\121\154\193\151\188\100\252\059\098\254\203\228\208\121\098\226\118\032\012\020\146\127\196\248\019\244\067\175\121\154\193\094\080\089\011\137\200\118\027\122\246\075\007\050\013\053\049\020\146\127\196\252\009\058\068\175\121\154\193\174\169\128\218\186\146\251\128\141\006\067\227\112\068\154\200\020\146\063\196\248\019\244\067\175\121\154\193\089\095\197\032\026\100\132\139\153\248\039\230\007\092\228\193\121\115\248\195\067\064\060\068\172\121\154\193\160\196\065\074\039\227\074\117\186\045\224\071\038\029\088\056\188\057\060\196\067\064\060\068\172\121\154\193\229\210\038\090\044\157\141\124\217\133\122\200\107\182\184\191\188\057\060\196\067\064\124\068\172\121\154\193\041\197\206\023\038\069\167\152\062\067\224\045\139\091\106\035\135\164\027\195\115\213\254\195\023\071\131\193\024\173\208\112\160\207\032\012\019\231\240\195\184\192\096\045\067\210\205\195\115\213\254\195\023\071\131\193\082\177\180\053\170\134\247\235\049\016\026\182\136\226\228\021\067\210\205\195\185\106\063\196\023\071\131\193\092\087\185\044\094\135\036\022\245\025\193\179\138\167\013\205\135\164\027\195\185\106\063\196\023\071\131\193\216\209\014\212\204\188\123\113\143\039\145\191\192\164\078\023\033\233\038\196\115\213\254\195\023\071\131\193\009\156\251\040\113\230\085\099\152\221\122\058\133\082\090\146\033\233\038\196\185\106\063\196\023\071\131\193\028\023\191\211\210\036\101\055\252\083\037\058\105\245\202\219\047\117\164\067\105\154\091\066\235\029\127\193\156\074\136\140\064\111\131\092\100\090\185\101\022\206\066\210\191\212\145\066\105\154\091\066\235\029\127\193\131\151\186\193\229\146\194\169\240\098\235\101\124\190\227\096\167\052\158\067\144\215\192\195\057\041\188\192\032\023\215\126\003\232\211\147\094\068\201\082\162\255\211\193\061\165\113\066\144\215\192\195\057\041\188\192\099\118\044\053\138\135\048\245\243\137\140\112\108\032\233\035\061\165\113\066\033\175\001\195\057\041\188\192",
	["Old Hillsbrad Foothills"] = "\096\146\171\052\042\027\224\185\059\252\080\143\003\025\068\021\255\255\215\069\255\255\199\197\000\000\000\000\082\050\011\185\099\130\158\184\168\097\187\034\127\119\163\191\255\255\215\069\255\255\207\197\000\000\000\000\060\159\201\098\196\158\200\033\017\034\077\134\201\023\076\047\255\255\215\069\255\255\215\197\000\000\000\000\166\170\140\240\245\172\095\070\113\165\250\179\166\214\109\019\255\255\215\069\255\255\223\197\000\000\000\000\017\063\176\104\084\140\002\238\052\011\234\122\048\005\075\137\255\255\215\069\255\255\231\197\000\000\000\000\016\146\223\162\132\206\091\161\132\182\171\009\050\248\253\122\255\255\215\069\255\255\239\197\000\000\000\000\089\220\092\066\168\179\107\009\035\168\158\126\141\228\027\225\255\255\223\069\255\255\199\197\000\000\000\000\044\198\061\071\087\040\210\094\223\148\160\096\115\200\191\153\255\255\223\069\255\255\207\197\000\000\000\000\074\146\250\140\066\125\212\029\126\167\192\183\241\074\199\117\255\255\223\069\255\255\215\197\000\000\000\000\208\046\219\076\133\062\235\042\080\002\194\059\232\216\118\135\255\255\223\069\255\255\223\197\000\000\000\000\129\161\019\105\110\021\195\201\177\200\167\172\196\167\104\054\255\255\223\069\255\255\231\197\000\000\000\000\019\091\122\044\153\140\127\237\073\114\045\091\033\158\171\139\255\255\223\069\255\255\239\197\000\000\000\000\144\007\038\246\049\167\243\187\032\067\251\046\255\038\063\026\255\255\231\069\255\255\199\197\000\000\000\000\120\012\136\072\049\079\132\233\110\077\069\047\019\237\161\166\255\255\231\069\255\255\207\197\000\000\000\000\081\080\206\009\150\160\157\196\155\116\243\206\200\201\201\179\255\255\231\069\255\255\215\197\000\000\000\000\093\035\171\024\156\200\013\144\102\125\230\026\225\108\131\100\255\255\231\069\255\255\223\197\000\000\000\000\254\055\243\003\093\108\228\137\246\123\156\228\086\091\222\097\255\255\231\069\255\255\231\197\000\000\000\000\117\052\166\093\158\075\209\153\106\089\070\004\008\235\058\013\255\255\231\069\255\255\239\197\000\000\000\000\006\223\151\093\240\075\061\147\126\010\073\081\211\007\082\233\255\255\239\069\255\255\199\197\000\000\000\000\119\204\194\220\035\077\198\014\000\098\195\220\028\200\209\133\255\255\239\069\255\255\207\197\000\000\000\000\163\018\202\011\222\185\185\110\252\100\180\138\072\074\041\084\255\255\239\069\255\255\215\197\000\000\000\000\014\130\130\239\050\005\002\140\105\155\128\237\005\239\151\238\255\255\239\069\255\255\223\197\000\000\000\000\208\093\056\241\192\048\078\051\203\002\179\225\110\252\081\049\255\255\239\069\255\255\231\197\000\000\000\000\070\209\244\218\162\167\025\195\226\194\048\003\126\037\217\145\255\255\239\069\255\255\239\197\000\000\000\000\131\049\141\174\018\241\246\123\160\129\155\028\237\206\098\060\255\255\247\069\255\255\199\197\000\000\000\000\247\066\216\209\004\066\068\042\145\058\170\186\141\227\095\117\255\255\247\069\255\255\207\197\000\000\000\000\154\190\213\137\032\238\000\141\069\121\242\016\145\071\241\087\255\255\247\069\255\255\215\197\000\000\000\000\085\200\131\237\088\065\109\039\090\005\003\056\098\113\241\023\255\255\247\069\255\255\223\197\000\000\000\000\158\002\102\201\017\085\108\050\110\229\061\143\170\190\214\081\255\255\247\069\255\255\231\197\000\000\000\000\060\220\129\240\252\044\045\188\134\066\067\164\094\049\117\244\255\255\247\069\255\255\239\197\000\000\000\000\119\105\141\121\030\014\091\194\021\050\213\105\182\068\173\003\000\000\000\070\255\255\199\197\000\000\000\000\180\113\210\113\134\218\200\238\172\051\122\053\148\198\126\224\000\000\000\070\255\255\207\197\000\000\000\000\135\208\195\092\019\051\206\012\235\162\068\179\222\137\127\172\000\000\000\070\255\255\215\197\000\000\000\000\222\180\254\221\019\157\241\214\012\164\026\228\073\242\090\168\000\000\000\070\255\255\223\197\000\000\000\000\052\013\050\170\107\173\033\039\090\143\160\071\006\007\044\170\000\000\000\070\255\255\231\197\000\000\000\000\078\039\026\091\099\166\114\167\036\089\003\145\205\079\127\081\000\000\000\070\255\255\239\197\000\000\000\000",
	["Onyxia's Lair"] = "\214\006\144\090\106\192\089\060\010\142\001\023\104\144\162\224\078\183\009\067\203\044\007\068\072\243\064\195\181\074\120\175\075\229\201\167\184\106\061\252\037\057\012\105\097\145\236\194\151\089\142\067\072\243\064\195\144\207\015\007\000\038\139\176\003\083\103\135\095\213\131\070\097\145\236\194\203\044\007\068\072\243\064\195\043\093\213\042\066\022\225\106\243\255\158\154\211\096\022\169\078\183\009\067\151\089\142\067\072\243\064\195\136\194\130\218\077\215\174\124\226\047\242\207\219\251\210\005\152\052\125\067\198\013\110\067\170\169\013\195\224\127\009\025\246\075\144\241\178\011\252\122\086\207\237\196\152\052\125\067\227\006\247\067\170\169\013\195\196\166\067\175\190\034\231\042\234\039\196\248\072\015\028\226\027\147\032\067\157\130\050\067\177\023\253\194\084\151\051\154\184\056\118\169\064\065\225\122\035\255\216\035\132\111\066\066\166\209\026\067\211\027\162\194\244\003\171\195\152\093\005\159\034\172\188\111\127\059\166\069\079\194\095\064\235\109\042\067\186\084\133\194\092\086\177\009\088\185\109\173\238\028\060\117\148\253\011\222\216\251\252\194\169\112\197\066\071\208\103\194\072\149\007\251\121\227\001\132\144\096\153\023\045\197\028\199\221\124\180\194\095\111\203\065\164\141\024\193",
	["Ragefire Chasm"] = "\018\179\009\195\082\218\017\137\226\028\219\037\146\004\150\234\230\160\001\068\253\173\196\194\003\098\004\195\213\220\188\165\123\081\001\121\166\034\055\212\066\170\152\107\204\065\131\067\000\169\029\067\003\098\004\195\020\230\216\157\130\212\079\034\127\226\085\057\018\043\229\109\204\065\131\067\253\173\196\194\003\098\004\195\205\141\054\021\177\051\097\012\098\243\164\116\094\029\201\152\230\160\001\068\000\169\029\067\003\098\004\195\224\240\052\102\044\071\220\008\155\193\200\130\202\194\230\109\107\049\005\067\018\029\022\065\023\226\175\194\125\205\248\225\212\203\162\153\126\172\148\013\046\247\045\094\241\180\016\068\045\016\138\195\012\071\159\194\095\056\174\094\126\029\214\087\032\250\048\254\068\042\184\050\241\180\016\068\022\008\005\196\012\071\159\194\235\054\250\152\080\143\082\192\071\221\154\092\225\107\157\248\226\105\161\067\022\008\005\196\012\071\159\194\073\199\047\008\232\138\110\179\081\135\095\064\242\090\145\088\226\105\161\067\045\016\138\195\012\071\159\194\022\113\016\011\206\077\084\118\066\211\062\179\080\194\113\212\042\182\005\194\173\089\124\193\052\166\071\194\203\172\045\222\220\182\192\195\197\061\080\076\004\165\101\089\114\142\253\066\051\182\085\195\250\236\066\194\182\074\095\176\158\067\227\034\235\241\227\220\072\081\152\047\030\161\028\068\009\097\147\195\012\138\053\194\038\167\085\129\022\133\254\207\064\185\244\242\034\004\251\120\030\161\028\068\132\176\009\196\012\138\053\194\053\252\195\251\249\057\111\053\135\103\180\106\028\077\126\085\077\134\049\195\015\120\251\194\155\187\205\193\235\112\245\186\026\117\102\165\128\209\165\072\023\025\224\181\076\233\077\195\227\094\039\195\021\198\172\193\048\134\028\044\042\006\048\220\118\031\217\145\237\249\231\201\199\166\070\195\213\053\105\195\235\213\123\193\112\247\106\245\073\065\195\044\078\000\066\173\088\175\133\230\125\236\066\195\017\193\159\195\152\239\204\064\235\063\054\081\157\143\161\195\206\062\012\022\159\215\210\152\053\251\080\194\033\065\186\195\046\255\045\066\019\164\148\092\141\030\015\076\205\148\073\167\048\055\093\223\230\038\252\194\168\063\188\195\022\188\084\066",
	["Razorfen Downs"] = "\202\122\065\211\024\116\145\241\226\167\240\024\025\145\233\095\038\128\131\195\253\188\009\067\107\222\162\194\063\154\163\184\004\128\217\170\012\245\026\200\156\055\010\087\191\009\224\192\253\188\009\067\107\222\162\194\000\025\109\119\026\212\053\046\144\253\212\120\095\048\082\186\038\128\131\195\063\111\034\068\107\222\162\194\159\223\131\234\120\110\054\003\244\039\249\151\134\131\186\245\038\128\131\195\126\222\196\067\107\222\162\194\016\063\008\080\245\124\002\023\013\219\101\190\200\247\053\125\191\009\224\192\126\222\196\067\107\222\162\194\123\196\214\123\197\136\244\238\168\213\244\134\167\132\253\110\191\009\224\192\063\111\034\068\107\222\162\194\062\144\173\023\164\255\091\016\038\217\165\023\108\226\074\246\168\140\141\195\135\090\022\068\218\097\155\194\169\038\010\057\127\239\217\003\129\169\216\251\171\001\143\243\168\140\141\195\015\181\172\067\218\097\155\194\038\163\111\109\172\117\028\091\247\145\011\131\145\030\103\120\143\202\216\193\135\090\022\068\218\097\155\194\066\220\036\160\060\016\178\004\114\220\117\222\014\107\241\140\242\028\073\066\252\084\251\067\114\046\150\194\020\226\225\160\187\013\207\230\140\190\079\171\231\090\146\166\242\028\073\066\248\169\118\067\114\046\150\194\136\113\211\144\023\035\115\138\182\145\102\236\121\188\148\202\155\142\038\195\144\223\028\068\033\199\133\194\178\062\014\000\210\060\009\163\085\214\048\203\151\212\105\077\155\142\038\195\144\223\092\068\033\199\133\194\070\164\075\062\245\053\017\203\072\111\071\145\105\167\089\179\131\219\222\194\011\252\067\068\062\188\079\194\052\149\168\239\083\241\076\106\183\127\179\173\236\161\012\093\224\182\183\195\011\252\067\068\062\188\079\194\156\123\142\176\025\173\230\064\052\122\107\023\217\189\041\059\126\093\165\195\230\180\077\068\205\137\024\194\060\031\250\095\144\098\237\032\069\012\225\224\149\024\227\080\126\093\165\195\230\180\013\068\205\137\024\194\102\162\219\144\211\112\023\192\072\000\052\126\065\179\110\084\135\142\215\195\245\051\130\067\138\190\251\193\125\152\100\073\207\128\180\130\207\110\184\111\132\133\162\077\045\207\124\195\051\151\109\068\059\101\243\193\192\177\143\000\002\172\051\105\221\203\024\063\031\191\209\225\127\052\076\064\051\151\109\068\059\101\243\193\001\136\082\236\009\224\062\030\022\189\133\023\022\191\095\178\071\227\212\195\219\173\217\067\006\243\241\193\010\043\221\153\235\212\114\218\080\195\070\177\125\000\161\067\064\101\227\195\009\103\084\068\131\215\241\193\111\188\181\015\145\102\140\138\254\125\003\126\173\216\182\230\002\088\218\195\139\048\058\067\106\213\232\193",
	["Razorfen Kraul"] = "\200\081\067\070\008\019\097\155\080\151\214\067\043\124\241\213\082\090\223\067\128\141\028\194\076\214\164\194\177\149\207\025\074\076\014\129\221\226\159\082\209\157\224\041\041\173\047\068\128\141\028\194\076\214\164\194\199\050\002\206\023\142\012\167\031\224\066\205\106\252\206\178\041\173\047\068\159\220\088\067\076\214\164\194\137\023\103\195\211\092\040\054\199\197\054\107\110\011\242\192\082\090\223\067\159\220\088\067\076\214\164\194\145\031\100\115\221\239\224\170\099\205\156\166\194\151\157\217\141\210\178\067\127\107\229\066\190\160\154\194\057\064\129\171\146\061\254\033\196\246\113\099\195\094\199\097\141\210\178\067\063\074\013\195\190\160\154\194\212\195\096\116\160\091\088\198\184\168\198\254\120\022\175\077\059\235\219\067\143\034\248\066\104\100\144\194\142\052\121\162\160\166\083\214\027\229\033\069\177\250\071\000\145\066\153\067\133\217\082\195\022\107\142\194\139\172\223\022\108\139\251\078\122\173\139\088\193\186\214\178\133\048\022\068\044\081\158\194\206\184\139\194\036\109\194\080\151\210\215\128\132\088\082\154\209\095\056\128\182\136\050\068\052\066\224\066\197\131\127\194\174\244\041\172\049\019\080\011\244\196\185\064\244\021\076\186\061\071\118\067\218\238\121\194\167\012\125\194\075\179\024\234\145\238\019\184\169\145\187\022\041\199\124\146\219\157\167\067\016\126\095\195\007\200\121\194\217\122\055\196\013\199\024\011\136\011\186\110\058\068\002\114\109\119\158\066\016\126\095\195\007\200\121\194\210\085\129\254\119\045\013\243\087\104\145\075\109\110\003\232\118\051\022\068\055\116\074\067\083\048\116\194\179\074\043\135\119\147\071\073\033\047\022\056\146\185\056\246\227\099\049\068\177\141\092\067\208\252\111\194\191\052\176\157\139\209\203\226\244\055\241\090\160\177\064\199\077\058\023\068\255\114\216\067\146\081\097\194\181\217\111\129\219\103\038\057\237\024\196\240\059\116\243\147\134\251\013\068\149\103\248\194\155\092\089\194\030\160\071\115\240\022\253\020\070\196\235\251\104\120\006\115\252\153\181\194\015\010\159\195\088\089\072\194\158\070\150\235\212\101\167\242\180\206\120\121\008\190\030\129\252\153\181\194\007\133\015\196\088\089\072\194\151\063\223\107\021\134\067\244\083\071\168\251\184\000\245\194\063\172\141\194\186\137\111\195\017\190\063\194\085\105\023\198\022\147\019\111\125\239\057\149\205\094\158\240\072\080\010\066\085\186\014\196\076\000\045\194\076\180\218\046\019\060\060\140\064\091\234\214\171\045\001\242\050\003\003\067\071\167\003\196\231\035\041\194\157\033\093\255\118\042\029\146\083\180\255\130\005\238\128\122\023\110\035\068\196\120\020\067\020\018\012\194\222\093\196\073\012\144\015\234\253\072\152\221\049\248\142\140\013\206\152\067\103\106\202\195\185\164\205\193\060\044\087\033\132\008\161\216\103\147\111\220\129\158\141\018\173\247\114\067\182\001\137\195\031\115\188\193\241\112\189\143\155\195\146\124\100\057\211\154\104\211\001\210\024\089\182\066\079\011\164\195\222\121\177\193\132\208\169\043\130\063\166\152\140\100\141\028\183\061\033\105\025\239\047\067\185\111\158\195\153\031\148\193\166\136\002\083\046\189\080\100\027\194\103\154\013\215\150\080\023\217\079\194\095\235\249\194\246\007\144\193\172\190\044\064\072\055\242\087\090\198\097\024\227\033\091\038\172\088\009\067\063\198\081\194\047\006\141\193\186\049\190\021\159\215\247\173\006\097\229\168\110\204\208\182\085\173\179\194\204\224\122\194\104\160\071\193",
	["Ruins of Ahn'Qiraj"] = "\052\089\231\066\186\082\009\200\228\242\174\183\044\128\069\205\255\255\215\069\255\255\059\198\000\000\000\000\253\229\219\107\114\076\128\096\198\104\142\201\199\255\214\141\255\255\215\069\255\255\063\198\000\000\000\000\111\179\176\123\106\205\007\035\012\125\204\092\208\060\056\125\255\255\215\069\255\255\067\198\000\000\000\000\071\198\049\191\113\032\094\018\252\187\238\168\132\104\050\206\255\255\215\069\255\255\071\198\000\000\000\000\241\129\058\044\158\088\118\246\142\037\075\109\251\100\076\039\255\255\223\069\255\255\059\198\000\000\000\000\161\069\131\065\118\221\120\112\039\034\207\114\198\043\102\083\255\255\223\069\255\255\063\198\000\000\000\000\007\172\223\022\168\192\033\214\241\225\094\246\157\057\213\113\255\255\223\069\255\255\067\198\000\000\000\000\250\085\114\065\135\184\185\001\213\253\166\118\240\030\105\218\255\255\223\069\255\255\071\198\000\000\000\000\077\232\042\158\043\233\072\176\247\212\190\196\010\045\228\216\255\255\231\069\255\255\059\198\000\000\000\000\248\164\210\252\004\214\203\126\141\251\220\124\116\028\209\162\255\255\231\069\255\255\063\198\000\000\000\000\189\223\003\107\140\205\140\145\242\196\039\178\108\114\219\203\255\255\231\069\255\255\067\198\000\000\000\000\247\115\244\102\162\123\199\106\034\104\062\167\215\032\199\220\255\255\231\069\255\255\071\198\000\000\000\000",
	["Scholomance"] = "\015\101\159\249\232\168\141\146\172\046\003\121\197\190\105\222\026\113\210\194\068\143\125\067\054\165\026\195\096\116\255\060\157\166\057\132\007\126\120\164\232\134\082\052\068\210\129\195\048\229\054\067\177\038\023\195\223\070\074\051\135\123\101\056\012\031\236\072\036\131\127\170\084\250\009\194\122\086\034\067\056\177\022\195\078\247\052\194\132\249\152\169\163\033\073\079\087\089\210\149\117\049\008\195\181\040\023\067\252\059\017\195\243\222\093\148\144\073\005\235\183\078\034\161\044\178\121\098\158\085\206\066\133\173\188\194\033\079\001\195\236\232\049\040\057\035\011\007\063\118\213\248\125\026\147\016\099\247\037\067\129\095\254\194\058\060\001\195\058\143\141\247\064\120\188\114\092\243\125\239\168\125\238\175\022\208\137\195\011\109\043\067\026\195\253\194\068\094\063\023\102\129\028\050\148\220\072\100\032\119\074\195\017\070\233\194\077\115\134\067\021\195\253\194\078\156\237\126\230\134\213\017\234\025\192\000\063\236\230\026\067\156\147\193\171\001\057\067\006\163\253\194\087\212\079\033\078\053\226\210\097\022\147\184\203\032\207\224\169\027\179\194\016\208\189\066\209\153\237\194\004\026\181\213\081\176\231\068\093\173\006\135\100\066\002\085\069\222\071\194\044\004\070\195\252\168\224\194\243\102\151\169\019\027\240\237\246\127\145\233\028\070\248\250\199\153\091\195\049\181\066\195\078\066\209\194\008\104\054\216\129\020\092\103\168\049\023\168\151\094\055\041\051\173\145\195\117\226\021\195\032\024\209\194\161\235\237\212\066\184\071\136\020\242\096\240\117\243\179\165\167\045\123\194\228\011\018\194\094\187\203\194\116\149\244\238\223\085\220\096\224\198\108\229\008\077\250\055\148\155\179\195\142\070\042\065\221\076\186\194\177\055\060\214\207\038\034\202\253\065\174\124\226\026\085\027\207\191\053\195\221\093\018\195\220\104\175\194\046\122\089\215\120\255\231\019\207\033\184\251\002\158\108\180\043\119\147\195\192\063\119\194\061\140\154\194\054\161\032\224\113\176\220\230\125\126\175\215\170\072\101\093\157\180\140\195\088\122\252\194\011\211\153\194\093\206\243\078\048\216\187\115\240\118\099\034\205\246\079\226\055\226\082\195\221\021\171\066\097\134\132\194\252\226\194\119\147\079\115\002\094\069\030\049\111\151\152\229\159\214\251\194\192\115\069\194\229\175\032\194\105\052\071\013\022\196\136\059\217\230\141\188\234\243\203\199\038\021\135\194\174\069\081\194\202\035\120\192",
	["Serpentshrine Cavern"] = "\111\241\195\066\176\184\038\034\186\021\124\100\147\007\200\235\089\136\020\196\080\236\003\068\230\220\141\195\109\030\113\235\046\146\186\077\174\188\245\065\178\086\073\156\207\066\164\194\003\020\123\065\230\220\141\195\189\016\164\093\128\193\142\129\071\154\155\059\184\201\175\160\179\016\169\195\040\246\193\068\230\220\141\195\070\237\065\193\092\212\089\029\218\117\158\212\073\219\081\061\179\016\169\195\040\246\161\068\230\220\141\195\144\039\058\202\098\144\058\243\043\063\176\202\025\168\006\214\207\066\164\194\160\216\135\067\230\220\141\195\149\118\234\206\138\001\054\058\079\154\201\193\056\024\145\208\207\066\164\194\080\236\067\068\230\220\141\195\135\164\211\054\176\111\042\198\099\046\125\057\098\154\153\210\207\066\164\194\080\236\003\068\230\220\141\195\023\036\036\040\060\137\048\093\027\128\048\166\013\171\164\155\207\066\164\194\040\246\129\068\230\220\141\195\008\056\153\068\210\168\119\207\209\125\213\253\252\182\244\248\179\016\169\195\040\246\129\068\230\220\141\195\187\108\210\116\198\038\159\209\249\162\120\133\032\111\128\125\179\016\169\195\080\236\003\068\230\220\141\195\086\108\074\187\095\198\144\029\025\163\085\168\044\143\003\213\089\136\020\196\040\246\129\068\230\220\141\195\129\251\120\045\140\031\206\046\224\161\175\166\179\055\116\094\089\136\020\196\080\236\067\068\230\220\141\195\137\218\159\160\113\036\072\198\192\037\247\245\081\057\249\049\179\016\169\195\080\236\067\068\230\220\141\195\177\091\127\108\134\060\041\116\064\118\128\125\104\212\128\011\089\136\020\196\040\246\161\068\230\220\141\195\193\211\152\129\212\189\154\062\112\045\121\127\077\041\003\083\179\016\169\195\160\216\135\067\230\220\141\195\110\053\105\195\163\054\073\231\209\015\086\131\064\236\082\053\179\016\169\195\003\020\123\065\230\220\141\195\229\035\153\160\089\178\067\069\031\079\201\063\046\139\216\194\089\136\020\196\160\216\135\067\230\220\141\195\184\005\235\089\074\159\152\253\132\245\197\228\194\204\108\226\207\066\164\194\040\246\161\068\230\220\141\195\137\107\189\025\213\092\032\016\155\224\233\223\173\068\200\115\151\222\045\067\003\020\123\065\230\220\141\195\096\146\076\232\121\015\169\177\116\032\115\210\146\049\133\008\075\239\214\067\040\246\129\068\230\220\141\195\029\018\194\186\229\048\211\142\193\203\027\157\255\177\189\137\075\239\214\067\080\236\067\068\230\220\141\195\167\251\089\029\021\014\185\162\015\057\108\060\030\251\241\254\075\239\214\067\080\236\003\068\230\220\141\195\243\253\099\044\148\105\177\039\038\129\175\192\109\136\218\160\075\239\214\067\040\246\161\068\230\220\141\195\094\200\192\030\228\012\140\069\092\189\055\189\023\105\194\047\165\119\043\068\080\236\067\068\230\220\141\195\034\178\076\090\234\098\061\249\015\213\033\085\037\204\122\249\165\119\043\068\080\236\003\068\230\220\141\195\069\040\235\196\042\140\225\086\231\213\186\187\131\015\071\103\207\066\164\194\040\246\193\068\230\220\141\195\141\244\188\081\082\119\190\023\145\173\195\214\209\000\046\172\075\239\214\067\160\216\135\067\230\220\141\195\120\242\049\025\081\066\094\229\116\216\136\255\177\152\137\053\151\222\045\067\040\246\193\068\230\220\141\195\013\202\139\211\121\113\117\026\205\122\121\215\151\025\175\243\151\222\045\067\080\236\003\068\230\220\141\195\065\247\200\209\236\019\014\183\101\154\018\153\164\204\000\121\151\222\045\067\160\216\135\067\230\220\141\195\210\074\102\051\064\141\088\157\109\047\248\081\233\026\092\119\075\239\214\067\003\020\123\065\230\220\141\195\022\069\112\184\138\017\158\037\118\190\050\205\188\199\106\017\151\222\045\067\080\236\067\068\230\220\141\195\098\204\214\060\155\161\164\133\218\137\043\104\101\093\224\170\151\222\045\067\040\246\161\068\230\220\141\195\228\104\094\195\004\204\202\131\209\018\079\206\034\117\206\193\151\222\045\067\040\246\129\068\230\220\141\195\026\089\168\040\080\034\164\031\243\105\156\246\174\252\040\046\165\119\043\068\040\246\129\068\230\220\141\195\059\092\157\091\227\200\166\017\140\096\189\075\037\019\168\116\067\025\036\195\141\048\056\194\035\079\014\195\156\182\099\173\118\153\144\026\177\084\068\048\194\099\139\084\209\062\010\195\249\213\002\069\056\101\251\194\176\077\031\143\129\132\172\116\107\099\122\137\019\109\143\216\209\062\010\195\242\171\229\068\056\101\251\194\038\156\057\053\183\112\150\068\011\019\251\109\074\185\166\170\091\130\235\066\242\171\197\068\056\101\251\194\123\048\066\112\156\204\148\098\071\078\244\250\025\050\151\189\091\130\235\066\242\171\229\068\056\101\251\194\190\082\108\248\085\087\126\051\067\156\138\136\139\015\132\008\209\062\010\195\242\171\197\068\056\101\251\194\159\211\244\176\190\208\030\161\136\079\032\209\230\168\073\026\104\031\197\195\242\171\229\068\056\101\251\194\090\131\180\048\142\011\149\164\143\202\087\120\116\098\123\186\104\031\197\195\249\213\002\069\056\101\251\194\235\219\187\222\236\054\102\034\246\004\057\208\229\039\184\144\104\031\197\195\242\171\197\068\056\101\251\194\253\030\046\235\163\051\092\091\084\253\201\012\216\068\206\238\091\130\235\066\249\213\002\069\056\101\251\194\109\054\195\146\062\030\125\077\035\077\231\088\172\013\039\191\216\151\039\196\061\028\165\068\026\176\224\193\188\150\107\189\248\098\184\109\114\121\036\152\065\000\051\232\216\151\103\196\061\028\165\068\026\176\224\193\063\219\081\047\230\119\061\236\116\094\162\102\039\149\208\164\218\073\128\196\198\242\065\068\074\091\223\193\138\171\067\141\122\004\109\005\103\242\213\157\131\184\068\037\066\038\024\196\133\174\160\068\051\088\211\193\006\167\138\208\136\170\158\179\120\083\061\210\099\095\184\066\039\092\094\196\099\007\135\068\004\250\210\193\031\034\041\153\085\090\248\232\144\190\019\183\098\090\244\099\039\092\094\196\198\014\078\068\004\250\210\193\056\093\193\072\060\102\009\227\193\171\170\211\137\167\036\194\019\046\143\196\099\007\135\068\004\250\210\193\097\068\079\035\145\125\127\182\212\084\013\171\177\132\193\239\019\046\143\196\198\014\078\068\004\250\210\193\066\131\111\235\183\202\034\241\122\063\023\016\197\146\176\107\242\120\143\196\178\145\150\068\168\129\101\193\253\234\228\096\254\158\210\058\131\028\136\023\102\141\237\008\242\120\143\196\178\145\182\068\168\129\101\193\141\247\100\083\048\043\048\077\243\145\142\013\023\120\058\081\212\022\057\196\087\137\235\067\165\113\204\189\127\181\055\098\251\145\035\025\174\200\133\228\117\111\063\239\206\138\096\196\040\069\082\068\159\019\133\065\149\195\045\222\229\074\176\109\037\058\067\216\047\117\123\132\187\070\017\196\170\116\136\068\155\133\012\066\043\055\020\005\027\046\188\118\239\012\076\053\220\014\117\033\187\070\017\196\085\233\080\068\155\133\012\066\079\233\209\015\066\021\052\026\003\007\088\138\052\049\050\245\187\070\081\196\085\233\016\068\155\133\012\066\011\240\058\142\074\229\075\049\080\111\138\182\176\000\095\106\187\070\081\196\170\116\136\068\155\133\012\066\169\078\187\228\103\252\063\065\025\077\255\122\076\243\021\113\187\070\081\196\085\233\080\068\155\133\012\066\244\181\192\179\114\188\043\199\214\097\050\134\079\204\250\107\187\070\017\196\085\233\016\068\155\133\012\066\006\113\039\183\009\074\003\135\071\160\213\139\058\244\069\083\233\036\075\195\061\167\102\195\038\086\197\068\226\054\185\105\187\215\056\179\159\203\099\147\160\047\113\051\087\108\083\066\015\198\202\065\038\086\197\068\226\111\136\081\122\013\220\029\003\026\052\210\087\025\046\113\138\109\154\067\015\198\202\065\038\086\197\068\120\226\011\059\093\171\203\035\224\021\015\159\119\103\199\001\087\108\083\066\061\167\102\195\038\086\197\068\229\012\185\135\173\091\100\243\015\180\107\116\239\135\087\151\138\109\154\067\061\167\102\195\038\086\197\068\040\173\248\162\149\146\100\000\065\178\102\232\253\168\145\037\233\036\075\195\015\198\202\065\038\086\197\068",
	["Sethekk Halls"] = "\178\186\076\162\254\031\118\118\021\027\019\231\087\229\242\166\167\157\142\194\114\246\195\195\235\213\212\192\188\210\231\129\244\240\201\100\138\051\148\103\204\048\242\155\105\167\163\195\114\246\195\195\235\213\212\192\210\017\050\014\163\247\114\076\029\060\153\179\237\116\092\068\167\157\142\194\229\236\007\195\235\213\212\192\186\032\019\016\033\171\115\194\176\016\113\008\055\203\037\025\105\167\163\195\229\236\007\195\235\213\212\192\253\131\135\048\198\240\174\134\022\017\215\209\135\101\060\141\000\196\202\067\039\147\217\195\252\193\098\192\246\071\044\236\240\029\122\015\063\149\234\007\154\106\054\224\202\143\141\066\223\002\136\195\166\191\054\192\188\116\145\206\248\233\233\203\228\066\168\205\074\231\202\076\029\140\135\065\147\253\183\193\051\052\234\191\226\067\056\108\191\250\043\006\246\118\114\250\237\140\194\111\008\092\089\067\246\051\229\195\117\110\231\191\130\059\113\254\060\118\227\049\106\127\010\197\170\113\049\030\075\221\219\194\117\063\248\194\064\223\066\189\154\157\058\113\252\161\234\117\101\010\015\216\227\179\151\190\002\070\237\066\212\246\184\195\211\230\048\189\208\116\127\192\182\121\212\018\221\110\203\167\214\121\141\136\179\016\070\065\081\056\096\195\009\178\040\189\099\072\006\113\019\225\215\148\137\180\003\153\032\197\081\129\218\053\225\194\051\092\164\195\217\152\038\189\066\198\077\124\250\023\222\156\249\023\219\201\124\019\035\200\078\095\179\067\210\247\184\195\239\116\011\189\191\240\177\019\219\092\183\098\110\011\089\120\211\092\059\246\218\053\225\194\090\009\199\195\109\243\161\061\188\058\071\078\220\016\168\159\210\179\101\165\051\241\200\148\146\140\128\194\169\234\250\195\127\094\056\066\023\046\135\145\198\083\202\018\154\006\007\146\125\042\129\165\182\185\063\067\084\117\061\196\127\094\056\066\120\061\171\225\210\061\049\184\247\243\208\200\167\234\051\068\146\140\128\194\084\117\061\196\127\094\056\066\159\115\172\222\050\096\251\146\228\061\081\132\048\129\149\019\182\185\063\067\169\234\250\195\127\094\056\066\240\006\090\044\057\062\104\179\047\185\193\040\246\198\091\198\138\207\156\067\179\155\054\196\134\174\058\066\065\030\199\137\121\209\103\017\043\199\136\162\198\161\240\163\182\036\057\195\091\066\039\196\015\224\071\066\010\003\118\028\250\128\159\218\081\125\182\027\231\001\101\226\074\054\225\194\077\039\231\195\210\128\085\066\136\000\028\025\036\168\167\096\124\058\049\089\231\185\074\055\170\210\230\067\097\178\002\196\187\143\085\066\176\103\059\170\104\165\029\034\184\021\117\246\011\168\151\165\119\044\136\067\227\039\021\196\022\159\085\066\047\199\008\013\136\046\073\055\136\090\163\125\104\095\108\124\088\239\168\065\051\039\021\196\025\159\085\066",
	["Shadow Labyrinth"] = "\229\181\102\130\097\205\211\205\173\242\215\207\181\199\111\162\043\168\157\064\142\119\035\067\232\234\135\193\232\168\029\197\240\179\009\169\198\227\026\172\177\160\144\227\043\168\157\064\225\016\185\194\232\234\135\193\016\107\227\013\009\156\142\255\119\040\190\089\052\068\212\079\100\237\033\195\222\128\202\194\125\055\131\192\251\001\159\038\123\085\059\158\046\004\187\014\203\049\027\195\026\168\203\066\019\042\079\067\021\249\019\192\032\216\095\122\231\086\081\136\012\148\065\238\231\202\097\164\044\216\226\066\037\093\020\195\079\221\186\062\199\253\255\139\024\133\169\121\246\013\060\018\143\208\081\155\173\092\111\067\024\042\079\067\016\218\218\064\224\134\165\138\048\244\103\211\214\245\202\021\204\146\150\065\101\110\070\067\090\161\121\067\019\218\218\064\001\167\235\135\032\211\171\030\129\028\049\001\144\169\228\195\068\116\111\067\049\093\020\195\211\222\218\064\065\064\134\053\126\185\247\032\164\078\222\244\081\247\113\132\252\133\070\067\061\151\028\195\213\222\218\064\235\042\010\130\000\174\168\176\012\019\236\164\090\146\201\196\216\172\103\067\026\135\071\067\230\199\224\064\194\033\158\205\072\153\250\240\021\198\244\013\011\086\089\081\216\172\103\067\150\227\097\194\230\199\224\064\029\246\250\059\046\170\168\164\206\018\177\133\177\008\144\184\105\205\041\068\095\136\229\066\232\199\224\064\145\214\108\095\144\114\148\249\189\097\200\206\173\051\253\145\105\205\041\068\207\059\013\195\232\199\224\064\200\009\165\163\164\071\179\212\067\117\183\110\041\132\112\045\211\154\211\067\207\059\013\195\232\199\224\064\033\116\231\132\180\030\101\053\051\156\067\241\046\064\248\031\211\154\211\067\095\136\229\066\232\199\224\064\100\135\226\216\144\158\214\085\118\234\167\140\137\088\225\104\203\045\198\067\034\077\092\066\091\180\128\065\203\001\128\096\187\226\061\000\254\139\140\173\051\114\064\239\176\175\035\068\153\114\004\067\152\019\144\065\039\133\233\124\243\075\231\213\052\209\098\117\196\034\155\126\176\175\099\068\076\057\194\067\152\019\144\065\121\228\180\181\248\101\169\162\038\036\034\099\016\122\219\197\176\175\099\068\153\114\004\067\152\019\144\065\091\243\195\114\195\128\153\083\114\237\190\047\218\046\254\125\176\175\035\068\076\057\194\067\152\019\144\065\127\025\053\143\052\013\145\179\135\053\021\223\037\174\182\150\189\164\044\068\155\096\217\067\081\053\181\065\128\196\002\090\034\026\037\065\053\089\071\235\055\169\089\236\123\073\217\067\155\096\217\067\081\053\181\065\203\230\160\120\039\036\099\104\002\055\039\000\217\012\147\127\115\070\062\068\241\072\092\066\095\133\202\065\147\145\001\046\211\014\142\042\176\132\119\237\202\026\004\250\117\070\062\068\081\151\201\067\120\133\202\065\216\118\224\030\213\024\133\044\213\246\062\099\127\249\170\225\043\175\074\067\193\053\093\068\067\016\252\065\161\212\211\008\230\235\107\115\046\243\189\160\131\081\040\111\043\175\074\067\193\053\029\068\067\016\252\065\033\161\087\191\156\209\112\115\004\205\122\056\084\042\180\176\144\012\145\067\231\045\252\067\183\112\008\066",
	["Shadowfang Keep"] = "\021\124\027\044\255\070\032\061\152\157\107\130\236\053\245\179\069\104\187\195\072\228\103\195\249\154\154\192\068\081\180\184\109\018\176\248\127\010\154\196\107\098\011\060\045\115\180\195\049\188\202\194\195\115\151\192\188\126\006\043\239\164\131\209\132\188\005\199\083\051\076\227\154\123\159\195\012\150\163\193\195\203\028\192\236\126\162\052\206\018\123\231\255\199\079\227\107\220\009\136\249\034\022\195\142\011\143\194\205\055\134\191\029\019\247\059\095\037\024\106\134\097\063\107\252\089\125\174\135\034\082\194\006\236\215\065\028\181\122\191\045\125\033\225\007\191\148\188\029\143\063\097\050\186\104\124\245\122\034\194\025\011\141\065\056\039\116\191\004\156\022\225\082\219\033\053\113\159\234\076\166\057\057\040\077\190\175\195\206\127\164\194\013\037\171\062\086\198\213\179\225\253\216\135\178\209\039\250\050\107\027\005\025\035\152\195\065\068\243\194\152\013\152\064\234\235\112\044\142\112\119\153\206\190\092\247\135\136\190\150\060\253\248\194\157\200\254\064\017\105\234\064\212\179\210\092\208\151\239\211\090\055\085\170\075\167\051\024\090\080\169\194\008\181\139\194\199\118\240\064\199\098\192\233\140\196\144\154\037\052\045\062\068\075\177\210\066\207\184\195\080\013\128\195\109\142\255\064\165\196\239\083\144\048\174\095\227\053\046\014\253\201\005\026\194\001\227\194\069\060\130\194\212\062\154\065\125\067\165\014\202\248\198\099\047\068\235\009\094\217\167\099\133\034\082\194\095\046\210\065\022\027\163\065\018\224\058\038\189\029\051\062\129\236\219\162\004\034\131\202\059\013\000\195\025\014\128\194\106\047\197\065\232\021\034\181\187\218\197\073\084\053\186\177\074\230\130\138\164\099\179\195\190\252\138\195\218\225\211\065\106\139\055\087\112\160\178\017\225\131\227\174\078\123\225\131\186\116\168\195\185\252\138\195\077\237\211\065\013\155\070\076\197\072\220\130\232\083\183\047\145\100\053\036\097\068\192\195\185\252\138\195\085\237\211\065\132\005\116\175\005\144\115\107\251\184\072\215\183\041\069\161\191\001\227\194\037\188\181\193\030\010\212\065\230\122\012\071\131\174\108\043\081\175\068\165\126\082\238\200\191\001\227\194\157\005\000\194\178\033\212\065\154\143\186\109\111\026\200\136\019\068\017\164\035\177\065\056\193\099\179\195\209\084\125\194\089\104\212\065\063\189\083\049\068\253\007\112\060\124\085\198\000\015\110\067\123\068\192\195\062\081\125\194\149\114\212\065\131\228\249\204\081\216\018\079\003\177\111\019\228\043\014\242\241\201\133\195\128\240\220\194\047\090\001\066\087\107\253\159\137\040\165\069\059\037\202\233\043\089\202\032\001\139\127\195\248\169\239\194\052\100\001\066\201\230\052\049\163\108\220\241\079\160\013\029\087\137\191\157\184\088\125\195\062\088\199\194\165\102\001\066\165\127\003\048\069\160\122\021\097\055\128\147\115\245\041\113\241\070\125\195\054\093\121\066\137\101\005\066\168\072\156\210\014\050\234\095\205\052\126\136\226\085\122\029\224\207\070\195\193\219\076\066\022\104\005\066\016\065\187\231\188\092\026\044\127\036\248\252\061\192\141\077\034\188\087\195\198\125\052\066\137\049\008\066\135\013\139\134\206\231\086\091\003\105\204\052\064\152\035\008\233\027\218\195\219\172\040\195\105\124\010\066\230\123\190\137\115\055\108\106\203\182\122\177\173\229\057\145\022\134\149\194\052\241\212\194\174\165\019\066\246\022\174\168\151\243\076\063\090\141\190\254\124\022\017\111\056\197\209\195\234\060\106\195\129\229\019\066\104\084\054\041\040\022\093\128\178\024\051\076\008\148\157\239\244\133\157\195\085\061\106\195\104\001\020\066\049\218\173\106\206\177\197\157\013\081\255\167\188\092\005\047\246\133\157\195\119\095\084\195\104\001\020\066\075\087\127\182\226\030\048\215\000\029\215\151\024\190\036\089\201\133\157\195\248\252\138\195\104\001\020\066\007\104\166\077\111\177\204\235\135\167\204\254\113\085\010\231\040\051\203\195\097\013\128\195\104\001\020\066\122\219\024\121\146\026\095\203\151\220\099\053\057\143\087\084\244\133\157\195\151\013\128\195\104\001\020\066\128\160\240\018\096\197\031\136\000\107\004\090\215\067\168\125\050\051\203\195\195\252\138\195\104\001\020\066\098\100\155\082\052\038\238\148\056\236\164\023\212\102\223\036\059\134\157\195\157\129\062\195\112\001\020\066\209\173\247\208\245\001\145\146\071\048\128\129\015\177\079\064\094\051\203\195\049\099\170\194\010\068\020\066\154\127\234\240\065\134\082\011\045\163\159\208\083\055\150\135\093\051\203\195\248\078\125\194\010\068\020\066\135\143\051\042\162\015\140\061\027\067\173\126\012\051\209\020\094\051\203\195\232\030\214\194\011\068\020\066\089\250\252\098\035\072\252\117\041\221\096\045\022\073\139\073\137\115\138\194\086\229\193\194\236\040\023\066\167\174\027\012\159\026\222\062\249\251\065\068\084\226\222\143\034\188\087\195\122\153\225\065\136\049\024\066\022\098\117\042\074\160\224\221\145\074\041\031\044\214\050\107\015\114\126\195\140\125\008\195\176\158\028\066\123\193\087\010\049\255\029\200\180\248\162\206\079\191\226\018\146\058\070\195\122\153\225\065\134\049\032\066\081\064\182\167\122\013\134\022\114\078\174\097\136\143\193\108\077\135\241\193\243\239\154\194\224\077\053\066\160\007\008\178\222\109\221\099\067\066\227\243\025\217\198\127\245\013\201\194\097\062\158\194\237\077\053\066\120\022\047\043\253\014\036\103\167\115\011\077\098\074\197\168\099\035\191\193\211\194\031\194\159\081\053\066\062\086\117\107\065\097\249\153\143\127\172\192\198\237\253\184\186\202\157\195\228\216\029\195\070\186\059\066\240\248\250\090\119\055\173\186\185\071\207\117\250\110\045\174\153\204\147\195\005\249\054\195\002\001\060\066\128\000\239\211\156\203\005\136\025\155\221\166\116\114\098\052\252\140\154\195\089\163\040\195\226\046\060\066\228\074\131\248\036\223\130\183\080\122\097\113\244\154\034\012\232\200\167\195\230\184\004\195\157\050\060\066\160\051\212\246\103\096\092\087\006\237\028\220\214\136\240\087\255\205\129\195\106\161\012\195\100\063\060\066\181\243\013\191\105\218\016\137\101\105\039\139\122\034\221\134\070\148\097\195\199\146\034\066\008\030\127\066\192\033\091\082\237\057\039\117\083\024\037\020\253\134\076\107\113\018\099\195\201\121\141\065\004\143\137\066\090\114\067\009\131\245\039\028\208\050\035\217\227\175\228\046\028\159\085\195\102\136\129\065\004\143\147\066\215\080\200\152\080\094\239\246\199\231\176\229\160\104\169\189\114\018\099\195\165\218\012\066\003\143\162\066\136\100\108\027\246\184\087\217\124\056\017\004\087\169\214\179\114\018\099\195\098\136\129\065\089\228\180\066\123\060\004\088\204\191\220\004\072\135\204\220\147\059\183\205\202\195\088\195\015\035\237\065\003\143\197\066\178\098\151\173\021\042\152\128\038\196\127\213\082\241\205\242\131\249\120\195\235\225\119\066\079\089\202\066\149\034\089\085\140\032\088\050\032\154\128\034\169\146\245\075\069\084\118\195\124\155\016\067\194\079\206\066\044\033\145\009\068\018\040\069\157\173\033\069\241\147\113\026\232\093\136\195\111\004\251\066\066\029\214\066\058\176\139\192\239\237\150\045\177\192\226\236\034\248\067\096\214\168\139\195\156\254\173\066\188\234\221\066\048\179\056\186\000\141\130\018\133\122\164\107\075\105\137\209\081\046\138\195\040\038\099\066\154\171\231\066\183\242\014\049\188\082\174\075\044\055\061\084\049\222\159\001\189\105\126\195\003\254\052\066\022\121\239\066\114\134\044\055\155\119\008\205\185\047\076\095\030\151\140\113\069\084\118\195\124\155\016\067\029\083\245\066\195\219\087\145\122\130\167\011\181\160\109\106\115\010\089\080\232\093\136\195\109\004\251\066\052\235\254\066\197\111\011\108\135\177\197\049\146\129\172\120\051\206\100\248\213\168\139\195\157\254\173\066\003\007\005\067\026\250\223\005\068\055\235\076\105\025\025\253\094\165\255\111\077\075\117\195\092\130\041\067\252\027\007\067\023\055\008\159\244\154\230\077\119\009\012\206\186\160\170\014\080\046\138\195\042\038\099\066\052\019\012\067\065\117\024\156\110\230\019\013\192\073\085\240\182\026\112\171\188\105\126\195\008\254\052\066\045\206\017\067\164\215\092\081\239\185\227\013\011\211\133\040\100\136\209\036\189\095\116\195\237\225\119\066\121\020\021\067",
	["Stratholme"] = "\230\243\254\199\119\077\098\064\081\218\117\161\183\055\231\003\234\069\137\196\147\108\187\067\206\210\052\195\028\139\063\101\100\072\030\205\218\065\072\233\233\148\057\001\234\069\169\196\093\170\220\067\206\210\052\195\068\054\160\186\162\218\059\189\060\141\175\002\086\114\129\045\234\069\169\196\073\182\029\068\206\210\052\195\010\139\032\038\049\008\115\213\034\040\122\234\041\019\201\118\234\069\169\196\093\170\220\067\206\210\052\195\047\221\134\114\088\229\016\098\215\110\006\226\244\170\132\058\234\069\169\196\147\108\187\067\206\210\052\195\052\182\133\209\153\053\005\073\124\157\165\053\225\069\185\083\187\159\085\196\181\240\166\067\140\182\035\195\028\244\188\144\221\215\124\222\224\115\202\098\162\156\129\136\221\207\138\196\215\194\155\066\140\182\035\195\246\155\193\138\114\053\097\067\177\077\114\112\021\070\203\057\221\207\138\196\181\240\166\067\140\182\035\195\244\186\004\092\135\218\047\213\140\242\255\193\114\059\141\068\028\087\123\196\221\090\199\066\140\182\035\195\077\089\026\082\227\153\109\112\192\059\063\163\199\230\232\026\081\248\101\196\221\090\199\066\140\182\035\195\225\183\244\064\149\211\196\124\143\159\160\101\195\013\093\093\187\159\085\196\215\194\155\066\140\182\035\195\041\103\147\229\142\042\010\099\173\127\165\130\182\066\131\123\059\195\105\196\049\075\022\068\071\243\027\195\070\204\233\079\162\064\002\145\204\045\170\195\048\193\155\115\059\195\105\196\049\075\022\068\071\243\027\195\135\156\144\118\045\072\234\009\156\125\028\136\120\195\006\171\065\127\138\196\229\045\217\067\071\243\027\195\248\218\108\210\190\006\000\164\076\204\191\230\124\187\187\135\131\254\084\196\229\045\217\067\071\243\027\195\110\229\174\200\240\166\182\050\009\020\225\013\152\102\047\082\131\254\084\196\242\150\044\068\071\243\027\195\125\074\008\056\128\042\033\067\138\224\015\044\195\220\198\173\065\127\138\196\242\150\044\068\071\243\027\195\141\051\165\206\181\016\061\126\129\191\196\132\236\235\049\181\052\223\143\196\109\107\083\195\005\161\027\195\088\237\033\154\018\065\250\122\011\079\238\147\149\137\142\132\105\190\095\196\182\181\233\195\005\161\027\195\140\098\153\029\005\108\188\229\245\174\161\194\028\248\182\136\105\190\031\196\182\181\233\195\005\161\027\195\216\100\220\217\112\227\113\058\119\084\163\172\192\150\250\057\052\223\143\196\182\181\233\195\005\161\027\195\004\126\007\165\069\205\252\142\127\021\130\253\187\197\165\150\105\190\095\196\109\107\083\195\005\161\027\195\037\031\090\033\180\254\230\067\178\212\174\115\133\146\157\185\041\195\171\196\006\153\134\194\151\067\242\194\034\217\251\056\148\151\035\049\231\176\192\066\181\128\086\003\041\195\171\196\006\153\134\194\151\067\242\194\065\084\244\223\021\026\179\239\197\117\186\076\226\246\211\120\041\195\171\196\006\153\134\194\151\067\242\194\172\004\253\090\080\211\034\140\084\213\153\163\168\045\009\009\041\195\171\196\006\153\134\194\151\067\242\194\147\084\024\244\003\202\090\238\204\255\056\135\097\251\136\101\041\195\139\196\158\029\221\194\151\067\242\194\194\161\222\162\092\040\104\219\145\106\005\129\061\089\050\148\041\195\171\196\158\029\221\194\151\067\242\194\105\254\167\131\205\108\149\122\041\191\099\089\242\057\011\248\105\190\095\196\223\194\155\194\201\147\222\194\041\219\140\134\024\029\018\013\011\142\117\152\052\085\185\148\052\223\143\196\060\007\141\194\201\147\222\194\170\130\199\021\139\229\089\215\011\018\068\193\170\244\217\046\052\223\143\196\186\047\124\194\201\147\222\194\076\038\190\034\153\156\068\116\105\088\128\101\048\028\063\149\052\223\143\196\223\194\155\194\201\147\222\194\038\047\025\054\000\185\045\174\180\108\223\207\106\155\054\071\052\223\143\196\181\156\252\194\201\147\222\194\009\014\180\204\135\066\034\241\248\170\017\080\061\230\058\176\105\190\095\196\181\156\252\194\201\147\222\194\056\181\076\197\221\178\172\203\128\205\052\145\175\057\200\086\052\223\143\196\193\087\095\194\201\147\222\194\077\170\249\163\073\238\238\087\136\029\227\165\072\036\175\022\216\033\143\196\036\143\082\195\017\100\212\194\164\068\182\098\098\128\187\035\208\120\212\071\197\078\157\049\216\033\175\196\036\143\082\195\017\100\212\194\063\252\123\085\110\143\156\195\011\212\146\123\052\055\102\211\216\033\175\196\107\195\053\066\017\100\212\194\194\114\167\144\251\151\162\027\213\142\238\100\064\205\092\093\216\033\143\196\107\195\053\066\017\100\212\194\223\116\186\056\060\090\236\050\208\058\179\042\150\213\219\160\071\115\017\195\233\204\156\194\248\134\205\194\024\128\180\020\035\026\073\187\236\201\239\017\148\192\171\087\111\025\221\066\233\204\156\194\248\134\205\194\216\035\007\054\195\166\127\204\046\231\043\004\017\145\254\131\253\025\166\196\037\232\077\067\233\050\177\194\157\152\211\149\155\203\024\067\100\069\066\194\049\220\025\126\069\136\159\196\091\091\088\067\233\050\177\194\185\143\065\180\002\144\054\235\124\097\156\208\160\159\246\021\069\136\159\196\068\052\071\067\233\050\177\194\198\092\040\158\085\192\015\016\058\061\151\104\072\056\029\050\139\016\127\196\091\091\088\067\233\050\177\194\145\212\139\140\144\075\199\042\200\200\184\045\227\055\135\137\131\198\019\196\222\152\029\196\211\069\176\194\097\177\045\166\239\255\109\214\004\115\179\186\242\068\110\162\191\193\164\195\153\177\129\195\211\069\176\194\239\157\066\097\176\089\152\141\132\251\236\146\191\103\238\226\078\039\019\196\121\229\144\195\211\069\176\194\051\152\033\185\223\235\015\231\235\011\151\130\076\098\171\123\078\039\019\196\188\114\008\196\211\069\176\194\199\091\117\128\025\147\168\103\084\167\176\004\081\112\142\152\223\096\018\196\153\177\129\195\211\069\176\194\242\016\142\117\033\197\246\028\119\206\078\031\171\147\056\223\131\198\019\196\189\049\187\195\211\069\176\194\056\194\113\098\249\142\254\194\009\144\152\024\141\250\160\024\007\141\167\195\222\152\029\196\211\069\176\194\006\089\116\119\046\127\186\224\050\103\090\054\241\167\120\131\171\239\197\195\059\108\165\195\211\069\176\194\143\224\038\002\137\099\150\159\142\046\052\148\019\089\090\021\213\247\034\196\059\108\165\195\211\069\176\194\212\255\227\189\120\181\066\172\211\084\064\065\244\161\058\124\007\141\167\195\189\049\187\195\211\069\176\194\074\237\085\081\170\091\009\023\233\114\009\139\226\009\063\035\157\033\155\195\191\162\168\192\137\221\174\194\206\236\022\084\098\248\048\106\046\190\241\083\076\015\141\027\157\033\155\195\162\094\036\195\137\221\174\194\121\130\095\126\159\244\216\004\120\150\019\233\167\212\116\138\206\144\013\196\162\094\036\195\137\221\174\194\213\060\129\083\031\172\196\011\105\232\089\001\114\149\196\233\138\038\253\195\065\065\135\195\137\221\174\194\141\216\036\105\042\123\051\102\159\107\185\137\145\037\157\196\206\144\013\196\162\094\036\195\137\221\174\194\233\061\228\021\136\101\148\168\173\109\083\046\028\077\073\013\206\144\013\196\138\162\130\195\137\221\174\194\141\064\231\203\013\033\140\020\062\184\221\255\058\226\133\007\157\033\155\195\138\162\130\195\137\221\174\194\089\103\083\056\231\172\239\149\068\098\155\036\148\153\218\042\119\252\052\194\138\162\130\195\075\181\171\194\249\167\159\104\244\095\242\197\177\164\070\038\099\154\047\074\142\159\150\195\138\162\130\195\075\181\171\194\084\178\131\053\158\187\080\247\158\249\184\230\117\206\121\226\119\252\052\194\191\162\168\192\075\181\171\194\252\239\108\252\069\124\175\225\121\232\166\123\240\251\081\022\142\159\150\195\191\162\168\192\075\181\171\194\090\112\208\100\010\061\092\182\027\226\198\097\161\156\041\037\194\147\236\195\190\023\006\196\071\145\170\194\069\213\081\043\232\048\084\157\003\218\160\005\247\068\229\069\026\155\001\196\082\141\248\195\071\145\170\194\147\005\040\087\240\123\243\075\210\059\044\164\129\107\152\224\100\038\030\196\101\204\003\195\132\065\162\194\081\121\179\026\113\128\115\060\153\001\119\162\243\016\170\013\245\097\183\195\055\039\150\066\132\065\162\194\117\002\231\172\026\226\092\087\001\192\164\004\061\246\059\198\201\076\188\195\101\204\003\195\132\065\162\194\121\087\114\045\105\096\192\180\079\008\174\084\030\228\058\241\021\048\030\196\171\246\081\066\132\065\162\194\216\047\151\071\081\232\084\187\058\021\188\211\214\176\104\238\007\252\035\196\222\170\085\066\132\065\162\194\222\084\023\096\099\245\121\085\237\147\156\002\193\008\225\079\250\176\027\196\205\137\165\067\132\065\162\194\187\142\102\083\159\160\243\000\253\186\139\147\142\214\135\048\250\176\027\196\055\039\150\066\132\065\162\194\183\162\057\135\230\107\199\053\233\002\008\167\126\062\146\099\245\097\183\195\205\137\165\067\132\065\162\194\210\189\143\062\023\216\124\144\223\063\125\251\137\126\208\254\021\048\030\196\032\041\130\066\132\065\162\194\083\192\041\207\164\232\166\207\137\085\186\233\036\205\174\156\100\038\030\196\051\103\248\066\132\065\162\194\097\133\163\034\030\141\183\005\036\130\039\244\133\170\201\213\221\207\138\196\116\076\029\067\025\088\153\194\245\058\253\190\158\055\225\252\105\096\007\084\105\163\182\120\221\207\138\196\080\061\135\067\025\088\153\194\217\048\097\187\158\164\210\065\106\065\205\242\073\180\218\044\248\030\147\196\173\074\141\067\025\088\153\194\178\229\017\130\055\137\103\167\157\125\002\205\171\244\137\094\241\061\102\196\173\074\141\067\025\088\153\194\255\094\222\121\011\095\014\250\077\246\033\066\041\183\035\252\071\115\017\195\233\204\156\194\062\112\149\194\197\089\159\006\225\207\247\121\234\102\135\059\212\011\219\163\131\254\020\196\083\232\138\067\108\127\135\194\117\230\053\048\050\152\074\067\195\121\181\091\116\193\084\032\065\127\138\196\015\228\220\067\108\127\135\194\031\147\026\211\088\207\044\017\088\030\243\236\039\159\008\064\131\254\084\196\041\116\005\068\108\127\135\194\204\015\203\250\051\112\246\078\154\131\049\014\060\044\070\058\065\127\138\196\083\232\138\067\108\127\135\194\240\218\042\046\088\242\058\201\088\055\163\064\130\025\129\044\131\254\084\196\083\232\138\067\108\127\135\194\249\209\237\057\103\227\126\000\180\249\175\060\022\062\153\158\065\127\138\196\028\007\194\067\108\127\135\194\021\246\253\247\031\120\167\168\056\199\054\155\123\034\007\027\163\170\234\195\029\005\178\066\104\152\131\194\018\236\248\188\191\119\212\161\042\004\149\075\224\032\118\101\071\085\085\195\029\005\178\066\104\152\131\194\216\117\155\206\127\027\098\064\183\216\147\223\209\179\079\108\071\085\085\195\224\188\182\066\104\152\131\194\228\069\044\138\023\157\191\103\241\008\162\049\183\050\225\246\163\170\234\195\224\188\182\066\104\152\131\194\059\035\008\012\237\045\015\023\135\015\075\071\145\126\243\183\205\236\255\195\215\206\177\067\003\101\093\194\195\080\219\059\248\194\036\060\129\172\208\170\114\107\195\191\163\045\186\195\252\206\018\068\003\101\093\194\049\132\058\154\166\234\216\089\176\162\112\042\172\138\153\003\205\236\255\195\251\001\077\067\003\101\093\194\009\068\108\180\089\078\014\148\066\180\174\225\153\000\125\090\209\022\029\196\249\157\165\067\003\101\093\194\161\074\080\155\130\225\119\224\124\081\214\045\230\239\076\037\209\022\029\196\252\206\018\068\003\101\093\194\015\142\119\187\231\162\153\049\226\063\011\064\087\101\210\054\163\045\186\195\249\157\165\067\003\101\093\194\187\060\029\102\182\124\125\131\011\074\082\111\091\196\049\111\017\227\177\195\029\005\178\066\119\013\090\194\195\211\176\191\051\210\238\032\101\068\206\127\133\233\130\092\071\140\199\194\029\005\178\066\119\013\090\194\192\118\134\054\013\198\073\037\163\081\025\164\103\217\241\123\017\227\177\195\029\005\178\066\119\013\090\194\227\034\117\143\218\222\129\147\090\080\073\066\041\206\241\120\219\064\128\196\183\225\076\065\111\184\069\194\072\198\041\069\074\084\197\076\200\122\218\046\049\089\199\033\253\252\115\196\136\221\118\065\128\179\069\194\220\081\071\080\020\172\048\142\171\218\100\067\005\017\197\061\213\026\233\195\120\108\225\067\088\159\064\194\187\105\169\087\211\186\201\135\247\010\065\009\071\062\190\087\213\026\233\195\120\108\225\067\088\159\064\194\030\227\152\040\090\126\047\098\228\066\208\088\209\089\054\202\213\026\233\195\120\108\225\067\088\159\064\194\020\175\166\023\089\000\012\088\068\113\089\231\042\075\047\020\022\070\096\196\196\010\028\067\113\074\064\194\004\176\127\149\242\162\175\179\032\135\061\051\166\076\129\118\034\054\015\196\084\084\198\067\199\087\056\194\171\005\068\015\173\079\163\173\063\214\090\075\135\163\243\102\173\234\164\195\060\008\198\195\211\039\047\194\185\188\097\111\197\209\074\046\202\162\155\087\102\235\166\078\033\215\046\196\144\122\031\193\112\127\046\194\224\200\231\021\098\204\065\254\091\187\141\197\140\125\011\133\230\233\144\195\136\181\097\196\093\009\036\194\014\199\113\197\184\215\044\208\005\013\237\067\239\169\199\177\021\190\083\196\170\207\182\067\126\142\033\194\180\000\004\145\125\029\153\101\048\158\217\150\112\252\246\055\092\055\109\195\073\176\047\196\247\160\028\194\169\150\151\196\208\161\065\006\083\178\214\112\112\206\107\112\174\076\065\196\249\139\202\067\246\087\013\194\211\129\096\238\162\213\201\108\064\228\145\116\040\028\162\238\174\076\065\196\183\239\129\067\246\087\013\194\030\084\212\096\171\013\007\195\016\072\184\218\094\092\223\098\174\076\065\196\030\228\195\067\246\087\013\194\013\044\165\210\204\206\105\230\082\061\071\169\169\067\223\064\030\186\137\196\048\152\252\067\081\136\215\193\082\231\215\078\048\216\062\124\242\078\191\177\044\241\145\231\155\067\207\195\213\131\029\196\106\089\165\193\082\108\093\184\023\121\157\211\175\232\098\184\238\129\006\039\206\016\204\195\061\220\013\196\106\089\165\193\064\085\090\193\253\216\043\030\025\217\004\045\051\001\123\077\147\184\217\195\086\023\018\196\106\089\165\193\187\041\034\111\087\015\019\063\074\107\148\226\169\227\045\202\040\026\136\195\080\239\038\196\054\066\151\193\015\177\137\197\222\048\120\128\000\217\081\038\086\121\188\153\119\058\087\195\016\233\030\196\054\066\151\193\135\096\134\123\246\122\058\020\218\016\059\249\084\098\094\044\003\057\112\195\032\219\033\196\054\066\151\193\210\121\153\174\018\204\100\161\044\219\211\061\020\109\051\012\101\082\006\195\191\151\031\196\053\066\151\193\103\029\225\144\251\094\215\038\100\236\238\228\021\164\174\044\059\070\031\195\055\246\035\196\053\066\151\193\113\193\007\216\099\008\215\246\063\213\206\148\052\183\021\037\192\001\064\195\215\041\041\196\053\066\151\193\187\149\191\071\032\157\007\249\131\248\083\002\111\251\125\171\025\185\218\194\049\057\027\196\053\066\151\193\147\237\158\238\112\152\183\075\065\105\123\059\024\085\142\223\054\063\186\194\048\234\038\196\245\212\150\193\015\031\212\147\108\038\071\061\110\145\142\138\249\135\249\054\104\190\159\195\069\138\033\196\079\002\140\193\210\047\196\214\124\208\189\130\232\173\239\036\089\090\085\243\149\238\176\195\049\101\004\196\028\247\139\193\136\038\106\077\246\238\237\115\050\136\180\046\206\132\107\042\184\235\247\194\241\163\018\196\056\237\139\193\055\041\033\174\033\161\197\051\108\000\177\026\128\117\050\174\104\139\154\064\206\118\045\196\132\069\125\193\037\173\172\182\196\165\168\220\120\154\192\063\098\197\186\170\038\067\137\194\138\032\020\196\196\191\123\193\120\081\020\178\071\114\145\127\002\105\040\169\050\197\144\177\034\214\001\194\141\203\013\196\193\191\123\193\241\238\030\098\197\052\254\066\026\139\043\002\043\006\169\189\088\091\156\195\119\127\005\068\056\228\067\193\145\250\118\080\190\241\254\191\247\139\110\239\098\135\132\120\148\117\095\196\069\214\051\068\046\253\009\193\011\110\011\106\087\118\023\116\213\053\069\025\176\129\152\123\003\045\154\196\046\058\011\068\031\126\152\065",
	["Sunwell Plateau"] = "\193\193\052\153\158\078\055\025\028\252\078\049\248\057\052\178\086\207\070\195\069\133\080\195\195\186\152\195\065\223\016\123\005\057\198\136\183\231\147\052\255\124\209\103\233\070\081\196\224\012\139\195\173\181\014\195\142\238\145\186\145\024\069\013\224\186\008\118\120\079\076\181\233\070\081\196\015\206\176\193\173\181\014\195\062\211\220\026\255\233\114\082\197\142\097\220\033\187\244\244\102\246\018\195\146\040\166\195\197\051\077\194\025\072\255\139\015\133\054\013\014\115\080\107\075\181\152\086\102\246\018\195\064\078\180\195\191\051\077\194\188\060\097\055\125\205\201\056\007\027\155\092\065\099\221\029\209\158\035\196\223\172\057\195\252\125\132\193\175\248\058\233\148\082\219\148\039\132\128\217\003\110\175\147\209\158\035\196\111\214\220\195\252\125\132\193\082\038\207\035\205\107\157\002\143\238\105\001\248\250\150\239\209\158\099\196\223\172\057\195\252\125\132\193\135\081\042\123\207\034\023\189\183\023\069\138\171\189\152\135\209\158\099\196\111\214\220\195\252\125\132\193\104\173\185\147\099\048\003\073\049\196\077\102\247\096\232\226\020\097\075\196\063\154\228\195\018\145\102\193\063\255\238\209\039\058\240\191\251\005\206\024\047\119\183\129\013\004\069\196\153\127\131\066\154\019\104\065\140\073\033\015\089\147\014\238\154\185\211\169\109\131\241\156\148\151\004\196\248\252\183\194\161\158\204\065\107\071\253\015\021\097\188\099\204\214\006\120\210\200\255\148\099\247\128\196\102\027\062\195\200\031\178\066",
	["The Arcatraz"] = "\017\052\139\151\097\151\248\236\144\101\205\027\143\071\044\186\107\250\033\196\060\098\006\195\150\143\233\196\028\001\087\153\149\229\147\087\210\228\172\134\065\195\022\181\006\106\035\196\156\234\012\195\105\217\211\195\070\033\237\100\225\119\167\202\217\020\013\016\095\022\061\086\007\106\035\196\156\234\012\195\138\224\044\195\185\018\170\094\022\159\231\188\000\241\204\104\193\016\227\176\103\200\225\195\017\085\075\195\243\045\237\194\182\006\041\230\219\091\198\224\048\004\149\135\058\251\137\170\222\166\042\196\250\124\007\067\189\052\028\194\207\251\228\136\171\237\008\051\177\038\070\184\004\174\225\136\189\077\213\195\250\124\007\067\189\052\028\194\084\027\114\098\001\028\199\151\115\179\200\103\079\101\081\098\222\166\042\196\125\190\195\067\189\052\028\194\070\049\200\191\084\103\094\253\168\005\070\154\194\136\248\229\189\077\213\195\125\190\195\067\189\052\028\194\037\017\235\136\037\194\157\099\138\047\031\066\251\210\252\076\212\248\244\195\218\142\161\194\050\238\014\194\109\080\081\249\135\036\097\248\116\087\255\123\192\089\166\028\123\087\213\195\075\047\019\067\170\246\207\193\002\188\226\042\071\098\050\207\221\112\080\196\222\067\226\194\203\200\158\195\045\236\161\193\131\246\207\193\090\018\158\094\244\163\156\200\247\245\214\062\196\021\153\050\079\161\240\195\013\101\062\195\216\008\199\193\072\215\083\183\016\005\250\158\102\237\103\130\027\217\039\081\079\161\240\195\227\053\131\066\216\008\199\193\148\093\047\178\132\208\152\171\174\135\218\027\238\193\156\199\167\080\056\196\227\053\131\066\216\008\199\193\013\064\005\216\123\194\221\213\246\251\141\111\055\109\060\199\167\080\056\196\013\101\062\195\216\008\199\193\085\126\154\123\017\206\247\063\003\248\093\191\175\016\051\043\255\177\078\194\232\101\018\195\219\165\178\193\173\214\200\083\154\040\018\165\053\236\151\187\082\075\058\069\063\214\153\195\232\101\018\195\219\165\178\193\131\167\200\234\095\127\089\180\023\120\011\168\128\026\221\164\063\214\153\195\045\052\219\066\219\165\178\193\131\039\061\147\181\030\032\185\014\119\178\014\098\062\074\144\232\020\129\194\062\016\170\194\136\118\198\192\223\006\079\209\203\129\180\121\104\005\229\208\010\027\181\078\012\030\043\196\105\192\188\195\013\094\231\065\023\250\212\024\061\251\042\094\028\252\134\036\137\149\172\157\010\015\011\196\204\246\135\066\207\203\027\066\099\142\151\104\214\160\060\168\214\205\252\073\049\126\025\029\031\130\235\195\197\228\098\195\045\147\031\066\087\161\249\069\170\015\183\061\102\240\001\125\143\115\192\189\063\004\087\195\098\114\241\195\045\147\031\066\062\118\077\155\054\079\081\142\220\091\085\190\123\167\102\132\063\004\087\195\197\228\098\195\045\147\031\066\242\019\021\148\125\040\146\078\064\174\120\151\170\159\117\126\031\130\235\195\098\114\241\195\045\147\031\066\076\102\207\099\064\065\154\134\191\034\170\018\091\133\140\255\048\067\027\196\173\032\077\195\033\147\049\066\128\003\238\144\195\224\060\232\012\107\224\071\071\239\115\008\104\150\246\195\022\216\155\195\128\249\049\066\105\227\096\058\184\036\225\251\041\099\112\033\185\091\118\076\233\084\208\195\234\072\109\195\168\249\049\066\012\167\164\128\060\150\045\250\177\101\008\154\142\003\220\255\014\194\135\196\193\155\202\066\167\184\144\066\033\102\099\083\198\105\040\131\029\218\121\220\001\201\078\143\014\194\135\196\240\166\178\067\167\184\144\066\124\058\222\121\179\027\194\200\053\032\087\139\196\030\116\009\029\132\079\196\240\166\178\067\167\184\144\066\002\161\170\160\116\146\081\003\213\015\178\254\237\127\058\153\029\132\079\196\193\155\202\066\167\184\144\066\214\084\160\204\233\128\077\250\044\213\003\209\255\166\121\022\170\225\115\196\126\081\249\194\078\203\161\066\208\173\150\095\116\158\069\183\084\187\192\014\042\183\006\132\159\201\072\196\204\108\127\194\023\181\177\066\095\176\208\075\149\163\233\138\213\057\041\085\072\019\168\065\212\182\223\195\060\036\173\194\071\189\192\066",
	["The Black Morass"] = "\065\054\206\162\013\139\205\225\250\086\085\155\216\105\020\023\255\255\135\069\255\255\007\198\000\000\000\000\085\169\214\105\164\225\042\117\034\109\038\094\112\016\063\248\255\255\135\069\255\255\011\198\000\000\000\000\052\102\163\016\027\033\084\177\161\008\227\105\132\120\010\082\255\255\135\069\255\255\015\198\000\000\000\000\200\077\088\223\124\052\030\158\146\077\092\077\147\018\218\151\255\255\143\069\255\255\007\198\000\000\000\000\042\206\156\007\050\027\221\204\048\168\071\179\088\239\209\035\255\255\143\069\255\255\011\198\000\000\000\000\180\203\209\223\238\159\207\224\157\017\085\029\015\043\238\012\255\255\143\069\255\255\015\198\000\000\000\000\151\227\127\215\062\245\082\003\007\199\151\006\136\001\040\171\255\255\151\069\255\255\007\198\000\000\000\000\012\226\088\219\033\205\216\010\023\129\071\005\017\116\084\029\255\255\151\069\255\255\011\198\000\000\000\000\203\147\104\007\088\115\214\080\096\016\013\104\100\012\034\254\255\255\151\069\255\255\015\198\000\000\000\000",
	["The Blood Furnace"] = "\203\086\229\051\174\167\130\235\236\101\078\079\247\105\151\081\143\073\000\196\138\023\194\066\096\027\141\195\213\130\162\222\054\247\018\253\015\231\206\133\007\012\061\101\206\138\028\196\100\031\039\067\012\056\139\195\131\195\056\162\094\138\009\220\243\095\086\031\164\173\206\170\206\138\092\196\100\031\039\067\012\056\139\195\158\239\246\203\010\185\085\077\046\017\101\123\211\055\210\024\206\138\028\196\054\193\177\194\012\056\139\195\159\066\059\046\017\154\011\206\161\011\038\095\089\080\247\154\206\138\092\196\054\193\177\194\012\056\139\195\014\100\146\135\118\067\077\178\222\235\214\129\218\197\070\221\206\138\092\196\178\143\211\067\012\056\139\195\013\062\242\002\045\093\003\007\015\036\079\187\253\101\087\142\176\072\138\196\088\029\229\066\069\011\015\195\203\019\240\141\008\076\092\073\175\180\063\190\176\152\047\096\050\090\239\195\172\217\096\067\056\026\236\194\090\247\163\219\084\227\216\224\246\097\191\213\049\190\183\034\101\180\094\195\172\217\096\067\056\026\236\194\140\064\015\249\163\065\220\185\164\128\147\213\246\076\092\099\250\111\191\195\207\113\067\194\118\134\179\194\176\240\050\077\036\001\053\122\066\190\083\117\039\245\184\080\250\111\191\195\139\035\079\067\118\134\179\194\093\068\019\001\033\170\115\243\252\046\152\172\244\040\017\177\235\191\253\194\207\113\067\194\118\134\179\194\064\102\172\025\052\047\056\093\040\054\030\133\001\048\148\207\235\191\253\194\139\035\079\067\118\134\179\194\112\146\027\082\136\218\130\215\167\255\072\178\226\192\089\098\168\067\098\196\027\023\163\194\054\134\132\194\092\154\178\235\005\012\116\223\095\025\020\099\244\022\232\016\081\135\196\195\027\023\163\194\054\134\132\194\104\034\076\017\179\243\023\117\129\101\207\008\139\175\056\243\081\135\196\195\113\116\046\067\054\134\132\194\097\109\019\184\000\016\133\116\005\132\105\190\089\221\191\034\168\067\098\196\113\116\046\067\054\134\132\194\049\173\095\147\099\033\166\025\210\110\140\146\030\245\109\150\168\067\034\196\027\023\163\194\054\134\132\194\013\141\063\184\190\041\008\156\095\027\086\029\098\091\175\174\168\067\034\196\113\116\046\067\054\134\132\194\172\038\208\067\068\068\012\182\010\243\010\245\209\207\103\148\029\246\127\196\169\227\150\195\108\180\227\064\097\246\215\000\114\197\099\070\184\051\083\022\137\144\186\199\173\153\063\196\054\120\162\195\087\181\227\064\172\016\174\009\150\191\000\145\037\115\114\110\205\020\078\114\036\020\130\196\093\082\062\067\211\170\145\065\165\204\152\066\015\140\122\023\005\107\249\128\127\055\045\089\036\020\130\196\068\091\131\194\211\170\145\065\242\130\150\184\063\128\215\092\212\015\155\203\188\108\024\254\097\082\057\196\055\092\213\195\202\179\151\065\079\012\242\063\099\102\203\046\184\226\247\233\174\115\156\177\097\082\121\196\055\092\213\195\202\179\151\065",
	["The Botanica"] = "\102\177\095\062\032\035\053\131\066\168\004\061\186\147\087\000\235\061\228\066\103\211\067\196\054\205\022\196\009\234\009\097\217\226\129\250\104\014\166\077\248\006\113\006\235\061\228\066\179\233\129\196\054\205\022\196\030\162\234\250\194\100\156\220\226\028\043\104\181\100\072\033\132\240\198\195\179\233\129\196\054\205\022\196\100\147\128\210\069\146\171\145\130\082\068\231\153\253\170\106\132\240\198\195\103\211\067\196\054\205\022\196\153\246\111\061\031\128\106\024\195\180\235\021\002\020\027\149\009\225\013\195\179\233\129\196\054\205\022\196\062\042\146\115\142\243\201\157\208\196\187\002\244\089\154\119\009\225\013\195\103\211\067\196\054\205\022\196\044\091\166\010\170\073\168\206\186\029\084\125\093\109\111\244\069\193\206\194\215\081\222\195\009\102\066\195\053\108\218\077\107\060\150\117\204\228\064\107\071\183\027\054\069\193\206\194\235\040\047\196\009\102\066\195\217\218\033\032\191\077\159\182\239\222\002\112\151\133\014\117\092\159\024\067\235\040\047\196\009\102\066\195\202\034\025\237\170\029\233\023\061\116\204\044\089\113\150\066\027\168\013\195\185\166\019\067\246\208\078\194\014\058\234\050\127\060\096\158\089\224\098\155\173\078\106\010\027\168\013\195\139\178\216\194\246\208\078\194\044\053\122\122\247\153\195\213\091\248\027\004\064\092\220\216\027\168\013\195\162\044\182\195\246\208\078\194\172\176\052\030\066\080\217\225\237\096\231\233\001\030\016\016\199\175\228\066\139\178\216\194\246\208\078\194\026\047\171\255\077\166\221\253\240\051\017\235\123\198\146\024\126\188\160\067\037\010\159\196\136\177\073\194\148\183\187\056\218\030\248\018\116\239\021\005\151\041\019\156\126\188\160\067\075\020\062\196\136\177\073\194\056\045\214\166\221\027\255\026\182\005\201\208\022\126\008\194\126\188\160\067\075\020\126\196\136\177\073\194\015\067\229\153\012\205\015\016\113\111\087\070\067\254\166\194\251\241\130\066\075\020\126\196\136\177\073\194\094\086\244\010\236\166\217\077\192\234\077\117\088\139\237\089\251\241\130\066\075\020\062\196\136\177\073\194\246\027\051\158\041\076\086\153\160\218\183\059\165\084\082\193\001\135\062\195\075\020\126\196\136\177\073\194\045\052\078\070\086\148\100\177\104\233\094\151\187\044\188\151\251\241\130\066\037\010\159\196\136\177\073\194\134\045\197\217\063\024\220\127\069\239\200\184\101\012\131\063\001\135\062\195\037\010\159\196\136\177\073\194\030\097\144\069\152\120\167\156\114\086\043\168\199\119\252\160\197\208\071\195\228\235\133\196\217\243\043\194\148\213\106\191\045\007\130\242\242\108\186\116\203\018\180\226\098\232\227\195\228\235\133\196\217\243\043\194\053\013\122\085\016\225\136\228\198\172\033\218\169\204\020\083\098\232\227\195\201\215\075\196\217\243\043\194\038\160\072\184\086\045\146\012\136\230\191\105\236\022\204\204\197\208\071\195\002\109\014\196\192\243\043\194\138\215\005\097\206\029\106\165\142\103\064\167\002\133\081\112\098\232\227\195\002\109\014\196\192\243\043\194\142\073\034\244\125\229\003\162\240\040\074\009\165\115\121\013\197\208\071\195\002\109\078\196\192\243\043\194\005\116\166\037\047\048\164\029\098\182\243\169\213\201\041\118\098\232\227\195\002\109\078\196\192\243\043\194",
	["The Deadmines"] = "\026\112\014\170\158\169\021\040\199\216\136\167\078\013\104\156\143\118\022\194\179\224\003\195\182\242\059\194\167\147\090\111\017\242\108\041\000\132\162\092\163\227\146\184\040\195\056\065\059\081\171\194\136\091\015\194\106\189\199\032\049\212\235\171\227\240\122\249\251\229\053\013\024\239\082\066\186\109\238\194\153\186\012\194\036\252\036\134\107\099\133\219\219\107\112\085\176\119\157\180\207\160\218\066\085\250\130\194\203\176\214\193\156\202\116\001\108\215\250\081\136\069\232\003\016\167\002\194\045\066\135\066\072\015\184\065\154\189\169\193\048\037\158\001\007\204\001\209\120\182\154\089\223\107\182\027\252\142\173\195\066\138\037\195\116\025\146\065\051\241\156\175\133\056\055\222\189\101\150\247\097\020\086\055\134\127\126\066\189\063\120\067\086\199\002\066\153\186\039\071\129\075\192\025\088\068\051\137\140\137\200\217\197\144\152\067\191\061\243\066\231\086\007\066\071\253\199\017\215\022\164\192\013\124\159\019\158\119\229\141\095\245\252\066\177\144\114\067\125\176\007\066\128\201\152\012\094\046\157\167\196\070\140\143\205\105\184\141\123\238\092\067\058\230\090\067\127\216\014\066\116\113\186\034\202\038\160\060\064\211\049\150\026\125\136\220\207\129\124\067\035\151\201\066\017\244\014\066\133\224\087\233\165\005\232\240\124\018\094\034\250\176\214\220\058\206\088\067\127\006\204\193\126\055\022\066\036\097\060\029\119\044\171\115\060\237\004\021\190\231\178\131\095\013\181\066\083\237\043\067\120\093\028\066\143\130\056\127\048\240\097\184\112\008\160\191\190\224\152\213\020\037\197\067\075\196\225\194\002\213\034\066\042\184\017\072\007\061\128\181\140\118\161\087\170\144\090\120\086\094\135\067\081\132\044\066\080\055\045\066\003\022\196\179\125\136\138\007\190\196\093\052\031\116\223\206\165\145\176\067\209\038\019\066\129\103\046\066\136\048\081\231\136\031\232\251\116\186\057\246\248\031\021\172\020\108\135\067\138\253\003\193\191\128\051\066\048\020\220\133\232\011\026\146\168\070\110\081\126\250\147\126\008\250\238\067\186\149\099\195\020\120\056\066\213\180\201\139\189\009\179\245\115\171\032\018\153\043\088\124\173\204\016\068\173\039\063\195\186\151\062\066\034\084\205\137\053\246\054\114\131\030\165\110\121\046\141\044\122\072\229\067\077\081\167\065\208\133\067\066\206\199\069\067\136\090\083\216\201\016\068\089\155\145\072\195\018\047\000\068\169\048\147\195\152\084\073\066\155\099\082\204\127\062\122\166\046\118\110\121\075\082\039\204\163\047\241\067\111\021\113\193\217\077\081\066\248\080\085\140\219\050\014\057\128\079\068\168\175\103\222\055\103\047\237\067\060\185\015\195\156\215\082\066\158\087\023\239\134\042\172\119\090\135\180\160\169\232\005\047\136\045\196\067\009\075\172\195\105\231\130\066\190\117\154\000\189\200\159\214\079\114\202\132\193\135\002\036\113\246\200\067\012\238\148\195\105\231\130\066\054\244\232\040\233\007\204\021\184\027\079\079\215\225\166\074\213\035\004\068\161\175\075\195\251\049\144\066\214\076\121\150\156\083\037\190\165\057\140\074\052\018\049\015\064\091\170\067\015\005\131\195\149\034\165\066\252\159\132\105\191\042\031\186\124\047\031\098\069\069\157\054\186\190\151\067\021\164\082\195\098\063\167\066",
	["The Eye"] = "\117\168\166\042\245\121\045\051\075\022\199\206\020\204\028\069\118\135\035\196\047\002\112\065\022\080\049\195\159\040\199\157\021\134\018\041\093\126\161\255\238\165\251\255\118\135\035\196\220\255\112\195\022\080\049\195\214\025\231\251\127\019\200\004\199\052\033\040\008\146\208\066\118\135\099\196\047\002\112\065\022\080\049\195\027\018\022\213\047\234\157\170\068\156\241\125\209\119\192\046\118\135\099\196\220\255\112\195\022\080\049\195\199\248\241\120\051\232\067\013\147\179\051\066\215\048\014\229\013\240\001\196\181\142\165\194\170\022\079\193\216\013\212\208\048\141\118\197\249\207\129\189\066\098\019\025\027\224\131\195\181\142\165\194\170\022\079\193\042\183\168\191\067\145\196\232\110\187\116\180\096\211\248\234\255\006\248\192\181\142\165\194\170\022\079\193\042\136\014\027\182\193\235\033\095\005\067\163\096\164\113\166\016\082\139\196\079\109\060\068\047\071\231\065\111\234\162\092\020\089\206\055\236\106\009\046\066\081\215\214\033\164\086\196\158\218\248\067\047\071\231\065\109\128\137\178\221\077\064\255\143\095\227\195\014\037\093\083\033\164\086\196\079\109\060\068\047\071\231\065\235\183\231\007\186\211\039\137\088\157\227\069\139\017\156\046\016\082\139\196\158\218\248\067\047\071\231\065\028\135\110\096\089\063\121\031\250\223\222\151\119\227\247\145\045\055\140\196\010\187\055\196\165\077\232\065\227\132\224\121\189\013\030\208\215\188\215\186\240\029\033\162\045\055\140\196\010\187\119\196\165\077\232\065\019\153\108\034\135\235\012\012\066\255\242\084\203\230\040\110\091\110\088\196\010\187\119\196\165\077\232\065\113\105\104\194\069\048\006\147\110\129\180\163\153\116\138\016\091\110\088\196\010\187\055\196\165\077\232\065\084\243\115\219\128\145\211\084\247\180\198\126\020\242\222\120\052\239\137\196\069\173\174\067\162\166\000\066\167\013\050\059\143\226\071\206\152\189\219\034\092\199\176\160\105\222\083\196\023\181\186\066\162\166\000\066\155\147\071\252\148\236\207\145\199\205\038\183\253\100\050\102\052\239\137\196\023\181\186\066\162\166\000\066\208\024\032\047\004\090\155\128\228\064\037\197\059\081\108\015\049\239\137\196\181\241\155\195\173\166\000\066\132\101\028\161\098\107\246\214\205\006\083\254\111\189\046\157\049\239\137\196\218\248\013\196\173\166\000\066\081\158\103\038\092\099\165\202\233\077\190\000\015\153\035\224\099\222\083\196\181\241\155\195\173\166\000\066\098\201\097\013\003\010\111\080\218\173\076\204\118\024\169\246\164\110\170\196\154\036\169\066\166\227\085\066\216\224\068\154\247\012\071\079\083\008\139\050\011\018\253\084\164\110\138\196\154\036\169\066\166\227\085\066\031\043\231\133\005\115\009\131\162\066\225\115\203\061\045\032\161\110\170\196\059\031\156\195\176\227\085\066\168\204\233\125\085\148\023\214\209\010\008\144\144\100\143\249\161\110\138\196\059\031\156\195\176\227\085\066\053\236\142\213\047\132\053\081\048\168\244\016\094\083\111\180\109\190\187\196\046\105\036\195\017\134\182\066\144\146\207\241\037\052\242\027\052\226\029\145\065\221\131\014\109\190\187\196\161\045\183\066\017\134\182\066\196\024\154\144\189\095\237\078\152\157\170\187\067\240\041\195\109\190\219\196\046\105\036\195\017\134\182\066\121\115\198\170\017\108\039\253\108\188\136\141\101\073\140\233\109\190\219\196\161\045\183\066\017\134\182\066\084\022\134\160\074\197\085\057\114\206\069\209\200\245\205\127\109\190\155\196\046\105\036\195\017\134\182\066",
	["The Mechanar"] = "\177\216\207\231\136\035\043\018\069\194\037\030\129\185\040\205\189\123\011\196\247\043\083\195\018\019\066\194\144\249\043\099\230\039\186\238\038\183\155\040\142\084\015\123\123\247\150\195\247\043\083\195\018\019\066\194\019\055\222\065\085\041\089\095\008\000\224\101\194\165\017\110\189\123\011\196\003\106\150\067\018\019\066\194\224\068\192\232\000\194\232\017\160\187\191\198\191\238\086\155\189\123\011\196\031\080\051\066\018\019\066\194\183\231\157\148\161\040\152\088\060\040\218\128\178\126\238\005\123\247\150\195\031\080\051\066\018\019\066\194\102\133\244\208\069\177\241\154\187\051\080\089\018\056\131\021\123\247\150\195\003\106\150\067\018\019\066\194\020\032\158\184\196\080\150\180\083\028\169\230\050\038\008\218\151\081\194\195\144\154\205\195\190\244\059\194\066\107\014\117\077\055\032\020\046\201\215\248\027\133\186\046\052\223\134\066\060\189\136\194\019\000\048\193\013\167\145\076\035\100\143\171\033\173\137\211\134\060\044\169\246\092\224\194\173\039\179\194\082\098\015\193\009\097\253\168\083\110\058\149\201\128\249\117\032\034\002\012\136\205\004\196\005\064\239\194\198\107\112\192\231\214\069\128\187\228\207\242\230\086\087\150\185\172\227\035\174\234\158\194\059\074\012\195\084\149\099\189\002\202\200\188\005\000\058\216\181\191\164\200\163\204\135\248\163\234\158\194\202\085\163\066\198\145\099\189\198\006\025\007\214\102\247\136\075\249\087\046\121\009\086\078\046\253\195\194\254\215\000\195\255\135\138\062\242\118\088\031\097\175\108\065\229\040\189\073\105\213\093\055\109\253\195\194\001\095\206\066\011\136\138\062\096\045\050\014\075\088\048\007\242\026\115\074\163\048\129\213\058\254\046\196\255\219\131\066\158\045\066\065\015\082\235\066\151\053\056\239\068\008\009\193\146\086\237\021\058\254\046\196\255\017\062\195\158\045\066\065\051\181\119\099\091\188\214\004\098\158\076\000\236\218\044\139\141\123\028\195\037\196\183\195\043\037\047\066\225\186\186\197\176\149\018\119\161\167\029\023\063\013\148\192\038\175\005\196\134\122\206\065\165\103\082\066\021\112\075\047\065\154\172\003\252\013\182\214\235\205\224\172\095\251\147\195\179\044\102\195\154\195\082\066\110\211\119\251\028\125\096\006\100\230\191\031\232\156\103\161\092\194\008\196\135\165\070\195\045\251\059\067\230\221\059\015\068\036\060\249\046\253\239\099\054\169\171\220\185\132\145\195\059\173\156\067\045\251\059\067\245\130\251\045\046\026\076\048\172\242\123\172\011\242\063\191\185\132\145\195\135\165\070\195\045\251\059\067\248\163\026\091\188\124\032\207\089\235\152\187\254\217\209\093\092\194\008\196\059\173\156\067\045\251\059\067\038\020\053\129\228\116\131\245\062\162\189\119\098\004\078\240\092\194\008\196\223\105\101\066\045\251\059\067\011\222\214\219\233\007\217\075\126\191\105\131\004\124\097\110\185\132\145\195\223\105\101\066\045\251\059\067",
	["The Shattered Halls"] = "\251\249\069\181\011\028\114\154\049\046\062\105\017\250\141\171\047\142\229\195\235\038\228\195\214\161\197\194\112\042\077\249\058\058\128\103\150\195\199\181\169\118\221\219\096\147\139\195\189\171\009\196\198\002\189\194\004\219\252\108\009\209\055\237\232\019\235\135\221\129\031\009\033\015\218\195\115\141\027\196\019\229\048\194\254\088\244\142\143\142\060\121\152\235\116\034\217\236\140\179\151\200\164\195\108\100\244\065\178\128\004\194\253\059\163\057\107\224\133\145\051\143\226\027\026\209\236\247\075\100\018\196\108\100\244\065\178\128\004\194\050\136\031\066\006\006\105\051\047\227\185\143\036\152\217\117\075\100\018\196\070\070\143\067\178\128\004\194\211\073\123\182\083\124\003\096\172\160\182\254\144\151\219\013\053\016\089\195\139\009\168\195\255\097\247\193\119\086\211\110\183\086\244\225\174\085\236\173\145\017\046\123\053\016\089\195\197\004\020\196\255\097\247\193\254\245\250\018\191\063\142\084\179\217\223\236\166\250\192\045\162\105\058\066\239\145\132\063\205\218\225\193\155\035\202\070\156\110\065\023\142\212\232\215\008\004\042\225\218\220\046\195\099\169\161\194\034\013\212\193\227\070\185\237\066\094\199\179\229\119\157\142\164\187\229\126\148\105\018\196\195\018\039\196\066\008\212\193\213\124\111\137\088\111\239\196\008\164\066\189\198\000\228\179\099\181\096\196\203\116\149\195\154\240\186\193\231\215\104\128\026\092\173\108\096\240\223\093\223\050\038\089\177\090\144\196\101\186\010\196\154\240\186\193\142\090\142\247\211\148\175\003\203\219\094\046\176\244\097\217\177\090\144\196\203\116\149\195\154\240\186\193\179\133\060\236\090\022\201\096\058\010\162\182\066\055\053\115\064\161\090\196\024\124\125\195\006\190\129\193\071\122\142\111\144\018\144\102\111\204\142\066\093\018\124\186\064\161\090\196\191\249\032\064\006\190\129\193\216\245\232\237\209\252\030\202\125\168\141\182\165\030\224\014\064\161\026\196\024\124\125\195\006\190\129\193\051\037\213\032\200\115\236\011\042\198\103\151\003\163\031\060\064\161\026\196\191\249\032\064\006\190\129\193\100\193\112\002\223\010\205\225\217\167\203\058\203\048\107\008\053\057\082\196\117\224\047\196\100\149\036\191\227\177\171\076\061\096\201\215\213\048\068\127\144\224\120\088\154\028\137\196\117\224\047\196\100\149\036\191",
	["The Slave Pens"] = "\083\130\166\079\092\104\111\062\238\213\049\246\243\174\040\048\197\025\232\067\001\002\108\068\193\036\246\194\076\082\220\063\055\247\101\039\147\187\201\066\211\053\108\141\207\049\063\194\001\002\108\068\193\036\246\194\217\135\193\133\119\055\084\195\059\252\183\055\236\198\246\151\207\049\063\194\000\001\150\068\193\036\246\194\107\185\017\007\115\082\224\104\157\224\121\206\254\221\251\206\207\049\063\194\001\002\044\068\193\036\246\194\072\169\059\182\090\056\104\073\105\050\091\129\142\180\112\169\207\049\063\194\003\004\216\067\193\036\246\194\251\159\052\248\143\110\090\195\220\003\250\251\237\143\061\018\207\049\063\194\007\008\048\067\193\036\246\194\221\091\153\121\189\226\030\047\113\052\022\092\053\224\102\083\139\051\080\067\007\008\048\067\193\036\246\194\078\218\053\088\213\040\003\201\241\030\058\218\033\175\089\062\139\051\080\067\001\002\044\068\193\036\246\194\067\060\234\010\170\123\022\011\179\033\154\117\080\170\130\118\197\025\232\067\003\004\216\067\193\036\246\194\176\044\229\014\239\018\215\065\071\161\181\004\018\218\095\027\139\051\080\067\003\004\216\067\193\036\246\194\251\214\107\034\169\119\105\029\131\152\128\173\088\133\065\117\139\051\080\067\000\001\150\068\193\036\246\194\032\234\100\238\006\007\107\176\198\025\032\162\136\056\147\009\139\051\080\067\001\002\108\068\193\036\246\194\215\054\210\122\040\037\007\146\091\041\221\179\137\235\230\117\197\025\232\067\001\002\044\068\193\036\246\194\182\081\134\099\105\016\210\219\108\181\048\115\121\039\196\252\057\230\151\195\001\002\108\068\193\036\246\194\087\188\125\132\133\233\049\223\175\027\216\250\044\180\069\000\057\230\151\195\003\004\216\067\193\036\246\194\051\113\172\202\106\071\200\176\084\019\138\242\059\124\175\173\057\230\151\195\007\008\048\067\193\036\246\194\085\216\131\034\024\130\195\150\244\253\220\248\134\003\198\129\057\230\151\195\001\002\044\068\193\036\246\194\042\155\237\246\149\021\212\040\243\227\153\026\106\163\151\192\092\093\032\067\139\236\130\193\251\029\160\193\065\221\020\173\112\059\167\170\049\072\116\193\039\035\171\025\007\167\088\194\190\033\050\067\187\237\130\193\013\019\029\173\100\229\246\208\140\064\249\203\150\185\179\088\224\020\155\195\190\033\050\067\187\237\130\193\108\132\127\038\063\204\237\199\035\108\044\072\083\047\009\054\007\167\088\194\130\188\155\194\187\237\130\193\121\139\219\152\062\054\207\042\208\084\187\040\101\068\042\042\224\020\155\195\130\188\155\194\187\237\130\193\144\145\100\148\076\142\113\165\074\191\109\237\074\064\088\075\189\162\249\067\158\243\154\068\022\231\131\065\146\201\184\007\118\044\094\124\140\089\126\118\177\023\121\029\122\069\115\067\158\243\186\068\022\231\131\065\101\129\255\193\249\015\201\010\230\049\133\190\192\192\244\232\122\069\115\067\158\243\154\068\022\231\131\065\012\250\104\112\169\030\042\092\034\223\165\071\033\141\128\246\251\015\254\066\006\009\166\068\038\252\081\066",
	["The Steamvault"] = "\122\056\058\228\088\110\027\250\131\138\238\093\187\198\138\087\017\145\128\195\238\137\113\194\169\203\058\195\199\240\178\039\105\220\195\053\166\061\032\151\238\230\212\092\255\017\145\191\194\206\225\067\169\203\058\195\094\035\155\220\181\044\161\082\106\198\051\202\127\007\069\165\255\017\145\191\097\231\048\068\169\203\058\195\031\033\089\221\203\157\092\085\177\029\199\152\200\212\134\176\219\221\126\067\194\206\225\067\169\203\058\195\155\066\226\176\003\228\089\096\005\114\127\254\228\089\168\235\255\017\145\191\132\157\067\067\169\203\058\195\054\234\014\074\150\040\038\029\251\251\116\119\017\185\099\241\219\221\126\067\097\231\048\068\169\203\058\195\080\236\122\114\133\020\252\143\045\021\210\056\066\224\163\250\017\145\128\195\097\231\048\068\169\203\058\195\215\183\017\130\068\073\081\062\036\115\157\050\021\113\052\039\017\145\128\195\132\157\067\067\169\203\058\195\068\075\174\002\217\051\070\070\207\169\028\158\168\207\247\192\255\017\145\191\238\137\113\194\169\203\058\195\063\062\135\092\057\059\063\224\034\017\201\164\202\072\255\236\017\145\128\195\194\206\225\067\169\203\058\195\080\076\089\199\231\175\254\057\056\117\037\151\110\148\036\214\078\153\184\067\053\011\004\067\114\086\007\195\031\099\172\243\102\109\128\217\005\038\044\056\225\117\226\031\078\153\184\067\154\005\194\067\114\086\007\195\036\176\127\001\120\193\020\219\171\194\129\217\119\036\253\217\167\076\028\068\053\011\004\067\114\086\007\195\034\237\015\108\099\224\128\035\245\253\112\212\186\183\115\183\182\137\196\067\028\231\019\068\114\086\007\195\194\171\127\052\020\226\164\045\231\009\144\195\222\134\016\134\167\076\028\068\154\005\194\067\114\086\007\195\040\154\180\107\049\230\188\113\161\158\090\077\242\043\245\202\004\039\127\067\102\247\094\068\014\025\044\194\146\113\067\238\253\129\203\015\158\237\004\112\234\223\058\155\004\039\127\067\179\123\143\068\014\025\044\194\024\236\229\033\078\038\121\161\001\099\134\164\065\061\091\107\024\251\088\191\102\247\094\068\014\025\044\194\115\022\219\082\237\117\060\055\145\029\048\145\085\088\119\175\024\251\088\191\179\123\143\068\014\025\044\194\184\240\160\036\248\073\048\124\072\164\154\034\226\017\124\224\067\234\139\067\152\159\220\067\235\196\125\193",
	["The Stockade"] = "\096\209\215\217\051\130\072\243\095\097\058\112\131\090\058\179\074\015\123\195\229\110\238\194\070\183\142\194\135\147\107\142\064\089\049\104\044\245\103\185\245\220\200\111\179\008\165\195\089\076\209\194\070\183\142\194\181\047\253\069\184\178\074\069\021\091\026\057\039\242\145\161\137\053\139\195\149\255\044\195\070\183\142\194\062\178\229\130\011\190\019\161\048\057\130\036\009\157\049\091\129\045\118\195\049\021\110\066\070\183\142\194\165\043\127\086\219\145\084\089\063\149\191\249\149\125\104\050\022\044\159\195\228\145\234\066\070\183\142\194\119\055\047\049\007\041\189\160\072\218\010\187\207\106\067\017\177\023\163\195\054\200\142\066\070\183\142\194\105\063\131\007\011\059\026\240\085\085\122\090\146\080\209\177\005\003\112\195\057\224\198\066\069\183\142\194\097\150\070\079\098\018\090\039\146\104\199\107\146\082\071\228\175\093\169\195\031\153\017\195\069\183\142\194\095\140\087\186\010\229\134\085\038\056\089\235\081\243\128\154\104\164\117\195\226\215\048\067\143\222\140\194\020\007\128\203\213\024\197\120\011\130\231\242\074\151\128\187\199\211\170\195\013\179\122\195\143\222\140\194\099\003\092\145\080\020\096\199\078\211\008\107\115\010\255\173\071\148\149\195\094\040\061\195\058\137\139\194\233\147\194\168\071\248\098\190\228\081\139\011\193\020\185\112\110\176\134\195\002\151\043\066\058\137\139\194\235\042\151\016\056\090\214\148\109\009\217\032\066\003\121\140\203\201\141\195\076\104\136\195\155\012\139\194\180\013\111\133\038\069\165\102\101\015\076\047\140\206\041\208\141\226\181\195\057\210\151\195\155\012\139\194\055\098\131\028\171\009\236\153\246\157\053\058\182\216\034\248\231\074\149\195\061\194\085\067\155\012\139\194\109\205\013\064\054\142\096\143\004\136\227\163\019\036\130\182\012\186\080\195\218\235\106\067\155\012\139\194\002\172\055\106\170\104\048\078\168\180\078\143\212\080\207\052\122\076\197\195\177\200\085\195\155\012\139\194\005\229\241\034\114\055\214\026\131\115\003\191\073\096\040\109\113\144\059\195\085\186\026\067\155\012\139\194\058\061\130\183\189\233\047\164\012\136\103\181\078\020\161\118\222\236\145\195\035\247\055\194\247\122\110\194\116\133\188\098\129\002\152\101\070\040\211\145\075\027\228\133\025\160\058\195\111\079\029\065\226\195\090\194\061\165\142\116\205\122\176\086\252\068\094\201\092\141\081\113\128\013\103\195\049\061\140\194\225\195\090\194\173\012\103\204\028\255\244\094\100\045\157\179\084\143\056\223\128\013\103\195\111\079\029\065\225\195\090\194\132\171\091\220\067\068\037\119\003\110\151\234\150\014\144\035\025\160\058\195\049\061\140\194\224\195\090\194\019\073\250\219\023\117\075\131\018\116\106\099\127\039\215\009\195\153\063\195\084\254\096\193\202\103\084\194\058\211\125\188\016\214\110\125\018\141\213\114\192\135\018\243\168\088\174\195\134\161\150\193\182\085\077\194\038\074\023\034\254\165\164\205\162\045\215\097\204\160\211\180\225\011\240\194\178\105\139\194\105\012\051\194",
	["The Temple of Atal'Hakkar"] = "\181\144\105\101\185\059\229\139\188\065\166\225\186\186\059\028\126\227\131\068\190\158\167\195\235\193\189\195\147\232\045\114\077\112\221\018\113\036\232\077\091\173\131\152\252\198\071\068\190\158\167\195\235\193\189\195\059\228\036\213\182\031\051\076\124\104\153\092\090\163\201\076\252\198\071\068\251\122\158\194\235\193\189\195\117\241\199\232\232\237\156\223\085\155\107\031\002\023\178\064\184\175\041\068\107\125\091\195\007\046\173\195\253\159\133\169\234\082\223\245\014\209\178\014\002\222\246\100\059\235\010\068\208\132\136\195\223\007\173\195\014\045\025\105\090\034\234\180\198\005\046\204\040\044\086\166\211\049\027\068\095\040\079\195\141\005\173\195\110\036\068\217\127\101\233\182\063\246\054\105\120\081\235\017\103\146\014\068\057\096\166\195\043\254\172\195\194\191\197\177\019\101\195\080\058\116\202\226\128\188\215\010\233\237\021\068\162\124\169\195\059\065\169\195\242\102\078\011\050\002\057\012\067\205\255\162\255\101\117\040\251\213\014\068\153\177\163\195\047\199\161\195\136\203\075\072\011\212\067\207\095\082\113\190\230\243\091\251\075\227\059\068\093\127\187\195\249\080\149\195\003\052\155\216\250\055\054\250\070\099\086\148\061\221\090\129\186\216\040\068\183\118\152\195\014\247\148\195\152\245\055\207\156\152\140\061\071\184\218\087\071\203\226\162\095\037\051\068\048\150\149\195\224\234\148\195\068\125\037\003\193\156\226\163\148\229\209\030\130\005\052\006\183\209\079\068\070\135\202\195\210\232\148\195\094\178\149\231\177\038\158\153\035\148\219\052\145\003\212\183\059\203\059\068\028\158\205\194\204\228\148\195\139\157\040\153\084\066\104\232\196\133\086\227\133\017\204\222\218\215\135\068\088\155\192\195\232\224\148\195\212\160\236\042\212\186\179\200\100\251\088\010\211\087\049\227\114\182\064\068\111\149\037\195\191\222\148\195\051\206\057\135\192\036\183\216\008\105\032\188\099\030\244\255\055\008\063\068\115\130\057\195\191\222\148\195\085\194\001\165\034\028\088\161\158\083\053\047\127\001\104\206\137\076\050\068\247\248\109\194\150\222\148\195\116\031\097\032\038\143\116\197\172\245\151\249\127\139\010\210\099\068\127\068\194\057\212\194\171\213\148\195\106\131\198\130\169\066\166\112\083\232\251\020\217\045\016\009\244\033\136\068\115\130\147\195\043\213\148\195\037\158\087\217\059\109\170\010\127\159\169\180\028\125\066\251\189\123\135\068\245\158\105\195\043\213\148\195\099\064\191\162\072\096\014\089\213\236\204\062\117\221\032\001\043\175\131\068\033\196\126\195\040\213\148\195\039\143\091\097\147\047\070\239\210\189\112\003\198\052\194\010\240\151\072\068\016\132\155\195\186\212\148\195\035\227\146\228\120\186\084\241\151\192\141\209\082\095\042\018\023\186\075\068\146\013\168\195\184\212\148\195\092\118\206\167\093\131\115\176\078\016\255\025\137\182\144\039\108\177\106\068\246\242\202\195\161\212\148\195\099\137\023\253\016\184\022\086\137\000\117\226\062\113\239\138\108\014\110\068\087\193\179\195\131\212\148\195\078\003\191\135\229\170\167\033\094\087\200\008\000\046\111\217\040\181\115\068\162\146\176\195\129\212\148\195\230\192\052\061\244\227\028\235\142\240\163\185\098\144\070\024\017\006\127\068\031\075\163\194\128\212\148\195\140\062\042\181\191\176\203\059\211\007\168\141\096\069\195\241\003\253\104\068\130\041\010\194\127\212\148\195\112\082\005\002\048\116\152\187\095\064\179\070\227\143\000\161\051\200\141\068\089\248\014\195\127\212\148\195\008\235\115\246\003\089\221\170\026\135\001\006\010\164\224\140\019\217\127\068\010\067\197\194\127\212\148\195\246\102\101\184\126\036\124\067\133\213\191\151\164\185\218\184\067\105\136\068\054\151\060\195\127\212\148\195\150\180\191\251\195\013\203\082\192\188\231\192\007\121\215\243\215\197\078\068\064\250\016\194\126\212\148\195\077\255\248\233\063\151\192\138\201\191\064\204\156\070\118\144\214\216\051\068\253\068\066\195\125\212\148\195\237\161\250\077\200\224\179\169\080\115\184\227\225\189\090\169\147\114\128\068\112\085\187\195\125\212\148\195\177\075\219\221\189\063\189\152\178\052\102\089\067\050\003\019\030\017\094\068\166\210\142\194\191\197\148\195\099\114\152\118\214\213\048\182\100\067\217\091\154\237\201\212\172\202\048\068\168\145\164\195\221\194\148\195\144\059\132\080\015\057\158\075\253\025\126\221\104\236\134\162\123\132\139\068\079\082\166\195\186\172\148\195\035\191\241\108\192\134\242\134\073\242\021\074\025\073\070\227\169\054\051\068\042\233\232\194\101\170\148\195\205\115\152\073\072\132\079\108\034\046\232\032\019\090\123\093\061\017\086\068\182\006\083\194\153\160\148\195\064\122\230\244\156\104\240\043\206\002\107\183\177\133\142\009\186\252\136\068\157\025\189\194\077\160\148\195\210\184\097\180\088\032\160\177\221\016\239\179\144\026\106\174\237\024\020\068\235\131\169\195\010\022\143\195\043\236\225\145\162\234\222\072\045\072\139\166\066\148\124\212\136\042\245\067\020\126\083\195\192\178\132\195\167\240\049\037\195\230\204\102\123\176\227\172\078\142\095\000\164\074\060\068\114\111\182\195\056\053\132\195\145\228\076\113\120\099\167\207\203\081\063\190\075\153\042\214\150\209\061\068\170\132\159\195\051\231\131\195\049\245\067\022\055\124\215\205\098\255\014\186\036\063\208\201\254\171\033\068\069\058\020\195\226\229\131\195\004\174\031\152\050\252\230\092\016\221\178\025\058\191\157\088\025\105\052\068\135\107\066\195\154\229\131\195\208\163\160\088\193\115\103\134\208\154\082\102\027\071\098\208\216\104\045\068\172\178\018\195\154\229\131\195\064\162\026\065\108\160\226\123\009\201\035\080\148\248\252\174\006\224\050\068\175\077\143\195\008\227\131\195\039\132\097\037\251\138\244\060\211\224\092\099\106\019\204\127\083\026\028\068\161\046\143\195\235\226\131\195\074\075\226\159\012\088\146\197\113\028\187\031\218\210\246\163\192\031\024\068\192\199\177\194\124\169\130\195\058\133\030\075\213\024\012\084\164\081\132\134\160\225\161\076\129\170\045\068\224\088\179\195\190\239\128\195\111\190\252\178\131\168\116\137\043\217\092\153\069\131\245\233\146\122\143\068\124\160\164\195\154\217\128\195\245\196\053\018\010\157\034\096\032\232\041\180\239\150\001\197\231\058\139\068\129\017\135\195\154\217\128\195\035\207\033\111\084\052\093\119\211\212\154\056\049\078\212\037\121\064\043\068\147\065\242\194\070\215\128\195\025\035\106\040\232\157\000\053\045\027\010\146\223\038\052\194\172\131\138\068\046\151\129\194\042\205\128\195\155\183\230\033\179\209\146\058\056\166\243\146\206\010\142\003\204\096\134\068\238\212\145\194\042\205\128\195\121\005\178\100\016\240\046\042\047\014\234\206\058\134\179\199\229\089\015\068\252\001\242\194\172\254\120\195\076\068\107\053\027\231\020\086\026\123\010\000\025\034\233\132\202\189\017\068\183\069\019\195\083\010\106\195\018\039\069\227\225\133\246\088\131\240\236\014\254\224\116\249\176\237\030\068\073\241\004\195\038\022\091\195\202\093\140\082\204\240\082\111\043\006\063\162\047\011\180\086\210\019\040\068\063\238\169\195\236\053\090\195\099\103\035\049\123\139\029\016\188\001\242\153\013\070\139\245\107\122\048\068\144\129\164\195\224\046\090\195\102\105\079\062\181\129\003\170\088\071\123\042\224\076\254\039\015\101\140\068\112\117\180\195\162\009\090\195\133\143\074\081\027\003\144\141\192\122\102\182\220\053\015\243\038\175\042\068\037\020\106\194\249\004\090\195\016\154\196\022\224\059\221\252\192\041\150\163\136\233\168\002\122\147\139\068\238\208\166\195\150\002\090\195\099\058\111\027\178\109\212\153\107\234\090\170\087\146\182\136\252\051\051\068\001\000\232\194\236\253\089\195\198\059\082\115\246\093\086\226\092\121\100\067\119\019\244\075\218\058\144\068\249\231\197\194\198\240\089\195\067\107\212\148\233\191\019\123\187\207\012\240\135\112\204\090\093\010\137\068\062\228\191\194\194\233\089\195\078\136\217\124\037\175\019\054\100\075\173\112\054\129\073\227\119\105\014\068\033\237\233\194\150\130\073\195\031\054\229\063\064\142\107\104\247\237\153\092\132\099\011\050\129\114\061\068\059\101\212\194\240\113\071\195\158\015\074\061\052\199\186\202\070\217\197\184\160\191\127\080\129\114\061\068\078\025\181\195\240\113\071\195\127\080\174\032\129\062\199\223\104\074\166\038\095\008\025\146\129\114\125\068\078\025\181\195\240\113\071\195\124\027\023\244\216\107\246\114\022\036\152\144\191\102\110\133\129\114\125\068\059\101\212\194\240\113\071\195\029\132\020\144\079\089\054\217\223\202\108\004\165\214\032\228\084\153\057\068\015\150\144\194\029\065\060\195\016\142\210\068\254\190\210\074\119\163\157\074\076\216\163\008\132\149\010\068\018\137\078\195\210\071\055\195\116\215\154\005\036\253\048\138\179\133\197\128\076\122\249\001\084\042\026\068\143\231\088\195\062\000\055\195\243\242\067\122\255\094\018\094\211\130\233\213\067\231\166\118\067\033\153\068\214\121\147\194\213\135\054\195\146\017\230\209\124\146\070\008\130\171\207\221\130\098\221\112\024\246\075\068\080\012\034\196\243\131\054\195\091\040\204\231\090\001\017\244\195\123\032\219\164\121\070\109\189\144\080\068\229\112\150\066\233\131\054\195\076\040\045\060\060\055\094\151\160\008\227\083\032\101\003\198\026\182\116\068\139\182\242\195\155\225\053\195\104\132\191\038\001\117\144\011\156\119\236\186\178\149\212\017\095\191\136\068\252\051\105\195\220\215\053\195\152\064\109\244\247\085\041\012\186\155\194\082\064\162\188\079\168\015\057\068\102\190\242\195\165\215\053\195\070\051\220\202\221\034\113\145\064\019\139\194\181\248\137\105\101\171\116\068\110\139\143\194\251\210\053\195\014\249\041\021\015\082\224\128\005\096\076\119\005\071\205\121\210\130\131\068\002\070\132\066\089\210\053\195\089\197\242\012\041\158\087\058\100\150\155\170\011\191\167\210\213\000\051\068\128\020\024\196\085\210\053\195\113\014\251\000\059\104\244\112\057\143\091\227\185\164\023\086\127\135\131\068\128\020\024\196\084\210\053\195\201\081\216\209\079\130\171\009\045\171\065\073\168\141\050\046\078\120\156\068\052\103\152\195\084\210\053\195\059\078\020\231\078\085\222\079\150\041\028\133\016\210\114\163\134\073\060\068\173\113\181\195\076\138\050\195\251\133\163\172\170\202\132\183\102\167\007\230\008\203\242\012\203\188\045\068\184\094\179\195\076\138\050\195\124\154\185\057\025\121\055\132\020\195\159\185\158\128\218\015\085\118\143\068\188\110\164\195\005\094\050\195\184\142\096\237\099\058\159\004\034\087\052\074\084\203\058\242\229\060\139\068\008\076\135\195\004\094\050\195\087\196\164\029\081\027\100\013\138\200\207\077\100\022\044\202\129\073\043\068\008\063\242\194\090\089\050\195\022\235\220\144\226\202\216\099\222\096\007\123\177\115\126\027\250\104\045\068\125\170\019\195\090\089\050\195\254\103\014\213\148\131\246\250\167\134\059\169\124\196\145\067\220\137\138\068\251\210\128\194\040\069\050\195\028\125\218\029\238\236\059\155\000\234\034\255\255\164\048\144\108\110\134\068\062\048\146\194\031\069\050\195\063\059\113\172\063\178\105\233\202\161\126\238\021\108\132\189\102\028\040\068\037\044\135\195\111\190\012\195\184\183\238\146\022\250\067\183\049\022\177\042\159\015\231\087\072\054\133\068\038\221\192\195\039\146\012\195\188\151\200\079\244\111\035\121\212\224\199\132\156\156\146\072\008\060\057\068\216\124\244\193\133\141\012\195\087\064\180\015\183\026\194\186\142\155\038\207\194\064\091\163\021\166\143\068\162\185\036\195\075\121\012\195\017\091\050\173\142\202\250\005\206\159\212\147\152\240\119\233\189\042\045\068\099\021\153\195\004\008\011\195\194\174\217\035\069\064\071\105\085\085\062\187\009\218\113\173\027\087\032\068\022\236\172\195\004\008\011\195\191\214\184\142\092\236\021\207\254\249\187\123\059\107\083\121\088\112\049\068\208\157\137\195\002\008\011\195\147\227\080\111\218\013\229\030\166\074\105\050\163\127\009\230\111\035\140\068\119\214\201\195\189\219\010\195\183\134\016\153\120\216\060\066\068\003\088\147\095\110\241\124\048\108\131\068\166\028\175\195\186\219\010\195\158\189\044\008\236\193\207\236\132\023\107\118\128\157\013\089\129\045\137\068\032\109\176\195\186\219\010\195\185\231\184\127\255\009\242\177\100\142\232\014\040\140\112\114\246\150\038\068\017\052\104\194\021\215\010\195\175\216\083\057\015\200\006\092\040\211\245\178\006\200\172\251\136\055\051\068\185\093\157\194\021\215\010\195\146\066\019\012\232\119\179\198\147\039\187\090\161\008\021\101\180\245\059\068\118\039\183\194\018\215\010\195\082\098\025\165\233\117\041\051\119\019\136\182\152\070\057\115\241\227\145\068\227\147\252\194\224\194\010\195\112\134\088\190\222\095\219\251\169\195\246\082\052\241\035\178\253\041\140\068\061\111\220\194\223\194\010\195\105\204\215\056\251\074\163\216\252\081\171\016\083\139\089\091\215\225\134\068\032\026\017\195\221\194\010\195\076\023\193\029\095\173\098\212\214\037\056\170\167\016\005\049\221\060\059\068\228\223\186\195\118\087\004\195\162\188\254\048\025\009\115\058\120\010\185\095\238\187\177\103\159\199\113\068\039\101\125\194\211\084\004\195\041\209\116\141\095\114\234\250\253\129\005\132\220\137\026\043\212\023\095\068\064\252\178\195\133\193\002\195\127\037\015\051\144\253\140\046\128\173\169\230\098\031\104\082\245\072\110\068\113\047\027\194\223\190\002\195\239\137\097\196\249\015\239\227\056\237\153\223\030\044\241\092\175\072\127\068\116\014\187\195\050\126\216\194\252\035\201\028\181\140\192\053\181\123\022\249\122\224\110\038\030\211\049\068\123\010\147\195\135\091\216\194\216\110\105\135\021\225\240\200\027\128\163\035\152\209\110\172\168\193\124\068\139\097\133\194\168\043\216\194\148\235\213\158\084\063\036\066\227\044\166\075\042\099\150\092\199\081\059\068\182\104\195\194\068\034\216\194\210\122\226\029\000\093\016\092\106\166\246\229\126\143\245\176\234\044\136\068\155\086\065\195\135\229\215\194\141\002\105\119\188\104\142\015\218\224\005\092\002\114\240\177\186\034\128\068\194\203\203\194\135\229\215\194\245\226\153\091\027\057\063\019\055\057\235\255\054\036\198\081\197\050\078\068\188\011\203\195\128\229\215\194\174\047\151\061\245\064\252\205\150\074\079\084\058\070\097\207\159\030\136\068\170\025\149\195\127\229\215\194\043\000\251\100\025\224\059\151\015\144\129\174\048\059\149\174\078\059\079\068\096\050\006\194\127\229\215\194\225\184\171\078\193\124\099\086\208\085\075\042\245\080\016\239\078\107\104\068\074\001\202\195\127\229\215\194\100\136\197\035\181\107\108\166\046\177\141\191\198\225\102\040\177\038\106\068\124\249\007\194\126\229\215\194\086\061\050\190\107\012\107\002\013\214\199\020\168\103\224\042\139\183\051\068\248\132\058\195\126\229\215\194",
	["The Underbog"] = "\103\252\217\066\216\221\144\165\049\174\168\146\251\057\221\251\006\222\083\196\183\015\012\067\178\097\171\194\022\082\039\122\094\137\168\155\235\038\164\068\140\115\170\113\055\240\158\194\143\224\231\194\178\097\171\194\061\003\247\251\086\127\132\241\037\039\171\252\195\108\209\240\055\240\158\194\183\015\012\067\178\097\171\194\054\111\232\211\112\203\148\180\195\134\186\174\097\023\250\255\055\240\158\194\035\248\185\195\178\097\171\194\203\205\089\217\020\194\051\157\093\102\228\022\070\148\094\084\013\188\167\195\237\003\035\068\178\097\171\194\207\245\099\172\010\254\209\111\081\131\209\145\122\167\223\032\013\188\167\195\237\003\099\068\178\097\171\194\154\217\028\245\227\144\162\116\214\124\228\233\013\104\005\040\013\188\167\195\219\007\198\067\178\097\171\194\219\130\091\160\225\073\090\238\026\023\125\091\205\171\188\015\055\240\158\194\219\007\198\067\178\097\171\194\110\111\093\051\185\136\091\124\064\043\210\129\230\005\222\201\055\240\158\194\237\003\099\068\178\097\171\194\149\113\191\151\070\002\066\072\123\063\164\012\053\130\072\234\227\135\048\067\183\015\012\067\178\097\171\194\041\078\068\246\015\236\050\211\219\202\209\204\110\169\095\107\055\240\158\194\237\003\035\068\178\097\171\194\107\052\014\093\151\217\137\254\136\151\014\081\141\188\252\191\227\135\048\067\143\224\231\194\178\097\171\194\227\246\016\239\173\175\073\185\023\154\191\190\010\087\064\015\227\135\048\067\035\248\185\195\178\097\171\194\101\205\228\217\252\070\107\049\210\144\073\251\053\008\145\058\227\135\048\067\219\007\198\067\178\097\171\194\071\235\167\072\018\238\217\218\176\083\078\208\205\049\107\217\013\188\167\195\183\015\012\067\178\097\171\194\120\200\025\168\151\207\047\041\068\049\237\233\075\103\044\224\013\188\167\195\035\248\185\195\178\097\171\194\135\142\155\211\244\046\076\159\001\141\012\022\003\046\045\246\006\222\083\196\246\129\145\068\178\097\171\194\209\152\128\104\054\253\153\138\163\098\110\108\121\116\192\101\006\222\019\196\035\248\185\195\178\097\171\194\044\001\224\177\112\126\061\068\251\100\194\022\038\082\108\067\006\222\083\196\237\003\099\068\178\097\171\194\128\199\078\064\075\204\013\174\004\014\228\205\225\204\251\056\006\222\083\196\219\007\198\067\178\097\171\194\146\070\140\011\149\104\061\160\079\141\220\097\146\186\123\180\006\222\083\196\237\003\035\068\178\097\171\194\228\198\070\109\116\174\244\082\168\209\215\216\146\158\073\114\013\188\167\195\143\224\231\194\178\097\171\194\180\116\072\047\197\043\101\025\237\203\231\148\053\195\238\018\006\222\019\196\143\224\231\194\178\097\171\194\133\072\001\157\046\020\108\166\181\100\117\113\140\208\019\146\006\222\019\196\219\007\198\067\178\097\171\194\242\179\254\115\156\224\212\026\202\072\010\134\175\088\072\006\006\222\019\196\246\129\145\068\178\097\171\194\094\204\080\214\077\075\000\065\249\148\127\148\200\222\045\150\006\222\019\196\183\015\012\067\178\097\171\194\127\017\239\108\133\093\046\084\229\055\187\073\106\190\039\056\006\222\019\196\237\003\099\068\178\097\171\194\188\038\002\038\222\132\220\058\182\008\184\248\193\148\125\126\006\222\019\196\237\003\035\068\178\097\171\194\141\136\056\003\144\017\008\081\104\212\133\142\150\179\157\044\227\135\048\067\237\003\035\068\178\097\171\194",
	["Uldaman"] = "\207\135\219\239\176\135\047\033\072\252\030\181\214\017\134\015\127\239\029\068\003\105\155\195\147\106\225\194\149\047\203\105\135\000\043\236\211\160\146\243\103\027\252\172\072\173\105\195\072\209\229\195\021\010\220\194\146\183\106\170\052\026\009\130\147\189\031\064\090\131\172\207\123\228\156\067\112\018\039\196\068\250\217\194\082\005\164\008\082\235\055\149\243\187\036\074\141\228\035\085\207\003\105\067\234\183\022\196\143\235\217\194\187\110\027\027\122\178\077\143\110\154\061\067\008\046\165\251\009\162\021\195\187\116\008\196\049\062\217\194\055\105\010\243\009\159\158\163\157\154\016\248\195\177\113\100\082\070\085\067\109\084\248\195\062\058\210\194\228\148\197\148\211\015\141\125\078\142\160\231\119\201\197\097\157\024\176\195\064\021\032\196\162\016\209\194\243\077\115\170\062\206\139\099\176\059\000\218\115\103\255\060\050\211\141\195\001\001\027\196\250\237\208\194\210\026\031\204\172\160\023\167\248\201\175\089\198\229\228\129\068\071\183\067\166\015\169\194\254\007\208\194\156\001\135\005\046\067\227\095\086\240\142\122\086\007\154\171\085\103\150\066\251\079\067\196\014\203\207\194\050\031\068\230\240\147\160\129\027\255\199\112\195\006\225\151\254\210\019\067\066\168\043\196\235\119\205\194\066\123\216\251\251\215\095\104\206\073\112\144\052\250\162\239\057\196\187\067\013\099\021\196\173\194\204\194\149\038\174\218\160\203\134\160\108\168\183\035\204\188\218\200\251\111\121\066\157\217\246\195\103\224\203\194\219\098\174\188\163\238\138\053\038\099\100\184\133\063\054\183\150\217\109\067\215\143\044\196\240\075\203\194\242\045\027\235\016\012\157\096\035\169\006\237\058\062\090\060\075\185\140\067\070\016\231\195\144\123\202\194\072\058\189\192\176\082\243\091\239\121\013\116\099\034\019\099\159\136\067\066\042\204\013\196\091\230\201\194\073\210\029\241\225\235\232\211\030\068\239\166\164\102\035\161\148\024\083\192\222\185\017\196\119\151\200\194\075\008\008\074\120\007\233\047\048\244\053\109\219\086\090\133\140\203\201\067\043\180\148\195\239\074\200\194\001\156\058\200\201\028\186\102\224\206\050\112\247\154\064\089\010\047\151\067\127\238\075\195\245\004\200\194\141\038\028\142\182\100\092\171\043\014\201\219\038\139\242\146\250\076\013\067\191\031\021\196\147\247\198\194\118\091\139\064\000\120\043\158\111\213\233\065\088\096\102\149\087\164\165\067\239\046\178\195\195\245\196\194\190\204\131\006\137\126\019\222\137\085\246\205\190\206\012\007\122\167\253\067\020\121\072\195\118\095\195\194\012\194\181\220\119\217\055\068\255\127\126\225\034\050\000\097\152\087\069\067\206\203\055\196\118\084\195\194\200\245\026\157\152\040\113\179\140\111\019\151\167\016\117\094\115\185\019\068\163\173\137\195\109\170\194\194\006\232\087\024\177\060\181\212\236\220\177\048\198\076\053\196\074\197\133\193\248\237\052\196\183\028\193\194\139\042\229\078\127\058\054\110\037\205\216\063\009\167\083\241\204\129\115\194\054\179\085\196\034\244\192\194\036\145\055\238\200\057\210\085\221\237\055\240\094\223\184\112\075\055\202\067\008\174\028\195\123\134\192\194\232\044\181\022\252\050\246\150\176\236\069\089\207\097\069\218\122\167\253\067\048\047\178\195\054\047\191\194\144\152\248\064\056\247\122\146\065\068\156\071\233\056\249\246\030\094\214\067\126\058\038\196\090\128\190\194\243\096\230\039\252\148\026\250\083\075\191\038\216\132\201\170\087\179\093\065\004\099\030\196\184\009\190\194\036\046\121\175\032\075\219\193\005\163\133\028\225\147\236\093\075\055\202\067\062\042\187\195\033\248\186\194\071\121\114\100\228\036\176\048\004\217\110\059\067\055\128\018\116\216\000\068\189\033\053\066\251\197\182\194\000\119\129\010\196\140\206\247\009\026\225\042\202\138\029\139\043\112\243\193\147\138\063\196\091\224\176\194\236\030\254\071\203\251\092\114\227\019\165\084\077\034\022\073\083\004\031\195\010\063\071\196\030\116\175\194\065\084\076\249\141\031\204\078\005\043\036\030\093\002\109\239\076\130\249\194\133\024\042\196\001\125\174\194\172\080\141\205\035\021\222\109\033\033\208\173\134\103\002\056\104\229\122\067\140\023\077\196\026\006\171\194\006\087\045\001\205\152\124\170\177\208\042\212\189\031\105\182\178\046\140\195\246\156\236\195\183\021\170\194\129\086\022\123\238\103\058\179\008\084\006\041\055\203\180\241\104\078\184\195\034\089\008\196\032\019\170\194\117\056\201\223\232\182\110\167\026\008\178\165\228\120\060\142\011\099\042\195\182\042\105\196\227\244\168\194\109\125\155\177\017\108\178\005\145\210\077\069\065\250\190\230\008\030\206\067\082\250\058\196\058\088\163\194\162\013\255\167\054\028\002\089\036\195\227\121\088\150\161\044\030\012\129\194\098\141\022\196\031\199\162\194\151\149\091\075\138\144\110\225\154\194\009\026\003\180\190\010\227\231\184\067\175\183\077\196\178\161\162\194\019\049\225\135\152\071\095\016\212\138\217\191\155\031\181\023\201\051\074\195\005\107\081\196\229\127\161\194\126\008\130\245\112\100\040\231\031\057\126\141\140\188\204\124\250\139\228\067\196\203\063\196\096\030\159\194\037\025\208\078\010\179\131\133\044\136\005\195\175\225\194\048\096\093\249\067\071\220\072\196\162\114\150\194\110\030\100\229\093\042\083\006\223\223\147\188\068\190\151\015\026\157\240\194\216\123\005\196\228\039\145\194\199\246\043\071\216\155\023\060\229\175\025\100\093\051\224\217\144\025\179\067\110\232\104\065\056\006\145\194\110\112\084\249\214\017\105\071\159\189\023\039\033\161\133\108\108\166\166\195\045\229\029\196\179\141\101\194\183\178\064\239\138\001\195\055\092\004\146\146\248\169\092\183\104\167\021\195\006\075\005\196\064\237\084\194\114\051\212\009\127\120\231\111\227\059\187\183\043\217\042\121\224\213\141\195\248\032\026\196\063\237\084\194",
	["Wailing Caverns"] = "\083\146\040\125\187\000\045\130\081\007\156\098\112\194\085\193\036\073\029\068\069\111\139\066\237\233\194\195\242\213\160\115\218\064\141\111\136\205\152\022\017\164\172\169\196\170\012\068\007\049\092\066\237\233\194\195\176\030\047\076\048\182\184\192\130\158\124\026\197\227\080\108\196\170\012\068\189\243\072\195\237\233\194\195\007\132\010\090\004\061\212\069\150\175\168\012\118\239\069\121\137\085\153\067\007\049\092\066\237\233\194\195\152\080\239\024\066\112\002\166\041\052\097\034\218\117\077\003\137\085\153\067\189\243\072\195\237\233\194\195\191\163\051\096\240\180\202\250\167\016\074\239\108\226\154\059\072\146\186\067\150\213\039\196\237\233\194\195\217\022\092\184\186\189\176\067\222\112\054\233\137\234\077\199\036\073\029\068\092\072\058\195\237\233\194\195\046\138\198\048\067\179\236\239\202\211\017\022\164\095\102\160\036\073\029\068\209\219\162\067\237\233\194\195\070\182\024\190\015\204\107\222\089\241\152\060\007\239\118\230\072\146\186\067\209\219\162\067\237\233\194\195\181\218\065\134\019\220\247\117\233\018\010\221\144\026\087\232\072\146\186\067\069\111\139\066\237\233\194\195\204\033\065\227\064\095\253\027\159\098\061\158\020\170\034\039\077\172\074\066\007\049\092\066\237\233\194\195\055\165\165\004\104\138\188\223\023\061\252\062\065\131\196\067\072\146\186\067\045\171\207\195\237\233\194\195\184\033\021\099\201\061\206\173\001\219\001\205\073\248\141\034\077\172\074\066\189\243\072\195\237\233\194\195\159\055\211\019\168\150\085\135\146\166\225\008\043\145\071\122\229\149\147\067\249\073\209\195\237\233\194\195\210\200\011\204\060\064\115\195\120\245\162\163\223\086\067\249\229\149\147\067\252\164\040\196\237\233\194\195\120\126\088\145\222\048\074\114\147\121\225\116\115\250\042\122\072\146\186\067\092\072\058\195\237\233\194\195\204\000\087\112\127\203\159\240\105\148\136\074\193\177\021\253\036\073\029\068\150\213\039\196\237\233\194\195\125\019\019\017\246\117\222\233\243\034\094\145\048\023\154\120\036\073\029\068\045\171\207\195\237\233\194\195\036\095\214\056\140\016\191\059\015\009\227\139\136\179\245\141\135\202\205\194\223\099\119\194\104\096\110\195\138\156\250\120\206\203\081\054\176\207\236\170\061\188\118\229\135\202\205\194\123\236\158\195\104\096\110\195\254\121\218\225\138\077\030\184\194\240\204\207\119\090\175\153\187\026\025\067\123\236\158\195\104\096\110\195\055\177\227\228\109\211\142\078\246\150\217\126\132\083\078\146\058\201\014\195\002\178\037\196\068\025\090\195\144\029\183\089\169\019\100\221\175\249\173\066\119\095\182\175\000\129\187\195\237\039\177\195\068\025\090\195\009\098\146\243\017\141\080\016\227\117\017\170\027\129\177\169\000\129\187\195\246\147\024\196\068\025\090\195\003\191\103\092\063\127\165\107\229\219\093\102\068\038\144\178\137\109\226\066\002\178\037\196\068\025\090\195\179\179\123\205\084\085\068\221\019\093\136\031\102\174\080\152\013\002\033\195\059\046\085\196\237\008\088\195\186\061\126\220\174\254\094\120\050\178\147\118\162\211\084\127\227\251\189\066\059\046\085\196\237\008\088\195\122\254\180\242\056\074\250\018\209\126\031\027\181\018\198\075\013\002\033\195\029\151\138\196\237\008\088\195\069\082\184\224\000\087\228\163\108\137\154\219\223\027\209\174\227\251\189\066\029\151\138\196\237\008\088\195\043\137\052\072\164\233\031\109\057\194\091\218\203\118\183\089\179\253\222\066\039\136\056\196\043\238\085\195\143\039\053\017\147\052\142\056\238\080\128\007\215\203\015\004\219\142\065\067\187\113\042\195\028\107\085\195\135\040\200\155\035\157\124\224\203\231\058\098\246\144\245\036\057\111\249\066\130\011\237\195\052\195\084\195\209\137\031\100\194\037\231\030\235\189\196\182\136\164\223\033\098\072\003\195\130\011\237\195\052\195\084\195\071\135\147\048\085\246\131\090\187\147\054\110\050\247\112\154\171\247\235\066\222\144\002\196\136\202\063\195\241\117\057\037\226\090\129\140\123\145\245\190\055\162\232\089\099\127\067\067\131\194\156\195\068\077\052\195\091\154\190\082\049\109\030\216\024\023\113\210\169\114\153\120\042\218\020\067\042\103\126\067\119\191\047\195\090\106\000\097\220\069\150\049\077\098\058\079\097\125\094\191\170\075\214\194\042\103\126\067\119\191\047\195\151\162\206\181\197\079\076\025\098\074\001\245\222\091\245\162\170\075\214\194\149\051\255\067\119\191\047\195\224\163\115\018\050\016\249\195\204\053\165\092\143\012\157\158\101\028\039\195\032\068\077\067\034\020\033\195\077\005\028\099\077\103\142\138\205\254\182\062\104\183\154\056\051\199\177\066\032\068\077\067\034\020\033\195\200\113\110\018\152\204\158\122\111\144\163\106\211\036\086\184\077\196\173\067\243\101\178\067\232\234\031\195\220\180\165\139\163\127\067\003\135\075\250\016\116\227\070\175\055\017\183\066\206\151\201\066\232\234\031\195\216\092\002\101\205\021\181\091\240\043\118\192\082\125\215\237\055\017\183\066\243\101\178\067\232\234\031\195\189\076\240\081\029\155\074\006\027\109\068\137\205\077\042\111\077\196\173\067\206\151\201\066\232\234\031\195\135\245\203\097\055\093\172\053\106\222\079\127\090\220\015\151\056\107\140\067\137\180\170\067\205\241\018\195\085\136\244\237\064\068\003\107\096\139\167\032\244\075\084\236\235\083\044\067\131\098\236\067\232\198\016\195\097\092\206\148\111\071\121\164\062\229\045\115\246\228\192\246\235\083\044\067\065\049\054\068\232\198\016\195\175\043\091\242\199\089\035\022\127\193\250\118\162\111\058\017\245\041\214\067\131\098\236\067\232\198\016\195\216\235\053\218\212\026\187\025\199\229\222\141\229\066\147\097\043\021\182\067\224\005\228\067\035\042\016\195\003\224\151\149\101\131\098\000\200\237\046\092\249\062\184\061\184\219\192\193\241\174\233\065\205\042\015\195\201\008\016\197\022\024\141\104\171\159\065\091\182\045\148\023\203\162\086\067\096\060\205\067\034\228\013\195\056\049\014\105\077\224\158\068\199\236\247\205\173\011\199\233\000\098\152\065\153\196\176\067\017\024\011\195\150\123\245\181\170\100\180\178\008\179\246\003\009\120\203\012\039\143\221\067\150\218\138\067\055\218\002\195\091\225\127\178\251\097\239\098\191\075\133\133\141\145\173\158\039\143\221\067\075\109\005\068\055\218\002\195",
	["Zul'Aman"] = "\002\176\006\217\248\054\242\127\142\123\057\156\017\085\117\087\255\255\231\069\255\255\247\197\000\000\000\000\219\220\218\033\238\051\049\048\222\188\178\002\138\186\135\126\255\255\231\069\000\000\000\198\000\000\000\000\015\216\091\060\197\194\090\222\135\045\034\216\242\150\027\239\255\255\239\069\255\255\247\197\000\000\000\000\085\044\223\175\202\003\027\136\171\214\153\243\128\147\215\148\255\255\239\069\000\000\000\198\000\000\000\000",
	["Zul'Farrak"] = "\068\081\024\165\160\024\170\084\153\101\014\181\051\097\176\040\255\255\231\069\255\255\223\197\000\000\000\000\223\068\162\211\077\136\230\094\175\058\017\230\120\096\036\014\255\255\231\069\255\255\231\197\000\000\000\000\155\113\015\136\062\001\136\002\214\155\099\143\058\047\061\182\255\255\239\069\255\255\223\197\000\000\000\000\082\011\042\022\245\250\107\150\252\149\249\235\155\180\133\001\255\255\239\069\255\255\231\197\000\000\000\000",
	["Zul'Gurub"] = "\223\048\207\070\194\201\097\009\145\034\158\217\079\136\214\244\255\255\007\070\255\255\083\198\000\000\000\000\024\087\116\015\117\252\250\081\209\009\164\071\159\019\085\241\255\255\007\070\255\255\087\198\000\000\000\000\084\244\247\070\143\105\201\001\167\129\037\249\124\053\058\051\255\255\007\070\255\255\091\198\000\000\000\000\002\250\036\134\121\014\228\208\072\078\084\118\227\150\154\178\255\255\011\070\255\255\083\198\000\000\000\000\002\034\230\072\030\221\089\151\154\224\204\123\148\110\075\040\255\255\011\070\255\255\087\198\000\000\000\000\030\211\125\049\084\177\072\206\153\254\007\025\149\069\023\098\255\255\011\070\255\255\091\198\000\000\000\000",
}
